// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The optional metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
/// <p>The following basic restrictions apply to tags:</p>
/// <ul>
/// <li> <p>Maximum number of tags per resource - 50.</p> </li>
/// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
/// <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li>
/// <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li>
/// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
/// <li> <p>Tag keys and values are case sensitive.</p> </li>
/// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &"*** Sensitive Data Redacted ***");
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Provides a summary of the predictor properties that are used in the <code>ListPredictors</code> operation. To get the complete set of properties, call the <code>DescribePredictor</code> operation, and provide the listed <code>PredictorArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictorSummary {
    /// <p>The ARN of the predictor.</p>
    pub predictor_arn: std::option::Option<std::string::String>,
    /// <p>The name of the predictor.</p>
    pub predictor_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>Whether AutoPredictor was used to create the predictor.</p>
    pub is_auto_predictor: std::option::Option<bool>,
    /// <p>A summary of the reference predictor used if the predictor was retrained or upgraded.</p>
    pub reference_predictor_summary: std::option::Option<crate::model::ReferencePredictorSummary>,
    /// <p>The status of the predictor. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// </ul> <note>
    /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a forecast.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the model training task was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PredictorSummary {
    /// <p>The ARN of the predictor.</p>
    pub fn predictor_arn(&self) -> std::option::Option<&str> {
        self.predictor_arn.as_deref()
    }
    /// <p>The name of the predictor.</p>
    pub fn predictor_name(&self) -> std::option::Option<&str> {
        self.predictor_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>Whether AutoPredictor was used to create the predictor.</p>
    pub fn is_auto_predictor(&self) -> std::option::Option<bool> {
        self.is_auto_predictor
    }
    /// <p>A summary of the reference predictor used if the predictor was retrained or upgraded.</p>
    pub fn reference_predictor_summary(
        &self,
    ) -> std::option::Option<&crate::model::ReferencePredictorSummary> {
        self.reference_predictor_summary.as_ref()
    }
    /// <p>The status of the predictor. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// </ul> <note>
    /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a forecast.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the model training task was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for PredictorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictorSummary");
        formatter.field("predictor_arn", &self.predictor_arn);
        formatter.field("predictor_name", &self.predictor_name);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("is_auto_predictor", &self.is_auto_predictor);
        formatter.field(
            "reference_predictor_summary",
            &self.reference_predictor_summary,
        );
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`PredictorSummary`](crate::model::PredictorSummary)
pub mod predictor_summary {
    /// A builder for [`PredictorSummary`](crate::model::PredictorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_arn: std::option::Option<std::string::String>,
        pub(crate) predictor_name: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) is_auto_predictor: std::option::Option<bool>,
        pub(crate) reference_predictor_summary:
            std::option::Option<crate::model::ReferencePredictorSummary>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the predictor.</p>
        pub fn predictor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the predictor.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_arn = input;
            self
        }
        /// <p>The name of the predictor.</p>
        pub fn predictor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_name = Some(input.into());
            self
        }
        /// <p>The name of the predictor.</p>
        pub fn set_predictor_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>Whether AutoPredictor was used to create the predictor.</p>
        pub fn is_auto_predictor(mut self, input: bool) -> Self {
            self.is_auto_predictor = Some(input);
            self
        }
        /// <p>Whether AutoPredictor was used to create the predictor.</p>
        pub fn set_is_auto_predictor(mut self, input: std::option::Option<bool>) -> Self {
            self.is_auto_predictor = input;
            self
        }
        /// <p>A summary of the reference predictor used if the predictor was retrained or upgraded.</p>
        pub fn reference_predictor_summary(
            mut self,
            input: crate::model::ReferencePredictorSummary,
        ) -> Self {
            self.reference_predictor_summary = Some(input);
            self
        }
        /// <p>A summary of the reference predictor used if the predictor was retrained or upgraded.</p>
        pub fn set_reference_predictor_summary(
            mut self,
            input: std::option::Option<crate::model::ReferencePredictorSummary>,
        ) -> Self {
            self.reference_predictor_summary = input;
            self
        }
        /// <p>The status of the predictor. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// </ul> <note>
        /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a forecast.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the predictor. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// </ul> <note>
        /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a forecast.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the model training task was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the model training task was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictorSummary`](crate::model::PredictorSummary)
        pub fn build(self) -> crate::model::PredictorSummary {
            crate::model::PredictorSummary {
                predictor_arn: self.predictor_arn,
                predictor_name: self.predictor_name,
                dataset_group_arn: self.dataset_group_arn,
                is_auto_predictor: self.is_auto_predictor,
                reference_predictor_summary: self.reference_predictor_summary,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl PredictorSummary {
    /// Creates a new builder-style object to manufacture [`PredictorSummary`](crate::model::PredictorSummary)
    pub fn builder() -> crate::model::predictor_summary::Builder {
        crate::model::predictor_summary::Builder::default()
    }
}

/// <p>Provides a summary of the reference predictor used when retraining or upgrading a predictor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReferencePredictorSummary {
    /// <p>The ARN of the reference predictor.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Whether the reference predictor is <code>Active</code> or <code>Deleted</code>.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl ReferencePredictorSummary {
    /// <p>The ARN of the reference predictor.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Whether the reference predictor is <code>Active</code> or <code>Deleted</code>.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ReferencePredictorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReferencePredictorSummary");
        formatter.field("arn", &self.arn);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ReferencePredictorSummary`](crate::model::ReferencePredictorSummary)
pub mod reference_predictor_summary {
    /// A builder for [`ReferencePredictorSummary`](crate::model::ReferencePredictorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The ARN of the reference predictor.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the reference predictor.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Whether the reference predictor is <code>Active</code> or <code>Deleted</code>.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Whether the reference predictor is <code>Active</code> or <code>Deleted</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ReferencePredictorSummary`](crate::model::ReferencePredictorSummary)
        pub fn build(self) -> crate::model::ReferencePredictorSummary {
            crate::model::ReferencePredictorSummary {
                arn: self.arn,
                state: self.state,
            }
        }
    }
}
impl ReferencePredictorSummary {
    /// Creates a new builder-style object to manufacture [`ReferencePredictorSummary`](crate::model::ReferencePredictorSummary)
    pub fn builder() -> crate::model::reference_predictor_summary::Builder {
        crate::model::reference_predictor_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum State {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for State {
    fn from(s: &str) -> Self {
        match s {
            "Active" => State::Active,
            "Deleted" => State::Deleted,
            other => State::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for State {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(State::from(s))
    }
}
impl State {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            State::Active => "Active",
            State::Deleted => "Deleted",
            State::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Deleted"]
    }
}
impl AsRef<str> for State {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a filter for choosing a subset of objects. Each filter consists of a condition and a match statement. The condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include or exclude the objects that match the statement, respectively. The match statement consists of a key and a value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the parameter to filter on.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value to match.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude matching objects, specify <code>IS_NOT</code>.</p>
    pub condition: std::option::Option<crate::model::FilterConditionString>,
}
impl Filter {
    /// <p>The name of the parameter to filter on.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value to match.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude matching objects, specify <code>IS_NOT</code>.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::FilterConditionString> {
        self.condition.as_ref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<crate::model::FilterConditionString>,
    }
    impl Builder {
        /// <p>The name of the parameter to filter on.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the parameter to filter on.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value to match.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value to match.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude matching objects, specify <code>IS_NOT</code>.</p>
        pub fn condition(mut self, input: crate::model::FilterConditionString) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude matching objects, specify <code>IS_NOT</code>.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::FilterConditionString>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                key: self.key,
                value: self.value,
                condition: self.condition,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterConditionString {
    #[allow(missing_docs)] // documentation missing in model
    Is,
    #[allow(missing_docs)] // documentation missing in model
    IsNot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterConditionString {
    fn from(s: &str) -> Self {
        match s {
            "IS" => FilterConditionString::Is,
            "IS_NOT" => FilterConditionString::IsNot,
            other => FilterConditionString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterConditionString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterConditionString::from(s))
    }
}
impl FilterConditionString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterConditionString::Is => "IS",
            FilterConditionString::IsNot => "IS_NOT",
            FilterConditionString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IS", "IS_NOT"]
    }
}
impl AsRef<str> for FilterConditionString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a summary of the predictor backtest export job properties used in the <code>ListPredictorBacktestExportJobs</code> operation. To get a complete set of properties, call the <code>DescribePredictorBacktestExportJob</code> operation, and provide the listed <code>PredictorBacktestExportJobArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictorBacktestExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
    pub predictor_backtest_export_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the predictor backtest export job.</p>
    pub predictor_backtest_export_job_name: std::option::Option<std::string::String>,
    /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
    pub destination: std::option::Option<crate::model::DataDestination>,
    /// <p>The status of the predictor backtest export job. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>Information about any errors that may have occurred during the backtest export.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the predictor backtest export job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PredictorBacktestExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
    pub fn predictor_backtest_export_job_arn(&self) -> std::option::Option<&str> {
        self.predictor_backtest_export_job_arn.as_deref()
    }
    /// <p>The name of the predictor backtest export job.</p>
    pub fn predictor_backtest_export_job_name(&self) -> std::option::Option<&str> {
        self.predictor_backtest_export_job_name.as_deref()
    }
    /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
    pub fn destination(&self) -> std::option::Option<&crate::model::DataDestination> {
        self.destination.as_ref()
    }
    /// <p>The status of the predictor backtest export job. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Information about any errors that may have occurred during the backtest export.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the predictor backtest export job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for PredictorBacktestExportJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictorBacktestExportJobSummary");
        formatter.field(
            "predictor_backtest_export_job_arn",
            &self.predictor_backtest_export_job_arn,
        );
        formatter.field(
            "predictor_backtest_export_job_name",
            &self.predictor_backtest_export_job_name,
        );
        formatter.field("destination", &self.destination);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`PredictorBacktestExportJobSummary`](crate::model::PredictorBacktestExportJobSummary)
pub mod predictor_backtest_export_job_summary {
    /// A builder for [`PredictorBacktestExportJobSummary`](crate::model::PredictorBacktestExportJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_backtest_export_job_arn: std::option::Option<std::string::String>,
        pub(crate) predictor_backtest_export_job_name: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::DataDestination>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
        pub fn predictor_backtest_export_job_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
        pub fn set_predictor_backtest_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_arn = input;
            self
        }
        /// <p>The name of the predictor backtest export job.</p>
        pub fn predictor_backtest_export_job_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_name = Some(input.into());
            self
        }
        /// <p>The name of the predictor backtest export job.</p>
        pub fn set_predictor_backtest_export_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_name = input;
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn destination(mut self, input: crate::model::DataDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DataDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The status of the predictor backtest export job. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the predictor backtest export job. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about any errors that may have occurred during the backtest export.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about any errors that may have occurred during the backtest export.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the predictor backtest export job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the predictor backtest export job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictorBacktestExportJobSummary`](crate::model::PredictorBacktestExportJobSummary)
        pub fn build(self) -> crate::model::PredictorBacktestExportJobSummary {
            crate::model::PredictorBacktestExportJobSummary {
                predictor_backtest_export_job_arn: self.predictor_backtest_export_job_arn,
                predictor_backtest_export_job_name: self.predictor_backtest_export_job_name,
                destination: self.destination,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl PredictorBacktestExportJobSummary {
    /// Creates a new builder-style object to manufacture [`PredictorBacktestExportJobSummary`](crate::model::PredictorBacktestExportJobSummary)
    pub fn builder() -> crate::model::predictor_backtest_export_job_summary::Builder {
        crate::model::predictor_backtest_export_job_summary::Builder::default()
    }
}

/// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataDestination {
    /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the bucket.</p>
    pub s3_config: std::option::Option<crate::model::S3Config>,
}
impl DataDestination {
    /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the bucket.</p>
    pub fn s3_config(&self) -> std::option::Option<&crate::model::S3Config> {
        self.s3_config.as_ref()
    }
}
impl std::fmt::Debug for DataDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataDestination");
        formatter.field("s3_config", &self.s3_config);
        formatter.finish()
    }
}
/// See [`DataDestination`](crate::model::DataDestination)
pub mod data_destination {
    /// A builder for [`DataDestination`](crate::model::DataDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_config: std::option::Option<crate::model::S3Config>,
    }
    impl Builder {
        /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the bucket.</p>
        pub fn s3_config(mut self, input: crate::model::S3Config) -> Self {
            self.s3_config = Some(input);
            self
        }
        /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the bucket.</p>
        pub fn set_s3_config(mut self, input: std::option::Option<crate::model::S3Config>) -> Self {
            self.s3_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DataDestination`](crate::model::DataDestination)
        pub fn build(self) -> crate::model::DataDestination {
            crate::model::DataDestination {
                s3_config: self.s3_config,
            }
        }
    }
}
impl DataDestination {
    /// Creates a new builder-style object to manufacture [`DataDestination`](crate::model::DataDestination)
    pub fn builder() -> crate::model::data_destination::Builder {
        crate::model::data_destination::Builder::default()
    }
}

/// <p>The path to the file(s) in an Amazon Simple Storage Service (Amazon S3) bucket, and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the file(s). Optionally, includes an AWS Key Management Service (KMS) key. This object is part of the <code>DataSource</code> object that is submitted in the <code>CreateDatasetImportJob</code> request, and part of the <code>DataDestination</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Config {
    /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s) in an Amazon S3 bucket.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket or files. If you provide a value for the <code>KMSKeyArn</code> key, the role must allow access to the key.</p>
    /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl S3Config {
    /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s) in an Amazon S3 bucket.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket or files. If you provide a value for the <code>KMSKeyArn</code> key, the role must allow access to the key.</p>
    /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for S3Config {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Config");
        formatter.field("path", &self.path);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`S3Config`](crate::model::S3Config)
pub mod s3_config {
    /// A builder for [`S3Config`](crate::model::S3Config)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s) in an Amazon S3 bucket.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s) in an Amazon S3 bucket.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket or files. If you provide a value for the <code>KMSKeyArn</code> key, the role must allow access to the key.</p>
        /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket or files. If you provide a value for the <code>KMSKeyArn</code> key, the role must allow access to the key.</p>
        /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Config`](crate::model::S3Config)
        pub fn build(self) -> crate::model::S3Config {
            crate::model::S3Config {
                path: self.path,
                role_arn: self.role_arn,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl S3Config {
    /// Creates a new builder-style object to manufacture [`S3Config`](crate::model::S3Config)
    pub fn builder() -> crate::model::s3_config::Builder {
        crate::model::s3_config::Builder::default()
    }
}

/// <p>Provides a summary of the forecast properties used in the <code>ListForecasts</code> operation. To get the complete set of properties, call the <code>DescribeForecast</code> operation, and provide the <code>ForecastArn</code> that is listed in the summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForecastSummary {
    /// <p>The ARN of the forecast.</p>
    pub forecast_arn: std::option::Option<std::string::String>,
    /// <p>The name of the forecast.</p>
    pub forecast_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the predictor used to generate the forecast.</p>
    pub predictor_arn: std::option::Option<std::string::String>,
    /// <p>Whether the Forecast was created from an AutoPredictor.</p>
    pub created_using_auto_predictor: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The status of the forecast. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul> <note>
    /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the forecast creation task was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ForecastSummary {
    /// <p>The ARN of the forecast.</p>
    pub fn forecast_arn(&self) -> std::option::Option<&str> {
        self.forecast_arn.as_deref()
    }
    /// <p>The name of the forecast.</p>
    pub fn forecast_name(&self) -> std::option::Option<&str> {
        self.forecast_name.as_deref()
    }
    /// <p>The ARN of the predictor used to generate the forecast.</p>
    pub fn predictor_arn(&self) -> std::option::Option<&str> {
        self.predictor_arn.as_deref()
    }
    /// <p>Whether the Forecast was created from an AutoPredictor.</p>
    pub fn created_using_auto_predictor(&self) -> std::option::Option<bool> {
        self.created_using_auto_predictor
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The status of the forecast. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul> <note>
    /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the forecast creation task was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for ForecastSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForecastSummary");
        formatter.field("forecast_arn", &self.forecast_arn);
        formatter.field("forecast_name", &self.forecast_name);
        formatter.field("predictor_arn", &self.predictor_arn);
        formatter.field(
            "created_using_auto_predictor",
            &self.created_using_auto_predictor,
        );
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`ForecastSummary`](crate::model::ForecastSummary)
pub mod forecast_summary {
    /// A builder for [`ForecastSummary`](crate::model::ForecastSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_arn: std::option::Option<std::string::String>,
        pub(crate) forecast_name: std::option::Option<std::string::String>,
        pub(crate) predictor_arn: std::option::Option<std::string::String>,
        pub(crate) created_using_auto_predictor: std::option::Option<bool>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the forecast.</p>
        pub fn forecast_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the forecast.</p>
        pub fn set_forecast_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.forecast_arn = input;
            self
        }
        /// <p>The name of the forecast.</p>
        pub fn forecast_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_name = Some(input.into());
            self
        }
        /// <p>The name of the forecast.</p>
        pub fn set_forecast_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_name = input;
            self
        }
        /// <p>The ARN of the predictor used to generate the forecast.</p>
        pub fn predictor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the predictor used to generate the forecast.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_arn = input;
            self
        }
        /// <p>Whether the Forecast was created from an AutoPredictor.</p>
        pub fn created_using_auto_predictor(mut self, input: bool) -> Self {
            self.created_using_auto_predictor = Some(input);
            self
        }
        /// <p>Whether the Forecast was created from an AutoPredictor.</p>
        pub fn set_created_using_auto_predictor(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.created_using_auto_predictor = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The status of the forecast. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul> <note>
        /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the forecast. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul> <note>
        /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the forecast creation task was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the forecast creation task was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ForecastSummary`](crate::model::ForecastSummary)
        pub fn build(self) -> crate::model::ForecastSummary {
            crate::model::ForecastSummary {
                forecast_arn: self.forecast_arn,
                forecast_name: self.forecast_name,
                predictor_arn: self.predictor_arn,
                created_using_auto_predictor: self.created_using_auto_predictor,
                dataset_group_arn: self.dataset_group_arn,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl ForecastSummary {
    /// Creates a new builder-style object to manufacture [`ForecastSummary`](crate::model::ForecastSummary)
    pub fn builder() -> crate::model::forecast_summary::Builder {
        crate::model::forecast_summary::Builder::default()
    }
}

/// <p>Provides a summary of the forecast export job properties used in the <code>ListForecastExportJobs</code> operation. To get the complete set of properties, call the <code>DescribeForecastExportJob</code> operation, and provide the listed <code>ForecastExportJobArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForecastExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the forecast export job.</p>
    pub forecast_export_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the forecast export job.</p>
    pub forecast_export_job_name: std::option::Option<std::string::String>,
    /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
    pub destination: std::option::Option<crate::model::DataDestination>,
    /// <p>The status of the forecast export job. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul> <note>
    /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast in your S3 bucket.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the forecast export job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ForecastExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the forecast export job.</p>
    pub fn forecast_export_job_arn(&self) -> std::option::Option<&str> {
        self.forecast_export_job_arn.as_deref()
    }
    /// <p>The name of the forecast export job.</p>
    pub fn forecast_export_job_name(&self) -> std::option::Option<&str> {
        self.forecast_export_job_name.as_deref()
    }
    /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::DataDestination> {
        self.destination.as_ref()
    }
    /// <p>The status of the forecast export job. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul> <note>
    /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast in your S3 bucket.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the forecast export job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for ForecastExportJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForecastExportJobSummary");
        formatter.field("forecast_export_job_arn", &self.forecast_export_job_arn);
        formatter.field("forecast_export_job_name", &self.forecast_export_job_name);
        formatter.field("destination", &self.destination);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`ForecastExportJobSummary`](crate::model::ForecastExportJobSummary)
pub mod forecast_export_job_summary {
    /// A builder for [`ForecastExportJobSummary`](crate::model::ForecastExportJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_export_job_arn: std::option::Option<std::string::String>,
        pub(crate) forecast_export_job_name: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::DataDestination>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the forecast export job.</p>
        pub fn forecast_export_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast export job.</p>
        pub fn set_forecast_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_export_job_arn = input;
            self
        }
        /// <p>The name of the forecast export job.</p>
        pub fn forecast_export_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_export_job_name = Some(input.into());
            self
        }
        /// <p>The name of the forecast export job.</p>
        pub fn set_forecast_export_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_export_job_name = input;
            self
        }
        /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
        pub fn destination(mut self, input: crate::model::DataDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DataDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The status of the forecast export job. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul> <note>
        /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast in your S3 bucket.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the forecast export job. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul> <note>
        /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast in your S3 bucket.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the forecast export job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the forecast export job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ForecastExportJobSummary`](crate::model::ForecastExportJobSummary)
        pub fn build(self) -> crate::model::ForecastExportJobSummary {
            crate::model::ForecastExportJobSummary {
                forecast_export_job_arn: self.forecast_export_job_arn,
                forecast_export_job_name: self.forecast_export_job_name,
                destination: self.destination,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl ForecastExportJobSummary {
    /// Creates a new builder-style object to manufacture [`ForecastExportJobSummary`](crate::model::ForecastExportJobSummary)
    pub fn builder() -> crate::model::forecast_export_job_summary::Builder {
        crate::model::forecast_export_job_summary::Builder::default()
    }
}

/// <p>Provides a summary of the Explainability export properties used in the <code>ListExplainabilityExports</code> operation. To get a complete set of properties, call the <code>DescribeExplainabilityExport</code> operation, and provide the <code>ExplainabilityExportArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExplainabilityExportSummary {
    /// <p>The Amazon Resource Name (ARN) of the Explainability export.</p>
    pub explainability_export_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Explainability export</p>
    pub explainability_export_name: std::option::Option<std::string::String>,
    /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
    pub destination: std::option::Option<crate::model::DataDestination>,
    /// <p>The status of the Explainability export. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>Information about any errors that may have occurred during the Explainability export.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the Explainability was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ExplainabilityExportSummary {
    /// <p>The Amazon Resource Name (ARN) of the Explainability export.</p>
    pub fn explainability_export_arn(&self) -> std::option::Option<&str> {
        self.explainability_export_arn.as_deref()
    }
    /// <p>The name of the Explainability export</p>
    pub fn explainability_export_name(&self) -> std::option::Option<&str> {
        self.explainability_export_name.as_deref()
    }
    /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
    pub fn destination(&self) -> std::option::Option<&crate::model::DataDestination> {
        self.destination.as_ref()
    }
    /// <p>The status of the Explainability export. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Information about any errors that may have occurred during the Explainability export.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the Explainability was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for ExplainabilityExportSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExplainabilityExportSummary");
        formatter.field("explainability_export_arn", &self.explainability_export_arn);
        formatter.field(
            "explainability_export_name",
            &self.explainability_export_name,
        );
        formatter.field("destination", &self.destination);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`ExplainabilityExportSummary`](crate::model::ExplainabilityExportSummary)
pub mod explainability_export_summary {
    /// A builder for [`ExplainabilityExportSummary`](crate::model::ExplainabilityExportSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) explainability_export_arn: std::option::Option<std::string::String>,
        pub(crate) explainability_export_name: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::DataDestination>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Explainability export.</p>
        pub fn explainability_export_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.explainability_export_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Explainability export.</p>
        pub fn set_explainability_export_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.explainability_export_arn = input;
            self
        }
        /// <p>The name of the Explainability export</p>
        pub fn explainability_export_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.explainability_export_name = Some(input.into());
            self
        }
        /// <p>The name of the Explainability export</p>
        pub fn set_explainability_export_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.explainability_export_name = input;
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn destination(mut self, input: crate::model::DataDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DataDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The status of the Explainability export. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Explainability export. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about any errors that may have occurred during the Explainability export.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about any errors that may have occurred during the Explainability export.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the Explainability was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the Explainability was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExplainabilityExportSummary`](crate::model::ExplainabilityExportSummary)
        pub fn build(self) -> crate::model::ExplainabilityExportSummary {
            crate::model::ExplainabilityExportSummary {
                explainability_export_arn: self.explainability_export_arn,
                explainability_export_name: self.explainability_export_name,
                destination: self.destination,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl ExplainabilityExportSummary {
    /// Creates a new builder-style object to manufacture [`ExplainabilityExportSummary`](crate::model::ExplainabilityExportSummary)
    pub fn builder() -> crate::model::explainability_export_summary::Builder {
        crate::model::explainability_export_summary::Builder::default()
    }
}

/// <p>Provides a summary of the Explainability properties used in the <code>ListExplainabilities</code> operation. To get a complete set of properties, call the <code>DescribeExplainability</code> operation, and provide the listed <code>ExplainabilityArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExplainabilitySummary {
    /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
    pub explainability_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Explainability.</p>
    pub explainability_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The configuration settings that define the granularity of time series and time points for the Explainability.</p>
    pub explainability_config: std::option::Option<crate::model::ExplainabilityConfig>,
    /// <p>The status of the Explainability. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>Information about any errors that may have occurred during the Explainability creation process.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the Explainability was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ExplainabilitySummary {
    /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
    pub fn explainability_arn(&self) -> std::option::Option<&str> {
        self.explainability_arn.as_deref()
    }
    /// <p>The name of the Explainability.</p>
    pub fn explainability_name(&self) -> std::option::Option<&str> {
        self.explainability_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The configuration settings that define the granularity of time series and time points for the Explainability.</p>
    pub fn explainability_config(
        &self,
    ) -> std::option::Option<&crate::model::ExplainabilityConfig> {
        self.explainability_config.as_ref()
    }
    /// <p>The status of the Explainability. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Information about any errors that may have occurred during the Explainability creation process.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the Explainability was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for ExplainabilitySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExplainabilitySummary");
        formatter.field("explainability_arn", &self.explainability_arn);
        formatter.field("explainability_name", &self.explainability_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("explainability_config", &self.explainability_config);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`ExplainabilitySummary`](crate::model::ExplainabilitySummary)
pub mod explainability_summary {
    /// A builder for [`ExplainabilitySummary`](crate::model::ExplainabilitySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) explainability_arn: std::option::Option<std::string::String>,
        pub(crate) explainability_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) explainability_config: std::option::Option<crate::model::ExplainabilityConfig>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
        pub fn explainability_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.explainability_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
        pub fn set_explainability_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.explainability_arn = input;
            self
        }
        /// <p>The name of the Explainability.</p>
        pub fn explainability_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.explainability_name = Some(input.into());
            self
        }
        /// <p>The name of the Explainability.</p>
        pub fn set_explainability_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.explainability_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The configuration settings that define the granularity of time series and time points for the Explainability.</p>
        pub fn explainability_config(mut self, input: crate::model::ExplainabilityConfig) -> Self {
            self.explainability_config = Some(input);
            self
        }
        /// <p>The configuration settings that define the granularity of time series and time points for the Explainability.</p>
        pub fn set_explainability_config(
            mut self,
            input: std::option::Option<crate::model::ExplainabilityConfig>,
        ) -> Self {
            self.explainability_config = input;
            self
        }
        /// <p>The status of the Explainability. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Explainability. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about any errors that may have occurred during the Explainability creation process.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about any errors that may have occurred during the Explainability creation process.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the Explainability was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the Explainability was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExplainabilitySummary`](crate::model::ExplainabilitySummary)
        pub fn build(self) -> crate::model::ExplainabilitySummary {
            crate::model::ExplainabilitySummary {
                explainability_arn: self.explainability_arn,
                explainability_name: self.explainability_name,
                resource_arn: self.resource_arn,
                explainability_config: self.explainability_config,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl ExplainabilitySummary {
    /// Creates a new builder-style object to manufacture [`ExplainabilitySummary`](crate::model::ExplainabilitySummary)
    pub fn builder() -> crate::model::explainability_summary::Builder {
        crate::model::explainability_summary::Builder::default()
    }
}

/// <p>The ExplainabilityConfig data type defines the number of time series and time points included in <code>CreateExplainability</code>.</p>
/// <p>If you provide a predictor ARN for <code>ResourceArn</code>, you must set both <code>TimePointGranularity</code> and <code>TimeSeriesGranularity</code> to “ALL”. When creating Predictor Explainability, Amazon Forecast considers all time series and time points.</p>
/// <p>If you provide a forecast ARN for <code>ResourceArn</code>, you can set <code>TimePointGranularity</code> and <code>TimeSeriesGranularity</code> to either “ALL” or “Specific”.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExplainabilityConfig {
    /// <p>To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
    /// <p>Specify time series by uploading a CSV file to an Amazon S3 bucket and set the location within the <code>DataDestination</code> data type.</p>
    pub time_series_granularity: std::option::Option<crate::model::TimeSeriesGranularity>,
    /// <p>To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.</p>
    /// <p>Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the <code>CreateExplainability</code> operation.</p>
    pub time_point_granularity: std::option::Option<crate::model::TimePointGranularity>,
}
impl ExplainabilityConfig {
    /// <p>To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
    /// <p>Specify time series by uploading a CSV file to an Amazon S3 bucket and set the location within the <code>DataDestination</code> data type.</p>
    pub fn time_series_granularity(
        &self,
    ) -> std::option::Option<&crate::model::TimeSeriesGranularity> {
        self.time_series_granularity.as_ref()
    }
    /// <p>To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.</p>
    /// <p>Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the <code>CreateExplainability</code> operation.</p>
    pub fn time_point_granularity(
        &self,
    ) -> std::option::Option<&crate::model::TimePointGranularity> {
        self.time_point_granularity.as_ref()
    }
}
impl std::fmt::Debug for ExplainabilityConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExplainabilityConfig");
        formatter.field("time_series_granularity", &self.time_series_granularity);
        formatter.field("time_point_granularity", &self.time_point_granularity);
        formatter.finish()
    }
}
/// See [`ExplainabilityConfig`](crate::model::ExplainabilityConfig)
pub mod explainability_config {
    /// A builder for [`ExplainabilityConfig`](crate::model::ExplainabilityConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_series_granularity:
            std::option::Option<crate::model::TimeSeriesGranularity>,
        pub(crate) time_point_granularity: std::option::Option<crate::model::TimePointGranularity>,
    }
    impl Builder {
        /// <p>To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
        /// <p>Specify time series by uploading a CSV file to an Amazon S3 bucket and set the location within the <code>DataDestination</code> data type.</p>
        pub fn time_series_granularity(
            mut self,
            input: crate::model::TimeSeriesGranularity,
        ) -> Self {
            self.time_series_granularity = Some(input);
            self
        }
        /// <p>To create an Explainability for all time series in your datasets, use <code>ALL</code>. To create an Explainability for specific time series in your datasets, use <code>SPECIFIC</code>.</p>
        /// <p>Specify time series by uploading a CSV file to an Amazon S3 bucket and set the location within the <code>DataDestination</code> data type.</p>
        pub fn set_time_series_granularity(
            mut self,
            input: std::option::Option<crate::model::TimeSeriesGranularity>,
        ) -> Self {
            self.time_series_granularity = input;
            self
        }
        /// <p>To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.</p>
        /// <p>Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the <code>CreateExplainability</code> operation.</p>
        pub fn time_point_granularity(mut self, input: crate::model::TimePointGranularity) -> Self {
            self.time_point_granularity = Some(input);
            self
        }
        /// <p>To create an Explainability for all time points in your forecast horizon, use <code>ALL</code>. To create an Explainability for specific time points in your forecast horizon, use <code>SPECIFIC</code>.</p>
        /// <p>Specify time points with the <code>StartDateTime</code> and <code>EndDateTime</code> parameters within the <code>CreateExplainability</code> operation.</p>
        pub fn set_time_point_granularity(
            mut self,
            input: std::option::Option<crate::model::TimePointGranularity>,
        ) -> Self {
            self.time_point_granularity = input;
            self
        }
        /// Consumes the builder and constructs a [`ExplainabilityConfig`](crate::model::ExplainabilityConfig)
        pub fn build(self) -> crate::model::ExplainabilityConfig {
            crate::model::ExplainabilityConfig {
                time_series_granularity: self.time_series_granularity,
                time_point_granularity: self.time_point_granularity,
            }
        }
    }
}
impl ExplainabilityConfig {
    /// Creates a new builder-style object to manufacture [`ExplainabilityConfig`](crate::model::ExplainabilityConfig)
    pub fn builder() -> crate::model::explainability_config::Builder {
        crate::model::explainability_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimePointGranularity {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Specific,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimePointGranularity {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => TimePointGranularity::All,
            "SPECIFIC" => TimePointGranularity::Specific,
            other => TimePointGranularity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimePointGranularity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimePointGranularity::from(s))
    }
}
impl TimePointGranularity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimePointGranularity::All => "ALL",
            TimePointGranularity::Specific => "SPECIFIC",
            TimePointGranularity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "SPECIFIC"]
    }
}
impl AsRef<str> for TimePointGranularity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeSeriesGranularity {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Specific,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeSeriesGranularity {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => TimeSeriesGranularity::All,
            "SPECIFIC" => TimeSeriesGranularity::Specific,
            other => TimeSeriesGranularity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeSeriesGranularity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeSeriesGranularity::from(s))
    }
}
impl TimeSeriesGranularity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeSeriesGranularity::All => "ALL",
            TimeSeriesGranularity::Specific => "SPECIFIC",
            TimeSeriesGranularity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "SPECIFIC"]
    }
}
impl AsRef<str> for TimeSeriesGranularity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a summary of the dataset properties used in the <code>ListDatasets</code> operation. To get the complete set of properties, call the <code>DescribeDataset</code> operation, and provide the <code>DatasetArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The dataset type.</p>
    pub dataset_type: std::option::Option<crate::model::DatasetType>,
    /// <p>The domain associated with the dataset.</p>
    pub domain: std::option::Option<crate::model::Domain>,
    /// <p>When the dataset was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the <code>ListDatasets</code> call. After a <code>CreateDatasetImportJob</code> operation has finished, <code>LastModificationTime</code> is when the import job completed or failed.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DatasetSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The name of the dataset.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The dataset type.</p>
    pub fn dataset_type(&self) -> std::option::Option<&crate::model::DatasetType> {
        self.dataset_type.as_ref()
    }
    /// <p>The domain associated with the dataset.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
    /// <p>When the dataset was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the <code>ListDatasets</code> call. After a <code>CreateDatasetImportJob</code> operation has finished, <code>LastModificationTime</code> is when the import job completed or failed.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DatasetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetSummary");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("domain", &self.domain);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DatasetSummary`](crate::model::DatasetSummary)
pub mod dataset_summary {
    /// A builder for [`DatasetSummary`](crate::model::DatasetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<crate::model::DatasetType>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The dataset type.</p>
        pub fn dataset_type(mut self, input: crate::model::DatasetType) -> Self {
            self.dataset_type = Some(input);
            self
        }
        /// <p>The dataset type.</p>
        pub fn set_dataset_type(
            mut self,
            input: std::option::Option<crate::model::DatasetType>,
        ) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>The domain associated with the dataset.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain associated with the dataset.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// <p>When the dataset was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the dataset was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the <code>ListDatasets</code> call. After a <code>CreateDatasetImportJob</code> operation has finished, <code>LastModificationTime</code> is when the import job completed or failed.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the <code>ListDatasets</code> call. After a <code>CreateDatasetImportJob</code> operation has finished, <code>LastModificationTime</code> is when the import job completed or failed.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetSummary`](crate::model::DatasetSummary)
        pub fn build(self) -> crate::model::DatasetSummary {
            crate::model::DatasetSummary {
                dataset_arn: self.dataset_arn,
                dataset_name: self.dataset_name,
                dataset_type: self.dataset_type,
                domain: self.domain,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DatasetSummary {
    /// Creates a new builder-style object to manufacture [`DatasetSummary`](crate::model::DatasetSummary)
    pub fn builder() -> crate::model::dataset_summary::Builder {
        crate::model::dataset_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Domain {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Capacity,
    #[allow(missing_docs)] // documentation missing in model
    InventoryPlanning,
    #[allow(missing_docs)] // documentation missing in model
    Metrics,
    #[allow(missing_docs)] // documentation missing in model
    Retail,
    #[allow(missing_docs)] // documentation missing in model
    WebTraffic,
    #[allow(missing_docs)] // documentation missing in model
    WorkForce,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Domain {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => Domain::Custom,
            "EC2_CAPACITY" => Domain::Ec2Capacity,
            "INVENTORY_PLANNING" => Domain::InventoryPlanning,
            "METRICS" => Domain::Metrics,
            "RETAIL" => Domain::Retail,
            "WEB_TRAFFIC" => Domain::WebTraffic,
            "WORK_FORCE" => Domain::WorkForce,
            other => Domain::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Domain {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Domain::from(s))
    }
}
impl Domain {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Domain::Custom => "CUSTOM",
            Domain::Ec2Capacity => "EC2_CAPACITY",
            Domain::InventoryPlanning => "INVENTORY_PLANNING",
            Domain::Metrics => "METRICS",
            Domain::Retail => "RETAIL",
            Domain::WebTraffic => "WEB_TRAFFIC",
            Domain::WorkForce => "WORK_FORCE",
            Domain::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CUSTOM",
            "EC2_CAPACITY",
            "INVENTORY_PLANNING",
            "METRICS",
            "RETAIL",
            "WEB_TRAFFIC",
            "WORK_FORCE",
        ]
    }
}
impl AsRef<str> for Domain {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetType {
    #[allow(missing_docs)] // documentation missing in model
    ItemMetadata,
    #[allow(missing_docs)] // documentation missing in model
    RelatedTimeSeries,
    #[allow(missing_docs)] // documentation missing in model
    TargetTimeSeries,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetType {
    fn from(s: &str) -> Self {
        match s {
            "ITEM_METADATA" => DatasetType::ItemMetadata,
            "RELATED_TIME_SERIES" => DatasetType::RelatedTimeSeries,
            "TARGET_TIME_SERIES" => DatasetType::TargetTimeSeries,
            other => DatasetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetType::from(s))
    }
}
impl DatasetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetType::ItemMetadata => "ITEM_METADATA",
            DatasetType::RelatedTimeSeries => "RELATED_TIME_SERIES",
            DatasetType::TargetTimeSeries => "TARGET_TIME_SERIES",
            DatasetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ITEM_METADATA", "RELATED_TIME_SERIES", "TARGET_TIME_SERIES"]
    }
}
impl AsRef<str> for DatasetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a summary of the dataset import job properties used in the <code>ListDatasetImportJobs</code> operation. To get the complete set of properties, call the <code>DescribeDatasetImportJob</code> operation, and provide the <code>DatasetImportJobArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetImportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
    pub dataset_import_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset import job.</p>
    pub dataset_import_job_name: std::option::Option<std::string::String>,
    /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p>
    /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>The status of the dataset import job. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the dataset import job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DatasetImportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
    pub fn dataset_import_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_import_job_arn.as_deref()
    }
    /// <p>The name of the dataset import job.</p>
    pub fn dataset_import_job_name(&self) -> std::option::Option<&str> {
        self.dataset_import_job_name.as_deref()
    }
    /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p>
    /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::DataSource> {
        self.data_source.as_ref()
    }
    /// <p>The status of the dataset import job. States include:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the dataset import job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
    /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
    /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DatasetImportJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetImportJobSummary");
        formatter.field("dataset_import_job_arn", &self.dataset_import_job_arn);
        formatter.field("dataset_import_job_name", &self.dataset_import_job_name);
        formatter.field("data_source", &self.data_source);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
pub mod dataset_import_job_summary {
    /// A builder for [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_job_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_import_job_name: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn dataset_import_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_arn = input;
            self
        }
        /// <p>The name of the dataset import job.</p>
        pub fn dataset_import_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset import job.</p>
        pub fn set_dataset_import_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_name = input;
            self
        }
        /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p>
        /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p>
        /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The status of the dataset import job. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset import job. States include:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the dataset import job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the dataset import job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li> <p> <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code> - The current timestamp.</p> </li>
        /// <li> <p> <code>CREATE_STOPPED</code> - When the job stopped.</p> </li>
        /// <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
        pub fn build(self) -> crate::model::DatasetImportJobSummary {
            crate::model::DatasetImportJobSummary {
                dataset_import_job_arn: self.dataset_import_job_arn,
                dataset_import_job_name: self.dataset_import_job_name,
                data_source: self.data_source,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DatasetImportJobSummary {
    /// Creates a new builder-style object to manufacture [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
    pub fn builder() -> crate::model::dataset_import_job_summary::Builder {
        crate::model::dataset_import_job_summary::Builder::default()
    }
}

/// <p>The source of your data, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the data and, optionally, an AWS Key Management Service (KMS) key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSource {
    /// <p>The path to the data stored in an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the data.</p>
    pub s3_config: std::option::Option<crate::model::S3Config>,
}
impl DataSource {
    /// <p>The path to the data stored in an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the data.</p>
    pub fn s3_config(&self) -> std::option::Option<&crate::model::S3Config> {
        self.s3_config.as_ref()
    }
}
impl std::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSource");
        formatter.field("s3_config", &self.s3_config);
        formatter.finish()
    }
}
/// See [`DataSource`](crate::model::DataSource)
pub mod data_source {
    /// A builder for [`DataSource`](crate::model::DataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_config: std::option::Option<crate::model::S3Config>,
    }
    impl Builder {
        /// <p>The path to the data stored in an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the data.</p>
        pub fn s3_config(mut self, input: crate::model::S3Config) -> Self {
            self.s3_config = Some(input);
            self
        }
        /// <p>The path to the data stored in an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the data.</p>
        pub fn set_s3_config(mut self, input: std::option::Option<crate::model::S3Config>) -> Self {
            self.s3_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSource`](crate::model::DataSource)
        pub fn build(self) -> crate::model::DataSource {
            crate::model::DataSource {
                s3_config: self.s3_config,
            }
        }
    }
}
impl DataSource {
    /// Creates a new builder-style object to manufacture [`DataSource`](crate::model::DataSource)
    pub fn builder() -> crate::model::data_source::Builder {
        crate::model::data_source::Builder::default()
    }
}

/// <p>Provides a summary of the dataset group properties used in the <code>ListDatasetGroups</code> operation. To get the complete set of properties, call the <code>DescribeDatasetGroup</code> operation, and provide the <code>DatasetGroupArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetGroupSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset group.</p>
    pub dataset_group_name: std::option::Option<std::string::String>,
    /// <p>When the dataset group was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the dataset group was created or last updated from a call to the <code>UpdateDatasetGroup</code> operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current time of the <code>ListDatasetGroups</code> call.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DatasetGroupSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The name of the dataset group.</p>
    pub fn dataset_group_name(&self) -> std::option::Option<&str> {
        self.dataset_group_name.as_deref()
    }
    /// <p>When the dataset group was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>When the dataset group was created or last updated from a call to the <code>UpdateDatasetGroup</code> operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current time of the <code>ListDatasetGroups</code> call.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DatasetGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetGroupSummary");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("dataset_group_name", &self.dataset_group_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
pub mod dataset_group_summary {
    /// A builder for [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The name of the dataset group.</p>
        pub fn dataset_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset group.</p>
        pub fn set_dataset_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_name = input;
            self
        }
        /// <p>When the dataset group was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the dataset group was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>When the dataset group was created or last updated from a call to the <code>UpdateDatasetGroup</code> operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current time of the <code>ListDatasetGroups</code> call.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>When the dataset group was created or last updated from a call to the <code>UpdateDatasetGroup</code> operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current time of the <code>ListDatasetGroups</code> call.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
        pub fn build(self) -> crate::model::DatasetGroupSummary {
            crate::model::DatasetGroupSummary {
                dataset_group_arn: self.dataset_group_arn,
                dataset_group_name: self.dataset_group_name,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DatasetGroupSummary {
    /// Creates a new builder-style object to manufacture [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
    pub fn builder() -> crate::model::dataset_group_summary::Builder {
        crate::model::dataset_group_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OptimizationMetric {
    #[allow(missing_docs)] // documentation missing in model
    AverageWeightedQuantileLoss,
    #[allow(missing_docs)] // documentation missing in model
    Mape,
    #[allow(missing_docs)] // documentation missing in model
    Mase,
    #[allow(missing_docs)] // documentation missing in model
    Rmse,
    #[allow(missing_docs)] // documentation missing in model
    Wape,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OptimizationMetric {
    fn from(s: &str) -> Self {
        match s {
            "AverageWeightedQuantileLoss" => OptimizationMetric::AverageWeightedQuantileLoss,
            "MAPE" => OptimizationMetric::Mape,
            "MASE" => OptimizationMetric::Mase,
            "RMSE" => OptimizationMetric::Rmse,
            "WAPE" => OptimizationMetric::Wape,
            other => OptimizationMetric::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OptimizationMetric {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OptimizationMetric::from(s))
    }
}
impl OptimizationMetric {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OptimizationMetric::AverageWeightedQuantileLoss => "AverageWeightedQuantileLoss",
            OptimizationMetric::Mape => "MAPE",
            OptimizationMetric::Mase => "MASE",
            OptimizationMetric::Rmse => "RMSE",
            OptimizationMetric::Wape => "WAPE",
            OptimizationMetric::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AverageWeightedQuantileLoss",
            "MAPE",
            "MASE",
            "RMSE",
            "WAPE",
        ]
    }
}
impl AsRef<str> for OptimizationMetric {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoMlOverrideStrategy {
    #[allow(missing_docs)] // documentation missing in model
    AccuracyOptimized,
    #[allow(missing_docs)] // documentation missing in model
    LatencyOptimized,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoMlOverrideStrategy {
    fn from(s: &str) -> Self {
        match s {
            "AccuracyOptimized" => AutoMlOverrideStrategy::AccuracyOptimized,
            "LatencyOptimized" => AutoMlOverrideStrategy::LatencyOptimized,
            other => AutoMlOverrideStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoMlOverrideStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoMlOverrideStrategy::from(s))
    }
}
impl AutoMlOverrideStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoMlOverrideStrategy::AccuracyOptimized => "AccuracyOptimized",
            AutoMlOverrideStrategy::LatencyOptimized => "LatencyOptimized",
            AutoMlOverrideStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AccuracyOptimized", "LatencyOptimized"]
    }
}
impl AsRef<str> for AutoMlOverrideStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The results of evaluating an algorithm. Returned as part of the <code>GetAccuracyMetrics</code> response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResult {
    /// <p>The Amazon Resource Name (ARN) of the algorithm that was evaluated.</p>
    pub algorithm_arn: std::option::Option<std::string::String>,
    /// <p>The array of test windows used for evaluating the algorithm. The <code>NumberOfBacktestWindows</code> from the <code>EvaluationParameters</code> object determines the number of windows in the array.</p>
    pub test_windows: std::option::Option<std::vec::Vec<crate::model::WindowSummary>>,
}
impl EvaluationResult {
    /// <p>The Amazon Resource Name (ARN) of the algorithm that was evaluated.</p>
    pub fn algorithm_arn(&self) -> std::option::Option<&str> {
        self.algorithm_arn.as_deref()
    }
    /// <p>The array of test windows used for evaluating the algorithm. The <code>NumberOfBacktestWindows</code> from the <code>EvaluationParameters</code> object determines the number of windows in the array.</p>
    pub fn test_windows(&self) -> std::option::Option<&[crate::model::WindowSummary]> {
        self.test_windows.as_deref()
    }
}
impl std::fmt::Debug for EvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResult");
        formatter.field("algorithm_arn", &self.algorithm_arn);
        formatter.field("test_windows", &self.test_windows);
        formatter.finish()
    }
}
/// See [`EvaluationResult`](crate::model::EvaluationResult)
pub mod evaluation_result {
    /// A builder for [`EvaluationResult`](crate::model::EvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_arn: std::option::Option<std::string::String>,
        pub(crate) test_windows: std::option::Option<std::vec::Vec<crate::model::WindowSummary>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the algorithm that was evaluated.</p>
        pub fn algorithm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm that was evaluated.</p>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_arn = input;
            self
        }
        /// Appends an item to `test_windows`.
        ///
        /// To override the contents of this collection use [`set_test_windows`](Self::set_test_windows).
        ///
        /// <p>The array of test windows used for evaluating the algorithm. The <code>NumberOfBacktestWindows</code> from the <code>EvaluationParameters</code> object determines the number of windows in the array.</p>
        pub fn test_windows(mut self, input: crate::model::WindowSummary) -> Self {
            let mut v = self.test_windows.unwrap_or_default();
            v.push(input);
            self.test_windows = Some(v);
            self
        }
        /// <p>The array of test windows used for evaluating the algorithm. The <code>NumberOfBacktestWindows</code> from the <code>EvaluationParameters</code> object determines the number of windows in the array.</p>
        pub fn set_test_windows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WindowSummary>>,
        ) -> Self {
            self.test_windows = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResult`](crate::model::EvaluationResult)
        pub fn build(self) -> crate::model::EvaluationResult {
            crate::model::EvaluationResult {
                algorithm_arn: self.algorithm_arn,
                test_windows: self.test_windows,
            }
        }
    }
}
impl EvaluationResult {
    /// Creates a new builder-style object to manufacture [`EvaluationResult`](crate::model::EvaluationResult)
    pub fn builder() -> crate::model::evaluation_result::Builder {
        crate::model::evaluation_result::Builder::default()
    }
}

/// <p>The metrics for a time range within the evaluation portion of a dataset. This object is part of the <code>EvaluationResult</code> object.</p>
/// <p>The <code>TestWindowStart</code> and <code>TestWindowEnd</code> parameters are determined by the <code>BackTestWindowOffset</code> parameter of the <code>EvaluationParameters</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WindowSummary {
    /// <p>The timestamp that defines the start of the window.</p>
    pub test_window_start: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp that defines the end of the window.</p>
    pub test_window_end: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of data points within the window.</p>
    pub item_count: std::option::Option<i32>,
    /// <p>The type of evaluation.</p>
    /// <ul>
    /// <li> <p> <code>SUMMARY</code> - The average metrics across all windows.</p> </li>
    /// <li> <p> <code>COMPUTED</code> - The metrics for the specified window.</p> </li>
    /// </ul>
    pub evaluation_type: std::option::Option<crate::model::EvaluationType>,
    /// <p>Provides metrics used to evaluate the performance of a predictor.</p>
    pub metrics: std::option::Option<crate::model::Metrics>,
}
impl WindowSummary {
    /// <p>The timestamp that defines the start of the window.</p>
    pub fn test_window_start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.test_window_start.as_ref()
    }
    /// <p>The timestamp that defines the end of the window.</p>
    pub fn test_window_end(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.test_window_end.as_ref()
    }
    /// <p>The number of data points within the window.</p>
    pub fn item_count(&self) -> std::option::Option<i32> {
        self.item_count
    }
    /// <p>The type of evaluation.</p>
    /// <ul>
    /// <li> <p> <code>SUMMARY</code> - The average metrics across all windows.</p> </li>
    /// <li> <p> <code>COMPUTED</code> - The metrics for the specified window.</p> </li>
    /// </ul>
    pub fn evaluation_type(&self) -> std::option::Option<&crate::model::EvaluationType> {
        self.evaluation_type.as_ref()
    }
    /// <p>Provides metrics used to evaluate the performance of a predictor.</p>
    pub fn metrics(&self) -> std::option::Option<&crate::model::Metrics> {
        self.metrics.as_ref()
    }
}
impl std::fmt::Debug for WindowSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WindowSummary");
        formatter.field("test_window_start", &self.test_window_start);
        formatter.field("test_window_end", &self.test_window_end);
        formatter.field("item_count", &self.item_count);
        formatter.field("evaluation_type", &self.evaluation_type);
        formatter.field("metrics", &self.metrics);
        formatter.finish()
    }
}
/// See [`WindowSummary`](crate::model::WindowSummary)
pub mod window_summary {
    /// A builder for [`WindowSummary`](crate::model::WindowSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_window_start: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) test_window_end: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) item_count: std::option::Option<i32>,
        pub(crate) evaluation_type: std::option::Option<crate::model::EvaluationType>,
        pub(crate) metrics: std::option::Option<crate::model::Metrics>,
    }
    impl Builder {
        /// <p>The timestamp that defines the start of the window.</p>
        pub fn test_window_start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.test_window_start = Some(input);
            self
        }
        /// <p>The timestamp that defines the start of the window.</p>
        pub fn set_test_window_start(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.test_window_start = input;
            self
        }
        /// <p>The timestamp that defines the end of the window.</p>
        pub fn test_window_end(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.test_window_end = Some(input);
            self
        }
        /// <p>The timestamp that defines the end of the window.</p>
        pub fn set_test_window_end(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.test_window_end = input;
            self
        }
        /// <p>The number of data points within the window.</p>
        pub fn item_count(mut self, input: i32) -> Self {
            self.item_count = Some(input);
            self
        }
        /// <p>The number of data points within the window.</p>
        pub fn set_item_count(mut self, input: std::option::Option<i32>) -> Self {
            self.item_count = input;
            self
        }
        /// <p>The type of evaluation.</p>
        /// <ul>
        /// <li> <p> <code>SUMMARY</code> - The average metrics across all windows.</p> </li>
        /// <li> <p> <code>COMPUTED</code> - The metrics for the specified window.</p> </li>
        /// </ul>
        pub fn evaluation_type(mut self, input: crate::model::EvaluationType) -> Self {
            self.evaluation_type = Some(input);
            self
        }
        /// <p>The type of evaluation.</p>
        /// <ul>
        /// <li> <p> <code>SUMMARY</code> - The average metrics across all windows.</p> </li>
        /// <li> <p> <code>COMPUTED</code> - The metrics for the specified window.</p> </li>
        /// </ul>
        pub fn set_evaluation_type(
            mut self,
            input: std::option::Option<crate::model::EvaluationType>,
        ) -> Self {
            self.evaluation_type = input;
            self
        }
        /// <p>Provides metrics used to evaluate the performance of a predictor.</p>
        pub fn metrics(mut self, input: crate::model::Metrics) -> Self {
            self.metrics = Some(input);
            self
        }
        /// <p>Provides metrics used to evaluate the performance of a predictor.</p>
        pub fn set_metrics(mut self, input: std::option::Option<crate::model::Metrics>) -> Self {
            self.metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`WindowSummary`](crate::model::WindowSummary)
        pub fn build(self) -> crate::model::WindowSummary {
            crate::model::WindowSummary {
                test_window_start: self.test_window_start,
                test_window_end: self.test_window_end,
                item_count: self.item_count,
                evaluation_type: self.evaluation_type,
                metrics: self.metrics,
            }
        }
    }
}
impl WindowSummary {
    /// Creates a new builder-style object to manufacture [`WindowSummary`](crate::model::WindowSummary)
    pub fn builder() -> crate::model::window_summary::Builder {
        crate::model::window_summary::Builder::default()
    }
}

/// <p>Provides metrics that are used to evaluate the performance of a predictor. This object is part of the <code>WindowSummary</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metrics {
    /// <p>The root-mean-square error (RMSE).</p>
    pub rmse: std::option::Option<f64>,
    /// <p>An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal probability. The distribution in this case is the loss function.</p>
    pub weighted_quantile_losses:
        std::option::Option<std::vec::Vec<crate::model::WeightedQuantileLoss>>,
    /// <p> Provides detailed error metrics for each forecast type. Metrics include root-mean square-error (RMSE), mean absolute percentage error (MAPE), mean absolute scaled error (MASE), and weighted average percentage error (WAPE). </p>
    pub error_metrics: std::option::Option<std::vec::Vec<crate::model::ErrorMetric>>,
    /// <p>The average value of all weighted quantile losses.</p>
    pub average_weighted_quantile_loss: std::option::Option<f64>,
}
impl Metrics {
    /// <p>The root-mean-square error (RMSE).</p>
    pub fn rmse(&self) -> std::option::Option<f64> {
        self.rmse
    }
    /// <p>An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal probability. The distribution in this case is the loss function.</p>
    pub fn weighted_quantile_losses(
        &self,
    ) -> std::option::Option<&[crate::model::WeightedQuantileLoss]> {
        self.weighted_quantile_losses.as_deref()
    }
    /// <p> Provides detailed error metrics for each forecast type. Metrics include root-mean square-error (RMSE), mean absolute percentage error (MAPE), mean absolute scaled error (MASE), and weighted average percentage error (WAPE). </p>
    pub fn error_metrics(&self) -> std::option::Option<&[crate::model::ErrorMetric]> {
        self.error_metrics.as_deref()
    }
    /// <p>The average value of all weighted quantile losses.</p>
    pub fn average_weighted_quantile_loss(&self) -> std::option::Option<f64> {
        self.average_weighted_quantile_loss
    }
}
impl std::fmt::Debug for Metrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metrics");
        formatter.field("rmse", &self.rmse);
        formatter.field("weighted_quantile_losses", &self.weighted_quantile_losses);
        formatter.field("error_metrics", &self.error_metrics);
        formatter.field(
            "average_weighted_quantile_loss",
            &self.average_weighted_quantile_loss,
        );
        formatter.finish()
    }
}
/// See [`Metrics`](crate::model::Metrics)
pub mod metrics {
    /// A builder for [`Metrics`](crate::model::Metrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rmse: std::option::Option<f64>,
        pub(crate) weighted_quantile_losses:
            std::option::Option<std::vec::Vec<crate::model::WeightedQuantileLoss>>,
        pub(crate) error_metrics: std::option::Option<std::vec::Vec<crate::model::ErrorMetric>>,
        pub(crate) average_weighted_quantile_loss: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The root-mean-square error (RMSE).</p>
        pub fn rmse(mut self, input: f64) -> Self {
            self.rmse = Some(input);
            self
        }
        /// <p>The root-mean-square error (RMSE).</p>
        pub fn set_rmse(mut self, input: std::option::Option<f64>) -> Self {
            self.rmse = input;
            self
        }
        /// Appends an item to `weighted_quantile_losses`.
        ///
        /// To override the contents of this collection use [`set_weighted_quantile_losses`](Self::set_weighted_quantile_losses).
        ///
        /// <p>An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal probability. The distribution in this case is the loss function.</p>
        pub fn weighted_quantile_losses(
            mut self,
            input: crate::model::WeightedQuantileLoss,
        ) -> Self {
            let mut v = self.weighted_quantile_losses.unwrap_or_default();
            v.push(input);
            self.weighted_quantile_losses = Some(v);
            self
        }
        /// <p>An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal probability. The distribution in this case is the loss function.</p>
        pub fn set_weighted_quantile_losses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WeightedQuantileLoss>>,
        ) -> Self {
            self.weighted_quantile_losses = input;
            self
        }
        /// Appends an item to `error_metrics`.
        ///
        /// To override the contents of this collection use [`set_error_metrics`](Self::set_error_metrics).
        ///
        /// <p> Provides detailed error metrics for each forecast type. Metrics include root-mean square-error (RMSE), mean absolute percentage error (MAPE), mean absolute scaled error (MASE), and weighted average percentage error (WAPE). </p>
        pub fn error_metrics(mut self, input: crate::model::ErrorMetric) -> Self {
            let mut v = self.error_metrics.unwrap_or_default();
            v.push(input);
            self.error_metrics = Some(v);
            self
        }
        /// <p> Provides detailed error metrics for each forecast type. Metrics include root-mean square-error (RMSE), mean absolute percentage error (MAPE), mean absolute scaled error (MASE), and weighted average percentage error (WAPE). </p>
        pub fn set_error_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ErrorMetric>>,
        ) -> Self {
            self.error_metrics = input;
            self
        }
        /// <p>The average value of all weighted quantile losses.</p>
        pub fn average_weighted_quantile_loss(mut self, input: f64) -> Self {
            self.average_weighted_quantile_loss = Some(input);
            self
        }
        /// <p>The average value of all weighted quantile losses.</p>
        pub fn set_average_weighted_quantile_loss(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.average_weighted_quantile_loss = input;
            self
        }
        /// Consumes the builder and constructs a [`Metrics`](crate::model::Metrics)
        pub fn build(self) -> crate::model::Metrics {
            crate::model::Metrics {
                rmse: self.rmse,
                weighted_quantile_losses: self.weighted_quantile_losses,
                error_metrics: self.error_metrics,
                average_weighted_quantile_loss: self.average_weighted_quantile_loss,
            }
        }
    }
}
impl Metrics {
    /// Creates a new builder-style object to manufacture [`Metrics`](crate::model::Metrics)
    pub fn builder() -> crate::model::metrics::Builder {
        crate::model::metrics::Builder::default()
    }
}

/// <p> Provides detailed error metrics to evaluate the performance of a predictor. This object is part of the <code>Metrics</code> object. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorMetric {
    /// <p> The Forecast type used to compute WAPE, MAPE, MASE, and RMSE. </p>
    pub forecast_type: std::option::Option<std::string::String>,
    /// <p> The weighted absolute percentage error (WAPE). </p>
    pub wape: std::option::Option<f64>,
    /// <p> The root-mean-square error (RMSE). </p>
    pub rmse: std::option::Option<f64>,
    /// <p>The Mean Absolute Scaled Error (MASE)</p>
    pub mase: std::option::Option<f64>,
    /// <p>The Mean Absolute Percentage Error (MAPE)</p>
    pub mape: std::option::Option<f64>,
}
impl ErrorMetric {
    /// <p> The Forecast type used to compute WAPE, MAPE, MASE, and RMSE. </p>
    pub fn forecast_type(&self) -> std::option::Option<&str> {
        self.forecast_type.as_deref()
    }
    /// <p> The weighted absolute percentage error (WAPE). </p>
    pub fn wape(&self) -> std::option::Option<f64> {
        self.wape
    }
    /// <p> The root-mean-square error (RMSE). </p>
    pub fn rmse(&self) -> std::option::Option<f64> {
        self.rmse
    }
    /// <p>The Mean Absolute Scaled Error (MASE)</p>
    pub fn mase(&self) -> std::option::Option<f64> {
        self.mase
    }
    /// <p>The Mean Absolute Percentage Error (MAPE)</p>
    pub fn mape(&self) -> std::option::Option<f64> {
        self.mape
    }
}
impl std::fmt::Debug for ErrorMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorMetric");
        formatter.field("forecast_type", &self.forecast_type);
        formatter.field("wape", &self.wape);
        formatter.field("rmse", &self.rmse);
        formatter.field("mase", &self.mase);
        formatter.field("mape", &self.mape);
        formatter.finish()
    }
}
/// See [`ErrorMetric`](crate::model::ErrorMetric)
pub mod error_metric {
    /// A builder for [`ErrorMetric`](crate::model::ErrorMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_type: std::option::Option<std::string::String>,
        pub(crate) wape: std::option::Option<f64>,
        pub(crate) rmse: std::option::Option<f64>,
        pub(crate) mase: std::option::Option<f64>,
        pub(crate) mape: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The Forecast type used to compute WAPE, MAPE, MASE, and RMSE. </p>
        pub fn forecast_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_type = Some(input.into());
            self
        }
        /// <p> The Forecast type used to compute WAPE, MAPE, MASE, and RMSE. </p>
        pub fn set_forecast_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_type = input;
            self
        }
        /// <p> The weighted absolute percentage error (WAPE). </p>
        pub fn wape(mut self, input: f64) -> Self {
            self.wape = Some(input);
            self
        }
        /// <p> The weighted absolute percentage error (WAPE). </p>
        pub fn set_wape(mut self, input: std::option::Option<f64>) -> Self {
            self.wape = input;
            self
        }
        /// <p> The root-mean-square error (RMSE). </p>
        pub fn rmse(mut self, input: f64) -> Self {
            self.rmse = Some(input);
            self
        }
        /// <p> The root-mean-square error (RMSE). </p>
        pub fn set_rmse(mut self, input: std::option::Option<f64>) -> Self {
            self.rmse = input;
            self
        }
        /// <p>The Mean Absolute Scaled Error (MASE)</p>
        pub fn mase(mut self, input: f64) -> Self {
            self.mase = Some(input);
            self
        }
        /// <p>The Mean Absolute Scaled Error (MASE)</p>
        pub fn set_mase(mut self, input: std::option::Option<f64>) -> Self {
            self.mase = input;
            self
        }
        /// <p>The Mean Absolute Percentage Error (MAPE)</p>
        pub fn mape(mut self, input: f64) -> Self {
            self.mape = Some(input);
            self
        }
        /// <p>The Mean Absolute Percentage Error (MAPE)</p>
        pub fn set_mape(mut self, input: std::option::Option<f64>) -> Self {
            self.mape = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorMetric`](crate::model::ErrorMetric)
        pub fn build(self) -> crate::model::ErrorMetric {
            crate::model::ErrorMetric {
                forecast_type: self.forecast_type,
                wape: self.wape,
                rmse: self.rmse,
                mase: self.mase,
                mape: self.mape,
            }
        }
    }
}
impl ErrorMetric {
    /// Creates a new builder-style object to manufacture [`ErrorMetric`](crate::model::ErrorMetric)
    pub fn builder() -> crate::model::error_metric::Builder {
        crate::model::error_metric::Builder::default()
    }
}

/// <p>The weighted loss value for a quantile. This object is part of the <code>Metrics</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WeightedQuantileLoss {
    /// <p>The quantile. Quantiles divide a probability distribution into regions of equal probability. For example, if the distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.</p>
    pub quantile: std::option::Option<f64>,
    /// <p>The difference between the predicted value and the actual value over the quantile, weighted (normalized) by dividing by the sum over all quantiles.</p>
    pub loss_value: std::option::Option<f64>,
}
impl WeightedQuantileLoss {
    /// <p>The quantile. Quantiles divide a probability distribution into regions of equal probability. For example, if the distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.</p>
    pub fn quantile(&self) -> std::option::Option<f64> {
        self.quantile
    }
    /// <p>The difference between the predicted value and the actual value over the quantile, weighted (normalized) by dividing by the sum over all quantiles.</p>
    pub fn loss_value(&self) -> std::option::Option<f64> {
        self.loss_value
    }
}
impl std::fmt::Debug for WeightedQuantileLoss {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WeightedQuantileLoss");
        formatter.field("quantile", &self.quantile);
        formatter.field("loss_value", &self.loss_value);
        formatter.finish()
    }
}
/// See [`WeightedQuantileLoss`](crate::model::WeightedQuantileLoss)
pub mod weighted_quantile_loss {
    /// A builder for [`WeightedQuantileLoss`](crate::model::WeightedQuantileLoss)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantile: std::option::Option<f64>,
        pub(crate) loss_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The quantile. Quantiles divide a probability distribution into regions of equal probability. For example, if the distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.</p>
        pub fn quantile(mut self, input: f64) -> Self {
            self.quantile = Some(input);
            self
        }
        /// <p>The quantile. Quantiles divide a probability distribution into regions of equal probability. For example, if the distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.</p>
        pub fn set_quantile(mut self, input: std::option::Option<f64>) -> Self {
            self.quantile = input;
            self
        }
        /// <p>The difference between the predicted value and the actual value over the quantile, weighted (normalized) by dividing by the sum over all quantiles.</p>
        pub fn loss_value(mut self, input: f64) -> Self {
            self.loss_value = Some(input);
            self
        }
        /// <p>The difference between the predicted value and the actual value over the quantile, weighted (normalized) by dividing by the sum over all quantiles.</p>
        pub fn set_loss_value(mut self, input: std::option::Option<f64>) -> Self {
            self.loss_value = input;
            self
        }
        /// Consumes the builder and constructs a [`WeightedQuantileLoss`](crate::model::WeightedQuantileLoss)
        pub fn build(self) -> crate::model::WeightedQuantileLoss {
            crate::model::WeightedQuantileLoss {
                quantile: self.quantile,
                loss_value: self.loss_value,
            }
        }
    }
}
impl WeightedQuantileLoss {
    /// Creates a new builder-style object to manufacture [`WeightedQuantileLoss`](crate::model::WeightedQuantileLoss)
    pub fn builder() -> crate::model::weighted_quantile_loss::Builder {
        crate::model::weighted_quantile_loss::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EvaluationType {
    #[allow(missing_docs)] // documentation missing in model
    Computed,
    #[allow(missing_docs)] // documentation missing in model
    Summary,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EvaluationType {
    fn from(s: &str) -> Self {
        match s {
            "COMPUTED" => EvaluationType::Computed,
            "SUMMARY" => EvaluationType::Summary,
            other => EvaluationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EvaluationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EvaluationType::from(s))
    }
}
impl EvaluationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EvaluationType::Computed => "COMPUTED",
            EvaluationType::Summary => "SUMMARY",
            EvaluationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPUTED", "SUMMARY"]
    }
}
impl AsRef<str> for EvaluationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details on the backtests performed to evaluate the accuracy of the predictor. The tests are returned in descending order of accuracy, with the most accurate backtest appearing first. You specify the number of backtests to perform when you call the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictorExecutionDetails {
    /// <p>An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
    pub predictor_executions: std::option::Option<std::vec::Vec<crate::model::PredictorExecution>>,
}
impl PredictorExecutionDetails {
    /// <p>An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
    pub fn predictor_executions(&self) -> std::option::Option<&[crate::model::PredictorExecution]> {
        self.predictor_executions.as_deref()
    }
}
impl std::fmt::Debug for PredictorExecutionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictorExecutionDetails");
        formatter.field("predictor_executions", &self.predictor_executions);
        formatter.finish()
    }
}
/// See [`PredictorExecutionDetails`](crate::model::PredictorExecutionDetails)
pub mod predictor_execution_details {
    /// A builder for [`PredictorExecutionDetails`](crate::model::PredictorExecutionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_executions:
            std::option::Option<std::vec::Vec<crate::model::PredictorExecution>>,
    }
    impl Builder {
        /// Appends an item to `predictor_executions`.
        ///
        /// To override the contents of this collection use [`set_predictor_executions`](Self::set_predictor_executions).
        ///
        /// <p>An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
        pub fn predictor_executions(mut self, input: crate::model::PredictorExecution) -> Self {
            let mut v = self.predictor_executions.unwrap_or_default();
            v.push(input);
            self.predictor_executions = Some(v);
            self
        }
        /// <p>An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
        pub fn set_predictor_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PredictorExecution>>,
        ) -> Self {
            self.predictor_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictorExecutionDetails`](crate::model::PredictorExecutionDetails)
        pub fn build(self) -> crate::model::PredictorExecutionDetails {
            crate::model::PredictorExecutionDetails {
                predictor_executions: self.predictor_executions,
            }
        }
    }
}
impl PredictorExecutionDetails {
    /// Creates a new builder-style object to manufacture [`PredictorExecutionDetails`](crate::model::PredictorExecutionDetails)
    pub fn builder() -> crate::model::predictor_execution_details::Builder {
        crate::model::predictor_execution_details::Builder::default()
    }
}

/// <p>The algorithm used to perform a backtest and the status of those tests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictorExecution {
    /// <p>The ARN of the algorithm used to test the predictor.</p>
    pub algorithm_arn: std::option::Option<std::string::String>,
    /// <p>An array of test windows used to evaluate the algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
    pub test_windows: std::option::Option<std::vec::Vec<crate::model::TestWindowSummary>>,
}
impl PredictorExecution {
    /// <p>The ARN of the algorithm used to test the predictor.</p>
    pub fn algorithm_arn(&self) -> std::option::Option<&str> {
        self.algorithm_arn.as_deref()
    }
    /// <p>An array of test windows used to evaluate the algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
    pub fn test_windows(&self) -> std::option::Option<&[crate::model::TestWindowSummary]> {
        self.test_windows.as_deref()
    }
}
impl std::fmt::Debug for PredictorExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictorExecution");
        formatter.field("algorithm_arn", &self.algorithm_arn);
        formatter.field("test_windows", &self.test_windows);
        formatter.finish()
    }
}
/// See [`PredictorExecution`](crate::model::PredictorExecution)
pub mod predictor_execution {
    /// A builder for [`PredictorExecution`](crate::model::PredictorExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_arn: std::option::Option<std::string::String>,
        pub(crate) test_windows:
            std::option::Option<std::vec::Vec<crate::model::TestWindowSummary>>,
    }
    impl Builder {
        /// <p>The ARN of the algorithm used to test the predictor.</p>
        pub fn algorithm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the algorithm used to test the predictor.</p>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_arn = input;
            self
        }
        /// Appends an item to `test_windows`.
        ///
        /// To override the contents of this collection use [`set_test_windows`](Self::set_test_windows).
        ///
        /// <p>An array of test windows used to evaluate the algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
        pub fn test_windows(mut self, input: crate::model::TestWindowSummary) -> Self {
            let mut v = self.test_windows.unwrap_or_default();
            v.push(input);
            self.test_windows = Some(v);
            self
        }
        /// <p>An array of test windows used to evaluate the algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>
        pub fn set_test_windows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestWindowSummary>>,
        ) -> Self {
            self.test_windows = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictorExecution`](crate::model::PredictorExecution)
        pub fn build(self) -> crate::model::PredictorExecution {
            crate::model::PredictorExecution {
                algorithm_arn: self.algorithm_arn,
                test_windows: self.test_windows,
            }
        }
    }
}
impl PredictorExecution {
    /// Creates a new builder-style object to manufacture [`PredictorExecution`](crate::model::PredictorExecution)
    pub fn builder() -> crate::model::predictor_execution::Builder {
        crate::model::predictor_execution::Builder::default()
    }
}

/// <p>The status, start time, and end time of a backtest, as well as a failure reason if applicable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestWindowSummary {
    /// <p>The time at which the test began.</p>
    pub test_window_start: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the test ended.</p>
    pub test_window_end: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the test. Possible status values are:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>CREATE_FAILED</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If the test failed, the reason why it failed.</p>
    pub message: std::option::Option<std::string::String>,
}
impl TestWindowSummary {
    /// <p>The time at which the test began.</p>
    pub fn test_window_start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.test_window_start.as_ref()
    }
    /// <p>The time at which the test ended.</p>
    pub fn test_window_end(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.test_window_end.as_ref()
    }
    /// <p>The status of the test. Possible status values are:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>CREATE_FAILED</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If the test failed, the reason why it failed.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for TestWindowSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestWindowSummary");
        formatter.field("test_window_start", &self.test_window_start);
        formatter.field("test_window_end", &self.test_window_end);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`TestWindowSummary`](crate::model::TestWindowSummary)
pub mod test_window_summary {
    /// A builder for [`TestWindowSummary`](crate::model::TestWindowSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_window_start: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) test_window_end: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time at which the test began.</p>
        pub fn test_window_start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.test_window_start = Some(input);
            self
        }
        /// <p>The time at which the test began.</p>
        pub fn set_test_window_start(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.test_window_start = input;
            self
        }
        /// <p>The time at which the test ended.</p>
        pub fn test_window_end(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.test_window_end = Some(input);
            self
        }
        /// <p>The time at which the test ended.</p>
        pub fn set_test_window_end(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.test_window_end = input;
            self
        }
        /// <p>The status of the test. Possible status values are:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>CREATE_FAILED</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the test. Possible status values are:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>CREATE_FAILED</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If the test failed, the reason why it failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If the test failed, the reason why it failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TestWindowSummary`](crate::model::TestWindowSummary)
        pub fn build(self) -> crate::model::TestWindowSummary {
            crate::model::TestWindowSummary {
                test_window_start: self.test_window_start,
                test_window_end: self.test_window_end,
                status: self.status,
                message: self.message,
            }
        }
    }
}
impl TestWindowSummary {
    /// Creates a new builder-style object to manufacture [`TestWindowSummary`](crate::model::TestWindowSummary)
    pub fn builder() -> crate::model::test_window_summary::Builder {
        crate::model::test_window_summary::Builder::default()
    }
}

/// <p>An AWS Key Management Service (KMS) key and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key. You can specify this optional object in the <code>CreateDataset</code> and <code>CreatePredictor</code> requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfig {
    /// <p>The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.</p>
    /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl EncryptionConfig {
    /// <p>The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.</p>
    /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the KMS key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for EncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfig");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`EncryptionConfig`](crate::model::EncryptionConfig)
pub mod encryption_config {
    /// A builder for [`EncryptionConfig`](crate::model::EncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.</p>
        /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.</p>
        /// <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an <code>InvalidInputException</code> error.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfig`](crate::model::EncryptionConfig)
        pub fn build(self) -> crate::model::EncryptionConfig {
            crate::model::EncryptionConfig {
                role_arn: self.role_arn,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl EncryptionConfig {
    /// Creates a new builder-style object to manufacture [`EncryptionConfig`](crate::model::EncryptionConfig)
    pub fn builder() -> crate::model::encryption_config::Builder {
        crate::model::encryption_config::Builder::default()
    }
}

/// <note>
/// <p>This object belongs to the <code>CreatePredictor</code> operation. If you created your predictor with <code>CreateAutoPredictor</code>, see <code>AttributeConfig</code>.</p>
/// </note>
/// <p>In a <code>CreatePredictor</code> operation, the specified algorithm trains a model using the specified dataset group. You can optionally tell the operation to modify data fields prior to training a model. These modifications are referred to as <i>featurization</i>.</p>
/// <p>You define featurization using the <code>FeaturizationConfig</code> object. You specify an array of transformations, one for each field that you want to featurize. You then include the <code>FeaturizationConfig</code> object in your <code>CreatePredictor</code> request. Amazon Forecast applies the featurization to the <code>TARGET_TIME_SERIES</code> and <code>RELATED_TIME_SERIES</code> datasets before model training.</p>
/// <p>You can create multiple featurization configurations. For example, you might call the <code>CreatePredictor</code> operation twice by specifying different featurization configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeaturizationConfig {
    /// <p>The frequency of predictions in a forecast.</p>
    /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min" indicates every five minutes.</p>
    /// <p>The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.</p>
    /// <p>When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset frequency.</p>
    pub forecast_frequency: std::option::Option<std::string::String>,
    /// <p>An array of dimension (field) names that specify how to group the generated forecast.</p>
    /// <p>For example, suppose that you are generating a forecast for item sales across all of your stores, and your dataset contains a <code>store_id</code> field. If you want the sales forecast for each item by store, you would specify <code>store_id</code> as the dimension.</p>
    /// <p>All forecast dimensions specified in the <code>TARGET_TIME_SERIES</code> dataset don't need to be specified in the <code>CreatePredictor</code> request. All forecast dimensions specified in the <code>RELATED_TIME_SERIES</code> dataset must be specified in the <code>CreatePredictor</code> request.</p>
    pub forecast_dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of featurization (transformation) information for the fields of a dataset.</p>
    pub featurizations: std::option::Option<std::vec::Vec<crate::model::Featurization>>,
}
impl FeaturizationConfig {
    /// <p>The frequency of predictions in a forecast.</p>
    /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min" indicates every five minutes.</p>
    /// <p>The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.</p>
    /// <p>When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset frequency.</p>
    pub fn forecast_frequency(&self) -> std::option::Option<&str> {
        self.forecast_frequency.as_deref()
    }
    /// <p>An array of dimension (field) names that specify how to group the generated forecast.</p>
    /// <p>For example, suppose that you are generating a forecast for item sales across all of your stores, and your dataset contains a <code>store_id</code> field. If you want the sales forecast for each item by store, you would specify <code>store_id</code> as the dimension.</p>
    /// <p>All forecast dimensions specified in the <code>TARGET_TIME_SERIES</code> dataset don't need to be specified in the <code>CreatePredictor</code> request. All forecast dimensions specified in the <code>RELATED_TIME_SERIES</code> dataset must be specified in the <code>CreatePredictor</code> request.</p>
    pub fn forecast_dimensions(&self) -> std::option::Option<&[std::string::String]> {
        self.forecast_dimensions.as_deref()
    }
    /// <p>An array of featurization (transformation) information for the fields of a dataset.</p>
    pub fn featurizations(&self) -> std::option::Option<&[crate::model::Featurization]> {
        self.featurizations.as_deref()
    }
}
impl std::fmt::Debug for FeaturizationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeaturizationConfig");
        formatter.field("forecast_frequency", &self.forecast_frequency);
        formatter.field("forecast_dimensions", &self.forecast_dimensions);
        formatter.field("featurizations", &self.featurizations);
        formatter.finish()
    }
}
/// See [`FeaturizationConfig`](crate::model::FeaturizationConfig)
pub mod featurization_config {
    /// A builder for [`FeaturizationConfig`](crate::model::FeaturizationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_frequency: std::option::Option<std::string::String>,
        pub(crate) forecast_dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) featurizations: std::option::Option<std::vec::Vec<crate::model::Featurization>>,
    }
    impl Builder {
        /// <p>The frequency of predictions in a forecast.</p>
        /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min" indicates every five minutes.</p>
        /// <p>The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.</p>
        /// <p>When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset frequency.</p>
        pub fn forecast_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_frequency = Some(input.into());
            self
        }
        /// <p>The frequency of predictions in a forecast.</p>
        /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min" indicates every five minutes.</p>
        /// <p>The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.</p>
        /// <p>When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset frequency.</p>
        pub fn set_forecast_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_frequency = input;
            self
        }
        /// Appends an item to `forecast_dimensions`.
        ///
        /// To override the contents of this collection use [`set_forecast_dimensions`](Self::set_forecast_dimensions).
        ///
        /// <p>An array of dimension (field) names that specify how to group the generated forecast.</p>
        /// <p>For example, suppose that you are generating a forecast for item sales across all of your stores, and your dataset contains a <code>store_id</code> field. If you want the sales forecast for each item by store, you would specify <code>store_id</code> as the dimension.</p>
        /// <p>All forecast dimensions specified in the <code>TARGET_TIME_SERIES</code> dataset don't need to be specified in the <code>CreatePredictor</code> request. All forecast dimensions specified in the <code>RELATED_TIME_SERIES</code> dataset must be specified in the <code>CreatePredictor</code> request.</p>
        pub fn forecast_dimensions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.forecast_dimensions.unwrap_or_default();
            v.push(input.into());
            self.forecast_dimensions = Some(v);
            self
        }
        /// <p>An array of dimension (field) names that specify how to group the generated forecast.</p>
        /// <p>For example, suppose that you are generating a forecast for item sales across all of your stores, and your dataset contains a <code>store_id</code> field. If you want the sales forecast for each item by store, you would specify <code>store_id</code> as the dimension.</p>
        /// <p>All forecast dimensions specified in the <code>TARGET_TIME_SERIES</code> dataset don't need to be specified in the <code>CreatePredictor</code> request. All forecast dimensions specified in the <code>RELATED_TIME_SERIES</code> dataset must be specified in the <code>CreatePredictor</code> request.</p>
        pub fn set_forecast_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.forecast_dimensions = input;
            self
        }
        /// Appends an item to `featurizations`.
        ///
        /// To override the contents of this collection use [`set_featurizations`](Self::set_featurizations).
        ///
        /// <p>An array of featurization (transformation) information for the fields of a dataset.</p>
        pub fn featurizations(mut self, input: crate::model::Featurization) -> Self {
            let mut v = self.featurizations.unwrap_or_default();
            v.push(input);
            self.featurizations = Some(v);
            self
        }
        /// <p>An array of featurization (transformation) information for the fields of a dataset.</p>
        pub fn set_featurizations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Featurization>>,
        ) -> Self {
            self.featurizations = input;
            self
        }
        /// Consumes the builder and constructs a [`FeaturizationConfig`](crate::model::FeaturizationConfig)
        pub fn build(self) -> crate::model::FeaturizationConfig {
            crate::model::FeaturizationConfig {
                forecast_frequency: self.forecast_frequency,
                forecast_dimensions: self.forecast_dimensions,
                featurizations: self.featurizations,
            }
        }
    }
}
impl FeaturizationConfig {
    /// Creates a new builder-style object to manufacture [`FeaturizationConfig`](crate::model::FeaturizationConfig)
    pub fn builder() -> crate::model::featurization_config::Builder {
        crate::model::featurization_config::Builder::default()
    }
}

/// <note>
/// <p>This object belongs to the <code>CreatePredictor</code> operation. If you created your predictor with <code>CreateAutoPredictor</code>, see <code>AttributeConfig</code>.</p>
/// </note>
/// <p>Provides featurization (transformation) information for a dataset field. This object is part of the <code>FeaturizationConfig</code> object.</p>
/// <p>For example:</p>
/// <p> <code>{</code> </p>
/// <p> <code>"AttributeName": "demand",</code> </p>
/// <p> <code>FeaturizationPipeline [ {</code> </p>
/// <p> <code>"FeaturizationMethodName": "filling",</code> </p>
/// <p> <code>"FeaturizationMethodParameters": {"aggregation": "avg", "backfill": "nan"}</code> </p>
/// <p> <code>} ]</code> </p>
/// <p> <code>}</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Featurization {
    /// <p>The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code> datasets. For example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the <code>CUSTOM</code> domain, the target is <code>target_value</code>. For more information, see <code>howitworks-missing-values</code>.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.</p>
    pub featurization_pipeline:
        std::option::Option<std::vec::Vec<crate::model::FeaturizationMethod>>,
}
impl Featurization {
    /// <p>The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code> datasets. For example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the <code>CUSTOM</code> domain, the target is <code>target_value</code>. For more information, see <code>howitworks-missing-values</code>.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.</p>
    pub fn featurization_pipeline(
        &self,
    ) -> std::option::Option<&[crate::model::FeaturizationMethod]> {
        self.featurization_pipeline.as_deref()
    }
}
impl std::fmt::Debug for Featurization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Featurization");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("featurization_pipeline", &self.featurization_pipeline);
        formatter.finish()
    }
}
/// See [`Featurization`](crate::model::Featurization)
pub mod featurization {
    /// A builder for [`Featurization`](crate::model::Featurization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) featurization_pipeline:
            std::option::Option<std::vec::Vec<crate::model::FeaturizationMethod>>,
    }
    impl Builder {
        /// <p>The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code> datasets. For example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the <code>CUSTOM</code> domain, the target is <code>target_value</code>. For more information, see <code>howitworks-missing-values</code>.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code> datasets. For example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the <code>CUSTOM</code> domain, the target is <code>target_value</code>. For more information, see <code>howitworks-missing-values</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `featurization_pipeline`.
        ///
        /// To override the contents of this collection use [`set_featurization_pipeline`](Self::set_featurization_pipeline).
        ///
        /// <p>An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.</p>
        pub fn featurization_pipeline(mut self, input: crate::model::FeaturizationMethod) -> Self {
            let mut v = self.featurization_pipeline.unwrap_or_default();
            v.push(input);
            self.featurization_pipeline = Some(v);
            self
        }
        /// <p>An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.</p>
        pub fn set_featurization_pipeline(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeaturizationMethod>>,
        ) -> Self {
            self.featurization_pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`Featurization`](crate::model::Featurization)
        pub fn build(self) -> crate::model::Featurization {
            crate::model::Featurization {
                attribute_name: self.attribute_name,
                featurization_pipeline: self.featurization_pipeline,
            }
        }
    }
}
impl Featurization {
    /// Creates a new builder-style object to manufacture [`Featurization`](crate::model::Featurization)
    pub fn builder() -> crate::model::featurization::Builder {
        crate::model::featurization::Builder::default()
    }
}

/// <p>Provides information about the method that featurizes (transforms) a dataset field. The method is part of the <code>FeaturizationPipeline</code> of the <code>Featurization</code> object. </p>
/// <p>The following is an example of how you specify a <code>FeaturizationMethod</code> object.</p>
/// <p> <code>{</code> </p>
/// <p> <code>"FeaturizationMethodName": "filling",</code> </p>
/// <p> <code>"FeaturizationMethodParameters": {"aggregation": "sum", "middlefill": "zero", "backfill": "zero"}</code> </p>
/// <p> <code>}</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeaturizationMethod {
    /// <p>The name of the method. The "filling" method is the only supported method.</p>
    pub featurization_method_name: std::option::Option<crate::model::FeaturizationMethodName>,
    /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
    /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Bold signifies the default value.</p>
    /// <ul>
    /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
    /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
    /// <ul>
    /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
    pub featurization_method_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl FeaturizationMethod {
    /// <p>The name of the method. The "filling" method is the only supported method.</p>
    pub fn featurization_method_name(
        &self,
    ) -> std::option::Option<&crate::model::FeaturizationMethodName> {
        self.featurization_method_name.as_ref()
    }
    /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
    /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Bold signifies the default value.</p>
    /// <ul>
    /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
    /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
    /// <ul>
    /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
    pub fn featurization_method_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.featurization_method_parameters.as_ref()
    }
}
impl std::fmt::Debug for FeaturizationMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeaturizationMethod");
        formatter.field("featurization_method_name", &self.featurization_method_name);
        formatter.field(
            "featurization_method_parameters",
            &self.featurization_method_parameters,
        );
        formatter.finish()
    }
}
/// See [`FeaturizationMethod`](crate::model::FeaturizationMethod)
pub mod featurization_method {
    /// A builder for [`FeaturizationMethod`](crate::model::FeaturizationMethod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) featurization_method_name:
            std::option::Option<crate::model::FeaturizationMethodName>,
        pub(crate) featurization_method_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the method. The "filling" method is the only supported method.</p>
        pub fn featurization_method_name(
            mut self,
            input: crate::model::FeaturizationMethodName,
        ) -> Self {
            self.featurization_method_name = Some(input);
            self
        }
        /// <p>The name of the method. The "filling" method is the only supported method.</p>
        pub fn set_featurization_method_name(
            mut self,
            input: std::option::Option<crate::model::FeaturizationMethodName>,
        ) -> Self {
            self.featurization_method_name = input;
            self
        }
        /// Adds a key-value pair to `featurization_method_parameters`.
        ///
        /// To override the contents of this collection use [`set_featurization_method_parameters`](Self::set_featurization_method_parameters).
        ///
        /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
        /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Bold signifies the default value.</p>
        /// <ul>
        /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
        /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
        /// <ul>
        /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
        pub fn featurization_method_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.featurization_method_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.featurization_method_parameters = Some(hash_map);
            self
        }
        /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
        /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Bold signifies the default value.</p>
        /// <ul>
        /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
        /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
        /// <ul>
        /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
        pub fn set_featurization_method_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.featurization_method_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`FeaturizationMethod`](crate::model::FeaturizationMethod)
        pub fn build(self) -> crate::model::FeaturizationMethod {
            crate::model::FeaturizationMethod {
                featurization_method_name: self.featurization_method_name,
                featurization_method_parameters: self.featurization_method_parameters,
            }
        }
    }
}
impl FeaturizationMethod {
    /// Creates a new builder-style object to manufacture [`FeaturizationMethod`](crate::model::FeaturizationMethod)
    pub fn builder() -> crate::model::featurization_method::Builder {
        crate::model::featurization_method::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeaturizationMethodName {
    #[allow(missing_docs)] // documentation missing in model
    Filling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeaturizationMethodName {
    fn from(s: &str) -> Self {
        match s {
            "filling" => FeaturizationMethodName::Filling,
            other => FeaturizationMethodName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeaturizationMethodName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeaturizationMethodName::from(s))
    }
}
impl FeaturizationMethodName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeaturizationMethodName::Filling => "filling",
            FeaturizationMethodName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["filling"]
    }
}
impl AsRef<str> for FeaturizationMethodName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This object belongs to the <code>CreatePredictor</code> operation. If you created your predictor with <code>CreateAutoPredictor</code>, see <code>DataConfig</code>.</p>
/// </note>
/// <p>The data used to train a predictor. The data includes a dataset group and any supplementary features. You specify this object in the <code>CreatePredictor</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDataConfig {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>An array of supplementary features. The only supported feature is a holiday calendar.</p>
    pub supplementary_features:
        std::option::Option<std::vec::Vec<crate::model::SupplementaryFeature>>,
}
impl InputDataConfig {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>An array of supplementary features. The only supported feature is a holiday calendar.</p>
    pub fn supplementary_features(
        &self,
    ) -> std::option::Option<&[crate::model::SupplementaryFeature]> {
        self.supplementary_features.as_deref()
    }
}
impl std::fmt::Debug for InputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDataConfig");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("supplementary_features", &self.supplementary_features);
        formatter.finish()
    }
}
/// See [`InputDataConfig`](crate::model::InputDataConfig)
pub mod input_data_config {
    /// A builder for [`InputDataConfig`](crate::model::InputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) supplementary_features:
            std::option::Option<std::vec::Vec<crate::model::SupplementaryFeature>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// Appends an item to `supplementary_features`.
        ///
        /// To override the contents of this collection use [`set_supplementary_features`](Self::set_supplementary_features).
        ///
        /// <p>An array of supplementary features. The only supported feature is a holiday calendar.</p>
        pub fn supplementary_features(mut self, input: crate::model::SupplementaryFeature) -> Self {
            let mut v = self.supplementary_features.unwrap_or_default();
            v.push(input);
            self.supplementary_features = Some(v);
            self
        }
        /// <p>An array of supplementary features. The only supported feature is a holiday calendar.</p>
        pub fn set_supplementary_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupplementaryFeature>>,
        ) -> Self {
            self.supplementary_features = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDataConfig`](crate::model::InputDataConfig)
        pub fn build(self) -> crate::model::InputDataConfig {
            crate::model::InputDataConfig {
                dataset_group_arn: self.dataset_group_arn,
                supplementary_features: self.supplementary_features,
            }
        }
    }
}
impl InputDataConfig {
    /// Creates a new builder-style object to manufacture [`InputDataConfig`](crate::model::InputDataConfig)
    pub fn builder() -> crate::model::input_data_config::Builder {
        crate::model::input_data_config::Builder::default()
    }
}

/// <note>
/// <p>This object belongs to the <code>CreatePredictor</code> operation. If you created your predictor with <code>CreateAutoPredictor</code>, see <code>AdditionalDataset</code>.</p>
/// </note>
/// <p>Describes a supplementary feature of a dataset group. This object is part of the <code>InputDataConfig</code> object. Forecast supports the Weather Index and Holidays built-in featurizations.</p>
/// <p> <b>Weather Index</b> </p>
/// <p>The Amazon Forecast Weather Index is a built-in featurization that incorporates historical and projected weather information into your model. The Weather Index supplements your datasets with over two years of historical weather data and up to 14 days of projected weather data. For more information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/weather.html">Amazon Forecast Weather Index</a>.</p>
/// <p> <b>Holidays</b> </p>
/// <p>Holidays is a built-in featurization that incorporates a feature-engineered dataset of national holiday information into your model. It provides native support for the holiday calendars of 66 countries. To view the holiday calendars, refer to the <a href="http://jollyday.sourceforge.net/data.html">Jollyday</a> library. For more information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/holidays.html">Holidays Featurization</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SupplementaryFeature {
    /// <p>The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> <b>Weather Index</b> </p>
    /// <p>To enable the Weather Index, set the value to <code>"true"</code> </p>
    /// <p> <b>Holidays</b> </p>
    /// <p>To enable Holidays, specify a country with one of the following two-letter country codes:</p>
    /// <ul>
    /// <li> <p>"AL" - ALBANIA</p> </li>
    /// <li> <p>"AR" - ARGENTINA</p> </li>
    /// <li> <p>"AT" - AUSTRIA</p> </li>
    /// <li> <p>"AU" - AUSTRALIA</p> </li>
    /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
    /// <li> <p>"BE" - BELGIUM</p> </li>
    /// <li> <p>"BG" - BULGARIA</p> </li>
    /// <li> <p>"BO" - BOLIVIA</p> </li>
    /// <li> <p>"BR" - BRAZIL</p> </li>
    /// <li> <p>"BY" - BELARUS</p> </li>
    /// <li> <p>"CA" - CANADA</p> </li>
    /// <li> <p>"CL" - CHILE</p> </li>
    /// <li> <p>"CO" - COLOMBIA</p> </li>
    /// <li> <p>"CR" - COSTA RICA</p> </li>
    /// <li> <p>"HR" - CROATIA</p> </li>
    /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
    /// <li> <p>"DK" - DENMARK</p> </li>
    /// <li> <p>"EC" - ECUADOR</p> </li>
    /// <li> <p>"EE" - ESTONIA</p> </li>
    /// <li> <p>"ET" - ETHIOPIA</p> </li>
    /// <li> <p>"FI" - FINLAND</p> </li>
    /// <li> <p>"FR" - FRANCE</p> </li>
    /// <li> <p>"DE" - GERMANY</p> </li>
    /// <li> <p>"GR" - GREECE</p> </li>
    /// <li> <p>"HU" - HUNGARY</p> </li>
    /// <li> <p>"IS" - ICELAND</p> </li>
    /// <li> <p>"IN" - INDIA</p> </li>
    /// <li> <p>"IE" - IRELAND</p> </li>
    /// <li> <p>"IT" - ITALY</p> </li>
    /// <li> <p>"JP" - JAPAN</p> </li>
    /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
    /// <li> <p>"KR" - KOREA</p> </li>
    /// <li> <p>"LV" - LATVIA</p> </li>
    /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
    /// <li> <p>"LT" - LITHUANIA</p> </li>
    /// <li> <p>"LU" - LUXEMBOURG</p> </li>
    /// <li> <p>"MK" - MACEDONIA</p> </li>
    /// <li> <p>"MT" - MALTA</p> </li>
    /// <li> <p>"MX" - MEXICO</p> </li>
    /// <li> <p>"MD" - MOLDOVA</p> </li>
    /// <li> <p>"ME" - MONTENEGRO</p> </li>
    /// <li> <p>"NL" - NETHERLANDS</p> </li>
    /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
    /// <li> <p>"NI" - NICARAGUA</p> </li>
    /// <li> <p>"NG" - NIGERIA</p> </li>
    /// <li> <p>"NO" - NORWAY</p> </li>
    /// <li> <p>"PA" - PANAMA</p> </li>
    /// <li> <p>"PY" - PARAGUAY</p> </li>
    /// <li> <p>"PE" - PERU</p> </li>
    /// <li> <p>"PL" - POLAND</p> </li>
    /// <li> <p>"PT" - PORTUGAL</p> </li>
    /// <li> <p>"RO" - ROMANIA</p> </li>
    /// <li> <p>"RU" - RUSSIA</p> </li>
    /// <li> <p>"RS" - SERBIA</p> </li>
    /// <li> <p>"SK" - SLOVAKIA</p> </li>
    /// <li> <p>"SI" - SLOVENIA</p> </li>
    /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
    /// <li> <p>"ES" - SPAIN</p> </li>
    /// <li> <p>"SE" - SWEDEN</p> </li>
    /// <li> <p>"CH" - SWITZERLAND</p> </li>
    /// <li> <p>"UA" - UKRAINE</p> </li>
    /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
    /// <li> <p>"US" - UNITED STATES</p> </li>
    /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
    /// <li> <p>"UY" - URUGUAY</p> </li>
    /// <li> <p>"VE" - VENEZUELA</p> </li>
    /// </ul>
    pub value: std::option::Option<std::string::String>,
}
impl SupplementaryFeature {
    /// <p>The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> <b>Weather Index</b> </p>
    /// <p>To enable the Weather Index, set the value to <code>"true"</code> </p>
    /// <p> <b>Holidays</b> </p>
    /// <p>To enable Holidays, specify a country with one of the following two-letter country codes:</p>
    /// <ul>
    /// <li> <p>"AL" - ALBANIA</p> </li>
    /// <li> <p>"AR" - ARGENTINA</p> </li>
    /// <li> <p>"AT" - AUSTRIA</p> </li>
    /// <li> <p>"AU" - AUSTRALIA</p> </li>
    /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
    /// <li> <p>"BE" - BELGIUM</p> </li>
    /// <li> <p>"BG" - BULGARIA</p> </li>
    /// <li> <p>"BO" - BOLIVIA</p> </li>
    /// <li> <p>"BR" - BRAZIL</p> </li>
    /// <li> <p>"BY" - BELARUS</p> </li>
    /// <li> <p>"CA" - CANADA</p> </li>
    /// <li> <p>"CL" - CHILE</p> </li>
    /// <li> <p>"CO" - COLOMBIA</p> </li>
    /// <li> <p>"CR" - COSTA RICA</p> </li>
    /// <li> <p>"HR" - CROATIA</p> </li>
    /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
    /// <li> <p>"DK" - DENMARK</p> </li>
    /// <li> <p>"EC" - ECUADOR</p> </li>
    /// <li> <p>"EE" - ESTONIA</p> </li>
    /// <li> <p>"ET" - ETHIOPIA</p> </li>
    /// <li> <p>"FI" - FINLAND</p> </li>
    /// <li> <p>"FR" - FRANCE</p> </li>
    /// <li> <p>"DE" - GERMANY</p> </li>
    /// <li> <p>"GR" - GREECE</p> </li>
    /// <li> <p>"HU" - HUNGARY</p> </li>
    /// <li> <p>"IS" - ICELAND</p> </li>
    /// <li> <p>"IN" - INDIA</p> </li>
    /// <li> <p>"IE" - IRELAND</p> </li>
    /// <li> <p>"IT" - ITALY</p> </li>
    /// <li> <p>"JP" - JAPAN</p> </li>
    /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
    /// <li> <p>"KR" - KOREA</p> </li>
    /// <li> <p>"LV" - LATVIA</p> </li>
    /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
    /// <li> <p>"LT" - LITHUANIA</p> </li>
    /// <li> <p>"LU" - LUXEMBOURG</p> </li>
    /// <li> <p>"MK" - MACEDONIA</p> </li>
    /// <li> <p>"MT" - MALTA</p> </li>
    /// <li> <p>"MX" - MEXICO</p> </li>
    /// <li> <p>"MD" - MOLDOVA</p> </li>
    /// <li> <p>"ME" - MONTENEGRO</p> </li>
    /// <li> <p>"NL" - NETHERLANDS</p> </li>
    /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
    /// <li> <p>"NI" - NICARAGUA</p> </li>
    /// <li> <p>"NG" - NIGERIA</p> </li>
    /// <li> <p>"NO" - NORWAY</p> </li>
    /// <li> <p>"PA" - PANAMA</p> </li>
    /// <li> <p>"PY" - PARAGUAY</p> </li>
    /// <li> <p>"PE" - PERU</p> </li>
    /// <li> <p>"PL" - POLAND</p> </li>
    /// <li> <p>"PT" - PORTUGAL</p> </li>
    /// <li> <p>"RO" - ROMANIA</p> </li>
    /// <li> <p>"RU" - RUSSIA</p> </li>
    /// <li> <p>"RS" - SERBIA</p> </li>
    /// <li> <p>"SK" - SLOVAKIA</p> </li>
    /// <li> <p>"SI" - SLOVENIA</p> </li>
    /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
    /// <li> <p>"ES" - SPAIN</p> </li>
    /// <li> <p>"SE" - SWEDEN</p> </li>
    /// <li> <p>"CH" - SWITZERLAND</p> </li>
    /// <li> <p>"UA" - UKRAINE</p> </li>
    /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
    /// <li> <p>"US" - UNITED STATES</p> </li>
    /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
    /// <li> <p>"UY" - URUGUAY</p> </li>
    /// <li> <p>"VE" - VENEZUELA</p> </li>
    /// </ul>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SupplementaryFeature {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SupplementaryFeature");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SupplementaryFeature`](crate::model::SupplementaryFeature)
pub mod supplementary_feature {
    /// A builder for [`SupplementaryFeature`](crate::model::SupplementaryFeature)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> <b>Weather Index</b> </p>
        /// <p>To enable the Weather Index, set the value to <code>"true"</code> </p>
        /// <p> <b>Holidays</b> </p>
        /// <p>To enable Holidays, specify a country with one of the following two-letter country codes:</p>
        /// <ul>
        /// <li> <p>"AL" - ALBANIA</p> </li>
        /// <li> <p>"AR" - ARGENTINA</p> </li>
        /// <li> <p>"AT" - AUSTRIA</p> </li>
        /// <li> <p>"AU" - AUSTRALIA</p> </li>
        /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
        /// <li> <p>"BE" - BELGIUM</p> </li>
        /// <li> <p>"BG" - BULGARIA</p> </li>
        /// <li> <p>"BO" - BOLIVIA</p> </li>
        /// <li> <p>"BR" - BRAZIL</p> </li>
        /// <li> <p>"BY" - BELARUS</p> </li>
        /// <li> <p>"CA" - CANADA</p> </li>
        /// <li> <p>"CL" - CHILE</p> </li>
        /// <li> <p>"CO" - COLOMBIA</p> </li>
        /// <li> <p>"CR" - COSTA RICA</p> </li>
        /// <li> <p>"HR" - CROATIA</p> </li>
        /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
        /// <li> <p>"DK" - DENMARK</p> </li>
        /// <li> <p>"EC" - ECUADOR</p> </li>
        /// <li> <p>"EE" - ESTONIA</p> </li>
        /// <li> <p>"ET" - ETHIOPIA</p> </li>
        /// <li> <p>"FI" - FINLAND</p> </li>
        /// <li> <p>"FR" - FRANCE</p> </li>
        /// <li> <p>"DE" - GERMANY</p> </li>
        /// <li> <p>"GR" - GREECE</p> </li>
        /// <li> <p>"HU" - HUNGARY</p> </li>
        /// <li> <p>"IS" - ICELAND</p> </li>
        /// <li> <p>"IN" - INDIA</p> </li>
        /// <li> <p>"IE" - IRELAND</p> </li>
        /// <li> <p>"IT" - ITALY</p> </li>
        /// <li> <p>"JP" - JAPAN</p> </li>
        /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
        /// <li> <p>"KR" - KOREA</p> </li>
        /// <li> <p>"LV" - LATVIA</p> </li>
        /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
        /// <li> <p>"LT" - LITHUANIA</p> </li>
        /// <li> <p>"LU" - LUXEMBOURG</p> </li>
        /// <li> <p>"MK" - MACEDONIA</p> </li>
        /// <li> <p>"MT" - MALTA</p> </li>
        /// <li> <p>"MX" - MEXICO</p> </li>
        /// <li> <p>"MD" - MOLDOVA</p> </li>
        /// <li> <p>"ME" - MONTENEGRO</p> </li>
        /// <li> <p>"NL" - NETHERLANDS</p> </li>
        /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
        /// <li> <p>"NI" - NICARAGUA</p> </li>
        /// <li> <p>"NG" - NIGERIA</p> </li>
        /// <li> <p>"NO" - NORWAY</p> </li>
        /// <li> <p>"PA" - PANAMA</p> </li>
        /// <li> <p>"PY" - PARAGUAY</p> </li>
        /// <li> <p>"PE" - PERU</p> </li>
        /// <li> <p>"PL" - POLAND</p> </li>
        /// <li> <p>"PT" - PORTUGAL</p> </li>
        /// <li> <p>"RO" - ROMANIA</p> </li>
        /// <li> <p>"RU" - RUSSIA</p> </li>
        /// <li> <p>"RS" - SERBIA</p> </li>
        /// <li> <p>"SK" - SLOVAKIA</p> </li>
        /// <li> <p>"SI" - SLOVENIA</p> </li>
        /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
        /// <li> <p>"ES" - SPAIN</p> </li>
        /// <li> <p>"SE" - SWEDEN</p> </li>
        /// <li> <p>"CH" - SWITZERLAND</p> </li>
        /// <li> <p>"UA" - UKRAINE</p> </li>
        /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
        /// <li> <p>"US" - UNITED STATES</p> </li>
        /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
        /// <li> <p>"UY" - URUGUAY</p> </li>
        /// <li> <p>"VE" - VENEZUELA</p> </li>
        /// </ul>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> <b>Weather Index</b> </p>
        /// <p>To enable the Weather Index, set the value to <code>"true"</code> </p>
        /// <p> <b>Holidays</b> </p>
        /// <p>To enable Holidays, specify a country with one of the following two-letter country codes:</p>
        /// <ul>
        /// <li> <p>"AL" - ALBANIA</p> </li>
        /// <li> <p>"AR" - ARGENTINA</p> </li>
        /// <li> <p>"AT" - AUSTRIA</p> </li>
        /// <li> <p>"AU" - AUSTRALIA</p> </li>
        /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
        /// <li> <p>"BE" - BELGIUM</p> </li>
        /// <li> <p>"BG" - BULGARIA</p> </li>
        /// <li> <p>"BO" - BOLIVIA</p> </li>
        /// <li> <p>"BR" - BRAZIL</p> </li>
        /// <li> <p>"BY" - BELARUS</p> </li>
        /// <li> <p>"CA" - CANADA</p> </li>
        /// <li> <p>"CL" - CHILE</p> </li>
        /// <li> <p>"CO" - COLOMBIA</p> </li>
        /// <li> <p>"CR" - COSTA RICA</p> </li>
        /// <li> <p>"HR" - CROATIA</p> </li>
        /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
        /// <li> <p>"DK" - DENMARK</p> </li>
        /// <li> <p>"EC" - ECUADOR</p> </li>
        /// <li> <p>"EE" - ESTONIA</p> </li>
        /// <li> <p>"ET" - ETHIOPIA</p> </li>
        /// <li> <p>"FI" - FINLAND</p> </li>
        /// <li> <p>"FR" - FRANCE</p> </li>
        /// <li> <p>"DE" - GERMANY</p> </li>
        /// <li> <p>"GR" - GREECE</p> </li>
        /// <li> <p>"HU" - HUNGARY</p> </li>
        /// <li> <p>"IS" - ICELAND</p> </li>
        /// <li> <p>"IN" - INDIA</p> </li>
        /// <li> <p>"IE" - IRELAND</p> </li>
        /// <li> <p>"IT" - ITALY</p> </li>
        /// <li> <p>"JP" - JAPAN</p> </li>
        /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
        /// <li> <p>"KR" - KOREA</p> </li>
        /// <li> <p>"LV" - LATVIA</p> </li>
        /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
        /// <li> <p>"LT" - LITHUANIA</p> </li>
        /// <li> <p>"LU" - LUXEMBOURG</p> </li>
        /// <li> <p>"MK" - MACEDONIA</p> </li>
        /// <li> <p>"MT" - MALTA</p> </li>
        /// <li> <p>"MX" - MEXICO</p> </li>
        /// <li> <p>"MD" - MOLDOVA</p> </li>
        /// <li> <p>"ME" - MONTENEGRO</p> </li>
        /// <li> <p>"NL" - NETHERLANDS</p> </li>
        /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
        /// <li> <p>"NI" - NICARAGUA</p> </li>
        /// <li> <p>"NG" - NIGERIA</p> </li>
        /// <li> <p>"NO" - NORWAY</p> </li>
        /// <li> <p>"PA" - PANAMA</p> </li>
        /// <li> <p>"PY" - PARAGUAY</p> </li>
        /// <li> <p>"PE" - PERU</p> </li>
        /// <li> <p>"PL" - POLAND</p> </li>
        /// <li> <p>"PT" - PORTUGAL</p> </li>
        /// <li> <p>"RO" - ROMANIA</p> </li>
        /// <li> <p>"RU" - RUSSIA</p> </li>
        /// <li> <p>"RS" - SERBIA</p> </li>
        /// <li> <p>"SK" - SLOVAKIA</p> </li>
        /// <li> <p>"SI" - SLOVENIA</p> </li>
        /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
        /// <li> <p>"ES" - SPAIN</p> </li>
        /// <li> <p>"SE" - SWEDEN</p> </li>
        /// <li> <p>"CH" - SWITZERLAND</p> </li>
        /// <li> <p>"UA" - UKRAINE</p> </li>
        /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
        /// <li> <p>"US" - UNITED STATES</p> </li>
        /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
        /// <li> <p>"UY" - URUGUAY</p> </li>
        /// <li> <p>"VE" - VENEZUELA</p> </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SupplementaryFeature`](crate::model::SupplementaryFeature)
        pub fn build(self) -> crate::model::SupplementaryFeature {
            crate::model::SupplementaryFeature {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SupplementaryFeature {
    /// Creates a new builder-style object to manufacture [`SupplementaryFeature`](crate::model::SupplementaryFeature)
    pub fn builder() -> crate::model::supplementary_feature::Builder {
        crate::model::supplementary_feature::Builder::default()
    }
}

/// <p>Configuration information for a hyperparameter tuning job. You specify this object in the <code>CreatePredictor</code> request.</p>
/// <p>A <i>hyperparameter</i> is a parameter that governs the model training process. You set hyperparameters before training starts, unlike model parameters, which are determined during training. The values of the hyperparameters effect which values are chosen for the model parameters.</p>
/// <p>In a <i>hyperparameter tuning job</i>, Amazon Forecast chooses the set of hyperparameter values that optimize a specified metric. Forecast accomplishes this by running many training jobs over a range of hyperparameter values. The optimum set of values depends on the algorithm, the training data, and the specified metric objective.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HyperParameterTuningJobConfig {
    /// <p>Specifies the ranges of valid values for the hyperparameters.</p>
    pub parameter_ranges: std::option::Option<crate::model::ParameterRanges>,
}
impl HyperParameterTuningJobConfig {
    /// <p>Specifies the ranges of valid values for the hyperparameters.</p>
    pub fn parameter_ranges(&self) -> std::option::Option<&crate::model::ParameterRanges> {
        self.parameter_ranges.as_ref()
    }
}
impl std::fmt::Debug for HyperParameterTuningJobConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HyperParameterTuningJobConfig");
        formatter.field("parameter_ranges", &self.parameter_ranges);
        formatter.finish()
    }
}
/// See [`HyperParameterTuningJobConfig`](crate::model::HyperParameterTuningJobConfig)
pub mod hyper_parameter_tuning_job_config {
    /// A builder for [`HyperParameterTuningJobConfig`](crate::model::HyperParameterTuningJobConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_ranges: std::option::Option<crate::model::ParameterRanges>,
    }
    impl Builder {
        /// <p>Specifies the ranges of valid values for the hyperparameters.</p>
        pub fn parameter_ranges(mut self, input: crate::model::ParameterRanges) -> Self {
            self.parameter_ranges = Some(input);
            self
        }
        /// <p>Specifies the ranges of valid values for the hyperparameters.</p>
        pub fn set_parameter_ranges(
            mut self,
            input: std::option::Option<crate::model::ParameterRanges>,
        ) -> Self {
            self.parameter_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`HyperParameterTuningJobConfig`](crate::model::HyperParameterTuningJobConfig)
        pub fn build(self) -> crate::model::HyperParameterTuningJobConfig {
            crate::model::HyperParameterTuningJobConfig {
                parameter_ranges: self.parameter_ranges,
            }
        }
    }
}
impl HyperParameterTuningJobConfig {
    /// Creates a new builder-style object to manufacture [`HyperParameterTuningJobConfig`](crate::model::HyperParameterTuningJobConfig)
    pub fn builder() -> crate::model::hyper_parameter_tuning_job_config::Builder {
        crate::model::hyper_parameter_tuning_job_config::Builder::default()
    }
}

/// <p>Specifies the categorical, continuous, and integer hyperparameters, and their ranges of tunable values. The range of tunable values determines which values that a hyperparameter tuning job can choose for the specified hyperparameter. This object is part of the <code>HyperParameterTuningJobConfig</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterRanges {
    /// <p>Specifies the tunable range for each categorical hyperparameter.</p>
    pub categorical_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::CategoricalParameterRange>>,
    /// <p>Specifies the tunable range for each continuous hyperparameter.</p>
    pub continuous_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::ContinuousParameterRange>>,
    /// <p>Specifies the tunable range for each integer hyperparameter.</p>
    pub integer_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::IntegerParameterRange>>,
}
impl ParameterRanges {
    /// <p>Specifies the tunable range for each categorical hyperparameter.</p>
    pub fn categorical_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::CategoricalParameterRange]> {
        self.categorical_parameter_ranges.as_deref()
    }
    /// <p>Specifies the tunable range for each continuous hyperparameter.</p>
    pub fn continuous_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::ContinuousParameterRange]> {
        self.continuous_parameter_ranges.as_deref()
    }
    /// <p>Specifies the tunable range for each integer hyperparameter.</p>
    pub fn integer_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::IntegerParameterRange]> {
        self.integer_parameter_ranges.as_deref()
    }
}
impl std::fmt::Debug for ParameterRanges {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterRanges");
        formatter.field(
            "categorical_parameter_ranges",
            &self.categorical_parameter_ranges,
        );
        formatter.field(
            "continuous_parameter_ranges",
            &self.continuous_parameter_ranges,
        );
        formatter.field("integer_parameter_ranges", &self.integer_parameter_ranges);
        formatter.finish()
    }
}
/// See [`ParameterRanges`](crate::model::ParameterRanges)
pub mod parameter_ranges {
    /// A builder for [`ParameterRanges`](crate::model::ParameterRanges)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) categorical_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::CategoricalParameterRange>>,
        pub(crate) continuous_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::ContinuousParameterRange>>,
        pub(crate) integer_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::IntegerParameterRange>>,
    }
    impl Builder {
        /// Appends an item to `categorical_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_categorical_parameter_ranges`](Self::set_categorical_parameter_ranges).
        ///
        /// <p>Specifies the tunable range for each categorical hyperparameter.</p>
        pub fn categorical_parameter_ranges(
            mut self,
            input: crate::model::CategoricalParameterRange,
        ) -> Self {
            let mut v = self.categorical_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.categorical_parameter_ranges = Some(v);
            self
        }
        /// <p>Specifies the tunable range for each categorical hyperparameter.</p>
        pub fn set_categorical_parameter_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CategoricalParameterRange>>,
        ) -> Self {
            self.categorical_parameter_ranges = input;
            self
        }
        /// Appends an item to `continuous_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_continuous_parameter_ranges`](Self::set_continuous_parameter_ranges).
        ///
        /// <p>Specifies the tunable range for each continuous hyperparameter.</p>
        pub fn continuous_parameter_ranges(
            mut self,
            input: crate::model::ContinuousParameterRange,
        ) -> Self {
            let mut v = self.continuous_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.continuous_parameter_ranges = Some(v);
            self
        }
        /// <p>Specifies the tunable range for each continuous hyperparameter.</p>
        pub fn set_continuous_parameter_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContinuousParameterRange>>,
        ) -> Self {
            self.continuous_parameter_ranges = input;
            self
        }
        /// Appends an item to `integer_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_integer_parameter_ranges`](Self::set_integer_parameter_ranges).
        ///
        /// <p>Specifies the tunable range for each integer hyperparameter.</p>
        pub fn integer_parameter_ranges(
            mut self,
            input: crate::model::IntegerParameterRange,
        ) -> Self {
            let mut v = self.integer_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.integer_parameter_ranges = Some(v);
            self
        }
        /// <p>Specifies the tunable range for each integer hyperparameter.</p>
        pub fn set_integer_parameter_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntegerParameterRange>>,
        ) -> Self {
            self.integer_parameter_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterRanges`](crate::model::ParameterRanges)
        pub fn build(self) -> crate::model::ParameterRanges {
            crate::model::ParameterRanges {
                categorical_parameter_ranges: self.categorical_parameter_ranges,
                continuous_parameter_ranges: self.continuous_parameter_ranges,
                integer_parameter_ranges: self.integer_parameter_ranges,
            }
        }
    }
}
impl ParameterRanges {
    /// Creates a new builder-style object to manufacture [`ParameterRanges`](crate::model::ParameterRanges)
    pub fn builder() -> crate::model::parameter_ranges::Builder {
        crate::model::parameter_ranges::Builder::default()
    }
}

/// <p>Specifies an integer hyperparameter and it's range of tunable values. This object is part of the <code>ParameterRanges</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntegerParameterRange {
    /// <p>The name of the hyperparameter to tune.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum tunable value of the hyperparameter.</p>
    pub max_value: std::option::Option<i32>,
    /// <p>The minimum tunable value of the hyperparameter.</p>
    pub min_value: std::option::Option<i32>,
    /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
    /// <dl>
    /// <dt>
    /// Auto
    /// </dt>
    /// <dd>
    /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
    /// </dd>
    /// <dt>
    /// Linear
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
    /// </dd>
    /// <dt>
    /// Logarithmic
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
    /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
    /// </dd>
    /// <dt>
    /// ReverseLogarithmic
    /// </dt>
    /// <dd>
    /// <p>Not supported for <code>IntegerParameterRange</code>.</p>
    /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
    /// </dd>
    /// </dl>
    /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
    pub scaling_type: std::option::Option<crate::model::ScalingType>,
}
impl IntegerParameterRange {
    /// <p>The name of the hyperparameter to tune.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum tunable value of the hyperparameter.</p>
    pub fn max_value(&self) -> std::option::Option<i32> {
        self.max_value
    }
    /// <p>The minimum tunable value of the hyperparameter.</p>
    pub fn min_value(&self) -> std::option::Option<i32> {
        self.min_value
    }
    /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
    /// <dl>
    /// <dt>
    /// Auto
    /// </dt>
    /// <dd>
    /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
    /// </dd>
    /// <dt>
    /// Linear
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
    /// </dd>
    /// <dt>
    /// Logarithmic
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
    /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
    /// </dd>
    /// <dt>
    /// ReverseLogarithmic
    /// </dt>
    /// <dd>
    /// <p>Not supported for <code>IntegerParameterRange</code>.</p>
    /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
    /// </dd>
    /// </dl>
    /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
    pub fn scaling_type(&self) -> std::option::Option<&crate::model::ScalingType> {
        self.scaling_type.as_ref()
    }
}
impl std::fmt::Debug for IntegerParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntegerParameterRange");
        formatter.field("name", &self.name);
        formatter.field("max_value", &self.max_value);
        formatter.field("min_value", &self.min_value);
        formatter.field("scaling_type", &self.scaling_type);
        formatter.finish()
    }
}
/// See [`IntegerParameterRange`](crate::model::IntegerParameterRange)
pub mod integer_parameter_range {
    /// A builder for [`IntegerParameterRange`](crate::model::IntegerParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max_value: std::option::Option<i32>,
        pub(crate) min_value: std::option::Option<i32>,
        pub(crate) scaling_type: std::option::Option<crate::model::ScalingType>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter to tune.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter to tune.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum tunable value of the hyperparameter.</p>
        pub fn max_value(mut self, input: i32) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>The maximum tunable value of the hyperparameter.</p>
        pub fn set_max_value(mut self, input: std::option::Option<i32>) -> Self {
            self.max_value = input;
            self
        }
        /// <p>The minimum tunable value of the hyperparameter.</p>
        pub fn min_value(mut self, input: i32) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>The minimum tunable value of the hyperparameter.</p>
        pub fn set_min_value(mut self, input: std::option::Option<i32>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
        /// <dl>
        /// <dt>
        /// Auto
        /// </dt>
        /// <dd>
        /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
        /// </dd>
        /// <dt>
        /// Linear
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
        /// </dd>
        /// <dt>
        /// Logarithmic
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
        /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
        /// </dd>
        /// <dt>
        /// ReverseLogarithmic
        /// </dt>
        /// <dd>
        /// <p>Not supported for <code>IntegerParameterRange</code>.</p>
        /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
        /// </dd>
        /// </dl>
        /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
        pub fn scaling_type(mut self, input: crate::model::ScalingType) -> Self {
            self.scaling_type = Some(input);
            self
        }
        /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
        /// <dl>
        /// <dt>
        /// Auto
        /// </dt>
        /// <dd>
        /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
        /// </dd>
        /// <dt>
        /// Linear
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
        /// </dd>
        /// <dt>
        /// Logarithmic
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
        /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
        /// </dd>
        /// <dt>
        /// ReverseLogarithmic
        /// </dt>
        /// <dd>
        /// <p>Not supported for <code>IntegerParameterRange</code>.</p>
        /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
        /// </dd>
        /// </dl>
        /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
        pub fn set_scaling_type(
            mut self,
            input: std::option::Option<crate::model::ScalingType>,
        ) -> Self {
            self.scaling_type = input;
            self
        }
        /// Consumes the builder and constructs a [`IntegerParameterRange`](crate::model::IntegerParameterRange)
        pub fn build(self) -> crate::model::IntegerParameterRange {
            crate::model::IntegerParameterRange {
                name: self.name,
                max_value: self.max_value,
                min_value: self.min_value,
                scaling_type: self.scaling_type,
            }
        }
    }
}
impl IntegerParameterRange {
    /// Creates a new builder-style object to manufacture [`IntegerParameterRange`](crate::model::IntegerParameterRange)
    pub fn builder() -> crate::model::integer_parameter_range::Builder {
        crate::model::integer_parameter_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingType {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Linear,
    #[allow(missing_docs)] // documentation missing in model
    Logarithmic,
    #[allow(missing_docs)] // documentation missing in model
    ReverseLogarithmic,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingType {
    fn from(s: &str) -> Self {
        match s {
            "Auto" => ScalingType::Auto,
            "Linear" => ScalingType::Linear,
            "Logarithmic" => ScalingType::Logarithmic,
            "ReverseLogarithmic" => ScalingType::ReverseLogarithmic,
            other => ScalingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingType::from(s))
    }
}
impl ScalingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingType::Auto => "Auto",
            ScalingType::Linear => "Linear",
            ScalingType::Logarithmic => "Logarithmic",
            ScalingType::ReverseLogarithmic => "ReverseLogarithmic",
            ScalingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Auto", "Linear", "Logarithmic", "ReverseLogarithmic"]
    }
}
impl AsRef<str> for ScalingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a continuous hyperparameter and it's range of tunable values. This object is part of the <code>ParameterRanges</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinuousParameterRange {
    /// <p>The name of the hyperparameter to tune.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum tunable value of the hyperparameter.</p>
    pub max_value: std::option::Option<f64>,
    /// <p>The minimum tunable value of the hyperparameter.</p>
    pub min_value: std::option::Option<f64>,
    /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
    /// <dl>
    /// <dt>
    /// Auto
    /// </dt>
    /// <dd>
    /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
    /// </dd>
    /// <dt>
    /// Linear
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
    /// </dd>
    /// <dt>
    /// Logarithmic
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
    /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
    /// </dd>
    /// <dt>
    /// ReverseLogarithmic
    /// </dt>
    /// <dd>
    /// <p>hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p>
    /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
    /// </dd>
    /// </dl>
    /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
    pub scaling_type: std::option::Option<crate::model::ScalingType>,
}
impl ContinuousParameterRange {
    /// <p>The name of the hyperparameter to tune.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum tunable value of the hyperparameter.</p>
    pub fn max_value(&self) -> std::option::Option<f64> {
        self.max_value
    }
    /// <p>The minimum tunable value of the hyperparameter.</p>
    pub fn min_value(&self) -> std::option::Option<f64> {
        self.min_value
    }
    /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
    /// <dl>
    /// <dt>
    /// Auto
    /// </dt>
    /// <dd>
    /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
    /// </dd>
    /// <dt>
    /// Linear
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
    /// </dd>
    /// <dt>
    /// Logarithmic
    /// </dt>
    /// <dd>
    /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
    /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
    /// </dd>
    /// <dt>
    /// ReverseLogarithmic
    /// </dt>
    /// <dd>
    /// <p>hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p>
    /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
    /// </dd>
    /// </dl>
    /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
    pub fn scaling_type(&self) -> std::option::Option<&crate::model::ScalingType> {
        self.scaling_type.as_ref()
    }
}
impl std::fmt::Debug for ContinuousParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinuousParameterRange");
        formatter.field("name", &self.name);
        formatter.field("max_value", &self.max_value);
        formatter.field("min_value", &self.min_value);
        formatter.field("scaling_type", &self.scaling_type);
        formatter.finish()
    }
}
/// See [`ContinuousParameterRange`](crate::model::ContinuousParameterRange)
pub mod continuous_parameter_range {
    /// A builder for [`ContinuousParameterRange`](crate::model::ContinuousParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max_value: std::option::Option<f64>,
        pub(crate) min_value: std::option::Option<f64>,
        pub(crate) scaling_type: std::option::Option<crate::model::ScalingType>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter to tune.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter to tune.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum tunable value of the hyperparameter.</p>
        pub fn max_value(mut self, input: f64) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>The maximum tunable value of the hyperparameter.</p>
        pub fn set_max_value(mut self, input: std::option::Option<f64>) -> Self {
            self.max_value = input;
            self
        }
        /// <p>The minimum tunable value of the hyperparameter.</p>
        pub fn min_value(mut self, input: f64) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>The minimum tunable value of the hyperparameter.</p>
        pub fn set_min_value(mut self, input: std::option::Option<f64>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
        /// <dl>
        /// <dt>
        /// Auto
        /// </dt>
        /// <dd>
        /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
        /// </dd>
        /// <dt>
        /// Linear
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
        /// </dd>
        /// <dt>
        /// Logarithmic
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
        /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
        /// </dd>
        /// <dt>
        /// ReverseLogarithmic
        /// </dt>
        /// <dd>
        /// <p>hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p>
        /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
        /// </dd>
        /// </dl>
        /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
        pub fn scaling_type(mut self, input: crate::model::ScalingType) -> Self {
            self.scaling_type = Some(input);
            self
        }
        /// <p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
        /// <dl>
        /// <dt>
        /// Auto
        /// </dt>
        /// <dd>
        /// <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p>
        /// </dd>
        /// <dt>
        /// Linear
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p>
        /// </dd>
        /// <dt>
        /// Logarithmic
        /// </dt>
        /// <dd>
        /// <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p>
        /// <p>Logarithmic scaling works only for ranges that have values greater than 0.</p>
        /// </dd>
        /// <dt>
        /// ReverseLogarithmic
        /// </dt>
        /// <dd>
        /// <p>hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p>
        /// <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p>
        /// </dd>
        /// </dl>
        /// <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>
        pub fn set_scaling_type(
            mut self,
            input: std::option::Option<crate::model::ScalingType>,
        ) -> Self {
            self.scaling_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinuousParameterRange`](crate::model::ContinuousParameterRange)
        pub fn build(self) -> crate::model::ContinuousParameterRange {
            crate::model::ContinuousParameterRange {
                name: self.name,
                max_value: self.max_value,
                min_value: self.min_value,
                scaling_type: self.scaling_type,
            }
        }
    }
}
impl ContinuousParameterRange {
    /// Creates a new builder-style object to manufacture [`ContinuousParameterRange`](crate::model::ContinuousParameterRange)
    pub fn builder() -> crate::model::continuous_parameter_range::Builder {
        crate::model::continuous_parameter_range::Builder::default()
    }
}

/// <p>Specifies a categorical hyperparameter and it's range of tunable values. This object is part of the <code>ParameterRanges</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CategoricalParameterRange {
    /// <p>The name of the categorical hyperparameter to tune.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the tunable categories for the hyperparameter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CategoricalParameterRange {
    /// <p>The name of the categorical hyperparameter to tune.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the tunable categories for the hyperparameter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for CategoricalParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CategoricalParameterRange");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`CategoricalParameterRange`](crate::model::CategoricalParameterRange)
pub mod categorical_parameter_range {
    /// A builder for [`CategoricalParameterRange`](crate::model::CategoricalParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the categorical hyperparameter to tune.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the categorical hyperparameter to tune.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of the tunable categories for the hyperparameter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of the tunable categories for the hyperparameter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`CategoricalParameterRange`](crate::model::CategoricalParameterRange)
        pub fn build(self) -> crate::model::CategoricalParameterRange {
            crate::model::CategoricalParameterRange {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl CategoricalParameterRange {
    /// Creates a new builder-style object to manufacture [`CategoricalParameterRange`](crate::model::CategoricalParameterRange)
    pub fn builder() -> crate::model::categorical_parameter_range::Builder {
        crate::model::categorical_parameter_range::Builder::default()
    }
}

/// <p>Parameters that define how to split a dataset into training data and testing data, and the number of iterations to perform. These parameters are specified in the predefined algorithms but you can override them in the <code>CreatePredictor</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationParameters {
    /// <p>The number of times to split the input data. The default is 1. Valid values are 1 through 5.</p>
    pub number_of_backtest_windows: std::option::Option<i32>,
    /// <p>The point from the end of the dataset where you want to split the data for model training and testing (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.</p>
    /// <p> <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES dataset length</p>
    pub back_test_window_offset: std::option::Option<i32>,
}
impl EvaluationParameters {
    /// <p>The number of times to split the input data. The default is 1. Valid values are 1 through 5.</p>
    pub fn number_of_backtest_windows(&self) -> std::option::Option<i32> {
        self.number_of_backtest_windows
    }
    /// <p>The point from the end of the dataset where you want to split the data for model training and testing (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.</p>
    /// <p> <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES dataset length</p>
    pub fn back_test_window_offset(&self) -> std::option::Option<i32> {
        self.back_test_window_offset
    }
}
impl std::fmt::Debug for EvaluationParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationParameters");
        formatter.field(
            "number_of_backtest_windows",
            &self.number_of_backtest_windows,
        );
        formatter.field("back_test_window_offset", &self.back_test_window_offset);
        formatter.finish()
    }
}
/// See [`EvaluationParameters`](crate::model::EvaluationParameters)
pub mod evaluation_parameters {
    /// A builder for [`EvaluationParameters`](crate::model::EvaluationParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_backtest_windows: std::option::Option<i32>,
        pub(crate) back_test_window_offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of times to split the input data. The default is 1. Valid values are 1 through 5.</p>
        pub fn number_of_backtest_windows(mut self, input: i32) -> Self {
            self.number_of_backtest_windows = Some(input);
            self
        }
        /// <p>The number of times to split the input data. The default is 1. Valid values are 1 through 5.</p>
        pub fn set_number_of_backtest_windows(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_backtest_windows = input;
            self
        }
        /// <p>The point from the end of the dataset where you want to split the data for model training and testing (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.</p>
        /// <p> <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES dataset length</p>
        pub fn back_test_window_offset(mut self, input: i32) -> Self {
            self.back_test_window_offset = Some(input);
            self
        }
        /// <p>The point from the end of the dataset where you want to split the data for model training and testing (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.</p>
        /// <p> <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES dataset length</p>
        pub fn set_back_test_window_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.back_test_window_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationParameters`](crate::model::EvaluationParameters)
        pub fn build(self) -> crate::model::EvaluationParameters {
            crate::model::EvaluationParameters {
                number_of_backtest_windows: self.number_of_backtest_windows,
                back_test_window_offset: self.back_test_window_offset,
            }
        }
    }
}
impl EvaluationParameters {
    /// Creates a new builder-style object to manufacture [`EvaluationParameters`](crate::model::EvaluationParameters)
    pub fn builder() -> crate::model::evaluation_parameters::Builder {
        crate::model::evaluation_parameters::Builder::default()
    }
}

/// <p>Defines the fields of a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Schema {
    /// <p>An array of attributes specifying the name and type of each field in a dataset.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::SchemaAttribute>>,
}
impl Schema {
    /// <p>An array of attributes specifying the name and type of each field in a dataset.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::SchemaAttribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for Schema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Schema");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`Schema`](crate::model::Schema)
pub mod schema {
    /// A builder for [`Schema`](crate::model::Schema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::SchemaAttribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>An array of attributes specifying the name and type of each field in a dataset.</p>
        pub fn attributes(mut self, input: crate::model::SchemaAttribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>An array of attributes specifying the name and type of each field in a dataset.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Schema`](crate::model::Schema)
        pub fn build(self) -> crate::model::Schema {
            crate::model::Schema {
                attributes: self.attributes,
            }
        }
    }
}
impl Schema {
    /// Creates a new builder-style object to manufacture [`Schema`](crate::model::Schema)
    pub fn builder() -> crate::model::schema::Builder {
        crate::model::schema::Builder::default()
    }
}

/// <p>An attribute of a schema, which defines a dataset field. A schema attribute is required for every field in a dataset. The <code>Schema</code> object contains an array of <code>SchemaAttribute</code> objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaAttribute {
    /// <p>The name of the dataset field.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The data type of the field.</p>
    pub attribute_type: std::option::Option<crate::model::AttributeType>,
}
impl SchemaAttribute {
    /// <p>The name of the dataset field.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The data type of the field.</p>
    pub fn attribute_type(&self) -> std::option::Option<&crate::model::AttributeType> {
        self.attribute_type.as_ref()
    }
}
impl std::fmt::Debug for SchemaAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaAttribute");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_type", &self.attribute_type);
        formatter.finish()
    }
}
/// See [`SchemaAttribute`](crate::model::SchemaAttribute)
pub mod schema_attribute {
    /// A builder for [`SchemaAttribute`](crate::model::SchemaAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_type: std::option::Option<crate::model::AttributeType>,
    }
    impl Builder {
        /// <p>The name of the dataset field.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset field.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The data type of the field.</p>
        pub fn attribute_type(mut self, input: crate::model::AttributeType) -> Self {
            self.attribute_type = Some(input);
            self
        }
        /// <p>The data type of the field.</p>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::AttributeType>,
        ) -> Self {
            self.attribute_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaAttribute`](crate::model::SchemaAttribute)
        pub fn build(self) -> crate::model::SchemaAttribute {
            crate::model::SchemaAttribute {
                attribute_name: self.attribute_name,
                attribute_type: self.attribute_type,
            }
        }
    }
}
impl SchemaAttribute {
    /// Creates a new builder-style object to manufacture [`SchemaAttribute`](crate::model::SchemaAttribute)
    pub fn builder() -> crate::model::schema_attribute::Builder {
        crate::model::schema_attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttributeType {
    #[allow(missing_docs)] // documentation missing in model
    Float,
    #[allow(missing_docs)] // documentation missing in model
    Geolocation,
    #[allow(missing_docs)] // documentation missing in model
    Integer,
    #[allow(missing_docs)] // documentation missing in model
    String,
    #[allow(missing_docs)] // documentation missing in model
    Timestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttributeType {
    fn from(s: &str) -> Self {
        match s {
            "float" => AttributeType::Float,
            "geolocation" => AttributeType::Geolocation,
            "integer" => AttributeType::Integer,
            "string" => AttributeType::String,
            "timestamp" => AttributeType::Timestamp,
            other => AttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttributeType::from(s))
    }
}
impl AttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttributeType::Float => "float",
            AttributeType::Geolocation => "geolocation",
            AttributeType::Integer => "integer",
            AttributeType::String => "string",
            AttributeType::Timestamp => "timestamp",
            AttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["float", "geolocation", "integer", "string", "timestamp"]
    }
}
impl AsRef<str> for AttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides statistics for each data field imported into to an Amazon Forecast dataset with the <code>CreateDatasetImportJob</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Statistics {
    /// <p>The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.</p>
    pub count: std::option::Option<i32>,
    /// <p>The number of distinct values in the field. If the response value is -1, refer to <code>CountDistinctLong</code>.</p>
    pub count_distinct: std::option::Option<i32>,
    /// <p>The number of null values in the field. If the response value is -1, refer to <code>CountNullLong</code>.</p>
    pub count_null: std::option::Option<i32>,
    /// <p>The number of NAN (not a number) values in the field. If the response value is -1, refer to <code>CountNanLong</code>.</p>
    pub count_nan: std::option::Option<i32>,
    /// <p>For a numeric field, the minimum value in the field.</p>
    pub min: std::option::Option<std::string::String>,
    /// <p>For a numeric field, the maximum value in the field.</p>
    pub max: std::option::Option<std::string::String>,
    /// <p>For a numeric field, the average value in the field.</p>
    pub avg: std::option::Option<f64>,
    /// <p>For a numeric field, the standard deviation.</p>
    pub stddev: std::option::Option<f64>,
    /// <p>The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the value is greater than 2,147,483,647.</p>
    pub count_long: std::option::Option<i64>,
    /// <p>The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of <code>CountDistinct</code> if the value is greater than 2,147,483,647.</p>
    pub count_distinct_long: std::option::Option<i64>,
    /// <p>The number of null values in the field. <code>CountNullLong</code> is used instead of <code>CountNull</code> if the value is greater than 2,147,483,647.</p>
    pub count_null_long: std::option::Option<i64>,
    /// <p>The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of <code>CountNan</code> if the value is greater than 2,147,483,647.</p>
    pub count_nan_long: std::option::Option<i64>,
}
impl Statistics {
    /// <p>The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.</p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
    /// <p>The number of distinct values in the field. If the response value is -1, refer to <code>CountDistinctLong</code>.</p>
    pub fn count_distinct(&self) -> std::option::Option<i32> {
        self.count_distinct
    }
    /// <p>The number of null values in the field. If the response value is -1, refer to <code>CountNullLong</code>.</p>
    pub fn count_null(&self) -> std::option::Option<i32> {
        self.count_null
    }
    /// <p>The number of NAN (not a number) values in the field. If the response value is -1, refer to <code>CountNanLong</code>.</p>
    pub fn count_nan(&self) -> std::option::Option<i32> {
        self.count_nan
    }
    /// <p>For a numeric field, the minimum value in the field.</p>
    pub fn min(&self) -> std::option::Option<&str> {
        self.min.as_deref()
    }
    /// <p>For a numeric field, the maximum value in the field.</p>
    pub fn max(&self) -> std::option::Option<&str> {
        self.max.as_deref()
    }
    /// <p>For a numeric field, the average value in the field.</p>
    pub fn avg(&self) -> std::option::Option<f64> {
        self.avg
    }
    /// <p>For a numeric field, the standard deviation.</p>
    pub fn stddev(&self) -> std::option::Option<f64> {
        self.stddev
    }
    /// <p>The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the value is greater than 2,147,483,647.</p>
    pub fn count_long(&self) -> std::option::Option<i64> {
        self.count_long
    }
    /// <p>The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of <code>CountDistinct</code> if the value is greater than 2,147,483,647.</p>
    pub fn count_distinct_long(&self) -> std::option::Option<i64> {
        self.count_distinct_long
    }
    /// <p>The number of null values in the field. <code>CountNullLong</code> is used instead of <code>CountNull</code> if the value is greater than 2,147,483,647.</p>
    pub fn count_null_long(&self) -> std::option::Option<i64> {
        self.count_null_long
    }
    /// <p>The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of <code>CountNan</code> if the value is greater than 2,147,483,647.</p>
    pub fn count_nan_long(&self) -> std::option::Option<i64> {
        self.count_nan_long
    }
}
impl std::fmt::Debug for Statistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Statistics");
        formatter.field("count", &self.count);
        formatter.field("count_distinct", &self.count_distinct);
        formatter.field("count_null", &self.count_null);
        formatter.field("count_nan", &self.count_nan);
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.field("avg", &self.avg);
        formatter.field("stddev", &self.stddev);
        formatter.field("count_long", &self.count_long);
        formatter.field("count_distinct_long", &self.count_distinct_long);
        formatter.field("count_null_long", &self.count_null_long);
        formatter.field("count_nan_long", &self.count_nan_long);
        formatter.finish()
    }
}
/// See [`Statistics`](crate::model::Statistics)
pub mod statistics {
    /// A builder for [`Statistics`](crate::model::Statistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i32>,
        pub(crate) count_distinct: std::option::Option<i32>,
        pub(crate) count_null: std::option::Option<i32>,
        pub(crate) count_nan: std::option::Option<i32>,
        pub(crate) min: std::option::Option<std::string::String>,
        pub(crate) max: std::option::Option<std::string::String>,
        pub(crate) avg: std::option::Option<f64>,
        pub(crate) stddev: std::option::Option<f64>,
        pub(crate) count_long: std::option::Option<i64>,
        pub(crate) count_distinct_long: std::option::Option<i64>,
        pub(crate) count_null_long: std::option::Option<i64>,
        pub(crate) count_nan_long: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The number of distinct values in the field. If the response value is -1, refer to <code>CountDistinctLong</code>.</p>
        pub fn count_distinct(mut self, input: i32) -> Self {
            self.count_distinct = Some(input);
            self
        }
        /// <p>The number of distinct values in the field. If the response value is -1, refer to <code>CountDistinctLong</code>.</p>
        pub fn set_count_distinct(mut self, input: std::option::Option<i32>) -> Self {
            self.count_distinct = input;
            self
        }
        /// <p>The number of null values in the field. If the response value is -1, refer to <code>CountNullLong</code>.</p>
        pub fn count_null(mut self, input: i32) -> Self {
            self.count_null = Some(input);
            self
        }
        /// <p>The number of null values in the field. If the response value is -1, refer to <code>CountNullLong</code>.</p>
        pub fn set_count_null(mut self, input: std::option::Option<i32>) -> Self {
            self.count_null = input;
            self
        }
        /// <p>The number of NAN (not a number) values in the field. If the response value is -1, refer to <code>CountNanLong</code>.</p>
        pub fn count_nan(mut self, input: i32) -> Self {
            self.count_nan = Some(input);
            self
        }
        /// <p>The number of NAN (not a number) values in the field. If the response value is -1, refer to <code>CountNanLong</code>.</p>
        pub fn set_count_nan(mut self, input: std::option::Option<i32>) -> Self {
            self.count_nan = input;
            self
        }
        /// <p>For a numeric field, the minimum value in the field.</p>
        pub fn min(mut self, input: impl Into<std::string::String>) -> Self {
            self.min = Some(input.into());
            self
        }
        /// <p>For a numeric field, the minimum value in the field.</p>
        pub fn set_min(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.min = input;
            self
        }
        /// <p>For a numeric field, the maximum value in the field.</p>
        pub fn max(mut self, input: impl Into<std::string::String>) -> Self {
            self.max = Some(input.into());
            self
        }
        /// <p>For a numeric field, the maximum value in the field.</p>
        pub fn set_max(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max = input;
            self
        }
        /// <p>For a numeric field, the average value in the field.</p>
        pub fn avg(mut self, input: f64) -> Self {
            self.avg = Some(input);
            self
        }
        /// <p>For a numeric field, the average value in the field.</p>
        pub fn set_avg(mut self, input: std::option::Option<f64>) -> Self {
            self.avg = input;
            self
        }
        /// <p>For a numeric field, the standard deviation.</p>
        pub fn stddev(mut self, input: f64) -> Self {
            self.stddev = Some(input);
            self
        }
        /// <p>For a numeric field, the standard deviation.</p>
        pub fn set_stddev(mut self, input: std::option::Option<f64>) -> Self {
            self.stddev = input;
            self
        }
        /// <p>The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the value is greater than 2,147,483,647.</p>
        pub fn count_long(mut self, input: i64) -> Self {
            self.count_long = Some(input);
            self
        }
        /// <p>The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the value is greater than 2,147,483,647.</p>
        pub fn set_count_long(mut self, input: std::option::Option<i64>) -> Self {
            self.count_long = input;
            self
        }
        /// <p>The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of <code>CountDistinct</code> if the value is greater than 2,147,483,647.</p>
        pub fn count_distinct_long(mut self, input: i64) -> Self {
            self.count_distinct_long = Some(input);
            self
        }
        /// <p>The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of <code>CountDistinct</code> if the value is greater than 2,147,483,647.</p>
        pub fn set_count_distinct_long(mut self, input: std::option::Option<i64>) -> Self {
            self.count_distinct_long = input;
            self
        }
        /// <p>The number of null values in the field. <code>CountNullLong</code> is used instead of <code>CountNull</code> if the value is greater than 2,147,483,647.</p>
        pub fn count_null_long(mut self, input: i64) -> Self {
            self.count_null_long = Some(input);
            self
        }
        /// <p>The number of null values in the field. <code>CountNullLong</code> is used instead of <code>CountNull</code> if the value is greater than 2,147,483,647.</p>
        pub fn set_count_null_long(mut self, input: std::option::Option<i64>) -> Self {
            self.count_null_long = input;
            self
        }
        /// <p>The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of <code>CountNan</code> if the value is greater than 2,147,483,647.</p>
        pub fn count_nan_long(mut self, input: i64) -> Self {
            self.count_nan_long = Some(input);
            self
        }
        /// <p>The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of <code>CountNan</code> if the value is greater than 2,147,483,647.</p>
        pub fn set_count_nan_long(mut self, input: std::option::Option<i64>) -> Self {
            self.count_nan_long = input;
            self
        }
        /// Consumes the builder and constructs a [`Statistics`](crate::model::Statistics)
        pub fn build(self) -> crate::model::Statistics {
            crate::model::Statistics {
                count: self.count,
                count_distinct: self.count_distinct,
                count_null: self.count_null,
                count_nan: self.count_nan,
                min: self.min,
                max: self.max,
                avg: self.avg,
                stddev: self.stddev,
                count_long: self.count_long,
                count_distinct_long: self.count_distinct_long,
                count_null_long: self.count_null_long,
                count_nan_long: self.count_nan_long,
            }
        }
    }
}
impl Statistics {
    /// Creates a new builder-style object to manufacture [`Statistics`](crate::model::Statistics)
    pub fn builder() -> crate::model::statistics::Builder {
        crate::model::statistics::Builder::default()
    }
}

/// <p>Provides information about the Explainability resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExplainabilityInfo {
    /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
    pub explainability_arn: std::option::Option<std::string::String>,
    /// <p>The status of the Explainability. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
}
impl ExplainabilityInfo {
    /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
    pub fn explainability_arn(&self) -> std::option::Option<&str> {
        self.explainability_arn.as_deref()
    }
    /// <p>The status of the Explainability. States include: </p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
    /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
    /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for ExplainabilityInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExplainabilityInfo");
        formatter.field("explainability_arn", &self.explainability_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ExplainabilityInfo`](crate::model::ExplainabilityInfo)
pub mod explainability_info {
    /// A builder for [`ExplainabilityInfo`](crate::model::ExplainabilityInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) explainability_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
        pub fn explainability_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.explainability_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Explainability.</p>
        pub fn set_explainability_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.explainability_arn = input;
            self
        }
        /// <p>The status of the Explainability. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Explainability. States include: </p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li>
        /// <li> <p> <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li>
        /// <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ExplainabilityInfo`](crate::model::ExplainabilityInfo)
        pub fn build(self) -> crate::model::ExplainabilityInfo {
            crate::model::ExplainabilityInfo {
                explainability_arn: self.explainability_arn,
                status: self.status,
            }
        }
    }
}
impl ExplainabilityInfo {
    /// Creates a new builder-style object to manufacture [`ExplainabilityInfo`](crate::model::ExplainabilityInfo)
    pub fn builder() -> crate::model::explainability_info::Builder {
        crate::model::explainability_info::Builder::default()
    }
}

/// <p>The data configuration for your dataset group and any additional datasets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataConfig {
    /// <p>The ARN of the dataset group used to train the predictor.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>Aggregation and filling options for attributes in your dataset group.</p>
    pub attribute_configs: std::option::Option<std::vec::Vec<crate::model::AttributeConfig>>,
    /// <p>Additional built-in datasets like Holidays and the Weather Index.</p>
    pub additional_datasets: std::option::Option<std::vec::Vec<crate::model::AdditionalDataset>>,
}
impl DataConfig {
    /// <p>The ARN of the dataset group used to train the predictor.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>Aggregation and filling options for attributes in your dataset group.</p>
    pub fn attribute_configs(&self) -> std::option::Option<&[crate::model::AttributeConfig]> {
        self.attribute_configs.as_deref()
    }
    /// <p>Additional built-in datasets like Holidays and the Weather Index.</p>
    pub fn additional_datasets(&self) -> std::option::Option<&[crate::model::AdditionalDataset]> {
        self.additional_datasets.as_deref()
    }
}
impl std::fmt::Debug for DataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataConfig");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("attribute_configs", &self.attribute_configs);
        formatter.field("additional_datasets", &self.additional_datasets);
        formatter.finish()
    }
}
/// See [`DataConfig`](crate::model::DataConfig)
pub mod data_config {
    /// A builder for [`DataConfig`](crate::model::DataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) attribute_configs:
            std::option::Option<std::vec::Vec<crate::model::AttributeConfig>>,
        pub(crate) additional_datasets:
            std::option::Option<std::vec::Vec<crate::model::AdditionalDataset>>,
    }
    impl Builder {
        /// <p>The ARN of the dataset group used to train the predictor.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group used to train the predictor.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// Appends an item to `attribute_configs`.
        ///
        /// To override the contents of this collection use [`set_attribute_configs`](Self::set_attribute_configs).
        ///
        /// <p>Aggregation and filling options for attributes in your dataset group.</p>
        pub fn attribute_configs(mut self, input: crate::model::AttributeConfig) -> Self {
            let mut v = self.attribute_configs.unwrap_or_default();
            v.push(input);
            self.attribute_configs = Some(v);
            self
        }
        /// <p>Aggregation and filling options for attributes in your dataset group.</p>
        pub fn set_attribute_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeConfig>>,
        ) -> Self {
            self.attribute_configs = input;
            self
        }
        /// Appends an item to `additional_datasets`.
        ///
        /// To override the contents of this collection use [`set_additional_datasets`](Self::set_additional_datasets).
        ///
        /// <p>Additional built-in datasets like Holidays and the Weather Index.</p>
        pub fn additional_datasets(mut self, input: crate::model::AdditionalDataset) -> Self {
            let mut v = self.additional_datasets.unwrap_or_default();
            v.push(input);
            self.additional_datasets = Some(v);
            self
        }
        /// <p>Additional built-in datasets like Holidays and the Weather Index.</p>
        pub fn set_additional_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdditionalDataset>>,
        ) -> Self {
            self.additional_datasets = input;
            self
        }
        /// Consumes the builder and constructs a [`DataConfig`](crate::model::DataConfig)
        pub fn build(self) -> crate::model::DataConfig {
            crate::model::DataConfig {
                dataset_group_arn: self.dataset_group_arn,
                attribute_configs: self.attribute_configs,
                additional_datasets: self.additional_datasets,
            }
        }
    }
}
impl DataConfig {
    /// Creates a new builder-style object to manufacture [`DataConfig`](crate::model::DataConfig)
    pub fn builder() -> crate::model::data_config::Builder {
        crate::model::data_config::Builder::default()
    }
}

/// <p>Describes an additional dataset. This object is part of the <code>DataConfig</code> object. Forecast supports the Weather Index and Holidays additional datasets.</p>
/// <p> <b>Weather Index</b> </p>
/// <p>The Amazon Forecast Weather Index is a built-in dataset that incorporates historical and projected weather information into your model. The Weather Index supplements your datasets with over two years of historical weather data and up to 14 days of projected weather data. For more information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/weather.html">Amazon Forecast Weather Index</a>.</p>
/// <p> <b>Holidays</b> </p>
/// <p>Holidays is a built-in dataset that incorporates national holiday information into your model. It provides native support for the holiday calendars of 66 countries. To view the holiday calendars, refer to the <a href="http://jollyday.sourceforge.net/data.html">Jollyday</a> library. For more information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/holidays.html">Holidays Featurization</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalDataset {
    /// <p>The name of the additional dataset. Valid names: <code>"holiday"</code> and <code>"weather"</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> <b>Weather Index</b> </p>
    /// <p>To enable the Weather Index, do not specify a value for <code>Configuration</code>.</p>
    /// <p> <b>Holidays</b> </p>
    /// <p>To enable Holidays, set <code>CountryCode</code> to one of the following two-letter country codes:</p>
    /// <ul>
    /// <li> <p>"AL" - ALBANIA</p> </li>
    /// <li> <p>"AR" - ARGENTINA</p> </li>
    /// <li> <p>"AT" - AUSTRIA</p> </li>
    /// <li> <p>"AU" - AUSTRALIA</p> </li>
    /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
    /// <li> <p>"BE" - BELGIUM</p> </li>
    /// <li> <p>"BG" - BULGARIA</p> </li>
    /// <li> <p>"BO" - BOLIVIA</p> </li>
    /// <li> <p>"BR" - BRAZIL</p> </li>
    /// <li> <p>"BY" - BELARUS</p> </li>
    /// <li> <p>"CA" - CANADA</p> </li>
    /// <li> <p>"CL" - CHILE</p> </li>
    /// <li> <p>"CO" - COLOMBIA</p> </li>
    /// <li> <p>"CR" - COSTA RICA</p> </li>
    /// <li> <p>"HR" - CROATIA</p> </li>
    /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
    /// <li> <p>"DK" - DENMARK</p> </li>
    /// <li> <p>"EC" - ECUADOR</p> </li>
    /// <li> <p>"EE" - ESTONIA</p> </li>
    /// <li> <p>"ET" - ETHIOPIA</p> </li>
    /// <li> <p>"FI" - FINLAND</p> </li>
    /// <li> <p>"FR" - FRANCE</p> </li>
    /// <li> <p>"DE" - GERMANY</p> </li>
    /// <li> <p>"GR" - GREECE</p> </li>
    /// <li> <p>"HU" - HUNGARY</p> </li>
    /// <li> <p>"IS" - ICELAND</p> </li>
    /// <li> <p>"IN" - INDIA</p> </li>
    /// <li> <p>"IE" - IRELAND</p> </li>
    /// <li> <p>"IT" - ITALY</p> </li>
    /// <li> <p>"JP" - JAPAN</p> </li>
    /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
    /// <li> <p>"KR" - KOREA</p> </li>
    /// <li> <p>"LV" - LATVIA</p> </li>
    /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
    /// <li> <p>"LT" - LITHUANIA</p> </li>
    /// <li> <p>"LU" - LUXEMBOURG</p> </li>
    /// <li> <p>"MK" - MACEDONIA</p> </li>
    /// <li> <p>"MT" - MALTA</p> </li>
    /// <li> <p>"MX" - MEXICO</p> </li>
    /// <li> <p>"MD" - MOLDOVA</p> </li>
    /// <li> <p>"ME" - MONTENEGRO</p> </li>
    /// <li> <p>"NL" - NETHERLANDS</p> </li>
    /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
    /// <li> <p>"NI" - NICARAGUA</p> </li>
    /// <li> <p>"NG" - NIGERIA</p> </li>
    /// <li> <p>"NO" - NORWAY</p> </li>
    /// <li> <p>"PA" - PANAMA</p> </li>
    /// <li> <p>"PY" - PARAGUAY</p> </li>
    /// <li> <p>"PE" - PERU</p> </li>
    /// <li> <p>"PL" - POLAND</p> </li>
    /// <li> <p>"PT" - PORTUGAL</p> </li>
    /// <li> <p>"RO" - ROMANIA</p> </li>
    /// <li> <p>"RU" - RUSSIA</p> </li>
    /// <li> <p>"RS" - SERBIA</p> </li>
    /// <li> <p>"SK" - SLOVAKIA</p> </li>
    /// <li> <p>"SI" - SLOVENIA</p> </li>
    /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
    /// <li> <p>"ES" - SPAIN</p> </li>
    /// <li> <p>"SE" - SWEDEN</p> </li>
    /// <li> <p>"CH" - SWITZERLAND</p> </li>
    /// <li> <p>"UA" - UKRAINE</p> </li>
    /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
    /// <li> <p>"US" - UNITED STATES</p> </li>
    /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
    /// <li> <p>"UY" - URUGUAY</p> </li>
    /// <li> <p>"VE" - VENEZUELA</p> </li>
    /// </ul>
    pub configuration: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl AdditionalDataset {
    /// <p>The name of the additional dataset. Valid names: <code>"holiday"</code> and <code>"weather"</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> <b>Weather Index</b> </p>
    /// <p>To enable the Weather Index, do not specify a value for <code>Configuration</code>.</p>
    /// <p> <b>Holidays</b> </p>
    /// <p>To enable Holidays, set <code>CountryCode</code> to one of the following two-letter country codes:</p>
    /// <ul>
    /// <li> <p>"AL" - ALBANIA</p> </li>
    /// <li> <p>"AR" - ARGENTINA</p> </li>
    /// <li> <p>"AT" - AUSTRIA</p> </li>
    /// <li> <p>"AU" - AUSTRALIA</p> </li>
    /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
    /// <li> <p>"BE" - BELGIUM</p> </li>
    /// <li> <p>"BG" - BULGARIA</p> </li>
    /// <li> <p>"BO" - BOLIVIA</p> </li>
    /// <li> <p>"BR" - BRAZIL</p> </li>
    /// <li> <p>"BY" - BELARUS</p> </li>
    /// <li> <p>"CA" - CANADA</p> </li>
    /// <li> <p>"CL" - CHILE</p> </li>
    /// <li> <p>"CO" - COLOMBIA</p> </li>
    /// <li> <p>"CR" - COSTA RICA</p> </li>
    /// <li> <p>"HR" - CROATIA</p> </li>
    /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
    /// <li> <p>"DK" - DENMARK</p> </li>
    /// <li> <p>"EC" - ECUADOR</p> </li>
    /// <li> <p>"EE" - ESTONIA</p> </li>
    /// <li> <p>"ET" - ETHIOPIA</p> </li>
    /// <li> <p>"FI" - FINLAND</p> </li>
    /// <li> <p>"FR" - FRANCE</p> </li>
    /// <li> <p>"DE" - GERMANY</p> </li>
    /// <li> <p>"GR" - GREECE</p> </li>
    /// <li> <p>"HU" - HUNGARY</p> </li>
    /// <li> <p>"IS" - ICELAND</p> </li>
    /// <li> <p>"IN" - INDIA</p> </li>
    /// <li> <p>"IE" - IRELAND</p> </li>
    /// <li> <p>"IT" - ITALY</p> </li>
    /// <li> <p>"JP" - JAPAN</p> </li>
    /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
    /// <li> <p>"KR" - KOREA</p> </li>
    /// <li> <p>"LV" - LATVIA</p> </li>
    /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
    /// <li> <p>"LT" - LITHUANIA</p> </li>
    /// <li> <p>"LU" - LUXEMBOURG</p> </li>
    /// <li> <p>"MK" - MACEDONIA</p> </li>
    /// <li> <p>"MT" - MALTA</p> </li>
    /// <li> <p>"MX" - MEXICO</p> </li>
    /// <li> <p>"MD" - MOLDOVA</p> </li>
    /// <li> <p>"ME" - MONTENEGRO</p> </li>
    /// <li> <p>"NL" - NETHERLANDS</p> </li>
    /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
    /// <li> <p>"NI" - NICARAGUA</p> </li>
    /// <li> <p>"NG" - NIGERIA</p> </li>
    /// <li> <p>"NO" - NORWAY</p> </li>
    /// <li> <p>"PA" - PANAMA</p> </li>
    /// <li> <p>"PY" - PARAGUAY</p> </li>
    /// <li> <p>"PE" - PERU</p> </li>
    /// <li> <p>"PL" - POLAND</p> </li>
    /// <li> <p>"PT" - PORTUGAL</p> </li>
    /// <li> <p>"RO" - ROMANIA</p> </li>
    /// <li> <p>"RU" - RUSSIA</p> </li>
    /// <li> <p>"RS" - SERBIA</p> </li>
    /// <li> <p>"SK" - SLOVAKIA</p> </li>
    /// <li> <p>"SI" - SLOVENIA</p> </li>
    /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
    /// <li> <p>"ES" - SPAIN</p> </li>
    /// <li> <p>"SE" - SWEDEN</p> </li>
    /// <li> <p>"CH" - SWITZERLAND</p> </li>
    /// <li> <p>"UA" - UKRAINE</p> </li>
    /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
    /// <li> <p>"US" - UNITED STATES</p> </li>
    /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
    /// <li> <p>"UY" - URUGUAY</p> </li>
    /// <li> <p>"VE" - VENEZUELA</p> </li>
    /// </ul>
    pub fn configuration(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for AdditionalDataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalDataset");
        formatter.field("name", &self.name);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`AdditionalDataset`](crate::model::AdditionalDataset)
pub mod additional_dataset {
    /// A builder for [`AdditionalDataset`](crate::model::AdditionalDataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The name of the additional dataset. Valid names: <code>"holiday"</code> and <code>"weather"</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the additional dataset. Valid names: <code>"holiday"</code> and <code>"weather"</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p> <b>Weather Index</b> </p>
        /// <p>To enable the Weather Index, do not specify a value for <code>Configuration</code>.</p>
        /// <p> <b>Holidays</b> </p>
        /// <p>To enable Holidays, set <code>CountryCode</code> to one of the following two-letter country codes:</p>
        /// <ul>
        /// <li> <p>"AL" - ALBANIA</p> </li>
        /// <li> <p>"AR" - ARGENTINA</p> </li>
        /// <li> <p>"AT" - AUSTRIA</p> </li>
        /// <li> <p>"AU" - AUSTRALIA</p> </li>
        /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
        /// <li> <p>"BE" - BELGIUM</p> </li>
        /// <li> <p>"BG" - BULGARIA</p> </li>
        /// <li> <p>"BO" - BOLIVIA</p> </li>
        /// <li> <p>"BR" - BRAZIL</p> </li>
        /// <li> <p>"BY" - BELARUS</p> </li>
        /// <li> <p>"CA" - CANADA</p> </li>
        /// <li> <p>"CL" - CHILE</p> </li>
        /// <li> <p>"CO" - COLOMBIA</p> </li>
        /// <li> <p>"CR" - COSTA RICA</p> </li>
        /// <li> <p>"HR" - CROATIA</p> </li>
        /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
        /// <li> <p>"DK" - DENMARK</p> </li>
        /// <li> <p>"EC" - ECUADOR</p> </li>
        /// <li> <p>"EE" - ESTONIA</p> </li>
        /// <li> <p>"ET" - ETHIOPIA</p> </li>
        /// <li> <p>"FI" - FINLAND</p> </li>
        /// <li> <p>"FR" - FRANCE</p> </li>
        /// <li> <p>"DE" - GERMANY</p> </li>
        /// <li> <p>"GR" - GREECE</p> </li>
        /// <li> <p>"HU" - HUNGARY</p> </li>
        /// <li> <p>"IS" - ICELAND</p> </li>
        /// <li> <p>"IN" - INDIA</p> </li>
        /// <li> <p>"IE" - IRELAND</p> </li>
        /// <li> <p>"IT" - ITALY</p> </li>
        /// <li> <p>"JP" - JAPAN</p> </li>
        /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
        /// <li> <p>"KR" - KOREA</p> </li>
        /// <li> <p>"LV" - LATVIA</p> </li>
        /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
        /// <li> <p>"LT" - LITHUANIA</p> </li>
        /// <li> <p>"LU" - LUXEMBOURG</p> </li>
        /// <li> <p>"MK" - MACEDONIA</p> </li>
        /// <li> <p>"MT" - MALTA</p> </li>
        /// <li> <p>"MX" - MEXICO</p> </li>
        /// <li> <p>"MD" - MOLDOVA</p> </li>
        /// <li> <p>"ME" - MONTENEGRO</p> </li>
        /// <li> <p>"NL" - NETHERLANDS</p> </li>
        /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
        /// <li> <p>"NI" - NICARAGUA</p> </li>
        /// <li> <p>"NG" - NIGERIA</p> </li>
        /// <li> <p>"NO" - NORWAY</p> </li>
        /// <li> <p>"PA" - PANAMA</p> </li>
        /// <li> <p>"PY" - PARAGUAY</p> </li>
        /// <li> <p>"PE" - PERU</p> </li>
        /// <li> <p>"PL" - POLAND</p> </li>
        /// <li> <p>"PT" - PORTUGAL</p> </li>
        /// <li> <p>"RO" - ROMANIA</p> </li>
        /// <li> <p>"RU" - RUSSIA</p> </li>
        /// <li> <p>"RS" - SERBIA</p> </li>
        /// <li> <p>"SK" - SLOVAKIA</p> </li>
        /// <li> <p>"SI" - SLOVENIA</p> </li>
        /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
        /// <li> <p>"ES" - SPAIN</p> </li>
        /// <li> <p>"SE" - SWEDEN</p> </li>
        /// <li> <p>"CH" - SWITZERLAND</p> </li>
        /// <li> <p>"UA" - UKRAINE</p> </li>
        /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
        /// <li> <p>"US" - UNITED STATES</p> </li>
        /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
        /// <li> <p>"UY" - URUGUAY</p> </li>
        /// <li> <p>"VE" - VENEZUELA</p> </li>
        /// </ul>
        pub fn configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.configuration.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.configuration = Some(hash_map);
            self
        }
        /// <p> <b>Weather Index</b> </p>
        /// <p>To enable the Weather Index, do not specify a value for <code>Configuration</code>.</p>
        /// <p> <b>Holidays</b> </p>
        /// <p>To enable Holidays, set <code>CountryCode</code> to one of the following two-letter country codes:</p>
        /// <ul>
        /// <li> <p>"AL" - ALBANIA</p> </li>
        /// <li> <p>"AR" - ARGENTINA</p> </li>
        /// <li> <p>"AT" - AUSTRIA</p> </li>
        /// <li> <p>"AU" - AUSTRALIA</p> </li>
        /// <li> <p>"BA" - BOSNIA HERZEGOVINA</p> </li>
        /// <li> <p>"BE" - BELGIUM</p> </li>
        /// <li> <p>"BG" - BULGARIA</p> </li>
        /// <li> <p>"BO" - BOLIVIA</p> </li>
        /// <li> <p>"BR" - BRAZIL</p> </li>
        /// <li> <p>"BY" - BELARUS</p> </li>
        /// <li> <p>"CA" - CANADA</p> </li>
        /// <li> <p>"CL" - CHILE</p> </li>
        /// <li> <p>"CO" - COLOMBIA</p> </li>
        /// <li> <p>"CR" - COSTA RICA</p> </li>
        /// <li> <p>"HR" - CROATIA</p> </li>
        /// <li> <p>"CZ" - CZECH REPUBLIC</p> </li>
        /// <li> <p>"DK" - DENMARK</p> </li>
        /// <li> <p>"EC" - ECUADOR</p> </li>
        /// <li> <p>"EE" - ESTONIA</p> </li>
        /// <li> <p>"ET" - ETHIOPIA</p> </li>
        /// <li> <p>"FI" - FINLAND</p> </li>
        /// <li> <p>"FR" - FRANCE</p> </li>
        /// <li> <p>"DE" - GERMANY</p> </li>
        /// <li> <p>"GR" - GREECE</p> </li>
        /// <li> <p>"HU" - HUNGARY</p> </li>
        /// <li> <p>"IS" - ICELAND</p> </li>
        /// <li> <p>"IN" - INDIA</p> </li>
        /// <li> <p>"IE" - IRELAND</p> </li>
        /// <li> <p>"IT" - ITALY</p> </li>
        /// <li> <p>"JP" - JAPAN</p> </li>
        /// <li> <p>"KZ" - KAZAKHSTAN</p> </li>
        /// <li> <p>"KR" - KOREA</p> </li>
        /// <li> <p>"LV" - LATVIA</p> </li>
        /// <li> <p>"LI" - LIECHTENSTEIN</p> </li>
        /// <li> <p>"LT" - LITHUANIA</p> </li>
        /// <li> <p>"LU" - LUXEMBOURG</p> </li>
        /// <li> <p>"MK" - MACEDONIA</p> </li>
        /// <li> <p>"MT" - MALTA</p> </li>
        /// <li> <p>"MX" - MEXICO</p> </li>
        /// <li> <p>"MD" - MOLDOVA</p> </li>
        /// <li> <p>"ME" - MONTENEGRO</p> </li>
        /// <li> <p>"NL" - NETHERLANDS</p> </li>
        /// <li> <p>"NZ" - NEW ZEALAND</p> </li>
        /// <li> <p>"NI" - NICARAGUA</p> </li>
        /// <li> <p>"NG" - NIGERIA</p> </li>
        /// <li> <p>"NO" - NORWAY</p> </li>
        /// <li> <p>"PA" - PANAMA</p> </li>
        /// <li> <p>"PY" - PARAGUAY</p> </li>
        /// <li> <p>"PE" - PERU</p> </li>
        /// <li> <p>"PL" - POLAND</p> </li>
        /// <li> <p>"PT" - PORTUGAL</p> </li>
        /// <li> <p>"RO" - ROMANIA</p> </li>
        /// <li> <p>"RU" - RUSSIA</p> </li>
        /// <li> <p>"RS" - SERBIA</p> </li>
        /// <li> <p>"SK" - SLOVAKIA</p> </li>
        /// <li> <p>"SI" - SLOVENIA</p> </li>
        /// <li> <p>"ZA" - SOUTH AFRICA</p> </li>
        /// <li> <p>"ES" - SPAIN</p> </li>
        /// <li> <p>"SE" - SWEDEN</p> </li>
        /// <li> <p>"CH" - SWITZERLAND</p> </li>
        /// <li> <p>"UA" - UKRAINE</p> </li>
        /// <li> <p>"AE" - UNITED ARAB EMIRATES</p> </li>
        /// <li> <p>"US" - UNITED STATES</p> </li>
        /// <li> <p>"UK" - UNITED KINGDOM</p> </li>
        /// <li> <p>"UY" - URUGUAY</p> </li>
        /// <li> <p>"VE" - VENEZUELA</p> </li>
        /// </ul>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalDataset`](crate::model::AdditionalDataset)
        pub fn build(self) -> crate::model::AdditionalDataset {
            crate::model::AdditionalDataset {
                name: self.name,
                configuration: self.configuration,
            }
        }
    }
}
impl AdditionalDataset {
    /// Creates a new builder-style object to manufacture [`AdditionalDataset`](crate::model::AdditionalDataset)
    pub fn builder() -> crate::model::additional_dataset::Builder {
        crate::model::additional_dataset::Builder::default()
    }
}

/// <p>Provides information about the method used to transform attributes.</p>
/// <p>The following is an example using the RETAIL domain:</p>
/// <p> <code>{</code> </p>
/// <p> <code>"AttributeName": "demand",</code> </p>
/// <p> <code>"Transformations": {"aggregation": "sum", "middlefill": "zero", "backfill": "zero"}</code> </p>
/// <p> <code>}</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeConfig {
    /// <p>The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target time series and the related time series datasets. For example, for the RETAIL domain, the target is <code>demand</code>.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
    /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Default values are bolded.</p>
    /// <ul>
    /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
    /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
    /// <ul>
    /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
    pub transformations:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AttributeConfig {
    /// <p>The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target time series and the related time series datasets. For example, for the RETAIL domain, the target is <code>demand</code>.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
    /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Default values are bolded.</p>
    /// <ul>
    /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
    /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
    /// <ul>
    /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
    /// </ul>
    /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
    pub fn transformations(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.transformations.as_ref()
    }
}
impl std::fmt::Debug for AttributeConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeConfig");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("transformations", &self.transformations);
        formatter.finish()
    }
}
/// See [`AttributeConfig`](crate::model::AttributeConfig)
pub mod attribute_config {
    /// A builder for [`AttributeConfig`](crate::model::AttributeConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) transformations: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target time series and the related time series datasets. For example, for the RETAIL domain, the target is <code>demand</code>.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target time series and the related time series datasets. For example, for the RETAIL domain, the target is <code>demand</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Adds a key-value pair to `transformations`.
        ///
        /// To override the contents of this collection use [`set_transformations`](Self::set_transformations).
        ///
        /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
        /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Default values are bolded.</p>
        /// <ul>
        /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
        /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
        /// <ul>
        /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
        pub fn transformations(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.transformations.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.transformations = Some(hash_map);
            self
        }
        /// <p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
        /// <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Default values are bolded.</p>
        /// <ul>
        /// <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>frontfill</code>: <b>none</b> </p> </li>
        /// <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p>
        /// <ul>
        /// <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li>
        /// </ul>
        /// <p>To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>. </p>
        pub fn set_transformations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.transformations = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeConfig`](crate::model::AttributeConfig)
        pub fn build(self) -> crate::model::AttributeConfig {
            crate::model::AttributeConfig {
                attribute_name: self.attribute_name,
                transformations: self.transformations,
            }
        }
    }
}
impl AttributeConfig {
    /// Creates a new builder-style object to manufacture [`AttributeConfig`](crate::model::AttributeConfig)
    pub fn builder() -> crate::model::attribute_config::Builder {
        crate::model::attribute_config::Builder::default()
    }
}
