// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateAutoPredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAutoPredictorError {
    /// Kind of error that occurred.
    pub kind: CreateAutoPredictorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAutoPredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAutoPredictorErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAutoPredictorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAutoPredictorErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateAutoPredictorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAutoPredictorErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAutoPredictorErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateAutoPredictorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAutoPredictorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAutoPredictorError {
    fn code(&self) -> Option<&str> {
        CreateAutoPredictorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAutoPredictorError {
    /// Creates a new `CreateAutoPredictorError`.
    pub fn new(kind: CreateAutoPredictorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAutoPredictorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAutoPredictorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAutoPredictorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAutoPredictorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAutoPredictorErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoPredictorErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAutoPredictorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoPredictorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAutoPredictorErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoPredictorErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAutoPredictorErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoPredictorErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAutoPredictorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoPredictorErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateAutoPredictorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAutoPredictorErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateAutoPredictorErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAutoPredictorErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateAutoPredictorErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateAutoPredictorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAutoPredictorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetError {
    fn code(&self) -> Option<&str> {
        CreateDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetError {
    /// Creates a new `CreateDatasetError`.
    pub fn new(kind: CreateDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatasetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetGroupErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetGroupError {
    fn code(&self) -> Option<&str> {
        CreateDatasetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetGroupError {
    /// Creates a new `CreateDatasetGroupError`.
    pub fn new(kind: CreateDatasetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateDatasetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetImportJobError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetImportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetImportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateDatasetImportJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetImportJobError {
    fn code(&self) -> Option<&str> {
        CreateDatasetImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetImportJobError {
    /// Creates a new `CreateDatasetImportJobError`.
    pub fn new(kind: CreateDatasetImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateDatasetImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetImportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExplainability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExplainabilityError {
    /// Kind of error that occurred.
    pub kind: CreateExplainabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExplainability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExplainabilityErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExplainabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExplainabilityErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateExplainabilityErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateExplainabilityErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateExplainabilityErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateExplainabilityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateExplainabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExplainabilityError {
    fn code(&self) -> Option<&str> {
        CreateExplainabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExplainabilityError {
    /// Creates a new `CreateExplainabilityError`.
    pub fn new(kind: CreateExplainabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExplainabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExplainabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExplainabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExplainabilityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExplainabilityErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateExplainabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExplainabilityErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateExplainabilityErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateExplainabilityErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateExplainabilityErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateExplainabilityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateExplainabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExplainabilityExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExplainabilityExportError {
    /// Kind of error that occurred.
    pub kind: CreateExplainabilityExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExplainabilityExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExplainabilityExportErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExplainabilityExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExplainabilityExportErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateExplainabilityExportErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateExplainabilityExportErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateExplainabilityExportErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateExplainabilityExportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateExplainabilityExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExplainabilityExportError {
    fn code(&self) -> Option<&str> {
        CreateExplainabilityExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExplainabilityExportError {
    /// Creates a new `CreateExplainabilityExportError`.
    pub fn new(kind: CreateExplainabilityExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExplainabilityExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExplainabilityExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExplainabilityExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExplainabilityExportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExplainabilityExportErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityExportErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityExportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityExportErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityExportErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityExportErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityExportErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityExportErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExplainabilityExportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExplainabilityExportErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateExplainabilityExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExplainabilityExportErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateExplainabilityExportErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateExplainabilityExportErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateExplainabilityExportErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateExplainabilityExportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateExplainabilityExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateForecastError {
    /// Kind of error that occurred.
    pub kind: CreateForecastErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateForecastErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateForecastError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateForecastErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateForecastErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateForecastErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateForecastErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateForecastErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateForecastErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateForecastError {
    fn code(&self) -> Option<&str> {
        CreateForecastError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateForecastError {
    /// Creates a new `CreateForecastError`.
    pub fn new(kind: CreateForecastErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateForecastError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateForecastErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateForecastError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateForecastErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateForecastErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateForecastError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateForecastErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateForecastErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateForecastErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateForecastErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateForecastErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateForecastErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateForecastExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateForecastExportJobError {
    /// Kind of error that occurred.
    pub kind: CreateForecastExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateForecastExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateForecastExportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateForecastExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateForecastExportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateForecastExportJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateForecastExportJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateForecastExportJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateForecastExportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateForecastExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateForecastExportJobError {
    fn code(&self) -> Option<&str> {
        CreateForecastExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateForecastExportJobError {
    /// Creates a new `CreateForecastExportJobError`.
    pub fn new(kind: CreateForecastExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateForecastExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateForecastExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateForecastExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateForecastExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateForecastExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastExportJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastExportJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastExportJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastExportJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastExportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastExportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateForecastExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateForecastExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateForecastExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateForecastExportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateForecastExportJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateForecastExportJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateForecastExportJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateForecastExportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateForecastExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePredictorError {
    /// Kind of error that occurred.
    pub kind: CreatePredictorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePredictorErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePredictorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePredictorErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreatePredictorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePredictorErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePredictorErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreatePredictorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePredictorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePredictorError {
    fn code(&self) -> Option<&str> {
        CreatePredictorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePredictorError {
    /// Creates a new `CreatePredictorError`.
    pub fn new(kind: CreatePredictorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePredictorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePredictorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePredictorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePredictorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePredictorErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreatePredictorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePredictorErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreatePredictorErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePredictorErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreatePredictorErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreatePredictorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePredictorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePredictorBacktestExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePredictorBacktestExportJobError {
    /// Kind of error that occurred.
    pub kind: CreatePredictorBacktestExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePredictorBacktestExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePredictorBacktestExportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There is already a resource with this name. Try again with a different name.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePredictorBacktestExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePredictorBacktestExportJobErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            CreatePredictorBacktestExportJobErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreatePredictorBacktestExportJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreatePredictorBacktestExportJobErrorKind::ResourceInUseException(_inner) => {
                _inner.fmt(f)
            }
            CreatePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreatePredictorBacktestExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePredictorBacktestExportJobError {
    fn code(&self) -> Option<&str> {
        CreatePredictorBacktestExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePredictorBacktestExportJobError {
    /// Creates a new `CreatePredictorBacktestExportJobError`.
    pub fn new(
        kind: CreatePredictorBacktestExportJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePredictorBacktestExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePredictorBacktestExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePredictorBacktestExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePredictorBacktestExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePredictorBacktestExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorBacktestExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorBacktestExportJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorBacktestExportJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorBacktestExportJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorBacktestExportJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorBacktestExportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorBacktestExportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePredictorBacktestExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreatePredictorBacktestExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePredictorBacktestExportJobErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            CreatePredictorBacktestExportJobErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            CreatePredictorBacktestExportJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreatePredictorBacktestExportJobErrorKind::ResourceInUseException(_inner) => {
                Some(_inner)
            }
            CreatePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreatePredictorBacktestExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetError {
    /// Creates a new `DeleteDatasetError`.
    pub fn new(kind: DeleteDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetGroupErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDatasetGroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDatasetGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetGroupError {
    /// Creates a new `DeleteDatasetGroupError`.
    pub fn new(kind: DeleteDatasetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetGroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetGroupErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDatasetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDatasetGroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDatasetGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetImportJobError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetImportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetImportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDatasetImportJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetImportJobError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetImportJobError {
    /// Creates a new `DeleteDatasetImportJobError`.
    pub fn new(kind: DeleteDatasetImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetImportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetImportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetImportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetImportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDatasetImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetImportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDatasetImportJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteExplainability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteExplainabilityError {
    /// Kind of error that occurred.
    pub kind: DeleteExplainabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteExplainability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteExplainabilityErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteExplainabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteExplainabilityErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteExplainabilityErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteExplainabilityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteExplainabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteExplainabilityError {
    fn code(&self) -> Option<&str> {
        DeleteExplainabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteExplainabilityError {
    /// Creates a new `DeleteExplainabilityError`.
    pub fn new(kind: DeleteExplainabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteExplainabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteExplainabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteExplainabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteExplainabilityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteExplainabilityErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExplainabilityErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExplainabilityErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExplainabilityErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExplainabilityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExplainabilityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteExplainabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteExplainabilityErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteExplainabilityErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteExplainabilityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteExplainabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteExplainabilityExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteExplainabilityExportError {
    /// Kind of error that occurred.
    pub kind: DeleteExplainabilityExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteExplainabilityExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteExplainabilityExportErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteExplainabilityExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteExplainabilityExportErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteExplainabilityExportErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteExplainabilityExportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteExplainabilityExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteExplainabilityExportError {
    fn code(&self) -> Option<&str> {
        DeleteExplainabilityExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteExplainabilityExportError {
    /// Creates a new `DeleteExplainabilityExportError`.
    pub fn new(kind: DeleteExplainabilityExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteExplainabilityExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteExplainabilityExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteExplainabilityExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteExplainabilityExportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteExplainabilityExportErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExplainabilityExportErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExplainabilityExportErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExplainabilityExportErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExplainabilityExportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExplainabilityExportErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteExplainabilityExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteExplainabilityExportErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteExplainabilityExportErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteExplainabilityExportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteExplainabilityExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteForecastError {
    /// Kind of error that occurred.
    pub kind: DeleteForecastErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteForecastErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteForecastError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteForecastErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteForecastErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteForecastErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteForecastErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteForecastError {
    fn code(&self) -> Option<&str> {
        DeleteForecastError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteForecastError {
    /// Creates a new `DeleteForecastError`.
    pub fn new(kind: DeleteForecastErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteForecastError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteForecastErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteForecastError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteForecastErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteForecastErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteForecastErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteForecastErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteForecastErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteForecastErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteForecastErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteForecastError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteForecastErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteForecastErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteForecastErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteForecastErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteForecastExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteForecastExportJobError {
    /// Kind of error that occurred.
    pub kind: DeleteForecastExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteForecastExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteForecastExportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteForecastExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteForecastExportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteForecastExportJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteForecastExportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteForecastExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteForecastExportJobError {
    fn code(&self) -> Option<&str> {
        DeleteForecastExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteForecastExportJobError {
    /// Creates a new `DeleteForecastExportJobError`.
    pub fn new(kind: DeleteForecastExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteForecastExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteForecastExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteForecastExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteForecastExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteForecastExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteForecastExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteForecastExportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteForecastExportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteForecastExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteForecastExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteForecastExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteForecastExportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteForecastExportJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteForecastExportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteForecastExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePredictorError {
    /// Kind of error that occurred.
    pub kind: DeletePredictorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePredictorErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePredictorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePredictorErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeletePredictorErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeletePredictorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePredictorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePredictorError {
    fn code(&self) -> Option<&str> {
        DeletePredictorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePredictorError {
    /// Creates a new `DeletePredictorError`.
    pub fn new(kind: DeletePredictorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePredictorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePredictorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePredictorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePredictorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePredictorErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePredictorErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePredictorErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePredictorErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePredictorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePredictorErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeletePredictorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePredictorErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeletePredictorErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeletePredictorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePredictorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePredictorBacktestExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePredictorBacktestExportJobError {
    /// Kind of error that occurred.
    pub kind: DeletePredictorBacktestExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePredictorBacktestExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePredictorBacktestExportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePredictorBacktestExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePredictorBacktestExportJobErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DeletePredictorBacktestExportJobErrorKind::ResourceInUseException(_inner) => {
                _inner.fmt(f)
            }
            DeletePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeletePredictorBacktestExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePredictorBacktestExportJobError {
    fn code(&self) -> Option<&str> {
        DeletePredictorBacktestExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePredictorBacktestExportJobError {
    /// Creates a new `DeletePredictorBacktestExportJobError`.
    pub fn new(
        kind: DeletePredictorBacktestExportJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePredictorBacktestExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePredictorBacktestExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePredictorBacktestExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePredictorBacktestExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePredictorBacktestExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePredictorBacktestExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePredictorBacktestExportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePredictorBacktestExportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePredictorBacktestExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeletePredictorBacktestExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePredictorBacktestExportJobErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            DeletePredictorBacktestExportJobErrorKind::ResourceInUseException(_inner) => {
                Some(_inner)
            }
            DeletePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeletePredictorBacktestExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourceTree` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceTreeError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceTreeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourceTree` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceTreeErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceTreeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceTreeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteResourceTreeErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteResourceTreeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourceTreeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceTreeError {
    fn code(&self) -> Option<&str> {
        DeleteResourceTreeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceTreeError {
    /// Creates a new `DeleteResourceTreeError`.
    pub fn new(kind: DeleteResourceTreeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceTreeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceTreeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceTreeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceTreeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceTreeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceTreeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceTreeErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceTreeErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceTreeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceTreeErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteResourceTreeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceTreeErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteResourceTreeErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteResourceTreeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourceTreeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAutoPredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAutoPredictorError {
    /// Kind of error that occurred.
    pub kind: DescribeAutoPredictorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAutoPredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAutoPredictorErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAutoPredictorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAutoPredictorErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeAutoPredictorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAutoPredictorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAutoPredictorError {
    fn code(&self) -> Option<&str> {
        DescribeAutoPredictorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAutoPredictorError {
    /// Creates a new `DescribeAutoPredictorError`.
    pub fn new(kind: DescribeAutoPredictorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAutoPredictorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAutoPredictorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAutoPredictorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAutoPredictorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAutoPredictorErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoPredictorErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutoPredictorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoPredictorErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeAutoPredictorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAutoPredictorErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeAutoPredictorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAutoPredictorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetError {
    /// Creates a new `DescribeDatasetError`.
    pub fn new(kind: DescribeDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetGroupErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDatasetGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetGroupError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetGroupError {
    /// Creates a new `DescribeDatasetGroupError`.
    pub fn new(kind: DescribeDatasetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDatasetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDatasetGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetImportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetImportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetImportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetImportJobError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetImportJobError {
    /// Creates a new `DescribeDatasetImportJobError`.
    pub fn new(kind: DescribeDatasetImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetImportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetImportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDatasetImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetImportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExplainability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExplainabilityError {
    /// Kind of error that occurred.
    pub kind: DescribeExplainabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExplainability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExplainabilityErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExplainabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExplainabilityErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeExplainabilityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeExplainabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExplainabilityError {
    fn code(&self) -> Option<&str> {
        DescribeExplainabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExplainabilityError {
    /// Creates a new `DescribeExplainabilityError`.
    pub fn new(kind: DescribeExplainabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExplainabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExplainabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExplainabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExplainabilityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExplainabilityErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExplainabilityErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExplainabilityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExplainabilityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeExplainabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExplainabilityErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeExplainabilityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeExplainabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExplainabilityExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExplainabilityExportError {
    /// Kind of error that occurred.
    pub kind: DescribeExplainabilityExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExplainabilityExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExplainabilityExportErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExplainabilityExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExplainabilityExportErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeExplainabilityExportErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeExplainabilityExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExplainabilityExportError {
    fn code(&self) -> Option<&str> {
        DescribeExplainabilityExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExplainabilityExportError {
    /// Creates a new `DescribeExplainabilityExportError`.
    pub fn new(kind: DescribeExplainabilityExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExplainabilityExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExplainabilityExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExplainabilityExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExplainabilityExportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExplainabilityExportErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExplainabilityExportErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExplainabilityExportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExplainabilityExportErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeExplainabilityExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExplainabilityExportErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeExplainabilityExportErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeExplainabilityExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeForecastError {
    /// Kind of error that occurred.
    pub kind: DescribeForecastErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeForecastErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeForecastError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeForecastErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeForecastErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeForecastErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeForecastError {
    fn code(&self) -> Option<&str> {
        DescribeForecastError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeForecastError {
    /// Creates a new `DescribeForecastError`.
    pub fn new(kind: DescribeForecastErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeForecastError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeForecastErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeForecastError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeForecastErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeForecastErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeForecastErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeForecastErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeForecastErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeForecastError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeForecastErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeForecastErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeForecastErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeForecastExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeForecastExportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeForecastExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeForecastExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeForecastExportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeForecastExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeForecastExportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeForecastExportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeForecastExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeForecastExportJobError {
    fn code(&self) -> Option<&str> {
        DescribeForecastExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeForecastExportJobError {
    /// Creates a new `DescribeForecastExportJobError`.
    pub fn new(kind: DescribeForecastExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeForecastExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeForecastExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeForecastExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeForecastExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeForecastExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeForecastExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeForecastExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeForecastExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeForecastExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeForecastExportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeForecastExportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeForecastExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePredictorError {
    /// Kind of error that occurred.
    pub kind: DescribePredictorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePredictor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePredictorErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePredictorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePredictorErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribePredictorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePredictorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePredictorError {
    fn code(&self) -> Option<&str> {
        DescribePredictorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePredictorError {
    /// Creates a new `DescribePredictorError`.
    pub fn new(kind: DescribePredictorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePredictorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePredictorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePredictorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePredictorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePredictorErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePredictorErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePredictorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePredictorErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribePredictorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePredictorErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribePredictorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePredictorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePredictorBacktestExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePredictorBacktestExportJobError {
    /// Kind of error that occurred.
    pub kind: DescribePredictorBacktestExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePredictorBacktestExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePredictorBacktestExportJobErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePredictorBacktestExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePredictorBacktestExportJobErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DescribePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribePredictorBacktestExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePredictorBacktestExportJobError {
    fn code(&self) -> Option<&str> {
        DescribePredictorBacktestExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePredictorBacktestExportJobError {
    /// Creates a new `DescribePredictorBacktestExportJobError`.
    pub fn new(
        kind: DescribePredictorBacktestExportJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePredictorBacktestExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePredictorBacktestExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePredictorBacktestExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePredictorBacktestExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePredictorBacktestExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePredictorBacktestExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePredictorBacktestExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribePredictorBacktestExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePredictorBacktestExportJobErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            DescribePredictorBacktestExportJobErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribePredictorBacktestExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccuracyMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccuracyMetricsError {
    /// Kind of error that occurred.
    pub kind: GetAccuracyMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccuracyMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccuracyMetricsErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccuracyMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccuracyMetricsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetAccuracyMetricsErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            GetAccuracyMetricsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAccuracyMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccuracyMetricsError {
    fn code(&self) -> Option<&str> {
        GetAccuracyMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccuracyMetricsError {
    /// Creates a new `GetAccuracyMetricsError`.
    pub fn new(kind: GetAccuracyMetricsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccuracyMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccuracyMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccuracyMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccuracyMetricsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccuracyMetricsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccuracyMetricsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccuracyMetricsErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccuracyMetricsErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccuracyMetricsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccuracyMetricsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetAccuracyMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccuracyMetricsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetAccuracyMetricsErrorKind::ResourceInUseException(_inner) => Some(_inner),
            GetAccuracyMetricsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAccuracyMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetGroupsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetGroupsErrorKind {
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetGroupsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDatasetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetGroupsError {
    fn code(&self) -> Option<&str> {
        ListDatasetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetGroupsError {
    /// Creates a new `ListDatasetGroupsError`.
    pub fn new(kind: ListDatasetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetGroupsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetGroupsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListDatasetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetGroupsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDatasetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasetImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetImportJobsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasetImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetImportJobsErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetImportJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListDatasetImportJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDatasetImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetImportJobsError {
    fn code(&self) -> Option<&str> {
        ListDatasetImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetImportJobsError {
    /// Creates a new `ListDatasetImportJobsError`.
    pub fn new(kind: ListDatasetImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetImportJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetImportJobsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetImportJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetImportJobsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListDatasetImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetImportJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDatasetImportJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDatasetImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetsErrorKind {
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetsError {
    fn code(&self) -> Option<&str> {
        ListDatasetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetsError {
    /// Creates a new `ListDatasetsError`.
    pub fn new(kind: ListDatasetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListDatasetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDatasetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExplainabilities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExplainabilitiesError {
    /// Kind of error that occurred.
    pub kind: ListExplainabilitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExplainabilities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExplainabilitiesErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExplainabilitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExplainabilitiesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListExplainabilitiesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListExplainabilitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExplainabilitiesError {
    fn code(&self) -> Option<&str> {
        ListExplainabilitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExplainabilitiesError {
    /// Creates a new `ListExplainabilitiesError`.
    pub fn new(kind: ListExplainabilitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExplainabilitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExplainabilitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExplainabilitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExplainabilitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExplainabilitiesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExplainabilitiesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExplainabilitiesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExplainabilitiesErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListExplainabilitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExplainabilitiesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListExplainabilitiesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListExplainabilitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExplainabilityExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExplainabilityExportsError {
    /// Kind of error that occurred.
    pub kind: ListExplainabilityExportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExplainabilityExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExplainabilityExportsErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExplainabilityExportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExplainabilityExportsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListExplainabilityExportsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListExplainabilityExportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExplainabilityExportsError {
    fn code(&self) -> Option<&str> {
        ListExplainabilityExportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExplainabilityExportsError {
    /// Creates a new `ListExplainabilityExportsError`.
    pub fn new(kind: ListExplainabilityExportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExplainabilityExportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExplainabilityExportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExplainabilityExportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExplainabilityExportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExplainabilityExportsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExplainabilityExportsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExplainabilityExportsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExplainabilityExportsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListExplainabilityExportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExplainabilityExportsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListExplainabilityExportsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListExplainabilityExportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListForecastExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListForecastExportJobsError {
    /// Kind of error that occurred.
    pub kind: ListForecastExportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListForecastExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListForecastExportJobsErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListForecastExportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListForecastExportJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListForecastExportJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListForecastExportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListForecastExportJobsError {
    fn code(&self) -> Option<&str> {
        ListForecastExportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListForecastExportJobsError {
    /// Creates a new `ListForecastExportJobsError`.
    pub fn new(kind: ListForecastExportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListForecastExportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListForecastExportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListForecastExportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListForecastExportJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListForecastExportJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListForecastExportJobsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListForecastExportJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListForecastExportJobsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListForecastExportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListForecastExportJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListForecastExportJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListForecastExportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListForecasts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListForecastsError {
    /// Kind of error that occurred.
    pub kind: ListForecastsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListForecasts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListForecastsErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListForecastsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListForecastsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListForecastsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListForecastsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListForecastsError {
    fn code(&self) -> Option<&str> {
        ListForecastsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListForecastsError {
    /// Creates a new `ListForecastsError`.
    pub fn new(kind: ListForecastsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListForecastsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListForecastsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListForecastsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListForecastsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListForecastsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListForecastsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListForecastsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListForecastsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListForecastsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListForecastsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListForecastsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListForecastsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPredictorBacktestExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPredictorBacktestExportJobsError {
    /// Kind of error that occurred.
    pub kind: ListPredictorBacktestExportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPredictorBacktestExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPredictorBacktestExportJobsErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPredictorBacktestExportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPredictorBacktestExportJobsErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            ListPredictorBacktestExportJobsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListPredictorBacktestExportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPredictorBacktestExportJobsError {
    fn code(&self) -> Option<&str> {
        ListPredictorBacktestExportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPredictorBacktestExportJobsError {
    /// Creates a new `ListPredictorBacktestExportJobsError`.
    pub fn new(
        kind: ListPredictorBacktestExportJobsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPredictorBacktestExportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPredictorBacktestExportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPredictorBacktestExportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPredictorBacktestExportJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPredictorBacktestExportJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPredictorBacktestExportJobsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPredictorBacktestExportJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPredictorBacktestExportJobsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListPredictorBacktestExportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPredictorBacktestExportJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListPredictorBacktestExportJobsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            ListPredictorBacktestExportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPredictors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPredictorsError {
    /// Kind of error that occurred.
    pub kind: ListPredictorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPredictors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPredictorsErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid. Tokens expire after 24 hours.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPredictorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPredictorsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListPredictorsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPredictorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPredictorsError {
    fn code(&self) -> Option<&str> {
        ListPredictorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPredictorsError {
    /// Creates a new `ListPredictorsError`.
    pub fn new(kind: ListPredictorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPredictorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPredictorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPredictorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPredictorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPredictorsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPredictorsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPredictorsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPredictorsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListPredictorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPredictorsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListPredictorsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPredictorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopResourceError {
    /// Kind of error that occurred.
    pub kind: StopResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopResourceErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StopResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopResourceError {
    fn code(&self) -> Option<&str> {
        StopResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopResourceError {
    /// Creates a new `StopResourceError`.
    pub fn new(kind: StopResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, StopResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `StopResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StopResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `StopResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            StopResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of resources per account has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDatasetGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateDatasetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDatasetGroupErrorKind {
    /// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDatasetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDatasetGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateDatasetGroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateDatasetGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDatasetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDatasetGroupError {
    fn code(&self) -> Option<&str> {
        UpdateDatasetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDatasetGroupError {
    /// Creates a new `UpdateDatasetGroupError`.
    pub fn new(kind: UpdateDatasetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDatasetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDatasetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDatasetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDatasetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDatasetGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetGroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetGroupErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateDatasetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDatasetGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateDatasetGroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateDatasetGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDatasetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The specified resource is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>We can't process the request because it includes an invalid value or a value that exceeds the valid range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>The limit on the number of resources per account has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The token is not valid. Tokens expire after 24 hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>There is already a resource with this name. Try again with a different name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
