// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatasetGroupOutput {}
impl std::fmt::Debug for UpdateDatasetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatasetGroupOutput");
        formatter.finish()
    }
}
/// See [`UpdateDatasetGroupOutput`](crate::output::UpdateDatasetGroupOutput)
pub mod update_dataset_group_output {
    /// A builder for [`UpdateDatasetGroupOutput`](crate::output::UpdateDatasetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDatasetGroupOutput`](crate::output::UpdateDatasetGroupOutput)
        pub fn build(self) -> crate::output::UpdateDatasetGroupOutput {
            crate::output::UpdateDatasetGroupOutput {}
        }
    }
}
impl UpdateDatasetGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetGroupOutput`](crate::output::UpdateDatasetGroupOutput)
    pub fn builder() -> crate::output::update_dataset_group_output::Builder {
        crate::output::update_dataset_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopResourceOutput {}
impl std::fmt::Debug for StopResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopResourceOutput");
        formatter.finish()
    }
}
/// See [`StopResourceOutput`](crate::output::StopResourceOutput)
pub mod stop_resource_output {
    /// A builder for [`StopResourceOutput`](crate::output::StopResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopResourceOutput`](crate::output::StopResourceOutput)
        pub fn build(self) -> crate::output::StopResourceOutput {
            crate::output::StopResourceOutput {}
        }
    }
}
impl StopResourceOutput {
    /// Creates a new builder-style object to manufacture [`StopResourceOutput`](crate::output::StopResourceOutput)
    pub fn builder() -> crate::output::stop_resource_output::Builder {
        crate::output::stop_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPredictorsOutput {
    /// <p>An array of objects that summarize each predictor's properties.</p>
    pub predictors: std::option::Option<std::vec::Vec<crate::model::PredictorSummary>>,
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPredictorsOutput {
    /// <p>An array of objects that summarize each predictor's properties.</p>
    pub fn predictors(&self) -> std::option::Option<&[crate::model::PredictorSummary]> {
        self.predictors.as_deref()
    }
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPredictorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPredictorsOutput");
        formatter.field("predictors", &self.predictors);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPredictorsOutput`](crate::output::ListPredictorsOutput)
pub mod list_predictors_output {
    /// A builder for [`ListPredictorsOutput`](crate::output::ListPredictorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictors: std::option::Option<std::vec::Vec<crate::model::PredictorSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `predictors`.
        ///
        /// To override the contents of this collection use [`set_predictors`](Self::set_predictors).
        ///
        /// <p>An array of objects that summarize each predictor's properties.</p>
        pub fn predictors(mut self, input: impl Into<crate::model::PredictorSummary>) -> Self {
            let mut v = self.predictors.unwrap_or_default();
            v.push(input.into());
            self.predictors = Some(v);
            self
        }
        /// <p>An array of objects that summarize each predictor's properties.</p>
        pub fn set_predictors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PredictorSummary>>,
        ) -> Self {
            self.predictors = input;
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPredictorsOutput`](crate::output::ListPredictorsOutput)
        pub fn build(self) -> crate::output::ListPredictorsOutput {
            crate::output::ListPredictorsOutput {
                predictors: self.predictors,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPredictorsOutput {
    /// Creates a new builder-style object to manufacture [`ListPredictorsOutput`](crate::output::ListPredictorsOutput)
    pub fn builder() -> crate::output::list_predictors_output::Builder {
        crate::output::list_predictors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPredictorBacktestExportJobsOutput {
    /// <p>An array of objects that summarize the properties of each predictor backtest export
    /// job.</p>
    pub predictor_backtest_export_jobs:
        std::option::Option<std::vec::Vec<crate::model::PredictorBacktestExportJobSummary>>,
    /// <p>Returns this token if the response is truncated. To retrieve the next
    /// set of results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPredictorBacktestExportJobsOutput {
    /// <p>An array of objects that summarize the properties of each predictor backtest export
    /// job.</p>
    pub fn predictor_backtest_export_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::PredictorBacktestExportJobSummary]> {
        self.predictor_backtest_export_jobs.as_deref()
    }
    /// <p>Returns this token if the response is truncated. To retrieve the next
    /// set of results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPredictorBacktestExportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPredictorBacktestExportJobsOutput");
        formatter.field(
            "predictor_backtest_export_jobs",
            &self.predictor_backtest_export_jobs,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPredictorBacktestExportJobsOutput`](crate::output::ListPredictorBacktestExportJobsOutput)
pub mod list_predictor_backtest_export_jobs_output {
    /// A builder for [`ListPredictorBacktestExportJobsOutput`](crate::output::ListPredictorBacktestExportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_backtest_export_jobs:
            std::option::Option<std::vec::Vec<crate::model::PredictorBacktestExportJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `predictor_backtest_export_jobs`.
        ///
        /// To override the contents of this collection use [`set_predictor_backtest_export_jobs`](Self::set_predictor_backtest_export_jobs).
        ///
        /// <p>An array of objects that summarize the properties of each predictor backtest export
        /// job.</p>
        pub fn predictor_backtest_export_jobs(
            mut self,
            input: impl Into<crate::model::PredictorBacktestExportJobSummary>,
        ) -> Self {
            let mut v = self.predictor_backtest_export_jobs.unwrap_or_default();
            v.push(input.into());
            self.predictor_backtest_export_jobs = Some(v);
            self
        }
        /// <p>An array of objects that summarize the properties of each predictor backtest export
        /// job.</p>
        pub fn set_predictor_backtest_export_jobs(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PredictorBacktestExportJobSummary>,
            >,
        ) -> Self {
            self.predictor_backtest_export_jobs = input;
            self
        }
        /// <p>Returns this token if the response is truncated. To retrieve the next
        /// set of results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Returns this token if the response is truncated. To retrieve the next
        /// set of results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPredictorBacktestExportJobsOutput`](crate::output::ListPredictorBacktestExportJobsOutput)
        pub fn build(self) -> crate::output::ListPredictorBacktestExportJobsOutput {
            crate::output::ListPredictorBacktestExportJobsOutput {
                predictor_backtest_export_jobs: self.predictor_backtest_export_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPredictorBacktestExportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListPredictorBacktestExportJobsOutput`](crate::output::ListPredictorBacktestExportJobsOutput)
    pub fn builder() -> crate::output::list_predictor_backtest_export_jobs_output::Builder {
        crate::output::list_predictor_backtest_export_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListForecastsOutput {
    /// <p>An array of objects that summarize each forecast's properties.</p>
    pub forecasts: std::option::Option<std::vec::Vec<crate::model::ForecastSummary>>,
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set
    /// of results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListForecastsOutput {
    /// <p>An array of objects that summarize each forecast's properties.</p>
    pub fn forecasts(&self) -> std::option::Option<&[crate::model::ForecastSummary]> {
        self.forecasts.as_deref()
    }
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set
    /// of results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListForecastsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListForecastsOutput");
        formatter.field("forecasts", &self.forecasts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListForecastsOutput`](crate::output::ListForecastsOutput)
pub mod list_forecasts_output {
    /// A builder for [`ListForecastsOutput`](crate::output::ListForecastsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecasts: std::option::Option<std::vec::Vec<crate::model::ForecastSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `forecasts`.
        ///
        /// To override the contents of this collection use [`set_forecasts`](Self::set_forecasts).
        ///
        /// <p>An array of objects that summarize each forecast's properties.</p>
        pub fn forecasts(mut self, input: impl Into<crate::model::ForecastSummary>) -> Self {
            let mut v = self.forecasts.unwrap_or_default();
            v.push(input.into());
            self.forecasts = Some(v);
            self
        }
        /// <p>An array of objects that summarize each forecast's properties.</p>
        pub fn set_forecasts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ForecastSummary>>,
        ) -> Self {
            self.forecasts = input;
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set
        /// of results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set
        /// of results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListForecastsOutput`](crate::output::ListForecastsOutput)
        pub fn build(self) -> crate::output::ListForecastsOutput {
            crate::output::ListForecastsOutput {
                forecasts: self.forecasts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListForecastsOutput {
    /// Creates a new builder-style object to manufacture [`ListForecastsOutput`](crate::output::ListForecastsOutput)
    pub fn builder() -> crate::output::list_forecasts_output::Builder {
        crate::output::list_forecasts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListForecastExportJobsOutput {
    /// <p>An array of objects that summarize each export job's properties.</p>
    pub forecast_export_jobs:
        std::option::Option<std::vec::Vec<crate::model::ForecastExportJobSummary>>,
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListForecastExportJobsOutput {
    /// <p>An array of objects that summarize each export job's properties.</p>
    pub fn forecast_export_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::ForecastExportJobSummary]> {
        self.forecast_export_jobs.as_deref()
    }
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListForecastExportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListForecastExportJobsOutput");
        formatter.field("forecast_export_jobs", &self.forecast_export_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListForecastExportJobsOutput`](crate::output::ListForecastExportJobsOutput)
pub mod list_forecast_export_jobs_output {
    /// A builder for [`ListForecastExportJobsOutput`](crate::output::ListForecastExportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_export_jobs:
            std::option::Option<std::vec::Vec<crate::model::ForecastExportJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `forecast_export_jobs`.
        ///
        /// To override the contents of this collection use [`set_forecast_export_jobs`](Self::set_forecast_export_jobs).
        ///
        /// <p>An array of objects that summarize each export job's properties.</p>
        pub fn forecast_export_jobs(
            mut self,
            input: impl Into<crate::model::ForecastExportJobSummary>,
        ) -> Self {
            let mut v = self.forecast_export_jobs.unwrap_or_default();
            v.push(input.into());
            self.forecast_export_jobs = Some(v);
            self
        }
        /// <p>An array of objects that summarize each export job's properties.</p>
        pub fn set_forecast_export_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ForecastExportJobSummary>>,
        ) -> Self {
            self.forecast_export_jobs = input;
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListForecastExportJobsOutput`](crate::output::ListForecastExportJobsOutput)
        pub fn build(self) -> crate::output::ListForecastExportJobsOutput {
            crate::output::ListForecastExportJobsOutput {
                forecast_export_jobs: self.forecast_export_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListForecastExportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListForecastExportJobsOutput`](crate::output::ListForecastExportJobsOutput)
    pub fn builder() -> crate::output::list_forecast_export_jobs_output::Builder {
        crate::output::list_forecast_export_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsOutput {
    /// <p>An array of objects that summarize each dataset's properties.</p>
    pub datasets: std::option::Option<std::vec::Vec<crate::model::DatasetSummary>>,
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetsOutput {
    /// <p>An array of objects that summarize each dataset's properties.</p>
    pub fn datasets(&self) -> std::option::Option<&[crate::model::DatasetSummary]> {
        self.datasets.as_deref()
    }
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsOutput");
        formatter.field("datasets", &self.datasets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
pub mod list_datasets_output {
    /// A builder for [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datasets: std::option::Option<std::vec::Vec<crate::model::DatasetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// <p>An array of objects that summarize each dataset's properties.</p>
        pub fn datasets(mut self, input: impl Into<crate::model::DatasetSummary>) -> Self {
            let mut v = self.datasets.unwrap_or_default();
            v.push(input.into());
            self.datasets = Some(v);
            self
        }
        /// <p>An array of objects that summarize each dataset's properties.</p>
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetSummary>>,
        ) -> Self {
            self.datasets = input;
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
        pub fn build(self) -> crate::output::ListDatasetsOutput {
            crate::output::ListDatasetsOutput {
                datasets: self.datasets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    pub fn builder() -> crate::output::list_datasets_output::Builder {
        crate::output::list_datasets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetImportJobsOutput {
    /// <p>An array of objects that summarize each dataset import job's properties.</p>
    pub dataset_import_jobs:
        std::option::Option<std::vec::Vec<crate::model::DatasetImportJobSummary>>,
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetImportJobsOutput {
    /// <p>An array of objects that summarize each dataset import job's properties.</p>
    pub fn dataset_import_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::DatasetImportJobSummary]> {
        self.dataset_import_jobs.as_deref()
    }
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetImportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetImportJobsOutput");
        formatter.field("dataset_import_jobs", &self.dataset_import_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
pub mod list_dataset_import_jobs_output {
    /// A builder for [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_jobs:
            std::option::Option<std::vec::Vec<crate::model::DatasetImportJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dataset_import_jobs`.
        ///
        /// To override the contents of this collection use [`set_dataset_import_jobs`](Self::set_dataset_import_jobs).
        ///
        /// <p>An array of objects that summarize each dataset import job's properties.</p>
        pub fn dataset_import_jobs(
            mut self,
            input: impl Into<crate::model::DatasetImportJobSummary>,
        ) -> Self {
            let mut v = self.dataset_import_jobs.unwrap_or_default();
            v.push(input.into());
            self.dataset_import_jobs = Some(v);
            self
        }
        /// <p>An array of objects that summarize each dataset import job's properties.</p>
        pub fn set_dataset_import_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetImportJobSummary>>,
        ) -> Self {
            self.dataset_import_jobs = input;
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
        pub fn build(self) -> crate::output::ListDatasetImportJobsOutput {
            crate::output::ListDatasetImportJobsOutput {
                dataset_import_jobs: self.dataset_import_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetImportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
    pub fn builder() -> crate::output::list_dataset_import_jobs_output::Builder {
        crate::output::list_dataset_import_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetGroupsOutput {
    /// <p>An array of objects that summarize each dataset group's properties.</p>
    pub dataset_groups: std::option::Option<std::vec::Vec<crate::model::DatasetGroupSummary>>,
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetGroupsOutput {
    /// <p>An array of objects that summarize each dataset group's properties.</p>
    pub fn dataset_groups(&self) -> std::option::Option<&[crate::model::DatasetGroupSummary]> {
        self.dataset_groups.as_deref()
    }
    /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
    /// results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetGroupsOutput");
        formatter.field("dataset_groups", &self.dataset_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
pub mod list_dataset_groups_output {
    /// A builder for [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_groups:
            std::option::Option<std::vec::Vec<crate::model::DatasetGroupSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dataset_groups`.
        ///
        /// To override the contents of this collection use [`set_dataset_groups`](Self::set_dataset_groups).
        ///
        /// <p>An array of objects that summarize each dataset group's properties.</p>
        pub fn dataset_groups(
            mut self,
            input: impl Into<crate::model::DatasetGroupSummary>,
        ) -> Self {
            let mut v = self.dataset_groups.unwrap_or_default();
            v.push(input.into());
            self.dataset_groups = Some(v);
            self
        }
        /// <p>An array of objects that summarize each dataset group's properties.</p>
        pub fn set_dataset_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetGroupSummary>>,
        ) -> Self {
            self.dataset_groups = input;
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of
        /// results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
        pub fn build(self) -> crate::output::ListDatasetGroupsOutput {
            crate::output::ListDatasetGroupsOutput {
                dataset_groups: self.dataset_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
    pub fn builder() -> crate::output::list_dataset_groups_output::Builder {
        crate::output::list_dataset_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccuracyMetricsOutput {
    /// <p>An array of results from evaluating the predictor.</p>
    pub predictor_evaluation_results:
        std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
    /// <note>
    /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
    /// Contact AWS Support or your account manager to learn more about access privileges.
    /// </p>
    /// </note>
    /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
    /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
    /// <p>This parameter is only valid for predictors trained using AutoML.</p>
    pub auto_ml_override_strategy: std::option::Option<crate::model::AutoMlOverrideStrategy>,
    /// <p>The accuracy metric used to optimize the predictor.</p>
    pub optimization_metric: std::option::Option<crate::model::OptimizationMetric>,
}
impl GetAccuracyMetricsOutput {
    /// <p>An array of results from evaluating the predictor.</p>
    pub fn predictor_evaluation_results(
        &self,
    ) -> std::option::Option<&[crate::model::EvaluationResult]> {
        self.predictor_evaluation_results.as_deref()
    }
    /// <note>
    /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
    /// Contact AWS Support or your account manager to learn more about access privileges.
    /// </p>
    /// </note>
    /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
    /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
    /// <p>This parameter is only valid for predictors trained using AutoML.</p>
    pub fn auto_ml_override_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AutoMlOverrideStrategy> {
        self.auto_ml_override_strategy.as_ref()
    }
    /// <p>The accuracy metric used to optimize the predictor.</p>
    pub fn optimization_metric(&self) -> std::option::Option<&crate::model::OptimizationMetric> {
        self.optimization_metric.as_ref()
    }
}
impl std::fmt::Debug for GetAccuracyMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccuracyMetricsOutput");
        formatter.field(
            "predictor_evaluation_results",
            &self.predictor_evaluation_results,
        );
        formatter.field("auto_ml_override_strategy", &self.auto_ml_override_strategy);
        formatter.field("optimization_metric", &self.optimization_metric);
        formatter.finish()
    }
}
/// See [`GetAccuracyMetricsOutput`](crate::output::GetAccuracyMetricsOutput)
pub mod get_accuracy_metrics_output {
    /// A builder for [`GetAccuracyMetricsOutput`](crate::output::GetAccuracyMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_evaluation_results:
            std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        pub(crate) auto_ml_override_strategy:
            std::option::Option<crate::model::AutoMlOverrideStrategy>,
        pub(crate) optimization_metric: std::option::Option<crate::model::OptimizationMetric>,
    }
    impl Builder {
        /// Appends an item to `predictor_evaluation_results`.
        ///
        /// To override the contents of this collection use [`set_predictor_evaluation_results`](Self::set_predictor_evaluation_results).
        ///
        /// <p>An array of results from evaluating the predictor.</p>
        pub fn predictor_evaluation_results(
            mut self,
            input: impl Into<crate::model::EvaluationResult>,
        ) -> Self {
            let mut v = self.predictor_evaluation_results.unwrap_or_default();
            v.push(input.into());
            self.predictor_evaluation_results = Some(v);
            self
        }
        /// <p>An array of results from evaluating the predictor.</p>
        pub fn set_predictor_evaluation_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        ) -> Self {
            self.predictor_evaluation_results = input;
            self
        }
        /// <note>
        /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
        /// Contact AWS Support or your account manager to learn more about access privileges.
        /// </p>
        /// </note>
        /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
        /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
        /// <p>This parameter is only valid for predictors trained using AutoML.</p>
        pub fn auto_ml_override_strategy(
            mut self,
            input: crate::model::AutoMlOverrideStrategy,
        ) -> Self {
            self.auto_ml_override_strategy = Some(input);
            self
        }
        /// <note>
        /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
        /// Contact AWS Support or your account manager to learn more about access privileges.
        /// </p>
        /// </note>
        /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
        /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
        /// <p>This parameter is only valid for predictors trained using AutoML.</p>
        pub fn set_auto_ml_override_strategy(
            mut self,
            input: std::option::Option<crate::model::AutoMlOverrideStrategy>,
        ) -> Self {
            self.auto_ml_override_strategy = input;
            self
        }
        /// <p>The accuracy metric used to optimize the predictor.</p>
        pub fn optimization_metric(mut self, input: crate::model::OptimizationMetric) -> Self {
            self.optimization_metric = Some(input);
            self
        }
        /// <p>The accuracy metric used to optimize the predictor.</p>
        pub fn set_optimization_metric(
            mut self,
            input: std::option::Option<crate::model::OptimizationMetric>,
        ) -> Self {
            self.optimization_metric = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccuracyMetricsOutput`](crate::output::GetAccuracyMetricsOutput)
        pub fn build(self) -> crate::output::GetAccuracyMetricsOutput {
            crate::output::GetAccuracyMetricsOutput {
                predictor_evaluation_results: self.predictor_evaluation_results,
                auto_ml_override_strategy: self.auto_ml_override_strategy,
                optimization_metric: self.optimization_metric,
            }
        }
    }
}
impl GetAccuracyMetricsOutput {
    /// Creates a new builder-style object to manufacture [`GetAccuracyMetricsOutput`](crate::output::GetAccuracyMetricsOutput)
    pub fn builder() -> crate::output::get_accuracy_metrics_output::Builder {
        crate::output::get_accuracy_metrics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePredictorBacktestExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
    pub predictor_backtest_export_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the predictor backtest export job.</p>
    pub predictor_backtest_export_job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
    pub predictor_arn: std::option::Option<std::string::String>,
    /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast
    /// to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
    pub destination: std::option::Option<crate::model::DataDestination>,
    /// <p>Information about any errors that may have occurred during the backtest export.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The status of the predictor backtest export job. States include: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>When the predictor backtest export job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribePredictorBacktestExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
    pub fn predictor_backtest_export_job_arn(&self) -> std::option::Option<&str> {
        self.predictor_backtest_export_job_arn.as_deref()
    }
    /// <p>The name of the predictor backtest export job.</p>
    pub fn predictor_backtest_export_job_name(&self) -> std::option::Option<&str> {
        self.predictor_backtest_export_job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
    pub fn predictor_arn(&self) -> std::option::Option<&str> {
        self.predictor_arn.as_deref()
    }
    /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast
    /// to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
    pub fn destination(&self) -> std::option::Option<&crate::model::DataDestination> {
        self.destination.as_ref()
    }
    /// <p>Information about any errors that may have occurred during the backtest export.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The status of the predictor backtest export job. States include: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>When the predictor backtest export job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DescribePredictorBacktestExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePredictorBacktestExportJobOutput");
        formatter.field(
            "predictor_backtest_export_job_arn",
            &self.predictor_backtest_export_job_arn,
        );
        formatter.field(
            "predictor_backtest_export_job_name",
            &self.predictor_backtest_export_job_name,
        );
        formatter.field("predictor_arn", &self.predictor_arn);
        formatter.field("destination", &self.destination);
        formatter.field("message", &self.message);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DescribePredictorBacktestExportJobOutput`](crate::output::DescribePredictorBacktestExportJobOutput)
pub mod describe_predictor_backtest_export_job_output {
    /// A builder for [`DescribePredictorBacktestExportJobOutput`](crate::output::DescribePredictorBacktestExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_backtest_export_job_arn: std::option::Option<std::string::String>,
        pub(crate) predictor_backtest_export_job_name: std::option::Option<std::string::String>,
        pub(crate) predictor_arn: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::DataDestination>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
        pub fn predictor_backtest_export_job_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
        pub fn set_predictor_backtest_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_arn = input;
            self
        }
        /// <p>The name of the predictor backtest export job.</p>
        pub fn predictor_backtest_export_job_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_name = Some(input.into());
            self
        }
        /// <p>The name of the predictor backtest export job.</p>
        pub fn set_predictor_backtest_export_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
        pub fn predictor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_arn = input;
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast
        /// to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn destination(mut self, input: crate::model::DataDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast
        /// to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DataDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>Information about any errors that may have occurred during the backtest export.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about any errors that may have occurred during the backtest export.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The status of the predictor backtest export job. States include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the predictor backtest export job. States include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>When the predictor backtest export job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the predictor backtest export job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePredictorBacktestExportJobOutput`](crate::output::DescribePredictorBacktestExportJobOutput)
        pub fn build(self) -> crate::output::DescribePredictorBacktestExportJobOutput {
            crate::output::DescribePredictorBacktestExportJobOutput {
                predictor_backtest_export_job_arn: self.predictor_backtest_export_job_arn,
                predictor_backtest_export_job_name: self.predictor_backtest_export_job_name,
                predictor_arn: self.predictor_arn,
                destination: self.destination,
                message: self.message,
                status: self.status,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DescribePredictorBacktestExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribePredictorBacktestExportJobOutput`](crate::output::DescribePredictorBacktestExportJobOutput)
    pub fn builder() -> crate::output::describe_predictor_backtest_export_job_output::Builder {
        crate::output::describe_predictor_backtest_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePredictorOutput {
    /// <p>The ARN of the predictor.</p>
    pub predictor_arn: std::option::Option<std::string::String>,
    /// <p>The name of the predictor.</p>
    pub predictor_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the algorithm used for model training.</p>
    pub algorithm_arn: std::option::Option<std::string::String>,
    /// <p>The number of time-steps of the forecast. The forecast horizon is also called the
    /// prediction length.</p>
    pub forecast_horizon: std::option::Option<i32>,
    /// <p>The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
    /// </p>
    pub forecast_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether the predictor is set to perform AutoML.</p>
    pub perform_auto_ml: std::option::Option<bool>,
    /// <note>
    /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
    /// Contact AWS Support or your account manager to learn more about access privileges.
    /// </p>
    /// </note>
    /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
    /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
    /// <p>This parameter is only valid for predictors trained using AutoML.</p>
    pub auto_ml_override_strategy: std::option::Option<crate::model::AutoMlOverrideStrategy>,
    /// <p>Whether the predictor is set to perform hyperparameter optimization (HPO).</p>
    pub perform_hpo: std::option::Option<bool>,
    /// <p>The default training parameters or overrides selected during model training. When running
    /// AutoML or choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen
    /// hyperparameters are returned. For more information, see <a>aws-forecast-choosing-recipes</a>.</p>
    pub training_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast
    /// evaluates a predictor by splitting a dataset into training data and testing data. The
    /// evaluation parameters define how to perform the split and the number of iterations.</p>
    pub evaluation_parameters: std::option::Option<crate::model::EvaluationParameters>,
    /// <p>The hyperparameter override values for the algorithm.</p>
    pub hpo_config: std::option::Option<crate::model::HyperParameterTuningJobConfig>,
    /// <p>Describes the dataset group that contains the data to use to train the predictor.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The featurization configuration.</p>
    pub featurization_config: std::option::Option<crate::model::FeaturizationConfig>,
    /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
    /// the key.</p>
    pub encryption_config: std::option::Option<crate::model::EncryptionConfig>,
    /// <p>Details on the the status and results of the backtests performed to evaluate the accuracy
    /// of the predictor. You specify the number of backtests to perform when you call the  operation.</p>
    pub predictor_execution_details: std::option::Option<crate::model::PredictorExecutionDetails>,
    /// <p>The estimated time remaining in minutes for the predictor training job to complete.</p>
    pub estimated_time_remaining_in_minutes: std::option::Option<i64>,
    /// <p>An array of the ARNs of the dataset import jobs used to import training data for the
    /// predictor.</p>
    pub dataset_import_job_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.</p>
    pub auto_ml_algorithm_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the predictor. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use
    /// the predictor to create a forecast.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the model training task was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The accuracy metric used to optimize the predictor.</p>
    pub optimization_metric: std::option::Option<crate::model::OptimizationMetric>,
}
impl DescribePredictorOutput {
    /// <p>The ARN of the predictor.</p>
    pub fn predictor_arn(&self) -> std::option::Option<&str> {
        self.predictor_arn.as_deref()
    }
    /// <p>The name of the predictor.</p>
    pub fn predictor_name(&self) -> std::option::Option<&str> {
        self.predictor_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the algorithm used for model training.</p>
    pub fn algorithm_arn(&self) -> std::option::Option<&str> {
        self.algorithm_arn.as_deref()
    }
    /// <p>The number of time-steps of the forecast. The forecast horizon is also called the
    /// prediction length.</p>
    pub fn forecast_horizon(&self) -> std::option::Option<i32> {
        self.forecast_horizon
    }
    /// <p>The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
    /// </p>
    pub fn forecast_types(&self) -> std::option::Option<&[std::string::String]> {
        self.forecast_types.as_deref()
    }
    /// <p>Whether the predictor is set to perform AutoML.</p>
    pub fn perform_auto_ml(&self) -> std::option::Option<bool> {
        self.perform_auto_ml
    }
    /// <note>
    /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
    /// Contact AWS Support or your account manager to learn more about access privileges.
    /// </p>
    /// </note>
    /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
    /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
    /// <p>This parameter is only valid for predictors trained using AutoML.</p>
    pub fn auto_ml_override_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AutoMlOverrideStrategy> {
        self.auto_ml_override_strategy.as_ref()
    }
    /// <p>Whether the predictor is set to perform hyperparameter optimization (HPO).</p>
    pub fn perform_hpo(&self) -> std::option::Option<bool> {
        self.perform_hpo
    }
    /// <p>The default training parameters or overrides selected during model training. When running
    /// AutoML or choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen
    /// hyperparameters are returned. For more information, see <a>aws-forecast-choosing-recipes</a>.</p>
    pub fn training_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.training_parameters.as_ref()
    }
    /// <p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast
    /// evaluates a predictor by splitting a dataset into training data and testing data. The
    /// evaluation parameters define how to perform the split and the number of iterations.</p>
    pub fn evaluation_parameters(
        &self,
    ) -> std::option::Option<&crate::model::EvaluationParameters> {
        self.evaluation_parameters.as_ref()
    }
    /// <p>The hyperparameter override values for the algorithm.</p>
    pub fn hpo_config(&self) -> std::option::Option<&crate::model::HyperParameterTuningJobConfig> {
        self.hpo_config.as_ref()
    }
    /// <p>Describes the dataset group that contains the data to use to train the predictor.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The featurization configuration.</p>
    pub fn featurization_config(&self) -> std::option::Option<&crate::model::FeaturizationConfig> {
        self.featurization_config.as_ref()
    }
    /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
    /// the key.</p>
    pub fn encryption_config(&self) -> std::option::Option<&crate::model::EncryptionConfig> {
        self.encryption_config.as_ref()
    }
    /// <p>Details on the the status and results of the backtests performed to evaluate the accuracy
    /// of the predictor. You specify the number of backtests to perform when you call the  operation.</p>
    pub fn predictor_execution_details(
        &self,
    ) -> std::option::Option<&crate::model::PredictorExecutionDetails> {
        self.predictor_execution_details.as_ref()
    }
    /// <p>The estimated time remaining in minutes for the predictor training job to complete.</p>
    pub fn estimated_time_remaining_in_minutes(&self) -> std::option::Option<i64> {
        self.estimated_time_remaining_in_minutes
    }
    /// <p>An array of the ARNs of the dataset import jobs used to import training data for the
    /// predictor.</p>
    pub fn dataset_import_job_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.dataset_import_job_arns.as_deref()
    }
    /// <p>When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.</p>
    pub fn auto_ml_algorithm_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_ml_algorithm_arns.as_deref()
    }
    /// <p>The status of the predictor. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use
    /// the predictor to create a forecast.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the model training task was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modification_time.as_ref()
    }
    /// <p>The accuracy metric used to optimize the predictor.</p>
    pub fn optimization_metric(&self) -> std::option::Option<&crate::model::OptimizationMetric> {
        self.optimization_metric.as_ref()
    }
}
impl std::fmt::Debug for DescribePredictorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePredictorOutput");
        formatter.field("predictor_arn", &self.predictor_arn);
        formatter.field("predictor_name", &self.predictor_name);
        formatter.field("algorithm_arn", &self.algorithm_arn);
        formatter.field("forecast_horizon", &self.forecast_horizon);
        formatter.field("forecast_types", &self.forecast_types);
        formatter.field("perform_auto_ml", &self.perform_auto_ml);
        formatter.field("auto_ml_override_strategy", &self.auto_ml_override_strategy);
        formatter.field("perform_hpo", &self.perform_hpo);
        formatter.field("training_parameters", &self.training_parameters);
        formatter.field("evaluation_parameters", &self.evaluation_parameters);
        formatter.field("hpo_config", &self.hpo_config);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("featurization_config", &self.featurization_config);
        formatter.field("encryption_config", &self.encryption_config);
        formatter.field(
            "predictor_execution_details",
            &self.predictor_execution_details,
        );
        formatter.field(
            "estimated_time_remaining_in_minutes",
            &self.estimated_time_remaining_in_minutes,
        );
        formatter.field("dataset_import_job_arns", &self.dataset_import_job_arns);
        formatter.field("auto_ml_algorithm_arns", &self.auto_ml_algorithm_arns);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.field("optimization_metric", &self.optimization_metric);
        formatter.finish()
    }
}
/// See [`DescribePredictorOutput`](crate::output::DescribePredictorOutput)
pub mod describe_predictor_output {
    /// A builder for [`DescribePredictorOutput`](crate::output::DescribePredictorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_arn: std::option::Option<std::string::String>,
        pub(crate) predictor_name: std::option::Option<std::string::String>,
        pub(crate) algorithm_arn: std::option::Option<std::string::String>,
        pub(crate) forecast_horizon: std::option::Option<i32>,
        pub(crate) forecast_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) perform_auto_ml: std::option::Option<bool>,
        pub(crate) auto_ml_override_strategy:
            std::option::Option<crate::model::AutoMlOverrideStrategy>,
        pub(crate) perform_hpo: std::option::Option<bool>,
        pub(crate) training_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) evaluation_parameters: std::option::Option<crate::model::EvaluationParameters>,
        pub(crate) hpo_config: std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) featurization_config: std::option::Option<crate::model::FeaturizationConfig>,
        pub(crate) encryption_config: std::option::Option<crate::model::EncryptionConfig>,
        pub(crate) predictor_execution_details:
            std::option::Option<crate::model::PredictorExecutionDetails>,
        pub(crate) estimated_time_remaining_in_minutes: std::option::Option<i64>,
        pub(crate) dataset_import_job_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_ml_algorithm_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) optimization_metric: std::option::Option<crate::model::OptimizationMetric>,
    }
    impl Builder {
        /// <p>The ARN of the predictor.</p>
        pub fn predictor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the predictor.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_arn = input;
            self
        }
        /// <p>The name of the predictor.</p>
        pub fn predictor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_name = Some(input.into());
            self
        }
        /// <p>The name of the predictor.</p>
        pub fn set_predictor_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm used for model training.</p>
        pub fn algorithm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm used for model training.</p>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_arn = input;
            self
        }
        /// <p>The number of time-steps of the forecast. The forecast horizon is also called the
        /// prediction length.</p>
        pub fn forecast_horizon(mut self, input: i32) -> Self {
            self.forecast_horizon = Some(input);
            self
        }
        /// <p>The number of time-steps of the forecast. The forecast horizon is also called the
        /// prediction length.</p>
        pub fn set_forecast_horizon(mut self, input: std::option::Option<i32>) -> Self {
            self.forecast_horizon = input;
            self
        }
        /// Appends an item to `forecast_types`.
        ///
        /// To override the contents of this collection use [`set_forecast_types`](Self::set_forecast_types).
        ///
        /// <p>The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
        /// </p>
        pub fn forecast_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.forecast_types.unwrap_or_default();
            v.push(input.into());
            self.forecast_types = Some(v);
            self
        }
        /// <p>The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
        /// </p>
        pub fn set_forecast_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.forecast_types = input;
            self
        }
        /// <p>Whether the predictor is set to perform AutoML.</p>
        pub fn perform_auto_ml(mut self, input: bool) -> Self {
            self.perform_auto_ml = Some(input);
            self
        }
        /// <p>Whether the predictor is set to perform AutoML.</p>
        pub fn set_perform_auto_ml(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_auto_ml = input;
            self
        }
        /// <note>
        /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
        /// Contact AWS Support or your account manager to learn more about access privileges.
        /// </p>
        /// </note>
        /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
        /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
        /// <p>This parameter is only valid for predictors trained using AutoML.</p>
        pub fn auto_ml_override_strategy(
            mut self,
            input: crate::model::AutoMlOverrideStrategy,
        ) -> Self {
            self.auto_ml_override_strategy = Some(input);
            self
        }
        /// <note>
        /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
        /// Contact AWS Support or your account manager to learn more about access privileges.
        /// </p>
        /// </note>
        /// <p>The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code>
        /// is specified, the AutoML strategy optimizes predictor accuracy.</p>
        /// <p>This parameter is only valid for predictors trained using AutoML.</p>
        pub fn set_auto_ml_override_strategy(
            mut self,
            input: std::option::Option<crate::model::AutoMlOverrideStrategy>,
        ) -> Self {
            self.auto_ml_override_strategy = input;
            self
        }
        /// <p>Whether the predictor is set to perform hyperparameter optimization (HPO).</p>
        pub fn perform_hpo(mut self, input: bool) -> Self {
            self.perform_hpo = Some(input);
            self
        }
        /// <p>Whether the predictor is set to perform hyperparameter optimization (HPO).</p>
        pub fn set_perform_hpo(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_hpo = input;
            self
        }
        /// Adds a key-value pair to `training_parameters`.
        ///
        /// To override the contents of this collection use [`set_training_parameters`](Self::set_training_parameters).
        ///
        /// <p>The default training parameters or overrides selected during model training. When running
        /// AutoML or choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen
        /// hyperparameters are returned. For more information, see <a>aws-forecast-choosing-recipes</a>.</p>
        pub fn training_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.training_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.training_parameters = Some(hash_map);
            self
        }
        /// <p>The default training parameters or overrides selected during model training. When running
        /// AutoML or choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen
        /// hyperparameters are returned. For more information, see <a>aws-forecast-choosing-recipes</a>.</p>
        pub fn set_training_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.training_parameters = input;
            self
        }
        /// <p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast
        /// evaluates a predictor by splitting a dataset into training data and testing data. The
        /// evaluation parameters define how to perform the split and the number of iterations.</p>
        pub fn evaluation_parameters(mut self, input: crate::model::EvaluationParameters) -> Self {
            self.evaluation_parameters = Some(input);
            self
        }
        /// <p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast
        /// evaluates a predictor by splitting a dataset into training data and testing data. The
        /// evaluation parameters define how to perform the split and the number of iterations.</p>
        pub fn set_evaluation_parameters(
            mut self,
            input: std::option::Option<crate::model::EvaluationParameters>,
        ) -> Self {
            self.evaluation_parameters = input;
            self
        }
        /// <p>The hyperparameter override values for the algorithm.</p>
        pub fn hpo_config(mut self, input: crate::model::HyperParameterTuningJobConfig) -> Self {
            self.hpo_config = Some(input);
            self
        }
        /// <p>The hyperparameter override values for the algorithm.</p>
        pub fn set_hpo_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        ) -> Self {
            self.hpo_config = input;
            self
        }
        /// <p>Describes the dataset group that contains the data to use to train the predictor.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Describes the dataset group that contains the data to use to train the predictor.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The featurization configuration.</p>
        pub fn featurization_config(mut self, input: crate::model::FeaturizationConfig) -> Self {
            self.featurization_config = Some(input);
            self
        }
        /// <p>The featurization configuration.</p>
        pub fn set_featurization_config(
            mut self,
            input: std::option::Option<crate::model::FeaturizationConfig>,
        ) -> Self {
            self.featurization_config = input;
            self
        }
        /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.encryption_config = Some(input);
            self
        }
        /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.encryption_config = input;
            self
        }
        /// <p>Details on the the status and results of the backtests performed to evaluate the accuracy
        /// of the predictor. You specify the number of backtests to perform when you call the  operation.</p>
        pub fn predictor_execution_details(
            mut self,
            input: crate::model::PredictorExecutionDetails,
        ) -> Self {
            self.predictor_execution_details = Some(input);
            self
        }
        /// <p>Details on the the status and results of the backtests performed to evaluate the accuracy
        /// of the predictor. You specify the number of backtests to perform when you call the  operation.</p>
        pub fn set_predictor_execution_details(
            mut self,
            input: std::option::Option<crate::model::PredictorExecutionDetails>,
        ) -> Self {
            self.predictor_execution_details = input;
            self
        }
        /// <p>The estimated time remaining in minutes for the predictor training job to complete.</p>
        pub fn estimated_time_remaining_in_minutes(mut self, input: i64) -> Self {
            self.estimated_time_remaining_in_minutes = Some(input);
            self
        }
        /// <p>The estimated time remaining in minutes for the predictor training job to complete.</p>
        pub fn set_estimated_time_remaining_in_minutes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_time_remaining_in_minutes = input;
            self
        }
        /// Appends an item to `dataset_import_job_arns`.
        ///
        /// To override the contents of this collection use [`set_dataset_import_job_arns`](Self::set_dataset_import_job_arns).
        ///
        /// <p>An array of the ARNs of the dataset import jobs used to import training data for the
        /// predictor.</p>
        pub fn dataset_import_job_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dataset_import_job_arns.unwrap_or_default();
            v.push(input.into());
            self.dataset_import_job_arns = Some(v);
            self
        }
        /// <p>An array of the ARNs of the dataset import jobs used to import training data for the
        /// predictor.</p>
        pub fn set_dataset_import_job_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dataset_import_job_arns = input;
            self
        }
        /// Appends an item to `auto_ml_algorithm_arns`.
        ///
        /// To override the contents of this collection use [`set_auto_ml_algorithm_arns`](Self::set_auto_ml_algorithm_arns).
        ///
        /// <p>When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.</p>
        pub fn auto_ml_algorithm_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_ml_algorithm_arns.unwrap_or_default();
            v.push(input.into());
            self.auto_ml_algorithm_arns = Some(v);
            self
        }
        /// <p>When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.</p>
        pub fn set_auto_ml_algorithm_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_ml_algorithm_arns = input;
            self
        }
        /// <p>The status of the predictor. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use
        /// the predictor to create a forecast.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the predictor. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use
        /// the predictor to create a forecast.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the model training task was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the model training task was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// <p>The accuracy metric used to optimize the predictor.</p>
        pub fn optimization_metric(mut self, input: crate::model::OptimizationMetric) -> Self {
            self.optimization_metric = Some(input);
            self
        }
        /// <p>The accuracy metric used to optimize the predictor.</p>
        pub fn set_optimization_metric(
            mut self,
            input: std::option::Option<crate::model::OptimizationMetric>,
        ) -> Self {
            self.optimization_metric = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePredictorOutput`](crate::output::DescribePredictorOutput)
        pub fn build(self) -> crate::output::DescribePredictorOutput {
            crate::output::DescribePredictorOutput {
                predictor_arn: self.predictor_arn,
                predictor_name: self.predictor_name,
                algorithm_arn: self.algorithm_arn,
                forecast_horizon: self.forecast_horizon,
                forecast_types: self.forecast_types,
                perform_auto_ml: self.perform_auto_ml,
                auto_ml_override_strategy: self.auto_ml_override_strategy,
                perform_hpo: self.perform_hpo,
                training_parameters: self.training_parameters,
                evaluation_parameters: self.evaluation_parameters,
                hpo_config: self.hpo_config,
                input_data_config: self.input_data_config,
                featurization_config: self.featurization_config,
                encryption_config: self.encryption_config,
                predictor_execution_details: self.predictor_execution_details,
                estimated_time_remaining_in_minutes: self.estimated_time_remaining_in_minutes,
                dataset_import_job_arns: self.dataset_import_job_arns,
                auto_ml_algorithm_arns: self.auto_ml_algorithm_arns,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
                optimization_metric: self.optimization_metric,
            }
        }
    }
}
impl DescribePredictorOutput {
    /// Creates a new builder-style object to manufacture [`DescribePredictorOutput`](crate::output::DescribePredictorOutput)
    pub fn builder() -> crate::output::describe_predictor_output::Builder {
        crate::output::describe_predictor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeForecastExportJobOutput {
    /// <p>The ARN of the forecast export job.</p>
    pub forecast_export_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the forecast export job.</p>
    pub forecast_export_job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the exported forecast.</p>
    pub forecast_arn: std::option::Option<std::string::String>,
    /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
    pub destination: std::option::Option<crate::model::DataDestination>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The status of the forecast export job. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before
    /// you can access the forecast in your S3 bucket.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>When the forecast export job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeForecastExportJobOutput {
    /// <p>The ARN of the forecast export job.</p>
    pub fn forecast_export_job_arn(&self) -> std::option::Option<&str> {
        self.forecast_export_job_arn.as_deref()
    }
    /// <p>The name of the forecast export job.</p>
    pub fn forecast_export_job_name(&self) -> std::option::Option<&str> {
        self.forecast_export_job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the exported forecast.</p>
    pub fn forecast_arn(&self) -> std::option::Option<&str> {
        self.forecast_arn.as_deref()
    }
    /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::DataDestination> {
        self.destination.as_ref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The status of the forecast export job. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before
    /// you can access the forecast in your S3 bucket.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>When the forecast export job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeForecastExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeForecastExportJobOutput");
        formatter.field("forecast_export_job_arn", &self.forecast_export_job_arn);
        formatter.field("forecast_export_job_name", &self.forecast_export_job_name);
        formatter.field("forecast_arn", &self.forecast_arn);
        formatter.field("destination", &self.destination);
        formatter.field("message", &self.message);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DescribeForecastExportJobOutput`](crate::output::DescribeForecastExportJobOutput)
pub mod describe_forecast_export_job_output {
    /// A builder for [`DescribeForecastExportJobOutput`](crate::output::DescribeForecastExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_export_job_arn: std::option::Option<std::string::String>,
        pub(crate) forecast_export_job_name: std::option::Option<std::string::String>,
        pub(crate) forecast_arn: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::DataDestination>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the forecast export job.</p>
        pub fn forecast_export_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_export_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the forecast export job.</p>
        pub fn set_forecast_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_export_job_arn = input;
            self
        }
        /// <p>The name of the forecast export job.</p>
        pub fn forecast_export_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_export_job_name = Some(input.into());
            self
        }
        /// <p>The name of the forecast export job.</p>
        pub fn set_forecast_export_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_export_job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the exported forecast.</p>
        pub fn forecast_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the exported forecast.</p>
        pub fn set_forecast_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.forecast_arn = input;
            self
        }
        /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
        pub fn destination(mut self, input: crate::model::DataDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DataDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The status of the forecast export job. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before
        /// you can access the forecast in your S3 bucket.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the forecast export job. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before
        /// you can access the forecast in your S3 bucket.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>When the forecast export job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the forecast export job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeForecastExportJobOutput`](crate::output::DescribeForecastExportJobOutput)
        pub fn build(self) -> crate::output::DescribeForecastExportJobOutput {
            crate::output::DescribeForecastExportJobOutput {
                forecast_export_job_arn: self.forecast_export_job_arn,
                forecast_export_job_name: self.forecast_export_job_name,
                forecast_arn: self.forecast_arn,
                destination: self.destination,
                message: self.message,
                status: self.status,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DescribeForecastExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeForecastExportJobOutput`](crate::output::DescribeForecastExportJobOutput)
    pub fn builder() -> crate::output::describe_forecast_export_job_output::Builder {
        crate::output::describe_forecast_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeForecastOutput {
    /// <p>The forecast ARN as specified in the request.</p>
    pub forecast_arn: std::option::Option<std::string::String>,
    /// <p>The name of the forecast.</p>
    pub forecast_name: std::option::Option<std::string::String>,
    /// <p>The quantiles at which probabilistic forecasts were generated.</p>
    pub forecast_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the predictor used to generate the forecast.</p>
    pub predictor_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the dataset group that provided the data used to train the predictor.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The estimated time remaining in minutes for the forecast job to complete.</p>
    pub estimated_time_remaining_in_minutes: std::option::Option<i64>,
    /// <p>The status of the forecast. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query
    /// or export the forecast.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the forecast creation task was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeForecastOutput {
    /// <p>The forecast ARN as specified in the request.</p>
    pub fn forecast_arn(&self) -> std::option::Option<&str> {
        self.forecast_arn.as_deref()
    }
    /// <p>The name of the forecast.</p>
    pub fn forecast_name(&self) -> std::option::Option<&str> {
        self.forecast_name.as_deref()
    }
    /// <p>The quantiles at which probabilistic forecasts were generated.</p>
    pub fn forecast_types(&self) -> std::option::Option<&[std::string::String]> {
        self.forecast_types.as_deref()
    }
    /// <p>The ARN of the predictor used to generate the forecast.</p>
    pub fn predictor_arn(&self) -> std::option::Option<&str> {
        self.predictor_arn.as_deref()
    }
    /// <p>The ARN of the dataset group that provided the data used to train the predictor.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The estimated time remaining in minutes for the forecast job to complete.</p>
    pub fn estimated_time_remaining_in_minutes(&self) -> std::option::Option<i64> {
        self.estimated_time_remaining_in_minutes
    }
    /// <p>The status of the forecast. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query
    /// or export the forecast.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the forecast creation task was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeForecastOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeForecastOutput");
        formatter.field("forecast_arn", &self.forecast_arn);
        formatter.field("forecast_name", &self.forecast_name);
        formatter.field("forecast_types", &self.forecast_types);
        formatter.field("predictor_arn", &self.predictor_arn);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field(
            "estimated_time_remaining_in_minutes",
            &self.estimated_time_remaining_in_minutes,
        );
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DescribeForecastOutput`](crate::output::DescribeForecastOutput)
pub mod describe_forecast_output {
    /// A builder for [`DescribeForecastOutput`](crate::output::DescribeForecastOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_arn: std::option::Option<std::string::String>,
        pub(crate) forecast_name: std::option::Option<std::string::String>,
        pub(crate) forecast_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) predictor_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) estimated_time_remaining_in_minutes: std::option::Option<i64>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The forecast ARN as specified in the request.</p>
        pub fn forecast_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_arn = Some(input.into());
            self
        }
        /// <p>The forecast ARN as specified in the request.</p>
        pub fn set_forecast_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.forecast_arn = input;
            self
        }
        /// <p>The name of the forecast.</p>
        pub fn forecast_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_name = Some(input.into());
            self
        }
        /// <p>The name of the forecast.</p>
        pub fn set_forecast_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_name = input;
            self
        }
        /// Appends an item to `forecast_types`.
        ///
        /// To override the contents of this collection use [`set_forecast_types`](Self::set_forecast_types).
        ///
        /// <p>The quantiles at which probabilistic forecasts were generated.</p>
        pub fn forecast_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.forecast_types.unwrap_or_default();
            v.push(input.into());
            self.forecast_types = Some(v);
            self
        }
        /// <p>The quantiles at which probabilistic forecasts were generated.</p>
        pub fn set_forecast_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.forecast_types = input;
            self
        }
        /// <p>The ARN of the predictor used to generate the forecast.</p>
        pub fn predictor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the predictor used to generate the forecast.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_arn = input;
            self
        }
        /// <p>The ARN of the dataset group that provided the data used to train the predictor.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group that provided the data used to train the predictor.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The estimated time remaining in minutes for the forecast job to complete.</p>
        pub fn estimated_time_remaining_in_minutes(mut self, input: i64) -> Self {
            self.estimated_time_remaining_in_minutes = Some(input);
            self
        }
        /// <p>The estimated time remaining in minutes for the forecast job to complete.</p>
        pub fn set_estimated_time_remaining_in_minutes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_time_remaining_in_minutes = input;
            self
        }
        /// <p>The status of the forecast. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query
        /// or export the forecast.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the forecast. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query
        /// or export the forecast.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the forecast creation task was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the forecast creation task was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeForecastOutput`](crate::output::DescribeForecastOutput)
        pub fn build(self) -> crate::output::DescribeForecastOutput {
            crate::output::DescribeForecastOutput {
                forecast_arn: self.forecast_arn,
                forecast_name: self.forecast_name,
                forecast_types: self.forecast_types,
                predictor_arn: self.predictor_arn,
                dataset_group_arn: self.dataset_group_arn,
                estimated_time_remaining_in_minutes: self.estimated_time_remaining_in_minutes,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DescribeForecastOutput {
    /// Creates a new builder-style object to manufacture [`DescribeForecastOutput`](crate::output::DescribeForecastOutput)
    pub fn builder() -> crate::output::describe_forecast_output::Builder {
        crate::output::describe_forecast_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetImportJobOutput {
    /// <p>The name of the dataset import job.</p>
    pub dataset_import_job_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the dataset import job.</p>
    pub dataset_import_job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset that the training data was imported
    /// to.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The format of timestamps in the dataset. The format that you specify depends on the
    /// <code>DataFrequency</code> specified when the dataset was created. The following formats are
    /// supported</p>
    /// <ul>
    /// <li>
    /// <p>"yyyy-MM-dd"</p>
    /// <p>For the following data frequencies: Y, M, W, and D</p>
    /// </li>
    /// <li>
    /// <p>"yyyy-MM-dd HH:mm:ss"</p>
    /// <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y,
    /// M, W, and D</p>
    /// </li>
    /// </ul>
    pub timestamp_format: std::option::Option<std::string::String>,
    /// <p>The single time zone applied to every item in the dataset</p>
    pub time_zone: std::option::Option<std::string::String>,
    /// <p>Whether <code>TimeZone</code> is automatically derived from the geolocation
    /// attribute.</p>
    pub use_geolocation_for_time_zone: bool,
    /// <p>The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and
    /// <code>"CC_POSTALCODE"</code>.</p>
    pub geolocation_format: std::option::Option<std::string::String>,
    /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast
    /// can assume to access the data.</p>
    /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>The estimated time remaining in minutes for the dataset import job to complete.</p>
    pub estimated_time_remaining_in_minutes: std::option::Option<i64>,
    /// <p>Statistical information about each field in the input data.</p>
    pub field_statistics: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Statistics>,
    >,
    /// <p>The size of the dataset in gigabytes (GB) after the import job has finished.</p>
    pub data_size: std::option::Option<f64>,
    /// <p>The status of the dataset import job. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurred, an informational message about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the dataset import job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time the resource was modified. The timestamp depends on the status of the
    /// job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub last_modification_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeDatasetImportJobOutput {
    /// <p>The name of the dataset import job.</p>
    pub fn dataset_import_job_name(&self) -> std::option::Option<&str> {
        self.dataset_import_job_name.as_deref()
    }
    /// <p>The ARN of the dataset import job.</p>
    pub fn dataset_import_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_import_job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset that the training data was imported
    /// to.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The format of timestamps in the dataset. The format that you specify depends on the
    /// <code>DataFrequency</code> specified when the dataset was created. The following formats are
    /// supported</p>
    /// <ul>
    /// <li>
    /// <p>"yyyy-MM-dd"</p>
    /// <p>For the following data frequencies: Y, M, W, and D</p>
    /// </li>
    /// <li>
    /// <p>"yyyy-MM-dd HH:mm:ss"</p>
    /// <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y,
    /// M, W, and D</p>
    /// </li>
    /// </ul>
    pub fn timestamp_format(&self) -> std::option::Option<&str> {
        self.timestamp_format.as_deref()
    }
    /// <p>The single time zone applied to every item in the dataset</p>
    pub fn time_zone(&self) -> std::option::Option<&str> {
        self.time_zone.as_deref()
    }
    /// <p>Whether <code>TimeZone</code> is automatically derived from the geolocation
    /// attribute.</p>
    pub fn use_geolocation_for_time_zone(&self) -> bool {
        self.use_geolocation_for_time_zone
    }
    /// <p>The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and
    /// <code>"CC_POSTALCODE"</code>.</p>
    pub fn geolocation_format(&self) -> std::option::Option<&str> {
        self.geolocation_format.as_deref()
    }
    /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast
    /// can assume to access the data.</p>
    /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::DataSource> {
        self.data_source.as_ref()
    }
    /// <p>The estimated time remaining in minutes for the dataset import job to complete.</p>
    pub fn estimated_time_remaining_in_minutes(&self) -> std::option::Option<i64> {
        self.estimated_time_remaining_in_minutes
    }
    /// <p>Statistical information about each field in the input data.</p>
    pub fn field_statistics(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::Statistics>,
    > {
        self.field_statistics.as_ref()
    }
    /// <p>The size of the dataset in gigabytes (GB) after the import job has finished.</p>
    pub fn data_size(&self) -> std::option::Option<f64> {
        self.data_size
    }
    /// <p>The status of the dataset import job. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an error occurred, an informational message about the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the dataset import job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the resource was modified. The timestamp depends on the status of the
    /// job:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
    /// failed.</p>
    /// </li>
    /// </ul>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetImportJobOutput");
        formatter.field("dataset_import_job_name", &self.dataset_import_job_name);
        formatter.field("dataset_import_job_arn", &self.dataset_import_job_arn);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("timestamp_format", &self.timestamp_format);
        formatter.field("time_zone", &self.time_zone);
        formatter.field(
            "use_geolocation_for_time_zone",
            &self.use_geolocation_for_time_zone,
        );
        formatter.field("geolocation_format", &self.geolocation_format);
        formatter.field("data_source", &self.data_source);
        formatter.field(
            "estimated_time_remaining_in_minutes",
            &self.estimated_time_remaining_in_minutes,
        );
        formatter.field("field_statistics", &self.field_statistics);
        formatter.field("data_size", &self.data_size);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
pub mod describe_dataset_import_job_output {
    /// A builder for [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_job_name: std::option::Option<std::string::String>,
        pub(crate) dataset_import_job_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) timestamp_format: std::option::Option<std::string::String>,
        pub(crate) time_zone: std::option::Option<std::string::String>,
        pub(crate) use_geolocation_for_time_zone: std::option::Option<bool>,
        pub(crate) geolocation_format: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) estimated_time_remaining_in_minutes: std::option::Option<i64>,
        pub(crate) field_statistics: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Statistics>,
        >,
        pub(crate) data_size: std::option::Option<f64>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the dataset import job.</p>
        pub fn dataset_import_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset import job.</p>
        pub fn set_dataset_import_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_name = input;
            self
        }
        /// <p>The ARN of the dataset import job.</p>
        pub fn dataset_import_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset import job.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that the training data was imported
        /// to.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that the training data was imported
        /// to.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The format of timestamps in the dataset. The format that you specify depends on the
        /// <code>DataFrequency</code> specified when the dataset was created. The following formats are
        /// supported</p>
        /// <ul>
        /// <li>
        /// <p>"yyyy-MM-dd"</p>
        /// <p>For the following data frequencies: Y, M, W, and D</p>
        /// </li>
        /// <li>
        /// <p>"yyyy-MM-dd HH:mm:ss"</p>
        /// <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y,
        /// M, W, and D</p>
        /// </li>
        /// </ul>
        pub fn timestamp_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp_format = Some(input.into());
            self
        }
        /// <p>The format of timestamps in the dataset. The format that you specify depends on the
        /// <code>DataFrequency</code> specified when the dataset was created. The following formats are
        /// supported</p>
        /// <ul>
        /// <li>
        /// <p>"yyyy-MM-dd"</p>
        /// <p>For the following data frequencies: Y, M, W, and D</p>
        /// </li>
        /// <li>
        /// <p>"yyyy-MM-dd HH:mm:ss"</p>
        /// <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y,
        /// M, W, and D</p>
        /// </li>
        /// </ul>
        pub fn set_timestamp_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timestamp_format = input;
            self
        }
        /// <p>The single time zone applied to every item in the dataset</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone = Some(input.into());
            self
        }
        /// <p>The single time zone applied to every item in the dataset</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone = input;
            self
        }
        /// <p>Whether <code>TimeZone</code> is automatically derived from the geolocation
        /// attribute.</p>
        pub fn use_geolocation_for_time_zone(mut self, input: bool) -> Self {
            self.use_geolocation_for_time_zone = Some(input);
            self
        }
        /// <p>Whether <code>TimeZone</code> is automatically derived from the geolocation
        /// attribute.</p>
        pub fn set_use_geolocation_for_time_zone(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_geolocation_for_time_zone = input;
            self
        }
        /// <p>The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and
        /// <code>"CC_POSTALCODE"</code>.</p>
        pub fn geolocation_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.geolocation_format = Some(input.into());
            self
        }
        /// <p>The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and
        /// <code>"CC_POSTALCODE"</code>.</p>
        pub fn set_geolocation_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.geolocation_format = input;
            self
        }
        /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast
        /// can assume to access the data.</p>
        /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast
        /// can assume to access the data.</p>
        /// <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The estimated time remaining in minutes for the dataset import job to complete.</p>
        pub fn estimated_time_remaining_in_minutes(mut self, input: i64) -> Self {
            self.estimated_time_remaining_in_minutes = Some(input);
            self
        }
        /// <p>The estimated time remaining in minutes for the dataset import job to complete.</p>
        pub fn set_estimated_time_remaining_in_minutes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_time_remaining_in_minutes = input;
            self
        }
        /// Adds a key-value pair to `field_statistics`.
        ///
        /// To override the contents of this collection use [`set_field_statistics`](Self::set_field_statistics).
        ///
        /// <p>Statistical information about each field in the input data.</p>
        pub fn field_statistics(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Statistics>,
        ) -> Self {
            let mut hash_map = self.field_statistics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.field_statistics = Some(hash_map);
            self
        }
        /// <p>Statistical information about each field in the input data.</p>
        pub fn set_field_statistics(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Statistics>,
            >,
        ) -> Self {
            self.field_statistics = input;
            self
        }
        /// <p>The size of the dataset in gigabytes (GB) after the import job has finished.</p>
        pub fn data_size(mut self, input: f64) -> Self {
            self.data_size = Some(input);
            self
        }
        /// <p>The size of the dataset in gigabytes (GB) after the import job has finished.</p>
        pub fn set_data_size(mut self, input: std::option::Option<f64>) -> Self {
            self.data_size = input;
            self
        }
        /// <p>The status of the dataset import job. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset import job. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, an informational message about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the dataset import job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the dataset import job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the
        /// job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn last_modification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The last time the resource was modified. The timestamp depends on the status of the
        /// job:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code> - The <code>CreationTime</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPING</code> - The current timestamp.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_STOPPED</code> - When the job stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or
        /// failed.</p>
        /// </li>
        /// </ul>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
        pub fn build(self) -> crate::output::DescribeDatasetImportJobOutput {
            crate::output::DescribeDatasetImportJobOutput {
                dataset_import_job_name: self.dataset_import_job_name,
                dataset_import_job_arn: self.dataset_import_job_arn,
                dataset_arn: self.dataset_arn,
                timestamp_format: self.timestamp_format,
                time_zone: self.time_zone,
                use_geolocation_for_time_zone: self
                    .use_geolocation_for_time_zone
                    .unwrap_or_default(),
                geolocation_format: self.geolocation_format,
                data_source: self.data_source,
                estimated_time_remaining_in_minutes: self.estimated_time_remaining_in_minutes,
                field_statistics: self.field_statistics,
                data_size: self.data_size,
                status: self.status,
                message: self.message,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DescribeDatasetImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
    pub fn builder() -> crate::output::describe_dataset_import_job_output::Builder {
        crate::output::describe_dataset_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetGroupOutput {
    /// <p>The name of the dataset group.</p>
    pub dataset_group_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset
    /// group.</p>
    pub dataset_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The domain associated with the dataset group.</p>
    pub domain: std::option::Option<crate::model::Domain>,
    /// <p>The status of the dataset group. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
    /// <code>UPDATE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.</p>
    /// <note>
    /// <p>The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can
    /// use the dataset group to create a predictor.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>When the dataset group was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While the dataset group is being updated,
    /// <code>LastModificationTime</code> is the current time of the
    /// <code>DescribeDatasetGroup</code> call.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeDatasetGroupOutput {
    /// <p>The name of the dataset group.</p>
    pub fn dataset_group_name(&self) -> std::option::Option<&str> {
        self.dataset_group_name.as_deref()
    }
    /// <p>The ARN of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset
    /// group.</p>
    pub fn dataset_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.dataset_arns.as_deref()
    }
    /// <p>The domain associated with the dataset group.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
    /// <p>The status of the dataset group. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
    /// <code>UPDATE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.</p>
    /// <note>
    /// <p>The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can
    /// use the dataset group to create a predictor.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>When the dataset group was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While the dataset group is being updated,
    /// <code>LastModificationTime</code> is the current time of the
    /// <code>DescribeDatasetGroup</code> call.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetGroupOutput");
        formatter.field("dataset_group_name", &self.dataset_group_name);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("dataset_arns", &self.dataset_arns);
        formatter.field("domain", &self.domain);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
pub mod describe_dataset_group_output {
    /// A builder for [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_name: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the dataset group.</p>
        pub fn dataset_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset group.</p>
        pub fn set_dataset_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_name = input;
            self
        }
        /// <p>The ARN of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// Appends an item to `dataset_arns`.
        ///
        /// To override the contents of this collection use [`set_dataset_arns`](Self::set_dataset_arns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset
        /// group.</p>
        pub fn dataset_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dataset_arns.unwrap_or_default();
            v.push(input.into());
            self.dataset_arns = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset
        /// group.</p>
        pub fn set_dataset_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dataset_arns = input;
            self
        }
        /// <p>The domain associated with the dataset group.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain associated with the dataset group.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The status of the dataset group. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
        /// <code>UPDATE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.</p>
        /// <note>
        /// <p>The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can
        /// use the dataset group to create a predictor.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset group. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
        /// <code>UPDATE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.</p>
        /// <note>
        /// <p>The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can
        /// use the dataset group to create a predictor.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>When the dataset group was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the dataset group was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While the dataset group is being updated,
        /// <code>LastModificationTime</code> is the current time of the
        /// <code>DescribeDatasetGroup</code> call.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While the dataset group is being updated,
        /// <code>LastModificationTime</code> is the current time of the
        /// <code>DescribeDatasetGroup</code> call.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
        pub fn build(self) -> crate::output::DescribeDatasetGroupOutput {
            crate::output::DescribeDatasetGroupOutput {
                dataset_group_name: self.dataset_group_name,
                dataset_group_arn: self.dataset_group_arn,
                dataset_arns: self.dataset_arns,
                domain: self.domain,
                status: self.status,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DescribeDatasetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
    pub fn builder() -> crate::output::describe_dataset_group_output::Builder {
        crate::output::describe_dataset_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The domain associated with the dataset.</p>
    pub domain: std::option::Option<crate::model::Domain>,
    /// <p>The dataset type.</p>
    pub dataset_type: std::option::Option<crate::model::DatasetType>,
    /// <p>The frequency of data collection.</p>
    /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes),
    /// 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example,
    /// "M" indicates every month and "30min" indicates every 30 minutes.</p>
    pub data_frequency: std::option::Option<std::string::String>,
    /// <p>An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
    /// <code>SchemaAttribute</code> specifies the name and data type of a field.</p>
    pub schema: std::option::Option<crate::model::Schema>,
    /// <p>The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
    /// the key.</p>
    pub encryption_config: std::option::Option<crate::model::EncryptionConfig>,
    /// <p>The status of the dataset. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
    /// <code>UPDATE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The <code>UPDATE</code> states apply while data is imported to the dataset from a call to
    /// the <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset
    /// import job. For example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the
    /// status of the dataset is <code>UPDATE_IN_PROGRESS</code>.</p>
    /// <note>
    /// <p>The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import
    /// training data.</p>
    /// </note>
    pub status: std::option::Option<std::string::String>,
    /// <p>When the dataset was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as
    /// <code>CreationTime</code>. While data is being imported to the dataset,
    /// <code>LastModificationTime</code> is the current time of the <code>DescribeDataset</code>
    /// call. After a <a>CreateDatasetImportJob</a> operation has finished,
    /// <code>LastModificationTime</code> is when the import job completed or failed.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeDatasetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The name of the dataset.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The domain associated with the dataset.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
    /// <p>The dataset type.</p>
    pub fn dataset_type(&self) -> std::option::Option<&crate::model::DatasetType> {
        self.dataset_type.as_ref()
    }
    /// <p>The frequency of data collection.</p>
    /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes),
    /// 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example,
    /// "M" indicates every month and "30min" indicates every 30 minutes.</p>
    pub fn data_frequency(&self) -> std::option::Option<&str> {
        self.data_frequency.as_deref()
    }
    /// <p>An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
    /// <code>SchemaAttribute</code> specifies the name and data type of a field.</p>
    pub fn schema(&self) -> std::option::Option<&crate::model::Schema> {
        self.schema.as_ref()
    }
    /// <p>The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
    /// the key.</p>
    pub fn encryption_config(&self) -> std::option::Option<&crate::model::EncryptionConfig> {
        self.encryption_config.as_ref()
    }
    /// <p>The status of the dataset. States include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
    /// <code>CREATE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
    /// <code>DELETE_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
    /// <code>UPDATE_FAILED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The <code>UPDATE</code> states apply while data is imported to the dataset from a call to
    /// the <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset
    /// import job. For example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the
    /// status of the dataset is <code>UPDATE_IN_PROGRESS</code>.</p>
    /// <note>
    /// <p>The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import
    /// training data.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>When the dataset was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as
    /// <code>CreationTime</code>. While data is being imported to the dataset,
    /// <code>LastModificationTime</code> is the current time of the <code>DescribeDataset</code>
    /// call. After a <a>CreateDatasetImportJob</a> operation has finished,
    /// <code>LastModificationTime</code> is when the import job completed or failed.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modification_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetOutput");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("domain", &self.domain);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("data_frequency", &self.data_frequency);
        formatter.field("schema", &self.schema);
        formatter.field("encryption_config", &self.encryption_config);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.finish()
    }
}
/// See [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
pub mod describe_dataset_output {
    /// A builder for [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
        pub(crate) dataset_type: std::option::Option<crate::model::DatasetType>,
        pub(crate) data_frequency: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<crate::model::Schema>,
        pub(crate) encryption_config: std::option::Option<crate::model::EncryptionConfig>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The domain associated with the dataset.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain associated with the dataset.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The dataset type.</p>
        pub fn dataset_type(mut self, input: crate::model::DatasetType) -> Self {
            self.dataset_type = Some(input);
            self
        }
        /// <p>The dataset type.</p>
        pub fn set_dataset_type(
            mut self,
            input: std::option::Option<crate::model::DatasetType>,
        ) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>The frequency of data collection.</p>
        /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes),
        /// 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example,
        /// "M" indicates every month and "30min" indicates every 30 minutes.</p>
        pub fn data_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_frequency = Some(input.into());
            self
        }
        /// <p>The frequency of data collection.</p>
        /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes),
        /// 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example,
        /// "M" indicates every month and "30min" indicates every 30 minutes.</p>
        pub fn set_data_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_frequency = input;
            self
        }
        /// <p>An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
        /// <code>SchemaAttribute</code> specifies the name and data type of a field.</p>
        pub fn schema(mut self, input: crate::model::Schema) -> Self {
            self.schema = Some(input);
            self
        }
        /// <p>An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each
        /// <code>SchemaAttribute</code> specifies the name and data type of a field.</p>
        pub fn set_schema(mut self, input: std::option::Option<crate::model::Schema>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.encryption_config = Some(input);
            self
        }
        /// <p>The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.encryption_config = input;
            self
        }
        /// <p>The status of the dataset. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
        /// <code>UPDATE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <code>UPDATE</code> states apply while data is imported to the dataset from a call to
        /// the <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset
        /// import job. For example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the
        /// status of the dataset is <code>UPDATE_IN_PROGRESS</code>.</p>
        /// <note>
        /// <p>The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import
        /// training data.</p>
        /// </note>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset. States include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>,
        /// <code>CREATE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
        /// <code>DELETE_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>,
        /// <code>UPDATE_FAILED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <code>UPDATE</code> states apply while data is imported to the dataset from a call to
        /// the <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset
        /// import job. For example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the
        /// status of the dataset is <code>UPDATE_IN_PROGRESS</code>.</p>
        /// <note>
        /// <p>The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import
        /// training data.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>When the dataset was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the dataset was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as
        /// <code>CreationTime</code>. While data is being imported to the dataset,
        /// <code>LastModificationTime</code> is the current time of the <code>DescribeDataset</code>
        /// call. After a <a>CreateDatasetImportJob</a> operation has finished,
        /// <code>LastModificationTime</code> is when the import job completed or failed.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>When you create a dataset, <code>LastModificationTime</code> is the same as
        /// <code>CreationTime</code>. While data is being imported to the dataset,
        /// <code>LastModificationTime</code> is the current time of the <code>DescribeDataset</code>
        /// call. After a <a>CreateDatasetImportJob</a> operation has finished,
        /// <code>LastModificationTime</code> is when the import job completed or failed.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
        pub fn build(self) -> crate::output::DescribeDatasetOutput {
            crate::output::DescribeDatasetOutput {
                dataset_arn: self.dataset_arn,
                dataset_name: self.dataset_name,
                domain: self.domain,
                dataset_type: self.dataset_type,
                data_frequency: self.data_frequency,
                schema: self.schema,
                encryption_config: self.encryption_config,
                status: self.status,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
            }
        }
    }
}
impl DescribeDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    pub fn builder() -> crate::output::describe_dataset_output::Builder {
        crate::output::describe_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceTreeOutput {}
impl std::fmt::Debug for DeleteResourceTreeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceTreeOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourceTreeOutput`](crate::output::DeleteResourceTreeOutput)
pub mod delete_resource_tree_output {
    /// A builder for [`DeleteResourceTreeOutput`](crate::output::DeleteResourceTreeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourceTreeOutput`](crate::output::DeleteResourceTreeOutput)
        pub fn build(self) -> crate::output::DeleteResourceTreeOutput {
            crate::output::DeleteResourceTreeOutput {}
        }
    }
}
impl DeleteResourceTreeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourceTreeOutput`](crate::output::DeleteResourceTreeOutput)
    pub fn builder() -> crate::output::delete_resource_tree_output::Builder {
        crate::output::delete_resource_tree_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePredictorBacktestExportJobOutput {}
impl std::fmt::Debug for DeletePredictorBacktestExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePredictorBacktestExportJobOutput");
        formatter.finish()
    }
}
/// See [`DeletePredictorBacktestExportJobOutput`](crate::output::DeletePredictorBacktestExportJobOutput)
pub mod delete_predictor_backtest_export_job_output {
    /// A builder for [`DeletePredictorBacktestExportJobOutput`](crate::output::DeletePredictorBacktestExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePredictorBacktestExportJobOutput`](crate::output::DeletePredictorBacktestExportJobOutput)
        pub fn build(self) -> crate::output::DeletePredictorBacktestExportJobOutput {
            crate::output::DeletePredictorBacktestExportJobOutput {}
        }
    }
}
impl DeletePredictorBacktestExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DeletePredictorBacktestExportJobOutput`](crate::output::DeletePredictorBacktestExportJobOutput)
    pub fn builder() -> crate::output::delete_predictor_backtest_export_job_output::Builder {
        crate::output::delete_predictor_backtest_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePredictorOutput {}
impl std::fmt::Debug for DeletePredictorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePredictorOutput");
        formatter.finish()
    }
}
/// See [`DeletePredictorOutput`](crate::output::DeletePredictorOutput)
pub mod delete_predictor_output {
    /// A builder for [`DeletePredictorOutput`](crate::output::DeletePredictorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePredictorOutput`](crate::output::DeletePredictorOutput)
        pub fn build(self) -> crate::output::DeletePredictorOutput {
            crate::output::DeletePredictorOutput {}
        }
    }
}
impl DeletePredictorOutput {
    /// Creates a new builder-style object to manufacture [`DeletePredictorOutput`](crate::output::DeletePredictorOutput)
    pub fn builder() -> crate::output::delete_predictor_output::Builder {
        crate::output::delete_predictor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteForecastExportJobOutput {}
impl std::fmt::Debug for DeleteForecastExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteForecastExportJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteForecastExportJobOutput`](crate::output::DeleteForecastExportJobOutput)
pub mod delete_forecast_export_job_output {
    /// A builder for [`DeleteForecastExportJobOutput`](crate::output::DeleteForecastExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteForecastExportJobOutput`](crate::output::DeleteForecastExportJobOutput)
        pub fn build(self) -> crate::output::DeleteForecastExportJobOutput {
            crate::output::DeleteForecastExportJobOutput {}
        }
    }
}
impl DeleteForecastExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteForecastExportJobOutput`](crate::output::DeleteForecastExportJobOutput)
    pub fn builder() -> crate::output::delete_forecast_export_job_output::Builder {
        crate::output::delete_forecast_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteForecastOutput {}
impl std::fmt::Debug for DeleteForecastOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteForecastOutput");
        formatter.finish()
    }
}
/// See [`DeleteForecastOutput`](crate::output::DeleteForecastOutput)
pub mod delete_forecast_output {
    /// A builder for [`DeleteForecastOutput`](crate::output::DeleteForecastOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteForecastOutput`](crate::output::DeleteForecastOutput)
        pub fn build(self) -> crate::output::DeleteForecastOutput {
            crate::output::DeleteForecastOutput {}
        }
    }
}
impl DeleteForecastOutput {
    /// Creates a new builder-style object to manufacture [`DeleteForecastOutput`](crate::output::DeleteForecastOutput)
    pub fn builder() -> crate::output::delete_forecast_output::Builder {
        crate::output::delete_forecast_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetImportJobOutput {}
impl std::fmt::Debug for DeleteDatasetImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetImportJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteDatasetImportJobOutput`](crate::output::DeleteDatasetImportJobOutput)
pub mod delete_dataset_import_job_output {
    /// A builder for [`DeleteDatasetImportJobOutput`](crate::output::DeleteDatasetImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDatasetImportJobOutput`](crate::output::DeleteDatasetImportJobOutput)
        pub fn build(self) -> crate::output::DeleteDatasetImportJobOutput {
            crate::output::DeleteDatasetImportJobOutput {}
        }
    }
}
impl DeleteDatasetImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetImportJobOutput`](crate::output::DeleteDatasetImportJobOutput)
    pub fn builder() -> crate::output::delete_dataset_import_job_output::Builder {
        crate::output::delete_dataset_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetGroupOutput {}
impl std::fmt::Debug for DeleteDatasetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
pub mod delete_dataset_group_output {
    /// A builder for [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
        pub fn build(self) -> crate::output::DeleteDatasetGroupOutput {
            crate::output::DeleteDatasetGroupOutput {}
        }
    }
}
impl DeleteDatasetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
    pub fn builder() -> crate::output::delete_dataset_group_output::Builder {
        crate::output::delete_dataset_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetOutput {}
impl std::fmt::Debug for DeleteDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetOutput");
        formatter.finish()
    }
}
/// See [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
pub mod delete_dataset_output {
    /// A builder for [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
        pub fn build(self) -> crate::output::DeleteDatasetOutput {
            crate::output::DeleteDatasetOutput {}
        }
    }
}
impl DeleteDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    pub fn builder() -> crate::output::delete_dataset_output::Builder {
        crate::output::delete_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePredictorBacktestExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job that you want to
    /// export.</p>
    pub predictor_backtest_export_job_arn: std::option::Option<std::string::String>,
}
impl CreatePredictorBacktestExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job that you want to
    /// export.</p>
    pub fn predictor_backtest_export_job_arn(&self) -> std::option::Option<&str> {
        self.predictor_backtest_export_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreatePredictorBacktestExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePredictorBacktestExportJobOutput");
        formatter.field(
            "predictor_backtest_export_job_arn",
            &self.predictor_backtest_export_job_arn,
        );
        formatter.finish()
    }
}
/// See [`CreatePredictorBacktestExportJobOutput`](crate::output::CreatePredictorBacktestExportJobOutput)
pub mod create_predictor_backtest_export_job_output {
    /// A builder for [`CreatePredictorBacktestExportJobOutput`](crate::output::CreatePredictorBacktestExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_backtest_export_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job that you want to
        /// export.</p>
        pub fn predictor_backtest_export_job_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job that you want to
        /// export.</p>
        pub fn set_predictor_backtest_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_backtest_export_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePredictorBacktestExportJobOutput`](crate::output::CreatePredictorBacktestExportJobOutput)
        pub fn build(self) -> crate::output::CreatePredictorBacktestExportJobOutput {
            crate::output::CreatePredictorBacktestExportJobOutput {
                predictor_backtest_export_job_arn: self.predictor_backtest_export_job_arn,
            }
        }
    }
}
impl CreatePredictorBacktestExportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreatePredictorBacktestExportJobOutput`](crate::output::CreatePredictorBacktestExportJobOutput)
    pub fn builder() -> crate::output::create_predictor_backtest_export_job_output::Builder {
        crate::output::create_predictor_backtest_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePredictorOutput {
    /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
    pub predictor_arn: std::option::Option<std::string::String>,
}
impl CreatePredictorOutput {
    /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
    pub fn predictor_arn(&self) -> std::option::Option<&str> {
        self.predictor_arn.as_deref()
    }
}
impl std::fmt::Debug for CreatePredictorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePredictorOutput");
        formatter.field("predictor_arn", &self.predictor_arn);
        formatter.finish()
    }
}
/// See [`CreatePredictorOutput`](crate::output::CreatePredictorOutput)
pub mod create_predictor_output {
    /// A builder for [`CreatePredictorOutput`](crate::output::CreatePredictorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predictor_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
        pub fn predictor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.predictor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predictor_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePredictorOutput`](crate::output::CreatePredictorOutput)
        pub fn build(self) -> crate::output::CreatePredictorOutput {
            crate::output::CreatePredictorOutput {
                predictor_arn: self.predictor_arn,
            }
        }
    }
}
impl CreatePredictorOutput {
    /// Creates a new builder-style object to manufacture [`CreatePredictorOutput`](crate::output::CreatePredictorOutput)
    pub fn builder() -> crate::output::create_predictor_output::Builder {
        crate::output::create_predictor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateForecastExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the export job.</p>
    pub forecast_export_job_arn: std::option::Option<std::string::String>,
}
impl CreateForecastExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the export job.</p>
    pub fn forecast_export_job_arn(&self) -> std::option::Option<&str> {
        self.forecast_export_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateForecastExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateForecastExportJobOutput");
        formatter.field("forecast_export_job_arn", &self.forecast_export_job_arn);
        formatter.finish()
    }
}
/// See [`CreateForecastExportJobOutput`](crate::output::CreateForecastExportJobOutput)
pub mod create_forecast_export_job_output {
    /// A builder for [`CreateForecastExportJobOutput`](crate::output::CreateForecastExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_export_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the export job.</p>
        pub fn forecast_export_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the export job.</p>
        pub fn set_forecast_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forecast_export_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateForecastExportJobOutput`](crate::output::CreateForecastExportJobOutput)
        pub fn build(self) -> crate::output::CreateForecastExportJobOutput {
            crate::output::CreateForecastExportJobOutput {
                forecast_export_job_arn: self.forecast_export_job_arn,
            }
        }
    }
}
impl CreateForecastExportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateForecastExportJobOutput`](crate::output::CreateForecastExportJobOutput)
    pub fn builder() -> crate::output::create_forecast_export_job_output::Builder {
        crate::output::create_forecast_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateForecastOutput {
    /// <p>The Amazon Resource Name (ARN) of the forecast.</p>
    pub forecast_arn: std::option::Option<std::string::String>,
}
impl CreateForecastOutput {
    /// <p>The Amazon Resource Name (ARN) of the forecast.</p>
    pub fn forecast_arn(&self) -> std::option::Option<&str> {
        self.forecast_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateForecastOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateForecastOutput");
        formatter.field("forecast_arn", &self.forecast_arn);
        formatter.finish()
    }
}
/// See [`CreateForecastOutput`](crate::output::CreateForecastOutput)
pub mod create_forecast_output {
    /// A builder for [`CreateForecastOutput`](crate::output::CreateForecastOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forecast_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the forecast.</p>
        pub fn forecast_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.forecast_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast.</p>
        pub fn set_forecast_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.forecast_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateForecastOutput`](crate::output::CreateForecastOutput)
        pub fn build(self) -> crate::output::CreateForecastOutput {
            crate::output::CreateForecastOutput {
                forecast_arn: self.forecast_arn,
            }
        }
    }
}
impl CreateForecastOutput {
    /// Creates a new builder-style object to manufacture [`CreateForecastOutput`](crate::output::CreateForecastOutput)
    pub fn builder() -> crate::output::create_forecast_output::Builder {
        crate::output::create_forecast_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetImportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
    pub dataset_import_job_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetImportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
    pub fn dataset_import_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_import_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetImportJobOutput");
        formatter.field("dataset_import_job_arn", &self.dataset_import_job_arn);
        formatter.finish()
    }
}
/// See [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
pub mod create_dataset_import_job_output {
    /// A builder for [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn dataset_import_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
        pub fn build(self) -> crate::output::CreateDatasetImportJobOutput {
            crate::output::CreateDatasetImportJobOutput {
                dataset_import_job_arn: self.dataset_import_job_arn,
            }
        }
    }
}
impl CreateDatasetImportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
    pub fn builder() -> crate::output::create_dataset_import_job_output::Builder {
        crate::output::create_dataset_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetGroupOutput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.finish()
    }
}
/// See [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
pub mod create_dataset_group_output {
    /// A builder for [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
        pub fn build(self) -> crate::output::CreateDatasetGroupOutput {
            crate::output::CreateDatasetGroupOutput {
                dataset_group_arn: self.dataset_group_arn,
            }
        }
    }
}
impl CreateDatasetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
    pub fn builder() -> crate::output::create_dataset_group_output::Builder {
        crate::output::create_dataset_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetOutput");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.finish()
    }
}
/// See [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
pub mod create_dataset_output {
    /// A builder for [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
        pub fn build(self) -> crate::output::CreateDatasetOutput {
            crate::output::CreateDatasetOutput {
                dataset_arn: self.dataset_arn,
            }
        }
    }
}
impl CreateDatasetOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    pub fn builder() -> crate::output::create_dataset_output::Builder {
        crate::output::create_dataset_output::Builder::default()
    }
}
