// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonForecast`.
///
/// This client allows ergonomic access to a `AmazonForecast`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateDataset` operation.
    ///
    /// See [`CreateDataset`](crate::client::fluent_builders::CreateDataset) for more information about the
    /// operation and its arguments.
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset<C, M, R> {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatasetGroup` operation.
    ///
    /// See [`CreateDatasetGroup`](crate::client::fluent_builders::CreateDatasetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_dataset_group(&self) -> fluent_builders::CreateDatasetGroup<C, M, R> {
        fluent_builders::CreateDatasetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatasetImportJob` operation.
    ///
    /// See [`CreateDatasetImportJob`](crate::client::fluent_builders::CreateDatasetImportJob) for more information about the
    /// operation and its arguments.
    pub fn create_dataset_import_job(&self) -> fluent_builders::CreateDatasetImportJob<C, M, R> {
        fluent_builders::CreateDatasetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateForecast` operation.
    ///
    /// See [`CreateForecast`](crate::client::fluent_builders::CreateForecast) for more information about the
    /// operation and its arguments.
    pub fn create_forecast(&self) -> fluent_builders::CreateForecast<C, M, R> {
        fluent_builders::CreateForecast::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateForecastExportJob` operation.
    ///
    /// See [`CreateForecastExportJob`](crate::client::fluent_builders::CreateForecastExportJob) for more information about the
    /// operation and its arguments.
    pub fn create_forecast_export_job(&self) -> fluent_builders::CreateForecastExportJob<C, M, R> {
        fluent_builders::CreateForecastExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePredictor` operation.
    ///
    /// See [`CreatePredictor`](crate::client::fluent_builders::CreatePredictor) for more information about the
    /// operation and its arguments.
    pub fn create_predictor(&self) -> fluent_builders::CreatePredictor<C, M, R> {
        fluent_builders::CreatePredictor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePredictorBacktestExportJob` operation.
    ///
    /// See [`CreatePredictorBacktestExportJob`](crate::client::fluent_builders::CreatePredictorBacktestExportJob) for more information about the
    /// operation and its arguments.
    pub fn create_predictor_backtest_export_job(
        &self,
    ) -> fluent_builders::CreatePredictorBacktestExportJob<C, M, R> {
        fluent_builders::CreatePredictorBacktestExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataset` operation.
    ///
    /// See [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset<C, M, R> {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDatasetGroup` operation.
    ///
    /// See [`DeleteDatasetGroup`](crate::client::fluent_builders::DeleteDatasetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset_group(&self) -> fluent_builders::DeleteDatasetGroup<C, M, R> {
        fluent_builders::DeleteDatasetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDatasetImportJob` operation.
    ///
    /// See [`DeleteDatasetImportJob`](crate::client::fluent_builders::DeleteDatasetImportJob) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset_import_job(&self) -> fluent_builders::DeleteDatasetImportJob<C, M, R> {
        fluent_builders::DeleteDatasetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteForecast` operation.
    ///
    /// See [`DeleteForecast`](crate::client::fluent_builders::DeleteForecast) for more information about the
    /// operation and its arguments.
    pub fn delete_forecast(&self) -> fluent_builders::DeleteForecast<C, M, R> {
        fluent_builders::DeleteForecast::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteForecastExportJob` operation.
    ///
    /// See [`DeleteForecastExportJob`](crate::client::fluent_builders::DeleteForecastExportJob) for more information about the
    /// operation and its arguments.
    pub fn delete_forecast_export_job(&self) -> fluent_builders::DeleteForecastExportJob<C, M, R> {
        fluent_builders::DeleteForecastExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePredictor` operation.
    ///
    /// See [`DeletePredictor`](crate::client::fluent_builders::DeletePredictor) for more information about the
    /// operation and its arguments.
    pub fn delete_predictor(&self) -> fluent_builders::DeletePredictor<C, M, R> {
        fluent_builders::DeletePredictor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePredictorBacktestExportJob` operation.
    ///
    /// See [`DeletePredictorBacktestExportJob`](crate::client::fluent_builders::DeletePredictorBacktestExportJob) for more information about the
    /// operation and its arguments.
    pub fn delete_predictor_backtest_export_job(
        &self,
    ) -> fluent_builders::DeletePredictorBacktestExportJob<C, M, R> {
        fluent_builders::DeletePredictorBacktestExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourceTree` operation.
    ///
    /// See [`DeleteResourceTree`](crate::client::fluent_builders::DeleteResourceTree) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_tree(&self) -> fluent_builders::DeleteResourceTree<C, M, R> {
        fluent_builders::DeleteResourceTree::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataset` operation.
    ///
    /// See [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset<C, M, R> {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDatasetGroup` operation.
    ///
    /// See [`DescribeDatasetGroup`](crate::client::fluent_builders::DescribeDatasetGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset_group(&self) -> fluent_builders::DescribeDatasetGroup<C, M, R> {
        fluent_builders::DescribeDatasetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDatasetImportJob` operation.
    ///
    /// See [`DescribeDatasetImportJob`](crate::client::fluent_builders::DescribeDatasetImportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset_import_job(
        &self,
    ) -> fluent_builders::DescribeDatasetImportJob<C, M, R> {
        fluent_builders::DescribeDatasetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeForecast` operation.
    ///
    /// See [`DescribeForecast`](crate::client::fluent_builders::DescribeForecast) for more information about the
    /// operation and its arguments.
    pub fn describe_forecast(&self) -> fluent_builders::DescribeForecast<C, M, R> {
        fluent_builders::DescribeForecast::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeForecastExportJob` operation.
    ///
    /// See [`DescribeForecastExportJob`](crate::client::fluent_builders::DescribeForecastExportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_forecast_export_job(
        &self,
    ) -> fluent_builders::DescribeForecastExportJob<C, M, R> {
        fluent_builders::DescribeForecastExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePredictor` operation.
    ///
    /// See [`DescribePredictor`](crate::client::fluent_builders::DescribePredictor) for more information about the
    /// operation and its arguments.
    pub fn describe_predictor(&self) -> fluent_builders::DescribePredictor<C, M, R> {
        fluent_builders::DescribePredictor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePredictorBacktestExportJob` operation.
    ///
    /// See [`DescribePredictorBacktestExportJob`](crate::client::fluent_builders::DescribePredictorBacktestExportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_predictor_backtest_export_job(
        &self,
    ) -> fluent_builders::DescribePredictorBacktestExportJob<C, M, R> {
        fluent_builders::DescribePredictorBacktestExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccuracyMetrics` operation.
    ///
    /// See [`GetAccuracyMetrics`](crate::client::fluent_builders::GetAccuracyMetrics) for more information about the
    /// operation and its arguments.
    pub fn get_accuracy_metrics(&self) -> fluent_builders::GetAccuracyMetrics<C, M, R> {
        fluent_builders::GetAccuracyMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetGroups` operation.
    ///
    /// See [`ListDatasetGroups`](crate::client::fluent_builders::ListDatasetGroups) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_groups(&self) -> fluent_builders::ListDatasetGroups<C, M, R> {
        fluent_builders::ListDatasetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetImportJobs` operation.
    ///
    /// See [`ListDatasetImportJobs`](crate::client::fluent_builders::ListDatasetImportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_import_jobs(&self) -> fluent_builders::ListDatasetImportJobs<C, M, R> {
        fluent_builders::ListDatasetImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasets` operation.
    ///
    /// See [`ListDatasets`](crate::client::fluent_builders::ListDatasets) for more information about the
    /// operation and its arguments.
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets<C, M, R> {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListForecastExportJobs` operation.
    ///
    /// See [`ListForecastExportJobs`](crate::client::fluent_builders::ListForecastExportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_forecast_export_jobs(&self) -> fluent_builders::ListForecastExportJobs<C, M, R> {
        fluent_builders::ListForecastExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListForecasts` operation.
    ///
    /// See [`ListForecasts`](crate::client::fluent_builders::ListForecasts) for more information about the
    /// operation and its arguments.
    pub fn list_forecasts(&self) -> fluent_builders::ListForecasts<C, M, R> {
        fluent_builders::ListForecasts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPredictorBacktestExportJobs` operation.
    ///
    /// See [`ListPredictorBacktestExportJobs`](crate::client::fluent_builders::ListPredictorBacktestExportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_predictor_backtest_export_jobs(
        &self,
    ) -> fluent_builders::ListPredictorBacktestExportJobs<C, M, R> {
        fluent_builders::ListPredictorBacktestExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPredictors` operation.
    ///
    /// See [`ListPredictors`](crate::client::fluent_builders::ListPredictors) for more information about the
    /// operation and its arguments.
    pub fn list_predictors(&self) -> fluent_builders::ListPredictors<C, M, R> {
        fluent_builders::ListPredictors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopResource` operation.
    ///
    /// See [`StopResource`](crate::client::fluent_builders::StopResource) for more information about the
    /// operation and its arguments.
    pub fn stop_resource(&self) -> fluent_builders::StopResource<C, M, R> {
        fluent_builders::StopResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDatasetGroup` operation.
    ///
    /// See [`UpdateDatasetGroup`](crate::client::fluent_builders::UpdateDatasetGroup) for more information about the
    /// operation and its arguments.
    pub fn update_dataset_group(&self) -> fluent_builders::UpdateDatasetGroup<C, M, R> {
        fluent_builders::UpdateDatasetGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates an Amazon Forecast dataset. The information about the dataset that you provide helps
    /// Forecast understand how to consume the data for model training. This includes the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>
    /// <code>DataFrequency</code>
    /// </i> - How frequently your historical
    /// time-series data is collected.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>
    /// <code>Domain</code>
    /// </i> and
    /// <i>
    /// <code>DatasetType</code>
    /// </i> - Each dataset has an associated dataset
    /// domain and a type within the domain. Amazon Forecast provides a list of predefined domains and
    /// types within each domain. For each unique dataset domain and type within the domain,
    /// Amazon Forecast requires your data to include a minimum set of predefined fields.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>
    /// <code>Schema</code>
    /// </i> - A schema specifies the fields in the dataset,
    /// including the field name and data type.</p>
    /// </li>
    /// </ul>
    /// <p>After creating a dataset, you import your training data into it and add the dataset to a
    /// dataset group. You use the dataset group to create a predictor. For more information, see
    /// <a>howitworks-datasets-groups</a>.</p>
    /// <p>To get a list of all your datasets, use the <a>ListDatasets</a>
    /// operation.</p>
    /// <p>For example Forecast datasets, see the <a href="https://github.com/aws-samples/amazon-forecast-samples">Amazon Forecast Sample GitHub
    /// repository</a>.</p>
    /// <note>
    /// <p>The <code>Status</code> of a dataset must be <code>ACTIVE</code> before you can import
    /// training data. Use the <a>DescribeDataset</a> operation to get the status.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl<C, M, R> CreateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetInputOperationOutputAlias,
                crate::output::CreateDatasetOutput,
                crate::error::CreateDatasetError,
                crate::input::CreateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the dataset.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>A name for the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The domain associated with the dataset. When you add a dataset to a dataset group, this
        /// value and the value specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must match.</p>
        /// <p>The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields
        /// that must be present in the training data that you import to the dataset. For example, if you
        /// choose the <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the
        /// <code>DatasetType</code>, Amazon Forecast requires <code>item_id</code>, <code>timestamp</code>,
        /// and <code>demand</code> fields to be present in your data. For more information, see <a>howitworks-datasets-groups</a>.</p>
        pub fn domain(mut self, inp: crate::model::Domain) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain associated with the dataset. When you add a dataset to a dataset group, this
        /// value and the value specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must match.</p>
        /// <p>The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields
        /// that must be present in the training data that you import to the dataset. For example, if you
        /// choose the <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the
        /// <code>DatasetType</code>, Amazon Forecast requires <code>item_id</code>, <code>timestamp</code>,
        /// and <code>demand</code> fields to be present in your data. For more information, see <a>howitworks-datasets-groups</a>.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The dataset type. Valid values depend on the chosen <code>Domain</code>.</p>
        pub fn dataset_type(mut self, inp: crate::model::DatasetType) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>The dataset type. Valid values depend on the chosen <code>Domain</code>.</p>
        pub fn set_dataset_type(
            mut self,
            input: std::option::Option<crate::model::DatasetType>,
        ) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>The frequency of data collection. This parameter is required for RELATED_TIME_SERIES
        /// datasets.</p>
        /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes),
        /// 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example,
        /// "D" indicates every day and "15min" indicates every 15 minutes.</p>
        pub fn data_frequency(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_frequency(inp);
            self
        }
        /// <p>The frequency of data collection. This parameter is required for RELATED_TIME_SERIES
        /// datasets.</p>
        /// <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes),
        /// 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example,
        /// "D" indicates every day and "15min" indicates every 15 minutes.</p>
        pub fn set_data_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_frequency(input);
            self
        }
        /// <p>The schema for the dataset. The schema attributes and their order must match the fields in
        /// your data. The dataset <code>Domain</code> and <code>DatasetType</code> that you choose
        /// determine the minimum required fields in your training data. For information about the
        /// required fields for a specific dataset domain and type, see <a>howitworks-domains-ds-types</a>.</p>
        pub fn schema(mut self, inp: crate::model::Schema) -> Self {
            self.inner = self.inner.schema(inp);
            self
        }
        /// <p>The schema for the dataset. The schema attributes and their order must match the fields in
        /// your data. The dataset <code>Domain</code> and <code>DatasetType</code> that you choose
        /// determine the minimum required fields in your training data. For information about the
        /// required fields for a specific dataset domain and type, see <a>howitworks-domains-ds-types</a>.</p>
        pub fn set_schema(mut self, input: std::option::Option<crate::model::Schema>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn encryption_config(mut self, inp: crate::model::EncryptionConfig) -> Self {
            self.inner = self.inner.encryption_config(inp);
            self
        }
        /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.inner = self.inner.set_encryption_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatasetGroup`.
    ///
    /// <p>Creates a dataset group, which holds a collection of related datasets. You can add
    /// datasets to the dataset group when you create the dataset group, or later by using the <a>UpdateDatasetGroup</a> operation.</p>
    /// <p>After creating a dataset group and adding datasets, you use the dataset group when you
    /// create a predictor. For more information, see <a>howitworks-datasets-groups</a>.</p>
    /// <p>To get a list of all your datasets groups, use the <a>ListDatasetGroups</a>
    /// operation.</p>
    /// <note>
    /// <p>The <code>Status</code> of a dataset group must be <code>ACTIVE</code> before you can
    /// use the dataset group to create a predictor. To get the status, use the <a>DescribeDatasetGroup</a> operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatasetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_group_input::Builder,
    }
    impl<C, M, R> CreateDatasetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatasetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetGroupInputOperationOutputAlias,
                crate::output::CreateDatasetGroupOutput,
                crate::error::CreateDatasetGroupError,
                crate::input::CreateDatasetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the dataset group.</p>
        pub fn dataset_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_name(inp);
            self
        }
        /// <p>A name for the dataset group.</p>
        pub fn set_dataset_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_name(input);
            self
        }
        /// <p>The domain associated with the dataset group. When you add a dataset to a dataset group,
        /// this value and the value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must match.</p>
        /// <p>The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields
        /// that must be present in training data that you import to a dataset. For example, if you choose
        /// the <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the
        /// <code>DatasetType</code>, Amazon Forecast requires that <code>item_id</code>,
        /// <code>timestamp</code>, and <code>demand</code> fields are present in your data. For more
        /// information, see <a>howitworks-datasets-groups</a>.</p>
        pub fn domain(mut self, inp: crate::model::Domain) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain associated with the dataset group. When you add a dataset to a dataset group,
        /// this value and the value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must match.</p>
        /// <p>The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields
        /// that must be present in training data that you import to a dataset. For example, if you choose
        /// the <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the
        /// <code>DatasetType</code>, Amazon Forecast requires that <code>item_id</code>,
        /// <code>timestamp</code>, and <code>demand</code> fields are present in your data. For more
        /// information, see <a>howitworks-datasets-groups</a>.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// Appends an item to `DatasetArns`.
        ///
        /// To override the contents of this collection use [`set_dataset_arns`](Self::set_dataset_arns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the
        /// dataset group.</p>
        pub fn dataset_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arns(inp);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the
        /// dataset group.</p>
        pub fn set_dataset_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dataset_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The optional metadata that you apply to the dataset group to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The optional metadata that you apply to the dataset group to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatasetImportJob`.
    ///
    /// <p>Imports your training data to an Amazon Forecast dataset. You provide the location of your
    /// training data in an Amazon Simple Storage Service (Amazon S3) bucket and the Amazon Resource Name (ARN) of the dataset
    /// that you want to import the data to.</p>
    /// <p>You must specify a <a>DataSource</a> object that includes an AWS Identity and Access Management (IAM)
    /// role that Amazon Forecast can assume to access the data, as Amazon Forecast makes a copy of your data and
    /// processes it in an internal AWS system. For more information, see <a>aws-forecast-iam-roles</a>.</p>
    /// <p>The training data must be in CSV format. The delimiter must be a comma (,).</p>
    /// <p>You can specify the path to a specific CSV file, the S3 bucket, or to a folder in the S3
    /// bucket. For the latter two cases, Amazon Forecast imports all files up to the limit of 10,000
    /// files.</p>
    ///
    ///
    /// <p>Because dataset imports are not aggregated, your most recent dataset import is the one
    /// that is used when training a predictor or generating a forecast. Make sure that your most
    /// recent dataset import contains all of the data you want to model off of, and not just the new
    /// data collected since the previous import.</p>
    ///
    ///
    /// <p>To get a list of all your dataset import jobs, filtered by specified criteria, use the
    /// <a>ListDatasetImportJobs</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatasetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_import_job_input::Builder,
    }
    impl<C, M, R> CreateDatasetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatasetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetImportJobInputOperationOutputAlias,
                crate::output::CreateDatasetImportJobOutput,
                crate::error::CreateDatasetImportJobError,
                crate::input::CreateDatasetImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the dataset import job. We recommend including the current timestamp in the
        /// name, for example, <code>20190721DatasetImport</code>. This can help you avoid getting a
        /// <code>ResourceAlreadyExistsException</code> exception.</p>
        pub fn dataset_import_job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_import_job_name(inp);
            self
        }
        /// <p>The name for the dataset import job. We recommend including the current timestamp in the
        /// name, for example, <code>20190721DatasetImport</code>. This can help you avoid getting a
        /// <code>ResourceAlreadyExistsException</code> exception.</p>
        pub fn set_dataset_import_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_import_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data
        /// to.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data
        /// to.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast
        /// can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p>
        /// <p>If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key and the
        /// IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must
        /// match those specified in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a> operation.</p>
        pub fn data_source(mut self, inp: crate::model::DataSource) -> Self {
            self.inner = self.inner.data_source(inp);
            self
        }
        /// <p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast
        /// can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p>
        /// <p>If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key and the
        /// IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must
        /// match those specified in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a> operation.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>The format of timestamps in the dataset. The format that you specify depends on the
        /// <code>DataFrequency</code> specified when the dataset was created. The following formats are
        /// supported</p>
        /// <ul>
        /// <li>
        /// <p>"yyyy-MM-dd"</p>
        /// <p>For the following data frequencies: Y, M, W, and D</p>
        /// </li>
        /// <li>
        /// <p>"yyyy-MM-dd HH:mm:ss"</p>
        /// <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y,
        /// M, W, and D</p>
        /// </li>
        /// </ul>
        /// <p>If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd
        /// HH:mm:ss".</p>
        pub fn timestamp_format(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timestamp_format(inp);
            self
        }
        /// <p>The format of timestamps in the dataset. The format that you specify depends on the
        /// <code>DataFrequency</code> specified when the dataset was created. The following formats are
        /// supported</p>
        /// <ul>
        /// <li>
        /// <p>"yyyy-MM-dd"</p>
        /// <p>For the following data frequencies: Y, M, W, and D</p>
        /// </li>
        /// <li>
        /// <p>"yyyy-MM-dd HH:mm:ss"</p>
        /// <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y,
        /// M, W, and D</p>
        /// </li>
        /// </ul>
        /// <p>If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd
        /// HH:mm:ss".</p>
        pub fn set_timestamp_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_timestamp_format(input);
            self
        }
        /// <p>A single time zone for every item in your dataset. This option is ideal for datasets
        /// with all timestamps within a single time zone, or if all timestamps are normalized to a
        /// single time zone. </p>
        /// <p>Refer to the <a href="http://joda-time.sourceforge.net/timezones.html">Joda-Time
        /// API</a> for a complete list of valid time zone names.</p>
        pub fn time_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_zone(inp);
            self
        }
        /// <p>A single time zone for every item in your dataset. This option is ideal for datasets
        /// with all timestamps within a single time zone, or if all timestamps are normalized to a
        /// single time zone. </p>
        /// <p>Refer to the <a href="http://joda-time.sourceforge.net/timezones.html">Joda-Time
        /// API</a> for a complete list of valid time zone names.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_zone(input);
            self
        }
        /// <p>Automatically derive time zone information from the geolocation attribute. This option
        /// is ideal for datasets that contain timestamps in multiple time zones and those
        /// timestamps are expressed in local time.</p>
        pub fn use_geolocation_for_time_zone(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_geolocation_for_time_zone(inp);
            self
        }
        /// <p>Automatically derive time zone information from the geolocation attribute. This option
        /// is ideal for datasets that contain timestamps in multiple time zones and those
        /// timestamps are expressed in local time.</p>
        pub fn set_use_geolocation_for_time_zone(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_geolocation_for_time_zone(input);
            self
        }
        /// <p>The format of the geolocation attribute. The geolocation attribute can be formatted in
        /// one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAT_LONG</code> - the latitude and longitude in decimal format (Example: 47.61_-122.33).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CC_POSTALCODE</code> (US Only) - the country code (US), followed by the 5-digit ZIP code (Example: US_98121).</p>
        /// </li>
        /// </ul>
        pub fn geolocation_format(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geolocation_format(inp);
            self
        }
        /// <p>The format of the geolocation attribute. The geolocation attribute can be formatted in
        /// one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAT_LONG</code> - the latitude and longitude in decimal format (Example: 47.61_-122.33).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CC_POSTALCODE</code> (US Only) - the country code (US), followed by the 5-digit ZIP code (Example: US_98121).</p>
        /// </li>
        /// </ul>
        pub fn set_geolocation_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_geolocation_format(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateForecast`.
    ///
    /// <p>Creates a forecast for each item in the <code>TARGET_TIME_SERIES</code> dataset that was
    /// used to train the predictor. This is known as inference. To retrieve the forecast for a single
    /// item at low latency, use the  operation. To
    /// export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the <a>CreateForecastExportJob</a> operation.</p>
    /// <p>The range of the forecast is determined by the <code>ForecastHorizon</code> value, which
    /// you specify in the <a>CreatePredictor</a> request. When you query a forecast, you
    /// can request a specific date range within the forecast.</p>
    /// <p>To get a list of all your forecasts, use the <a>ListForecasts</a>
    /// operation.</p>
    /// <note>
    /// <p>The forecasts generated by Amazon Forecast are in the same time zone as the dataset that was
    /// used to create the predictor.</p>
    /// </note>
    /// <p>For more information, see <a>howitworks-forecast</a>.</p>
    /// <note>
    /// <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query
    /// or export the forecast. Use the <a>DescribeForecast</a> operation to get the
    /// status.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateForecast<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_forecast_input::Builder,
    }
    impl<C, M, R> CreateForecast<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateForecast`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateForecastOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateForecastError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateForecastInputOperationOutputAlias,
                crate::output::CreateForecastOutput,
                crate::error::CreateForecastError,
                crate::input::CreateForecastInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the forecast.</p>
        pub fn forecast_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_name(inp);
            self
        }
        /// <p>A name for the forecast.</p>
        pub fn set_forecast_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forecast_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.</p>
        pub fn predictor_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predictor_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_arn(input);
            self
        }
        /// Appends an item to `ForecastTypes`.
        ///
        /// To override the contents of this collection use [`set_forecast_types`](Self::set_forecast_types).
        ///
        /// <p>The quantiles at which probabilistic forecasts are generated. <b>You
        /// can currently specify up to 5 quantiles per forecast</b>. Accepted values include
        /// <code>0.01 to 0.99</code> (increments of .01 only) and <code>mean</code>. The mean forecast
        /// is different from the median (0.50) when the distribution is not symmetric (for example, Beta
        /// and Negative Binomial). The default value is <code>["0.1", "0.5", "0.9"]</code>.</p>
        pub fn forecast_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_types(inp);
            self
        }
        /// <p>The quantiles at which probabilistic forecasts are generated. <b>You
        /// can currently specify up to 5 quantiles per forecast</b>. Accepted values include
        /// <code>0.01 to 0.99</code> (increments of .01 only) and <code>mean</code>. The mean forecast
        /// is different from the median (0.50) when the distribution is not symmetric (for example, Beta
        /// and Negative Binomial). The default value is <code>["0.1", "0.5", "0.9"]</code>.</p>
        pub fn set_forecast_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_forecast_types(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateForecastExportJob`.
    ///
    /// <p>Exports a forecast created by the <a>CreateForecast</a> operation to your
    /// Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:</p>
    /// <p><ForecastExportJobName>_<ExportTimestamp>_<PartNumber></p>
    /// <p>where the <ExportTimestamp> component is in Java SimpleDateFormat
    /// (yyyy-MM-ddTHH-mm-ssZ).</p>
    /// <p>You must specify a <a>DataDestination</a> object that includes an AWS Identity and Access Management
    /// (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see
    /// <a>aws-forecast-iam-roles</a>.</p>
    /// <p>For more information, see <a>howitworks-forecast</a>.</p>
    /// <p>To get a list of all your forecast export jobs, use the <a>ListForecastExportJobs</a> operation.</p>
    /// <note>
    /// <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before
    /// you can access the forecast in your Amazon S3 bucket. To get the status, use the <a>DescribeForecastExportJob</a> operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateForecastExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_forecast_export_job_input::Builder,
    }
    impl<C, M, R> CreateForecastExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateForecastExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateForecastExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateForecastExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateForecastExportJobInputOperationOutputAlias,
                crate::output::CreateForecastExportJobOutput,
                crate::error::CreateForecastExportJobError,
                crate::input::CreateForecastExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the forecast export job.</p>
        pub fn forecast_export_job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_export_job_name(inp);
            self
        }
        /// <p>The name for the forecast export job.</p>
        pub fn set_forecast_export_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forecast_export_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast that you want to export.</p>
        pub fn forecast_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast that you want to export.</p>
        pub fn set_forecast_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_forecast_arn(input);
            self
        }
        /// <p>The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role that
        /// Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3
        /// bucket.</p>
        /// <p>If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key. The
        /// IAM role must allow Amazon Forecast permission to access the key.</p>
        pub fn destination(mut self, inp: crate::model::DataDestination) -> Self {
            self.inner = self.inner.destination(inp);
            self
        }
        /// <p>The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role that
        /// Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3
        /// bucket.</p>
        /// <p>If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key. The
        /// IAM role must allow Amazon Forecast permission to access the key.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DataDestination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The optional metadata that you apply to the forecast export job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The optional metadata that you apply to the forecast export job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePredictor`.
    ///
    /// <p>Creates an Amazon Forecast predictor.</p>
    /// <p>In the request, provide a dataset group and either specify an algorithm or let
    /// Amazon Forecast choose an algorithm for you using AutoML. If you specify an algorithm, you also can
    /// override algorithm-specific hyperparameters.</p>
    /// <p>Amazon Forecast uses the algorithm to train a predictor using the latest version of the
    /// datasets in the specified dataset group. You can then generate a
    /// forecast using the <a>CreateForecast</a> operation.</p>
    /// <p>
    /// To see the evaluation metrics, use the <a>GetAccuracyMetrics</a> operation.
    /// </p>
    /// <p>You can specify a featurization configuration to fill and aggregate the data
    /// fields in the <code>TARGET_TIME_SERIES</code> dataset to improve model training. For more
    /// information, see <a>FeaturizationConfig</a>.</p>
    /// <p>For RELATED_TIME_SERIES datasets, <code>CreatePredictor</code> verifies that the
    /// <code>DataFrequency</code> specified when the dataset was created matches the
    /// <code>ForecastFrequency</code>. TARGET_TIME_SERIES datasets don't have this restriction.
    /// Amazon Forecast also verifies the delimiter and timestamp format. For more information, see <a>howitworks-datasets-groups</a>.</p>
    /// <p>By default, predictors are trained and evaluated at the 0.1 (P10), 0.5 (P50), and 0.9
    /// (P90) quantiles. You can choose custom forecast types to train and evaluate your predictor
    /// by setting the <code>ForecastTypes</code>.
    /// </p>
    /// <p>
    /// <b>AutoML</b>
    /// </p>
    /// <p>If you want Amazon Forecast to evaluate each algorithm and choose the one that minimizes the
    /// <code>objective function</code>, set <code>PerformAutoML</code> to <code>true</code>. The
    /// <code>objective function</code> is defined as the mean of the weighted losses over the
    /// forecast types. By default, these are the p10, p50, and p90
    /// quantile losses. For more information, see <a>EvaluationResult</a>.</p>
    /// <p>When AutoML is enabled, the following properties are disallowed:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AlgorithmArn</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HPOConfig</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PerformHPO</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TrainingParameters</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    ///
    ///
    /// <p>To get a list of all of your predictors, use the <a>ListPredictors</a>
    /// operation.</p>
    /// <note>
    /// <p>Before you can use the predictor to create a forecast, the <code>Status</code> of the
    /// predictor must be <code>ACTIVE</code>, signifying that training has completed. To get the
    /// status, use the <a>DescribePredictor</a> operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreatePredictor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_predictor_input::Builder,
    }
    impl<C, M, R> CreatePredictor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePredictor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePredictorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePredictorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePredictorInputOperationOutputAlias,
                crate::output::CreatePredictorOutput,
                crate::error::CreatePredictorError,
                crate::input::CreatePredictorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the predictor.</p>
        pub fn predictor_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predictor_name(inp);
            self
        }
        /// <p>A name for the predictor.</p>
        pub fn set_predictor_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm to use for model training. Required if
        /// <code>PerformAutoML</code> is not set to <code>true</code>.</p>
        /// <p class="title">
        /// <b>Supported algorithms:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/ARIMA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/CNN-QR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/Deep_AR_Plus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/ETS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/NPTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/Prophet</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn algorithm_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.algorithm_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm to use for model training. Required if
        /// <code>PerformAutoML</code> is not set to <code>true</code>.</p>
        /// <p class="title">
        /// <b>Supported algorithms:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/ARIMA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/CNN-QR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/Deep_AR_Plus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/ETS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/NPTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>arn:aws:forecast:::algorithm/Prophet</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_arn(input);
            self
        }
        /// <p>Specifies the number of time-steps that the model is trained to predict. The forecast
        /// horizon is also called the prediction length.</p>
        /// <p>For example, if you configure a dataset for daily data collection (using the
        /// <code>DataFrequency</code> parameter of the <a>CreateDataset</a> operation) and
        /// set the forecast horizon to 10, the model returns predictions for 10 days.</p>
        /// <p>The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the
        /// TARGET_TIME_SERIES dataset length.</p>
        pub fn forecast_horizon(mut self, inp: i32) -> Self {
            self.inner = self.inner.forecast_horizon(inp);
            self
        }
        /// <p>Specifies the number of time-steps that the model is trained to predict. The forecast
        /// horizon is also called the prediction length.</p>
        /// <p>For example, if you configure a dataset for daily data collection (using the
        /// <code>DataFrequency</code> parameter of the <a>CreateDataset</a> operation) and
        /// set the forecast horizon to 10, the model returns predictions for 10 days.</p>
        /// <p>The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the
        /// TARGET_TIME_SERIES dataset length.</p>
        pub fn set_forecast_horizon(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_forecast_horizon(input);
            self
        }
        /// Appends an item to `ForecastTypes`.
        ///
        /// To override the contents of this collection use [`set_forecast_types`](Self::set_forecast_types).
        ///
        /// <p>Specifies the forecast types used to train a predictor. You can specify up to five forecast types.
        /// Forecast types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify
        /// the mean forecast with <code>mean</code>.
        /// </p>
        /// <p>The default value is <code>["0.10", "0.50", "0.9"]</code>.</p>
        pub fn forecast_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_types(inp);
            self
        }
        /// <p>Specifies the forecast types used to train a predictor. You can specify up to five forecast types.
        /// Forecast types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify
        /// the mean forecast with <code>mean</code>.
        /// </p>
        /// <p>The default value is <code>["0.10", "0.50", "0.9"]</code>.</p>
        pub fn set_forecast_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_forecast_types(input);
            self
        }
        /// <p>Whether to perform AutoML. When Amazon Forecast performs AutoML, it evaluates the algorithms it
        /// provides and chooses the best algorithm and configuration for your training dataset.</p>
        /// <p>The default value is <code>false</code>. In this case, you are required to specify an
        /// algorithm.</p>
        /// <p>Set <code>PerformAutoML</code> to <code>true</code> to have Amazon Forecast perform AutoML. This
        /// is a good option if you aren't sure which algorithm is suitable for your training data. In
        /// this case, <code>PerformHPO</code> must be false.</p>
        pub fn perform_auto_ml(mut self, inp: bool) -> Self {
            self.inner = self.inner.perform_auto_ml(inp);
            self
        }
        /// <p>Whether to perform AutoML. When Amazon Forecast performs AutoML, it evaluates the algorithms it
        /// provides and chooses the best algorithm and configuration for your training dataset.</p>
        /// <p>The default value is <code>false</code>. In this case, you are required to specify an
        /// algorithm.</p>
        /// <p>Set <code>PerformAutoML</code> to <code>true</code> to have Amazon Forecast perform AutoML. This
        /// is a good option if you aren't sure which algorithm is suitable for your training data. In
        /// this case, <code>PerformHPO</code> must be false.</p>
        pub fn set_perform_auto_ml(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_auto_ml(input);
            self
        }
        /// <note>
        /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
        /// Contact AWS Support or your account manager to learn more about access privileges.
        /// </p>
        /// </note>
        /// <p>Used to overide the default AutoML strategy, which is to optimize predictor accuracy.
        /// To apply an AutoML strategy that minimizes training time, use
        /// <code>LatencyOptimized</code>.</p>
        /// <p>This parameter is only valid for predictors trained using AutoML.</p>
        pub fn auto_ml_override_strategy(
            mut self,
            inp: crate::model::AutoMlOverrideStrategy,
        ) -> Self {
            self.inner = self.inner.auto_ml_override_strategy(inp);
            self
        }
        /// <note>
        /// <p> The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta.
        /// Contact AWS Support or your account manager to learn more about access privileges.
        /// </p>
        /// </note>
        /// <p>Used to overide the default AutoML strategy, which is to optimize predictor accuracy.
        /// To apply an AutoML strategy that minimizes training time, use
        /// <code>LatencyOptimized</code>.</p>
        /// <p>This parameter is only valid for predictors trained using AutoML.</p>
        pub fn set_auto_ml_override_strategy(
            mut self,
            input: std::option::Option<crate::model::AutoMlOverrideStrategy>,
        ) -> Self {
            self.inner = self.inner.set_auto_ml_override_strategy(input);
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO). HPO finds optimal hyperparameter
        /// values for your training data. The process of performing HPO is known as running a
        /// hyperparameter tuning job.</p>
        /// <p>The default value is <code>false</code>. In this case, Amazon Forecast uses default
        /// hyperparameter values from the chosen algorithm.</p>
        /// <p>To override the default values, set <code>PerformHPO</code> to <code>true</code> and,
        /// optionally, supply the <a>HyperParameterTuningJobConfig</a> object. The tuning job
        /// specifies a metric to optimize, which hyperparameters participate in tuning, and the valid
        /// range for each tunable hyperparameter. In this case, you are required to specify an algorithm
        /// and <code>PerformAutoML</code> must be false.</p>
        /// <p>The following algorithms support HPO:</p>
        /// <ul>
        /// <li>
        /// <p>DeepAR+</p>
        /// </li>
        /// <li>
        /// <p>CNN-QR</p>
        /// </li>
        /// </ul>
        pub fn perform_hpo(mut self, inp: bool) -> Self {
            self.inner = self.inner.perform_hpo(inp);
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO). HPO finds optimal hyperparameter
        /// values for your training data. The process of performing HPO is known as running a
        /// hyperparameter tuning job.</p>
        /// <p>The default value is <code>false</code>. In this case, Amazon Forecast uses default
        /// hyperparameter values from the chosen algorithm.</p>
        /// <p>To override the default values, set <code>PerformHPO</code> to <code>true</code> and,
        /// optionally, supply the <a>HyperParameterTuningJobConfig</a> object. The tuning job
        /// specifies a metric to optimize, which hyperparameters participate in tuning, and the valid
        /// range for each tunable hyperparameter. In this case, you are required to specify an algorithm
        /// and <code>PerformAutoML</code> must be false.</p>
        /// <p>The following algorithms support HPO:</p>
        /// <ul>
        /// <li>
        /// <p>DeepAR+</p>
        /// </li>
        /// <li>
        /// <p>CNN-QR</p>
        /// </li>
        /// </ul>
        pub fn set_perform_hpo(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_hpo(input);
            self
        }
        /// Adds a key-value pair to `TrainingParameters`.
        ///
        /// To override the contents of this collection use [`set_training_parameters`](Self::set_training_parameters).
        ///
        /// <p>The hyperparameters to override for model training. The hyperparameters that you can
        /// override are listed in the individual algorithms. For the list of supported algorithms, see
        /// <a>aws-forecast-choosing-recipes</a>.</p>
        pub fn training_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.training_parameters(k, v);
            self
        }
        /// <p>The hyperparameters to override for model training. The hyperparameters that you can
        /// override are listed in the individual algorithms. For the list of supported algorithms, see
        /// <a>aws-forecast-choosing-recipes</a>.</p>
        pub fn set_training_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_training_parameters(input);
            self
        }
        /// <p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast
        /// evaluates a predictor by splitting a dataset into training data and testing data. The
        /// evaluation parameters define how to perform the split and the number of iterations.</p>
        pub fn evaluation_parameters(mut self, inp: crate::model::EvaluationParameters) -> Self {
            self.inner = self.inner.evaluation_parameters(inp);
            self
        }
        /// <p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast
        /// evaluates a predictor by splitting a dataset into training data and testing data. The
        /// evaluation parameters define how to perform the split and the number of iterations.</p>
        pub fn set_evaluation_parameters(
            mut self,
            input: std::option::Option<crate::model::EvaluationParameters>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_parameters(input);
            self
        }
        /// <p>Provides hyperparameter override values for the algorithm. If you don't provide this
        /// parameter, Amazon Forecast uses default values. The individual algorithms specify which
        /// hyperparameters support hyperparameter optimization (HPO). For more information, see <a>aws-forecast-choosing-recipes</a>.</p>
        /// <p>If you included the <code>HPOConfig</code> object, you must set <code>PerformHPO</code> to
        /// true.</p>
        pub fn hpo_config(mut self, inp: crate::model::HyperParameterTuningJobConfig) -> Self {
            self.inner = self.inner.hpo_config(inp);
            self
        }
        /// <p>Provides hyperparameter override values for the algorithm. If you don't provide this
        /// parameter, Amazon Forecast uses default values. The individual algorithms specify which
        /// hyperparameters support hyperparameter optimization (HPO). For more information, see <a>aws-forecast-choosing-recipes</a>.</p>
        /// <p>If you included the <code>HPOConfig</code> object, you must set <code>PerformHPO</code> to
        /// true.</p>
        pub fn set_hpo_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        ) -> Self {
            self.inner = self.inner.set_hpo_config(input);
            self
        }
        /// <p>Describes the dataset group that contains the data to use to train the predictor.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Describes the dataset group that contains the data to use to train the predictor.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The featurization configuration.</p>
        pub fn featurization_config(mut self, inp: crate::model::FeaturizationConfig) -> Self {
            self.inner = self.inner.featurization_config(inp);
            self
        }
        /// <p>The featurization configuration.</p>
        pub fn set_featurization_config(
            mut self,
            input: std::option::Option<crate::model::FeaturizationConfig>,
        ) -> Self {
            self.inner = self.inner.set_featurization_config(input);
            self
        }
        /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn encryption_config(mut self, inp: crate::model::EncryptionConfig) -> Self {
            self.inner = self.inner.encryption_config(inp);
            self
        }
        /// <p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
        /// the key.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.inner = self.inner.set_encryption_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The optional metadata that you apply to the predictor to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The optional metadata that you apply to the predictor to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The accuracy metric used to optimize the predictor.</p>
        pub fn optimization_metric(mut self, inp: crate::model::OptimizationMetric) -> Self {
            self.inner = self.inner.optimization_metric(inp);
            self
        }
        /// <p>The accuracy metric used to optimize the predictor.</p>
        pub fn set_optimization_metric(
            mut self,
            input: std::option::Option<crate::model::OptimizationMetric>,
        ) -> Self {
            self.inner = self.inner.set_optimization_metric(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePredictorBacktestExportJob`.
    ///
    /// <p>Exports backtest forecasts and accuracy metrics generated by the <a>CreatePredictor</a> operation. Two folders containing CSV files are exported
    /// to your specified S3 bucket.</p>
    /// <p> The export file names will match the following conventions:</p>
    /// <p>
    /// <code><ExportJobName>_<ExportTimestamp>_<PartNumber>.csv</code>
    /// </p>
    /// <p>The <ExportTimestamp> component is in Java SimpleDate format
    /// (yyyy-MM-ddTHH-mm-ssZ).</p>
    /// <p>You must specify a <a>DataDestination</a> object that includes an Amazon S3
    /// bucket and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3
    /// bucket. For more information, see <a>aws-forecast-iam-roles</a>.</p>
    /// <note>
    /// <p>The <code>Status</code> of the export job must be <code>ACTIVE</code> before
    /// you can access the export in your Amazon S3 bucket. To get the status, use the <a>DescribePredictorBacktestExportJob</a> operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreatePredictorBacktestExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_predictor_backtest_export_job_input::Builder,
    }
    impl<C, M, R> CreatePredictorBacktestExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePredictorBacktestExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePredictorBacktestExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePredictorBacktestExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePredictorBacktestExportJobInputOperationOutputAlias,
                crate::output::CreatePredictorBacktestExportJobOutput,
                crate::error::CreatePredictorBacktestExportJobError,
                crate::input::CreatePredictorBacktestExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the backtest export job.</p>
        pub fn predictor_backtest_export_job_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.predictor_backtest_export_job_name(inp);
            self
        }
        /// <p>The name for the backtest export job.</p>
        pub fn set_predictor_backtest_export_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_backtest_export_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor that you want to export.</p>
        pub fn predictor_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predictor_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor that you want to export.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_arn(input);
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast
        /// to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn destination(mut self, inp: crate::model::DataDestination) -> Self {
            self.inner = self.inner.destination(inp);
            self
        }
        /// <p>The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast
        /// to access the location, and an AWS Key Management Service (KMS) key (optional). </p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DataDestination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata to help you categorize and organize your backtests. Each tag consists
        /// of a key and an optional value, both of which you define. Tag keys and values are case
        /// sensitive.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>For each resource, each tag key must be unique and each tag key must have one
        /// value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum number of tags per resource: 50.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Accepted characters: all letters and numbers, spaces representable in UTF-8, and +
        /// - = . _ : / @. If your tagging schema is used across other services and resources,
        /// the character restrictions of those services also apply. </p>
        /// </li>
        /// <li>
        /// <p>Key prefixes cannot include any upper or lowercase combination of
        /// <code>aws:</code> or <code>AWS:</code>. Values can have this prefix. If a tag
        /// value has <code>aws</code> as its prefix but the key does not, Forecast considers it
        /// to be a user tag and will count against the limit of 50 tags. Tags with only the key
        /// prefix of <code>aws</code> do not count against your tags per resource limit. You
        /// cannot edit or delete tag keys with this prefix.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata to help you categorize and organize your backtests. Each tag consists
        /// of a key and an optional value, both of which you define. Tag keys and values are case
        /// sensitive.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>For each resource, each tag key must be unique and each tag key must have one
        /// value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum number of tags per resource: 50.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Accepted characters: all letters and numbers, spaces representable in UTF-8, and +
        /// - = . _ : / @. If your tagging schema is used across other services and resources,
        /// the character restrictions of those services also apply. </p>
        /// </li>
        /// <li>
        /// <p>Key prefixes cannot include any upper or lowercase combination of
        /// <code>aws:</code> or <code>AWS:</code>. Values can have this prefix. If a tag
        /// value has <code>aws</code> as its prefix but the key does not, Forecast considers it
        /// to be a user tag and will count against the limit of 50 tags. Tags with only the key
        /// prefix of <code>aws</code> do not count against your tags per resource limit. You
        /// cannot edit or delete tag keys with this prefix.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes an Amazon Forecast dataset that was created using the <a>CreateDataset</a>
    /// operation. You can only delete datasets that have a status of <code>ACTIVE</code> or
    /// <code>CREATE_FAILED</code>. To get the status use the <a>DescribeDataset</a>
    /// operation.</p>
    /// <note>
    /// <p>Forecast does not automatically update any dataset groups that contain the deleted dataset.
    /// In order to update the dataset group, use the
    /// operation, omitting the deleted dataset's ARN.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl<C, M, R> DeleteDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetInputOperationOutputAlias,
                crate::output::DeleteDatasetOutput,
                crate::error::DeleteDatasetError,
                crate::input::DeleteDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatasetGroup`.
    ///
    /// <p>Deletes a dataset group created using the <a>CreateDatasetGroup</a> operation.
    /// You can only delete dataset groups that have a status of <code>ACTIVE</code>,
    /// <code>CREATE_FAILED</code>, or <code>UPDATE_FAILED</code>. To get the status, use the <a>DescribeDatasetGroup</a> operation.</p>
    /// <p>This operation deletes only the dataset group, not the datasets in the group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDatasetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_group_input::Builder,
    }
    impl<C, M, R> DeleteDatasetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDatasetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetGroupInputOperationOutputAlias,
                crate::output::DeleteDatasetGroupOutput,
                crate::error::DeleteDatasetGroupError,
                crate::input::DeleteDatasetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to delete.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to delete.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatasetImportJob`.
    ///
    /// <p>Deletes a dataset import job created using the <a>CreateDatasetImportJob</a>
    /// operation. You can delete only dataset import jobs that have a status of <code>ACTIVE</code>
    /// or <code>CREATE_FAILED</code>. To get the status, use the <a>DescribeDatasetImportJob</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDatasetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_import_job_input::Builder,
    }
    impl<C, M, R> DeleteDatasetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDatasetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetImportJobInputOperationOutputAlias,
                crate::output::DeleteDatasetImportJobOutput,
                crate::error::DeleteDatasetImportJobError,
                crate::input::DeleteDatasetImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job to delete.</p>
        pub fn dataset_import_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_import_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job to delete.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_import_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteForecast`.
    ///
    /// <p>Deletes a forecast created using the <a>CreateForecast</a> operation. You can
    /// delete only forecasts that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>.
    /// To get the status, use the <a>DescribeForecast</a> operation.</p>
    /// <p>You can't delete a forecast while it is being exported. After a forecast is deleted, you
    /// can no longer query the forecast.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteForecast<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_forecast_input::Builder,
    }
    impl<C, M, R> DeleteForecast<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteForecast`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteForecastOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteForecastError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteForecastInputOperationOutputAlias,
                crate::output::DeleteForecastOutput,
                crate::error::DeleteForecastError,
                crate::input::DeleteForecastInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast to delete.</p>
        pub fn forecast_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast to delete.</p>
        pub fn set_forecast_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_forecast_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteForecastExportJob`.
    ///
    /// <p>Deletes a forecast export job created using the <a>CreateForecastExportJob</a>
    /// operation. You can delete only export jobs that have a status of <code>ACTIVE</code> or
    /// <code>CREATE_FAILED</code>. To get the status, use the <a>DescribeForecastExportJob</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteForecastExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_forecast_export_job_input::Builder,
    }
    impl<C, M, R> DeleteForecastExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteForecastExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteForecastExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteForecastExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteForecastExportJobInputOperationOutputAlias,
                crate::output::DeleteForecastExportJobOutput,
                crate::error::DeleteForecastExportJobError,
                crate::input::DeleteForecastExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast export job to delete.</p>
        pub fn forecast_export_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_export_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast export job to delete.</p>
        pub fn set_forecast_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forecast_export_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePredictor`.
    ///
    /// <p>Deletes a predictor created using the <a>CreatePredictor</a> operation. You can
    /// delete only predictor that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>.
    /// To get the status, use the <a>DescribePredictor</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePredictor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_predictor_input::Builder,
    }
    impl<C, M, R> DeletePredictor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePredictor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePredictorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePredictorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePredictorInputOperationOutputAlias,
                crate::output::DeletePredictorOutput,
                crate::error::DeletePredictorError,
                crate::input::DeletePredictorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor to delete.</p>
        pub fn predictor_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predictor_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor to delete.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePredictorBacktestExportJob`.
    ///
    /// <p>Deletes a predictor backtest export job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePredictorBacktestExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_predictor_backtest_export_job_input::Builder,
    }
    impl<C, M, R> DeletePredictorBacktestExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePredictorBacktestExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePredictorBacktestExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePredictorBacktestExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePredictorBacktestExportJobInputOperationOutputAlias,
                crate::output::DeletePredictorBacktestExportJobOutput,
                crate::error::DeletePredictorBacktestExportJobError,
                crate::input::DeletePredictorBacktestExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job to delete.</p>
        pub fn predictor_backtest_export_job_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.predictor_backtest_export_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job to delete.</p>
        pub fn set_predictor_backtest_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_backtest_export_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceTree`.
    ///
    /// <p>Deletes an entire resource tree. This operation will delete the parent resource and
    /// its child resources.</p>
    /// <p>Child resources are resources that were created from another resource. For example,
    /// when a forecast is generated from a predictor, the forecast is the child resource and
    /// the predictor is the parent resource.</p>
    /// <p>Amazon Forecast resources possess the following parent-child resource hierarchies:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Dataset</b>: dataset import jobs</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Dataset Group</b>: predictors, predictor backtest
    /// export jobs, forecasts, forecast export jobs</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Predictor</b>: predictor backtest export jobs,
    /// forecasts, forecast export jobs</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Forecast</b>: forecast export jobs</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>
    /// <code>DeleteResourceTree</code> will only delete Amazon Forecast resources, and will not
    /// delete datasets or exported files stored in Amazon S3. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourceTree<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_tree_input::Builder,
    }
    impl<C, M, R> DeleteResourceTree<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceTree`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceTreeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceTreeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceTreeInputOperationOutputAlias,
                crate::output::DeleteResourceTreeOutput,
                crate::error::DeleteResourceTreeError,
                crate::input::DeleteResourceTreeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the parent resource to delete. All child resources
        /// of the parent resource will also be deleted.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the parent resource to delete. All child resources
        /// of the parent resource will also be deleted.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Describes an Amazon Forecast dataset created using the <a>CreateDataset</a>
    /// operation.</p>
    /// <p>In addition to listing the parameters specified in the <code>CreateDataset</code> request,
    /// this operation includes the following dataset properties:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastModificationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl<C, M, R> DescribeDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetInputOperationOutputAlias,
                crate::output::DescribeDatasetOutput,
                crate::error::DescribeDatasetError,
                crate::input::DescribeDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDatasetGroup`.
    ///
    /// <p>Describes a dataset group created using the <a>CreateDatasetGroup</a>
    /// operation.</p>
    /// <p>In addition to listing the parameters provided in the <code>CreateDatasetGroup</code>
    /// request, this operation includes the following properties:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DatasetArns</code> - The datasets belonging to the group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastModificationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDatasetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_group_input::Builder,
    }
    impl<C, M, R> DescribeDatasetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDatasetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetGroupInputOperationOutputAlias,
                crate::output::DescribeDatasetGroupOutput,
                crate::error::DescribeDatasetGroupError,
                crate::input::DescribeDatasetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDatasetImportJob`.
    ///
    /// <p>Describes a dataset import job created using the <a>CreateDatasetImportJob</a>
    /// operation.</p>
    /// <p>In addition to listing the parameters provided in the <code>CreateDatasetImportJob</code>
    /// request, this operation includes the following properties:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastModificationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FieldStatistics</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Message</code> - If an error occurred, information about the error.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDatasetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_import_job_input::Builder,
    }
    impl<C, M, R> DescribeDatasetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDatasetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetImportJobInputOperationOutputAlias,
                crate::output::DescribeDatasetImportJobOutput,
                crate::error::DescribeDatasetImportJobError,
                crate::input::DescribeDatasetImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn dataset_import_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_import_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_import_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeForecast`.
    ///
    /// <p>Describes a forecast created using the <a>CreateForecast</a> operation.</p>
    /// <p>In addition to listing the properties provided in the <code>CreateForecast</code> request,
    /// this operation lists the following properties:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DatasetGroupArn</code> - The dataset group that provided the training
    /// data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastModificationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Message</code> - If an error occurred, information about the error.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeForecast<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_forecast_input::Builder,
    }
    impl<C, M, R> DescribeForecast<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeForecast`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeForecastOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeForecastError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeForecastInputOperationOutputAlias,
                crate::output::DescribeForecastOutput,
                crate::error::DescribeForecastError,
                crate::input::DescribeForecastInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast.</p>
        pub fn forecast_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast.</p>
        pub fn set_forecast_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_forecast_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeForecastExportJob`.
    ///
    /// <p>Describes a forecast export job created using the <a>CreateForecastExportJob</a> operation.</p>
    /// <p>In addition to listing the properties provided by the user in the
    /// <code>CreateForecastExportJob</code> request, this operation lists the following
    /// properties:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastModificationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Message</code> - If an error occurred, information about the error.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeForecastExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_forecast_export_job_input::Builder,
    }
    impl<C, M, R> DescribeForecastExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeForecastExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeForecastExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeForecastExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeForecastExportJobInputOperationOutputAlias,
                crate::output::DescribeForecastExportJobOutput,
                crate::error::DescribeForecastExportJobError,
                crate::input::DescribeForecastExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast export job.</p>
        pub fn forecast_export_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forecast_export_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the forecast export job.</p>
        pub fn set_forecast_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forecast_export_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePredictor`.
    ///
    /// <p>Describes a predictor created using the <a>CreatePredictor</a>
    /// operation.</p>
    /// <p>In addition to listing the properties provided in the <code>CreatePredictor</code>
    /// request, this operation lists the following properties:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DatasetImportJobArns</code> - The dataset import jobs used to import training
    /// data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AutoMLAlgorithmArns</code> - If AutoML is performed, the algorithms that were
    /// evaluated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastModificationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Message</code> - If an error occurred, information about the error.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribePredictor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_predictor_input::Builder,
    }
    impl<C, M, R> DescribePredictor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePredictor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePredictorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePredictorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePredictorInputOperationOutputAlias,
                crate::output::DescribePredictorOutput,
                crate::error::DescribePredictorError,
                crate::input::DescribePredictorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor that you want information about.</p>
        pub fn predictor_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predictor_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor that you want information about.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePredictorBacktestExportJob`.
    ///
    /// <p>Describes a predictor backtest export job created using the <a>CreatePredictorBacktestExportJob</a> operation.</p>
    /// <p>In addition to listing the properties provided by the user in the
    /// <code>CreatePredictorBacktestExportJob</code> request, this operation lists the
    /// following properties:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastModificationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Message</code> (if an error occurred)</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribePredictorBacktestExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_predictor_backtest_export_job_input::Builder,
    }
    impl<C, M, R> DescribePredictorBacktestExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePredictorBacktestExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePredictorBacktestExportJobOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribePredictorBacktestExportJobError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePredictorBacktestExportJobInputOperationOutputAlias,
                crate::output::DescribePredictorBacktestExportJobOutput,
                crate::error::DescribePredictorBacktestExportJobError,
                crate::input::DescribePredictorBacktestExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
        pub fn predictor_backtest_export_job_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.predictor_backtest_export_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor backtest export job.</p>
        pub fn set_predictor_backtest_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_backtest_export_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccuracyMetrics`.
    ///
    /// <p>Provides metrics on the accuracy of the models that were trained by the <a>CreatePredictor</a> operation. Use metrics to see how well the model performed and
    /// to decide whether to use the predictor to generate a forecast. For more information, see
    /// <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">Predictor
    /// Metrics</a>.</p>
    /// <p>This operation generates metrics for each backtest window that was evaluated. The number
    /// of backtest windows (<code>NumberOfBacktestWindows</code>) is specified using the <a>EvaluationParameters</a> object, which is optionally included in the
    /// <code>CreatePredictor</code> request. If <code>NumberOfBacktestWindows</code> isn't
    /// specified, the number defaults to one.</p>
    /// <p>The parameters of the <code>filling</code> method determine which items contribute to the
    /// metrics. If you want all items to contribute, specify <code>zero</code>. If you want only
    /// those items that have complete data in the range being evaluated to contribute, specify
    /// <code>nan</code>. For more information, see <a>FeaturizationMethod</a>.</p>
    ///
    /// <note>
    /// <p>Before you can get accuracy metrics, the <code>Status</code> of the predictor must be
    /// <code>ACTIVE</code>, signifying that training has completed. To get the status, use the
    /// <a>DescribePredictor</a> operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetAccuracyMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_accuracy_metrics_input::Builder,
    }
    impl<C, M, R> GetAccuracyMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccuracyMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccuracyMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccuracyMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccuracyMetricsInputOperationOutputAlias,
                crate::output::GetAccuracyMetricsOutput,
                crate::error::GetAccuracyMetricsError,
                crate::input::GetAccuracyMetricsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor to get metrics for.</p>
        pub fn predictor_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predictor_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the predictor to get metrics for.</p>
        pub fn set_predictor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predictor_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetGroups`.
    ///
    /// <p>Returns a list of dataset groups created using the <a>CreateDatasetGroup</a>
    /// operation. For each dataset group, this operation returns a summary of its properties,
    /// including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by
    /// using the dataset group ARN with the <a>DescribeDatasetGroup</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_groups_input::Builder,
    }
    impl<C, M, R> ListDatasetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetGroupsInputOperationOutputAlias,
                crate::output::ListDatasetGroupsOutput,
                crate::error::ListDatasetGroupsError,
                crate::input::ListDatasetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetImportJobs`.
    ///
    /// <p>Returns a list of dataset import jobs created using the <a>CreateDatasetImportJob</a> operation. For each import job, this operation returns a
    /// summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the
    /// complete set of properties by using the ARN with the <a>DescribeDatasetImportJob</a> operation. You can filter the list by providing an array of <a>Filter</a>
    /// objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_import_jobs_input::Builder,
    }
    impl<C, M, R> ListDatasetImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetImportJobsInputOperationOutputAlias,
                crate::output::ListDatasetImportJobsOutput,
                crate::error::ListDatasetImportJobsError,
                crate::input::ListDatasetImportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the datasets that match the statement from the list, respectively. The match
        /// statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the datasets that match the statement, specify
        /// <code>IS</code>. To exclude matching datasets, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>DatasetArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all dataset import jobs whose status is ACTIVE, you specify the
        /// following filter:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" }
        /// ]</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the datasets that match the statement from the list, respectively. The match
        /// statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the datasets that match the statement, specify
        /// <code>IS</code>. To exclude matching datasets, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>DatasetArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all dataset import jobs whose status is ACTIVE, you specify the
        /// following filter:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" }
        /// ]</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Returns a list of datasets created using the <a>CreateDataset</a> operation.
    /// For each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is
    /// returned. To retrieve the complete set of properties, use the ARN with the <a>DescribeDataset</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl<C, M, R> ListDatasets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetsInputOperationOutputAlias,
                crate::output::ListDatasetsOutput,
                crate::error::ListDatasetsError,
                crate::input::ListDatasetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListForecastExportJobs`.
    ///
    /// <p>Returns a list of forecast export jobs created using the <a>CreateForecastExportJob</a> operation. For each forecast export job, this operation
    /// returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the
    /// complete set of properties, use the ARN with the <a>DescribeForecastExportJob</a>
    /// operation. You can filter the list using an array of <a>Filter</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListForecastExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_forecast_export_jobs_input::Builder,
    }
    impl<C, M, R> ListForecastExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListForecastExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListForecastExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListForecastExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListForecastExportJobsInputOperationOutputAlias,
                crate::output::ListForecastExportJobsOutput,
                crate::error::ListForecastExportJobsError,
                crate::input::ListForecastExportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the forecast export jobs that match the statement from the list, respectively. The
        /// match statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the forecast export jobs that match the statement,
        /// specify <code>IS</code>. To exclude matching forecast export jobs, specify
        /// <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>ForecastArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all jobs that export a forecast named
        /// <i>electricityforecast</i>, specify the following filter:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS", "Key": "ForecastArn", "Value":
        /// "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityforecast" } ]</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the forecast export jobs that match the statement from the list, respectively. The
        /// match statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the forecast export jobs that match the statement,
        /// specify <code>IS</code>. To exclude matching forecast export jobs, specify
        /// <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>ForecastArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all jobs that export a forecast named
        /// <i>electricityforecast</i>, specify the following filter:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS", "Key": "ForecastArn", "Value":
        /// "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityforecast" } ]</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListForecasts`.
    ///
    /// <p>Returns a list of forecasts created using the <a>CreateForecast</a> operation.
    /// For each forecast, this operation returns a summary of its properties, including its Amazon
    /// Resource Name (ARN). To retrieve the complete set of properties, specify the ARN with the
    /// <a>DescribeForecast</a> operation. You can filter the list using an array of
    /// <a>Filter</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListForecasts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_forecasts_input::Builder,
    }
    impl<C, M, R> ListForecasts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListForecasts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListForecastsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListForecastsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListForecastsInputOperationOutputAlias,
                crate::output::ListForecastsOutput,
                crate::error::ListForecastsError,
                crate::input::ListForecastsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the forecasts that match the statement from the list, respectively. The match
        /// statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the forecasts that match the statement, specify
        /// <code>IS</code>. To exclude matching forecasts, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>DatasetGroupArn</code>, <code>PredictorArn</code>, and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all forecasts whose status is not ACTIVE, you would specify:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS_NOT", "Key": "Status", "Value": "ACTIVE" }
        /// ]</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the forecasts that match the statement from the list, respectively. The match
        /// statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the forecasts that match the statement, specify
        /// <code>IS</code>. To exclude matching forecasts, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>DatasetGroupArn</code>, <code>PredictorArn</code>, and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all forecasts whose status is not ACTIVE, you would specify:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS_NOT", "Key": "Status", "Value": "ACTIVE" }
        /// ]</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPredictorBacktestExportJobs`.
    ///
    /// <p>Returns a list of predictor backtest export jobs created using the <a>CreatePredictorBacktestExportJob</a> operation. This operation returns a summary
    /// for each backtest export job. You can filter the list using an array of <a>Filter</a> objects.</p>
    /// <p>To retrieve the complete set of properties for a particular backtest export job, use the
    /// ARN with the <a>DescribePredictorBacktestExportJob</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPredictorBacktestExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_predictor_backtest_export_jobs_input::Builder,
    }
    impl<C, M, R> ListPredictorBacktestExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPredictorBacktestExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPredictorBacktestExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPredictorBacktestExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPredictorBacktestExportJobsInputOperationOutputAlias,
                crate::output::ListPredictorBacktestExportJobsOutput,
                crate::error::ListPredictorBacktestExportJobsError,
                crate::input::ListPredictorBacktestExportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the previous request was truncated, the response includes a NextToken.
        /// To retrieve the next set of results, use the token in the next request. Tokens expire after
        /// 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a NextToken.
        /// To retrieve the next set of results, use the token in the next request. Tokens expire after
        /// 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters. For each filter, provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to
        /// include or exclude the predictor backtest export jobs that match the statement from the
        /// list. The match statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are
        /// <code>IS</code> and <code>IS_NOT</code>. To include the predictor backtest
        /// export jobs that match the statement, specify <code>IS</code>. To exclude matching
        /// predictor backtest export jobs, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>PredictorArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An array of filters. For each filter, provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to
        /// include or exclude the predictor backtest export jobs that match the statement from the
        /// list. The match statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are
        /// <code>IS</code> and <code>IS_NOT</code>. To include the predictor backtest
        /// export jobs that match the statement, specify <code>IS</code>. To exclude matching
        /// predictor backtest export jobs, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>PredictorArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPredictors`.
    ///
    /// <p>Returns a list of predictors created using the <a>CreatePredictor</a>
    /// operation. For each predictor, this operation returns a summary of its properties, including
    /// its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the
    /// ARN with the <a>DescribePredictor</a> operation. You can filter the list using an
    /// array of <a>Filter</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPredictors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_predictors_input::Builder,
    }
    impl<C, M, R> ListPredictors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPredictors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPredictorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPredictorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPredictorsInputOperationOutputAlias,
                crate::output::ListPredictorsOutput,
                crate::error::ListPredictorsError,
                crate::input::ListPredictorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the predictors that match the statement from the list, respectively. The match
        /// statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the predictors that match the statement, specify
        /// <code>IS</code>. To exclude matching predictors, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>DatasetGroupArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all predictors whose status is ACTIVE, you would specify:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" }
        /// ]</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An array of filters. For each filter, you provide a condition and a match statement. The
        /// condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include
        /// or exclude the predictors that match the statement from the list, respectively. The match
        /// statement consists of a key and a value.</p>
        /// <p>
        /// <b>Filter properties</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and
        /// <code>IS_NOT</code>. To include the predictors that match the statement, specify
        /// <code>IS</code>. To exclude matching predictors, specify <code>IS_NOT</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key</code> - The name of the parameter to filter on. Valid values are
        /// <code>DatasetGroupArn</code> and <code>Status</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Value</code> - The value to match.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to list all predictors whose status is ACTIVE, you would specify:</p>
        /// <p>
        /// <code>"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" }
        /// ]</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for an Amazon Forecast resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast export jobs.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast export jobs.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopResource`.
    ///
    /// <p>Stops a resource.</p>
    /// <p>The resource undergoes the following states:
    /// <code>CREATE_STOPPING</code> and <code>CREATE_STOPPED</code>. You cannot resume
    /// a resource once it has been stopped.</p>
    /// <p>This operation can be applied to the following resources (and their corresponding child
    /// resources):</p>
    /// <ul>
    /// <li>
    /// <p>Dataset Import Job</p>
    /// </li>
    /// <li>
    /// <p>Predictor Job</p>
    /// </li>
    /// <li>
    /// <p>Forecast Job</p>
    /// </li>
    /// <li>
    /// <p>Forecast Export Job</p>
    /// </li>
    /// <li>
    /// <p>Predictor Backtest Export Job</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct StopResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_resource_input::Builder,
    }
    impl<C, M, R> StopResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::StopResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopResourceInputOperationOutputAlias,
                crate::output::StopResourceOutput,
                crate::error::StopResourceError,
                crate::input::StopResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to stop. The supported ARNs
        /// are <code>DatasetImportJobArn</code>, <code>PredictorArn</code>,
        /// <code>PredictorBacktestExportJobArn</code>, <code>ForecastArn</code>, and
        /// <code>ForecastExportJobArn</code>. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to stop. The supported ARNs
        /// are <code>DatasetImportJobArn</code>, <code>PredictorArn</code>,
        /// <code>PredictorBacktestExportJobArn</code>, <code>ForecastArn</code>, and
        /// <code>ForecastExportJobArn</code>. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast export jobs.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast export jobs.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50.</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the specified tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast exports.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast exports.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatasetGroup`.
    ///
    /// <p>Replaces the datasets in a dataset group with the specified datasets.</p>
    /// <note>
    /// <p>The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can
    /// use the dataset group to create a predictor. Use the <a>DescribeDatasetGroup</a>
    /// operation to get the status.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDatasetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dataset_group_input::Builder,
    }
    impl<C, M, R> UpdateDatasetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDatasetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDatasetGroupInputOperationOutputAlias,
                crate::output::UpdateDatasetGroupOutput,
                crate::error::UpdateDatasetGroupError,
                crate::input::UpdateDatasetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the dataset group.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The ARN of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// Appends an item to `DatasetArns`.
        ///
        /// To override the contents of this collection use [`set_dataset_arns`](Self::set_dataset_arns).
        ///
        /// <p>An array of the Amazon Resource Names (ARNs) of the datasets to add to the dataset
        /// group.</p>
        pub fn dataset_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arns(inp);
            self
        }
        /// <p>An array of the Amazon Resource Names (ARNs) of the datasets to add to the dataset
        /// group.</p>
        pub fn set_dataset_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dataset_arns(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
