// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Firewall Management Service
///
/// Client for invoking operations on Firewall Management Service. Each operation on Firewall Management Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_fms::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_fms::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_fms::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateAdminAccount`](crate::client::fluent_builders::AssociateAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_account(impl Into<String>)`](crate::client::fluent_builders::AssociateAdminAccount::admin_account) / [`set_admin_account(Option<String>)`](crate::client::fluent_builders::AssociateAdminAccount::set_admin_account): <p>The Amazon Web Services account ID to associate with Firewall Manager as the Firewall Manager administrator account. This must be an Organizations member account. For more information about Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the Amazon Web Services Accounts in Your Organization</a>. </p>
    /// - On success, responds with [`AssociateAdminAccountOutput`](crate::output::AssociateAdminAccountOutput)

    /// - On failure, responds with [`SdkError<AssociateAdminAccountError>`](crate::error::AssociateAdminAccountError)
    pub fn associate_admin_account(&self) -> fluent_builders::AssociateAdminAccount<C, M, R> {
        fluent_builders::AssociateAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppsList`](crate::client::fluent_builders::DeleteAppsList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`list_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAppsList::list_id) / [`set_list_id(Option<String>)`](crate::client::fluent_builders::DeleteAppsList::set_list_id): <p>The ID of the applications list that you want to delete. You can retrieve this ID from <code>PutAppsList</code>, <code>ListAppsLists</code>, and <code>GetAppsList</code>.</p>
    /// - On success, responds with [`DeleteAppsListOutput`](crate::output::DeleteAppsListOutput)

    /// - On failure, responds with [`SdkError<DeleteAppsListError>`](crate::error::DeleteAppsListError)
    pub fn delete_apps_list(&self) -> fluent_builders::DeleteAppsList<C, M, R> {
        fluent_builders::DeleteAppsList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNotificationChannel`](crate::client::fluent_builders::DeleteNotificationChannel) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteNotificationChannel::send) it.

    /// - On success, responds with [`DeleteNotificationChannelOutput`](crate::output::DeleteNotificationChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteNotificationChannelError>`](crate::error::DeleteNotificationChannelError)
    pub fn delete_notification_channel(
        &self,
    ) -> fluent_builders::DeleteNotificationChannel<C, M, R> {
        fluent_builders::DeleteNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::DeletePolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::DeletePolicy::set_policy_id): <p>The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and <code>ListPolicies</code>.</p>
    ///   - [`delete_all_policy_resources(bool)`](crate::client::fluent_builders::DeletePolicy::delete_all_policy_resources) / [`set_delete_all_policy_resources(bool)`](crate::client::fluent_builders::DeletePolicy::set_delete_all_policy_resources): <p>If <code>True</code>, the request performs cleanup according to the policy type. </p>  <p>For WAF and Shield Advanced policies, the cleanup does the following:</p>  <ul>   <li> <p>Deletes rule groups created by Firewall Manager</p> </li>   <li> <p>Removes web ACLs from in-scope resources</p> </li>   <li> <p>Deletes web ACLs that contain no rules or rule groups</p> </li>  </ul>  <p>For security group policies, the cleanup does the following for each security group in the policy:</p>  <ul>   <li> <p>Disassociates the security group from in-scope resources </p> </li>   <li> <p>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</p> </li>  </ul>  <p>After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope. </p>
    /// - On success, responds with [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)

    /// - On failure, responds with [`SdkError<DeletePolicyError>`](crate::error::DeletePolicyError)
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy<C, M, R> {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProtocolsList`](crate::client::fluent_builders::DeleteProtocolsList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`list_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProtocolsList::list_id) / [`set_list_id(Option<String>)`](crate::client::fluent_builders::DeleteProtocolsList::set_list_id): <p>The ID of the protocols list that you want to delete. You can retrieve this ID from <code>PutProtocolsList</code>, <code>ListProtocolsLists</code>, and <code>GetProtocolsLost</code>.</p>
    /// - On success, responds with [`DeleteProtocolsListOutput`](crate::output::DeleteProtocolsListOutput)

    /// - On failure, responds with [`SdkError<DeleteProtocolsListError>`](crate::error::DeleteProtocolsListError)
    pub fn delete_protocols_list(&self) -> fluent_builders::DeleteProtocolsList<C, M, R> {
        fluent_builders::DeleteProtocolsList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateAdminAccount`](crate::client::fluent_builders::DisassociateAdminAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateAdminAccount::send) it.

    /// - On success, responds with [`DisassociateAdminAccountOutput`](crate::output::DisassociateAdminAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateAdminAccountError>`](crate::error::DisassociateAdminAccountError)
    pub fn disassociate_admin_account(&self) -> fluent_builders::DisassociateAdminAccount<C, M, R> {
        fluent_builders::DisassociateAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAdminAccount`](crate::client::fluent_builders::GetAdminAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAdminAccount::send) it.

    /// - On success, responds with [`GetAdminAccountOutput`](crate::output::GetAdminAccountOutput) with field(s):
    ///   - [`admin_account(Option<String>)`](crate::output::GetAdminAccountOutput::admin_account): <p>The Amazon Web Services account that is set as the Firewall Manager administrator.</p>
    ///   - [`role_status(Option<AccountRoleStatus>)`](crate::output::GetAdminAccountOutput::role_status): <p>The status of the Amazon Web Services account that you set as the Firewall Manager administrator.</p>
    /// - On failure, responds with [`SdkError<GetAdminAccountError>`](crate::error::GetAdminAccountError)
    pub fn get_admin_account(&self) -> fluent_builders::GetAdminAccount<C, M, R> {
        fluent_builders::GetAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAppsList`](crate::client::fluent_builders::GetAppsList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`list_id(impl Into<String>)`](crate::client::fluent_builders::GetAppsList::list_id) / [`set_list_id(Option<String>)`](crate::client::fluent_builders::GetAppsList::set_list_id): <p>The ID of the Firewall Manager applications list that you want the details for.</p>
    ///   - [`default_list(bool)`](crate::client::fluent_builders::GetAppsList::default_list) / [`set_default_list(bool)`](crate::client::fluent_builders::GetAppsList::set_default_list): <p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>
    /// - On success, responds with [`GetAppsListOutput`](crate::output::GetAppsListOutput) with field(s):
    ///   - [`apps_list(Option<AppsListData>)`](crate::output::GetAppsListOutput::apps_list): <p>Information about the specified Firewall Manager applications list.</p>
    ///   - [`apps_list_arn(Option<String>)`](crate::output::GetAppsListOutput::apps_list_arn): <p>The Amazon Resource Name (ARN) of the applications list.</p>
    /// - On failure, responds with [`SdkError<GetAppsListError>`](crate::error::GetAppsListError)
    pub fn get_apps_list(&self) -> fluent_builders::GetAppsList<C, M, R> {
        fluent_builders::GetAppsList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComplianceDetail`](crate::client::fluent_builders::GetComplianceDetail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::GetComplianceDetail::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::GetComplianceDetail::set_policy_id): <p>The ID of the policy that you want to get the details for. <code>PolicyId</code> is returned by <code>PutPolicy</code> and by <code>ListPolicies</code>.</p>
    ///   - [`member_account(impl Into<String>)`](crate::client::fluent_builders::GetComplianceDetail::member_account) / [`set_member_account(Option<String>)`](crate::client::fluent_builders::GetComplianceDetail::set_member_account): <p>The Amazon Web Services account that owns the resources that you want to get the details for.</p>
    /// - On success, responds with [`GetComplianceDetailOutput`](crate::output::GetComplianceDetailOutput) with field(s):
    ///   - [`policy_compliance_detail(Option<PolicyComplianceDetail>)`](crate::output::GetComplianceDetailOutput::policy_compliance_detail): <p>Information about the resources and the policy that you specified in the <code>GetComplianceDetail</code> request.</p>
    /// - On failure, responds with [`SdkError<GetComplianceDetailError>`](crate::error::GetComplianceDetailError)
    pub fn get_compliance_detail(&self) -> fluent_builders::GetComplianceDetail<C, M, R> {
        fluent_builders::GetComplianceDetail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNotificationChannel`](crate::client::fluent_builders::GetNotificationChannel) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetNotificationChannel::send) it.

    /// - On success, responds with [`GetNotificationChannelOutput`](crate::output::GetNotificationChannelOutput) with field(s):
    ///   - [`sns_topic_arn(Option<String>)`](crate::output::GetNotificationChannelOutput::sns_topic_arn): <p>The SNS topic that records Firewall Manager activity. </p>
    ///   - [`sns_role_name(Option<String>)`](crate::output::GetNotificationChannelOutput::sns_role_name): <p>The IAM role that is used by Firewall Manager to record activity to SNS.</p>
    /// - On failure, responds with [`SdkError<GetNotificationChannelError>`](crate::error::GetNotificationChannelError)
    pub fn get_notification_channel(&self) -> fluent_builders::GetNotificationChannel<C, M, R> {
        fluent_builders::GetNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPolicy`](crate::client::fluent_builders::GetPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::GetPolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::GetPolicy::set_policy_id): <p>The ID of the Firewall Manager policy that you want the details for.</p>
    /// - On success, responds with [`GetPolicyOutput`](crate::output::GetPolicyOutput) with field(s):
    ///   - [`policy(Option<Policy>)`](crate::output::GetPolicyOutput::policy): <p>Information about the specified Firewall Manager policy.</p>
    ///   - [`policy_arn(Option<String>)`](crate::output::GetPolicyOutput::policy_arn): <p>The Amazon Resource Name (ARN) of the specified policy.</p>
    /// - On failure, responds with [`SdkError<GetPolicyError>`](crate::error::GetPolicyError)
    pub fn get_policy(&self) -> fluent_builders::GetPolicy<C, M, R> {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProtectionStatus`](crate::client::fluent_builders::GetProtectionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::GetProtectionStatus::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::GetProtectionStatus::set_policy_id): <p>The ID of the policy for which you want to get the attack information.</p>
    ///   - [`member_account_id(impl Into<String>)`](crate::client::fluent_builders::GetProtectionStatus::member_account_id) / [`set_member_account_id(Option<String>)`](crate::client::fluent_builders::GetProtectionStatus::set_member_account_id): <p>The Amazon Web Services account that is in scope of the policy that you want to get the details for.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetProtectionStatus::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetProtectionStatus::set_start_time): <p>The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetProtectionStatus::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetProtectionStatus::set_end_time): <p>The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetProtectionStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetProtectionStatus::set_next_token): <p>If you specify a value for <code>MaxResults</code> and you have more objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response, which you can use to retrieve another group of objects. For the second and subsequent <code>GetProtectionStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of objects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetProtectionStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetProtectionStatus::set_max_results): <p>Specifies the number of objects that you want Firewall Manager to return for this request. If you have more objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of objects.</p>
    /// - On success, responds with [`GetProtectionStatusOutput`](crate::output::GetProtectionStatusOutput) with field(s):
    ///   - [`admin_account_id(Option<String>)`](crate::output::GetProtectionStatusOutput::admin_account_id): <p>The ID of the Firewall Manager administrator account for this policy.</p>
    ///   - [`service_type(Option<SecurityServiceType>)`](crate::output::GetProtectionStatusOutput::service_type): <p>The service type that is protected by the policy. Currently, this is always <code>SHIELD_ADVANCED</code>.</p>
    ///   - [`data(Option<String>)`](crate::output::GetProtectionStatusOutput::data): <p>Details about the attack, including the following:</p>  <ul>   <li> <p>Attack type</p> </li>   <li> <p>Account ID</p> </li>   <li> <p>ARN of the resource attacked</p> </li>   <li> <p>Start time of the attack</p> </li>   <li> <p>End time of the attack (ongoing attacks will not have an end time)</p> </li>  </ul>  <p>The details are in JSON format. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetProtectionStatusOutput::next_token): <p>If you have more objects than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more objects, submit another <code>GetProtectionStatus</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p>  <p>Amazon Web Services SDKs provide auto-pagination that identify <code>NextToken</code> in a response and make subsequent request calls automatically on your behalf. However, this feature is not supported by <code>GetProtectionStatus</code>. You must submit subsequent requests with <code>NextToken</code> using your own processes. </p>
    /// - On failure, responds with [`SdkError<GetProtectionStatusError>`](crate::error::GetProtectionStatusError)
    pub fn get_protection_status(&self) -> fluent_builders::GetProtectionStatus<C, M, R> {
        fluent_builders::GetProtectionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProtocolsList`](crate::client::fluent_builders::GetProtocolsList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`list_id(impl Into<String>)`](crate::client::fluent_builders::GetProtocolsList::list_id) / [`set_list_id(Option<String>)`](crate::client::fluent_builders::GetProtocolsList::set_list_id): <p>The ID of the Firewall Manager protocols list that you want the details for.</p>
    ///   - [`default_list(bool)`](crate::client::fluent_builders::GetProtocolsList::default_list) / [`set_default_list(bool)`](crate::client::fluent_builders::GetProtocolsList::set_default_list): <p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>
    /// - On success, responds with [`GetProtocolsListOutput`](crate::output::GetProtocolsListOutput) with field(s):
    ///   - [`protocols_list(Option<ProtocolsListData>)`](crate::output::GetProtocolsListOutput::protocols_list): <p>Information about the specified Firewall Manager protocols list.</p>
    ///   - [`protocols_list_arn(Option<String>)`](crate::output::GetProtocolsListOutput::protocols_list_arn): <p>The Amazon Resource Name (ARN) of the specified protocols list.</p>
    /// - On failure, responds with [`SdkError<GetProtocolsListError>`](crate::error::GetProtocolsListError)
    pub fn get_protocols_list(&self) -> fluent_builders::GetProtocolsList<C, M, R> {
        fluent_builders::GetProtocolsList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetViolationDetails`](crate::client::fluent_builders::GetViolationDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::GetViolationDetails::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::GetViolationDetails::set_policy_id): <p>The ID of the Firewall Manager policy that you want the details for. This currently only supports security group content audit policies.</p>
    ///   - [`member_account(impl Into<String>)`](crate::client::fluent_builders::GetViolationDetails::member_account) / [`set_member_account(Option<String>)`](crate::client::fluent_builders::GetViolationDetails::set_member_account): <p>The Amazon Web Services account ID that you want the details for.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetViolationDetails::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetViolationDetails::set_resource_id): <p>The ID of the resource that has violations.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::GetViolationDetails::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::GetViolationDetails::set_resource_type): <p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. Supported resource types are: <code>AWS::EC2::Instance</code>, <code>AWS::EC2::NetworkInterface</code>, <code>AWS::EC2::SecurityGroup</code>, <code>AWS::NetworkFirewall::FirewallPolicy</code>, and <code>AWS::EC2::Subnet</code>. </p>
    /// - On success, responds with [`GetViolationDetailsOutput`](crate::output::GetViolationDetailsOutput) with field(s):
    ///   - [`violation_detail(Option<ViolationDetail>)`](crate::output::GetViolationDetailsOutput::violation_detail): <p>Violation detail for a resource.</p>
    /// - On failure, responds with [`SdkError<GetViolationDetailsError>`](crate::error::GetViolationDetailsError)
    pub fn get_violation_details(&self) -> fluent_builders::GetViolationDetails<C, M, R> {
        fluent_builders::GetViolationDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppsLists`](crate::client::fluent_builders::ListAppsLists) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppsLists::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`default_lists(bool)`](crate::client::fluent_builders::ListAppsLists::default_lists) / [`set_default_lists(bool)`](crate::client::fluent_builders::ListAppsLists::set_default_lists): <p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppsLists::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppsLists::set_next_token): <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppsLists::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppsLists::set_max_results): <p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify this, Firewall Manager returns all available objects.</p>
    /// - On success, responds with [`ListAppsListsOutput`](crate::output::ListAppsListsOutput) with field(s):
    ///   - [`apps_lists(Option<Vec<AppsListDataSummary>>)`](crate::output::ListAppsListsOutput::apps_lists): <p>An array of <code>AppsListDataSummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppsListsOutput::next_token): <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. You can use this token in subsequent requests to retrieve the next batch of objects.</p>
    /// - On failure, responds with [`SdkError<ListAppsListsError>`](crate::error::ListAppsListsError)
    pub fn list_apps_lists(&self) -> fluent_builders::ListAppsLists<C, M, R> {
        fluent_builders::ListAppsLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComplianceStatus`](crate::client::fluent_builders::ListComplianceStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComplianceStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::ListComplianceStatus::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::ListComplianceStatus::set_policy_id): <p>The ID of the Firewall Manager policy that you want the details for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComplianceStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComplianceStatus::set_next_token): <p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicyComplianceStatus</code> objects. For the second and subsequent <code>ListComplianceStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicyComplianceStatus</code> objects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComplianceStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComplianceStatus::set_max_results): <p>Specifies the number of <code>PolicyComplianceStatus</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicyComplianceStatus</code> objects.</p>
    /// - On success, responds with [`ListComplianceStatusOutput`](crate::output::ListComplianceStatusOutput) with field(s):
    ///   - [`policy_compliance_status_list(Option<Vec<PolicyComplianceStatus>>)`](crate::output::ListComplianceStatusOutput::policy_compliance_status_list): <p>An array of <code>PolicyComplianceStatus</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComplianceStatusOutput::next_token): <p>If you have more <code>PolicyComplianceStatus</code> objects than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more <code>PolicyComplianceStatus</code> objects, submit another <code>ListComplianceStatus</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p>
    /// - On failure, responds with [`SdkError<ListComplianceStatusError>`](crate::error::ListComplianceStatusError)
    pub fn list_compliance_status(&self) -> fluent_builders::ListComplianceStatus<C, M, R> {
        fluent_builders::ListComplianceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMemberAccounts`](crate::client::fluent_builders::ListMemberAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMemberAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMemberAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMemberAccounts::set_next_token): <p>If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of IDs. For the second and subsequent <code>ListMemberAccountsRequest</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of member account IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMemberAccounts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMemberAccounts::set_max_results): <p>Specifies the number of member account IDs that you want Firewall Manager to return for this request. If you have more IDs than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of member account IDs.</p>
    /// - On success, responds with [`ListMemberAccountsOutput`](crate::output::ListMemberAccountsOutput) with field(s):
    ///   - [`member_accounts(Option<Vec<String>>)`](crate::output::ListMemberAccountsOutput::member_accounts): <p>An array of account IDs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMemberAccountsOutput::next_token): <p>If you have more member account IDs than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more IDs, submit another <code>ListMemberAccounts</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p>
    /// - On failure, responds with [`SdkError<ListMemberAccountsError>`](crate::error::ListMemberAccountsError)
    pub fn list_member_accounts(&self) -> fluent_builders::ListMemberAccounts<C, M, R> {
        fluent_builders::ListMemberAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPolicies`](crate::client::fluent_builders::ListPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPolicies::set_next_token): <p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicySummary</code> objects. For the second and subsequent <code>ListPolicies</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicySummary</code> objects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPolicies::set_max_results): <p>Specifies the number of <code>PolicySummary</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicySummary</code> objects.</p>
    /// - On success, responds with [`ListPoliciesOutput`](crate::output::ListPoliciesOutput) with field(s):
    ///   - [`policy_list(Option<Vec<PolicySummary>>)`](crate::output::ListPoliciesOutput::policy_list): <p>An array of <code>PolicySummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPoliciesOutput::next_token): <p>If you have more <code>PolicySummary</code> objects than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more <code>PolicySummary</code> objects, submit another <code>ListPolicies</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p>
    /// - On failure, responds with [`SdkError<ListPoliciesError>`](crate::error::ListPoliciesError)
    pub fn list_policies(&self) -> fluent_builders::ListPolicies<C, M, R> {
        fluent_builders::ListPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProtocolsLists`](crate::client::fluent_builders::ListProtocolsLists) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProtocolsLists::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`default_lists(bool)`](crate::client::fluent_builders::ListProtocolsLists::default_lists) / [`set_default_lists(bool)`](crate::client::fluent_builders::ListProtocolsLists::set_default_lists): <p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProtocolsLists::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProtocolsLists::set_next_token): <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProtocolsLists::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProtocolsLists::set_max_results): <p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify this, Firewall Manager returns all available objects.</p>
    /// - On success, responds with [`ListProtocolsListsOutput`](crate::output::ListProtocolsListsOutput) with field(s):
    ///   - [`protocols_lists(Option<Vec<ProtocolsListDataSummary>>)`](crate::output::ListProtocolsListsOutput::protocols_lists): <p>An array of <code>ProtocolsListDataSummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProtocolsListsOutput::next_token): <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. You can use this token in subsequent requests to retrieve the next batch of objects.</p>
    /// - On failure, responds with [`SdkError<ListProtocolsListsError>`](crate::error::ListProtocolsListsError)
    pub fn list_protocols_lists(&self) -> fluent_builders::ListProtocolsLists<C, M, R> {
        fluent_builders::ListProtocolsLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>The tags associated with the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAppsList`](crate::client::fluent_builders::PutAppsList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`apps_list(AppsListData)`](crate::client::fluent_builders::PutAppsList::apps_list) / [`set_apps_list(Option<AppsListData>)`](crate::client::fluent_builders::PutAppsList::set_apps_list): <p>The details of the Firewall Manager applications list to be created.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::PutAppsList::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutAppsList::set_tag_list): <p>The tags associated with the resource.</p>
    /// - On success, responds with [`PutAppsListOutput`](crate::output::PutAppsListOutput) with field(s):
    ///   - [`apps_list(Option<AppsListData>)`](crate::output::PutAppsListOutput::apps_list): <p>The details of the Firewall Manager applications list.</p>
    ///   - [`apps_list_arn(Option<String>)`](crate::output::PutAppsListOutput::apps_list_arn): <p>The Amazon Resource Name (ARN) of the applications list.</p>
    /// - On failure, responds with [`SdkError<PutAppsListError>`](crate::error::PutAppsListError)
    pub fn put_apps_list(&self) -> fluent_builders::PutAppsList<C, M, R> {
        fluent_builders::PutAppsList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutNotificationChannel`](crate::client::fluent_builders::PutNotificationChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::PutNotificationChannel::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::PutNotificationChannel::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.</p>
    ///   - [`sns_role_name(impl Into<String>)`](crate::client::fluent_builders::PutNotificationChannel::sns_role_name) / [`set_sns_role_name(Option<String>)`](crate::client::fluent_builders::PutNotificationChannel::set_sns_role_name): <p>The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager activity. </p>
    /// - On success, responds with [`PutNotificationChannelOutput`](crate::output::PutNotificationChannelOutput)

    /// - On failure, responds with [`SdkError<PutNotificationChannelError>`](crate::error::PutNotificationChannelError)
    pub fn put_notification_channel(&self) -> fluent_builders::PutNotificationChannel<C, M, R> {
        fluent_builders::PutNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPolicy`](crate::client::fluent_builders::PutPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy(Policy)`](crate::client::fluent_builders::PutPolicy::policy) / [`set_policy(Option<Policy>)`](crate::client::fluent_builders::PutPolicy::set_policy): <p>The details of the Firewall Manager policy to be created.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::PutPolicy::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutPolicy::set_tag_list): <p>The tags to add to the Amazon Web Services resource.</p>
    /// - On success, responds with [`PutPolicyOutput`](crate::output::PutPolicyOutput) with field(s):
    ///   - [`policy(Option<Policy>)`](crate::output::PutPolicyOutput::policy): <p>The details of the Firewall Manager policy.</p>
    ///   - [`policy_arn(Option<String>)`](crate::output::PutPolicyOutput::policy_arn): <p>The Amazon Resource Name (ARN) of the policy.</p>
    /// - On failure, responds with [`SdkError<PutPolicyError>`](crate::error::PutPolicyError)
    pub fn put_policy(&self) -> fluent_builders::PutPolicy<C, M, R> {
        fluent_builders::PutPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutProtocolsList`](crate::client::fluent_builders::PutProtocolsList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protocols_list(ProtocolsListData)`](crate::client::fluent_builders::PutProtocolsList::protocols_list) / [`set_protocols_list(Option<ProtocolsListData>)`](crate::client::fluent_builders::PutProtocolsList::set_protocols_list): <p>The details of the Firewall Manager protocols list to be created.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::PutProtocolsList::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutProtocolsList::set_tag_list): <p>The tags associated with the resource.</p>
    /// - On success, responds with [`PutProtocolsListOutput`](crate::output::PutProtocolsListOutput) with field(s):
    ///   - [`protocols_list(Option<ProtocolsListData>)`](crate::output::PutProtocolsListOutput::protocols_list): <p>The details of the Firewall Manager protocols list.</p>
    ///   - [`protocols_list_arn(Option<String>)`](crate::output::PutProtocolsListOutput::protocols_list_arn): <p>The Amazon Resource Name (ARN) of the protocols list.</p>
    /// - On failure, responds with [`SdkError<PutProtocolsListError>`](crate::error::PutProtocolsListError)
    pub fn put_protocols_list(&self) -> fluent_builders::PutProtocolsList<C, M, R> {
        fluent_builders::PutProtocolsList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tag_list): <p>The tags to add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to remove from the resource. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAdminAccount`.
    ///
    /// <p>Sets the Firewall Manager administrator account. The account must be a member of the organization in Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account to administer your Firewall Manager policies.</p>
    /// <p>The account that you associate with Firewall Manager is called the Firewall Manager administrator account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_admin_account_input::Builder,
    }
    impl<C, M, R> AssociateAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAdminAccountInputOperationOutputAlias,
                crate::output::AssociateAdminAccountOutput,
                crate::error::AssociateAdminAccountError,
                crate::input::AssociateAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID to associate with Firewall Manager as the Firewall Manager administrator account. This must be an Organizations member account. For more information about Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the Amazon Web Services Accounts in Your Organization</a>. </p>
        pub fn admin_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID to associate with Firewall Manager as the Firewall Manager administrator account. This must be an Organizations member account. For more information about Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the Amazon Web Services Accounts in Your Organization</a>. </p>
        pub fn set_admin_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppsList`.
    ///
    /// <p>Permanently deletes an Firewall Manager applications list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppsList<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apps_list_input::Builder,
    }
    impl<C, M, R> DeleteAppsList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppsList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppsListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppsListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppsListInputOperationOutputAlias,
                crate::output::DeleteAppsListOutput,
                crate::error::DeleteAppsListError,
                crate::input::DeleteAppsListInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the applications list that you want to delete. You can retrieve this ID from <code>PutAppsList</code>, <code>ListAppsLists</code>, and <code>GetAppsList</code>.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.list_id(input.into());
            self
        }
        /// <p>The ID of the applications list that you want to delete. You can retrieve this ID from <code>PutAppsList</code>, <code>ListAppsLists</code>, and <code>GetAppsList</code>.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotificationChannel`.
    ///
    /// <p>Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNotificationChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_notification_channel_input::Builder,
    }
    impl<C, M, R> DeleteNotificationChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNotificationChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNotificationChannelInputOperationOutputAlias,
                crate::output::DeleteNotificationChannelOutput,
                crate::error::DeleteNotificationChannelError,
                crate::input::DeleteNotificationChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// <p>Permanently deletes an Firewall Manager policy. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl<C, M, R> DeletePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyInputOperationOutputAlias,
                crate::output::DeletePolicyOutput,
                crate::error::DeletePolicyError,
                crate::input::DeletePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and <code>ListPolicies</code>.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and <code>ListPolicies</code>.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>If <code>True</code>, the request performs cleanup according to the policy type. </p>
        /// <p>For WAF and Shield Advanced policies, the cleanup does the following:</p>
        /// <ul>
        /// <li> <p>Deletes rule groups created by Firewall Manager</p> </li>
        /// <li> <p>Removes web ACLs from in-scope resources</p> </li>
        /// <li> <p>Deletes web ACLs that contain no rules or rule groups</p> </li>
        /// </ul>
        /// <p>For security group policies, the cleanup does the following for each security group in the policy:</p>
        /// <ul>
        /// <li> <p>Disassociates the security group from in-scope resources </p> </li>
        /// <li> <p>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</p> </li>
        /// </ul>
        /// <p>After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope. </p>
        pub fn delete_all_policy_resources(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_all_policy_resources(input);
            self
        }
        /// <p>If <code>True</code>, the request performs cleanup according to the policy type. </p>
        /// <p>For WAF and Shield Advanced policies, the cleanup does the following:</p>
        /// <ul>
        /// <li> <p>Deletes rule groups created by Firewall Manager</p> </li>
        /// <li> <p>Removes web ACLs from in-scope resources</p> </li>
        /// <li> <p>Deletes web ACLs that contain no rules or rule groups</p> </li>
        /// </ul>
        /// <p>For security group policies, the cleanup does the following for each security group in the policy:</p>
        /// <ul>
        /// <li> <p>Disassociates the security group from in-scope resources </p> </li>
        /// <li> <p>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</p> </li>
        /// </ul>
        /// <p>After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope. </p>
        pub fn set_delete_all_policy_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_all_policy_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProtocolsList`.
    ///
    /// <p>Permanently deletes an Firewall Manager protocols list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProtocolsList<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_protocols_list_input::Builder,
    }
    impl<C, M, R> DeleteProtocolsList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProtocolsList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProtocolsListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProtocolsListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProtocolsListInputOperationOutputAlias,
                crate::output::DeleteProtocolsListOutput,
                crate::error::DeleteProtocolsListError,
                crate::input::DeleteProtocolsListInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the protocols list that you want to delete. You can retrieve this ID from <code>PutProtocolsList</code>, <code>ListProtocolsLists</code>, and <code>GetProtocolsLost</code>.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.list_id(input.into());
            self
        }
        /// <p>The ID of the protocols list that you want to delete. You can retrieve this ID from <code>PutProtocolsList</code>, <code>ListProtocolsLists</code>, and <code>GetProtocolsLost</code>.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAdminAccount`.
    ///
    /// <p>Disassociates the account that has been set as the Firewall Manager administrator account. To set a different account as the administrator account, you must submit an <code>AssociateAdminAccount</code> request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_admin_account_input::Builder,
    }
    impl<C, M, R> DisassociateAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateAdminAccountInputOperationOutputAlias,
                crate::output::DisassociateAdminAccountOutput,
                crate::error::DisassociateAdminAccountError,
                crate::input::DisassociateAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAdminAccount`.
    ///
    /// <p>Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_admin_account_input::Builder,
    }
    impl<C, M, R> GetAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAdminAccountInputOperationOutputAlias,
                crate::output::GetAdminAccountOutput,
                crate::error::GetAdminAccountError,
                crate::input::GetAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAppsList`.
    ///
    /// <p>Returns information about the specified Firewall Manager applications list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAppsList<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apps_list_input::Builder,
    }
    impl<C, M, R> GetAppsList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppsList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppsListOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppsListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppsListInputOperationOutputAlias,
                crate::output::GetAppsListOutput,
                crate::error::GetAppsListError,
                crate::input::GetAppsListInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Firewall Manager applications list that you want the details for.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.list_id(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager applications list that you want the details for.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_list_id(input);
            self
        }
        /// <p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>
        pub fn default_list(mut self, input: bool) -> Self {
            self.inner = self.inner.default_list(input);
            self
        }
        /// <p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>
        pub fn set_default_list(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComplianceDetail`.
    ///
    /// <p>Returns detailed compliance information about the specified member account. Details include resources that are in and out of compliance with the specified policy. </p>
    /// <ul>
    /// <li> <p>Resources are considered noncompliant for WAF and Shield Advanced policies if the specified policy has not been applied to them.</p> </li>
    /// <li> <p>Resources are considered noncompliant for security group policies if they are in scope of the policy, they violate one or more of the policy rules, and remediation is disabled or not possible.</p> </li>
    /// <li> <p>Resources are considered noncompliant for Network Firewall policies if a firewall is missing in the VPC, if the firewall endpoint isn't set up in an expected Availability Zone and subnet, if a subnet created by the Firewall Manager doesn't have the expected route table, and for modifications to a firewall policy that violate the Firewall Manager policy's rules.</p> </li>
    /// <li> <p>Resources are considered noncompliant for DNS Firewall policies if a DNS Firewall rule group is missing from the rule group associations for the VPC. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComplianceDetail<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_compliance_detail_input::Builder,
    }
    impl<C, M, R> GetComplianceDetail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComplianceDetail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComplianceDetailOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComplianceDetailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComplianceDetailInputOperationOutputAlias,
                crate::output::GetComplianceDetailOutput,
                crate::error::GetComplianceDetailError,
                crate::input::GetComplianceDetailInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the policy that you want to get the details for. <code>PolicyId</code> is returned by <code>PutPolicy</code> and by <code>ListPolicies</code>.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The ID of the policy that you want to get the details for. <code>PolicyId</code> is returned by <code>PutPolicy</code> and by <code>ListPolicies</code>.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The Amazon Web Services account that owns the resources that you want to get the details for.</p>
        pub fn member_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account(input.into());
            self
        }
        /// <p>The Amazon Web Services account that owns the resources that you want to get the details for.</p>
        pub fn set_member_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNotificationChannel`.
    ///
    /// <p>Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNotificationChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_notification_channel_input::Builder,
    }
    impl<C, M, R> GetNotificationChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNotificationChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNotificationChannelInputOperationOutputAlias,
                crate::output::GetNotificationChannelOutput,
                crate::error::GetNotificationChannelError,
                crate::input::GetNotificationChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// <p>Returns information about the specified Firewall Manager policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl<C, M, R> GetPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyInputOperationOutputAlias,
                crate::output::GetPolicyOutput,
                crate::error::GetPolicyError,
                crate::input::GetPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Firewall Manager policy that you want the details for.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager policy that you want the details for.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProtectionStatus`.
    ///
    /// <p>If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack. Other policy types are currently unsupported.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProtectionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_protection_status_input::Builder,
    }
    impl<C, M, R> GetProtectionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProtectionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProtectionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProtectionStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProtectionStatusInputOperationOutputAlias,
                crate::output::GetProtectionStatusOutput,
                crate::error::GetProtectionStatusError,
                crate::input::GetProtectionStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the policy for which you want to get the attack information.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The ID of the policy for which you want to get the attack information.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The Amazon Web Services account that is in scope of the policy that you want to get the details for.</p>
        pub fn member_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account that is in scope of the policy that you want to get the details for.</p>
        pub fn set_member_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account_id(input);
            self
        }
        /// <p>The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response, which you can use to retrieve another group of objects. For the second and subsequent <code>GetProtectionStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response, which you can use to retrieve another group of objects. For the second and subsequent <code>GetProtectionStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the number of objects that you want Firewall Manager to return for this request. If you have more objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of objects that you want Firewall Manager to return for this request. If you have more objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProtocolsList`.
    ///
    /// <p>Returns information about the specified Firewall Manager protocols list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProtocolsList<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_protocols_list_input::Builder,
    }
    impl<C, M, R> GetProtocolsList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProtocolsList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProtocolsListOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProtocolsListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProtocolsListInputOperationOutputAlias,
                crate::output::GetProtocolsListOutput,
                crate::error::GetProtocolsListError,
                crate::input::GetProtocolsListInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Firewall Manager protocols list that you want the details for.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.list_id(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager protocols list that you want the details for.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_list_id(input);
            self
        }
        /// <p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>
        pub fn default_list(mut self, input: bool) -> Self {
            self.inner = self.inner.default_list(input);
            self
        }
        /// <p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>
        pub fn set_default_list(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetViolationDetails`.
    ///
    /// <p>Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetViolationDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_violation_details_input::Builder,
    }
    impl<C, M, R> GetViolationDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetViolationDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetViolationDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetViolationDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetViolationDetailsInputOperationOutputAlias,
                crate::output::GetViolationDetailsOutput,
                crate::error::GetViolationDetailsError,
                crate::input::GetViolationDetailsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Firewall Manager policy that you want the details for. This currently only supports security group content audit policies.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager policy that you want the details for. This currently only supports security group content audit policies.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID that you want the details for.</p>
        pub fn member_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that you want the details for.</p>
        pub fn set_member_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account(input);
            self
        }
        /// <p>The ID of the resource that has violations.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource that has violations.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. Supported resource types are: <code>AWS::EC2::Instance</code>, <code>AWS::EC2::NetworkInterface</code>, <code>AWS::EC2::SecurityGroup</code>, <code>AWS::NetworkFirewall::FirewallPolicy</code>, and <code>AWS::EC2::Subnet</code>. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. Supported resource types are: <code>AWS::EC2::Instance</code>, <code>AWS::EC2::NetworkInterface</code>, <code>AWS::EC2::SecurityGroup</code>, <code>AWS::NetworkFirewall::FirewallPolicy</code>, and <code>AWS::EC2::Subnet</code>. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppsLists`.
    ///
    /// <p>Returns an array of <code>AppsListDataSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppsLists<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_apps_lists_input::Builder,
    }
    impl<C, M, R> ListAppsLists<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppsLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppsListsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppsListsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppsListsInputOperationOutputAlias,
                crate::output::ListAppsListsOutput,
                crate::error::ListAppsListsError,
                crate::input::ListAppsListsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppsListsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppsListsPaginator<C, M, R> {
            crate::paginator::ListAppsListsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>
        pub fn default_lists(mut self, input: bool) -> Self {
            self.inner = self.inner.default_lists(input);
            self
        }
        /// <p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>
        pub fn set_default_lists(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_lists(input);
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify this, Firewall Manager returns all available objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify this, Firewall Manager returns all available objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComplianceStatus`.
    ///
    /// <p>Returns an array of <code>PolicyComplianceStatus</code> objects. Use <code>PolicyComplianceStatus</code> to get a summary of which member accounts are protected by the specified policy. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComplianceStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_compliance_status_input::Builder,
    }
    impl<C, M, R> ListComplianceStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComplianceStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComplianceStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComplianceStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComplianceStatusInputOperationOutputAlias,
                crate::output::ListComplianceStatusOutput,
                crate::error::ListComplianceStatusError,
                crate::input::ListComplianceStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComplianceStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComplianceStatusPaginator<C, M, R> {
            crate::paginator::ListComplianceStatusPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Firewall Manager policy that you want the details for.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager policy that you want the details for.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicyComplianceStatus</code> objects. For the second and subsequent <code>ListComplianceStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicyComplianceStatus</code> objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicyComplianceStatus</code> objects. For the second and subsequent <code>ListComplianceStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicyComplianceStatus</code> objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the number of <code>PolicyComplianceStatus</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicyComplianceStatus</code> objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of <code>PolicyComplianceStatus</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicyComplianceStatus</code> objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMemberAccounts`.
    ///
    /// <p>Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's Amazon Web Services organization.</p>
    /// <p>The <code>ListMemberAccounts</code> must be submitted by the account that is set as the Firewall Manager administrator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMemberAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_member_accounts_input::Builder,
    }
    impl<C, M, R> ListMemberAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMemberAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMemberAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMemberAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMemberAccountsInputOperationOutputAlias,
                crate::output::ListMemberAccountsOutput,
                crate::error::ListMemberAccountsError,
                crate::input::ListMemberAccountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMemberAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMemberAccountsPaginator<C, M, R> {
            crate::paginator::ListMemberAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of IDs. For the second and subsequent <code>ListMemberAccountsRequest</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of member account IDs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of IDs. For the second and subsequent <code>ListMemberAccountsRequest</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of member account IDs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the number of member account IDs that you want Firewall Manager to return for this request. If you have more IDs than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of member account IDs.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of member account IDs that you want Firewall Manager to return for this request. If you have more IDs than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of member account IDs.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicies`.
    ///
    /// <p>Returns an array of <code>PolicySummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policies_input::Builder,
    }
    impl<C, M, R> ListPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPoliciesInputOperationOutputAlias,
                crate::output::ListPoliciesOutput,
                crate::error::ListPoliciesError,
                crate::input::ListPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPoliciesPaginator<C, M, R> {
            crate::paginator::ListPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicySummary</code> objects. For the second and subsequent <code>ListPolicies</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicySummary</code> objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicySummary</code> objects. For the second and subsequent <code>ListPolicies</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicySummary</code> objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the number of <code>PolicySummary</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicySummary</code> objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of <code>PolicySummary</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicySummary</code> objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProtocolsLists`.
    ///
    /// <p>Returns an array of <code>ProtocolsListDataSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProtocolsLists<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_protocols_lists_input::Builder,
    }
    impl<C, M, R> ListProtocolsLists<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProtocolsLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProtocolsListsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProtocolsListsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProtocolsListsInputOperationOutputAlias,
                crate::output::ListProtocolsListsOutput,
                crate::error::ListProtocolsListsError,
                crate::input::ListProtocolsListsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProtocolsListsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProtocolsListsPaginator<C, M, R> {
            crate::paginator::ListProtocolsListsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>
        pub fn default_lists(mut self, input: bool) -> Self {
            self.inner = self.inner.default_lists(input);
            self
        }
        /// <p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>
        pub fn set_default_lists(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_lists(input);
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify this, Firewall Manager returns all available objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify this, Firewall Manager returns all available objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the list of tags for the specified Amazon Web Services resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppsList`.
    ///
    /// <p>Creates an Firewall Manager applications list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAppsList<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_apps_list_input::Builder,
    }
    impl<C, M, R> PutAppsList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppsList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppsListOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppsListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppsListInputOperationOutputAlias,
                crate::output::PutAppsListOutput,
                crate::error::PutAppsListError,
                crate::input::PutAppsListInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The details of the Firewall Manager applications list to be created.</p>
        pub fn apps_list(mut self, input: crate::model::AppsListData) -> Self {
            self.inner = self.inner.apps_list(input);
            self
        }
        /// <p>The details of the Firewall Manager applications list to be created.</p>
        pub fn set_apps_list(
            mut self,
            input: std::option::Option<crate::model::AppsListData>,
        ) -> Self {
            self.inner = self.inner.set_apps_list(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The tags associated with the resource.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>The tags associated with the resource.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutNotificationChannel`.
    ///
    /// <p>Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs.</p>
    /// <p>To perform this action outside of the console, you must configure the SNS topic to allow the Firewall Manager role <code>AWSServiceRoleForFMS</code> to publish SNS logs. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html">Firewall Manager required permissions for API actions</a> in the <i>Firewall Manager Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutNotificationChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_notification_channel_input::Builder,
    }
    impl<C, M, R> PutNotificationChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutNotificationChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutNotificationChannelInputOperationOutputAlias,
                crate::output::PutNotificationChannelOutput,
                crate::error::PutNotificationChannelError,
                crate::input::PutNotificationChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager activity. </p>
        pub fn sns_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_role_name(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager activity. </p>
        pub fn set_sns_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPolicy`.
    ///
    /// <p>Creates an Firewall Manager policy.</p>
    /// <p>Firewall Manager provides the following types of policies: </p>
    /// <ul>
    /// <li> <p>An WAF policy (type WAFV2), which defines rule groups to run first in the corresponding WAF web ACL and rule groups to run last in the web ACL.</p> </li>
    /// <li> <p>An WAF Classic policy (type WAF), which defines a rule group. </p> </li>
    /// <li> <p>A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.</p> </li>
    /// <li> <p>A security group policy, which manages VPC security groups across your Amazon Web Services organization. </p> </li>
    /// <li> <p>An Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.</p> </li>
    /// <li> <p>A DNS Firewall policy, which provides Route&nbsp;53 Resolver DNS Firewall rules to filter DNS queries for specified VPCs.</p> </li>
    /// </ul>
    /// <p>Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.</p>
    /// <p>You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about subscribing to Shield Advanced, see <a href="https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html">CreateSubscription</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_policy_input::Builder,
    }
    impl<C, M, R> PutPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPolicyInputOperationOutputAlias,
                crate::output::PutPolicyOutput,
                crate::error::PutPolicyError,
                crate::input::PutPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The details of the Firewall Manager policy to be created.</p>
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.inner = self.inner.policy(input);
            self
        }
        /// <p>The details of the Firewall Manager policy to be created.</p>
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The tags to add to the Amazon Web Services resource.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>The tags to add to the Amazon Web Services resource.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProtocolsList`.
    ///
    /// <p>Creates an Firewall Manager protocols list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutProtocolsList<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_protocols_list_input::Builder,
    }
    impl<C, M, R> PutProtocolsList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutProtocolsList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProtocolsListOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProtocolsListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutProtocolsListInputOperationOutputAlias,
                crate::output::PutProtocolsListOutput,
                crate::error::PutProtocolsListError,
                crate::input::PutProtocolsListInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The details of the Firewall Manager protocols list to be created.</p>
        pub fn protocols_list(mut self, input: crate::model::ProtocolsListData) -> Self {
            self.inner = self.inner.protocols_list(input);
            self
        }
        /// <p>The details of the Firewall Manager protocols list to be created.</p>
        pub fn set_protocols_list(
            mut self,
            input: std::option::Option<crate::model::ProtocolsListData>,
        ) -> Self {
            self.inner = self.inner.set_protocols_list(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The tags associated with the resource.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>The tags associated with the resource.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to an Amazon Web Services resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from an Amazon Web Services resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove from the resource. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to remove from the resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
