// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A collection of key:value pairs associated with an Amazon Web Services resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each Amazon Web Services resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive. </p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>An Firewall Manager protocols list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtocolsListData {
    /// <p>The ID of the Firewall Manager protocols list.</p>
    pub list_id: std::option::Option<std::string::String>,
    /// <p>The name of the Firewall Manager protocols list.</p>
    pub list_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
    pub list_update_token: std::option::Option<std::string::String>,
    /// <p>The time that the Firewall Manager protocols list was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the Firewall Manager protocols list was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An array of protocols in the Firewall Manager protocols list.</p>
    pub protocols_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A map of previous version numbers to their corresponding protocol arrays.</p>
    pub previous_protocols_list: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl ProtocolsListData {
    /// <p>The ID of the Firewall Manager protocols list.</p>
    pub fn list_id(&self) -> std::option::Option<&str> {
        self.list_id.as_deref()
    }
    /// <p>The name of the Firewall Manager protocols list.</p>
    pub fn list_name(&self) -> std::option::Option<&str> {
        self.list_name.as_deref()
    }
    /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
    pub fn list_update_token(&self) -> std::option::Option<&str> {
        self.list_update_token.as_deref()
    }
    /// <p>The time that the Firewall Manager protocols list was created.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The time that the Firewall Manager protocols list was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>An array of protocols in the Firewall Manager protocols list.</p>
    pub fn protocols_list(&self) -> std::option::Option<&[std::string::String]> {
        self.protocols_list.as_deref()
    }
    /// <p>A map of previous version numbers to their corresponding protocol arrays.</p>
    pub fn previous_protocols_list(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.previous_protocols_list.as_ref()
    }
}
impl std::fmt::Debug for ProtocolsListData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtocolsListData");
        formatter.field("list_id", &self.list_id);
        formatter.field("list_name", &self.list_name);
        formatter.field("list_update_token", &self.list_update_token);
        formatter.field("create_time", &self.create_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("protocols_list", &self.protocols_list);
        formatter.field("previous_protocols_list", &self.previous_protocols_list);
        formatter.finish()
    }
}
/// See [`ProtocolsListData`](crate::model::ProtocolsListData)
pub mod protocols_list_data {
    /// A builder for [`ProtocolsListData`](crate::model::ProtocolsListData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) list_id: std::option::Option<std::string::String>,
        pub(crate) list_name: std::option::Option<std::string::String>,
        pub(crate) list_update_token: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) protocols_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) previous_protocols_list: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The ID of the Firewall Manager protocols list.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_id = Some(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager protocols list.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_id = input;
            self
        }
        /// <p>The name of the Firewall Manager protocols list.</p>
        pub fn list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_name = Some(input.into());
            self
        }
        /// <p>The name of the Firewall Manager protocols list.</p>
        pub fn set_list_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_name = input;
            self
        }
        /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
        pub fn list_update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_update_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
        pub fn set_list_update_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.list_update_token = input;
            self
        }
        /// <p>The time that the Firewall Manager protocols list was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time that the Firewall Manager protocols list was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The time that the Firewall Manager protocols list was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time that the Firewall Manager protocols list was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Appends an item to `protocols_list`.
        ///
        /// To override the contents of this collection use [`set_protocols_list`](Self::set_protocols_list).
        ///
        /// <p>An array of protocols in the Firewall Manager protocols list.</p>
        pub fn protocols_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.protocols_list.unwrap_or_default();
            v.push(input.into());
            self.protocols_list = Some(v);
            self
        }
        /// <p>An array of protocols in the Firewall Manager protocols list.</p>
        pub fn set_protocols_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.protocols_list = input;
            self
        }
        /// Adds a key-value pair to `previous_protocols_list`.
        ///
        /// To override the contents of this collection use [`set_previous_protocols_list`](Self::set_previous_protocols_list).
        ///
        /// <p>A map of previous version numbers to their corresponding protocol arrays.</p>
        pub fn previous_protocols_list(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.previous_protocols_list.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.previous_protocols_list = Some(hash_map);
            self
        }
        /// <p>A map of previous version numbers to their corresponding protocol arrays.</p>
        pub fn set_previous_protocols_list(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.previous_protocols_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtocolsListData`](crate::model::ProtocolsListData)
        pub fn build(self) -> crate::model::ProtocolsListData {
            crate::model::ProtocolsListData {
                list_id: self.list_id,
                list_name: self.list_name,
                list_update_token: self.list_update_token,
                create_time: self.create_time,
                last_update_time: self.last_update_time,
                protocols_list: self.protocols_list,
                previous_protocols_list: self.previous_protocols_list,
            }
        }
    }
}
impl ProtocolsListData {
    /// Creates a new builder-style object to manufacture [`ProtocolsListData`](crate::model::ProtocolsListData)
    pub fn builder() -> crate::model::protocols_list_data::Builder {
        crate::model::protocols_list_data::Builder::default()
    }
}

/// <p>An Firewall Manager policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Policy {
    /// <p>The ID of the Firewall Manager policy.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The name of the Firewall Manager policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for each update to the policy. When issuing a <code>PutPolicy</code> request, the <code>PolicyUpdateToken</code> in the request must match the <code>PolicyUpdateToken</code> of the current policy version. To get the <code>PolicyUpdateToken</code> of the current policy version, use a <code>GetPolicy</code> request.</p>
    pub policy_update_token: std::option::Option<std::string::String>,
    /// <p>Details about the security service that is being used to protect the resources.</p>
    pub security_service_policy_data: std::option::Option<crate::model::SecurityServicePolicyData>,
    /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code>.</p>
    /// <p>For WAF and Shield Advanced, resource types include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::ElasticLoadBalancing::LoadBalancer</code>, <code>AWS::EC2::EIP</code>, and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>An array of <code>ResourceType</code> objects. Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code>.</p>
    pub resource_type_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of <code>ResourceTag</code> objects.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    /// <p>If set to <code>True</code>, resources with the tags that are specified in the <code>ResourceTag</code> array are not in scope of the policy. If set to <code>False</code>, and the <code>ResourceTag</code> array is not null, only resources with the specified tags are in scope of the policy.</p>
    pub exclude_resource_tags: bool,
    /// <p>Indicates if the policy should be automatically applied to new resources.</p>
    pub remediation_enabled: bool,
    /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
    /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
    /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
    pub delete_unused_fm_managed_resources: bool,
    /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to include in the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
    /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
    /// <p>You can specify account IDs, OUs, or a combination: </p>
    /// <ul>
    /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
    /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// </ul>
    pub include_map: std::option::Option<
        std::collections::HashMap<
            crate::model::CustomerPolicyScopeIdType,
            std::vec::Vec<std::string::String>,
        >,
    >,
    /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
    /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
    /// <p>You can specify account IDs, OUs, or a combination: </p>
    /// <ul>
    /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
    /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// </ul>
    pub exclude_map: std::option::Option<
        std::collections::HashMap<
            crate::model::CustomerPolicyScopeIdType,
            std::vec::Vec<std::string::String>,
        >,
    >,
}
impl Policy {
    /// <p>The ID of the Firewall Manager policy.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The name of the Firewall Manager policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>A unique identifier for each update to the policy. When issuing a <code>PutPolicy</code> request, the <code>PolicyUpdateToken</code> in the request must match the <code>PolicyUpdateToken</code> of the current policy version. To get the <code>PolicyUpdateToken</code> of the current policy version, use a <code>GetPolicy</code> request.</p>
    pub fn policy_update_token(&self) -> std::option::Option<&str> {
        self.policy_update_token.as_deref()
    }
    /// <p>Details about the security service that is being used to protect the resources.</p>
    pub fn security_service_policy_data(
        &self,
    ) -> std::option::Option<&crate::model::SecurityServicePolicyData> {
        self.security_service_policy_data.as_ref()
    }
    /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code>.</p>
    /// <p>For WAF and Shield Advanced, resource types include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::ElasticLoadBalancing::LoadBalancer</code>, <code>AWS::EC2::EIP</code>, and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>An array of <code>ResourceType</code> objects. Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code>.</p>
    pub fn resource_type_list(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_type_list.as_deref()
    }
    /// <p>An array of <code>ResourceTag</code> objects.</p>
    pub fn resource_tags(&self) -> std::option::Option<&[crate::model::ResourceTag]> {
        self.resource_tags.as_deref()
    }
    /// <p>If set to <code>True</code>, resources with the tags that are specified in the <code>ResourceTag</code> array are not in scope of the policy. If set to <code>False</code>, and the <code>ResourceTag</code> array is not null, only resources with the specified tags are in scope of the policy.</p>
    pub fn exclude_resource_tags(&self) -> bool {
        self.exclude_resource_tags
    }
    /// <p>Indicates if the policy should be automatically applied to new resources.</p>
    pub fn remediation_enabled(&self) -> bool {
        self.remediation_enabled
    }
    /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
    /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
    /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
    pub fn delete_unused_fm_managed_resources(&self) -> bool {
        self.delete_unused_fm_managed_resources
    }
    /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to include in the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
    /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
    /// <p>You can specify account IDs, OUs, or a combination: </p>
    /// <ul>
    /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
    /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// </ul>
    pub fn include_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::CustomerPolicyScopeIdType,
            std::vec::Vec<std::string::String>,
        >,
    > {
        self.include_map.as_ref()
    }
    /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
    /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
    /// <p>You can specify account IDs, OUs, or a combination: </p>
    /// <ul>
    /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
    /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
    /// </ul>
    pub fn exclude_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::CustomerPolicyScopeIdType,
            std::vec::Vec<std::string::String>,
        >,
    > {
        self.exclude_map.as_ref()
    }
}
impl std::fmt::Debug for Policy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Policy");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_update_token", &self.policy_update_token);
        formatter.field(
            "security_service_policy_data",
            &self.security_service_policy_data,
        );
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_type_list", &self.resource_type_list);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("exclude_resource_tags", &self.exclude_resource_tags);
        formatter.field("remediation_enabled", &self.remediation_enabled);
        formatter.field(
            "delete_unused_fm_managed_resources",
            &self.delete_unused_fm_managed_resources,
        );
        formatter.field("include_map", &self.include_map);
        formatter.field("exclude_map", &self.exclude_map);
        formatter.finish()
    }
}
/// See [`Policy`](crate::model::Policy)
pub mod policy {
    /// A builder for [`Policy`](crate::model::Policy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_update_token: std::option::Option<std::string::String>,
        pub(crate) security_service_policy_data:
            std::option::Option<crate::model::SecurityServicePolicyData>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_type_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        pub(crate) exclude_resource_tags: std::option::Option<bool>,
        pub(crate) remediation_enabled: std::option::Option<bool>,
        pub(crate) delete_unused_fm_managed_resources: std::option::Option<bool>,
        pub(crate) include_map: std::option::Option<
            std::collections::HashMap<
                crate::model::CustomerPolicyScopeIdType,
                std::vec::Vec<std::string::String>,
            >,
        >,
        pub(crate) exclude_map: std::option::Option<
            std::collections::HashMap<
                crate::model::CustomerPolicyScopeIdType,
                std::vec::Vec<std::string::String>,
            >,
        >,
    }
    impl Builder {
        /// <p>The ID of the Firewall Manager policy.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager policy.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The name of the Firewall Manager policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the Firewall Manager policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>A unique identifier for each update to the policy. When issuing a <code>PutPolicy</code> request, the <code>PolicyUpdateToken</code> in the request must match the <code>PolicyUpdateToken</code> of the current policy version. To get the <code>PolicyUpdateToken</code> of the current policy version, use a <code>GetPolicy</code> request.</p>
        pub fn policy_update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_update_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for each update to the policy. When issuing a <code>PutPolicy</code> request, the <code>PolicyUpdateToken</code> in the request must match the <code>PolicyUpdateToken</code> of the current policy version. To get the <code>PolicyUpdateToken</code> of the current policy version, use a <code>GetPolicy</code> request.</p>
        pub fn set_policy_update_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_update_token = input;
            self
        }
        /// <p>Details about the security service that is being used to protect the resources.</p>
        pub fn security_service_policy_data(
            mut self,
            input: crate::model::SecurityServicePolicyData,
        ) -> Self {
            self.security_service_policy_data = Some(input);
            self
        }
        /// <p>Details about the security service that is being used to protect the resources.</p>
        pub fn set_security_service_policy_data(
            mut self,
            input: std::option::Option<crate::model::SecurityServicePolicyData>,
        ) -> Self {
            self.security_service_policy_data = input;
            self
        }
        /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code>.</p>
        /// <p>For WAF and Shield Advanced, resource types include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::ElasticLoadBalancing::LoadBalancer</code>, <code>AWS::EC2::EIP</code>, and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code>.</p>
        /// <p>For WAF and Shield Advanced, resource types include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::ElasticLoadBalancing::LoadBalancer</code>, <code>AWS::EC2::EIP</code>, and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_type_list`.
        ///
        /// To override the contents of this collection use [`set_resource_type_list`](Self::set_resource_type_list).
        ///
        /// <p>An array of <code>ResourceType</code> objects. Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code>.</p>
        pub fn resource_type_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_type_list.unwrap_or_default();
            v.push(input.into());
            self.resource_type_list = Some(v);
            self
        }
        /// <p>An array of <code>ResourceType</code> objects. Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code>.</p>
        pub fn set_resource_type_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_type_list = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>An array of <code>ResourceTag</code> objects.</p>
        pub fn resource_tags(mut self, input: crate::model::ResourceTag) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input);
            self.resource_tags = Some(v);
            self
        }
        /// <p>An array of <code>ResourceTag</code> objects.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>If set to <code>True</code>, resources with the tags that are specified in the <code>ResourceTag</code> array are not in scope of the policy. If set to <code>False</code>, and the <code>ResourceTag</code> array is not null, only resources with the specified tags are in scope of the policy.</p>
        pub fn exclude_resource_tags(mut self, input: bool) -> Self {
            self.exclude_resource_tags = Some(input);
            self
        }
        /// <p>If set to <code>True</code>, resources with the tags that are specified in the <code>ResourceTag</code> array are not in scope of the policy. If set to <code>False</code>, and the <code>ResourceTag</code> array is not null, only resources with the specified tags are in scope of the policy.</p>
        pub fn set_exclude_resource_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.exclude_resource_tags = input;
            self
        }
        /// <p>Indicates if the policy should be automatically applied to new resources.</p>
        pub fn remediation_enabled(mut self, input: bool) -> Self {
            self.remediation_enabled = Some(input);
            self
        }
        /// <p>Indicates if the policy should be automatically applied to new resources.</p>
        pub fn set_remediation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remediation_enabled = input;
            self
        }
        /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
        /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
        /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
        pub fn delete_unused_fm_managed_resources(mut self, input: bool) -> Self {
            self.delete_unused_fm_managed_resources = Some(input);
            self
        }
        /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
        /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
        /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
        pub fn set_delete_unused_fm_managed_resources(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.delete_unused_fm_managed_resources = input;
            self
        }
        /// Adds a key-value pair to `include_map`.
        ///
        /// To override the contents of this collection use [`set_include_map`](Self::set_include_map).
        ///
        /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to include in the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
        /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
        /// <p>You can specify account IDs, OUs, or a combination: </p>
        /// <ul>
        /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
        /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// </ul>
        pub fn include_map(
            mut self,
            k: crate::model::CustomerPolicyScopeIdType,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.include_map.unwrap_or_default();
            hash_map.insert(k, v);
            self.include_map = Some(hash_map);
            self
        }
        /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to include in the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
        /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
        /// <p>You can specify account IDs, OUs, or a combination: </p>
        /// <ul>
        /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
        /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// </ul>
        pub fn set_include_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::CustomerPolicyScopeIdType,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.include_map = input;
            self
        }
        /// Adds a key-value pair to `exclude_map`.
        ///
        /// To override the contents of this collection use [`set_exclude_map`](Self::set_exclude_map).
        ///
        /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
        /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
        /// <p>You can specify account IDs, OUs, or a combination: </p>
        /// <ul>
        /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
        /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// </ul>
        pub fn exclude_map(
            mut self,
            k: crate::model::CustomerPolicyScopeIdType,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.exclude_map.unwrap_or_default();
            hash_map.insert(k, v);
            self.exclude_map = Some(hash_map);
            self
        }
        /// <p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p>
        /// <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p>
        /// <p>You can specify account IDs, OUs, or a combination: </p>
        /// <ul>
        /// <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li>
        /// <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li>
        /// </ul>
        pub fn set_exclude_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::CustomerPolicyScopeIdType,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.exclude_map = input;
            self
        }
        /// Consumes the builder and constructs a [`Policy`](crate::model::Policy)
        pub fn build(self) -> crate::model::Policy {
            crate::model::Policy {
                policy_id: self.policy_id,
                policy_name: self.policy_name,
                policy_update_token: self.policy_update_token,
                security_service_policy_data: self.security_service_policy_data,
                resource_type: self.resource_type,
                resource_type_list: self.resource_type_list,
                resource_tags: self.resource_tags,
                exclude_resource_tags: self.exclude_resource_tags.unwrap_or_default(),
                remediation_enabled: self.remediation_enabled.unwrap_or_default(),
                delete_unused_fm_managed_resources: self
                    .delete_unused_fm_managed_resources
                    .unwrap_or_default(),
                include_map: self.include_map,
                exclude_map: self.exclude_map,
            }
        }
    }
}
impl Policy {
    /// Creates a new builder-style object to manufacture [`Policy`](crate::model::Policy)
    pub fn builder() -> crate::model::policy::Builder {
        crate::model::policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomerPolicyScopeIdType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    OrgUnit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomerPolicyScopeIdType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => CustomerPolicyScopeIdType::Account,
            "ORG_UNIT" => CustomerPolicyScopeIdType::OrgUnit,
            other => CustomerPolicyScopeIdType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomerPolicyScopeIdType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomerPolicyScopeIdType::from(s))
    }
}
impl CustomerPolicyScopeIdType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomerPolicyScopeIdType::Account => "ACCOUNT",
            CustomerPolicyScopeIdType::OrgUnit => "ORG_UNIT",
            CustomerPolicyScopeIdType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT", "ORG_UNIT"]
    }
}
impl AsRef<str> for CustomerPolicyScopeIdType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The resource tags that Firewall Manager uses to determine if a particular resource should be included or excluded from the Firewall Manager policy. Tags enable you to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value. Firewall Manager combines the tags with "AND" so that, if you add more than one tag to a policy scope, a resource must have all the specified tags to be included or excluded. For more information, see <a href="https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html">Working with Tag Editor</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTag {
    /// <p>The resource tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The resource tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ResourceTag {
    /// <p>The resource tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The resource tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ResourceTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ResourceTag`](crate::model::ResourceTag)
pub mod resource_tag {
    /// A builder for [`ResourceTag`](crate::model::ResourceTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The resource tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The resource tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The resource tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTag`](crate::model::ResourceTag)
        pub fn build(self) -> crate::model::ResourceTag {
            crate::model::ResourceTag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ResourceTag {
    /// Creates a new builder-style object to manufacture [`ResourceTag`](crate::model::ResourceTag)
    pub fn builder() -> crate::model::resource_tag::Builder {
        crate::model::resource_tag::Builder::default()
    }
}

/// <p>Details about the security service that is being used to protect the resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityServicePolicyData {
    /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting Amazon Web Services Support.</p>
    pub r#type: std::option::Option<crate::model::SecurityServiceType>,
    /// <p>Details about the service that are specific to the service type, in JSON format. </p>
    /// <ul>
    /// <li> <p>Example: <code>DNS_FIREWALL</code> </p> <p> <code>"{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"</code> </p> <note>
    /// <p>Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.</p>
    /// </note> </li>
    /// <li> <p>Example: <code>NETWORK_FIREWALL</code> </p> <p> <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateless-rulegroup/rulegroup2\",\"priority\":10}],\"networkFirewallStatelessDefaultActions\":[\"aws:pass\",\"custom1\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"custom2\",\"aws:pass\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"custom1\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension1\"}]}}},{\"actionName\":\"custom2\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension2\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateful-rulegroup/rulegroup1\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":true,\"allowedIPV4CidrList\":[\"10.24.34.0/28\"]} }"</code> </p> </li>
    /// <li> <p>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions </p> <p> <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code> </p> <p>For example: <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code> </p> <p>The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code>. The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code>. The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code>.</p> <p>For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.</p> </li>
    /// <li> <p>Example: <code>WAFV2</code> </p> <p> <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code> </p> <p>In the <code>loggingConfiguration</code>, you can specify one <code>logDestinationConfigs</code>, you can optionally provide up to 20 <code>redactedFields</code>, and the <code>RedactedFieldType</code> must be one of <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p> </li>
    /// <li> <p>Example: <code>WAF Classic</code> </p> <p> <code>"{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"</code> </p> </li>
    /// <li> <p>Example: <code>SECURITY_GROUPS_COMMON</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
    /// <li> <p>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
    /// <li> <p>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"</code> </p> <p>The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code>. For <code>ALLOW</code>, all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code>, all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.</p> </li>
    /// <li> <p>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"</code> </p> </li>
    /// </ul>
    pub managed_service_data: std::option::Option<std::string::String>,
}
impl SecurityServicePolicyData {
    /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting Amazon Web Services Support.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SecurityServiceType> {
        self.r#type.as_ref()
    }
    /// <p>Details about the service that are specific to the service type, in JSON format. </p>
    /// <ul>
    /// <li> <p>Example: <code>DNS_FIREWALL</code> </p> <p> <code>"{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"</code> </p> <note>
    /// <p>Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.</p>
    /// </note> </li>
    /// <li> <p>Example: <code>NETWORK_FIREWALL</code> </p> <p> <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateless-rulegroup/rulegroup2\",\"priority\":10}],\"networkFirewallStatelessDefaultActions\":[\"aws:pass\",\"custom1\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"custom2\",\"aws:pass\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"custom1\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension1\"}]}}},{\"actionName\":\"custom2\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension2\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateful-rulegroup/rulegroup1\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":true,\"allowedIPV4CidrList\":[\"10.24.34.0/28\"]} }"</code> </p> </li>
    /// <li> <p>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions </p> <p> <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code> </p> <p>For example: <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code> </p> <p>The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code>. The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code>. The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code>.</p> <p>For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.</p> </li>
    /// <li> <p>Example: <code>WAFV2</code> </p> <p> <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code> </p> <p>In the <code>loggingConfiguration</code>, you can specify one <code>logDestinationConfigs</code>, you can optionally provide up to 20 <code>redactedFields</code>, and the <code>RedactedFieldType</code> must be one of <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p> </li>
    /// <li> <p>Example: <code>WAF Classic</code> </p> <p> <code>"{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"</code> </p> </li>
    /// <li> <p>Example: <code>SECURITY_GROUPS_COMMON</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
    /// <li> <p>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
    /// <li> <p>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"</code> </p> <p>The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code>. For <code>ALLOW</code>, all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code>, all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.</p> </li>
    /// <li> <p>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"</code> </p> </li>
    /// </ul>
    pub fn managed_service_data(&self) -> std::option::Option<&str> {
        self.managed_service_data.as_deref()
    }
}
impl std::fmt::Debug for SecurityServicePolicyData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityServicePolicyData");
        formatter.field("r#type", &self.r#type);
        formatter.field("managed_service_data", &self.managed_service_data);
        formatter.finish()
    }
}
/// See [`SecurityServicePolicyData`](crate::model::SecurityServicePolicyData)
pub mod security_service_policy_data {
    /// A builder for [`SecurityServicePolicyData`](crate::model::SecurityServicePolicyData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SecurityServiceType>,
        pub(crate) managed_service_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting Amazon Web Services Support.</p>
        pub fn r#type(mut self, input: crate::model::SecurityServiceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting Amazon Web Services Support.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::SecurityServiceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Details about the service that are specific to the service type, in JSON format. </p>
        /// <ul>
        /// <li> <p>Example: <code>DNS_FIREWALL</code> </p> <p> <code>"{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"</code> </p> <note>
        /// <p>Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.</p>
        /// </note> </li>
        /// <li> <p>Example: <code>NETWORK_FIREWALL</code> </p> <p> <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateless-rulegroup/rulegroup2\",\"priority\":10}],\"networkFirewallStatelessDefaultActions\":[\"aws:pass\",\"custom1\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"custom2\",\"aws:pass\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"custom1\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension1\"}]}}},{\"actionName\":\"custom2\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension2\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateful-rulegroup/rulegroup1\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":true,\"allowedIPV4CidrList\":[\"10.24.34.0/28\"]} }"</code> </p> </li>
        /// <li> <p>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions </p> <p> <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code> </p> <p>For example: <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code> </p> <p>The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code>. The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code>. The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code>.</p> <p>For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.</p> </li>
        /// <li> <p>Example: <code>WAFV2</code> </p> <p> <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code> </p> <p>In the <code>loggingConfiguration</code>, you can specify one <code>logDestinationConfigs</code>, you can optionally provide up to 20 <code>redactedFields</code>, and the <code>RedactedFieldType</code> must be one of <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p> </li>
        /// <li> <p>Example: <code>WAF Classic</code> </p> <p> <code>"{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"</code> </p> </li>
        /// <li> <p>Example: <code>SECURITY_GROUPS_COMMON</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
        /// <li> <p>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
        /// <li> <p>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"</code> </p> <p>The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code>. For <code>ALLOW</code>, all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code>, all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.</p> </li>
        /// <li> <p>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"</code> </p> </li>
        /// </ul>
        pub fn managed_service_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_service_data = Some(input.into());
            self
        }
        /// <p>Details about the service that are specific to the service type, in JSON format. </p>
        /// <ul>
        /// <li> <p>Example: <code>DNS_FIREWALL</code> </p> <p> <code>"{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"</code> </p> <note>
        /// <p>Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.</p>
        /// </note> </li>
        /// <li> <p>Example: <code>NETWORK_FIREWALL</code> </p> <p> <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateless-rulegroup/rulegroup2\",\"priority\":10}],\"networkFirewallStatelessDefaultActions\":[\"aws:pass\",\"custom1\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"custom2\",\"aws:pass\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"custom1\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension1\"}]}}},{\"actionName\":\"custom2\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"dimension2\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-1:1234567891011:stateful-rulegroup/rulegroup1\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":true,\"allowedIPV4CidrList\":[\"10.24.34.0/28\"]} }"</code> </p> </li>
        /// <li> <p>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions </p> <p> <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code> </p> <p>For example: <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code> </p> <p>The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code>. The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code>. The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code>.</p> <p>For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.</p> </li>
        /// <li> <p>Example: <code>WAFV2</code> </p> <p> <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code> </p> <p>In the <code>loggingConfiguration</code>, you can specify one <code>logDestinationConfigs</code>, you can optionally provide up to 20 <code>redactedFields</code>, and the <code>RedactedFieldType</code> must be one of <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p> </li>
        /// <li> <p>Example: <code>WAF Classic</code> </p> <p> <code>"{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"</code> </p> </li>
        /// <li> <p>Example: <code>SECURITY_GROUPS_COMMON</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
        /// <li> <p>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code> </p> </li>
        /// <li> <p>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"</code> </p> <p>The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code>. For <code>ALLOW</code>, all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code>, all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.</p> </li>
        /// <li> <p>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code> </p> <p> <code>"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"</code> </p> </li>
        /// </ul>
        pub fn set_managed_service_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_service_data = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityServicePolicyData`](crate::model::SecurityServicePolicyData)
        pub fn build(self) -> crate::model::SecurityServicePolicyData {
            crate::model::SecurityServicePolicyData {
                r#type: self.r#type,
                managed_service_data: self.managed_service_data,
            }
        }
    }
}
impl SecurityServicePolicyData {
    /// Creates a new builder-style object to manufacture [`SecurityServicePolicyData`](crate::model::SecurityServicePolicyData)
    pub fn builder() -> crate::model::security_service_policy_data::Builder {
        crate::model::security_service_policy_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SecurityServiceType {
    #[allow(missing_docs)] // documentation missing in model
    DnsFirewall,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewall,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupsCommon,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupsContentAudit,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupsUsageAudit,
    #[allow(missing_docs)] // documentation missing in model
    ShieldAdvanced,
    #[allow(missing_docs)] // documentation missing in model
    Waf,
    #[allow(missing_docs)] // documentation missing in model
    Wafv2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SecurityServiceType {
    fn from(s: &str) -> Self {
        match s {
            "DNS_FIREWALL" => SecurityServiceType::DnsFirewall,
            "NETWORK_FIREWALL" => SecurityServiceType::NetworkFirewall,
            "SECURITY_GROUPS_COMMON" => SecurityServiceType::SecurityGroupsCommon,
            "SECURITY_GROUPS_CONTENT_AUDIT" => SecurityServiceType::SecurityGroupsContentAudit,
            "SECURITY_GROUPS_USAGE_AUDIT" => SecurityServiceType::SecurityGroupsUsageAudit,
            "SHIELD_ADVANCED" => SecurityServiceType::ShieldAdvanced,
            "WAF" => SecurityServiceType::Waf,
            "WAFV2" => SecurityServiceType::Wafv2,
            other => SecurityServiceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SecurityServiceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SecurityServiceType::from(s))
    }
}
impl SecurityServiceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SecurityServiceType::DnsFirewall => "DNS_FIREWALL",
            SecurityServiceType::NetworkFirewall => "NETWORK_FIREWALL",
            SecurityServiceType::SecurityGroupsCommon => "SECURITY_GROUPS_COMMON",
            SecurityServiceType::SecurityGroupsContentAudit => "SECURITY_GROUPS_CONTENT_AUDIT",
            SecurityServiceType::SecurityGroupsUsageAudit => "SECURITY_GROUPS_USAGE_AUDIT",
            SecurityServiceType::ShieldAdvanced => "SHIELD_ADVANCED",
            SecurityServiceType::Waf => "WAF",
            SecurityServiceType::Wafv2 => "WAFV2",
            SecurityServiceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DNS_FIREWALL",
            "NETWORK_FIREWALL",
            "SECURITY_GROUPS_COMMON",
            "SECURITY_GROUPS_CONTENT_AUDIT",
            "SECURITY_GROUPS_USAGE_AUDIT",
            "SHIELD_ADVANCED",
            "WAF",
            "WAFV2",
        ]
    }
}
impl AsRef<str> for SecurityServiceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An Firewall Manager applications list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppsListData {
    /// <p>The ID of the Firewall Manager applications list.</p>
    pub list_id: std::option::Option<std::string::String>,
    /// <p>The name of the Firewall Manager applications list.</p>
    pub list_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
    pub list_update_token: std::option::Option<std::string::String>,
    /// <p>The time that the Firewall Manager applications list was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the Firewall Manager applications list was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An array of applications in the Firewall Manager applications list.</p>
    pub apps_list: std::option::Option<std::vec::Vec<crate::model::App>>,
    /// <p>A map of previous version numbers to their corresponding <code>App</code> object arrays.</p>
    pub previous_apps_list: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::App>>,
    >,
}
impl AppsListData {
    /// <p>The ID of the Firewall Manager applications list.</p>
    pub fn list_id(&self) -> std::option::Option<&str> {
        self.list_id.as_deref()
    }
    /// <p>The name of the Firewall Manager applications list.</p>
    pub fn list_name(&self) -> std::option::Option<&str> {
        self.list_name.as_deref()
    }
    /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
    pub fn list_update_token(&self) -> std::option::Option<&str> {
        self.list_update_token.as_deref()
    }
    /// <p>The time that the Firewall Manager applications list was created.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The time that the Firewall Manager applications list was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>An array of applications in the Firewall Manager applications list.</p>
    pub fn apps_list(&self) -> std::option::Option<&[crate::model::App]> {
        self.apps_list.as_deref()
    }
    /// <p>A map of previous version numbers to their corresponding <code>App</code> object arrays.</p>
    pub fn previous_apps_list(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::App>>,
    > {
        self.previous_apps_list.as_ref()
    }
}
impl std::fmt::Debug for AppsListData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppsListData");
        formatter.field("list_id", &self.list_id);
        formatter.field("list_name", &self.list_name);
        formatter.field("list_update_token", &self.list_update_token);
        formatter.field("create_time", &self.create_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("apps_list", &self.apps_list);
        formatter.field("previous_apps_list", &self.previous_apps_list);
        formatter.finish()
    }
}
/// See [`AppsListData`](crate::model::AppsListData)
pub mod apps_list_data {
    /// A builder for [`AppsListData`](crate::model::AppsListData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) list_id: std::option::Option<std::string::String>,
        pub(crate) list_name: std::option::Option<std::string::String>,
        pub(crate) list_update_token: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) apps_list: std::option::Option<std::vec::Vec<crate::model::App>>,
        pub(crate) previous_apps_list: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::App>>,
        >,
    }
    impl Builder {
        /// <p>The ID of the Firewall Manager applications list.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_id = Some(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager applications list.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_id = input;
            self
        }
        /// <p>The name of the Firewall Manager applications list.</p>
        pub fn list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_name = Some(input.into());
            self
        }
        /// <p>The name of the Firewall Manager applications list.</p>
        pub fn set_list_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_name = input;
            self
        }
        /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
        pub fn list_update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_update_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>
        pub fn set_list_update_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.list_update_token = input;
            self
        }
        /// <p>The time that the Firewall Manager applications list was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time that the Firewall Manager applications list was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The time that the Firewall Manager applications list was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time that the Firewall Manager applications list was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Appends an item to `apps_list`.
        ///
        /// To override the contents of this collection use [`set_apps_list`](Self::set_apps_list).
        ///
        /// <p>An array of applications in the Firewall Manager applications list.</p>
        pub fn apps_list(mut self, input: crate::model::App) -> Self {
            let mut v = self.apps_list.unwrap_or_default();
            v.push(input);
            self.apps_list = Some(v);
            self
        }
        /// <p>An array of applications in the Firewall Manager applications list.</p>
        pub fn set_apps_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::App>>,
        ) -> Self {
            self.apps_list = input;
            self
        }
        /// Adds a key-value pair to `previous_apps_list`.
        ///
        /// To override the contents of this collection use [`set_previous_apps_list`](Self::set_previous_apps_list).
        ///
        /// <p>A map of previous version numbers to their corresponding <code>App</code> object arrays.</p>
        pub fn previous_apps_list(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<crate::model::App>,
        ) -> Self {
            let mut hash_map = self.previous_apps_list.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.previous_apps_list = Some(hash_map);
            self
        }
        /// <p>A map of previous version numbers to their corresponding <code>App</code> object arrays.</p>
        pub fn set_previous_apps_list(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::App>>,
            >,
        ) -> Self {
            self.previous_apps_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AppsListData`](crate::model::AppsListData)
        pub fn build(self) -> crate::model::AppsListData {
            crate::model::AppsListData {
                list_id: self.list_id,
                list_name: self.list_name,
                list_update_token: self.list_update_token,
                create_time: self.create_time,
                last_update_time: self.last_update_time,
                apps_list: self.apps_list,
                previous_apps_list: self.previous_apps_list,
            }
        }
    }
}
impl AppsListData {
    /// Creates a new builder-style object to manufacture [`AppsListData`](crate::model::AppsListData)
    pub fn builder() -> crate::model::apps_list_data::Builder {
        crate::model::apps_list_data::Builder::default()
    }
}

/// <p>An individual Firewall Manager application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct App {
    /// <p>The application's name.</p>
    pub app_name: std::option::Option<std::string::String>,
    /// <p>The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or <code>icmp</code>. For information on possible numbers, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The application's port number, for example <code>80</code>.</p>
    pub port: std::option::Option<i64>,
}
impl App {
    /// <p>The application's name.</p>
    pub fn app_name(&self) -> std::option::Option<&str> {
        self.app_name.as_deref()
    }
    /// <p>The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or <code>icmp</code>. For information on possible numbers, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.</p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
    /// <p>The application's port number, for example <code>80</code>.</p>
    pub fn port(&self) -> std::option::Option<i64> {
        self.port
    }
}
impl std::fmt::Debug for App {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("App");
        formatter.field("app_name", &self.app_name);
        formatter.field("protocol", &self.protocol);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`App`](crate::model::App)
pub mod app {
    /// A builder for [`App`](crate::model::App)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_name: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The application's name.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_name = Some(input.into());
            self
        }
        /// <p>The application's name.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_name = input;
            self
        }
        /// <p>The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or <code>icmp</code>. For information on possible numbers, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or <code>icmp</code>. For information on possible numbers, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The application's port number, for example <code>80</code>.</p>
        pub fn port(mut self, input: i64) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The application's port number, for example <code>80</code>.</p>
        pub fn set_port(mut self, input: std::option::Option<i64>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`App`](crate::model::App)
        pub fn build(self) -> crate::model::App {
            crate::model::App {
                app_name: self.app_name,
                protocol: self.protocol,
                port: self.port,
            }
        }
    }
}
impl App {
    /// Creates a new builder-style object to manufacture [`App`](crate::model::App)
    pub fn builder() -> crate::model::app::Builder {
        crate::model::app::Builder::default()
    }
}

/// <p>Details of the Firewall Manager protocols list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtocolsListDataSummary {
    /// <p>The Amazon Resource Name (ARN) of the specified protocols list.</p>
    pub list_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the specified protocols list.</p>
    pub list_id: std::option::Option<std::string::String>,
    /// <p>The name of the specified protocols list.</p>
    pub list_name: std::option::Option<std::string::String>,
    /// <p>An array of protocols in the Firewall Manager protocols list.</p>
    pub protocols_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ProtocolsListDataSummary {
    /// <p>The Amazon Resource Name (ARN) of the specified protocols list.</p>
    pub fn list_arn(&self) -> std::option::Option<&str> {
        self.list_arn.as_deref()
    }
    /// <p>The ID of the specified protocols list.</p>
    pub fn list_id(&self) -> std::option::Option<&str> {
        self.list_id.as_deref()
    }
    /// <p>The name of the specified protocols list.</p>
    pub fn list_name(&self) -> std::option::Option<&str> {
        self.list_name.as_deref()
    }
    /// <p>An array of protocols in the Firewall Manager protocols list.</p>
    pub fn protocols_list(&self) -> std::option::Option<&[std::string::String]> {
        self.protocols_list.as_deref()
    }
}
impl std::fmt::Debug for ProtocolsListDataSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtocolsListDataSummary");
        formatter.field("list_arn", &self.list_arn);
        formatter.field("list_id", &self.list_id);
        formatter.field("list_name", &self.list_name);
        formatter.field("protocols_list", &self.protocols_list);
        formatter.finish()
    }
}
/// See [`ProtocolsListDataSummary`](crate::model::ProtocolsListDataSummary)
pub mod protocols_list_data_summary {
    /// A builder for [`ProtocolsListDataSummary`](crate::model::ProtocolsListDataSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) list_arn: std::option::Option<std::string::String>,
        pub(crate) list_id: std::option::Option<std::string::String>,
        pub(crate) list_name: std::option::Option<std::string::String>,
        pub(crate) protocols_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the specified protocols list.</p>
        pub fn list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the specified protocols list.</p>
        pub fn set_list_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_arn = input;
            self
        }
        /// <p>The ID of the specified protocols list.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_id = Some(input.into());
            self
        }
        /// <p>The ID of the specified protocols list.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_id = input;
            self
        }
        /// <p>The name of the specified protocols list.</p>
        pub fn list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_name = Some(input.into());
            self
        }
        /// <p>The name of the specified protocols list.</p>
        pub fn set_list_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_name = input;
            self
        }
        /// Appends an item to `protocols_list`.
        ///
        /// To override the contents of this collection use [`set_protocols_list`](Self::set_protocols_list).
        ///
        /// <p>An array of protocols in the Firewall Manager protocols list.</p>
        pub fn protocols_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.protocols_list.unwrap_or_default();
            v.push(input.into());
            self.protocols_list = Some(v);
            self
        }
        /// <p>An array of protocols in the Firewall Manager protocols list.</p>
        pub fn set_protocols_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.protocols_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtocolsListDataSummary`](crate::model::ProtocolsListDataSummary)
        pub fn build(self) -> crate::model::ProtocolsListDataSummary {
            crate::model::ProtocolsListDataSummary {
                list_arn: self.list_arn,
                list_id: self.list_id,
                list_name: self.list_name,
                protocols_list: self.protocols_list,
            }
        }
    }
}
impl ProtocolsListDataSummary {
    /// Creates a new builder-style object to manufacture [`ProtocolsListDataSummary`](crate::model::ProtocolsListDataSummary)
    pub fn builder() -> crate::model::protocols_list_data_summary::Builder {
        crate::model::protocols_list_data_summary::Builder::default()
    }
}

/// <p>Details of the Firewall Manager policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicySummary {
    /// <p>The Amazon Resource Name (ARN) of the specified policy.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the specified policy.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The name of the specified policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy.</p>
    pub security_service_type: std::option::Option<crate::model::SecurityServiceType>,
    /// <p>Indicates if the policy should be automatically applied to new resources.</p>
    pub remediation_enabled: bool,
    /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
    /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
    /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
    pub delete_unused_fm_managed_resources: bool,
}
impl PolicySummary {
    /// <p>The Amazon Resource Name (ARN) of the specified policy.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The ID of the specified policy.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The name of the specified policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy.</p>
    pub fn security_service_type(&self) -> std::option::Option<&crate::model::SecurityServiceType> {
        self.security_service_type.as_ref()
    }
    /// <p>Indicates if the policy should be automatically applied to new resources.</p>
    pub fn remediation_enabled(&self) -> bool {
        self.remediation_enabled
    }
    /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
    /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
    /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
    pub fn delete_unused_fm_managed_resources(&self) -> bool {
        self.delete_unused_fm_managed_resources
    }
}
impl std::fmt::Debug for PolicySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicySummary");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_id", &self.policy_id);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("security_service_type", &self.security_service_type);
        formatter.field("remediation_enabled", &self.remediation_enabled);
        formatter.field(
            "delete_unused_fm_managed_resources",
            &self.delete_unused_fm_managed_resources,
        );
        formatter.finish()
    }
}
/// See [`PolicySummary`](crate::model::PolicySummary)
pub mod policy_summary {
    /// A builder for [`PolicySummary`](crate::model::PolicySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) security_service_type: std::option::Option<crate::model::SecurityServiceType>,
        pub(crate) remediation_enabled: std::option::Option<bool>,
        pub(crate) delete_unused_fm_managed_resources: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the specified policy.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the specified policy.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The ID of the specified policy.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the specified policy.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The name of the specified policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the specified policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>. For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy.</p>
        pub fn security_service_type(mut self, input: crate::model::SecurityServiceType) -> Self {
            self.security_service_type = Some(input);
            self
        }
        /// <p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy.</p>
        pub fn set_security_service_type(
            mut self,
            input: std::option::Option<crate::model::SecurityServiceType>,
        ) -> Self {
            self.security_service_type = input;
            self
        }
        /// <p>Indicates if the policy should be automatically applied to new resources.</p>
        pub fn remediation_enabled(mut self, input: bool) -> Self {
            self.remediation_enabled = Some(input);
            self
        }
        /// <p>Indicates if the policy should be automatically applied to new resources.</p>
        pub fn set_remediation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remediation_enabled = input;
            self
        }
        /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
        /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
        /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
        pub fn delete_unused_fm_managed_resources(mut self, input: bool) -> Self {
            self.delete_unused_fm_managed_resources = Some(input);
            self
        }
        /// <p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p>
        /// <p>By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources. </p>
        /// <p>This option is not available for Shield Advanced or WAF Classic policies.</p>
        pub fn set_delete_unused_fm_managed_resources(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.delete_unused_fm_managed_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicySummary`](crate::model::PolicySummary)
        pub fn build(self) -> crate::model::PolicySummary {
            crate::model::PolicySummary {
                policy_arn: self.policy_arn,
                policy_id: self.policy_id,
                policy_name: self.policy_name,
                resource_type: self.resource_type,
                security_service_type: self.security_service_type,
                remediation_enabled: self.remediation_enabled.unwrap_or_default(),
                delete_unused_fm_managed_resources: self
                    .delete_unused_fm_managed_resources
                    .unwrap_or_default(),
            }
        }
    }
}
impl PolicySummary {
    /// Creates a new builder-style object to manufacture [`PolicySummary`](crate::model::PolicySummary)
    pub fn builder() -> crate::model::policy_summary::Builder {
        crate::model::policy_summary::Builder::default()
    }
}

/// <p>Indicates whether the account is compliant with the specified policy. An account is considered noncompliant if it includes resources that are not protected by the policy, for WAF and Shield Advanced policies, or that are noncompliant with the policy, for security group policies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyComplianceStatus {
    /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
    pub policy_owner: std::option::Option<std::string::String>,
    /// <p>The ID of the Firewall Manager policy.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The name of the Firewall Manager policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The member account ID.</p>
    pub member_account: std::option::Option<std::string::String>,
    /// <p>An array of <code>EvaluationResult</code> objects.</p>
    pub evaluation_results: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
    /// <p>Timestamp of the last update to the <code>EvaluationResult</code> objects.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
    pub issue_info_map: std::option::Option<
        std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
    >,
}
impl PolicyComplianceStatus {
    /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
    pub fn policy_owner(&self) -> std::option::Option<&str> {
        self.policy_owner.as_deref()
    }
    /// <p>The ID of the Firewall Manager policy.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The name of the Firewall Manager policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The member account ID.</p>
    pub fn member_account(&self) -> std::option::Option<&str> {
        self.member_account.as_deref()
    }
    /// <p>An array of <code>EvaluationResult</code> objects.</p>
    pub fn evaluation_results(&self) -> std::option::Option<&[crate::model::EvaluationResult]> {
        self.evaluation_results.as_deref()
    }
    /// <p>Timestamp of the last update to the <code>EvaluationResult</code> objects.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
    pub fn issue_info_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
    > {
        self.issue_info_map.as_ref()
    }
}
impl std::fmt::Debug for PolicyComplianceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyComplianceStatus");
        formatter.field("policy_owner", &self.policy_owner);
        formatter.field("policy_id", &self.policy_id);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("member_account", &self.member_account);
        formatter.field("evaluation_results", &self.evaluation_results);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("issue_info_map", &self.issue_info_map);
        formatter.finish()
    }
}
/// See [`PolicyComplianceStatus`](crate::model::PolicyComplianceStatus)
pub mod policy_compliance_status {
    /// A builder for [`PolicyComplianceStatus`](crate::model::PolicyComplianceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_owner: std::option::Option<std::string::String>,
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) member_account: std::option::Option<std::string::String>,
        pub(crate) evaluation_results:
            std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) issue_info_map: std::option::Option<
            std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
        pub fn policy_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
        pub fn set_policy_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_owner = input;
            self
        }
        /// <p>The ID of the Firewall Manager policy.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager policy.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The name of the Firewall Manager policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the Firewall Manager policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The member account ID.</p>
        pub fn member_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_account = Some(input.into());
            self
        }
        /// <p>The member account ID.</p>
        pub fn set_member_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.member_account = input;
            self
        }
        /// Appends an item to `evaluation_results`.
        ///
        /// To override the contents of this collection use [`set_evaluation_results`](Self::set_evaluation_results).
        ///
        /// <p>An array of <code>EvaluationResult</code> objects.</p>
        pub fn evaluation_results(mut self, input: crate::model::EvaluationResult) -> Self {
            let mut v = self.evaluation_results.unwrap_or_default();
            v.push(input);
            self.evaluation_results = Some(v);
            self
        }
        /// <p>An array of <code>EvaluationResult</code> objects.</p>
        pub fn set_evaluation_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        ) -> Self {
            self.evaluation_results = input;
            self
        }
        /// <p>Timestamp of the last update to the <code>EvaluationResult</code> objects.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>Timestamp of the last update to the <code>EvaluationResult</code> objects.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Adds a key-value pair to `issue_info_map`.
        ///
        /// To override the contents of this collection use [`set_issue_info_map`](Self::set_issue_info_map).
        ///
        /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
        pub fn issue_info_map(
            mut self,
            k: crate::model::DependentServiceName,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.issue_info_map.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.issue_info_map = Some(hash_map);
            self
        }
        /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
        pub fn set_issue_info_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
            >,
        ) -> Self {
            self.issue_info_map = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyComplianceStatus`](crate::model::PolicyComplianceStatus)
        pub fn build(self) -> crate::model::PolicyComplianceStatus {
            crate::model::PolicyComplianceStatus {
                policy_owner: self.policy_owner,
                policy_id: self.policy_id,
                policy_name: self.policy_name,
                member_account: self.member_account,
                evaluation_results: self.evaluation_results,
                last_updated: self.last_updated,
                issue_info_map: self.issue_info_map,
            }
        }
    }
}
impl PolicyComplianceStatus {
    /// Creates a new builder-style object to manufacture [`PolicyComplianceStatus`](crate::model::PolicyComplianceStatus)
    pub fn builder() -> crate::model::policy_compliance_status::Builder {
        crate::model::policy_compliance_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DependentServiceName {
    #[allow(missing_docs)] // documentation missing in model
    AwsConfig,
    #[allow(missing_docs)] // documentation missing in model
    AwsShieldAdvanced,
    #[allow(missing_docs)] // documentation missing in model
    AwsVirtualPrivateCloud,
    #[allow(missing_docs)] // documentation missing in model
    Awswaf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DependentServiceName {
    fn from(s: &str) -> Self {
        match s {
            "AWSCONFIG" => DependentServiceName::AwsConfig,
            "AWSSHIELD_ADVANCED" => DependentServiceName::AwsShieldAdvanced,
            "AWSVPC" => DependentServiceName::AwsVirtualPrivateCloud,
            "AWSWAF" => DependentServiceName::Awswaf,
            other => DependentServiceName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DependentServiceName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DependentServiceName::from(s))
    }
}
impl DependentServiceName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DependentServiceName::AwsConfig => "AWSCONFIG",
            DependentServiceName::AwsShieldAdvanced => "AWSSHIELD_ADVANCED",
            DependentServiceName::AwsVirtualPrivateCloud => "AWSVPC",
            DependentServiceName::Awswaf => "AWSWAF",
            DependentServiceName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWSCONFIG", "AWSSHIELD_ADVANCED", "AWSVPC", "AWSWAF"]
    }
}
impl AsRef<str> for DependentServiceName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the compliance status for the account. An account is considered noncompliant if it includes resources that are not protected by the specified policy or that don't comply with the policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResult {
    /// <p>Describes an Amazon Web Services account's compliance with the Firewall Manager policy.</p>
    pub compliance_status: std::option::Option<crate::model::PolicyComplianceStatusType>,
    /// <p>The number of resources that are noncompliant with the specified policy. For WAF and Shield Advanced policies, a resource is considered noncompliant if it is not associated with the policy. For security group policies, a resource is considered noncompliant if it doesn't comply with the rules of the policy and remediation is disabled or not possible.</p>
    pub violator_count: i64,
    /// <p>Indicates that over 100 resources are noncompliant with the Firewall Manager policy.</p>
    pub evaluation_limit_exceeded: bool,
}
impl EvaluationResult {
    /// <p>Describes an Amazon Web Services account's compliance with the Firewall Manager policy.</p>
    pub fn compliance_status(
        &self,
    ) -> std::option::Option<&crate::model::PolicyComplianceStatusType> {
        self.compliance_status.as_ref()
    }
    /// <p>The number of resources that are noncompliant with the specified policy. For WAF and Shield Advanced policies, a resource is considered noncompliant if it is not associated with the policy. For security group policies, a resource is considered noncompliant if it doesn't comply with the rules of the policy and remediation is disabled or not possible.</p>
    pub fn violator_count(&self) -> i64 {
        self.violator_count
    }
    /// <p>Indicates that over 100 resources are noncompliant with the Firewall Manager policy.</p>
    pub fn evaluation_limit_exceeded(&self) -> bool {
        self.evaluation_limit_exceeded
    }
}
impl std::fmt::Debug for EvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResult");
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field("violator_count", &self.violator_count);
        formatter.field("evaluation_limit_exceeded", &self.evaluation_limit_exceeded);
        formatter.finish()
    }
}
/// See [`EvaluationResult`](crate::model::EvaluationResult)
pub mod evaluation_result {
    /// A builder for [`EvaluationResult`](crate::model::EvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_status: std::option::Option<crate::model::PolicyComplianceStatusType>,
        pub(crate) violator_count: std::option::Option<i64>,
        pub(crate) evaluation_limit_exceeded: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Describes an Amazon Web Services account's compliance with the Firewall Manager policy.</p>
        pub fn compliance_status(
            mut self,
            input: crate::model::PolicyComplianceStatusType,
        ) -> Self {
            self.compliance_status = Some(input);
            self
        }
        /// <p>Describes an Amazon Web Services account's compliance with the Firewall Manager policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::PolicyComplianceStatusType>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// <p>The number of resources that are noncompliant with the specified policy. For WAF and Shield Advanced policies, a resource is considered noncompliant if it is not associated with the policy. For security group policies, a resource is considered noncompliant if it doesn't comply with the rules of the policy and remediation is disabled or not possible.</p>
        pub fn violator_count(mut self, input: i64) -> Self {
            self.violator_count = Some(input);
            self
        }
        /// <p>The number of resources that are noncompliant with the specified policy. For WAF and Shield Advanced policies, a resource is considered noncompliant if it is not associated with the policy. For security group policies, a resource is considered noncompliant if it doesn't comply with the rules of the policy and remediation is disabled or not possible.</p>
        pub fn set_violator_count(mut self, input: std::option::Option<i64>) -> Self {
            self.violator_count = input;
            self
        }
        /// <p>Indicates that over 100 resources are noncompliant with the Firewall Manager policy.</p>
        pub fn evaluation_limit_exceeded(mut self, input: bool) -> Self {
            self.evaluation_limit_exceeded = Some(input);
            self
        }
        /// <p>Indicates that over 100 resources are noncompliant with the Firewall Manager policy.</p>
        pub fn set_evaluation_limit_exceeded(mut self, input: std::option::Option<bool>) -> Self {
            self.evaluation_limit_exceeded = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResult`](crate::model::EvaluationResult)
        pub fn build(self) -> crate::model::EvaluationResult {
            crate::model::EvaluationResult {
                compliance_status: self.compliance_status,
                violator_count: self.violator_count.unwrap_or_default(),
                evaluation_limit_exceeded: self.evaluation_limit_exceeded.unwrap_or_default(),
            }
        }
    }
}
impl EvaluationResult {
    /// Creates a new builder-style object to manufacture [`EvaluationResult`](crate::model::EvaluationResult)
    pub fn builder() -> crate::model::evaluation_result::Builder {
        crate::model::evaluation_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyComplianceStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Compliant,
    #[allow(missing_docs)] // documentation missing in model
    NonCompliant,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyComplianceStatusType {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANT" => PolicyComplianceStatusType::Compliant,
            "NON_COMPLIANT" => PolicyComplianceStatusType::NonCompliant,
            other => PolicyComplianceStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyComplianceStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyComplianceStatusType::from(s))
    }
}
impl PolicyComplianceStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyComplianceStatusType::Compliant => "COMPLIANT",
            PolicyComplianceStatusType::NonCompliant => "NON_COMPLIANT",
            PolicyComplianceStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANT", "NON_COMPLIANT"]
    }
}
impl AsRef<str> for PolicyComplianceStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of the Firewall Manager applications list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppsListDataSummary {
    /// <p>The Amazon Resource Name (ARN) of the applications list.</p>
    pub list_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the applications list.</p>
    pub list_id: std::option::Option<std::string::String>,
    /// <p>The name of the applications list.</p>
    pub list_name: std::option::Option<std::string::String>,
    /// <p>An array of <code>App</code> objects in the Firewall Manager applications list.</p>
    pub apps_list: std::option::Option<std::vec::Vec<crate::model::App>>,
}
impl AppsListDataSummary {
    /// <p>The Amazon Resource Name (ARN) of the applications list.</p>
    pub fn list_arn(&self) -> std::option::Option<&str> {
        self.list_arn.as_deref()
    }
    /// <p>The ID of the applications list.</p>
    pub fn list_id(&self) -> std::option::Option<&str> {
        self.list_id.as_deref()
    }
    /// <p>The name of the applications list.</p>
    pub fn list_name(&self) -> std::option::Option<&str> {
        self.list_name.as_deref()
    }
    /// <p>An array of <code>App</code> objects in the Firewall Manager applications list.</p>
    pub fn apps_list(&self) -> std::option::Option<&[crate::model::App]> {
        self.apps_list.as_deref()
    }
}
impl std::fmt::Debug for AppsListDataSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppsListDataSummary");
        formatter.field("list_arn", &self.list_arn);
        formatter.field("list_id", &self.list_id);
        formatter.field("list_name", &self.list_name);
        formatter.field("apps_list", &self.apps_list);
        formatter.finish()
    }
}
/// See [`AppsListDataSummary`](crate::model::AppsListDataSummary)
pub mod apps_list_data_summary {
    /// A builder for [`AppsListDataSummary`](crate::model::AppsListDataSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) list_arn: std::option::Option<std::string::String>,
        pub(crate) list_id: std::option::Option<std::string::String>,
        pub(crate) list_name: std::option::Option<std::string::String>,
        pub(crate) apps_list: std::option::Option<std::vec::Vec<crate::model::App>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the applications list.</p>
        pub fn list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the applications list.</p>
        pub fn set_list_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_arn = input;
            self
        }
        /// <p>The ID of the applications list.</p>
        pub fn list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_id = Some(input.into());
            self
        }
        /// <p>The ID of the applications list.</p>
        pub fn set_list_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_id = input;
            self
        }
        /// <p>The name of the applications list.</p>
        pub fn list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.list_name = Some(input.into());
            self
        }
        /// <p>The name of the applications list.</p>
        pub fn set_list_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.list_name = input;
            self
        }
        /// Appends an item to `apps_list`.
        ///
        /// To override the contents of this collection use [`set_apps_list`](Self::set_apps_list).
        ///
        /// <p>An array of <code>App</code> objects in the Firewall Manager applications list.</p>
        pub fn apps_list(mut self, input: crate::model::App) -> Self {
            let mut v = self.apps_list.unwrap_or_default();
            v.push(input);
            self.apps_list = Some(v);
            self
        }
        /// <p>An array of <code>App</code> objects in the Firewall Manager applications list.</p>
        pub fn set_apps_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::App>>,
        ) -> Self {
            self.apps_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AppsListDataSummary`](crate::model::AppsListDataSummary)
        pub fn build(self) -> crate::model::AppsListDataSummary {
            crate::model::AppsListDataSummary {
                list_arn: self.list_arn,
                list_id: self.list_id,
                list_name: self.list_name,
                apps_list: self.apps_list,
            }
        }
    }
}
impl AppsListDataSummary {
    /// Creates a new builder-style object to manufacture [`AppsListDataSummary`](crate::model::AppsListDataSummary)
    pub fn builder() -> crate::model::apps_list_data_summary::Builder {
        crate::model::apps_list_data_summary::Builder::default()
    }
}

/// <p>Violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViolationDetail {
    /// <p>The ID of the Firewall Manager policy that the violation details were requested for.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account that the violation details were requested for.</p>
    pub member_account: std::option::Option<std::string::String>,
    /// <p>The resource ID that the violation details were requested for.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The resource type that the violation details were requested for.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>List of violations for the requested resource.</p>
    pub resource_violations: std::option::Option<std::vec::Vec<crate::model::ResourceViolation>>,
    /// <p>The <code>ResourceTag</code> objects associated with the resource.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Brief description for the requested resource.</p>
    pub resource_description: std::option::Option<std::string::String>,
}
impl ViolationDetail {
    /// <p>The ID of the Firewall Manager policy that the violation details were requested for.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The Amazon Web Services account that the violation details were requested for.</p>
    pub fn member_account(&self) -> std::option::Option<&str> {
        self.member_account.as_deref()
    }
    /// <p>The resource ID that the violation details were requested for.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The resource type that the violation details were requested for.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>List of violations for the requested resource.</p>
    pub fn resource_violations(&self) -> std::option::Option<&[crate::model::ResourceViolation]> {
        self.resource_violations.as_deref()
    }
    /// <p>The <code>ResourceTag</code> objects associated with the resource.</p>
    pub fn resource_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.resource_tags.as_deref()
    }
    /// <p>Brief description for the requested resource.</p>
    pub fn resource_description(&self) -> std::option::Option<&str> {
        self.resource_description.as_deref()
    }
}
impl std::fmt::Debug for ViolationDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViolationDetail");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("member_account", &self.member_account);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_violations", &self.resource_violations);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("resource_description", &self.resource_description);
        formatter.finish()
    }
}
/// See [`ViolationDetail`](crate::model::ViolationDetail)
pub mod violation_detail {
    /// A builder for [`ViolationDetail`](crate::model::ViolationDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) member_account: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_violations:
            std::option::Option<std::vec::Vec<crate::model::ResourceViolation>>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) resource_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Firewall Manager policy that the violation details were requested for.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager policy that the violation details were requested for.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The Amazon Web Services account that the violation details were requested for.</p>
        pub fn member_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that the violation details were requested for.</p>
        pub fn set_member_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.member_account = input;
            self
        }
        /// <p>The resource ID that the violation details were requested for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID that the violation details were requested for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The resource type that the violation details were requested for.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type that the violation details were requested for.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_violations`.
        ///
        /// To override the contents of this collection use [`set_resource_violations`](Self::set_resource_violations).
        ///
        /// <p>List of violations for the requested resource.</p>
        pub fn resource_violations(mut self, input: crate::model::ResourceViolation) -> Self {
            let mut v = self.resource_violations.unwrap_or_default();
            v.push(input);
            self.resource_violations = Some(v);
            self
        }
        /// <p>List of violations for the requested resource.</p>
        pub fn set_resource_violations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceViolation>>,
        ) -> Self {
            self.resource_violations = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The <code>ResourceTag</code> objects associated with the resource.</p>
        pub fn resource_tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input);
            self.resource_tags = Some(v);
            self
        }
        /// <p>The <code>ResourceTag</code> objects associated with the resource.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>Brief description for the requested resource.</p>
        pub fn resource_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_description = Some(input.into());
            self
        }
        /// <p>Brief description for the requested resource.</p>
        pub fn set_resource_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ViolationDetail`](crate::model::ViolationDetail)
        pub fn build(self) -> crate::model::ViolationDetail {
            crate::model::ViolationDetail {
                policy_id: self.policy_id,
                member_account: self.member_account,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                resource_violations: self.resource_violations,
                resource_tags: self.resource_tags,
                resource_description: self.resource_description,
            }
        }
    }
}
impl ViolationDetail {
    /// Creates a new builder-style object to manufacture [`ViolationDetail`](crate::model::ViolationDetail)
    pub fn builder() -> crate::model::violation_detail::Builder {
        crate::model::violation_detail::Builder::default()
    }
}

/// <p>Violation detail based on resource type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceViolation {
    /// <p>Violation detail for security groups.</p>
    pub aws_vpc_security_group_violation:
        std::option::Option<crate::model::AwsVpcSecurityGroupViolation>,
    /// <p>Violation detail for a network interface.</p>
    pub aws_ec2_network_interface_violation:
        std::option::Option<crate::model::AwsEc2NetworkInterfaceViolation>,
    /// <p>Violation detail for an EC2 instance.</p>
    pub aws_ec2_instance_violation: std::option::Option<crate::model::AwsEc2InstanceViolation>,
    /// <p>Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed firewall in its VPC. </p>
    pub network_firewall_missing_firewall_violation:
        std::option::Option<crate::model::NetworkFirewallMissingFirewallViolation>,
    /// <p>Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the expected Firewall Manager managed subnet.</p>
    pub network_firewall_missing_subnet_violation:
        std::option::Option<crate::model::NetworkFirewallMissingSubnetViolation>,
    /// <p>Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the expected Firewall Manager managed route table. </p>
    pub network_firewall_missing_expected_rt_violation:
        std::option::Option<crate::model::NetworkFirewallMissingExpectedRtViolation>,
    /// <p>Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual account has been modified in a way that makes it noncompliant. For example, the individual account owner might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default action.</p>
    pub network_firewall_policy_modified_violation:
        std::option::Option<crate::model::NetworkFirewallPolicyModifiedViolation>,
    /// <p>Violation detail for the subnet for which internet traffic hasn't been inspected.</p>
    pub network_firewall_internet_traffic_not_inspected_violation:
        std::option::Option<crate::model::NetworkFirewallInternetTrafficNotInspectedViolation>,
    /// <p>The route configuration is invalid.</p>
    pub network_firewall_invalid_route_configuration_violation:
        std::option::Option<crate::model::NetworkFirewallInvalidRouteConfigurationViolation>,
    /// <p>Violation detail for an internet gateway route with an inactive state in the customer subnet route table or Network Firewall subnet route table.</p>
    pub network_firewall_black_hole_route_detected_violation:
        std::option::Option<crate::model::NetworkFirewallBlackHoleRouteDetectedViolation>,
    /// <p>There's an unexpected firewall route.</p>
    pub network_firewall_unexpected_firewall_routes_violation:
        std::option::Option<crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation>,
    /// <p>There's an unexpected gateway route.</p>
    pub network_firewall_unexpected_gateway_routes_violation:
        std::option::Option<crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation>,
    /// <p>Expected routes are missing from Network Firewall.</p>
    pub network_firewall_missing_expected_routes_violation:
        std::option::Option<crate::model::NetworkFirewallMissingExpectedRoutesViolation>,
    /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that's already associated. </p>
    pub dns_rule_group_priority_conflict_violation:
        std::option::Option<crate::model::DnsRuleGroupPriorityConflictViolation>,
    /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and can't be associated again. </p>
    pub dns_duplicate_rule_group_violation:
        std::option::Option<crate::model::DnsDuplicateRuleGroupViolation>,
    /// <p>Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed. </p>
    pub dns_rule_group_limit_exceeded_violation:
        std::option::Option<crate::model::DnsRuleGroupLimitExceededViolation>,
    /// <p>A list of possible remediation action lists. Each individual possible remediation action is a list of individual remediation actions.</p>
    pub possible_remediation_actions: std::option::Option<crate::model::PossibleRemediationActions>,
}
impl ResourceViolation {
    /// <p>Violation detail for security groups.</p>
    pub fn aws_vpc_security_group_violation(
        &self,
    ) -> std::option::Option<&crate::model::AwsVpcSecurityGroupViolation> {
        self.aws_vpc_security_group_violation.as_ref()
    }
    /// <p>Violation detail for a network interface.</p>
    pub fn aws_ec2_network_interface_violation(
        &self,
    ) -> std::option::Option<&crate::model::AwsEc2NetworkInterfaceViolation> {
        self.aws_ec2_network_interface_violation.as_ref()
    }
    /// <p>Violation detail for an EC2 instance.</p>
    pub fn aws_ec2_instance_violation(
        &self,
    ) -> std::option::Option<&crate::model::AwsEc2InstanceViolation> {
        self.aws_ec2_instance_violation.as_ref()
    }
    /// <p>Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed firewall in its VPC. </p>
    pub fn network_firewall_missing_firewall_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallMissingFirewallViolation> {
        self.network_firewall_missing_firewall_violation.as_ref()
    }
    /// <p>Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the expected Firewall Manager managed subnet.</p>
    pub fn network_firewall_missing_subnet_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallMissingSubnetViolation> {
        self.network_firewall_missing_subnet_violation.as_ref()
    }
    /// <p>Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the expected Firewall Manager managed route table. </p>
    pub fn network_firewall_missing_expected_rt_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallMissingExpectedRtViolation> {
        self.network_firewall_missing_expected_rt_violation.as_ref()
    }
    /// <p>Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual account has been modified in a way that makes it noncompliant. For example, the individual account owner might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default action.</p>
    pub fn network_firewall_policy_modified_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallPolicyModifiedViolation> {
        self.network_firewall_policy_modified_violation.as_ref()
    }
    /// <p>Violation detail for the subnet for which internet traffic hasn't been inspected.</p>
    pub fn network_firewall_internet_traffic_not_inspected_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallInternetTrafficNotInspectedViolation>
    {
        self.network_firewall_internet_traffic_not_inspected_violation
            .as_ref()
    }
    /// <p>The route configuration is invalid.</p>
    pub fn network_firewall_invalid_route_configuration_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallInvalidRouteConfigurationViolation> {
        self.network_firewall_invalid_route_configuration_violation
            .as_ref()
    }
    /// <p>Violation detail for an internet gateway route with an inactive state in the customer subnet route table or Network Firewall subnet route table.</p>
    pub fn network_firewall_black_hole_route_detected_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallBlackHoleRouteDetectedViolation> {
        self.network_firewall_black_hole_route_detected_violation
            .as_ref()
    }
    /// <p>There's an unexpected firewall route.</p>
    pub fn network_firewall_unexpected_firewall_routes_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation> {
        self.network_firewall_unexpected_firewall_routes_violation
            .as_ref()
    }
    /// <p>There's an unexpected gateway route.</p>
    pub fn network_firewall_unexpected_gateway_routes_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation> {
        self.network_firewall_unexpected_gateway_routes_violation
            .as_ref()
    }
    /// <p>Expected routes are missing from Network Firewall.</p>
    pub fn network_firewall_missing_expected_routes_violation(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallMissingExpectedRoutesViolation> {
        self.network_firewall_missing_expected_routes_violation
            .as_ref()
    }
    /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that's already associated. </p>
    pub fn dns_rule_group_priority_conflict_violation(
        &self,
    ) -> std::option::Option<&crate::model::DnsRuleGroupPriorityConflictViolation> {
        self.dns_rule_group_priority_conflict_violation.as_ref()
    }
    /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and can't be associated again. </p>
    pub fn dns_duplicate_rule_group_violation(
        &self,
    ) -> std::option::Option<&crate::model::DnsDuplicateRuleGroupViolation> {
        self.dns_duplicate_rule_group_violation.as_ref()
    }
    /// <p>Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed. </p>
    pub fn dns_rule_group_limit_exceeded_violation(
        &self,
    ) -> std::option::Option<&crate::model::DnsRuleGroupLimitExceededViolation> {
        self.dns_rule_group_limit_exceeded_violation.as_ref()
    }
    /// <p>A list of possible remediation action lists. Each individual possible remediation action is a list of individual remediation actions.</p>
    pub fn possible_remediation_actions(
        &self,
    ) -> std::option::Option<&crate::model::PossibleRemediationActions> {
        self.possible_remediation_actions.as_ref()
    }
}
impl std::fmt::Debug for ResourceViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceViolation");
        formatter.field(
            "aws_vpc_security_group_violation",
            &self.aws_vpc_security_group_violation,
        );
        formatter.field(
            "aws_ec2_network_interface_violation",
            &self.aws_ec2_network_interface_violation,
        );
        formatter.field(
            "aws_ec2_instance_violation",
            &self.aws_ec2_instance_violation,
        );
        formatter.field(
            "network_firewall_missing_firewall_violation",
            &self.network_firewall_missing_firewall_violation,
        );
        formatter.field(
            "network_firewall_missing_subnet_violation",
            &self.network_firewall_missing_subnet_violation,
        );
        formatter.field(
            "network_firewall_missing_expected_rt_violation",
            &self.network_firewall_missing_expected_rt_violation,
        );
        formatter.field(
            "network_firewall_policy_modified_violation",
            &self.network_firewall_policy_modified_violation,
        );
        formatter.field(
            "network_firewall_internet_traffic_not_inspected_violation",
            &self.network_firewall_internet_traffic_not_inspected_violation,
        );
        formatter.field(
            "network_firewall_invalid_route_configuration_violation",
            &self.network_firewall_invalid_route_configuration_violation,
        );
        formatter.field(
            "network_firewall_black_hole_route_detected_violation",
            &self.network_firewall_black_hole_route_detected_violation,
        );
        formatter.field(
            "network_firewall_unexpected_firewall_routes_violation",
            &self.network_firewall_unexpected_firewall_routes_violation,
        );
        formatter.field(
            "network_firewall_unexpected_gateway_routes_violation",
            &self.network_firewall_unexpected_gateway_routes_violation,
        );
        formatter.field(
            "network_firewall_missing_expected_routes_violation",
            &self.network_firewall_missing_expected_routes_violation,
        );
        formatter.field(
            "dns_rule_group_priority_conflict_violation",
            &self.dns_rule_group_priority_conflict_violation,
        );
        formatter.field(
            "dns_duplicate_rule_group_violation",
            &self.dns_duplicate_rule_group_violation,
        );
        formatter.field(
            "dns_rule_group_limit_exceeded_violation",
            &self.dns_rule_group_limit_exceeded_violation,
        );
        formatter.field(
            "possible_remediation_actions",
            &self.possible_remediation_actions,
        );
        formatter.finish()
    }
}
/// See [`ResourceViolation`](crate::model::ResourceViolation)
pub mod resource_violation {
    /// A builder for [`ResourceViolation`](crate::model::ResourceViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_vpc_security_group_violation:
            std::option::Option<crate::model::AwsVpcSecurityGroupViolation>,
        pub(crate) aws_ec2_network_interface_violation:
            std::option::Option<crate::model::AwsEc2NetworkInterfaceViolation>,
        pub(crate) aws_ec2_instance_violation:
            std::option::Option<crate::model::AwsEc2InstanceViolation>,
        pub(crate) network_firewall_missing_firewall_violation:
            std::option::Option<crate::model::NetworkFirewallMissingFirewallViolation>,
        pub(crate) network_firewall_missing_subnet_violation:
            std::option::Option<crate::model::NetworkFirewallMissingSubnetViolation>,
        pub(crate) network_firewall_missing_expected_rt_violation:
            std::option::Option<crate::model::NetworkFirewallMissingExpectedRtViolation>,
        pub(crate) network_firewall_policy_modified_violation:
            std::option::Option<crate::model::NetworkFirewallPolicyModifiedViolation>,
        pub(crate) network_firewall_internet_traffic_not_inspected_violation:
            std::option::Option<crate::model::NetworkFirewallInternetTrafficNotInspectedViolation>,
        pub(crate) network_firewall_invalid_route_configuration_violation:
            std::option::Option<crate::model::NetworkFirewallInvalidRouteConfigurationViolation>,
        pub(crate) network_firewall_black_hole_route_detected_violation:
            std::option::Option<crate::model::NetworkFirewallBlackHoleRouteDetectedViolation>,
        pub(crate) network_firewall_unexpected_firewall_routes_violation:
            std::option::Option<crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation>,
        pub(crate) network_firewall_unexpected_gateway_routes_violation:
            std::option::Option<crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation>,
        pub(crate) network_firewall_missing_expected_routes_violation:
            std::option::Option<crate::model::NetworkFirewallMissingExpectedRoutesViolation>,
        pub(crate) dns_rule_group_priority_conflict_violation:
            std::option::Option<crate::model::DnsRuleGroupPriorityConflictViolation>,
        pub(crate) dns_duplicate_rule_group_violation:
            std::option::Option<crate::model::DnsDuplicateRuleGroupViolation>,
        pub(crate) dns_rule_group_limit_exceeded_violation:
            std::option::Option<crate::model::DnsRuleGroupLimitExceededViolation>,
        pub(crate) possible_remediation_actions:
            std::option::Option<crate::model::PossibleRemediationActions>,
    }
    impl Builder {
        /// <p>Violation detail for security groups.</p>
        pub fn aws_vpc_security_group_violation(
            mut self,
            input: crate::model::AwsVpcSecurityGroupViolation,
        ) -> Self {
            self.aws_vpc_security_group_violation = Some(input);
            self
        }
        /// <p>Violation detail for security groups.</p>
        pub fn set_aws_vpc_security_group_violation(
            mut self,
            input: std::option::Option<crate::model::AwsVpcSecurityGroupViolation>,
        ) -> Self {
            self.aws_vpc_security_group_violation = input;
            self
        }
        /// <p>Violation detail for a network interface.</p>
        pub fn aws_ec2_network_interface_violation(
            mut self,
            input: crate::model::AwsEc2NetworkInterfaceViolation,
        ) -> Self {
            self.aws_ec2_network_interface_violation = Some(input);
            self
        }
        /// <p>Violation detail for a network interface.</p>
        pub fn set_aws_ec2_network_interface_violation(
            mut self,
            input: std::option::Option<crate::model::AwsEc2NetworkInterfaceViolation>,
        ) -> Self {
            self.aws_ec2_network_interface_violation = input;
            self
        }
        /// <p>Violation detail for an EC2 instance.</p>
        pub fn aws_ec2_instance_violation(
            mut self,
            input: crate::model::AwsEc2InstanceViolation,
        ) -> Self {
            self.aws_ec2_instance_violation = Some(input);
            self
        }
        /// <p>Violation detail for an EC2 instance.</p>
        pub fn set_aws_ec2_instance_violation(
            mut self,
            input: std::option::Option<crate::model::AwsEc2InstanceViolation>,
        ) -> Self {
            self.aws_ec2_instance_violation = input;
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed firewall in its VPC. </p>
        pub fn network_firewall_missing_firewall_violation(
            mut self,
            input: crate::model::NetworkFirewallMissingFirewallViolation,
        ) -> Self {
            self.network_firewall_missing_firewall_violation = Some(input);
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed firewall in its VPC. </p>
        pub fn set_network_firewall_missing_firewall_violation(
            mut self,
            input: std::option::Option<crate::model::NetworkFirewallMissingFirewallViolation>,
        ) -> Self {
            self.network_firewall_missing_firewall_violation = input;
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the expected Firewall Manager managed subnet.</p>
        pub fn network_firewall_missing_subnet_violation(
            mut self,
            input: crate::model::NetworkFirewallMissingSubnetViolation,
        ) -> Self {
            self.network_firewall_missing_subnet_violation = Some(input);
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the expected Firewall Manager managed subnet.</p>
        pub fn set_network_firewall_missing_subnet_violation(
            mut self,
            input: std::option::Option<crate::model::NetworkFirewallMissingSubnetViolation>,
        ) -> Self {
            self.network_firewall_missing_subnet_violation = input;
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the expected Firewall Manager managed route table. </p>
        pub fn network_firewall_missing_expected_rt_violation(
            mut self,
            input: crate::model::NetworkFirewallMissingExpectedRtViolation,
        ) -> Self {
            self.network_firewall_missing_expected_rt_violation = Some(input);
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the expected Firewall Manager managed route table. </p>
        pub fn set_network_firewall_missing_expected_rt_violation(
            mut self,
            input: std::option::Option<crate::model::NetworkFirewallMissingExpectedRtViolation>,
        ) -> Self {
            self.network_firewall_missing_expected_rt_violation = input;
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual account has been modified in a way that makes it noncompliant. For example, the individual account owner might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default action.</p>
        pub fn network_firewall_policy_modified_violation(
            mut self,
            input: crate::model::NetworkFirewallPolicyModifiedViolation,
        ) -> Self {
            self.network_firewall_policy_modified_violation = Some(input);
            self
        }
        /// <p>Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual account has been modified in a way that makes it noncompliant. For example, the individual account owner might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default action.</p>
        pub fn set_network_firewall_policy_modified_violation(
            mut self,
            input: std::option::Option<crate::model::NetworkFirewallPolicyModifiedViolation>,
        ) -> Self {
            self.network_firewall_policy_modified_violation = input;
            self
        }
        /// <p>Violation detail for the subnet for which internet traffic hasn't been inspected.</p>
        pub fn network_firewall_internet_traffic_not_inspected_violation(
            mut self,
            input: crate::model::NetworkFirewallInternetTrafficNotInspectedViolation,
        ) -> Self {
            self.network_firewall_internet_traffic_not_inspected_violation = Some(input);
            self
        }
        /// <p>Violation detail for the subnet for which internet traffic hasn't been inspected.</p>
        pub fn set_network_firewall_internet_traffic_not_inspected_violation(
            mut self,
            input: std::option::Option<
                crate::model::NetworkFirewallInternetTrafficNotInspectedViolation,
            >,
        ) -> Self {
            self.network_firewall_internet_traffic_not_inspected_violation = input;
            self
        }
        /// <p>The route configuration is invalid.</p>
        pub fn network_firewall_invalid_route_configuration_violation(
            mut self,
            input: crate::model::NetworkFirewallInvalidRouteConfigurationViolation,
        ) -> Self {
            self.network_firewall_invalid_route_configuration_violation = Some(input);
            self
        }
        /// <p>The route configuration is invalid.</p>
        pub fn set_network_firewall_invalid_route_configuration_violation(
            mut self,
            input: std::option::Option<
                crate::model::NetworkFirewallInvalidRouteConfigurationViolation,
            >,
        ) -> Self {
            self.network_firewall_invalid_route_configuration_violation = input;
            self
        }
        /// <p>Violation detail for an internet gateway route with an inactive state in the customer subnet route table or Network Firewall subnet route table.</p>
        pub fn network_firewall_black_hole_route_detected_violation(
            mut self,
            input: crate::model::NetworkFirewallBlackHoleRouteDetectedViolation,
        ) -> Self {
            self.network_firewall_black_hole_route_detected_violation = Some(input);
            self
        }
        /// <p>Violation detail for an internet gateway route with an inactive state in the customer subnet route table or Network Firewall subnet route table.</p>
        pub fn set_network_firewall_black_hole_route_detected_violation(
            mut self,
            input: std::option::Option<
                crate::model::NetworkFirewallBlackHoleRouteDetectedViolation,
            >,
        ) -> Self {
            self.network_firewall_black_hole_route_detected_violation = input;
            self
        }
        /// <p>There's an unexpected firewall route.</p>
        pub fn network_firewall_unexpected_firewall_routes_violation(
            mut self,
            input: crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation,
        ) -> Self {
            self.network_firewall_unexpected_firewall_routes_violation = Some(input);
            self
        }
        /// <p>There's an unexpected firewall route.</p>
        pub fn set_network_firewall_unexpected_firewall_routes_violation(
            mut self,
            input: std::option::Option<
                crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation,
            >,
        ) -> Self {
            self.network_firewall_unexpected_firewall_routes_violation = input;
            self
        }
        /// <p>There's an unexpected gateway route.</p>
        pub fn network_firewall_unexpected_gateway_routes_violation(
            mut self,
            input: crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation,
        ) -> Self {
            self.network_firewall_unexpected_gateway_routes_violation = Some(input);
            self
        }
        /// <p>There's an unexpected gateway route.</p>
        pub fn set_network_firewall_unexpected_gateway_routes_violation(
            mut self,
            input: std::option::Option<
                crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation,
            >,
        ) -> Self {
            self.network_firewall_unexpected_gateway_routes_violation = input;
            self
        }
        /// <p>Expected routes are missing from Network Firewall.</p>
        pub fn network_firewall_missing_expected_routes_violation(
            mut self,
            input: crate::model::NetworkFirewallMissingExpectedRoutesViolation,
        ) -> Self {
            self.network_firewall_missing_expected_routes_violation = Some(input);
            self
        }
        /// <p>Expected routes are missing from Network Firewall.</p>
        pub fn set_network_firewall_missing_expected_routes_violation(
            mut self,
            input: std::option::Option<crate::model::NetworkFirewallMissingExpectedRoutesViolation>,
        ) -> Self {
            self.network_firewall_missing_expected_routes_violation = input;
            self
        }
        /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that's already associated. </p>
        pub fn dns_rule_group_priority_conflict_violation(
            mut self,
            input: crate::model::DnsRuleGroupPriorityConflictViolation,
        ) -> Self {
            self.dns_rule_group_priority_conflict_violation = Some(input);
            self
        }
        /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that's already associated. </p>
        pub fn set_dns_rule_group_priority_conflict_violation(
            mut self,
            input: std::option::Option<crate::model::DnsRuleGroupPriorityConflictViolation>,
        ) -> Self {
            self.dns_rule_group_priority_conflict_violation = input;
            self
        }
        /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and can't be associated again. </p>
        pub fn dns_duplicate_rule_group_violation(
            mut self,
            input: crate::model::DnsDuplicateRuleGroupViolation,
        ) -> Self {
            self.dns_duplicate_rule_group_violation = Some(input);
            self
        }
        /// <p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and can't be associated again. </p>
        pub fn set_dns_duplicate_rule_group_violation(
            mut self,
            input: std::option::Option<crate::model::DnsDuplicateRuleGroupViolation>,
        ) -> Self {
            self.dns_duplicate_rule_group_violation = input;
            self
        }
        /// <p>Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed. </p>
        pub fn dns_rule_group_limit_exceeded_violation(
            mut self,
            input: crate::model::DnsRuleGroupLimitExceededViolation,
        ) -> Self {
            self.dns_rule_group_limit_exceeded_violation = Some(input);
            self
        }
        /// <p>Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed. </p>
        pub fn set_dns_rule_group_limit_exceeded_violation(
            mut self,
            input: std::option::Option<crate::model::DnsRuleGroupLimitExceededViolation>,
        ) -> Self {
            self.dns_rule_group_limit_exceeded_violation = input;
            self
        }
        /// <p>A list of possible remediation action lists. Each individual possible remediation action is a list of individual remediation actions.</p>
        pub fn possible_remediation_actions(
            mut self,
            input: crate::model::PossibleRemediationActions,
        ) -> Self {
            self.possible_remediation_actions = Some(input);
            self
        }
        /// <p>A list of possible remediation action lists. Each individual possible remediation action is a list of individual remediation actions.</p>
        pub fn set_possible_remediation_actions(
            mut self,
            input: std::option::Option<crate::model::PossibleRemediationActions>,
        ) -> Self {
            self.possible_remediation_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceViolation`](crate::model::ResourceViolation)
        pub fn build(self) -> crate::model::ResourceViolation {
            crate::model::ResourceViolation {
                aws_vpc_security_group_violation: self.aws_vpc_security_group_violation,
                aws_ec2_network_interface_violation: self.aws_ec2_network_interface_violation,
                aws_ec2_instance_violation: self.aws_ec2_instance_violation,
                network_firewall_missing_firewall_violation: self
                    .network_firewall_missing_firewall_violation,
                network_firewall_missing_subnet_violation: self
                    .network_firewall_missing_subnet_violation,
                network_firewall_missing_expected_rt_violation: self
                    .network_firewall_missing_expected_rt_violation,
                network_firewall_policy_modified_violation: self
                    .network_firewall_policy_modified_violation,
                network_firewall_internet_traffic_not_inspected_violation: self
                    .network_firewall_internet_traffic_not_inspected_violation,
                network_firewall_invalid_route_configuration_violation: self
                    .network_firewall_invalid_route_configuration_violation,
                network_firewall_black_hole_route_detected_violation: self
                    .network_firewall_black_hole_route_detected_violation,
                network_firewall_unexpected_firewall_routes_violation: self
                    .network_firewall_unexpected_firewall_routes_violation,
                network_firewall_unexpected_gateway_routes_violation: self
                    .network_firewall_unexpected_gateway_routes_violation,
                network_firewall_missing_expected_routes_violation: self
                    .network_firewall_missing_expected_routes_violation,
                dns_rule_group_priority_conflict_violation: self
                    .dns_rule_group_priority_conflict_violation,
                dns_duplicate_rule_group_violation: self.dns_duplicate_rule_group_violation,
                dns_rule_group_limit_exceeded_violation: self
                    .dns_rule_group_limit_exceeded_violation,
                possible_remediation_actions: self.possible_remediation_actions,
            }
        }
    }
}
impl ResourceViolation {
    /// Creates a new builder-style object to manufacture [`ResourceViolation`](crate::model::ResourceViolation)
    pub fn builder() -> crate::model::resource_violation::Builder {
        crate::model::resource_violation::Builder::default()
    }
}

/// <p>A list of possible remediation action lists. Each individual possible remediation action is a list of individual remediation actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PossibleRemediationActions {
    /// <p>A description of the possible remediation actions list.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the actions.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::PossibleRemediationAction>>,
}
impl PossibleRemediationActions {
    /// <p>A description of the possible remediation actions list.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the actions.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::PossibleRemediationAction]> {
        self.actions.as_deref()
    }
}
impl std::fmt::Debug for PossibleRemediationActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PossibleRemediationActions");
        formatter.field("description", &self.description);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`PossibleRemediationActions`](crate::model::PossibleRemediationActions)
pub mod possible_remediation_actions {
    /// A builder for [`PossibleRemediationActions`](crate::model::PossibleRemediationActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) actions:
            std::option::Option<std::vec::Vec<crate::model::PossibleRemediationAction>>,
    }
    impl Builder {
        /// <p>A description of the possible remediation actions list.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the possible remediation actions list.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>Information about the actions.</p>
        pub fn actions(mut self, input: crate::model::PossibleRemediationAction) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>Information about the actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PossibleRemediationAction>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`PossibleRemediationActions`](crate::model::PossibleRemediationActions)
        pub fn build(self) -> crate::model::PossibleRemediationActions {
            crate::model::PossibleRemediationActions {
                description: self.description,
                actions: self.actions,
            }
        }
    }
}
impl PossibleRemediationActions {
    /// Creates a new builder-style object to manufacture [`PossibleRemediationActions`](crate::model::PossibleRemediationActions)
    pub fn builder() -> crate::model::possible_remediation_actions::Builder {
        crate::model::possible_remediation_actions::Builder::default()
    }
}

/// <p>A list of remediation actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PossibleRemediationAction {
    /// <p>A description of the list of remediation actions.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ordered list of remediation actions.</p>
    pub ordered_remediation_actions:
        std::option::Option<std::vec::Vec<crate::model::RemediationActionWithOrder>>,
    /// <p>Information about whether an action is taken by default.</p>
    pub is_default_action: bool,
}
impl PossibleRemediationAction {
    /// <p>A description of the list of remediation actions.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ordered list of remediation actions.</p>
    pub fn ordered_remediation_actions(
        &self,
    ) -> std::option::Option<&[crate::model::RemediationActionWithOrder]> {
        self.ordered_remediation_actions.as_deref()
    }
    /// <p>Information about whether an action is taken by default.</p>
    pub fn is_default_action(&self) -> bool {
        self.is_default_action
    }
}
impl std::fmt::Debug for PossibleRemediationAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PossibleRemediationAction");
        formatter.field("description", &self.description);
        formatter.field(
            "ordered_remediation_actions",
            &self.ordered_remediation_actions,
        );
        formatter.field("is_default_action", &self.is_default_action);
        formatter.finish()
    }
}
/// See [`PossibleRemediationAction`](crate::model::PossibleRemediationAction)
pub mod possible_remediation_action {
    /// A builder for [`PossibleRemediationAction`](crate::model::PossibleRemediationAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ordered_remediation_actions:
            std::option::Option<std::vec::Vec<crate::model::RemediationActionWithOrder>>,
        pub(crate) is_default_action: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A description of the list of remediation actions.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the list of remediation actions.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ordered_remediation_actions`.
        ///
        /// To override the contents of this collection use [`set_ordered_remediation_actions`](Self::set_ordered_remediation_actions).
        ///
        /// <p>The ordered list of remediation actions.</p>
        pub fn ordered_remediation_actions(
            mut self,
            input: crate::model::RemediationActionWithOrder,
        ) -> Self {
            let mut v = self.ordered_remediation_actions.unwrap_or_default();
            v.push(input);
            self.ordered_remediation_actions = Some(v);
            self
        }
        /// <p>The ordered list of remediation actions.</p>
        pub fn set_ordered_remediation_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemediationActionWithOrder>>,
        ) -> Self {
            self.ordered_remediation_actions = input;
            self
        }
        /// <p>Information about whether an action is taken by default.</p>
        pub fn is_default_action(mut self, input: bool) -> Self {
            self.is_default_action = Some(input);
            self
        }
        /// <p>Information about whether an action is taken by default.</p>
        pub fn set_is_default_action(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_action = input;
            self
        }
        /// Consumes the builder and constructs a [`PossibleRemediationAction`](crate::model::PossibleRemediationAction)
        pub fn build(self) -> crate::model::PossibleRemediationAction {
            crate::model::PossibleRemediationAction {
                description: self.description,
                ordered_remediation_actions: self.ordered_remediation_actions,
                is_default_action: self.is_default_action.unwrap_or_default(),
            }
        }
    }
}
impl PossibleRemediationAction {
    /// Creates a new builder-style object to manufacture [`PossibleRemediationAction`](crate::model::PossibleRemediationAction)
    pub fn builder() -> crate::model::possible_remediation_action::Builder {
        crate::model::possible_remediation_action::Builder::default()
    }
}

/// <p>An ordered list of actions you can take to remediate a violation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationActionWithOrder {
    /// <p>Information about an action you can take to remediate a violation.</p>
    pub remediation_action: std::option::Option<crate::model::RemediationAction>,
    /// <p>The order of the remediation actions in the list.</p>
    pub order: i32,
}
impl RemediationActionWithOrder {
    /// <p>Information about an action you can take to remediate a violation.</p>
    pub fn remediation_action(&self) -> std::option::Option<&crate::model::RemediationAction> {
        self.remediation_action.as_ref()
    }
    /// <p>The order of the remediation actions in the list.</p>
    pub fn order(&self) -> i32 {
        self.order
    }
}
impl std::fmt::Debug for RemediationActionWithOrder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationActionWithOrder");
        formatter.field("remediation_action", &self.remediation_action);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`RemediationActionWithOrder`](crate::model::RemediationActionWithOrder)
pub mod remediation_action_with_order {
    /// A builder for [`RemediationActionWithOrder`](crate::model::RemediationActionWithOrder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remediation_action: std::option::Option<crate::model::RemediationAction>,
        pub(crate) order: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Information about an action you can take to remediate a violation.</p>
        pub fn remediation_action(mut self, input: crate::model::RemediationAction) -> Self {
            self.remediation_action = Some(input);
            self
        }
        /// <p>Information about an action you can take to remediate a violation.</p>
        pub fn set_remediation_action(
            mut self,
            input: std::option::Option<crate::model::RemediationAction>,
        ) -> Self {
            self.remediation_action = input;
            self
        }
        /// <p>The order of the remediation actions in the list.</p>
        pub fn order(mut self, input: i32) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order of the remediation actions in the list.</p>
        pub fn set_order(mut self, input: std::option::Option<i32>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationActionWithOrder`](crate::model::RemediationActionWithOrder)
        pub fn build(self) -> crate::model::RemediationActionWithOrder {
            crate::model::RemediationActionWithOrder {
                remediation_action: self.remediation_action,
                order: self.order.unwrap_or_default(),
            }
        }
    }
}
impl RemediationActionWithOrder {
    /// Creates a new builder-style object to manufacture [`RemediationActionWithOrder`](crate::model::RemediationActionWithOrder)
    pub fn builder() -> crate::model::remediation_action_with_order::Builder {
        crate::model::remediation_action_with_order::Builder::default()
    }
}

/// <p>Information about an individual action you can take to remediate a violation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationAction {
    /// <p>A description of a remediation action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the CreateRoute action in the Amazon EC2 API.</p>
    pub ec2_create_route_action: std::option::Option<crate::model::Ec2CreateRouteAction>,
    /// <p>Information about the ReplaceRoute action in the Amazon EC2 API.</p>
    pub ec2_replace_route_action: std::option::Option<crate::model::Ec2ReplaceRouteAction>,
    /// <p>Information about the DeleteRoute action in the Amazon EC2 API.</p>
    pub ec2_delete_route_action: std::option::Option<crate::model::Ec2DeleteRouteAction>,
    /// <p>Information about the CopyRouteTable action in the Amazon EC2 API.</p>
    pub ec2_copy_route_table_action: std::option::Option<crate::model::Ec2CopyRouteTableAction>,
    /// <p>Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.</p>
    pub ec2_replace_route_table_association_action:
        std::option::Option<crate::model::Ec2ReplaceRouteTableAssociationAction>,
    /// <p>Information about the AssociateRouteTable action in the Amazon EC2 API.</p>
    pub ec2_associate_route_table_action:
        std::option::Option<crate::model::Ec2AssociateRouteTableAction>,
    /// <p>Information about the CreateRouteTable action in the Amazon EC2 API.</p>
    pub ec2_create_route_table_action: std::option::Option<crate::model::Ec2CreateRouteTableAction>,
}
impl RemediationAction {
    /// <p>A description of a remediation action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the CreateRoute action in the Amazon EC2 API.</p>
    pub fn ec2_create_route_action(
        &self,
    ) -> std::option::Option<&crate::model::Ec2CreateRouteAction> {
        self.ec2_create_route_action.as_ref()
    }
    /// <p>Information about the ReplaceRoute action in the Amazon EC2 API.</p>
    pub fn ec2_replace_route_action(
        &self,
    ) -> std::option::Option<&crate::model::Ec2ReplaceRouteAction> {
        self.ec2_replace_route_action.as_ref()
    }
    /// <p>Information about the DeleteRoute action in the Amazon EC2 API.</p>
    pub fn ec2_delete_route_action(
        &self,
    ) -> std::option::Option<&crate::model::Ec2DeleteRouteAction> {
        self.ec2_delete_route_action.as_ref()
    }
    /// <p>Information about the CopyRouteTable action in the Amazon EC2 API.</p>
    pub fn ec2_copy_route_table_action(
        &self,
    ) -> std::option::Option<&crate::model::Ec2CopyRouteTableAction> {
        self.ec2_copy_route_table_action.as_ref()
    }
    /// <p>Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.</p>
    pub fn ec2_replace_route_table_association_action(
        &self,
    ) -> std::option::Option<&crate::model::Ec2ReplaceRouteTableAssociationAction> {
        self.ec2_replace_route_table_association_action.as_ref()
    }
    /// <p>Information about the AssociateRouteTable action in the Amazon EC2 API.</p>
    pub fn ec2_associate_route_table_action(
        &self,
    ) -> std::option::Option<&crate::model::Ec2AssociateRouteTableAction> {
        self.ec2_associate_route_table_action.as_ref()
    }
    /// <p>Information about the CreateRouteTable action in the Amazon EC2 API.</p>
    pub fn ec2_create_route_table_action(
        &self,
    ) -> std::option::Option<&crate::model::Ec2CreateRouteTableAction> {
        self.ec2_create_route_table_action.as_ref()
    }
}
impl std::fmt::Debug for RemediationAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationAction");
        formatter.field("description", &self.description);
        formatter.field("ec2_create_route_action", &self.ec2_create_route_action);
        formatter.field("ec2_replace_route_action", &self.ec2_replace_route_action);
        formatter.field("ec2_delete_route_action", &self.ec2_delete_route_action);
        formatter.field(
            "ec2_copy_route_table_action",
            &self.ec2_copy_route_table_action,
        );
        formatter.field(
            "ec2_replace_route_table_association_action",
            &self.ec2_replace_route_table_association_action,
        );
        formatter.field(
            "ec2_associate_route_table_action",
            &self.ec2_associate_route_table_action,
        );
        formatter.field(
            "ec2_create_route_table_action",
            &self.ec2_create_route_table_action,
        );
        formatter.finish()
    }
}
/// See [`RemediationAction`](crate::model::RemediationAction)
pub mod remediation_action {
    /// A builder for [`RemediationAction`](crate::model::RemediationAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_create_route_action: std::option::Option<crate::model::Ec2CreateRouteAction>,
        pub(crate) ec2_replace_route_action:
            std::option::Option<crate::model::Ec2ReplaceRouteAction>,
        pub(crate) ec2_delete_route_action: std::option::Option<crate::model::Ec2DeleteRouteAction>,
        pub(crate) ec2_copy_route_table_action:
            std::option::Option<crate::model::Ec2CopyRouteTableAction>,
        pub(crate) ec2_replace_route_table_association_action:
            std::option::Option<crate::model::Ec2ReplaceRouteTableAssociationAction>,
        pub(crate) ec2_associate_route_table_action:
            std::option::Option<crate::model::Ec2AssociateRouteTableAction>,
        pub(crate) ec2_create_route_table_action:
            std::option::Option<crate::model::Ec2CreateRouteTableAction>,
    }
    impl Builder {
        /// <p>A description of a remediation action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of a remediation action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the CreateRoute action in the Amazon EC2 API.</p>
        pub fn ec2_create_route_action(
            mut self,
            input: crate::model::Ec2CreateRouteAction,
        ) -> Self {
            self.ec2_create_route_action = Some(input);
            self
        }
        /// <p>Information about the CreateRoute action in the Amazon EC2 API.</p>
        pub fn set_ec2_create_route_action(
            mut self,
            input: std::option::Option<crate::model::Ec2CreateRouteAction>,
        ) -> Self {
            self.ec2_create_route_action = input;
            self
        }
        /// <p>Information about the ReplaceRoute action in the Amazon EC2 API.</p>
        pub fn ec2_replace_route_action(
            mut self,
            input: crate::model::Ec2ReplaceRouteAction,
        ) -> Self {
            self.ec2_replace_route_action = Some(input);
            self
        }
        /// <p>Information about the ReplaceRoute action in the Amazon EC2 API.</p>
        pub fn set_ec2_replace_route_action(
            mut self,
            input: std::option::Option<crate::model::Ec2ReplaceRouteAction>,
        ) -> Self {
            self.ec2_replace_route_action = input;
            self
        }
        /// <p>Information about the DeleteRoute action in the Amazon EC2 API.</p>
        pub fn ec2_delete_route_action(
            mut self,
            input: crate::model::Ec2DeleteRouteAction,
        ) -> Self {
            self.ec2_delete_route_action = Some(input);
            self
        }
        /// <p>Information about the DeleteRoute action in the Amazon EC2 API.</p>
        pub fn set_ec2_delete_route_action(
            mut self,
            input: std::option::Option<crate::model::Ec2DeleteRouteAction>,
        ) -> Self {
            self.ec2_delete_route_action = input;
            self
        }
        /// <p>Information about the CopyRouteTable action in the Amazon EC2 API.</p>
        pub fn ec2_copy_route_table_action(
            mut self,
            input: crate::model::Ec2CopyRouteTableAction,
        ) -> Self {
            self.ec2_copy_route_table_action = Some(input);
            self
        }
        /// <p>Information about the CopyRouteTable action in the Amazon EC2 API.</p>
        pub fn set_ec2_copy_route_table_action(
            mut self,
            input: std::option::Option<crate::model::Ec2CopyRouteTableAction>,
        ) -> Self {
            self.ec2_copy_route_table_action = input;
            self
        }
        /// <p>Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.</p>
        pub fn ec2_replace_route_table_association_action(
            mut self,
            input: crate::model::Ec2ReplaceRouteTableAssociationAction,
        ) -> Self {
            self.ec2_replace_route_table_association_action = Some(input);
            self
        }
        /// <p>Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.</p>
        pub fn set_ec2_replace_route_table_association_action(
            mut self,
            input: std::option::Option<crate::model::Ec2ReplaceRouteTableAssociationAction>,
        ) -> Self {
            self.ec2_replace_route_table_association_action = input;
            self
        }
        /// <p>Information about the AssociateRouteTable action in the Amazon EC2 API.</p>
        pub fn ec2_associate_route_table_action(
            mut self,
            input: crate::model::Ec2AssociateRouteTableAction,
        ) -> Self {
            self.ec2_associate_route_table_action = Some(input);
            self
        }
        /// <p>Information about the AssociateRouteTable action in the Amazon EC2 API.</p>
        pub fn set_ec2_associate_route_table_action(
            mut self,
            input: std::option::Option<crate::model::Ec2AssociateRouteTableAction>,
        ) -> Self {
            self.ec2_associate_route_table_action = input;
            self
        }
        /// <p>Information about the CreateRouteTable action in the Amazon EC2 API.</p>
        pub fn ec2_create_route_table_action(
            mut self,
            input: crate::model::Ec2CreateRouteTableAction,
        ) -> Self {
            self.ec2_create_route_table_action = Some(input);
            self
        }
        /// <p>Information about the CreateRouteTable action in the Amazon EC2 API.</p>
        pub fn set_ec2_create_route_table_action(
            mut self,
            input: std::option::Option<crate::model::Ec2CreateRouteTableAction>,
        ) -> Self {
            self.ec2_create_route_table_action = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationAction`](crate::model::RemediationAction)
        pub fn build(self) -> crate::model::RemediationAction {
            crate::model::RemediationAction {
                description: self.description,
                ec2_create_route_action: self.ec2_create_route_action,
                ec2_replace_route_action: self.ec2_replace_route_action,
                ec2_delete_route_action: self.ec2_delete_route_action,
                ec2_copy_route_table_action: self.ec2_copy_route_table_action,
                ec2_replace_route_table_association_action: self
                    .ec2_replace_route_table_association_action,
                ec2_associate_route_table_action: self.ec2_associate_route_table_action,
                ec2_create_route_table_action: self.ec2_create_route_table_action,
            }
        }
    }
}
impl RemediationAction {
    /// Creates a new builder-style object to manufacture [`RemediationAction`](crate::model::RemediationAction)
    pub fn builder() -> crate::model::remediation_action::Builder {
        crate::model::remediation_action::Builder::default()
    }
}

/// <p>Information about the CreateRouteTable action in Amazon EC2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2CreateRouteTableAction {
    /// <p>A description of the CreateRouteTable action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the ID of a VPC.</p>
    pub vpc_id: std::option::Option<crate::model::ActionTarget>,
}
impl Ec2CreateRouteTableAction {
    /// <p>A description of the CreateRouteTable action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the ID of a VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.vpc_id.as_ref()
    }
}
impl std::fmt::Debug for Ec2CreateRouteTableAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2CreateRouteTableAction");
        formatter.field("description", &self.description);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`Ec2CreateRouteTableAction`](crate::model::Ec2CreateRouteTableAction)
pub mod ec2_create_route_table_action {
    /// A builder for [`Ec2CreateRouteTableAction`](crate::model::Ec2CreateRouteTableAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<crate::model::ActionTarget>,
    }
    impl Builder {
        /// <p>A description of the CreateRouteTable action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the CreateRouteTable action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the ID of a VPC.</p>
        pub fn vpc_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.vpc_id = Some(input);
            self
        }
        /// <p>Information about the ID of a VPC.</p>
        pub fn set_vpc_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2CreateRouteTableAction`](crate::model::Ec2CreateRouteTableAction)
        pub fn build(self) -> crate::model::Ec2CreateRouteTableAction {
            crate::model::Ec2CreateRouteTableAction {
                description: self.description,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl Ec2CreateRouteTableAction {
    /// Creates a new builder-style object to manufacture [`Ec2CreateRouteTableAction`](crate::model::Ec2CreateRouteTableAction)
    pub fn builder() -> crate::model::ec2_create_route_table_action::Builder {
        crate::model::ec2_create_route_table_action::Builder::default()
    }
}

/// <p>Describes a remediation action target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTarget {
    /// <p>The ID of the remediation target.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>A description of the remediation action target.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ActionTarget {
    /// <p>The ID of the remediation target.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>A description of the remediation action target.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ActionTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTarget");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ActionTarget`](crate::model::ActionTarget)
pub mod action_target {
    /// A builder for [`ActionTarget`](crate::model::ActionTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the remediation target.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the remediation target.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>A description of the remediation action target.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the remediation action target.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTarget`](crate::model::ActionTarget)
        pub fn build(self) -> crate::model::ActionTarget {
            crate::model::ActionTarget {
                resource_id: self.resource_id,
                description: self.description,
            }
        }
    }
}
impl ActionTarget {
    /// Creates a new builder-style object to manufacture [`ActionTarget`](crate::model::ActionTarget)
    pub fn builder() -> crate::model::action_target::Builder {
        crate::model::action_target::Builder::default()
    }
}

/// <p>The action of associating an EC2 resource, such as a subnet or internet gateway, with a route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2AssociateRouteTableAction {
    /// <p>A description of the EC2 route table that is associated with the remediation action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the EC2 route table that is associated with the remediation action.</p>
    pub route_table_id: std::option::Option<crate::model::ActionTarget>,
    /// <p>The ID of the subnet for the EC2 route table that is associated with the remediation action.</p>
    pub subnet_id: std::option::Option<crate::model::ActionTarget>,
    /// <p>The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.</p>
    pub gateway_id: std::option::Option<crate::model::ActionTarget>,
}
impl Ec2AssociateRouteTableAction {
    /// <p>A description of the EC2 route table that is associated with the remediation action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the EC2 route table that is associated with the remediation action.</p>
    pub fn route_table_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.route_table_id.as_ref()
    }
    /// <p>The ID of the subnet for the EC2 route table that is associated with the remediation action.</p>
    pub fn subnet_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.subnet_id.as_ref()
    }
    /// <p>The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.</p>
    pub fn gateway_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.gateway_id.as_ref()
    }
}
impl std::fmt::Debug for Ec2AssociateRouteTableAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2AssociateRouteTableAction");
        formatter.field("description", &self.description);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("gateway_id", &self.gateway_id);
        formatter.finish()
    }
}
/// See [`Ec2AssociateRouteTableAction`](crate::model::Ec2AssociateRouteTableAction)
pub mod ec2_associate_route_table_action {
    /// A builder for [`Ec2AssociateRouteTableAction`](crate::model::Ec2AssociateRouteTableAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) route_table_id: std::option::Option<crate::model::ActionTarget>,
        pub(crate) subnet_id: std::option::Option<crate::model::ActionTarget>,
        pub(crate) gateway_id: std::option::Option<crate::model::ActionTarget>,
    }
    impl Builder {
        /// <p>A description of the EC2 route table that is associated with the remediation action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the EC2 route table that is associated with the remediation action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the EC2 route table that is associated with the remediation action.</p>
        pub fn route_table_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.route_table_id = Some(input);
            self
        }
        /// <p>The ID of the EC2 route table that is associated with the remediation action.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// <p>The ID of the subnet for the EC2 route table that is associated with the remediation action.</p>
        pub fn subnet_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.subnet_id = Some(input);
            self
        }
        /// <p>The ID of the subnet for the EC2 route table that is associated with the remediation action.</p>
        pub fn set_subnet_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.</p>
        pub fn gateway_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.gateway_id = Some(input);
            self
        }
        /// <p>The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.</p>
        pub fn set_gateway_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2AssociateRouteTableAction`](crate::model::Ec2AssociateRouteTableAction)
        pub fn build(self) -> crate::model::Ec2AssociateRouteTableAction {
            crate::model::Ec2AssociateRouteTableAction {
                description: self.description,
                route_table_id: self.route_table_id,
                subnet_id: self.subnet_id,
                gateway_id: self.gateway_id,
            }
        }
    }
}
impl Ec2AssociateRouteTableAction {
    /// Creates a new builder-style object to manufacture [`Ec2AssociateRouteTableAction`](crate::model::Ec2AssociateRouteTableAction)
    pub fn builder() -> crate::model::ec2_associate_route_table_action::Builder {
        crate::model::ec2_associate_route_table_action::Builder::default()
    }
}

/// <p>Information about the ReplaceRouteTableAssociation action in Amazon EC2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2ReplaceRouteTableAssociationAction {
    /// <p>A description of the ReplaceRouteTableAssociation action in Amazon EC2.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the association ID.</p>
    pub association_id: std::option::Option<crate::model::ActionTarget>,
    /// <p>Information about the ID of the new route table to associate with the subnet.</p>
    pub route_table_id: std::option::Option<crate::model::ActionTarget>,
}
impl Ec2ReplaceRouteTableAssociationAction {
    /// <p>A description of the ReplaceRouteTableAssociation action in Amazon EC2.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the association ID.</p>
    pub fn association_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.association_id.as_ref()
    }
    /// <p>Information about the ID of the new route table to associate with the subnet.</p>
    pub fn route_table_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.route_table_id.as_ref()
    }
}
impl std::fmt::Debug for Ec2ReplaceRouteTableAssociationAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2ReplaceRouteTableAssociationAction");
        formatter.field("description", &self.description);
        formatter.field("association_id", &self.association_id);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.finish()
    }
}
/// See [`Ec2ReplaceRouteTableAssociationAction`](crate::model::Ec2ReplaceRouteTableAssociationAction)
pub mod ec2_replace_route_table_association_action {
    /// A builder for [`Ec2ReplaceRouteTableAssociationAction`](crate::model::Ec2ReplaceRouteTableAssociationAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<crate::model::ActionTarget>,
        pub(crate) route_table_id: std::option::Option<crate::model::ActionTarget>,
    }
    impl Builder {
        /// <p>A description of the ReplaceRouteTableAssociation action in Amazon EC2.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the ReplaceRouteTableAssociation action in Amazon EC2.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the association ID.</p>
        pub fn association_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.association_id = Some(input);
            self
        }
        /// <p>Information about the association ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>Information about the ID of the new route table to associate with the subnet.</p>
        pub fn route_table_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.route_table_id = Some(input);
            self
        }
        /// <p>Information about the ID of the new route table to associate with the subnet.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2ReplaceRouteTableAssociationAction`](crate::model::Ec2ReplaceRouteTableAssociationAction)
        pub fn build(self) -> crate::model::Ec2ReplaceRouteTableAssociationAction {
            crate::model::Ec2ReplaceRouteTableAssociationAction {
                description: self.description,
                association_id: self.association_id,
                route_table_id: self.route_table_id,
            }
        }
    }
}
impl Ec2ReplaceRouteTableAssociationAction {
    /// Creates a new builder-style object to manufacture [`Ec2ReplaceRouteTableAssociationAction`](crate::model::Ec2ReplaceRouteTableAssociationAction)
    pub fn builder() -> crate::model::ec2_replace_route_table_association_action::Builder {
        crate::model::ec2_replace_route_table_association_action::Builder::default()
    }
}

/// <p>An action that copies the EC2 route table for use in remediation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2CopyRouteTableAction {
    /// <p>A description of the copied EC2 route table that is associated with the remediation action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The VPC ID of the copied EC2 route table that is associated with the remediation action.</p>
    pub vpc_id: std::option::Option<crate::model::ActionTarget>,
    /// <p>The ID of the copied EC2 route table that is associated with the remediation action.</p>
    pub route_table_id: std::option::Option<crate::model::ActionTarget>,
}
impl Ec2CopyRouteTableAction {
    /// <p>A description of the copied EC2 route table that is associated with the remediation action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The VPC ID of the copied EC2 route table that is associated with the remediation action.</p>
    pub fn vpc_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.vpc_id.as_ref()
    }
    /// <p>The ID of the copied EC2 route table that is associated with the remediation action.</p>
    pub fn route_table_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.route_table_id.as_ref()
    }
}
impl std::fmt::Debug for Ec2CopyRouteTableAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2CopyRouteTableAction");
        formatter.field("description", &self.description);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.finish()
    }
}
/// See [`Ec2CopyRouteTableAction`](crate::model::Ec2CopyRouteTableAction)
pub mod ec2_copy_route_table_action {
    /// A builder for [`Ec2CopyRouteTableAction`](crate::model::Ec2CopyRouteTableAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<crate::model::ActionTarget>,
        pub(crate) route_table_id: std::option::Option<crate::model::ActionTarget>,
    }
    impl Builder {
        /// <p>A description of the copied EC2 route table that is associated with the remediation action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the copied EC2 route table that is associated with the remediation action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The VPC ID of the copied EC2 route table that is associated with the remediation action.</p>
        pub fn vpc_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.vpc_id = Some(input);
            self
        }
        /// <p>The VPC ID of the copied EC2 route table that is associated with the remediation action.</p>
        pub fn set_vpc_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The ID of the copied EC2 route table that is associated with the remediation action.</p>
        pub fn route_table_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.route_table_id = Some(input);
            self
        }
        /// <p>The ID of the copied EC2 route table that is associated with the remediation action.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2CopyRouteTableAction`](crate::model::Ec2CopyRouteTableAction)
        pub fn build(self) -> crate::model::Ec2CopyRouteTableAction {
            crate::model::Ec2CopyRouteTableAction {
                description: self.description,
                vpc_id: self.vpc_id,
                route_table_id: self.route_table_id,
            }
        }
    }
}
impl Ec2CopyRouteTableAction {
    /// Creates a new builder-style object to manufacture [`Ec2CopyRouteTableAction`](crate::model::Ec2CopyRouteTableAction)
    pub fn builder() -> crate::model::ec2_copy_route_table_action::Builder {
        crate::model::ec2_copy_route_table_action::Builder::default()
    }
}

/// <p>Information about the DeleteRoute action in Amazon EC2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2DeleteRouteAction {
    /// <p>A description of the DeleteRoute action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
    /// <p>Information about the ID of the prefix list for the route.</p>
    pub destination_prefix_list_id: std::option::Option<std::string::String>,
    /// <p>Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    pub destination_ipv6_cidr_block: std::option::Option<std::string::String>,
    /// <p>Information about the ID of the route table.</p>
    pub route_table_id: std::option::Option<crate::model::ActionTarget>,
}
impl Ec2DeleteRouteAction {
    /// <p>A description of the DeleteRoute action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    pub fn destination_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_cidr_block.as_deref()
    }
    /// <p>Information about the ID of the prefix list for the route.</p>
    pub fn destination_prefix_list_id(&self) -> std::option::Option<&str> {
        self.destination_prefix_list_id.as_deref()
    }
    /// <p>Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    pub fn destination_ipv6_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_ipv6_cidr_block.as_deref()
    }
    /// <p>Information about the ID of the route table.</p>
    pub fn route_table_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.route_table_id.as_ref()
    }
}
impl std::fmt::Debug for Ec2DeleteRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2DeleteRouteAction");
        formatter.field("description", &self.description);
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.field(
            "destination_prefix_list_id",
            &self.destination_prefix_list_id,
        );
        formatter.field(
            "destination_ipv6_cidr_block",
            &self.destination_ipv6_cidr_block,
        );
        formatter.field("route_table_id", &self.route_table_id);
        formatter.finish()
    }
}
/// See [`Ec2DeleteRouteAction`](crate::model::Ec2DeleteRouteAction)
pub mod ec2_delete_route_action {
    /// A builder for [`Ec2DeleteRouteAction`](crate::model::Ec2DeleteRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) destination_prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) destination_ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) route_table_id: std::option::Option<crate::model::ActionTarget>,
    }
    impl Builder {
        /// <p>A description of the DeleteRoute action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the DeleteRoute action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>Information about the ID of the prefix list for the route.</p>
        pub fn destination_prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_prefix_list_id = Some(input.into());
            self
        }
        /// <p>Information about the ID of the prefix list for the route.</p>
        pub fn set_destination_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_prefix_list_id = input;
            self
        }
        /// <p>Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
        pub fn destination_ipv6_cidr_block(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
        pub fn set_destination_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = input;
            self
        }
        /// <p>Information about the ID of the route table.</p>
        pub fn route_table_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.route_table_id = Some(input);
            self
        }
        /// <p>Information about the ID of the route table.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2DeleteRouteAction`](crate::model::Ec2DeleteRouteAction)
        pub fn build(self) -> crate::model::Ec2DeleteRouteAction {
            crate::model::Ec2DeleteRouteAction {
                description: self.description,
                destination_cidr_block: self.destination_cidr_block,
                destination_prefix_list_id: self.destination_prefix_list_id,
                destination_ipv6_cidr_block: self.destination_ipv6_cidr_block,
                route_table_id: self.route_table_id,
            }
        }
    }
}
impl Ec2DeleteRouteAction {
    /// Creates a new builder-style object to manufacture [`Ec2DeleteRouteAction`](crate::model::Ec2DeleteRouteAction)
    pub fn builder() -> crate::model::ec2_delete_route_action::Builder {
        crate::model::ec2_delete_route_action::Builder::default()
    }
}

/// <p>Information about the ReplaceRoute action in Amazon EC2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2ReplaceRouteAction {
    /// <p>A description of the ReplaceRoute action in Amazon EC2.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
    /// <p>Information about the ID of the prefix list for the route.</p>
    pub destination_prefix_list_id: std::option::Option<std::string::String>,
    /// <p>Information about the IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
    pub destination_ipv6_cidr_block: std::option::Option<std::string::String>,
    /// <p>Information about the ID of an internet gateway or virtual private gateway.</p>
    pub gateway_id: std::option::Option<crate::model::ActionTarget>,
    /// <p>Information about the ID of the route table.</p>
    pub route_table_id: std::option::Option<crate::model::ActionTarget>,
}
impl Ec2ReplaceRouteAction {
    /// <p>A description of the ReplaceRoute action in Amazon EC2.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
    pub fn destination_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_cidr_block.as_deref()
    }
    /// <p>Information about the ID of the prefix list for the route.</p>
    pub fn destination_prefix_list_id(&self) -> std::option::Option<&str> {
        self.destination_prefix_list_id.as_deref()
    }
    /// <p>Information about the IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
    pub fn destination_ipv6_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_ipv6_cidr_block.as_deref()
    }
    /// <p>Information about the ID of an internet gateway or virtual private gateway.</p>
    pub fn gateway_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.gateway_id.as_ref()
    }
    /// <p>Information about the ID of the route table.</p>
    pub fn route_table_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.route_table_id.as_ref()
    }
}
impl std::fmt::Debug for Ec2ReplaceRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2ReplaceRouteAction");
        formatter.field("description", &self.description);
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.field(
            "destination_prefix_list_id",
            &self.destination_prefix_list_id,
        );
        formatter.field(
            "destination_ipv6_cidr_block",
            &self.destination_ipv6_cidr_block,
        );
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.finish()
    }
}
/// See [`Ec2ReplaceRouteAction`](crate::model::Ec2ReplaceRouteAction)
pub mod ec2_replace_route_action {
    /// A builder for [`Ec2ReplaceRouteAction`](crate::model::Ec2ReplaceRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) destination_prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) destination_ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<crate::model::ActionTarget>,
        pub(crate) route_table_id: std::option::Option<crate::model::ActionTarget>,
    }
    impl Builder {
        /// <p>A description of the ReplaceRoute action in Amazon EC2.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the ReplaceRoute action in Amazon EC2.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>Information about the IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>Information about the ID of the prefix list for the route.</p>
        pub fn destination_prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_prefix_list_id = Some(input.into());
            self
        }
        /// <p>Information about the ID of the prefix list for the route.</p>
        pub fn set_destination_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_prefix_list_id = input;
            self
        }
        /// <p>Information about the IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
        pub fn destination_ipv6_cidr_block(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>Information about the IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>
        pub fn set_destination_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = input;
            self
        }
        /// <p>Information about the ID of an internet gateway or virtual private gateway.</p>
        pub fn gateway_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.gateway_id = Some(input);
            self
        }
        /// <p>Information about the ID of an internet gateway or virtual private gateway.</p>
        pub fn set_gateway_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>Information about the ID of the route table.</p>
        pub fn route_table_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.route_table_id = Some(input);
            self
        }
        /// <p>Information about the ID of the route table.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2ReplaceRouteAction`](crate::model::Ec2ReplaceRouteAction)
        pub fn build(self) -> crate::model::Ec2ReplaceRouteAction {
            crate::model::Ec2ReplaceRouteAction {
                description: self.description,
                destination_cidr_block: self.destination_cidr_block,
                destination_prefix_list_id: self.destination_prefix_list_id,
                destination_ipv6_cidr_block: self.destination_ipv6_cidr_block,
                gateway_id: self.gateway_id,
                route_table_id: self.route_table_id,
            }
        }
    }
}
impl Ec2ReplaceRouteAction {
    /// Creates a new builder-style object to manufacture [`Ec2ReplaceRouteAction`](crate::model::Ec2ReplaceRouteAction)
    pub fn builder() -> crate::model::ec2_replace_route_action::Builder {
        crate::model::ec2_replace_route_action::Builder::default()
    }
}

/// <p>Information about the CreateRoute action in Amazon EC2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2CreateRouteAction {
    /// <p>A description of CreateRoute action in Amazon EC2.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the IPv4 CIDR address block used for the destination match.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
    /// <p>Information about the ID of a prefix list used for the destination match.</p>
    pub destination_prefix_list_id: std::option::Option<std::string::String>,
    /// <p>Information about the IPv6 CIDR block destination.</p>
    pub destination_ipv6_cidr_block: std::option::Option<std::string::String>,
    /// <p>Information about the ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
    pub vpc_endpoint_id: std::option::Option<crate::model::ActionTarget>,
    /// <p>Information about the ID of an internet gateway or virtual private gateway attached to your VPC.</p>
    pub gateway_id: std::option::Option<crate::model::ActionTarget>,
    /// <p>Information about the ID of the route table for the route.</p>
    pub route_table_id: std::option::Option<crate::model::ActionTarget>,
}
impl Ec2CreateRouteAction {
    /// <p>A description of CreateRoute action in Amazon EC2.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the IPv4 CIDR address block used for the destination match.</p>
    pub fn destination_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_cidr_block.as_deref()
    }
    /// <p>Information about the ID of a prefix list used for the destination match.</p>
    pub fn destination_prefix_list_id(&self) -> std::option::Option<&str> {
        self.destination_prefix_list_id.as_deref()
    }
    /// <p>Information about the IPv6 CIDR block destination.</p>
    pub fn destination_ipv6_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_ipv6_cidr_block.as_deref()
    }
    /// <p>Information about the ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
    pub fn vpc_endpoint_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.vpc_endpoint_id.as_ref()
    }
    /// <p>Information about the ID of an internet gateway or virtual private gateway attached to your VPC.</p>
    pub fn gateway_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.gateway_id.as_ref()
    }
    /// <p>Information about the ID of the route table for the route.</p>
    pub fn route_table_id(&self) -> std::option::Option<&crate::model::ActionTarget> {
        self.route_table_id.as_ref()
    }
}
impl std::fmt::Debug for Ec2CreateRouteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2CreateRouteAction");
        formatter.field("description", &self.description);
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.field(
            "destination_prefix_list_id",
            &self.destination_prefix_list_id,
        );
        formatter.field(
            "destination_ipv6_cidr_block",
            &self.destination_ipv6_cidr_block,
        );
        formatter.field("vpc_endpoint_id", &self.vpc_endpoint_id);
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.finish()
    }
}
/// See [`Ec2CreateRouteAction`](crate::model::Ec2CreateRouteAction)
pub mod ec2_create_route_action {
    /// A builder for [`Ec2CreateRouteAction`](crate::model::Ec2CreateRouteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) destination_prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) destination_ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) vpc_endpoint_id: std::option::Option<crate::model::ActionTarget>,
        pub(crate) gateway_id: std::option::Option<crate::model::ActionTarget>,
        pub(crate) route_table_id: std::option::Option<crate::model::ActionTarget>,
    }
    impl Builder {
        /// <p>A description of CreateRoute action in Amazon EC2.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of CreateRoute action in Amazon EC2.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the IPv4 CIDR address block used for the destination match.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>Information about the IPv4 CIDR address block used for the destination match.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>Information about the ID of a prefix list used for the destination match.</p>
        pub fn destination_prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_prefix_list_id = Some(input.into());
            self
        }
        /// <p>Information about the ID of a prefix list used for the destination match.</p>
        pub fn set_destination_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_prefix_list_id = input;
            self
        }
        /// <p>Information about the IPv6 CIDR block destination.</p>
        pub fn destination_ipv6_cidr_block(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>Information about the IPv6 CIDR block destination.</p>
        pub fn set_destination_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = input;
            self
        }
        /// <p>Information about the ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
        pub fn vpc_endpoint_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.vpc_endpoint_id = Some(input);
            self
        }
        /// <p>Information about the ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.vpc_endpoint_id = input;
            self
        }
        /// <p>Information about the ID of an internet gateway or virtual private gateway attached to your VPC.</p>
        pub fn gateway_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.gateway_id = Some(input);
            self
        }
        /// <p>Information about the ID of an internet gateway or virtual private gateway attached to your VPC.</p>
        pub fn set_gateway_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>Information about the ID of the route table for the route.</p>
        pub fn route_table_id(mut self, input: crate::model::ActionTarget) -> Self {
            self.route_table_id = Some(input);
            self
        }
        /// <p>Information about the ID of the route table for the route.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<crate::model::ActionTarget>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2CreateRouteAction`](crate::model::Ec2CreateRouteAction)
        pub fn build(self) -> crate::model::Ec2CreateRouteAction {
            crate::model::Ec2CreateRouteAction {
                description: self.description,
                destination_cidr_block: self.destination_cidr_block,
                destination_prefix_list_id: self.destination_prefix_list_id,
                destination_ipv6_cidr_block: self.destination_ipv6_cidr_block,
                vpc_endpoint_id: self.vpc_endpoint_id,
                gateway_id: self.gateway_id,
                route_table_id: self.route_table_id,
            }
        }
    }
}
impl Ec2CreateRouteAction {
    /// Creates a new builder-style object to manufacture [`Ec2CreateRouteAction`](crate::model::Ec2CreateRouteAction)
    pub fn builder() -> crate::model::ec2_create_route_action::Builder {
        crate::model::ec2_create_route_action::Builder::default()
    }
}

/// <p>The VPC that Firewall Manager was applying a DNS Fireall policy to reached the limit for associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed due to the limit. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsRuleGroupLimitExceededViolation {
    /// <p>Information about the VPC ID. </p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>A description of the violation that specifies the rule group and VPC.</p>
    pub violation_target_description: std::option::Option<std::string::String>,
    /// <p>The number of rule groups currently associated with the VPC. </p>
    pub number_of_rule_groups_already_associated: i32,
}
impl DnsRuleGroupLimitExceededViolation {
    /// <p>Information about the VPC ID. </p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>A description of the violation that specifies the rule group and VPC.</p>
    pub fn violation_target_description(&self) -> std::option::Option<&str> {
        self.violation_target_description.as_deref()
    }
    /// <p>The number of rule groups currently associated with the VPC. </p>
    pub fn number_of_rule_groups_already_associated(&self) -> i32 {
        self.number_of_rule_groups_already_associated
    }
}
impl std::fmt::Debug for DnsRuleGroupLimitExceededViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsRuleGroupLimitExceededViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field(
            "violation_target_description",
            &self.violation_target_description,
        );
        formatter.field(
            "number_of_rule_groups_already_associated",
            &self.number_of_rule_groups_already_associated,
        );
        formatter.finish()
    }
}
/// See [`DnsRuleGroupLimitExceededViolation`](crate::model::DnsRuleGroupLimitExceededViolation)
pub mod dns_rule_group_limit_exceeded_violation {
    /// A builder for [`DnsRuleGroupLimitExceededViolation`](crate::model::DnsRuleGroupLimitExceededViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) violation_target_description: std::option::Option<std::string::String>,
        pub(crate) number_of_rule_groups_already_associated: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Information about the VPC ID. </p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID. </p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>A description of the violation that specifies the rule group and VPC.</p>
        pub fn violation_target_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.violation_target_description = Some(input.into());
            self
        }
        /// <p>A description of the violation that specifies the rule group and VPC.</p>
        pub fn set_violation_target_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target_description = input;
            self
        }
        /// <p>The number of rule groups currently associated with the VPC. </p>
        pub fn number_of_rule_groups_already_associated(mut self, input: i32) -> Self {
            self.number_of_rule_groups_already_associated = Some(input);
            self
        }
        /// <p>The number of rule groups currently associated with the VPC. </p>
        pub fn set_number_of_rule_groups_already_associated(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_rule_groups_already_associated = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsRuleGroupLimitExceededViolation`](crate::model::DnsRuleGroupLimitExceededViolation)
        pub fn build(self) -> crate::model::DnsRuleGroupLimitExceededViolation {
            crate::model::DnsRuleGroupLimitExceededViolation {
                violation_target: self.violation_target,
                violation_target_description: self.violation_target_description,
                number_of_rule_groups_already_associated: self
                    .number_of_rule_groups_already_associated
                    .unwrap_or_default(),
            }
        }
    }
}
impl DnsRuleGroupLimitExceededViolation {
    /// Creates a new builder-style object to manufacture [`DnsRuleGroupLimitExceededViolation`](crate::model::DnsRuleGroupLimitExceededViolation)
    pub fn builder() -> crate::model::dns_rule_group_limit_exceeded_violation::Builder {
        crate::model::dns_rule_group_limit_exceeded_violation::Builder::default()
    }
}

/// <p>A DNS Firewall rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and can't be associated again. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsDuplicateRuleGroupViolation {
    /// <p>Information about the VPC ID. </p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>A description of the violation that specifies the rule group and VPC.</p>
    pub violation_target_description: std::option::Option<std::string::String>,
}
impl DnsDuplicateRuleGroupViolation {
    /// <p>Information about the VPC ID. </p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>A description of the violation that specifies the rule group and VPC.</p>
    pub fn violation_target_description(&self) -> std::option::Option<&str> {
        self.violation_target_description.as_deref()
    }
}
impl std::fmt::Debug for DnsDuplicateRuleGroupViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsDuplicateRuleGroupViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field(
            "violation_target_description",
            &self.violation_target_description,
        );
        formatter.finish()
    }
}
/// See [`DnsDuplicateRuleGroupViolation`](crate::model::DnsDuplicateRuleGroupViolation)
pub mod dns_duplicate_rule_group_violation {
    /// A builder for [`DnsDuplicateRuleGroupViolation`](crate::model::DnsDuplicateRuleGroupViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) violation_target_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the VPC ID. </p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID. </p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>A description of the violation that specifies the rule group and VPC.</p>
        pub fn violation_target_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.violation_target_description = Some(input.into());
            self
        }
        /// <p>A description of the violation that specifies the rule group and VPC.</p>
        pub fn set_violation_target_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsDuplicateRuleGroupViolation`](crate::model::DnsDuplicateRuleGroupViolation)
        pub fn build(self) -> crate::model::DnsDuplicateRuleGroupViolation {
            crate::model::DnsDuplicateRuleGroupViolation {
                violation_target: self.violation_target,
                violation_target_description: self.violation_target_description,
            }
        }
    }
}
impl DnsDuplicateRuleGroupViolation {
    /// Creates a new builder-style object to manufacture [`DnsDuplicateRuleGroupViolation`](crate::model::DnsDuplicateRuleGroupViolation)
    pub fn builder() -> crate::model::dns_duplicate_rule_group_violation::Builder {
        crate::model::dns_duplicate_rule_group_violation::Builder::default()
    }
}

/// <p>A rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that's already associated. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsRuleGroupPriorityConflictViolation {
    /// <p>Information about the VPC ID. </p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>A description of the violation that specifies the VPC and the rule group that's already associated with it.</p>
    pub violation_target_description: std::option::Option<std::string::String>,
    /// <p>The priority setting of the two conflicting rule groups.</p>
    pub conflicting_priority: i32,
    /// <p>The ID of the Firewall Manager DNS Firewall policy that was already applied to the VPC. This policy contains the rule group that's already associated with the VPC. </p>
    pub conflicting_policy_id: std::option::Option<std::string::String>,
    /// <p>The priorities of rule groups that are already associated with the VPC. To retry your operation, choose priority settings that aren't in this list for the rule groups in your new DNS Firewall policy. </p>
    pub unavailable_priorities: std::option::Option<std::vec::Vec<i32>>,
}
impl DnsRuleGroupPriorityConflictViolation {
    /// <p>Information about the VPC ID. </p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>A description of the violation that specifies the VPC and the rule group that's already associated with it.</p>
    pub fn violation_target_description(&self) -> std::option::Option<&str> {
        self.violation_target_description.as_deref()
    }
    /// <p>The priority setting of the two conflicting rule groups.</p>
    pub fn conflicting_priority(&self) -> i32 {
        self.conflicting_priority
    }
    /// <p>The ID of the Firewall Manager DNS Firewall policy that was already applied to the VPC. This policy contains the rule group that's already associated with the VPC. </p>
    pub fn conflicting_policy_id(&self) -> std::option::Option<&str> {
        self.conflicting_policy_id.as_deref()
    }
    /// <p>The priorities of rule groups that are already associated with the VPC. To retry your operation, choose priority settings that aren't in this list for the rule groups in your new DNS Firewall policy. </p>
    pub fn unavailable_priorities(&self) -> std::option::Option<&[i32]> {
        self.unavailable_priorities.as_deref()
    }
}
impl std::fmt::Debug for DnsRuleGroupPriorityConflictViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsRuleGroupPriorityConflictViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field(
            "violation_target_description",
            &self.violation_target_description,
        );
        formatter.field("conflicting_priority", &self.conflicting_priority);
        formatter.field("conflicting_policy_id", &self.conflicting_policy_id);
        formatter.field("unavailable_priorities", &self.unavailable_priorities);
        formatter.finish()
    }
}
/// See [`DnsRuleGroupPriorityConflictViolation`](crate::model::DnsRuleGroupPriorityConflictViolation)
pub mod dns_rule_group_priority_conflict_violation {
    /// A builder for [`DnsRuleGroupPriorityConflictViolation`](crate::model::DnsRuleGroupPriorityConflictViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) violation_target_description: std::option::Option<std::string::String>,
        pub(crate) conflicting_priority: std::option::Option<i32>,
        pub(crate) conflicting_policy_id: std::option::Option<std::string::String>,
        pub(crate) unavailable_priorities: std::option::Option<std::vec::Vec<i32>>,
    }
    impl Builder {
        /// <p>Information about the VPC ID. </p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID. </p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>A description of the violation that specifies the VPC and the rule group that's already associated with it.</p>
        pub fn violation_target_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.violation_target_description = Some(input.into());
            self
        }
        /// <p>A description of the violation that specifies the VPC and the rule group that's already associated with it.</p>
        pub fn set_violation_target_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target_description = input;
            self
        }
        /// <p>The priority setting of the two conflicting rule groups.</p>
        pub fn conflicting_priority(mut self, input: i32) -> Self {
            self.conflicting_priority = Some(input);
            self
        }
        /// <p>The priority setting of the two conflicting rule groups.</p>
        pub fn set_conflicting_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.conflicting_priority = input;
            self
        }
        /// <p>The ID of the Firewall Manager DNS Firewall policy that was already applied to the VPC. This policy contains the rule group that's already associated with the VPC. </p>
        pub fn conflicting_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.conflicting_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager DNS Firewall policy that was already applied to the VPC. This policy contains the rule group that's already associated with the VPC. </p>
        pub fn set_conflicting_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conflicting_policy_id = input;
            self
        }
        /// Appends an item to `unavailable_priorities`.
        ///
        /// To override the contents of this collection use [`set_unavailable_priorities`](Self::set_unavailable_priorities).
        ///
        /// <p>The priorities of rule groups that are already associated with the VPC. To retry your operation, choose priority settings that aren't in this list for the rule groups in your new DNS Firewall policy. </p>
        pub fn unavailable_priorities(mut self, input: i32) -> Self {
            let mut v = self.unavailable_priorities.unwrap_or_default();
            v.push(input);
            self.unavailable_priorities = Some(v);
            self
        }
        /// <p>The priorities of rule groups that are already associated with the VPC. To retry your operation, choose priority settings that aren't in this list for the rule groups in your new DNS Firewall policy. </p>
        pub fn set_unavailable_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.unavailable_priorities = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsRuleGroupPriorityConflictViolation`](crate::model::DnsRuleGroupPriorityConflictViolation)
        pub fn build(self) -> crate::model::DnsRuleGroupPriorityConflictViolation {
            crate::model::DnsRuleGroupPriorityConflictViolation {
                violation_target: self.violation_target,
                violation_target_description: self.violation_target_description,
                conflicting_priority: self.conflicting_priority.unwrap_or_default(),
                conflicting_policy_id: self.conflicting_policy_id,
                unavailable_priorities: self.unavailable_priorities,
            }
        }
    }
}
impl DnsRuleGroupPriorityConflictViolation {
    /// Creates a new builder-style object to manufacture [`DnsRuleGroupPriorityConflictViolation`](crate::model::DnsRuleGroupPriorityConflictViolation)
    pub fn builder() -> crate::model::dns_rule_group_priority_conflict_violation::Builder {
        crate::model::dns_rule_group_priority_conflict_violation::Builder::default()
    }
}

/// <p>Violation detail for an expected route missing in Network Firewall.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallMissingExpectedRoutesViolation {
    /// <p>The target of the violation.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>The expected routes.</p>
    pub expected_routes: std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
    /// <p>Information about the VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl NetworkFirewallMissingExpectedRoutesViolation {
    /// <p>The target of the violation.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>The expected routes.</p>
    pub fn expected_routes(&self) -> std::option::Option<&[crate::model::ExpectedRoute]> {
        self.expected_routes.as_deref()
    }
    /// <p>Information about the VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallMissingExpectedRoutesViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallMissingExpectedRoutesViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field("expected_routes", &self.expected_routes);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`NetworkFirewallMissingExpectedRoutesViolation`](crate::model::NetworkFirewallMissingExpectedRoutesViolation)
pub mod network_firewall_missing_expected_routes_violation {
    /// A builder for [`NetworkFirewallMissingExpectedRoutesViolation`](crate::model::NetworkFirewallMissingExpectedRoutesViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) expected_routes: std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The target of the violation.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The target of the violation.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// Appends an item to `expected_routes`.
        ///
        /// To override the contents of this collection use [`set_expected_routes`](Self::set_expected_routes).
        ///
        /// <p>The expected routes.</p>
        pub fn expected_routes(mut self, input: crate::model::ExpectedRoute) -> Self {
            let mut v = self.expected_routes.unwrap_or_default();
            v.push(input);
            self.expected_routes = Some(v);
            self
        }
        /// <p>The expected routes.</p>
        pub fn set_expected_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        ) -> Self {
            self.expected_routes = input;
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallMissingExpectedRoutesViolation`](crate::model::NetworkFirewallMissingExpectedRoutesViolation)
        pub fn build(self) -> crate::model::NetworkFirewallMissingExpectedRoutesViolation {
            crate::model::NetworkFirewallMissingExpectedRoutesViolation {
                violation_target: self.violation_target,
                expected_routes: self.expected_routes,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl NetworkFirewallMissingExpectedRoutesViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallMissingExpectedRoutesViolation`](crate::model::NetworkFirewallMissingExpectedRoutesViolation)
    pub fn builder() -> crate::model::network_firewall_missing_expected_routes_violation::Builder {
        crate::model::network_firewall_missing_expected_routes_violation::Builder::default()
    }
}

/// <p>Information about the expected route in the route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpectedRoute {
    /// <p>Information about the IPv4 CIDR block.</p>
    pub ip_v4_cidr: std::option::Option<std::string::String>,
    /// <p>Information about the ID of the prefix list for the route.</p>
    pub prefix_list_id: std::option::Option<std::string::String>,
    /// <p>Information about the IPv6 CIDR block.</p>
    pub ip_v6_cidr: std::option::Option<std::string::String>,
    /// <p>Information about the contributing subnets.</p>
    pub contributing_subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the allowed targets.</p>
    pub allowed_targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the route table ID.</p>
    pub route_table_id: std::option::Option<std::string::String>,
}
impl ExpectedRoute {
    /// <p>Information about the IPv4 CIDR block.</p>
    pub fn ip_v4_cidr(&self) -> std::option::Option<&str> {
        self.ip_v4_cidr.as_deref()
    }
    /// <p>Information about the ID of the prefix list for the route.</p>
    pub fn prefix_list_id(&self) -> std::option::Option<&str> {
        self.prefix_list_id.as_deref()
    }
    /// <p>Information about the IPv6 CIDR block.</p>
    pub fn ip_v6_cidr(&self) -> std::option::Option<&str> {
        self.ip_v6_cidr.as_deref()
    }
    /// <p>Information about the contributing subnets.</p>
    pub fn contributing_subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.contributing_subnets.as_deref()
    }
    /// <p>Information about the allowed targets.</p>
    pub fn allowed_targets(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_targets.as_deref()
    }
    /// <p>Information about the route table ID.</p>
    pub fn route_table_id(&self) -> std::option::Option<&str> {
        self.route_table_id.as_deref()
    }
}
impl std::fmt::Debug for ExpectedRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpectedRoute");
        formatter.field("ip_v4_cidr", &self.ip_v4_cidr);
        formatter.field("prefix_list_id", &self.prefix_list_id);
        formatter.field("ip_v6_cidr", &self.ip_v6_cidr);
        formatter.field("contributing_subnets", &self.contributing_subnets);
        formatter.field("allowed_targets", &self.allowed_targets);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.finish()
    }
}
/// See [`ExpectedRoute`](crate::model::ExpectedRoute)
pub mod expected_route {
    /// A builder for [`ExpectedRoute`](crate::model::ExpectedRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_v4_cidr: std::option::Option<std::string::String>,
        pub(crate) prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) ip_v6_cidr: std::option::Option<std::string::String>,
        pub(crate) contributing_subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the IPv4 CIDR block.</p>
        pub fn ip_v4_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_v4_cidr = Some(input.into());
            self
        }
        /// <p>Information about the IPv4 CIDR block.</p>
        pub fn set_ip_v4_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_v4_cidr = input;
            self
        }
        /// <p>Information about the ID of the prefix list for the route.</p>
        pub fn prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_id = Some(input.into());
            self
        }
        /// <p>Information about the ID of the prefix list for the route.</p>
        pub fn set_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_id = input;
            self
        }
        /// <p>Information about the IPv6 CIDR block.</p>
        pub fn ip_v6_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_v6_cidr = Some(input.into());
            self
        }
        /// <p>Information about the IPv6 CIDR block.</p>
        pub fn set_ip_v6_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_v6_cidr = input;
            self
        }
        /// Appends an item to `contributing_subnets`.
        ///
        /// To override the contents of this collection use [`set_contributing_subnets`](Self::set_contributing_subnets).
        ///
        /// <p>Information about the contributing subnets.</p>
        pub fn contributing_subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.contributing_subnets.unwrap_or_default();
            v.push(input.into());
            self.contributing_subnets = Some(v);
            self
        }
        /// <p>Information about the contributing subnets.</p>
        pub fn set_contributing_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.contributing_subnets = input;
            self
        }
        /// Appends an item to `allowed_targets`.
        ///
        /// To override the contents of this collection use [`set_allowed_targets`](Self::set_allowed_targets).
        ///
        /// <p>Information about the allowed targets.</p>
        pub fn allowed_targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_targets.unwrap_or_default();
            v.push(input.into());
            self.allowed_targets = Some(v);
            self
        }
        /// <p>Information about the allowed targets.</p>
        pub fn set_allowed_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_targets = input;
            self
        }
        /// <p>Information about the route table ID.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>Information about the route table ID.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpectedRoute`](crate::model::ExpectedRoute)
        pub fn build(self) -> crate::model::ExpectedRoute {
            crate::model::ExpectedRoute {
                ip_v4_cidr: self.ip_v4_cidr,
                prefix_list_id: self.prefix_list_id,
                ip_v6_cidr: self.ip_v6_cidr,
                contributing_subnets: self.contributing_subnets,
                allowed_targets: self.allowed_targets,
                route_table_id: self.route_table_id,
            }
        }
    }
}
impl ExpectedRoute {
    /// Creates a new builder-style object to manufacture [`ExpectedRoute`](crate::model::ExpectedRoute)
    pub fn builder() -> crate::model::expected_route::Builder {
        crate::model::expected_route::Builder::default()
    }
}

/// <p>Violation detail for an unexpected gateway route that’s present in a route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallUnexpectedGatewayRoutesViolation {
    /// <p>Information about the gateway ID.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes that are in violation.</p>
    pub violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>Information about the route table.</p>
    pub route_table_id: std::option::Option<std::string::String>,
    /// <p>Information about the VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl NetworkFirewallUnexpectedGatewayRoutesViolation {
    /// <p>Information about the gateway ID.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The routes that are in violation.</p>
    pub fn violating_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.violating_routes.as_deref()
    }
    /// <p>Information about the route table.</p>
    pub fn route_table_id(&self) -> std::option::Option<&str> {
        self.route_table_id.as_deref()
    }
    /// <p>Information about the VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallUnexpectedGatewayRoutesViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallUnexpectedGatewayRoutesViolation");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("violating_routes", &self.violating_routes);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`NetworkFirewallUnexpectedGatewayRoutesViolation`](crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation)
pub mod network_firewall_unexpected_gateway_routes_violation {
    /// A builder for [`NetworkFirewallUnexpectedGatewayRoutesViolation`](crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the gateway ID.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>Information about the gateway ID.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// Appends an item to `violating_routes`.
        ///
        /// To override the contents of this collection use [`set_violating_routes`](Self::set_violating_routes).
        ///
        /// <p>The routes that are in violation.</p>
        pub fn violating_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.violating_routes.unwrap_or_default();
            v.push(input);
            self.violating_routes = Some(v);
            self
        }
        /// <p>The routes that are in violation.</p>
        pub fn set_violating_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.violating_routes = input;
            self
        }
        /// <p>Information about the route table.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>Information about the route table.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallUnexpectedGatewayRoutesViolation`](crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation)
        pub fn build(self) -> crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation {
            crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation {
                gateway_id: self.gateway_id,
                violating_routes: self.violating_routes,
                route_table_id: self.route_table_id,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl NetworkFirewallUnexpectedGatewayRoutesViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallUnexpectedGatewayRoutesViolation`](crate::model::NetworkFirewallUnexpectedGatewayRoutesViolation)
    pub fn builder() -> crate::model::network_firewall_unexpected_gateway_routes_violation::Builder
    {
        crate::model::network_firewall_unexpected_gateway_routes_violation::Builder::default()
    }
}

/// <p>Describes a route in a route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Route {
    /// <p>The type of destination for the route.</p>
    pub destination_type: std::option::Option<crate::model::DestinationType>,
    /// <p>The type of target for the route.</p>
    pub target_type: std::option::Option<crate::model::TargetType>,
    /// <p>The destination of the route.</p>
    pub destination: std::option::Option<std::string::String>,
    /// <p>The route's target.</p>
    pub target: std::option::Option<std::string::String>,
}
impl Route {
    /// <p>The type of destination for the route.</p>
    pub fn destination_type(&self) -> std::option::Option<&crate::model::DestinationType> {
        self.destination_type.as_ref()
    }
    /// <p>The type of target for the route.</p>
    pub fn target_type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.target_type.as_ref()
    }
    /// <p>The destination of the route.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
    /// <p>The route's target.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for Route {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Route");
        formatter.field("destination_type", &self.destination_type);
        formatter.field("target_type", &self.target_type);
        formatter.field("destination", &self.destination);
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`Route`](crate::model::Route)
pub mod route {
    /// A builder for [`Route`](crate::model::Route)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_type: std::option::Option<crate::model::DestinationType>,
        pub(crate) target_type: std::option::Option<crate::model::TargetType>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of destination for the route.</p>
        pub fn destination_type(mut self, input: crate::model::DestinationType) -> Self {
            self.destination_type = Some(input);
            self
        }
        /// <p>The type of destination for the route.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::DestinationType>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p>The type of target for the route.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The type of target for the route.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The destination of the route.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The destination of the route.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The route's target.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The route's target.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`Route`](crate::model::Route)
        pub fn build(self) -> crate::model::Route {
            crate::model::Route {
                destination_type: self.destination_type,
                target_type: self.target_type,
                destination: self.destination,
                target: self.target,
            }
        }
    }
}
impl Route {
    /// Creates a new builder-style object to manufacture [`Route`](crate::model::Route)
    pub fn builder() -> crate::model::route::Builder {
        crate::model::route::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetType {
    #[allow(missing_docs)] // documentation missing in model
    CarrierGateway,
    #[allow(missing_docs)] // documentation missing in model
    EgressOnlyInternetGateway,
    #[allow(missing_docs)] // documentation missing in model
    Gateway,
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    LocalGateway,
    #[allow(missing_docs)] // documentation missing in model
    NatGateway,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterface,
    #[allow(missing_docs)] // documentation missing in model
    TransitGateway,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    VpcPeeringConnection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetType {
    fn from(s: &str) -> Self {
        match s {
            "CARRIER_GATEWAY" => TargetType::CarrierGateway,
            "EGRESS_ONLY_INTERNET_GATEWAY" => TargetType::EgressOnlyInternetGateway,
            "GATEWAY" => TargetType::Gateway,
            "INSTANCE" => TargetType::Instance,
            "LOCAL_GATEWAY" => TargetType::LocalGateway,
            "NAT_GATEWAY" => TargetType::NatGateway,
            "NETWORK_INTERFACE" => TargetType::NetworkInterface,
            "TRANSIT_GATEWAY" => TargetType::TransitGateway,
            "VPC_ENDPOINT" => TargetType::VpcEndpoint,
            "VPC_PEERING_CONNECTION" => TargetType::VpcPeeringConnection,
            other => TargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetType::from(s))
    }
}
impl TargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetType::CarrierGateway => "CARRIER_GATEWAY",
            TargetType::EgressOnlyInternetGateway => "EGRESS_ONLY_INTERNET_GATEWAY",
            TargetType::Gateway => "GATEWAY",
            TargetType::Instance => "INSTANCE",
            TargetType::LocalGateway => "LOCAL_GATEWAY",
            TargetType::NatGateway => "NAT_GATEWAY",
            TargetType::NetworkInterface => "NETWORK_INTERFACE",
            TargetType::TransitGateway => "TRANSIT_GATEWAY",
            TargetType::VpcEndpoint => "VPC_ENDPOINT",
            TargetType::VpcPeeringConnection => "VPC_PEERING_CONNECTION",
            TargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CARRIER_GATEWAY",
            "EGRESS_ONLY_INTERNET_GATEWAY",
            "GATEWAY",
            "INSTANCE",
            "LOCAL_GATEWAY",
            "NAT_GATEWAY",
            "NETWORK_INTERFACE",
            "TRANSIT_GATEWAY",
            "VPC_ENDPOINT",
            "VPC_PEERING_CONNECTION",
        ]
    }
}
impl AsRef<str> for TargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DestinationType {
    #[allow(missing_docs)] // documentation missing in model
    Ipv4,
    #[allow(missing_docs)] // documentation missing in model
    Ipv6,
    #[allow(missing_docs)] // documentation missing in model
    PrefixList,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DestinationType {
    fn from(s: &str) -> Self {
        match s {
            "IPV4" => DestinationType::Ipv4,
            "IPV6" => DestinationType::Ipv6,
            "PREFIX_LIST" => DestinationType::PrefixList,
            other => DestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DestinationType::from(s))
    }
}
impl DestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DestinationType::Ipv4 => "IPV4",
            DestinationType::Ipv6 => "IPV6",
            DestinationType::PrefixList => "PREFIX_LIST",
            DestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IPV4", "IPV6", "PREFIX_LIST"]
    }
}
impl AsRef<str> for DestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Violation detail for an unexpected route that's present in a route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallUnexpectedFirewallRoutesViolation {
    /// <p>The subnet ID for the firewall.</p>
    pub firewall_subnet_id: std::option::Option<std::string::String>,
    /// <p>The routes that are in violation.</p>
    pub violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>The ID of the route table.</p>
    pub route_table_id: std::option::Option<std::string::String>,
    /// <p>The endpoint of the firewall.</p>
    pub firewall_endpoint: std::option::Option<std::string::String>,
    /// <p>Information about the VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl NetworkFirewallUnexpectedFirewallRoutesViolation {
    /// <p>The subnet ID for the firewall.</p>
    pub fn firewall_subnet_id(&self) -> std::option::Option<&str> {
        self.firewall_subnet_id.as_deref()
    }
    /// <p>The routes that are in violation.</p>
    pub fn violating_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.violating_routes.as_deref()
    }
    /// <p>The ID of the route table.</p>
    pub fn route_table_id(&self) -> std::option::Option<&str> {
        self.route_table_id.as_deref()
    }
    /// <p>The endpoint of the firewall.</p>
    pub fn firewall_endpoint(&self) -> std::option::Option<&str> {
        self.firewall_endpoint.as_deref()
    }
    /// <p>Information about the VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallUnexpectedFirewallRoutesViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallUnexpectedFirewallRoutesViolation");
        formatter.field("firewall_subnet_id", &self.firewall_subnet_id);
        formatter.field("violating_routes", &self.violating_routes);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.field("firewall_endpoint", &self.firewall_endpoint);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`NetworkFirewallUnexpectedFirewallRoutesViolation`](crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation)
pub mod network_firewall_unexpected_firewall_routes_violation {
    /// A builder for [`NetworkFirewallUnexpectedFirewallRoutesViolation`](crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_subnet_id: std::option::Option<std::string::String>,
        pub(crate) violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
        pub(crate) firewall_endpoint: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subnet ID for the firewall.</p>
        pub fn firewall_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID for the firewall.</p>
        pub fn set_firewall_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_subnet_id = input;
            self
        }
        /// Appends an item to `violating_routes`.
        ///
        /// To override the contents of this collection use [`set_violating_routes`](Self::set_violating_routes).
        ///
        /// <p>The routes that are in violation.</p>
        pub fn violating_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.violating_routes.unwrap_or_default();
            v.push(input);
            self.violating_routes = Some(v);
            self
        }
        /// <p>The routes that are in violation.</p>
        pub fn set_violating_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.violating_routes = input;
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// <p>The endpoint of the firewall.</p>
        pub fn firewall_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the firewall.</p>
        pub fn set_firewall_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_endpoint = input;
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallUnexpectedFirewallRoutesViolation`](crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation)
        pub fn build(self) -> crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation {
            crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation {
                firewall_subnet_id: self.firewall_subnet_id,
                violating_routes: self.violating_routes,
                route_table_id: self.route_table_id,
                firewall_endpoint: self.firewall_endpoint,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl NetworkFirewallUnexpectedFirewallRoutesViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallUnexpectedFirewallRoutesViolation`](crate::model::NetworkFirewallUnexpectedFirewallRoutesViolation)
    pub fn builder() -> crate::model::network_firewall_unexpected_firewall_routes_violation::Builder
    {
        crate::model::network_firewall_unexpected_firewall_routes_violation::Builder::default()
    }
}

/// <p>Violation detail for an internet gateway route with an inactive state in the customer subnet route table or Network Firewall subnet route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallBlackHoleRouteDetectedViolation {
    /// <p>The subnet that has an inactive state.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>Information about the route table ID.</p>
    pub route_table_id: std::option::Option<std::string::String>,
    /// <p>Information about the VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Information about the route or routes that are in violation.</p>
    pub violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
}
impl NetworkFirewallBlackHoleRouteDetectedViolation {
    /// <p>The subnet that has an inactive state.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>Information about the route table ID.</p>
    pub fn route_table_id(&self) -> std::option::Option<&str> {
        self.route_table_id.as_deref()
    }
    /// <p>Information about the VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Information about the route or routes that are in violation.</p>
    pub fn violating_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.violating_routes.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallBlackHoleRouteDetectedViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallBlackHoleRouteDetectedViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("violating_routes", &self.violating_routes);
        formatter.finish()
    }
}
/// See [`NetworkFirewallBlackHoleRouteDetectedViolation`](crate::model::NetworkFirewallBlackHoleRouteDetectedViolation)
pub mod network_firewall_black_hole_route_detected_violation {
    /// A builder for [`NetworkFirewallBlackHoleRouteDetectedViolation`](crate::model::NetworkFirewallBlackHoleRouteDetectedViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    }
    impl Builder {
        /// <p>The subnet that has an inactive state.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The subnet that has an inactive state.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>Information about the route table ID.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>Information about the route table ID.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `violating_routes`.
        ///
        /// To override the contents of this collection use [`set_violating_routes`](Self::set_violating_routes).
        ///
        /// <p>Information about the route or routes that are in violation.</p>
        pub fn violating_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.violating_routes.unwrap_or_default();
            v.push(input);
            self.violating_routes = Some(v);
            self
        }
        /// <p>Information about the route or routes that are in violation.</p>
        pub fn set_violating_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.violating_routes = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallBlackHoleRouteDetectedViolation`](crate::model::NetworkFirewallBlackHoleRouteDetectedViolation)
        pub fn build(self) -> crate::model::NetworkFirewallBlackHoleRouteDetectedViolation {
            crate::model::NetworkFirewallBlackHoleRouteDetectedViolation {
                violation_target: self.violation_target,
                route_table_id: self.route_table_id,
                vpc_id: self.vpc_id,
                violating_routes: self.violating_routes,
            }
        }
    }
}
impl NetworkFirewallBlackHoleRouteDetectedViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallBlackHoleRouteDetectedViolation`](crate::model::NetworkFirewallBlackHoleRouteDetectedViolation)
    pub fn builder() -> crate::model::network_firewall_black_hole_route_detected_violation::Builder
    {
        crate::model::network_firewall_black_hole_route_detected_violation::Builder::default()
    }
}

/// <p>Violation detail for the improperly configured subnet route. It's possible there is a missing route table route, or a configuration that causes traffic to cross an Availability Zone boundary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallInvalidRouteConfigurationViolation {
    /// <p>The subnets that are affected.</p>
    pub affected_subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The route table ID.</p>
    pub route_table_id: std::option::Option<std::string::String>,
    /// <p>Information about whether the route table is used in another Availability Zone.</p>
    pub is_route_table_used_in_different_az: bool,
    /// <p>The route that's in violation.</p>
    pub violating_route: std::option::Option<crate::model::Route>,
    /// <p>The subnet route table for the current firewall.</p>
    pub current_firewall_subnet_route_table: std::option::Option<std::string::String>,
    /// <p>The firewall endpoint that's expected.</p>
    pub expected_firewall_endpoint: std::option::Option<std::string::String>,
    /// <p>The actual firewall endpoint.</p>
    pub actual_firewall_endpoint: std::option::Option<std::string::String>,
    /// <p>The expected subnet ID for the firewall.</p>
    pub expected_firewall_subnet_id: std::option::Option<std::string::String>,
    /// <p>The actual subnet ID for the firewall.</p>
    pub actual_firewall_subnet_id: std::option::Option<std::string::String>,
    /// <p>The firewall subnet routes that are expected.</p>
    pub expected_firewall_subnet_routes:
        std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
    /// <p>The actual firewall subnet routes that are expected.</p>
    pub actual_firewall_subnet_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>The internet gateway ID.</p>
    pub internet_gateway_id: std::option::Option<std::string::String>,
    /// <p>The route table for the current internet gateway.</p>
    pub current_internet_gateway_route_table: std::option::Option<std::string::String>,
    /// <p>The expected routes for the internet gateway.</p>
    pub expected_internet_gateway_routes:
        std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
    /// <p>The actual internet gateway routes.</p>
    pub actual_internet_gateway_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>Information about the VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl NetworkFirewallInvalidRouteConfigurationViolation {
    /// <p>The subnets that are affected.</p>
    pub fn affected_subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.affected_subnets.as_deref()
    }
    /// <p>The route table ID.</p>
    pub fn route_table_id(&self) -> std::option::Option<&str> {
        self.route_table_id.as_deref()
    }
    /// <p>Information about whether the route table is used in another Availability Zone.</p>
    pub fn is_route_table_used_in_different_az(&self) -> bool {
        self.is_route_table_used_in_different_az
    }
    /// <p>The route that's in violation.</p>
    pub fn violating_route(&self) -> std::option::Option<&crate::model::Route> {
        self.violating_route.as_ref()
    }
    /// <p>The subnet route table for the current firewall.</p>
    pub fn current_firewall_subnet_route_table(&self) -> std::option::Option<&str> {
        self.current_firewall_subnet_route_table.as_deref()
    }
    /// <p>The firewall endpoint that's expected.</p>
    pub fn expected_firewall_endpoint(&self) -> std::option::Option<&str> {
        self.expected_firewall_endpoint.as_deref()
    }
    /// <p>The actual firewall endpoint.</p>
    pub fn actual_firewall_endpoint(&self) -> std::option::Option<&str> {
        self.actual_firewall_endpoint.as_deref()
    }
    /// <p>The expected subnet ID for the firewall.</p>
    pub fn expected_firewall_subnet_id(&self) -> std::option::Option<&str> {
        self.expected_firewall_subnet_id.as_deref()
    }
    /// <p>The actual subnet ID for the firewall.</p>
    pub fn actual_firewall_subnet_id(&self) -> std::option::Option<&str> {
        self.actual_firewall_subnet_id.as_deref()
    }
    /// <p>The firewall subnet routes that are expected.</p>
    pub fn expected_firewall_subnet_routes(
        &self,
    ) -> std::option::Option<&[crate::model::ExpectedRoute]> {
        self.expected_firewall_subnet_routes.as_deref()
    }
    /// <p>The actual firewall subnet routes that are expected.</p>
    pub fn actual_firewall_subnet_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.actual_firewall_subnet_routes.as_deref()
    }
    /// <p>The internet gateway ID.</p>
    pub fn internet_gateway_id(&self) -> std::option::Option<&str> {
        self.internet_gateway_id.as_deref()
    }
    /// <p>The route table for the current internet gateway.</p>
    pub fn current_internet_gateway_route_table(&self) -> std::option::Option<&str> {
        self.current_internet_gateway_route_table.as_deref()
    }
    /// <p>The expected routes for the internet gateway.</p>
    pub fn expected_internet_gateway_routes(
        &self,
    ) -> std::option::Option<&[crate::model::ExpectedRoute]> {
        self.expected_internet_gateway_routes.as_deref()
    }
    /// <p>The actual internet gateway routes.</p>
    pub fn actual_internet_gateway_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.actual_internet_gateway_routes.as_deref()
    }
    /// <p>Information about the VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallInvalidRouteConfigurationViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallInvalidRouteConfigurationViolation");
        formatter.field("affected_subnets", &self.affected_subnets);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.field(
            "is_route_table_used_in_different_az",
            &self.is_route_table_used_in_different_az,
        );
        formatter.field("violating_route", &self.violating_route);
        formatter.field(
            "current_firewall_subnet_route_table",
            &self.current_firewall_subnet_route_table,
        );
        formatter.field(
            "expected_firewall_endpoint",
            &self.expected_firewall_endpoint,
        );
        formatter.field("actual_firewall_endpoint", &self.actual_firewall_endpoint);
        formatter.field(
            "expected_firewall_subnet_id",
            &self.expected_firewall_subnet_id,
        );
        formatter.field("actual_firewall_subnet_id", &self.actual_firewall_subnet_id);
        formatter.field(
            "expected_firewall_subnet_routes",
            &self.expected_firewall_subnet_routes,
        );
        formatter.field(
            "actual_firewall_subnet_routes",
            &self.actual_firewall_subnet_routes,
        );
        formatter.field("internet_gateway_id", &self.internet_gateway_id);
        formatter.field(
            "current_internet_gateway_route_table",
            &self.current_internet_gateway_route_table,
        );
        formatter.field(
            "expected_internet_gateway_routes",
            &self.expected_internet_gateway_routes,
        );
        formatter.field(
            "actual_internet_gateway_routes",
            &self.actual_internet_gateway_routes,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`NetworkFirewallInvalidRouteConfigurationViolation`](crate::model::NetworkFirewallInvalidRouteConfigurationViolation)
pub mod network_firewall_invalid_route_configuration_violation {
    /// A builder for [`NetworkFirewallInvalidRouteConfigurationViolation`](crate::model::NetworkFirewallInvalidRouteConfigurationViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) affected_subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
        pub(crate) is_route_table_used_in_different_az: std::option::Option<bool>,
        pub(crate) violating_route: std::option::Option<crate::model::Route>,
        pub(crate) current_firewall_subnet_route_table: std::option::Option<std::string::String>,
        pub(crate) expected_firewall_endpoint: std::option::Option<std::string::String>,
        pub(crate) actual_firewall_endpoint: std::option::Option<std::string::String>,
        pub(crate) expected_firewall_subnet_id: std::option::Option<std::string::String>,
        pub(crate) actual_firewall_subnet_id: std::option::Option<std::string::String>,
        pub(crate) expected_firewall_subnet_routes:
            std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        pub(crate) actual_firewall_subnet_routes:
            std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) internet_gateway_id: std::option::Option<std::string::String>,
        pub(crate) current_internet_gateway_route_table: std::option::Option<std::string::String>,
        pub(crate) expected_internet_gateway_routes:
            std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        pub(crate) actual_internet_gateway_routes:
            std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `affected_subnets`.
        ///
        /// To override the contents of this collection use [`set_affected_subnets`](Self::set_affected_subnets).
        ///
        /// <p>The subnets that are affected.</p>
        pub fn affected_subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.affected_subnets.unwrap_or_default();
            v.push(input.into());
            self.affected_subnets = Some(v);
            self
        }
        /// <p>The subnets that are affected.</p>
        pub fn set_affected_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.affected_subnets = input;
            self
        }
        /// <p>The route table ID.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>The route table ID.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// <p>Information about whether the route table is used in another Availability Zone.</p>
        pub fn is_route_table_used_in_different_az(mut self, input: bool) -> Self {
            self.is_route_table_used_in_different_az = Some(input);
            self
        }
        /// <p>Information about whether the route table is used in another Availability Zone.</p>
        pub fn set_is_route_table_used_in_different_az(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_route_table_used_in_different_az = input;
            self
        }
        /// <p>The route that's in violation.</p>
        pub fn violating_route(mut self, input: crate::model::Route) -> Self {
            self.violating_route = Some(input);
            self
        }
        /// <p>The route that's in violation.</p>
        pub fn set_violating_route(
            mut self,
            input: std::option::Option<crate::model::Route>,
        ) -> Self {
            self.violating_route = input;
            self
        }
        /// <p>The subnet route table for the current firewall.</p>
        pub fn current_firewall_subnet_route_table(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_firewall_subnet_route_table = Some(input.into());
            self
        }
        /// <p>The subnet route table for the current firewall.</p>
        pub fn set_current_firewall_subnet_route_table(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_firewall_subnet_route_table = input;
            self
        }
        /// <p>The firewall endpoint that's expected.</p>
        pub fn expected_firewall_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_firewall_endpoint = Some(input.into());
            self
        }
        /// <p>The firewall endpoint that's expected.</p>
        pub fn set_expected_firewall_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_firewall_endpoint = input;
            self
        }
        /// <p>The actual firewall endpoint.</p>
        pub fn actual_firewall_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.actual_firewall_endpoint = Some(input.into());
            self
        }
        /// <p>The actual firewall endpoint.</p>
        pub fn set_actual_firewall_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.actual_firewall_endpoint = input;
            self
        }
        /// <p>The expected subnet ID for the firewall.</p>
        pub fn expected_firewall_subnet_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.expected_firewall_subnet_id = Some(input.into());
            self
        }
        /// <p>The expected subnet ID for the firewall.</p>
        pub fn set_expected_firewall_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_firewall_subnet_id = input;
            self
        }
        /// <p>The actual subnet ID for the firewall.</p>
        pub fn actual_firewall_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.actual_firewall_subnet_id = Some(input.into());
            self
        }
        /// <p>The actual subnet ID for the firewall.</p>
        pub fn set_actual_firewall_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.actual_firewall_subnet_id = input;
            self
        }
        /// Appends an item to `expected_firewall_subnet_routes`.
        ///
        /// To override the contents of this collection use [`set_expected_firewall_subnet_routes`](Self::set_expected_firewall_subnet_routes).
        ///
        /// <p>The firewall subnet routes that are expected.</p>
        pub fn expected_firewall_subnet_routes(
            mut self,
            input: crate::model::ExpectedRoute,
        ) -> Self {
            let mut v = self.expected_firewall_subnet_routes.unwrap_or_default();
            v.push(input);
            self.expected_firewall_subnet_routes = Some(v);
            self
        }
        /// <p>The firewall subnet routes that are expected.</p>
        pub fn set_expected_firewall_subnet_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        ) -> Self {
            self.expected_firewall_subnet_routes = input;
            self
        }
        /// Appends an item to `actual_firewall_subnet_routes`.
        ///
        /// To override the contents of this collection use [`set_actual_firewall_subnet_routes`](Self::set_actual_firewall_subnet_routes).
        ///
        /// <p>The actual firewall subnet routes that are expected.</p>
        pub fn actual_firewall_subnet_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.actual_firewall_subnet_routes.unwrap_or_default();
            v.push(input);
            self.actual_firewall_subnet_routes = Some(v);
            self
        }
        /// <p>The actual firewall subnet routes that are expected.</p>
        pub fn set_actual_firewall_subnet_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.actual_firewall_subnet_routes = input;
            self
        }
        /// <p>The internet gateway ID.</p>
        pub fn internet_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.internet_gateway_id = Some(input.into());
            self
        }
        /// <p>The internet gateway ID.</p>
        pub fn set_internet_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.internet_gateway_id = input;
            self
        }
        /// <p>The route table for the current internet gateway.</p>
        pub fn current_internet_gateway_route_table(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_internet_gateway_route_table = Some(input.into());
            self
        }
        /// <p>The route table for the current internet gateway.</p>
        pub fn set_current_internet_gateway_route_table(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_internet_gateway_route_table = input;
            self
        }
        /// Appends an item to `expected_internet_gateway_routes`.
        ///
        /// To override the contents of this collection use [`set_expected_internet_gateway_routes`](Self::set_expected_internet_gateway_routes).
        ///
        /// <p>The expected routes for the internet gateway.</p>
        pub fn expected_internet_gateway_routes(
            mut self,
            input: crate::model::ExpectedRoute,
        ) -> Self {
            let mut v = self.expected_internet_gateway_routes.unwrap_or_default();
            v.push(input);
            self.expected_internet_gateway_routes = Some(v);
            self
        }
        /// <p>The expected routes for the internet gateway.</p>
        pub fn set_expected_internet_gateway_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        ) -> Self {
            self.expected_internet_gateway_routes = input;
            self
        }
        /// Appends an item to `actual_internet_gateway_routes`.
        ///
        /// To override the contents of this collection use [`set_actual_internet_gateway_routes`](Self::set_actual_internet_gateway_routes).
        ///
        /// <p>The actual internet gateway routes.</p>
        pub fn actual_internet_gateway_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.actual_internet_gateway_routes.unwrap_or_default();
            v.push(input);
            self.actual_internet_gateway_routes = Some(v);
            self
        }
        /// <p>The actual internet gateway routes.</p>
        pub fn set_actual_internet_gateway_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.actual_internet_gateway_routes = input;
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallInvalidRouteConfigurationViolation`](crate::model::NetworkFirewallInvalidRouteConfigurationViolation)
        pub fn build(self) -> crate::model::NetworkFirewallInvalidRouteConfigurationViolation {
            crate::model::NetworkFirewallInvalidRouteConfigurationViolation {
                affected_subnets: self.affected_subnets,
                route_table_id: self.route_table_id,
                is_route_table_used_in_different_az: self
                    .is_route_table_used_in_different_az
                    .unwrap_or_default(),
                violating_route: self.violating_route,
                current_firewall_subnet_route_table: self.current_firewall_subnet_route_table,
                expected_firewall_endpoint: self.expected_firewall_endpoint,
                actual_firewall_endpoint: self.actual_firewall_endpoint,
                expected_firewall_subnet_id: self.expected_firewall_subnet_id,
                actual_firewall_subnet_id: self.actual_firewall_subnet_id,
                expected_firewall_subnet_routes: self.expected_firewall_subnet_routes,
                actual_firewall_subnet_routes: self.actual_firewall_subnet_routes,
                internet_gateway_id: self.internet_gateway_id,
                current_internet_gateway_route_table: self.current_internet_gateway_route_table,
                expected_internet_gateway_routes: self.expected_internet_gateway_routes,
                actual_internet_gateway_routes: self.actual_internet_gateway_routes,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl NetworkFirewallInvalidRouteConfigurationViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallInvalidRouteConfigurationViolation`](crate::model::NetworkFirewallInvalidRouteConfigurationViolation)
    pub fn builder() -> crate::model::network_firewall_invalid_route_configuration_violation::Builder
    {
        crate::model::network_firewall_invalid_route_configuration_violation::Builder::default()
    }
}

/// <p>Violation detail for the subnet for which internet traffic that hasn't been inspected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallInternetTrafficNotInspectedViolation {
    /// <p>The subnet ID.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The subnet Availability Zone.</p>
    pub subnet_availability_zone: std::option::Option<std::string::String>,
    /// <p>Information about the route table ID.</p>
    pub route_table_id: std::option::Option<std::string::String>,
    /// <p>The route or routes that are in violation.</p>
    pub violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>Information about whether the route table is used in another Availability Zone.</p>
    pub is_route_table_used_in_different_az: bool,
    /// <p>Information about the subnet route table for the current firewall.</p>
    pub current_firewall_subnet_route_table: std::option::Option<std::string::String>,
    /// <p>The expected endpoint for the current firewall.</p>
    pub expected_firewall_endpoint: std::option::Option<std::string::String>,
    /// <p>The firewall subnet ID.</p>
    pub firewall_subnet_id: std::option::Option<std::string::String>,
    /// <p>The firewall subnet routes that are expected.</p>
    pub expected_firewall_subnet_routes:
        std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
    /// <p>The actual firewall subnet routes.</p>
    pub actual_firewall_subnet_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>The internet gateway ID.</p>
    pub internet_gateway_id: std::option::Option<std::string::String>,
    /// <p>The current route table for the internet gateway.</p>
    pub current_internet_gateway_route_table: std::option::Option<std::string::String>,
    /// <p>The internet gateway routes that are expected.</p>
    pub expected_internet_gateway_routes:
        std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
    /// <p>The actual internet gateway routes.</p>
    pub actual_internet_gateway_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
    /// <p>Information about the VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl NetworkFirewallInternetTrafficNotInspectedViolation {
    /// <p>The subnet ID.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The subnet Availability Zone.</p>
    pub fn subnet_availability_zone(&self) -> std::option::Option<&str> {
        self.subnet_availability_zone.as_deref()
    }
    /// <p>Information about the route table ID.</p>
    pub fn route_table_id(&self) -> std::option::Option<&str> {
        self.route_table_id.as_deref()
    }
    /// <p>The route or routes that are in violation.</p>
    pub fn violating_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.violating_routes.as_deref()
    }
    /// <p>Information about whether the route table is used in another Availability Zone.</p>
    pub fn is_route_table_used_in_different_az(&self) -> bool {
        self.is_route_table_used_in_different_az
    }
    /// <p>Information about the subnet route table for the current firewall.</p>
    pub fn current_firewall_subnet_route_table(&self) -> std::option::Option<&str> {
        self.current_firewall_subnet_route_table.as_deref()
    }
    /// <p>The expected endpoint for the current firewall.</p>
    pub fn expected_firewall_endpoint(&self) -> std::option::Option<&str> {
        self.expected_firewall_endpoint.as_deref()
    }
    /// <p>The firewall subnet ID.</p>
    pub fn firewall_subnet_id(&self) -> std::option::Option<&str> {
        self.firewall_subnet_id.as_deref()
    }
    /// <p>The firewall subnet routes that are expected.</p>
    pub fn expected_firewall_subnet_routes(
        &self,
    ) -> std::option::Option<&[crate::model::ExpectedRoute]> {
        self.expected_firewall_subnet_routes.as_deref()
    }
    /// <p>The actual firewall subnet routes.</p>
    pub fn actual_firewall_subnet_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.actual_firewall_subnet_routes.as_deref()
    }
    /// <p>The internet gateway ID.</p>
    pub fn internet_gateway_id(&self) -> std::option::Option<&str> {
        self.internet_gateway_id.as_deref()
    }
    /// <p>The current route table for the internet gateway.</p>
    pub fn current_internet_gateway_route_table(&self) -> std::option::Option<&str> {
        self.current_internet_gateway_route_table.as_deref()
    }
    /// <p>The internet gateway routes that are expected.</p>
    pub fn expected_internet_gateway_routes(
        &self,
    ) -> std::option::Option<&[crate::model::ExpectedRoute]> {
        self.expected_internet_gateway_routes.as_deref()
    }
    /// <p>The actual internet gateway routes.</p>
    pub fn actual_internet_gateway_routes(&self) -> std::option::Option<&[crate::model::Route]> {
        self.actual_internet_gateway_routes.as_deref()
    }
    /// <p>Information about the VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallInternetTrafficNotInspectedViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallInternetTrafficNotInspectedViolation");
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.field("route_table_id", &self.route_table_id);
        formatter.field("violating_routes", &self.violating_routes);
        formatter.field(
            "is_route_table_used_in_different_az",
            &self.is_route_table_used_in_different_az,
        );
        formatter.field(
            "current_firewall_subnet_route_table",
            &self.current_firewall_subnet_route_table,
        );
        formatter.field(
            "expected_firewall_endpoint",
            &self.expected_firewall_endpoint,
        );
        formatter.field("firewall_subnet_id", &self.firewall_subnet_id);
        formatter.field(
            "expected_firewall_subnet_routes",
            &self.expected_firewall_subnet_routes,
        );
        formatter.field(
            "actual_firewall_subnet_routes",
            &self.actual_firewall_subnet_routes,
        );
        formatter.field("internet_gateway_id", &self.internet_gateway_id);
        formatter.field(
            "current_internet_gateway_route_table",
            &self.current_internet_gateway_route_table,
        );
        formatter.field(
            "expected_internet_gateway_routes",
            &self.expected_internet_gateway_routes,
        );
        formatter.field(
            "actual_internet_gateway_routes",
            &self.actual_internet_gateway_routes,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`NetworkFirewallInternetTrafficNotInspectedViolation`](crate::model::NetworkFirewallInternetTrafficNotInspectedViolation)
pub mod network_firewall_internet_traffic_not_inspected_violation {
    /// A builder for [`NetworkFirewallInternetTrafficNotInspectedViolation`](crate::model::NetworkFirewallInternetTrafficNotInspectedViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<std::string::String>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
        pub(crate) violating_routes: std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) is_route_table_used_in_different_az: std::option::Option<bool>,
        pub(crate) current_firewall_subnet_route_table: std::option::Option<std::string::String>,
        pub(crate) expected_firewall_endpoint: std::option::Option<std::string::String>,
        pub(crate) firewall_subnet_id: std::option::Option<std::string::String>,
        pub(crate) expected_firewall_subnet_routes:
            std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        pub(crate) actual_firewall_subnet_routes:
            std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) internet_gateway_id: std::option::Option<std::string::String>,
        pub(crate) current_internet_gateway_route_table: std::option::Option<std::string::String>,
        pub(crate) expected_internet_gateway_routes:
            std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        pub(crate) actual_internet_gateway_routes:
            std::option::Option<std::vec::Vec<crate::model::Route>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subnet ID.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The subnet Availability Zone.</p>
        pub fn subnet_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_availability_zone = Some(input.into());
            self
        }
        /// <p>The subnet Availability Zone.</p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// <p>Information about the route table ID.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>Information about the route table ID.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// Appends an item to `violating_routes`.
        ///
        /// To override the contents of this collection use [`set_violating_routes`](Self::set_violating_routes).
        ///
        /// <p>The route or routes that are in violation.</p>
        pub fn violating_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.violating_routes.unwrap_or_default();
            v.push(input);
            self.violating_routes = Some(v);
            self
        }
        /// <p>The route or routes that are in violation.</p>
        pub fn set_violating_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.violating_routes = input;
            self
        }
        /// <p>Information about whether the route table is used in another Availability Zone.</p>
        pub fn is_route_table_used_in_different_az(mut self, input: bool) -> Self {
            self.is_route_table_used_in_different_az = Some(input);
            self
        }
        /// <p>Information about whether the route table is used in another Availability Zone.</p>
        pub fn set_is_route_table_used_in_different_az(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_route_table_used_in_different_az = input;
            self
        }
        /// <p>Information about the subnet route table for the current firewall.</p>
        pub fn current_firewall_subnet_route_table(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_firewall_subnet_route_table = Some(input.into());
            self
        }
        /// <p>Information about the subnet route table for the current firewall.</p>
        pub fn set_current_firewall_subnet_route_table(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_firewall_subnet_route_table = input;
            self
        }
        /// <p>The expected endpoint for the current firewall.</p>
        pub fn expected_firewall_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_firewall_endpoint = Some(input.into());
            self
        }
        /// <p>The expected endpoint for the current firewall.</p>
        pub fn set_expected_firewall_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_firewall_endpoint = input;
            self
        }
        /// <p>The firewall subnet ID.</p>
        pub fn firewall_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_subnet_id = Some(input.into());
            self
        }
        /// <p>The firewall subnet ID.</p>
        pub fn set_firewall_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_subnet_id = input;
            self
        }
        /// Appends an item to `expected_firewall_subnet_routes`.
        ///
        /// To override the contents of this collection use [`set_expected_firewall_subnet_routes`](Self::set_expected_firewall_subnet_routes).
        ///
        /// <p>The firewall subnet routes that are expected.</p>
        pub fn expected_firewall_subnet_routes(
            mut self,
            input: crate::model::ExpectedRoute,
        ) -> Self {
            let mut v = self.expected_firewall_subnet_routes.unwrap_or_default();
            v.push(input);
            self.expected_firewall_subnet_routes = Some(v);
            self
        }
        /// <p>The firewall subnet routes that are expected.</p>
        pub fn set_expected_firewall_subnet_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        ) -> Self {
            self.expected_firewall_subnet_routes = input;
            self
        }
        /// Appends an item to `actual_firewall_subnet_routes`.
        ///
        /// To override the contents of this collection use [`set_actual_firewall_subnet_routes`](Self::set_actual_firewall_subnet_routes).
        ///
        /// <p>The actual firewall subnet routes.</p>
        pub fn actual_firewall_subnet_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.actual_firewall_subnet_routes.unwrap_or_default();
            v.push(input);
            self.actual_firewall_subnet_routes = Some(v);
            self
        }
        /// <p>The actual firewall subnet routes.</p>
        pub fn set_actual_firewall_subnet_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.actual_firewall_subnet_routes = input;
            self
        }
        /// <p>The internet gateway ID.</p>
        pub fn internet_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.internet_gateway_id = Some(input.into());
            self
        }
        /// <p>The internet gateway ID.</p>
        pub fn set_internet_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.internet_gateway_id = input;
            self
        }
        /// <p>The current route table for the internet gateway.</p>
        pub fn current_internet_gateway_route_table(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_internet_gateway_route_table = Some(input.into());
            self
        }
        /// <p>The current route table for the internet gateway.</p>
        pub fn set_current_internet_gateway_route_table(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_internet_gateway_route_table = input;
            self
        }
        /// Appends an item to `expected_internet_gateway_routes`.
        ///
        /// To override the contents of this collection use [`set_expected_internet_gateway_routes`](Self::set_expected_internet_gateway_routes).
        ///
        /// <p>The internet gateway routes that are expected.</p>
        pub fn expected_internet_gateway_routes(
            mut self,
            input: crate::model::ExpectedRoute,
        ) -> Self {
            let mut v = self.expected_internet_gateway_routes.unwrap_or_default();
            v.push(input);
            self.expected_internet_gateway_routes = Some(v);
            self
        }
        /// <p>The internet gateway routes that are expected.</p>
        pub fn set_expected_internet_gateway_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpectedRoute>>,
        ) -> Self {
            self.expected_internet_gateway_routes = input;
            self
        }
        /// Appends an item to `actual_internet_gateway_routes`.
        ///
        /// To override the contents of this collection use [`set_actual_internet_gateway_routes`](Self::set_actual_internet_gateway_routes).
        ///
        /// <p>The actual internet gateway routes.</p>
        pub fn actual_internet_gateway_routes(mut self, input: crate::model::Route) -> Self {
            let mut v = self.actual_internet_gateway_routes.unwrap_or_default();
            v.push(input);
            self.actual_internet_gateway_routes = Some(v);
            self
        }
        /// <p>The actual internet gateway routes.</p>
        pub fn set_actual_internet_gateway_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Route>>,
        ) -> Self {
            self.actual_internet_gateway_routes = input;
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Information about the VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallInternetTrafficNotInspectedViolation`](crate::model::NetworkFirewallInternetTrafficNotInspectedViolation)
        pub fn build(self) -> crate::model::NetworkFirewallInternetTrafficNotInspectedViolation {
            crate::model::NetworkFirewallInternetTrafficNotInspectedViolation {
                subnet_id: self.subnet_id,
                subnet_availability_zone: self.subnet_availability_zone,
                route_table_id: self.route_table_id,
                violating_routes: self.violating_routes,
                is_route_table_used_in_different_az: self
                    .is_route_table_used_in_different_az
                    .unwrap_or_default(),
                current_firewall_subnet_route_table: self.current_firewall_subnet_route_table,
                expected_firewall_endpoint: self.expected_firewall_endpoint,
                firewall_subnet_id: self.firewall_subnet_id,
                expected_firewall_subnet_routes: self.expected_firewall_subnet_routes,
                actual_firewall_subnet_routes: self.actual_firewall_subnet_routes,
                internet_gateway_id: self.internet_gateway_id,
                current_internet_gateway_route_table: self.current_internet_gateway_route_table,
                expected_internet_gateway_routes: self.expected_internet_gateway_routes,
                actual_internet_gateway_routes: self.actual_internet_gateway_routes,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl NetworkFirewallInternetTrafficNotInspectedViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallInternetTrafficNotInspectedViolation`](crate::model::NetworkFirewallInternetTrafficNotInspectedViolation)
    pub fn builder(
    ) -> crate::model::network_firewall_internet_traffic_not_inspected_violation::Builder {
        crate::model::network_firewall_internet_traffic_not_inspected_violation::Builder::default()
    }
}

/// <p>Violation detail for Network Firewall for a firewall policy that has a different <code>NetworkFirewallPolicyDescription</code> than is required by the Firewall Manager policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallPolicyModifiedViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>The policy that's currently in use in the individual account. </p>
    pub current_policy_description:
        std::option::Option<crate::model::NetworkFirewallPolicyDescription>,
    /// <p>The policy that should be in use in the individual account in order to be compliant. </p>
    pub expected_policy_description:
        std::option::Option<crate::model::NetworkFirewallPolicyDescription>,
}
impl NetworkFirewallPolicyModifiedViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>The policy that's currently in use in the individual account. </p>
    pub fn current_policy_description(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallPolicyDescription> {
        self.current_policy_description.as_ref()
    }
    /// <p>The policy that should be in use in the individual account in order to be compliant. </p>
    pub fn expected_policy_description(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFirewallPolicyDescription> {
        self.expected_policy_description.as_ref()
    }
}
impl std::fmt::Debug for NetworkFirewallPolicyModifiedViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallPolicyModifiedViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field(
            "current_policy_description",
            &self.current_policy_description,
        );
        formatter.field(
            "expected_policy_description",
            &self.expected_policy_description,
        );
        formatter.finish()
    }
}
/// See [`NetworkFirewallPolicyModifiedViolation`](crate::model::NetworkFirewallPolicyModifiedViolation)
pub mod network_firewall_policy_modified_violation {
    /// A builder for [`NetworkFirewallPolicyModifiedViolation`](crate::model::NetworkFirewallPolicyModifiedViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) current_policy_description:
            std::option::Option<crate::model::NetworkFirewallPolicyDescription>,
        pub(crate) expected_policy_description:
            std::option::Option<crate::model::NetworkFirewallPolicyDescription>,
    }
    impl Builder {
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>The policy that's currently in use in the individual account. </p>
        pub fn current_policy_description(
            mut self,
            input: crate::model::NetworkFirewallPolicyDescription,
        ) -> Self {
            self.current_policy_description = Some(input);
            self
        }
        /// <p>The policy that's currently in use in the individual account. </p>
        pub fn set_current_policy_description(
            mut self,
            input: std::option::Option<crate::model::NetworkFirewallPolicyDescription>,
        ) -> Self {
            self.current_policy_description = input;
            self
        }
        /// <p>The policy that should be in use in the individual account in order to be compliant. </p>
        pub fn expected_policy_description(
            mut self,
            input: crate::model::NetworkFirewallPolicyDescription,
        ) -> Self {
            self.expected_policy_description = Some(input);
            self
        }
        /// <p>The policy that should be in use in the individual account in order to be compliant. </p>
        pub fn set_expected_policy_description(
            mut self,
            input: std::option::Option<crate::model::NetworkFirewallPolicyDescription>,
        ) -> Self {
            self.expected_policy_description = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallPolicyModifiedViolation`](crate::model::NetworkFirewallPolicyModifiedViolation)
        pub fn build(self) -> crate::model::NetworkFirewallPolicyModifiedViolation {
            crate::model::NetworkFirewallPolicyModifiedViolation {
                violation_target: self.violation_target,
                current_policy_description: self.current_policy_description,
                expected_policy_description: self.expected_policy_description,
            }
        }
    }
}
impl NetworkFirewallPolicyModifiedViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallPolicyModifiedViolation`](crate::model::NetworkFirewallPolicyModifiedViolation)
    pub fn builder() -> crate::model::network_firewall_policy_modified_violation::Builder {
        crate::model::network_firewall_policy_modified_violation::Builder::default()
    }
}

/// <p>The definition of the Network Firewall firewall policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallPolicyDescription {
    /// <p>The stateless rule groups that are used in the Network Firewall firewall policy. </p>
    pub stateless_rule_groups: std::option::Option<std::vec::Vec<crate::model::StatelessRuleGroup>>,
    /// <p>The actions to take on packets that don't match any of the stateless rule groups. </p>
    pub stateless_default_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The actions to take on packet fragments that don't match any of the stateless rule groups. </p>
    pub stateless_fragment_default_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Names of custom actions that are available for use in the stateless default actions settings.</p>
    pub stateless_custom_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The stateful rule groups that are used in the Network Firewall firewall policy. </p>
    pub stateful_rule_groups: std::option::Option<std::vec::Vec<crate::model::StatefulRuleGroup>>,
}
impl NetworkFirewallPolicyDescription {
    /// <p>The stateless rule groups that are used in the Network Firewall firewall policy. </p>
    pub fn stateless_rule_groups(
        &self,
    ) -> std::option::Option<&[crate::model::StatelessRuleGroup]> {
        self.stateless_rule_groups.as_deref()
    }
    /// <p>The actions to take on packets that don't match any of the stateless rule groups. </p>
    pub fn stateless_default_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.stateless_default_actions.as_deref()
    }
    /// <p>The actions to take on packet fragments that don't match any of the stateless rule groups. </p>
    pub fn stateless_fragment_default_actions(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.stateless_fragment_default_actions.as_deref()
    }
    /// <p>Names of custom actions that are available for use in the stateless default actions settings.</p>
    pub fn stateless_custom_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.stateless_custom_actions.as_deref()
    }
    /// <p>The stateful rule groups that are used in the Network Firewall firewall policy. </p>
    pub fn stateful_rule_groups(&self) -> std::option::Option<&[crate::model::StatefulRuleGroup]> {
        self.stateful_rule_groups.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallPolicyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallPolicyDescription");
        formatter.field("stateless_rule_groups", &self.stateless_rule_groups);
        formatter.field("stateless_default_actions", &self.stateless_default_actions);
        formatter.field(
            "stateless_fragment_default_actions",
            &self.stateless_fragment_default_actions,
        );
        formatter.field("stateless_custom_actions", &self.stateless_custom_actions);
        formatter.field("stateful_rule_groups", &self.stateful_rule_groups);
        formatter.finish()
    }
}
/// See [`NetworkFirewallPolicyDescription`](crate::model::NetworkFirewallPolicyDescription)
pub mod network_firewall_policy_description {
    /// A builder for [`NetworkFirewallPolicyDescription`](crate::model::NetworkFirewallPolicyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stateless_rule_groups:
            std::option::Option<std::vec::Vec<crate::model::StatelessRuleGroup>>,
        pub(crate) stateless_default_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stateless_fragment_default_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stateless_custom_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stateful_rule_groups:
            std::option::Option<std::vec::Vec<crate::model::StatefulRuleGroup>>,
    }
    impl Builder {
        /// Appends an item to `stateless_rule_groups`.
        ///
        /// To override the contents of this collection use [`set_stateless_rule_groups`](Self::set_stateless_rule_groups).
        ///
        /// <p>The stateless rule groups that are used in the Network Firewall firewall policy. </p>
        pub fn stateless_rule_groups(mut self, input: crate::model::StatelessRuleGroup) -> Self {
            let mut v = self.stateless_rule_groups.unwrap_or_default();
            v.push(input);
            self.stateless_rule_groups = Some(v);
            self
        }
        /// <p>The stateless rule groups that are used in the Network Firewall firewall policy. </p>
        pub fn set_stateless_rule_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatelessRuleGroup>>,
        ) -> Self {
            self.stateless_rule_groups = input;
            self
        }
        /// Appends an item to `stateless_default_actions`.
        ///
        /// To override the contents of this collection use [`set_stateless_default_actions`](Self::set_stateless_default_actions).
        ///
        /// <p>The actions to take on packets that don't match any of the stateless rule groups. </p>
        pub fn stateless_default_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stateless_default_actions.unwrap_or_default();
            v.push(input.into());
            self.stateless_default_actions = Some(v);
            self
        }
        /// <p>The actions to take on packets that don't match any of the stateless rule groups. </p>
        pub fn set_stateless_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stateless_default_actions = input;
            self
        }
        /// Appends an item to `stateless_fragment_default_actions`.
        ///
        /// To override the contents of this collection use [`set_stateless_fragment_default_actions`](Self::set_stateless_fragment_default_actions).
        ///
        /// <p>The actions to take on packet fragments that don't match any of the stateless rule groups. </p>
        pub fn stateless_fragment_default_actions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.stateless_fragment_default_actions.unwrap_or_default();
            v.push(input.into());
            self.stateless_fragment_default_actions = Some(v);
            self
        }
        /// <p>The actions to take on packet fragments that don't match any of the stateless rule groups. </p>
        pub fn set_stateless_fragment_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stateless_fragment_default_actions = input;
            self
        }
        /// Appends an item to `stateless_custom_actions`.
        ///
        /// To override the contents of this collection use [`set_stateless_custom_actions`](Self::set_stateless_custom_actions).
        ///
        /// <p>Names of custom actions that are available for use in the stateless default actions settings.</p>
        pub fn stateless_custom_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stateless_custom_actions.unwrap_or_default();
            v.push(input.into());
            self.stateless_custom_actions = Some(v);
            self
        }
        /// <p>Names of custom actions that are available for use in the stateless default actions settings.</p>
        pub fn set_stateless_custom_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stateless_custom_actions = input;
            self
        }
        /// Appends an item to `stateful_rule_groups`.
        ///
        /// To override the contents of this collection use [`set_stateful_rule_groups`](Self::set_stateful_rule_groups).
        ///
        /// <p>The stateful rule groups that are used in the Network Firewall firewall policy. </p>
        pub fn stateful_rule_groups(mut self, input: crate::model::StatefulRuleGroup) -> Self {
            let mut v = self.stateful_rule_groups.unwrap_or_default();
            v.push(input);
            self.stateful_rule_groups = Some(v);
            self
        }
        /// <p>The stateful rule groups that are used in the Network Firewall firewall policy. </p>
        pub fn set_stateful_rule_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatefulRuleGroup>>,
        ) -> Self {
            self.stateful_rule_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallPolicyDescription`](crate::model::NetworkFirewallPolicyDescription)
        pub fn build(self) -> crate::model::NetworkFirewallPolicyDescription {
            crate::model::NetworkFirewallPolicyDescription {
                stateless_rule_groups: self.stateless_rule_groups,
                stateless_default_actions: self.stateless_default_actions,
                stateless_fragment_default_actions: self.stateless_fragment_default_actions,
                stateless_custom_actions: self.stateless_custom_actions,
                stateful_rule_groups: self.stateful_rule_groups,
            }
        }
    }
}
impl NetworkFirewallPolicyDescription {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallPolicyDescription`](crate::model::NetworkFirewallPolicyDescription)
    pub fn builder() -> crate::model::network_firewall_policy_description::Builder {
        crate::model::network_firewall_policy_description::Builder::default()
    }
}

/// <p>Network Firewall stateful rule group, used in a <code>NetworkFirewallPolicyDescription</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatefulRuleGroup {
    /// <p>The name of the rule group.</p>
    pub rule_group_name: std::option::Option<std::string::String>,
    /// <p>The resource ID of the rule group.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl StatefulRuleGroup {
    /// <p>The name of the rule group.</p>
    pub fn rule_group_name(&self) -> std::option::Option<&str> {
        self.rule_group_name.as_deref()
    }
    /// <p>The resource ID of the rule group.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for StatefulRuleGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatefulRuleGroup");
        formatter.field("rule_group_name", &self.rule_group_name);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
/// See [`StatefulRuleGroup`](crate::model::StatefulRuleGroup)
pub mod stateful_rule_group {
    /// A builder for [`StatefulRuleGroup`](crate::model::StatefulRuleGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group_name: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule group.</p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_name = Some(input.into());
            self
        }
        /// <p>The name of the rule group.</p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_name = input;
            self
        }
        /// <p>The resource ID of the rule group.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the rule group.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StatefulRuleGroup`](crate::model::StatefulRuleGroup)
        pub fn build(self) -> crate::model::StatefulRuleGroup {
            crate::model::StatefulRuleGroup {
                rule_group_name: self.rule_group_name,
                resource_id: self.resource_id,
            }
        }
    }
}
impl StatefulRuleGroup {
    /// Creates a new builder-style object to manufacture [`StatefulRuleGroup`](crate::model::StatefulRuleGroup)
    pub fn builder() -> crate::model::stateful_rule_group::Builder {
        crate::model::stateful_rule_group::Builder::default()
    }
}

/// <p>Network Firewall stateless rule group, used in a <code>NetworkFirewallPolicyDescription</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatelessRuleGroup {
    /// <p>The name of the rule group.</p>
    pub rule_group_name: std::option::Option<std::string::String>,
    /// <p>The resource ID of the rule group.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The priority of the rule group. Network Firewall evaluates the stateless rule groups in a firewall policy starting from the lowest priority setting. </p>
    pub priority: i32,
}
impl StatelessRuleGroup {
    /// <p>The name of the rule group.</p>
    pub fn rule_group_name(&self) -> std::option::Option<&str> {
        self.rule_group_name.as_deref()
    }
    /// <p>The resource ID of the rule group.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The priority of the rule group. Network Firewall evaluates the stateless rule groups in a firewall policy starting from the lowest priority setting. </p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
}
impl std::fmt::Debug for StatelessRuleGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatelessRuleGroup");
        formatter.field("rule_group_name", &self.rule_group_name);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`StatelessRuleGroup`](crate::model::StatelessRuleGroup)
pub mod stateless_rule_group {
    /// A builder for [`StatelessRuleGroup`](crate::model::StatelessRuleGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group_name: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the rule group.</p>
        pub fn rule_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_name = Some(input.into());
            self
        }
        /// <p>The name of the rule group.</p>
        pub fn set_rule_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_name = input;
            self
        }
        /// <p>The resource ID of the rule group.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the rule group.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The priority of the rule group. Network Firewall evaluates the stateless rule groups in a firewall policy starting from the lowest priority setting. </p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority of the rule group. Network Firewall evaluates the stateless rule groups in a firewall policy starting from the lowest priority setting. </p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`StatelessRuleGroup`](crate::model::StatelessRuleGroup)
        pub fn build(self) -> crate::model::StatelessRuleGroup {
            crate::model::StatelessRuleGroup {
                rule_group_name: self.rule_group_name,
                resource_id: self.resource_id,
                priority: self.priority.unwrap_or_default(),
            }
        }
    }
}
impl StatelessRuleGroup {
    /// Creates a new builder-style object to manufacture [`StatelessRuleGroup`](crate::model::StatelessRuleGroup)
    pub fn builder() -> crate::model::stateless_rule_group::Builder {
        crate::model::stateless_rule_group::Builder::default()
    }
}

/// <p>Violation detail for Network Firewall for a subnet that's not associated to the expected Firewall Manager managed route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallMissingExpectedRtViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>The resource ID of the VPC associated with a violating subnet.</p>
    pub vpc: std::option::Option<std::string::String>,
    /// <p>The Availability Zone of a violating subnet. </p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The resource ID of the current route table that's associated with the subnet, if one is available.</p>
    pub current_route_table: std::option::Option<std::string::String>,
    /// <p>The resource ID of the route table that should be associated with the subnet.</p>
    pub expected_route_table: std::option::Option<std::string::String>,
}
impl NetworkFirewallMissingExpectedRtViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>The resource ID of the VPC associated with a violating subnet.</p>
    pub fn vpc(&self) -> std::option::Option<&str> {
        self.vpc.as_deref()
    }
    /// <p>The Availability Zone of a violating subnet. </p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The resource ID of the current route table that's associated with the subnet, if one is available.</p>
    pub fn current_route_table(&self) -> std::option::Option<&str> {
        self.current_route_table.as_deref()
    }
    /// <p>The resource ID of the route table that should be associated with the subnet.</p>
    pub fn expected_route_table(&self) -> std::option::Option<&str> {
        self.expected_route_table.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallMissingExpectedRtViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallMissingExpectedRtViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field("vpc", &self.vpc);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("current_route_table", &self.current_route_table);
        formatter.field("expected_route_table", &self.expected_route_table);
        formatter.finish()
    }
}
/// See [`NetworkFirewallMissingExpectedRtViolation`](crate::model::NetworkFirewallMissingExpectedRtViolation)
pub mod network_firewall_missing_expected_rt_violation {
    /// A builder for [`NetworkFirewallMissingExpectedRtViolation`](crate::model::NetworkFirewallMissingExpectedRtViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) current_route_table: std::option::Option<std::string::String>,
        pub(crate) expected_route_table: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>The resource ID of the VPC associated with a violating subnet.</p>
        pub fn vpc(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc = Some(input.into());
            self
        }
        /// <p>The resource ID of the VPC associated with a violating subnet.</p>
        pub fn set_vpc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>The Availability Zone of a violating subnet. </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone of a violating subnet. </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The resource ID of the current route table that's associated with the subnet, if one is available.</p>
        pub fn current_route_table(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_route_table = Some(input.into());
            self
        }
        /// <p>The resource ID of the current route table that's associated with the subnet, if one is available.</p>
        pub fn set_current_route_table(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_route_table = input;
            self
        }
        /// <p>The resource ID of the route table that should be associated with the subnet.</p>
        pub fn expected_route_table(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_route_table = Some(input.into());
            self
        }
        /// <p>The resource ID of the route table that should be associated with the subnet.</p>
        pub fn set_expected_route_table(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_route_table = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallMissingExpectedRtViolation`](crate::model::NetworkFirewallMissingExpectedRtViolation)
        pub fn build(self) -> crate::model::NetworkFirewallMissingExpectedRtViolation {
            crate::model::NetworkFirewallMissingExpectedRtViolation {
                violation_target: self.violation_target,
                vpc: self.vpc,
                availability_zone: self.availability_zone,
                current_route_table: self.current_route_table,
                expected_route_table: self.expected_route_table,
            }
        }
    }
}
impl NetworkFirewallMissingExpectedRtViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallMissingExpectedRtViolation`](crate::model::NetworkFirewallMissingExpectedRtViolation)
    pub fn builder() -> crate::model::network_firewall_missing_expected_rt_violation::Builder {
        crate::model::network_firewall_missing_expected_rt_violation::Builder::default()
    }
}

/// <p>Violation detail for Network Firewall for an Availability Zone that's missing the expected Firewall Manager managed subnet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallMissingSubnetViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>The resource ID of the VPC associated with a violating subnet.</p>
    pub vpc: std::option::Option<std::string::String>,
    /// <p>The Availability Zone of a violating subnet. </p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The reason the resource has this violation, if one is available. </p>
    pub target_violation_reason: std::option::Option<std::string::String>,
}
impl NetworkFirewallMissingSubnetViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>The resource ID of the VPC associated with a violating subnet.</p>
    pub fn vpc(&self) -> std::option::Option<&str> {
        self.vpc.as_deref()
    }
    /// <p>The Availability Zone of a violating subnet. </p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The reason the resource has this violation, if one is available. </p>
    pub fn target_violation_reason(&self) -> std::option::Option<&str> {
        self.target_violation_reason.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallMissingSubnetViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallMissingSubnetViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field("vpc", &self.vpc);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("target_violation_reason", &self.target_violation_reason);
        formatter.finish()
    }
}
/// See [`NetworkFirewallMissingSubnetViolation`](crate::model::NetworkFirewallMissingSubnetViolation)
pub mod network_firewall_missing_subnet_violation {
    /// A builder for [`NetworkFirewallMissingSubnetViolation`](crate::model::NetworkFirewallMissingSubnetViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) target_violation_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>The resource ID of the VPC associated with a violating subnet.</p>
        pub fn vpc(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc = Some(input.into());
            self
        }
        /// <p>The resource ID of the VPC associated with a violating subnet.</p>
        pub fn set_vpc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>The Availability Zone of a violating subnet. </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone of a violating subnet. </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The reason the resource has this violation, if one is available. </p>
        pub fn target_violation_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_violation_reason = Some(input.into());
            self
        }
        /// <p>The reason the resource has this violation, if one is available. </p>
        pub fn set_target_violation_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_violation_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallMissingSubnetViolation`](crate::model::NetworkFirewallMissingSubnetViolation)
        pub fn build(self) -> crate::model::NetworkFirewallMissingSubnetViolation {
            crate::model::NetworkFirewallMissingSubnetViolation {
                violation_target: self.violation_target,
                vpc: self.vpc,
                availability_zone: self.availability_zone,
                target_violation_reason: self.target_violation_reason,
            }
        }
    }
}
impl NetworkFirewallMissingSubnetViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallMissingSubnetViolation`](crate::model::NetworkFirewallMissingSubnetViolation)
    pub fn builder() -> crate::model::network_firewall_missing_subnet_violation::Builder {
        crate::model::network_firewall_missing_subnet_violation::Builder::default()
    }
}

/// <p>Violation detail for Network Firewall for a subnet that doesn't have a Firewall Manager managed firewall in its VPC. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFirewallMissingFirewallViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>The resource ID of the VPC associated with a violating subnet.</p>
    pub vpc: std::option::Option<std::string::String>,
    /// <p>The Availability Zone of a violating subnet. </p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The reason the resource has this violation, if one is available. </p>
    pub target_violation_reason: std::option::Option<std::string::String>,
}
impl NetworkFirewallMissingFirewallViolation {
    /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>The resource ID of the VPC associated with a violating subnet.</p>
    pub fn vpc(&self) -> std::option::Option<&str> {
        self.vpc.as_deref()
    }
    /// <p>The Availability Zone of a violating subnet. </p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The reason the resource has this violation, if one is available. </p>
    pub fn target_violation_reason(&self) -> std::option::Option<&str> {
        self.target_violation_reason.as_deref()
    }
}
impl std::fmt::Debug for NetworkFirewallMissingFirewallViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFirewallMissingFirewallViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field("vpc", &self.vpc);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("target_violation_reason", &self.target_violation_reason);
        formatter.finish()
    }
}
/// See [`NetworkFirewallMissingFirewallViolation`](crate::model::NetworkFirewallMissingFirewallViolation)
pub mod network_firewall_missing_firewall_violation {
    /// A builder for [`NetworkFirewallMissingFirewallViolation`](crate::model::NetworkFirewallMissingFirewallViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) target_violation_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The ID of the Network Firewall or VPC resource that's in violation.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>The resource ID of the VPC associated with a violating subnet.</p>
        pub fn vpc(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc = Some(input.into());
            self
        }
        /// <p>The resource ID of the VPC associated with a violating subnet.</p>
        pub fn set_vpc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>The Availability Zone of a violating subnet. </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone of a violating subnet. </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The reason the resource has this violation, if one is available. </p>
        pub fn target_violation_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_violation_reason = Some(input.into());
            self
        }
        /// <p>The reason the resource has this violation, if one is available. </p>
        pub fn set_target_violation_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_violation_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFirewallMissingFirewallViolation`](crate::model::NetworkFirewallMissingFirewallViolation)
        pub fn build(self) -> crate::model::NetworkFirewallMissingFirewallViolation {
            crate::model::NetworkFirewallMissingFirewallViolation {
                violation_target: self.violation_target,
                vpc: self.vpc,
                availability_zone: self.availability_zone,
                target_violation_reason: self.target_violation_reason,
            }
        }
    }
}
impl NetworkFirewallMissingFirewallViolation {
    /// Creates a new builder-style object to manufacture [`NetworkFirewallMissingFirewallViolation`](crate::model::NetworkFirewallMissingFirewallViolation)
    pub fn builder() -> crate::model::network_firewall_missing_firewall_violation::Builder {
        crate::model::network_firewall_missing_firewall_violation::Builder::default()
    }
}

/// <p>Violation detail for an EC2 instance resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2InstanceViolation {
    /// <p>The resource ID of the EC2 instance.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>Violation detail for network interfaces associated with the EC2 instance.</p>
    pub aws_ec2_network_interface_violations:
        std::option::Option<std::vec::Vec<crate::model::AwsEc2NetworkInterfaceViolation>>,
}
impl AwsEc2InstanceViolation {
    /// <p>The resource ID of the EC2 instance.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>Violation detail for network interfaces associated with the EC2 instance.</p>
    pub fn aws_ec2_network_interface_violations(
        &self,
    ) -> std::option::Option<&[crate::model::AwsEc2NetworkInterfaceViolation]> {
        self.aws_ec2_network_interface_violations.as_deref()
    }
}
impl std::fmt::Debug for AwsEc2InstanceViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2InstanceViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field(
            "aws_ec2_network_interface_violations",
            &self.aws_ec2_network_interface_violations,
        );
        formatter.finish()
    }
}
/// See [`AwsEc2InstanceViolation`](crate::model::AwsEc2InstanceViolation)
pub mod aws_ec2_instance_violation {
    /// A builder for [`AwsEc2InstanceViolation`](crate::model::AwsEc2InstanceViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) aws_ec2_network_interface_violations:
            std::option::Option<std::vec::Vec<crate::model::AwsEc2NetworkInterfaceViolation>>,
    }
    impl Builder {
        /// <p>The resource ID of the EC2 instance.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The resource ID of the EC2 instance.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// Appends an item to `aws_ec2_network_interface_violations`.
        ///
        /// To override the contents of this collection use [`set_aws_ec2_network_interface_violations`](Self::set_aws_ec2_network_interface_violations).
        ///
        /// <p>Violation detail for network interfaces associated with the EC2 instance.</p>
        pub fn aws_ec2_network_interface_violations(
            mut self,
            input: crate::model::AwsEc2NetworkInterfaceViolation,
        ) -> Self {
            let mut v = self
                .aws_ec2_network_interface_violations
                .unwrap_or_default();
            v.push(input);
            self.aws_ec2_network_interface_violations = Some(v);
            self
        }
        /// <p>Violation detail for network interfaces associated with the EC2 instance.</p>
        pub fn set_aws_ec2_network_interface_violations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEc2NetworkInterfaceViolation>,
            >,
        ) -> Self {
            self.aws_ec2_network_interface_violations = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2InstanceViolation`](crate::model::AwsEc2InstanceViolation)
        pub fn build(self) -> crate::model::AwsEc2InstanceViolation {
            crate::model::AwsEc2InstanceViolation {
                violation_target: self.violation_target,
                aws_ec2_network_interface_violations: self.aws_ec2_network_interface_violations,
            }
        }
    }
}
impl AwsEc2InstanceViolation {
    /// Creates a new builder-style object to manufacture [`AwsEc2InstanceViolation`](crate::model::AwsEc2InstanceViolation)
    pub fn builder() -> crate::model::aws_ec2_instance_violation::Builder {
        crate::model::aws_ec2_instance_violation::Builder::default()
    }
}

/// <p>Violation detail for network interfaces associated with an EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2NetworkInterfaceViolation {
    /// <p>The resource ID of the network interface.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>List of security groups that violate the rules specified in the primary security group of the Firewall Manager policy.</p>
    pub violating_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AwsEc2NetworkInterfaceViolation {
    /// <p>The resource ID of the network interface.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>List of security groups that violate the rules specified in the primary security group of the Firewall Manager policy.</p>
    pub fn violating_security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.violating_security_groups.as_deref()
    }
}
impl std::fmt::Debug for AwsEc2NetworkInterfaceViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2NetworkInterfaceViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field("violating_security_groups", &self.violating_security_groups);
        formatter.finish()
    }
}
/// See [`AwsEc2NetworkInterfaceViolation`](crate::model::AwsEc2NetworkInterfaceViolation)
pub mod aws_ec2_network_interface_violation {
    /// A builder for [`AwsEc2NetworkInterfaceViolation`](crate::model::AwsEc2NetworkInterfaceViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) violating_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource ID of the network interface.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The resource ID of the network interface.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// Appends an item to `violating_security_groups`.
        ///
        /// To override the contents of this collection use [`set_violating_security_groups`](Self::set_violating_security_groups).
        ///
        /// <p>List of security groups that violate the rules specified in the primary security group of the Firewall Manager policy.</p>
        pub fn violating_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.violating_security_groups.unwrap_or_default();
            v.push(input.into());
            self.violating_security_groups = Some(v);
            self
        }
        /// <p>List of security groups that violate the rules specified in the primary security group of the Firewall Manager policy.</p>
        pub fn set_violating_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.violating_security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2NetworkInterfaceViolation`](crate::model::AwsEc2NetworkInterfaceViolation)
        pub fn build(self) -> crate::model::AwsEc2NetworkInterfaceViolation {
            crate::model::AwsEc2NetworkInterfaceViolation {
                violation_target: self.violation_target,
                violating_security_groups: self.violating_security_groups,
            }
        }
    }
}
impl AwsEc2NetworkInterfaceViolation {
    /// Creates a new builder-style object to manufacture [`AwsEc2NetworkInterfaceViolation`](crate::model::AwsEc2NetworkInterfaceViolation)
    pub fn builder() -> crate::model::aws_ec2_network_interface_violation::Builder {
        crate::model::aws_ec2_network_interface_violation::Builder::default()
    }
}

/// <p>Violation detail for the rule violation in a security group when compared to the primary security group of the Firewall Manager policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsVpcSecurityGroupViolation {
    /// <p>The security group rule that is being evaluated.</p>
    pub violation_target: std::option::Option<std::string::String>,
    /// <p>A description of the security group that violates the policy.</p>
    pub violation_target_description: std::option::Option<std::string::String>,
    /// <p>List of rules specified in the security group of the Firewall Manager policy that partially match the <code>ViolationTarget</code> rule.</p>
    pub partial_matches: std::option::Option<std::vec::Vec<crate::model::PartialMatch>>,
    /// <p>Remediation options for the rule specified in the <code>ViolationTarget</code>.</p>
    pub possible_security_group_remediation_actions:
        std::option::Option<std::vec::Vec<crate::model::SecurityGroupRemediationAction>>,
}
impl AwsVpcSecurityGroupViolation {
    /// <p>The security group rule that is being evaluated.</p>
    pub fn violation_target(&self) -> std::option::Option<&str> {
        self.violation_target.as_deref()
    }
    /// <p>A description of the security group that violates the policy.</p>
    pub fn violation_target_description(&self) -> std::option::Option<&str> {
        self.violation_target_description.as_deref()
    }
    /// <p>List of rules specified in the security group of the Firewall Manager policy that partially match the <code>ViolationTarget</code> rule.</p>
    pub fn partial_matches(&self) -> std::option::Option<&[crate::model::PartialMatch]> {
        self.partial_matches.as_deref()
    }
    /// <p>Remediation options for the rule specified in the <code>ViolationTarget</code>.</p>
    pub fn possible_security_group_remediation_actions(
        &self,
    ) -> std::option::Option<&[crate::model::SecurityGroupRemediationAction]> {
        self.possible_security_group_remediation_actions.as_deref()
    }
}
impl std::fmt::Debug for AwsVpcSecurityGroupViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsVpcSecurityGroupViolation");
        formatter.field("violation_target", &self.violation_target);
        formatter.field(
            "violation_target_description",
            &self.violation_target_description,
        );
        formatter.field("partial_matches", &self.partial_matches);
        formatter.field(
            "possible_security_group_remediation_actions",
            &self.possible_security_group_remediation_actions,
        );
        formatter.finish()
    }
}
/// See [`AwsVpcSecurityGroupViolation`](crate::model::AwsVpcSecurityGroupViolation)
pub mod aws_vpc_security_group_violation {
    /// A builder for [`AwsVpcSecurityGroupViolation`](crate::model::AwsVpcSecurityGroupViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_target: std::option::Option<std::string::String>,
        pub(crate) violation_target_description: std::option::Option<std::string::String>,
        pub(crate) partial_matches: std::option::Option<std::vec::Vec<crate::model::PartialMatch>>,
        pub(crate) possible_security_group_remediation_actions:
            std::option::Option<std::vec::Vec<crate::model::SecurityGroupRemediationAction>>,
    }
    impl Builder {
        /// <p>The security group rule that is being evaluated.</p>
        pub fn violation_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_target = Some(input.into());
            self
        }
        /// <p>The security group rule that is being evaluated.</p>
        pub fn set_violation_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target = input;
            self
        }
        /// <p>A description of the security group that violates the policy.</p>
        pub fn violation_target_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.violation_target_description = Some(input.into());
            self
        }
        /// <p>A description of the security group that violates the policy.</p>
        pub fn set_violation_target_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.violation_target_description = input;
            self
        }
        /// Appends an item to `partial_matches`.
        ///
        /// To override the contents of this collection use [`set_partial_matches`](Self::set_partial_matches).
        ///
        /// <p>List of rules specified in the security group of the Firewall Manager policy that partially match the <code>ViolationTarget</code> rule.</p>
        pub fn partial_matches(mut self, input: crate::model::PartialMatch) -> Self {
            let mut v = self.partial_matches.unwrap_or_default();
            v.push(input);
            self.partial_matches = Some(v);
            self
        }
        /// <p>List of rules specified in the security group of the Firewall Manager policy that partially match the <code>ViolationTarget</code> rule.</p>
        pub fn set_partial_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartialMatch>>,
        ) -> Self {
            self.partial_matches = input;
            self
        }
        /// Appends an item to `possible_security_group_remediation_actions`.
        ///
        /// To override the contents of this collection use [`set_possible_security_group_remediation_actions`](Self::set_possible_security_group_remediation_actions).
        ///
        /// <p>Remediation options for the rule specified in the <code>ViolationTarget</code>.</p>
        pub fn possible_security_group_remediation_actions(
            mut self,
            input: crate::model::SecurityGroupRemediationAction,
        ) -> Self {
            let mut v = self
                .possible_security_group_remediation_actions
                .unwrap_or_default();
            v.push(input);
            self.possible_security_group_remediation_actions = Some(v);
            self
        }
        /// <p>Remediation options for the rule specified in the <code>ViolationTarget</code>.</p>
        pub fn set_possible_security_group_remediation_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityGroupRemediationAction>>,
        ) -> Self {
            self.possible_security_group_remediation_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsVpcSecurityGroupViolation`](crate::model::AwsVpcSecurityGroupViolation)
        pub fn build(self) -> crate::model::AwsVpcSecurityGroupViolation {
            crate::model::AwsVpcSecurityGroupViolation {
                violation_target: self.violation_target,
                violation_target_description: self.violation_target_description,
                partial_matches: self.partial_matches,
                possible_security_group_remediation_actions: self
                    .possible_security_group_remediation_actions,
            }
        }
    }
}
impl AwsVpcSecurityGroupViolation {
    /// Creates a new builder-style object to manufacture [`AwsVpcSecurityGroupViolation`](crate::model::AwsVpcSecurityGroupViolation)
    pub fn builder() -> crate::model::aws_vpc_security_group_violation::Builder {
        crate::model::aws_vpc_security_group_violation::Builder::default()
    }
}

/// <p>Remediation option for the rule specified in the <code>ViolationTarget</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupRemediationAction {
    /// <p>The remediation action that will be performed.</p>
    pub remediation_action_type: std::option::Option<crate::model::RemediationActionType>,
    /// <p>Brief description of the action that will be performed.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.</p>
    pub remediation_result: std::option::Option<crate::model::SecurityGroupRuleDescription>,
    /// <p>Indicates if the current action is the default action.</p>
    pub is_default_action: bool,
}
impl SecurityGroupRemediationAction {
    /// <p>The remediation action that will be performed.</p>
    pub fn remediation_action_type(
        &self,
    ) -> std::option::Option<&crate::model::RemediationActionType> {
        self.remediation_action_type.as_ref()
    }
    /// <p>Brief description of the action that will be performed.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.</p>
    pub fn remediation_result(
        &self,
    ) -> std::option::Option<&crate::model::SecurityGroupRuleDescription> {
        self.remediation_result.as_ref()
    }
    /// <p>Indicates if the current action is the default action.</p>
    pub fn is_default_action(&self) -> bool {
        self.is_default_action
    }
}
impl std::fmt::Debug for SecurityGroupRemediationAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupRemediationAction");
        formatter.field("remediation_action_type", &self.remediation_action_type);
        formatter.field("description", &self.description);
        formatter.field("remediation_result", &self.remediation_result);
        formatter.field("is_default_action", &self.is_default_action);
        formatter.finish()
    }
}
/// See [`SecurityGroupRemediationAction`](crate::model::SecurityGroupRemediationAction)
pub mod security_group_remediation_action {
    /// A builder for [`SecurityGroupRemediationAction`](crate::model::SecurityGroupRemediationAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remediation_action_type:
            std::option::Option<crate::model::RemediationActionType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) remediation_result:
            std::option::Option<crate::model::SecurityGroupRuleDescription>,
        pub(crate) is_default_action: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The remediation action that will be performed.</p>
        pub fn remediation_action_type(
            mut self,
            input: crate::model::RemediationActionType,
        ) -> Self {
            self.remediation_action_type = Some(input);
            self
        }
        /// <p>The remediation action that will be performed.</p>
        pub fn set_remediation_action_type(
            mut self,
            input: std::option::Option<crate::model::RemediationActionType>,
        ) -> Self {
            self.remediation_action_type = input;
            self
        }
        /// <p>Brief description of the action that will be performed.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Brief description of the action that will be performed.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.</p>
        pub fn remediation_result(
            mut self,
            input: crate::model::SecurityGroupRuleDescription,
        ) -> Self {
            self.remediation_result = Some(input);
            self
        }
        /// <p>The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.</p>
        pub fn set_remediation_result(
            mut self,
            input: std::option::Option<crate::model::SecurityGroupRuleDescription>,
        ) -> Self {
            self.remediation_result = input;
            self
        }
        /// <p>Indicates if the current action is the default action.</p>
        pub fn is_default_action(mut self, input: bool) -> Self {
            self.is_default_action = Some(input);
            self
        }
        /// <p>Indicates if the current action is the default action.</p>
        pub fn set_is_default_action(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_action = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupRemediationAction`](crate::model::SecurityGroupRemediationAction)
        pub fn build(self) -> crate::model::SecurityGroupRemediationAction {
            crate::model::SecurityGroupRemediationAction {
                remediation_action_type: self.remediation_action_type,
                description: self.description,
                remediation_result: self.remediation_result,
                is_default_action: self.is_default_action.unwrap_or_default(),
            }
        }
    }
}
impl SecurityGroupRemediationAction {
    /// Creates a new builder-style object to manufacture [`SecurityGroupRemediationAction`](crate::model::SecurityGroupRemediationAction)
    pub fn builder() -> crate::model::security_group_remediation_action::Builder {
        crate::model::security_group_remediation_action::Builder::default()
    }
}

/// <p>Describes a set of permissions for a security group rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupRuleDescription {
    /// <p>The IPv4 ranges for the security group rule.</p>
    pub ipv4_range: std::option::Option<std::string::String>,
    /// <p>The IPv6 ranges for the security group rule.</p>
    pub ipv6_range: std::option::Option<std::string::String>,
    /// <p>The ID of the prefix list for the security group rule.</p>
    pub prefix_list_id: std::option::Option<std::string::String>,
    /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types.</p>
    pub from_port: std::option::Option<i64>,
    /// <p>The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes.</p>
    pub to_port: std::option::Option<i64>,
}
impl SecurityGroupRuleDescription {
    /// <p>The IPv4 ranges for the security group rule.</p>
    pub fn ipv4_range(&self) -> std::option::Option<&str> {
        self.ipv4_range.as_deref()
    }
    /// <p>The IPv6 ranges for the security group rule.</p>
    pub fn ipv6_range(&self) -> std::option::Option<&str> {
        self.ipv6_range.as_deref()
    }
    /// <p>The ID of the prefix list for the security group rule.</p>
    pub fn prefix_list_id(&self) -> std::option::Option<&str> {
        self.prefix_list_id.as_deref()
    }
    /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.</p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
    /// <p>The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types.</p>
    pub fn from_port(&self) -> std::option::Option<i64> {
        self.from_port
    }
    /// <p>The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes.</p>
    pub fn to_port(&self) -> std::option::Option<i64> {
        self.to_port
    }
}
impl std::fmt::Debug for SecurityGroupRuleDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupRuleDescription");
        formatter.field("ipv4_range", &self.ipv4_range);
        formatter.field("ipv6_range", &self.ipv6_range);
        formatter.field("prefix_list_id", &self.prefix_list_id);
        formatter.field("protocol", &self.protocol);
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.finish()
    }
}
/// See [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
pub mod security_group_rule_description {
    /// A builder for [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv4_range: std::option::Option<std::string::String>,
        pub(crate) ipv6_range: std::option::Option<std::string::String>,
        pub(crate) prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) from_port: std::option::Option<i64>,
        pub(crate) to_port: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The IPv4 ranges for the security group rule.</p>
        pub fn ipv4_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv4_range = Some(input.into());
            self
        }
        /// <p>The IPv4 ranges for the security group rule.</p>
        pub fn set_ipv4_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv4_range = input;
            self
        }
        /// <p>The IPv6 ranges for the security group rule.</p>
        pub fn ipv6_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_range = Some(input.into());
            self
        }
        /// <p>The IPv6 ranges for the security group rule.</p>
        pub fn set_ipv6_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_range = input;
            self
        }
        /// <p>The ID of the prefix list for the security group rule.</p>
        pub fn prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the prefix list for the security group rule.</p>
        pub fn set_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_id = input;
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types.</p>
        pub fn from_port(mut self, input: i64) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i64>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes.</p>
        pub fn to_port(mut self, input: i64) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i64>) -> Self {
            self.to_port = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
        pub fn build(self) -> crate::model::SecurityGroupRuleDescription {
            crate::model::SecurityGroupRuleDescription {
                ipv4_range: self.ipv4_range,
                ipv6_range: self.ipv6_range,
                prefix_list_id: self.prefix_list_id,
                protocol: self.protocol,
                from_port: self.from_port,
                to_port: self.to_port,
            }
        }
    }
}
impl SecurityGroupRuleDescription {
    /// Creates a new builder-style object to manufacture [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
    pub fn builder() -> crate::model::security_group_rule_description::Builder {
        crate::model::security_group_rule_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RemediationActionType {
    #[allow(missing_docs)] // documentation missing in model
    Modify,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RemediationActionType {
    fn from(s: &str) -> Self {
        match s {
            "MODIFY" => RemediationActionType::Modify,
            "REMOVE" => RemediationActionType::Remove,
            other => RemediationActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RemediationActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RemediationActionType::from(s))
    }
}
impl RemediationActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RemediationActionType::Modify => "MODIFY",
            RemediationActionType::Remove => "REMOVE",
            RemediationActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MODIFY", "REMOVE"]
    }
}
impl AsRef<str> for RemediationActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The reference rule that partially matches the <code>ViolationTarget</code> rule and violation reason.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartialMatch {
    /// <p>The reference rule from the primary security group of the Firewall Manager policy.</p>
    pub reference: std::option::Option<std::string::String>,
    /// <p>The violation reason.</p>
    pub target_violation_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PartialMatch {
    /// <p>The reference rule from the primary security group of the Firewall Manager policy.</p>
    pub fn reference(&self) -> std::option::Option<&str> {
        self.reference.as_deref()
    }
    /// <p>The violation reason.</p>
    pub fn target_violation_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.target_violation_reasons.as_deref()
    }
}
impl std::fmt::Debug for PartialMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartialMatch");
        formatter.field("reference", &self.reference);
        formatter.field("target_violation_reasons", &self.target_violation_reasons);
        formatter.finish()
    }
}
/// See [`PartialMatch`](crate::model::PartialMatch)
pub mod partial_match {
    /// A builder for [`PartialMatch`](crate::model::PartialMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference: std::option::Option<std::string::String>,
        pub(crate) target_violation_reasons:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The reference rule from the primary security group of the Firewall Manager policy.</p>
        pub fn reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference = Some(input.into());
            self
        }
        /// <p>The reference rule from the primary security group of the Firewall Manager policy.</p>
        pub fn set_reference(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference = input;
            self
        }
        /// Appends an item to `target_violation_reasons`.
        ///
        /// To override the contents of this collection use [`set_target_violation_reasons`](Self::set_target_violation_reasons).
        ///
        /// <p>The violation reason.</p>
        pub fn target_violation_reasons(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_violation_reasons.unwrap_or_default();
            v.push(input.into());
            self.target_violation_reasons = Some(v);
            self
        }
        /// <p>The violation reason.</p>
        pub fn set_target_violation_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_violation_reasons = input;
            self
        }
        /// Consumes the builder and constructs a [`PartialMatch`](crate::model::PartialMatch)
        pub fn build(self) -> crate::model::PartialMatch {
            crate::model::PartialMatch {
                reference: self.reference,
                target_violation_reasons: self.target_violation_reasons,
            }
        }
    }
}
impl PartialMatch {
    /// Creates a new builder-style object to manufacture [`PartialMatch`](crate::model::PartialMatch)
    pub fn builder() -> crate::model::partial_match::Builder {
        crate::model::partial_match::Builder::default()
    }
}

/// <p>Describes the noncompliant resources in a member account for a specific Firewall Manager policy. A maximum of 100 entries are displayed. If more than 100 resources are noncompliant, <code>EvaluationLimitExceeded</code> is set to <code>True</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyComplianceDetail {
    /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
    pub policy_owner: std::option::Option<std::string::String>,
    /// <p>The ID of the Firewall Manager policy.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID.</p>
    pub member_account: std::option::Option<std::string::String>,
    /// <p>An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance with the security group policy.</p>
    pub violators: std::option::Option<std::vec::Vec<crate::model::ComplianceViolator>>,
    /// <p>Indicates if over 100 resources are noncompliant with the Firewall Manager policy.</p>
    pub evaluation_limit_exceeded: bool,
    /// <p>A timestamp that indicates when the returned information should be considered out of date.</p>
    pub expired_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
    pub issue_info_map: std::option::Option<
        std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
    >,
}
impl PolicyComplianceDetail {
    /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
    pub fn policy_owner(&self) -> std::option::Option<&str> {
        self.policy_owner.as_deref()
    }
    /// <p>The ID of the Firewall Manager policy.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID.</p>
    pub fn member_account(&self) -> std::option::Option<&str> {
        self.member_account.as_deref()
    }
    /// <p>An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance with the security group policy.</p>
    pub fn violators(&self) -> std::option::Option<&[crate::model::ComplianceViolator]> {
        self.violators.as_deref()
    }
    /// <p>Indicates if over 100 resources are noncompliant with the Firewall Manager policy.</p>
    pub fn evaluation_limit_exceeded(&self) -> bool {
        self.evaluation_limit_exceeded
    }
    /// <p>A timestamp that indicates when the returned information should be considered out of date.</p>
    pub fn expired_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expired_at.as_ref()
    }
    /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
    pub fn issue_info_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
    > {
        self.issue_info_map.as_ref()
    }
}
impl std::fmt::Debug for PolicyComplianceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyComplianceDetail");
        formatter.field("policy_owner", &self.policy_owner);
        formatter.field("policy_id", &self.policy_id);
        formatter.field("member_account", &self.member_account);
        formatter.field("violators", &self.violators);
        formatter.field("evaluation_limit_exceeded", &self.evaluation_limit_exceeded);
        formatter.field("expired_at", &self.expired_at);
        formatter.field("issue_info_map", &self.issue_info_map);
        formatter.finish()
    }
}
/// See [`PolicyComplianceDetail`](crate::model::PolicyComplianceDetail)
pub mod policy_compliance_detail {
    /// A builder for [`PolicyComplianceDetail`](crate::model::PolicyComplianceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_owner: std::option::Option<std::string::String>,
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) member_account: std::option::Option<std::string::String>,
        pub(crate) violators: std::option::Option<std::vec::Vec<crate::model::ComplianceViolator>>,
        pub(crate) evaluation_limit_exceeded: std::option::Option<bool>,
        pub(crate) expired_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) issue_info_map: std::option::Option<
            std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
        pub fn policy_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that created the Firewall Manager policy.</p>
        pub fn set_policy_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_owner = input;
            self
        }
        /// <p>The ID of the Firewall Manager policy.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the Firewall Manager policy.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn member_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_member_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.member_account = input;
            self
        }
        /// Appends an item to `violators`.
        ///
        /// To override the contents of this collection use [`set_violators`](Self::set_violators).
        ///
        /// <p>An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance with the security group policy.</p>
        pub fn violators(mut self, input: crate::model::ComplianceViolator) -> Self {
            let mut v = self.violators.unwrap_or_default();
            v.push(input);
            self.violators = Some(v);
            self
        }
        /// <p>An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance with the security group policy.</p>
        pub fn set_violators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceViolator>>,
        ) -> Self {
            self.violators = input;
            self
        }
        /// <p>Indicates if over 100 resources are noncompliant with the Firewall Manager policy.</p>
        pub fn evaluation_limit_exceeded(mut self, input: bool) -> Self {
            self.evaluation_limit_exceeded = Some(input);
            self
        }
        /// <p>Indicates if over 100 resources are noncompliant with the Firewall Manager policy.</p>
        pub fn set_evaluation_limit_exceeded(mut self, input: std::option::Option<bool>) -> Self {
            self.evaluation_limit_exceeded = input;
            self
        }
        /// <p>A timestamp that indicates when the returned information should be considered out of date.</p>
        pub fn expired_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expired_at = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the returned information should be considered out of date.</p>
        pub fn set_expired_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expired_at = input;
            self
        }
        /// Adds a key-value pair to `issue_info_map`.
        ///
        /// To override the contents of this collection use [`set_issue_info_map`](Self::set_issue_info_map).
        ///
        /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
        pub fn issue_info_map(
            mut self,
            k: crate::model::DependentServiceName,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.issue_info_map.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.issue_info_map = Some(hash_map);
            self
        }
        /// <p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>
        pub fn set_issue_info_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::DependentServiceName, std::string::String>,
            >,
        ) -> Self {
            self.issue_info_map = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyComplianceDetail`](crate::model::PolicyComplianceDetail)
        pub fn build(self) -> crate::model::PolicyComplianceDetail {
            crate::model::PolicyComplianceDetail {
                policy_owner: self.policy_owner,
                policy_id: self.policy_id,
                member_account: self.member_account,
                violators: self.violators,
                evaluation_limit_exceeded: self.evaluation_limit_exceeded.unwrap_or_default(),
                expired_at: self.expired_at,
                issue_info_map: self.issue_info_map,
            }
        }
    }
}
impl PolicyComplianceDetail {
    /// Creates a new builder-style object to manufacture [`PolicyComplianceDetail`](crate::model::PolicyComplianceDetail)
    pub fn builder() -> crate::model::policy_compliance_detail::Builder {
        crate::model::policy_compliance_detail::Builder::default()
    }
}

/// <p>Details of the resource that is not protected by the policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceViolator {
    /// <p>The resource ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The reason that the resource is not protected by the policy.</p>
    pub violation_reason: std::option::Option<crate::model::ViolationReason>,
    /// <p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ComplianceViolator {
    /// <p>The resource ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The reason that the resource is not protected by the policy.</p>
    pub fn violation_reason(&self) -> std::option::Option<&crate::model::ViolationReason> {
        self.violation_reason.as_ref()
    }
    /// <p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ComplianceViolator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceViolator");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("violation_reason", &self.violation_reason);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`ComplianceViolator`](crate::model::ComplianceViolator)
pub mod compliance_violator {
    /// A builder for [`ComplianceViolator`](crate::model::ComplianceViolator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) violation_reason: std::option::Option<crate::model::ViolationReason>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The reason that the resource is not protected by the policy.</p>
        pub fn violation_reason(mut self, input: crate::model::ViolationReason) -> Self {
            self.violation_reason = Some(input);
            self
        }
        /// <p>The reason that the resource is not protected by the policy.</p>
        pub fn set_violation_reason(
            mut self,
            input: std::option::Option<crate::model::ViolationReason>,
        ) -> Self {
            self.violation_reason = input;
            self
        }
        /// <p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceViolator`](crate::model::ComplianceViolator)
        pub fn build(self) -> crate::model::ComplianceViolator {
            crate::model::ComplianceViolator {
                resource_id: self.resource_id,
                violation_reason: self.violation_reason,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ComplianceViolator {
    /// Creates a new builder-style object to manufacture [`ComplianceViolator`](crate::model::ComplianceViolator)
    pub fn builder() -> crate::model::compliance_violator::Builder {
        crate::model::compliance_violator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ViolationReason {
    #[allow(missing_docs)] // documentation missing in model
    BlackHoleRouteDetected,
    #[allow(missing_docs)] // documentation missing in model
    BlackHoleRouteDetectedInFirewallSubnet,
    #[allow(missing_docs)] // documentation missing in model
    FirewallSubnetMissingExpectedRoute,
    #[allow(missing_docs)] // documentation missing in model
    FmsCreatedSecurityGroupEdited,
    #[allow(missing_docs)] // documentation missing in model
    InternetGatewayMissingExpectedRoute,
    #[allow(missing_docs)] // documentation missing in model
    InternetTrafficNotInspected,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRouteConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    MissingExpectedRouteTable,
    #[allow(missing_docs)] // documentation missing in model
    MissingFirewall,
    #[allow(missing_docs)] // documentation missing in model
    MissingFirewallSubnetInAz,
    #[allow(missing_docs)] // documentation missing in model
    MissingTargetGateway,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewallPolicyModified,
    #[allow(missing_docs)] // documentation missing in model
    ResourceIncorrectWebAcl,
    #[allow(missing_docs)] // documentation missing in model
    ResourceMissingDnsFirewall,
    #[allow(missing_docs)] // documentation missing in model
    ResourceMissingSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    ResourceMissingShieldProtection,
    #[allow(missing_docs)] // documentation missing in model
    ResourceMissingWebAcl,
    #[allow(missing_docs)] // documentation missing in model
    ResourceMissingWebaclOrShieldProtection,
    #[allow(missing_docs)] // documentation missing in model
    ResourceViolatesAuditSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupRedundant,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupUnused,
    #[allow(missing_docs)] // documentation missing in model
    TrafficInspectionCrossesAzBoundary,
    #[allow(missing_docs)] // documentation missing in model
    UnexpectedFirewallRoutes,
    #[allow(missing_docs)] // documentation missing in model
    UnexpectedTargetGatewayRoutes,
    #[allow(missing_docs)] // documentation missing in model
    WebAclMissingRuleGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ViolationReason {
    fn from(s: &str) -> Self {
        match s {
            "BLACK_HOLE_ROUTE_DETECTED" => ViolationReason::BlackHoleRouteDetected,
            "BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET" => {
                ViolationReason::BlackHoleRouteDetectedInFirewallSubnet
            }
            "FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE" => {
                ViolationReason::FirewallSubnetMissingExpectedRoute
            }
            "FMS_CREATED_SECURITY_GROUP_EDITED" => ViolationReason::FmsCreatedSecurityGroupEdited,
            "INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE" => {
                ViolationReason::InternetGatewayMissingExpectedRoute
            }
            "INTERNET_TRAFFIC_NOT_INSPECTED" => ViolationReason::InternetTrafficNotInspected,
            "INVALID_ROUTE_CONFIGURATION" => ViolationReason::InvalidRouteConfiguration,
            "MISSING_EXPECTED_ROUTE_TABLE" => ViolationReason::MissingExpectedRouteTable,
            "MISSING_FIREWALL" => ViolationReason::MissingFirewall,
            "MISSING_FIREWALL_SUBNET_IN_AZ" => ViolationReason::MissingFirewallSubnetInAz,
            "MISSING_TARGET_GATEWAY" => ViolationReason::MissingTargetGateway,
            "NETWORK_FIREWALL_POLICY_MODIFIED" => ViolationReason::NetworkFirewallPolicyModified,
            "RESOURCE_INCORRECT_WEB_ACL" => ViolationReason::ResourceIncorrectWebAcl,
            "RESOURCE_MISSING_DNS_FIREWALL" => ViolationReason::ResourceMissingDnsFirewall,
            "RESOURCE_MISSING_SECURITY_GROUP" => ViolationReason::ResourceMissingSecurityGroup,
            "RESOURCE_MISSING_SHIELD_PROTECTION" => {
                ViolationReason::ResourceMissingShieldProtection
            }
            "RESOURCE_MISSING_WEB_ACL" => ViolationReason::ResourceMissingWebAcl,
            "RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION" => {
                ViolationReason::ResourceMissingWebaclOrShieldProtection
            }
            "RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP" => {
                ViolationReason::ResourceViolatesAuditSecurityGroup
            }
            "SECURITY_GROUP_REDUNDANT" => ViolationReason::SecurityGroupRedundant,
            "SECURITY_GROUP_UNUSED" => ViolationReason::SecurityGroupUnused,
            "TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY" => {
                ViolationReason::TrafficInspectionCrossesAzBoundary
            }
            "UNEXPECTED_FIREWALL_ROUTES" => ViolationReason::UnexpectedFirewallRoutes,
            "UNEXPECTED_TARGET_GATEWAY_ROUTES" => ViolationReason::UnexpectedTargetGatewayRoutes,
            "WEB_ACL_MISSING_RULE_GROUP" => ViolationReason::WebAclMissingRuleGroup,
            other => ViolationReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ViolationReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ViolationReason::from(s))
    }
}
impl ViolationReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ViolationReason::BlackHoleRouteDetected => "BLACK_HOLE_ROUTE_DETECTED",
            ViolationReason::BlackHoleRouteDetectedInFirewallSubnet => {
                "BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET"
            }
            ViolationReason::FirewallSubnetMissingExpectedRoute => {
                "FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE"
            }
            ViolationReason::FmsCreatedSecurityGroupEdited => "FMS_CREATED_SECURITY_GROUP_EDITED",
            ViolationReason::InternetGatewayMissingExpectedRoute => {
                "INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE"
            }
            ViolationReason::InternetTrafficNotInspected => "INTERNET_TRAFFIC_NOT_INSPECTED",
            ViolationReason::InvalidRouteConfiguration => "INVALID_ROUTE_CONFIGURATION",
            ViolationReason::MissingExpectedRouteTable => "MISSING_EXPECTED_ROUTE_TABLE",
            ViolationReason::MissingFirewall => "MISSING_FIREWALL",
            ViolationReason::MissingFirewallSubnetInAz => "MISSING_FIREWALL_SUBNET_IN_AZ",
            ViolationReason::MissingTargetGateway => "MISSING_TARGET_GATEWAY",
            ViolationReason::NetworkFirewallPolicyModified => "NETWORK_FIREWALL_POLICY_MODIFIED",
            ViolationReason::ResourceIncorrectWebAcl => "RESOURCE_INCORRECT_WEB_ACL",
            ViolationReason::ResourceMissingDnsFirewall => "RESOURCE_MISSING_DNS_FIREWALL",
            ViolationReason::ResourceMissingSecurityGroup => "RESOURCE_MISSING_SECURITY_GROUP",
            ViolationReason::ResourceMissingShieldProtection => {
                "RESOURCE_MISSING_SHIELD_PROTECTION"
            }
            ViolationReason::ResourceMissingWebAcl => "RESOURCE_MISSING_WEB_ACL",
            ViolationReason::ResourceMissingWebaclOrShieldProtection => {
                "RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION"
            }
            ViolationReason::ResourceViolatesAuditSecurityGroup => {
                "RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP"
            }
            ViolationReason::SecurityGroupRedundant => "SECURITY_GROUP_REDUNDANT",
            ViolationReason::SecurityGroupUnused => "SECURITY_GROUP_UNUSED",
            ViolationReason::TrafficInspectionCrossesAzBoundary => {
                "TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY"
            }
            ViolationReason::UnexpectedFirewallRoutes => "UNEXPECTED_FIREWALL_ROUTES",
            ViolationReason::UnexpectedTargetGatewayRoutes => "UNEXPECTED_TARGET_GATEWAY_ROUTES",
            ViolationReason::WebAclMissingRuleGroup => "WEB_ACL_MISSING_RULE_GROUP",
            ViolationReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BLACK_HOLE_ROUTE_DETECTED",
            "BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET",
            "FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE",
            "FMS_CREATED_SECURITY_GROUP_EDITED",
            "INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE",
            "INTERNET_TRAFFIC_NOT_INSPECTED",
            "INVALID_ROUTE_CONFIGURATION",
            "MISSING_EXPECTED_ROUTE_TABLE",
            "MISSING_FIREWALL",
            "MISSING_FIREWALL_SUBNET_IN_AZ",
            "MISSING_TARGET_GATEWAY",
            "NETWORK_FIREWALL_POLICY_MODIFIED",
            "RESOURCE_INCORRECT_WEB_ACL",
            "RESOURCE_MISSING_DNS_FIREWALL",
            "RESOURCE_MISSING_SECURITY_GROUP",
            "RESOURCE_MISSING_SHIELD_PROTECTION",
            "RESOURCE_MISSING_WEB_ACL",
            "RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION",
            "RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP",
            "SECURITY_GROUP_REDUNDANT",
            "SECURITY_GROUP_UNUSED",
            "TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY",
            "UNEXPECTED_FIREWALL_ROUTES",
            "UNEXPECTED_TARGET_GATEWAY_ROUTES",
            "WEB_ACL_MISSING_RULE_GROUP",
        ]
    }
}
impl AsRef<str> for ViolationReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountRoleStatus {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeletion,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountRoleStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => AccountRoleStatus::Creating,
            "DELETED" => AccountRoleStatus::Deleted,
            "DELETING" => AccountRoleStatus::Deleting,
            "PENDING_DELETION" => AccountRoleStatus::PendingDeletion,
            "READY" => AccountRoleStatus::Ready,
            other => AccountRoleStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountRoleStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountRoleStatus::from(s))
    }
}
impl AccountRoleStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountRoleStatus::Creating => "CREATING",
            AccountRoleStatus::Deleted => "DELETED",
            AccountRoleStatus::Deleting => "DELETING",
            AccountRoleStatus::PendingDeletion => "PENDING_DELETION",
            AccountRoleStatus::Ready => "READY",
            AccountRoleStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATING",
            "DELETED",
            "DELETING",
            "PENDING_DELETION",
            "READY",
        ]
    }
}
impl AsRef<str> for AccountRoleStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
