// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_admin_account`](crate::client::Client::associate_admin_account).
///
/// See [`crate::client::fluent_builders::AssociateAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateAdminAccount {
    _private: (),
}
impl AssociateAdminAccount {
    /// Creates a new builder-style object to manufacture [`AssociateAdminAccountInput`](crate::input::AssociateAdminAccountInput)
    pub fn builder() -> crate::input::associate_admin_account_input::Builder {
        crate::input::associate_admin_account_input::Builder::default()
    }
    /// Creates a new `AssociateAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateAdminAccount {
    type Output = std::result::Result<
        crate::output::AssociateAdminAccountOutput,
        crate::error::AssociateAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_admin_account_error(response)
        } else {
            crate::operation_deser::parse_associate_admin_account_response(response)
        }
    }
}

/// Operation shape for `AssociateThirdPartyFirewall`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_third_party_firewall`](crate::client::Client::associate_third_party_firewall).
///
/// See [`crate::client::fluent_builders::AssociateThirdPartyFirewall`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateThirdPartyFirewall {
    _private: (),
}
impl AssociateThirdPartyFirewall {
    /// Creates a new builder-style object to manufacture [`AssociateThirdPartyFirewallInput`](crate::input::AssociateThirdPartyFirewallInput)
    pub fn builder() -> crate::input::associate_third_party_firewall_input::Builder {
        crate::input::associate_third_party_firewall_input::Builder::default()
    }
    /// Creates a new `AssociateThirdPartyFirewall` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateThirdPartyFirewall {
    type Output = std::result::Result<
        crate::output::AssociateThirdPartyFirewallOutput,
        crate::error::AssociateThirdPartyFirewallError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_third_party_firewall_error(response)
        } else {
            crate::operation_deser::parse_associate_third_party_firewall_response(response)
        }
    }
}

/// Operation shape for `DeleteAppsList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_apps_list`](crate::client::Client::delete_apps_list).
///
/// See [`crate::client::fluent_builders::DeleteAppsList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppsList {
    _private: (),
}
impl DeleteAppsList {
    /// Creates a new builder-style object to manufacture [`DeleteAppsListInput`](crate::input::DeleteAppsListInput)
    pub fn builder() -> crate::input::delete_apps_list_input::Builder {
        crate::input::delete_apps_list_input::Builder::default()
    }
    /// Creates a new `DeleteAppsList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppsList {
    type Output =
        std::result::Result<crate::output::DeleteAppsListOutput, crate::error::DeleteAppsListError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_apps_list_error(response)
        } else {
            crate::operation_deser::parse_delete_apps_list_response(response)
        }
    }
}

/// Operation shape for `DeleteNotificationChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_notification_channel`](crate::client::Client::delete_notification_channel).
///
/// See [`crate::client::fluent_builders::DeleteNotificationChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNotificationChannel {
    _private: (),
}
impl DeleteNotificationChannel {
    /// Creates a new builder-style object to manufacture [`DeleteNotificationChannelInput`](crate::input::DeleteNotificationChannelInput)
    pub fn builder() -> crate::input::delete_notification_channel_input::Builder {
        crate::input::delete_notification_channel_input::Builder::default()
    }
    /// Creates a new `DeleteNotificationChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNotificationChannel {
    type Output = std::result::Result<
        crate::output::DeleteNotificationChannelOutput,
        crate::error::DeleteNotificationChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_notification_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_notification_channel_response(response)
        }
    }
}

/// Operation shape for `DeletePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_policy`](crate::client::Client::delete_policy).
///
/// See [`crate::client::fluent_builders::DeletePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePolicy {
    _private: (),
}
impl DeletePolicy {
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
    /// Creates a new `DeletePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePolicy {
    type Output =
        std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteProtocolsList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_protocols_list`](crate::client::Client::delete_protocols_list).
///
/// See [`crate::client::fluent_builders::DeleteProtocolsList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProtocolsList {
    _private: (),
}
impl DeleteProtocolsList {
    /// Creates a new builder-style object to manufacture [`DeleteProtocolsListInput`](crate::input::DeleteProtocolsListInput)
    pub fn builder() -> crate::input::delete_protocols_list_input::Builder {
        crate::input::delete_protocols_list_input::Builder::default()
    }
    /// Creates a new `DeleteProtocolsList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProtocolsList {
    type Output = std::result::Result<
        crate::output::DeleteProtocolsListOutput,
        crate::error::DeleteProtocolsListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_protocols_list_error(response)
        } else {
            crate::operation_deser::parse_delete_protocols_list_response(response)
        }
    }
}

/// Operation shape for `DisassociateAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_admin_account`](crate::client::Client::disassociate_admin_account).
///
/// See [`crate::client::fluent_builders::DisassociateAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateAdminAccount {
    _private: (),
}
impl DisassociateAdminAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateAdminAccountInput`](crate::input::DisassociateAdminAccountInput)
    pub fn builder() -> crate::input::disassociate_admin_account_input::Builder {
        crate::input::disassociate_admin_account_input::Builder::default()
    }
    /// Creates a new `DisassociateAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateAdminAccount {
    type Output = std::result::Result<
        crate::output::DisassociateAdminAccountOutput,
        crate::error::DisassociateAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_admin_account_error(response)
        } else {
            crate::operation_deser::parse_disassociate_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateThirdPartyFirewall`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_third_party_firewall`](crate::client::Client::disassociate_third_party_firewall).
///
/// See [`crate::client::fluent_builders::DisassociateThirdPartyFirewall`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateThirdPartyFirewall {
    _private: (),
}
impl DisassociateThirdPartyFirewall {
    /// Creates a new builder-style object to manufacture [`DisassociateThirdPartyFirewallInput`](crate::input::DisassociateThirdPartyFirewallInput)
    pub fn builder() -> crate::input::disassociate_third_party_firewall_input::Builder {
        crate::input::disassociate_third_party_firewall_input::Builder::default()
    }
    /// Creates a new `DisassociateThirdPartyFirewall` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateThirdPartyFirewall {
    type Output = std::result::Result<
        crate::output::DisassociateThirdPartyFirewallOutput,
        crate::error::DisassociateThirdPartyFirewallError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_third_party_firewall_error(response)
        } else {
            crate::operation_deser::parse_disassociate_third_party_firewall_response(response)
        }
    }
}

/// Operation shape for `GetAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_admin_account`](crate::client::Client::get_admin_account).
///
/// See [`crate::client::fluent_builders::GetAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAdminAccount {
    _private: (),
}
impl GetAdminAccount {
    /// Creates a new builder-style object to manufacture [`GetAdminAccountInput`](crate::input::GetAdminAccountInput)
    pub fn builder() -> crate::input::get_admin_account_input::Builder {
        crate::input::get_admin_account_input::Builder::default()
    }
    /// Creates a new `GetAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAdminAccount {
    type Output = std::result::Result<
        crate::output::GetAdminAccountOutput,
        crate::error::GetAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_admin_account_error(response)
        } else {
            crate::operation_deser::parse_get_admin_account_response(response)
        }
    }
}

/// Operation shape for `GetAppsList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_apps_list`](crate::client::Client::get_apps_list).
///
/// See [`crate::client::fluent_builders::GetAppsList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppsList {
    _private: (),
}
impl GetAppsList {
    /// Creates a new builder-style object to manufacture [`GetAppsListInput`](crate::input::GetAppsListInput)
    pub fn builder() -> crate::input::get_apps_list_input::Builder {
        crate::input::get_apps_list_input::Builder::default()
    }
    /// Creates a new `GetAppsList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppsList {
    type Output =
        std::result::Result<crate::output::GetAppsListOutput, crate::error::GetAppsListError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_apps_list_error(response)
        } else {
            crate::operation_deser::parse_get_apps_list_response(response)
        }
    }
}

/// Operation shape for `GetComplianceDetail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_compliance_detail`](crate::client::Client::get_compliance_detail).
///
/// See [`crate::client::fluent_builders::GetComplianceDetail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComplianceDetail {
    _private: (),
}
impl GetComplianceDetail {
    /// Creates a new builder-style object to manufacture [`GetComplianceDetailInput`](crate::input::GetComplianceDetailInput)
    pub fn builder() -> crate::input::get_compliance_detail_input::Builder {
        crate::input::get_compliance_detail_input::Builder::default()
    }
    /// Creates a new `GetComplianceDetail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComplianceDetail {
    type Output = std::result::Result<
        crate::output::GetComplianceDetailOutput,
        crate::error::GetComplianceDetailError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_compliance_detail_error(response)
        } else {
            crate::operation_deser::parse_get_compliance_detail_response(response)
        }
    }
}

/// Operation shape for `GetNotificationChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_notification_channel`](crate::client::Client::get_notification_channel).
///
/// See [`crate::client::fluent_builders::GetNotificationChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNotificationChannel {
    _private: (),
}
impl GetNotificationChannel {
    /// Creates a new builder-style object to manufacture [`GetNotificationChannelInput`](crate::input::GetNotificationChannelInput)
    pub fn builder() -> crate::input::get_notification_channel_input::Builder {
        crate::input::get_notification_channel_input::Builder::default()
    }
    /// Creates a new `GetNotificationChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNotificationChannel {
    type Output = std::result::Result<
        crate::output::GetNotificationChannelOutput,
        crate::error::GetNotificationChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_notification_channel_error(response)
        } else {
            crate::operation_deser::parse_get_notification_channel_response(response)
        }
    }
}

/// Operation shape for `GetPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_policy`](crate::client::Client::get_policy).
///
/// See [`crate::client::fluent_builders::GetPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPolicy {
    _private: (),
}
impl GetPolicy {
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
    /// Creates a new `GetPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPolicy {
    type Output = std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_policy_error(response)
        } else {
            crate::operation_deser::parse_get_policy_response(response)
        }
    }
}

/// Operation shape for `GetProtectionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_protection_status`](crate::client::Client::get_protection_status).
///
/// See [`crate::client::fluent_builders::GetProtectionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProtectionStatus {
    _private: (),
}
impl GetProtectionStatus {
    /// Creates a new builder-style object to manufacture [`GetProtectionStatusInput`](crate::input::GetProtectionStatusInput)
    pub fn builder() -> crate::input::get_protection_status_input::Builder {
        crate::input::get_protection_status_input::Builder::default()
    }
    /// Creates a new `GetProtectionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProtectionStatus {
    type Output = std::result::Result<
        crate::output::GetProtectionStatusOutput,
        crate::error::GetProtectionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_protection_status_error(response)
        } else {
            crate::operation_deser::parse_get_protection_status_response(response)
        }
    }
}

/// Operation shape for `GetProtocolsList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_protocols_list`](crate::client::Client::get_protocols_list).
///
/// See [`crate::client::fluent_builders::GetProtocolsList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProtocolsList {
    _private: (),
}
impl GetProtocolsList {
    /// Creates a new builder-style object to manufacture [`GetProtocolsListInput`](crate::input::GetProtocolsListInput)
    pub fn builder() -> crate::input::get_protocols_list_input::Builder {
        crate::input::get_protocols_list_input::Builder::default()
    }
    /// Creates a new `GetProtocolsList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProtocolsList {
    type Output = std::result::Result<
        crate::output::GetProtocolsListOutput,
        crate::error::GetProtocolsListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_protocols_list_error(response)
        } else {
            crate::operation_deser::parse_get_protocols_list_response(response)
        }
    }
}

/// Operation shape for `GetThirdPartyFirewallAssociationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_third_party_firewall_association_status`](crate::client::Client::get_third_party_firewall_association_status).
///
/// See [`crate::client::fluent_builders::GetThirdPartyFirewallAssociationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetThirdPartyFirewallAssociationStatus {
    _private: (),
}
impl GetThirdPartyFirewallAssociationStatus {
    /// Creates a new builder-style object to manufacture [`GetThirdPartyFirewallAssociationStatusInput`](crate::input::GetThirdPartyFirewallAssociationStatusInput)
    pub fn builder() -> crate::input::get_third_party_firewall_association_status_input::Builder {
        crate::input::get_third_party_firewall_association_status_input::Builder::default()
    }
    /// Creates a new `GetThirdPartyFirewallAssociationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetThirdPartyFirewallAssociationStatus {
    type Output = std::result::Result<
        crate::output::GetThirdPartyFirewallAssociationStatusOutput,
        crate::error::GetThirdPartyFirewallAssociationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_third_party_firewall_association_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_third_party_firewall_association_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetViolationDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_violation_details`](crate::client::Client::get_violation_details).
///
/// See [`crate::client::fluent_builders::GetViolationDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetViolationDetails {
    _private: (),
}
impl GetViolationDetails {
    /// Creates a new builder-style object to manufacture [`GetViolationDetailsInput`](crate::input::GetViolationDetailsInput)
    pub fn builder() -> crate::input::get_violation_details_input::Builder {
        crate::input::get_violation_details_input::Builder::default()
    }
    /// Creates a new `GetViolationDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetViolationDetails {
    type Output = std::result::Result<
        crate::output::GetViolationDetailsOutput,
        crate::error::GetViolationDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_violation_details_error(response)
        } else {
            crate::operation_deser::parse_get_violation_details_response(response)
        }
    }
}

/// Operation shape for `ListAppsLists`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_apps_lists`](crate::client::Client::list_apps_lists).
///
/// See [`crate::client::fluent_builders::ListAppsLists`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppsLists {
    _private: (),
}
impl ListAppsLists {
    /// Creates a new builder-style object to manufacture [`ListAppsListsInput`](crate::input::ListAppsListsInput)
    pub fn builder() -> crate::input::list_apps_lists_input::Builder {
        crate::input::list_apps_lists_input::Builder::default()
    }
    /// Creates a new `ListAppsLists` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppsLists {
    type Output =
        std::result::Result<crate::output::ListAppsListsOutput, crate::error::ListAppsListsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_apps_lists_error(response)
        } else {
            crate::operation_deser::parse_list_apps_lists_response(response)
        }
    }
}

/// Operation shape for `ListComplianceStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_compliance_status`](crate::client::Client::list_compliance_status).
///
/// See [`crate::client::fluent_builders::ListComplianceStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListComplianceStatus {
    _private: (),
}
impl ListComplianceStatus {
    /// Creates a new builder-style object to manufacture [`ListComplianceStatusInput`](crate::input::ListComplianceStatusInput)
    pub fn builder() -> crate::input::list_compliance_status_input::Builder {
        crate::input::list_compliance_status_input::Builder::default()
    }
    /// Creates a new `ListComplianceStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListComplianceStatus {
    type Output = std::result::Result<
        crate::output::ListComplianceStatusOutput,
        crate::error::ListComplianceStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_compliance_status_error(response)
        } else {
            crate::operation_deser::parse_list_compliance_status_response(response)
        }
    }
}

/// Operation shape for `ListMemberAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_member_accounts`](crate::client::Client::list_member_accounts).
///
/// See [`crate::client::fluent_builders::ListMemberAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMemberAccounts {
    _private: (),
}
impl ListMemberAccounts {
    /// Creates a new builder-style object to manufacture [`ListMemberAccountsInput`](crate::input::ListMemberAccountsInput)
    pub fn builder() -> crate::input::list_member_accounts_input::Builder {
        crate::input::list_member_accounts_input::Builder::default()
    }
    /// Creates a new `ListMemberAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMemberAccounts {
    type Output = std::result::Result<
        crate::output::ListMemberAccountsOutput,
        crate::error::ListMemberAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_member_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_member_accounts_response(response)
        }
    }
}

/// Operation shape for `ListPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policies`](crate::client::Client::list_policies).
///
/// See [`crate::client::fluent_builders::ListPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPolicies {
    _private: (),
}
impl ListPolicies {
    /// Creates a new builder-style object to manufacture [`ListPoliciesInput`](crate::input::ListPoliciesInput)
    pub fn builder() -> crate::input::list_policies_input::Builder {
        crate::input::list_policies_input::Builder::default()
    }
    /// Creates a new `ListPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPolicies {
    type Output =
        std::result::Result<crate::output::ListPoliciesOutput, crate::error::ListPoliciesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policies_error(response)
        } else {
            crate::operation_deser::parse_list_policies_response(response)
        }
    }
}

/// Operation shape for `ListProtocolsLists`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_protocols_lists`](crate::client::Client::list_protocols_lists).
///
/// See [`crate::client::fluent_builders::ListProtocolsLists`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProtocolsLists {
    _private: (),
}
impl ListProtocolsLists {
    /// Creates a new builder-style object to manufacture [`ListProtocolsListsInput`](crate::input::ListProtocolsListsInput)
    pub fn builder() -> crate::input::list_protocols_lists_input::Builder {
        crate::input::list_protocols_lists_input::Builder::default()
    }
    /// Creates a new `ListProtocolsLists` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProtocolsLists {
    type Output = std::result::Result<
        crate::output::ListProtocolsListsOutput,
        crate::error::ListProtocolsListsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_protocols_lists_error(response)
        } else {
            crate::operation_deser::parse_list_protocols_lists_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListThirdPartyFirewallFirewallPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_third_party_firewall_firewall_policies`](crate::client::Client::list_third_party_firewall_firewall_policies).
///
/// See [`crate::client::fluent_builders::ListThirdPartyFirewallFirewallPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThirdPartyFirewallFirewallPolicies {
    _private: (),
}
impl ListThirdPartyFirewallFirewallPolicies {
    /// Creates a new builder-style object to manufacture [`ListThirdPartyFirewallFirewallPoliciesInput`](crate::input::ListThirdPartyFirewallFirewallPoliciesInput)
    pub fn builder() -> crate::input::list_third_party_firewall_firewall_policies_input::Builder {
        crate::input::list_third_party_firewall_firewall_policies_input::Builder::default()
    }
    /// Creates a new `ListThirdPartyFirewallFirewallPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThirdPartyFirewallFirewallPolicies {
    type Output = std::result::Result<
        crate::output::ListThirdPartyFirewallFirewallPoliciesOutput,
        crate::error::ListThirdPartyFirewallFirewallPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_third_party_firewall_firewall_policies_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_third_party_firewall_firewall_policies_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutAppsList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_apps_list`](crate::client::Client::put_apps_list).
///
/// See [`crate::client::fluent_builders::PutAppsList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAppsList {
    _private: (),
}
impl PutAppsList {
    /// Creates a new builder-style object to manufacture [`PutAppsListInput`](crate::input::PutAppsListInput)
    pub fn builder() -> crate::input::put_apps_list_input::Builder {
        crate::input::put_apps_list_input::Builder::default()
    }
    /// Creates a new `PutAppsList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAppsList {
    type Output =
        std::result::Result<crate::output::PutAppsListOutput, crate::error::PutAppsListError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_apps_list_error(response)
        } else {
            crate::operation_deser::parse_put_apps_list_response(response)
        }
    }
}

/// Operation shape for `PutNotificationChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_notification_channel`](crate::client::Client::put_notification_channel).
///
/// See [`crate::client::fluent_builders::PutNotificationChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutNotificationChannel {
    _private: (),
}
impl PutNotificationChannel {
    /// Creates a new builder-style object to manufacture [`PutNotificationChannelInput`](crate::input::PutNotificationChannelInput)
    pub fn builder() -> crate::input::put_notification_channel_input::Builder {
        crate::input::put_notification_channel_input::Builder::default()
    }
    /// Creates a new `PutNotificationChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutNotificationChannel {
    type Output = std::result::Result<
        crate::output::PutNotificationChannelOutput,
        crate::error::PutNotificationChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_notification_channel_error(response)
        } else {
            crate::operation_deser::parse_put_notification_channel_response(response)
        }
    }
}

/// Operation shape for `PutPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_policy`](crate::client::Client::put_policy).
///
/// See [`crate::client::fluent_builders::PutPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPolicy {
    _private: (),
}
impl PutPolicy {
    /// Creates a new builder-style object to manufacture [`PutPolicyInput`](crate::input::PutPolicyInput)
    pub fn builder() -> crate::input::put_policy_input::Builder {
        crate::input::put_policy_input::Builder::default()
    }
    /// Creates a new `PutPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPolicy {
    type Output = std::result::Result<crate::output::PutPolicyOutput, crate::error::PutPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_policy_error(response)
        } else {
            crate::operation_deser::parse_put_policy_response(response)
        }
    }
}

/// Operation shape for `PutProtocolsList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_protocols_list`](crate::client::Client::put_protocols_list).
///
/// See [`crate::client::fluent_builders::PutProtocolsList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutProtocolsList {
    _private: (),
}
impl PutProtocolsList {
    /// Creates a new builder-style object to manufacture [`PutProtocolsListInput`](crate::input::PutProtocolsListInput)
    pub fn builder() -> crate::input::put_protocols_list_input::Builder {
        crate::input::put_protocols_list_input::Builder::default()
    }
    /// Creates a new `PutProtocolsList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutProtocolsList {
    type Output = std::result::Result<
        crate::output::PutProtocolsListOutput,
        crate::error::PutProtocolsListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_protocols_list_error(response)
        } else {
            crate::operation_deser::parse_put_protocols_list_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
