// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateAdminAccountError {
    /// Kind of error that occurred.
    pub kind: AssociateAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateAdminAccountErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateAdminAccountErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AssociateAdminAccountErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AssociateAdminAccountErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            AssociateAdminAccountErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateAdminAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateAdminAccountError {
    fn code(&self) -> Option<&str> {
        AssociateAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateAdminAccountError {
    /// Creates a new `AssociateAdminAccountError`.
    pub fn new(kind: AssociateAdminAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateAdminAccountErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAdminAccountErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAdminAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAdminAccountErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAdminAccountErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAdminAccountErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAdminAccountErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAdminAccountErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateAdminAccountErrorKind::InternalErrorException(_inner) => Some(_inner),
            AssociateAdminAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            AssociateAdminAccountErrorKind::InvalidOperationException(_inner) => Some(_inner),
            AssociateAdminAccountErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateAdminAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppsListError {
    /// Kind of error that occurred.
    pub kind: DeleteAppsListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppsListErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppsListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppsListErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteAppsListErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteAppsListErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAppsListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppsListError {
    fn code(&self) -> Option<&str> {
        DeleteAppsListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppsListError {
    /// Creates a new `DeleteAppsListError`.
    pub fn new(kind: DeleteAppsListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppsListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppsListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppsListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppsListErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppsListErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppsListErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppsListErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppsListErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppsListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppsListErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteAppsListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppsListErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteAppsListErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteAppsListErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAppsListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNotificationChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteNotificationChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNotificationChannelErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNotificationChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNotificationChannelErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteNotificationChannelErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteNotificationChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteNotificationChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNotificationChannelError {
    fn code(&self) -> Option<&str> {
        DeleteNotificationChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNotificationChannelError {
    /// Creates a new `DeleteNotificationChannelError`.
    pub fn new(kind: DeleteNotificationChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNotificationChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNotificationChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNotificationChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNotificationChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNotificationChannelErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationChannelErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNotificationChannelErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationChannelErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNotificationChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationChannelErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteNotificationChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNotificationChannelErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteNotificationChannelErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteNotificationChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteNotificationChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyError {
    fn code(&self) -> Option<&str> {
        DeletePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyError {
    /// Creates a new `DeletePolicyError`.
    pub fn new(kind: DeletePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeletePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeletePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProtocolsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProtocolsListError {
    /// Kind of error that occurred.
    pub kind: DeleteProtocolsListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProtocolsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProtocolsListErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProtocolsListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProtocolsListErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteProtocolsListErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteProtocolsListErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProtocolsListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProtocolsListError {
    fn code(&self) -> Option<&str> {
        DeleteProtocolsListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProtocolsListError {
    /// Creates a new `DeleteProtocolsListError`.
    pub fn new(kind: DeleteProtocolsListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProtocolsListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProtocolsListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProtocolsListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProtocolsListErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProtocolsListErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtocolsListErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProtocolsListErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtocolsListErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProtocolsListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtocolsListErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteProtocolsListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProtocolsListErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteProtocolsListErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteProtocolsListErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProtocolsListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateAdminAccountError {
    /// Kind of error that occurred.
    pub kind: DisassociateAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateAdminAccountErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateAdminAccountErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DisassociateAdminAccountErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DisassociateAdminAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateAdminAccountError {
    fn code(&self) -> Option<&str> {
        DisassociateAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateAdminAccountError {
    /// Creates a new `DisassociateAdminAccountError`.
    pub fn new(kind: DisassociateAdminAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateAdminAccountErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAdminAccountErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAdminAccountErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAdminAccountErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateAdminAccountErrorKind::InternalErrorException(_inner) => Some(_inner),
            DisassociateAdminAccountErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DisassociateAdminAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAdminAccountError {
    /// Kind of error that occurred.
    pub kind: GetAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAdminAccountErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAdminAccountErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetAdminAccountErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            GetAdminAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAdminAccountError {
    fn code(&self) -> Option<&str> {
        GetAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAdminAccountError {
    /// Creates a new `GetAdminAccountError`.
    pub fn new(kind: GetAdminAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAdminAccountErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdminAccountErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdminAccountErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdminAccountErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAdminAccountErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetAdminAccountErrorKind::InvalidOperationException(_inner) => Some(_inner),
            GetAdminAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppsListError {
    /// Kind of error that occurred.
    pub kind: GetAppsListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppsListErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppsListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppsListErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetAppsListErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            GetAppsListErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAppsListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppsListError {
    fn code(&self) -> Option<&str> {
        GetAppsListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppsListError {
    /// Creates a new `GetAppsListError`.
    pub fn new(kind: GetAppsListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppsListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppsListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppsListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppsListErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAppsListErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetAppsListErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetAppsListErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppsListErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppsListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppsListErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetAppsListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppsListErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetAppsListErrorKind::InvalidOperationException(_inner) => Some(_inner),
            GetAppsListErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAppsListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComplianceDetail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComplianceDetailError {
    /// Kind of error that occurred.
    pub kind: GetComplianceDetailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComplianceDetail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComplianceDetailErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComplianceDetailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComplianceDetailErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetComplianceDetailErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetComplianceDetailErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            GetComplianceDetailErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetComplianceDetailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComplianceDetailError {
    fn code(&self) -> Option<&str> {
        GetComplianceDetailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComplianceDetailError {
    /// Creates a new `GetComplianceDetailError`.
    pub fn new(kind: GetComplianceDetailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComplianceDetailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComplianceDetailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComplianceDetailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComplianceDetailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetComplianceDetailErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComplianceDetailErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComplianceDetailErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComplianceDetailErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetComplianceDetailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComplianceDetailErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetComplianceDetailErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetComplianceDetailErrorKind::InvalidOperationException(_inner) => Some(_inner),
            GetComplianceDetailErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetComplianceDetailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNotificationChannelError {
    /// Kind of error that occurred.
    pub kind: GetNotificationChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNotificationChannelErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNotificationChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNotificationChannelErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetNotificationChannelErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            GetNotificationChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetNotificationChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNotificationChannelError {
    fn code(&self) -> Option<&str> {
        GetNotificationChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNotificationChannelError {
    /// Creates a new `GetNotificationChannelError`.
    pub fn new(kind: GetNotificationChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNotificationChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNotificationChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNotificationChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNotificationChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNotificationChannelErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNotificationChannelErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNotificationChannelErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNotificationChannelErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNotificationChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNotificationChannelErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetNotificationChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNotificationChannelErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetNotificationChannelErrorKind::InvalidOperationException(_inner) => Some(_inner),
            GetNotificationChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetNotificationChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The value of the <code>Type</code> parameter is invalid.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyError {
    fn code(&self) -> Option<&str> {
        GetPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyError {
    /// Creates a new `GetPolicyError`.
    pub fn new(kind: GetPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InvalidOperationException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InvalidTypeException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for GetPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetPolicyErrorKind::InvalidOperationException(_inner) => Some(_inner),
            GetPolicyErrorKind::InvalidTypeException(_inner) => Some(_inner),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProtectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProtectionStatusError {
    /// Kind of error that occurred.
    pub kind: GetProtectionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProtectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProtectionStatusErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProtectionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProtectionStatusErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetProtectionStatusErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetProtectionStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetProtectionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProtectionStatusError {
    fn code(&self) -> Option<&str> {
        GetProtectionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProtectionStatusError {
    /// Creates a new `GetProtectionStatusError`.
    pub fn new(kind: GetProtectionStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProtectionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProtectionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProtectionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProtectionStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProtectionStatusErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProtectionStatusErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProtectionStatusErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProtectionStatusErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProtectionStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProtectionStatusErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetProtectionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProtectionStatusErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetProtectionStatusErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetProtectionStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetProtectionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProtocolsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProtocolsListError {
    /// Kind of error that occurred.
    pub kind: GetProtocolsListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProtocolsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProtocolsListErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProtocolsListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProtocolsListErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetProtocolsListErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            GetProtocolsListErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetProtocolsListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProtocolsListError {
    fn code(&self) -> Option<&str> {
        GetProtocolsListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProtocolsListError {
    /// Creates a new `GetProtocolsListError`.
    pub fn new(kind: GetProtocolsListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProtocolsListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProtocolsListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProtocolsListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProtocolsListErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProtocolsListErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProtocolsListErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProtocolsListErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProtocolsListErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProtocolsListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProtocolsListErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetProtocolsListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProtocolsListErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetProtocolsListErrorKind::InvalidOperationException(_inner) => Some(_inner),
            GetProtocolsListErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetProtocolsListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetViolationDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetViolationDetailsError {
    /// Kind of error that occurred.
    pub kind: GetViolationDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetViolationDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetViolationDetailsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetViolationDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetViolationDetailsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetViolationDetailsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetViolationDetailsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetViolationDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetViolationDetailsError {
    fn code(&self) -> Option<&str> {
        GetViolationDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetViolationDetailsError {
    /// Creates a new `GetViolationDetailsError`.
    pub fn new(kind: GetViolationDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetViolationDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetViolationDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetViolationDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetViolationDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetViolationDetailsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetViolationDetailsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetViolationDetailsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetViolationDetailsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetViolationDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetViolationDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetViolationDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetViolationDetailsErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetViolationDetailsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetViolationDetailsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetViolationDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAppsLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAppsListsError {
    /// Kind of error that occurred.
    pub kind: ListAppsListsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAppsLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAppsListsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAppsListsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAppsListsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListAppsListsErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            ListAppsListsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListAppsListsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAppsListsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAppsListsError {
    fn code(&self) -> Option<&str> {
        ListAppsListsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAppsListsError {
    /// Creates a new `ListAppsListsError`.
    pub fn new(kind: ListAppsListsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAppsListsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAppsListsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAppsListsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAppsListsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAppsListsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppsListsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppsListsErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppsListsErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppsListsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppsListsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppsListsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppsListsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListAppsListsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAppsListsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListAppsListsErrorKind::InvalidOperationException(_inner) => Some(_inner),
            ListAppsListsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListAppsListsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAppsListsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListComplianceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListComplianceStatusError {
    /// Kind of error that occurred.
    pub kind: ListComplianceStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListComplianceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListComplianceStatusErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListComplianceStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListComplianceStatusErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListComplianceStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListComplianceStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListComplianceStatusError {
    fn code(&self) -> Option<&str> {
        ListComplianceStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListComplianceStatusError {
    /// Creates a new `ListComplianceStatusError`.
    pub fn new(kind: ListComplianceStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListComplianceStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListComplianceStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListComplianceStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListComplianceStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListComplianceStatusErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceStatusErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComplianceStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceStatusErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListComplianceStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListComplianceStatusErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListComplianceStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListComplianceStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMemberAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMemberAccountsError {
    /// Kind of error that occurred.
    pub kind: ListMemberAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMemberAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMemberAccountsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMemberAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMemberAccountsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListMemberAccountsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMemberAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMemberAccountsError {
    fn code(&self) -> Option<&str> {
        ListMemberAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMemberAccountsError {
    /// Creates a new `ListMemberAccountsError`.
    pub fn new(kind: ListMemberAccountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMemberAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMemberAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMemberAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMemberAccountsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMemberAccountsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMemberAccountsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMemberAccountsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMemberAccountsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListMemberAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMemberAccountsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListMemberAccountsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMemberAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPoliciesErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPoliciesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPoliciesError {
    fn code(&self) -> Option<&str> {
        ListPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPoliciesError {
    /// Creates a new `ListPoliciesError`.
    pub fn new(kind: ListPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ListPoliciesErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListPoliciesErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPoliciesErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListPoliciesErrorKind::InvalidOperationException(_inner) => Some(_inner),
            ListPoliciesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListPoliciesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProtocolsLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProtocolsListsError {
    /// Kind of error that occurred.
    pub kind: ListProtocolsListsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProtocolsLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProtocolsListsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProtocolsListsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProtocolsListsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListProtocolsListsErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            ListProtocolsListsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProtocolsListsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProtocolsListsError {
    fn code(&self) -> Option<&str> {
        ListProtocolsListsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProtocolsListsError {
    /// Creates a new `ListProtocolsListsError`.
    pub fn new(kind: ListProtocolsListsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProtocolsListsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProtocolsListsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProtocolsListsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProtocolsListsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProtocolsListsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtocolsListsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProtocolsListsErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtocolsListsErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProtocolsListsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtocolsListsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListProtocolsListsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProtocolsListsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListProtocolsListsErrorKind::InvalidOperationException(_inner) => Some(_inner),
            ListProtocolsListsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProtocolsListsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidOperationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAppsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAppsListError {
    /// Kind of error that occurred.
    pub kind: PutAppsListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAppsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAppsListErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAppsListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAppsListErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            PutAppsListErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutAppsListErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            PutAppsListErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutAppsListErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutAppsListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAppsListError {
    fn code(&self) -> Option<&str> {
        PutAppsListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAppsListError {
    /// Creates a new `PutAppsListError`.
    pub fn new(kind: PutAppsListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAppsListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAppsListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAppsListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAppsListErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAppsListErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, PutAppsListErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `PutAppsListErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, PutAppsListErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `PutAppsListErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppsListErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAppsListErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutAppsListErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutAppsListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppsListErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutAppsListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAppsListErrorKind::InternalErrorException(_inner) => Some(_inner),
            PutAppsListErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutAppsListErrorKind::InvalidOperationException(_inner) => Some(_inner),
            PutAppsListErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutAppsListErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutAppsListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutNotificationChannelError {
    /// Kind of error that occurred.
    pub kind: PutNotificationChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutNotificationChannelErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutNotificationChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutNotificationChannelErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            PutNotificationChannelErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            PutNotificationChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutNotificationChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutNotificationChannelError {
    fn code(&self) -> Option<&str> {
        PutNotificationChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutNotificationChannelError {
    /// Creates a new `PutNotificationChannelError`.
    pub fn new(kind: PutNotificationChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutNotificationChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutNotificationChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutNotificationChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutNotificationChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutNotificationChannelErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutNotificationChannelErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutNotificationChannelErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutNotificationChannelErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutNotificationChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutNotificationChannelErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutNotificationChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutNotificationChannelErrorKind::InternalErrorException(_inner) => Some(_inner),
            PutNotificationChannelErrorKind::InvalidOperationException(_inner) => Some(_inner),
            PutNotificationChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutNotificationChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPolicyError {
    /// Kind of error that occurred.
    pub kind: PutPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPolicyErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The value of the <code>Type</code> parameter is invalid.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPolicyErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPolicyError {
    fn code(&self) -> Option<&str> {
        PutPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPolicyError {
    /// Creates a new `PutPolicyError`.
    pub fn new(kind: PutPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::InvalidOperationException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::InvalidTypeException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for PutPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPolicyErrorKind::InternalErrorException(_inner) => Some(_inner),
            PutPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutPolicyErrorKind::InvalidOperationException(_inner) => Some(_inner),
            PutPolicyErrorKind::InvalidTypeException(_inner) => Some(_inner),
            PutPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutProtocolsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutProtocolsListError {
    /// Kind of error that occurred.
    pub kind: PutProtocolsListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutProtocolsList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutProtocolsListErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutProtocolsListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutProtocolsListErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            PutProtocolsListErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutProtocolsListErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            PutProtocolsListErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutProtocolsListErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutProtocolsListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutProtocolsListError {
    fn code(&self) -> Option<&str> {
        PutProtocolsListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutProtocolsListError {
    /// Creates a new `PutProtocolsListError`.
    pub fn new(kind: PutProtocolsListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutProtocolsListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutProtocolsListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutProtocolsListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutProtocolsListErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutProtocolsListErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProtocolsListErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProtocolsListErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProtocolsListErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProtocolsListErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProtocolsListErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProtocolsListErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProtocolsListErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProtocolsListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProtocolsListErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutProtocolsListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutProtocolsListErrorKind::InternalErrorException(_inner) => Some(_inner),
            PutProtocolsListErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutProtocolsListErrorKind::InvalidOperationException(_inner) => Some(_inner),
            PutProtocolsListErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutProtocolsListErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutProtocolsListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of
    /// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
    /// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
    /// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidOperationException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry
    /// your request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The parameters of the request were invalid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
    /// submitted an <code>AssociateAdminAccount</code> request for an account ID that
    /// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
    /// that's disabled by default, and that you need to enable for the Firewall Manager         
    /// administrator account and for Organizations before you can access it.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidOperationException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The operation failed because there was nothing to do or the operation wasn't possible. For example, you might have
/// submitted an <code>AssociateAdminAccount</code> request for an account ID that
/// was already set as the Firewall Manager administrator. Or you might have tried to access a Region
/// that's disabled by default, and that you need to enable for the Firewall Manager         
/// administrator account and for Organizations before you can access it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOperationException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOperationException {}
/// See [`InvalidOperationException`](crate::error::InvalidOperationException)
pub mod invalid_operation_exception {
    /// A builder for [`InvalidOperationException`](crate::error::InvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOperationException`](crate::error::InvalidOperationException)
        pub fn build(self) -> crate::error::InvalidOperationException {
            crate::error::InvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl InvalidOperationException {
    /// Creates a new builder-style object to manufacture [`InvalidOperationException`](crate::error::InvalidOperationException)
    pub fn builder() -> crate::error::invalid_operation_exception::Builder {
        crate::error::invalid_operation_exception::Builder::default()
    }
}

/// <p>The parameters of the request were invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>The operation failed because of a system problem, even though the request was valid. Retry
/// your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalErrorException {}
/// See [`InternalErrorException`](crate::error::InternalErrorException)
pub mod internal_error_exception {
    /// A builder for [`InternalErrorException`](crate::error::InternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalErrorException`](crate::error::InternalErrorException)
        pub fn build(self) -> crate::error::InternalErrorException {
            crate::error::InternalErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalErrorException {
    /// Creates a new builder-style object to manufacture [`InternalErrorException`](crate::error::InternalErrorException)
    pub fn builder() -> crate::error::internal_error_exception::Builder {
        crate::error::internal_error_exception::Builder::default()
    }
}

/// <p>The operation exceeds a resource limit, for example, the maximum number of
/// <code>policy</code> objects that you can create for an Amazon Web Services account. For more information,
/// see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall
/// Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The value of the <code>Type</code> parameter is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTypeException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTypeException {}
/// See [`InvalidTypeException`](crate::error::InvalidTypeException)
pub mod invalid_type_exception {
    /// A builder for [`InvalidTypeException`](crate::error::InvalidTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTypeException`](crate::error::InvalidTypeException)
        pub fn build(self) -> crate::error::InvalidTypeException {
            crate::error::InvalidTypeException {
                message: self.message,
            }
        }
    }
}
impl InvalidTypeException {
    /// Creates a new builder-style object to manufacture [`InvalidTypeException`](crate::error::InvalidTypeException)
    pub fn builder() -> crate::error::invalid_type_exception::Builder {
        crate::error::invalid_type_exception::Builder::default()
    }
}
