// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Fault Injection Simulator
///
/// Client for invoking operations on AWS Fault Injection Simulator. Each operation on AWS Fault Injection Simulator is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_fis::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_fis::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_fis::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateExperimentTemplate`](crate::client::fluent_builders::CreateExperimentTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateExperimentTemplate::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateExperimentTemplate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_description): <p>A description for the experiment template.</p>
    ///   - [`stop_conditions(Vec<CreateExperimentTemplateStopConditionInput>)`](crate::client::fluent_builders::CreateExperimentTemplate::stop_conditions) / [`set_stop_conditions(Option<Vec<CreateExperimentTemplateStopConditionInput>>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_stop_conditions): <p>The stop conditions.</p>
    ///   - [`targets(HashMap<String, CreateExperimentTemplateTargetInput>)`](crate::client::fluent_builders::CreateExperimentTemplate::targets) / [`set_targets(Option<HashMap<String, CreateExperimentTemplateTargetInput>>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_targets): <p>The targets for the experiment.</p>
    ///   - [`actions(HashMap<String, CreateExperimentTemplateActionInput>)`](crate::client::fluent_builders::CreateExperimentTemplate::actions) / [`set_actions(Option<HashMap<String, CreateExperimentTemplateActionInput>>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_actions): <p>The actions for the experiment.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateExperimentTemplate::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateExperimentTemplate::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_tags): <p>The tags to apply to the experiment template.</p>
    ///   - [`log_configuration(CreateExperimentTemplateLogConfigurationInput)`](crate::client::fluent_builders::CreateExperimentTemplate::log_configuration) / [`set_log_configuration(Option<CreateExperimentTemplateLogConfigurationInput>)`](crate::client::fluent_builders::CreateExperimentTemplate::set_log_configuration): <p>The configuration for experiment logging.</p>
    /// - On success, responds with [`CreateExperimentTemplateOutput`](crate::output::CreateExperimentTemplateOutput) with field(s):
    ///   - [`experiment_template(Option<ExperimentTemplate>)`](crate::output::CreateExperimentTemplateOutput::experiment_template): <p>Information about the experiment template.</p>
    /// - On failure, responds with [`SdkError<CreateExperimentTemplateError>`](crate::error::CreateExperimentTemplateError)
    pub fn create_experiment_template(&self) -> fluent_builders::CreateExperimentTemplate {
        fluent_builders::CreateExperimentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteExperimentTemplate`](crate::client::fluent_builders::DeleteExperimentTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteExperimentTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteExperimentTemplate::set_id): <p>The ID of the experiment template.</p>
    /// - On success, responds with [`DeleteExperimentTemplateOutput`](crate::output::DeleteExperimentTemplateOutput) with field(s):
    ///   - [`experiment_template(Option<ExperimentTemplate>)`](crate::output::DeleteExperimentTemplateOutput::experiment_template): <p>Information about the experiment template.</p>
    /// - On failure, responds with [`SdkError<DeleteExperimentTemplateError>`](crate::error::DeleteExperimentTemplateError)
    pub fn delete_experiment_template(&self) -> fluent_builders::DeleteExperimentTemplate {
        fluent_builders::DeleteExperimentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAction`](crate::client::fluent_builders::GetAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetAction::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetAction::set_id): <p>The ID of the action.</p>
    /// - On success, responds with [`GetActionOutput`](crate::output::GetActionOutput) with field(s):
    ///   - [`action(Option<Action>)`](crate::output::GetActionOutput::action): <p>Information about the action.</p>
    /// - On failure, responds with [`SdkError<GetActionError>`](crate::error::GetActionError)
    pub fn get_action(&self) -> fluent_builders::GetAction {
        fluent_builders::GetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExperiment`](crate::client::fluent_builders::GetExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetExperiment::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetExperiment::set_id): <p>The ID of the experiment.</p>
    /// - On success, responds with [`GetExperimentOutput`](crate::output::GetExperimentOutput) with field(s):
    ///   - [`experiment(Option<Experiment>)`](crate::output::GetExperimentOutput::experiment): <p>Information about the experiment.</p>
    /// - On failure, responds with [`SdkError<GetExperimentError>`](crate::error::GetExperimentError)
    pub fn get_experiment(&self) -> fluent_builders::GetExperiment {
        fluent_builders::GetExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExperimentTemplate`](crate::client::fluent_builders::GetExperimentTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetExperimentTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetExperimentTemplate::set_id): <p>The ID of the experiment template.</p>
    /// - On success, responds with [`GetExperimentTemplateOutput`](crate::output::GetExperimentTemplateOutput) with field(s):
    ///   - [`experiment_template(Option<ExperimentTemplate>)`](crate::output::GetExperimentTemplateOutput::experiment_template): <p>Information about the experiment template.</p>
    /// - On failure, responds with [`SdkError<GetExperimentTemplateError>`](crate::error::GetExperimentTemplateError)
    pub fn get_experiment_template(&self) -> fluent_builders::GetExperimentTemplate {
        fluent_builders::GetExperimentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTargetResourceType`](crate::client::fluent_builders::GetTargetResourceType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::GetTargetResourceType::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::GetTargetResourceType::set_resource_type): <p>The resource type.</p>
    /// - On success, responds with [`GetTargetResourceTypeOutput`](crate::output::GetTargetResourceTypeOutput) with field(s):
    ///   - [`target_resource_type(Option<TargetResourceType>)`](crate::output::GetTargetResourceTypeOutput::target_resource_type): <p>Information about the resource type.</p>
    /// - On failure, responds with [`SdkError<GetTargetResourceTypeError>`](crate::error::GetTargetResourceTypeError)
    pub fn get_target_resource_type(&self) -> fluent_builders::GetTargetResourceType {
        fluent_builders::GetTargetResourceType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListActions`](crate::client::fluent_builders::ListActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListActions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListActions::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListActions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListActions::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListActionsOutput`](crate::output::ListActionsOutput) with field(s):
    ///   - [`actions(Option<Vec<ActionSummary>>)`](crate::output::ListActionsOutput::actions): <p>The actions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListActionsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListActionsError>`](crate::error::ListActionsError)
    pub fn list_actions(&self) -> fluent_builders::ListActions {
        fluent_builders::ListActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExperiments`](crate::client::fluent_builders::ListExperiments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExperiments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExperiments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExperiments::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExperiments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExperiments::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListExperimentsOutput`](crate::output::ListExperimentsOutput) with field(s):
    ///   - [`experiments(Option<Vec<ExperimentSummary>>)`](crate::output::ListExperimentsOutput::experiments): <p>The experiments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExperimentsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListExperimentsError>`](crate::error::ListExperimentsError)
    pub fn list_experiments(&self) -> fluent_builders::ListExperiments {
        fluent_builders::ListExperiments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExperimentTemplates`](crate::client::fluent_builders::ListExperimentTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExperimentTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExperimentTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExperimentTemplates::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExperimentTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExperimentTemplates::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListExperimentTemplatesOutput`](crate::output::ListExperimentTemplatesOutput) with field(s):
    ///   - [`experiment_templates(Option<Vec<ExperimentTemplateSummary>>)`](crate::output::ListExperimentTemplatesOutput::experiment_templates): <p>The experiment templates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExperimentTemplatesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListExperimentTemplatesError>`](crate::error::ListExperimentTemplatesError)
    pub fn list_experiment_templates(&self) -> fluent_builders::ListExperimentTemplates {
        fluent_builders::ListExperimentTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags for the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTargetResourceTypes`](crate::client::fluent_builders::ListTargetResourceTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTargetResourceTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTargetResourceTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTargetResourceTypes::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTargetResourceTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTargetResourceTypes::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListTargetResourceTypesOutput`](crate::output::ListTargetResourceTypesOutput) with field(s):
    ///   - [`target_resource_types(Option<Vec<TargetResourceTypeSummary>>)`](crate::output::ListTargetResourceTypesOutput::target_resource_types): <p>The target resource types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTargetResourceTypesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListTargetResourceTypesError>`](crate::error::ListTargetResourceTypesError)
    pub fn list_target_resource_types(&self) -> fluent_builders::ListTargetResourceTypes {
        fluent_builders::ListTargetResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartExperiment`](crate::client::fluent_builders::StartExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartExperiment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartExperiment::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`experiment_template_id(impl Into<String>)`](crate::client::fluent_builders::StartExperiment::experiment_template_id) / [`set_experiment_template_id(Option<String>)`](crate::client::fluent_builders::StartExperiment::set_experiment_template_id): <p>The ID of the experiment template.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartExperiment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartExperiment::set_tags): <p>The tags to apply to the experiment.</p>
    /// - On success, responds with [`StartExperimentOutput`](crate::output::StartExperimentOutput) with field(s):
    ///   - [`experiment(Option<Experiment>)`](crate::output::StartExperimentOutput::experiment): <p>Information about the experiment.</p>
    /// - On failure, responds with [`SdkError<StartExperimentError>`](crate::error::StartExperimentError)
    pub fn start_experiment(&self) -> fluent_builders::StartExperiment {
        fluent_builders::StartExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopExperiment`](crate::client::fluent_builders::StopExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::StopExperiment::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::StopExperiment::set_id): <p>The ID of the experiment.</p>
    /// - On success, responds with [`StopExperimentOutput`](crate::output::StopExperimentOutput) with field(s):
    ///   - [`experiment(Option<Experiment>)`](crate::output::StopExperimentOutput::experiment): <p>Information about the experiment.</p>
    /// - On failure, responds with [`SdkError<StopExperimentError>`](crate::error::StopExperimentError)
    pub fn stop_experiment(&self) -> fluent_builders::StopExperiment {
        fluent_builders::StopExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags for the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateExperimentTemplate`](crate::client::fluent_builders::UpdateExperimentTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateExperimentTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateExperimentTemplate::set_id): <p>The ID of the experiment template.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateExperimentTemplate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateExperimentTemplate::set_description): <p>A description for the template.</p>
    ///   - [`stop_conditions(Vec<UpdateExperimentTemplateStopConditionInput>)`](crate::client::fluent_builders::UpdateExperimentTemplate::stop_conditions) / [`set_stop_conditions(Option<Vec<UpdateExperimentTemplateStopConditionInput>>)`](crate::client::fluent_builders::UpdateExperimentTemplate::set_stop_conditions): <p>The stop conditions for the experiment.</p>
    ///   - [`targets(HashMap<String, UpdateExperimentTemplateTargetInput>)`](crate::client::fluent_builders::UpdateExperimentTemplate::targets) / [`set_targets(Option<HashMap<String, UpdateExperimentTemplateTargetInput>>)`](crate::client::fluent_builders::UpdateExperimentTemplate::set_targets): <p>The targets for the experiment.</p>
    ///   - [`actions(HashMap<String, UpdateExperimentTemplateActionInputItem>)`](crate::client::fluent_builders::UpdateExperimentTemplate::actions) / [`set_actions(Option<HashMap<String, UpdateExperimentTemplateActionInputItem>>)`](crate::client::fluent_builders::UpdateExperimentTemplate::set_actions): <p>The actions for the experiment.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateExperimentTemplate::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateExperimentTemplate::set_role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>
    ///   - [`log_configuration(UpdateExperimentTemplateLogConfigurationInput)`](crate::client::fluent_builders::UpdateExperimentTemplate::log_configuration) / [`set_log_configuration(Option<UpdateExperimentTemplateLogConfigurationInput>)`](crate::client::fluent_builders::UpdateExperimentTemplate::set_log_configuration): <p>The configuration for experiment logging.</p>
    /// - On success, responds with [`UpdateExperimentTemplateOutput`](crate::output::UpdateExperimentTemplateOutput) with field(s):
    ///   - [`experiment_template(Option<ExperimentTemplate>)`](crate::output::UpdateExperimentTemplateOutput::experiment_template): <p>Information about the experiment template.</p>
    /// - On failure, responds with [`SdkError<UpdateExperimentTemplateError>`](crate::error::UpdateExperimentTemplateError)
    pub fn update_experiment_template(&self) -> fluent_builders::UpdateExperimentTemplate {
        fluent_builders::UpdateExperimentTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateExperimentTemplate`.
    ///
    /// <p>Creates an experiment template. </p>
    /// <p>An experiment template includes the following components:</p>
    /// <ul>
    /// <li> <p> <b>Targets</b>: A target can be a specific resource in your Amazon Web Services environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.</p> </li>
    /// <li> <p> <b>Actions</b>: The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.</p> </li>
    /// <li> <p> <b>Stop conditions</b>: If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the <i>Fault Injection Simulator User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExperimentTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_experiment_template_input::Builder,
    }
    impl CreateExperimentTemplate {
        /// Creates a new `CreateExperimentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExperimentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExperimentTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A description for the experiment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the experiment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `stopConditions`.
        ///
        /// To override the contents of this collection use [`set_stop_conditions`](Self::set_stop_conditions).
        ///
        /// <p>The stop conditions.</p>
        pub fn stop_conditions(
            mut self,
            input: crate::model::CreateExperimentTemplateStopConditionInput,
        ) -> Self {
            self.inner = self.inner.stop_conditions(input);
            self
        }
        /// <p>The stop conditions.</p>
        pub fn set_stop_conditions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateExperimentTemplateStopConditionInput>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stop_conditions(input);
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the experiment.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CreateExperimentTemplateTargetInput,
        ) -> Self {
            self.inner = self.inner.targets(k.into(), v);
            self
        }
        /// <p>The targets for the experiment.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::CreateExperimentTemplateTargetInput,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// Adds a key-value pair to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions for the experiment.</p>
        pub fn actions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CreateExperimentTemplateActionInput,
        ) -> Self {
            self.inner = self.inner.actions(k.into(), v);
            self
        }
        /// <p>The actions for the experiment.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::CreateExperimentTemplateActionInput,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the experiment template.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to apply to the experiment template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration for experiment logging.</p>
        pub fn log_configuration(
            mut self,
            input: crate::model::CreateExperimentTemplateLogConfigurationInput,
        ) -> Self {
            self.inner = self.inner.log_configuration(input);
            self
        }
        /// <p>The configuration for experiment logging.</p>
        pub fn set_log_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateExperimentTemplateLogConfigurationInput>,
        ) -> Self {
            self.inner = self.inner.set_log_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExperimentTemplate`.
    ///
    /// <p>Deletes the specified experiment template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteExperimentTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_experiment_template_input::Builder,
    }
    impl DeleteExperimentTemplate {
        /// Creates a new `DeleteExperimentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExperimentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExperimentTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the experiment template.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAction`.
    ///
    /// <p>Gets information about the specified FIS action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_action_input::Builder,
    }
    impl GetAction {
        /// Creates a new `GetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExperiment`.
    ///
    /// <p>Gets information about the specified experiment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_experiment_input::Builder,
    }
    impl GetExperiment {
        /// Creates a new `GetExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the experiment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the experiment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExperimentTemplate`.
    ///
    /// <p>Gets information about the specified experiment template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExperimentTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_experiment_template_input::Builder,
    }
    impl GetExperimentTemplate {
        /// Creates a new `GetExperimentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExperimentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExperimentTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the experiment template.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTargetResourceType`.
    ///
    /// <p>Gets information about the specified resource type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTargetResourceType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_target_resource_type_input::Builder,
    }
    impl GetTargetResourceType {
        /// Creates a new `GetTargetResourceType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTargetResourceTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTargetResourceTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActions`.
    ///
    /// <p>Lists the available FIS actions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_actions_input::Builder,
    }
    impl ListActions {
        /// Creates a new `ListActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListActionsPaginator {
            crate::paginator::ListActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExperiments`.
    ///
    /// <p>Lists your experiments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExperiments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_experiments_input::Builder,
    }
    impl ListExperiments {
        /// Creates a new `ListExperiments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExperimentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExperimentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExperimentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExperimentsPaginator {
            crate::paginator::ListExperimentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExperimentTemplates`.
    ///
    /// <p>Lists your experiment templates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExperimentTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_experiment_templates_input::Builder,
    }
    impl ListExperimentTemplates {
        /// Creates a new `ListExperimentTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExperimentTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExperimentTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExperimentTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExperimentTemplatesPaginator {
            crate::paginator::ListExperimentTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargetResourceTypes`.
    ///
    /// <p>Lists the target resource types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTargetResourceTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_target_resource_types_input::Builder,
    }
    impl ListTargetResourceTypes {
        /// Creates a new `ListTargetResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetResourceTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTargetResourceTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTargetResourceTypesPaginator {
            crate::paginator::ListTargetResourceTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExperiment`.
    ///
    /// <p>Starts running an experiment from the specified experiment template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_experiment_input::Builder,
    }
    impl StartExperiment {
        /// Creates a new `StartExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn experiment_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment_template_id(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_experiment_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_experiment_template_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the experiment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to apply to the experiment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopExperiment`.
    ///
    /// <p>Stops the specified experiment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_experiment_input::Builder,
    }
    impl StopExperiment {
        /// Creates a new `StopExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the experiment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the experiment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateExperimentTemplate`.
    ///
    /// <p>Updates the specified experiment template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateExperimentTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_experiment_template_input::Builder,
    }
    impl UpdateExperimentTemplate {
        /// Creates a new `UpdateExperimentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateExperimentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateExperimentTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the experiment template.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description for the template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `stopConditions`.
        ///
        /// To override the contents of this collection use [`set_stop_conditions`](Self::set_stop_conditions).
        ///
        /// <p>The stop conditions for the experiment.</p>
        pub fn stop_conditions(
            mut self,
            input: crate::model::UpdateExperimentTemplateStopConditionInput,
        ) -> Self {
            self.inner = self.inner.stop_conditions(input);
            self
        }
        /// <p>The stop conditions for the experiment.</p>
        pub fn set_stop_conditions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::UpdateExperimentTemplateStopConditionInput>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stop_conditions(input);
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the experiment.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::UpdateExperimentTemplateTargetInput,
        ) -> Self {
            self.inner = self.inner.targets(k.into(), v);
            self
        }
        /// <p>The targets for the experiment.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::UpdateExperimentTemplateTargetInput,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// Adds a key-value pair to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions for the experiment.</p>
        pub fn actions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::UpdateExperimentTemplateActionInputItem,
        ) -> Self {
            self.inner = self.inner.actions(k.into(), v);
            self
        }
        /// <p>The actions for the experiment.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::UpdateExperimentTemplateActionInputItem,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The configuration for experiment logging.</p>
        pub fn log_configuration(
            mut self,
            input: crate::model::UpdateExperimentTemplateLogConfigurationInput,
        ) -> Self {
            self.inner = self.inner.log_configuration(input);
            self
        }
        /// <p>The configuration for experiment logging.</p>
        pub fn set_log_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateExperimentTemplateLogConfigurationInput>,
        ) -> Self {
            self.inner = self.inner.set_log_configuration(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
