// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTemplate {
    /// <p>The ID of the experiment template.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description for the experiment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The targets for the experiment.</p>
    pub targets: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ExperimentTemplateTarget>,
    >,
    /// <p>The actions for the experiment.</p>
    pub actions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ExperimentTemplateAction>,
    >,
    /// <p>The stop conditions for the experiment.</p>
    pub stop_conditions:
        std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateStopCondition>>,
    /// <p>The time the experiment template was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the experiment template was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The tags for the experiment template.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ExperimentTemplate {
    /// <p>The ID of the experiment template.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description for the experiment template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The targets for the experiment.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ExperimentTemplateTarget>,
    > {
        self.targets.as_ref()
    }
    /// <p>The actions for the experiment.</p>
    pub fn actions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ExperimentTemplateAction>,
    > {
        self.actions.as_ref()
    }
    /// <p>The stop conditions for the experiment.</p>
    pub fn stop_conditions(
        &self,
    ) -> std::option::Option<&[crate::model::ExperimentTemplateStopCondition]> {
        self.stop_conditions.as_deref()
    }
    /// <p>The time the experiment template was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time the experiment template was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The tags for the experiment template.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ExperimentTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTemplate");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("targets", &self.targets);
        formatter.field("actions", &self.actions);
        formatter.field("stop_conditions", &self.stop_conditions);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ExperimentTemplate`](crate::model::ExperimentTemplate)
pub mod experiment_template {
    /// A builder for [`ExperimentTemplate`](crate::model::ExperimentTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ExperimentTemplateTarget>,
        >,
        pub(crate) actions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ExperimentTemplateAction>,
        >,
        pub(crate) stop_conditions:
            std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateStopCondition>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the experiment template.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description for the experiment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the experiment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the experiment.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExperimentTemplateTarget>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The targets for the experiment.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExperimentTemplateTarget,
                >,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Adds a key-value pair to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions for the experiment.</p>
        pub fn actions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExperimentTemplateAction>,
        ) -> Self {
            let mut hash_map = self.actions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.actions = Some(hash_map);
            self
        }
        /// <p>The actions for the experiment.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExperimentTemplateAction,
                >,
            >,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `stop_conditions`.
        ///
        /// To override the contents of this collection use [`set_stop_conditions`](Self::set_stop_conditions).
        ///
        /// <p>The stop conditions for the experiment.</p>
        pub fn stop_conditions(
            mut self,
            input: impl Into<crate::model::ExperimentTemplateStopCondition>,
        ) -> Self {
            let mut v = self.stop_conditions.unwrap_or_default();
            v.push(input.into());
            self.stop_conditions = Some(v);
            self
        }
        /// <p>The stop conditions for the experiment.</p>
        pub fn set_stop_conditions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ExperimentTemplateStopCondition>,
            >,
        ) -> Self {
            self.stop_conditions = input;
            self
        }
        /// <p>The time the experiment template was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the experiment template was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the experiment template was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the experiment template was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the experiment template.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the experiment template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTemplate`](crate::model::ExperimentTemplate)
        pub fn build(self) -> crate::model::ExperimentTemplate {
            crate::model::ExperimentTemplate {
                id: self.id,
                description: self.description,
                targets: self.targets,
                actions: self.actions,
                stop_conditions: self.stop_conditions,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                role_arn: self.role_arn,
                tags: self.tags,
            }
        }
    }
}
impl ExperimentTemplate {
    /// Creates a new builder-style object to manufacture [`ExperimentTemplate`](crate::model::ExperimentTemplate)
    pub fn builder() -> crate::model::experiment_template::Builder {
        crate::model::experiment_template::Builder::default()
    }
}

/// <p>Describes a stop condition for an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTemplateStopCondition {
    /// <p>The source for the stop condition.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ExperimentTemplateStopCondition {
    /// <p>The source for the stop condition.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ExperimentTemplateStopCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTemplateStopCondition");
        formatter.field("source", &self.source);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ExperimentTemplateStopCondition`](crate::model::ExperimentTemplateStopCondition)
pub mod experiment_template_stop_condition {
    /// A builder for [`ExperimentTemplateStopCondition`](crate::model::ExperimentTemplateStopCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source for the stop condition.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source for the stop condition.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTemplateStopCondition`](crate::model::ExperimentTemplateStopCondition)
        pub fn build(self) -> crate::model::ExperimentTemplateStopCondition {
            crate::model::ExperimentTemplateStopCondition {
                source: self.source,
                value: self.value,
            }
        }
    }
}
impl ExperimentTemplateStopCondition {
    /// Creates a new builder-style object to manufacture [`ExperimentTemplateStopCondition`](crate::model::ExperimentTemplateStopCondition)
    pub fn builder() -> crate::model::experiment_template_stop_condition::Builder {
        crate::model::experiment_template_stop_condition::Builder::default()
    }
}

/// <p>Describes an action for an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTemplateAction {
    /// <p>The ID of the action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>A description for the action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The parameters for the action.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The targets for the action.</p>
    pub targets:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the action that must be completed before the current action starts.</p>
    pub start_after: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ExperimentTemplateAction {
    /// <p>The ID of the action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>A description for the action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The parameters for the action.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
    /// <p>The targets for the action.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.targets.as_ref()
    }
    /// <p>The name of the action that must be completed before the current action starts.</p>
    pub fn start_after(&self) -> std::option::Option<&[std::string::String]> {
        self.start_after.as_deref()
    }
}
impl std::fmt::Debug for ExperimentTemplateAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTemplateAction");
        formatter.field("action_id", &self.action_id);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("targets", &self.targets);
        formatter.field("start_after", &self.start_after);
        formatter.finish()
    }
}
/// See [`ExperimentTemplateAction`](crate::model::ExperimentTemplateAction)
pub mod experiment_template_action {
    /// A builder for [`ExperimentTemplateAction`](crate::model::ExperimentTemplateAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) start_after: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The ID of the action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>A description for the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the action.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameters for the action.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the action.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The targets for the action.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `start_after`.
        ///
        /// To override the contents of this collection use [`set_start_after`](Self::set_start_after).
        ///
        /// <p>The name of the action that must be completed before the current action starts.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.start_after.unwrap_or_default();
            v.push(input.into());
            self.start_after = Some(v);
            self
        }
        /// <p>The name of the action that must be completed before the current action starts.</p>
        pub fn set_start_after(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.start_after = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTemplateAction`](crate::model::ExperimentTemplateAction)
        pub fn build(self) -> crate::model::ExperimentTemplateAction {
            crate::model::ExperimentTemplateAction {
                action_id: self.action_id,
                description: self.description,
                parameters: self.parameters,
                targets: self.targets,
                start_after: self.start_after,
            }
        }
    }
}
impl ExperimentTemplateAction {
    /// Creates a new builder-style object to manufacture [`ExperimentTemplateAction`](crate::model::ExperimentTemplateAction)
    pub fn builder() -> crate::model::experiment_template_action::Builder {
        crate::model::experiment_template_action::Builder::default()
    }
}

/// <p>Describes a target for an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTemplateTarget {
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags for the target resources.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateTargetFilter>>,
    /// <p>Scopes the identified resources to a specific count or percentage.</p>
    pub selection_mode: std::option::Option<std::string::String>,
}
impl ExperimentTemplateTarget {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The tags for the target resources.</p>
    pub fn resource_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_tags.as_ref()
    }
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ExperimentTemplateTargetFilter]> {
        self.filters.as_deref()
    }
    /// <p>Scopes the identified resources to a specific count or percentage.</p>
    pub fn selection_mode(&self) -> std::option::Option<&str> {
        self.selection_mode.as_deref()
    }
}
impl std::fmt::Debug for ExperimentTemplateTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTemplateTarget");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("filters", &self.filters);
        formatter.field("selection_mode", &self.selection_mode);
        formatter.finish()
    }
}
/// See [`ExperimentTemplateTarget`](crate::model::ExperimentTemplateTarget)
pub mod experiment_template_target {
    /// A builder for [`ExperimentTemplateTarget`](crate::model::ExperimentTemplateTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateTargetFilter>>,
        pub(crate) selection_mode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags for the target resources.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags for the target resources.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::ExperimentTemplateTargetFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateTargetFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Scopes the identified resources to a specific count or percentage.</p>
        pub fn selection_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_mode = Some(input.into());
            self
        }
        /// <p>Scopes the identified resources to a specific count or percentage.</p>
        pub fn set_selection_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTemplateTarget`](crate::model::ExperimentTemplateTarget)
        pub fn build(self) -> crate::model::ExperimentTemplateTarget {
            crate::model::ExperimentTemplateTarget {
                resource_type: self.resource_type,
                resource_arns: self.resource_arns,
                resource_tags: self.resource_tags,
                filters: self.filters,
                selection_mode: self.selection_mode,
            }
        }
    }
}
impl ExperimentTemplateTarget {
    /// Creates a new builder-style object to manufacture [`ExperimentTemplateTarget`](crate::model::ExperimentTemplateTarget)
    pub fn builder() -> crate::model::experiment_template_target::Builder {
        crate::model::experiment_template_target::Builder::default()
    }
}

/// <p>Describes a filter used for the target resources in an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTemplateTargetFilter {
    /// <p>The attribute path for the filter.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The attribute values for the filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ExperimentTemplateTargetFilter {
    /// <p>The attribute path for the filter.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The attribute values for the filter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ExperimentTemplateTargetFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTemplateTargetFilter");
        formatter.field("path", &self.path);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ExperimentTemplateTargetFilter`](crate::model::ExperimentTemplateTargetFilter)
pub mod experiment_template_target_filter {
    /// A builder for [`ExperimentTemplateTargetFilter`](crate::model::ExperimentTemplateTargetFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The attribute path for the filter.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The attribute path for the filter.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The attribute values for the filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The attribute values for the filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTemplateTargetFilter`](crate::model::ExperimentTemplateTargetFilter)
        pub fn build(self) -> crate::model::ExperimentTemplateTargetFilter {
            crate::model::ExperimentTemplateTargetFilter {
                path: self.path,
                values: self.values,
            }
        }
    }
}
impl ExperimentTemplateTargetFilter {
    /// Creates a new builder-style object to manufacture [`ExperimentTemplateTargetFilter`](crate::model::ExperimentTemplateTargetFilter)
    pub fn builder() -> crate::model::experiment_template_target_filter::Builder {
        crate::model::experiment_template_target_filter::Builder::default()
    }
}

/// <p>Specifies an action for an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExperimentTemplateActionInputItem {
    /// <p>The ID of the action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>A description for the action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The parameters for the action, if applicable.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The targets for the action.</p>
    pub targets:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
    pub start_after: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateExperimentTemplateActionInputItem {
    /// <p>The ID of the action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>A description for the action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The parameters for the action, if applicable.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
    /// <p>The targets for the action.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.targets.as_ref()
    }
    /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
    pub fn start_after(&self) -> std::option::Option<&[std::string::String]> {
        self.start_after.as_deref()
    }
}
impl std::fmt::Debug for UpdateExperimentTemplateActionInputItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExperimentTemplateActionInputItem");
        formatter.field("action_id", &self.action_id);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("targets", &self.targets);
        formatter.field("start_after", &self.start_after);
        formatter.finish()
    }
}
/// See [`UpdateExperimentTemplateActionInputItem`](crate::model::UpdateExperimentTemplateActionInputItem)
pub mod update_experiment_template_action_input_item {
    /// A builder for [`UpdateExperimentTemplateActionInputItem`](crate::model::UpdateExperimentTemplateActionInputItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) start_after: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The ID of the action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>A description for the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the action, if applicable.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameters for the action, if applicable.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the action.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The targets for the action.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `start_after`.
        ///
        /// To override the contents of this collection use [`set_start_after`](Self::set_start_after).
        ///
        /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.start_after.unwrap_or_default();
            v.push(input.into());
            self.start_after = Some(v);
            self
        }
        /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
        pub fn set_start_after(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.start_after = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExperimentTemplateActionInputItem`](crate::model::UpdateExperimentTemplateActionInputItem)
        pub fn build(self) -> crate::model::UpdateExperimentTemplateActionInputItem {
            crate::model::UpdateExperimentTemplateActionInputItem {
                action_id: self.action_id,
                description: self.description,
                parameters: self.parameters,
                targets: self.targets,
                start_after: self.start_after,
            }
        }
    }
}
impl UpdateExperimentTemplateActionInputItem {
    /// Creates a new builder-style object to manufacture [`UpdateExperimentTemplateActionInputItem`](crate::model::UpdateExperimentTemplateActionInputItem)
    pub fn builder() -> crate::model::update_experiment_template_action_input_item::Builder {
        crate::model::update_experiment_template_action_input_item::Builder::default()
    }
}

/// <p>Specifies a target for an experiment. You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExperimentTemplateTargetInput {
    /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags for the target resources.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub filters:
        std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateTargetInputFilter>>,
    /// <p>Scopes the identified resources to a specific count or percentage.</p>
    pub selection_mode: std::option::Option<std::string::String>,
}
impl UpdateExperimentTemplateTargetInput {
    /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The tags for the target resources.</p>
    pub fn resource_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_tags.as_ref()
    }
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&[crate::model::ExperimentTemplateTargetInputFilter]> {
        self.filters.as_deref()
    }
    /// <p>Scopes the identified resources to a specific count or percentage.</p>
    pub fn selection_mode(&self) -> std::option::Option<&str> {
        self.selection_mode.as_deref()
    }
}
impl std::fmt::Debug for UpdateExperimentTemplateTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExperimentTemplateTargetInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("filters", &self.filters);
        formatter.field("selection_mode", &self.selection_mode);
        formatter.finish()
    }
}
/// See [`UpdateExperimentTemplateTargetInput`](crate::model::UpdateExperimentTemplateTargetInput)
pub mod update_experiment_template_target_input {
    /// A builder for [`UpdateExperimentTemplateTargetInput`](crate::model::UpdateExperimentTemplateTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateTargetInputFilter>>,
        pub(crate) selection_mode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the targets.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags for the target resources.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags for the target resources.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::ExperimentTemplateTargetInputFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ExperimentTemplateTargetInputFilter>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Scopes the identified resources to a specific count or percentage.</p>
        pub fn selection_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_mode = Some(input.into());
            self
        }
        /// <p>Scopes the identified resources to a specific count or percentage.</p>
        pub fn set_selection_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExperimentTemplateTargetInput`](crate::model::UpdateExperimentTemplateTargetInput)
        pub fn build(self) -> crate::model::UpdateExperimentTemplateTargetInput {
            crate::model::UpdateExperimentTemplateTargetInput {
                resource_type: self.resource_type,
                resource_arns: self.resource_arns,
                resource_tags: self.resource_tags,
                filters: self.filters,
                selection_mode: self.selection_mode,
            }
        }
    }
}
impl UpdateExperimentTemplateTargetInput {
    /// Creates a new builder-style object to manufacture [`UpdateExperimentTemplateTargetInput`](crate::model::UpdateExperimentTemplateTargetInput)
    pub fn builder() -> crate::model::update_experiment_template_target_input::Builder {
        crate::model::update_experiment_template_target_input::Builder::default()
    }
}

/// <p>Describes a filter used for the target resource input in an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTemplateTargetInputFilter {
    /// <p>The attribute path for the filter.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The attribute values for the filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ExperimentTemplateTargetInputFilter {
    /// <p>The attribute path for the filter.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The attribute values for the filter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ExperimentTemplateTargetInputFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTemplateTargetInputFilter");
        formatter.field("path", &self.path);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ExperimentTemplateTargetInputFilter`](crate::model::ExperimentTemplateTargetInputFilter)
pub mod experiment_template_target_input_filter {
    /// A builder for [`ExperimentTemplateTargetInputFilter`](crate::model::ExperimentTemplateTargetInputFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The attribute path for the filter.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The attribute path for the filter.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The attribute values for the filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The attribute values for the filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTemplateTargetInputFilter`](crate::model::ExperimentTemplateTargetInputFilter)
        pub fn build(self) -> crate::model::ExperimentTemplateTargetInputFilter {
            crate::model::ExperimentTemplateTargetInputFilter {
                path: self.path,
                values: self.values,
            }
        }
    }
}
impl ExperimentTemplateTargetInputFilter {
    /// Creates a new builder-style object to manufacture [`ExperimentTemplateTargetInputFilter`](crate::model::ExperimentTemplateTargetInputFilter)
    pub fn builder() -> crate::model::experiment_template_target_input_filter::Builder {
        crate::model::experiment_template_target_input_filter::Builder::default()
    }
}

/// <p>Specifies a stop condition for an experiment. You can define a stop condition as a CloudWatch alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExperimentTemplateStopConditionInput {
    /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
    /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
    /// condition.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm.</p>
    pub value: std::option::Option<std::string::String>,
}
impl UpdateExperimentTemplateStopConditionInput {
    /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
    /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
    /// condition.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for UpdateExperimentTemplateStopConditionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExperimentTemplateStopConditionInput");
        formatter.field("source", &self.source);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`UpdateExperimentTemplateStopConditionInput`](crate::model::UpdateExperimentTemplateStopConditionInput)
pub mod update_experiment_template_stop_condition_input {
    /// A builder for [`UpdateExperimentTemplateStopConditionInput`](crate::model::UpdateExperimentTemplateStopConditionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
        /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
        /// condition.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
        /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
        /// condition.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExperimentTemplateStopConditionInput`](crate::model::UpdateExperimentTemplateStopConditionInput)
        pub fn build(self) -> crate::model::UpdateExperimentTemplateStopConditionInput {
            crate::model::UpdateExperimentTemplateStopConditionInput {
                source: self.source,
                value: self.value,
            }
        }
    }
}
impl UpdateExperimentTemplateStopConditionInput {
    /// Creates a new builder-style object to manufacture [`UpdateExperimentTemplateStopConditionInput`](crate::model::UpdateExperimentTemplateStopConditionInput)
    pub fn builder() -> crate::model::update_experiment_template_stop_condition_input::Builder {
        crate::model::update_experiment_template_stop_condition_input::Builder::default()
    }
}

/// <p>Describes an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Experiment {
    /// <p>The ID of the experiment.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the experiment template.</p>
    pub experiment_template_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The state of the experiment.</p>
    pub state: std::option::Option<crate::model::ExperimentState>,
    /// <p>The targets for the experiment.</p>
    pub targets: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ExperimentTarget>,
    >,
    /// <p>The actions for the experiment.</p>
    pub actions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ExperimentAction>,
    >,
    /// <p>The stop conditions for the experiment.</p>
    pub stop_conditions: std::option::Option<std::vec::Vec<crate::model::ExperimentStopCondition>>,
    /// <p>The time the experiment was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the experiment was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the experiment ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags for the experiment.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Experiment {
    /// <p>The ID of the experiment.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the experiment template.</p>
    pub fn experiment_template_id(&self) -> std::option::Option<&str> {
        self.experiment_template_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The state of the experiment.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ExperimentState> {
        self.state.as_ref()
    }
    /// <p>The targets for the experiment.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ExperimentTarget>,
    > {
        self.targets.as_ref()
    }
    /// <p>The actions for the experiment.</p>
    pub fn actions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ExperimentAction>,
    > {
        self.actions.as_ref()
    }
    /// <p>The stop conditions for the experiment.</p>
    pub fn stop_conditions(&self) -> std::option::Option<&[crate::model::ExperimentStopCondition]> {
        self.stop_conditions.as_deref()
    }
    /// <p>The time the experiment was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time that the experiment was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The time that the experiment ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The tags for the experiment.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Experiment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Experiment");
        formatter.field("id", &self.id);
        formatter.field("experiment_template_id", &self.experiment_template_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("state", &self.state);
        formatter.field("targets", &self.targets);
        formatter.field("actions", &self.actions);
        formatter.field("stop_conditions", &self.stop_conditions);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Experiment`](crate::model::Experiment)
pub mod experiment {
    /// A builder for [`Experiment`](crate::model::Experiment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) experiment_template_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ExperimentState>,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ExperimentTarget>,
        >,
        pub(crate) actions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ExperimentAction>,
        >,
        pub(crate) stop_conditions:
            std::option::Option<std::vec::Vec<crate::model::ExperimentStopCondition>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the experiment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the experiment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn experiment_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_experiment_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_template_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The state of the experiment.</p>
        pub fn state(mut self, input: crate::model::ExperimentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the experiment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ExperimentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the experiment.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExperimentTarget>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The targets for the experiment.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ExperimentTarget>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Adds a key-value pair to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions for the experiment.</p>
        pub fn actions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExperimentAction>,
        ) -> Self {
            let mut hash_map = self.actions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.actions = Some(hash_map);
            self
        }
        /// <p>The actions for the experiment.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ExperimentAction>,
            >,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `stop_conditions`.
        ///
        /// To override the contents of this collection use [`set_stop_conditions`](Self::set_stop_conditions).
        ///
        /// <p>The stop conditions for the experiment.</p>
        pub fn stop_conditions(
            mut self,
            input: impl Into<crate::model::ExperimentStopCondition>,
        ) -> Self {
            let mut v = self.stop_conditions.unwrap_or_default();
            v.push(input.into());
            self.stop_conditions = Some(v);
            self
        }
        /// <p>The stop conditions for the experiment.</p>
        pub fn set_stop_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentStopCondition>>,
        ) -> Self {
            self.stop_conditions = input;
            self
        }
        /// <p>The time the experiment was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the experiment was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that the experiment was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time that the experiment was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time that the experiment ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the experiment ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the experiment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the experiment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Experiment`](crate::model::Experiment)
        pub fn build(self) -> crate::model::Experiment {
            crate::model::Experiment {
                id: self.id,
                experiment_template_id: self.experiment_template_id,
                role_arn: self.role_arn,
                state: self.state,
                targets: self.targets,
                actions: self.actions,
                stop_conditions: self.stop_conditions,
                creation_time: self.creation_time,
                start_time: self.start_time,
                end_time: self.end_time,
                tags: self.tags,
            }
        }
    }
}
impl Experiment {
    /// Creates a new builder-style object to manufacture [`Experiment`](crate::model::Experiment)
    pub fn builder() -> crate::model::experiment::Builder {
        crate::model::experiment::Builder::default()
    }
}

/// <p>Describes the stop condition for an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentStopCondition {
    /// <p>The source for the stop condition.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ExperimentStopCondition {
    /// <p>The source for the stop condition.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ExperimentStopCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentStopCondition");
        formatter.field("source", &self.source);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ExperimentStopCondition`](crate::model::ExperimentStopCondition)
pub mod experiment_stop_condition {
    /// A builder for [`ExperimentStopCondition`](crate::model::ExperimentStopCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source for the stop condition.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source for the stop condition.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentStopCondition`](crate::model::ExperimentStopCondition)
        pub fn build(self) -> crate::model::ExperimentStopCondition {
            crate::model::ExperimentStopCondition {
                source: self.source,
                value: self.value,
            }
        }
    }
}
impl ExperimentStopCondition {
    /// Creates a new builder-style object to manufacture [`ExperimentStopCondition`](crate::model::ExperimentStopCondition)
    pub fn builder() -> crate::model::experiment_stop_condition::Builder {
        crate::model::experiment_stop_condition::Builder::default()
    }
}

/// <p>Describes the action for an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentAction {
    /// <p>The ID of the action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>The description for the action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The parameters for the action.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The targets for the action.</p>
    pub targets:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the action that must be completed before this action starts.</p>
    pub start_after: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The state of the action.</p>
    pub state: std::option::Option<crate::model::ExperimentActionState>,
}
impl ExperimentAction {
    /// <p>The ID of the action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>The description for the action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The parameters for the action.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
    /// <p>The targets for the action.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.targets.as_ref()
    }
    /// <p>The name of the action that must be completed before this action starts.</p>
    pub fn start_after(&self) -> std::option::Option<&[std::string::String]> {
        self.start_after.as_deref()
    }
    /// <p>The state of the action.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ExperimentActionState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ExperimentAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentAction");
        formatter.field("action_id", &self.action_id);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("targets", &self.targets);
        formatter.field("start_after", &self.start_after);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ExperimentAction`](crate::model::ExperimentAction)
pub mod experiment_action {
    /// A builder for [`ExperimentAction`](crate::model::ExperimentAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) start_after: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state: std::option::Option<crate::model::ExperimentActionState>,
    }
    impl Builder {
        /// <p>The ID of the action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The ID of the action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>The description for the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the action.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameters for the action.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the action.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The targets for the action.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `start_after`.
        ///
        /// To override the contents of this collection use [`set_start_after`](Self::set_start_after).
        ///
        /// <p>The name of the action that must be completed before this action starts.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.start_after.unwrap_or_default();
            v.push(input.into());
            self.start_after = Some(v);
            self
        }
        /// <p>The name of the action that must be completed before this action starts.</p>
        pub fn set_start_after(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.start_after = input;
            self
        }
        /// <p>The state of the action.</p>
        pub fn state(mut self, input: crate::model::ExperimentActionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the action.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ExperimentActionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentAction`](crate::model::ExperimentAction)
        pub fn build(self) -> crate::model::ExperimentAction {
            crate::model::ExperimentAction {
                action_id: self.action_id,
                description: self.description,
                parameters: self.parameters,
                targets: self.targets,
                start_after: self.start_after,
                state: self.state,
            }
        }
    }
}
impl ExperimentAction {
    /// Creates a new builder-style object to manufacture [`ExperimentAction`](crate::model::ExperimentAction)
    pub fn builder() -> crate::model::experiment_action::Builder {
        crate::model::experiment_action::Builder::default()
    }
}

/// <p>Describes the state of an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentActionState {
    /// <p>The state of the action.</p>
    pub status: std::option::Option<crate::model::ExperimentActionStatus>,
    /// <p>The reason for the state.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl ExperimentActionState {
    /// <p>The state of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExperimentActionStatus> {
        self.status.as_ref()
    }
    /// <p>The reason for the state.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for ExperimentActionState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentActionState");
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ExperimentActionState`](crate::model::ExperimentActionState)
pub mod experiment_action_state {
    /// A builder for [`ExperimentActionState`](crate::model::ExperimentActionState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ExperimentActionStatus>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the action.</p>
        pub fn status(mut self, input: crate::model::ExperimentActionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExperimentActionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the state.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the state.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentActionState`](crate::model::ExperimentActionState)
        pub fn build(self) -> crate::model::ExperimentActionState {
            crate::model::ExperimentActionState {
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl ExperimentActionState {
    /// Creates a new builder-style object to manufacture [`ExperimentActionState`](crate::model::ExperimentActionState)
    pub fn builder() -> crate::model::experiment_action_state::Builder {
        crate::model::experiment_action_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentActionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initiating,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentActionStatus {
    fn from(s: &str) -> Self {
        match s {
            "cancelled" => ExperimentActionStatus::Cancelled,
            "completed" => ExperimentActionStatus::Completed,
            "failed" => ExperimentActionStatus::Failed,
            "initiating" => ExperimentActionStatus::Initiating,
            "pending" => ExperimentActionStatus::Pending,
            "running" => ExperimentActionStatus::Running,
            "stopped" => ExperimentActionStatus::Stopped,
            "stopping" => ExperimentActionStatus::Stopping,
            other => ExperimentActionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentActionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentActionStatus::from(s))
    }
}
impl ExperimentActionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentActionStatus::Cancelled => "cancelled",
            ExperimentActionStatus::Completed => "completed",
            ExperimentActionStatus::Failed => "failed",
            ExperimentActionStatus::Initiating => "initiating",
            ExperimentActionStatus::Pending => "pending",
            ExperimentActionStatus::Running => "running",
            ExperimentActionStatus::Stopped => "stopped",
            ExperimentActionStatus::Stopping => "stopping",
            ExperimentActionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cancelled",
            "completed",
            "failed",
            "initiating",
            "pending",
            "running",
            "stopped",
            "stopping",
        ]
    }
}
impl AsRef<str> for ExperimentActionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a target for an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTarget {
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags for the target resources.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ExperimentTargetFilter>>,
    /// <p>Scopes the identified resources to a specific count or percentage.</p>
    pub selection_mode: std::option::Option<std::string::String>,
}
impl ExperimentTarget {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The tags for the target resources.</p>
    pub fn resource_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_tags.as_ref()
    }
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ExperimentTargetFilter]> {
        self.filters.as_deref()
    }
    /// <p>Scopes the identified resources to a specific count or percentage.</p>
    pub fn selection_mode(&self) -> std::option::Option<&str> {
        self.selection_mode.as_deref()
    }
}
impl std::fmt::Debug for ExperimentTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTarget");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("filters", &self.filters);
        formatter.field("selection_mode", &self.selection_mode);
        formatter.finish()
    }
}
/// See [`ExperimentTarget`](crate::model::ExperimentTarget)
pub mod experiment_target {
    /// A builder for [`ExperimentTarget`](crate::model::ExperimentTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ExperimentTargetFilter>>,
        pub(crate) selection_mode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags for the target resources.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags for the target resources.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ExperimentTargetFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentTargetFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Scopes the identified resources to a specific count or percentage.</p>
        pub fn selection_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_mode = Some(input.into());
            self
        }
        /// <p>Scopes the identified resources to a specific count or percentage.</p>
        pub fn set_selection_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTarget`](crate::model::ExperimentTarget)
        pub fn build(self) -> crate::model::ExperimentTarget {
            crate::model::ExperimentTarget {
                resource_type: self.resource_type,
                resource_arns: self.resource_arns,
                resource_tags: self.resource_tags,
                filters: self.filters,
                selection_mode: self.selection_mode,
            }
        }
    }
}
impl ExperimentTarget {
    /// Creates a new builder-style object to manufacture [`ExperimentTarget`](crate::model::ExperimentTarget)
    pub fn builder() -> crate::model::experiment_target::Builder {
        crate::model::experiment_target::Builder::default()
    }
}

/// <p>Describes a filter used for the target resources in an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTargetFilter {
    /// <p>The attribute path for the filter.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The attribute values for the filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ExperimentTargetFilter {
    /// <p>The attribute path for the filter.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The attribute values for the filter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ExperimentTargetFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTargetFilter");
        formatter.field("path", &self.path);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ExperimentTargetFilter`](crate::model::ExperimentTargetFilter)
pub mod experiment_target_filter {
    /// A builder for [`ExperimentTargetFilter`](crate::model::ExperimentTargetFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The attribute path for the filter.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The attribute path for the filter.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The attribute values for the filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The attribute values for the filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTargetFilter`](crate::model::ExperimentTargetFilter)
        pub fn build(self) -> crate::model::ExperimentTargetFilter {
            crate::model::ExperimentTargetFilter {
                path: self.path,
                values: self.values,
            }
        }
    }
}
impl ExperimentTargetFilter {
    /// Creates a new builder-style object to manufacture [`ExperimentTargetFilter`](crate::model::ExperimentTargetFilter)
    pub fn builder() -> crate::model::experiment_target_filter::Builder {
        crate::model::experiment_target_filter::Builder::default()
    }
}

/// <p>Describes the state of an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentState {
    /// <p>The state of the experiment.</p>
    pub status: std::option::Option<crate::model::ExperimentStatus>,
    /// <p>The reason for the state.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl ExperimentState {
    /// <p>The state of the experiment.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExperimentStatus> {
        self.status.as_ref()
    }
    /// <p>The reason for the state.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for ExperimentState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentState");
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ExperimentState`](crate::model::ExperimentState)
pub mod experiment_state {
    /// A builder for [`ExperimentState`](crate::model::ExperimentState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ExperimentStatus>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the experiment.</p>
        pub fn status(mut self, input: crate::model::ExperimentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the experiment.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExperimentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the state.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the state.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentState`](crate::model::ExperimentState)
        pub fn build(self) -> crate::model::ExperimentState {
            crate::model::ExperimentState {
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl ExperimentState {
    /// Creates a new builder-style object to manufacture [`ExperimentState`](crate::model::ExperimentState)
    pub fn builder() -> crate::model::experiment_state::Builder {
        crate::model::experiment_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initiating,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentStatus {
    fn from(s: &str) -> Self {
        match s {
            "completed" => ExperimentStatus::Completed,
            "failed" => ExperimentStatus::Failed,
            "initiating" => ExperimentStatus::Initiating,
            "pending" => ExperimentStatus::Pending,
            "running" => ExperimentStatus::Running,
            "stopped" => ExperimentStatus::Stopped,
            "stopping" => ExperimentStatus::Stopping,
            other => ExperimentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentStatus::from(s))
    }
}
impl ExperimentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentStatus::Completed => "completed",
            ExperimentStatus::Failed => "failed",
            ExperimentStatus::Initiating => "initiating",
            ExperimentStatus::Pending => "pending",
            ExperimentStatus::Running => "running",
            ExperimentStatus::Stopped => "stopped",
            ExperimentStatus::Stopping => "stopping",
            ExperimentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "completed",
            "failed",
            "initiating",
            "pending",
            "running",
            "stopped",
            "stopping",
        ]
    }
}
impl AsRef<str> for ExperimentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a summary of an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentTemplateSummary {
    /// <p>The ID of the experiment template.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description of the experiment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The time that the experiment template was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the experiment template was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags for the experiment template.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ExperimentTemplateSummary {
    /// <p>The ID of the experiment template.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description of the experiment template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The time that the experiment template was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time that the experiment template was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_time.as_ref()
    }
    /// <p>The tags for the experiment template.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ExperimentTemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentTemplateSummary");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ExperimentTemplateSummary`](crate::model::ExperimentTemplateSummary)
pub mod experiment_template_summary {
    /// A builder for [`ExperimentTemplateSummary`](crate::model::ExperimentTemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the experiment template.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description of the experiment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the experiment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The time that the experiment template was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the experiment template was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that the experiment template was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time that the experiment template was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the experiment template.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the experiment template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentTemplateSummary`](crate::model::ExperimentTemplateSummary)
        pub fn build(self) -> crate::model::ExperimentTemplateSummary {
            crate::model::ExperimentTemplateSummary {
                id: self.id,
                description: self.description,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                tags: self.tags,
            }
        }
    }
}
impl ExperimentTemplateSummary {
    /// Creates a new builder-style object to manufacture [`ExperimentTemplateSummary`](crate::model::ExperimentTemplateSummary)
    pub fn builder() -> crate::model::experiment_template_summary::Builder {
        crate::model::experiment_template_summary::Builder::default()
    }
}

/// <p>Provides a summary of an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentSummary {
    /// <p>The ID of the experiment.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the experiment template.</p>
    pub experiment_template_id: std::option::Option<std::string::String>,
    /// <p>The state of the experiment.</p>
    pub state: std::option::Option<crate::model::ExperimentState>,
    /// <p>The time that the experiment was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags for the experiment.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ExperimentSummary {
    /// <p>The ID of the experiment.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the experiment template.</p>
    pub fn experiment_template_id(&self) -> std::option::Option<&str> {
        self.experiment_template_id.as_deref()
    }
    /// <p>The state of the experiment.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ExperimentState> {
        self.state.as_ref()
    }
    /// <p>The time that the experiment was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The tags for the experiment.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ExperimentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentSummary");
        formatter.field("id", &self.id);
        formatter.field("experiment_template_id", &self.experiment_template_id);
        formatter.field("state", &self.state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ExperimentSummary`](crate::model::ExperimentSummary)
pub mod experiment_summary {
    /// A builder for [`ExperimentSummary`](crate::model::ExperimentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) experiment_template_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ExperimentState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the experiment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the experiment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn experiment_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the experiment template.</p>
        pub fn set_experiment_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_template_id = input;
            self
        }
        /// <p>The state of the experiment.</p>
        pub fn state(mut self, input: crate::model::ExperimentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the experiment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ExperimentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The time that the experiment was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the experiment was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the experiment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the experiment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentSummary`](crate::model::ExperimentSummary)
        pub fn build(self) -> crate::model::ExperimentSummary {
            crate::model::ExperimentSummary {
                id: self.id,
                experiment_template_id: self.experiment_template_id,
                state: self.state,
                creation_time: self.creation_time,
                tags: self.tags,
            }
        }
    }
}
impl ExperimentSummary {
    /// Creates a new builder-style object to manufacture [`ExperimentSummary`](crate::model::ExperimentSummary)
    pub fn builder() -> crate::model::experiment_summary::Builder {
        crate::model::experiment_summary::Builder::default()
    }
}

/// <p>Provides a summary of an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionSummary {
    /// <p>The ID of the action.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description for the action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The targets for the action.</p>
    pub targets: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
    >,
    /// <p>The tags for the action.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ActionSummary {
    /// <p>The ID of the action.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description for the action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The targets for the action.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
    > {
        self.targets.as_ref()
    }
    /// <p>The tags for the action.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ActionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionSummary");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("targets", &self.targets);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ActionSummary`](crate::model::ActionSummary)
pub mod action_summary {
    /// A builder for [`ActionSummary`](crate::model::ActionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description for the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the action.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ActionTarget>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The targets for the action.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the action.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionSummary`](crate::model::ActionSummary)
        pub fn build(self) -> crate::model::ActionSummary {
            crate::model::ActionSummary {
                id: self.id,
                description: self.description,
                targets: self.targets,
                tags: self.tags,
            }
        }
    }
}
impl ActionSummary {
    /// Creates a new builder-style object to manufacture [`ActionSummary`](crate::model::ActionSummary)
    pub fn builder() -> crate::model::action_summary::Builder {
        crate::model::action_summary::Builder::default()
    }
}

/// <p>Describes a target for an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTarget {
    /// <p>The resource type of the target.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ActionTarget {
    /// <p>The resource type of the target.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ActionTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTarget");
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`ActionTarget`](crate::model::ActionTarget)
pub mod action_target {
    /// A builder for [`ActionTarget`](crate::model::ActionTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type of the target.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type of the target.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTarget`](crate::model::ActionTarget)
        pub fn build(self) -> crate::model::ActionTarget {
            crate::model::ActionTarget {
                resource_type: self.resource_type,
            }
        }
    }
}
impl ActionTarget {
    /// Creates a new builder-style object to manufacture [`ActionTarget`](crate::model::ActionTarget)
    pub fn builder() -> crate::model::action_target::Builder {
        crate::model::action_target::Builder::default()
    }
}

/// <p>Describes an action. For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html">AWS FIS actions</a>
/// in the <i>AWS Fault Injection Simulator User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>The ID of the action.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description for the action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The action parameters, if applicable.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ActionParameter>,
    >,
    /// <p>The supported targets for the action.</p>
    pub targets: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
    >,
    /// <p>The tags for the action.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Action {
    /// <p>The ID of the action.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description for the action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The action parameters, if applicable.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ActionParameter>,
    > {
        self.parameters.as_ref()
    }
    /// <p>The supported targets for the action.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
    > {
        self.targets.as_ref()
    }
    /// <p>The tags for the action.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("targets", &self.targets);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ActionParameter>,
        >,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description for the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The action parameters, if applicable.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ActionParameter>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The action parameters, if applicable.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ActionParameter>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The supported targets for the action.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ActionTarget>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The supported targets for the action.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ActionTarget>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the action.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                id: self.id,
                description: self.description,
                parameters: self.parameters,
                targets: self.targets,
                tags: self.tags,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Describes a parameter for an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionParameter {
    /// <p>The parameter description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates whether the parameter is required.</p>
    pub required: std::option::Option<bool>,
}
impl ActionParameter {
    /// <p>The parameter description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates whether the parameter is required.</p>
    pub fn required(&self) -> std::option::Option<bool> {
        self.required
    }
}
impl std::fmt::Debug for ActionParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionParameter");
        formatter.field("description", &self.description);
        formatter.field("required", &self.required);
        formatter.finish()
    }
}
/// See [`ActionParameter`](crate::model::ActionParameter)
pub mod action_parameter {
    /// A builder for [`ActionParameter`](crate::model::ActionParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) required: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The parameter description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The parameter description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether the parameter is required.</p>
        pub fn required(mut self, input: bool) -> Self {
            self.required = Some(input);
            self
        }
        /// <p>Indicates whether the parameter is required.</p>
        pub fn set_required(mut self, input: std::option::Option<bool>) -> Self {
            self.required = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionParameter`](crate::model::ActionParameter)
        pub fn build(self) -> crate::model::ActionParameter {
            crate::model::ActionParameter {
                description: self.description,
                required: self.required,
            }
        }
    }
}
impl ActionParameter {
    /// Creates a new builder-style object to manufacture [`ActionParameter`](crate::model::ActionParameter)
    pub fn builder() -> crate::model::action_parameter::Builder {
        crate::model::action_parameter::Builder::default()
    }
}

/// <p>Specifies an action for an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExperimentTemplateActionInput {
    /// <p>The ID of the action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>A description for the action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The parameters for the action, if applicable.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The targets for the action.</p>
    pub targets:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
    pub start_after: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateExperimentTemplateActionInput {
    /// <p>The ID of the action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>A description for the action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The parameters for the action, if applicable.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
    /// <p>The targets for the action.</p>
    pub fn targets(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.targets.as_ref()
    }
    /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
    pub fn start_after(&self) -> std::option::Option<&[std::string::String]> {
        self.start_after.as_deref()
    }
}
impl std::fmt::Debug for CreateExperimentTemplateActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExperimentTemplateActionInput");
        formatter.field("action_id", &self.action_id);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("targets", &self.targets);
        formatter.field("start_after", &self.start_after);
        formatter.finish()
    }
}
/// See [`CreateExperimentTemplateActionInput`](crate::model::CreateExperimentTemplateActionInput)
pub mod create_experiment_template_action_input {
    /// A builder for [`CreateExperimentTemplateActionInput`](crate::model::CreateExperimentTemplateActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) start_after: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The ID of the action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>A description for the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the action, if applicable.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameters for the action, if applicable.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the action.</p>
        pub fn targets(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The targets for the action.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `start_after`.
        ///
        /// To override the contents of this collection use [`set_start_after`](Self::set_start_after).
        ///
        /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.start_after.unwrap_or_default();
            v.push(input.into());
            self.start_after = Some(v);
            self
        }
        /// <p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>
        pub fn set_start_after(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.start_after = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExperimentTemplateActionInput`](crate::model::CreateExperimentTemplateActionInput)
        pub fn build(self) -> crate::model::CreateExperimentTemplateActionInput {
            crate::model::CreateExperimentTemplateActionInput {
                action_id: self.action_id,
                description: self.description,
                parameters: self.parameters,
                targets: self.targets,
                start_after: self.start_after,
            }
        }
    }
}
impl CreateExperimentTemplateActionInput {
    /// Creates a new builder-style object to manufacture [`CreateExperimentTemplateActionInput`](crate::model::CreateExperimentTemplateActionInput)
    pub fn builder() -> crate::model::create_experiment_template_action_input::Builder {
        crate::model::create_experiment_template_action_input::Builder::default()
    }
}

/// <p>Specifies a target for an experiment. You must specify at least one Amazon Resource Name (ARN) or
/// at least one resource tag. You cannot specify both ARNs and tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExperimentTemplateTargetInput {
    /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags for the target resources.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub filters:
        std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateTargetInputFilter>>,
    /// <p>Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.</p>
    /// <ul>
    /// <li>
    /// <p>ALL - Run the action on all identified targets. This is the default.</p>
    /// </li>
    /// <li>
    /// <p>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random.
    /// For example, COUNT(1) selects one of the targets.</p>
    /// </li>
    /// <li>
    /// <p>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets
    /// at random. For example, PERCENT(25) selects 25% of the targets.</p>
    /// </li>
    /// </ul>
    pub selection_mode: std::option::Option<std::string::String>,
}
impl CreateExperimentTemplateTargetInput {
    /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The tags for the target resources.</p>
    pub fn resource_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_tags.as_ref()
    }
    /// <p>The filters to apply to identify target resources using specific attributes.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&[crate::model::ExperimentTemplateTargetInputFilter]> {
        self.filters.as_deref()
    }
    /// <p>Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.</p>
    /// <ul>
    /// <li>
    /// <p>ALL - Run the action on all identified targets. This is the default.</p>
    /// </li>
    /// <li>
    /// <p>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random.
    /// For example, COUNT(1) selects one of the targets.</p>
    /// </li>
    /// <li>
    /// <p>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets
    /// at random. For example, PERCENT(25) selects 25% of the targets.</p>
    /// </li>
    /// </ul>
    pub fn selection_mode(&self) -> std::option::Option<&str> {
        self.selection_mode.as_deref()
    }
}
impl std::fmt::Debug for CreateExperimentTemplateTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExperimentTemplateTargetInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("filters", &self.filters);
        formatter.field("selection_mode", &self.selection_mode);
        formatter.finish()
    }
}
/// See [`CreateExperimentTemplateTargetInput`](crate::model::CreateExperimentTemplateTargetInput)
pub mod create_experiment_template_target_input {
    /// A builder for [`CreateExperimentTemplateTargetInput`](crate::model::CreateExperimentTemplateTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ExperimentTemplateTargetInputFilter>>,
        pub(crate) selection_mode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The AWS resource type. The resource type must be supported for the specified action.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags for the target resources.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags for the target resources.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::ExperimentTemplateTargetInputFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to apply to identify target resources using specific attributes.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ExperimentTemplateTargetInputFilter>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.</p>
        /// <ul>
        /// <li>
        /// <p>ALL - Run the action on all identified targets. This is the default.</p>
        /// </li>
        /// <li>
        /// <p>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random.
        /// For example, COUNT(1) selects one of the targets.</p>
        /// </li>
        /// <li>
        /// <p>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets
        /// at random. For example, PERCENT(25) selects 25% of the targets.</p>
        /// </li>
        /// </ul>
        pub fn selection_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_mode = Some(input.into());
            self
        }
        /// <p>Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.</p>
        /// <ul>
        /// <li>
        /// <p>ALL - Run the action on all identified targets. This is the default.</p>
        /// </li>
        /// <li>
        /// <p>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random.
        /// For example, COUNT(1) selects one of the targets.</p>
        /// </li>
        /// <li>
        /// <p>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets
        /// at random. For example, PERCENT(25) selects 25% of the targets.</p>
        /// </li>
        /// </ul>
        pub fn set_selection_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExperimentTemplateTargetInput`](crate::model::CreateExperimentTemplateTargetInput)
        pub fn build(self) -> crate::model::CreateExperimentTemplateTargetInput {
            crate::model::CreateExperimentTemplateTargetInput {
                resource_type: self.resource_type,
                resource_arns: self.resource_arns,
                resource_tags: self.resource_tags,
                filters: self.filters,
                selection_mode: self.selection_mode,
            }
        }
    }
}
impl CreateExperimentTemplateTargetInput {
    /// Creates a new builder-style object to manufacture [`CreateExperimentTemplateTargetInput`](crate::model::CreateExperimentTemplateTargetInput)
    pub fn builder() -> crate::model::create_experiment_template_target_input::Builder {
        crate::model::create_experiment_template_target_input::Builder::default()
    }
}

/// <p>Specifies a stop condition for an experiment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExperimentTemplateStopConditionInput {
    /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
    /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
    /// condition.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required if the source is
    /// a CloudWatch alarm.</p>
    pub value: std::option::Option<std::string::String>,
}
impl CreateExperimentTemplateStopConditionInput {
    /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
    /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
    /// condition.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required if the source is
    /// a CloudWatch alarm.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for CreateExperimentTemplateStopConditionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExperimentTemplateStopConditionInput");
        formatter.field("source", &self.source);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CreateExperimentTemplateStopConditionInput`](crate::model::CreateExperimentTemplateStopConditionInput)
pub mod create_experiment_template_stop_condition_input {
    /// A builder for [`CreateExperimentTemplateStopConditionInput`](crate::model::CreateExperimentTemplateStopConditionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
        /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
        /// condition.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop
        /// condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop
        /// condition.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required if the source is
        /// a CloudWatch alarm.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required if the source is
        /// a CloudWatch alarm.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExperimentTemplateStopConditionInput`](crate::model::CreateExperimentTemplateStopConditionInput)
        pub fn build(self) -> crate::model::CreateExperimentTemplateStopConditionInput {
            crate::model::CreateExperimentTemplateStopConditionInput {
                source: self.source,
                value: self.value,
            }
        }
    }
}
impl CreateExperimentTemplateStopConditionInput {
    /// Creates a new builder-style object to manufacture [`CreateExperimentTemplateStopConditionInput`](crate::model::CreateExperimentTemplateStopConditionInput)
    pub fn builder() -> crate::model::create_experiment_template_stop_condition_input::Builder {
        crate::model::create_experiment_template_stop_condition_input::Builder::default()
    }
}
