// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Kinesis Firehose
///
/// Client for invoking operations on Amazon Kinesis Firehose. Each operation on Amazon Kinesis Firehose is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_firehose::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_firehose::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_firehose::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateDeliveryStream`](crate::client::fluent_builders::CreateDeliveryStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeliveryStream::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::CreateDeliveryStream::set_delivery_stream_name): <p>The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the delivery streams are in different accounts or different Regions, you can have multiple delivery streams with the same name.</p>
    ///   - [`delivery_stream_type(DeliveryStreamType)`](crate::client::fluent_builders::CreateDeliveryStream::delivery_stream_type) / [`set_delivery_stream_type(Option<DeliveryStreamType>)`](crate::client::fluent_builders::CreateDeliveryStream::set_delivery_stream_type): <p>The delivery stream type. This parameter can be one of the following values:</p>  <ul>   <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li>   <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li>  </ul>
    ///   - [`kinesis_stream_source_configuration(KinesisStreamSourceConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::kinesis_stream_source_configuration) / [`set_kinesis_stream_source_configuration(Option<KinesisStreamSourceConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_kinesis_stream_source_configuration): <p>When a Kinesis data stream is used as the source for the delivery stream, a <code>KinesisStreamSourceConfiguration</code> containing the Kinesis data stream Amazon Resource Name (ARN) and the role ARN for the source stream.</p>
    ///   - [`delivery_stream_encryption_configuration_input(DeliveryStreamEncryptionConfigurationInput)`](crate::client::fluent_builders::CreateDeliveryStream::delivery_stream_encryption_configuration_input) / [`set_delivery_stream_encryption_configuration_input(Option<DeliveryStreamEncryptionConfigurationInput>)`](crate::client::fluent_builders::CreateDeliveryStream::set_delivery_stream_encryption_configuration_input): <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>
    ///   - [`s3_destination_configuration(S3DestinationConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::s3_destination_configuration) / [`set_s3_destination_configuration(Option<S3DestinationConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_s3_destination_configuration): <p>[Deprecated] The destination in Amazon S3. You can specify only one destination.</p>
    ///   - [`extended_s3_destination_configuration(ExtendedS3DestinationConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::extended_s3_destination_configuration) / [`set_extended_s3_destination_configuration(Option<ExtendedS3DestinationConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_extended_s3_destination_configuration): <p>The destination in Amazon S3. You can specify only one destination.</p>
    ///   - [`redshift_destination_configuration(RedshiftDestinationConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::redshift_destination_configuration) / [`set_redshift_destination_configuration(Option<RedshiftDestinationConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_redshift_destination_configuration): <p>The destination in Amazon Redshift. You can specify only one destination.</p>
    ///   - [`elasticsearch_destination_configuration(ElasticsearchDestinationConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::elasticsearch_destination_configuration) / [`set_elasticsearch_destination_configuration(Option<ElasticsearchDestinationConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_elasticsearch_destination_configuration): <p>The destination in Amazon ES. You can specify only one destination.</p>
    ///   - [`amazonopensearchservice_destination_configuration(AmazonopensearchserviceDestinationConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::amazonopensearchservice_destination_configuration) / [`set_amazonopensearchservice_destination_configuration(Option<AmazonopensearchserviceDestinationConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_amazonopensearchservice_destination_configuration): (undocumented)
    ///   - [`splunk_destination_configuration(SplunkDestinationConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::splunk_destination_configuration) / [`set_splunk_destination_configuration(Option<SplunkDestinationConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_splunk_destination_configuration): <p>The destination in Splunk. You can specify only one destination.</p>
    ///   - [`http_endpoint_destination_configuration(HttpEndpointDestinationConfiguration)`](crate::client::fluent_builders::CreateDeliveryStream::http_endpoint_destination_configuration) / [`set_http_endpoint_destination_configuration(Option<HttpEndpointDestinationConfiguration>)`](crate::client::fluent_builders::CreateDeliveryStream::set_http_endpoint_destination_configuration): <p>Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDeliveryStream::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDeliveryStream::set_tags): <p>A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.</p>  <p>You can specify up to 50 tags when creating a delivery stream.</p>
    /// - On success, responds with [`CreateDeliveryStreamOutput`](crate::output::CreateDeliveryStreamOutput) with field(s):
    ///   - [`delivery_stream_arn(Option<String>)`](crate::output::CreateDeliveryStreamOutput::delivery_stream_arn): <p>The ARN of the delivery stream.</p>
    /// - On failure, responds with [`SdkError<CreateDeliveryStreamError>`](crate::error::CreateDeliveryStreamError)
    pub fn create_delivery_stream(&self) -> fluent_builders::CreateDeliveryStream<C, M, R> {
        fluent_builders::CreateDeliveryStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDeliveryStream`](crate::client::fluent_builders::DeleteDeliveryStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDeliveryStream::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::DeleteDeliveryStream::set_delivery_stream_name): <p>The name of the delivery stream.</p>
    ///   - [`allow_force_delete(bool)`](crate::client::fluent_builders::DeleteDeliveryStream::allow_force_delete) / [`set_allow_force_delete(Option<bool>)`](crate::client::fluent_builders::DeleteDeliveryStream::set_allow_force_delete): <p>Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer error, such as when the CMK or the grant are in an invalid state. If you force deletion, you can then use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete operation.</p>  <p>The default value is false.</p>
    /// - On success, responds with [`DeleteDeliveryStreamOutput`](crate::output::DeleteDeliveryStreamOutput)

    /// - On failure, responds with [`SdkError<DeleteDeliveryStreamError>`](crate::error::DeleteDeliveryStreamError)
    pub fn delete_delivery_stream(&self) -> fluent_builders::DeleteDeliveryStream<C, M, R> {
        fluent_builders::DeleteDeliveryStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDeliveryStream`](crate::client::fluent_builders::DescribeDeliveryStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDeliveryStream::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::DescribeDeliveryStream::set_delivery_stream_name): <p>The name of the delivery stream.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeDeliveryStream::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeDeliveryStream::set_limit): <p>The limit on the number of destinations to return. You can have one destination per delivery stream.</p>
    ///   - [`exclusive_start_destination_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDeliveryStream::exclusive_start_destination_id) / [`set_exclusive_start_destination_id(Option<String>)`](crate::client::fluent_builders::DescribeDeliveryStream::set_exclusive_start_destination_id): <p>The ID of the destination to start returning the destination information. Kinesis Data Firehose supports one destination per delivery stream.</p>
    /// - On success, responds with [`DescribeDeliveryStreamOutput`](crate::output::DescribeDeliveryStreamOutput) with field(s):
    ///   - [`delivery_stream_description(Option<DeliveryStreamDescription>)`](crate::output::DescribeDeliveryStreamOutput::delivery_stream_description): <p>Information about the delivery stream.</p>
    /// - On failure, responds with [`SdkError<DescribeDeliveryStreamError>`](crate::error::DescribeDeliveryStreamError)
    pub fn describe_delivery_stream(&self) -> fluent_builders::DescribeDeliveryStream<C, M, R> {
        fluent_builders::DescribeDeliveryStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeliveryStreams`](crate::client::fluent_builders::ListDeliveryStreams) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListDeliveryStreams::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListDeliveryStreams::set_limit): <p>The maximum number of delivery streams to list. The default value is 10.</p>
    ///   - [`delivery_stream_type(DeliveryStreamType)`](crate::client::fluent_builders::ListDeliveryStreams::delivery_stream_type) / [`set_delivery_stream_type(Option<DeliveryStreamType>)`](crate::client::fluent_builders::ListDeliveryStreams::set_delivery_stream_type): <p>The delivery stream type. This can be one of the following values:</p>  <ul>   <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li>   <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li>  </ul>  <p>This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.</p>
    ///   - [`exclusive_start_delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::ListDeliveryStreams::exclusive_start_delivery_stream_name) / [`set_exclusive_start_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::ListDeliveryStreams::set_exclusive_start_delivery_stream_name): <p>The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with the delivery stream whose name comes alphabetically immediately after the name you specify in <code>ExclusiveStartDeliveryStreamName</code>.</p>
    /// - On success, responds with [`ListDeliveryStreamsOutput`](crate::output::ListDeliveryStreamsOutput) with field(s):
    ///   - [`delivery_stream_names(Option<Vec<String>>)`](crate::output::ListDeliveryStreamsOutput::delivery_stream_names): <p>The names of the delivery streams.</p>
    ///   - [`has_more_delivery_streams(Option<bool>)`](crate::output::ListDeliveryStreamsOutput::has_more_delivery_streams): <p>Indicates whether there are more delivery streams available to list.</p>
    /// - On failure, responds with [`SdkError<ListDeliveryStreamsError>`](crate::error::ListDeliveryStreamsError)
    pub fn list_delivery_streams(&self) -> fluent_builders::ListDeliveryStreams<C, M, R> {
        fluent_builders::ListDeliveryStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForDeliveryStream`](crate::client::fluent_builders::ListTagsForDeliveryStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::ListTagsForDeliveryStream::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::ListTagsForDeliveryStream::set_delivery_stream_name): <p>The name of the delivery stream whose tags you want to list.</p>
    ///   - [`exclusive_start_tag_key(impl Into<String>)`](crate::client::fluent_builders::ListTagsForDeliveryStream::exclusive_start_tag_key) / [`set_exclusive_start_tag_key(Option<String>)`](crate::client::fluent_builders::ListTagsForDeliveryStream::set_exclusive_start_tag_key): <p>The key to use as the starting point for the list of tags. If you set this parameter, <code>ListTagsForDeliveryStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTagsForDeliveryStream::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTagsForDeliveryStream::set_limit): <p>The number of tags to return. If this number is less than the total number of tags associated with the delivery stream, <code>HasMoreTags</code> is set to <code>true</code> in the response. To list additional tags, set <code>ExclusiveStartTagKey</code> to the last key in the response. </p>
    /// - On success, responds with [`ListTagsForDeliveryStreamOutput`](crate::output::ListTagsForDeliveryStreamOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForDeliveryStreamOutput::tags): <p>A list of tags associated with <code>DeliveryStreamName</code>, starting with the first tag after <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.</p>
    ///   - [`has_more_tags(Option<bool>)`](crate::output::ListTagsForDeliveryStreamOutput::has_more_tags): <p>If this is <code>true</code> in the response, more tags are available. To list the remaining tags, set <code>ExclusiveStartTagKey</code> to the key of the last tag returned and call <code>ListTagsForDeliveryStream</code> again.</p>
    /// - On failure, responds with [`SdkError<ListTagsForDeliveryStreamError>`](crate::error::ListTagsForDeliveryStreamError)
    pub fn list_tags_for_delivery_stream(
        &self,
    ) -> fluent_builders::ListTagsForDeliveryStream<C, M, R> {
        fluent_builders::ListTagsForDeliveryStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRecord`](crate::client::fluent_builders::PutRecord) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::PutRecord::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::PutRecord::set_delivery_stream_name): <p>The name of the delivery stream.</p>
    ///   - [`record(Record)`](crate::client::fluent_builders::PutRecord::record) / [`set_record(Option<Record>)`](crate::client::fluent_builders::PutRecord::set_record): <p>The record.</p>
    /// - On success, responds with [`PutRecordOutput`](crate::output::PutRecordOutput) with field(s):
    ///   - [`record_id(Option<String>)`](crate::output::PutRecordOutput::record_id): <p>The ID of the record.</p>
    ///   - [`encrypted(Option<bool>)`](crate::output::PutRecordOutput::encrypted): <p>Indicates whether server-side encryption (SSE) was enabled during this operation.</p>
    /// - On failure, responds with [`SdkError<PutRecordError>`](crate::error::PutRecordError)
    pub fn put_record(&self) -> fluent_builders::PutRecord<C, M, R> {
        fluent_builders::PutRecord::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRecordBatch`](crate::client::fluent_builders::PutRecordBatch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::PutRecordBatch::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::PutRecordBatch::set_delivery_stream_name): <p>The name of the delivery stream.</p>
    ///   - [`records(Vec<Record>)`](crate::client::fluent_builders::PutRecordBatch::records) / [`set_records(Option<Vec<Record>>)`](crate::client::fluent_builders::PutRecordBatch::set_records): <p>One or more records.</p>
    /// - On success, responds with [`PutRecordBatchOutput`](crate::output::PutRecordBatchOutput) with field(s):
    ///   - [`failed_put_count(Option<i32>)`](crate::output::PutRecordBatchOutput::failed_put_count): <p>The number of records that might have failed processing. This number might be greater than 0 even if the <code>PutRecordBatch</code> call succeeds. Check <code>FailedPutCount</code> to determine whether there are records that you need to resend.</p>
    ///   - [`encrypted(Option<bool>)`](crate::output::PutRecordBatchOutput::encrypted): <p>Indicates whether server-side encryption (SSE) was enabled during this operation.</p>
    ///   - [`request_responses(Option<Vec<PutRecordBatchResponseEntry>>)`](crate::output::PutRecordBatchOutput::request_responses): <p>The results array. For each record, the index of the response element is the same as the index used in the request array.</p>
    /// - On failure, responds with [`SdkError<PutRecordBatchError>`](crate::error::PutRecordBatchError)
    pub fn put_record_batch(&self) -> fluent_builders::PutRecordBatch<C, M, R> {
        fluent_builders::PutRecordBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDeliveryStreamEncryption`](crate::client::fluent_builders::StartDeliveryStreamEncryption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::StartDeliveryStreamEncryption::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::StartDeliveryStreamEncryption::set_delivery_stream_name): <p>The name of the delivery stream for which you want to enable server-side encryption (SSE).</p>
    ///   - [`delivery_stream_encryption_configuration_input(DeliveryStreamEncryptionConfigurationInput)`](crate::client::fluent_builders::StartDeliveryStreamEncryption::delivery_stream_encryption_configuration_input) / [`set_delivery_stream_encryption_configuration_input(Option<DeliveryStreamEncryptionConfigurationInput>)`](crate::client::fluent_builders::StartDeliveryStreamEncryption::set_delivery_stream_encryption_configuration_input): <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>
    /// - On success, responds with [`StartDeliveryStreamEncryptionOutput`](crate::output::StartDeliveryStreamEncryptionOutput)

    /// - On failure, responds with [`SdkError<StartDeliveryStreamEncryptionError>`](crate::error::StartDeliveryStreamEncryptionError)
    pub fn start_delivery_stream_encryption(
        &self,
    ) -> fluent_builders::StartDeliveryStreamEncryption<C, M, R> {
        fluent_builders::StartDeliveryStreamEncryption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDeliveryStreamEncryption`](crate::client::fluent_builders::StopDeliveryStreamEncryption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::StopDeliveryStreamEncryption::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::StopDeliveryStreamEncryption::set_delivery_stream_name): <p>The name of the delivery stream for which you want to disable server-side encryption (SSE).</p>
    /// - On success, responds with [`StopDeliveryStreamEncryptionOutput`](crate::output::StopDeliveryStreamEncryptionOutput)

    /// - On failure, responds with [`SdkError<StopDeliveryStreamEncryptionError>`](crate::error::StopDeliveryStreamEncryptionError)
    pub fn stop_delivery_stream_encryption(
        &self,
    ) -> fluent_builders::StopDeliveryStreamEncryption<C, M, R> {
        fluent_builders::StopDeliveryStreamEncryption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagDeliveryStream`](crate::client::fluent_builders::TagDeliveryStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::TagDeliveryStream::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::TagDeliveryStream::set_delivery_stream_name): <p>The name of the delivery stream to which you want to add the tags.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagDeliveryStream::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagDeliveryStream::set_tags): <p>A set of key-value pairs to use to create the tags.</p>
    /// - On success, responds with [`TagDeliveryStreamOutput`](crate::output::TagDeliveryStreamOutput)

    /// - On failure, responds with [`SdkError<TagDeliveryStreamError>`](crate::error::TagDeliveryStreamError)
    pub fn tag_delivery_stream(&self) -> fluent_builders::TagDeliveryStream<C, M, R> {
        fluent_builders::TagDeliveryStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagDeliveryStream`](crate::client::fluent_builders::UntagDeliveryStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::UntagDeliveryStream::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::UntagDeliveryStream::set_delivery_stream_name): <p>The name of the delivery stream.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagDeliveryStream::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagDeliveryStream::set_tag_keys): <p>A list of tag keys. Each corresponding tag is removed from the delivery stream.</p>
    /// - On success, responds with [`UntagDeliveryStreamOutput`](crate::output::UntagDeliveryStreamOutput)

    /// - On failure, responds with [`SdkError<UntagDeliveryStreamError>`](crate::error::UntagDeliveryStreamError)
    pub fn untag_delivery_stream(&self) -> fluent_builders::UntagDeliveryStream<C, M, R> {
        fluent_builders::UntagDeliveryStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDestination`](crate::client::fluent_builders::UpdateDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delivery_stream_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDestination::delivery_stream_name) / [`set_delivery_stream_name(Option<String>)`](crate::client::fluent_builders::UpdateDestination::set_delivery_stream_name): <p>The name of the delivery stream.</p>
    ///   - [`current_delivery_stream_version_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDestination::current_delivery_stream_version_id) / [`set_current_delivery_stream_version_id(Option<String>)`](crate::client::fluent_builders::UpdateDestination::set_current_delivery_stream_version_id): <p>Obtain this value from the <code>VersionId</code> result of <code>DeliveryStreamDescription</code>. This value is required, and helps the service perform conditional operations. For example, if there is an interleaving update and this value is null, then the update destination fails. After the update is successful, the <code>VersionId</code> value is updated. The service then performs a merge of the old configuration with the new configuration.</p>
    ///   - [`destination_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDestination::destination_id) / [`set_destination_id(Option<String>)`](crate::client::fluent_builders::UpdateDestination::set_destination_id): <p>The ID of the destination.</p>
    ///   - [`s3_destination_update(S3DestinationUpdate)`](crate::client::fluent_builders::UpdateDestination::s3_destination_update) / [`set_s3_destination_update(Option<S3DestinationUpdate>)`](crate::client::fluent_builders::UpdateDestination::set_s3_destination_update): <p>[Deprecated] Describes an update for a destination in Amazon S3.</p>
    ///   - [`extended_s3_destination_update(ExtendedS3DestinationUpdate)`](crate::client::fluent_builders::UpdateDestination::extended_s3_destination_update) / [`set_extended_s3_destination_update(Option<ExtendedS3DestinationUpdate>)`](crate::client::fluent_builders::UpdateDestination::set_extended_s3_destination_update): <p>Describes an update for a destination in Amazon S3.</p>
    ///   - [`redshift_destination_update(RedshiftDestinationUpdate)`](crate::client::fluent_builders::UpdateDestination::redshift_destination_update) / [`set_redshift_destination_update(Option<RedshiftDestinationUpdate>)`](crate::client::fluent_builders::UpdateDestination::set_redshift_destination_update): <p>Describes an update for a destination in Amazon Redshift.</p>
    ///   - [`elasticsearch_destination_update(ElasticsearchDestinationUpdate)`](crate::client::fluent_builders::UpdateDestination::elasticsearch_destination_update) / [`set_elasticsearch_destination_update(Option<ElasticsearchDestinationUpdate>)`](crate::client::fluent_builders::UpdateDestination::set_elasticsearch_destination_update): <p>Describes an update for a destination in Amazon ES.</p>
    ///   - [`amazonopensearchservice_destination_update(AmazonopensearchserviceDestinationUpdate)`](crate::client::fluent_builders::UpdateDestination::amazonopensearchservice_destination_update) / [`set_amazonopensearchservice_destination_update(Option<AmazonopensearchserviceDestinationUpdate>)`](crate::client::fluent_builders::UpdateDestination::set_amazonopensearchservice_destination_update): (undocumented)
    ///   - [`splunk_destination_update(SplunkDestinationUpdate)`](crate::client::fluent_builders::UpdateDestination::splunk_destination_update) / [`set_splunk_destination_update(Option<SplunkDestinationUpdate>)`](crate::client::fluent_builders::UpdateDestination::set_splunk_destination_update): <p>Describes an update for a destination in Splunk.</p>
    ///   - [`http_endpoint_destination_update(HttpEndpointDestinationUpdate)`](crate::client::fluent_builders::UpdateDestination::http_endpoint_destination_update) / [`set_http_endpoint_destination_update(Option<HttpEndpointDestinationUpdate>)`](crate::client::fluent_builders::UpdateDestination::set_http_endpoint_destination_update): <p>Describes an update to the specified HTTP endpoint destination.</p>
    /// - On success, responds with [`UpdateDestinationOutput`](crate::output::UpdateDestinationOutput)

    /// - On failure, responds with [`SdkError<UpdateDestinationError>`](crate::error::UpdateDestinationError)
    pub fn update_destination(&self) -> fluent_builders::UpdateDestination<C, M, R> {
        fluent_builders::UpdateDestination::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDeliveryStream`.
    ///
    /// <p>Creates a Kinesis Data Firehose delivery stream.</p>
    /// <p>By default, you can create up to 50 delivery streams per AWS Region.</p>
    /// <p>This is an asynchronous operation that immediately returns. The initial status of the delivery stream is <code>CREATING</code>. After the delivery stream is created, its status is <code>ACTIVE</code> and it now accepts data. If the delivery stream creation fails, the status transitions to <code>CREATING_FAILED</code>. Attempts to send data to a delivery stream that is not in the <code>ACTIVE</code> state cause an exception. To check the state of a delivery stream, use <code>DescribeDeliveryStream</code>.</p>
    /// <p>If the status of a delivery stream is <code>CREATING_FAILED</code>, this status doesn't change, and you can't invoke <code>CreateDeliveryStream</code> again on it. However, you can invoke the <code>DeleteDeliveryStream</code> operation to delete it.</p>
    /// <p>A Kinesis Data Firehose delivery stream can be configured to receive records directly from providers using <code>PutRecord</code> or <code>PutRecordBatch</code>, or it can be configured to use an existing Kinesis stream as its source. To specify a Kinesis data stream as input, set the <code>DeliveryStreamType</code> parameter to <code>KinesisStreamAsSource</code>, and provide the Kinesis stream Amazon Resource Name (ARN) and role ARN in the <code>KinesisStreamSourceConfiguration</code> parameter.</p>
    /// <p>To create a delivery stream with server-side encryption (SSE) enabled, include <code>DeliveryStreamEncryptionConfigurationInput</code> in your request. This is optional. You can also invoke <code>StartDeliveryStreamEncryption</code> to turn on SSE for an existing delivery stream that doesn't have SSE enabled.</p>
    /// <p>A delivery stream is configured with a single destination: Amazon S3, Amazon ES, Amazon Redshift, or Splunk. You must specify only one of the following destination configuration parameters: <code>ExtendedS3DestinationConfiguration</code>, <code>S3DestinationConfiguration</code>, <code>ElasticsearchDestinationConfiguration</code>, <code>RedshiftDestinationConfiguration</code>, or <code>SplunkDestinationConfiguration</code>.</p>
    /// <p>When you specify <code>S3DestinationConfiguration</code>, you can also provide the following optional values: BufferingHints, <code>EncryptionConfiguration</code>, and <code>CompressionFormat</code>. By default, if no <code>BufferingHints</code> value is provided, Kinesis Data Firehose buffers data up to 5 MB or for 5 minutes, whichever condition is satisfied first. <code>BufferingHints</code> is a hint, so there are some cases where the service cannot adhere to these conditions strictly. For example, record boundaries might be such that the size is a little over or under the configured buffering size. By default, no encryption is performed. We strongly recommend that you enable encryption to ensure secure data storage in Amazon S3.</p>
    /// <p>A few notes about Amazon Redshift as a destination:</p>
    /// <ul>
    /// <li> <p>An Amazon Redshift destination requires an S3 bucket as intermediate location. Kinesis Data Firehose first delivers data to Amazon S3 and then uses <code>COPY</code> syntax to load data into an Amazon Redshift table. This is specified in the <code>RedshiftDestinationConfiguration.S3Configuration</code> parameter.</p> </li>
    /// <li> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket doesn't support these compression formats.</p> </li>
    /// <li> <p>We strongly recommend that you use the user name and password you provide exclusively with Kinesis Data Firehose, and that the permissions for the account are restricted for Amazon Redshift <code>INSERT</code> permissions.</p> </li>
    /// </ul>
    /// <p>Kinesis Data Firehose assumes the IAM role that is configured as part of the destination. The role should allow the Kinesis Data Firehose principal to assume the role, and the role should have permissions that allow the service to deliver the data. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> in the <i>Amazon Kinesis Data Firehose Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeliveryStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_delivery_stream_input::Builder,
    }
    impl<C, M, R> CreateDeliveryStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeliveryStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeliveryStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeliveryStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeliveryStreamInputOperationOutputAlias,
                crate::output::CreateDeliveryStreamOutput,
                crate::error::CreateDeliveryStreamError,
                crate::input::CreateDeliveryStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the delivery streams are in different accounts or different Regions, you can have multiple delivery streams with the same name.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the delivery streams are in different accounts or different Regions, you can have multiple delivery streams with the same name.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// <p>The delivery stream type. This parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li>
        /// <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li>
        /// </ul>
        pub fn delivery_stream_type(mut self, input: crate::model::DeliveryStreamType) -> Self {
            self.inner = self.inner.delivery_stream_type(input);
            self
        }
        /// <p>The delivery stream type. This parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li>
        /// <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li>
        /// </ul>
        pub fn set_delivery_stream_type(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamType>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_type(input);
            self
        }
        /// <p>When a Kinesis data stream is used as the source for the delivery stream, a <code>KinesisStreamSourceConfiguration</code> containing the Kinesis data stream Amazon Resource Name (ARN) and the role ARN for the source stream.</p>
        pub fn kinesis_stream_source_configuration(
            mut self,
            input: crate::model::KinesisStreamSourceConfiguration,
        ) -> Self {
            self.inner = self.inner.kinesis_stream_source_configuration(input);
            self
        }
        /// <p>When a Kinesis data stream is used as the source for the delivery stream, a <code>KinesisStreamSourceConfiguration</code> containing the Kinesis data stream Amazon Resource Name (ARN) and the role ARN for the source stream.</p>
        pub fn set_kinesis_stream_source_configuration(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamSourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_stream_source_configuration(input);
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>
        pub fn delivery_stream_encryption_configuration_input(
            mut self,
            input: crate::model::DeliveryStreamEncryptionConfigurationInput,
        ) -> Self {
            self.inner = self
                .inner
                .delivery_stream_encryption_configuration_input(input);
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>
        pub fn set_delivery_stream_encryption_configuration_input(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
        ) -> Self {
            self.inner = self
                .inner
                .set_delivery_stream_encryption_configuration_input(input);
            self
        }
        /// <p>[Deprecated] The destination in Amazon S3. You can specify only one destination.</p>
        pub fn s3_destination_configuration(
            mut self,
            input: crate::model::S3DestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.s3_destination_configuration(input);
            self
        }
        /// <p>[Deprecated] The destination in Amazon S3. You can specify only one destination.</p>
        pub fn set_s3_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination_configuration(input);
            self
        }
        /// <p>The destination in Amazon S3. You can specify only one destination.</p>
        pub fn extended_s3_destination_configuration(
            mut self,
            input: crate::model::ExtendedS3DestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.extended_s3_destination_configuration(input);
            self
        }
        /// <p>The destination in Amazon S3. You can specify only one destination.</p>
        pub fn set_extended_s3_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::ExtendedS3DestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_extended_s3_destination_configuration(input);
            self
        }
        /// <p>The destination in Amazon Redshift. You can specify only one destination.</p>
        pub fn redshift_destination_configuration(
            mut self,
            input: crate::model::RedshiftDestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.redshift_destination_configuration(input);
            self
        }
        /// <p>The destination in Amazon Redshift. You can specify only one destination.</p>
        pub fn set_redshift_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::RedshiftDestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_redshift_destination_configuration(input);
            self
        }
        /// <p>The destination in Amazon ES. You can specify only one destination.</p>
        pub fn elasticsearch_destination_configuration(
            mut self,
            input: crate::model::ElasticsearchDestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.elasticsearch_destination_configuration(input);
            self
        }
        /// <p>The destination in Amazon ES. You can specify only one destination.</p>
        pub fn set_elasticsearch_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDestinationConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_elasticsearch_destination_configuration(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn amazonopensearchservice_destination_configuration(
            mut self,
            input: crate::model::AmazonopensearchserviceDestinationConfiguration,
        ) -> Self {
            self.inner = self
                .inner
                .amazonopensearchservice_destination_configuration(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_amazonopensearchservice_destination_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AmazonopensearchserviceDestinationConfiguration,
            >,
        ) -> Self {
            self.inner = self
                .inner
                .set_amazonopensearchservice_destination_configuration(input);
            self
        }
        /// <p>The destination in Splunk. You can specify only one destination.</p>
        pub fn splunk_destination_configuration(
            mut self,
            input: crate::model::SplunkDestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.splunk_destination_configuration(input);
            self
        }
        /// <p>The destination in Splunk. You can specify only one destination.</p>
        pub fn set_splunk_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::SplunkDestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_splunk_destination_configuration(input);
            self
        }
        /// <p>Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.</p>
        pub fn http_endpoint_destination_configuration(
            mut self,
            input: crate::model::HttpEndpointDestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.http_endpoint_destination_configuration(input);
            self
        }
        /// <p>Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.</p>
        pub fn set_http_endpoint_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointDestinationConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_http_endpoint_destination_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.</p>
        /// <p>You can specify up to 50 tags when creating a delivery stream.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.</p>
        /// <p>You can specify up to 50 tags when creating a delivery stream.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeliveryStream`.
    ///
    /// <p>Deletes a delivery stream and its data.</p>
    /// <p>To check the state of a delivery stream, use <code>DescribeDeliveryStream</code>. You can delete a delivery stream only if it is in one of the following states: <code>ACTIVE</code>, <code>DELETING</code>, <code>CREATING_FAILED</code>, or <code>DELETING_FAILED</code>. You can't delete a delivery stream that is in the <code>CREATING</code> state. While the deletion request is in process, the delivery stream is in the <code>DELETING</code> state.</p>
    /// <p>While the delivery stream is in the <code>DELETING</code> state, the service might continue to accept records, but it doesn't make any guarantees with respect to delivering the data. Therefore, as a best practice, first stop any applications that are sending records before you delete a delivery stream.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeliveryStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_delivery_stream_input::Builder,
    }
    impl<C, M, R> DeleteDeliveryStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeliveryStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeliveryStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeliveryStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeliveryStreamInputOperationOutputAlias,
                crate::output::DeleteDeliveryStreamOutput,
                crate::error::DeleteDeliveryStreamError,
                crate::input::DeleteDeliveryStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// <p>Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer error, such as when the CMK or the grant are in an invalid state. If you force deletion, you can then use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete operation.</p>
        /// <p>The default value is false.</p>
        pub fn allow_force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_force_delete(input);
            self
        }
        /// <p>Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer error, such as when the CMK or the grant are in an invalid state. If you force deletion, you can then use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete operation.</p>
        /// <p>The default value is false.</p>
        pub fn set_allow_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDeliveryStream`.
    ///
    /// <p>Describes the specified delivery stream and its status. For example, after your delivery stream is created, call <code>DescribeDeliveryStream</code> to see whether the delivery stream is <code>ACTIVE</code> and therefore ready for data to be sent to it. </p>
    /// <p>If the status of a delivery stream is <code>CREATING_FAILED</code>, this status doesn't change, and you can't invoke <code>CreateDeliveryStream</code> again on it. However, you can invoke the <code>DeleteDeliveryStream</code> operation to delete it. If the status is <code>DELETING_FAILED</code>, you can force deletion by invoking <code>DeleteDeliveryStream</code> again but with <code>DeleteDeliveryStreamInput$AllowForceDelete</code> set to true.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDeliveryStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_delivery_stream_input::Builder,
    }
    impl<C, M, R> DescribeDeliveryStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDeliveryStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeliveryStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeliveryStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeliveryStreamInputOperationOutputAlias,
                crate::output::DescribeDeliveryStreamOutput,
                crate::error::DescribeDeliveryStreamError,
                crate::input::DescribeDeliveryStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// <p>The limit on the number of destinations to return. You can have one destination per delivery stream.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The limit on the number of destinations to return. You can have one destination per delivery stream.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The ID of the destination to start returning the destination information. Kinesis Data Firehose supports one destination per delivery stream.</p>
        pub fn exclusive_start_destination_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.exclusive_start_destination_id(input.into());
            self
        }
        /// <p>The ID of the destination to start returning the destination information. Kinesis Data Firehose supports one destination per delivery stream.</p>
        pub fn set_exclusive_start_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_destination_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeliveryStreams`.
    ///
    /// <p>Lists your delivery streams in alphabetical order of their names.</p>
    /// <p>The number of delivery streams might be too large to return using a single call to <code>ListDeliveryStreams</code>. You can limit the number of delivery streams returned, using the <code>Limit</code> parameter. To determine whether there are more delivery streams to list, check the value of <code>HasMoreDeliveryStreams</code> in the output. If there are more delivery streams to list, you can request them by calling this operation again and setting the <code>ExclusiveStartDeliveryStreamName</code> parameter to the name of the last delivery stream returned in the last call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeliveryStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_delivery_streams_input::Builder,
    }
    impl<C, M, R> ListDeliveryStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeliveryStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeliveryStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeliveryStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeliveryStreamsInputOperationOutputAlias,
                crate::output::ListDeliveryStreamsOutput,
                crate::error::ListDeliveryStreamsError,
                crate::input::ListDeliveryStreamsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of delivery streams to list. The default value is 10.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of delivery streams to list. The default value is 10.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The delivery stream type. This can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li>
        /// <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li>
        /// </ul>
        /// <p>This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.</p>
        pub fn delivery_stream_type(mut self, input: crate::model::DeliveryStreamType) -> Self {
            self.inner = self.inner.delivery_stream_type(input);
            self
        }
        /// <p>The delivery stream type. This can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li>
        /// <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li>
        /// </ul>
        /// <p>This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.</p>
        pub fn set_delivery_stream_type(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamType>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_type(input);
            self
        }
        /// <p>The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with the delivery stream whose name comes alphabetically immediately after the name you specify in <code>ExclusiveStartDeliveryStreamName</code>.</p>
        pub fn exclusive_start_delivery_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .exclusive_start_delivery_stream_name(input.into());
            self
        }
        /// <p>The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with the delivery stream whose name comes alphabetically immediately after the name you specify in <code>ExclusiveStartDeliveryStreamName</code>.</p>
        pub fn set_exclusive_start_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_delivery_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForDeliveryStream`.
    ///
    /// <p>Lists the tags for the specified delivery stream. This operation has a limit of five transactions per second per account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForDeliveryStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_delivery_stream_input::Builder,
    }
    impl<C, M, R> ListTagsForDeliveryStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForDeliveryStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForDeliveryStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForDeliveryStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForDeliveryStreamInputOperationOutputAlias,
                crate::output::ListTagsForDeliveryStreamOutput,
                crate::error::ListTagsForDeliveryStreamError,
                crate::input::ListTagsForDeliveryStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream whose tags you want to list.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream whose tags you want to list.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// <p>The key to use as the starting point for the list of tags. If you set this parameter, <code>ListTagsForDeliveryStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.</p>
        pub fn exclusive_start_tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_tag_key(input.into());
            self
        }
        /// <p>The key to use as the starting point for the list of tags. If you set this parameter, <code>ListTagsForDeliveryStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.</p>
        pub fn set_exclusive_start_tag_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_tag_key(input);
            self
        }
        /// <p>The number of tags to return. If this number is less than the total number of tags associated with the delivery stream, <code>HasMoreTags</code> is set to <code>true</code> in the response. To list additional tags, set <code>ExclusiveStartTagKey</code> to the last key in the response. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The number of tags to return. If this number is less than the total number of tags associated with the delivery stream, <code>HasMoreTags</code> is set to <code>true</code> in the response. To list additional tags, set <code>ExclusiveStartTagKey</code> to the last key in the response. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRecord`.
    ///
    /// <p>Writes a single data record into an Amazon Kinesis Data Firehose delivery stream. To write multiple data records into a delivery stream, use <code>PutRecordBatch</code>. Applications using these operations are referred to as producers.</p>
    /// <p>By default, each delivery stream can take in up to 2,000 transactions per second, 5,000 records per second, or 5 MB per second. If you use <code>PutRecord</code> and <code>PutRecordBatch</code>, the limits are an aggregate across these two operations for each delivery stream. For more information about limits and how to request an increase, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose Limits</a>. </p>
    /// <p>You must specify the name of the delivery stream and the data record when using <code>PutRecord</code>. The data record consists of a data blob that can be up to 1,000 KiB in size, and any kind of data. For example, it can be a segment from a log file, geographic location data, website clickstream data, and so on.</p>
    /// <p>Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (<code>\n</code>) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.</p>
    /// <p>The <code>PutRecord</code> operation returns a <code>RecordId</code>, which is a unique string assigned to each record. Producer applications can use this ID for purposes such as auditability and investigation.</p>
    /// <p>If the <code>PutRecord</code> operation throws a <code>ServiceUnavailableException</code>, back off and retry. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream. </p>
    /// <p>Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it tries to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.</p> <important>
    /// <p>Don't concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRecord<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_record_input::Builder,
    }
    impl<C, M, R> PutRecord<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRecord`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRecordOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRecordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRecordInputOperationOutputAlias,
                crate::output::PutRecordOutput,
                crate::error::PutRecordError,
                crate::input::PutRecordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// <p>The record.</p>
        pub fn record(mut self, input: crate::model::Record) -> Self {
            self.inner = self.inner.record(input);
            self
        }
        /// <p>The record.</p>
        pub fn set_record(mut self, input: std::option::Option<crate::model::Record>) -> Self {
            self.inner = self.inner.set_record(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRecordBatch`.
    ///
    /// <p>Writes multiple data records into a delivery stream in a single call, which can achieve higher throughput per producer than when writing single records. To write single data records into a delivery stream, use <code>PutRecord</code>. Applications using these operations are referred to as producers.</p>
    /// <p>For information about service quota, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose Quota</a>.</p>
    /// <p>Each <code>PutRecordBatch</code> request supports up to 500 records. Each record in the request can be as large as 1,000 KB (before base64 encoding), up to a limit of 4 MB for the entire request. These limits cannot be changed.</p>
    /// <p>You must specify the name of the delivery stream and the data record when using <code>PutRecord</code>. The data record consists of a data blob that can be up to 1,000 KB in size, and any kind of data. For example, it could be a segment from a log file, geographic location data, website clickstream data, and so on.</p>
    /// <p>Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (<code>\n</code>) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.</p>
    /// <p>The <code>PutRecordBatch</code> response includes a count of failed records, <code>FailedPutCount</code>, and an array of responses, <code>RequestResponses</code>. Even if the <code>PutRecordBatch</code> call succeeds, the value of <code>FailedPutCount</code> may be greater than 0, indicating that there are records for which the operation didn't succeed. Each entry in the <code>RequestResponses</code> array provides additional information about the processed record. It directly correlates with a record in the request array using the same ordering, from the top to the bottom. The response array always includes the same number of records as the request array. <code>RequestResponses</code> includes both successfully and unsuccessfully processed records. Kinesis Data Firehose tries to process all records in each <code>PutRecordBatch</code> request. A single record failure does not stop the processing of subsequent records. </p>
    /// <p>A successfully processed record includes a <code>RecordId</code> value, which is unique for the record. An unsuccessfully processed record includes <code>ErrorCode</code> and <code>ErrorMessage</code> values. <code>ErrorCode</code> reflects the type of error, and is one of the following values: <code>ServiceUnavailableException</code> or <code>InternalFailure</code>. <code>ErrorMessage</code> provides more detailed information about the error.</p>
    /// <p>If there is an internal server error or a timeout, the write might have completed or it might have failed. If <code>FailedPutCount</code> is greater than 0, retry the request, resending only those records that might have failed processing. This minimizes the possible duplicate records and also reduces the total bytes sent (and corresponding charges). We recommend that you handle any duplicates at the destination.</p>
    /// <p>If <code>PutRecordBatch</code> throws <code>ServiceUnavailableException</code>, back off and retry. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream.</p>
    /// <p>Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it attempts to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.</p> <important>
    /// <p>Don't concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRecordBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_record_batch_input::Builder,
    }
    impl<C, M, R> PutRecordBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRecordBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRecordBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRecordBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRecordBatchInputOperationOutputAlias,
                crate::output::PutRecordBatchOutput,
                crate::error::PutRecordBatchError,
                crate::input::PutRecordBatchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// Appends an item to `Records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// <p>One or more records.</p>
        pub fn records(mut self, input: crate::model::Record) -> Self {
            self.inner = self.inner.records(input);
            self
        }
        /// <p>One or more records.</p>
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Record>>,
        ) -> Self {
            self.inner = self.inner.set_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDeliveryStreamEncryption`.
    ///
    /// <p>Enables server-side encryption (SSE) for the delivery stream. </p>
    /// <p>This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to <code>ENABLING</code>, and then to <code>ENABLED</code>. The encryption status of a delivery stream is the <code>Status</code> property in <code>DeliveryStreamEncryptionConfiguration</code>. If the operation fails, the encryption status changes to <code>ENABLING_FAILED</code>. You can continue to read and write data to your delivery stream while the encryption status is <code>ENABLING</code>, but the data is not encrypted. It can take up to 5 seconds after the encryption status changes to <code>ENABLED</code> before all records written to the delivery stream are encrypted. To find out whether a record or a batch of records was encrypted, check the response elements <code>PutRecordOutput$Encrypted</code> and <code>PutRecordBatchOutput$Encrypted</code>, respectively.</p>
    /// <p>To check the encryption status of a delivery stream, use <code>DescribeDeliveryStream</code>.</p>
    /// <p>Even if encryption is currently enabled for a delivery stream, you can still invoke this operation on it to change the ARN of the CMK or both its type and ARN. If you invoke this method to change the CMK, and the old CMK is of type <code>CUSTOMER_MANAGED_CMK</code>, Kinesis Data Firehose schedules the grant it had on the old CMK for retirement. If the new CMK is of type <code>CUSTOMER_MANAGED_CMK</code>, Kinesis Data Firehose creates a grant that enables it to use the new CMK to encrypt and decrypt data and to manage the grant.</p>
    /// <p>If a delivery stream already has encryption enabled and then you invoke this operation to change the ARN of the CMK or both its type and ARN and you get <code>ENABLING_FAILED</code>, this only means that the attempt to change the CMK failed. In this case, encryption remains enabled with the old CMK.</p>
    /// <p>If the encryption status of your delivery stream is <code>ENABLING_FAILED</code>, you can invoke this operation again with a valid CMK. The CMK must be enabled and the key policy mustn't explicitly deny the permission for Kinesis Data Firehose to invoke KMS encrypt and decrypt operations.</p>
    /// <p>You can enable SSE for a delivery stream only if it's a delivery stream that uses <code>DirectPut</code> as its source. </p>
    /// <p>The <code>StartDeliveryStreamEncryption</code> and <code>StopDeliveryStreamEncryption</code> operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call <code>StartDeliveryStreamEncryption</code> 13 times and <code>StopDeliveryStreamEncryption</code> 12 times for the same delivery stream in a 24-hour period.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDeliveryStreamEncryption<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_delivery_stream_encryption_input::Builder,
    }
    impl<C, M, R> StartDeliveryStreamEncryption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDeliveryStreamEncryption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDeliveryStreamEncryptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDeliveryStreamEncryptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDeliveryStreamEncryptionInputOperationOutputAlias,
                crate::output::StartDeliveryStreamEncryptionOutput,
                crate::error::StartDeliveryStreamEncryptionError,
                crate::input::StartDeliveryStreamEncryptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream for which you want to enable server-side encryption (SSE).</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream for which you want to enable server-side encryption (SSE).</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>
        pub fn delivery_stream_encryption_configuration_input(
            mut self,
            input: crate::model::DeliveryStreamEncryptionConfigurationInput,
        ) -> Self {
            self.inner = self
                .inner
                .delivery_stream_encryption_configuration_input(input);
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>
        pub fn set_delivery_stream_encryption_configuration_input(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
        ) -> Self {
            self.inner = self
                .inner
                .set_delivery_stream_encryption_configuration_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDeliveryStreamEncryption`.
    ///
    /// <p>Disables server-side encryption (SSE) for the delivery stream. </p>
    /// <p>This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to <code>DISABLING</code>, and then to <code>DISABLED</code>. You can continue to read and write data to your stream while its status is <code>DISABLING</code>. It can take up to 5 seconds after the encryption status changes to <code>DISABLED</code> before all records written to the delivery stream are no longer subject to encryption. To find out whether a record or a batch of records was encrypted, check the response elements <code>PutRecordOutput$Encrypted</code> and <code>PutRecordBatchOutput$Encrypted</code>, respectively.</p>
    /// <p>To check the encryption state of a delivery stream, use <code>DescribeDeliveryStream</code>. </p>
    /// <p>If SSE is enabled using a customer managed CMK and then you invoke <code>StopDeliveryStreamEncryption</code>, Kinesis Data Firehose schedules the related KMS grant for retirement and then retires it after it ensures that it is finished delivering records to the destination.</p>
    /// <p>The <code>StartDeliveryStreamEncryption</code> and <code>StopDeliveryStreamEncryption</code> operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call <code>StartDeliveryStreamEncryption</code> 13 times and <code>StopDeliveryStreamEncryption</code> 12 times for the same delivery stream in a 24-hour period.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopDeliveryStreamEncryption<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_delivery_stream_encryption_input::Builder,
    }
    impl<C, M, R> StopDeliveryStreamEncryption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopDeliveryStreamEncryption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDeliveryStreamEncryptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDeliveryStreamEncryptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopDeliveryStreamEncryptionInputOperationOutputAlias,
                crate::output::StopDeliveryStreamEncryptionOutput,
                crate::error::StopDeliveryStreamEncryptionError,
                crate::input::StopDeliveryStreamEncryptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream for which you want to disable server-side encryption (SSE).</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream for which you want to disable server-side encryption (SSE).</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagDeliveryStream`.
    ///
    /// <p>Adds or updates tags for the specified delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p>
    /// <p>Each delivery stream can have up to 50 tags. </p>
    /// <p>This operation has a limit of five transactions per second per account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagDeliveryStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_delivery_stream_input::Builder,
    }
    impl<C, M, R> TagDeliveryStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagDeliveryStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagDeliveryStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::TagDeliveryStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagDeliveryStreamInputOperationOutputAlias,
                crate::output::TagDeliveryStreamOutput,
                crate::error::TagDeliveryStreamError,
                crate::input::TagDeliveryStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream to which you want to add the tags.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream to which you want to add the tags.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of key-value pairs to use to create the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A set of key-value pairs to use to create the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagDeliveryStream`.
    ///
    /// <p>Removes tags from the specified delivery stream. Removed tags are deleted, and you can't recover them after this operation successfully completes.</p>
    /// <p>If you specify a tag that doesn't exist, the operation ignores it.</p>
    /// <p>This operation has a limit of five transactions per second per account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagDeliveryStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_delivery_stream_input::Builder,
    }
    impl<C, M, R> UntagDeliveryStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagDeliveryStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagDeliveryStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagDeliveryStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagDeliveryStreamInputOperationOutputAlias,
                crate::output::UntagDeliveryStreamOutput,
                crate::error::UntagDeliveryStreamError,
                crate::input::UntagDeliveryStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Each corresponding tag is removed from the delivery stream.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys. Each corresponding tag is removed from the delivery stream.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDestination`.
    ///
    /// <p>Updates the specified destination of the specified delivery stream.</p>
    /// <p>Use this operation to change the destination type (for example, to replace the Amazon S3 destination with Amazon Redshift) or change the parameters associated with a destination (for example, to change the bucket name of the Amazon S3 destination). The update might not occur immediately. The target delivery stream remains active while the configurations are updated, so data writes to the delivery stream can continue during this process. The updated configurations are usually effective within a few minutes.</p>
    /// <p>Switching between Amazon ES and other services is not supported. For an Amazon ES destination, you can only update to another Amazon ES destination.</p>
    /// <p>If the destination type is the same, Kinesis Data Firehose merges the configuration parameters specified with the destination configuration that already exists on the delivery stream. If any of the parameters are not specified in the call, the existing values are retained. For example, in the Amazon S3 destination, if <code>EncryptionConfiguration</code> is not specified, then the existing <code>EncryptionConfiguration</code> is maintained on the destination.</p>
    /// <p>If the destination type is not the same, for example, changing the destination from Amazon S3 to Amazon Redshift, Kinesis Data Firehose does not merge any parameters. In this case, all parameters must be specified.</p>
    /// <p>Kinesis Data Firehose uses <code>CurrentDeliveryStreamVersionId</code> to avoid race conditions and conflicting merges. This is a required field, and the service updates the configuration only if the existing configuration has a version ID that matches. After the update is applied successfully, the version ID is updated, and can be retrieved using <code>DescribeDeliveryStream</code>. Use the new version ID to set <code>CurrentDeliveryStreamVersionId</code> in the next call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_destination_input::Builder,
    }
    impl<C, M, R> UpdateDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDestinationInputOperationOutputAlias,
                crate::output::UpdateDestinationOutput,
                crate::error::UpdateDestinationError,
                crate::input::UpdateDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_stream_name(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_stream_name(input);
            self
        }
        /// <p>Obtain this value from the <code>VersionId</code> result of <code>DeliveryStreamDescription</code>. This value is required, and helps the service perform conditional operations. For example, if there is an interleaving update and this value is null, then the update destination fails. After the update is successful, the <code>VersionId</code> value is updated. The service then performs a merge of the old configuration with the new configuration.</p>
        pub fn current_delivery_stream_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.current_delivery_stream_version_id(input.into());
            self
        }
        /// <p>Obtain this value from the <code>VersionId</code> result of <code>DeliveryStreamDescription</code>. This value is required, and helps the service perform conditional operations. For example, if there is an interleaving update and this value is null, then the update destination fails. After the update is successful, the <code>VersionId</code> value is updated. The service then performs a merge of the old configuration with the new configuration.</p>
        pub fn set_current_delivery_stream_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_delivery_stream_version_id(input);
            self
        }
        /// <p>The ID of the destination.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_id(input.into());
            self
        }
        /// <p>The ID of the destination.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_id(input);
            self
        }
        /// <p>[Deprecated] Describes an update for a destination in Amazon S3.</p>
        pub fn s3_destination_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.inner = self.inner.s3_destination_update(input);
            self
        }
        /// <p>[Deprecated] Describes an update for a destination in Amazon S3.</p>
        pub fn set_s3_destination_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn extended_s3_destination_update(
            mut self,
            input: crate::model::ExtendedS3DestinationUpdate,
        ) -> Self {
            self.inner = self.inner.extended_s3_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn set_extended_s3_destination_update(
            mut self,
            input: std::option::Option<crate::model::ExtendedS3DestinationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_extended_s3_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon Redshift.</p>
        pub fn redshift_destination_update(
            mut self,
            input: crate::model::RedshiftDestinationUpdate,
        ) -> Self {
            self.inner = self.inner.redshift_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon Redshift.</p>
        pub fn set_redshift_destination_update(
            mut self,
            input: std::option::Option<crate::model::RedshiftDestinationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_redshift_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon ES.</p>
        pub fn elasticsearch_destination_update(
            mut self,
            input: crate::model::ElasticsearchDestinationUpdate,
        ) -> Self {
            self.inner = self.inner.elasticsearch_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon ES.</p>
        pub fn set_elasticsearch_destination_update(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDestinationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_destination_update(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn amazonopensearchservice_destination_update(
            mut self,
            input: crate::model::AmazonopensearchserviceDestinationUpdate,
        ) -> Self {
            self.inner = self.inner.amazonopensearchservice_destination_update(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_amazonopensearchservice_destination_update(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceDestinationUpdate>,
        ) -> Self {
            self.inner = self
                .inner
                .set_amazonopensearchservice_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Splunk.</p>
        pub fn splunk_destination_update(
            mut self,
            input: crate::model::SplunkDestinationUpdate,
        ) -> Self {
            self.inner = self.inner.splunk_destination_update(input);
            self
        }
        /// <p>Describes an update for a destination in Splunk.</p>
        pub fn set_splunk_destination_update(
            mut self,
            input: std::option::Option<crate::model::SplunkDestinationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_splunk_destination_update(input);
            self
        }
        /// <p>Describes an update to the specified HTTP endpoint destination.</p>
        pub fn http_endpoint_destination_update(
            mut self,
            input: crate::model::HttpEndpointDestinationUpdate,
        ) -> Self {
            self.inner = self.inner.http_endpoint_destination_update(input);
            self
        }
        /// <p>Describes an update to the specified HTTP endpoint destination.</p>
        pub fn set_http_endpoint_destination_update(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointDestinationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_http_endpoint_destination_update(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
