// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Updates the specified HTTP endpoint destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointDestinationUpdate {
    /// <p>Describes the configuration of the HTTP endpoint destination.</p>
    pub endpoint_configuration: std::option::Option<crate::model::HttpEndpointConfiguration>,
    /// <p>Describes buffering options that can be applied to the data before it is delivered to
    /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
    /// might choose to use more optimal values. The <code>SizeInMBs</code> and
    /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
    /// one of them, you must also provide a value for the other. </p>
    pub buffering_hints: std::option::Option<crate::model::HttpEndpointBufferingHints>,
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The configuration of the request sent to the HTTP endpoint specified as the
    /// destination.</p>
    pub request_configuration: std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
    /// <p>Describes a data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
    /// stream needs.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
    /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
    /// receipt from the specified HTTP endpoint destination.</p>
    pub retry_options: std::option::Option<crate::model::HttpEndpointRetryOptions>,
    /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
    /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
    /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
    /// destination (<code>FailedDataOnly</code>).</p>
    pub s3_backup_mode: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
    /// <p>Describes an update for a destination in Amazon S3.</p>
    pub s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
}
impl HttpEndpointDestinationUpdate {
    /// <p>Describes the configuration of the HTTP endpoint destination.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>Describes buffering options that can be applied to the data before it is delivered to
    /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
    /// might choose to use more optimal values. The <code>SizeInMBs</code> and
    /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
    /// one of them, you must also provide a value for the other. </p>
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointBufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The configuration of the request sent to the HTTP endpoint specified as the
    /// destination.</p>
    pub fn request_configuration(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointRequestConfiguration> {
        self.request_configuration.as_ref()
    }
    /// <p>Describes a data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
    /// stream needs.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
    /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
    /// receipt from the specified HTTP endpoint destination.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::HttpEndpointRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
    /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
    /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
    /// destination (<code>FailedDataOnly</code>).</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::HttpEndpointS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>Describes an update for a destination in Amazon S3.</p>
    pub fn s3_update(&self) -> std::option::Option<&crate::model::S3DestinationUpdate> {
        self.s3_update.as_ref()
    }
}
impl std::fmt::Debug for HttpEndpointDestinationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointDestinationUpdate");
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("request_configuration", &self.request_configuration);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_update", &self.s3_update);
        formatter.finish()
    }
}
/// See [`HttpEndpointDestinationUpdate`](crate::model::HttpEndpointDestinationUpdate)
pub mod http_endpoint_destination_update {
    /// A builder for [`HttpEndpointDestinationUpdate`](crate::model::HttpEndpointDestinationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_configuration:
            std::option::Option<crate::model::HttpEndpointConfiguration>,
        pub(crate) buffering_hints: std::option::Option<crate::model::HttpEndpointBufferingHints>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) request_configuration:
            std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) retry_options: std::option::Option<crate::model::HttpEndpointRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
        pub(crate) s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
    }
    impl Builder {
        /// <p>Describes the configuration of the HTTP endpoint destination.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::HttpEndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>Describes the configuration of the HTTP endpoint destination.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>Describes buffering options that can be applied to the data before it is delivered to
        /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
        /// might choose to use more optimal values. The <code>SizeInMBs</code> and
        /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
        /// one of them, you must also provide a value for the other. </p>
        pub fn buffering_hints(mut self, input: crate::model::HttpEndpointBufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>Describes buffering options that can be applied to the data before it is delivered to
        /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
        /// might choose to use more optimal values. The <code>SizeInMBs</code> and
        /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
        /// one of them, you must also provide a value for the other. </p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The configuration of the request sent to the HTTP endpoint specified as the
        /// destination.</p>
        pub fn request_configuration(
            mut self,
            input: crate::model::HttpEndpointRequestConfiguration,
        ) -> Self {
            self.request_configuration = Some(input);
            self
        }
        /// <p>The configuration of the request sent to the HTTP endpoint specified as the
        /// destination.</p>
        pub fn set_request_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
        ) -> Self {
            self.request_configuration = input;
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
        /// stream needs.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
        /// stream needs.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
        /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
        /// receipt from the specified HTTP endpoint destination.</p>
        pub fn retry_options(mut self, input: crate::model::HttpEndpointRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
        /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
        /// receipt from the specified HTTP endpoint destination.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
        /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
        /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
        /// destination (<code>FailedDataOnly</code>).</p>
        pub fn s3_backup_mode(mut self, input: crate::model::HttpEndpointS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
        /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
        /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
        /// destination (<code>FailedDataOnly</code>).</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn s3_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_update = Some(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn set_s3_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_update = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointDestinationUpdate`](crate::model::HttpEndpointDestinationUpdate)
        pub fn build(self) -> crate::model::HttpEndpointDestinationUpdate {
            crate::model::HttpEndpointDestinationUpdate {
                endpoint_configuration: self.endpoint_configuration,
                buffering_hints: self.buffering_hints,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                request_configuration: self.request_configuration,
                processing_configuration: self.processing_configuration,
                role_arn: self.role_arn,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_update: self.s3_update,
            }
        }
    }
}
impl HttpEndpointDestinationUpdate {
    /// Creates a new builder-style object to manufacture [`HttpEndpointDestinationUpdate`](crate::model::HttpEndpointDestinationUpdate)
    pub fn builder() -> crate::model::http_endpoint_destination_update::Builder {
        crate::model::http_endpoint_destination_update::Builder::default()
    }
}

/// <p>Describes an update for a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub error_output_prefix: std::option::Option<std::string::String>,
    /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
    /// default values are used.</p>
    pub buffering_hints: std::option::Option<crate::model::BufferingHints>,
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
    /// <code>COPY</code> operation that reads from the S3 bucket.</p>
    pub compression_format: std::option::Option<crate::model::CompressionFormat>,
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl S3DestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn error_output_prefix(&self) -> std::option::Option<&str> {
        self.error_output_prefix.as_deref()
    }
    /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
    /// default values are used.</p>
    pub fn buffering_hints(&self) -> std::option::Option<&crate::model::BufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
    /// <code>COPY</code> operation that reads from the S3 bucket.</p>
    pub fn compression_format(&self) -> std::option::Option<&crate::model::CompressionFormat> {
        self.compression_format.as_ref()
    }
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for S3DestinationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationUpdate");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("prefix", &self.prefix);
        formatter.field("error_output_prefix", &self.error_output_prefix);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("compression_format", &self.compression_format);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`S3DestinationUpdate`](crate::model::S3DestinationUpdate)
pub mod s3_destination_update {
    /// A builder for [`S3DestinationUpdate`](crate::model::S3DestinationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) error_output_prefix: std::option::Option<std::string::String>,
        pub(crate) buffering_hints: std::option::Option<crate::model::BufferingHints>,
        pub(crate) compression_format: std::option::Option<crate::model::CompressionFormat>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn error_output_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_output_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_error_output_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_output_prefix = input;
            self
        }
        /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
        /// default values are used.</p>
        pub fn buffering_hints(mut self, input: crate::model::BufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
        /// default values are used.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::BufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
        /// <code>COPY</code> operation that reads from the S3 bucket.</p>
        pub fn compression_format(mut self, input: crate::model::CompressionFormat) -> Self {
            self.compression_format = Some(input);
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
        /// <code>COPY</code> operation that reads from the S3 bucket.</p>
        pub fn set_compression_format(
            mut self,
            input: std::option::Option<crate::model::CompressionFormat>,
        ) -> Self {
            self.compression_format = input;
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationUpdate`](crate::model::S3DestinationUpdate)
        pub fn build(self) -> crate::model::S3DestinationUpdate {
            crate::model::S3DestinationUpdate {
                role_arn: self.role_arn,
                bucket_arn: self.bucket_arn,
                prefix: self.prefix,
                error_output_prefix: self.error_output_prefix,
                buffering_hints: self.buffering_hints,
                compression_format: self.compression_format,
                encryption_configuration: self.encryption_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl S3DestinationUpdate {
    /// Creates a new builder-style object to manufacture [`S3DestinationUpdate`](crate::model::S3DestinationUpdate)
    pub fn builder() -> crate::model::s3_destination_update::Builder {
        crate::model::s3_destination_update::Builder::default()
    }
}

/// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLoggingOptions {
    /// <p>Enables or disables CloudWatch logging.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The CloudWatch group name for logging. This value is required if CloudWatch logging
    /// is enabled.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>The CloudWatch log stream name for logging. This value is required if CloudWatch
    /// logging is enabled.</p>
    pub log_stream_name: std::option::Option<std::string::String>,
}
impl CloudWatchLoggingOptions {
    /// <p>Enables or disables CloudWatch logging.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The CloudWatch group name for logging. This value is required if CloudWatch logging
    /// is enabled.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
    /// <p>The CloudWatch log stream name for logging. This value is required if CloudWatch
    /// logging is enabled.</p>
    pub fn log_stream_name(&self) -> std::option::Option<&str> {
        self.log_stream_name.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLoggingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLoggingOptions");
        formatter.field("enabled", &self.enabled);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("log_stream_name", &self.log_stream_name);
        formatter.finish()
    }
}
/// See [`CloudWatchLoggingOptions`](crate::model::CloudWatchLoggingOptions)
pub mod cloud_watch_logging_options {
    /// A builder for [`CloudWatchLoggingOptions`](crate::model::CloudWatchLoggingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) log_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Enables or disables CloudWatch logging.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Enables or disables CloudWatch logging.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The CloudWatch group name for logging. This value is required if CloudWatch logging
        /// is enabled.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The CloudWatch group name for logging. This value is required if CloudWatch logging
        /// is enabled.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>The CloudWatch log stream name for logging. This value is required if CloudWatch
        /// logging is enabled.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_name = Some(input.into());
            self
        }
        /// <p>The CloudWatch log stream name for logging. This value is required if CloudWatch
        /// logging is enabled.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLoggingOptions`](crate::model::CloudWatchLoggingOptions)
        pub fn build(self) -> crate::model::CloudWatchLoggingOptions {
            crate::model::CloudWatchLoggingOptions {
                enabled: self.enabled,
                log_group_name: self.log_group_name,
                log_stream_name: self.log_stream_name,
            }
        }
    }
}
impl CloudWatchLoggingOptions {
    /// Creates a new builder-style object to manufacture [`CloudWatchLoggingOptions`](crate::model::CloudWatchLoggingOptions)
    pub fn builder() -> crate::model::cloud_watch_logging_options::Builder {
        crate::model::cloud_watch_logging_options::Builder::default()
    }
}

/// <p>Describes the encryption for a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfiguration {
    /// <p>Specifically override existing encryption information to ensure that no encryption is
    /// used.</p>
    pub no_encryption_config: std::option::Option<crate::model::NoEncryptionConfig>,
    /// <p>The encryption key.</p>
    pub kms_encryption_config: std::option::Option<crate::model::KmsEncryptionConfig>,
}
impl EncryptionConfiguration {
    /// <p>Specifically override existing encryption information to ensure that no encryption is
    /// used.</p>
    pub fn no_encryption_config(&self) -> std::option::Option<&crate::model::NoEncryptionConfig> {
        self.no_encryption_config.as_ref()
    }
    /// <p>The encryption key.</p>
    pub fn kms_encryption_config(&self) -> std::option::Option<&crate::model::KmsEncryptionConfig> {
        self.kms_encryption_config.as_ref()
    }
}
impl std::fmt::Debug for EncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfiguration");
        formatter.field("no_encryption_config", &self.no_encryption_config);
        formatter.field("kms_encryption_config", &self.kms_encryption_config);
        formatter.finish()
    }
}
/// See [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
pub mod encryption_configuration {
    /// A builder for [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) no_encryption_config: std::option::Option<crate::model::NoEncryptionConfig>,
        pub(crate) kms_encryption_config: std::option::Option<crate::model::KmsEncryptionConfig>,
    }
    impl Builder {
        /// <p>Specifically override existing encryption information to ensure that no encryption is
        /// used.</p>
        pub fn no_encryption_config(mut self, input: crate::model::NoEncryptionConfig) -> Self {
            self.no_encryption_config = Some(input);
            self
        }
        /// <p>Specifically override existing encryption information to ensure that no encryption is
        /// used.</p>
        pub fn set_no_encryption_config(
            mut self,
            input: std::option::Option<crate::model::NoEncryptionConfig>,
        ) -> Self {
            self.no_encryption_config = input;
            self
        }
        /// <p>The encryption key.</p>
        pub fn kms_encryption_config(mut self, input: crate::model::KmsEncryptionConfig) -> Self {
            self.kms_encryption_config = Some(input);
            self
        }
        /// <p>The encryption key.</p>
        pub fn set_kms_encryption_config(
            mut self,
            input: std::option::Option<crate::model::KmsEncryptionConfig>,
        ) -> Self {
            self.kms_encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
        pub fn build(self) -> crate::model::EncryptionConfiguration {
            crate::model::EncryptionConfiguration {
                no_encryption_config: self.no_encryption_config,
                kms_encryption_config: self.kms_encryption_config,
            }
        }
    }
}
impl EncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    pub fn builder() -> crate::model::encryption_configuration::Builder {
        crate::model::encryption_configuration::Builder::default()
    }
}

/// <p>Describes an encryption key for a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsEncryptionConfig {
    /// <p>The Amazon Resource Name (ARN) of the encryption key. Must belong to the same AWS
    /// Region as the destination Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub awskms_key_arn: std::option::Option<std::string::String>,
}
impl KmsEncryptionConfig {
    /// <p>The Amazon Resource Name (ARN) of the encryption key. Must belong to the same AWS
    /// Region as the destination Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn awskms_key_arn(&self) -> std::option::Option<&str> {
        self.awskms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for KmsEncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsEncryptionConfig");
        formatter.field("awskms_key_arn", &self.awskms_key_arn);
        formatter.finish()
    }
}
/// See [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
pub mod kms_encryption_config {
    /// A builder for [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) awskms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the encryption key. Must belong to the same AWS
        /// Region as the destination Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn awskms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.awskms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the encryption key. Must belong to the same AWS
        /// Region as the destination Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_awskms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.awskms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
        pub fn build(self) -> crate::model::KmsEncryptionConfig {
            crate::model::KmsEncryptionConfig {
                awskms_key_arn: self.awskms_key_arn,
            }
        }
    }
}
impl KmsEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
    pub fn builder() -> crate::model::kms_encryption_config::Builder {
        crate::model::kms_encryption_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NoEncryptionConfig {
    #[allow(missing_docs)] // documentation missing in model
    NoEncryption,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NoEncryptionConfig {
    fn from(s: &str) -> Self {
        match s {
            "NoEncryption" => NoEncryptionConfig::NoEncryption,
            other => NoEncryptionConfig::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NoEncryptionConfig {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NoEncryptionConfig::from(s))
    }
}
impl NoEncryptionConfig {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NoEncryptionConfig::NoEncryption => "NoEncryption",
            NoEncryptionConfig::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NoEncryption"]
    }
}
impl AsRef<str> for NoEncryptionConfig {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CompressionFormat {
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    HadoopSnappy,
    #[allow(missing_docs)] // documentation missing in model
    Snappy,
    #[allow(missing_docs)] // documentation missing in model
    Uncompressed,
    #[allow(missing_docs)] // documentation missing in model
    Zip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CompressionFormat {
    fn from(s: &str) -> Self {
        match s {
            "GZIP" => CompressionFormat::Gzip,
            "HADOOP_SNAPPY" => CompressionFormat::HadoopSnappy,
            "Snappy" => CompressionFormat::Snappy,
            "UNCOMPRESSED" => CompressionFormat::Uncompressed,
            "ZIP" => CompressionFormat::Zip,
            other => CompressionFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CompressionFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CompressionFormat::from(s))
    }
}
impl CompressionFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CompressionFormat::Gzip => "GZIP",
            CompressionFormat::HadoopSnappy => "HADOOP_SNAPPY",
            CompressionFormat::Snappy => "Snappy",
            CompressionFormat::Uncompressed => "UNCOMPRESSED",
            CompressionFormat::Zip => "ZIP",
            CompressionFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GZIP", "HADOOP_SNAPPY", "Snappy", "UNCOMPRESSED", "ZIP"]
    }
}
impl AsRef<str> for CompressionFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes hints for the buffering to perform before delivering data to the
/// destination. These options are treated as hints, and therefore Kinesis Data Firehose might
/// choose to use different values when it is optimal. The <code>SizeInMBs</code> and
/// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
/// one of them, you must also provide a value for the other.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BufferingHints {
    /// <p>Buffer incoming data to the specified size, in MiBs, before delivering it to the
    /// destination. The default value is 5. This parameter is optional but if you specify a value
    /// for it, you must also specify a value for <code>IntervalInSeconds</code>, and vice
    /// versa.</p>
    /// <p>We recommend setting this parameter to a value greater than the amount of data you
    /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
    /// ingest data at 1 MiB/sec, the value should be 10 MiB or higher.</p>
    pub size_in_m_bs: std::option::Option<i32>,
    /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
    /// it to the destination. The default value is 300. This parameter is optional but if you
    /// specify a value for it, you must also specify a value for <code>SizeInMBs</code>, and vice
    /// versa.</p>
    pub interval_in_seconds: std::option::Option<i32>,
}
impl BufferingHints {
    /// <p>Buffer incoming data to the specified size, in MiBs, before delivering it to the
    /// destination. The default value is 5. This parameter is optional but if you specify a value
    /// for it, you must also specify a value for <code>IntervalInSeconds</code>, and vice
    /// versa.</p>
    /// <p>We recommend setting this parameter to a value greater than the amount of data you
    /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
    /// ingest data at 1 MiB/sec, the value should be 10 MiB or higher.</p>
    pub fn size_in_m_bs(&self) -> std::option::Option<i32> {
        self.size_in_m_bs
    }
    /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
    /// it to the destination. The default value is 300. This parameter is optional but if you
    /// specify a value for it, you must also specify a value for <code>SizeInMBs</code>, and vice
    /// versa.</p>
    pub fn interval_in_seconds(&self) -> std::option::Option<i32> {
        self.interval_in_seconds
    }
}
impl std::fmt::Debug for BufferingHints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BufferingHints");
        formatter.field("size_in_m_bs", &self.size_in_m_bs);
        formatter.field("interval_in_seconds", &self.interval_in_seconds);
        formatter.finish()
    }
}
/// See [`BufferingHints`](crate::model::BufferingHints)
pub mod buffering_hints {
    /// A builder for [`BufferingHints`](crate::model::BufferingHints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_in_m_bs: std::option::Option<i32>,
        pub(crate) interval_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Buffer incoming data to the specified size, in MiBs, before delivering it to the
        /// destination. The default value is 5. This parameter is optional but if you specify a value
        /// for it, you must also specify a value for <code>IntervalInSeconds</code>, and vice
        /// versa.</p>
        /// <p>We recommend setting this parameter to a value greater than the amount of data you
        /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
        /// ingest data at 1 MiB/sec, the value should be 10 MiB or higher.</p>
        pub fn size_in_m_bs(mut self, input: i32) -> Self {
            self.size_in_m_bs = Some(input);
            self
        }
        /// <p>Buffer incoming data to the specified size, in MiBs, before delivering it to the
        /// destination. The default value is 5. This parameter is optional but if you specify a value
        /// for it, you must also specify a value for <code>IntervalInSeconds</code>, and vice
        /// versa.</p>
        /// <p>We recommend setting this parameter to a value greater than the amount of data you
        /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
        /// ingest data at 1 MiB/sec, the value should be 10 MiB or higher.</p>
        pub fn set_size_in_m_bs(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_m_bs = input;
            self
        }
        /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
        /// it to the destination. The default value is 300. This parameter is optional but if you
        /// specify a value for it, you must also specify a value for <code>SizeInMBs</code>, and vice
        /// versa.</p>
        pub fn interval_in_seconds(mut self, input: i32) -> Self {
            self.interval_in_seconds = Some(input);
            self
        }
        /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
        /// it to the destination. The default value is 300. This parameter is optional but if you
        /// specify a value for it, you must also specify a value for <code>SizeInMBs</code>, and vice
        /// versa.</p>
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.interval_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`BufferingHints`](crate::model::BufferingHints)
        pub fn build(self) -> crate::model::BufferingHints {
            crate::model::BufferingHints {
                size_in_m_bs: self.size_in_m_bs,
                interval_in_seconds: self.interval_in_seconds,
            }
        }
    }
}
impl BufferingHints {
    /// Creates a new builder-style object to manufacture [`BufferingHints`](crate::model::BufferingHints)
    pub fn builder() -> crate::model::buffering_hints::Builder {
        crate::model::buffering_hints::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HttpEndpointS3BackupMode {
    #[allow(missing_docs)] // documentation missing in model
    AllData,
    #[allow(missing_docs)] // documentation missing in model
    FailedDataOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HttpEndpointS3BackupMode {
    fn from(s: &str) -> Self {
        match s {
            "AllData" => HttpEndpointS3BackupMode::AllData,
            "FailedDataOnly" => HttpEndpointS3BackupMode::FailedDataOnly,
            other => HttpEndpointS3BackupMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HttpEndpointS3BackupMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HttpEndpointS3BackupMode::from(s))
    }
}
impl HttpEndpointS3BackupMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HttpEndpointS3BackupMode::AllData => "AllData",
            HttpEndpointS3BackupMode::FailedDataOnly => "FailedDataOnly",
            HttpEndpointS3BackupMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AllData", "FailedDataOnly"]
    }
}
impl AsRef<str> for HttpEndpointS3BackupMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
/// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
/// receipt from the specified HTTP endpoint destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointRetryOptions {
    /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
    /// starts after the initial attempt to send data to the custom destination via HTTPS endpoint
    /// fails. It doesn't include the periods during which Kinesis Data Firehose waits for
    /// acknowledgment from the specified destination after each attempt. </p>
    pub duration_in_seconds: std::option::Option<i32>,
}
impl HttpEndpointRetryOptions {
    /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
    /// starts after the initial attempt to send data to the custom destination via HTTPS endpoint
    /// fails. It doesn't include the periods during which Kinesis Data Firehose waits for
    /// acknowledgment from the specified destination after each attempt. </p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i32> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for HttpEndpointRetryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointRetryOptions");
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`HttpEndpointRetryOptions`](crate::model::HttpEndpointRetryOptions)
pub mod http_endpoint_retry_options {
    /// A builder for [`HttpEndpointRetryOptions`](crate::model::HttpEndpointRetryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
        /// starts after the initial attempt to send data to the custom destination via HTTPS endpoint
        /// fails. It doesn't include the periods during which Kinesis Data Firehose waits for
        /// acknowledgment from the specified destination after each attempt. </p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
        /// starts after the initial attempt to send data to the custom destination via HTTPS endpoint
        /// fails. It doesn't include the periods during which Kinesis Data Firehose waits for
        /// acknowledgment from the specified destination after each attempt. </p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointRetryOptions`](crate::model::HttpEndpointRetryOptions)
        pub fn build(self) -> crate::model::HttpEndpointRetryOptions {
            crate::model::HttpEndpointRetryOptions {
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl HttpEndpointRetryOptions {
    /// Creates a new builder-style object to manufacture [`HttpEndpointRetryOptions`](crate::model::HttpEndpointRetryOptions)
    pub fn builder() -> crate::model::http_endpoint_retry_options::Builder {
        crate::model::http_endpoint_retry_options::Builder::default()
    }
}

/// <p>Describes a data processing configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProcessingConfiguration {
    /// <p>Enables or disables data processing.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The data processors.</p>
    pub processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
}
impl ProcessingConfiguration {
    /// <p>Enables or disables data processing.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The data processors.</p>
    pub fn processors(&self) -> std::option::Option<&[crate::model::Processor]> {
        self.processors.as_deref()
    }
}
impl std::fmt::Debug for ProcessingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProcessingConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.field("processors", &self.processors);
        formatter.finish()
    }
}
/// See [`ProcessingConfiguration`](crate::model::ProcessingConfiguration)
pub mod processing_configuration {
    /// A builder for [`ProcessingConfiguration`](crate::model::ProcessingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) processors: std::option::Option<std::vec::Vec<crate::model::Processor>>,
    }
    impl Builder {
        /// <p>Enables or disables data processing.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Enables or disables data processing.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `processors`.
        ///
        /// To override the contents of this collection use [`set_processors`](Self::set_processors).
        ///
        /// <p>The data processors.</p>
        pub fn processors(mut self, input: impl Into<crate::model::Processor>) -> Self {
            let mut v = self.processors.unwrap_or_default();
            v.push(input.into());
            self.processors = Some(v);
            self
        }
        /// <p>The data processors.</p>
        pub fn set_processors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Processor>>,
        ) -> Self {
            self.processors = input;
            self
        }
        /// Consumes the builder and constructs a [`ProcessingConfiguration`](crate::model::ProcessingConfiguration)
        pub fn build(self) -> crate::model::ProcessingConfiguration {
            crate::model::ProcessingConfiguration {
                enabled: self.enabled,
                processors: self.processors,
            }
        }
    }
}
impl ProcessingConfiguration {
    /// Creates a new builder-style object to manufacture [`ProcessingConfiguration`](crate::model::ProcessingConfiguration)
    pub fn builder() -> crate::model::processing_configuration::Builder {
        crate::model::processing_configuration::Builder::default()
    }
}

/// <p>Describes a data processor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Processor {
    /// <p>The type of processor.</p>
    pub r#type: std::option::Option<crate::model::ProcessorType>,
    /// <p>The processor parameters.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::ProcessorParameter>>,
}
impl Processor {
    /// <p>The type of processor.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ProcessorType> {
        self.r#type.as_ref()
    }
    /// <p>The processor parameters.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::ProcessorParameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for Processor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Processor");
        formatter.field("r#type", &self.r#type);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`Processor`](crate::model::Processor)
pub mod processor {
    /// A builder for [`Processor`](crate::model::Processor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ProcessorType>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::ProcessorParameter>>,
    }
    impl Builder {
        /// <p>The type of processor.</p>
        pub fn r#type(mut self, input: crate::model::ProcessorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of processor.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ProcessorType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The processor parameters.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::ProcessorParameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>The processor parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorParameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`Processor`](crate::model::Processor)
        pub fn build(self) -> crate::model::Processor {
            crate::model::Processor {
                r#type: self.r#type,
                parameters: self.parameters,
            }
        }
    }
}
impl Processor {
    /// Creates a new builder-style object to manufacture [`Processor`](crate::model::Processor)
    pub fn builder() -> crate::model::processor::Builder {
        crate::model::processor::Builder::default()
    }
}

/// <p>Describes the processor parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProcessorParameter {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<crate::model::ProcessorParameterName>,
    /// <p>The parameter value.</p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl ProcessorParameter {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&crate::model::ProcessorParameterName> {
        self.parameter_name.as_ref()
    }
    /// <p>The parameter value.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
}
impl std::fmt::Debug for ProcessorParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProcessorParameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`ProcessorParameter`](crate::model::ProcessorParameter)
pub mod processor_parameter {
    /// A builder for [`ProcessorParameter`](crate::model::ProcessorParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<crate::model::ProcessorParameterName>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: crate::model::ProcessorParameterName) -> Self {
            self.parameter_name = Some(input);
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<crate::model::ProcessorParameterName>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The parameter value.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The parameter value.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ProcessorParameter`](crate::model::ProcessorParameter)
        pub fn build(self) -> crate::model::ProcessorParameter {
            crate::model::ProcessorParameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl ProcessorParameter {
    /// Creates a new builder-style object to manufacture [`ProcessorParameter`](crate::model::ProcessorParameter)
    pub fn builder() -> crate::model::processor_parameter::Builder {
        crate::model::processor_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProcessorParameterName {
    #[allow(missing_docs)] // documentation missing in model
    BufferIntervalInSeconds,
    #[allow(missing_docs)] // documentation missing in model
    BufferSizeInMb,
    #[allow(missing_docs)] // documentation missing in model
    Delimiter,
    #[allow(missing_docs)] // documentation missing in model
    JsonParsingEngine,
    #[allow(missing_docs)] // documentation missing in model
    LambdaArn,
    #[allow(missing_docs)] // documentation missing in model
    MetadataExtractionQuery,
    #[allow(missing_docs)] // documentation missing in model
    LambdaNumberOfRetries,
    #[allow(missing_docs)] // documentation missing in model
    RoleArn,
    #[allow(missing_docs)] // documentation missing in model
    SubRecordType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProcessorParameterName {
    fn from(s: &str) -> Self {
        match s {
            "BufferIntervalInSeconds" => ProcessorParameterName::BufferIntervalInSeconds,
            "BufferSizeInMBs" => ProcessorParameterName::BufferSizeInMb,
            "Delimiter" => ProcessorParameterName::Delimiter,
            "JsonParsingEngine" => ProcessorParameterName::JsonParsingEngine,
            "LambdaArn" => ProcessorParameterName::LambdaArn,
            "MetadataExtractionQuery" => ProcessorParameterName::MetadataExtractionQuery,
            "NumberOfRetries" => ProcessorParameterName::LambdaNumberOfRetries,
            "RoleArn" => ProcessorParameterName::RoleArn,
            "SubRecordType" => ProcessorParameterName::SubRecordType,
            other => ProcessorParameterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProcessorParameterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProcessorParameterName::from(s))
    }
}
impl ProcessorParameterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProcessorParameterName::BufferIntervalInSeconds => "BufferIntervalInSeconds",
            ProcessorParameterName::BufferSizeInMb => "BufferSizeInMBs",
            ProcessorParameterName::Delimiter => "Delimiter",
            ProcessorParameterName::JsonParsingEngine => "JsonParsingEngine",
            ProcessorParameterName::LambdaArn => "LambdaArn",
            ProcessorParameterName::MetadataExtractionQuery => "MetadataExtractionQuery",
            ProcessorParameterName::LambdaNumberOfRetries => "NumberOfRetries",
            ProcessorParameterName::RoleArn => "RoleArn",
            ProcessorParameterName::SubRecordType => "SubRecordType",
            ProcessorParameterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BufferIntervalInSeconds",
            "BufferSizeInMBs",
            "Delimiter",
            "JsonParsingEngine",
            "LambdaArn",
            "MetadataExtractionQuery",
            "NumberOfRetries",
            "RoleArn",
            "SubRecordType",
        ]
    }
}
impl AsRef<str> for ProcessorParameterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProcessorType {
    #[allow(missing_docs)] // documentation missing in model
    AppendDelimiterToRecord,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    MetadataExtraction,
    #[allow(missing_docs)] // documentation missing in model
    RecordDeAggregation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProcessorType {
    fn from(s: &str) -> Self {
        match s {
            "AppendDelimiterToRecord" => ProcessorType::AppendDelimiterToRecord,
            "Lambda" => ProcessorType::Lambda,
            "MetadataExtraction" => ProcessorType::MetadataExtraction,
            "RecordDeAggregation" => ProcessorType::RecordDeAggregation,
            other => ProcessorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProcessorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProcessorType::from(s))
    }
}
impl ProcessorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProcessorType::AppendDelimiterToRecord => "AppendDelimiterToRecord",
            ProcessorType::Lambda => "Lambda",
            ProcessorType::MetadataExtraction => "MetadataExtraction",
            ProcessorType::RecordDeAggregation => "RecordDeAggregation",
            ProcessorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AppendDelimiterToRecord",
            "Lambda",
            "MetadataExtraction",
            "RecordDeAggregation",
        ]
    }
}
impl AsRef<str> for ProcessorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration of the HTTP endpoint request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointRequestConfiguration {
    /// <p>Kinesis Data Firehose uses the content encoding to compress the body of a request before
    /// sending the request to the destination. For more information, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN Web Docs, the official Mozilla documentation.</p>
    pub content_encoding: std::option::Option<crate::model::ContentEncoding>,
    /// <p>Describes the metadata sent to the HTTP endpoint destination.</p>
    pub common_attributes:
        std::option::Option<std::vec::Vec<crate::model::HttpEndpointCommonAttribute>>,
}
impl HttpEndpointRequestConfiguration {
    /// <p>Kinesis Data Firehose uses the content encoding to compress the body of a request before
    /// sending the request to the destination. For more information, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN Web Docs, the official Mozilla documentation.</p>
    pub fn content_encoding(&self) -> std::option::Option<&crate::model::ContentEncoding> {
        self.content_encoding.as_ref()
    }
    /// <p>Describes the metadata sent to the HTTP endpoint destination.</p>
    pub fn common_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::HttpEndpointCommonAttribute]> {
        self.common_attributes.as_deref()
    }
}
impl std::fmt::Debug for HttpEndpointRequestConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointRequestConfiguration");
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("common_attributes", &self.common_attributes);
        formatter.finish()
    }
}
/// See [`HttpEndpointRequestConfiguration`](crate::model::HttpEndpointRequestConfiguration)
pub mod http_endpoint_request_configuration {
    /// A builder for [`HttpEndpointRequestConfiguration`](crate::model::HttpEndpointRequestConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_encoding: std::option::Option<crate::model::ContentEncoding>,
        pub(crate) common_attributes:
            std::option::Option<std::vec::Vec<crate::model::HttpEndpointCommonAttribute>>,
    }
    impl Builder {
        /// <p>Kinesis Data Firehose uses the content encoding to compress the body of a request before
        /// sending the request to the destination. For more information, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN Web Docs, the official Mozilla documentation.</p>
        pub fn content_encoding(mut self, input: crate::model::ContentEncoding) -> Self {
            self.content_encoding = Some(input);
            self
        }
        /// <p>Kinesis Data Firehose uses the content encoding to compress the body of a request before
        /// sending the request to the destination. For more information, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN Web Docs, the official Mozilla documentation.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<crate::model::ContentEncoding>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// Appends an item to `common_attributes`.
        ///
        /// To override the contents of this collection use [`set_common_attributes`](Self::set_common_attributes).
        ///
        /// <p>Describes the metadata sent to the HTTP endpoint destination.</p>
        pub fn common_attributes(
            mut self,
            input: impl Into<crate::model::HttpEndpointCommonAttribute>,
        ) -> Self {
            let mut v = self.common_attributes.unwrap_or_default();
            v.push(input.into());
            self.common_attributes = Some(v);
            self
        }
        /// <p>Describes the metadata sent to the HTTP endpoint destination.</p>
        pub fn set_common_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpEndpointCommonAttribute>>,
        ) -> Self {
            self.common_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointRequestConfiguration`](crate::model::HttpEndpointRequestConfiguration)
        pub fn build(self) -> crate::model::HttpEndpointRequestConfiguration {
            crate::model::HttpEndpointRequestConfiguration {
                content_encoding: self.content_encoding,
                common_attributes: self.common_attributes,
            }
        }
    }
}
impl HttpEndpointRequestConfiguration {
    /// Creates a new builder-style object to manufacture [`HttpEndpointRequestConfiguration`](crate::model::HttpEndpointRequestConfiguration)
    pub fn builder() -> crate::model::http_endpoint_request_configuration::Builder {
        crate::model::http_endpoint_request_configuration::Builder::default()
    }
}

/// <p>Describes the metadata that's delivered to the specified HTTP endpoint
/// destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointCommonAttribute {
    /// <p>The name of the HTTP endpoint common attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value of the HTTP endpoint common attribute.</p>
    pub attribute_value: std::option::Option<std::string::String>,
}
impl HttpEndpointCommonAttribute {
    /// <p>The name of the HTTP endpoint common attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The value of the HTTP endpoint common attribute.</p>
    pub fn attribute_value(&self) -> std::option::Option<&str> {
        self.attribute_value.as_deref()
    }
}
impl std::fmt::Debug for HttpEndpointCommonAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointCommonAttribute");
        formatter.field("attribute_name", &"*** Sensitive Data Redacted ***");
        formatter.field("attribute_value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`HttpEndpointCommonAttribute`](crate::model::HttpEndpointCommonAttribute)
pub mod http_endpoint_common_attribute {
    /// A builder for [`HttpEndpointCommonAttribute`](crate::model::HttpEndpointCommonAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the HTTP endpoint common attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the HTTP endpoint common attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The value of the HTTP endpoint common attribute.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>The value of the HTTP endpoint common attribute.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointCommonAttribute`](crate::model::HttpEndpointCommonAttribute)
        pub fn build(self) -> crate::model::HttpEndpointCommonAttribute {
            crate::model::HttpEndpointCommonAttribute {
                attribute_name: self.attribute_name,
                attribute_value: self.attribute_value,
            }
        }
    }
}
impl HttpEndpointCommonAttribute {
    /// Creates a new builder-style object to manufacture [`HttpEndpointCommonAttribute`](crate::model::HttpEndpointCommonAttribute)
    pub fn builder() -> crate::model::http_endpoint_common_attribute::Builder {
        crate::model::http_endpoint_common_attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentEncoding {
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentEncoding {
    fn from(s: &str) -> Self {
        match s {
            "GZIP" => ContentEncoding::Gzip,
            "NONE" => ContentEncoding::None,
            other => ContentEncoding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentEncoding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentEncoding::from(s))
    }
}
impl ContentEncoding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentEncoding::Gzip => "GZIP",
            ContentEncoding::None => "NONE",
            ContentEncoding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GZIP", "NONE"]
    }
}
impl AsRef<str> for ContentEncoding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the buffering options that can be applied before data is delivered to the HTTP
/// endpoint destination. Kinesis Data Firehose treats these options as hints, and it might
/// choose to use more optimal values. The <code>SizeInMBs</code> and
/// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
/// one of them, you must also provide a value for the other. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointBufferingHints {
    /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
    /// destination. The default value is 5. </p>
    /// <p>We recommend setting this parameter to a value greater than the amount of data you
    /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
    /// ingest data at 1 MB/sec, the value should be 10 MB or higher. </p>
    pub size_in_m_bs: std::option::Option<i32>,
    /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering it
    /// to the destination. The default value is 300 (5 minutes). </p>
    pub interval_in_seconds: std::option::Option<i32>,
}
impl HttpEndpointBufferingHints {
    /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
    /// destination. The default value is 5. </p>
    /// <p>We recommend setting this parameter to a value greater than the amount of data you
    /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
    /// ingest data at 1 MB/sec, the value should be 10 MB or higher. </p>
    pub fn size_in_m_bs(&self) -> std::option::Option<i32> {
        self.size_in_m_bs
    }
    /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering it
    /// to the destination. The default value is 300 (5 minutes). </p>
    pub fn interval_in_seconds(&self) -> std::option::Option<i32> {
        self.interval_in_seconds
    }
}
impl std::fmt::Debug for HttpEndpointBufferingHints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointBufferingHints");
        formatter.field("size_in_m_bs", &self.size_in_m_bs);
        formatter.field("interval_in_seconds", &self.interval_in_seconds);
        formatter.finish()
    }
}
/// See [`HttpEndpointBufferingHints`](crate::model::HttpEndpointBufferingHints)
pub mod http_endpoint_buffering_hints {
    /// A builder for [`HttpEndpointBufferingHints`](crate::model::HttpEndpointBufferingHints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_in_m_bs: std::option::Option<i32>,
        pub(crate) interval_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
        /// destination. The default value is 5. </p>
        /// <p>We recommend setting this parameter to a value greater than the amount of data you
        /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
        /// ingest data at 1 MB/sec, the value should be 10 MB or higher. </p>
        pub fn size_in_m_bs(mut self, input: i32) -> Self {
            self.size_in_m_bs = Some(input);
            self
        }
        /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
        /// destination. The default value is 5. </p>
        /// <p>We recommend setting this parameter to a value greater than the amount of data you
        /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
        /// ingest data at 1 MB/sec, the value should be 10 MB or higher. </p>
        pub fn set_size_in_m_bs(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_m_bs = input;
            self
        }
        /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering it
        /// to the destination. The default value is 300 (5 minutes). </p>
        pub fn interval_in_seconds(mut self, input: i32) -> Self {
            self.interval_in_seconds = Some(input);
            self
        }
        /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering it
        /// to the destination. The default value is 300 (5 minutes). </p>
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.interval_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointBufferingHints`](crate::model::HttpEndpointBufferingHints)
        pub fn build(self) -> crate::model::HttpEndpointBufferingHints {
            crate::model::HttpEndpointBufferingHints {
                size_in_m_bs: self.size_in_m_bs,
                interval_in_seconds: self.interval_in_seconds,
            }
        }
    }
}
impl HttpEndpointBufferingHints {
    /// Creates a new builder-style object to manufacture [`HttpEndpointBufferingHints`](crate::model::HttpEndpointBufferingHints)
    pub fn builder() -> crate::model::http_endpoint_buffering_hints::Builder {
        crate::model::http_endpoint_buffering_hints::Builder::default()
    }
}

/// <p>Describes the configuration of the HTTP endpoint to which Kinesis Firehose delivers
/// data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointConfiguration {
    /// <p>The URL of the HTTP endpoint selected as the destination.</p>
    /// <important>
    /// <p>If you choose an HTTP endpoint as your destination, review and follow the
    /// instructions in the <a href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP Endpoint
    /// Delivery Request and Response Specifications</a>.</p>
    /// </important>
    pub url: std::option::Option<std::string::String>,
    /// <p>The name of the HTTP endpoint selected as the destination.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The access key required for Kinesis Firehose to authenticate with the HTTP endpoint
    /// selected as the destination.</p>
    pub access_key: std::option::Option<std::string::String>,
}
impl HttpEndpointConfiguration {
    /// <p>The URL of the HTTP endpoint selected as the destination.</p>
    /// <important>
    /// <p>If you choose an HTTP endpoint as your destination, review and follow the
    /// instructions in the <a href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP Endpoint
    /// Delivery Request and Response Specifications</a>.</p>
    /// </important>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The name of the HTTP endpoint selected as the destination.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The access key required for Kinesis Firehose to authenticate with the HTTP endpoint
    /// selected as the destination.</p>
    pub fn access_key(&self) -> std::option::Option<&str> {
        self.access_key.as_deref()
    }
}
impl std::fmt::Debug for HttpEndpointConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointConfiguration");
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.field("access_key", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`HttpEndpointConfiguration`](crate::model::HttpEndpointConfiguration)
pub mod http_endpoint_configuration {
    /// A builder for [`HttpEndpointConfiguration`](crate::model::HttpEndpointConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) access_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL of the HTTP endpoint selected as the destination.</p>
        /// <important>
        /// <p>If you choose an HTTP endpoint as your destination, review and follow the
        /// instructions in the <a href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP Endpoint
        /// Delivery Request and Response Specifications</a>.</p>
        /// </important>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the HTTP endpoint selected as the destination.</p>
        /// <important>
        /// <p>If you choose an HTTP endpoint as your destination, review and follow the
        /// instructions in the <a href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP Endpoint
        /// Delivery Request and Response Specifications</a>.</p>
        /// </important>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The name of the HTTP endpoint selected as the destination.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the HTTP endpoint selected as the destination.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The access key required for Kinesis Firehose to authenticate with the HTTP endpoint
        /// selected as the destination.</p>
        pub fn access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key = Some(input.into());
            self
        }
        /// <p>The access key required for Kinesis Firehose to authenticate with the HTTP endpoint
        /// selected as the destination.</p>
        pub fn set_access_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_key = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointConfiguration`](crate::model::HttpEndpointConfiguration)
        pub fn build(self) -> crate::model::HttpEndpointConfiguration {
            crate::model::HttpEndpointConfiguration {
                url: self.url,
                name: self.name,
                access_key: self.access_key,
            }
        }
    }
}
impl HttpEndpointConfiguration {
    /// Creates a new builder-style object to manufacture [`HttpEndpointConfiguration`](crate::model::HttpEndpointConfiguration)
    pub fn builder() -> crate::model::http_endpoint_configuration::Builder {
        crate::model::http_endpoint_configuration::Builder::default()
    }
}

/// <p>Describes an update for a destination in Splunk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SplunkDestinationUpdate {
    /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
    /// data.</p>
    pub hec_endpoint: std::option::Option<std::string::String>,
    /// <p>This type can be either "Raw" or "Event."</p>
    pub hec_endpoint_type: std::option::Option<crate::model::HecEndpointType>,
    /// <p>A GUID that you obtain from your Splunk cluster when you create a new HEC
    /// endpoint.</p>
    pub hec_token: std::option::Option<std::string::String>,
    /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
    /// Splunk after it sends data. At the end of the timeout period, Kinesis Data Firehose either
    /// tries to send the data again or considers it an error, based on your retry
    /// settings.</p>
    pub hec_acknowledgment_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
    /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
    pub retry_options: std::option::Option<crate::model::SplunkRetryOptions>,
    /// <p>Specifies how you want Kinesis Data Firehose to back up documents to Amazon S3. When
    /// set to <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could
    /// not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
    /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
    /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
    /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
    /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
    /// <code>FailedEventsOnly</code>.</p>
    pub s3_backup_mode: std::option::Option<crate::model::SplunkS3BackupMode>,
    /// <p>Your update to the configuration of the backup Amazon S3 location.</p>
    pub s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl SplunkDestinationUpdate {
    /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
    /// data.</p>
    pub fn hec_endpoint(&self) -> std::option::Option<&str> {
        self.hec_endpoint.as_deref()
    }
    /// <p>This type can be either "Raw" or "Event."</p>
    pub fn hec_endpoint_type(&self) -> std::option::Option<&crate::model::HecEndpointType> {
        self.hec_endpoint_type.as_ref()
    }
    /// <p>A GUID that you obtain from your Splunk cluster when you create a new HEC
    /// endpoint.</p>
    pub fn hec_token(&self) -> std::option::Option<&str> {
        self.hec_token.as_deref()
    }
    /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
    /// Splunk after it sends data. At the end of the timeout period, Kinesis Data Firehose either
    /// tries to send the data again or considers it an error, based on your retry
    /// settings.</p>
    pub fn hec_acknowledgment_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.hec_acknowledgment_timeout_in_seconds
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
    /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::SplunkRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Specifies how you want Kinesis Data Firehose to back up documents to Amazon S3. When
    /// set to <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could
    /// not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
    /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
    /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
    /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
    /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
    /// <code>FailedEventsOnly</code>.</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::SplunkS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>Your update to the configuration of the backup Amazon S3 location.</p>
    pub fn s3_update(&self) -> std::option::Option<&crate::model::S3DestinationUpdate> {
        self.s3_update.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for SplunkDestinationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SplunkDestinationUpdate");
        formatter.field("hec_endpoint", &self.hec_endpoint);
        formatter.field("hec_endpoint_type", &self.hec_endpoint_type);
        formatter.field("hec_token", &self.hec_token);
        formatter.field(
            "hec_acknowledgment_timeout_in_seconds",
            &self.hec_acknowledgment_timeout_in_seconds,
        );
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_update", &self.s3_update);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`SplunkDestinationUpdate`](crate::model::SplunkDestinationUpdate)
pub mod splunk_destination_update {
    /// A builder for [`SplunkDestinationUpdate`](crate::model::SplunkDestinationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hec_endpoint: std::option::Option<std::string::String>,
        pub(crate) hec_endpoint_type: std::option::Option<crate::model::HecEndpointType>,
        pub(crate) hec_token: std::option::Option<std::string::String>,
        pub(crate) hec_acknowledgment_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) retry_options: std::option::Option<crate::model::SplunkRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::SplunkS3BackupMode>,
        pub(crate) s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
        /// data.</p>
        pub fn hec_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.hec_endpoint = Some(input.into());
            self
        }
        /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
        /// data.</p>
        pub fn set_hec_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hec_endpoint = input;
            self
        }
        /// <p>This type can be either "Raw" or "Event."</p>
        pub fn hec_endpoint_type(mut self, input: crate::model::HecEndpointType) -> Self {
            self.hec_endpoint_type = Some(input);
            self
        }
        /// <p>This type can be either "Raw" or "Event."</p>
        pub fn set_hec_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::HecEndpointType>,
        ) -> Self {
            self.hec_endpoint_type = input;
            self
        }
        /// <p>A GUID that you obtain from your Splunk cluster when you create a new HEC
        /// endpoint.</p>
        pub fn hec_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.hec_token = Some(input.into());
            self
        }
        /// <p>A GUID that you obtain from your Splunk cluster when you create a new HEC
        /// endpoint.</p>
        pub fn set_hec_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hec_token = input;
            self
        }
        /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
        /// Splunk after it sends data. At the end of the timeout period, Kinesis Data Firehose either
        /// tries to send the data again or considers it an error, based on your retry
        /// settings.</p>
        pub fn hec_acknowledgment_timeout_in_seconds(mut self, input: i32) -> Self {
            self.hec_acknowledgment_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
        /// Splunk after it sends data. At the end of the timeout period, Kinesis Data Firehose either
        /// tries to send the data again or considers it an error, based on your retry
        /// settings.</p>
        pub fn set_hec_acknowledgment_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.hec_acknowledgment_timeout_in_seconds = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
        /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
        pub fn retry_options(mut self, input: crate::model::SplunkRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
        /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::SplunkRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Specifies how you want Kinesis Data Firehose to back up documents to Amazon S3. When
        /// set to <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could
        /// not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
        /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
        /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
        /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
        /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
        /// <code>FailedEventsOnly</code>.</p>
        pub fn s3_backup_mode(mut self, input: crate::model::SplunkS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>Specifies how you want Kinesis Data Firehose to back up documents to Amazon S3. When
        /// set to <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could
        /// not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
        /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
        /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
        /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
        /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
        /// <code>FailedEventsOnly</code>.</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::SplunkS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>Your update to the configuration of the backup Amazon S3 location.</p>
        pub fn s3_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_update = Some(input);
            self
        }
        /// <p>Your update to the configuration of the backup Amazon S3 location.</p>
        pub fn set_s3_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_update = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`SplunkDestinationUpdate`](crate::model::SplunkDestinationUpdate)
        pub fn build(self) -> crate::model::SplunkDestinationUpdate {
            crate::model::SplunkDestinationUpdate {
                hec_endpoint: self.hec_endpoint,
                hec_endpoint_type: self.hec_endpoint_type,
                hec_token: self.hec_token,
                hec_acknowledgment_timeout_in_seconds: self.hec_acknowledgment_timeout_in_seconds,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_update: self.s3_update,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl SplunkDestinationUpdate {
    /// Creates a new builder-style object to manufacture [`SplunkDestinationUpdate`](crate::model::SplunkDestinationUpdate)
    pub fn builder() -> crate::model::splunk_destination_update::Builder {
        crate::model::splunk_destination_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SplunkS3BackupMode {
    #[allow(missing_docs)] // documentation missing in model
    AllEvents,
    #[allow(missing_docs)] // documentation missing in model
    FailedEventsOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SplunkS3BackupMode {
    fn from(s: &str) -> Self {
        match s {
            "AllEvents" => SplunkS3BackupMode::AllEvents,
            "FailedEventsOnly" => SplunkS3BackupMode::FailedEventsOnly,
            other => SplunkS3BackupMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SplunkS3BackupMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SplunkS3BackupMode::from(s))
    }
}
impl SplunkS3BackupMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SplunkS3BackupMode::AllEvents => "AllEvents",
            SplunkS3BackupMode::FailedEventsOnly => "FailedEventsOnly",
            SplunkS3BackupMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AllEvents", "FailedEventsOnly"]
    }
}
impl AsRef<str> for SplunkS3BackupMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configures retry behavior in case Kinesis Data Firehose is unable to deliver
/// documents to Splunk, or if it doesn't receive an acknowledgment from Splunk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SplunkRetryOptions {
    /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
    /// starts after the initial attempt to send data to Splunk fails. It doesn't include the
    /// periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each
    /// attempt.</p>
    pub duration_in_seconds: std::option::Option<i32>,
}
impl SplunkRetryOptions {
    /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
    /// starts after the initial attempt to send data to Splunk fails. It doesn't include the
    /// periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each
    /// attempt.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i32> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for SplunkRetryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SplunkRetryOptions");
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`SplunkRetryOptions`](crate::model::SplunkRetryOptions)
pub mod splunk_retry_options {
    /// A builder for [`SplunkRetryOptions`](crate::model::SplunkRetryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
        /// starts after the initial attempt to send data to Splunk fails. It doesn't include the
        /// periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each
        /// attempt.</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>The total amount of time that Kinesis Data Firehose spends on retries. This duration
        /// starts after the initial attempt to send data to Splunk fails. It doesn't include the
        /// periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each
        /// attempt.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`SplunkRetryOptions`](crate::model::SplunkRetryOptions)
        pub fn build(self) -> crate::model::SplunkRetryOptions {
            crate::model::SplunkRetryOptions {
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl SplunkRetryOptions {
    /// Creates a new builder-style object to manufacture [`SplunkRetryOptions`](crate::model::SplunkRetryOptions)
    pub fn builder() -> crate::model::splunk_retry_options::Builder {
        crate::model::splunk_retry_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HecEndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    Raw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HecEndpointType {
    fn from(s: &str) -> Self {
        match s {
            "Event" => HecEndpointType::Event,
            "Raw" => HecEndpointType::Raw,
            other => HecEndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HecEndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HecEndpointType::from(s))
    }
}
impl HecEndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HecEndpointType::Event => "Event",
            HecEndpointType::Raw => "Raw",
            HecEndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Event", "Raw"]
    }
}
impl AsRef<str> for HecEndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonopensearchserviceDestinationUpdate {
    #[allow(missing_docs)] // documentation missing in model
    pub role_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub domain_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub cluster_endpoint: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub index_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub type_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub index_rotation_period:
        std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
    #[allow(missing_docs)] // documentation missing in model
    pub buffering_hints: std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
    #[allow(missing_docs)] // documentation missing in model
    pub retry_options: std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
    /// <p>Describes an update for a destination in Amazon S3.</p>
    pub s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
    /// <p>Describes a data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl AmazonopensearchserviceDestinationUpdate {
    #[allow(missing_docs)] // documentation missing in model
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn domain_arn(&self) -> std::option::Option<&str> {
        self.domain_arn.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn cluster_endpoint(&self) -> std::option::Option<&str> {
        self.cluster_endpoint.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn index_rotation_period(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceIndexRotationPeriod> {
        self.index_rotation_period.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceBufferingHints> {
        self.buffering_hints.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn retry_options(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Describes an update for a destination in Amazon S3.</p>
    pub fn s3_update(&self) -> std::option::Option<&crate::model::S3DestinationUpdate> {
        self.s3_update.as_ref()
    }
    /// <p>Describes a data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for AmazonopensearchserviceDestinationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonopensearchserviceDestinationUpdate");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("domain_arn", &self.domain_arn);
        formatter.field("cluster_endpoint", &self.cluster_endpoint);
        formatter.field("index_name", &self.index_name);
        formatter.field("type_name", &self.type_name);
        formatter.field("index_rotation_period", &self.index_rotation_period);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_update", &self.s3_update);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`AmazonopensearchserviceDestinationUpdate`](crate::model::AmazonopensearchserviceDestinationUpdate)
pub mod amazonopensearchservice_destination_update {
    /// A builder for [`AmazonopensearchserviceDestinationUpdate`](crate::model::AmazonopensearchserviceDestinationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_endpoint: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) index_rotation_period:
            std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
        pub(crate) buffering_hints:
            std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
        pub(crate) retry_options:
            std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
        pub(crate) s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn domain_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_domain_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn cluster_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_endpoint = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_cluster_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_endpoint = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn index_rotation_period(
            mut self,
            input: crate::model::AmazonopensearchserviceIndexRotationPeriod,
        ) -> Self {
            self.index_rotation_period = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_index_rotation_period(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
        ) -> Self {
            self.index_rotation_period = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn buffering_hints(
            mut self,
            input: crate::model::AmazonopensearchserviceBufferingHints,
        ) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_options(
            mut self,
            input: crate::model::AmazonopensearchserviceRetryOptions,
        ) -> Self {
            self.retry_options = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn s3_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_update = Some(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn set_s3_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_update = input;
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonopensearchserviceDestinationUpdate`](crate::model::AmazonopensearchserviceDestinationUpdate)
        pub fn build(self) -> crate::model::AmazonopensearchserviceDestinationUpdate {
            crate::model::AmazonopensearchserviceDestinationUpdate {
                role_arn: self.role_arn,
                domain_arn: self.domain_arn,
                cluster_endpoint: self.cluster_endpoint,
                index_name: self.index_name,
                type_name: self.type_name,
                index_rotation_period: self.index_rotation_period,
                buffering_hints: self.buffering_hints,
                retry_options: self.retry_options,
                s3_update: self.s3_update,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl AmazonopensearchserviceDestinationUpdate {
    /// Creates a new builder-style object to manufacture [`AmazonopensearchserviceDestinationUpdate`](crate::model::AmazonopensearchserviceDestinationUpdate)
    pub fn builder() -> crate::model::amazonopensearchservice_destination_update::Builder {
        crate::model::amazonopensearchservice_destination_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonopensearchserviceRetryOptions {
    #[allow(missing_docs)] // documentation missing in model
    pub duration_in_seconds: std::option::Option<i32>,
}
impl AmazonopensearchserviceRetryOptions {
    #[allow(missing_docs)] // documentation missing in model
    pub fn duration_in_seconds(&self) -> std::option::Option<i32> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for AmazonopensearchserviceRetryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonopensearchserviceRetryOptions");
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`AmazonopensearchserviceRetryOptions`](crate::model::AmazonopensearchserviceRetryOptions)
pub mod amazonopensearchservice_retry_options {
    /// A builder for [`AmazonopensearchserviceRetryOptions`](crate::model::AmazonopensearchserviceRetryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonopensearchserviceRetryOptions`](crate::model::AmazonopensearchserviceRetryOptions)
        pub fn build(self) -> crate::model::AmazonopensearchserviceRetryOptions {
            crate::model::AmazonopensearchserviceRetryOptions {
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl AmazonopensearchserviceRetryOptions {
    /// Creates a new builder-style object to manufacture [`AmazonopensearchserviceRetryOptions`](crate::model::AmazonopensearchserviceRetryOptions)
    pub fn builder() -> crate::model::amazonopensearchservice_retry_options::Builder {
        crate::model::amazonopensearchservice_retry_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonopensearchserviceBufferingHints {
    #[allow(missing_docs)] // documentation missing in model
    pub interval_in_seconds: std::option::Option<i32>,
    #[allow(missing_docs)] // documentation missing in model
    pub size_in_m_bs: std::option::Option<i32>,
}
impl AmazonopensearchserviceBufferingHints {
    #[allow(missing_docs)] // documentation missing in model
    pub fn interval_in_seconds(&self) -> std::option::Option<i32> {
        self.interval_in_seconds
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn size_in_m_bs(&self) -> std::option::Option<i32> {
        self.size_in_m_bs
    }
}
impl std::fmt::Debug for AmazonopensearchserviceBufferingHints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonopensearchserviceBufferingHints");
        formatter.field("interval_in_seconds", &self.interval_in_seconds);
        formatter.field("size_in_m_bs", &self.size_in_m_bs);
        formatter.finish()
    }
}
/// See [`AmazonopensearchserviceBufferingHints`](crate::model::AmazonopensearchserviceBufferingHints)
pub mod amazonopensearchservice_buffering_hints {
    /// A builder for [`AmazonopensearchserviceBufferingHints`](crate::model::AmazonopensearchserviceBufferingHints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interval_in_seconds: std::option::Option<i32>,
        pub(crate) size_in_m_bs: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn interval_in_seconds(mut self, input: i32) -> Self {
            self.interval_in_seconds = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.interval_in_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn size_in_m_bs(mut self, input: i32) -> Self {
            self.size_in_m_bs = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_size_in_m_bs(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_m_bs = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonopensearchserviceBufferingHints`](crate::model::AmazonopensearchserviceBufferingHints)
        pub fn build(self) -> crate::model::AmazonopensearchserviceBufferingHints {
            crate::model::AmazonopensearchserviceBufferingHints {
                interval_in_seconds: self.interval_in_seconds,
                size_in_m_bs: self.size_in_m_bs,
            }
        }
    }
}
impl AmazonopensearchserviceBufferingHints {
    /// Creates a new builder-style object to manufacture [`AmazonopensearchserviceBufferingHints`](crate::model::AmazonopensearchserviceBufferingHints)
    pub fn builder() -> crate::model::amazonopensearchservice_buffering_hints::Builder {
        crate::model::amazonopensearchservice_buffering_hints::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AmazonopensearchserviceIndexRotationPeriod {
    #[allow(missing_docs)] // documentation missing in model
    NoRotation,
    #[allow(missing_docs)] // documentation missing in model
    OneDay,
    #[allow(missing_docs)] // documentation missing in model
    OneHour,
    #[allow(missing_docs)] // documentation missing in model
    OneMonth,
    #[allow(missing_docs)] // documentation missing in model
    OneWeek,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AmazonopensearchserviceIndexRotationPeriod {
    fn from(s: &str) -> Self {
        match s {
            "NoRotation" => AmazonopensearchserviceIndexRotationPeriod::NoRotation,
            "OneDay" => AmazonopensearchserviceIndexRotationPeriod::OneDay,
            "OneHour" => AmazonopensearchserviceIndexRotationPeriod::OneHour,
            "OneMonth" => AmazonopensearchserviceIndexRotationPeriod::OneMonth,
            "OneWeek" => AmazonopensearchserviceIndexRotationPeriod::OneWeek,
            other => AmazonopensearchserviceIndexRotationPeriod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AmazonopensearchserviceIndexRotationPeriod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AmazonopensearchserviceIndexRotationPeriod::from(s))
    }
}
impl AmazonopensearchserviceIndexRotationPeriod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AmazonopensearchserviceIndexRotationPeriod::NoRotation => "NoRotation",
            AmazonopensearchserviceIndexRotationPeriod::OneDay => "OneDay",
            AmazonopensearchserviceIndexRotationPeriod::OneHour => "OneHour",
            AmazonopensearchserviceIndexRotationPeriod::OneMonth => "OneMonth",
            AmazonopensearchserviceIndexRotationPeriod::OneWeek => "OneWeek",
            AmazonopensearchserviceIndexRotationPeriod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NoRotation", "OneDay", "OneHour", "OneMonth", "OneWeek"]
    }
}
impl AsRef<str> for AmazonopensearchserviceIndexRotationPeriod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an update for a destination in Amazon ES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchDestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
    /// for calling the Amazon ES Configuration API and for indexing documents. For more
    /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
    /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
    /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
    /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in
    /// <code>RoleARN</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    ///
    /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
    pub domain_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint to use when communicating with the cluster. Specify either this
    /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
    pub cluster_endpoint: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch index name.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
    /// index. If you try to specify a new type for an existing index that already has another
    /// type, Kinesis Data Firehose returns an error during runtime.</p>
    ///
    /// <p>If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream,
    /// Kinesis Data Firehose still delivers data to Elasticsearch with the old index name and type
    /// name. If you want to update your delivery stream with a new index name, provide an empty
    /// string for <code>TypeName</code>. </p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to
    /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
    /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
    /// Amazon ES Destination</a>. Default value is <code>OneDay</code>.</p>
    pub index_rotation_period: std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
    /// <p>The buffering options. If no value is specified,
    /// <code>ElasticsearchBufferingHints</code> object default values are used. </p>
    pub buffering_hints: std::option::Option<crate::model::ElasticsearchBufferingHints>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon ES. The default value is 300 (5 minutes).</p>
    pub retry_options: std::option::Option<crate::model::ElasticsearchRetryOptions>,
    /// <p>The Amazon S3 destination.</p>
    pub s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl ElasticsearchDestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
    /// for calling the Amazon ES Configuration API and for indexing documents. For more
    /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
    /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
    /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
    /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in
    /// <code>RoleARN</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    ///
    /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
    pub fn domain_arn(&self) -> std::option::Option<&str> {
        self.domain_arn.as_deref()
    }
    /// <p>The endpoint to use when communicating with the cluster. Specify either this
    /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
    pub fn cluster_endpoint(&self) -> std::option::Option<&str> {
        self.cluster_endpoint.as_deref()
    }
    /// <p>The Elasticsearch index name.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
    /// index. If you try to specify a new type for an existing index that already has another
    /// type, Kinesis Data Firehose returns an error during runtime.</p>
    ///
    /// <p>If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream,
    /// Kinesis Data Firehose still delivers data to Elasticsearch with the old index name and type
    /// name. If you want to update your delivery stream with a new index name, provide an empty
    /// string for <code>TypeName</code>. </p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to
    /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
    /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
    /// Amazon ES Destination</a>. Default value is <code>OneDay</code>.</p>
    pub fn index_rotation_period(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchIndexRotationPeriod> {
        self.index_rotation_period.as_ref()
    }
    /// <p>The buffering options. If no value is specified,
    /// <code>ElasticsearchBufferingHints</code> object default values are used. </p>
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchBufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon ES. The default value is 300 (5 minutes).</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::ElasticsearchRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>The Amazon S3 destination.</p>
    pub fn s3_update(&self) -> std::option::Option<&crate::model::S3DestinationUpdate> {
        self.s3_update.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchDestinationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchDestinationUpdate");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("domain_arn", &self.domain_arn);
        formatter.field("cluster_endpoint", &self.cluster_endpoint);
        formatter.field("index_name", &self.index_name);
        formatter.field("type_name", &self.type_name);
        formatter.field("index_rotation_period", &self.index_rotation_period);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_update", &self.s3_update);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`ElasticsearchDestinationUpdate`](crate::model::ElasticsearchDestinationUpdate)
pub mod elasticsearch_destination_update {
    /// A builder for [`ElasticsearchDestinationUpdate`](crate::model::ElasticsearchDestinationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_endpoint: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) index_rotation_period:
            std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
        pub(crate) buffering_hints: std::option::Option<crate::model::ElasticsearchBufferingHints>,
        pub(crate) retry_options: std::option::Option<crate::model::ElasticsearchRetryOptions>,
        pub(crate) s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
        /// for calling the Amazon ES Configuration API and for indexing documents. For more
        /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
        /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
        /// for calling the Amazon ES Configuration API and for indexing documents. For more
        /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
        /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
        /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
        /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in
        /// <code>RoleARN</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        ///
        /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
        pub fn domain_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
        /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
        /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in
        /// <code>RoleARN</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        ///
        /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
        pub fn set_domain_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_arn = input;
            self
        }
        /// <p>The endpoint to use when communicating with the cluster. Specify either this
        /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
        pub fn cluster_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint to use when communicating with the cluster. Specify either this
        /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
        pub fn set_cluster_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_endpoint = input;
            self
        }
        /// <p>The Elasticsearch index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The Elasticsearch index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
        /// index. If you try to specify a new type for an existing index that already has another
        /// type, Kinesis Data Firehose returns an error during runtime.</p>
        ///
        /// <p>If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream,
        /// Kinesis Data Firehose still delivers data to Elasticsearch with the old index name and type
        /// name. If you want to update your delivery stream with a new index name, provide an empty
        /// string for <code>TypeName</code>. </p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
        /// index. If you try to specify a new type for an existing index that already has another
        /// type, Kinesis Data Firehose returns an error during runtime.</p>
        ///
        /// <p>If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream,
        /// Kinesis Data Firehose still delivers data to Elasticsearch with the old index name and type
        /// name. If you want to update your delivery stream with a new index name, provide an empty
        /// string for <code>TypeName</code>. </p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to
        /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
        /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
        /// Amazon ES Destination</a>. Default value is <code>OneDay</code>.</p>
        pub fn index_rotation_period(
            mut self,
            input: crate::model::ElasticsearchIndexRotationPeriod,
        ) -> Self {
            self.index_rotation_period = Some(input);
            self
        }
        /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to
        /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
        /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
        /// Amazon ES Destination</a>. Default value is <code>OneDay</code>.</p>
        pub fn set_index_rotation_period(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
        ) -> Self {
            self.index_rotation_period = input;
            self
        }
        /// <p>The buffering options. If no value is specified,
        /// <code>ElasticsearchBufferingHints</code> object default values are used. </p>
        pub fn buffering_hints(mut self, input: crate::model::ElasticsearchBufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering options. If no value is specified,
        /// <code>ElasticsearchBufferingHints</code> object default values are used. </p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon ES. The default value is 300 (5 minutes).</p>
        pub fn retry_options(mut self, input: crate::model::ElasticsearchRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon ES. The default value is 300 (5 minutes).</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>The Amazon S3 destination.</p>
        pub fn s3_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_update = Some(input);
            self
        }
        /// <p>The Amazon S3 destination.</p>
        pub fn set_s3_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_update = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchDestinationUpdate`](crate::model::ElasticsearchDestinationUpdate)
        pub fn build(self) -> crate::model::ElasticsearchDestinationUpdate {
            crate::model::ElasticsearchDestinationUpdate {
                role_arn: self.role_arn,
                domain_arn: self.domain_arn,
                cluster_endpoint: self.cluster_endpoint,
                index_name: self.index_name,
                type_name: self.type_name,
                index_rotation_period: self.index_rotation_period,
                buffering_hints: self.buffering_hints,
                retry_options: self.retry_options,
                s3_update: self.s3_update,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl ElasticsearchDestinationUpdate {
    /// Creates a new builder-style object to manufacture [`ElasticsearchDestinationUpdate`](crate::model::ElasticsearchDestinationUpdate)
    pub fn builder() -> crate::model::elasticsearch_destination_update::Builder {
        crate::model::elasticsearch_destination_update::Builder::default()
    }
}

/// <p>Configures retry behavior in case Kinesis Data Firehose is unable to deliver
/// documents to Amazon ES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchRetryOptions {
    /// <p>After an initial failure to deliver to Amazon ES, the total amount of time during
    /// which Kinesis Data Firehose retries delivery (including the first attempt). After this time
    /// has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5
    /// minutes). A value of 0 (zero) results in no retries.</p>
    pub duration_in_seconds: std::option::Option<i32>,
}
impl ElasticsearchRetryOptions {
    /// <p>After an initial failure to deliver to Amazon ES, the total amount of time during
    /// which Kinesis Data Firehose retries delivery (including the first attempt). After this time
    /// has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5
    /// minutes). A value of 0 (zero) results in no retries.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i32> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for ElasticsearchRetryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchRetryOptions");
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`ElasticsearchRetryOptions`](crate::model::ElasticsearchRetryOptions)
pub mod elasticsearch_retry_options {
    /// A builder for [`ElasticsearchRetryOptions`](crate::model::ElasticsearchRetryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>After an initial failure to deliver to Amazon ES, the total amount of time during
        /// which Kinesis Data Firehose retries delivery (including the first attempt). After this time
        /// has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5
        /// minutes). A value of 0 (zero) results in no retries.</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>After an initial failure to deliver to Amazon ES, the total amount of time during
        /// which Kinesis Data Firehose retries delivery (including the first attempt). After this time
        /// has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5
        /// minutes). A value of 0 (zero) results in no retries.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchRetryOptions`](crate::model::ElasticsearchRetryOptions)
        pub fn build(self) -> crate::model::ElasticsearchRetryOptions {
            crate::model::ElasticsearchRetryOptions {
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl ElasticsearchRetryOptions {
    /// Creates a new builder-style object to manufacture [`ElasticsearchRetryOptions`](crate::model::ElasticsearchRetryOptions)
    pub fn builder() -> crate::model::elasticsearch_retry_options::Builder {
        crate::model::elasticsearch_retry_options::Builder::default()
    }
}

/// <p>Describes the buffering to perform before delivering data to the Amazon ES
/// destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchBufferingHints {
    /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
    /// it to the destination. The default value is 300 (5 minutes).</p>
    pub interval_in_seconds: std::option::Option<i32>,
    /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
    /// destination. The default value is 5.</p>
    /// <p>We recommend setting this parameter to a value greater than the amount of data you
    /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
    /// ingest data at 1 MB/sec, the value should be 10 MB or higher.</p>
    pub size_in_m_bs: std::option::Option<i32>,
}
impl ElasticsearchBufferingHints {
    /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
    /// it to the destination. The default value is 300 (5 minutes).</p>
    pub fn interval_in_seconds(&self) -> std::option::Option<i32> {
        self.interval_in_seconds
    }
    /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
    /// destination. The default value is 5.</p>
    /// <p>We recommend setting this parameter to a value greater than the amount of data you
    /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
    /// ingest data at 1 MB/sec, the value should be 10 MB or higher.</p>
    pub fn size_in_m_bs(&self) -> std::option::Option<i32> {
        self.size_in_m_bs
    }
}
impl std::fmt::Debug for ElasticsearchBufferingHints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchBufferingHints");
        formatter.field("interval_in_seconds", &self.interval_in_seconds);
        formatter.field("size_in_m_bs", &self.size_in_m_bs);
        formatter.finish()
    }
}
/// See [`ElasticsearchBufferingHints`](crate::model::ElasticsearchBufferingHints)
pub mod elasticsearch_buffering_hints {
    /// A builder for [`ElasticsearchBufferingHints`](crate::model::ElasticsearchBufferingHints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interval_in_seconds: std::option::Option<i32>,
        pub(crate) size_in_m_bs: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
        /// it to the destination. The default value is 300 (5 minutes).</p>
        pub fn interval_in_seconds(mut self, input: i32) -> Self {
            self.interval_in_seconds = Some(input);
            self
        }
        /// <p>Buffer incoming data for the specified period of time, in seconds, before delivering
        /// it to the destination. The default value is 300 (5 minutes).</p>
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.interval_in_seconds = input;
            self
        }
        /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
        /// destination. The default value is 5.</p>
        /// <p>We recommend setting this parameter to a value greater than the amount of data you
        /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
        /// ingest data at 1 MB/sec, the value should be 10 MB or higher.</p>
        pub fn size_in_m_bs(mut self, input: i32) -> Self {
            self.size_in_m_bs = Some(input);
            self
        }
        /// <p>Buffer incoming data to the specified size, in MBs, before delivering it to the
        /// destination. The default value is 5.</p>
        /// <p>We recommend setting this parameter to a value greater than the amount of data you
        /// typically ingest into the delivery stream in 10 seconds. For example, if you typically
        /// ingest data at 1 MB/sec, the value should be 10 MB or higher.</p>
        pub fn set_size_in_m_bs(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_m_bs = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchBufferingHints`](crate::model::ElasticsearchBufferingHints)
        pub fn build(self) -> crate::model::ElasticsearchBufferingHints {
            crate::model::ElasticsearchBufferingHints {
                interval_in_seconds: self.interval_in_seconds,
                size_in_m_bs: self.size_in_m_bs,
            }
        }
    }
}
impl ElasticsearchBufferingHints {
    /// Creates a new builder-style object to manufacture [`ElasticsearchBufferingHints`](crate::model::ElasticsearchBufferingHints)
    pub fn builder() -> crate::model::elasticsearch_buffering_hints::Builder {
        crate::model::elasticsearch_buffering_hints::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ElasticsearchIndexRotationPeriod {
    #[allow(missing_docs)] // documentation missing in model
    NoRotation,
    #[allow(missing_docs)] // documentation missing in model
    OneDay,
    #[allow(missing_docs)] // documentation missing in model
    OneHour,
    #[allow(missing_docs)] // documentation missing in model
    OneMonth,
    #[allow(missing_docs)] // documentation missing in model
    OneWeek,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ElasticsearchIndexRotationPeriod {
    fn from(s: &str) -> Self {
        match s {
            "NoRotation" => ElasticsearchIndexRotationPeriod::NoRotation,
            "OneDay" => ElasticsearchIndexRotationPeriod::OneDay,
            "OneHour" => ElasticsearchIndexRotationPeriod::OneHour,
            "OneMonth" => ElasticsearchIndexRotationPeriod::OneMonth,
            "OneWeek" => ElasticsearchIndexRotationPeriod::OneWeek,
            other => ElasticsearchIndexRotationPeriod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ElasticsearchIndexRotationPeriod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ElasticsearchIndexRotationPeriod::from(s))
    }
}
impl ElasticsearchIndexRotationPeriod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ElasticsearchIndexRotationPeriod::NoRotation => "NoRotation",
            ElasticsearchIndexRotationPeriod::OneDay => "OneDay",
            ElasticsearchIndexRotationPeriod::OneHour => "OneHour",
            ElasticsearchIndexRotationPeriod::OneMonth => "OneMonth",
            ElasticsearchIndexRotationPeriod::OneWeek => "OneWeek",
            ElasticsearchIndexRotationPeriod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NoRotation", "OneDay", "OneHour", "OneMonth", "OneWeek"]
    }
}
impl AsRef<str> for ElasticsearchIndexRotationPeriod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an update for a destination in Amazon Redshift.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftDestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The database connection string.</p>
    pub cluster_jdbcurl: std::option::Option<std::string::String>,
    /// <p>The <code>COPY</code> command.</p>
    pub copy_command: std::option::Option<crate::model::CopyCommand>,
    /// <p>The name of the user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The user password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
    pub retry_options: std::option::Option<crate::model::RedshiftRetryOptions>,
    /// <p>The Amazon S3 destination.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// in <code>RedshiftDestinationUpdate.S3Update</code> because the Amazon Redshift
    /// <code>COPY</code> operation that reads from the S3 bucket doesn't support these
    /// compression formats.</p>
    pub s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
    /// backup is enabled, you can't update the delivery stream to disable it. </p>
    pub s3_backup_mode: std::option::Option<crate::model::RedshiftS3BackupMode>,
    /// <p>The Amazon S3 destination for backup.</p>
    pub s3_backup_update: std::option::Option<crate::model::S3DestinationUpdate>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl RedshiftDestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The database connection string.</p>
    pub fn cluster_jdbcurl(&self) -> std::option::Option<&str> {
        self.cluster_jdbcurl.as_deref()
    }
    /// <p>The <code>COPY</code> command.</p>
    pub fn copy_command(&self) -> std::option::Option<&crate::model::CopyCommand> {
        self.copy_command.as_ref()
    }
    /// <p>The name of the user.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The user password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::RedshiftRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>The Amazon S3 destination.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// in <code>RedshiftDestinationUpdate.S3Update</code> because the Amazon Redshift
    /// <code>COPY</code> operation that reads from the S3 bucket doesn't support these
    /// compression formats.</p>
    pub fn s3_update(&self) -> std::option::Option<&crate::model::S3DestinationUpdate> {
        self.s3_update.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
    /// backup is enabled, you can't update the delivery stream to disable it. </p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::RedshiftS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The Amazon S3 destination for backup.</p>
    pub fn s3_backup_update(&self) -> std::option::Option<&crate::model::S3DestinationUpdate> {
        self.s3_backup_update.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for RedshiftDestinationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftDestinationUpdate");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("cluster_jdbcurl", &self.cluster_jdbcurl);
        formatter.field("copy_command", &self.copy_command);
        formatter.field("username", &"*** Sensitive Data Redacted ***");
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_update", &self.s3_update);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_backup_update", &self.s3_backup_update);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`RedshiftDestinationUpdate`](crate::model::RedshiftDestinationUpdate)
pub mod redshift_destination_update {
    /// A builder for [`RedshiftDestinationUpdate`](crate::model::RedshiftDestinationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_jdbcurl: std::option::Option<std::string::String>,
        pub(crate) copy_command: std::option::Option<crate::model::CopyCommand>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) retry_options: std::option::Option<crate::model::RedshiftRetryOptions>,
        pub(crate) s3_update: std::option::Option<crate::model::S3DestinationUpdate>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::RedshiftS3BackupMode>,
        pub(crate) s3_backup_update: std::option::Option<crate::model::S3DestinationUpdate>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The database connection string.</p>
        pub fn cluster_jdbcurl(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_jdbcurl = Some(input.into());
            self
        }
        /// <p>The database connection string.</p>
        pub fn set_cluster_jdbcurl(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_jdbcurl = input;
            self
        }
        /// <p>The <code>COPY</code> command.</p>
        pub fn copy_command(mut self, input: crate::model::CopyCommand) -> Self {
            self.copy_command = Some(input);
            self
        }
        /// <p>The <code>COPY</code> command.</p>
        pub fn set_copy_command(
            mut self,
            input: std::option::Option<crate::model::CopyCommand>,
        ) -> Self {
            self.copy_command = input;
            self
        }
        /// <p>The name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The user password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The user password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
        pub fn retry_options(mut self, input: crate::model::RedshiftRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::RedshiftRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>The Amazon S3 destination.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// in <code>RedshiftDestinationUpdate.S3Update</code> because the Amazon Redshift
        /// <code>COPY</code> operation that reads from the S3 bucket doesn't support these
        /// compression formats.</p>
        pub fn s3_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_update = Some(input);
            self
        }
        /// <p>The Amazon S3 destination.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// in <code>RedshiftDestinationUpdate.S3Update</code> because the Amazon Redshift
        /// <code>COPY</code> operation that reads from the S3 bucket doesn't support these
        /// compression formats.</p>
        pub fn set_s3_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_update = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
        /// backup is enabled, you can't update the delivery stream to disable it. </p>
        pub fn s3_backup_mode(mut self, input: crate::model::RedshiftS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
        /// backup is enabled, you can't update the delivery stream to disable it. </p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::RedshiftS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The Amazon S3 destination for backup.</p>
        pub fn s3_backup_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_backup_update = Some(input);
            self
        }
        /// <p>The Amazon S3 destination for backup.</p>
        pub fn set_s3_backup_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_backup_update = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftDestinationUpdate`](crate::model::RedshiftDestinationUpdate)
        pub fn build(self) -> crate::model::RedshiftDestinationUpdate {
            crate::model::RedshiftDestinationUpdate {
                role_arn: self.role_arn,
                cluster_jdbcurl: self.cluster_jdbcurl,
                copy_command: self.copy_command,
                username: self.username,
                password: self.password,
                retry_options: self.retry_options,
                s3_update: self.s3_update,
                processing_configuration: self.processing_configuration,
                s3_backup_mode: self.s3_backup_mode,
                s3_backup_update: self.s3_backup_update,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl RedshiftDestinationUpdate {
    /// Creates a new builder-style object to manufacture [`RedshiftDestinationUpdate`](crate::model::RedshiftDestinationUpdate)
    pub fn builder() -> crate::model::redshift_destination_update::Builder {
        crate::model::redshift_destination_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RedshiftS3BackupMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RedshiftS3BackupMode {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => RedshiftS3BackupMode::Disabled,
            "Enabled" => RedshiftS3BackupMode::Enabled,
            other => RedshiftS3BackupMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RedshiftS3BackupMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RedshiftS3BackupMode::from(s))
    }
}
impl RedshiftS3BackupMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RedshiftS3BackupMode::Disabled => "Disabled",
            RedshiftS3BackupMode::Enabled => "Enabled",
            RedshiftS3BackupMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for RedshiftS3BackupMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configures retry behavior in case Kinesis Data Firehose is unable to deliver
/// documents to Amazon Redshift.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftRetryOptions {
    /// <p>The length of time during which Kinesis Data Firehose retries delivery after a
    /// failure, starting from the initial request and including the first attempt. The default
    /// value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of
    /// <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer
    /// than the current value.</p>
    pub duration_in_seconds: std::option::Option<i32>,
}
impl RedshiftRetryOptions {
    /// <p>The length of time during which Kinesis Data Firehose retries delivery after a
    /// failure, starting from the initial request and including the first attempt. The default
    /// value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of
    /// <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer
    /// than the current value.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i32> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for RedshiftRetryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftRetryOptions");
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`RedshiftRetryOptions`](crate::model::RedshiftRetryOptions)
pub mod redshift_retry_options {
    /// A builder for [`RedshiftRetryOptions`](crate::model::RedshiftRetryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The length of time during which Kinesis Data Firehose retries delivery after a
        /// failure, starting from the initial request and including the first attempt. The default
        /// value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of
        /// <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer
        /// than the current value.</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>The length of time during which Kinesis Data Firehose retries delivery after a
        /// failure, starting from the initial request and including the first attempt. The default
        /// value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of
        /// <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer
        /// than the current value.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftRetryOptions`](crate::model::RedshiftRetryOptions)
        pub fn build(self) -> crate::model::RedshiftRetryOptions {
            crate::model::RedshiftRetryOptions {
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl RedshiftRetryOptions {
    /// Creates a new builder-style object to manufacture [`RedshiftRetryOptions`](crate::model::RedshiftRetryOptions)
    pub fn builder() -> crate::model::redshift_retry_options::Builder {
        crate::model::redshift_retry_options::Builder::default()
    }
}

/// <p>Describes a <code>COPY</code> command for Amazon Redshift.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyCommand {
    /// <p>The name of the target table. The table must already exist in the database.</p>
    pub data_table_name: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of column names.</p>
    pub data_table_columns: std::option::Option<std::string::String>,
    /// <p>Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For
    /// more information, see the "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some possible
    /// examples that would apply to Kinesis Data Firehose are as follows:</p>
    /// <p>
    /// <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and
    /// compressed using lzop.</p>
    /// <p>
    /// <code>delimiter '|'</code> - fields are delimited with "|" (this is the default
    /// delimiter).</p>
    /// <p>
    /// <code>delimiter '|' escape</code> - the delimiter should be escaped.</p>
    /// <p>
    /// <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> -
    /// fields are fixed width in the source, with each width specified after every column in the
    /// table.</p>
    /// <p>
    /// <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path
    /// specified is the format of the data.</p>
    /// <p>For more examples, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
    /// examples</a>.</p>
    pub copy_options: std::option::Option<std::string::String>,
}
impl CopyCommand {
    /// <p>The name of the target table. The table must already exist in the database.</p>
    pub fn data_table_name(&self) -> std::option::Option<&str> {
        self.data_table_name.as_deref()
    }
    /// <p>A comma-separated list of column names.</p>
    pub fn data_table_columns(&self) -> std::option::Option<&str> {
        self.data_table_columns.as_deref()
    }
    /// <p>Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For
    /// more information, see the "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some possible
    /// examples that would apply to Kinesis Data Firehose are as follows:</p>
    /// <p>
    /// <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and
    /// compressed using lzop.</p>
    /// <p>
    /// <code>delimiter '|'</code> - fields are delimited with "|" (this is the default
    /// delimiter).</p>
    /// <p>
    /// <code>delimiter '|' escape</code> - the delimiter should be escaped.</p>
    /// <p>
    /// <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> -
    /// fields are fixed width in the source, with each width specified after every column in the
    /// table.</p>
    /// <p>
    /// <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path
    /// specified is the format of the data.</p>
    /// <p>For more examples, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
    /// examples</a>.</p>
    pub fn copy_options(&self) -> std::option::Option<&str> {
        self.copy_options.as_deref()
    }
}
impl std::fmt::Debug for CopyCommand {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyCommand");
        formatter.field("data_table_name", &self.data_table_name);
        formatter.field("data_table_columns", &self.data_table_columns);
        formatter.field("copy_options", &self.copy_options);
        formatter.finish()
    }
}
/// See [`CopyCommand`](crate::model::CopyCommand)
pub mod copy_command {
    /// A builder for [`CopyCommand`](crate::model::CopyCommand)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_table_name: std::option::Option<std::string::String>,
        pub(crate) data_table_columns: std::option::Option<std::string::String>,
        pub(crate) copy_options: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the target table. The table must already exist in the database.</p>
        pub fn data_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_table_name = Some(input.into());
            self
        }
        /// <p>The name of the target table. The table must already exist in the database.</p>
        pub fn set_data_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_table_name = input;
            self
        }
        /// <p>A comma-separated list of column names.</p>
        pub fn data_table_columns(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_table_columns = Some(input.into());
            self
        }
        /// <p>A comma-separated list of column names.</p>
        pub fn set_data_table_columns(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_table_columns = input;
            self
        }
        /// <p>Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For
        /// more information, see the "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some possible
        /// examples that would apply to Kinesis Data Firehose are as follows:</p>
        /// <p>
        /// <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and
        /// compressed using lzop.</p>
        /// <p>
        /// <code>delimiter '|'</code> - fields are delimited with "|" (this is the default
        /// delimiter).</p>
        /// <p>
        /// <code>delimiter '|' escape</code> - the delimiter should be escaped.</p>
        /// <p>
        /// <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> -
        /// fields are fixed width in the source, with each width specified after every column in the
        /// table.</p>
        /// <p>
        /// <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path
        /// specified is the format of the data.</p>
        /// <p>For more examples, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
        /// examples</a>.</p>
        pub fn copy_options(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_options = Some(input.into());
            self
        }
        /// <p>Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For
        /// more information, see the "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some possible
        /// examples that would apply to Kinesis Data Firehose are as follows:</p>
        /// <p>
        /// <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and
        /// compressed using lzop.</p>
        /// <p>
        /// <code>delimiter '|'</code> - fields are delimited with "|" (this is the default
        /// delimiter).</p>
        /// <p>
        /// <code>delimiter '|' escape</code> - the delimiter should be escaped.</p>
        /// <p>
        /// <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> -
        /// fields are fixed width in the source, with each width specified after every column in the
        /// table.</p>
        /// <p>
        /// <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path
        /// specified is the format of the data.</p>
        /// <p>For more examples, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
        /// examples</a>.</p>
        pub fn set_copy_options(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.copy_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyCommand`](crate::model::CopyCommand)
        pub fn build(self) -> crate::model::CopyCommand {
            crate::model::CopyCommand {
                data_table_name: self.data_table_name,
                data_table_columns: self.data_table_columns,
                copy_options: self.copy_options,
            }
        }
    }
}
impl CopyCommand {
    /// Creates a new builder-style object to manufacture [`CopyCommand`](crate::model::CopyCommand)
    pub fn builder() -> crate::model::copy_command::Builder {
        crate::model::copy_command::Builder::default()
    }
}

/// <p>Describes an update for a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtendedS3DestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub error_output_prefix: std::option::Option<std::string::String>,
    /// <p>The buffering option.</p>
    pub buffering_hints: std::option::Option<crate::model::BufferingHints>,
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>. </p>
    pub compression_format: std::option::Option<crate::model::CompressionFormat>,
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
    /// backup is enabled, you can't update the delivery stream to disable it. </p>
    pub s3_backup_mode: std::option::Option<crate::model::S3BackupMode>,
    /// <p>The Amazon S3 destination for backup.</p>
    pub s3_backup_update: std::option::Option<crate::model::S3DestinationUpdate>,
    /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
    /// the Parquet or ORC format before writing it to Amazon S3.</p>
    pub data_format_conversion_configuration:
        std::option::Option<crate::model::DataFormatConversionConfiguration>,
    /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
    /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
    /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
    /// </p>
    pub dynamic_partitioning_configuration:
        std::option::Option<crate::model::DynamicPartitioningConfiguration>,
}
impl ExtendedS3DestinationUpdate {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn error_output_prefix(&self) -> std::option::Option<&str> {
        self.error_output_prefix.as_deref()
    }
    /// <p>The buffering option.</p>
    pub fn buffering_hints(&self) -> std::option::Option<&crate::model::BufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>. </p>
    pub fn compression_format(&self) -> std::option::Option<&crate::model::CompressionFormat> {
        self.compression_format.as_ref()
    }
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
    /// backup is enabled, you can't update the delivery stream to disable it. </p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::S3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The Amazon S3 destination for backup.</p>
    pub fn s3_backup_update(&self) -> std::option::Option<&crate::model::S3DestinationUpdate> {
        self.s3_backup_update.as_ref()
    }
    /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
    /// the Parquet or ORC format before writing it to Amazon S3.</p>
    pub fn data_format_conversion_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataFormatConversionConfiguration> {
        self.data_format_conversion_configuration.as_ref()
    }
    /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
    /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
    /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
    /// </p>
    pub fn dynamic_partitioning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DynamicPartitioningConfiguration> {
        self.dynamic_partitioning_configuration.as_ref()
    }
}
impl std::fmt::Debug for ExtendedS3DestinationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtendedS3DestinationUpdate");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("prefix", &self.prefix);
        formatter.field("error_output_prefix", &self.error_output_prefix);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("compression_format", &self.compression_format);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_backup_update", &self.s3_backup_update);
        formatter.field(
            "data_format_conversion_configuration",
            &self.data_format_conversion_configuration,
        );
        formatter.field(
            "dynamic_partitioning_configuration",
            &self.dynamic_partitioning_configuration,
        );
        formatter.finish()
    }
}
/// See [`ExtendedS3DestinationUpdate`](crate::model::ExtendedS3DestinationUpdate)
pub mod extended_s3_destination_update {
    /// A builder for [`ExtendedS3DestinationUpdate`](crate::model::ExtendedS3DestinationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) error_output_prefix: std::option::Option<std::string::String>,
        pub(crate) buffering_hints: std::option::Option<crate::model::BufferingHints>,
        pub(crate) compression_format: std::option::Option<crate::model::CompressionFormat>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::S3BackupMode>,
        pub(crate) s3_backup_update: std::option::Option<crate::model::S3DestinationUpdate>,
        pub(crate) data_format_conversion_configuration:
            std::option::Option<crate::model::DataFormatConversionConfiguration>,
        pub(crate) dynamic_partitioning_configuration:
            std::option::Option<crate::model::DynamicPartitioningConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn error_output_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_output_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_error_output_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_output_prefix = input;
            self
        }
        /// <p>The buffering option.</p>
        pub fn buffering_hints(mut self, input: crate::model::BufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering option.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::BufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>. </p>
        pub fn compression_format(mut self, input: crate::model::CompressionFormat) -> Self {
            self.compression_format = Some(input);
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>. </p>
        pub fn set_compression_format(
            mut self,
            input: std::option::Option<crate::model::CompressionFormat>,
        ) -> Self {
            self.compression_format = input;
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
        /// backup is enabled, you can't update the delivery stream to disable it. </p>
        pub fn s3_backup_mode(mut self, input: crate::model::S3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
        /// backup is enabled, you can't update the delivery stream to disable it. </p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::S3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The Amazon S3 destination for backup.</p>
        pub fn s3_backup_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_backup_update = Some(input);
            self
        }
        /// <p>The Amazon S3 destination for backup.</p>
        pub fn set_s3_backup_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_backup_update = input;
            self
        }
        /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
        /// the Parquet or ORC format before writing it to Amazon S3.</p>
        pub fn data_format_conversion_configuration(
            mut self,
            input: crate::model::DataFormatConversionConfiguration,
        ) -> Self {
            self.data_format_conversion_configuration = Some(input);
            self
        }
        /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
        /// the Parquet or ORC format before writing it to Amazon S3.</p>
        pub fn set_data_format_conversion_configuration(
            mut self,
            input: std::option::Option<crate::model::DataFormatConversionConfiguration>,
        ) -> Self {
            self.data_format_conversion_configuration = input;
            self
        }
        /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
        /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
        /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
        /// </p>
        pub fn dynamic_partitioning_configuration(
            mut self,
            input: crate::model::DynamicPartitioningConfiguration,
        ) -> Self {
            self.dynamic_partitioning_configuration = Some(input);
            self
        }
        /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
        /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
        /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
        /// </p>
        pub fn set_dynamic_partitioning_configuration(
            mut self,
            input: std::option::Option<crate::model::DynamicPartitioningConfiguration>,
        ) -> Self {
            self.dynamic_partitioning_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtendedS3DestinationUpdate`](crate::model::ExtendedS3DestinationUpdate)
        pub fn build(self) -> crate::model::ExtendedS3DestinationUpdate {
            crate::model::ExtendedS3DestinationUpdate {
                role_arn: self.role_arn,
                bucket_arn: self.bucket_arn,
                prefix: self.prefix,
                error_output_prefix: self.error_output_prefix,
                buffering_hints: self.buffering_hints,
                compression_format: self.compression_format,
                encryption_configuration: self.encryption_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                processing_configuration: self.processing_configuration,
                s3_backup_mode: self.s3_backup_mode,
                s3_backup_update: self.s3_backup_update,
                data_format_conversion_configuration: self.data_format_conversion_configuration,
                dynamic_partitioning_configuration: self.dynamic_partitioning_configuration,
            }
        }
    }
}
impl ExtendedS3DestinationUpdate {
    /// Creates a new builder-style object to manufacture [`ExtendedS3DestinationUpdate`](crate::model::ExtendedS3DestinationUpdate)
    pub fn builder() -> crate::model::extended_s3_destination_update::Builder {
        crate::model::extended_s3_destination_update::Builder::default()
    }
}

/// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
/// from the streaming data by partitioning it based on partition keys. Currently, dynamic
/// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamicPartitioningConfiguration {
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon
    /// S3 prefix.</p>
    pub retry_options: std::option::Option<crate::model::RetryOptions>,
    /// <p>Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose
    /// delivery stream.</p>
    pub enabled: std::option::Option<bool>,
}
impl DynamicPartitioningConfiguration {
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon
    /// S3 prefix.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::RetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose
    /// delivery stream.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for DynamicPartitioningConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamicPartitioningConfiguration");
        formatter.field("retry_options", &self.retry_options);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`DynamicPartitioningConfiguration`](crate::model::DynamicPartitioningConfiguration)
pub mod dynamic_partitioning_configuration {
    /// A builder for [`DynamicPartitioningConfiguration`](crate::model::DynamicPartitioningConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_options: std::option::Option<crate::model::RetryOptions>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon
        /// S3 prefix.</p>
        pub fn retry_options(mut self, input: crate::model::RetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon
        /// S3 prefix.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::RetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose
        /// delivery stream.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose
        /// delivery stream.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamicPartitioningConfiguration`](crate::model::DynamicPartitioningConfiguration)
        pub fn build(self) -> crate::model::DynamicPartitioningConfiguration {
            crate::model::DynamicPartitioningConfiguration {
                retry_options: self.retry_options,
                enabled: self.enabled,
            }
        }
    }
}
impl DynamicPartitioningConfiguration {
    /// Creates a new builder-style object to manufacture [`DynamicPartitioningConfiguration`](crate::model::DynamicPartitioningConfiguration)
    pub fn builder() -> crate::model::dynamic_partitioning_configuration::Builder {
        crate::model::dynamic_partitioning_configuration::Builder::default()
    }
}

/// <p> The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon
/// S3 prefix.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryOptions {
    /// <p>The period of time during which Kinesis Data Firehose retries to deliver data to the
    /// specified Amazon S3 prefix.</p>
    pub duration_in_seconds: std::option::Option<i32>,
}
impl RetryOptions {
    /// <p>The period of time during which Kinesis Data Firehose retries to deliver data to the
    /// specified Amazon S3 prefix.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i32> {
        self.duration_in_seconds
    }
}
impl std::fmt::Debug for RetryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryOptions");
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.finish()
    }
}
/// See [`RetryOptions`](crate::model::RetryOptions)
pub mod retry_options {
    /// A builder for [`RetryOptions`](crate::model::RetryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The period of time during which Kinesis Data Firehose retries to deliver data to the
        /// specified Amazon S3 prefix.</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>The period of time during which Kinesis Data Firehose retries to deliver data to the
        /// specified Amazon S3 prefix.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryOptions`](crate::model::RetryOptions)
        pub fn build(self) -> crate::model::RetryOptions {
            crate::model::RetryOptions {
                duration_in_seconds: self.duration_in_seconds,
            }
        }
    }
}
impl RetryOptions {
    /// Creates a new builder-style object to manufacture [`RetryOptions`](crate::model::RetryOptions)
    pub fn builder() -> crate::model::retry_options::Builder {
        crate::model::retry_options::Builder::default()
    }
}

/// <p>Specifies that you want Kinesis Data Firehose to convert data from the JSON format to
/// the Parquet or ORC format before writing it to Amazon S3. Kinesis Data Firehose uses the
/// serializer and deserializer that you specify, in addition to the column information from
/// the AWS Glue table, to deserialize your input data from JSON and then serialize it to the
/// Parquet or ORC format. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html">Kinesis Data Firehose Record
/// Format Conversion</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataFormatConversionConfiguration {
    /// <p>Specifies the AWS Glue Data Catalog table that contains the column information. This
    /// parameter is required if <code>Enabled</code> is set to true.</p>
    pub schema_configuration: std::option::Option<crate::model::SchemaConfiguration>,
    /// <p>Specifies the deserializer that you want Kinesis Data Firehose to use to convert the
    /// format of your data from JSON. This parameter is required if <code>Enabled</code> is set to
    /// true.</p>
    pub input_format_configuration: std::option::Option<crate::model::InputFormatConfiguration>,
    /// <p>Specifies the serializer that you want Kinesis Data Firehose to use to convert the
    /// format of your data to the Parquet or ORC format. This parameter is required if
    /// <code>Enabled</code> is set to true.</p>
    pub output_format_configuration: std::option::Option<crate::model::OutputFormatConfiguration>,
    /// <p>Defaults to <code>true</code>. Set it to <code>false</code> if you want to disable
    /// format conversion while preserving the configuration details.</p>
    pub enabled: std::option::Option<bool>,
}
impl DataFormatConversionConfiguration {
    /// <p>Specifies the AWS Glue Data Catalog table that contains the column information. This
    /// parameter is required if <code>Enabled</code> is set to true.</p>
    pub fn schema_configuration(&self) -> std::option::Option<&crate::model::SchemaConfiguration> {
        self.schema_configuration.as_ref()
    }
    /// <p>Specifies the deserializer that you want Kinesis Data Firehose to use to convert the
    /// format of your data from JSON. This parameter is required if <code>Enabled</code> is set to
    /// true.</p>
    pub fn input_format_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InputFormatConfiguration> {
        self.input_format_configuration.as_ref()
    }
    /// <p>Specifies the serializer that you want Kinesis Data Firehose to use to convert the
    /// format of your data to the Parquet or ORC format. This parameter is required if
    /// <code>Enabled</code> is set to true.</p>
    pub fn output_format_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OutputFormatConfiguration> {
        self.output_format_configuration.as_ref()
    }
    /// <p>Defaults to <code>true</code>. Set it to <code>false</code> if you want to disable
    /// format conversion while preserving the configuration details.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for DataFormatConversionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataFormatConversionConfiguration");
        formatter.field("schema_configuration", &self.schema_configuration);
        formatter.field(
            "input_format_configuration",
            &self.input_format_configuration,
        );
        formatter.field(
            "output_format_configuration",
            &self.output_format_configuration,
        );
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`DataFormatConversionConfiguration`](crate::model::DataFormatConversionConfiguration)
pub mod data_format_conversion_configuration {
    /// A builder for [`DataFormatConversionConfiguration`](crate::model::DataFormatConversionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_configuration: std::option::Option<crate::model::SchemaConfiguration>,
        pub(crate) input_format_configuration:
            std::option::Option<crate::model::InputFormatConfiguration>,
        pub(crate) output_format_configuration:
            std::option::Option<crate::model::OutputFormatConfiguration>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the AWS Glue Data Catalog table that contains the column information. This
        /// parameter is required if <code>Enabled</code> is set to true.</p>
        pub fn schema_configuration(mut self, input: crate::model::SchemaConfiguration) -> Self {
            self.schema_configuration = Some(input);
            self
        }
        /// <p>Specifies the AWS Glue Data Catalog table that contains the column information. This
        /// parameter is required if <code>Enabled</code> is set to true.</p>
        pub fn set_schema_configuration(
            mut self,
            input: std::option::Option<crate::model::SchemaConfiguration>,
        ) -> Self {
            self.schema_configuration = input;
            self
        }
        /// <p>Specifies the deserializer that you want Kinesis Data Firehose to use to convert the
        /// format of your data from JSON. This parameter is required if <code>Enabled</code> is set to
        /// true.</p>
        pub fn input_format_configuration(
            mut self,
            input: crate::model::InputFormatConfiguration,
        ) -> Self {
            self.input_format_configuration = Some(input);
            self
        }
        /// <p>Specifies the deserializer that you want Kinesis Data Firehose to use to convert the
        /// format of your data from JSON. This parameter is required if <code>Enabled</code> is set to
        /// true.</p>
        pub fn set_input_format_configuration(
            mut self,
            input: std::option::Option<crate::model::InputFormatConfiguration>,
        ) -> Self {
            self.input_format_configuration = input;
            self
        }
        /// <p>Specifies the serializer that you want Kinesis Data Firehose to use to convert the
        /// format of your data to the Parquet or ORC format. This parameter is required if
        /// <code>Enabled</code> is set to true.</p>
        pub fn output_format_configuration(
            mut self,
            input: crate::model::OutputFormatConfiguration,
        ) -> Self {
            self.output_format_configuration = Some(input);
            self
        }
        /// <p>Specifies the serializer that you want Kinesis Data Firehose to use to convert the
        /// format of your data to the Parquet or ORC format. This parameter is required if
        /// <code>Enabled</code> is set to true.</p>
        pub fn set_output_format_configuration(
            mut self,
            input: std::option::Option<crate::model::OutputFormatConfiguration>,
        ) -> Self {
            self.output_format_configuration = input;
            self
        }
        /// <p>Defaults to <code>true</code>. Set it to <code>false</code> if you want to disable
        /// format conversion while preserving the configuration details.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Defaults to <code>true</code>. Set it to <code>false</code> if you want to disable
        /// format conversion while preserving the configuration details.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DataFormatConversionConfiguration`](crate::model::DataFormatConversionConfiguration)
        pub fn build(self) -> crate::model::DataFormatConversionConfiguration {
            crate::model::DataFormatConversionConfiguration {
                schema_configuration: self.schema_configuration,
                input_format_configuration: self.input_format_configuration,
                output_format_configuration: self.output_format_configuration,
                enabled: self.enabled,
            }
        }
    }
}
impl DataFormatConversionConfiguration {
    /// Creates a new builder-style object to manufacture [`DataFormatConversionConfiguration`](crate::model::DataFormatConversionConfiguration)
    pub fn builder() -> crate::model::data_format_conversion_configuration::Builder {
        crate::model::data_format_conversion_configuration::Builder::default()
    }
}

/// <p>Specifies the serializer that you want Kinesis Data Firehose to use to convert the
/// format of your data before it writes it to Amazon S3. This parameter is required if
/// <code>Enabled</code> is set to true.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputFormatConfiguration {
    /// <p>Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet
    /// SerDe. If both are non-null, the server rejects the request.</p>
    pub serializer: std::option::Option<crate::model::Serializer>,
}
impl OutputFormatConfiguration {
    /// <p>Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet
    /// SerDe. If both are non-null, the server rejects the request.</p>
    pub fn serializer(&self) -> std::option::Option<&crate::model::Serializer> {
        self.serializer.as_ref()
    }
}
impl std::fmt::Debug for OutputFormatConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputFormatConfiguration");
        formatter.field("serializer", &self.serializer);
        formatter.finish()
    }
}
/// See [`OutputFormatConfiguration`](crate::model::OutputFormatConfiguration)
pub mod output_format_configuration {
    /// A builder for [`OutputFormatConfiguration`](crate::model::OutputFormatConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) serializer: std::option::Option<crate::model::Serializer>,
    }
    impl Builder {
        /// <p>Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet
        /// SerDe. If both are non-null, the server rejects the request.</p>
        pub fn serializer(mut self, input: crate::model::Serializer) -> Self {
            self.serializer = Some(input);
            self
        }
        /// <p>Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet
        /// SerDe. If both are non-null, the server rejects the request.</p>
        pub fn set_serializer(
            mut self,
            input: std::option::Option<crate::model::Serializer>,
        ) -> Self {
            self.serializer = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputFormatConfiguration`](crate::model::OutputFormatConfiguration)
        pub fn build(self) -> crate::model::OutputFormatConfiguration {
            crate::model::OutputFormatConfiguration {
                serializer: self.serializer,
            }
        }
    }
}
impl OutputFormatConfiguration {
    /// Creates a new builder-style object to manufacture [`OutputFormatConfiguration`](crate::model::OutputFormatConfiguration)
    pub fn builder() -> crate::model::output_format_configuration::Builder {
        crate::model::output_format_configuration::Builder::default()
    }
}

/// <p>The serializer that you want Kinesis Data Firehose to use to convert data to the target
/// format before writing it to Amazon S3. Kinesis Data Firehose supports two types of
/// serializers: the <a href="https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html">ORC SerDe</a> and the <a href="https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html">Parquet SerDe</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Serializer {
    /// <p>A serializer to use for converting data to the Parquet format before storing it in
    /// Amazon S3. For more information, see <a href="https://parquet.apache.org/documentation/latest/">Apache Parquet</a>.</p>
    pub parquet_ser_de: std::option::Option<crate::model::ParquetSerDe>,
    /// <p>A serializer to use for converting data to the ORC format before storing it in Amazon
    /// S3. For more information, see <a href="https://orc.apache.org/docs/">Apache
    /// ORC</a>.</p>
    pub orc_ser_de: std::option::Option<crate::model::OrcSerDe>,
}
impl Serializer {
    /// <p>A serializer to use for converting data to the Parquet format before storing it in
    /// Amazon S3. For more information, see <a href="https://parquet.apache.org/documentation/latest/">Apache Parquet</a>.</p>
    pub fn parquet_ser_de(&self) -> std::option::Option<&crate::model::ParquetSerDe> {
        self.parquet_ser_de.as_ref()
    }
    /// <p>A serializer to use for converting data to the ORC format before storing it in Amazon
    /// S3. For more information, see <a href="https://orc.apache.org/docs/">Apache
    /// ORC</a>.</p>
    pub fn orc_ser_de(&self) -> std::option::Option<&crate::model::OrcSerDe> {
        self.orc_ser_de.as_ref()
    }
}
impl std::fmt::Debug for Serializer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Serializer");
        formatter.field("parquet_ser_de", &self.parquet_ser_de);
        formatter.field("orc_ser_de", &self.orc_ser_de);
        formatter.finish()
    }
}
/// See [`Serializer`](crate::model::Serializer)
pub mod serializer {
    /// A builder for [`Serializer`](crate::model::Serializer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parquet_ser_de: std::option::Option<crate::model::ParquetSerDe>,
        pub(crate) orc_ser_de: std::option::Option<crate::model::OrcSerDe>,
    }
    impl Builder {
        /// <p>A serializer to use for converting data to the Parquet format before storing it in
        /// Amazon S3. For more information, see <a href="https://parquet.apache.org/documentation/latest/">Apache Parquet</a>.</p>
        pub fn parquet_ser_de(mut self, input: crate::model::ParquetSerDe) -> Self {
            self.parquet_ser_de = Some(input);
            self
        }
        /// <p>A serializer to use for converting data to the Parquet format before storing it in
        /// Amazon S3. For more information, see <a href="https://parquet.apache.org/documentation/latest/">Apache Parquet</a>.</p>
        pub fn set_parquet_ser_de(
            mut self,
            input: std::option::Option<crate::model::ParquetSerDe>,
        ) -> Self {
            self.parquet_ser_de = input;
            self
        }
        /// <p>A serializer to use for converting data to the ORC format before storing it in Amazon
        /// S3. For more information, see <a href="https://orc.apache.org/docs/">Apache
        /// ORC</a>.</p>
        pub fn orc_ser_de(mut self, input: crate::model::OrcSerDe) -> Self {
            self.orc_ser_de = Some(input);
            self
        }
        /// <p>A serializer to use for converting data to the ORC format before storing it in Amazon
        /// S3. For more information, see <a href="https://orc.apache.org/docs/">Apache
        /// ORC</a>.</p>
        pub fn set_orc_ser_de(
            mut self,
            input: std::option::Option<crate::model::OrcSerDe>,
        ) -> Self {
            self.orc_ser_de = input;
            self
        }
        /// Consumes the builder and constructs a [`Serializer`](crate::model::Serializer)
        pub fn build(self) -> crate::model::Serializer {
            crate::model::Serializer {
                parquet_ser_de: self.parquet_ser_de,
                orc_ser_de: self.orc_ser_de,
            }
        }
    }
}
impl Serializer {
    /// Creates a new builder-style object to manufacture [`Serializer`](crate::model::Serializer)
    pub fn builder() -> crate::model::serializer::Builder {
        crate::model::serializer::Builder::default()
    }
}

/// <p>A serializer to use for converting data to the ORC format before storing it in Amazon
/// S3. For more information, see <a href="https://orc.apache.org/docs/">Apache
/// ORC</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrcSerDe {
    /// <p>The number of bytes in each stripe. The default is 64 MiB and the minimum is 8
    /// MiB.</p>
    pub stripe_size_bytes: std::option::Option<i32>,
    /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
    /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
    /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
    pub block_size_bytes: std::option::Option<i32>,
    /// <p>The number of rows between index entries. The default is 10,000 and the minimum is
    /// 1,000.</p>
    pub row_index_stride: std::option::Option<i32>,
    /// <p>Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS
    /// block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS
    /// before querying. The default is <code>false</code>.</p>
    pub enable_padding: std::option::Option<bool>,
    /// <p>A number between 0 and 1 that defines the tolerance for block padding as a decimal
    /// fraction of stripe size. The default value is 0.05, which means 5 percent of stripe
    /// size.</p>
    /// <p>For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block
    /// padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB
    /// block. In such a case, if the available size within the block is more than 3.2 MiB, a new,
    /// smaller stripe is inserted to fit within that space. This ensures that no stripe crosses
    /// block boundaries and causes remote reads within a node-local task.</p>
    /// <p>Kinesis Data Firehose ignores this parameter when <a>OrcSerDe$EnablePadding</a> is <code>false</code>.</p>
    pub padding_tolerance: std::option::Option<f64>,
    /// <p>The compression code to use over data blocks. The default is <code>SNAPPY</code>.</p>
    pub compression: std::option::Option<crate::model::OrcCompression>,
    /// <p>The column names for which you want Kinesis Data Firehose to create bloom filters. The
    /// default is <code>null</code>.</p>
    pub bloom_filter_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the
    /// Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.</p>
    pub bloom_filter_false_positive_probability: std::option::Option<f64>,
    /// <p>Represents the fraction of the total number of non-null rows. To turn off dictionary
    /// encoding, set this fraction to a number that is less than the number of distinct keys in a
    /// dictionary. To always use dictionary encoding, set this threshold to 1.</p>
    pub dictionary_key_threshold: std::option::Option<f64>,
    /// <p>The version of the file to write. The possible values are <code>V0_11</code> and
    /// <code>V0_12</code>. The default is <code>V0_12</code>.</p>
    pub format_version: std::option::Option<crate::model::OrcFormatVersion>,
}
impl OrcSerDe {
    /// <p>The number of bytes in each stripe. The default is 64 MiB and the minimum is 8
    /// MiB.</p>
    pub fn stripe_size_bytes(&self) -> std::option::Option<i32> {
        self.stripe_size_bytes
    }
    /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
    /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
    /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
    pub fn block_size_bytes(&self) -> std::option::Option<i32> {
        self.block_size_bytes
    }
    /// <p>The number of rows between index entries. The default is 10,000 and the minimum is
    /// 1,000.</p>
    pub fn row_index_stride(&self) -> std::option::Option<i32> {
        self.row_index_stride
    }
    /// <p>Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS
    /// block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS
    /// before querying. The default is <code>false</code>.</p>
    pub fn enable_padding(&self) -> std::option::Option<bool> {
        self.enable_padding
    }
    /// <p>A number between 0 and 1 that defines the tolerance for block padding as a decimal
    /// fraction of stripe size. The default value is 0.05, which means 5 percent of stripe
    /// size.</p>
    /// <p>For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block
    /// padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB
    /// block. In such a case, if the available size within the block is more than 3.2 MiB, a new,
    /// smaller stripe is inserted to fit within that space. This ensures that no stripe crosses
    /// block boundaries and causes remote reads within a node-local task.</p>
    /// <p>Kinesis Data Firehose ignores this parameter when <a>OrcSerDe$EnablePadding</a> is <code>false</code>.</p>
    pub fn padding_tolerance(&self) -> std::option::Option<f64> {
        self.padding_tolerance
    }
    /// <p>The compression code to use over data blocks. The default is <code>SNAPPY</code>.</p>
    pub fn compression(&self) -> std::option::Option<&crate::model::OrcCompression> {
        self.compression.as_ref()
    }
    /// <p>The column names for which you want Kinesis Data Firehose to create bloom filters. The
    /// default is <code>null</code>.</p>
    pub fn bloom_filter_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.bloom_filter_columns.as_deref()
    }
    /// <p>The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the
    /// Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.</p>
    pub fn bloom_filter_false_positive_probability(&self) -> std::option::Option<f64> {
        self.bloom_filter_false_positive_probability
    }
    /// <p>Represents the fraction of the total number of non-null rows. To turn off dictionary
    /// encoding, set this fraction to a number that is less than the number of distinct keys in a
    /// dictionary. To always use dictionary encoding, set this threshold to 1.</p>
    pub fn dictionary_key_threshold(&self) -> std::option::Option<f64> {
        self.dictionary_key_threshold
    }
    /// <p>The version of the file to write. The possible values are <code>V0_11</code> and
    /// <code>V0_12</code>. The default is <code>V0_12</code>.</p>
    pub fn format_version(&self) -> std::option::Option<&crate::model::OrcFormatVersion> {
        self.format_version.as_ref()
    }
}
impl std::fmt::Debug for OrcSerDe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrcSerDe");
        formatter.field("stripe_size_bytes", &self.stripe_size_bytes);
        formatter.field("block_size_bytes", &self.block_size_bytes);
        formatter.field("row_index_stride", &self.row_index_stride);
        formatter.field("enable_padding", &self.enable_padding);
        formatter.field("padding_tolerance", &self.padding_tolerance);
        formatter.field("compression", &self.compression);
        formatter.field("bloom_filter_columns", &self.bloom_filter_columns);
        formatter.field(
            "bloom_filter_false_positive_probability",
            &self.bloom_filter_false_positive_probability,
        );
        formatter.field("dictionary_key_threshold", &self.dictionary_key_threshold);
        formatter.field("format_version", &self.format_version);
        formatter.finish()
    }
}
/// See [`OrcSerDe`](crate::model::OrcSerDe)
pub mod orc_ser_de {
    /// A builder for [`OrcSerDe`](crate::model::OrcSerDe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stripe_size_bytes: std::option::Option<i32>,
        pub(crate) block_size_bytes: std::option::Option<i32>,
        pub(crate) row_index_stride: std::option::Option<i32>,
        pub(crate) enable_padding: std::option::Option<bool>,
        pub(crate) padding_tolerance: std::option::Option<f64>,
        pub(crate) compression: std::option::Option<crate::model::OrcCompression>,
        pub(crate) bloom_filter_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) bloom_filter_false_positive_probability: std::option::Option<f64>,
        pub(crate) dictionary_key_threshold: std::option::Option<f64>,
        pub(crate) format_version: std::option::Option<crate::model::OrcFormatVersion>,
    }
    impl Builder {
        /// <p>The number of bytes in each stripe. The default is 64 MiB and the minimum is 8
        /// MiB.</p>
        pub fn stripe_size_bytes(mut self, input: i32) -> Self {
            self.stripe_size_bytes = Some(input);
            self
        }
        /// <p>The number of bytes in each stripe. The default is 64 MiB and the minimum is 8
        /// MiB.</p>
        pub fn set_stripe_size_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.stripe_size_bytes = input;
            self
        }
        /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
        /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
        /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
        pub fn block_size_bytes(mut self, input: i32) -> Self {
            self.block_size_bytes = Some(input);
            self
        }
        /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
        /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
        /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
        pub fn set_block_size_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.block_size_bytes = input;
            self
        }
        /// <p>The number of rows between index entries. The default is 10,000 and the minimum is
        /// 1,000.</p>
        pub fn row_index_stride(mut self, input: i32) -> Self {
            self.row_index_stride = Some(input);
            self
        }
        /// <p>The number of rows between index entries. The default is 10,000 and the minimum is
        /// 1,000.</p>
        pub fn set_row_index_stride(mut self, input: std::option::Option<i32>) -> Self {
            self.row_index_stride = input;
            self
        }
        /// <p>Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS
        /// block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS
        /// before querying. The default is <code>false</code>.</p>
        pub fn enable_padding(mut self, input: bool) -> Self {
            self.enable_padding = Some(input);
            self
        }
        /// <p>Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS
        /// block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS
        /// before querying. The default is <code>false</code>.</p>
        pub fn set_enable_padding(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_padding = input;
            self
        }
        /// <p>A number between 0 and 1 that defines the tolerance for block padding as a decimal
        /// fraction of stripe size. The default value is 0.05, which means 5 percent of stripe
        /// size.</p>
        /// <p>For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block
        /// padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB
        /// block. In such a case, if the available size within the block is more than 3.2 MiB, a new,
        /// smaller stripe is inserted to fit within that space. This ensures that no stripe crosses
        /// block boundaries and causes remote reads within a node-local task.</p>
        /// <p>Kinesis Data Firehose ignores this parameter when <a>OrcSerDe$EnablePadding</a> is <code>false</code>.</p>
        pub fn padding_tolerance(mut self, input: f64) -> Self {
            self.padding_tolerance = Some(input);
            self
        }
        /// <p>A number between 0 and 1 that defines the tolerance for block padding as a decimal
        /// fraction of stripe size. The default value is 0.05, which means 5 percent of stripe
        /// size.</p>
        /// <p>For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block
        /// padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB
        /// block. In such a case, if the available size within the block is more than 3.2 MiB, a new,
        /// smaller stripe is inserted to fit within that space. This ensures that no stripe crosses
        /// block boundaries and causes remote reads within a node-local task.</p>
        /// <p>Kinesis Data Firehose ignores this parameter when <a>OrcSerDe$EnablePadding</a> is <code>false</code>.</p>
        pub fn set_padding_tolerance(mut self, input: std::option::Option<f64>) -> Self {
            self.padding_tolerance = input;
            self
        }
        /// <p>The compression code to use over data blocks. The default is <code>SNAPPY</code>.</p>
        pub fn compression(mut self, input: crate::model::OrcCompression) -> Self {
            self.compression = Some(input);
            self
        }
        /// <p>The compression code to use over data blocks. The default is <code>SNAPPY</code>.</p>
        pub fn set_compression(
            mut self,
            input: std::option::Option<crate::model::OrcCompression>,
        ) -> Self {
            self.compression = input;
            self
        }
        /// Appends an item to `bloom_filter_columns`.
        ///
        /// To override the contents of this collection use [`set_bloom_filter_columns`](Self::set_bloom_filter_columns).
        ///
        /// <p>The column names for which you want Kinesis Data Firehose to create bloom filters. The
        /// default is <code>null</code>.</p>
        pub fn bloom_filter_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bloom_filter_columns.unwrap_or_default();
            v.push(input.into());
            self.bloom_filter_columns = Some(v);
            self
        }
        /// <p>The column names for which you want Kinesis Data Firehose to create bloom filters. The
        /// default is <code>null</code>.</p>
        pub fn set_bloom_filter_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bloom_filter_columns = input;
            self
        }
        /// <p>The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the
        /// Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.</p>
        pub fn bloom_filter_false_positive_probability(mut self, input: f64) -> Self {
            self.bloom_filter_false_positive_probability = Some(input);
            self
        }
        /// <p>The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the
        /// Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.</p>
        pub fn set_bloom_filter_false_positive_probability(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.bloom_filter_false_positive_probability = input;
            self
        }
        /// <p>Represents the fraction of the total number of non-null rows. To turn off dictionary
        /// encoding, set this fraction to a number that is less than the number of distinct keys in a
        /// dictionary. To always use dictionary encoding, set this threshold to 1.</p>
        pub fn dictionary_key_threshold(mut self, input: f64) -> Self {
            self.dictionary_key_threshold = Some(input);
            self
        }
        /// <p>Represents the fraction of the total number of non-null rows. To turn off dictionary
        /// encoding, set this fraction to a number that is less than the number of distinct keys in a
        /// dictionary. To always use dictionary encoding, set this threshold to 1.</p>
        pub fn set_dictionary_key_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.dictionary_key_threshold = input;
            self
        }
        /// <p>The version of the file to write. The possible values are <code>V0_11</code> and
        /// <code>V0_12</code>. The default is <code>V0_12</code>.</p>
        pub fn format_version(mut self, input: crate::model::OrcFormatVersion) -> Self {
            self.format_version = Some(input);
            self
        }
        /// <p>The version of the file to write. The possible values are <code>V0_11</code> and
        /// <code>V0_12</code>. The default is <code>V0_12</code>.</p>
        pub fn set_format_version(
            mut self,
            input: std::option::Option<crate::model::OrcFormatVersion>,
        ) -> Self {
            self.format_version = input;
            self
        }
        /// Consumes the builder and constructs a [`OrcSerDe`](crate::model::OrcSerDe)
        pub fn build(self) -> crate::model::OrcSerDe {
            crate::model::OrcSerDe {
                stripe_size_bytes: self.stripe_size_bytes,
                block_size_bytes: self.block_size_bytes,
                row_index_stride: self.row_index_stride,
                enable_padding: self.enable_padding,
                padding_tolerance: self.padding_tolerance,
                compression: self.compression,
                bloom_filter_columns: self.bloom_filter_columns,
                bloom_filter_false_positive_probability: self
                    .bloom_filter_false_positive_probability,
                dictionary_key_threshold: self.dictionary_key_threshold,
                format_version: self.format_version,
            }
        }
    }
}
impl OrcSerDe {
    /// Creates a new builder-style object to manufacture [`OrcSerDe`](crate::model::OrcSerDe)
    pub fn builder() -> crate::model::orc_ser_de::Builder {
        crate::model::orc_ser_de::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrcFormatVersion {
    #[allow(missing_docs)] // documentation missing in model
    V011,
    #[allow(missing_docs)] // documentation missing in model
    V012,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrcFormatVersion {
    fn from(s: &str) -> Self {
        match s {
            "V0_11" => OrcFormatVersion::V011,
            "V0_12" => OrcFormatVersion::V012,
            other => OrcFormatVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrcFormatVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrcFormatVersion::from(s))
    }
}
impl OrcFormatVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrcFormatVersion::V011 => "V0_11",
            OrcFormatVersion::V012 => "V0_12",
            OrcFormatVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V0_11", "V0_12"]
    }
}
impl AsRef<str> for OrcFormatVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrcCompression {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Snappy,
    #[allow(missing_docs)] // documentation missing in model
    Zlib,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrcCompression {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => OrcCompression::None,
            "SNAPPY" => OrcCompression::Snappy,
            "ZLIB" => OrcCompression::Zlib,
            other => OrcCompression::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrcCompression {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrcCompression::from(s))
    }
}
impl OrcCompression {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrcCompression::None => "NONE",
            OrcCompression::Snappy => "SNAPPY",
            OrcCompression::Zlib => "ZLIB",
            OrcCompression::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SNAPPY", "ZLIB"]
    }
}
impl AsRef<str> for OrcCompression {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A serializer to use for converting data to the Parquet format before storing it in
/// Amazon S3. For more information, see <a href="https://parquet.apache.org/documentation/latest/">Apache Parquet</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParquetSerDe {
    /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
    /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
    /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
    pub block_size_bytes: std::option::Option<i32>,
    /// <p>The Parquet page size. Column chunks are divided into pages. A page is conceptually an
    /// indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and
    /// the default is 1 MiB.</p>
    pub page_size_bytes: std::option::Option<i32>,
    /// <p>The compression code to use over data blocks. The possible values are
    /// <code>UNCOMPRESSED</code>, <code>SNAPPY</code>, and <code>GZIP</code>, with the default
    /// being <code>SNAPPY</code>. Use <code>SNAPPY</code> for higher decompression speed. Use
    /// <code>GZIP</code> if the compression ratio is more important than speed.</p>
    pub compression: std::option::Option<crate::model::ParquetCompression>,
    /// <p>Indicates whether to enable dictionary compression.</p>
    pub enable_dictionary_compression: std::option::Option<bool>,
    /// <p>The maximum amount of padding to apply. This is useful if you intend to copy the data
    /// from Amazon S3 to HDFS before querying. The default is 0.</p>
    pub max_padding_bytes: std::option::Option<i32>,
    /// <p>Indicates the version of row format to output. The possible values are <code>V1</code>
    /// and <code>V2</code>. The default is <code>V1</code>.</p>
    pub writer_version: std::option::Option<crate::model::ParquetWriterVersion>,
}
impl ParquetSerDe {
    /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
    /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
    /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
    pub fn block_size_bytes(&self) -> std::option::Option<i32> {
        self.block_size_bytes
    }
    /// <p>The Parquet page size. Column chunks are divided into pages. A page is conceptually an
    /// indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and
    /// the default is 1 MiB.</p>
    pub fn page_size_bytes(&self) -> std::option::Option<i32> {
        self.page_size_bytes
    }
    /// <p>The compression code to use over data blocks. The possible values are
    /// <code>UNCOMPRESSED</code>, <code>SNAPPY</code>, and <code>GZIP</code>, with the default
    /// being <code>SNAPPY</code>. Use <code>SNAPPY</code> for higher decompression speed. Use
    /// <code>GZIP</code> if the compression ratio is more important than speed.</p>
    pub fn compression(&self) -> std::option::Option<&crate::model::ParquetCompression> {
        self.compression.as_ref()
    }
    /// <p>Indicates whether to enable dictionary compression.</p>
    pub fn enable_dictionary_compression(&self) -> std::option::Option<bool> {
        self.enable_dictionary_compression
    }
    /// <p>The maximum amount of padding to apply. This is useful if you intend to copy the data
    /// from Amazon S3 to HDFS before querying. The default is 0.</p>
    pub fn max_padding_bytes(&self) -> std::option::Option<i32> {
        self.max_padding_bytes
    }
    /// <p>Indicates the version of row format to output. The possible values are <code>V1</code>
    /// and <code>V2</code>. The default is <code>V1</code>.</p>
    pub fn writer_version(&self) -> std::option::Option<&crate::model::ParquetWriterVersion> {
        self.writer_version.as_ref()
    }
}
impl std::fmt::Debug for ParquetSerDe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParquetSerDe");
        formatter.field("block_size_bytes", &self.block_size_bytes);
        formatter.field("page_size_bytes", &self.page_size_bytes);
        formatter.field("compression", &self.compression);
        formatter.field(
            "enable_dictionary_compression",
            &self.enable_dictionary_compression,
        );
        formatter.field("max_padding_bytes", &self.max_padding_bytes);
        formatter.field("writer_version", &self.writer_version);
        formatter.finish()
    }
}
/// See [`ParquetSerDe`](crate::model::ParquetSerDe)
pub mod parquet_ser_de {
    /// A builder for [`ParquetSerDe`](crate::model::ParquetSerDe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_size_bytes: std::option::Option<i32>,
        pub(crate) page_size_bytes: std::option::Option<i32>,
        pub(crate) compression: std::option::Option<crate::model::ParquetCompression>,
        pub(crate) enable_dictionary_compression: std::option::Option<bool>,
        pub(crate) max_padding_bytes: std::option::Option<i32>,
        pub(crate) writer_version: std::option::Option<crate::model::ParquetWriterVersion>,
    }
    impl Builder {
        /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
        /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
        /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
        pub fn block_size_bytes(mut self, input: i32) -> Self {
            self.block_size_bytes = Some(input);
            self
        }
        /// <p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to
        /// copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the
        /// minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>
        pub fn set_block_size_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.block_size_bytes = input;
            self
        }
        /// <p>The Parquet page size. Column chunks are divided into pages. A page is conceptually an
        /// indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and
        /// the default is 1 MiB.</p>
        pub fn page_size_bytes(mut self, input: i32) -> Self {
            self.page_size_bytes = Some(input);
            self
        }
        /// <p>The Parquet page size. Column chunks are divided into pages. A page is conceptually an
        /// indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and
        /// the default is 1 MiB.</p>
        pub fn set_page_size_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size_bytes = input;
            self
        }
        /// <p>The compression code to use over data blocks. The possible values are
        /// <code>UNCOMPRESSED</code>, <code>SNAPPY</code>, and <code>GZIP</code>, with the default
        /// being <code>SNAPPY</code>. Use <code>SNAPPY</code> for higher decompression speed. Use
        /// <code>GZIP</code> if the compression ratio is more important than speed.</p>
        pub fn compression(mut self, input: crate::model::ParquetCompression) -> Self {
            self.compression = Some(input);
            self
        }
        /// <p>The compression code to use over data blocks. The possible values are
        /// <code>UNCOMPRESSED</code>, <code>SNAPPY</code>, and <code>GZIP</code>, with the default
        /// being <code>SNAPPY</code>. Use <code>SNAPPY</code> for higher decompression speed. Use
        /// <code>GZIP</code> if the compression ratio is more important than speed.</p>
        pub fn set_compression(
            mut self,
            input: std::option::Option<crate::model::ParquetCompression>,
        ) -> Self {
            self.compression = input;
            self
        }
        /// <p>Indicates whether to enable dictionary compression.</p>
        pub fn enable_dictionary_compression(mut self, input: bool) -> Self {
            self.enable_dictionary_compression = Some(input);
            self
        }
        /// <p>Indicates whether to enable dictionary compression.</p>
        pub fn set_enable_dictionary_compression(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_dictionary_compression = input;
            self
        }
        /// <p>The maximum amount of padding to apply. This is useful if you intend to copy the data
        /// from Amazon S3 to HDFS before querying. The default is 0.</p>
        pub fn max_padding_bytes(mut self, input: i32) -> Self {
            self.max_padding_bytes = Some(input);
            self
        }
        /// <p>The maximum amount of padding to apply. This is useful if you intend to copy the data
        /// from Amazon S3 to HDFS before querying. The default is 0.</p>
        pub fn set_max_padding_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.max_padding_bytes = input;
            self
        }
        /// <p>Indicates the version of row format to output. The possible values are <code>V1</code>
        /// and <code>V2</code>. The default is <code>V1</code>.</p>
        pub fn writer_version(mut self, input: crate::model::ParquetWriterVersion) -> Self {
            self.writer_version = Some(input);
            self
        }
        /// <p>Indicates the version of row format to output. The possible values are <code>V1</code>
        /// and <code>V2</code>. The default is <code>V1</code>.</p>
        pub fn set_writer_version(
            mut self,
            input: std::option::Option<crate::model::ParquetWriterVersion>,
        ) -> Self {
            self.writer_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ParquetSerDe`](crate::model::ParquetSerDe)
        pub fn build(self) -> crate::model::ParquetSerDe {
            crate::model::ParquetSerDe {
                block_size_bytes: self.block_size_bytes,
                page_size_bytes: self.page_size_bytes,
                compression: self.compression,
                enable_dictionary_compression: self.enable_dictionary_compression,
                max_padding_bytes: self.max_padding_bytes,
                writer_version: self.writer_version,
            }
        }
    }
}
impl ParquetSerDe {
    /// Creates a new builder-style object to manufacture [`ParquetSerDe`](crate::model::ParquetSerDe)
    pub fn builder() -> crate::model::parquet_ser_de::Builder {
        crate::model::parquet_ser_de::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParquetWriterVersion {
    #[allow(missing_docs)] // documentation missing in model
    V1,
    #[allow(missing_docs)] // documentation missing in model
    V2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParquetWriterVersion {
    fn from(s: &str) -> Self {
        match s {
            "V1" => ParquetWriterVersion::V1,
            "V2" => ParquetWriterVersion::V2,
            other => ParquetWriterVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParquetWriterVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParquetWriterVersion::from(s))
    }
}
impl ParquetWriterVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParquetWriterVersion::V1 => "V1",
            ParquetWriterVersion::V2 => "V2",
            ParquetWriterVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V1", "V2"]
    }
}
impl AsRef<str> for ParquetWriterVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParquetCompression {
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    Snappy,
    #[allow(missing_docs)] // documentation missing in model
    Uncompressed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParquetCompression {
    fn from(s: &str) -> Self {
        match s {
            "GZIP" => ParquetCompression::Gzip,
            "SNAPPY" => ParquetCompression::Snappy,
            "UNCOMPRESSED" => ParquetCompression::Uncompressed,
            other => ParquetCompression::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParquetCompression {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParquetCompression::from(s))
    }
}
impl ParquetCompression {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParquetCompression::Gzip => "GZIP",
            ParquetCompression::Snappy => "SNAPPY",
            ParquetCompression::Uncompressed => "UNCOMPRESSED",
            ParquetCompression::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GZIP", "SNAPPY", "UNCOMPRESSED"]
    }
}
impl AsRef<str> for ParquetCompression {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the deserializer you want to use to convert the format of the input data.
/// This parameter is required if <code>Enabled</code> is set to true.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputFormatConfiguration {
    /// <p>Specifies which deserializer to use. You can choose either the Apache Hive JSON SerDe
    /// or the OpenX JSON SerDe. If both are non-null, the server rejects the request.</p>
    pub deserializer: std::option::Option<crate::model::Deserializer>,
}
impl InputFormatConfiguration {
    /// <p>Specifies which deserializer to use. You can choose either the Apache Hive JSON SerDe
    /// or the OpenX JSON SerDe. If both are non-null, the server rejects the request.</p>
    pub fn deserializer(&self) -> std::option::Option<&crate::model::Deserializer> {
        self.deserializer.as_ref()
    }
}
impl std::fmt::Debug for InputFormatConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputFormatConfiguration");
        formatter.field("deserializer", &self.deserializer);
        formatter.finish()
    }
}
/// See [`InputFormatConfiguration`](crate::model::InputFormatConfiguration)
pub mod input_format_configuration {
    /// A builder for [`InputFormatConfiguration`](crate::model::InputFormatConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deserializer: std::option::Option<crate::model::Deserializer>,
    }
    impl Builder {
        /// <p>Specifies which deserializer to use. You can choose either the Apache Hive JSON SerDe
        /// or the OpenX JSON SerDe. If both are non-null, the server rejects the request.</p>
        pub fn deserializer(mut self, input: crate::model::Deserializer) -> Self {
            self.deserializer = Some(input);
            self
        }
        /// <p>Specifies which deserializer to use. You can choose either the Apache Hive JSON SerDe
        /// or the OpenX JSON SerDe. If both are non-null, the server rejects the request.</p>
        pub fn set_deserializer(
            mut self,
            input: std::option::Option<crate::model::Deserializer>,
        ) -> Self {
            self.deserializer = input;
            self
        }
        /// Consumes the builder and constructs a [`InputFormatConfiguration`](crate::model::InputFormatConfiguration)
        pub fn build(self) -> crate::model::InputFormatConfiguration {
            crate::model::InputFormatConfiguration {
                deserializer: self.deserializer,
            }
        }
    }
}
impl InputFormatConfiguration {
    /// Creates a new builder-style object to manufacture [`InputFormatConfiguration`](crate::model::InputFormatConfiguration)
    pub fn builder() -> crate::model::input_format_configuration::Builder {
        crate::model::input_format_configuration::Builder::default()
    }
}

/// <p>The deserializer you want Kinesis Data Firehose to use for converting the input data
/// from JSON. Kinesis Data Firehose then serializes the data to its final format using the
/// <a>Serializer</a>. Kinesis Data Firehose supports two types of deserializers:
/// the <a href="https://cwiki.apache.org/confluence/display/Hive/LanguageManual+DDL#LanguageManualDDL-JSON">Apache Hive JSON SerDe</a> and the <a href="https://github.com/rcongiu/Hive-JSON-Serde">OpenX JSON SerDe</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deserializer {
    /// <p>The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means
    /// converting it from the JSON format in preparation for serializing it to the Parquet or ORC
    /// format. This is one of two deserializers you can choose, depending on which one offers the
    /// functionality you need. The other option is the native Hive / HCatalog JsonSerDe.</p>
    pub open_x_json_ser_de: std::option::Option<crate::model::OpenXJsonSerDe>,
    /// <p>The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing
    /// data, which means converting it from the JSON format in preparation for serializing it to
    /// the Parquet or ORC format. This is one of two deserializers you can choose, depending on
    /// which one offers the functionality you need. The other option is the OpenX SerDe.</p>
    pub hive_json_ser_de: std::option::Option<crate::model::HiveJsonSerDe>,
}
impl Deserializer {
    /// <p>The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means
    /// converting it from the JSON format in preparation for serializing it to the Parquet or ORC
    /// format. This is one of two deserializers you can choose, depending on which one offers the
    /// functionality you need. The other option is the native Hive / HCatalog JsonSerDe.</p>
    pub fn open_x_json_ser_de(&self) -> std::option::Option<&crate::model::OpenXJsonSerDe> {
        self.open_x_json_ser_de.as_ref()
    }
    /// <p>The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing
    /// data, which means converting it from the JSON format in preparation for serializing it to
    /// the Parquet or ORC format. This is one of two deserializers you can choose, depending on
    /// which one offers the functionality you need. The other option is the OpenX SerDe.</p>
    pub fn hive_json_ser_de(&self) -> std::option::Option<&crate::model::HiveJsonSerDe> {
        self.hive_json_ser_de.as_ref()
    }
}
impl std::fmt::Debug for Deserializer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deserializer");
        formatter.field("open_x_json_ser_de", &self.open_x_json_ser_de);
        formatter.field("hive_json_ser_de", &self.hive_json_ser_de);
        formatter.finish()
    }
}
/// See [`Deserializer`](crate::model::Deserializer)
pub mod deserializer {
    /// A builder for [`Deserializer`](crate::model::Deserializer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_x_json_ser_de: std::option::Option<crate::model::OpenXJsonSerDe>,
        pub(crate) hive_json_ser_de: std::option::Option<crate::model::HiveJsonSerDe>,
    }
    impl Builder {
        /// <p>The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means
        /// converting it from the JSON format in preparation for serializing it to the Parquet or ORC
        /// format. This is one of two deserializers you can choose, depending on which one offers the
        /// functionality you need. The other option is the native Hive / HCatalog JsonSerDe.</p>
        pub fn open_x_json_ser_de(mut self, input: crate::model::OpenXJsonSerDe) -> Self {
            self.open_x_json_ser_de = Some(input);
            self
        }
        /// <p>The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means
        /// converting it from the JSON format in preparation for serializing it to the Parquet or ORC
        /// format. This is one of two deserializers you can choose, depending on which one offers the
        /// functionality you need. The other option is the native Hive / HCatalog JsonSerDe.</p>
        pub fn set_open_x_json_ser_de(
            mut self,
            input: std::option::Option<crate::model::OpenXJsonSerDe>,
        ) -> Self {
            self.open_x_json_ser_de = input;
            self
        }
        /// <p>The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing
        /// data, which means converting it from the JSON format in preparation for serializing it to
        /// the Parquet or ORC format. This is one of two deserializers you can choose, depending on
        /// which one offers the functionality you need. The other option is the OpenX SerDe.</p>
        pub fn hive_json_ser_de(mut self, input: crate::model::HiveJsonSerDe) -> Self {
            self.hive_json_ser_de = Some(input);
            self
        }
        /// <p>The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing
        /// data, which means converting it from the JSON format in preparation for serializing it to
        /// the Parquet or ORC format. This is one of two deserializers you can choose, depending on
        /// which one offers the functionality you need. The other option is the OpenX SerDe.</p>
        pub fn set_hive_json_ser_de(
            mut self,
            input: std::option::Option<crate::model::HiveJsonSerDe>,
        ) -> Self {
            self.hive_json_ser_de = input;
            self
        }
        /// Consumes the builder and constructs a [`Deserializer`](crate::model::Deserializer)
        pub fn build(self) -> crate::model::Deserializer {
            crate::model::Deserializer {
                open_x_json_ser_de: self.open_x_json_ser_de,
                hive_json_ser_de: self.hive_json_ser_de,
            }
        }
    }
}
impl Deserializer {
    /// Creates a new builder-style object to manufacture [`Deserializer`](crate::model::Deserializer)
    pub fn builder() -> crate::model::deserializer::Builder {
        crate::model::deserializer::Builder::default()
    }
}

/// <p>The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing
/// data, which means converting it from the JSON format in preparation for serializing it to
/// the Parquet or ORC format. This is one of two deserializers you can choose, depending on
/// which one offers the functionality you need. The other option is the OpenX SerDe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HiveJsonSerDe {
    /// <p>Indicates how you want Kinesis Data Firehose to parse the date and timestamps that
    /// may be present in your input data JSON. To specify these format strings, follow the pattern
    /// syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a>. You can also use the special value <code>millis</code> to
    /// parse timestamps in epoch milliseconds. If you don't specify a format, Kinesis Data
    /// Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.</p>
    pub timestamp_formats: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl HiveJsonSerDe {
    /// <p>Indicates how you want Kinesis Data Firehose to parse the date and timestamps that
    /// may be present in your input data JSON. To specify these format strings, follow the pattern
    /// syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a>. You can also use the special value <code>millis</code> to
    /// parse timestamps in epoch milliseconds. If you don't specify a format, Kinesis Data
    /// Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.</p>
    pub fn timestamp_formats(&self) -> std::option::Option<&[std::string::String]> {
        self.timestamp_formats.as_deref()
    }
}
impl std::fmt::Debug for HiveJsonSerDe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HiveJsonSerDe");
        formatter.field("timestamp_formats", &self.timestamp_formats);
        formatter.finish()
    }
}
/// See [`HiveJsonSerDe`](crate::model::HiveJsonSerDe)
pub mod hive_json_ser_de {
    /// A builder for [`HiveJsonSerDe`](crate::model::HiveJsonSerDe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp_formats: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `timestamp_formats`.
        ///
        /// To override the contents of this collection use [`set_timestamp_formats`](Self::set_timestamp_formats).
        ///
        /// <p>Indicates how you want Kinesis Data Firehose to parse the date and timestamps that
        /// may be present in your input data JSON. To specify these format strings, follow the pattern
        /// syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a>. You can also use the special value <code>millis</code> to
        /// parse timestamps in epoch milliseconds. If you don't specify a format, Kinesis Data
        /// Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.</p>
        pub fn timestamp_formats(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.timestamp_formats.unwrap_or_default();
            v.push(input.into());
            self.timestamp_formats = Some(v);
            self
        }
        /// <p>Indicates how you want Kinesis Data Firehose to parse the date and timestamps that
        /// may be present in your input data JSON. To specify these format strings, follow the pattern
        /// syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a>. You can also use the special value <code>millis</code> to
        /// parse timestamps in epoch milliseconds. If you don't specify a format, Kinesis Data
        /// Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.</p>
        pub fn set_timestamp_formats(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.timestamp_formats = input;
            self
        }
        /// Consumes the builder and constructs a [`HiveJsonSerDe`](crate::model::HiveJsonSerDe)
        pub fn build(self) -> crate::model::HiveJsonSerDe {
            crate::model::HiveJsonSerDe {
                timestamp_formats: self.timestamp_formats,
            }
        }
    }
}
impl HiveJsonSerDe {
    /// Creates a new builder-style object to manufacture [`HiveJsonSerDe`](crate::model::HiveJsonSerDe)
    pub fn builder() -> crate::model::hive_json_ser_de::Builder {
        crate::model::hive_json_ser_de::Builder::default()
    }
}

/// <p>The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means
/// converting it from the JSON format in preparation for serializing it to the Parquet or ORC
/// format. This is one of two deserializers you can choose, depending on which one offers the
/// functionality you need. The other option is the native Hive / HCatalog JsonSerDe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpenXJsonSerDe {
    /// <p>When set to <code>true</code>, specifies that the names of the keys include dots and
    /// that you want Kinesis Data Firehose to replace them with underscores. This is useful
    /// because Apache Hive does not allow dots in column names. For example, if the JSON contains
    /// a key whose name is "a.b", you can define the column name to be "a_b" when using this
    /// option.</p>
    /// <p>The default is <code>false</code>.</p>
    pub convert_dots_in_json_keys_to_underscores: std::option::Option<bool>,
    /// <p>When set to <code>true</code>, which is the default, Kinesis Data Firehose converts
    /// JSON keys to lowercase before deserializing them.</p>
    pub case_insensitive: std::option::Option<bool>,
    /// <p>Maps column names to JSON keys that aren't identical to the column names. This is
    /// useful when the JSON contains keys that are Hive keywords. For example,
    /// <code>timestamp</code> is a Hive keyword. If you have a JSON key named
    /// <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map
    /// this key to a column named <code>ts</code>.</p>
    pub column_to_json_key_mappings:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl OpenXJsonSerDe {
    /// <p>When set to <code>true</code>, specifies that the names of the keys include dots and
    /// that you want Kinesis Data Firehose to replace them with underscores. This is useful
    /// because Apache Hive does not allow dots in column names. For example, if the JSON contains
    /// a key whose name is "a.b", you can define the column name to be "a_b" when using this
    /// option.</p>
    /// <p>The default is <code>false</code>.</p>
    pub fn convert_dots_in_json_keys_to_underscores(&self) -> std::option::Option<bool> {
        self.convert_dots_in_json_keys_to_underscores
    }
    /// <p>When set to <code>true</code>, which is the default, Kinesis Data Firehose converts
    /// JSON keys to lowercase before deserializing them.</p>
    pub fn case_insensitive(&self) -> std::option::Option<bool> {
        self.case_insensitive
    }
    /// <p>Maps column names to JSON keys that aren't identical to the column names. This is
    /// useful when the JSON contains keys that are Hive keywords. For example,
    /// <code>timestamp</code> is a Hive keyword. If you have a JSON key named
    /// <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map
    /// this key to a column named <code>ts</code>.</p>
    pub fn column_to_json_key_mappings(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.column_to_json_key_mappings.as_ref()
    }
}
impl std::fmt::Debug for OpenXJsonSerDe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpenXJsonSerDe");
        formatter.field(
            "convert_dots_in_json_keys_to_underscores",
            &self.convert_dots_in_json_keys_to_underscores,
        );
        formatter.field("case_insensitive", &self.case_insensitive);
        formatter.field(
            "column_to_json_key_mappings",
            &self.column_to_json_key_mappings,
        );
        formatter.finish()
    }
}
/// See [`OpenXJsonSerDe`](crate::model::OpenXJsonSerDe)
pub mod open_x_json_ser_de {
    /// A builder for [`OpenXJsonSerDe`](crate::model::OpenXJsonSerDe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) convert_dots_in_json_keys_to_underscores: std::option::Option<bool>,
        pub(crate) case_insensitive: std::option::Option<bool>,
        pub(crate) column_to_json_key_mappings: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>When set to <code>true</code>, specifies that the names of the keys include dots and
        /// that you want Kinesis Data Firehose to replace them with underscores. This is useful
        /// because Apache Hive does not allow dots in column names. For example, if the JSON contains
        /// a key whose name is "a.b", you can define the column name to be "a_b" when using this
        /// option.</p>
        /// <p>The default is <code>false</code>.</p>
        pub fn convert_dots_in_json_keys_to_underscores(mut self, input: bool) -> Self {
            self.convert_dots_in_json_keys_to_underscores = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, specifies that the names of the keys include dots and
        /// that you want Kinesis Data Firehose to replace them with underscores. This is useful
        /// because Apache Hive does not allow dots in column names. For example, if the JSON contains
        /// a key whose name is "a.b", you can define the column name to be "a_b" when using this
        /// option.</p>
        /// <p>The default is <code>false</code>.</p>
        pub fn set_convert_dots_in_json_keys_to_underscores(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.convert_dots_in_json_keys_to_underscores = input;
            self
        }
        /// <p>When set to <code>true</code>, which is the default, Kinesis Data Firehose converts
        /// JSON keys to lowercase before deserializing them.</p>
        pub fn case_insensitive(mut self, input: bool) -> Self {
            self.case_insensitive = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, which is the default, Kinesis Data Firehose converts
        /// JSON keys to lowercase before deserializing them.</p>
        pub fn set_case_insensitive(mut self, input: std::option::Option<bool>) -> Self {
            self.case_insensitive = input;
            self
        }
        /// Adds a key-value pair to `column_to_json_key_mappings`.
        ///
        /// To override the contents of this collection use [`set_column_to_json_key_mappings`](Self::set_column_to_json_key_mappings).
        ///
        /// <p>Maps column names to JSON keys that aren't identical to the column names. This is
        /// useful when the JSON contains keys that are Hive keywords. For example,
        /// <code>timestamp</code> is a Hive keyword. If you have a JSON key named
        /// <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map
        /// this key to a column named <code>ts</code>.</p>
        pub fn column_to_json_key_mappings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.column_to_json_key_mappings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.column_to_json_key_mappings = Some(hash_map);
            self
        }
        /// <p>Maps column names to JSON keys that aren't identical to the column names. This is
        /// useful when the JSON contains keys that are Hive keywords. For example,
        /// <code>timestamp</code> is a Hive keyword. If you have a JSON key named
        /// <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map
        /// this key to a column named <code>ts</code>.</p>
        pub fn set_column_to_json_key_mappings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.column_to_json_key_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`OpenXJsonSerDe`](crate::model::OpenXJsonSerDe)
        pub fn build(self) -> crate::model::OpenXJsonSerDe {
            crate::model::OpenXJsonSerDe {
                convert_dots_in_json_keys_to_underscores: self
                    .convert_dots_in_json_keys_to_underscores,
                case_insensitive: self.case_insensitive,
                column_to_json_key_mappings: self.column_to_json_key_mappings,
            }
        }
    }
}
impl OpenXJsonSerDe {
    /// Creates a new builder-style object to manufacture [`OpenXJsonSerDe`](crate::model::OpenXJsonSerDe)
    pub fn builder() -> crate::model::open_x_json_ser_de::Builder {
        crate::model::open_x_json_ser_de::Builder::default()
    }
}

/// <p>Specifies the schema to which you want Kinesis Data Firehose to configure your data
/// before it writes it to Amazon S3. This parameter is required if <code>Enabled</code> is set
/// to true.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaConfiguration {
    /// <p>The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in
    /// the same account you use for Kinesis Data Firehose. Cross-account roles aren't
    /// allowed.</p>
    /// <important>
    /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
    /// the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is
    /// required and its value must be specified.</p>
    /// </important>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is
    /// used by default.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the AWS Glue database that contains the schema for the output
    /// data.</p>
    /// <important>
    /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
    /// the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property
    /// is required and its value must be specified.</p>
    /// </important>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Specifies the AWS Glue table that contains the column information that constitutes your
    /// data schema.</p>
    /// <important>
    /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
    /// the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is
    /// required and its value must be specified.</p>
    /// </important>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>If you don't specify an AWS Region, the default is the current Region.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Specifies the table version for the output data schema. If you don't specify this
    /// version ID, or if you set it to <code>LATEST</code>, Kinesis Data Firehose uses the most
    /// recent version. This means that any updates to the table are automatically picked
    /// up.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl SchemaConfiguration {
    /// <p>The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in
    /// the same account you use for Kinesis Data Firehose. Cross-account roles aren't
    /// allowed.</p>
    /// <important>
    /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
    /// the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is
    /// required and its value must be specified.</p>
    /// </important>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is
    /// used by default.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>Specifies the name of the AWS Glue database that contains the schema for the output
    /// data.</p>
    /// <important>
    /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
    /// the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property
    /// is required and its value must be specified.</p>
    /// </important>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Specifies the AWS Glue table that contains the column information that constitutes your
    /// data schema.</p>
    /// <important>
    /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
    /// the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is
    /// required and its value must be specified.</p>
    /// </important>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>If you don't specify an AWS Region, the default is the current Region.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>Specifies the table version for the output data schema. If you don't specify this
    /// version ID, or if you set it to <code>LATEST</code>, Kinesis Data Firehose uses the most
    /// recent version. This means that any updates to the table are automatically picked
    /// up.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for SchemaConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("region", &self.region);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`SchemaConfiguration`](crate::model::SchemaConfiguration)
pub mod schema_configuration {
    /// A builder for [`SchemaConfiguration`](crate::model::SchemaConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in
        /// the same account you use for Kinesis Data Firehose. Cross-account roles aren't
        /// allowed.</p>
        /// <important>
        /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
        /// the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is
        /// required and its value must be specified.</p>
        /// </important>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in
        /// the same account you use for Kinesis Data Firehose. Cross-account roles aren't
        /// allowed.</p>
        /// <important>
        /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
        /// the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is
        /// required and its value must be specified.</p>
        /// </important>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is
        /// used by default.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is
        /// used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>Specifies the name of the AWS Glue database that contains the schema for the output
        /// data.</p>
        /// <important>
        /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
        /// the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property
        /// is required and its value must be specified.</p>
        /// </important>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the AWS Glue database that contains the schema for the output
        /// data.</p>
        /// <important>
        /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
        /// the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property
        /// is required and its value must be specified.</p>
        /// </important>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Specifies the AWS Glue table that contains the column information that constitutes your
        /// data schema.</p>
        /// <important>
        /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
        /// the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is
        /// required and its value must be specified.</p>
        /// </important>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Specifies the AWS Glue table that contains the column information that constitutes your
        /// data schema.</p>
        /// <important>
        /// <p>If the <code>SchemaConfiguration</code> request parameter is used as part of invoking
        /// the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is
        /// required and its value must be specified.</p>
        /// </important>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>If you don't specify an AWS Region, the default is the current Region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>If you don't specify an AWS Region, the default is the current Region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Specifies the table version for the output data schema. If you don't specify this
        /// version ID, or if you set it to <code>LATEST</code>, Kinesis Data Firehose uses the most
        /// recent version. This means that any updates to the table are automatically picked
        /// up.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Specifies the table version for the output data schema. If you don't specify this
        /// version ID, or if you set it to <code>LATEST</code>, Kinesis Data Firehose uses the most
        /// recent version. This means that any updates to the table are automatically picked
        /// up.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaConfiguration`](crate::model::SchemaConfiguration)
        pub fn build(self) -> crate::model::SchemaConfiguration {
            crate::model::SchemaConfiguration {
                role_arn: self.role_arn,
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                region: self.region,
                version_id: self.version_id,
            }
        }
    }
}
impl SchemaConfiguration {
    /// Creates a new builder-style object to manufacture [`SchemaConfiguration`](crate::model::SchemaConfiguration)
    pub fn builder() -> crate::model::schema_configuration::Builder {
        crate::model::schema_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3BackupMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3BackupMode {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => S3BackupMode::Disabled,
            "Enabled" => S3BackupMode::Enabled,
            other => S3BackupMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3BackupMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3BackupMode::from(s))
    }
}
impl S3BackupMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3BackupMode::Disabled => "Disabled",
            S3BackupMode::Enabled => "Enabled",
            S3BackupMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for S3BackupMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata that you can assign to a delivery stream, consisting of a key-value
/// pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
    /// Unicode letters, digits, white space, _ . / = + - % @</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>An optional string, which you can use to describe or define the tag. Maximum length:
    /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
    /// @</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
    /// Unicode letters, digits, white space, _ . / = + - % @</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>An optional string, which you can use to describe or define the tag. Maximum length:
    /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
    /// @</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
        /// Unicode letters, digits, white space, _ . / = + - % @</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
        /// Unicode letters, digits, white space, _ . / = + - % @</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>An optional string, which you can use to describe or define the tag. Maximum length:
        /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
        /// @</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>An optional string, which you can use to describe or define the tag. Maximum length:
        /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
        /// @</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side
/// Encryption (SSE). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliveryStreamEncryptionConfigurationInput {
    /// <p>If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify
    /// the Amazon Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to
    /// <code>AWS_OWNED_CMK</code>, Kinesis Data Firehose uses a service-account CMK.</p>
    pub key_arn: std::option::Option<std::string::String>,
    /// <p>Indicates the type of customer master key (CMK) to use for encryption. The default
    /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
    /// Master Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or
    /// <a>StartDeliveryStreamEncryption</a> with <code>KeyType</code> set to
    /// CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant that allows the Kinesis Data Firehose service to
    /// use the customer managed CMK to perform encryption and decryption. Kinesis Data Firehose
    /// manages that grant. </p>
    /// <p>When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a
    /// delivery stream that is encrypted with a customer managed CMK, Kinesis Data Firehose
    /// schedules the grant it had on the old CMK for retirement.</p>
    /// <p>You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If
    /// a <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
    /// operation exceeds this limit, Kinesis Data Firehose throws a
    /// <code>LimitExceededException</code>. </p>
    /// <important>
    /// <p>To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't
    /// support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About
    /// Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer
    /// guide.</p>
    /// </important>
    pub key_type: std::option::Option<crate::model::KeyType>,
}
impl DeliveryStreamEncryptionConfigurationInput {
    /// <p>If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify
    /// the Amazon Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to
    /// <code>AWS_OWNED_CMK</code>, Kinesis Data Firehose uses a service-account CMK.</p>
    pub fn key_arn(&self) -> std::option::Option<&str> {
        self.key_arn.as_deref()
    }
    /// <p>Indicates the type of customer master key (CMK) to use for encryption. The default
    /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
    /// Master Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or
    /// <a>StartDeliveryStreamEncryption</a> with <code>KeyType</code> set to
    /// CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant that allows the Kinesis Data Firehose service to
    /// use the customer managed CMK to perform encryption and decryption. Kinesis Data Firehose
    /// manages that grant. </p>
    /// <p>When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a
    /// delivery stream that is encrypted with a customer managed CMK, Kinesis Data Firehose
    /// schedules the grant it had on the old CMK for retirement.</p>
    /// <p>You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If
    /// a <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
    /// operation exceeds this limit, Kinesis Data Firehose throws a
    /// <code>LimitExceededException</code>. </p>
    /// <important>
    /// <p>To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't
    /// support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About
    /// Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer
    /// guide.</p>
    /// </important>
    pub fn key_type(&self) -> std::option::Option<&crate::model::KeyType> {
        self.key_type.as_ref()
    }
}
impl std::fmt::Debug for DeliveryStreamEncryptionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliveryStreamEncryptionConfigurationInput");
        formatter.field("key_arn", &self.key_arn);
        formatter.field("key_type", &self.key_type);
        formatter.finish()
    }
}
/// See [`DeliveryStreamEncryptionConfigurationInput`](crate::model::DeliveryStreamEncryptionConfigurationInput)
pub mod delivery_stream_encryption_configuration_input {
    /// A builder for [`DeliveryStreamEncryptionConfigurationInput`](crate::model::DeliveryStreamEncryptionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_arn: std::option::Option<std::string::String>,
        pub(crate) key_type: std::option::Option<crate::model::KeyType>,
    }
    impl Builder {
        /// <p>If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify
        /// the Amazon Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to
        /// <code>AWS_OWNED_CMK</code>, Kinesis Data Firehose uses a service-account CMK.</p>
        pub fn key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_arn = Some(input.into());
            self
        }
        /// <p>If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify
        /// the Amazon Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to
        /// <code>AWS_OWNED_CMK</code>, Kinesis Data Firehose uses a service-account CMK.</p>
        pub fn set_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_arn = input;
            self
        }
        /// <p>Indicates the type of customer master key (CMK) to use for encryption. The default
        /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
        /// Master Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or
        /// <a>StartDeliveryStreamEncryption</a> with <code>KeyType</code> set to
        /// CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant that allows the Kinesis Data Firehose service to
        /// use the customer managed CMK to perform encryption and decryption. Kinesis Data Firehose
        /// manages that grant. </p>
        /// <p>When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a
        /// delivery stream that is encrypted with a customer managed CMK, Kinesis Data Firehose
        /// schedules the grant it had on the old CMK for retirement.</p>
        /// <p>You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If
        /// a <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
        /// operation exceeds this limit, Kinesis Data Firehose throws a
        /// <code>LimitExceededException</code>. </p>
        /// <important>
        /// <p>To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't
        /// support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About
        /// Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer
        /// guide.</p>
        /// </important>
        pub fn key_type(mut self, input: crate::model::KeyType) -> Self {
            self.key_type = Some(input);
            self
        }
        /// <p>Indicates the type of customer master key (CMK) to use for encryption. The default
        /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
        /// Master Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or
        /// <a>StartDeliveryStreamEncryption</a> with <code>KeyType</code> set to
        /// CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant that allows the Kinesis Data Firehose service to
        /// use the customer managed CMK to perform encryption and decryption. Kinesis Data Firehose
        /// manages that grant. </p>
        /// <p>When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a
        /// delivery stream that is encrypted with a customer managed CMK, Kinesis Data Firehose
        /// schedules the grant it had on the old CMK for retirement.</p>
        /// <p>You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If
        /// a <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
        /// operation exceeds this limit, Kinesis Data Firehose throws a
        /// <code>LimitExceededException</code>. </p>
        /// <important>
        /// <p>To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't
        /// support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About
        /// Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer
        /// guide.</p>
        /// </important>
        pub fn set_key_type(mut self, input: std::option::Option<crate::model::KeyType>) -> Self {
            self.key_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliveryStreamEncryptionConfigurationInput`](crate::model::DeliveryStreamEncryptionConfigurationInput)
        pub fn build(self) -> crate::model::DeliveryStreamEncryptionConfigurationInput {
            crate::model::DeliveryStreamEncryptionConfigurationInput {
                key_arn: self.key_arn,
                key_type: self.key_type,
            }
        }
    }
}
impl DeliveryStreamEncryptionConfigurationInput {
    /// Creates a new builder-style object to manufacture [`DeliveryStreamEncryptionConfigurationInput`](crate::model::DeliveryStreamEncryptionConfigurationInput)
    pub fn builder() -> crate::model::delivery_stream_encryption_configuration_input::Builder {
        crate::model::delivery_stream_encryption_configuration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyType {
    #[allow(missing_docs)] // documentation missing in model
    AwsOwnedCmk,
    #[allow(missing_docs)] // documentation missing in model
    CustomerManagedCmk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_OWNED_CMK" => KeyType::AwsOwnedCmk,
            "CUSTOMER_MANAGED_CMK" => KeyType::CustomerManagedCmk,
            other => KeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyType::from(s))
    }
}
impl KeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyType::AwsOwnedCmk => "AWS_OWNED_CMK",
            KeyType::CustomerManagedCmk => "CUSTOMER_MANAGED_CMK",
            KeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_OWNED_CMK", "CUSTOMER_MANAGED_CMK"]
    }
}
impl AsRef<str> for KeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the result for an individual record from a <a>PutRecordBatch</a>
/// request. If the record is successfully added to your delivery stream, it receives a record
/// ID. If the record fails to be added to your delivery stream, the result includes an error
/// code and an error message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecordBatchResponseEntry {
    /// <p>The ID of the record.</p>
    pub record_id: std::option::Option<std::string::String>,
    /// <p>The error code for an individual record result.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message for an individual record result.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl PutRecordBatchResponseEntry {
    /// <p>The ID of the record.</p>
    pub fn record_id(&self) -> std::option::Option<&str> {
        self.record_id.as_deref()
    }
    /// <p>The error code for an individual record result.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message for an individual record result.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for PutRecordBatchResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecordBatchResponseEntry");
        formatter.field("record_id", &self.record_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PutRecordBatchResponseEntry`](crate::model::PutRecordBatchResponseEntry)
pub mod put_record_batch_response_entry {
    /// A builder for [`PutRecordBatchResponseEntry`](crate::model::PutRecordBatchResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the record.</p>
        pub fn record_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_id = Some(input.into());
            self
        }
        /// <p>The ID of the record.</p>
        pub fn set_record_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.record_id = input;
            self
        }
        /// <p>The error code for an individual record result.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code for an individual record result.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message for an individual record result.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message for an individual record result.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecordBatchResponseEntry`](crate::model::PutRecordBatchResponseEntry)
        pub fn build(self) -> crate::model::PutRecordBatchResponseEntry {
            crate::model::PutRecordBatchResponseEntry {
                record_id: self.record_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PutRecordBatchResponseEntry {
    /// Creates a new builder-style object to manufacture [`PutRecordBatchResponseEntry`](crate::model::PutRecordBatchResponseEntry)
    pub fn builder() -> crate::model::put_record_batch_response_entry::Builder {
        crate::model::put_record_batch_response_entry::Builder::default()
    }
}

/// <p>The unit of data in a delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Record {
    /// <p>The data blob, which is base64-encoded when the blob is serialized. The maximum size
    /// of the data blob, before base64-encoding, is 1,000 KiB.</p>
    pub data: std::option::Option<aws_smithy_types::Blob>,
}
impl Record {
    /// <p>The data blob, which is base64-encoded when the blob is serialized. The maximum size
    /// of the data blob, before base64-encoding, is 1,000 KiB.</p>
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
}
impl std::fmt::Debug for Record {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Record");
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`Record`](crate::model::Record)
pub mod record {
    /// A builder for [`Record`](crate::model::Record)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The data blob, which is base64-encoded when the blob is serialized. The maximum size
        /// of the data blob, before base64-encoding, is 1,000 KiB.</p>
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The data blob, which is base64-encoded when the blob is serialized. The maximum size
        /// of the data blob, before base64-encoding, is 1,000 KiB.</p>
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`Record`](crate::model::Record)
        pub fn build(self) -> crate::model::Record {
            crate::model::Record { data: self.data }
        }
    }
}
impl Record {
    /// Creates a new builder-style object to manufacture [`Record`](crate::model::Record)
    pub fn builder() -> crate::model::record::Builder {
        crate::model::record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliveryStreamType {
    #[allow(missing_docs)] // documentation missing in model
    DirectPut,
    #[allow(missing_docs)] // documentation missing in model
    KinesisStreamAsSource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliveryStreamType {
    fn from(s: &str) -> Self {
        match s {
            "DirectPut" => DeliveryStreamType::DirectPut,
            "KinesisStreamAsSource" => DeliveryStreamType::KinesisStreamAsSource,
            other => DeliveryStreamType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliveryStreamType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliveryStreamType::from(s))
    }
}
impl DeliveryStreamType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliveryStreamType::DirectPut => "DirectPut",
            DeliveryStreamType::KinesisStreamAsSource => "KinesisStreamAsSource",
            DeliveryStreamType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DirectPut", "KinesisStreamAsSource"]
    }
}
impl AsRef<str> for DeliveryStreamType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliveryStreamDescription {
    /// <p>The name of the delivery stream.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the delivery stream. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub delivery_stream_arn: std::option::Option<std::string::String>,
    /// <p>The status of the delivery stream. If the status of a delivery stream is
    /// <code>CREATING_FAILED</code>, this status doesn't change, and you can't invoke
    /// <code>CreateDeliveryStream</code> again on it. However, you can invoke the <a>DeleteDeliveryStream</a> operation to delete it.</p>
    pub delivery_stream_status: std::option::Option<crate::model::DeliveryStreamStatus>,
    /// <p>Provides details in case one of the following operations fails due to an error related
    /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
    /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
    pub failure_description: std::option::Option<crate::model::FailureDescription>,
    /// <p>Indicates the server-side encryption (SSE) status for the delivery stream.</p>
    pub delivery_stream_encryption_configuration:
        std::option::Option<crate::model::DeliveryStreamEncryptionConfiguration>,
    /// <p>The delivery stream type. This can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DirectPut</code>: Provider applications access the delivery stream
    /// directly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
    /// stream as a source.</p>
    /// </li>
    /// </ul>
    pub delivery_stream_type: std::option::Option<crate::model::DeliveryStreamType>,
    /// <p>Each time the destination is updated for a delivery stream, the version ID is
    /// changed, and the current version ID is required when updating the destination. This is so
    /// that the service knows it is applying the changes to the correct version of the delivery
    /// stream.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the delivery stream was created.</p>
    pub create_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the delivery stream was last updated.</p>
    pub last_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If the <code>DeliveryStreamType</code> parameter is
    /// <code>KinesisStreamAsSource</code>, a <a>SourceDescription</a> object
    /// describing the source Kinesis data stream.</p>
    pub source: std::option::Option<crate::model::SourceDescription>,
    /// <p>The destinations.</p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::DestinationDescription>>,
    /// <p>Indicates whether there are more destinations available to list.</p>
    pub has_more_destinations: std::option::Option<bool>,
}
impl DeliveryStreamDescription {
    /// <p>The name of the delivery stream.</p>
    pub fn delivery_stream_name(&self) -> std::option::Option<&str> {
        self.delivery_stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the delivery stream. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn delivery_stream_arn(&self) -> std::option::Option<&str> {
        self.delivery_stream_arn.as_deref()
    }
    /// <p>The status of the delivery stream. If the status of a delivery stream is
    /// <code>CREATING_FAILED</code>, this status doesn't change, and you can't invoke
    /// <code>CreateDeliveryStream</code> again on it. However, you can invoke the <a>DeleteDeliveryStream</a> operation to delete it.</p>
    pub fn delivery_stream_status(
        &self,
    ) -> std::option::Option<&crate::model::DeliveryStreamStatus> {
        self.delivery_stream_status.as_ref()
    }
    /// <p>Provides details in case one of the following operations fails due to an error related
    /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
    /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
    pub fn failure_description(&self) -> std::option::Option<&crate::model::FailureDescription> {
        self.failure_description.as_ref()
    }
    /// <p>Indicates the server-side encryption (SSE) status for the delivery stream.</p>
    pub fn delivery_stream_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeliveryStreamEncryptionConfiguration> {
        self.delivery_stream_encryption_configuration.as_ref()
    }
    /// <p>The delivery stream type. This can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DirectPut</code>: Provider applications access the delivery stream
    /// directly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
    /// stream as a source.</p>
    /// </li>
    /// </ul>
    pub fn delivery_stream_type(&self) -> std::option::Option<&crate::model::DeliveryStreamType> {
        self.delivery_stream_type.as_ref()
    }
    /// <p>Each time the destination is updated for a delivery stream, the version ID is
    /// changed, and the current version ID is required when updating the destination. This is so
    /// that the service knows it is applying the changes to the correct version of the delivery
    /// stream.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The date and time that the delivery stream was created.</p>
    pub fn create_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_timestamp.as_ref()
    }
    /// <p>The date and time that the delivery stream was last updated.</p>
    pub fn last_update_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_timestamp.as_ref()
    }
    /// <p>If the <code>DeliveryStreamType</code> parameter is
    /// <code>KinesisStreamAsSource</code>, a <a>SourceDescription</a> object
    /// describing the source Kinesis data stream.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::SourceDescription> {
        self.source.as_ref()
    }
    /// <p>The destinations.</p>
    pub fn destinations(&self) -> std::option::Option<&[crate::model::DestinationDescription]> {
        self.destinations.as_deref()
    }
    /// <p>Indicates whether there are more destinations available to list.</p>
    pub fn has_more_destinations(&self) -> std::option::Option<bool> {
        self.has_more_destinations
    }
}
impl std::fmt::Debug for DeliveryStreamDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliveryStreamDescription");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("delivery_stream_arn", &self.delivery_stream_arn);
        formatter.field("delivery_stream_status", &self.delivery_stream_status);
        formatter.field("failure_description", &self.failure_description);
        formatter.field(
            "delivery_stream_encryption_configuration",
            &self.delivery_stream_encryption_configuration,
        );
        formatter.field("delivery_stream_type", &self.delivery_stream_type);
        formatter.field("version_id", &self.version_id);
        formatter.field("create_timestamp", &self.create_timestamp);
        formatter.field("last_update_timestamp", &self.last_update_timestamp);
        formatter.field("source", &self.source);
        formatter.field("destinations", &self.destinations);
        formatter.field("has_more_destinations", &self.has_more_destinations);
        formatter.finish()
    }
}
/// See [`DeliveryStreamDescription`](crate::model::DeliveryStreamDescription)
pub mod delivery_stream_description {
    /// A builder for [`DeliveryStreamDescription`](crate::model::DeliveryStreamDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_arn: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_status: std::option::Option<crate::model::DeliveryStreamStatus>,
        pub(crate) failure_description: std::option::Option<crate::model::FailureDescription>,
        pub(crate) delivery_stream_encryption_configuration:
            std::option::Option<crate::model::DeliveryStreamEncryptionConfiguration>,
        pub(crate) delivery_stream_type: std::option::Option<crate::model::DeliveryStreamType>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) create_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) source: std::option::Option<crate::model::SourceDescription>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::DestinationDescription>>,
        pub(crate) has_more_destinations: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the delivery stream. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn delivery_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the delivery stream. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_delivery_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_arn = input;
            self
        }
        /// <p>The status of the delivery stream. If the status of a delivery stream is
        /// <code>CREATING_FAILED</code>, this status doesn't change, and you can't invoke
        /// <code>CreateDeliveryStream</code> again on it. However, you can invoke the <a>DeleteDeliveryStream</a> operation to delete it.</p>
        pub fn delivery_stream_status(mut self, input: crate::model::DeliveryStreamStatus) -> Self {
            self.delivery_stream_status = Some(input);
            self
        }
        /// <p>The status of the delivery stream. If the status of a delivery stream is
        /// <code>CREATING_FAILED</code>, this status doesn't change, and you can't invoke
        /// <code>CreateDeliveryStream</code> again on it. However, you can invoke the <a>DeleteDeliveryStream</a> operation to delete it.</p>
        pub fn set_delivery_stream_status(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamStatus>,
        ) -> Self {
            self.delivery_stream_status = input;
            self
        }
        /// <p>Provides details in case one of the following operations fails due to an error related
        /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
        /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
        pub fn failure_description(mut self, input: crate::model::FailureDescription) -> Self {
            self.failure_description = Some(input);
            self
        }
        /// <p>Provides details in case one of the following operations fails due to an error related
        /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
        /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
        pub fn set_failure_description(
            mut self,
            input: std::option::Option<crate::model::FailureDescription>,
        ) -> Self {
            self.failure_description = input;
            self
        }
        /// <p>Indicates the server-side encryption (SSE) status for the delivery stream.</p>
        pub fn delivery_stream_encryption_configuration(
            mut self,
            input: crate::model::DeliveryStreamEncryptionConfiguration,
        ) -> Self {
            self.delivery_stream_encryption_configuration = Some(input);
            self
        }
        /// <p>Indicates the server-side encryption (SSE) status for the delivery stream.</p>
        pub fn set_delivery_stream_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamEncryptionConfiguration>,
        ) -> Self {
            self.delivery_stream_encryption_configuration = input;
            self
        }
        /// <p>The delivery stream type. This can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DirectPut</code>: Provider applications access the delivery stream
        /// directly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
        /// stream as a source.</p>
        /// </li>
        /// </ul>
        pub fn delivery_stream_type(mut self, input: crate::model::DeliveryStreamType) -> Self {
            self.delivery_stream_type = Some(input);
            self
        }
        /// <p>The delivery stream type. This can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DirectPut</code>: Provider applications access the delivery stream
        /// directly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
        /// stream as a source.</p>
        /// </li>
        /// </ul>
        pub fn set_delivery_stream_type(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamType>,
        ) -> Self {
            self.delivery_stream_type = input;
            self
        }
        /// <p>Each time the destination is updated for a delivery stream, the version ID is
        /// changed, and the current version ID is required when updating the destination. This is so
        /// that the service knows it is applying the changes to the correct version of the delivery
        /// stream.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Each time the destination is updated for a delivery stream, the version ID is
        /// changed, and the current version ID is required when updating the destination. This is so
        /// that the service knows it is applying the changes to the correct version of the delivery
        /// stream.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The date and time that the delivery stream was created.</p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the delivery stream was created.</p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_timestamp = input;
            self
        }
        /// <p>The date and time that the delivery stream was last updated.</p>
        pub fn last_update_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the delivery stream was last updated.</p>
        pub fn set_last_update_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_timestamp = input;
            self
        }
        /// <p>If the <code>DeliveryStreamType</code> parameter is
        /// <code>KinesisStreamAsSource</code>, a <a>SourceDescription</a> object
        /// describing the source Kinesis data stream.</p>
        pub fn source(mut self, input: crate::model::SourceDescription) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>If the <code>DeliveryStreamType</code> parameter is
        /// <code>KinesisStreamAsSource</code>, a <a>SourceDescription</a> object
        /// describing the source Kinesis data stream.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::SourceDescription>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>The destinations.</p>
        pub fn destinations(
            mut self,
            input: impl Into<crate::model::DestinationDescription>,
        ) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// <p>The destinations.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationDescription>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// <p>Indicates whether there are more destinations available to list.</p>
        pub fn has_more_destinations(mut self, input: bool) -> Self {
            self.has_more_destinations = Some(input);
            self
        }
        /// <p>Indicates whether there are more destinations available to list.</p>
        pub fn set_has_more_destinations(mut self, input: std::option::Option<bool>) -> Self {
            self.has_more_destinations = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliveryStreamDescription`](crate::model::DeliveryStreamDescription)
        pub fn build(self) -> crate::model::DeliveryStreamDescription {
            crate::model::DeliveryStreamDescription {
                delivery_stream_name: self.delivery_stream_name,
                delivery_stream_arn: self.delivery_stream_arn,
                delivery_stream_status: self.delivery_stream_status,
                failure_description: self.failure_description,
                delivery_stream_encryption_configuration: self
                    .delivery_stream_encryption_configuration,
                delivery_stream_type: self.delivery_stream_type,
                version_id: self.version_id,
                create_timestamp: self.create_timestamp,
                last_update_timestamp: self.last_update_timestamp,
                source: self.source,
                destinations: self.destinations,
                has_more_destinations: self.has_more_destinations,
            }
        }
    }
}
impl DeliveryStreamDescription {
    /// Creates a new builder-style object to manufacture [`DeliveryStreamDescription`](crate::model::DeliveryStreamDescription)
    pub fn builder() -> crate::model::delivery_stream_description::Builder {
        crate::model::delivery_stream_description::Builder::default()
    }
}

/// <p>Describes the destination for a delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationDescription {
    /// <p>The ID of the destination.</p>
    pub destination_id: std::option::Option<std::string::String>,
    /// <p>[Deprecated] The destination in Amazon S3.</p>
    pub s3_destination_description: std::option::Option<crate::model::S3DestinationDescription>,
    /// <p>The destination in Amazon S3.</p>
    pub extended_s3_destination_description:
        std::option::Option<crate::model::ExtendedS3DestinationDescription>,
    /// <p>The destination in Amazon Redshift.</p>
    pub redshift_destination_description:
        std::option::Option<crate::model::RedshiftDestinationDescription>,
    /// <p>The destination in Amazon ES.</p>
    pub elasticsearch_destination_description:
        std::option::Option<crate::model::ElasticsearchDestinationDescription>,
    #[allow(missing_docs)] // documentation missing in model
    pub amazonopensearchservice_destination_description:
        std::option::Option<crate::model::AmazonopensearchserviceDestinationDescription>,
    /// <p>The destination in Splunk.</p>
    pub splunk_destination_description:
        std::option::Option<crate::model::SplunkDestinationDescription>,
    /// <p>Describes the specified HTTP endpoint destination.</p>
    pub http_endpoint_destination_description:
        std::option::Option<crate::model::HttpEndpointDestinationDescription>,
}
impl DestinationDescription {
    /// <p>The ID of the destination.</p>
    pub fn destination_id(&self) -> std::option::Option<&str> {
        self.destination_id.as_deref()
    }
    /// <p>[Deprecated] The destination in Amazon S3.</p>
    pub fn s3_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_destination_description.as_ref()
    }
    /// <p>The destination in Amazon S3.</p>
    pub fn extended_s3_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::ExtendedS3DestinationDescription> {
        self.extended_s3_destination_description.as_ref()
    }
    /// <p>The destination in Amazon Redshift.</p>
    pub fn redshift_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::RedshiftDestinationDescription> {
        self.redshift_destination_description.as_ref()
    }
    /// <p>The destination in Amazon ES.</p>
    pub fn elasticsearch_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchDestinationDescription> {
        self.elasticsearch_destination_description.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn amazonopensearchservice_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceDestinationDescription> {
        self.amazonopensearchservice_destination_description
            .as_ref()
    }
    /// <p>The destination in Splunk.</p>
    pub fn splunk_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::SplunkDestinationDescription> {
        self.splunk_destination_description.as_ref()
    }
    /// <p>Describes the specified HTTP endpoint destination.</p>
    pub fn http_endpoint_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointDestinationDescription> {
        self.http_endpoint_destination_description.as_ref()
    }
}
impl std::fmt::Debug for DestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationDescription");
        formatter.field("destination_id", &self.destination_id);
        formatter.field(
            "s3_destination_description",
            &self.s3_destination_description,
        );
        formatter.field(
            "extended_s3_destination_description",
            &self.extended_s3_destination_description,
        );
        formatter.field(
            "redshift_destination_description",
            &self.redshift_destination_description,
        );
        formatter.field(
            "elasticsearch_destination_description",
            &self.elasticsearch_destination_description,
        );
        formatter.field(
            "amazonopensearchservice_destination_description",
            &self.amazonopensearchservice_destination_description,
        );
        formatter.field(
            "splunk_destination_description",
            &self.splunk_destination_description,
        );
        formatter.field(
            "http_endpoint_destination_description",
            &self.http_endpoint_destination_description,
        );
        formatter.finish()
    }
}
/// See [`DestinationDescription`](crate::model::DestinationDescription)
pub mod destination_description {
    /// A builder for [`DestinationDescription`](crate::model::DestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination_description:
            std::option::Option<crate::model::S3DestinationDescription>,
        pub(crate) extended_s3_destination_description:
            std::option::Option<crate::model::ExtendedS3DestinationDescription>,
        pub(crate) redshift_destination_description:
            std::option::Option<crate::model::RedshiftDestinationDescription>,
        pub(crate) elasticsearch_destination_description:
            std::option::Option<crate::model::ElasticsearchDestinationDescription>,
        pub(crate) amazonopensearchservice_destination_description:
            std::option::Option<crate::model::AmazonopensearchserviceDestinationDescription>,
        pub(crate) splunk_destination_description:
            std::option::Option<crate::model::SplunkDestinationDescription>,
        pub(crate) http_endpoint_destination_description:
            std::option::Option<crate::model::HttpEndpointDestinationDescription>,
    }
    impl Builder {
        /// <p>The ID of the destination.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_id = Some(input.into());
            self
        }
        /// <p>The ID of the destination.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_id = input;
            self
        }
        /// <p>[Deprecated] The destination in Amazon S3.</p>
        pub fn s3_destination_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_destination_description = Some(input);
            self
        }
        /// <p>[Deprecated] The destination in Amazon S3.</p>
        pub fn set_s3_destination_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_destination_description = input;
            self
        }
        /// <p>The destination in Amazon S3.</p>
        pub fn extended_s3_destination_description(
            mut self,
            input: crate::model::ExtendedS3DestinationDescription,
        ) -> Self {
            self.extended_s3_destination_description = Some(input);
            self
        }
        /// <p>The destination in Amazon S3.</p>
        pub fn set_extended_s3_destination_description(
            mut self,
            input: std::option::Option<crate::model::ExtendedS3DestinationDescription>,
        ) -> Self {
            self.extended_s3_destination_description = input;
            self
        }
        /// <p>The destination in Amazon Redshift.</p>
        pub fn redshift_destination_description(
            mut self,
            input: crate::model::RedshiftDestinationDescription,
        ) -> Self {
            self.redshift_destination_description = Some(input);
            self
        }
        /// <p>The destination in Amazon Redshift.</p>
        pub fn set_redshift_destination_description(
            mut self,
            input: std::option::Option<crate::model::RedshiftDestinationDescription>,
        ) -> Self {
            self.redshift_destination_description = input;
            self
        }
        /// <p>The destination in Amazon ES.</p>
        pub fn elasticsearch_destination_description(
            mut self,
            input: crate::model::ElasticsearchDestinationDescription,
        ) -> Self {
            self.elasticsearch_destination_description = Some(input);
            self
        }
        /// <p>The destination in Amazon ES.</p>
        pub fn set_elasticsearch_destination_description(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDestinationDescription>,
        ) -> Self {
            self.elasticsearch_destination_description = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn amazonopensearchservice_destination_description(
            mut self,
            input: crate::model::AmazonopensearchserviceDestinationDescription,
        ) -> Self {
            self.amazonopensearchservice_destination_description = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_amazonopensearchservice_destination_description(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceDestinationDescription>,
        ) -> Self {
            self.amazonopensearchservice_destination_description = input;
            self
        }
        /// <p>The destination in Splunk.</p>
        pub fn splunk_destination_description(
            mut self,
            input: crate::model::SplunkDestinationDescription,
        ) -> Self {
            self.splunk_destination_description = Some(input);
            self
        }
        /// <p>The destination in Splunk.</p>
        pub fn set_splunk_destination_description(
            mut self,
            input: std::option::Option<crate::model::SplunkDestinationDescription>,
        ) -> Self {
            self.splunk_destination_description = input;
            self
        }
        /// <p>Describes the specified HTTP endpoint destination.</p>
        pub fn http_endpoint_destination_description(
            mut self,
            input: crate::model::HttpEndpointDestinationDescription,
        ) -> Self {
            self.http_endpoint_destination_description = Some(input);
            self
        }
        /// <p>Describes the specified HTTP endpoint destination.</p>
        pub fn set_http_endpoint_destination_description(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointDestinationDescription>,
        ) -> Self {
            self.http_endpoint_destination_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationDescription`](crate::model::DestinationDescription)
        pub fn build(self) -> crate::model::DestinationDescription {
            crate::model::DestinationDescription {
                destination_id: self.destination_id,
                s3_destination_description: self.s3_destination_description,
                extended_s3_destination_description: self.extended_s3_destination_description,
                redshift_destination_description: self.redshift_destination_description,
                elasticsearch_destination_description: self.elasticsearch_destination_description,
                amazonopensearchservice_destination_description: self
                    .amazonopensearchservice_destination_description,
                splunk_destination_description: self.splunk_destination_description,
                http_endpoint_destination_description: self.http_endpoint_destination_description,
            }
        }
    }
}
impl DestinationDescription {
    /// Creates a new builder-style object to manufacture [`DestinationDescription`](crate::model::DestinationDescription)
    pub fn builder() -> crate::model::destination_description::Builder {
        crate::model::destination_description::Builder::default()
    }
}

/// <p>Describes the HTTP endpoint destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointDestinationDescription {
    /// <p>The configuration of the specified HTTP endpoint destination.</p>
    pub endpoint_configuration: std::option::Option<crate::model::HttpEndpointDescription>,
    /// <p>Describes buffering options that can be applied to the data before it is delivered to
    /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
    /// might choose to use more optimal values. The <code>SizeInMBs</code> and
    /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
    /// one of them, you must also provide a value for the other. </p>
    pub buffering_hints: std::option::Option<crate::model::HttpEndpointBufferingHints>,
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The configuration of request sent to the HTTP endpoint specified as the
    /// destination.</p>
    pub request_configuration: std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
    /// <p>Describes a data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
    /// stream needs.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
    /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
    /// receipt from the specified HTTP endpoint destination.</p>
    pub retry_options: std::option::Option<crate::model::HttpEndpointRetryOptions>,
    /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
    /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
    /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
    /// destination (<code>FailedDataOnly</code>).</p>
    pub s3_backup_mode: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
    /// <p>Describes a destination in Amazon S3.</p>
    pub s3_destination_description: std::option::Option<crate::model::S3DestinationDescription>,
}
impl HttpEndpointDestinationDescription {
    /// <p>The configuration of the specified HTTP endpoint destination.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointDescription> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>Describes buffering options that can be applied to the data before it is delivered to
    /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
    /// might choose to use more optimal values. The <code>SizeInMBs</code> and
    /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
    /// one of them, you must also provide a value for the other. </p>
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointBufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The configuration of request sent to the HTTP endpoint specified as the
    /// destination.</p>
    pub fn request_configuration(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointRequestConfiguration> {
        self.request_configuration.as_ref()
    }
    /// <p>Describes a data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
    /// stream needs.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
    /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
    /// receipt from the specified HTTP endpoint destination.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::HttpEndpointRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
    /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
    /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
    /// destination (<code>FailedDataOnly</code>).</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::HttpEndpointS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>Describes a destination in Amazon S3.</p>
    pub fn s3_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_destination_description.as_ref()
    }
}
impl std::fmt::Debug for HttpEndpointDestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointDestinationDescription");
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("request_configuration", &self.request_configuration);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field(
            "s3_destination_description",
            &self.s3_destination_description,
        );
        formatter.finish()
    }
}
/// See [`HttpEndpointDestinationDescription`](crate::model::HttpEndpointDestinationDescription)
pub mod http_endpoint_destination_description {
    /// A builder for [`HttpEndpointDestinationDescription`](crate::model::HttpEndpointDestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_configuration:
            std::option::Option<crate::model::HttpEndpointDescription>,
        pub(crate) buffering_hints: std::option::Option<crate::model::HttpEndpointBufferingHints>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) request_configuration:
            std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) retry_options: std::option::Option<crate::model::HttpEndpointRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
        pub(crate) s3_destination_description:
            std::option::Option<crate::model::S3DestinationDescription>,
    }
    impl Builder {
        /// <p>The configuration of the specified HTTP endpoint destination.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::HttpEndpointDescription,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The configuration of the specified HTTP endpoint destination.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointDescription>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>Describes buffering options that can be applied to the data before it is delivered to
        /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
        /// might choose to use more optimal values. The <code>SizeInMBs</code> and
        /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
        /// one of them, you must also provide a value for the other. </p>
        pub fn buffering_hints(mut self, input: crate::model::HttpEndpointBufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>Describes buffering options that can be applied to the data before it is delivered to
        /// the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it
        /// might choose to use more optimal values. The <code>SizeInMBs</code> and
        /// <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
        /// one of them, you must also provide a value for the other. </p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The configuration of request sent to the HTTP endpoint specified as the
        /// destination.</p>
        pub fn request_configuration(
            mut self,
            input: crate::model::HttpEndpointRequestConfiguration,
        ) -> Self {
            self.request_configuration = Some(input);
            self
        }
        /// <p>The configuration of request sent to the HTTP endpoint specified as the
        /// destination.</p>
        pub fn set_request_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
        ) -> Self {
            self.request_configuration = input;
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
        /// stream needs.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
        /// stream needs.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
        /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
        /// receipt from the specified HTTP endpoint destination.</p>
        pub fn retry_options(mut self, input: crate::model::HttpEndpointRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
        /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
        /// receipt from the specified HTTP endpoint destination.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
        /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
        /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
        /// destination (<code>FailedDataOnly</code>).</p>
        pub fn s3_backup_mode(mut self, input: crate::model::HttpEndpointS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to
        /// the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only
        /// the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint
        /// destination (<code>FailedDataOnly</code>).</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>Describes a destination in Amazon S3.</p>
        pub fn s3_destination_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_destination_description = Some(input);
            self
        }
        /// <p>Describes a destination in Amazon S3.</p>
        pub fn set_s3_destination_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_destination_description = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointDestinationDescription`](crate::model::HttpEndpointDestinationDescription)
        pub fn build(self) -> crate::model::HttpEndpointDestinationDescription {
            crate::model::HttpEndpointDestinationDescription {
                endpoint_configuration: self.endpoint_configuration,
                buffering_hints: self.buffering_hints,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                request_configuration: self.request_configuration,
                processing_configuration: self.processing_configuration,
                role_arn: self.role_arn,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_destination_description: self.s3_destination_description,
            }
        }
    }
}
impl HttpEndpointDestinationDescription {
    /// Creates a new builder-style object to manufacture [`HttpEndpointDestinationDescription`](crate::model::HttpEndpointDestinationDescription)
    pub fn builder() -> crate::model::http_endpoint_destination_description::Builder {
        crate::model::http_endpoint_destination_description::Builder::default()
    }
}

/// <p>Describes a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub error_output_prefix: std::option::Option<std::string::String>,
    /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
    /// default values are used.</p>
    pub buffering_hints: std::option::Option<crate::model::BufferingHints>,
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    pub compression_format: std::option::Option<crate::model::CompressionFormat>,
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl S3DestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn error_output_prefix(&self) -> std::option::Option<&str> {
        self.error_output_prefix.as_deref()
    }
    /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
    /// default values are used.</p>
    pub fn buffering_hints(&self) -> std::option::Option<&crate::model::BufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    pub fn compression_format(&self) -> std::option::Option<&crate::model::CompressionFormat> {
        self.compression_format.as_ref()
    }
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for S3DestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationDescription");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("prefix", &self.prefix);
        formatter.field("error_output_prefix", &self.error_output_prefix);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("compression_format", &self.compression_format);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`S3DestinationDescription`](crate::model::S3DestinationDescription)
pub mod s3_destination_description {
    /// A builder for [`S3DestinationDescription`](crate::model::S3DestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) error_output_prefix: std::option::Option<std::string::String>,
        pub(crate) buffering_hints: std::option::Option<crate::model::BufferingHints>,
        pub(crate) compression_format: std::option::Option<crate::model::CompressionFormat>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn error_output_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_output_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_error_output_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_output_prefix = input;
            self
        }
        /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
        /// default values are used.</p>
        pub fn buffering_hints(mut self, input: crate::model::BufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
        /// default values are used.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::BufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        pub fn compression_format(mut self, input: crate::model::CompressionFormat) -> Self {
            self.compression_format = Some(input);
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        pub fn set_compression_format(
            mut self,
            input: std::option::Option<crate::model::CompressionFormat>,
        ) -> Self {
            self.compression_format = input;
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationDescription`](crate::model::S3DestinationDescription)
        pub fn build(self) -> crate::model::S3DestinationDescription {
            crate::model::S3DestinationDescription {
                role_arn: self.role_arn,
                bucket_arn: self.bucket_arn,
                prefix: self.prefix,
                error_output_prefix: self.error_output_prefix,
                buffering_hints: self.buffering_hints,
                compression_format: self.compression_format,
                encryption_configuration: self.encryption_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl S3DestinationDescription {
    /// Creates a new builder-style object to manufacture [`S3DestinationDescription`](crate::model::S3DestinationDescription)
    pub fn builder() -> crate::model::s3_destination_description::Builder {
        crate::model::s3_destination_description::Builder::default()
    }
}

/// <p>Describes the HTTP endpoint selected as the destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointDescription {
    /// <p>The URL of the HTTP endpoint selected as the destination.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The name of the HTTP endpoint selected as the destination.</p>
    pub name: std::option::Option<std::string::String>,
}
impl HttpEndpointDescription {
    /// <p>The URL of the HTTP endpoint selected as the destination.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The name of the HTTP endpoint selected as the destination.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for HttpEndpointDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointDescription");
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`HttpEndpointDescription`](crate::model::HttpEndpointDescription)
pub mod http_endpoint_description {
    /// A builder for [`HttpEndpointDescription`](crate::model::HttpEndpointDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL of the HTTP endpoint selected as the destination.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the HTTP endpoint selected as the destination.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The name of the HTTP endpoint selected as the destination.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the HTTP endpoint selected as the destination.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointDescription`](crate::model::HttpEndpointDescription)
        pub fn build(self) -> crate::model::HttpEndpointDescription {
            crate::model::HttpEndpointDescription {
                url: self.url,
                name: self.name,
            }
        }
    }
}
impl HttpEndpointDescription {
    /// Creates a new builder-style object to manufacture [`HttpEndpointDescription`](crate::model::HttpEndpointDescription)
    pub fn builder() -> crate::model::http_endpoint_description::Builder {
        crate::model::http_endpoint_description::Builder::default()
    }
}

/// <p>Describes a destination in Splunk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SplunkDestinationDescription {
    /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
    /// data.</p>
    pub hec_endpoint: std::option::Option<std::string::String>,
    /// <p>This type can be either "Raw" or "Event."</p>
    pub hec_endpoint_type: std::option::Option<crate::model::HecEndpointType>,
    /// <p>A GUID you obtain from your Splunk cluster when you create a new HEC
    /// endpoint.</p>
    pub hec_token: std::option::Option<std::string::String>,
    /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
    /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
    /// either tries to send the data again or considers it an error, based on your retry
    /// settings.</p>
    pub hec_acknowledgment_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
    /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
    pub retry_options: std::option::Option<crate::model::SplunkRetryOptions>,
    /// <p>Defines how documents should be delivered to Amazon S3. When set to
    /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could not
    /// be indexed to the configured Amazon S3 destination. When set to <code>AllDocuments</code>,
    /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
    /// documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>. </p>
    pub s3_backup_mode: std::option::Option<crate::model::SplunkS3BackupMode>,
    /// <p>The Amazon S3 destination.></p>
    pub s3_destination_description: std::option::Option<crate::model::S3DestinationDescription>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl SplunkDestinationDescription {
    /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
    /// data.</p>
    pub fn hec_endpoint(&self) -> std::option::Option<&str> {
        self.hec_endpoint.as_deref()
    }
    /// <p>This type can be either "Raw" or "Event."</p>
    pub fn hec_endpoint_type(&self) -> std::option::Option<&crate::model::HecEndpointType> {
        self.hec_endpoint_type.as_ref()
    }
    /// <p>A GUID you obtain from your Splunk cluster when you create a new HEC
    /// endpoint.</p>
    pub fn hec_token(&self) -> std::option::Option<&str> {
        self.hec_token.as_deref()
    }
    /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
    /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
    /// either tries to send the data again or considers it an error, based on your retry
    /// settings.</p>
    pub fn hec_acknowledgment_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.hec_acknowledgment_timeout_in_seconds
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
    /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::SplunkRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Defines how documents should be delivered to Amazon S3. When set to
    /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could not
    /// be indexed to the configured Amazon S3 destination. When set to <code>AllDocuments</code>,
    /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
    /// documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>. </p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::SplunkS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The Amazon S3 destination.></p>
    pub fn s3_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_destination_description.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for SplunkDestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SplunkDestinationDescription");
        formatter.field("hec_endpoint", &self.hec_endpoint);
        formatter.field("hec_endpoint_type", &self.hec_endpoint_type);
        formatter.field("hec_token", &self.hec_token);
        formatter.field(
            "hec_acknowledgment_timeout_in_seconds",
            &self.hec_acknowledgment_timeout_in_seconds,
        );
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field(
            "s3_destination_description",
            &self.s3_destination_description,
        );
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`SplunkDestinationDescription`](crate::model::SplunkDestinationDescription)
pub mod splunk_destination_description {
    /// A builder for [`SplunkDestinationDescription`](crate::model::SplunkDestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hec_endpoint: std::option::Option<std::string::String>,
        pub(crate) hec_endpoint_type: std::option::Option<crate::model::HecEndpointType>,
        pub(crate) hec_token: std::option::Option<std::string::String>,
        pub(crate) hec_acknowledgment_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) retry_options: std::option::Option<crate::model::SplunkRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::SplunkS3BackupMode>,
        pub(crate) s3_destination_description:
            std::option::Option<crate::model::S3DestinationDescription>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
        /// data.</p>
        pub fn hec_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.hec_endpoint = Some(input.into());
            self
        }
        /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
        /// data.</p>
        pub fn set_hec_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hec_endpoint = input;
            self
        }
        /// <p>This type can be either "Raw" or "Event."</p>
        pub fn hec_endpoint_type(mut self, input: crate::model::HecEndpointType) -> Self {
            self.hec_endpoint_type = Some(input);
            self
        }
        /// <p>This type can be either "Raw" or "Event."</p>
        pub fn set_hec_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::HecEndpointType>,
        ) -> Self {
            self.hec_endpoint_type = input;
            self
        }
        /// <p>A GUID you obtain from your Splunk cluster when you create a new HEC
        /// endpoint.</p>
        pub fn hec_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.hec_token = Some(input.into());
            self
        }
        /// <p>A GUID you obtain from your Splunk cluster when you create a new HEC
        /// endpoint.</p>
        pub fn set_hec_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hec_token = input;
            self
        }
        /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
        /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
        /// either tries to send the data again or considers it an error, based on your retry
        /// settings.</p>
        pub fn hec_acknowledgment_timeout_in_seconds(mut self, input: i32) -> Self {
            self.hec_acknowledgment_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
        /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
        /// either tries to send the data again or considers it an error, based on your retry
        /// settings.</p>
        pub fn set_hec_acknowledgment_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.hec_acknowledgment_timeout_in_seconds = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
        /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
        pub fn retry_options(mut self, input: crate::model::SplunkRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk
        /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::SplunkRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Defines how documents should be delivered to Amazon S3. When set to
        /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could not
        /// be indexed to the configured Amazon S3 destination. When set to <code>AllDocuments</code>,
        /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
        /// documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>. </p>
        pub fn s3_backup_mode(mut self, input: crate::model::SplunkS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>Defines how documents should be delivered to Amazon S3. When set to
        /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could not
        /// be indexed to the configured Amazon S3 destination. When set to <code>AllDocuments</code>,
        /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
        /// documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>. </p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::SplunkS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The Amazon S3 destination.></p>
        pub fn s3_destination_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_destination_description = Some(input);
            self
        }
        /// <p>The Amazon S3 destination.></p>
        pub fn set_s3_destination_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_destination_description = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`SplunkDestinationDescription`](crate::model::SplunkDestinationDescription)
        pub fn build(self) -> crate::model::SplunkDestinationDescription {
            crate::model::SplunkDestinationDescription {
                hec_endpoint: self.hec_endpoint,
                hec_endpoint_type: self.hec_endpoint_type,
                hec_token: self.hec_token,
                hec_acknowledgment_timeout_in_seconds: self.hec_acknowledgment_timeout_in_seconds,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_destination_description: self.s3_destination_description,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl SplunkDestinationDescription {
    /// Creates a new builder-style object to manufacture [`SplunkDestinationDescription`](crate::model::SplunkDestinationDescription)
    pub fn builder() -> crate::model::splunk_destination_description::Builder {
        crate::model::splunk_destination_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonopensearchserviceDestinationDescription {
    #[allow(missing_docs)] // documentation missing in model
    pub role_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub domain_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub cluster_endpoint: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub index_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub type_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub index_rotation_period:
        std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
    #[allow(missing_docs)] // documentation missing in model
    pub buffering_hints: std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
    #[allow(missing_docs)] // documentation missing in model
    pub retry_options: std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
    #[allow(missing_docs)] // documentation missing in model
    pub s3_backup_mode: std::option::Option<crate::model::AmazonopensearchserviceS3BackupMode>,
    /// <p>Describes a destination in Amazon S3.</p>
    pub s3_destination_description: std::option::Option<crate::model::S3DestinationDescription>,
    /// <p>Describes a data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub vpc_configuration_description:
        std::option::Option<crate::model::VpcConfigurationDescription>,
}
impl AmazonopensearchserviceDestinationDescription {
    #[allow(missing_docs)] // documentation missing in model
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn domain_arn(&self) -> std::option::Option<&str> {
        self.domain_arn.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn cluster_endpoint(&self) -> std::option::Option<&str> {
        self.cluster_endpoint.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn index_rotation_period(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceIndexRotationPeriod> {
        self.index_rotation_period.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceBufferingHints> {
        self.buffering_hints.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn retry_options(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceRetryOptions> {
        self.retry_options.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn s3_backup_mode(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>Describes a destination in Amazon S3.</p>
    pub fn s3_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_destination_description.as_ref()
    }
    /// <p>Describes a data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub fn vpc_configuration_description(
        &self,
    ) -> std::option::Option<&crate::model::VpcConfigurationDescription> {
        self.vpc_configuration_description.as_ref()
    }
}
impl std::fmt::Debug for AmazonopensearchserviceDestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonopensearchserviceDestinationDescription");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("domain_arn", &self.domain_arn);
        formatter.field("cluster_endpoint", &self.cluster_endpoint);
        formatter.field("index_name", &self.index_name);
        formatter.field("type_name", &self.type_name);
        formatter.field("index_rotation_period", &self.index_rotation_period);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field(
            "s3_destination_description",
            &self.s3_destination_description,
        );
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field(
            "vpc_configuration_description",
            &self.vpc_configuration_description,
        );
        formatter.finish()
    }
}
/// See [`AmazonopensearchserviceDestinationDescription`](crate::model::AmazonopensearchserviceDestinationDescription)
pub mod amazonopensearchservice_destination_description {
    /// A builder for [`AmazonopensearchserviceDestinationDescription`](crate::model::AmazonopensearchserviceDestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_endpoint: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) index_rotation_period:
            std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
        pub(crate) buffering_hints:
            std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
        pub(crate) retry_options:
            std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
        pub(crate) s3_backup_mode:
            std::option::Option<crate::model::AmazonopensearchserviceS3BackupMode>,
        pub(crate) s3_destination_description:
            std::option::Option<crate::model::S3DestinationDescription>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) vpc_configuration_description:
            std::option::Option<crate::model::VpcConfigurationDescription>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn domain_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_domain_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn cluster_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_endpoint = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_cluster_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_endpoint = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn index_rotation_period(
            mut self,
            input: crate::model::AmazonopensearchserviceIndexRotationPeriod,
        ) -> Self {
            self.index_rotation_period = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_index_rotation_period(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
        ) -> Self {
            self.index_rotation_period = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn buffering_hints(
            mut self,
            input: crate::model::AmazonopensearchserviceBufferingHints,
        ) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_options(
            mut self,
            input: crate::model::AmazonopensearchserviceRetryOptions,
        ) -> Self {
            self.retry_options = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn s3_backup_mode(
            mut self,
            input: crate::model::AmazonopensearchserviceS3BackupMode,
        ) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>Describes a destination in Amazon S3.</p>
        pub fn s3_destination_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_destination_description = Some(input);
            self
        }
        /// <p>Describes a destination in Amazon S3.</p>
        pub fn set_s3_destination_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_destination_description = input;
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn vpc_configuration_description(
            mut self,
            input: crate::model::VpcConfigurationDescription,
        ) -> Self {
            self.vpc_configuration_description = Some(input);
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn set_vpc_configuration_description(
            mut self,
            input: std::option::Option<crate::model::VpcConfigurationDescription>,
        ) -> Self {
            self.vpc_configuration_description = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonopensearchserviceDestinationDescription`](crate::model::AmazonopensearchserviceDestinationDescription)
        pub fn build(self) -> crate::model::AmazonopensearchserviceDestinationDescription {
            crate::model::AmazonopensearchserviceDestinationDescription {
                role_arn: self.role_arn,
                domain_arn: self.domain_arn,
                cluster_endpoint: self.cluster_endpoint,
                index_name: self.index_name,
                type_name: self.type_name,
                index_rotation_period: self.index_rotation_period,
                buffering_hints: self.buffering_hints,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_destination_description: self.s3_destination_description,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                vpc_configuration_description: self.vpc_configuration_description,
            }
        }
    }
}
impl AmazonopensearchserviceDestinationDescription {
    /// Creates a new builder-style object to manufacture [`AmazonopensearchserviceDestinationDescription`](crate::model::AmazonopensearchserviceDestinationDescription)
    pub fn builder() -> crate::model::amazonopensearchservice_destination_description::Builder {
        crate::model::amazonopensearchservice_destination_description::Builder::default()
    }
}

/// <p>The details of the VPC of the Amazon ES destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfigurationDescription {
    /// <p>The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the
    /// Amazon ES destination. Make sure that the routing tables and inbound and outbound rules
    /// allow traffic to flow from the subnets whose IDs are specified here to the subnets that
    /// have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in
    /// each of the subnets that are specified here. Do not delete or modify these ENIs.</p>
    /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
    /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
    /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
    /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
    /// three ENIs for this delivery stream for each of the subnets specified here. For more
    /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
    /// </a> in the Amazon VPC Quotas topic.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the IAM role that the delivery stream uses to create endpoints in the
    /// destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can
    /// specify a new role. In either case, make sure that the role trusts the Kinesis Data
    /// Firehose service principal and that it grants the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcs</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcAttribute</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSubnets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSecurityGroups</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeNetworkInterfaces</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterface</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterfacePermission</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DeleteNetworkInterface</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
    /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
    /// degradation in performance.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in
    /// the VPC of the Amazon ES destination. You can use the same security group that the Amazon
    /// ES domain uses or different ones. If you specify different security groups, ensure that
    /// they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure
    /// that the Amazon ES domain's security group allows HTTPS traffic from the security groups
    /// specified here. If you use the same security group for both your delivery stream and the
    /// Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more
    /// information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
    /// rules</a> in the Amazon VPC documentation.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the Amazon ES destination's VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl VpcConfigurationDescription {
    /// <p>The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the
    /// Amazon ES destination. Make sure that the routing tables and inbound and outbound rules
    /// allow traffic to flow from the subnets whose IDs are specified here to the subnets that
    /// have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in
    /// each of the subnets that are specified here. Do not delete or modify these ENIs.</p>
    /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
    /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
    /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
    /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
    /// three ENIs for this delivery stream for each of the subnets specified here. For more
    /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
    /// </a> in the Amazon VPC Quotas topic.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The ARN of the IAM role that the delivery stream uses to create endpoints in the
    /// destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can
    /// specify a new role. In either case, make sure that the role trusts the Kinesis Data
    /// Firehose service principal and that it grants the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcs</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcAttribute</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSubnets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSecurityGroups</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeNetworkInterfaces</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterface</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterfacePermission</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DeleteNetworkInterface</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
    /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
    /// degradation in performance.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in
    /// the VPC of the Amazon ES destination. You can use the same security group that the Amazon
    /// ES domain uses or different ones. If you specify different security groups, ensure that
    /// they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure
    /// that the Amazon ES domain's security group allows HTTPS traffic from the security groups
    /// specified here. If you use the same security group for both your delivery stream and the
    /// Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more
    /// information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
    /// rules</a> in the Amazon VPC documentation.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The ID of the Amazon ES destination's VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for VpcConfigurationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfigurationDescription");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`VpcConfigurationDescription`](crate::model::VpcConfigurationDescription)
pub mod vpc_configuration_description {
    /// A builder for [`VpcConfigurationDescription`](crate::model::VpcConfigurationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the
        /// Amazon ES destination. Make sure that the routing tables and inbound and outbound rules
        /// allow traffic to flow from the subnets whose IDs are specified here to the subnets that
        /// have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in
        /// each of the subnets that are specified here. Do not delete or modify these ENIs.</p>
        /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
        /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
        /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
        /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
        /// three ENIs for this delivery stream for each of the subnets specified here. For more
        /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
        /// </a> in the Amazon VPC Quotas topic.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the
        /// Amazon ES destination. Make sure that the routing tables and inbound and outbound rules
        /// allow traffic to flow from the subnets whose IDs are specified here to the subnets that
        /// have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in
        /// each of the subnets that are specified here. Do not delete or modify these ENIs.</p>
        /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
        /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
        /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
        /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
        /// three ENIs for this delivery stream for each of the subnets specified here. For more
        /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
        /// </a> in the Amazon VPC Quotas topic.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The ARN of the IAM role that the delivery stream uses to create endpoints in the
        /// destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can
        /// specify a new role. In either case, make sure that the role trusts the Kinesis Data
        /// Firehose service principal and that it grants the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcs</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcAttribute</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSubnets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSecurityGroups</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeNetworkInterfaces</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterface</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterfacePermission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DeleteNetworkInterface</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
        /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
        /// degradation in performance.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that the delivery stream uses to create endpoints in the
        /// destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can
        /// specify a new role. In either case, make sure that the role trusts the Kinesis Data
        /// Firehose service principal and that it grants the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcs</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcAttribute</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSubnets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSecurityGroups</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeNetworkInterfaces</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterface</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterfacePermission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DeleteNetworkInterface</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
        /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
        /// degradation in performance.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in
        /// the VPC of the Amazon ES destination. You can use the same security group that the Amazon
        /// ES domain uses or different ones. If you specify different security groups, ensure that
        /// they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure
        /// that the Amazon ES domain's security group allows HTTPS traffic from the security groups
        /// specified here. If you use the same security group for both your delivery stream and the
        /// Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more
        /// information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
        /// rules</a> in the Amazon VPC documentation.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in
        /// the VPC of the Amazon ES destination. You can use the same security group that the Amazon
        /// ES domain uses or different ones. If you specify different security groups, ensure that
        /// they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure
        /// that the Amazon ES domain's security group allows HTTPS traffic from the security groups
        /// specified here. If you use the same security group for both your delivery stream and the
        /// Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more
        /// information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
        /// rules</a> in the Amazon VPC documentation.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The ID of the Amazon ES destination's VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon ES destination's VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfigurationDescription`](crate::model::VpcConfigurationDescription)
        pub fn build(self) -> crate::model::VpcConfigurationDescription {
            crate::model::VpcConfigurationDescription {
                subnet_ids: self.subnet_ids,
                role_arn: self.role_arn,
                security_group_ids: self.security_group_ids,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl VpcConfigurationDescription {
    /// Creates a new builder-style object to manufacture [`VpcConfigurationDescription`](crate::model::VpcConfigurationDescription)
    pub fn builder() -> crate::model::vpc_configuration_description::Builder {
        crate::model::vpc_configuration_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AmazonopensearchserviceS3BackupMode {
    #[allow(missing_docs)] // documentation missing in model
    AllDocuments,
    #[allow(missing_docs)] // documentation missing in model
    FailedDocumentsOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AmazonopensearchserviceS3BackupMode {
    fn from(s: &str) -> Self {
        match s {
            "AllDocuments" => AmazonopensearchserviceS3BackupMode::AllDocuments,
            "FailedDocumentsOnly" => AmazonopensearchserviceS3BackupMode::FailedDocumentsOnly,
            other => AmazonopensearchserviceS3BackupMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AmazonopensearchserviceS3BackupMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AmazonopensearchserviceS3BackupMode::from(s))
    }
}
impl AmazonopensearchserviceS3BackupMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AmazonopensearchserviceS3BackupMode::AllDocuments => "AllDocuments",
            AmazonopensearchserviceS3BackupMode::FailedDocumentsOnly => "FailedDocumentsOnly",
            AmazonopensearchserviceS3BackupMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AllDocuments", "FailedDocumentsOnly"]
    }
}
impl AsRef<str> for AmazonopensearchserviceS3BackupMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The destination description in Amazon ES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchDestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Amazon ES domain. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    ///
    /// <p>Kinesis Data Firehose uses either <code>ClusterEndpoint</code> or <code>DomainARN</code>
    /// to send data to Amazon ES.</p>
    pub domain_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint to use when communicating with the cluster. Kinesis Data Firehose uses
    /// either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field to send data
    /// to Amazon ES.</p>
    pub cluster_endpoint: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch index name.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch type name. This applies to Elasticsearch 6.x and lower versions.
    /// For Elasticsearch 7.x, there's no value for <code>TypeName</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch index rotation period</p>
    pub index_rotation_period: std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
    /// <p>The buffering options.</p>
    pub buffering_hints: std::option::Option<crate::model::ElasticsearchBufferingHints>,
    /// <p>The Amazon ES retry options.</p>
    pub retry_options: std::option::Option<crate::model::ElasticsearchRetryOptions>,
    /// <p>The Amazon S3 backup mode.</p>
    pub s3_backup_mode: std::option::Option<crate::model::ElasticsearchS3BackupMode>,
    /// <p>The Amazon S3 destination.</p>
    pub s3_destination_description: std::option::Option<crate::model::S3DestinationDescription>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon CloudWatch logging options.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub vpc_configuration_description:
        std::option::Option<crate::model::VpcConfigurationDescription>,
}
impl ElasticsearchDestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the Amazon ES domain. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    ///
    /// <p>Kinesis Data Firehose uses either <code>ClusterEndpoint</code> or <code>DomainARN</code>
    /// to send data to Amazon ES.</p>
    pub fn domain_arn(&self) -> std::option::Option<&str> {
        self.domain_arn.as_deref()
    }
    /// <p>The endpoint to use when communicating with the cluster. Kinesis Data Firehose uses
    /// either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field to send data
    /// to Amazon ES.</p>
    pub fn cluster_endpoint(&self) -> std::option::Option<&str> {
        self.cluster_endpoint.as_deref()
    }
    /// <p>The Elasticsearch index name.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The Elasticsearch type name. This applies to Elasticsearch 6.x and lower versions.
    /// For Elasticsearch 7.x, there's no value for <code>TypeName</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The Elasticsearch index rotation period</p>
    pub fn index_rotation_period(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchIndexRotationPeriod> {
        self.index_rotation_period.as_ref()
    }
    /// <p>The buffering options.</p>
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchBufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The Amazon ES retry options.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::ElasticsearchRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>The Amazon S3 backup mode.</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::ElasticsearchS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The Amazon S3 destination.</p>
    pub fn s3_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_destination_description.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub fn vpc_configuration_description(
        &self,
    ) -> std::option::Option<&crate::model::VpcConfigurationDescription> {
        self.vpc_configuration_description.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchDestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchDestinationDescription");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("domain_arn", &self.domain_arn);
        formatter.field("cluster_endpoint", &self.cluster_endpoint);
        formatter.field("index_name", &self.index_name);
        formatter.field("type_name", &self.type_name);
        formatter.field("index_rotation_period", &self.index_rotation_period);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field(
            "s3_destination_description",
            &self.s3_destination_description,
        );
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field(
            "vpc_configuration_description",
            &self.vpc_configuration_description,
        );
        formatter.finish()
    }
}
/// See [`ElasticsearchDestinationDescription`](crate::model::ElasticsearchDestinationDescription)
pub mod elasticsearch_destination_description {
    /// A builder for [`ElasticsearchDestinationDescription`](crate::model::ElasticsearchDestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_endpoint: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) index_rotation_period:
            std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
        pub(crate) buffering_hints: std::option::Option<crate::model::ElasticsearchBufferingHints>,
        pub(crate) retry_options: std::option::Option<crate::model::ElasticsearchRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::ElasticsearchS3BackupMode>,
        pub(crate) s3_destination_description:
            std::option::Option<crate::model::S3DestinationDescription>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) vpc_configuration_description:
            std::option::Option<crate::model::VpcConfigurationDescription>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the Amazon ES domain. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        ///
        /// <p>Kinesis Data Firehose uses either <code>ClusterEndpoint</code> or <code>DomainARN</code>
        /// to send data to Amazon ES.</p>
        pub fn domain_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon ES domain. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        ///
        /// <p>Kinesis Data Firehose uses either <code>ClusterEndpoint</code> or <code>DomainARN</code>
        /// to send data to Amazon ES.</p>
        pub fn set_domain_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_arn = input;
            self
        }
        /// <p>The endpoint to use when communicating with the cluster. Kinesis Data Firehose uses
        /// either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field to send data
        /// to Amazon ES.</p>
        pub fn cluster_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint to use when communicating with the cluster. Kinesis Data Firehose uses
        /// either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field to send data
        /// to Amazon ES.</p>
        pub fn set_cluster_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_endpoint = input;
            self
        }
        /// <p>The Elasticsearch index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The Elasticsearch index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The Elasticsearch type name. This applies to Elasticsearch 6.x and lower versions.
        /// For Elasticsearch 7.x, there's no value for <code>TypeName</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The Elasticsearch type name. This applies to Elasticsearch 6.x and lower versions.
        /// For Elasticsearch 7.x, there's no value for <code>TypeName</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The Elasticsearch index rotation period</p>
        pub fn index_rotation_period(
            mut self,
            input: crate::model::ElasticsearchIndexRotationPeriod,
        ) -> Self {
            self.index_rotation_period = Some(input);
            self
        }
        /// <p>The Elasticsearch index rotation period</p>
        pub fn set_index_rotation_period(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
        ) -> Self {
            self.index_rotation_period = input;
            self
        }
        /// <p>The buffering options.</p>
        pub fn buffering_hints(mut self, input: crate::model::ElasticsearchBufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering options.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The Amazon ES retry options.</p>
        pub fn retry_options(mut self, input: crate::model::ElasticsearchRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The Amazon ES retry options.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>The Amazon S3 backup mode.</p>
        pub fn s3_backup_mode(mut self, input: crate::model::ElasticsearchS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>The Amazon S3 backup mode.</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The Amazon S3 destination.</p>
        pub fn s3_destination_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_destination_description = Some(input);
            self
        }
        /// <p>The Amazon S3 destination.</p>
        pub fn set_s3_destination_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_destination_description = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn vpc_configuration_description(
            mut self,
            input: crate::model::VpcConfigurationDescription,
        ) -> Self {
            self.vpc_configuration_description = Some(input);
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn set_vpc_configuration_description(
            mut self,
            input: std::option::Option<crate::model::VpcConfigurationDescription>,
        ) -> Self {
            self.vpc_configuration_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchDestinationDescription`](crate::model::ElasticsearchDestinationDescription)
        pub fn build(self) -> crate::model::ElasticsearchDestinationDescription {
            crate::model::ElasticsearchDestinationDescription {
                role_arn: self.role_arn,
                domain_arn: self.domain_arn,
                cluster_endpoint: self.cluster_endpoint,
                index_name: self.index_name,
                type_name: self.type_name,
                index_rotation_period: self.index_rotation_period,
                buffering_hints: self.buffering_hints,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_destination_description: self.s3_destination_description,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                vpc_configuration_description: self.vpc_configuration_description,
            }
        }
    }
}
impl ElasticsearchDestinationDescription {
    /// Creates a new builder-style object to manufacture [`ElasticsearchDestinationDescription`](crate::model::ElasticsearchDestinationDescription)
    pub fn builder() -> crate::model::elasticsearch_destination_description::Builder {
        crate::model::elasticsearch_destination_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ElasticsearchS3BackupMode {
    #[allow(missing_docs)] // documentation missing in model
    AllDocuments,
    #[allow(missing_docs)] // documentation missing in model
    FailedDocumentsOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ElasticsearchS3BackupMode {
    fn from(s: &str) -> Self {
        match s {
            "AllDocuments" => ElasticsearchS3BackupMode::AllDocuments,
            "FailedDocumentsOnly" => ElasticsearchS3BackupMode::FailedDocumentsOnly,
            other => ElasticsearchS3BackupMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ElasticsearchS3BackupMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ElasticsearchS3BackupMode::from(s))
    }
}
impl ElasticsearchS3BackupMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ElasticsearchS3BackupMode::AllDocuments => "AllDocuments",
            ElasticsearchS3BackupMode::FailedDocumentsOnly => "FailedDocumentsOnly",
            ElasticsearchS3BackupMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AllDocuments", "FailedDocumentsOnly"]
    }
}
impl AsRef<str> for ElasticsearchS3BackupMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a destination in Amazon Redshift.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftDestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The database connection string.</p>
    pub cluster_jdbcurl: std::option::Option<std::string::String>,
    /// <p>The <code>COPY</code> command.</p>
    pub copy_command: std::option::Option<crate::model::CopyCommand>,
    /// <p>The name of the user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
    pub retry_options: std::option::Option<crate::model::RedshiftRetryOptions>,
    /// <p>The Amazon S3 destination.</p>
    pub s3_destination_description: std::option::Option<crate::model::S3DestinationDescription>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon S3 backup mode.</p>
    pub s3_backup_mode: std::option::Option<crate::model::RedshiftS3BackupMode>,
    /// <p>The configuration for backup in Amazon S3.</p>
    pub s3_backup_description: std::option::Option<crate::model::S3DestinationDescription>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl RedshiftDestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The database connection string.</p>
    pub fn cluster_jdbcurl(&self) -> std::option::Option<&str> {
        self.cluster_jdbcurl.as_deref()
    }
    /// <p>The <code>COPY</code> command.</p>
    pub fn copy_command(&self) -> std::option::Option<&crate::model::CopyCommand> {
        self.copy_command.as_ref()
    }
    /// <p>The name of the user.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::RedshiftRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>The Amazon S3 destination.</p>
    pub fn s3_destination_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_destination_description.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon S3 backup mode.</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::RedshiftS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The configuration for backup in Amazon S3.</p>
    pub fn s3_backup_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_backup_description.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for RedshiftDestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftDestinationDescription");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("cluster_jdbcurl", &self.cluster_jdbcurl);
        formatter.field("copy_command", &self.copy_command);
        formatter.field("username", &"*** Sensitive Data Redacted ***");
        formatter.field("retry_options", &self.retry_options);
        formatter.field(
            "s3_destination_description",
            &self.s3_destination_description,
        );
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_backup_description", &self.s3_backup_description);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`RedshiftDestinationDescription`](crate::model::RedshiftDestinationDescription)
pub mod redshift_destination_description {
    /// A builder for [`RedshiftDestinationDescription`](crate::model::RedshiftDestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_jdbcurl: std::option::Option<std::string::String>,
        pub(crate) copy_command: std::option::Option<crate::model::CopyCommand>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) retry_options: std::option::Option<crate::model::RedshiftRetryOptions>,
        pub(crate) s3_destination_description:
            std::option::Option<crate::model::S3DestinationDescription>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::RedshiftS3BackupMode>,
        pub(crate) s3_backup_description:
            std::option::Option<crate::model::S3DestinationDescription>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The database connection string.</p>
        pub fn cluster_jdbcurl(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_jdbcurl = Some(input.into());
            self
        }
        /// <p>The database connection string.</p>
        pub fn set_cluster_jdbcurl(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_jdbcurl = input;
            self
        }
        /// <p>The <code>COPY</code> command.</p>
        pub fn copy_command(mut self, input: crate::model::CopyCommand) -> Self {
            self.copy_command = Some(input);
            self
        }
        /// <p>The <code>COPY</code> command.</p>
        pub fn set_copy_command(
            mut self,
            input: std::option::Option<crate::model::CopyCommand>,
        ) -> Self {
            self.copy_command = input;
            self
        }
        /// <p>The name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
        pub fn retry_options(mut self, input: crate::model::RedshiftRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::RedshiftRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>The Amazon S3 destination.</p>
        pub fn s3_destination_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_destination_description = Some(input);
            self
        }
        /// <p>The Amazon S3 destination.</p>
        pub fn set_s3_destination_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_destination_description = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon S3 backup mode.</p>
        pub fn s3_backup_mode(mut self, input: crate::model::RedshiftS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>The Amazon S3 backup mode.</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::RedshiftS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn s3_backup_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_backup_description = Some(input);
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn set_s3_backup_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_backup_description = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftDestinationDescription`](crate::model::RedshiftDestinationDescription)
        pub fn build(self) -> crate::model::RedshiftDestinationDescription {
            crate::model::RedshiftDestinationDescription {
                role_arn: self.role_arn,
                cluster_jdbcurl: self.cluster_jdbcurl,
                copy_command: self.copy_command,
                username: self.username,
                retry_options: self.retry_options,
                s3_destination_description: self.s3_destination_description,
                processing_configuration: self.processing_configuration,
                s3_backup_mode: self.s3_backup_mode,
                s3_backup_description: self.s3_backup_description,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl RedshiftDestinationDescription {
    /// Creates a new builder-style object to manufacture [`RedshiftDestinationDescription`](crate::model::RedshiftDestinationDescription)
    pub fn builder() -> crate::model::redshift_destination_description::Builder {
        crate::model::redshift_destination_description::Builder::default()
    }
}

/// <p>Describes a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtendedS3DestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub error_output_prefix: std::option::Option<std::string::String>,
    /// <p>The buffering option.</p>
    pub buffering_hints: std::option::Option<crate::model::BufferingHints>,
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    pub compression_format: std::option::Option<crate::model::CompressionFormat>,
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon S3 backup mode.</p>
    pub s3_backup_mode: std::option::Option<crate::model::S3BackupMode>,
    /// <p>The configuration for backup in Amazon S3.</p>
    pub s3_backup_description: std::option::Option<crate::model::S3DestinationDescription>,
    /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
    /// the Parquet or ORC format before writing it to Amazon S3.</p>
    pub data_format_conversion_configuration:
        std::option::Option<crate::model::DataFormatConversionConfiguration>,
    /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
    /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
    /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
    /// </p>
    pub dynamic_partitioning_configuration:
        std::option::Option<crate::model::DynamicPartitioningConfiguration>,
}
impl ExtendedS3DestinationDescription {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn error_output_prefix(&self) -> std::option::Option<&str> {
        self.error_output_prefix.as_deref()
    }
    /// <p>The buffering option.</p>
    pub fn buffering_hints(&self) -> std::option::Option<&crate::model::BufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    pub fn compression_format(&self) -> std::option::Option<&crate::model::CompressionFormat> {
        self.compression_format.as_ref()
    }
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon S3 backup mode.</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::S3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The configuration for backup in Amazon S3.</p>
    pub fn s3_backup_description(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationDescription> {
        self.s3_backup_description.as_ref()
    }
    /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
    /// the Parquet or ORC format before writing it to Amazon S3.</p>
    pub fn data_format_conversion_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataFormatConversionConfiguration> {
        self.data_format_conversion_configuration.as_ref()
    }
    /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
    /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
    /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
    /// </p>
    pub fn dynamic_partitioning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DynamicPartitioningConfiguration> {
        self.dynamic_partitioning_configuration.as_ref()
    }
}
impl std::fmt::Debug for ExtendedS3DestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtendedS3DestinationDescription");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("prefix", &self.prefix);
        formatter.field("error_output_prefix", &self.error_output_prefix);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("compression_format", &self.compression_format);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_backup_description", &self.s3_backup_description);
        formatter.field(
            "data_format_conversion_configuration",
            &self.data_format_conversion_configuration,
        );
        formatter.field(
            "dynamic_partitioning_configuration",
            &self.dynamic_partitioning_configuration,
        );
        formatter.finish()
    }
}
/// See [`ExtendedS3DestinationDescription`](crate::model::ExtendedS3DestinationDescription)
pub mod extended_s3_destination_description {
    /// A builder for [`ExtendedS3DestinationDescription`](crate::model::ExtendedS3DestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) error_output_prefix: std::option::Option<std::string::String>,
        pub(crate) buffering_hints: std::option::Option<crate::model::BufferingHints>,
        pub(crate) compression_format: std::option::Option<crate::model::CompressionFormat>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::S3BackupMode>,
        pub(crate) s3_backup_description:
            std::option::Option<crate::model::S3DestinationDescription>,
        pub(crate) data_format_conversion_configuration:
            std::option::Option<crate::model::DataFormatConversionConfiguration>,
        pub(crate) dynamic_partitioning_configuration:
            std::option::Option<crate::model::DynamicPartitioningConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn error_output_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_output_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_error_output_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_output_prefix = input;
            self
        }
        /// <p>The buffering option.</p>
        pub fn buffering_hints(mut self, input: crate::model::BufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering option.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::BufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        pub fn compression_format(mut self, input: crate::model::CompressionFormat) -> Self {
            self.compression_format = Some(input);
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        pub fn set_compression_format(
            mut self,
            input: std::option::Option<crate::model::CompressionFormat>,
        ) -> Self {
            self.compression_format = input;
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon S3 backup mode.</p>
        pub fn s3_backup_mode(mut self, input: crate::model::S3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>The Amazon S3 backup mode.</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::S3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn s3_backup_description(
            mut self,
            input: crate::model::S3DestinationDescription,
        ) -> Self {
            self.s3_backup_description = Some(input);
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn set_s3_backup_description(
            mut self,
            input: std::option::Option<crate::model::S3DestinationDescription>,
        ) -> Self {
            self.s3_backup_description = input;
            self
        }
        /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
        /// the Parquet or ORC format before writing it to Amazon S3.</p>
        pub fn data_format_conversion_configuration(
            mut self,
            input: crate::model::DataFormatConversionConfiguration,
        ) -> Self {
            self.data_format_conversion_configuration = Some(input);
            self
        }
        /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
        /// the Parquet or ORC format before writing it to Amazon S3.</p>
        pub fn set_data_format_conversion_configuration(
            mut self,
            input: std::option::Option<crate::model::DataFormatConversionConfiguration>,
        ) -> Self {
            self.data_format_conversion_configuration = input;
            self
        }
        /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
        /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
        /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
        /// </p>
        pub fn dynamic_partitioning_configuration(
            mut self,
            input: crate::model::DynamicPartitioningConfiguration,
        ) -> Self {
            self.dynamic_partitioning_configuration = Some(input);
            self
        }
        /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
        /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
        /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
        /// </p>
        pub fn set_dynamic_partitioning_configuration(
            mut self,
            input: std::option::Option<crate::model::DynamicPartitioningConfiguration>,
        ) -> Self {
            self.dynamic_partitioning_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtendedS3DestinationDescription`](crate::model::ExtendedS3DestinationDescription)
        pub fn build(self) -> crate::model::ExtendedS3DestinationDescription {
            crate::model::ExtendedS3DestinationDescription {
                role_arn: self.role_arn,
                bucket_arn: self.bucket_arn,
                prefix: self.prefix,
                error_output_prefix: self.error_output_prefix,
                buffering_hints: self.buffering_hints,
                compression_format: self.compression_format,
                encryption_configuration: self.encryption_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                processing_configuration: self.processing_configuration,
                s3_backup_mode: self.s3_backup_mode,
                s3_backup_description: self.s3_backup_description,
                data_format_conversion_configuration: self.data_format_conversion_configuration,
                dynamic_partitioning_configuration: self.dynamic_partitioning_configuration,
            }
        }
    }
}
impl ExtendedS3DestinationDescription {
    /// Creates a new builder-style object to manufacture [`ExtendedS3DestinationDescription`](crate::model::ExtendedS3DestinationDescription)
    pub fn builder() -> crate::model::extended_s3_destination_description::Builder {
        crate::model::extended_s3_destination_description::Builder::default()
    }
}

/// <p>Details about a Kinesis data stream used as the source for a Kinesis Data Firehose
/// delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceDescription {
    /// <p>The <a>KinesisStreamSourceDescription</a> value for the source Kinesis
    /// data stream.</p>
    pub kinesis_stream_source_description:
        std::option::Option<crate::model::KinesisStreamSourceDescription>,
}
impl SourceDescription {
    /// <p>The <a>KinesisStreamSourceDescription</a> value for the source Kinesis
    /// data stream.</p>
    pub fn kinesis_stream_source_description(
        &self,
    ) -> std::option::Option<&crate::model::KinesisStreamSourceDescription> {
        self.kinesis_stream_source_description.as_ref()
    }
}
impl std::fmt::Debug for SourceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceDescription");
        formatter.field(
            "kinesis_stream_source_description",
            &self.kinesis_stream_source_description,
        );
        formatter.finish()
    }
}
/// See [`SourceDescription`](crate::model::SourceDescription)
pub mod source_description {
    /// A builder for [`SourceDescription`](crate::model::SourceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kinesis_stream_source_description:
            std::option::Option<crate::model::KinesisStreamSourceDescription>,
    }
    impl Builder {
        /// <p>The <a>KinesisStreamSourceDescription</a> value for the source Kinesis
        /// data stream.</p>
        pub fn kinesis_stream_source_description(
            mut self,
            input: crate::model::KinesisStreamSourceDescription,
        ) -> Self {
            self.kinesis_stream_source_description = Some(input);
            self
        }
        /// <p>The <a>KinesisStreamSourceDescription</a> value for the source Kinesis
        /// data stream.</p>
        pub fn set_kinesis_stream_source_description(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamSourceDescription>,
        ) -> Self {
            self.kinesis_stream_source_description = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceDescription`](crate::model::SourceDescription)
        pub fn build(self) -> crate::model::SourceDescription {
            crate::model::SourceDescription {
                kinesis_stream_source_description: self.kinesis_stream_source_description,
            }
        }
    }
}
impl SourceDescription {
    /// Creates a new builder-style object to manufacture [`SourceDescription`](crate::model::SourceDescription)
    pub fn builder() -> crate::model::source_description::Builder {
        crate::model::source_description::Builder::default()
    }
}

/// <p>Details about a Kinesis data stream used as the source for a Kinesis Data Firehose
/// delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamSourceDescription {
    /// <p>The Amazon Resource Name (ARN) of the source Kinesis data stream. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
    /// Kinesis Data Streams ARN Format</a>.</p>
    pub kinesis_stream_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the role used by the source Kinesis data stream. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
    /// Access Management (IAM) ARN Format</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Kinesis Data Firehose starts retrieving records from the Kinesis data stream starting
    /// with this timestamp.</p>
    pub delivery_start_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl KinesisStreamSourceDescription {
    /// <p>The Amazon Resource Name (ARN) of the source Kinesis data stream. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
    /// Kinesis Data Streams ARN Format</a>.</p>
    pub fn kinesis_stream_arn(&self) -> std::option::Option<&str> {
        self.kinesis_stream_arn.as_deref()
    }
    /// <p>The ARN of the role used by the source Kinesis data stream. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
    /// Access Management (IAM) ARN Format</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Kinesis Data Firehose starts retrieving records from the Kinesis data stream starting
    /// with this timestamp.</p>
    pub fn delivery_start_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.delivery_start_timestamp.as_ref()
    }
}
impl std::fmt::Debug for KinesisStreamSourceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamSourceDescription");
        formatter.field("kinesis_stream_arn", &self.kinesis_stream_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("delivery_start_timestamp", &self.delivery_start_timestamp);
        formatter.finish()
    }
}
/// See [`KinesisStreamSourceDescription`](crate::model::KinesisStreamSourceDescription)
pub mod kinesis_stream_source_description {
    /// A builder for [`KinesisStreamSourceDescription`](crate::model::KinesisStreamSourceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kinesis_stream_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) delivery_start_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the source Kinesis data stream. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
        /// Kinesis Data Streams ARN Format</a>.</p>
        pub fn kinesis_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kinesis_stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source Kinesis data stream. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
        /// Kinesis Data Streams ARN Format</a>.</p>
        pub fn set_kinesis_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kinesis_stream_arn = input;
            self
        }
        /// <p>The ARN of the role used by the source Kinesis data stream. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
        /// Access Management (IAM) ARN Format</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role used by the source Kinesis data stream. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
        /// Access Management (IAM) ARN Format</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Kinesis Data Firehose starts retrieving records from the Kinesis data stream starting
        /// with this timestamp.</p>
        pub fn delivery_start_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.delivery_start_timestamp = Some(input);
            self
        }
        /// <p>Kinesis Data Firehose starts retrieving records from the Kinesis data stream starting
        /// with this timestamp.</p>
        pub fn set_delivery_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.delivery_start_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamSourceDescription`](crate::model::KinesisStreamSourceDescription)
        pub fn build(self) -> crate::model::KinesisStreamSourceDescription {
            crate::model::KinesisStreamSourceDescription {
                kinesis_stream_arn: self.kinesis_stream_arn,
                role_arn: self.role_arn,
                delivery_start_timestamp: self.delivery_start_timestamp,
            }
        }
    }
}
impl KinesisStreamSourceDescription {
    /// Creates a new builder-style object to manufacture [`KinesisStreamSourceDescription`](crate::model::KinesisStreamSourceDescription)
    pub fn builder() -> crate::model::kinesis_stream_source_description::Builder {
        crate::model::kinesis_stream_source_description::Builder::default()
    }
}

/// <p>Contains information about the server-side encryption (SSE) status for the delivery
/// stream, the type customer master key (CMK) in use, if any, and the ARN of the CMK. You can
/// get <code>DeliveryStreamEncryptionConfiguration</code> by invoking the <a>DescribeDeliveryStream</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliveryStreamEncryptionConfiguration {
    /// <p>If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the
    /// ARN of the customer managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>,
    /// <code>DeliveryStreamEncryptionConfiguration</code> doesn't contain a value for
    /// <code>KeyARN</code>.</p>
    pub key_arn: std::option::Option<std::string::String>,
    /// <p>Indicates the type of customer master key (CMK) that is used for encryption. The default
    /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
    /// Master Keys (CMKs)</a>.</p>
    pub key_type: std::option::Option<crate::model::KeyType>,
    /// <p>This is the server-side encryption (SSE) status for the delivery stream. For a full
    /// description of the different values of this status, see <a>StartDeliveryStreamEncryption</a> and <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code>
    /// or <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or
    /// disable SSE, respectively.</p>
    pub status: std::option::Option<crate::model::DeliveryStreamEncryptionStatus>,
    /// <p>Provides details in case one of the following operations fails due to an error related
    /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
    /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
    pub failure_description: std::option::Option<crate::model::FailureDescription>,
}
impl DeliveryStreamEncryptionConfiguration {
    /// <p>If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the
    /// ARN of the customer managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>,
    /// <code>DeliveryStreamEncryptionConfiguration</code> doesn't contain a value for
    /// <code>KeyARN</code>.</p>
    pub fn key_arn(&self) -> std::option::Option<&str> {
        self.key_arn.as_deref()
    }
    /// <p>Indicates the type of customer master key (CMK) that is used for encryption. The default
    /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
    /// Master Keys (CMKs)</a>.</p>
    pub fn key_type(&self) -> std::option::Option<&crate::model::KeyType> {
        self.key_type.as_ref()
    }
    /// <p>This is the server-side encryption (SSE) status for the delivery stream. For a full
    /// description of the different values of this status, see <a>StartDeliveryStreamEncryption</a> and <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code>
    /// or <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or
    /// disable SSE, respectively.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeliveryStreamEncryptionStatus> {
        self.status.as_ref()
    }
    /// <p>Provides details in case one of the following operations fails due to an error related
    /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
    /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
    pub fn failure_description(&self) -> std::option::Option<&crate::model::FailureDescription> {
        self.failure_description.as_ref()
    }
}
impl std::fmt::Debug for DeliveryStreamEncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliveryStreamEncryptionConfiguration");
        formatter.field("key_arn", &self.key_arn);
        formatter.field("key_type", &self.key_type);
        formatter.field("status", &self.status);
        formatter.field("failure_description", &self.failure_description);
        formatter.finish()
    }
}
/// See [`DeliveryStreamEncryptionConfiguration`](crate::model::DeliveryStreamEncryptionConfiguration)
pub mod delivery_stream_encryption_configuration {
    /// A builder for [`DeliveryStreamEncryptionConfiguration`](crate::model::DeliveryStreamEncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_arn: std::option::Option<std::string::String>,
        pub(crate) key_type: std::option::Option<crate::model::KeyType>,
        pub(crate) status: std::option::Option<crate::model::DeliveryStreamEncryptionStatus>,
        pub(crate) failure_description: std::option::Option<crate::model::FailureDescription>,
    }
    impl Builder {
        /// <p>If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the
        /// ARN of the customer managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>,
        /// <code>DeliveryStreamEncryptionConfiguration</code> doesn't contain a value for
        /// <code>KeyARN</code>.</p>
        pub fn key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_arn = Some(input.into());
            self
        }
        /// <p>If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the
        /// ARN of the customer managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>,
        /// <code>DeliveryStreamEncryptionConfiguration</code> doesn't contain a value for
        /// <code>KeyARN</code>.</p>
        pub fn set_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_arn = input;
            self
        }
        /// <p>Indicates the type of customer master key (CMK) that is used for encryption. The default
        /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
        /// Master Keys (CMKs)</a>.</p>
        pub fn key_type(mut self, input: crate::model::KeyType) -> Self {
            self.key_type = Some(input);
            self
        }
        /// <p>Indicates the type of customer master key (CMK) that is used for encryption. The default
        /// setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
        /// Master Keys (CMKs)</a>.</p>
        pub fn set_key_type(mut self, input: std::option::Option<crate::model::KeyType>) -> Self {
            self.key_type = input;
            self
        }
        /// <p>This is the server-side encryption (SSE) status for the delivery stream. For a full
        /// description of the different values of this status, see <a>StartDeliveryStreamEncryption</a> and <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code>
        /// or <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or
        /// disable SSE, respectively.</p>
        pub fn status(mut self, input: crate::model::DeliveryStreamEncryptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>This is the server-side encryption (SSE) status for the delivery stream. For a full
        /// description of the different values of this status, see <a>StartDeliveryStreamEncryption</a> and <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code>
        /// or <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or
        /// disable SSE, respectively.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamEncryptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides details in case one of the following operations fails due to an error related
        /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
        /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
        pub fn failure_description(mut self, input: crate::model::FailureDescription) -> Self {
            self.failure_description = Some(input);
            self
        }
        /// <p>Provides details in case one of the following operations fails due to an error related
        /// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
        /// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
        pub fn set_failure_description(
            mut self,
            input: std::option::Option<crate::model::FailureDescription>,
        ) -> Self {
            self.failure_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliveryStreamEncryptionConfiguration`](crate::model::DeliveryStreamEncryptionConfiguration)
        pub fn build(self) -> crate::model::DeliveryStreamEncryptionConfiguration {
            crate::model::DeliveryStreamEncryptionConfiguration {
                key_arn: self.key_arn,
                key_type: self.key_type,
                status: self.status,
                failure_description: self.failure_description,
            }
        }
    }
}
impl DeliveryStreamEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`DeliveryStreamEncryptionConfiguration`](crate::model::DeliveryStreamEncryptionConfiguration)
    pub fn builder() -> crate::model::delivery_stream_encryption_configuration::Builder {
        crate::model::delivery_stream_encryption_configuration::Builder::default()
    }
}

/// <p>Provides details in case one of the following operations fails due to an error related
/// to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>,
/// <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureDescription {
    /// <p>The type of error that caused the failure.</p>
    pub r#type: std::option::Option<crate::model::DeliveryStreamFailureType>,
    /// <p>A message providing details about the error that caused the failure.</p>
    pub details: std::option::Option<std::string::String>,
}
impl FailureDescription {
    /// <p>The type of error that caused the failure.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DeliveryStreamFailureType> {
        self.r#type.as_ref()
    }
    /// <p>A message providing details about the error that caused the failure.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for FailureDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureDescription");
        formatter.field("r#type", &self.r#type);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`FailureDescription`](crate::model::FailureDescription)
pub mod failure_description {
    /// A builder for [`FailureDescription`](crate::model::FailureDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DeliveryStreamFailureType>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of error that caused the failure.</p>
        pub fn r#type(mut self, input: crate::model::DeliveryStreamFailureType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of error that caused the failure.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamFailureType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A message providing details about the error that caused the failure.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>A message providing details about the error that caused the failure.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureDescription`](crate::model::FailureDescription)
        pub fn build(self) -> crate::model::FailureDescription {
            crate::model::FailureDescription {
                r#type: self.r#type,
                details: self.details,
            }
        }
    }
}
impl FailureDescription {
    /// Creates a new builder-style object to manufacture [`FailureDescription`](crate::model::FailureDescription)
    pub fn builder() -> crate::model::failure_description::Builder {
        crate::model::failure_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliveryStreamFailureType {
    #[allow(missing_docs)] // documentation missing in model
    CreateEniFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateKmsGrantFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteEniFailed,
    #[allow(missing_docs)] // documentation missing in model
    DisabledKmsKey,
    #[allow(missing_docs)] // documentation missing in model
    EniAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    InvalidKmsKey,
    #[allow(missing_docs)] // documentation missing in model
    KmsAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    KmsKeyNotFound,
    #[allow(missing_docs)] // documentation missing in model
    KmsOptInRequired,
    #[allow(missing_docs)] // documentation missing in model
    RetireKmsGrantFailed,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupNotFound,
    #[allow(missing_docs)] // documentation missing in model
    SubnetAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    SubnetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    UnknownError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliveryStreamFailureType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_ENI_FAILED" => DeliveryStreamFailureType::CreateEniFailed,
            "CREATE_KMS_GRANT_FAILED" => DeliveryStreamFailureType::CreateKmsGrantFailed,
            "DELETE_ENI_FAILED" => DeliveryStreamFailureType::DeleteEniFailed,
            "DISABLED_KMS_KEY" => DeliveryStreamFailureType::DisabledKmsKey,
            "ENI_ACCESS_DENIED" => DeliveryStreamFailureType::EniAccessDenied,
            "INVALID_KMS_KEY" => DeliveryStreamFailureType::InvalidKmsKey,
            "KMS_ACCESS_DENIED" => DeliveryStreamFailureType::KmsAccessDenied,
            "KMS_KEY_NOT_FOUND" => DeliveryStreamFailureType::KmsKeyNotFound,
            "KMS_OPT_IN_REQUIRED" => DeliveryStreamFailureType::KmsOptInRequired,
            "RETIRE_KMS_GRANT_FAILED" => DeliveryStreamFailureType::RetireKmsGrantFailed,
            "SECURITY_GROUP_ACCESS_DENIED" => DeliveryStreamFailureType::SecurityGroupAccessDenied,
            "SECURITY_GROUP_NOT_FOUND" => DeliveryStreamFailureType::SecurityGroupNotFound,
            "SUBNET_ACCESS_DENIED" => DeliveryStreamFailureType::SubnetAccessDenied,
            "SUBNET_NOT_FOUND" => DeliveryStreamFailureType::SubnetNotFound,
            "UNKNOWN_ERROR" => DeliveryStreamFailureType::UnknownError,
            other => DeliveryStreamFailureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliveryStreamFailureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliveryStreamFailureType::from(s))
    }
}
impl DeliveryStreamFailureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliveryStreamFailureType::CreateEniFailed => "CREATE_ENI_FAILED",
            DeliveryStreamFailureType::CreateKmsGrantFailed => "CREATE_KMS_GRANT_FAILED",
            DeliveryStreamFailureType::DeleteEniFailed => "DELETE_ENI_FAILED",
            DeliveryStreamFailureType::DisabledKmsKey => "DISABLED_KMS_KEY",
            DeliveryStreamFailureType::EniAccessDenied => "ENI_ACCESS_DENIED",
            DeliveryStreamFailureType::InvalidKmsKey => "INVALID_KMS_KEY",
            DeliveryStreamFailureType::KmsAccessDenied => "KMS_ACCESS_DENIED",
            DeliveryStreamFailureType::KmsKeyNotFound => "KMS_KEY_NOT_FOUND",
            DeliveryStreamFailureType::KmsOptInRequired => "KMS_OPT_IN_REQUIRED",
            DeliveryStreamFailureType::RetireKmsGrantFailed => "RETIRE_KMS_GRANT_FAILED",
            DeliveryStreamFailureType::SecurityGroupAccessDenied => "SECURITY_GROUP_ACCESS_DENIED",
            DeliveryStreamFailureType::SecurityGroupNotFound => "SECURITY_GROUP_NOT_FOUND",
            DeliveryStreamFailureType::SubnetAccessDenied => "SUBNET_ACCESS_DENIED",
            DeliveryStreamFailureType::SubnetNotFound => "SUBNET_NOT_FOUND",
            DeliveryStreamFailureType::UnknownError => "UNKNOWN_ERROR",
            DeliveryStreamFailureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_ENI_FAILED",
            "CREATE_KMS_GRANT_FAILED",
            "DELETE_ENI_FAILED",
            "DISABLED_KMS_KEY",
            "ENI_ACCESS_DENIED",
            "INVALID_KMS_KEY",
            "KMS_ACCESS_DENIED",
            "KMS_KEY_NOT_FOUND",
            "KMS_OPT_IN_REQUIRED",
            "RETIRE_KMS_GRANT_FAILED",
            "SECURITY_GROUP_ACCESS_DENIED",
            "SECURITY_GROUP_NOT_FOUND",
            "SUBNET_ACCESS_DENIED",
            "SUBNET_NOT_FOUND",
            "UNKNOWN_ERROR",
        ]
    }
}
impl AsRef<str> for DeliveryStreamFailureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliveryStreamEncryptionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    DisablingFailed,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    #[allow(missing_docs)] // documentation missing in model
    EnablingFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliveryStreamEncryptionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DeliveryStreamEncryptionStatus::Disabled,
            "DISABLING" => DeliveryStreamEncryptionStatus::Disabling,
            "DISABLING_FAILED" => DeliveryStreamEncryptionStatus::DisablingFailed,
            "ENABLED" => DeliveryStreamEncryptionStatus::Enabled,
            "ENABLING" => DeliveryStreamEncryptionStatus::Enabling,
            "ENABLING_FAILED" => DeliveryStreamEncryptionStatus::EnablingFailed,
            other => DeliveryStreamEncryptionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliveryStreamEncryptionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliveryStreamEncryptionStatus::from(s))
    }
}
impl DeliveryStreamEncryptionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliveryStreamEncryptionStatus::Disabled => "DISABLED",
            DeliveryStreamEncryptionStatus::Disabling => "DISABLING",
            DeliveryStreamEncryptionStatus::DisablingFailed => "DISABLING_FAILED",
            DeliveryStreamEncryptionStatus::Enabled => "ENABLED",
            DeliveryStreamEncryptionStatus::Enabling => "ENABLING",
            DeliveryStreamEncryptionStatus::EnablingFailed => "ENABLING_FAILED",
            DeliveryStreamEncryptionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DISABLED",
            "DISABLING",
            "DISABLING_FAILED",
            "ENABLED",
            "ENABLING",
            "ENABLING_FAILED",
        ]
    }
}
impl AsRef<str> for DeliveryStreamEncryptionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliveryStreamStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    CreatingFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    DeletingFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliveryStreamStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DeliveryStreamStatus::Active,
            "CREATING" => DeliveryStreamStatus::Creating,
            "CREATING_FAILED" => DeliveryStreamStatus::CreatingFailed,
            "DELETING" => DeliveryStreamStatus::Deleting,
            "DELETING_FAILED" => DeliveryStreamStatus::DeletingFailed,
            other => DeliveryStreamStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliveryStreamStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliveryStreamStatus::from(s))
    }
}
impl DeliveryStreamStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliveryStreamStatus::Active => "ACTIVE",
            DeliveryStreamStatus::Creating => "CREATING",
            DeliveryStreamStatus::CreatingFailed => "CREATING_FAILED",
            DeliveryStreamStatus::Deleting => "DELETING",
            DeliveryStreamStatus::DeletingFailed => "DELETING_FAILED",
            DeliveryStreamStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "CREATING_FAILED",
            "DELETING",
            "DELETING_FAILED",
        ]
    }
}
impl AsRef<str> for DeliveryStreamStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the configuration of the HTTP endpoint destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpEndpointDestinationConfiguration {
    /// <p>The configuration of the HTTP endpoint selected as the destination.</p>
    pub endpoint_configuration: std::option::Option<crate::model::HttpEndpointConfiguration>,
    /// <p>The buffering options that can be used before data is delivered to the specified
    /// destination. Kinesis Data Firehose treats these options as hints, and it might choose to
    /// use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code>
    /// parameters are optional. However, if you specify a value for one of them, you must also
    /// provide a value for the other. </p>
    pub buffering_hints: std::option::Option<crate::model::HttpEndpointBufferingHints>,
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The configuration of the requeste sent to the HTTP endpoint specified as the
    /// destination.</p>
    pub request_configuration: std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
    /// <p>Describes a data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
    /// stream needs.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
    /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
    /// receipt from the specified HTTP endpoint destination.</p>
    pub retry_options: std::option::Option<crate::model::HttpEndpointRetryOptions>,
    /// <p>Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers
    /// to the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or
    /// only the documents that Kinesis Data Firehose could not deliver to the specified HTTP
    /// endpoint destination (<code>FailedDataOnly</code>).</p>
    pub s3_backup_mode: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
    /// <p>Describes the configuration of a destination in Amazon S3.</p>
    pub s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
}
impl HttpEndpointDestinationConfiguration {
    /// <p>The configuration of the HTTP endpoint selected as the destination.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>The buffering options that can be used before data is delivered to the specified
    /// destination. Kinesis Data Firehose treats these options as hints, and it might choose to
    /// use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code>
    /// parameters are optional. However, if you specify a value for one of them, you must also
    /// provide a value for the other. </p>
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointBufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The configuration of the requeste sent to the HTTP endpoint specified as the
    /// destination.</p>
    pub fn request_configuration(
        &self,
    ) -> std::option::Option<&crate::model::HttpEndpointRequestConfiguration> {
        self.request_configuration.as_ref()
    }
    /// <p>Describes a data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
    /// stream needs.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
    /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
    /// receipt from the specified HTTP endpoint destination.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::HttpEndpointRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers
    /// to the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or
    /// only the documents that Kinesis Data Firehose could not deliver to the specified HTTP
    /// endpoint destination (<code>FailedDataOnly</code>).</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::HttpEndpointS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>Describes the configuration of a destination in Amazon S3.</p>
    pub fn s3_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_configuration.as_ref()
    }
}
impl std::fmt::Debug for HttpEndpointDestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpEndpointDestinationConfiguration");
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("request_configuration", &self.request_configuration);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_configuration", &self.s3_configuration);
        formatter.finish()
    }
}
/// See [`HttpEndpointDestinationConfiguration`](crate::model::HttpEndpointDestinationConfiguration)
pub mod http_endpoint_destination_configuration {
    /// A builder for [`HttpEndpointDestinationConfiguration`](crate::model::HttpEndpointDestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_configuration:
            std::option::Option<crate::model::HttpEndpointConfiguration>,
        pub(crate) buffering_hints: std::option::Option<crate::model::HttpEndpointBufferingHints>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) request_configuration:
            std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) retry_options: std::option::Option<crate::model::HttpEndpointRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
        pub(crate) s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    }
    impl Builder {
        /// <p>The configuration of the HTTP endpoint selected as the destination.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::HttpEndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The configuration of the HTTP endpoint selected as the destination.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>The buffering options that can be used before data is delivered to the specified
        /// destination. Kinesis Data Firehose treats these options as hints, and it might choose to
        /// use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code>
        /// parameters are optional. However, if you specify a value for one of them, you must also
        /// provide a value for the other. </p>
        pub fn buffering_hints(mut self, input: crate::model::HttpEndpointBufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering options that can be used before data is delivered to the specified
        /// destination. Kinesis Data Firehose treats these options as hints, and it might choose to
        /// use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code>
        /// parameters are optional. However, if you specify a value for one of them, you must also
        /// provide a value for the other. </p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The configuration of the requeste sent to the HTTP endpoint specified as the
        /// destination.</p>
        pub fn request_configuration(
            mut self,
            input: crate::model::HttpEndpointRequestConfiguration,
        ) -> Self {
            self.request_configuration = Some(input);
            self
        }
        /// <p>The configuration of the requeste sent to the HTTP endpoint specified as the
        /// destination.</p>
        pub fn set_request_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointRequestConfiguration>,
        ) -> Self {
            self.request_configuration = input;
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
        /// stream needs.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery
        /// stream needs.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
        /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
        /// receipt from the specified HTTP endpoint destination.</p>
        pub fn retry_options(mut self, input: crate::model::HttpEndpointRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to
        /// the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of
        /// receipt from the specified HTTP endpoint destination.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers
        /// to the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or
        /// only the documents that Kinesis Data Firehose could not deliver to the specified HTTP
        /// endpoint destination (<code>FailedDataOnly</code>).</p>
        pub fn s3_backup_mode(mut self, input: crate::model::HttpEndpointS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers
        /// to the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or
        /// only the documents that Kinesis Data Firehose could not deliver to the specified HTTP
        /// endpoint destination (<code>FailedDataOnly</code>).</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>Describes the configuration of a destination in Amazon S3.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3DestinationConfiguration) -> Self {
            self.s3_configuration = Some(input);
            self
        }
        /// <p>Describes the configuration of a destination in Amazon S3.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpEndpointDestinationConfiguration`](crate::model::HttpEndpointDestinationConfiguration)
        pub fn build(self) -> crate::model::HttpEndpointDestinationConfiguration {
            crate::model::HttpEndpointDestinationConfiguration {
                endpoint_configuration: self.endpoint_configuration,
                buffering_hints: self.buffering_hints,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                request_configuration: self.request_configuration,
                processing_configuration: self.processing_configuration,
                role_arn: self.role_arn,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_configuration: self.s3_configuration,
            }
        }
    }
}
impl HttpEndpointDestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`HttpEndpointDestinationConfiguration`](crate::model::HttpEndpointDestinationConfiguration)
    pub fn builder() -> crate::model::http_endpoint_destination_configuration::Builder {
        crate::model::http_endpoint_destination_configuration::Builder::default()
    }
}

/// <p>Describes the configuration of a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub error_output_prefix: std::option::Option<std::string::String>,
    /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
    /// default values are used.</p>
    pub buffering_hints: std::option::Option<crate::model::BufferingHints>,
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
    /// <code>COPY</code> operation that reads from the S3 bucket.</p>
    pub compression_format: std::option::Option<crate::model::CompressionFormat>,
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl S3DestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn error_output_prefix(&self) -> std::option::Option<&str> {
        self.error_output_prefix.as_deref()
    }
    /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
    /// default values are used.</p>
    pub fn buffering_hints(&self) -> std::option::Option<&crate::model::BufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The compression format. If no value is specified, the default is
    /// <code>UNCOMPRESSED</code>.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
    /// <code>COPY</code> operation that reads from the S3 bucket.</p>
    pub fn compression_format(&self) -> std::option::Option<&crate::model::CompressionFormat> {
        self.compression_format.as_ref()
    }
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for S3DestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("prefix", &self.prefix);
        formatter.field("error_output_prefix", &self.error_output_prefix);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("compression_format", &self.compression_format);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
pub mod s3_destination_configuration {
    /// A builder for [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) error_output_prefix: std::option::Option<std::string::String>,
        pub(crate) buffering_hints: std::option::Option<crate::model::BufferingHints>,
        pub(crate) compression_format: std::option::Option<crate::model::CompressionFormat>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn error_output_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_output_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_error_output_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_output_prefix = input;
            self
        }
        /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
        /// default values are used.</p>
        pub fn buffering_hints(mut self, input: crate::model::BufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering option. If no value is specified, <code>BufferingHints</code> object
        /// default values are used.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::BufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
        /// <code>COPY</code> operation that reads from the S3 bucket.</p>
        pub fn compression_format(mut self, input: crate::model::CompressionFormat) -> Self {
            self.compression_format = Some(input);
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// <code>UNCOMPRESSED</code>.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// for Amazon Redshift destinations because they are not supported by the Amazon Redshift
        /// <code>COPY</code> operation that reads from the S3 bucket.</p>
        pub fn set_compression_format(
            mut self,
            input: std::option::Option<crate::model::CompressionFormat>,
        ) -> Self {
            self.compression_format = input;
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
        pub fn build(self) -> crate::model::S3DestinationConfiguration {
            crate::model::S3DestinationConfiguration {
                role_arn: self.role_arn,
                bucket_arn: self.bucket_arn,
                prefix: self.prefix,
                error_output_prefix: self.error_output_prefix,
                buffering_hints: self.buffering_hints,
                compression_format: self.compression_format,
                encryption_configuration: self.encryption_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl S3DestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
    pub fn builder() -> crate::model::s3_destination_configuration::Builder {
        crate::model::s3_destination_configuration::Builder::default()
    }
}

/// <p>Describes the configuration of a destination in Splunk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SplunkDestinationConfiguration {
    /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
    /// data.</p>
    pub hec_endpoint: std::option::Option<std::string::String>,
    /// <p>This type can be either "Raw" or "Event."</p>
    pub hec_endpoint_type: std::option::Option<crate::model::HecEndpointType>,
    /// <p>This is a GUID that you obtain from your Splunk cluster when you create a new HEC
    /// endpoint.</p>
    pub hec_token: std::option::Option<std::string::String>,
    /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
    /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
    /// either tries to send the data again or considers it an error, based on your retry
    /// settings.</p>
    pub hec_acknowledgment_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk,
    /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
    pub retry_options: std::option::Option<crate::model::SplunkRetryOptions>,
    /// <p>Defines how documents should be delivered to Amazon S3. When set to
    /// <code>FailedEventsOnly</code>, Kinesis Data Firehose writes any data that could not be
    /// indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
    /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
    /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
    /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
    /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
    /// <code>FailedEventsOnly</code>.</p>
    pub s3_backup_mode: std::option::Option<crate::model::SplunkS3BackupMode>,
    /// <p>The configuration for the backup Amazon S3 location.</p>
    pub s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl SplunkDestinationConfiguration {
    /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
    /// data.</p>
    pub fn hec_endpoint(&self) -> std::option::Option<&str> {
        self.hec_endpoint.as_deref()
    }
    /// <p>This type can be either "Raw" or "Event."</p>
    pub fn hec_endpoint_type(&self) -> std::option::Option<&crate::model::HecEndpointType> {
        self.hec_endpoint_type.as_ref()
    }
    /// <p>This is a GUID that you obtain from your Splunk cluster when you create a new HEC
    /// endpoint.</p>
    pub fn hec_token(&self) -> std::option::Option<&str> {
        self.hec_token.as_deref()
    }
    /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
    /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
    /// either tries to send the data again or considers it an error, based on your retry
    /// settings.</p>
    pub fn hec_acknowledgment_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.hec_acknowledgment_timeout_in_seconds
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk,
    /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::SplunkRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Defines how documents should be delivered to Amazon S3. When set to
    /// <code>FailedEventsOnly</code>, Kinesis Data Firehose writes any data that could not be
    /// indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
    /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
    /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
    /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
    /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
    /// <code>FailedEventsOnly</code>.</p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::SplunkS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The configuration for the backup Amazon S3 location.</p>
    pub fn s3_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_configuration.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for SplunkDestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SplunkDestinationConfiguration");
        formatter.field("hec_endpoint", &self.hec_endpoint);
        formatter.field("hec_endpoint_type", &self.hec_endpoint_type);
        formatter.field("hec_token", &self.hec_token);
        formatter.field(
            "hec_acknowledgment_timeout_in_seconds",
            &self.hec_acknowledgment_timeout_in_seconds,
        );
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_configuration", &self.s3_configuration);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`SplunkDestinationConfiguration`](crate::model::SplunkDestinationConfiguration)
pub mod splunk_destination_configuration {
    /// A builder for [`SplunkDestinationConfiguration`](crate::model::SplunkDestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hec_endpoint: std::option::Option<std::string::String>,
        pub(crate) hec_endpoint_type: std::option::Option<crate::model::HecEndpointType>,
        pub(crate) hec_token: std::option::Option<std::string::String>,
        pub(crate) hec_acknowledgment_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) retry_options: std::option::Option<crate::model::SplunkRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::SplunkS3BackupMode>,
        pub(crate) s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
        /// data.</p>
        pub fn hec_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.hec_endpoint = Some(input.into());
            self
        }
        /// <p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your
        /// data.</p>
        pub fn set_hec_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hec_endpoint = input;
            self
        }
        /// <p>This type can be either "Raw" or "Event."</p>
        pub fn hec_endpoint_type(mut self, input: crate::model::HecEndpointType) -> Self {
            self.hec_endpoint_type = Some(input);
            self
        }
        /// <p>This type can be either "Raw" or "Event."</p>
        pub fn set_hec_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::HecEndpointType>,
        ) -> Self {
            self.hec_endpoint_type = input;
            self
        }
        /// <p>This is a GUID that you obtain from your Splunk cluster when you create a new HEC
        /// endpoint.</p>
        pub fn hec_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.hec_token = Some(input.into());
            self
        }
        /// <p>This is a GUID that you obtain from your Splunk cluster when you create a new HEC
        /// endpoint.</p>
        pub fn set_hec_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hec_token = input;
            self
        }
        /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
        /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
        /// either tries to send the data again or considers it an error, based on your retry
        /// settings.</p>
        pub fn hec_acknowledgment_timeout_in_seconds(mut self, input: i32) -> Self {
            self.hec_acknowledgment_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from
        /// Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose
        /// either tries to send the data again or considers it an error, based on your retry
        /// settings.</p>
        pub fn set_hec_acknowledgment_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.hec_acknowledgment_timeout_in_seconds = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk,
        /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
        pub fn retry_options(mut self, input: crate::model::SplunkRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk,
        /// or if it doesn't receive an acknowledgment of receipt from Splunk.</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::SplunkRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Defines how documents should be delivered to Amazon S3. When set to
        /// <code>FailedEventsOnly</code>, Kinesis Data Firehose writes any data that could not be
        /// indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
        /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
        /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
        /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
        /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
        /// <code>FailedEventsOnly</code>.</p>
        pub fn s3_backup_mode(mut self, input: crate::model::SplunkS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>Defines how documents should be delivered to Amazon S3. When set to
        /// <code>FailedEventsOnly</code>, Kinesis Data Firehose writes any data that could not be
        /// indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>,
        /// Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed
        /// documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p>
        /// <p>You can update this backup mode from <code>FailedEventsOnly</code> to
        /// <code>AllEvents</code>. You can't update it from <code>AllEvents</code> to
        /// <code>FailedEventsOnly</code>.</p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::SplunkS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The configuration for the backup Amazon S3 location.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3DestinationConfiguration) -> Self {
            self.s3_configuration = Some(input);
            self
        }
        /// <p>The configuration for the backup Amazon S3 location.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_configuration = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`SplunkDestinationConfiguration`](crate::model::SplunkDestinationConfiguration)
        pub fn build(self) -> crate::model::SplunkDestinationConfiguration {
            crate::model::SplunkDestinationConfiguration {
                hec_endpoint: self.hec_endpoint,
                hec_endpoint_type: self.hec_endpoint_type,
                hec_token: self.hec_token,
                hec_acknowledgment_timeout_in_seconds: self.hec_acknowledgment_timeout_in_seconds,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_configuration: self.s3_configuration,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl SplunkDestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`SplunkDestinationConfiguration`](crate::model::SplunkDestinationConfiguration)
    pub fn builder() -> crate::model::splunk_destination_configuration::Builder {
        crate::model::splunk_destination_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonopensearchserviceDestinationConfiguration {
    #[allow(missing_docs)] // documentation missing in model
    pub role_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub domain_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub cluster_endpoint: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub index_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub type_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub index_rotation_period:
        std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
    #[allow(missing_docs)] // documentation missing in model
    pub buffering_hints: std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
    #[allow(missing_docs)] // documentation missing in model
    pub retry_options: std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
    #[allow(missing_docs)] // documentation missing in model
    pub s3_backup_mode: std::option::Option<crate::model::AmazonopensearchserviceS3BackupMode>,
    /// <p>Describes the configuration of a destination in Amazon S3.</p>
    pub s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    /// <p>Describes a data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
}
impl AmazonopensearchserviceDestinationConfiguration {
    #[allow(missing_docs)] // documentation missing in model
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn domain_arn(&self) -> std::option::Option<&str> {
        self.domain_arn.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn cluster_endpoint(&self) -> std::option::Option<&str> {
        self.cluster_endpoint.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn index_rotation_period(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceIndexRotationPeriod> {
        self.index_rotation_period.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceBufferingHints> {
        self.buffering_hints.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn retry_options(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceRetryOptions> {
        self.retry_options.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn s3_backup_mode(
        &self,
    ) -> std::option::Option<&crate::model::AmazonopensearchserviceS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>Describes the configuration of a destination in Amazon S3.</p>
    pub fn s3_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_configuration.as_ref()
    }
    /// <p>Describes a data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub fn vpc_configuration(&self) -> std::option::Option<&crate::model::VpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
}
impl std::fmt::Debug for AmazonopensearchserviceDestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonopensearchserviceDestinationConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("domain_arn", &self.domain_arn);
        formatter.field("cluster_endpoint", &self.cluster_endpoint);
        formatter.field("index_name", &self.index_name);
        formatter.field("type_name", &self.type_name);
        formatter.field("index_rotation_period", &self.index_rotation_period);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_configuration", &self.s3_configuration);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.finish()
    }
}
/// See [`AmazonopensearchserviceDestinationConfiguration`](crate::model::AmazonopensearchserviceDestinationConfiguration)
pub mod amazonopensearchservice_destination_configuration {
    /// A builder for [`AmazonopensearchserviceDestinationConfiguration`](crate::model::AmazonopensearchserviceDestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_endpoint: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) index_rotation_period:
            std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
        pub(crate) buffering_hints:
            std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
        pub(crate) retry_options:
            std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
        pub(crate) s3_backup_mode:
            std::option::Option<crate::model::AmazonopensearchserviceS3BackupMode>,
        pub(crate) s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn domain_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_domain_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn cluster_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_endpoint = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_cluster_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_endpoint = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn index_rotation_period(
            mut self,
            input: crate::model::AmazonopensearchserviceIndexRotationPeriod,
        ) -> Self {
            self.index_rotation_period = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_index_rotation_period(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceIndexRotationPeriod>,
        ) -> Self {
            self.index_rotation_period = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn buffering_hints(
            mut self,
            input: crate::model::AmazonopensearchserviceBufferingHints,
        ) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_options(
            mut self,
            input: crate::model::AmazonopensearchserviceRetryOptions,
        ) -> Self {
            self.retry_options = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn s3_backup_mode(
            mut self,
            input: crate::model::AmazonopensearchserviceS3BackupMode,
        ) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>Describes the configuration of a destination in Amazon S3.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3DestinationConfiguration) -> Self {
            self.s3_configuration = Some(input);
            self
        }
        /// <p>Describes the configuration of a destination in Amazon S3.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_configuration = input;
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>Describes a data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonopensearchserviceDestinationConfiguration`](crate::model::AmazonopensearchserviceDestinationConfiguration)
        pub fn build(self) -> crate::model::AmazonopensearchserviceDestinationConfiguration {
            crate::model::AmazonopensearchserviceDestinationConfiguration {
                role_arn: self.role_arn,
                domain_arn: self.domain_arn,
                cluster_endpoint: self.cluster_endpoint,
                index_name: self.index_name,
                type_name: self.type_name,
                index_rotation_period: self.index_rotation_period,
                buffering_hints: self.buffering_hints,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_configuration: self.s3_configuration,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                vpc_configuration: self.vpc_configuration,
            }
        }
    }
}
impl AmazonopensearchserviceDestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`AmazonopensearchserviceDestinationConfiguration`](crate::model::AmazonopensearchserviceDestinationConfiguration)
    pub fn builder() -> crate::model::amazonopensearchservice_destination_configuration::Builder {
        crate::model::amazonopensearchservice_destination_configuration::Builder::default()
    }
}

/// <p>The details of the VPC of the Amazon ES destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfiguration {
    /// <p>The IDs of the subnets that you want Kinesis Data Firehose to use to create ENIs in the
    /// VPC of the Amazon ES destination. Make sure that the routing tables and inbound and
    /// outbound rules allow traffic to flow from the subnets whose IDs are specified here to the
    /// subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at
    /// least one ENI in each of the subnets that are specified here. Do not delete or modify these
    /// ENIs.</p>
    /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
    /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
    /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
    /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
    /// three ENIs for this delivery stream for each of the subnets specified here. For more
    /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
    /// </a> in the Amazon VPC Quotas topic.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the IAM role that you want the delivery stream to use to create endpoints in
    /// the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you
    /// can specify a new role. In either case, make sure that the role trusts the Kinesis Data
    /// Firehose service principal and that it grants the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcs</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcAttribute</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSubnets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSecurityGroups</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeNetworkInterfaces</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterface</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterfacePermission</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DeleteNetworkInterface</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
    /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
    /// degradation in performance.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The IDs of the security groups that you want Kinesis Data Firehose to use when it
    /// creates ENIs in the VPC of the Amazon ES destination. You can use the same security group
    /// that the Amazon ES domain uses or different ones. If you specify different security groups
    /// here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security
    /// group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the
    /// security groups specified here. If you use the same security group for both your delivery
    /// stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS
    /// traffic. For more information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
    /// rules</a> in the Amazon VPC documentation.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfiguration {
    /// <p>The IDs of the subnets that you want Kinesis Data Firehose to use to create ENIs in the
    /// VPC of the Amazon ES destination. Make sure that the routing tables and inbound and
    /// outbound rules allow traffic to flow from the subnets whose IDs are specified here to the
    /// subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at
    /// least one ENI in each of the subnets that are specified here. Do not delete or modify these
    /// ENIs.</p>
    /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
    /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
    /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
    /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
    /// three ENIs for this delivery stream for each of the subnets specified here. For more
    /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
    /// </a> in the Amazon VPC Quotas topic.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The ARN of the IAM role that you want the delivery stream to use to create endpoints in
    /// the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you
    /// can specify a new role. In either case, make sure that the role trusts the Kinesis Data
    /// Firehose service principal and that it grants the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcs</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeVpcAttribute</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSubnets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSecurityGroups</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeNetworkInterfaces</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterface</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterfacePermission</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DeleteNetworkInterface</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
    /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
    /// degradation in performance.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The IDs of the security groups that you want Kinesis Data Firehose to use when it
    /// creates ENIs in the VPC of the Amazon ES destination. You can use the same security group
    /// that the Amazon ES domain uses or different ones. If you specify different security groups
    /// here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security
    /// group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the
    /// security groups specified here. If you use the same security group for both your delivery
    /// stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS
    /// traffic. For more information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
    /// rules</a> in the Amazon VPC documentation.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfiguration");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcConfiguration`](crate::model::VpcConfiguration)
pub mod vpc_configuration {
    /// A builder for [`VpcConfiguration`](crate::model::VpcConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets that you want Kinesis Data Firehose to use to create ENIs in the
        /// VPC of the Amazon ES destination. Make sure that the routing tables and inbound and
        /// outbound rules allow traffic to flow from the subnets whose IDs are specified here to the
        /// subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at
        /// least one ENI in each of the subnets that are specified here. Do not delete or modify these
        /// ENIs.</p>
        /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
        /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
        /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
        /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
        /// three ENIs for this delivery stream for each of the subnets specified here. For more
        /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
        /// </a> in the Amazon VPC Quotas topic.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The IDs of the subnets that you want Kinesis Data Firehose to use to create ENIs in the
        /// VPC of the Amazon ES destination. Make sure that the routing tables and inbound and
        /// outbound rules allow traffic to flow from the subnets whose IDs are specified here to the
        /// subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at
        /// least one ENI in each of the subnets that are specified here. Do not delete or modify these
        /// ENIs.</p>
        /// <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
        /// scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
        /// scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
        /// help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
        /// three ENIs for this delivery stream for each of the subnets specified here. For more
        /// information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
        /// </a> in the Amazon VPC Quotas topic.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The ARN of the IAM role that you want the delivery stream to use to create endpoints in
        /// the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you
        /// can specify a new role. In either case, make sure that the role trusts the Kinesis Data
        /// Firehose service principal and that it grants the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcs</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcAttribute</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSubnets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSecurityGroups</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeNetworkInterfaces</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterface</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterfacePermission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DeleteNetworkInterface</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
        /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
        /// degradation in performance.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that you want the delivery stream to use to create endpoints in
        /// the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you
        /// can specify a new role. In either case, make sure that the role trusts the Kinesis Data
        /// Firehose service principal and that it grants the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcs</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeVpcAttribute</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSubnets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeSecurityGroups</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DescribeNetworkInterfaces</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterface</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:CreateNetworkInterfacePermission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ec2:DeleteNetworkInterface</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you revoke these permissions after you create the delivery stream, Kinesis Data
        /// Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
        /// degradation in performance.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups that you want Kinesis Data Firehose to use when it
        /// creates ENIs in the VPC of the Amazon ES destination. You can use the same security group
        /// that the Amazon ES domain uses or different ones. If you specify different security groups
        /// here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security
        /// group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the
        /// security groups specified here. If you use the same security group for both your delivery
        /// stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS
        /// traffic. For more information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
        /// rules</a> in the Amazon VPC documentation.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of the security groups that you want Kinesis Data Firehose to use when it
        /// creates ENIs in the VPC of the Amazon ES destination. You can use the same security group
        /// that the Amazon ES domain uses or different ones. If you specify different security groups
        /// here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security
        /// group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the
        /// security groups specified here. If you use the same security group for both your delivery
        /// stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS
        /// traffic. For more information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
        /// rules</a> in the Amazon VPC documentation.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfiguration`](crate::model::VpcConfiguration)
        pub fn build(self) -> crate::model::VpcConfiguration {
            crate::model::VpcConfiguration {
                subnet_ids: self.subnet_ids,
                role_arn: self.role_arn,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcConfiguration {
    /// Creates a new builder-style object to manufacture [`VpcConfiguration`](crate::model::VpcConfiguration)
    pub fn builder() -> crate::model::vpc_configuration::Builder {
        crate::model::vpc_configuration::Builder::default()
    }
}

/// <p>Describes the configuration of a destination in Amazon ES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchDestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
    /// for calling the Amazon ES Configuration API and for indexing documents. For more
    /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
    /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
    /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
    /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in
    /// <b>RoleARN</b>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    ///
    /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
    pub domain_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint to use when communicating with the cluster. Specify either this
    /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
    pub cluster_endpoint: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch index name.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
    /// index. If you try to specify a new type for an existing index that already has another
    /// type, Kinesis Data Firehose returns an error during run time.</p>
    ///
    /// <p>For Elasticsearch 7.x, don't specify a <code>TypeName</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to the
    /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
    /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
    /// Amazon ES Destination</a>. The default value is <code>OneDay</code>.</p>
    pub index_rotation_period: std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
    /// <p>The buffering options. If no value is specified, the default values for
    /// <code>ElasticsearchBufferingHints</code> are used.</p>
    pub buffering_hints: std::option::Option<crate::model::ElasticsearchBufferingHints>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon ES. The default value is 300 (5 minutes).</p>
    pub retry_options: std::option::Option<crate::model::ElasticsearchRetryOptions>,
    /// <p>Defines how documents should be delivered to Amazon S3. When it is set to
    /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could
    /// not be indexed to the configured Amazon S3 destination, with
    /// <code>elasticsearch-failed/</code> appended to the key prefix. When set to
    /// <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon
    /// S3, and also writes failed documents with <code>elasticsearch-failed/</code> appended to
    /// the prefix. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for the
    /// Amazon ES Destination</a>. Default value is
    /// <code>FailedDocumentsOnly</code>.</p>
    /// <p>You can't change this backup mode after you create the delivery stream. </p>
    pub s3_backup_mode: std::option::Option<crate::model::ElasticsearchS3BackupMode>,
    /// <p>The configuration for the backup Amazon S3 location.</p>
    pub s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
}
impl ElasticsearchDestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
    /// for calling the Amazon ES Configuration API and for indexing documents. For more
    /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
    /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
    /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
    /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in
    /// <b>RoleARN</b>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    ///
    /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
    pub fn domain_arn(&self) -> std::option::Option<&str> {
        self.domain_arn.as_deref()
    }
    /// <p>The endpoint to use when communicating with the cluster. Specify either this
    /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
    pub fn cluster_endpoint(&self) -> std::option::Option<&str> {
        self.cluster_endpoint.as_deref()
    }
    /// <p>The Elasticsearch index name.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
    /// index. If you try to specify a new type for an existing index that already has another
    /// type, Kinesis Data Firehose returns an error during run time.</p>
    ///
    /// <p>For Elasticsearch 7.x, don't specify a <code>TypeName</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to the
    /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
    /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
    /// Amazon ES Destination</a>. The default value is <code>OneDay</code>.</p>
    pub fn index_rotation_period(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchIndexRotationPeriod> {
        self.index_rotation_period.as_ref()
    }
    /// <p>The buffering options. If no value is specified, the default values for
    /// <code>ElasticsearchBufferingHints</code> are used.</p>
    pub fn buffering_hints(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchBufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon ES. The default value is 300 (5 minutes).</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::ElasticsearchRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>Defines how documents should be delivered to Amazon S3. When it is set to
    /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could
    /// not be indexed to the configured Amazon S3 destination, with
    /// <code>elasticsearch-failed/</code> appended to the key prefix. When set to
    /// <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon
    /// S3, and also writes failed documents with <code>elasticsearch-failed/</code> appended to
    /// the prefix. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for the
    /// Amazon ES Destination</a>. Default value is
    /// <code>FailedDocumentsOnly</code>.</p>
    /// <p>You can't change this backup mode after you create the delivery stream. </p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::ElasticsearchS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The configuration for the backup Amazon S3 location.</p>
    pub fn s3_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_configuration.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The details of the VPC of the Amazon ES destination.</p>
    pub fn vpc_configuration(&self) -> std::option::Option<&crate::model::VpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchDestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchDestinationConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("domain_arn", &self.domain_arn);
        formatter.field("cluster_endpoint", &self.cluster_endpoint);
        formatter.field("index_name", &self.index_name);
        formatter.field("type_name", &self.type_name);
        formatter.field("index_rotation_period", &self.index_rotation_period);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_configuration", &self.s3_configuration);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.finish()
    }
}
/// See [`ElasticsearchDestinationConfiguration`](crate::model::ElasticsearchDestinationConfiguration)
pub mod elasticsearch_destination_configuration {
    /// A builder for [`ElasticsearchDestinationConfiguration`](crate::model::ElasticsearchDestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_endpoint: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) index_rotation_period:
            std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
        pub(crate) buffering_hints: std::option::Option<crate::model::ElasticsearchBufferingHints>,
        pub(crate) retry_options: std::option::Option<crate::model::ElasticsearchRetryOptions>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::ElasticsearchS3BackupMode>,
        pub(crate) s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
        /// for calling the Amazon ES Configuration API and for indexing documents. For more
        /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
        /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
        /// for calling the Amazon ES Configuration API and for indexing documents. For more
        /// information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
        /// Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
        /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
        /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in
        /// <b>RoleARN</b>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        ///
        /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
        pub fn domain_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon ES domain. The IAM role must have permissions
        /// for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>,
        /// and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in
        /// <b>RoleARN</b>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        ///
        /// <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>
        pub fn set_domain_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_arn = input;
            self
        }
        /// <p>The endpoint to use when communicating with the cluster. Specify either this
        /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
        pub fn cluster_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint to use when communicating with the cluster. Specify either this
        /// <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>
        pub fn set_cluster_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_endpoint = input;
            self
        }
        /// <p>The Elasticsearch index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The Elasticsearch index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
        /// index. If you try to specify a new type for an existing index that already has another
        /// type, Kinesis Data Firehose returns an error during run time.</p>
        ///
        /// <p>For Elasticsearch 7.x, don't specify a <code>TypeName</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
        /// index. If you try to specify a new type for an existing index that already has another
        /// type, Kinesis Data Firehose returns an error during run time.</p>
        ///
        /// <p>For Elasticsearch 7.x, don't specify a <code>TypeName</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to the
        /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
        /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
        /// Amazon ES Destination</a>. The default value is <code>OneDay</code>.</p>
        pub fn index_rotation_period(
            mut self,
            input: crate::model::ElasticsearchIndexRotationPeriod,
        ) -> Self {
            self.index_rotation_period = Some(input);
            self
        }
        /// <p>The Elasticsearch index rotation period. Index rotation appends a timestamp to the
        /// <code>IndexName</code> to facilitate the expiration of old data. For more information,
        /// see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
        /// Amazon ES Destination</a>. The default value is <code>OneDay</code>.</p>
        pub fn set_index_rotation_period(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchIndexRotationPeriod>,
        ) -> Self {
            self.index_rotation_period = input;
            self
        }
        /// <p>The buffering options. If no value is specified, the default values for
        /// <code>ElasticsearchBufferingHints</code> are used.</p>
        pub fn buffering_hints(mut self, input: crate::model::ElasticsearchBufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering options. If no value is specified, the default values for
        /// <code>ElasticsearchBufferingHints</code> are used.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchBufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon ES. The default value is 300 (5 minutes).</p>
        pub fn retry_options(mut self, input: crate::model::ElasticsearchRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon ES. The default value is 300 (5 minutes).</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>Defines how documents should be delivered to Amazon S3. When it is set to
        /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could
        /// not be indexed to the configured Amazon S3 destination, with
        /// <code>elasticsearch-failed/</code> appended to the key prefix. When set to
        /// <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon
        /// S3, and also writes failed documents with <code>elasticsearch-failed/</code> appended to
        /// the prefix. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for the
        /// Amazon ES Destination</a>. Default value is
        /// <code>FailedDocumentsOnly</code>.</p>
        /// <p>You can't change this backup mode after you create the delivery stream. </p>
        pub fn s3_backup_mode(mut self, input: crate::model::ElasticsearchS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>Defines how documents should be delivered to Amazon S3. When it is set to
        /// <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could
        /// not be indexed to the configured Amazon S3 destination, with
        /// <code>elasticsearch-failed/</code> appended to the key prefix. When set to
        /// <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon
        /// S3, and also writes failed documents with <code>elasticsearch-failed/</code> appended to
        /// the prefix. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for the
        /// Amazon ES Destination</a>. Default value is
        /// <code>FailedDocumentsOnly</code>.</p>
        /// <p>You can't change this backup mode after you create the delivery stream. </p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The configuration for the backup Amazon S3 location.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3DestinationConfiguration) -> Self {
            self.s3_configuration = Some(input);
            self
        }
        /// <p>The configuration for the backup Amazon S3 location.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_configuration = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>The details of the VPC of the Amazon ES destination.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchDestinationConfiguration`](crate::model::ElasticsearchDestinationConfiguration)
        pub fn build(self) -> crate::model::ElasticsearchDestinationConfiguration {
            crate::model::ElasticsearchDestinationConfiguration {
                role_arn: self.role_arn,
                domain_arn: self.domain_arn,
                cluster_endpoint: self.cluster_endpoint,
                index_name: self.index_name,
                type_name: self.type_name,
                index_rotation_period: self.index_rotation_period,
                buffering_hints: self.buffering_hints,
                retry_options: self.retry_options,
                s3_backup_mode: self.s3_backup_mode,
                s3_configuration: self.s3_configuration,
                processing_configuration: self.processing_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                vpc_configuration: self.vpc_configuration,
            }
        }
    }
}
impl ElasticsearchDestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`ElasticsearchDestinationConfiguration`](crate::model::ElasticsearchDestinationConfiguration)
    pub fn builder() -> crate::model::elasticsearch_destination_configuration::Builder {
        crate::model::elasticsearch_destination_configuration::Builder::default()
    }
}

/// <p>Describes the configuration of a destination in Amazon Redshift.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftDestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The database connection string.</p>
    pub cluster_jdbcurl: std::option::Option<std::string::String>,
    /// <p>The <code>COPY</code> command.</p>
    pub copy_command: std::option::Option<crate::model::CopyCommand>,
    /// <p>The name of the user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The user password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
    pub retry_options: std::option::Option<crate::model::RedshiftRetryOptions>,
    /// <p>The configuration for the intermediate Amazon S3 location from which Amazon Redshift
    /// obtains data. Restrictions are described in the topic for <a>CreateDeliveryStream</a>.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon
    /// Redshift <code>COPY</code> operation that reads from the S3 bucket doesn't support these
    /// compression formats.</p>
    pub s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
    /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
    /// delivery stream to disable it. </p>
    pub s3_backup_mode: std::option::Option<crate::model::RedshiftS3BackupMode>,
    /// <p>The configuration for backup in Amazon S3.</p>
    pub s3_backup_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
}
impl RedshiftDestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The database connection string.</p>
    pub fn cluster_jdbcurl(&self) -> std::option::Option<&str> {
        self.cluster_jdbcurl.as_deref()
    }
    /// <p>The <code>COPY</code> command.</p>
    pub fn copy_command(&self) -> std::option::Option<&crate::model::CopyCommand> {
        self.copy_command.as_ref()
    }
    /// <p>The name of the user.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The user password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
    /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
    pub fn retry_options(&self) -> std::option::Option<&crate::model::RedshiftRetryOptions> {
        self.retry_options.as_ref()
    }
    /// <p>The configuration for the intermediate Amazon S3 location from which Amazon Redshift
    /// obtains data. Restrictions are described in the topic for <a>CreateDeliveryStream</a>.</p>
    /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
    /// in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon
    /// Redshift <code>COPY</code> operation that reads from the S3 bucket doesn't support these
    /// compression formats.</p>
    pub fn s3_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_configuration.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
    /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
    /// delivery stream to disable it. </p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::RedshiftS3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The configuration for backup in Amazon S3.</p>
    pub fn s3_backup_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_backup_configuration.as_ref()
    }
    /// <p>The CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
}
impl std::fmt::Debug for RedshiftDestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftDestinationConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("cluster_jdbcurl", &self.cluster_jdbcurl);
        formatter.field("copy_command", &self.copy_command);
        formatter.field("username", &"*** Sensitive Data Redacted ***");
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("retry_options", &self.retry_options);
        formatter.field("s3_configuration", &self.s3_configuration);
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_backup_configuration", &self.s3_backup_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.finish()
    }
}
/// See [`RedshiftDestinationConfiguration`](crate::model::RedshiftDestinationConfiguration)
pub mod redshift_destination_configuration {
    /// A builder for [`RedshiftDestinationConfiguration`](crate::model::RedshiftDestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_jdbcurl: std::option::Option<std::string::String>,
        pub(crate) copy_command: std::option::Option<crate::model::CopyCommand>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) retry_options: std::option::Option<crate::model::RedshiftRetryOptions>,
        pub(crate) s3_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::RedshiftS3BackupMode>,
        pub(crate) s3_backup_configuration:
            std::option::Option<crate::model::S3DestinationConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The database connection string.</p>
        pub fn cluster_jdbcurl(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_jdbcurl = Some(input.into());
            self
        }
        /// <p>The database connection string.</p>
        pub fn set_cluster_jdbcurl(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_jdbcurl = input;
            self
        }
        /// <p>The <code>COPY</code> command.</p>
        pub fn copy_command(mut self, input: crate::model::CopyCommand) -> Self {
            self.copy_command = Some(input);
            self
        }
        /// <p>The <code>COPY</code> command.</p>
        pub fn set_copy_command(
            mut self,
            input: std::option::Option<crate::model::CopyCommand>,
        ) -> Self {
            self.copy_command = input;
            self
        }
        /// <p>The name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The user password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The user password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
        pub fn retry_options(mut self, input: crate::model::RedshiftRetryOptions) -> Self {
            self.retry_options = Some(input);
            self
        }
        /// <p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
        /// Amazon Redshift. Default value is 3600 (60 minutes).</p>
        pub fn set_retry_options(
            mut self,
            input: std::option::Option<crate::model::RedshiftRetryOptions>,
        ) -> Self {
            self.retry_options = input;
            self
        }
        /// <p>The configuration for the intermediate Amazon S3 location from which Amazon Redshift
        /// obtains data. Restrictions are described in the topic for <a>CreateDeliveryStream</a>.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon
        /// Redshift <code>COPY</code> operation that reads from the S3 bucket doesn't support these
        /// compression formats.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3DestinationConfiguration) -> Self {
            self.s3_configuration = Some(input);
            self
        }
        /// <p>The configuration for the intermediate Amazon S3 location from which Amazon Redshift
        /// obtains data. Restrictions are described in the topic for <a>CreateDeliveryStream</a>.</p>
        /// <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified
        /// in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon
        /// Redshift <code>COPY</code> operation that reads from the S3 bucket doesn't support these
        /// compression formats.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_configuration = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
        /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
        /// delivery stream to disable it. </p>
        pub fn s3_backup_mode(mut self, input: crate::model::RedshiftS3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
        /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
        /// delivery stream to disable it. </p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::RedshiftS3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn s3_backup_configuration(
            mut self,
            input: crate::model::S3DestinationConfiguration,
        ) -> Self {
            self.s3_backup_configuration = Some(input);
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn set_s3_backup_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_backup_configuration = input;
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftDestinationConfiguration`](crate::model::RedshiftDestinationConfiguration)
        pub fn build(self) -> crate::model::RedshiftDestinationConfiguration {
            crate::model::RedshiftDestinationConfiguration {
                role_arn: self.role_arn,
                cluster_jdbcurl: self.cluster_jdbcurl,
                copy_command: self.copy_command,
                username: self.username,
                password: self.password,
                retry_options: self.retry_options,
                s3_configuration: self.s3_configuration,
                processing_configuration: self.processing_configuration,
                s3_backup_mode: self.s3_backup_mode,
                s3_backup_configuration: self.s3_backup_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
            }
        }
    }
}
impl RedshiftDestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`RedshiftDestinationConfiguration`](crate::model::RedshiftDestinationConfiguration)
    pub fn builder() -> crate::model::redshift_destination_configuration::Builder {
        crate::model::redshift_destination_configuration::Builder::default()
    }
}

/// <p>Describes the configuration of a destination in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtendedS3DestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub error_output_prefix: std::option::Option<std::string::String>,
    /// <p>The buffering option.</p>
    pub buffering_hints: std::option::Option<crate::model::BufferingHints>,
    /// <p>The compression format. If no value is specified, the default is
    /// UNCOMPRESSED.</p>
    pub compression_format: std::option::Option<crate::model::CompressionFormat>,
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub cloud_watch_logging_options: std::option::Option<crate::model::CloudWatchLoggingOptions>,
    /// <p>The data processing configuration.</p>
    pub processing_configuration: std::option::Option<crate::model::ProcessingConfiguration>,
    /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
    /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
    /// delivery stream to disable it. </p>
    pub s3_backup_mode: std::option::Option<crate::model::S3BackupMode>,
    /// <p>The configuration for backup in Amazon S3.</p>
    pub s3_backup_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
    /// the Parquet or ORC format before writing it to Amazon S3.</p>
    pub data_format_conversion_configuration:
        std::option::Option<crate::model::DataFormatConversionConfiguration>,
    /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
    /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
    /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
    /// </p>
    pub dynamic_partitioning_configuration:
        std::option::Option<crate::model::DynamicPartitioningConfiguration>,
}
impl ExtendedS3DestinationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
    /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
    /// AWS Service Namespaces</a>.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
    /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
    /// them to S3. This prefix appears immediately following the bucket name. For information
    /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
    /// Objects</a>.</p>
    pub fn error_output_prefix(&self) -> std::option::Option<&str> {
        self.error_output_prefix.as_deref()
    }
    /// <p>The buffering option.</p>
    pub fn buffering_hints(&self) -> std::option::Option<&crate::model::BufferingHints> {
        self.buffering_hints.as_ref()
    }
    /// <p>The compression format. If no value is specified, the default is
    /// UNCOMPRESSED.</p>
    pub fn compression_format(&self) -> std::option::Option<&crate::model::CompressionFormat> {
        self.compression_format.as_ref()
    }
    /// <p>The encryption configuration. If no value is specified, the default is no
    /// encryption.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOptions> {
        self.cloud_watch_logging_options.as_ref()
    }
    /// <p>The data processing configuration.</p>
    pub fn processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingConfiguration> {
        self.processing_configuration.as_ref()
    }
    /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
    /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
    /// delivery stream to disable it. </p>
    pub fn s3_backup_mode(&self) -> std::option::Option<&crate::model::S3BackupMode> {
        self.s3_backup_mode.as_ref()
    }
    /// <p>The configuration for backup in Amazon S3.</p>
    pub fn s3_backup_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_backup_configuration.as_ref()
    }
    /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
    /// the Parquet or ORC format before writing it to Amazon S3.</p>
    pub fn data_format_conversion_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataFormatConversionConfiguration> {
        self.data_format_conversion_configuration.as_ref()
    }
    /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
    /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
    /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
    /// </p>
    pub fn dynamic_partitioning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DynamicPartitioningConfiguration> {
        self.dynamic_partitioning_configuration.as_ref()
    }
}
impl std::fmt::Debug for ExtendedS3DestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtendedS3DestinationConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("prefix", &self.prefix);
        formatter.field("error_output_prefix", &self.error_output_prefix);
        formatter.field("buffering_hints", &self.buffering_hints);
        formatter.field("compression_format", &self.compression_format);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("processing_configuration", &self.processing_configuration);
        formatter.field("s3_backup_mode", &self.s3_backup_mode);
        formatter.field("s3_backup_configuration", &self.s3_backup_configuration);
        formatter.field(
            "data_format_conversion_configuration",
            &self.data_format_conversion_configuration,
        );
        formatter.field(
            "dynamic_partitioning_configuration",
            &self.dynamic_partitioning_configuration,
        );
        formatter.finish()
    }
}
/// See [`ExtendedS3DestinationConfiguration`](crate::model::ExtendedS3DestinationConfiguration)
pub mod extended_s3_destination_configuration {
    /// A builder for [`ExtendedS3DestinationConfiguration`](crate::model::ExtendedS3DestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) error_output_prefix: std::option::Option<std::string::String>,
        pub(crate) buffering_hints: std::option::Option<crate::model::BufferingHints>,
        pub(crate) compression_format: std::option::Option<crate::model::CompressionFormat>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<crate::model::CloudWatchLoggingOptions>,
        pub(crate) processing_configuration:
            std::option::Option<crate::model::ProcessingConfiguration>,
        pub(crate) s3_backup_mode: std::option::Option<crate::model::S3BackupMode>,
        pub(crate) s3_backup_configuration:
            std::option::Option<crate::model::S3DestinationConfiguration>,
        pub(crate) data_format_conversion_configuration:
            std::option::Option<crate::model::DataFormatConversionConfiguration>,
        pub(crate) dynamic_partitioning_configuration:
            std::option::Option<crate::model::DynamicPartitioningConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
        /// Resource Names (ARNs) and AWS Service Namespaces</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
        /// AWS Service Namespaces</a>.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3
        /// files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn error_output_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_output_prefix = Some(input.into());
            self
        }
        /// <p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing
        /// them to S3. This prefix appears immediately following the bucket name. For information
        /// about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
        /// Objects</a>.</p>
        pub fn set_error_output_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_output_prefix = input;
            self
        }
        /// <p>The buffering option.</p>
        pub fn buffering_hints(mut self, input: crate::model::BufferingHints) -> Self {
            self.buffering_hints = Some(input);
            self
        }
        /// <p>The buffering option.</p>
        pub fn set_buffering_hints(
            mut self,
            input: std::option::Option<crate::model::BufferingHints>,
        ) -> Self {
            self.buffering_hints = input;
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// UNCOMPRESSED.</p>
        pub fn compression_format(mut self, input: crate::model::CompressionFormat) -> Self {
            self.compression_format = Some(input);
            self
        }
        /// <p>The compression format. If no value is specified, the default is
        /// UNCOMPRESSED.</p>
        pub fn set_compression_format(
            mut self,
            input: std::option::Option<crate::model::CompressionFormat>,
        ) -> Self {
            self.compression_format = input;
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration. If no value is specified, the default is no
        /// encryption.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOptions,
        ) -> Self {
            self.cloud_watch_logging_options = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch logging options for your delivery stream.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOptions>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn processing_configuration(
            mut self,
            input: crate::model::ProcessingConfiguration,
        ) -> Self {
            self.processing_configuration = Some(input);
            self
        }
        /// <p>The data processing configuration.</p>
        pub fn set_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::ProcessingConfiguration>,
        ) -> Self {
            self.processing_configuration = input;
            self
        }
        /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
        /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
        /// delivery stream to disable it. </p>
        pub fn s3_backup_mode(mut self, input: crate::model::S3BackupMode) -> Self {
            self.s3_backup_mode = Some(input);
            self
        }
        /// <p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to
        /// enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the
        /// delivery stream to disable it. </p>
        pub fn set_s3_backup_mode(
            mut self,
            input: std::option::Option<crate::model::S3BackupMode>,
        ) -> Self {
            self.s3_backup_mode = input;
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn s3_backup_configuration(
            mut self,
            input: crate::model::S3DestinationConfiguration,
        ) -> Self {
            self.s3_backup_configuration = Some(input);
            self
        }
        /// <p>The configuration for backup in Amazon S3.</p>
        pub fn set_s3_backup_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_backup_configuration = input;
            self
        }
        /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
        /// the Parquet or ORC format before writing it to Amazon S3.</p>
        pub fn data_format_conversion_configuration(
            mut self,
            input: crate::model::DataFormatConversionConfiguration,
        ) -> Self {
            self.data_format_conversion_configuration = Some(input);
            self
        }
        /// <p>The serializer, deserializer, and schema for converting data from the JSON format to
        /// the Parquet or ORC format before writing it to Amazon S3.</p>
        pub fn set_data_format_conversion_configuration(
            mut self,
            input: std::option::Option<crate::model::DataFormatConversionConfiguration>,
        ) -> Self {
            self.data_format_conversion_configuration = input;
            self
        }
        /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
        /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
        /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
        /// </p>
        pub fn dynamic_partitioning_configuration(
            mut self,
            input: crate::model::DynamicPartitioningConfiguration,
        ) -> Self {
            self.dynamic_partitioning_configuration = Some(input);
            self
        }
        /// <p>The configuration of the dynamic partitioning mechanism that creates smaller data sets
        /// from the streaming data by partitioning it based on partition keys. Currently, dynamic
        /// partitioning is only supported for Amazon S3 destinations. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html">https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
        /// </p>
        pub fn set_dynamic_partitioning_configuration(
            mut self,
            input: std::option::Option<crate::model::DynamicPartitioningConfiguration>,
        ) -> Self {
            self.dynamic_partitioning_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtendedS3DestinationConfiguration`](crate::model::ExtendedS3DestinationConfiguration)
        pub fn build(self) -> crate::model::ExtendedS3DestinationConfiguration {
            crate::model::ExtendedS3DestinationConfiguration {
                role_arn: self.role_arn,
                bucket_arn: self.bucket_arn,
                prefix: self.prefix,
                error_output_prefix: self.error_output_prefix,
                buffering_hints: self.buffering_hints,
                compression_format: self.compression_format,
                encryption_configuration: self.encryption_configuration,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                processing_configuration: self.processing_configuration,
                s3_backup_mode: self.s3_backup_mode,
                s3_backup_configuration: self.s3_backup_configuration,
                data_format_conversion_configuration: self.data_format_conversion_configuration,
                dynamic_partitioning_configuration: self.dynamic_partitioning_configuration,
            }
        }
    }
}
impl ExtendedS3DestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`ExtendedS3DestinationConfiguration`](crate::model::ExtendedS3DestinationConfiguration)
    pub fn builder() -> crate::model::extended_s3_destination_configuration::Builder {
        crate::model::extended_s3_destination_configuration::Builder::default()
    }
}

/// <p>The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as
/// the source for a delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamSourceConfiguration {
    /// <p>The ARN of the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
    /// Kinesis Data Streams ARN Format</a>.</p>
    pub kinesis_stream_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that provides access to the source Kinesis data stream. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
    /// Access Management (IAM) ARN Format</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl KinesisStreamSourceConfiguration {
    /// <p>The ARN of the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
    /// Kinesis Data Streams ARN Format</a>.</p>
    pub fn kinesis_stream_arn(&self) -> std::option::Option<&str> {
        self.kinesis_stream_arn.as_deref()
    }
    /// <p>The ARN of the role that provides access to the source Kinesis data stream. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
    /// Access Management (IAM) ARN Format</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisStreamSourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamSourceConfiguration");
        formatter.field("kinesis_stream_arn", &self.kinesis_stream_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisStreamSourceConfiguration`](crate::model::KinesisStreamSourceConfiguration)
pub mod kinesis_stream_source_configuration {
    /// A builder for [`KinesisStreamSourceConfiguration`](crate::model::KinesisStreamSourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kinesis_stream_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
        /// Kinesis Data Streams ARN Format</a>.</p>
        pub fn kinesis_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kinesis_stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
        /// Kinesis Data Streams ARN Format</a>.</p>
        pub fn set_kinesis_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kinesis_stream_arn = input;
            self
        }
        /// <p>The ARN of the role that provides access to the source Kinesis data stream. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
        /// Access Management (IAM) ARN Format</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that provides access to the source Kinesis data stream. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
        /// Access Management (IAM) ARN Format</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamSourceConfiguration`](crate::model::KinesisStreamSourceConfiguration)
        pub fn build(self) -> crate::model::KinesisStreamSourceConfiguration {
            crate::model::KinesisStreamSourceConfiguration {
                kinesis_stream_arn: self.kinesis_stream_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisStreamSourceConfiguration {
    /// Creates a new builder-style object to manufacture [`KinesisStreamSourceConfiguration`](crate::model::KinesisStreamSourceConfiguration)
    pub fn builder() -> crate::model::kinesis_stream_source_configuration::Builder {
        crate::model::kinesis_stream_source_configuration::Builder::default()
    }
}
