// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateDeliveryStreamInput`](crate::input::CreateDeliveryStreamInput)
pub mod create_delivery_stream_input {
    /// A builder for [`CreateDeliveryStreamInput`](crate::input::CreateDeliveryStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_type: std::option::Option<crate::model::DeliveryStreamType>,
        pub(crate) kinesis_stream_source_configuration:
            std::option::Option<crate::model::KinesisStreamSourceConfiguration>,
        pub(crate) delivery_stream_encryption_configuration_input:
            std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
        pub(crate) s3_destination_configuration:
            std::option::Option<crate::model::S3DestinationConfiguration>,
        pub(crate) extended_s3_destination_configuration:
            std::option::Option<crate::model::ExtendedS3DestinationConfiguration>,
        pub(crate) redshift_destination_configuration:
            std::option::Option<crate::model::RedshiftDestinationConfiguration>,
        pub(crate) elasticsearch_destination_configuration:
            std::option::Option<crate::model::ElasticsearchDestinationConfiguration>,
        pub(crate) amazonopensearchservice_destination_configuration:
            std::option::Option<crate::model::AmazonopensearchserviceDestinationConfiguration>,
        pub(crate) splunk_destination_configuration:
            std::option::Option<crate::model::SplunkDestinationConfiguration>,
        pub(crate) http_endpoint_destination_configuration:
            std::option::Option<crate::model::HttpEndpointDestinationConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the delivery stream. This name must be unique per AWS account in the same
        /// AWS Region. If the delivery streams are in different accounts or different Regions, you can
        /// have multiple delivery streams with the same name.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream. This name must be unique per AWS account in the same
        /// AWS Region. If the delivery streams are in different accounts or different Regions, you can
        /// have multiple delivery streams with the same name.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>The delivery stream type. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DirectPut</code>: Provider applications access the delivery stream
        /// directly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
        /// stream as a source.</p>
        /// </li>
        /// </ul>
        pub fn delivery_stream_type(mut self, input: crate::model::DeliveryStreamType) -> Self {
            self.delivery_stream_type = Some(input);
            self
        }
        /// <p>The delivery stream type. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DirectPut</code>: Provider applications access the delivery stream
        /// directly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
        /// stream as a source.</p>
        /// </li>
        /// </ul>
        pub fn set_delivery_stream_type(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamType>,
        ) -> Self {
            self.delivery_stream_type = input;
            self
        }
        /// <p>When a Kinesis data stream is used as the source for the delivery stream, a <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon
        /// Resource Name (ARN) and the role ARN for the source stream.</p>
        pub fn kinesis_stream_source_configuration(
            mut self,
            input: crate::model::KinesisStreamSourceConfiguration,
        ) -> Self {
            self.kinesis_stream_source_configuration = Some(input);
            self
        }
        /// <p>When a Kinesis data stream is used as the source for the delivery stream, a <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon
        /// Resource Name (ARN) and the role ARN for the source stream.</p>
        pub fn set_kinesis_stream_source_configuration(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamSourceConfiguration>,
        ) -> Self {
            self.kinesis_stream_source_configuration = input;
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for
        /// Server-Side Encryption (SSE).</p>
        pub fn delivery_stream_encryption_configuration_input(
            mut self,
            input: crate::model::DeliveryStreamEncryptionConfigurationInput,
        ) -> Self {
            self.delivery_stream_encryption_configuration_input = Some(input);
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for
        /// Server-Side Encryption (SSE).</p>
        pub fn set_delivery_stream_encryption_configuration_input(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
        ) -> Self {
            self.delivery_stream_encryption_configuration_input = input;
            self
        }
        /// <p>[Deprecated]
        /// The destination in Amazon S3. You can specify only one destination.</p>
        pub fn s3_destination_configuration(
            mut self,
            input: crate::model::S3DestinationConfiguration,
        ) -> Self {
            self.s3_destination_configuration = Some(input);
            self
        }
        /// <p>[Deprecated]
        /// The destination in Amazon S3. You can specify only one destination.</p>
        pub fn set_s3_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_destination_configuration = input;
            self
        }
        /// <p>The destination in Amazon S3. You can specify only one destination.</p>
        pub fn extended_s3_destination_configuration(
            mut self,
            input: crate::model::ExtendedS3DestinationConfiguration,
        ) -> Self {
            self.extended_s3_destination_configuration = Some(input);
            self
        }
        /// <p>The destination in Amazon S3. You can specify only one destination.</p>
        pub fn set_extended_s3_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::ExtendedS3DestinationConfiguration>,
        ) -> Self {
            self.extended_s3_destination_configuration = input;
            self
        }
        /// <p>The destination in Amazon Redshift. You can specify only one destination.</p>
        pub fn redshift_destination_configuration(
            mut self,
            input: crate::model::RedshiftDestinationConfiguration,
        ) -> Self {
            self.redshift_destination_configuration = Some(input);
            self
        }
        /// <p>The destination in Amazon Redshift. You can specify only one destination.</p>
        pub fn set_redshift_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::RedshiftDestinationConfiguration>,
        ) -> Self {
            self.redshift_destination_configuration = input;
            self
        }
        /// <p>The destination in Amazon ES. You can specify only one destination.</p>
        pub fn elasticsearch_destination_configuration(
            mut self,
            input: crate::model::ElasticsearchDestinationConfiguration,
        ) -> Self {
            self.elasticsearch_destination_configuration = Some(input);
            self
        }
        /// <p>The destination in Amazon ES. You can specify only one destination.</p>
        pub fn set_elasticsearch_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDestinationConfiguration>,
        ) -> Self {
            self.elasticsearch_destination_configuration = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn amazonopensearchservice_destination_configuration(
            mut self,
            input: crate::model::AmazonopensearchserviceDestinationConfiguration,
        ) -> Self {
            self.amazonopensearchservice_destination_configuration = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_amazonopensearchservice_destination_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AmazonopensearchserviceDestinationConfiguration,
            >,
        ) -> Self {
            self.amazonopensearchservice_destination_configuration = input;
            self
        }
        /// <p>The destination in Splunk. You can specify only one destination.</p>
        pub fn splunk_destination_configuration(
            mut self,
            input: crate::model::SplunkDestinationConfiguration,
        ) -> Self {
            self.splunk_destination_configuration = Some(input);
            self
        }
        /// <p>The destination in Splunk. You can specify only one destination.</p>
        pub fn set_splunk_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::SplunkDestinationConfiguration>,
        ) -> Self {
            self.splunk_destination_configuration = input;
            self
        }
        /// <p>Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
        /// You can specify only one destination.</p>
        pub fn http_endpoint_destination_configuration(
            mut self,
            input: crate::model::HttpEndpointDestinationConfiguration,
        ) -> Self {
            self.http_endpoint_destination_configuration = Some(input);
            self
        }
        /// <p>Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
        /// You can specify only one destination.</p>
        pub fn set_http_endpoint_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointDestinationConfiguration>,
        ) -> Self {
            self.http_endpoint_destination_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to assign to the delivery stream. A tag is a key-value pair that you can
        /// define and assign to AWS resources. Tags are metadata. For example, you can add friendly
        /// names and descriptions or other types of information that can help you distinguish the
        /// delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
        /// Tags</a> in the AWS Billing and Cost Management User Guide.</p>
        ///
        /// <p>You can specify up to 50 tags when creating a delivery stream.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A set of tags to assign to the delivery stream. A tag is a key-value pair that you can
        /// define and assign to AWS resources. Tags are metadata. For example, you can add friendly
        /// names and descriptions or other types of information that can help you distinguish the
        /// delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
        /// Tags</a> in the AWS Billing and Cost Management User Guide.</p>
        ///
        /// <p>You can specify up to 50 tags when creating a delivery stream.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeliveryStreamInput`](crate::input::CreateDeliveryStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeliveryStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeliveryStreamInput {
                delivery_stream_name: self.delivery_stream_name,
                delivery_stream_type: self.delivery_stream_type,
                kinesis_stream_source_configuration: self.kinesis_stream_source_configuration,
                delivery_stream_encryption_configuration_input: self
                    .delivery_stream_encryption_configuration_input,
                s3_destination_configuration: self.s3_destination_configuration,
                extended_s3_destination_configuration: self.extended_s3_destination_configuration,
                redshift_destination_configuration: self.redshift_destination_configuration,
                elasticsearch_destination_configuration: self
                    .elasticsearch_destination_configuration,
                amazonopensearchservice_destination_configuration: self
                    .amazonopensearchservice_destination_configuration,
                splunk_destination_configuration: self.splunk_destination_configuration,
                http_endpoint_destination_configuration: self
                    .http_endpoint_destination_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeliveryStreamInputOperationOutputAlias = crate::operation::CreateDeliveryStream;
#[doc(hidden)]
pub type CreateDeliveryStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeliveryStreamInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeliveryStream`](crate::operation::CreateDeliveryStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeliveryStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeliveryStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeliveryStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeliveryStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.CreateDeliveryStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_delivery_stream(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeliveryStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeliveryStream",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeliveryStreamInput`](crate::input::CreateDeliveryStreamInput)
    pub fn builder() -> crate::input::create_delivery_stream_input::Builder {
        crate::input::create_delivery_stream_input::Builder::default()
    }
}

/// See [`DeleteDeliveryStreamInput`](crate::input::DeleteDeliveryStreamInput)
pub mod delete_delivery_stream_input {
    /// A builder for [`DeleteDeliveryStreamInput`](crate::input::DeleteDeliveryStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) allow_force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose
        /// is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire
        /// the grant due to a customer error, such as when the CMK or the grant are in an invalid
        /// state. If you force deletion, you can then use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to
        /// revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant
        /// happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete
        /// operation.</p>
        /// <p>The default value is false.</p>
        pub fn allow_force_delete(mut self, input: bool) -> Self {
            self.allow_force_delete = Some(input);
            self
        }
        /// <p>Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose
        /// is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire
        /// the grant due to a customer error, such as when the CMK or the grant are in an invalid
        /// state. If you force deletion, you can then use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to
        /// revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant
        /// happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete
        /// operation.</p>
        /// <p>The default value is false.</p>
        pub fn set_allow_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeliveryStreamInput`](crate::input::DeleteDeliveryStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeliveryStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeliveryStreamInput {
                delivery_stream_name: self.delivery_stream_name,
                allow_force_delete: self.allow_force_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeliveryStreamInputOperationOutputAlias = crate::operation::DeleteDeliveryStream;
#[doc(hidden)]
pub type DeleteDeliveryStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeliveryStreamInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeliveryStream`](crate::operation::DeleteDeliveryStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeliveryStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeliveryStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeliveryStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeliveryStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.DeleteDeliveryStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_delivery_stream(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeliveryStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeliveryStream",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeliveryStreamInput`](crate::input::DeleteDeliveryStreamInput)
    pub fn builder() -> crate::input::delete_delivery_stream_input::Builder {
        crate::input::delete_delivery_stream_input::Builder::default()
    }
}

/// See [`DescribeDeliveryStreamInput`](crate::input::DescribeDeliveryStreamInput)
pub mod describe_delivery_stream_input {
    /// A builder for [`DescribeDeliveryStreamInput`](crate::input::DescribeDeliveryStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) exclusive_start_destination_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>The limit on the number of destinations to return. You can have one destination per
        /// delivery stream.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The limit on the number of destinations to return. You can have one destination per
        /// delivery stream.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The ID of the destination to start returning the destination information. Kinesis
        /// Data Firehose supports one destination per delivery stream.</p>
        pub fn exclusive_start_destination_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.exclusive_start_destination_id = Some(input.into());
            self
        }
        /// <p>The ID of the destination to start returning the destination information. Kinesis
        /// Data Firehose supports one destination per delivery stream.</p>
        pub fn set_exclusive_start_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_start_destination_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeliveryStreamInput`](crate::input::DescribeDeliveryStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeliveryStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeliveryStreamInput {
                delivery_stream_name: self.delivery_stream_name,
                limit: self.limit,
                exclusive_start_destination_id: self.exclusive_start_destination_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeliveryStreamInputOperationOutputAlias = crate::operation::DescribeDeliveryStream;
#[doc(hidden)]
pub type DescribeDeliveryStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDeliveryStreamInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDeliveryStream`](crate::operation::DescribeDeliveryStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDeliveryStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDeliveryStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDeliveryStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDeliveryStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.DescribeDeliveryStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_delivery_stream(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDeliveryStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDeliveryStream",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeliveryStreamInput`](crate::input::DescribeDeliveryStreamInput)
    pub fn builder() -> crate::input::describe_delivery_stream_input::Builder {
        crate::input::describe_delivery_stream_input::Builder::default()
    }
}

/// See [`ListDeliveryStreamsInput`](crate::input::ListDeliveryStreamsInput)
pub mod list_delivery_streams_input {
    /// A builder for [`ListDeliveryStreamsInput`](crate::input::ListDeliveryStreamsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) delivery_stream_type: std::option::Option<crate::model::DeliveryStreamType>,
        pub(crate) exclusive_start_delivery_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of delivery streams to list. The default value is 10.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of delivery streams to list. The default value is 10.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The delivery stream type. This can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DirectPut</code>: Provider applications access the delivery stream
        /// directly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
        /// stream as a source.</p>
        /// </li>
        /// </ul>
        /// <p>This parameter is optional. If this parameter is omitted, delivery streams of all
        /// types are returned.</p>
        pub fn delivery_stream_type(mut self, input: crate::model::DeliveryStreamType) -> Self {
            self.delivery_stream_type = Some(input);
            self
        }
        /// <p>The delivery stream type. This can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DirectPut</code>: Provider applications access the delivery stream
        /// directly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
        /// stream as a source.</p>
        /// </li>
        /// </ul>
        /// <p>This parameter is optional. If this parameter is omitted, delivery streams of all
        /// types are returned.</p>
        pub fn set_delivery_stream_type(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamType>,
        ) -> Self {
            self.delivery_stream_type = input;
            self
        }
        /// <p>The list of delivery streams returned by this call to
        /// <code>ListDeliveryStreams</code> will start with the delivery stream whose name comes
        /// alphabetically immediately after the name you specify in
        /// <code>ExclusiveStartDeliveryStreamName</code>.</p>
        pub fn exclusive_start_delivery_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.exclusive_start_delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The list of delivery streams returned by this call to
        /// <code>ListDeliveryStreams</code> will start with the delivery stream whose name comes
        /// alphabetically immediately after the name you specify in
        /// <code>ExclusiveStartDeliveryStreamName</code>.</p>
        pub fn set_exclusive_start_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_start_delivery_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeliveryStreamsInput`](crate::input::ListDeliveryStreamsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeliveryStreamsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeliveryStreamsInput {
                limit: self.limit,
                delivery_stream_type: self.delivery_stream_type,
                exclusive_start_delivery_stream_name: self.exclusive_start_delivery_stream_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeliveryStreamsInputOperationOutputAlias = crate::operation::ListDeliveryStreams;
#[doc(hidden)]
pub type ListDeliveryStreamsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDeliveryStreamsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeliveryStreams`](crate::operation::ListDeliveryStreams)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeliveryStreams,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeliveryStreamsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeliveryStreamsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeliveryStreamsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.ListDeliveryStreams",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_delivery_streams(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeliveryStreams::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeliveryStreams",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeliveryStreamsInput`](crate::input::ListDeliveryStreamsInput)
    pub fn builder() -> crate::input::list_delivery_streams_input::Builder {
        crate::input::list_delivery_streams_input::Builder::default()
    }
}

/// See [`ListTagsForDeliveryStreamInput`](crate::input::ListTagsForDeliveryStreamInput)
pub mod list_tags_for_delivery_stream_input {
    /// A builder for [`ListTagsForDeliveryStreamInput`](crate::input::ListTagsForDeliveryStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) exclusive_start_tag_key: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the delivery stream whose tags you want to list.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream whose tags you want to list.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>The key to use as the starting point for the list of tags. If you set this parameter,
        /// <code>ListTagsForDeliveryStream</code> gets all tags that occur after
        /// <code>ExclusiveStartTagKey</code>.</p>
        pub fn exclusive_start_tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.exclusive_start_tag_key = Some(input.into());
            self
        }
        /// <p>The key to use as the starting point for the list of tags. If you set this parameter,
        /// <code>ListTagsForDeliveryStream</code> gets all tags that occur after
        /// <code>ExclusiveStartTagKey</code>.</p>
        pub fn set_exclusive_start_tag_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_start_tag_key = input;
            self
        }
        /// <p>The number of tags to return. If this number is less than the total number of tags
        /// associated with the delivery stream, <code>HasMoreTags</code> is set to <code>true</code>
        /// in the response. To list additional tags, set <code>ExclusiveStartTagKey</code> to the last
        /// key in the response. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The number of tags to return. If this number is less than the total number of tags
        /// associated with the delivery stream, <code>HasMoreTags</code> is set to <code>true</code>
        /// in the response. To list additional tags, set <code>ExclusiveStartTagKey</code> to the last
        /// key in the response. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForDeliveryStreamInput`](crate::input::ListTagsForDeliveryStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForDeliveryStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForDeliveryStreamInput {
                delivery_stream_name: self.delivery_stream_name,
                exclusive_start_tag_key: self.exclusive_start_tag_key,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForDeliveryStreamInputOperationOutputAlias =
    crate::operation::ListTagsForDeliveryStream;
#[doc(hidden)]
pub type ListTagsForDeliveryStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForDeliveryStreamInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForDeliveryStream`](crate::operation::ListTagsForDeliveryStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForDeliveryStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForDeliveryStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForDeliveryStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForDeliveryStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.ListTagsForDeliveryStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_delivery_stream(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForDeliveryStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForDeliveryStream",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForDeliveryStreamInput`](crate::input::ListTagsForDeliveryStreamInput)
    pub fn builder() -> crate::input::list_tags_for_delivery_stream_input::Builder {
        crate::input::list_tags_for_delivery_stream_input::Builder::default()
    }
}

/// See [`PutRecordInput`](crate::input::PutRecordInput)
pub mod put_record_input {
    /// A builder for [`PutRecordInput`](crate::input::PutRecordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) record: std::option::Option<crate::model::Record>,
    }
    impl Builder {
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>The record.</p>
        pub fn record(mut self, input: crate::model::Record) -> Self {
            self.record = Some(input);
            self
        }
        /// <p>The record.</p>
        pub fn set_record(mut self, input: std::option::Option<crate::model::Record>) -> Self {
            self.record = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecordInput`](crate::input::PutRecordInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutRecordInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutRecordInput {
                delivery_stream_name: self.delivery_stream_name,
                record: self.record,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRecordInputOperationOutputAlias = crate::operation::PutRecord;
#[doc(hidden)]
pub type PutRecordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRecordInput {
    /// Consumes the builder and constructs an Operation<[`PutRecord`](crate::operation::PutRecord)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRecord,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRecordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRecordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRecordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.PutRecord",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_record(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutRecord::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutRecord",
                    "firehose",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRecordInput`](crate::input::PutRecordInput)
    pub fn builder() -> crate::input::put_record_input::Builder {
        crate::input::put_record_input::Builder::default()
    }
}

/// See [`PutRecordBatchInput`](crate::input::PutRecordBatchInput)
pub mod put_record_batch_input {
    /// A builder for [`PutRecordBatchInput`](crate::input::PutRecordBatchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) records: std::option::Option<std::vec::Vec<crate::model::Record>>,
    }
    impl Builder {
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// <p>One or more records.</p>
        pub fn records(mut self, input: impl Into<crate::model::Record>) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input.into());
            self.records = Some(v);
            self
        }
        /// <p>One or more records.</p>
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Record>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecordBatchInput`](crate::input::PutRecordBatchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRecordBatchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRecordBatchInput {
                delivery_stream_name: self.delivery_stream_name,
                records: self.records,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRecordBatchInputOperationOutputAlias = crate::operation::PutRecordBatch;
#[doc(hidden)]
pub type PutRecordBatchInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRecordBatchInput {
    /// Consumes the builder and constructs an Operation<[`PutRecordBatch`](crate::operation::PutRecordBatch)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRecordBatch,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRecordBatchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRecordBatchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRecordBatchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.PutRecordBatch",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_record_batch(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRecordBatch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRecordBatch",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRecordBatchInput`](crate::input::PutRecordBatchInput)
    pub fn builder() -> crate::input::put_record_batch_input::Builder {
        crate::input::put_record_batch_input::Builder::default()
    }
}

/// See [`StartDeliveryStreamEncryptionInput`](crate::input::StartDeliveryStreamEncryptionInput)
pub mod start_delivery_stream_encryption_input {
    /// A builder for [`StartDeliveryStreamEncryptionInput`](crate::input::StartDeliveryStreamEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_encryption_configuration_input:
            std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
    }
    impl Builder {
        /// <p>The name of the delivery stream for which you want to enable server-side encryption
        /// (SSE).</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream for which you want to enable server-side encryption
        /// (SSE).</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for
        /// Server-Side Encryption (SSE).</p>
        pub fn delivery_stream_encryption_configuration_input(
            mut self,
            input: crate::model::DeliveryStreamEncryptionConfigurationInput,
        ) -> Self {
            self.delivery_stream_encryption_configuration_input = Some(input);
            self
        }
        /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for
        /// Server-Side Encryption (SSE).</p>
        pub fn set_delivery_stream_encryption_configuration_input(
            mut self,
            input: std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
        ) -> Self {
            self.delivery_stream_encryption_configuration_input = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDeliveryStreamEncryptionInput`](crate::input::StartDeliveryStreamEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDeliveryStreamEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDeliveryStreamEncryptionInput {
                delivery_stream_name: self.delivery_stream_name,
                delivery_stream_encryption_configuration_input: self
                    .delivery_stream_encryption_configuration_input,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDeliveryStreamEncryptionInputOperationOutputAlias =
    crate::operation::StartDeliveryStreamEncryption;
#[doc(hidden)]
pub type StartDeliveryStreamEncryptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDeliveryStreamEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`StartDeliveryStreamEncryption`](crate::operation::StartDeliveryStreamEncryption)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDeliveryStreamEncryption,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDeliveryStreamEncryptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDeliveryStreamEncryptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDeliveryStreamEncryptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.StartDeliveryStreamEncryption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_delivery_stream_encryption(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDeliveryStreamEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDeliveryStreamEncryption",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDeliveryStreamEncryptionInput`](crate::input::StartDeliveryStreamEncryptionInput)
    pub fn builder() -> crate::input::start_delivery_stream_encryption_input::Builder {
        crate::input::start_delivery_stream_encryption_input::Builder::default()
    }
}

/// See [`StopDeliveryStreamEncryptionInput`](crate::input::StopDeliveryStreamEncryptionInput)
pub mod stop_delivery_stream_encryption_input {
    /// A builder for [`StopDeliveryStreamEncryptionInput`](crate::input::StopDeliveryStreamEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the delivery stream for which you want to disable server-side encryption
        /// (SSE).</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream for which you want to disable server-side encryption
        /// (SSE).</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDeliveryStreamEncryptionInput`](crate::input::StopDeliveryStreamEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDeliveryStreamEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDeliveryStreamEncryptionInput {
                delivery_stream_name: self.delivery_stream_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDeliveryStreamEncryptionInputOperationOutputAlias =
    crate::operation::StopDeliveryStreamEncryption;
#[doc(hidden)]
pub type StopDeliveryStreamEncryptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopDeliveryStreamEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`StopDeliveryStreamEncryption`](crate::operation::StopDeliveryStreamEncryption)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDeliveryStreamEncryption,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDeliveryStreamEncryptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDeliveryStreamEncryptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDeliveryStreamEncryptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.StopDeliveryStreamEncryption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_delivery_stream_encryption(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDeliveryStreamEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDeliveryStreamEncryption",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDeliveryStreamEncryptionInput`](crate::input::StopDeliveryStreamEncryptionInput)
    pub fn builder() -> crate::input::stop_delivery_stream_encryption_input::Builder {
        crate::input::stop_delivery_stream_encryption_input::Builder::default()
    }
}

/// See [`TagDeliveryStreamInput`](crate::input::TagDeliveryStreamInput)
pub mod tag_delivery_stream_input {
    /// A builder for [`TagDeliveryStreamInput`](crate::input::TagDeliveryStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the delivery stream to which you want to add the tags.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream to which you want to add the tags.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of key-value pairs to use to create the tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A set of key-value pairs to use to create the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagDeliveryStreamInput`](crate::input::TagDeliveryStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagDeliveryStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagDeliveryStreamInput {
                delivery_stream_name: self.delivery_stream_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagDeliveryStreamInputOperationOutputAlias = crate::operation::TagDeliveryStream;
#[doc(hidden)]
pub type TagDeliveryStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagDeliveryStreamInput {
    /// Consumes the builder and constructs an Operation<[`TagDeliveryStream`](crate::operation::TagDeliveryStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagDeliveryStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagDeliveryStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagDeliveryStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagDeliveryStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.TagDeliveryStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_tag_delivery_stream(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagDeliveryStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagDeliveryStream",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagDeliveryStreamInput`](crate::input::TagDeliveryStreamInput)
    pub fn builder() -> crate::input::tag_delivery_stream_input::Builder {
        crate::input::tag_delivery_stream_input::Builder::default()
    }
}

/// See [`UntagDeliveryStreamInput`](crate::input::UntagDeliveryStreamInput)
pub mod untag_delivery_stream_input {
    /// A builder for [`UntagDeliveryStreamInput`](crate::input::UntagDeliveryStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Each corresponding tag is removed from the delivery
        /// stream.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys. Each corresponding tag is removed from the delivery
        /// stream.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagDeliveryStreamInput`](crate::input::UntagDeliveryStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagDeliveryStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagDeliveryStreamInput {
                delivery_stream_name: self.delivery_stream_name,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagDeliveryStreamInputOperationOutputAlias = crate::operation::UntagDeliveryStream;
#[doc(hidden)]
pub type UntagDeliveryStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagDeliveryStreamInput {
    /// Consumes the builder and constructs an Operation<[`UntagDeliveryStream`](crate::operation::UntagDeliveryStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagDeliveryStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagDeliveryStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagDeliveryStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagDeliveryStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.UntagDeliveryStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_untag_delivery_stream(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagDeliveryStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagDeliveryStream",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagDeliveryStreamInput`](crate::input::UntagDeliveryStreamInput)
    pub fn builder() -> crate::input::untag_delivery_stream_input::Builder {
        crate::input::untag_delivery_stream_input::Builder::default()
    }
}

/// See [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
pub mod update_destination_input {
    /// A builder for [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) current_delivery_stream_version_id: std::option::Option<std::string::String>,
        pub(crate) destination_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination_update: std::option::Option<crate::model::S3DestinationUpdate>,
        pub(crate) extended_s3_destination_update:
            std::option::Option<crate::model::ExtendedS3DestinationUpdate>,
        pub(crate) redshift_destination_update:
            std::option::Option<crate::model::RedshiftDestinationUpdate>,
        pub(crate) elasticsearch_destination_update:
            std::option::Option<crate::model::ElasticsearchDestinationUpdate>,
        pub(crate) amazonopensearchservice_destination_update:
            std::option::Option<crate::model::AmazonopensearchserviceDestinationUpdate>,
        pub(crate) splunk_destination_update:
            std::option::Option<crate::model::SplunkDestinationUpdate>,
        pub(crate) http_endpoint_destination_update:
            std::option::Option<crate::model::HttpEndpointDestinationUpdate>,
    }
    impl Builder {
        /// <p>The name of the delivery stream.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery stream.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This value is required, and helps the service
        /// perform conditional operations. For example, if there is an interleaving update and this
        /// value is null, then the update destination fails. After the update is successful, the
        /// <code>VersionId</code> value is updated. The service then performs a merge of the old
        /// configuration with the new configuration.</p>
        pub fn current_delivery_stream_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_delivery_stream_version_id = Some(input.into());
            self
        }
        /// <p>Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This value is required, and helps the service
        /// perform conditional operations. For example, if there is an interleaving update and this
        /// value is null, then the update destination fails. After the update is successful, the
        /// <code>VersionId</code> value is updated. The service then performs a merge of the old
        /// configuration with the new configuration.</p>
        pub fn set_current_delivery_stream_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_delivery_stream_version_id = input;
            self
        }
        /// <p>The ID of the destination.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_id = Some(input.into());
            self
        }
        /// <p>The ID of the destination.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_id = input;
            self
        }
        /// <p>[Deprecated] Describes an update for a destination in Amazon S3.</p>
        pub fn s3_destination_update(mut self, input: crate::model::S3DestinationUpdate) -> Self {
            self.s3_destination_update = Some(input);
            self
        }
        /// <p>[Deprecated] Describes an update for a destination in Amazon S3.</p>
        pub fn set_s3_destination_update(
            mut self,
            input: std::option::Option<crate::model::S3DestinationUpdate>,
        ) -> Self {
            self.s3_destination_update = input;
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn extended_s3_destination_update(
            mut self,
            input: crate::model::ExtendedS3DestinationUpdate,
        ) -> Self {
            self.extended_s3_destination_update = Some(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon S3.</p>
        pub fn set_extended_s3_destination_update(
            mut self,
            input: std::option::Option<crate::model::ExtendedS3DestinationUpdate>,
        ) -> Self {
            self.extended_s3_destination_update = input;
            self
        }
        /// <p>Describes an update for a destination in Amazon Redshift.</p>
        pub fn redshift_destination_update(
            mut self,
            input: crate::model::RedshiftDestinationUpdate,
        ) -> Self {
            self.redshift_destination_update = Some(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon Redshift.</p>
        pub fn set_redshift_destination_update(
            mut self,
            input: std::option::Option<crate::model::RedshiftDestinationUpdate>,
        ) -> Self {
            self.redshift_destination_update = input;
            self
        }
        /// <p>Describes an update for a destination in Amazon ES.</p>
        pub fn elasticsearch_destination_update(
            mut self,
            input: crate::model::ElasticsearchDestinationUpdate,
        ) -> Self {
            self.elasticsearch_destination_update = Some(input);
            self
        }
        /// <p>Describes an update for a destination in Amazon ES.</p>
        pub fn set_elasticsearch_destination_update(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDestinationUpdate>,
        ) -> Self {
            self.elasticsearch_destination_update = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn amazonopensearchservice_destination_update(
            mut self,
            input: crate::model::AmazonopensearchserviceDestinationUpdate,
        ) -> Self {
            self.amazonopensearchservice_destination_update = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_amazonopensearchservice_destination_update(
            mut self,
            input: std::option::Option<crate::model::AmazonopensearchserviceDestinationUpdate>,
        ) -> Self {
            self.amazonopensearchservice_destination_update = input;
            self
        }
        /// <p>Describes an update for a destination in Splunk.</p>
        pub fn splunk_destination_update(
            mut self,
            input: crate::model::SplunkDestinationUpdate,
        ) -> Self {
            self.splunk_destination_update = Some(input);
            self
        }
        /// <p>Describes an update for a destination in Splunk.</p>
        pub fn set_splunk_destination_update(
            mut self,
            input: std::option::Option<crate::model::SplunkDestinationUpdate>,
        ) -> Self {
            self.splunk_destination_update = input;
            self
        }
        /// <p>Describes an update to the specified HTTP endpoint destination.</p>
        pub fn http_endpoint_destination_update(
            mut self,
            input: crate::model::HttpEndpointDestinationUpdate,
        ) -> Self {
            self.http_endpoint_destination_update = Some(input);
            self
        }
        /// <p>Describes an update to the specified HTTP endpoint destination.</p>
        pub fn set_http_endpoint_destination_update(
            mut self,
            input: std::option::Option<crate::model::HttpEndpointDestinationUpdate>,
        ) -> Self {
            self.http_endpoint_destination_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDestinationInput {
                delivery_stream_name: self.delivery_stream_name,
                current_delivery_stream_version_id: self.current_delivery_stream_version_id,
                destination_id: self.destination_id,
                s3_destination_update: self.s3_destination_update,
                extended_s3_destination_update: self.extended_s3_destination_update,
                redshift_destination_update: self.redshift_destination_update,
                elasticsearch_destination_update: self.elasticsearch_destination_update,
                amazonopensearchservice_destination_update: self
                    .amazonopensearchservice_destination_update,
                splunk_destination_update: self.splunk_destination_update,
                http_endpoint_destination_update: self.http_endpoint_destination_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDestinationInputOperationOutputAlias = crate::operation::UpdateDestination;
#[doc(hidden)]
pub type UpdateDestinationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDestination`](crate::operation::UpdateDestination)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Firehose_20150804.UpdateDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_destination(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDestination",
            "firehose",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
    pub fn builder() -> crate::input::update_destination_input::Builder {
        crate::input::update_destination_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDestinationInput {
    /// <p>The name of the delivery stream.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This value is required, and helps the service
    /// perform conditional operations. For example, if there is an interleaving update and this
    /// value is null, then the update destination fails. After the update is successful, the
    /// <code>VersionId</code> value is updated. The service then performs a merge of the old
    /// configuration with the new configuration.</p>
    pub current_delivery_stream_version_id: std::option::Option<std::string::String>,
    /// <p>The ID of the destination.</p>
    pub destination_id: std::option::Option<std::string::String>,
    /// <p>[Deprecated] Describes an update for a destination in Amazon S3.</p>
    pub s3_destination_update: std::option::Option<crate::model::S3DestinationUpdate>,
    /// <p>Describes an update for a destination in Amazon S3.</p>
    pub extended_s3_destination_update:
        std::option::Option<crate::model::ExtendedS3DestinationUpdate>,
    /// <p>Describes an update for a destination in Amazon Redshift.</p>
    pub redshift_destination_update: std::option::Option<crate::model::RedshiftDestinationUpdate>,
    /// <p>Describes an update for a destination in Amazon ES.</p>
    pub elasticsearch_destination_update:
        std::option::Option<crate::model::ElasticsearchDestinationUpdate>,
    #[allow(missing_docs)] // documentation missing in model
    pub amazonopensearchservice_destination_update:
        std::option::Option<crate::model::AmazonopensearchserviceDestinationUpdate>,
    /// <p>Describes an update for a destination in Splunk.</p>
    pub splunk_destination_update: std::option::Option<crate::model::SplunkDestinationUpdate>,
    /// <p>Describes an update to the specified HTTP endpoint destination.</p>
    pub http_endpoint_destination_update:
        std::option::Option<crate::model::HttpEndpointDestinationUpdate>,
}
impl std::fmt::Debug for UpdateDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDestinationInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field(
            "current_delivery_stream_version_id",
            &self.current_delivery_stream_version_id,
        );
        formatter.field("destination_id", &self.destination_id);
        formatter.field("s3_destination_update", &self.s3_destination_update);
        formatter.field(
            "extended_s3_destination_update",
            &self.extended_s3_destination_update,
        );
        formatter.field(
            "redshift_destination_update",
            &self.redshift_destination_update,
        );
        formatter.field(
            "elasticsearch_destination_update",
            &self.elasticsearch_destination_update,
        );
        formatter.field(
            "amazonopensearchservice_destination_update",
            &self.amazonopensearchservice_destination_update,
        );
        formatter.field("splunk_destination_update", &self.splunk_destination_update);
        formatter.field(
            "http_endpoint_destination_update",
            &self.http_endpoint_destination_update,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagDeliveryStreamInput {
    /// <p>The name of the delivery stream.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>A list of tag keys. Each corresponding tag is removed from the delivery
    /// stream.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagDeliveryStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagDeliveryStreamInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagDeliveryStreamInput {
    /// <p>The name of the delivery stream to which you want to add the tags.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>A set of key-value pairs to use to create the tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagDeliveryStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagDeliveryStreamInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDeliveryStreamEncryptionInput {
    /// <p>The name of the delivery stream for which you want to disable server-side encryption
    /// (SSE).</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopDeliveryStreamEncryptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDeliveryStreamEncryptionInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDeliveryStreamEncryptionInput {
    /// <p>The name of the delivery stream for which you want to enable server-side encryption
    /// (SSE).</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for
    /// Server-Side Encryption (SSE).</p>
    pub delivery_stream_encryption_configuration_input:
        std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
}
impl std::fmt::Debug for StartDeliveryStreamEncryptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeliveryStreamEncryptionInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field(
            "delivery_stream_encryption_configuration_input",
            &self.delivery_stream_encryption_configuration_input,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecordBatchInput {
    /// <p>The name of the delivery stream.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>One or more records.</p>
    pub records: std::option::Option<std::vec::Vec<crate::model::Record>>,
}
impl std::fmt::Debug for PutRecordBatchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecordBatchInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("records", &self.records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecordInput {
    /// <p>The name of the delivery stream.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>The record.</p>
    pub record: std::option::Option<crate::model::Record>,
}
impl std::fmt::Debug for PutRecordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecordInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("record", &self.record);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForDeliveryStreamInput {
    /// <p>The name of the delivery stream whose tags you want to list.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>The key to use as the starting point for the list of tags. If you set this parameter,
    /// <code>ListTagsForDeliveryStream</code> gets all tags that occur after
    /// <code>ExclusiveStartTagKey</code>.</p>
    pub exclusive_start_tag_key: std::option::Option<std::string::String>,
    /// <p>The number of tags to return. If this number is less than the total number of tags
    /// associated with the delivery stream, <code>HasMoreTags</code> is set to <code>true</code>
    /// in the response. To list additional tags, set <code>ExclusiveStartTagKey</code> to the last
    /// key in the response. </p>
    pub limit: std::option::Option<i32>,
}
impl std::fmt::Debug for ListTagsForDeliveryStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForDeliveryStreamInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("exclusive_start_tag_key", &self.exclusive_start_tag_key);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeliveryStreamsInput {
    /// <p>The maximum number of delivery streams to list. The default value is 10.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The delivery stream type. This can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DirectPut</code>: Provider applications access the delivery stream
    /// directly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
    /// stream as a source.</p>
    /// </li>
    /// </ul>
    /// <p>This parameter is optional. If this parameter is omitted, delivery streams of all
    /// types are returned.</p>
    pub delivery_stream_type: std::option::Option<crate::model::DeliveryStreamType>,
    /// <p>The list of delivery streams returned by this call to
    /// <code>ListDeliveryStreams</code> will start with the delivery stream whose name comes
    /// alphabetically immediately after the name you specify in
    /// <code>ExclusiveStartDeliveryStreamName</code>.</p>
    pub exclusive_start_delivery_stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeliveryStreamsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeliveryStreamsInput");
        formatter.field("limit", &self.limit);
        formatter.field("delivery_stream_type", &self.delivery_stream_type);
        formatter.field(
            "exclusive_start_delivery_stream_name",
            &self.exclusive_start_delivery_stream_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeliveryStreamInput {
    /// <p>The name of the delivery stream.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>The limit on the number of destinations to return. You can have one destination per
    /// delivery stream.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The ID of the destination to start returning the destination information. Kinesis
    /// Data Firehose supports one destination per delivery stream.</p>
    pub exclusive_start_destination_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDeliveryStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeliveryStreamInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("limit", &self.limit);
        formatter.field(
            "exclusive_start_destination_id",
            &self.exclusive_start_destination_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeliveryStreamInput {
    /// <p>The name of the delivery stream.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose
    /// is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire
    /// the grant due to a customer error, such as when the CMK or the grant are in an invalid
    /// state. If you force deletion, you can then use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to
    /// revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant
    /// happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete
    /// operation.</p>
    /// <p>The default value is false.</p>
    pub allow_force_delete: std::option::Option<bool>,
}
impl std::fmt::Debug for DeleteDeliveryStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeliveryStreamInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("allow_force_delete", &self.allow_force_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeliveryStreamInput {
    /// <p>The name of the delivery stream. This name must be unique per AWS account in the same
    /// AWS Region. If the delivery streams are in different accounts or different Regions, you can
    /// have multiple delivery streams with the same name.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>The delivery stream type. This parameter can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DirectPut</code>: Provider applications access the delivery stream
    /// directly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data
    /// stream as a source.</p>
    /// </li>
    /// </ul>
    pub delivery_stream_type: std::option::Option<crate::model::DeliveryStreamType>,
    /// <p>When a Kinesis data stream is used as the source for the delivery stream, a <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon
    /// Resource Name (ARN) and the role ARN for the source stream.</p>
    pub kinesis_stream_source_configuration:
        std::option::Option<crate::model::KinesisStreamSourceConfiguration>,
    /// <p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for
    /// Server-Side Encryption (SSE).</p>
    pub delivery_stream_encryption_configuration_input:
        std::option::Option<crate::model::DeliveryStreamEncryptionConfigurationInput>,
    /// <p>[Deprecated]
    /// The destination in Amazon S3. You can specify only one destination.</p>
    pub s3_destination_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
    /// <p>The destination in Amazon S3. You can specify only one destination.</p>
    pub extended_s3_destination_configuration:
        std::option::Option<crate::model::ExtendedS3DestinationConfiguration>,
    /// <p>The destination in Amazon Redshift. You can specify only one destination.</p>
    pub redshift_destination_configuration:
        std::option::Option<crate::model::RedshiftDestinationConfiguration>,
    /// <p>The destination in Amazon ES. You can specify only one destination.</p>
    pub elasticsearch_destination_configuration:
        std::option::Option<crate::model::ElasticsearchDestinationConfiguration>,
    #[allow(missing_docs)] // documentation missing in model
    pub amazonopensearchservice_destination_configuration:
        std::option::Option<crate::model::AmazonopensearchserviceDestinationConfiguration>,
    /// <p>The destination in Splunk. You can specify only one destination.</p>
    pub splunk_destination_configuration:
        std::option::Option<crate::model::SplunkDestinationConfiguration>,
    /// <p>Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
    /// You can specify only one destination.</p>
    pub http_endpoint_destination_configuration:
        std::option::Option<crate::model::HttpEndpointDestinationConfiguration>,
    /// <p>A set of tags to assign to the delivery stream. A tag is a key-value pair that you can
    /// define and assign to AWS resources. Tags are metadata. For example, you can add friendly
    /// names and descriptions or other types of information that can help you distinguish the
    /// delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
    /// Tags</a> in the AWS Billing and Cost Management User Guide.</p>
    ///
    /// <p>You can specify up to 50 tags when creating a delivery stream.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDeliveryStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeliveryStreamInput");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("delivery_stream_type", &self.delivery_stream_type);
        formatter.field(
            "kinesis_stream_source_configuration",
            &self.kinesis_stream_source_configuration,
        );
        formatter.field(
            "delivery_stream_encryption_configuration_input",
            &self.delivery_stream_encryption_configuration_input,
        );
        formatter.field(
            "s3_destination_configuration",
            &self.s3_destination_configuration,
        );
        formatter.field(
            "extended_s3_destination_configuration",
            &self.extended_s3_destination_configuration,
        );
        formatter.field(
            "redshift_destination_configuration",
            &self.redshift_destination_configuration,
        );
        formatter.field(
            "elasticsearch_destination_configuration",
            &self.elasticsearch_destination_configuration,
        );
        formatter.field(
            "amazonopensearchservice_destination_configuration",
            &self.amazonopensearchservice_destination_configuration,
        );
        formatter.field(
            "splunk_destination_configuration",
            &self.splunk_destination_configuration,
        );
        formatter.field(
            "http_endpoint_destination_configuration",
            &self.http_endpoint_destination_configuration,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
