// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeliveryStreamError {
    /// Kind of error that occurred.
    pub kind: CreateDeliveryStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeliveryStreamErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Kinesis Data Firehose throws this exception when an attempt to put records or to start
    /// or stop delivery stream encryption fails. This happens when the KMS service throws one of
    /// the following exception types: <code>AccessDeniedException</code>,
    /// <code>InvalidStateException</code>, <code>DisabledException</code>, or
    /// <code>NotFoundException</code>.</p>
    InvalidKmsResourceException(crate::error::InvalidKmsResourceException),
    /// <p>You have already reached the limit for a requested resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is already in use and not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeliveryStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeliveryStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateDeliveryStreamErrorKind::InvalidKmsResourceException(_inner) => _inner.fmt(f),
            CreateDeliveryStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDeliveryStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateDeliveryStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeliveryStreamError {
    fn code(&self) -> Option<&str> {
        CreateDeliveryStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeliveryStreamError {
    /// Creates a new `CreateDeliveryStreamError`.
    pub fn new(kind: CreateDeliveryStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeliveryStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeliveryStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeliveryStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeliveryStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDeliveryStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliveryStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeliveryStreamErrorKind::InvalidKmsResourceException`.
    pub fn is_invalid_kms_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliveryStreamErrorKind::InvalidKmsResourceException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeliveryStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliveryStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeliveryStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliveryStreamErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for CreateDeliveryStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeliveryStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateDeliveryStreamErrorKind::InvalidKmsResourceException(_inner) => Some(_inner),
            CreateDeliveryStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDeliveryStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateDeliveryStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeliveryStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteDeliveryStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeliveryStreamErrorKind {
    /// <p>The resource is already in use and not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeliveryStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeliveryStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDeliveryStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeliveryStreamError {
    fn code(&self) -> Option<&str> {
        DeleteDeliveryStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeliveryStreamError {
    /// Creates a new `DeleteDeliveryStreamError`.
    pub fn new(kind: DeleteDeliveryStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeliveryStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeliveryStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeliveryStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeliveryStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDeliveryStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeliveryStreamErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeliveryStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeliveryStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDeliveryStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeliveryStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDeliveryStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDeliveryStreamError {
    /// Kind of error that occurred.
    pub kind: DescribeDeliveryStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDeliveryStreamErrorKind {
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDeliveryStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDeliveryStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDeliveryStreamError {
    fn code(&self) -> Option<&str> {
        DescribeDeliveryStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDeliveryStreamError {
    /// Creates a new `DescribeDeliveryStreamError`.
    pub fn new(kind: DescribeDeliveryStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDeliveryStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDeliveryStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDeliveryStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDeliveryStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDeliveryStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeliveryStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDeliveryStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDeliveryStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeliveryStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeliveryStreamsError {
    /// Kind of error that occurred.
    pub kind: ListDeliveryStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeliveryStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeliveryStreamsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeliveryStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeliveryStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeliveryStreamsError {
    fn code(&self) -> Option<&str> {
        ListDeliveryStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeliveryStreamsError {
    /// Creates a new `ListDeliveryStreamsError`.
    pub fn new(kind: ListDeliveryStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeliveryStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeliveryStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeliveryStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeliveryStreamsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListDeliveryStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeliveryStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForDeliveryStreamError {
    /// Kind of error that occurred.
    pub kind: ListTagsForDeliveryStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForDeliveryStreamErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>You have already reached the limit for a requested resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForDeliveryStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForDeliveryStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListTagsForDeliveryStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForDeliveryStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForDeliveryStreamError {
    fn code(&self) -> Option<&str> {
        ListTagsForDeliveryStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForDeliveryStreamError {
    /// Creates a new `ListTagsForDeliveryStreamError`.
    pub fn new(kind: ListTagsForDeliveryStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForDeliveryStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForDeliveryStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForDeliveryStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForDeliveryStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForDeliveryStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForDeliveryStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForDeliveryStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForDeliveryStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForDeliveryStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForDeliveryStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForDeliveryStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForDeliveryStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListTagsForDeliveryStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTagsForDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForDeliveryStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRecordError {
    /// Kind of error that occurred.
    pub kind: PutRecordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRecordErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Kinesis Data Firehose throws this exception when an attempt to put records or to start
    /// or stop delivery stream encryption fails. This happens when the KMS service throws one of
    /// the following exception types: <code>AccessDeniedException</code>,
    /// <code>InvalidStateException</code>, <code>DisabledException</code>, or
    /// <code>NotFoundException</code>.</p>
    InvalidKmsResourceException(crate::error::InvalidKmsResourceException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is unavailable. Back off and retry the operation. If you continue to see
    /// the exception, throughput limits for the delivery stream may have been exceeded. For more
    /// information about limits and how to request an increase, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose
    /// Limits</a>.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRecordErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::InvalidKmsResourceException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRecordError {
    fn code(&self) -> Option<&str> {
        PutRecordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRecordError {
    /// Creates a new `PutRecordError`.
    pub fn new(kind: PutRecordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRecordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRecordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRecordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRecordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutRecordErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::InvalidArgumentException(_))
    }
    /// Returns true if the error kind is `PutRecordErrorKind::InvalidKmsResourceException`.
    pub fn is_invalid_kms_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordErrorKind::InvalidKmsResourceException(_)
        )
    }
    /// Returns true if the error kind is `PutRecordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `PutRecordErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutRecordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRecordErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            PutRecordErrorKind::InvalidKmsResourceException(_inner) => Some(_inner),
            PutRecordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutRecordErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutRecordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRecordBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRecordBatchError {
    /// Kind of error that occurred.
    pub kind: PutRecordBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRecordBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRecordBatchErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Kinesis Data Firehose throws this exception when an attempt to put records or to start
    /// or stop delivery stream encryption fails. This happens when the KMS service throws one of
    /// the following exception types: <code>AccessDeniedException</code>,
    /// <code>InvalidStateException</code>, <code>DisabledException</code>, or
    /// <code>NotFoundException</code>.</p>
    InvalidKmsResourceException(crate::error::InvalidKmsResourceException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is unavailable. Back off and retry the operation. If you continue to see
    /// the exception, throughput limits for the delivery stream may have been exceeded. For more
    /// information about limits and how to request an increase, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose
    /// Limits</a>.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRecordBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRecordBatchErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            PutRecordBatchErrorKind::InvalidKmsResourceException(_inner) => _inner.fmt(f),
            PutRecordBatchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutRecordBatchErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutRecordBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRecordBatchError {
    fn code(&self) -> Option<&str> {
        PutRecordBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRecordBatchError {
    /// Creates a new `PutRecordBatchError`.
    pub fn new(kind: PutRecordBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRecordBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRecordBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRecordBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRecordBatchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutRecordBatchErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordBatchErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `PutRecordBatchErrorKind::InvalidKmsResourceException`.
    pub fn is_invalid_kms_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordBatchErrorKind::InvalidKmsResourceException(_)
        )
    }
    /// Returns true if the error kind is `PutRecordBatchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordBatchErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutRecordBatchErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordBatchErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutRecordBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRecordBatchErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            PutRecordBatchErrorKind::InvalidKmsResourceException(_inner) => Some(_inner),
            PutRecordBatchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutRecordBatchErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutRecordBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDeliveryStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDeliveryStreamEncryptionError {
    /// Kind of error that occurred.
    pub kind: StartDeliveryStreamEncryptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDeliveryStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDeliveryStreamEncryptionErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Kinesis Data Firehose throws this exception when an attempt to put records or to start
    /// or stop delivery stream encryption fails. This happens when the KMS service throws one of
    /// the following exception types: <code>AccessDeniedException</code>,
    /// <code>InvalidStateException</code>, <code>DisabledException</code>, or
    /// <code>NotFoundException</code>.</p>
    InvalidKmsResourceException(crate::error::InvalidKmsResourceException),
    /// <p>You have already reached the limit for a requested resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is already in use and not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDeliveryStreamEncryptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDeliveryStreamEncryptionErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            StartDeliveryStreamEncryptionErrorKind::InvalidKmsResourceException(_inner) => {
                _inner.fmt(f)
            }
            StartDeliveryStreamEncryptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartDeliveryStreamEncryptionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StartDeliveryStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartDeliveryStreamEncryptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDeliveryStreamEncryptionError {
    fn code(&self) -> Option<&str> {
        StartDeliveryStreamEncryptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDeliveryStreamEncryptionError {
    /// Creates a new `StartDeliveryStreamEncryptionError`.
    pub fn new(
        kind: StartDeliveryStreamEncryptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDeliveryStreamEncryptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDeliveryStreamEncryptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDeliveryStreamEncryptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDeliveryStreamEncryptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartDeliveryStreamEncryptionErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeliveryStreamEncryptionErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `StartDeliveryStreamEncryptionErrorKind::InvalidKmsResourceException`.
    pub fn is_invalid_kms_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeliveryStreamEncryptionErrorKind::InvalidKmsResourceException(_)
        )
    }
    /// Returns true if the error kind is `StartDeliveryStreamEncryptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeliveryStreamEncryptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `StartDeliveryStreamEncryptionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeliveryStreamEncryptionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `StartDeliveryStreamEncryptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeliveryStreamEncryptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartDeliveryStreamEncryptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDeliveryStreamEncryptionErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            StartDeliveryStreamEncryptionErrorKind::InvalidKmsResourceException(_inner) => {
                Some(_inner)
            }
            StartDeliveryStreamEncryptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartDeliveryStreamEncryptionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StartDeliveryStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StartDeliveryStreamEncryptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDeliveryStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDeliveryStreamEncryptionError {
    /// Kind of error that occurred.
    pub kind: StopDeliveryStreamEncryptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDeliveryStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDeliveryStreamEncryptionErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>You have already reached the limit for a requested resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is already in use and not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDeliveryStreamEncryptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDeliveryStreamEncryptionErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            StopDeliveryStreamEncryptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StopDeliveryStreamEncryptionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StopDeliveryStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StopDeliveryStreamEncryptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDeliveryStreamEncryptionError {
    fn code(&self) -> Option<&str> {
        StopDeliveryStreamEncryptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDeliveryStreamEncryptionError {
    /// Creates a new `StopDeliveryStreamEncryptionError`.
    pub fn new(kind: StopDeliveryStreamEncryptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDeliveryStreamEncryptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDeliveryStreamEncryptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDeliveryStreamEncryptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDeliveryStreamEncryptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopDeliveryStreamEncryptionErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDeliveryStreamEncryptionErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `StopDeliveryStreamEncryptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDeliveryStreamEncryptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `StopDeliveryStreamEncryptionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDeliveryStreamEncryptionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `StopDeliveryStreamEncryptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDeliveryStreamEncryptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopDeliveryStreamEncryptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDeliveryStreamEncryptionErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            StopDeliveryStreamEncryptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            StopDeliveryStreamEncryptionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StopDeliveryStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StopDeliveryStreamEncryptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagDeliveryStreamError {
    /// Kind of error that occurred.
    pub kind: TagDeliveryStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagDeliveryStreamErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>You have already reached the limit for a requested resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is already in use and not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagDeliveryStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagDeliveryStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            TagDeliveryStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagDeliveryStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            TagDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagDeliveryStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagDeliveryStreamError {
    fn code(&self) -> Option<&str> {
        TagDeliveryStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagDeliveryStreamError {
    /// Creates a new `TagDeliveryStreamError`.
    pub fn new(kind: TagDeliveryStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagDeliveryStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagDeliveryStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagDeliveryStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagDeliveryStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagDeliveryStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagDeliveryStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `TagDeliveryStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagDeliveryStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `TagDeliveryStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagDeliveryStreamErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `TagDeliveryStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagDeliveryStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagDeliveryStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagDeliveryStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            TagDeliveryStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagDeliveryStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            TagDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagDeliveryStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagDeliveryStreamError {
    /// Kind of error that occurred.
    pub kind: UntagDeliveryStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagDeliveryStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagDeliveryStreamErrorKind {
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>You have already reached the limit for a requested resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is already in use and not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagDeliveryStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagDeliveryStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UntagDeliveryStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagDeliveryStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UntagDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagDeliveryStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagDeliveryStreamError {
    fn code(&self) -> Option<&str> {
        UntagDeliveryStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagDeliveryStreamError {
    /// Creates a new `UntagDeliveryStreamError`.
    pub fn new(kind: UntagDeliveryStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagDeliveryStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagDeliveryStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagDeliveryStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagDeliveryStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagDeliveryStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagDeliveryStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UntagDeliveryStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagDeliveryStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UntagDeliveryStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagDeliveryStreamErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `UntagDeliveryStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagDeliveryStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagDeliveryStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagDeliveryStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UntagDeliveryStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagDeliveryStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UntagDeliveryStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagDeliveryStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdateDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDestinationErrorKind {
    /// <p>Another modification has already happened. Fetch <code>VersionId</code> again and use
    /// it to update the destination.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified input parameter has a value that is not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is already in use and not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDestinationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDestinationError {
    fn code(&self) -> Option<&str> {
        UpdateDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDestinationError {
    /// Creates a new `UpdateDestinationError`.
    pub fn new(kind: UpdateDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDestinationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDestinationErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDestinationErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDestinationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The resource is already in use and not available for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The specified input parameter has a value that is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgumentException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgumentException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgumentException {}
/// See [`InvalidArgumentException`](crate::error::InvalidArgumentException)
pub mod invalid_argument_exception {
    /// A builder for [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgumentException`](crate::error::InvalidArgumentException)
        pub fn build(self) -> crate::error::InvalidArgumentException {
            crate::error::InvalidArgumentException {
                message: self.message,
            }
        }
    }
}
impl InvalidArgumentException {
    /// Creates a new builder-style object to manufacture [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    pub fn builder() -> crate::error::invalid_argument_exception::Builder {
        crate::error::invalid_argument_exception::Builder::default()
    }
}

/// <p>Another modification has already happened. Fetch <code>VersionId</code> again and use
/// it to update the destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>You have already reached the limit for a requested resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Kinesis Data Firehose throws this exception when an attempt to put records or to start
/// or stop delivery stream encryption fails. This happens when the KMS service throws one of
/// the following exception types: <code>AccessDeniedException</code>,
/// <code>InvalidStateException</code>, <code>DisabledException</code>, or
/// <code>NotFoundException</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKmsResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKmsResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKmsResourceException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKmsResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKmsResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidKmsResourceException [InvalidKMSResourceException]"
        )?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKmsResourceException {}
/// See [`InvalidKmsResourceException`](crate::error::InvalidKmsResourceException)
pub mod invalid_kms_resource_exception {
    /// A builder for [`InvalidKmsResourceException`](crate::error::InvalidKmsResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKmsResourceException`](crate::error::InvalidKmsResourceException)
        pub fn build(self) -> crate::error::InvalidKmsResourceException {
            crate::error::InvalidKmsResourceException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InvalidKmsResourceException {
    /// Creates a new builder-style object to manufacture [`InvalidKmsResourceException`](crate::error::InvalidKmsResourceException)
    pub fn builder() -> crate::error::invalid_kms_resource_exception::Builder {
        crate::error::invalid_kms_resource_exception::Builder::default()
    }
}

/// <p>The service is unavailable. Back off and retry the operation. If you continue to see
/// the exception, throughput limits for the delivery stream may have been exceeded. For more
/// information about limits and how to request an increase, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose
/// Limits</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}
