// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateChangeset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChangesetError {
    /// Kind of error that occurred.
    pub kind: CreateChangesetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChangeset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChangesetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChangesetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChangesetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateChangesetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChangesetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateChangesetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateChangesetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateChangesetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateChangesetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateChangesetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChangesetError {
    fn code(&self) -> Option<&str> {
        CreateChangesetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChangesetError {
    /// Creates a new `CreateChangesetError`.
    pub fn new(kind: CreateChangesetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChangesetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChangesetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChangesetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChangesetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChangesetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChangesetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChangesetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateChangesetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateChangesetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChangesetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChangesetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChangesetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChangesetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChangesetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChangesetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateChangesetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateChangesetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateChangesetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateChangesetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChangesetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateChangesetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChangesetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateChangesetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateChangesetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateChangesetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateChangesetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateChangesetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetError {
    fn code(&self) -> Option<&str> {
        CreateDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetError {
    /// Creates a new `CreateDatasetError`.
    pub fn new(kind: CreateDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDatasetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDatasetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataViewError {
    /// Kind of error that occurred.
    pub kind: CreateDataViewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataViewErrorKind {
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataViewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataViewErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDataViewErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDataViewErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDataViewErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDataViewErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDataViewErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDataViewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataViewError {
    fn code(&self) -> Option<&str> {
        CreateDataViewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataViewError {
    /// Creates a new `CreateDataViewError`.
    pub fn new(kind: CreateDataViewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataViewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataViewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataViewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataViewErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataViewErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDataViewErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDataViewErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataViewErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataViewErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataViewErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataViewErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataViewErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataViewErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDataViewErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDataViewErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDataViewErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDataViewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataViewErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDataViewErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDataViewErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDataViewErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDataViewErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDataViewErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDataViewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePermissionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePermissionGroupError {
    /// Kind of error that occurred.
    pub kind: CreatePermissionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePermissionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePermissionGroupErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePermissionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePermissionGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePermissionGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePermissionGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePermissionGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePermissionGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePermissionGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePermissionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePermissionGroupError {
    fn code(&self) -> Option<&str> {
        CreatePermissionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePermissionGroupError {
    /// Creates a new `CreatePermissionGroupError`.
    pub fn new(kind: CreatePermissionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePermissionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePermissionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePermissionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePermissionGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePermissionGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreatePermissionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePermissionGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePermissionGroupErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePermissionGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePermissionGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePermissionGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePermissionGroupErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePermissionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateUserErrorKind::ConflictException(_inner) => Some(_inner),
            CreateUserErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateUserErrorKind::ValidationException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetError {
    /// Creates a new `DeleteDatasetError`.
    pub fn new(kind: DeleteDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePermissionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePermissionGroupError {
    /// Kind of error that occurred.
    pub kind: DeletePermissionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePermissionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePermissionGroupErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePermissionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePermissionGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePermissionGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePermissionGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePermissionGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeletePermissionGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePermissionGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePermissionGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePermissionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePermissionGroupError {
    fn code(&self) -> Option<&str> {
        DeletePermissionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePermissionGroupError {
    /// Creates a new `DeletePermissionGroupError`.
    pub fn new(kind: DeletePermissionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePermissionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePermissionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePermissionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePermissionGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePermissionGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePermissionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePermissionGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePermissionGroupErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePermissionGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePermissionGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeletePermissionGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePermissionGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePermissionGroupErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePermissionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableUserError {
    /// Kind of error that occurred.
    pub kind: DisableUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableUserErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisableUserErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisableUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisableUserErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisableUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableUserError {
    fn code(&self) -> Option<&str> {
        DisableUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableUserError {
    /// Creates a new `DisableUserError`.
    pub fn new(kind: DisableUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DisableUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DisableUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DisableUserErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DisableUserErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DisableUserErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DisableUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DisableUserErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DisableUserErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DisableUserErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DisableUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableUserErrorKind::ConflictException(_inner) => Some(_inner),
            DisableUserErrorKind::InternalServerException(_inner) => Some(_inner),
            DisableUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisableUserErrorKind::ValidationException(_inner) => Some(_inner),
            DisableUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableUserError {
    /// Kind of error that occurred.
    pub kind: EnableUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableUserErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A limit has exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableUserError {
    fn code(&self) -> Option<&str> {
        EnableUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableUserError {
    /// Creates a new `EnableUserError`.
    pub fn new(kind: EnableUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, EnableUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, EnableUserErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, EnableUserErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, EnableUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, EnableUserErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, EnableUserErrorKind::ValidationException(_))
    }
}
impl std::error::Error for EnableUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableUserErrorKind::ConflictException(_inner) => Some(_inner),
            EnableUserErrorKind::InternalServerException(_inner) => Some(_inner),
            EnableUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            EnableUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            EnableUserErrorKind::ValidationException(_inner) => Some(_inner),
            EnableUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChangeset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChangesetError {
    /// Kind of error that occurred.
    pub kind: GetChangesetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChangeset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChangesetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChangesetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChangesetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetChangesetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetChangesetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetChangesetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetChangesetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetChangesetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetChangesetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChangesetError {
    fn code(&self) -> Option<&str> {
        GetChangesetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChangesetError {
    /// Creates a new `GetChangesetError`.
    pub fn new(kind: GetChangesetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChangesetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChangesetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChangesetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChangesetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetChangesetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetChangesetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetChangesetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetChangesetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetChangesetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChangesetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChangesetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChangesetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChangesetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetChangesetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetChangesetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetChangesetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetChangesetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChangesetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetChangesetErrorKind::ConflictException(_inner) => Some(_inner),
            GetChangesetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetChangesetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetChangesetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetChangesetErrorKind::ValidationException(_inner) => Some(_inner),
            GetChangesetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDatasetError {
    /// Kind of error that occurred.
    pub kind: GetDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDatasetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDatasetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDatasetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetDatasetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDatasetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDatasetError {
    fn code(&self) -> Option<&str> {
        GetDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDatasetError {
    /// Creates a new `GetDatasetError`.
    pub fn new(kind: GetDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDatasetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDatasetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetDatasetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetDatasetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetDatasetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetDatasetErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDatasetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetDatasetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDatasetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDatasetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDatasetErrorKind::ConflictException(_inner) => Some(_inner),
            GetDatasetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDatasetErrorKind::ValidationException(_inner) => Some(_inner),
            GetDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataViewError {
    /// Kind of error that occurred.
    pub kind: GetDataViewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataViewErrorKind {
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataViewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataViewErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetDataViewErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDataViewErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDataViewErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDataViewErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDataViewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataViewError {
    fn code(&self) -> Option<&str> {
        GetDataViewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataViewError {
    /// Creates a new `GetDataViewError`.
    pub fn new(kind: GetDataViewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataViewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataViewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataViewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataViewErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataViewErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetDataViewErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetDataViewErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetDataViewErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetDataViewErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataViewErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataViewErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDataViewErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetDataViewErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDataViewErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDataViewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataViewErrorKind::ConflictException(_inner) => Some(_inner),
            GetDataViewErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDataViewErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDataViewErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDataViewErrorKind::ValidationException(_inner) => Some(_inner),
            GetDataViewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProgrammaticAccessCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProgrammaticAccessCredentialsError {
    /// Kind of error that occurred.
    pub kind: GetProgrammaticAccessCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProgrammaticAccessCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProgrammaticAccessCredentialsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProgrammaticAccessCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProgrammaticAccessCredentialsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetProgrammaticAccessCredentialsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetProgrammaticAccessCredentialsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetProgrammaticAccessCredentialsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetProgrammaticAccessCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProgrammaticAccessCredentialsError {
    fn code(&self) -> Option<&str> {
        GetProgrammaticAccessCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProgrammaticAccessCredentialsError {
    /// Creates a new `GetProgrammaticAccessCredentialsError`.
    pub fn new(
        kind: GetProgrammaticAccessCredentialsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProgrammaticAccessCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProgrammaticAccessCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProgrammaticAccessCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProgrammaticAccessCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProgrammaticAccessCredentialsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProgrammaticAccessCredentialsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProgrammaticAccessCredentialsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProgrammaticAccessCredentialsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProgrammaticAccessCredentialsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProgrammaticAccessCredentialsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProgrammaticAccessCredentialsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProgrammaticAccessCredentialsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetProgrammaticAccessCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProgrammaticAccessCredentialsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetProgrammaticAccessCredentialsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetProgrammaticAccessCredentialsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetProgrammaticAccessCredentialsErrorKind::ValidationException(_inner) => Some(_inner),
            GetProgrammaticAccessCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserError {
    /// Kind of error that occurred.
    pub kind: GetUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetUserErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserError {
    fn code(&self) -> Option<&str> {
        GetUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserError {
    /// Creates a new `GetUserError`.
    pub fn new(kind: GetUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetUserErrorKind::InternalServerException(_inner) => Some(_inner),
            GetUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetUserErrorKind::ValidationException(_inner) => Some(_inner),
            GetUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkingLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkingLocationError {
    /// Kind of error that occurred.
    pub kind: GetWorkingLocationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkingLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkingLocationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkingLocationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkingLocationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWorkingLocationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWorkingLocationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWorkingLocationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWorkingLocationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkingLocationError {
    fn code(&self) -> Option<&str> {
        GetWorkingLocationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkingLocationError {
    /// Creates a new `GetWorkingLocationError`.
    pub fn new(kind: GetWorkingLocationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkingLocationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkingLocationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkingLocationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkingLocationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWorkingLocationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkingLocationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkingLocationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkingLocationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkingLocationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkingLocationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkingLocationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkingLocationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWorkingLocationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkingLocationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWorkingLocationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWorkingLocationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWorkingLocationErrorKind::ValidationException(_inner) => Some(_inner),
            GetWorkingLocationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChangesets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChangesetsError {
    /// Kind of error that occurred.
    pub kind: ListChangesetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChangesets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChangesetsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChangesetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChangesetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListChangesetsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListChangesetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListChangesetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListChangesetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListChangesetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListChangesetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChangesetsError {
    fn code(&self) -> Option<&str> {
        ListChangesetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChangesetsError {
    /// Creates a new `ListChangesetsError`.
    pub fn new(kind: ListChangesetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChangesetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChangesetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChangesetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChangesetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChangesetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangesetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangesetsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListChangesetsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListChangesetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangesetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangesetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangesetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangesetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListChangesetsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListChangesetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListChangesetsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListChangesetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChangesetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListChangesetsErrorKind::ConflictException(_inner) => Some(_inner),
            ListChangesetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListChangesetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListChangesetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListChangesetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListChangesetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetsErrorKind {
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetsError {
    fn code(&self) -> Option<&str> {
        ListDatasetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetsError {
    /// Creates a new `ListDatasetsError`.
    pub fn new(kind: ListDatasetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListDatasetsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDatasetsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDatasetsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDatasetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetsErrorKind::ConflictException(_inner) => Some(_inner),
            ListDatasetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDatasetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDatasetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDatasetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDatasetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataViews` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataViewsError {
    /// Kind of error that occurred.
    pub kind: ListDataViewsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataViews` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataViewsErrorKind {
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataViewsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataViewsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListDataViewsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDataViewsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDataViewsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataViewsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDataViewsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataViewsError {
    fn code(&self) -> Option<&str> {
        ListDataViewsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataViewsError {
    /// Creates a new `ListDataViewsError`.
    pub fn new(kind: ListDataViewsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataViewsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataViewsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataViewsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataViewsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataViewsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListDataViewsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListDataViewsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataViewsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataViewsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataViewsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataViewsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDataViewsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDataViewsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDataViewsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDataViewsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataViewsErrorKind::ConflictException(_inner) => Some(_inner),
            ListDataViewsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDataViewsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDataViewsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataViewsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDataViewsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPermissionGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionGroupsError {
    /// Kind of error that occurred.
    pub kind: ListPermissionGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissionGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionGroupsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPermissionGroupsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPermissionGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPermissionGroupsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPermissionGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionGroupsError {
    fn code(&self) -> Option<&str> {
        ListPermissionGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPermissionGroupsError {
    /// Creates a new `ListPermissionGroupsError`.
    pub fn new(kind: ListPermissionGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPermissionGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionGroupsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionGroupsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionGroupsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionGroupsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionGroupsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPermissionGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPermissionGroupsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPermissionGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPermissionGroupsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPermissionGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListUsersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListUsersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUsersErrorKind::ValidationException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetUserPasswordError {
    /// Kind of error that occurred.
    pub kind: ResetUserPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetUserPasswordErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetUserPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetUserPasswordErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetUserPasswordError {
    fn code(&self) -> Option<&str> {
        ResetUserPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetUserPasswordError {
    /// Creates a new `ResetUserPasswordError`.
    pub fn new(kind: ResetUserPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetUserPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetUserPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetUserPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetUserPasswordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ResetUserPasswordErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ResetUserPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetUserPasswordErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::ConflictException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::InternalServerException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::ThrottlingException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::ValidationException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChangeset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChangesetError {
    /// Kind of error that occurred.
    pub kind: UpdateChangesetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChangeset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChangesetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChangesetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChangesetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateChangesetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChangesetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateChangesetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateChangesetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateChangesetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateChangesetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChangesetError {
    fn code(&self) -> Option<&str> {
        UpdateChangesetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChangesetError {
    /// Creates a new `UpdateChangesetError`.
    pub fn new(kind: UpdateChangesetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChangesetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChangesetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChangesetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChangesetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateChangesetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChangesetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChangesetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateChangesetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateChangesetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChangesetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChangesetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChangesetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChangesetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateChangesetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateChangesetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateChangesetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateChangesetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChangesetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateChangesetErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChangesetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateChangesetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateChangesetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateChangesetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateChangesetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDatasetError {
    /// Kind of error that occurred.
    pub kind: UpdateDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDatasetErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDatasetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDatasetError {
    fn code(&self) -> Option<&str> {
        UpdateDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDatasetError {
    /// Creates a new `UpdateDatasetError`.
    pub fn new(kind: UpdateDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateDatasetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDatasetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDatasetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateDatasetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDatasetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePermissionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePermissionGroupError {
    /// Kind of error that occurred.
    pub kind: UpdatePermissionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePermissionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePermissionGroupErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePermissionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePermissionGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePermissionGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePermissionGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePermissionGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePermissionGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePermissionGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePermissionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePermissionGroupError {
    fn code(&self) -> Option<&str> {
        UpdatePermissionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePermissionGroupError {
    /// Creates a new `UpdatePermissionGroupError`.
    pub fn new(kind: UpdatePermissionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePermissionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePermissionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePermissionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePermissionGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePermissionGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePermissionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePermissionGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePermissionGroupErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePermissionGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePermissionGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePermissionGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePermissionGroupErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePermissionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserError {
    /// Kind of error that occurred.
    pub kind: UpdateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request conflicts with an existing resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserError {
    fn code(&self) -> Option<&str> {
        UpdateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserError {
    /// Creates a new `UpdateUserError`.
    pub fn new(kind: UpdateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateUserErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateUserErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input fails to satisfy the constraints specified by an AWS service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<std::string::String>,
}
impl ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>One or more resources can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The request conflicts with an existing resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<std::string::String>,
}
impl ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>A limit has exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
