// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A union of schema types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaUnion {
    /// <p>The configuration for a schema on a tabular Dataset.</p>
    pub tabular_schema_config: std::option::Option<crate::model::SchemaDefinition>,
}
impl SchemaUnion {
    /// <p>The configuration for a schema on a tabular Dataset.</p>
    pub fn tabular_schema_config(&self) -> std::option::Option<&crate::model::SchemaDefinition> {
        self.tabular_schema_config.as_ref()
    }
}
impl std::fmt::Debug for SchemaUnion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaUnion");
        formatter.field("tabular_schema_config", &self.tabular_schema_config);
        formatter.finish()
    }
}
/// See [`SchemaUnion`](crate::model::SchemaUnion)
pub mod schema_union {
    /// A builder for [`SchemaUnion`](crate::model::SchemaUnion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tabular_schema_config: std::option::Option<crate::model::SchemaDefinition>,
    }
    impl Builder {
        /// <p>The configuration for a schema on a tabular Dataset.</p>
        pub fn tabular_schema_config(mut self, input: crate::model::SchemaDefinition) -> Self {
            self.tabular_schema_config = Some(input);
            self
        }
        /// <p>The configuration for a schema on a tabular Dataset.</p>
        pub fn set_tabular_schema_config(
            mut self,
            input: std::option::Option<crate::model::SchemaDefinition>,
        ) -> Self {
            self.tabular_schema_config = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaUnion`](crate::model::SchemaUnion)
        pub fn build(self) -> crate::model::SchemaUnion {
            crate::model::SchemaUnion {
                tabular_schema_config: self.tabular_schema_config,
            }
        }
    }
}
impl SchemaUnion {
    /// Creates a new builder-style object to manufacture [`SchemaUnion`](crate::model::SchemaUnion)
    pub fn builder() -> crate::model::schema_union::Builder {
        crate::model::schema_union::Builder::default()
    }
}

/// <p>Definition for a schema on a tabular Dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaDefinition {
    /// <p>List of column definitions.</p>
    pub columns: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
    /// <p>List of column names used for primary key.</p>
    pub primary_key_columns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SchemaDefinition {
    /// <p>List of column definitions.</p>
    pub fn columns(&self) -> std::option::Option<&[crate::model::ColumnDefinition]> {
        self.columns.as_deref()
    }
    /// <p>List of column names used for primary key.</p>
    pub fn primary_key_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.primary_key_columns.as_deref()
    }
}
impl std::fmt::Debug for SchemaDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaDefinition");
        formatter.field("columns", &self.columns);
        formatter.field("primary_key_columns", &self.primary_key_columns);
        formatter.finish()
    }
}
/// See [`SchemaDefinition`](crate::model::SchemaDefinition)
pub mod schema_definition {
    /// A builder for [`SchemaDefinition`](crate::model::SchemaDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) columns: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
        pub(crate) primary_key_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>List of column definitions.</p>
        pub fn columns(mut self, input: crate::model::ColumnDefinition) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input);
            self.columns = Some(v);
            self
        }
        /// <p>List of column definitions.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// Appends an item to `primary_key_columns`.
        ///
        /// To override the contents of this collection use [`set_primary_key_columns`](Self::set_primary_key_columns).
        ///
        /// <p>List of column names used for primary key.</p>
        pub fn primary_key_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.primary_key_columns.unwrap_or_default();
            v.push(input.into());
            self.primary_key_columns = Some(v);
            self
        }
        /// <p>List of column names used for primary key.</p>
        pub fn set_primary_key_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.primary_key_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaDefinition`](crate::model::SchemaDefinition)
        pub fn build(self) -> crate::model::SchemaDefinition {
            crate::model::SchemaDefinition {
                columns: self.columns,
                primary_key_columns: self.primary_key_columns,
            }
        }
    }
}
impl SchemaDefinition {
    /// Creates a new builder-style object to manufacture [`SchemaDefinition`](crate::model::SchemaDefinition)
    pub fn builder() -> crate::model::schema_definition::Builder {
        crate::model::schema_definition::Builder::default()
    }
}

/// <p>The definition of a column in a tabular Dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnDefinition {
    /// <p>Data type of a column.</p>
    /// <ul>
    /// <li> <p> <code>STRING</code> - A String data type.</p> <p> <code>CHAR</code> - A char data type.</p> <p> <code>INTEGER</code> - An integer data type.</p> <p> <code>TINYINT</code> - A tinyint data type.</p> <p> <code>SMALLINT</code> - A smallint data type.</p> <p> <code>BIGINT</code> - A bigint data type.</p> <p> <code>FLOAT</code> - A float data type.</p> <p> <code>DOUBLE</code> - A double data type.</p> <p> <code>DATE</code> - A date data type.</p> <p> <code>DATETIME</code> - A datetime data type.</p> <p> <code>BOOLEAN</code> - A boolean data type.</p> <p> <code>BINARY</code> - A binary data type.</p> </li>
    /// </ul>
    pub data_type: std::option::Option<crate::model::ColumnDataType>,
    /// <p>Name for a column.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>Description for a column.</p>
    pub column_description: std::option::Option<std::string::String>,
}
impl ColumnDefinition {
    /// <p>Data type of a column.</p>
    /// <ul>
    /// <li> <p> <code>STRING</code> - A String data type.</p> <p> <code>CHAR</code> - A char data type.</p> <p> <code>INTEGER</code> - An integer data type.</p> <p> <code>TINYINT</code> - A tinyint data type.</p> <p> <code>SMALLINT</code> - A smallint data type.</p> <p> <code>BIGINT</code> - A bigint data type.</p> <p> <code>FLOAT</code> - A float data type.</p> <p> <code>DOUBLE</code> - A double data type.</p> <p> <code>DATE</code> - A date data type.</p> <p> <code>DATETIME</code> - A datetime data type.</p> <p> <code>BOOLEAN</code> - A boolean data type.</p> <p> <code>BINARY</code> - A binary data type.</p> </li>
    /// </ul>
    pub fn data_type(&self) -> std::option::Option<&crate::model::ColumnDataType> {
        self.data_type.as_ref()
    }
    /// <p>Name for a column.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>Description for a column.</p>
    pub fn column_description(&self) -> std::option::Option<&str> {
        self.column_description.as_deref()
    }
}
impl std::fmt::Debug for ColumnDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnDefinition");
        formatter.field("data_type", &self.data_type);
        formatter.field("column_name", &self.column_name);
        formatter.field("column_description", &self.column_description);
        formatter.finish()
    }
}
/// See [`ColumnDefinition`](crate::model::ColumnDefinition)
pub mod column_definition {
    /// A builder for [`ColumnDefinition`](crate::model::ColumnDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_type: std::option::Option<crate::model::ColumnDataType>,
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) column_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Data type of a column.</p>
        /// <ul>
        /// <li> <p> <code>STRING</code> - A String data type.</p> <p> <code>CHAR</code> - A char data type.</p> <p> <code>INTEGER</code> - An integer data type.</p> <p> <code>TINYINT</code> - A tinyint data type.</p> <p> <code>SMALLINT</code> - A smallint data type.</p> <p> <code>BIGINT</code> - A bigint data type.</p> <p> <code>FLOAT</code> - A float data type.</p> <p> <code>DOUBLE</code> - A double data type.</p> <p> <code>DATE</code> - A date data type.</p> <p> <code>DATETIME</code> - A datetime data type.</p> <p> <code>BOOLEAN</code> - A boolean data type.</p> <p> <code>BINARY</code> - A binary data type.</p> </li>
        /// </ul>
        pub fn data_type(mut self, input: crate::model::ColumnDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>Data type of a column.</p>
        /// <ul>
        /// <li> <p> <code>STRING</code> - A String data type.</p> <p> <code>CHAR</code> - A char data type.</p> <p> <code>INTEGER</code> - An integer data type.</p> <p> <code>TINYINT</code> - A tinyint data type.</p> <p> <code>SMALLINT</code> - A smallint data type.</p> <p> <code>BIGINT</code> - A bigint data type.</p> <p> <code>FLOAT</code> - A float data type.</p> <p> <code>DOUBLE</code> - A double data type.</p> <p> <code>DATE</code> - A date data type.</p> <p> <code>DATETIME</code> - A datetime data type.</p> <p> <code>BOOLEAN</code> - A boolean data type.</p> <p> <code>BINARY</code> - A binary data type.</p> </li>
        /// </ul>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::ColumnDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>Name for a column.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>Name for a column.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>Description for a column.</p>
        pub fn column_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_description = Some(input.into());
            self
        }
        /// <p>Description for a column.</p>
        pub fn set_column_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.column_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnDefinition`](crate::model::ColumnDefinition)
        pub fn build(self) -> crate::model::ColumnDefinition {
            crate::model::ColumnDefinition {
                data_type: self.data_type,
                column_name: self.column_name,
                column_description: self.column_description,
            }
        }
    }
}
impl ColumnDefinition {
    /// Creates a new builder-style object to manufacture [`ColumnDefinition`](crate::model::ColumnDefinition)
    pub fn builder() -> crate::model::column_definition::Builder {
        crate::model::column_definition::Builder::default()
    }
}

/// Data type of a column.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ColumnDataType {
    #[allow(missing_docs)] // documentation missing in model
    Bigint,
    #[allow(missing_docs)] // documentation missing in model
    Binary,
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Char,
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    Datetime,
    #[allow(missing_docs)] // documentation missing in model
    Double,
    #[allow(missing_docs)] // documentation missing in model
    Float,
    #[allow(missing_docs)] // documentation missing in model
    Integer,
    #[allow(missing_docs)] // documentation missing in model
    Smallint,
    #[allow(missing_docs)] // documentation missing in model
    String,
    #[allow(missing_docs)] // documentation missing in model
    Tinyint,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ColumnDataType {
    fn from(s: &str) -> Self {
        match s {
            "BIGINT" => ColumnDataType::Bigint,
            "BINARY" => ColumnDataType::Binary,
            "BOOLEAN" => ColumnDataType::Boolean,
            "CHAR" => ColumnDataType::Char,
            "DATE" => ColumnDataType::Date,
            "DATETIME" => ColumnDataType::Datetime,
            "DOUBLE" => ColumnDataType::Double,
            "FLOAT" => ColumnDataType::Float,
            "INTEGER" => ColumnDataType::Integer,
            "SMALLINT" => ColumnDataType::Smallint,
            "STRING" => ColumnDataType::String,
            "TINYINT" => ColumnDataType::Tinyint,
            other => ColumnDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ColumnDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ColumnDataType::from(s))
    }
}
impl ColumnDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ColumnDataType::Bigint => "BIGINT",
            ColumnDataType::Binary => "BINARY",
            ColumnDataType::Boolean => "BOOLEAN",
            ColumnDataType::Char => "CHAR",
            ColumnDataType::Date => "DATE",
            ColumnDataType::Datetime => "DATETIME",
            ColumnDataType::Double => "DOUBLE",
            ColumnDataType::Float => "FLOAT",
            ColumnDataType::Integer => "INTEGER",
            ColumnDataType::Smallint => "SMALLINT",
            ColumnDataType::String => "STRING",
            ColumnDataType::Tinyint => "TINYINT",
            ColumnDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BIGINT", "BINARY", "BOOLEAN", "CHAR", "DATE", "DATETIME", "DOUBLE", "FLOAT",
            "INTEGER", "SMALLINT", "STRING", "TINYINT",
        ]
    }
}
impl AsRef<str> for ColumnDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Dataset Kind
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetKind {
    #[allow(missing_docs)] // documentation missing in model
    NonTabular,
    #[allow(missing_docs)] // documentation missing in model
    Tabular,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetKind {
    fn from(s: &str) -> Self {
        match s {
            "NON_TABULAR" => DatasetKind::NonTabular,
            "TABULAR" => DatasetKind::Tabular,
            other => DatasetKind::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetKind {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetKind::from(s))
    }
}
impl DatasetKind {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetKind::NonTabular => "NON_TABULAR",
            DatasetKind::Tabular => "TABULAR",
            DatasetKind::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NON_TABULAR", "TABULAR"]
    }
}
impl AsRef<str> for DatasetKind {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Structure for the summary of a Dataview.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataViewSummary {
    /// <p>The unique identifier for the Dataview.</p>
    pub data_view_id: std::option::Option<std::string::String>,
    /// <p>The ARN identifier of the Dataview.</p>
    pub data_view_arn: std::option::Option<std::string::String>,
    /// <p>Th unique identifier for the Dataview Dataset.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>Time range to use for the Dataview. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub as_of_timestamp: std::option::Option<i64>,
    /// <p>Ordered set of column names used to partition data.</p>
    pub partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Columns to be used for sorting the data.</p>
    pub sort_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of a Dataview creation.</p>
    /// <ul>
    /// <li> <p> <code>RUNNING</code> - Dataview creation is running.</p> </li>
    /// <li> <p> <code>STARTING</code> - Dataview creation is starting.</p> </li>
    /// <li> <p> <code>FAILED</code> - Dataview creation has failed.</p> </li>
    /// <li> <p> <code>CANCELLED</code> - Dataview creation has been cancelled.</p> </li>
    /// <li> <p> <code>TIMEOUT</code> - Dataview creation has timed out.</p> </li>
    /// <li> <p> <code>SUCCESS</code> - Dataview creation has succeeded.</p> </li>
    /// <li> <p> <code>PENDING</code> - Dataview creation is pending.</p> </li>
    /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> - Dataview creation failed and resource cleanup failed.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DataViewStatus>,
    /// <p>The structure with error messages.</p>
    pub error_info: std::option::Option<crate::model::DataViewErrorInfo>,
    /// <p>Information about the Dataview destination.</p>
    pub destination_type_properties:
        std::option::Option<crate::model::DataViewDestinationTypeParams>,
    /// <p>The flag to indicate Dataview should be updated automatically.</p>
    pub auto_update: bool,
    /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub create_time: i64,
    /// <p>The last time that a Dataview was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub last_modified_time: i64,
}
impl DataViewSummary {
    /// <p>The unique identifier for the Dataview.</p>
    pub fn data_view_id(&self) -> std::option::Option<&str> {
        self.data_view_id.as_deref()
    }
    /// <p>The ARN identifier of the Dataview.</p>
    pub fn data_view_arn(&self) -> std::option::Option<&str> {
        self.data_view_arn.as_deref()
    }
    /// <p>Th unique identifier for the Dataview Dataset.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>Time range to use for the Dataview. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn as_of_timestamp(&self) -> std::option::Option<i64> {
        self.as_of_timestamp
    }
    /// <p>Ordered set of column names used to partition data.</p>
    pub fn partition_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_columns.as_deref()
    }
    /// <p>Columns to be used for sorting the data.</p>
    pub fn sort_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.sort_columns.as_deref()
    }
    /// <p>The status of a Dataview creation.</p>
    /// <ul>
    /// <li> <p> <code>RUNNING</code> - Dataview creation is running.</p> </li>
    /// <li> <p> <code>STARTING</code> - Dataview creation is starting.</p> </li>
    /// <li> <p> <code>FAILED</code> - Dataview creation has failed.</p> </li>
    /// <li> <p> <code>CANCELLED</code> - Dataview creation has been cancelled.</p> </li>
    /// <li> <p> <code>TIMEOUT</code> - Dataview creation has timed out.</p> </li>
    /// <li> <p> <code>SUCCESS</code> - Dataview creation has succeeded.</p> </li>
    /// <li> <p> <code>PENDING</code> - Dataview creation is pending.</p> </li>
    /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> - Dataview creation failed and resource cleanup failed.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::DataViewStatus> {
        self.status.as_ref()
    }
    /// <p>The structure with error messages.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::DataViewErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p>Information about the Dataview destination.</p>
    pub fn destination_type_properties(
        &self,
    ) -> std::option::Option<&crate::model::DataViewDestinationTypeParams> {
        self.destination_type_properties.as_ref()
    }
    /// <p>The flag to indicate Dataview should be updated automatically.</p>
    pub fn auto_update(&self) -> bool {
        self.auto_update
    }
    /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn create_time(&self) -> i64 {
        self.create_time
    }
    /// <p>The last time that a Dataview was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
}
impl std::fmt::Debug for DataViewSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataViewSummary");
        formatter.field("data_view_id", &self.data_view_id);
        formatter.field("data_view_arn", &self.data_view_arn);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("as_of_timestamp", &self.as_of_timestamp);
        formatter.field("partition_columns", &self.partition_columns);
        formatter.field("sort_columns", &self.sort_columns);
        formatter.field("status", &self.status);
        formatter.field("error_info", &self.error_info);
        formatter.field(
            "destination_type_properties",
            &self.destination_type_properties,
        );
        formatter.field("auto_update", &self.auto_update);
        formatter.field("create_time", &self.create_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`DataViewSummary`](crate::model::DataViewSummary)
pub mod data_view_summary {
    /// A builder for [`DataViewSummary`](crate::model::DataViewSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_view_id: std::option::Option<std::string::String>,
        pub(crate) data_view_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) as_of_timestamp: std::option::Option<i64>,
        pub(crate) partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sort_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::DataViewStatus>,
        pub(crate) error_info: std::option::Option<crate::model::DataViewErrorInfo>,
        pub(crate) destination_type_properties:
            std::option::Option<crate::model::DataViewDestinationTypeParams>,
        pub(crate) auto_update: std::option::Option<bool>,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique identifier for the Dataview.</p>
        pub fn data_view_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_view_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Dataview.</p>
        pub fn set_data_view_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_view_id = input;
            self
        }
        /// <p>The ARN identifier of the Dataview.</p>
        pub fn data_view_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_view_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of the Dataview.</p>
        pub fn set_data_view_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_view_arn = input;
            self
        }
        /// <p>Th unique identifier for the Dataview Dataset.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>Th unique identifier for the Dataview Dataset.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>Time range to use for the Dataview. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn as_of_timestamp(mut self, input: i64) -> Self {
            self.as_of_timestamp = Some(input);
            self
        }
        /// <p>Time range to use for the Dataview. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_as_of_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.as_of_timestamp = input;
            self
        }
        /// Appends an item to `partition_columns`.
        ///
        /// To override the contents of this collection use [`set_partition_columns`](Self::set_partition_columns).
        ///
        /// <p>Ordered set of column names used to partition data.</p>
        pub fn partition_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_columns.unwrap_or_default();
            v.push(input.into());
            self.partition_columns = Some(v);
            self
        }
        /// <p>Ordered set of column names used to partition data.</p>
        pub fn set_partition_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_columns = input;
            self
        }
        /// Appends an item to `sort_columns`.
        ///
        /// To override the contents of this collection use [`set_sort_columns`](Self::set_sort_columns).
        ///
        /// <p>Columns to be used for sorting the data.</p>
        pub fn sort_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sort_columns.unwrap_or_default();
            v.push(input.into());
            self.sort_columns = Some(v);
            self
        }
        /// <p>Columns to be used for sorting the data.</p>
        pub fn set_sort_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sort_columns = input;
            self
        }
        /// <p>The status of a Dataview creation.</p>
        /// <ul>
        /// <li> <p> <code>RUNNING</code> - Dataview creation is running.</p> </li>
        /// <li> <p> <code>STARTING</code> - Dataview creation is starting.</p> </li>
        /// <li> <p> <code>FAILED</code> - Dataview creation has failed.</p> </li>
        /// <li> <p> <code>CANCELLED</code> - Dataview creation has been cancelled.</p> </li>
        /// <li> <p> <code>TIMEOUT</code> - Dataview creation has timed out.</p> </li>
        /// <li> <p> <code>SUCCESS</code> - Dataview creation has succeeded.</p> </li>
        /// <li> <p> <code>PENDING</code> - Dataview creation is pending.</p> </li>
        /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> - Dataview creation failed and resource cleanup failed.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DataViewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a Dataview creation.</p>
        /// <ul>
        /// <li> <p> <code>RUNNING</code> - Dataview creation is running.</p> </li>
        /// <li> <p> <code>STARTING</code> - Dataview creation is starting.</p> </li>
        /// <li> <p> <code>FAILED</code> - Dataview creation has failed.</p> </li>
        /// <li> <p> <code>CANCELLED</code> - Dataview creation has been cancelled.</p> </li>
        /// <li> <p> <code>TIMEOUT</code> - Dataview creation has timed out.</p> </li>
        /// <li> <p> <code>SUCCESS</code> - Dataview creation has succeeded.</p> </li>
        /// <li> <p> <code>PENDING</code> - Dataview creation is pending.</p> </li>
        /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> - Dataview creation failed and resource cleanup failed.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataViewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn error_info(mut self, input: crate::model::DataViewErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::DataViewErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// <p>Information about the Dataview destination.</p>
        pub fn destination_type_properties(
            mut self,
            input: crate::model::DataViewDestinationTypeParams,
        ) -> Self {
            self.destination_type_properties = Some(input);
            self
        }
        /// <p>Information about the Dataview destination.</p>
        pub fn set_destination_type_properties(
            mut self,
            input: std::option::Option<crate::model::DataViewDestinationTypeParams>,
        ) -> Self {
            self.destination_type_properties = input;
            self
        }
        /// <p>The flag to indicate Dataview should be updated automatically.</p>
        pub fn auto_update(mut self, input: bool) -> Self {
            self.auto_update = Some(input);
            self
        }
        /// <p>The flag to indicate Dataview should be updated automatically.</p>
        pub fn set_auto_update(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_update = input;
            self
        }
        /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The last time that a Dataview was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time that a Dataview was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DataViewSummary`](crate::model::DataViewSummary)
        pub fn build(self) -> crate::model::DataViewSummary {
            crate::model::DataViewSummary {
                data_view_id: self.data_view_id,
                data_view_arn: self.data_view_arn,
                dataset_id: self.dataset_id,
                as_of_timestamp: self.as_of_timestamp,
                partition_columns: self.partition_columns,
                sort_columns: self.sort_columns,
                status: self.status,
                error_info: self.error_info,
                destination_type_properties: self.destination_type_properties,
                auto_update: self.auto_update.unwrap_or_default(),
                create_time: self.create_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
            }
        }
    }
}
impl DataViewSummary {
    /// Creates a new builder-style object to manufacture [`DataViewSummary`](crate::model::DataViewSummary)
    pub fn builder() -> crate::model::data_view_summary::Builder {
        crate::model::data_view_summary::Builder::default()
    }
}

/// <p>Structure for the Dataview destination type parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataViewDestinationTypeParams {
    /// <p>Destination type for a Dataview.</p>
    /// <ul>
    /// <li> <p> <code>GLUE_TABLE</code> - Glue table destination type.</p> </li>
    /// <li> <p> <code>S3</code> - S3 destination type.</p> </li>
    /// </ul>
    pub destination_type: std::option::Option<std::string::String>,
    /// <p>Data view export file format.</p>
    /// <ul>
    /// <li> <p> <code>PARQUET</code> - Parquet export file format.</p> </li>
    /// <li> <p> <code>DELIMITED_TEXT</code> - Delimited text export file format.</p> </li>
    /// </ul>
    pub s3_destination_export_file_format: std::option::Option<crate::model::ExportFileFormat>,
    /// <p>Format Options for S3 Destination type.</p>
    /// <p>Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code> </p>
    /// <p> <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code> </p>
    pub s3_destination_export_file_format_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DataViewDestinationTypeParams {
    /// <p>Destination type for a Dataview.</p>
    /// <ul>
    /// <li> <p> <code>GLUE_TABLE</code> - Glue table destination type.</p> </li>
    /// <li> <p> <code>S3</code> - S3 destination type.</p> </li>
    /// </ul>
    pub fn destination_type(&self) -> std::option::Option<&str> {
        self.destination_type.as_deref()
    }
    /// <p>Data view export file format.</p>
    /// <ul>
    /// <li> <p> <code>PARQUET</code> - Parquet export file format.</p> </li>
    /// <li> <p> <code>DELIMITED_TEXT</code> - Delimited text export file format.</p> </li>
    /// </ul>
    pub fn s3_destination_export_file_format(
        &self,
    ) -> std::option::Option<&crate::model::ExportFileFormat> {
        self.s3_destination_export_file_format.as_ref()
    }
    /// <p>Format Options for S3 Destination type.</p>
    /// <p>Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code> </p>
    /// <p> <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code> </p>
    pub fn s3_destination_export_file_format_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.s3_destination_export_file_format_options.as_ref()
    }
}
impl std::fmt::Debug for DataViewDestinationTypeParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataViewDestinationTypeParams");
        formatter.field("destination_type", &self.destination_type);
        formatter.field(
            "s3_destination_export_file_format",
            &self.s3_destination_export_file_format,
        );
        formatter.field(
            "s3_destination_export_file_format_options",
            &self.s3_destination_export_file_format_options,
        );
        formatter.finish()
    }
}
/// See [`DataViewDestinationTypeParams`](crate::model::DataViewDestinationTypeParams)
pub mod data_view_destination_type_params {
    /// A builder for [`DataViewDestinationTypeParams`](crate::model::DataViewDestinationTypeParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_type: std::option::Option<std::string::String>,
        pub(crate) s3_destination_export_file_format:
            std::option::Option<crate::model::ExportFileFormat>,
        pub(crate) s3_destination_export_file_format_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Destination type for a Dataview.</p>
        /// <ul>
        /// <li> <p> <code>GLUE_TABLE</code> - Glue table destination type.</p> </li>
        /// <li> <p> <code>S3</code> - S3 destination type.</p> </li>
        /// </ul>
        pub fn destination_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_type = Some(input.into());
            self
        }
        /// <p>Destination type for a Dataview.</p>
        /// <ul>
        /// <li> <p> <code>GLUE_TABLE</code> - Glue table destination type.</p> </li>
        /// <li> <p> <code>S3</code> - S3 destination type.</p> </li>
        /// </ul>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p>Data view export file format.</p>
        /// <ul>
        /// <li> <p> <code>PARQUET</code> - Parquet export file format.</p> </li>
        /// <li> <p> <code>DELIMITED_TEXT</code> - Delimited text export file format.</p> </li>
        /// </ul>
        pub fn s3_destination_export_file_format(
            mut self,
            input: crate::model::ExportFileFormat,
        ) -> Self {
            self.s3_destination_export_file_format = Some(input);
            self
        }
        /// <p>Data view export file format.</p>
        /// <ul>
        /// <li> <p> <code>PARQUET</code> - Parquet export file format.</p> </li>
        /// <li> <p> <code>DELIMITED_TEXT</code> - Delimited text export file format.</p> </li>
        /// </ul>
        pub fn set_s3_destination_export_file_format(
            mut self,
            input: std::option::Option<crate::model::ExportFileFormat>,
        ) -> Self {
            self.s3_destination_export_file_format = input;
            self
        }
        /// Adds a key-value pair to `s3_destination_export_file_format_options`.
        ///
        /// To override the contents of this collection use [`set_s3_destination_export_file_format_options`](Self::set_s3_destination_export_file_format_options).
        ///
        /// <p>Format Options for S3 Destination type.</p>
        /// <p>Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code> </p>
        /// <p> <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code> </p>
        pub fn s3_destination_export_file_format_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self
                .s3_destination_export_file_format_options
                .unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.s3_destination_export_file_format_options = Some(hash_map);
            self
        }
        /// <p>Format Options for S3 Destination type.</p>
        /// <p>Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code> </p>
        /// <p> <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code> </p>
        pub fn set_s3_destination_export_file_format_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.s3_destination_export_file_format_options = input;
            self
        }
        /// Consumes the builder and constructs a [`DataViewDestinationTypeParams`](crate::model::DataViewDestinationTypeParams)
        pub fn build(self) -> crate::model::DataViewDestinationTypeParams {
            crate::model::DataViewDestinationTypeParams {
                destination_type: self.destination_type,
                s3_destination_export_file_format: self.s3_destination_export_file_format,
                s3_destination_export_file_format_options: self
                    .s3_destination_export_file_format_options,
            }
        }
    }
}
impl DataViewDestinationTypeParams {
    /// Creates a new builder-style object to manufacture [`DataViewDestinationTypeParams`](crate::model::DataViewDestinationTypeParams)
    pub fn builder() -> crate::model::data_view_destination_type_params::Builder {
        crate::model::data_view_destination_type_params::Builder::default()
    }
}

/// Data View Export File Format
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportFileFormat {
    #[allow(missing_docs)] // documentation missing in model
    DelimitedText,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportFileFormat {
    fn from(s: &str) -> Self {
        match s {
            "DELIMITED_TEXT" => ExportFileFormat::DelimitedText,
            "PARQUET" => ExportFileFormat::Parquet,
            other => ExportFileFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportFileFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportFileFormat::from(s))
    }
}
impl ExportFileFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportFileFormat::DelimitedText => "DELIMITED_TEXT",
            ExportFileFormat::Parquet => "PARQUET",
            ExportFileFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELIMITED_TEXT", "PARQUET"]
    }
}
impl AsRef<str> for ExportFileFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The structure with error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataViewErrorInfo {
    /// <p>The text of the error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The category of the error.</p>
    /// <ul>
    /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
    /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
    /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
    /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
    /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
    /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
    /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
    /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
    /// </ul>
    pub error_category: std::option::Option<crate::model::ErrorCategory>,
}
impl DataViewErrorInfo {
    /// <p>The text of the error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The category of the error.</p>
    /// <ul>
    /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
    /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
    /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
    /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
    /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
    /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
    /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
    /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
    /// </ul>
    pub fn error_category(&self) -> std::option::Option<&crate::model::ErrorCategory> {
        self.error_category.as_ref()
    }
}
impl std::fmt::Debug for DataViewErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataViewErrorInfo");
        formatter.field("error_message", &self.error_message);
        formatter.field("error_category", &self.error_category);
        formatter.finish()
    }
}
/// See [`DataViewErrorInfo`](crate::model::DataViewErrorInfo)
pub mod data_view_error_info {
    /// A builder for [`DataViewErrorInfo`](crate::model::DataViewErrorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_category: std::option::Option<crate::model::ErrorCategory>,
    }
    impl Builder {
        /// <p>The text of the error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The category of the error.</p>
        /// <ul>
        /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
        /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
        /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
        /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
        /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
        /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
        /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
        /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
        /// </ul>
        pub fn error_category(mut self, input: crate::model::ErrorCategory) -> Self {
            self.error_category = Some(input);
            self
        }
        /// <p>The category of the error.</p>
        /// <ul>
        /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
        /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
        /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
        /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
        /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
        /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
        /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
        /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
        /// </ul>
        pub fn set_error_category(
            mut self,
            input: std::option::Option<crate::model::ErrorCategory>,
        ) -> Self {
            self.error_category = input;
            self
        }
        /// Consumes the builder and constructs a [`DataViewErrorInfo`](crate::model::DataViewErrorInfo)
        pub fn build(self) -> crate::model::DataViewErrorInfo {
            crate::model::DataViewErrorInfo {
                error_message: self.error_message,
                error_category: self.error_category,
            }
        }
    }
}
impl DataViewErrorInfo {
    /// Creates a new builder-style object to manufacture [`DataViewErrorInfo`](crate::model::DataViewErrorInfo)
    pub fn builder() -> crate::model::data_view_error_info::Builder {
        crate::model::data_view_error_info::Builder::default()
    }
}

/// Changeset Error Category
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCategory {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceException,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceeded,
    #[allow(missing_docs)] // documentation missing in model
    Throttling,
    #[allow(missing_docs)] // documentation missing in model
    UserRecoverable,
    #[allow(missing_docs)] // documentation missing in model
    Validation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCategory {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => ErrorCategory::AccessDenied,
            "CANCELLED" => ErrorCategory::Cancelled,
            "INTERNAL_SERVICE_EXCEPTION" => ErrorCategory::InternalServiceException,
            "RESOURCE_NOT_FOUND" => ErrorCategory::ResourceNotFound,
            "SERVICE_QUOTA_EXCEEDED" => ErrorCategory::ServiceQuotaExceeded,
            "THROTTLING" => ErrorCategory::Throttling,
            "USER_RECOVERABLE" => ErrorCategory::UserRecoverable,
            "VALIDATION" => ErrorCategory::Validation,
            other => ErrorCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCategory::from(s))
    }
}
impl ErrorCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCategory::AccessDenied => "ACCESS_DENIED",
            ErrorCategory::Cancelled => "CANCELLED",
            ErrorCategory::InternalServiceException => "INTERNAL_SERVICE_EXCEPTION",
            ErrorCategory::ResourceNotFound => "RESOURCE_NOT_FOUND",
            ErrorCategory::ServiceQuotaExceeded => "SERVICE_QUOTA_EXCEEDED",
            ErrorCategory::Throttling => "THROTTLING",
            ErrorCategory::UserRecoverable => "USER_RECOVERABLE",
            ErrorCategory::Validation => "VALIDATION",
            ErrorCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "CANCELLED",
            "INTERNAL_SERVICE_EXCEPTION",
            "RESOURCE_NOT_FOUND",
            "SERVICE_QUOTA_EXCEEDED",
            "THROTTLING",
            "USER_RECOVERABLE",
            "VALIDATION",
        ]
    }
}
impl AsRef<str> for ErrorCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Status of a DataView
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataViewStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    FailedCleanupFailed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataViewStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => DataViewStatus::Cancelled,
            "FAILED" => DataViewStatus::Failed,
            "FAILED_CLEANUP_FAILED" => DataViewStatus::FailedCleanupFailed,
            "PENDING" => DataViewStatus::Pending,
            "RUNNING" => DataViewStatus::Running,
            "STARTING" => DataViewStatus::Starting,
            "SUCCESS" => DataViewStatus::Success,
            "TIMEOUT" => DataViewStatus::Timeout,
            other => DataViewStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataViewStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataViewStatus::from(s))
    }
}
impl DataViewStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataViewStatus::Cancelled => "CANCELLED",
            DataViewStatus::Failed => "FAILED",
            DataViewStatus::FailedCleanupFailed => "FAILED_CLEANUP_FAILED",
            DataViewStatus::Pending => "PENDING",
            DataViewStatus::Running => "RUNNING",
            DataViewStatus::Starting => "STARTING",
            DataViewStatus::Success => "SUCCESS",
            DataViewStatus::Timeout => "TIMEOUT",
            DataViewStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "FAILED",
            "FAILED_CLEANUP_FAILED",
            "PENDING",
            "RUNNING",
            "STARTING",
            "SUCCESS",
            "TIMEOUT",
        ]
    }
}
impl AsRef<str> for DataViewStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The structure for a Dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dataset {
    /// <p>An identifier for a Dataset.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The ARN identifier of the Dataset.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>Display title for a Dataset.</p>
    pub dataset_title: std::option::Option<std::string::String>,
    /// <p>The format in which Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> - Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> - Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub kind: std::option::Option<crate::model::DatasetKind>,
    /// <p>Description for a Dataset.</p>
    pub dataset_description: std::option::Option<std::string::String>,
    /// <p>Contact information for a Dataset owner.</p>
    pub owner_info: std::option::Option<crate::model::DatasetOwnerInfo>,
    /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub create_time: i64,
    /// <p>The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub last_modified_time: i64,
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub schema_definition: std::option::Option<crate::model::SchemaUnion>,
    /// <p>The unique resource identifier for a Dataset.</p>
    pub alias: std::option::Option<std::string::String>,
}
impl Dataset {
    /// <p>An identifier for a Dataset.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The ARN identifier of the Dataset.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>Display title for a Dataset.</p>
    pub fn dataset_title(&self) -> std::option::Option<&str> {
        self.dataset_title.as_deref()
    }
    /// <p>The format in which Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> - Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> - Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub fn kind(&self) -> std::option::Option<&crate::model::DatasetKind> {
        self.kind.as_ref()
    }
    /// <p>Description for a Dataset.</p>
    pub fn dataset_description(&self) -> std::option::Option<&str> {
        self.dataset_description.as_deref()
    }
    /// <p>Contact information for a Dataset owner.</p>
    pub fn owner_info(&self) -> std::option::Option<&crate::model::DatasetOwnerInfo> {
        self.owner_info.as_ref()
    }
    /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn create_time(&self) -> i64 {
        self.create_time
    }
    /// <p>The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub fn schema_definition(&self) -> std::option::Option<&crate::model::SchemaUnion> {
        self.schema_definition.as_ref()
    }
    /// <p>The unique resource identifier for a Dataset.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for Dataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dataset");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("dataset_title", &self.dataset_title);
        formatter.field("kind", &self.kind);
        formatter.field("dataset_description", &self.dataset_description);
        formatter.field("owner_info", &self.owner_info);
        formatter.field("create_time", &self.create_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("schema_definition", &self.schema_definition);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
/// See [`Dataset`](crate::model::Dataset)
pub mod dataset {
    /// A builder for [`Dataset`](crate::model::Dataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_title: std::option::Option<std::string::String>,
        pub(crate) kind: std::option::Option<crate::model::DatasetKind>,
        pub(crate) dataset_description: std::option::Option<std::string::String>,
        pub(crate) owner_info: std::option::Option<crate::model::DatasetOwnerInfo>,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) schema_definition: std::option::Option<crate::model::SchemaUnion>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for a Dataset.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>An identifier for a Dataset.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The ARN identifier of the Dataset.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of the Dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>Display title for a Dataset.</p>
        pub fn dataset_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_title = Some(input.into());
            self
        }
        /// <p>Display title for a Dataset.</p>
        pub fn set_dataset_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_title = input;
            self
        }
        /// <p>The format in which Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> - Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> - Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::DatasetKind) -> Self {
            self.kind = Some(input);
            self
        }
        /// <p>The format in which Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> - Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> - Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::DatasetKind>) -> Self {
            self.kind = input;
            self
        }
        /// <p>Description for a Dataset.</p>
        pub fn dataset_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_description = Some(input.into());
            self
        }
        /// <p>Description for a Dataset.</p>
        pub fn set_dataset_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_description = input;
            self
        }
        /// <p>Contact information for a Dataset owner.</p>
        pub fn owner_info(mut self, input: crate::model::DatasetOwnerInfo) -> Self {
            self.owner_info = Some(input);
            self
        }
        /// <p>Contact information for a Dataset owner.</p>
        pub fn set_owner_info(
            mut self,
            input: std::option::Option<crate::model::DatasetOwnerInfo>,
        ) -> Self {
            self.owner_info = input;
            self
        }
        /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaUnion) -> Self {
            self.schema_definition = Some(input);
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaUnion>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`Dataset`](crate::model::Dataset)
        pub fn build(self) -> crate::model::Dataset {
            crate::model::Dataset {
                dataset_id: self.dataset_id,
                dataset_arn: self.dataset_arn,
                dataset_title: self.dataset_title,
                kind: self.kind,
                dataset_description: self.dataset_description,
                owner_info: self.owner_info,
                create_time: self.create_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                schema_definition: self.schema_definition,
                alias: self.alias,
            }
        }
    }
}
impl Dataset {
    /// Creates a new builder-style object to manufacture [`Dataset`](crate::model::Dataset)
    pub fn builder() -> crate::model::dataset::Builder {
        crate::model::dataset::Builder::default()
    }
}

/// <p>A structure for Dataset owner info.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetOwnerInfo {
    /// <p>Name of the Dataset owner.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Phone number for the Dataset owner.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>Email address for the Dataset owner.</p>
    pub email: std::option::Option<std::string::String>,
}
impl DatasetOwnerInfo {
    /// <p>Name of the Dataset owner.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Phone number for the Dataset owner.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>Email address for the Dataset owner.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
}
impl std::fmt::Debug for DatasetOwnerInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetOwnerInfo");
        formatter.field("name", &self.name);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}
/// See [`DatasetOwnerInfo`](crate::model::DatasetOwnerInfo)
pub mod dataset_owner_info {
    /// A builder for [`DatasetOwnerInfo`](crate::model::DatasetOwnerInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the Dataset owner.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the Dataset owner.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Phone number for the Dataset owner.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>Phone number for the Dataset owner.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>Email address for the Dataset owner.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>Email address for the Dataset owner.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetOwnerInfo`](crate::model::DatasetOwnerInfo)
        pub fn build(self) -> crate::model::DatasetOwnerInfo {
            crate::model::DatasetOwnerInfo {
                name: self.name,
                phone_number: self.phone_number,
                email: self.email,
            }
        }
    }
}
impl DatasetOwnerInfo {
    /// Creates a new builder-style object to manufacture [`DatasetOwnerInfo`](crate::model::DatasetOwnerInfo)
    pub fn builder() -> crate::model::dataset_owner_info::Builder {
        crate::model::dataset_owner_info::Builder::default()
    }
}

/// <p>A Changeset is unit of data in a Dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangesetSummary {
    /// <p>The unique identifier for a Changeset.</p>
    pub changeset_id: std::option::Option<std::string::String>,
    /// <p>The ARN identifier of the Changeset.</p>
    pub changeset_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
    /// <ul>
    /// <li> <p> <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
    /// </ul>
    pub change_type: std::option::Option<crate::model::ChangeType>,
    /// <p>Options that define the location of the data being ingested.</p>
    pub source_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Options that define the structure of the source file(s).</p>
    pub format_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub create_time: i64,
    /// <p>Status of the Changeset ingestion.</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> - Changeset is pending creation.</p> </li>
    /// <li> <p> <code>FAILED</code> - Changeset creation has failed.</p> </li>
    /// <li> <p> <code>SUCCESS</code> - Changeset creation has succeeded.</p> </li>
    /// <li> <p> <code>RUNNING</code> - Changeset creation is running.</p> </li>
    /// <li> <p> <code>STOP_REQUESTED</code> - User requested Changeset creation to stop.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::IngestionStatus>,
    /// <p>The structure with error messages.</p>
    pub error_info: std::option::Option<crate::model::ChangesetErrorInfo>,
    /// <p>Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub active_until_timestamp: std::option::Option<i64>,
    /// <p>Beginning time from which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub active_from_timestamp: std::option::Option<i64>,
    /// <p>The unique identifier of the Changeset that is updated.</p>
    pub updates_changeset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the updated Changeset.</p>
    pub updated_by_changeset_id: std::option::Option<std::string::String>,
}
impl ChangesetSummary {
    /// <p>The unique identifier for a Changeset.</p>
    pub fn changeset_id(&self) -> std::option::Option<&str> {
        self.changeset_id.as_deref()
    }
    /// <p>The ARN identifier of the Changeset.</p>
    pub fn changeset_arn(&self) -> std::option::Option<&str> {
        self.changeset_arn.as_deref()
    }
    /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
    /// <ul>
    /// <li> <p> <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
    /// </ul>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.change_type.as_ref()
    }
    /// <p>Options that define the location of the data being ingested.</p>
    pub fn source_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.source_params.as_ref()
    }
    /// <p>Options that define the structure of the source file(s).</p>
    pub fn format_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.format_params.as_ref()
    }
    /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn create_time(&self) -> i64 {
        self.create_time
    }
    /// <p>Status of the Changeset ingestion.</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> - Changeset is pending creation.</p> </li>
    /// <li> <p> <code>FAILED</code> - Changeset creation has failed.</p> </li>
    /// <li> <p> <code>SUCCESS</code> - Changeset creation has succeeded.</p> </li>
    /// <li> <p> <code>RUNNING</code> - Changeset creation is running.</p> </li>
    /// <li> <p> <code>STOP_REQUESTED</code> - User requested Changeset creation to stop.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::IngestionStatus> {
        self.status.as_ref()
    }
    /// <p>The structure with error messages.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::ChangesetErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p>Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn active_until_timestamp(&self) -> std::option::Option<i64> {
        self.active_until_timestamp
    }
    /// <p>Beginning time from which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn active_from_timestamp(&self) -> std::option::Option<i64> {
        self.active_from_timestamp
    }
    /// <p>The unique identifier of the Changeset that is updated.</p>
    pub fn updates_changeset_id(&self) -> std::option::Option<&str> {
        self.updates_changeset_id.as_deref()
    }
    /// <p>The unique identifier of the updated Changeset.</p>
    pub fn updated_by_changeset_id(&self) -> std::option::Option<&str> {
        self.updated_by_changeset_id.as_deref()
    }
}
impl std::fmt::Debug for ChangesetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangesetSummary");
        formatter.field("changeset_id", &self.changeset_id);
        formatter.field("changeset_arn", &self.changeset_arn);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("change_type", &self.change_type);
        formatter.field("source_params", &self.source_params);
        formatter.field("format_params", &self.format_params);
        formatter.field("create_time", &self.create_time);
        formatter.field("status", &self.status);
        formatter.field("error_info", &self.error_info);
        formatter.field("active_until_timestamp", &self.active_until_timestamp);
        formatter.field("active_from_timestamp", &self.active_from_timestamp);
        formatter.field("updates_changeset_id", &self.updates_changeset_id);
        formatter.field("updated_by_changeset_id", &self.updated_by_changeset_id);
        formatter.finish()
    }
}
/// See [`ChangesetSummary`](crate::model::ChangesetSummary)
pub mod changeset_summary {
    /// A builder for [`ChangesetSummary`](crate::model::ChangesetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) changeset_id: std::option::Option<std::string::String>,
        pub(crate) changeset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeType>,
        pub(crate) source_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) format_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::IngestionStatus>,
        pub(crate) error_info: std::option::Option<crate::model::ChangesetErrorInfo>,
        pub(crate) active_until_timestamp: std::option::Option<i64>,
        pub(crate) active_from_timestamp: std::option::Option<i64>,
        pub(crate) updates_changeset_id: std::option::Option<std::string::String>,
        pub(crate) updated_by_changeset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a Changeset.</p>
        pub fn changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a Changeset.</p>
        pub fn set_changeset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.changeset_id = input;
            self
        }
        /// <p>The ARN identifier of the Changeset.</p>
        pub fn changeset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of the Changeset.</p>
        pub fn set_changeset_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.changeset_arn = input;
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
        /// <ul>
        /// <li> <p> <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
        /// </ul>
        pub fn change_type(mut self, input: crate::model::ChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
        /// <ul>
        /// <li> <p> <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
        /// </ul>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// Adds a key-value pair to `source_params`.
        ///
        /// To override the contents of this collection use [`set_source_params`](Self::set_source_params).
        ///
        /// <p>Options that define the location of the data being ingested.</p>
        pub fn source_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.source_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.source_params = Some(hash_map);
            self
        }
        /// <p>Options that define the location of the data being ingested.</p>
        pub fn set_source_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.source_params = input;
            self
        }
        /// Adds a key-value pair to `format_params`.
        ///
        /// To override the contents of this collection use [`set_format_params`](Self::set_format_params).
        ///
        /// <p>Options that define the structure of the source file(s).</p>
        pub fn format_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.format_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.format_params = Some(hash_map);
            self
        }
        /// <p>Options that define the structure of the source file(s).</p>
        pub fn set_format_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.format_params = input;
            self
        }
        /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>Status of the Changeset ingestion.</p>
        /// <ul>
        /// <li> <p> <code>PENDING</code> - Changeset is pending creation.</p> </li>
        /// <li> <p> <code>FAILED</code> - Changeset creation has failed.</p> </li>
        /// <li> <p> <code>SUCCESS</code> - Changeset creation has succeeded.</p> </li>
        /// <li> <p> <code>RUNNING</code> - Changeset creation is running.</p> </li>
        /// <li> <p> <code>STOP_REQUESTED</code> - User requested Changeset creation to stop.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::IngestionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the Changeset ingestion.</p>
        /// <ul>
        /// <li> <p> <code>PENDING</code> - Changeset is pending creation.</p> </li>
        /// <li> <p> <code>FAILED</code> - Changeset creation has failed.</p> </li>
        /// <li> <p> <code>SUCCESS</code> - Changeset creation has succeeded.</p> </li>
        /// <li> <p> <code>RUNNING</code> - Changeset creation is running.</p> </li>
        /// <li> <p> <code>STOP_REQUESTED</code> - User requested Changeset creation to stop.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IngestionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn error_info(mut self, input: crate::model::ChangesetErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::ChangesetErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// <p>Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn active_until_timestamp(mut self, input: i64) -> Self {
            self.active_until_timestamp = Some(input);
            self
        }
        /// <p>Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_active_until_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.active_until_timestamp = input;
            self
        }
        /// <p>Beginning time from which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn active_from_timestamp(mut self, input: i64) -> Self {
            self.active_from_timestamp = Some(input);
            self
        }
        /// <p>Beginning time from which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_active_from_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.active_from_timestamp = input;
            self
        }
        /// <p>The unique identifier of the Changeset that is updated.</p>
        pub fn updates_changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.updates_changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Changeset that is updated.</p>
        pub fn set_updates_changeset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.updates_changeset_id = input;
            self
        }
        /// <p>The unique identifier of the updated Changeset.</p>
        pub fn updated_by_changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by_changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the updated Changeset.</p>
        pub fn set_updated_by_changeset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.updated_by_changeset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangesetSummary`](crate::model::ChangesetSummary)
        pub fn build(self) -> crate::model::ChangesetSummary {
            crate::model::ChangesetSummary {
                changeset_id: self.changeset_id,
                changeset_arn: self.changeset_arn,
                dataset_id: self.dataset_id,
                change_type: self.change_type,
                source_params: self.source_params,
                format_params: self.format_params,
                create_time: self.create_time.unwrap_or_default(),
                status: self.status,
                error_info: self.error_info,
                active_until_timestamp: self.active_until_timestamp,
                active_from_timestamp: self.active_from_timestamp,
                updates_changeset_id: self.updates_changeset_id,
                updated_by_changeset_id: self.updated_by_changeset_id,
            }
        }
    }
}
impl ChangesetSummary {
    /// Creates a new builder-style object to manufacture [`ChangesetSummary`](crate::model::ChangesetSummary)
    pub fn builder() -> crate::model::changeset_summary::Builder {
        crate::model::changeset_summary::Builder::default()
    }
}

/// <p>The structure with error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangesetErrorInfo {
    /// <p>The text of the error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The category of the error.</p>
    /// <ul>
    /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
    /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
    /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
    /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
    /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
    /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
    /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
    /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
    /// </ul>
    pub error_category: std::option::Option<crate::model::ErrorCategory>,
}
impl ChangesetErrorInfo {
    /// <p>The text of the error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The category of the error.</p>
    /// <ul>
    /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
    /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
    /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
    /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
    /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
    /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
    /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
    /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
    /// </ul>
    pub fn error_category(&self) -> std::option::Option<&crate::model::ErrorCategory> {
        self.error_category.as_ref()
    }
}
impl std::fmt::Debug for ChangesetErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangesetErrorInfo");
        formatter.field("error_message", &self.error_message);
        formatter.field("error_category", &self.error_category);
        formatter.finish()
    }
}
/// See [`ChangesetErrorInfo`](crate::model::ChangesetErrorInfo)
pub mod changeset_error_info {
    /// A builder for [`ChangesetErrorInfo`](crate::model::ChangesetErrorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_category: std::option::Option<crate::model::ErrorCategory>,
    }
    impl Builder {
        /// <p>The text of the error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The category of the error.</p>
        /// <ul>
        /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
        /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
        /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
        /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
        /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
        /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
        /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
        /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
        /// </ul>
        pub fn error_category(mut self, input: crate::model::ErrorCategory) -> Self {
            self.error_category = Some(input);
            self
        }
        /// <p>The category of the error.</p>
        /// <ul>
        /// <li> <p> <code>VALIDATION</code> -The inputs to this request are invalid.</p> </li>
        /// <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li>
        /// <li> <p> <code>ACCESS_DENIED</code> - Missing required permission to perform this request.</p> </li>
        /// <li> <p> <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.</p> </li>
        /// <li> <p> <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.</p> </li>
        /// <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.</p> </li>
        /// <li> <p> <code>CANCELLED</code> - Cancelled.</p> </li>
        /// <li> <p> <code>USER_RECOVERABLE</code> - A user recoverable error has occurred.</p> </li>
        /// </ul>
        pub fn set_error_category(
            mut self,
            input: std::option::Option<crate::model::ErrorCategory>,
        ) -> Self {
            self.error_category = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangesetErrorInfo`](crate::model::ChangesetErrorInfo)
        pub fn build(self) -> crate::model::ChangesetErrorInfo {
            crate::model::ChangesetErrorInfo {
                error_message: self.error_message,
                error_category: self.error_category,
            }
        }
    }
}
impl ChangesetErrorInfo {
    /// Creates a new builder-style object to manufacture [`ChangesetErrorInfo`](crate::model::ChangesetErrorInfo)
    pub fn builder() -> crate::model::changeset_error_info::Builder {
        crate::model::changeset_error_info::Builder::default()
    }
}

/// Status of the ingestion process returned from scheduler service.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IngestionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    StopRequested,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IngestionStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => IngestionStatus::Failed,
            "PENDING" => IngestionStatus::Pending,
            "RUNNING" => IngestionStatus::Running,
            "STOP_REQUESTED" => IngestionStatus::StopRequested,
            "SUCCESS" => IngestionStatus::Success,
            other => IngestionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IngestionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IngestionStatus::from(s))
    }
}
impl IngestionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IngestionStatus::Failed => "FAILED",
            IngestionStatus::Pending => "PENDING",
            IngestionStatus::Running => "RUNNING",
            IngestionStatus::StopRequested => "STOP_REQUESTED",
            IngestionStatus::Success => "SUCCESS",
            IngestionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "RUNNING", "STOP_REQUESTED", "SUCCESS"]
    }
}
impl AsRef<str> for IngestionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Indicates how the given change will be applied to the dataset.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeType {
    #[allow(missing_docs)] // documentation missing in model
    Append,
    #[allow(missing_docs)] // documentation missing in model
    Modify,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeType {
    fn from(s: &str) -> Self {
        match s {
            "APPEND" => ChangeType::Append,
            "MODIFY" => ChangeType::Modify,
            "REPLACE" => ChangeType::Replace,
            other => ChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeType::from(s))
    }
}
impl ChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeType::Append => "APPEND",
            ChangeType::Modify => "MODIFY",
            ChangeType::Replace => "REPLACE",
            ChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPEND", "MODIFY", "REPLACE"]
    }
}
impl AsRef<str> for ChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocationType {
    #[allow(missing_docs)] // documentation missing in model
    Ingestion,
    #[allow(missing_docs)] // documentation missing in model
    Sagemaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocationType {
    fn from(s: &str) -> Self {
        match s {
            "INGESTION" => LocationType::Ingestion,
            "SAGEMAKER" => LocationType::Sagemaker,
            other => LocationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocationType::from(s))
    }
}
impl LocationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocationType::Ingestion => "INGESTION",
            LocationType::Sagemaker => "SAGEMAKER",
            LocationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INGESTION", "SAGEMAKER"]
    }
}
impl AsRef<str> for LocationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Short term API credentials.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Credentials {
    /// <p>The access key identifier.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The access key.</p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p>The session token.</p>
    pub session_token: std::option::Option<std::string::String>,
}
impl Credentials {
    /// <p>The access key identifier.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The access key.</p>
    pub fn secret_access_key(&self) -> std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p>The session token.</p>
    pub fn session_token(&self) -> std::option::Option<&str> {
        self.session_token.as_deref()
    }
}
impl std::fmt::Debug for Credentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Credentials");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("secret_access_key", &self.secret_access_key);
        formatter.field("session_token", &self.session_token);
        formatter.finish()
    }
}
/// See [`Credentials`](crate::model::Credentials)
pub mod credentials {
    /// A builder for [`Credentials`](crate::model::Credentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) session_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access key identifier.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The access key identifier.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The access key.</p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p>The access key.</p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p>The session token.</p>
        pub fn session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_token = Some(input.into());
            self
        }
        /// <p>The session token.</p>
        pub fn set_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_token = input;
            self
        }
        /// Consumes the builder and constructs a [`Credentials`](crate::model::Credentials)
        pub fn build(self) -> crate::model::Credentials {
            crate::model::Credentials {
                access_key_id: self.access_key_id,
                secret_access_key: self.secret_access_key,
                session_token: self.session_token,
            }
        }
    }
}
impl Credentials {
    /// Creates a new builder-style object to manufacture [`Credentials`](crate::model::Credentials)
    pub fn builder() -> crate::model::credentials::Builder {
        crate::model::credentials::Builder::default()
    }
}

/// Status of the dataset process returned from scheduler service.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DatasetStatus::Failed,
            "PENDING" => DatasetStatus::Pending,
            "RUNNING" => DatasetStatus::Running,
            "SUCCESS" => DatasetStatus::Success,
            other => DatasetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetStatus::from(s))
    }
}
impl DatasetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetStatus::Failed => "FAILED",
            DatasetStatus::Pending => "PENDING",
            DatasetStatus::Running => "RUNNING",
            DatasetStatus::Success => "SUCCESS",
            DatasetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "RUNNING", "SUCCESS"]
    }
}
impl AsRef<str> for DatasetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Permission group parameters for Dataset permissions.</p>
/// <p>Here is an example of how you could specify the <code>PermissionGroupParams</code>:</p>
/// <p> <code> { "permissionGroupId": "0r6fCRtSTUk4XPfXQe3M0g", "datasetPermissions": [ {"permission": "ViewDatasetDetails"}, {"permission": "AddDatasetData"}, {"permission": "EditDatasetMetadata"}, {"permission": "DeleteDataset"} ] } </code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionGroupParams {
    /// <p>The unique identifier of the PermissionGroup.</p>
    pub permission_group_id: std::option::Option<std::string::String>,
    /// <p>List of resource permissions.</p>
    pub dataset_permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
}
impl PermissionGroupParams {
    /// <p>The unique identifier of the PermissionGroup.</p>
    pub fn permission_group_id(&self) -> std::option::Option<&str> {
        self.permission_group_id.as_deref()
    }
    /// <p>List of resource permissions.</p>
    pub fn dataset_permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.dataset_permissions.as_deref()
    }
}
impl std::fmt::Debug for PermissionGroupParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionGroupParams");
        formatter.field("permission_group_id", &self.permission_group_id);
        formatter.field("dataset_permissions", &self.dataset_permissions);
        formatter.finish()
    }
}
/// See [`PermissionGroupParams`](crate::model::PermissionGroupParams)
pub mod permission_group_params {
    /// A builder for [`PermissionGroupParams`](crate::model::PermissionGroupParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_group_id: std::option::Option<std::string::String>,
        pub(crate) dataset_permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    }
    impl Builder {
        /// <p>The unique identifier of the PermissionGroup.</p>
        pub fn permission_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the PermissionGroup.</p>
        pub fn set_permission_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_group_id = input;
            self
        }
        /// Appends an item to `dataset_permissions`.
        ///
        /// To override the contents of this collection use [`set_dataset_permissions`](Self::set_dataset_permissions).
        ///
        /// <p>List of resource permissions.</p>
        pub fn dataset_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.dataset_permissions.unwrap_or_default();
            v.push(input);
            self.dataset_permissions = Some(v);
            self
        }
        /// <p>List of resource permissions.</p>
        pub fn set_dataset_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.dataset_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionGroupParams`](crate::model::PermissionGroupParams)
        pub fn build(self) -> crate::model::PermissionGroupParams {
            crate::model::PermissionGroupParams {
                permission_group_id: self.permission_group_id,
                dataset_permissions: self.dataset_permissions,
            }
        }
    }
}
impl PermissionGroupParams {
    /// Creates a new builder-style object to manufacture [`PermissionGroupParams`](crate::model::PermissionGroupParams)
    pub fn builder() -> crate::model::permission_group_params::Builder {
        crate::model::permission_group_params::Builder::default()
    }
}

/// <p>Resource permission for a dataset. When you create a dataset, all the other members of the same user group inherit access to the dataset. You can only create a dataset if your user group has application permission for Create Datasets.</p>
/// <p>The following is a list of valid dataset permissions that you can apply: </p>
/// <ul>
/// <li> <p> <code>ViewDatasetDetails</code> </p> </li>
/// <li> <p> <code>ReadDatasetDetails</code> </p> </li>
/// <li> <p> <code>AddDatasetData</code> </p> </li>
/// <li> <p> <code>CreateSnapshot</code> </p> </li>
/// <li> <p> <code>EditDatasetMetadata</code> </p> </li>
/// <li> <p> <code>DeleteDataset</code> </p> </li>
/// </ul>
/// <p>For more information on the ataset permissions, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/managing-user-permissions.html#supported-dataset-permissions">Supported Dataset Permissions</a> in the FinSpace User Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePermission {
    /// <p>Permission for a resource.</p>
    pub permission: std::option::Option<std::string::String>,
}
impl ResourcePermission {
    /// <p>Permission for a resource.</p>
    pub fn permission(&self) -> std::option::Option<&str> {
        self.permission.as_deref()
    }
}
impl std::fmt::Debug for ResourcePermission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePermission");
        formatter.field("permission", &self.permission);
        formatter.finish()
    }
}
/// See [`ResourcePermission`](crate::model::ResourcePermission)
pub mod resource_permission {
    /// A builder for [`ResourcePermission`](crate::model::ResourcePermission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Permission for a resource.</p>
        pub fn permission(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission = Some(input.into());
            self
        }
        /// <p>Permission for a resource.</p>
        pub fn set_permission(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.permission = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePermission`](crate::model::ResourcePermission)
        pub fn build(self) -> crate::model::ResourcePermission {
            crate::model::ResourcePermission {
                permission: self.permission,
            }
        }
    }
}
impl ResourcePermission {
    /// Creates a new builder-style object to manufacture [`ResourcePermission`](crate::model::ResourcePermission)
    pub fn builder() -> crate::model::resource_permission::Builder {
        crate::model::resource_permission::Builder::default()
    }
}
