// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateChangeset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_changeset`](crate::client::Client::create_changeset).
///
/// See [`crate::client::fluent_builders::CreateChangeset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChangeset {
    _private: (),
}
impl CreateChangeset {
    /// Creates a new builder-style object to manufacture [`CreateChangesetInput`](crate::input::CreateChangesetInput)
    pub fn builder() -> crate::input::create_changeset_input::Builder {
        crate::input::create_changeset_input::Builder::default()
    }
    /// Creates a new `CreateChangeset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChangeset {
    type Output = std::result::Result<
        crate::output::CreateChangesetOutput,
        crate::error::CreateChangesetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_changeset_error(response)
        } else {
            crate::operation_deser::parse_create_changeset_response(response)
        }
    }
}

/// Operation shape for `GetProgrammaticAccessCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_programmatic_access_credentials`](crate::client::Client::get_programmatic_access_credentials).
///
/// See [`crate::client::fluent_builders::GetProgrammaticAccessCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProgrammaticAccessCredentials {
    _private: (),
}
impl GetProgrammaticAccessCredentials {
    /// Creates a new builder-style object to manufacture [`GetProgrammaticAccessCredentialsInput`](crate::input::GetProgrammaticAccessCredentialsInput)
    pub fn builder() -> crate::input::get_programmatic_access_credentials_input::Builder {
        crate::input::get_programmatic_access_credentials_input::Builder::default()
    }
    /// Creates a new `GetProgrammaticAccessCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProgrammaticAccessCredentials {
    type Output = std::result::Result<
        crate::output::GetProgrammaticAccessCredentialsOutput,
        crate::error::GetProgrammaticAccessCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_programmatic_access_credentials_error(response)
        } else {
            crate::operation_deser::parse_get_programmatic_access_credentials_response(response)
        }
    }
}

/// Operation shape for `GetWorkingLocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_working_location`](crate::client::Client::get_working_location).
///
/// See [`crate::client::fluent_builders::GetWorkingLocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkingLocation {
    _private: (),
}
impl GetWorkingLocation {
    /// Creates a new builder-style object to manufacture [`GetWorkingLocationInput`](crate::input::GetWorkingLocationInput)
    pub fn builder() -> crate::input::get_working_location_input::Builder {
        crate::input::get_working_location_input::Builder::default()
    }
    /// Creates a new `GetWorkingLocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkingLocation {
    type Output = std::result::Result<
        crate::output::GetWorkingLocationOutput,
        crate::error::GetWorkingLocationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_working_location_error(response)
        } else {
            crate::operation_deser::parse_get_working_location_response(response)
        }
    }
}
