// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserOutput {
    /// <p>The unique identifier of the updated user account.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl UpdateUserOutput {
    /// <p>The unique identifier of the updated user account.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`UpdateUserOutput`](crate::output::UpdateUserOutput)
pub mod update_user_output {
    /// A builder for [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the updated user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the updated user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserOutput`](crate::output::UpdateUserOutput)
        pub fn build(self) -> crate::output::UpdateUserOutput {
            crate::output::UpdateUserOutput {
                user_id: self.user_id,
            }
        }
    }
}
impl UpdateUserOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    pub fn builder() -> crate::output::update_user_output::Builder {
        crate::output::update_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePermissionGroupOutput {
    /// <p>The unique identifier for the updated permission group.</p>
    pub permission_group_id: std::option::Option<std::string::String>,
}
impl UpdatePermissionGroupOutput {
    /// <p>The unique identifier for the updated permission group.</p>
    pub fn permission_group_id(&self) -> std::option::Option<&str> {
        self.permission_group_id.as_deref()
    }
}
impl std::fmt::Debug for UpdatePermissionGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePermissionGroupOutput");
        formatter.field("permission_group_id", &self.permission_group_id);
        formatter.finish()
    }
}
/// See [`UpdatePermissionGroupOutput`](crate::output::UpdatePermissionGroupOutput)
pub mod update_permission_group_output {
    /// A builder for [`UpdatePermissionGroupOutput`](crate::output::UpdatePermissionGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the updated permission group.</p>
        pub fn permission_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the updated permission group.</p>
        pub fn set_permission_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePermissionGroupOutput`](crate::output::UpdatePermissionGroupOutput)
        pub fn build(self) -> crate::output::UpdatePermissionGroupOutput {
            crate::output::UpdatePermissionGroupOutput {
                permission_group_id: self.permission_group_id,
            }
        }
    }
}
impl UpdatePermissionGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePermissionGroupOutput`](crate::output::UpdatePermissionGroupOutput)
    pub fn builder() -> crate::output::update_permission_group_output::Builder {
        crate::output::update_permission_group_output::Builder::default()
    }
}

/// The response from an UpdateDataset operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatasetOutput {
    /// <p>The unique identifier for updated Dataset.</p>
    pub dataset_id: std::option::Option<std::string::String>,
}
impl UpdateDatasetOutput {
    /// <p>The unique identifier for updated Dataset.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatasetOutput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.finish()
    }
}
/// See [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
pub mod update_dataset_output {
    /// A builder for [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for updated Dataset.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for updated Dataset.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
        pub fn build(self) -> crate::output::UpdateDatasetOutput {
            crate::output::UpdateDatasetOutput {
                dataset_id: self.dataset_id,
            }
        }
    }
}
impl UpdateDatasetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
    pub fn builder() -> crate::output::update_dataset_output::Builder {
        crate::output::update_dataset_output::Builder::default()
    }
}

/// The response from a update changeset operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChangesetOutput {
    /// <p>The unique identifier for the Changeset to update.</p>
    pub changeset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
    pub dataset_id: std::option::Option<std::string::String>,
}
impl UpdateChangesetOutput {
    /// <p>The unique identifier for the Changeset to update.</p>
    pub fn changeset_id(&self) -> std::option::Option<&str> {
        self.changeset_id.as_deref()
    }
    /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateChangesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChangesetOutput");
        formatter.field("changeset_id", &self.changeset_id);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.finish()
    }
}
/// See [`UpdateChangesetOutput`](crate::output::UpdateChangesetOutput)
pub mod update_changeset_output {
    /// A builder for [`UpdateChangesetOutput`](crate::output::UpdateChangesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) changeset_id: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Changeset to update.</p>
        pub fn changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Changeset to update.</p>
        pub fn set_changeset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.changeset_id = input;
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChangesetOutput`](crate::output::UpdateChangesetOutput)
        pub fn build(self) -> crate::output::UpdateChangesetOutput {
            crate::output::UpdateChangesetOutput {
                changeset_id: self.changeset_id,
                dataset_id: self.dataset_id,
            }
        }
    }
}
impl UpdateChangesetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChangesetOutput`](crate::output::UpdateChangesetOutput)
    pub fn builder() -> crate::output::update_changeset_output::Builder {
        crate::output::update_changeset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetUserPasswordOutput {
    /// <p>The unique identifier of the user that a new password is generated for.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>A randomly generated temporary password for the requested user account. This password expires in 7 days.</p>
    pub temporary_password: std::option::Option<std::string::String>,
}
impl ResetUserPasswordOutput {
    /// <p>The unique identifier of the user that a new password is generated for.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>A randomly generated temporary password for the requested user account. This password expires in 7 days.</p>
    pub fn temporary_password(&self) -> std::option::Option<&str> {
        self.temporary_password.as_deref()
    }
}
impl std::fmt::Debug for ResetUserPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetUserPasswordOutput");
        formatter.field("user_id", &self.user_id);
        formatter.field("temporary_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
pub mod reset_user_password_output {
    /// A builder for [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) temporary_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the user that a new password is generated for.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the user that a new password is generated for.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>A randomly generated temporary password for the requested user account. This password expires in 7 days.</p>
        pub fn temporary_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.temporary_password = Some(input.into());
            self
        }
        /// <p>A randomly generated temporary password for the requested user account. This password expires in 7 days.</p>
        pub fn set_temporary_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.temporary_password = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
        pub fn build(self) -> crate::output::ResetUserPasswordOutput {
            crate::output::ResetUserPasswordOutput {
                user_id: self.user_id,
                temporary_password: self.temporary_password,
            }
        }
    }
}
impl ResetUserPasswordOutput {
    /// Creates a new builder-style object to manufacture [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
    pub fn builder() -> crate::output::reset_user_password_output::Builder {
        crate::output::reset_user_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersOutput {
    /// <p>A list of all the user accounts.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUsersOutput {
    /// <p>A list of all the user accounts.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::User]> {
        self.users.as_deref()
    }
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersOutput");
        formatter.field("users", &self.users);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUsersOutput`](crate::output::ListUsersOutput)
pub mod list_users_output {
    /// A builder for [`ListUsersOutput`](crate::output::ListUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>A list of all the user accounts.</p>
        pub fn users(mut self, input: crate::model::User) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input);
            self.users = Some(v);
            self
        }
        /// <p>A list of all the user accounts.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersOutput`](crate::output::ListUsersOutput)
        pub fn build(self) -> crate::output::ListUsersOutput {
            crate::output::ListUsersOutput {
                users: self.users,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUsersOutput {
    /// Creates a new builder-style object to manufacture [`ListUsersOutput`](crate::output::ListUsersOutput)
    pub fn builder() -> crate::output::list_users_output::Builder {
        crate::output::list_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionGroupsOutput {
    /// <p>A list of all the permission groups.</p>
    pub permission_groups: std::option::Option<std::vec::Vec<crate::model::PermissionGroup>>,
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPermissionGroupsOutput {
    /// <p>A list of all the permission groups.</p>
    pub fn permission_groups(&self) -> std::option::Option<&[crate::model::PermissionGroup]> {
        self.permission_groups.as_deref()
    }
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPermissionGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionGroupsOutput");
        formatter.field("permission_groups", &self.permission_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPermissionGroupsOutput`](crate::output::ListPermissionGroupsOutput)
pub mod list_permission_groups_output {
    /// A builder for [`ListPermissionGroupsOutput`](crate::output::ListPermissionGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_groups:
            std::option::Option<std::vec::Vec<crate::model::PermissionGroup>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `permission_groups`.
        ///
        /// To override the contents of this collection use [`set_permission_groups`](Self::set_permission_groups).
        ///
        /// <p>A list of all the permission groups.</p>
        pub fn permission_groups(mut self, input: crate::model::PermissionGroup) -> Self {
            let mut v = self.permission_groups.unwrap_or_default();
            v.push(input);
            self.permission_groups = Some(v);
            self
        }
        /// <p>A list of all the permission groups.</p>
        pub fn set_permission_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionGroup>>,
        ) -> Self {
            self.permission_groups = input;
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionGroupsOutput`](crate::output::ListPermissionGroupsOutput)
        pub fn build(self) -> crate::output::ListPermissionGroupsOutput {
            crate::output::ListPermissionGroupsOutput {
                permission_groups: self.permission_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPermissionGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListPermissionGroupsOutput`](crate::output::ListPermissionGroupsOutput)
    pub fn builder() -> crate::output::list_permission_groups_output::Builder {
        crate::output::list_permission_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataViewsOutput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of Dataviews.</p>
    pub data_views: std::option::Option<std::vec::Vec<crate::model::DataViewSummary>>,
}
impl ListDataViewsOutput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of Dataviews.</p>
    pub fn data_views(&self) -> std::option::Option<&[crate::model::DataViewSummary]> {
        self.data_views.as_deref()
    }
}
impl std::fmt::Debug for ListDataViewsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataViewsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("data_views", &self.data_views);
        formatter.finish()
    }
}
/// See [`ListDataViewsOutput`](crate::output::ListDataViewsOutput)
pub mod list_data_views_output {
    /// A builder for [`ListDataViewsOutput`](crate::output::ListDataViewsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) data_views: std::option::Option<std::vec::Vec<crate::model::DataViewSummary>>,
    }
    impl Builder {
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `data_views`.
        ///
        /// To override the contents of this collection use [`set_data_views`](Self::set_data_views).
        ///
        /// <p>A list of Dataviews.</p>
        pub fn data_views(mut self, input: crate::model::DataViewSummary) -> Self {
            let mut v = self.data_views.unwrap_or_default();
            v.push(input);
            self.data_views = Some(v);
            self
        }
        /// <p>A list of Dataviews.</p>
        pub fn set_data_views(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataViewSummary>>,
        ) -> Self {
            self.data_views = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataViewsOutput`](crate::output::ListDataViewsOutput)
        pub fn build(self) -> crate::output::ListDataViewsOutput {
            crate::output::ListDataViewsOutput {
                next_token: self.next_token,
                data_views: self.data_views,
            }
        }
    }
}
impl ListDataViewsOutput {
    /// Creates a new builder-style object to manufacture [`ListDataViewsOutput`](crate::output::ListDataViewsOutput)
    pub fn builder() -> crate::output::list_data_views_output::Builder {
        crate::output::list_data_views_output::Builder::default()
    }
}

/// Response for the ListDatasets operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsOutput {
    /// <p>List of Datasets.</p>
    pub datasets: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetsOutput {
    /// <p>List of Datasets.</p>
    pub fn datasets(&self) -> std::option::Option<&[crate::model::Dataset]> {
        self.datasets.as_deref()
    }
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsOutput");
        formatter.field("datasets", &self.datasets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
pub mod list_datasets_output {
    /// A builder for [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datasets: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// <p>List of Datasets.</p>
        pub fn datasets(mut self, input: crate::model::Dataset) -> Self {
            let mut v = self.datasets.unwrap_or_default();
            v.push(input);
            self.datasets = Some(v);
            self
        }
        /// <p>List of Datasets.</p>
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
        ) -> Self {
            self.datasets = input;
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
        pub fn build(self) -> crate::output::ListDatasetsOutput {
            crate::output::ListDatasetsOutput {
                datasets: self.datasets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    pub fn builder() -> crate::output::list_datasets_output::Builder {
        crate::output::list_datasets_output::Builder::default()
    }
}

/// Response to ListChangesetsResponse. This returns a list of dataset changesets that match the query criteria.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChangesetsOutput {
    /// <p>List of Changesets found.</p>
    pub changesets: std::option::Option<std::vec::Vec<crate::model::ChangesetSummary>>,
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChangesetsOutput {
    /// <p>List of Changesets found.</p>
    pub fn changesets(&self) -> std::option::Option<&[crate::model::ChangesetSummary]> {
        self.changesets.as_deref()
    }
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChangesetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChangesetsOutput");
        formatter.field("changesets", &self.changesets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListChangesetsOutput`](crate::output::ListChangesetsOutput)
pub mod list_changesets_output {
    /// A builder for [`ListChangesetsOutput`](crate::output::ListChangesetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) changesets: std::option::Option<std::vec::Vec<crate::model::ChangesetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `changesets`.
        ///
        /// To override the contents of this collection use [`set_changesets`](Self::set_changesets).
        ///
        /// <p>List of Changesets found.</p>
        pub fn changesets(mut self, input: crate::model::ChangesetSummary) -> Self {
            let mut v = self.changesets.unwrap_or_default();
            v.push(input);
            self.changesets = Some(v);
            self
        }
        /// <p>List of Changesets found.</p>
        pub fn set_changesets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChangesetSummary>>,
        ) -> Self {
            self.changesets = input;
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChangesetsOutput`](crate::output::ListChangesetsOutput)
        pub fn build(self) -> crate::output::ListChangesetsOutput {
            crate::output::ListChangesetsOutput {
                changesets: self.changesets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChangesetsOutput {
    /// Creates a new builder-style object to manufacture [`ListChangesetsOutput`](crate::output::ListChangesetsOutput)
    pub fn builder() -> crate::output::list_changesets_output::Builder {
        crate::output::list_changesets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkingLocationOutput {
    /// <p>Returns the Amazon S3 URI for the working location.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>Returns the Amazon S3 Path for the working location.</p>
    pub s3_path: std::option::Option<std::string::String>,
    /// <p>Returns the Amazon S3 bucket name for the working location.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
}
impl GetWorkingLocationOutput {
    /// <p>Returns the Amazon S3 URI for the working location.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>Returns the Amazon S3 Path for the working location.</p>
    pub fn s3_path(&self) -> std::option::Option<&str> {
        self.s3_path.as_deref()
    }
    /// <p>Returns the Amazon S3 bucket name for the working location.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
}
impl std::fmt::Debug for GetWorkingLocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkingLocationOutput");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("s3_path", &self.s3_path);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.finish()
    }
}
/// See [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
pub mod get_working_location_output {
    /// A builder for [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) s3_path: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the Amazon S3 URI for the working location.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>Returns the Amazon S3 URI for the working location.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>Returns the Amazon S3 Path for the working location.</p>
        pub fn s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_path = Some(input.into());
            self
        }
        /// <p>Returns the Amazon S3 Path for the working location.</p>
        pub fn set_s3_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_path = input;
            self
        }
        /// <p>Returns the Amazon S3 bucket name for the working location.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>Returns the Amazon S3 bucket name for the working location.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
        pub fn build(self) -> crate::output::GetWorkingLocationOutput {
            crate::output::GetWorkingLocationOutput {
                s3_uri: self.s3_uri,
                s3_path: self.s3_path,
                s3_bucket: self.s3_bucket,
            }
        }
    }
}
impl GetWorkingLocationOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
    pub fn builder() -> crate::output::get_working_location_output::Builder {
        crate::output::get_working_location_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserOutput {
    /// <p>The unique identifier for the user account that is retrieved.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The current status of the user account. </p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> – The user account creation is in progress.</p> </li>
    /// <li> <p> <code>ENABLED</code> – The user account is created and is currently active.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user account is currently inactive.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::UserStatus>,
    /// <p>The first name of the user.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name of the user.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The email address that is associated with the user.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>Indicates the type of user. </p>
    /// <ul>
    /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::UserType>,
    /// <p>Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations. </p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
    /// </ul>
    pub api_access: std::option::Option<crate::model::ApiAccess>,
    /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
    pub api_access_principal_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in milliseconds. </p>
    pub create_time: i64,
    /// <p>Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds.</p>
    pub last_enabled_time: i64,
    /// <p>Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.</p>
    pub last_disabled_time: i64,
    /// <p>Describes the last time the user account was updated. The value is determined as epoch time in milliseconds.</p>
    pub last_modified_time: i64,
    /// <p>Describes the last time that the user logged into their account. The value is determined as epoch time in milliseconds.</p>
    pub last_login_time: i64,
}
impl GetUserOutput {
    /// <p>The unique identifier for the user account that is retrieved.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The current status of the user account. </p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> – The user account creation is in progress.</p> </li>
    /// <li> <p> <code>ENABLED</code> – The user account is created and is currently active.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user account is currently inactive.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::UserStatus> {
        self.status.as_ref()
    }
    /// <p>The first name of the user.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>The last name of the user.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>The email address that is associated with the user.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>Indicates the type of user. </p>
    /// <ul>
    /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UserType> {
        self.r#type.as_ref()
    }
    /// <p>Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations. </p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
    /// </ul>
    pub fn api_access(&self) -> std::option::Option<&crate::model::ApiAccess> {
        self.api_access.as_ref()
    }
    /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
    pub fn api_access_principal_arn(&self) -> std::option::Option<&str> {
        self.api_access_principal_arn.as_deref()
    }
    /// <p>The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in milliseconds. </p>
    pub fn create_time(&self) -> i64 {
        self.create_time
    }
    /// <p>Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds.</p>
    pub fn last_enabled_time(&self) -> i64 {
        self.last_enabled_time
    }
    /// <p>Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.</p>
    pub fn last_disabled_time(&self) -> i64 {
        self.last_disabled_time
    }
    /// <p>Describes the last time the user account was updated. The value is determined as epoch time in milliseconds.</p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p>Describes the last time that the user logged into their account. The value is determined as epoch time in milliseconds.</p>
    pub fn last_login_time(&self) -> i64 {
        self.last_login_time
    }
}
impl std::fmt::Debug for GetUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.field("status", &self.status);
        formatter.field("first_name", &"*** Sensitive Data Redacted ***");
        formatter.field("last_name", &"*** Sensitive Data Redacted ***");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("api_access", &self.api_access);
        formatter.field("api_access_principal_arn", &self.api_access_principal_arn);
        formatter.field("create_time", &self.create_time);
        formatter.field("last_enabled_time", &self.last_enabled_time);
        formatter.field("last_disabled_time", &self.last_disabled_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_login_time", &self.last_login_time);
        formatter.finish()
    }
}
/// See [`GetUserOutput`](crate::output::GetUserOutput)
pub mod get_user_output {
    /// A builder for [`GetUserOutput`](crate::output::GetUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::UserStatus>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UserType>,
        pub(crate) api_access: std::option::Option<crate::model::ApiAccess>,
        pub(crate) api_access_principal_arn: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) last_enabled_time: std::option::Option<i64>,
        pub(crate) last_disabled_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) last_login_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique identifier for the user account that is retrieved.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user account that is retrieved.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The current status of the user account. </p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> – The user account creation is in progress.</p> </li>
        /// <li> <p> <code>ENABLED</code> – The user account is created and is currently active.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user account is currently inactive.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::UserStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the user account. </p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> – The user account creation is in progress.</p> </li>
        /// <li> <p> <code>ENABLED</code> – The user account is created and is currently active.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user account is currently inactive.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::UserStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The first name of the user.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name of the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name of the user.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name of the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The email address that is associated with the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address that is associated with the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>Indicates the type of user. </p>
        /// <ul>
        /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Indicates the type of user. </p>
        /// <ul>
        /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations. </p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
        /// </ul>
        pub fn api_access(mut self, input: crate::model::ApiAccess) -> Self {
            self.api_access = Some(input);
            self
        }
        /// <p>Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations. </p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
        /// </ul>
        pub fn set_api_access(
            mut self,
            input: std::option::Option<crate::model::ApiAccess>,
        ) -> Self {
            self.api_access = input;
            self
        }
        /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
        pub fn api_access_principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_access_principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
        pub fn set_api_access_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_access_principal_arn = input;
            self
        }
        /// <p>The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in milliseconds. </p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in milliseconds. </p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds.</p>
        pub fn last_enabled_time(mut self, input: i64) -> Self {
            self.last_enabled_time = Some(input);
            self
        }
        /// <p>Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds.</p>
        pub fn set_last_enabled_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_enabled_time = input;
            self
        }
        /// <p>Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.</p>
        pub fn last_disabled_time(mut self, input: i64) -> Self {
            self.last_disabled_time = Some(input);
            self
        }
        /// <p>Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.</p>
        pub fn set_last_disabled_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_disabled_time = input;
            self
        }
        /// <p>Describes the last time the user account was updated. The value is determined as epoch time in milliseconds.</p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>Describes the last time the user account was updated. The value is determined as epoch time in milliseconds.</p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Describes the last time that the user logged into their account. The value is determined as epoch time in milliseconds.</p>
        pub fn last_login_time(mut self, input: i64) -> Self {
            self.last_login_time = Some(input);
            self
        }
        /// <p>Describes the last time that the user logged into their account. The value is determined as epoch time in milliseconds.</p>
        pub fn set_last_login_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_login_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserOutput`](crate::output::GetUserOutput)
        pub fn build(self) -> crate::output::GetUserOutput {
            crate::output::GetUserOutput {
                user_id: self.user_id,
                status: self.status,
                first_name: self.first_name,
                last_name: self.last_name,
                email_address: self.email_address,
                r#type: self.r#type,
                api_access: self.api_access,
                api_access_principal_arn: self.api_access_principal_arn,
                create_time: self.create_time.unwrap_or_default(),
                last_enabled_time: self.last_enabled_time.unwrap_or_default(),
                last_disabled_time: self.last_disabled_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                last_login_time: self.last_login_time.unwrap_or_default(),
            }
        }
    }
}
impl GetUserOutput {
    /// Creates a new builder-style object to manufacture [`GetUserOutput`](crate::output::GetUserOutput)
    pub fn builder() -> crate::output::get_user_output::Builder {
        crate::output::get_user_output::Builder::default()
    }
}

/// Response for GetProgrammaticAccessCredentials operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProgrammaticAccessCredentialsOutput {
    /// <p>Returns the programmatic credentials.</p>
    pub credentials: std::option::Option<crate::model::Credentials>,
    /// <p>Returns the duration in which the credentials will remain valid.</p>
    pub duration_in_minutes: i64,
}
impl GetProgrammaticAccessCredentialsOutput {
    /// <p>Returns the programmatic credentials.</p>
    pub fn credentials(&self) -> std::option::Option<&crate::model::Credentials> {
        self.credentials.as_ref()
    }
    /// <p>Returns the duration in which the credentials will remain valid.</p>
    pub fn duration_in_minutes(&self) -> i64 {
        self.duration_in_minutes
    }
}
impl std::fmt::Debug for GetProgrammaticAccessCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProgrammaticAccessCredentialsOutput");
        formatter.field("credentials", &self.credentials);
        formatter.field("duration_in_minutes", &self.duration_in_minutes);
        formatter.finish()
    }
}
/// See [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
pub mod get_programmatic_access_credentials_output {
    /// A builder for [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
        pub(crate) duration_in_minutes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Returns the programmatic credentials.</p>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>Returns the programmatic credentials.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// <p>Returns the duration in which the credentials will remain valid.</p>
        pub fn duration_in_minutes(mut self, input: i64) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>Returns the duration in which the credentials will remain valid.</p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
        pub fn build(self) -> crate::output::GetProgrammaticAccessCredentialsOutput {
            crate::output::GetProgrammaticAccessCredentialsOutput {
                credentials: self.credentials,
                duration_in_minutes: self.duration_in_minutes.unwrap_or_default(),
            }
        }
    }
}
impl GetProgrammaticAccessCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
    pub fn builder() -> crate::output::get_programmatic_access_credentials_output::Builder {
        crate::output::get_programmatic_access_credentials_output::Builder::default()
    }
}

/// Response from retrieving a dataview, which includes details on the target database and table name
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataViewOutput {
    /// <p>Flag to indicate Dataview should be updated automatically.</p>
    pub auto_update: bool,
    /// <p>Ordered set of column names used to partition data.</p>
    pub partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The unique identifier for the Dataset used in the Dataview.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub as_of_timestamp: std::option::Option<i64>,
    /// <p>Information about an error that occurred for the Dataview.</p>
    pub error_info: std::option::Option<crate::model::DataViewErrorInfo>,
    /// <p>The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub last_modified_time: i64,
    /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub create_time: i64,
    /// <p>Columns to be used for sorting the data.</p>
    pub sort_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The unique identifier for the Dataview.</p>
    pub data_view_id: std::option::Option<std::string::String>,
    /// <p>The ARN identifier of the Dataview.</p>
    pub data_view_arn: std::option::Option<std::string::String>,
    /// <p>Options that define the destination type for the Dataview.</p>
    pub destination_type_params: std::option::Option<crate::model::DataViewDestinationTypeParams>,
    /// <p>The status of a Dataview creation.</p>
    /// <ul>
    /// <li> <p> <code>RUNNING</code> – Dataview creation is running.</p> </li>
    /// <li> <p> <code>STARTING</code> – Dataview creation is starting.</p> </li>
    /// <li> <p> <code>FAILED</code> – Dataview creation has failed.</p> </li>
    /// <li> <p> <code>CANCELLED</code> – Dataview creation has been cancelled.</p> </li>
    /// <li> <p> <code>TIMEOUT</code> – Dataview creation has timed out.</p> </li>
    /// <li> <p> <code>SUCCESS</code> – Dataview creation has succeeded.</p> </li>
    /// <li> <p> <code>PENDING</code> – Dataview creation is pending.</p> </li>
    /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DataViewStatus>,
}
impl GetDataViewOutput {
    /// <p>Flag to indicate Dataview should be updated automatically.</p>
    pub fn auto_update(&self) -> bool {
        self.auto_update
    }
    /// <p>Ordered set of column names used to partition data.</p>
    pub fn partition_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_columns.as_deref()
    }
    /// <p>The unique identifier for the Dataset used in the Dataview.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn as_of_timestamp(&self) -> std::option::Option<i64> {
        self.as_of_timestamp
    }
    /// <p>Information about an error that occurred for the Dataview.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::DataViewErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p>The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn create_time(&self) -> i64 {
        self.create_time
    }
    /// <p>Columns to be used for sorting the data.</p>
    pub fn sort_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.sort_columns.as_deref()
    }
    /// <p>The unique identifier for the Dataview.</p>
    pub fn data_view_id(&self) -> std::option::Option<&str> {
        self.data_view_id.as_deref()
    }
    /// <p>The ARN identifier of the Dataview.</p>
    pub fn data_view_arn(&self) -> std::option::Option<&str> {
        self.data_view_arn.as_deref()
    }
    /// <p>Options that define the destination type for the Dataview.</p>
    pub fn destination_type_params(
        &self,
    ) -> std::option::Option<&crate::model::DataViewDestinationTypeParams> {
        self.destination_type_params.as_ref()
    }
    /// <p>The status of a Dataview creation.</p>
    /// <ul>
    /// <li> <p> <code>RUNNING</code> – Dataview creation is running.</p> </li>
    /// <li> <p> <code>STARTING</code> – Dataview creation is starting.</p> </li>
    /// <li> <p> <code>FAILED</code> – Dataview creation has failed.</p> </li>
    /// <li> <p> <code>CANCELLED</code> – Dataview creation has been cancelled.</p> </li>
    /// <li> <p> <code>TIMEOUT</code> – Dataview creation has timed out.</p> </li>
    /// <li> <p> <code>SUCCESS</code> – Dataview creation has succeeded.</p> </li>
    /// <li> <p> <code>PENDING</code> – Dataview creation is pending.</p> </li>
    /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::DataViewStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetDataViewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataViewOutput");
        formatter.field("auto_update", &self.auto_update);
        formatter.field("partition_columns", &self.partition_columns);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("as_of_timestamp", &self.as_of_timestamp);
        formatter.field("error_info", &self.error_info);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("create_time", &self.create_time);
        formatter.field("sort_columns", &self.sort_columns);
        formatter.field("data_view_id", &self.data_view_id);
        formatter.field("data_view_arn", &self.data_view_arn);
        formatter.field("destination_type_params", &self.destination_type_params);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetDataViewOutput`](crate::output::GetDataViewOutput)
pub mod get_data_view_output {
    /// A builder for [`GetDataViewOutput`](crate::output::GetDataViewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_update: std::option::Option<bool>,
        pub(crate) partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) as_of_timestamp: std::option::Option<i64>,
        pub(crate) error_info: std::option::Option<crate::model::DataViewErrorInfo>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) sort_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) data_view_id: std::option::Option<std::string::String>,
        pub(crate) data_view_arn: std::option::Option<std::string::String>,
        pub(crate) destination_type_params:
            std::option::Option<crate::model::DataViewDestinationTypeParams>,
        pub(crate) status: std::option::Option<crate::model::DataViewStatus>,
    }
    impl Builder {
        /// <p>Flag to indicate Dataview should be updated automatically.</p>
        pub fn auto_update(mut self, input: bool) -> Self {
            self.auto_update = Some(input);
            self
        }
        /// <p>Flag to indicate Dataview should be updated automatically.</p>
        pub fn set_auto_update(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_update = input;
            self
        }
        /// Appends an item to `partition_columns`.
        ///
        /// To override the contents of this collection use [`set_partition_columns`](Self::set_partition_columns).
        ///
        /// <p>Ordered set of column names used to partition data.</p>
        pub fn partition_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_columns.unwrap_or_default();
            v.push(input.into());
            self.partition_columns = Some(v);
            self
        }
        /// <p>Ordered set of column names used to partition data.</p>
        pub fn set_partition_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_columns = input;
            self
        }
        /// <p>The unique identifier for the Dataset used in the Dataview.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Dataset used in the Dataview.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn as_of_timestamp(mut self, input: i64) -> Self {
            self.as_of_timestamp = Some(input);
            self
        }
        /// <p>Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_as_of_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.as_of_timestamp = input;
            self
        }
        /// <p>Information about an error that occurred for the Dataview.</p>
        pub fn error_info(mut self, input: crate::model::DataViewErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>Information about an error that occurred for the Dataview.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::DataViewErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// <p>The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// Appends an item to `sort_columns`.
        ///
        /// To override the contents of this collection use [`set_sort_columns`](Self::set_sort_columns).
        ///
        /// <p>Columns to be used for sorting the data.</p>
        pub fn sort_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sort_columns.unwrap_or_default();
            v.push(input.into());
            self.sort_columns = Some(v);
            self
        }
        /// <p>Columns to be used for sorting the data.</p>
        pub fn set_sort_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sort_columns = input;
            self
        }
        /// <p>The unique identifier for the Dataview.</p>
        pub fn data_view_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_view_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Dataview.</p>
        pub fn set_data_view_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_view_id = input;
            self
        }
        /// <p>The ARN identifier of the Dataview.</p>
        pub fn data_view_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_view_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of the Dataview.</p>
        pub fn set_data_view_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_view_arn = input;
            self
        }
        /// <p>Options that define the destination type for the Dataview.</p>
        pub fn destination_type_params(
            mut self,
            input: crate::model::DataViewDestinationTypeParams,
        ) -> Self {
            self.destination_type_params = Some(input);
            self
        }
        /// <p>Options that define the destination type for the Dataview.</p>
        pub fn set_destination_type_params(
            mut self,
            input: std::option::Option<crate::model::DataViewDestinationTypeParams>,
        ) -> Self {
            self.destination_type_params = input;
            self
        }
        /// <p>The status of a Dataview creation.</p>
        /// <ul>
        /// <li> <p> <code>RUNNING</code> – Dataview creation is running.</p> </li>
        /// <li> <p> <code>STARTING</code> – Dataview creation is starting.</p> </li>
        /// <li> <p> <code>FAILED</code> – Dataview creation has failed.</p> </li>
        /// <li> <p> <code>CANCELLED</code> – Dataview creation has been cancelled.</p> </li>
        /// <li> <p> <code>TIMEOUT</code> – Dataview creation has timed out.</p> </li>
        /// <li> <p> <code>SUCCESS</code> – Dataview creation has succeeded.</p> </li>
        /// <li> <p> <code>PENDING</code> – Dataview creation is pending.</p> </li>
        /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DataViewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a Dataview creation.</p>
        /// <ul>
        /// <li> <p> <code>RUNNING</code> – Dataview creation is running.</p> </li>
        /// <li> <p> <code>STARTING</code> – Dataview creation is starting.</p> </li>
        /// <li> <p> <code>FAILED</code> – Dataview creation has failed.</p> </li>
        /// <li> <p> <code>CANCELLED</code> – Dataview creation has been cancelled.</p> </li>
        /// <li> <p> <code>TIMEOUT</code> – Dataview creation has timed out.</p> </li>
        /// <li> <p> <code>SUCCESS</code> – Dataview creation has succeeded.</p> </li>
        /// <li> <p> <code>PENDING</code> – Dataview creation is pending.</p> </li>
        /// <li> <p> <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataViewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataViewOutput`](crate::output::GetDataViewOutput)
        pub fn build(self) -> crate::output::GetDataViewOutput {
            crate::output::GetDataViewOutput {
                auto_update: self.auto_update.unwrap_or_default(),
                partition_columns: self.partition_columns,
                dataset_id: self.dataset_id,
                as_of_timestamp: self.as_of_timestamp,
                error_info: self.error_info,
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                create_time: self.create_time.unwrap_or_default(),
                sort_columns: self.sort_columns,
                data_view_id: self.data_view_id,
                data_view_arn: self.data_view_arn,
                destination_type_params: self.destination_type_params,
                status: self.status,
            }
        }
    }
}
impl GetDataViewOutput {
    /// Creates a new builder-style object to manufacture [`GetDataViewOutput`](crate::output::GetDataViewOutput)
    pub fn builder() -> crate::output::get_data_view_output::Builder {
        crate::output::get_data_view_output::Builder::default()
    }
}

/// Response for the GetDataset operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDatasetOutput {
    /// <p>The unique identifier for a Dataset.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The ARN identifier of the Dataset.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>Display title for a Dataset.</p>
    pub dataset_title: std::option::Option<std::string::String>,
    /// <p>The format in which Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub kind: std::option::Option<crate::model::DatasetKind>,
    /// <p>A description of the Dataset.</p>
    pub dataset_description: std::option::Option<std::string::String>,
    /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub create_time: i64,
    /// <p>The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub last_modified_time: i64,
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub schema_definition: std::option::Option<crate::model::SchemaUnion>,
    /// <p>The unique resource identifier for a Dataset.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>Status of the Dataset creation.</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> – Dataset is pending creation.</p> </li>
    /// <li> <p> <code>FAILED</code> – Dataset creation has failed.</p> </li>
    /// <li> <p> <code>SUCCESS</code> – Dataset creation has succeeded.</p> </li>
    /// <li> <p> <code>RUNNING</code> – Dataset creation is running.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DatasetStatus>,
}
impl GetDatasetOutput {
    /// <p>The unique identifier for a Dataset.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The ARN identifier of the Dataset.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>Display title for a Dataset.</p>
    pub fn dataset_title(&self) -> std::option::Option<&str> {
        self.dataset_title.as_deref()
    }
    /// <p>The format in which Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub fn kind(&self) -> std::option::Option<&crate::model::DatasetKind> {
        self.kind.as_ref()
    }
    /// <p>A description of the Dataset.</p>
    pub fn dataset_description(&self) -> std::option::Option<&str> {
        self.dataset_description.as_deref()
    }
    /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn create_time(&self) -> i64 {
        self.create_time
    }
    /// <p>The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub fn schema_definition(&self) -> std::option::Option<&crate::model::SchemaUnion> {
        self.schema_definition.as_ref()
    }
    /// <p>The unique resource identifier for a Dataset.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>Status of the Dataset creation.</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> – Dataset is pending creation.</p> </li>
    /// <li> <p> <code>FAILED</code> – Dataset creation has failed.</p> </li>
    /// <li> <p> <code>SUCCESS</code> – Dataset creation has succeeded.</p> </li>
    /// <li> <p> <code>RUNNING</code> – Dataset creation is running.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::DatasetStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDatasetOutput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("dataset_title", &self.dataset_title);
        formatter.field("kind", &self.kind);
        formatter.field("dataset_description", &self.dataset_description);
        formatter.field("create_time", &self.create_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("schema_definition", &self.schema_definition);
        formatter.field("alias", &self.alias);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetDatasetOutput`](crate::output::GetDatasetOutput)
pub mod get_dataset_output {
    /// A builder for [`GetDatasetOutput`](crate::output::GetDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_title: std::option::Option<std::string::String>,
        pub(crate) kind: std::option::Option<crate::model::DatasetKind>,
        pub(crate) dataset_description: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) schema_definition: std::option::Option<crate::model::SchemaUnion>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DatasetStatus>,
    }
    impl Builder {
        /// <p>The unique identifier for a Dataset.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a Dataset.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The ARN identifier of the Dataset.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of the Dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>Display title for a Dataset.</p>
        pub fn dataset_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_title = Some(input.into());
            self
        }
        /// <p>Display title for a Dataset.</p>
        pub fn set_dataset_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_title = input;
            self
        }
        /// <p>The format in which Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::DatasetKind) -> Self {
            self.kind = Some(input);
            self
        }
        /// <p>The format in which Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::DatasetKind>) -> Self {
            self.kind = input;
            self
        }
        /// <p>A description of the Dataset.</p>
        pub fn dataset_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_description = Some(input.into());
            self
        }
        /// <p>A description of the Dataset.</p>
        pub fn set_dataset_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_description = input;
            self
        }
        /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaUnion) -> Self {
            self.schema_definition = Some(input);
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaUnion>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>Status of the Dataset creation.</p>
        /// <ul>
        /// <li> <p> <code>PENDING</code> – Dataset is pending creation.</p> </li>
        /// <li> <p> <code>FAILED</code> – Dataset creation has failed.</p> </li>
        /// <li> <p> <code>SUCCESS</code> – Dataset creation has succeeded.</p> </li>
        /// <li> <p> <code>RUNNING</code> – Dataset creation is running.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DatasetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the Dataset creation.</p>
        /// <ul>
        /// <li> <p> <code>PENDING</code> – Dataset is pending creation.</p> </li>
        /// <li> <p> <code>FAILED</code> – Dataset creation has failed.</p> </li>
        /// <li> <p> <code>SUCCESS</code> – Dataset creation has succeeded.</p> </li>
        /// <li> <p> <code>RUNNING</code> – Dataset creation is running.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatasetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDatasetOutput`](crate::output::GetDatasetOutput)
        pub fn build(self) -> crate::output::GetDatasetOutput {
            crate::output::GetDatasetOutput {
                dataset_id: self.dataset_id,
                dataset_arn: self.dataset_arn,
                dataset_title: self.dataset_title,
                kind: self.kind,
                dataset_description: self.dataset_description,
                create_time: self.create_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                schema_definition: self.schema_definition,
                alias: self.alias,
                status: self.status,
            }
        }
    }
}
impl GetDatasetOutput {
    /// Creates a new builder-style object to manufacture [`GetDatasetOutput`](crate::output::GetDatasetOutput)
    pub fn builder() -> crate::output::get_dataset_output::Builder {
        crate::output::get_dataset_output::Builder::default()
    }
}

/// The response from a describe changeset operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangesetOutput {
    /// <p>The unique identifier for a Changeset.</p>
    pub changeset_id: std::option::Option<std::string::String>,
    /// <p>The ARN identifier of the Changeset.</p>
    pub changeset_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
    /// <ul>
    /// <li> <p> <code>REPLACE</code> – Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>APPEND</code> – Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
    /// </ul>
    pub change_type: std::option::Option<crate::model::ChangeType>,
    /// <p>Options that define the location of the data being ingested.</p>
    pub source_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Structure of the source file(s).</p>
    pub format_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub create_time: i64,
    /// <p>The status of Changeset creation operation.</p>
    pub status: std::option::Option<crate::model::IngestionStatus>,
    /// <p>The structure with error messages.</p>
    pub error_info: std::option::Option<crate::model::ChangesetErrorInfo>,
    /// <p>Time until which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub active_until_timestamp: std::option::Option<i64>,
    /// <p>Beginning time from which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub active_from_timestamp: std::option::Option<i64>,
    /// <p>The unique identifier of the Changeset that is being updated.</p>
    pub updates_changeset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the updated Changeset.</p>
    pub updated_by_changeset_id: std::option::Option<std::string::String>,
}
impl GetChangesetOutput {
    /// <p>The unique identifier for a Changeset.</p>
    pub fn changeset_id(&self) -> std::option::Option<&str> {
        self.changeset_id.as_deref()
    }
    /// <p>The ARN identifier of the Changeset.</p>
    pub fn changeset_arn(&self) -> std::option::Option<&str> {
        self.changeset_arn.as_deref()
    }
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
    /// <ul>
    /// <li> <p> <code>REPLACE</code> – Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>APPEND</code> – Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
    /// </ul>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.change_type.as_ref()
    }
    /// <p>Options that define the location of the data being ingested.</p>
    pub fn source_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.source_params.as_ref()
    }
    /// <p>Structure of the source file(s).</p>
    pub fn format_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.format_params.as_ref()
    }
    /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn create_time(&self) -> i64 {
        self.create_time
    }
    /// <p>The status of Changeset creation operation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::IngestionStatus> {
        self.status.as_ref()
    }
    /// <p>The structure with error messages.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::ChangesetErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p>Time until which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn active_until_timestamp(&self) -> std::option::Option<i64> {
        self.active_until_timestamp
    }
    /// <p>Beginning time from which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn active_from_timestamp(&self) -> std::option::Option<i64> {
        self.active_from_timestamp
    }
    /// <p>The unique identifier of the Changeset that is being updated.</p>
    pub fn updates_changeset_id(&self) -> std::option::Option<&str> {
        self.updates_changeset_id.as_deref()
    }
    /// <p>The unique identifier of the updated Changeset.</p>
    pub fn updated_by_changeset_id(&self) -> std::option::Option<&str> {
        self.updated_by_changeset_id.as_deref()
    }
}
impl std::fmt::Debug for GetChangesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangesetOutput");
        formatter.field("changeset_id", &self.changeset_id);
        formatter.field("changeset_arn", &self.changeset_arn);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("change_type", &self.change_type);
        formatter.field("source_params", &self.source_params);
        formatter.field("format_params", &self.format_params);
        formatter.field("create_time", &self.create_time);
        formatter.field("status", &self.status);
        formatter.field("error_info", &self.error_info);
        formatter.field("active_until_timestamp", &self.active_until_timestamp);
        formatter.field("active_from_timestamp", &self.active_from_timestamp);
        formatter.field("updates_changeset_id", &self.updates_changeset_id);
        formatter.field("updated_by_changeset_id", &self.updated_by_changeset_id);
        formatter.finish()
    }
}
/// See [`GetChangesetOutput`](crate::output::GetChangesetOutput)
pub mod get_changeset_output {
    /// A builder for [`GetChangesetOutput`](crate::output::GetChangesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) changeset_id: std::option::Option<std::string::String>,
        pub(crate) changeset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeType>,
        pub(crate) source_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) format_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::IngestionStatus>,
        pub(crate) error_info: std::option::Option<crate::model::ChangesetErrorInfo>,
        pub(crate) active_until_timestamp: std::option::Option<i64>,
        pub(crate) active_from_timestamp: std::option::Option<i64>,
        pub(crate) updates_changeset_id: std::option::Option<std::string::String>,
        pub(crate) updated_by_changeset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a Changeset.</p>
        pub fn changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a Changeset.</p>
        pub fn set_changeset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.changeset_id = input;
            self
        }
        /// <p>The ARN identifier of the Changeset.</p>
        pub fn changeset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of the Changeset.</p>
        pub fn set_changeset_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.changeset_arn = input;
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
        /// <ul>
        /// <li> <p> <code>REPLACE</code> – Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>APPEND</code> – Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
        /// </ul>
        pub fn change_type(mut self, input: crate::model::ChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>Type that indicates how a Changeset is applied to a Dataset.</p>
        /// <ul>
        /// <li> <p> <code>REPLACE</code> – Changeset is considered as a replacement to all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>APPEND</code> – Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
        /// </ul>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// Adds a key-value pair to `source_params`.
        ///
        /// To override the contents of this collection use [`set_source_params`](Self::set_source_params).
        ///
        /// <p>Options that define the location of the data being ingested.</p>
        pub fn source_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.source_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.source_params = Some(hash_map);
            self
        }
        /// <p>Options that define the location of the data being ingested.</p>
        pub fn set_source_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.source_params = input;
            self
        }
        /// Adds a key-value pair to `format_params`.
        ///
        /// To override the contents of this collection use [`set_format_params`](Self::set_format_params).
        ///
        /// <p>Structure of the source file(s).</p>
        pub fn format_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.format_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.format_params = Some(hash_map);
            self
        }
        /// <p>Structure of the source file(s).</p>
        pub fn set_format_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.format_params = input;
            self
        }
        /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp at which the Changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The status of Changeset creation operation.</p>
        pub fn status(mut self, input: crate::model::IngestionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of Changeset creation operation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IngestionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn error_info(mut self, input: crate::model::ChangesetErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::ChangesetErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// <p>Time until which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn active_until_timestamp(mut self, input: i64) -> Self {
            self.active_until_timestamp = Some(input);
            self
        }
        /// <p>Time until which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_active_until_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.active_until_timestamp = input;
            self
        }
        /// <p>Beginning time from which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn active_from_timestamp(mut self, input: i64) -> Self {
            self.active_from_timestamp = Some(input);
            self
        }
        /// <p>Beginning time from which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_active_from_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.active_from_timestamp = input;
            self
        }
        /// <p>The unique identifier of the Changeset that is being updated.</p>
        pub fn updates_changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.updates_changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Changeset that is being updated.</p>
        pub fn set_updates_changeset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.updates_changeset_id = input;
            self
        }
        /// <p>The unique identifier of the updated Changeset.</p>
        pub fn updated_by_changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by_changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the updated Changeset.</p>
        pub fn set_updated_by_changeset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.updated_by_changeset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangesetOutput`](crate::output::GetChangesetOutput)
        pub fn build(self) -> crate::output::GetChangesetOutput {
            crate::output::GetChangesetOutput {
                changeset_id: self.changeset_id,
                changeset_arn: self.changeset_arn,
                dataset_id: self.dataset_id,
                change_type: self.change_type,
                source_params: self.source_params,
                format_params: self.format_params,
                create_time: self.create_time.unwrap_or_default(),
                status: self.status,
                error_info: self.error_info,
                active_until_timestamp: self.active_until_timestamp,
                active_from_timestamp: self.active_from_timestamp,
                updates_changeset_id: self.updates_changeset_id,
                updated_by_changeset_id: self.updated_by_changeset_id,
            }
        }
    }
}
impl GetChangesetOutput {
    /// Creates a new builder-style object to manufacture [`GetChangesetOutput`](crate::output::GetChangesetOutput)
    pub fn builder() -> crate::output::get_changeset_output::Builder {
        crate::output::get_changeset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableUserOutput {
    /// <p>The unique identifier for the enabled user account.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl EnableUserOutput {
    /// <p>The unique identifier for the enabled user account.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for EnableUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`EnableUserOutput`](crate::output::EnableUserOutput)
pub mod enable_user_output {
    /// A builder for [`EnableUserOutput`](crate::output::EnableUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the enabled user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the enabled user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableUserOutput`](crate::output::EnableUserOutput)
        pub fn build(self) -> crate::output::EnableUserOutput {
            crate::output::EnableUserOutput {
                user_id: self.user_id,
            }
        }
    }
}
impl EnableUserOutput {
    /// Creates a new builder-style object to manufacture [`EnableUserOutput`](crate::output::EnableUserOutput)
    pub fn builder() -> crate::output::enable_user_output::Builder {
        crate::output::enable_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableUserOutput {
    /// <p>The unique identifier for the disabled user account.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl DisableUserOutput {
    /// <p>The unique identifier for the disabled user account.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for DisableUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`DisableUserOutput`](crate::output::DisableUserOutput)
pub mod disable_user_output {
    /// A builder for [`DisableUserOutput`](crate::output::DisableUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the disabled user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the disabled user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableUserOutput`](crate::output::DisableUserOutput)
        pub fn build(self) -> crate::output::DisableUserOutput {
            crate::output::DisableUserOutput {
                user_id: self.user_id,
            }
        }
    }
}
impl DisableUserOutput {
    /// Creates a new builder-style object to manufacture [`DisableUserOutput`](crate::output::DisableUserOutput)
    pub fn builder() -> crate::output::disable_user_output::Builder {
        crate::output::disable_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePermissionGroupOutput {
    /// <p>The unique identifier for the deleted permission group.</p>
    pub permission_group_id: std::option::Option<std::string::String>,
}
impl DeletePermissionGroupOutput {
    /// <p>The unique identifier for the deleted permission group.</p>
    pub fn permission_group_id(&self) -> std::option::Option<&str> {
        self.permission_group_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePermissionGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePermissionGroupOutput");
        formatter.field("permission_group_id", &self.permission_group_id);
        formatter.finish()
    }
}
/// See [`DeletePermissionGroupOutput`](crate::output::DeletePermissionGroupOutput)
pub mod delete_permission_group_output {
    /// A builder for [`DeletePermissionGroupOutput`](crate::output::DeletePermissionGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the deleted permission group.</p>
        pub fn permission_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the deleted permission group.</p>
        pub fn set_permission_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePermissionGroupOutput`](crate::output::DeletePermissionGroupOutput)
        pub fn build(self) -> crate::output::DeletePermissionGroupOutput {
            crate::output::DeletePermissionGroupOutput {
                permission_group_id: self.permission_group_id,
            }
        }
    }
}
impl DeletePermissionGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeletePermissionGroupOutput`](crate::output::DeletePermissionGroupOutput)
    pub fn builder() -> crate::output::delete_permission_group_output::Builder {
        crate::output::delete_permission_group_output::Builder::default()
    }
}

/// The response from an DeleteDataset operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetOutput {
    /// <p>The unique identifier for the deleted Dataset.</p>
    pub dataset_id: std::option::Option<std::string::String>,
}
impl DeleteDatasetOutput {
    /// <p>The unique identifier for the deleted Dataset.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetOutput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.finish()
    }
}
/// See [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
pub mod delete_dataset_output {
    /// A builder for [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the deleted Dataset.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the deleted Dataset.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
        pub fn build(self) -> crate::output::DeleteDatasetOutput {
            crate::output::DeleteDatasetOutput {
                dataset_id: self.dataset_id,
            }
        }
    }
}
impl DeleteDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    pub fn builder() -> crate::output::delete_dataset_output::Builder {
        crate::output::delete_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserOutput {
    /// <p>The unique identifier for the user.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl CreateUserOutput {
    /// <p>The unique identifier for the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for CreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`CreateUserOutput`](crate::output::CreateUserOutput)
pub mod create_user_output {
    /// A builder for [`CreateUserOutput`](crate::output::CreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserOutput`](crate::output::CreateUserOutput)
        pub fn build(self) -> crate::output::CreateUserOutput {
            crate::output::CreateUserOutput {
                user_id: self.user_id,
            }
        }
    }
}
impl CreateUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserOutput`](crate::output::CreateUserOutput)
    pub fn builder() -> crate::output::create_user_output::Builder {
        crate::output::create_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePermissionGroupOutput {
    /// <p>The unique identifier for the permission group.</p>
    pub permission_group_id: std::option::Option<std::string::String>,
}
impl CreatePermissionGroupOutput {
    /// <p>The unique identifier for the permission group.</p>
    pub fn permission_group_id(&self) -> std::option::Option<&str> {
        self.permission_group_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePermissionGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePermissionGroupOutput");
        formatter.field("permission_group_id", &self.permission_group_id);
        formatter.finish()
    }
}
/// See [`CreatePermissionGroupOutput`](crate::output::CreatePermissionGroupOutput)
pub mod create_permission_group_output {
    /// A builder for [`CreatePermissionGroupOutput`](crate::output::CreatePermissionGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the permission group.</p>
        pub fn permission_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the permission group.</p>
        pub fn set_permission_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePermissionGroupOutput`](crate::output::CreatePermissionGroupOutput)
        pub fn build(self) -> crate::output::CreatePermissionGroupOutput {
            crate::output::CreatePermissionGroupOutput {
                permission_group_id: self.permission_group_id,
            }
        }
    }
}
impl CreatePermissionGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreatePermissionGroupOutput`](crate::output::CreatePermissionGroupOutput)
    pub fn builder() -> crate::output::create_permission_group_output::Builder {
        crate::output::create_permission_group_output::Builder::default()
    }
}

/// Response for creating a data view.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataViewOutput {
    /// <p>The unique identifier of the Dataset used for the Dataview.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the created Dataview.</p>
    pub data_view_id: std::option::Option<std::string::String>,
}
impl CreateDataViewOutput {
    /// <p>The unique identifier of the Dataset used for the Dataview.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The unique identifier for the created Dataview.</p>
    pub fn data_view_id(&self) -> std::option::Option<&str> {
        self.data_view_id.as_deref()
    }
}
impl std::fmt::Debug for CreateDataViewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataViewOutput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("data_view_id", &self.data_view_id);
        formatter.finish()
    }
}
/// See [`CreateDataViewOutput`](crate::output::CreateDataViewOutput)
pub mod create_data_view_output {
    /// A builder for [`CreateDataViewOutput`](crate::output::CreateDataViewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) data_view_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the Dataset used for the Dataview.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Dataset used for the Dataview.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The unique identifier for the created Dataview.</p>
        pub fn data_view_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_view_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the created Dataview.</p>
        pub fn set_data_view_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_view_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataViewOutput`](crate::output::CreateDataViewOutput)
        pub fn build(self) -> crate::output::CreateDataViewOutput {
            crate::output::CreateDataViewOutput {
                dataset_id: self.dataset_id,
                data_view_id: self.data_view_id,
            }
        }
    }
}
impl CreateDataViewOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataViewOutput`](crate::output::CreateDataViewOutput)
    pub fn builder() -> crate::output::create_data_view_output::Builder {
        crate::output::create_data_view_output::Builder::default()
    }
}

/// The response from a CreateDataset operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetOutput {
    /// <p>The unique identifier for the created Dataset.</p>
    pub dataset_id: std::option::Option<std::string::String>,
}
impl CreateDatasetOutput {
    /// <p>The unique identifier for the created Dataset.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetOutput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.finish()
    }
}
/// See [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
pub mod create_dataset_output {
    /// A builder for [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the created Dataset.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the created Dataset.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
        pub fn build(self) -> crate::output::CreateDatasetOutput {
            crate::output::CreateDatasetOutput {
                dataset_id: self.dataset_id,
            }
        }
    }
}
impl CreateDatasetOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    pub fn builder() -> crate::output::create_dataset_output::Builder {
        crate::output::create_dataset_output::Builder::default()
    }
}

/// The response from a CreateChangeset operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChangesetOutput {
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the Changeset that is created.</p>
    pub changeset_id: std::option::Option<std::string::String>,
}
impl CreateChangesetOutput {
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The unique identifier of the Changeset that is created.</p>
    pub fn changeset_id(&self) -> std::option::Option<&str> {
        self.changeset_id.as_deref()
    }
}
impl std::fmt::Debug for CreateChangesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChangesetOutput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("changeset_id", &self.changeset_id);
        formatter.finish()
    }
}
/// See [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
pub mod create_changeset_output {
    /// A builder for [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) changeset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The unique identifier of the Changeset that is created.</p>
        pub fn changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Changeset that is created.</p>
        pub fn set_changeset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.changeset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
        pub fn build(self) -> crate::output::CreateChangesetOutput {
            crate::output::CreateChangesetOutput {
                dataset_id: self.dataset_id,
                changeset_id: self.changeset_id,
            }
        }
    }
}
impl CreateChangesetOutput {
    /// Creates a new builder-style object to manufacture [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
    pub fn builder() -> crate::output::create_changeset_output::Builder {
        crate::output::create_changeset_output::Builder::default()
    }
}
