// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateChangeset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_changeset`](crate::client::Client::create_changeset).
///
/// See [`crate::client::fluent_builders::CreateChangeset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChangeset {
    _private: (),
}
impl CreateChangeset {
    /// Creates a new builder-style object to manufacture [`CreateChangesetInput`](crate::input::CreateChangesetInput)
    pub fn builder() -> crate::input::create_changeset_input::Builder {
        crate::input::create_changeset_input::Builder::default()
    }
    /// Creates a new `CreateChangeset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChangeset {
    type Output = std::result::Result<
        crate::output::CreateChangesetOutput,
        crate::error::CreateChangesetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_changeset_error(response)
        } else {
            crate::operation_deser::parse_create_changeset_response(response)
        }
    }
}

/// Operation shape for `CreateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset`](crate::client::Client::create_dataset).
///
/// See [`crate::client::fluent_builders::CreateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataset {
    _private: (),
}
impl CreateDataset {
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
    /// Creates a new `CreateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataset {
    type Output =
        std::result::Result<crate::output::CreateDatasetOutput, crate::error::CreateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_response(response)
        }
    }
}

/// Operation shape for `CreateDataView`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_view`](crate::client::Client::create_data_view).
///
/// See [`crate::client::fluent_builders::CreateDataView`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataView {
    _private: (),
}
impl CreateDataView {
    /// Creates a new builder-style object to manufacture [`CreateDataViewInput`](crate::input::CreateDataViewInput)
    pub fn builder() -> crate::input::create_data_view_input::Builder {
        crate::input::create_data_view_input::Builder::default()
    }
    /// Creates a new `CreateDataView` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataView {
    type Output =
        std::result::Result<crate::output::CreateDataViewOutput, crate::error::CreateDataViewError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_view_error(response)
        } else {
            crate::operation_deser::parse_create_data_view_response(response)
        }
    }
}

/// Operation shape for `CreatePermissionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_permission_group`](crate::client::Client::create_permission_group).
///
/// See [`crate::client::fluent_builders::CreatePermissionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePermissionGroup {
    _private: (),
}
impl CreatePermissionGroup {
    /// Creates a new builder-style object to manufacture [`CreatePermissionGroupInput`](crate::input::CreatePermissionGroupInput)
    pub fn builder() -> crate::input::create_permission_group_input::Builder {
        crate::input::create_permission_group_input::Builder::default()
    }
    /// Creates a new `CreatePermissionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePermissionGroup {
    type Output = std::result::Result<
        crate::output::CreatePermissionGroupOutput,
        crate::error::CreatePermissionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_permission_group_error(response)
        } else {
            crate::operation_deser::parse_create_permission_group_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `DeleteDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset`](crate::client::Client::delete_dataset).
///
/// See [`crate::client::fluent_builders::DeleteDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataset {
    _private: (),
}
impl DeleteDataset {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
    /// Creates a new `DeleteDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataset {
    type Output =
        std::result::Result<crate::output::DeleteDatasetOutput, crate::error::DeleteDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_response(response)
        }
    }
}

/// Operation shape for `DeletePermissionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_permission_group`](crate::client::Client::delete_permission_group).
///
/// See [`crate::client::fluent_builders::DeletePermissionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePermissionGroup {
    _private: (),
}
impl DeletePermissionGroup {
    /// Creates a new builder-style object to manufacture [`DeletePermissionGroupInput`](crate::input::DeletePermissionGroupInput)
    pub fn builder() -> crate::input::delete_permission_group_input::Builder {
        crate::input::delete_permission_group_input::Builder::default()
    }
    /// Creates a new `DeletePermissionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePermissionGroup {
    type Output = std::result::Result<
        crate::output::DeletePermissionGroupOutput,
        crate::error::DeletePermissionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_permission_group_error(response)
        } else {
            crate::operation_deser::parse_delete_permission_group_response(response)
        }
    }
}

/// Operation shape for `DisableUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_user`](crate::client::Client::disable_user).
///
/// See [`crate::client::fluent_builders::DisableUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableUser {
    _private: (),
}
impl DisableUser {
    /// Creates a new builder-style object to manufacture [`DisableUserInput`](crate::input::DisableUserInput)
    pub fn builder() -> crate::input::disable_user_input::Builder {
        crate::input::disable_user_input::Builder::default()
    }
    /// Creates a new `DisableUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableUser {
    type Output =
        std::result::Result<crate::output::DisableUserOutput, crate::error::DisableUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_user_error(response)
        } else {
            crate::operation_deser::parse_disable_user_response(response)
        }
    }
}

/// Operation shape for `EnableUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_user`](crate::client::Client::enable_user).
///
/// See [`crate::client::fluent_builders::EnableUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableUser {
    _private: (),
}
impl EnableUser {
    /// Creates a new builder-style object to manufacture [`EnableUserInput`](crate::input::EnableUserInput)
    pub fn builder() -> crate::input::enable_user_input::Builder {
        crate::input::enable_user_input::Builder::default()
    }
    /// Creates a new `EnableUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableUser {
    type Output =
        std::result::Result<crate::output::EnableUserOutput, crate::error::EnableUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_user_error(response)
        } else {
            crate::operation_deser::parse_enable_user_response(response)
        }
    }
}

/// Operation shape for `GetChangeset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_changeset`](crate::client::Client::get_changeset).
///
/// See [`crate::client::fluent_builders::GetChangeset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChangeset {
    _private: (),
}
impl GetChangeset {
    /// Creates a new builder-style object to manufacture [`GetChangesetInput`](crate::input::GetChangesetInput)
    pub fn builder() -> crate::input::get_changeset_input::Builder {
        crate::input::get_changeset_input::Builder::default()
    }
    /// Creates a new `GetChangeset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChangeset {
    type Output =
        std::result::Result<crate::output::GetChangesetOutput, crate::error::GetChangesetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_changeset_error(response)
        } else {
            crate::operation_deser::parse_get_changeset_response(response)
        }
    }
}

/// Operation shape for `GetDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dataset`](crate::client::Client::get_dataset).
///
/// See [`crate::client::fluent_builders::GetDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataset {
    _private: (),
}
impl GetDataset {
    /// Creates a new builder-style object to manufacture [`GetDatasetInput`](crate::input::GetDatasetInput)
    pub fn builder() -> crate::input::get_dataset_input::Builder {
        crate::input::get_dataset_input::Builder::default()
    }
    /// Creates a new `GetDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataset {
    type Output =
        std::result::Result<crate::output::GetDatasetOutput, crate::error::GetDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dataset_error(response)
        } else {
            crate::operation_deser::parse_get_dataset_response(response)
        }
    }
}

/// Operation shape for `GetDataView`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_data_view`](crate::client::Client::get_data_view).
///
/// See [`crate::client::fluent_builders::GetDataView`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataView {
    _private: (),
}
impl GetDataView {
    /// Creates a new builder-style object to manufacture [`GetDataViewInput`](crate::input::GetDataViewInput)
    pub fn builder() -> crate::input::get_data_view_input::Builder {
        crate::input::get_data_view_input::Builder::default()
    }
    /// Creates a new `GetDataView` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataView {
    type Output =
        std::result::Result<crate::output::GetDataViewOutput, crate::error::GetDataViewError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_data_view_error(response)
        } else {
            crate::operation_deser::parse_get_data_view_response(response)
        }
    }
}

/// Operation shape for `GetProgrammaticAccessCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_programmatic_access_credentials`](crate::client::Client::get_programmatic_access_credentials).
///
/// See [`crate::client::fluent_builders::GetProgrammaticAccessCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProgrammaticAccessCredentials {
    _private: (),
}
impl GetProgrammaticAccessCredentials {
    /// Creates a new builder-style object to manufacture [`GetProgrammaticAccessCredentialsInput`](crate::input::GetProgrammaticAccessCredentialsInput)
    pub fn builder() -> crate::input::get_programmatic_access_credentials_input::Builder {
        crate::input::get_programmatic_access_credentials_input::Builder::default()
    }
    /// Creates a new `GetProgrammaticAccessCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProgrammaticAccessCredentials {
    type Output = std::result::Result<
        crate::output::GetProgrammaticAccessCredentialsOutput,
        crate::error::GetProgrammaticAccessCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_programmatic_access_credentials_error(response)
        } else {
            crate::operation_deser::parse_get_programmatic_access_credentials_response(response)
        }
    }
}

/// Operation shape for `GetUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user`](crate::client::Client::get_user).
///
/// See [`crate::client::fluent_builders::GetUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUser {
    _private: (),
}
impl GetUser {
    /// Creates a new builder-style object to manufacture [`GetUserInput`](crate::input::GetUserInput)
    pub fn builder() -> crate::input::get_user_input::Builder {
        crate::input::get_user_input::Builder::default()
    }
    /// Creates a new `GetUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUser {
    type Output = std::result::Result<crate::output::GetUserOutput, crate::error::GetUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_error(response)
        } else {
            crate::operation_deser::parse_get_user_response(response)
        }
    }
}

/// Operation shape for `GetWorkingLocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_working_location`](crate::client::Client::get_working_location).
///
/// See [`crate::client::fluent_builders::GetWorkingLocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkingLocation {
    _private: (),
}
impl GetWorkingLocation {
    /// Creates a new builder-style object to manufacture [`GetWorkingLocationInput`](crate::input::GetWorkingLocationInput)
    pub fn builder() -> crate::input::get_working_location_input::Builder {
        crate::input::get_working_location_input::Builder::default()
    }
    /// Creates a new `GetWorkingLocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkingLocation {
    type Output = std::result::Result<
        crate::output::GetWorkingLocationOutput,
        crate::error::GetWorkingLocationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_working_location_error(response)
        } else {
            crate::operation_deser::parse_get_working_location_response(response)
        }
    }
}

/// Operation shape for `ListChangesets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_changesets`](crate::client::Client::list_changesets).
///
/// See [`crate::client::fluent_builders::ListChangesets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChangesets {
    _private: (),
}
impl ListChangesets {
    /// Creates a new builder-style object to manufacture [`ListChangesetsInput`](crate::input::ListChangesetsInput)
    pub fn builder() -> crate::input::list_changesets_input::Builder {
        crate::input::list_changesets_input::Builder::default()
    }
    /// Creates a new `ListChangesets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChangesets {
    type Output =
        std::result::Result<crate::output::ListChangesetsOutput, crate::error::ListChangesetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_changesets_error(response)
        } else {
            crate::operation_deser::parse_list_changesets_response(response)
        }
    }
}

/// Operation shape for `ListDatasets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_datasets`](crate::client::Client::list_datasets).
///
/// See [`crate::client::fluent_builders::ListDatasets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasets {
    _private: (),
}
impl ListDatasets {
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
    /// Creates a new `ListDatasets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasets {
    type Output =
        std::result::Result<crate::output::ListDatasetsOutput, crate::error::ListDatasetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_datasets_error(response)
        } else {
            crate::operation_deser::parse_list_datasets_response(response)
        }
    }
}

/// Operation shape for `ListDataViews`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_views`](crate::client::Client::list_data_views).
///
/// See [`crate::client::fluent_builders::ListDataViews`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataViews {
    _private: (),
}
impl ListDataViews {
    /// Creates a new builder-style object to manufacture [`ListDataViewsInput`](crate::input::ListDataViewsInput)
    pub fn builder() -> crate::input::list_data_views_input::Builder {
        crate::input::list_data_views_input::Builder::default()
    }
    /// Creates a new `ListDataViews` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataViews {
    type Output =
        std::result::Result<crate::output::ListDataViewsOutput, crate::error::ListDataViewsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_views_error(response)
        } else {
            crate::operation_deser::parse_list_data_views_response(response)
        }
    }
}

/// Operation shape for `ListPermissionGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_permission_groups`](crate::client::Client::list_permission_groups).
///
/// See [`crate::client::fluent_builders::ListPermissionGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPermissionGroups {
    _private: (),
}
impl ListPermissionGroups {
    /// Creates a new builder-style object to manufacture [`ListPermissionGroupsInput`](crate::input::ListPermissionGroupsInput)
    pub fn builder() -> crate::input::list_permission_groups_input::Builder {
        crate::input::list_permission_groups_input::Builder::default()
    }
    /// Creates a new `ListPermissionGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPermissionGroups {
    type Output = std::result::Result<
        crate::output::ListPermissionGroupsOutput,
        crate::error::ListPermissionGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_permission_groups_error(response)
        } else {
            crate::operation_deser::parse_list_permission_groups_response(response)
        }
    }
}

/// Operation shape for `ListUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users`](crate::client::Client::list_users).
///
/// See [`crate::client::fluent_builders::ListUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsers {
    _private: (),
}
impl ListUsers {
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
    /// Creates a new `ListUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsers {
    type Output = std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_error(response)
        } else {
            crate::operation_deser::parse_list_users_response(response)
        }
    }
}

/// Operation shape for `ResetUserPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_user_password`](crate::client::Client::reset_user_password).
///
/// See [`crate::client::fluent_builders::ResetUserPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetUserPassword {
    _private: (),
}
impl ResetUserPassword {
    /// Creates a new builder-style object to manufacture [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
    pub fn builder() -> crate::input::reset_user_password_input::Builder {
        crate::input::reset_user_password_input::Builder::default()
    }
    /// Creates a new `ResetUserPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetUserPassword {
    type Output = std::result::Result<
        crate::output::ResetUserPasswordOutput,
        crate::error::ResetUserPasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_user_password_error(response)
        } else {
            crate::operation_deser::parse_reset_user_password_response(response)
        }
    }
}

/// Operation shape for `UpdateChangeset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_changeset`](crate::client::Client::update_changeset).
///
/// See [`crate::client::fluent_builders::UpdateChangeset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChangeset {
    _private: (),
}
impl UpdateChangeset {
    /// Creates a new builder-style object to manufacture [`UpdateChangesetInput`](crate::input::UpdateChangesetInput)
    pub fn builder() -> crate::input::update_changeset_input::Builder {
        crate::input::update_changeset_input::Builder::default()
    }
    /// Creates a new `UpdateChangeset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChangeset {
    type Output = std::result::Result<
        crate::output::UpdateChangesetOutput,
        crate::error::UpdateChangesetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_changeset_error(response)
        } else {
            crate::operation_deser::parse_update_changeset_response(response)
        }
    }
}

/// Operation shape for `UpdateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dataset`](crate::client::Client::update_dataset).
///
/// See [`crate::client::fluent_builders::UpdateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataset {
    _private: (),
}
impl UpdateDataset {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
    pub fn builder() -> crate::input::update_dataset_input::Builder {
        crate::input::update_dataset_input::Builder::default()
    }
    /// Creates a new `UpdateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataset {
    type Output =
        std::result::Result<crate::output::UpdateDatasetOutput, crate::error::UpdateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dataset_error(response)
        } else {
            crate::operation_deser::parse_update_dataset_response(response)
        }
    }
}

/// Operation shape for `UpdatePermissionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_permission_group`](crate::client::Client::update_permission_group).
///
/// See [`crate::client::fluent_builders::UpdatePermissionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePermissionGroup {
    _private: (),
}
impl UpdatePermissionGroup {
    /// Creates a new builder-style object to manufacture [`UpdatePermissionGroupInput`](crate::input::UpdatePermissionGroupInput)
    pub fn builder() -> crate::input::update_permission_group_input::Builder {
        crate::input::update_permission_group_input::Builder::default()
    }
    /// Creates a new `UpdatePermissionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePermissionGroup {
    type Output = std::result::Result<
        crate::output::UpdatePermissionGroupOutput,
        crate::error::UpdatePermissionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_permission_group_error(response)
        } else {
            crate::operation_deser::parse_update_permission_group_response(response)
        }
    }
}

/// Operation shape for `UpdateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user`](crate::client::Client::update_user).
///
/// See [`crate::client::fluent_builders::UpdateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUser {
    _private: (),
}
impl UpdateUser {
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
    /// Creates a new `UpdateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUser {
    type Output =
        std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_error(response)
        } else {
            crate::operation_deser::parse_update_user_response(response)
        }
    }
}
