// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateChangesetInput`](crate::input::CreateChangesetInput)
pub mod create_changeset_input {
    /// A builder for [`CreateChangesetInput`](crate::input::CreateChangesetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeType>,
        pub(crate) source_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) format_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset will be created. </p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset will be created. </p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The option to indicate how a Changeset will be applied to a Dataset.</p>
        /// <ul>
        /// <li> <p> <code>REPLACE</code> – Changeset will be considered as a replacement to all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>APPEND</code> – Changeset will be considered as an addition to the end of all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
        /// </ul>
        pub fn change_type(mut self, input: crate::model::ChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>The option to indicate how a Changeset will be applied to a Dataset.</p>
        /// <ul>
        /// <li> <p> <code>REPLACE</code> – Changeset will be considered as a replacement to all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>APPEND</code> – Changeset will be considered as an addition to the end of all prior loaded Changesets.</p> </li>
        /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
        /// </ul>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// Adds a key-value pair to `source_params`.
        ///
        /// To override the contents of this collection use [`set_source_params`](Self::set_source_params).
        ///
        /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
        /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
        /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
        /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
        /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a> section.</p>
        pub fn source_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.source_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.source_params = Some(hash_map);
            self
        }
        /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
        /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
        /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
        /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
        /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a> section.</p>
        pub fn set_source_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.source_params = input;
            self
        }
        /// Adds a key-value pair to `format_params`.
        ///
        /// To override the contents of this collection use [`set_format_params`](Self::set_format_params).
        ///
        /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
        /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
        /// <ul>
        /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
        /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
        /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
        /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
        /// </ul>
        /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
        /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
        /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
        /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
        /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
        pub fn format_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.format_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.format_params = Some(hash_map);
            self
        }
        /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
        /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
        /// <ul>
        /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
        /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
        /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
        /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
        /// </ul>
        /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
        /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
        /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
        /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
        /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
        pub fn set_format_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.format_params = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChangesetInput`](crate::input::CreateChangesetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChangesetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChangesetInput {
                client_token: self.client_token,
                dataset_id: self.dataset_id,
                change_type: self.change_type,
                source_params: self.source_params,
                format_params: self.format_params,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChangesetInputOperationOutputAlias = crate::operation::CreateChangeset;
#[doc(hidden)]
pub type CreateChangesetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChangesetInput {
    /// Consumes the builder and constructs an Operation<[`CreateChangeset`](crate::operation::CreateChangeset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChangeset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateChangesetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.dataset_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_1, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/datasets/{datasetId}/changesetsv2",
                    datasetId = dataset_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateChangesetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_changeset(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChangeset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChangeset",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateChangesetInput`](crate::input::CreateChangesetInput)
    pub fn builder() -> crate::input::create_changeset_input::Builder {
        crate::input::create_changeset_input::Builder::default()
    }
}

/// See [`CreateDatasetInput`](crate::input::CreateDatasetInput)
pub mod create_dataset_input {
    /// A builder for [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dataset_title: std::option::Option<std::string::String>,
        pub(crate) kind: std::option::Option<crate::model::DatasetKind>,
        pub(crate) dataset_description: std::option::Option<std::string::String>,
        pub(crate) owner_info: std::option::Option<crate::model::DatasetOwnerInfo>,
        pub(crate) permission_group_params:
            std::option::Option<crate::model::PermissionGroupParams>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) schema_definition: std::option::Option<crate::model::SchemaUnion>,
    }
    impl Builder {
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Display title for a FinSpace Dataset.</p>
        pub fn dataset_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_title = Some(input.into());
            self
        }
        /// <p>Display title for a FinSpace Dataset.</p>
        pub fn set_dataset_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_title = input;
            self
        }
        /// <p>The format in which Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::DatasetKind) -> Self {
            self.kind = Some(input);
            self
        }
        /// <p>The format in which Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::DatasetKind>) -> Self {
            self.kind = input;
            self
        }
        /// <p>Description of a Dataset.</p>
        pub fn dataset_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_description = Some(input.into());
            self
        }
        /// <p>Description of a Dataset.</p>
        pub fn set_dataset_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_description = input;
            self
        }
        /// <p>Contact information for a Dataset owner.</p>
        pub fn owner_info(mut self, input: crate::model::DatasetOwnerInfo) -> Self {
            self.owner_info = Some(input);
            self
        }
        /// <p>Contact information for a Dataset owner.</p>
        pub fn set_owner_info(
            mut self,
            input: std::option::Option<crate::model::DatasetOwnerInfo>,
        ) -> Self {
            self.owner_info = input;
            self
        }
        /// <p>Permission group parameters for Dataset permissions.</p>
        pub fn permission_group_params(
            mut self,
            input: crate::model::PermissionGroupParams,
        ) -> Self {
            self.permission_group_params = Some(input);
            self
        }
        /// <p>Permission group parameters for Dataset permissions.</p>
        pub fn set_permission_group_params(
            mut self,
            input: std::option::Option<crate::model::PermissionGroupParams>,
        ) -> Self {
            self.permission_group_params = input;
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaUnion) -> Self {
            self.schema_definition = Some(input);
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaUnion>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetInput`](crate::input::CreateDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDatasetInput {
                client_token: self.client_token,
                dataset_title: self.dataset_title,
                kind: self.kind,
                dataset_description: self.dataset_description,
                owner_info: self.owner_info,
                permission_group_params: self.permission_group_params,
                alias: self.alias,
                schema_definition: self.schema_definition,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDatasetInputOperationOutputAlias = crate::operation::CreateDataset;
#[doc(hidden)]
pub type CreateDatasetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDatasetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataset`](crate::operation::CreateDataset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDatasetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/datasetsv2").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDatasetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_dataset(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataset",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
}

/// See [`CreateDataViewInput`](crate::input::CreateDataViewInput)
pub mod create_data_view_input {
    /// A builder for [`CreateDataViewInput`](crate::input::CreateDataViewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) auto_update: std::option::Option<bool>,
        pub(crate) sort_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) as_of_timestamp: std::option::Option<i64>,
        pub(crate) destination_type_params:
            std::option::Option<crate::model::DataViewDestinationTypeParams>,
    }
    impl Builder {
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The unique Dataset identifier that is used to create a Dataview.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique Dataset identifier that is used to create a Dataview.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>Flag to indicate Dataview should be updated automatically.</p>
        pub fn auto_update(mut self, input: bool) -> Self {
            self.auto_update = Some(input);
            self
        }
        /// <p>Flag to indicate Dataview should be updated automatically.</p>
        pub fn set_auto_update(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_update = input;
            self
        }
        /// Appends an item to `sort_columns`.
        ///
        /// To override the contents of this collection use [`set_sort_columns`](Self::set_sort_columns).
        ///
        /// <p>Columns to be used for sorting the data.</p>
        pub fn sort_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sort_columns.unwrap_or_default();
            v.push(input.into());
            self.sort_columns = Some(v);
            self
        }
        /// <p>Columns to be used for sorting the data.</p>
        pub fn set_sort_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sort_columns = input;
            self
        }
        /// Appends an item to `partition_columns`.
        ///
        /// To override the contents of this collection use [`set_partition_columns`](Self::set_partition_columns).
        ///
        /// <p>Ordered set of column names used to partition data.</p>
        pub fn partition_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_columns.unwrap_or_default();
            v.push(input.into());
            self.partition_columns = Some(v);
            self
        }
        /// <p>Ordered set of column names used to partition data.</p>
        pub fn set_partition_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_columns = input;
            self
        }
        /// <p>Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn as_of_timestamp(mut self, input: i64) -> Self {
            self.as_of_timestamp = Some(input);
            self
        }
        /// <p>Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
        pub fn set_as_of_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.as_of_timestamp = input;
            self
        }
        /// <p>Options that define the destination type for the Dataview.</p>
        pub fn destination_type_params(
            mut self,
            input: crate::model::DataViewDestinationTypeParams,
        ) -> Self {
            self.destination_type_params = Some(input);
            self
        }
        /// <p>Options that define the destination type for the Dataview.</p>
        pub fn set_destination_type_params(
            mut self,
            input: std::option::Option<crate::model::DataViewDestinationTypeParams>,
        ) -> Self {
            self.destination_type_params = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataViewInput`](crate::input::CreateDataViewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataViewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataViewInput {
                client_token: self.client_token,
                dataset_id: self.dataset_id,
                auto_update: self.auto_update.unwrap_or_default(),
                sort_columns: self.sort_columns,
                partition_columns: self.partition_columns,
                as_of_timestamp: self.as_of_timestamp,
                destination_type_params: self.destination_type_params,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataViewInputOperationOutputAlias = crate::operation::CreateDataView;
#[doc(hidden)]
pub type CreateDataViewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDataViewInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataView`](crate::operation::CreateDataView)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataView,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDataViewInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.dataset_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_2, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/datasets/{datasetId}/dataviewsv2",
                    datasetId = dataset_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDataViewInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_data_view(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataView::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataView",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDataViewInput`](crate::input::CreateDataViewInput)
    pub fn builder() -> crate::input::create_data_view_input::Builder {
        crate::input::create_data_view_input::Builder::default()
    }
}

/// See [`CreatePermissionGroupInput`](crate::input::CreatePermissionGroupInput)
pub mod create_permission_group_input {
    /// A builder for [`CreatePermissionGroupInput`](crate::input::CreatePermissionGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) application_permissions:
            std::option::Option<std::vec::Vec<crate::model::ApplicationPermission>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the permission group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the permission group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A brief description for the permission group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A brief description for the permission group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `application_permissions`.
        ///
        /// To override the contents of this collection use [`set_application_permissions`](Self::set_application_permissions).
        ///
        /// <p>The option to indicate FinSpace application permissions that are granted to a specific group.</p>
        /// <ul>
        /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
        /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
        /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
        /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
        /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
        /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
        /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
        /// </ul>
        pub fn application_permissions(
            mut self,
            input: crate::model::ApplicationPermission,
        ) -> Self {
            let mut v = self.application_permissions.unwrap_or_default();
            v.push(input);
            self.application_permissions = Some(v);
            self
        }
        /// <p>The option to indicate FinSpace application permissions that are granted to a specific group.</p>
        /// <ul>
        /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
        /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
        /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
        /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
        /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
        /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
        /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
        /// </ul>
        pub fn set_application_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationPermission>>,
        ) -> Self {
            self.application_permissions = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePermissionGroupInput`](crate::input::CreatePermissionGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePermissionGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePermissionGroupInput {
                name: self.name,
                description: self.description,
                application_permissions: self.application_permissions,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePermissionGroupInputOperationOutputAlias = crate::operation::CreatePermissionGroup;
#[doc(hidden)]
pub type CreatePermissionGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePermissionGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreatePermissionGroup`](crate::operation::CreatePermissionGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePermissionGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePermissionGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/permission-group").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePermissionGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_permission_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePermissionGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePermissionGroup",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePermissionGroupInput`](crate::input::CreatePermissionGroupInput)
    pub fn builder() -> crate::input::create_permission_group_input::Builder {
        crate::input::create_permission_group_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UserType>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) api_access: std::option::Option<crate::model::ApiAccess>,
        pub(crate) api_access_principal_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address of the user that you want to register. The email address serves as a uniquer identifier for each user and cannot be changed after it's created.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address of the user that you want to register. The email address serves as a uniquer identifier for each user and cannot be changed after it's created.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The option to indicate the type of user. Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
        /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permission group.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The option to indicate the type of user. Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
        /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permission group.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The first name of the user that you want to register.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name of the user that you want to register.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name of the user that you want to register.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name of the user that you want to register.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
        /// </ul>
        pub fn api_access(mut self, input: crate::model::ApiAccess) -> Self {
            self.api_access = Some(input);
            self
        }
        /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
        /// </ul>
        pub fn set_api_access(
            mut self,
            input: std::option::Option<crate::model::ApiAccess>,
        ) -> Self {
            self.api_access = input;
            self
        }
        /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
        pub fn api_access_principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_access_principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
        pub fn set_api_access_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_access_principal_arn = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                email_address: self.email_address,
                r#type: self.r#type,
                first_name: self.first_name,
                last_name: self.last_name,
                api_access: self.api_access,
                api_access_principal_arn: self.api_access_principal_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/user").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
pub mod delete_dataset_input {
    /// A builder for [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The unique identifier of the Dataset to be deleted.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Dataset to be deleted.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDatasetInput {
                client_token: self.client_token,
                dataset_id: self.dataset_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDatasetInputOperationOutputAlias = crate::operation::DeleteDataset;
#[doc(hidden)]
pub type DeleteDatasetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataset`](crate::operation::DeleteDataset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDatasetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.dataset_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_3, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/datasetsv2/{datasetId}", datasetId = dataset_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteDatasetInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_4) = &_input.client_token {
                    query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_4));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDatasetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataset",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
}

/// See [`DeletePermissionGroupInput`](crate::input::DeletePermissionGroupInput)
pub mod delete_permission_group_input {
    /// A builder for [`DeletePermissionGroupInput`](crate::input::DeletePermissionGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_group_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the permission group that you want to delete.</p>
        pub fn permission_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the permission group that you want to delete.</p>
        pub fn set_permission_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_group_id = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePermissionGroupInput`](crate::input::DeletePermissionGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePermissionGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePermissionGroupInput {
                permission_group_id: self.permission_group_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePermissionGroupInputOperationOutputAlias = crate::operation::DeletePermissionGroup;
#[doc(hidden)]
pub type DeletePermissionGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePermissionGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeletePermissionGroup`](crate::operation::DeletePermissionGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePermissionGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePermissionGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.permission_group_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "permission_group_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let permission_group_id = aws_smithy_http::label::fmt_string(input_5, false);
                if permission_group_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "permission_group_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/permission-group/{permissionGroupId}",
                    permissionGroupId = permission_group_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeletePermissionGroupInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_6) = &_input.client_token {
                    query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_6));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePermissionGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePermissionGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePermissionGroup",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePermissionGroupInput`](crate::input::DeletePermissionGroupInput)
    pub fn builder() -> crate::input::delete_permission_group_input::Builder {
        crate::input::delete_permission_group_input::Builder::default()
    }
}

/// See [`DisableUserInput`](crate::input::DisableUserInput)
pub mod disable_user_input {
    /// A builder for [`DisableUserInput`](crate::input::DisableUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the user account that you want to disable.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user account that you want to disable.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableUserInput`](crate::input::DisableUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableUserInput {
                user_id: self.user_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableUserInputOperationOutputAlias = crate::operation::DisableUser;
#[doc(hidden)]
pub type DisableUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableUserInput {
    /// Consumes the builder and constructs an Operation<[`DisableUser`](crate::operation::DisableUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisableUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.user_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_7, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/user/{userId}/disable", userId = user_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisableUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disable_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableUser",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisableUserInput`](crate::input::DisableUserInput)
    pub fn builder() -> crate::input::disable_user_input::Builder {
        crate::input::disable_user_input::Builder::default()
    }
}

/// See [`EnableUserInput`](crate::input::EnableUserInput)
pub mod enable_user_input {
    /// A builder for [`EnableUserInput`](crate::input::EnableUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the user account that you want to enable.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user account that you want to enable.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableUserInput`](crate::input::EnableUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableUserInput {
                user_id: self.user_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableUserInputOperationOutputAlias = crate::operation::EnableUser;
#[doc(hidden)]
pub type EnableUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableUserInput {
    /// Consumes the builder and constructs an Operation<[`EnableUser`](crate::operation::EnableUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::EnableUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.user_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_8, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/user/{userId}/enable", userId = user_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EnableUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_enable_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableUser",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EnableUserInput`](crate::input::EnableUserInput)
    pub fn builder() -> crate::input::enable_user_input::Builder {
        crate::input::enable_user_input::Builder::default()
    }
}

/// See [`GetChangesetInput`](crate::input::GetChangesetInput)
pub mod get_changeset_input {
    /// A builder for [`GetChangesetInput`](crate::input::GetChangesetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) changeset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The unique identifier of the Changeset for which to get data.</p>
        pub fn changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Changeset for which to get data.</p>
        pub fn set_changeset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.changeset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangesetInput`](crate::input::GetChangesetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetChangesetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetChangesetInput {
                dataset_id: self.dataset_id,
                changeset_id: self.changeset_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetChangesetInputOperationOutputAlias = crate::operation::GetChangeset;
#[doc(hidden)]
pub type GetChangesetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetChangesetInput {
    /// Consumes the builder and constructs an Operation<[`GetChangeset`](crate::operation::GetChangeset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChangeset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetChangesetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.dataset_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_9, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_10 = &_input.changeset_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "changeset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let changeset_id = aws_smithy_http::label::fmt_string(input_10, false);
                if changeset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "changeset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/datasets/{datasetId}/changesetsv2/{changesetId}",
                    datasetId = dataset_id,
                    changesetId = changeset_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetChangesetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetChangeset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetChangeset",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetChangesetInput`](crate::input::GetChangesetInput)
    pub fn builder() -> crate::input::get_changeset_input::Builder {
        crate::input::get_changeset_input::Builder::default()
    }
}

/// See [`GetDatasetInput`](crate::input::GetDatasetInput)
pub mod get_dataset_input {
    /// A builder for [`GetDatasetInput`](crate::input::GetDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a Dataset.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a Dataset.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDatasetInput`](crate::input::GetDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDatasetInput {
                dataset_id: self.dataset_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDatasetInputOperationOutputAlias = crate::operation::GetDataset;
#[doc(hidden)]
pub type GetDatasetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDatasetInput {
    /// Consumes the builder and constructs an Operation<[`GetDataset`](crate::operation::GetDataset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDatasetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.dataset_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_11, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/datasetsv2/{datasetId}", datasetId = dataset_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDatasetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataset",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDatasetInput`](crate::input::GetDatasetInput)
    pub fn builder() -> crate::input::get_dataset_input::Builder {
        crate::input::get_dataset_input::Builder::default()
    }
}

/// See [`GetDataViewInput`](crate::input::GetDataViewInput)
pub mod get_data_view_input {
    /// A builder for [`GetDataViewInput`](crate::input::GetDataViewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_view_id: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Dataview.</p>
        pub fn data_view_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_view_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Dataview.</p>
        pub fn set_data_view_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_view_id = input;
            self
        }
        /// <p>The unique identifier for the Dataset used in the Dataview.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Dataset used in the Dataview.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataViewInput`](crate::input::GetDataViewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataViewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataViewInput {
                data_view_id: self.data_view_id,
                dataset_id: self.dataset_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataViewInputOperationOutputAlias = crate::operation::GetDataView;
#[doc(hidden)]
pub type GetDataViewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDataViewInput {
    /// Consumes the builder and constructs an Operation<[`GetDataView`](crate::operation::GetDataView)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataView,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDataViewInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.dataset_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_12, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.data_view_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_view_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let data_view_id = aws_smithy_http::label::fmt_string(input_13, false);
                if data_view_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_view_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/datasets/{datasetId}/dataviewsv2/{dataViewId}",
                    datasetId = dataset_id,
                    dataViewId = data_view_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDataViewInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataView::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataView",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDataViewInput`](crate::input::GetDataViewInput)
    pub fn builder() -> crate::input::get_data_view_input::Builder {
        crate::input::get_data_view_input::Builder::default()
    }
}

/// See [`GetProgrammaticAccessCredentialsInput`](crate::input::GetProgrammaticAccessCredentialsInput)
pub mod get_programmatic_access_credentials_input {
    /// A builder for [`GetProgrammaticAccessCredentialsInput`](crate::input::GetProgrammaticAccessCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_minutes: std::option::Option<i64>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time duration in which the credentials remain valid. </p>
        pub fn duration_in_minutes(mut self, input: i64) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>The time duration in which the credentials remain valid. </p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// <p>The FinSpace environment identifier.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The FinSpace environment identifier.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProgrammaticAccessCredentialsInput`](crate::input::GetProgrammaticAccessCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProgrammaticAccessCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProgrammaticAccessCredentialsInput {
                duration_in_minutes: self.duration_in_minutes.unwrap_or_default(),
                environment_id: self.environment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProgrammaticAccessCredentialsInputOperationOutputAlias =
    crate::operation::GetProgrammaticAccessCredentials;
#[doc(hidden)]
pub type GetProgrammaticAccessCredentialsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetProgrammaticAccessCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`GetProgrammaticAccessCredentials`](crate::operation::GetProgrammaticAccessCredentials)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProgrammaticAccessCredentials,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetProgrammaticAccessCredentialsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/credentials/programmatic").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetProgrammaticAccessCredentialsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.duration_in_minutes != 0 {
                    query.push_kv(
                        "durationInMinutes",
                        aws_smithy_types::primitive::Encoder::from(_input.duration_in_minutes)
                            .encode(),
                    );
                }
                if let Some(inner_14) = &_input.environment_id {
                    query.push_kv(
                        "environmentId",
                        &aws_smithy_http::query::fmt_string(&inner_14),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetProgrammaticAccessCredentialsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProgrammaticAccessCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProgrammaticAccessCredentials",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetProgrammaticAccessCredentialsInput`](crate::input::GetProgrammaticAccessCredentialsInput)
    pub fn builder() -> crate::input::get_programmatic_access_credentials_input::Builder {
        crate::input::get_programmatic_access_credentials_input::Builder::default()
    }
}

/// See [`GetUserInput`](crate::input::GetUserInput)
pub mod get_user_input {
    /// A builder for [`GetUserInput`](crate::input::GetUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the user to get data for.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the user to get data for.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserInput`](crate::input::GetUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetUserInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetUserInput {
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserInputOperationOutputAlias = crate::operation::GetUser;
#[doc(hidden)]
pub type GetUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUserInput {
    /// Consumes the builder and constructs an Operation<[`GetUser`](crate::operation::GetUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.user_id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_15, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/user/{userId}", userId = user_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetUser::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetUser",
                    "finspacedata",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetUserInput`](crate::input::GetUserInput)
    pub fn builder() -> crate::input::get_user_input::Builder {
        crate::input::get_user_input::Builder::default()
    }
}

/// See [`GetWorkingLocationInput`](crate::input::GetWorkingLocationInput)
pub mod get_working_location_input {
    /// A builder for [`GetWorkingLocationInput`](crate::input::GetWorkingLocationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_type: std::option::Option<crate::model::LocationType>,
    }
    impl Builder {
        /// <p>Specify the type of the working location.</p>
        /// <ul>
        /// <li> <p> <code>SAGEMAKER</code> – Use the Amazon S3 location as a temporary location to store data content when working with FinSpace Notebooks that run on SageMaker studio.</p> </li>
        /// <li> <p> <code>INGESTION</code> – Use the Amazon S3 location as a staging location to copy your data content and then use the location with the Changeset creation operation.</p> </li>
        /// </ul>
        pub fn location_type(mut self, input: crate::model::LocationType) -> Self {
            self.location_type = Some(input);
            self
        }
        /// <p>Specify the type of the working location.</p>
        /// <ul>
        /// <li> <p> <code>SAGEMAKER</code> – Use the Amazon S3 location as a temporary location to store data content when working with FinSpace Notebooks that run on SageMaker studio.</p> </li>
        /// <li> <p> <code>INGESTION</code> – Use the Amazon S3 location as a staging location to copy your data content and then use the location with the Changeset creation operation.</p> </li>
        /// </ul>
        pub fn set_location_type(
            mut self,
            input: std::option::Option<crate::model::LocationType>,
        ) -> Self {
            self.location_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkingLocationInput`](crate::input::GetWorkingLocationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkingLocationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkingLocationInput {
                location_type: self.location_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkingLocationInputOperationOutputAlias = crate::operation::GetWorkingLocation;
#[doc(hidden)]
pub type GetWorkingLocationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWorkingLocationInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkingLocation`](crate::operation::GetWorkingLocation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkingLocation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetWorkingLocationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/workingLocationV1").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetWorkingLocationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_working_location(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkingLocation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkingLocation",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetWorkingLocationInput`](crate::input::GetWorkingLocationInput)
    pub fn builder() -> crate::input::get_working_location_input::Builder {
        crate::input::get_working_location_input::Builder::default()
    }
}

/// See [`ListChangesetsInput`](crate::input::ListChangesetsInput)
pub mod list_changesets_input {
    /// A builder for [`ListChangesetsInput`](crate::input::ListChangesetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the FinSpace Dataset to which the Changeset belongs.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset to which the Changeset belongs.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChangesetsInput`](crate::input::ListChangesetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChangesetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChangesetsInput {
                dataset_id: self.dataset_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChangesetsInputOperationOutputAlias = crate::operation::ListChangesets;
#[doc(hidden)]
pub type ListChangesetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChangesetsInput {
    /// Consumes the builder and constructs an Operation<[`ListChangesets`](crate::operation::ListChangesets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChangesets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListChangesetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.dataset_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_16, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/datasets/{datasetId}/changesetsv2",
                    datasetId = dataset_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListChangesetsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_17) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_17).encode(),
                    );
                }
                if let Some(inner_18) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_18));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListChangesetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChangesets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChangesets",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListChangesetsInput`](crate::input::ListChangesetsInput)
    pub fn builder() -> crate::input::list_changesets_input::Builder {
        crate::input::list_changesets_input::Builder::default()
    }
}

/// See [`ListDatasetsInput`](crate::input::ListDatasetsInput)
pub mod list_datasets_input {
    /// A builder for [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsInput`](crate::input::ListDatasetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetsInputOperationOutputAlias = crate::operation::ListDatasets;
#[doc(hidden)]
pub type ListDatasetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDatasetsInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasets`](crate::operation::ListDatasets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDatasetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/datasetsv2").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDatasetsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_19) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
                }
                if let Some(inner_20) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_20).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDatasetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasets",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
}

/// See [`ListDataViewsInput`](crate::input::ListDataViewsInput)
pub mod list_data_views_input {
    /// A builder for [`ListDataViewsInput`](crate::input::ListDataViewsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the Dataset for which to retrieve Dataviews.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Dataset for which to retrieve Dataviews.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataViewsInput`](crate::input::ListDataViewsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataViewsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataViewsInput {
                dataset_id: self.dataset_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataViewsInputOperationOutputAlias = crate::operation::ListDataViews;
#[doc(hidden)]
pub type ListDataViewsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataViewsInput {
    /// Consumes the builder and constructs an Operation<[`ListDataViews`](crate::operation::ListDataViews)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataViews,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDataViewsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.dataset_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_21, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/datasets/{datasetId}/dataviewsv2",
                    datasetId = dataset_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDataViewsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_22) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
                }
                if let Some(inner_23) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_23).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDataViewsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataViews::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataViews",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDataViewsInput`](crate::input::ListDataViewsInput)
    pub fn builder() -> crate::input::list_data_views_input::Builder {
        crate::input::list_data_views_input::Builder::default()
    }
}

/// See [`ListPermissionGroupsInput`](crate::input::ListPermissionGroupsInput)
pub mod list_permission_groups_input {
    /// A builder for [`ListPermissionGroupsInput`](crate::input::ListPermissionGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionGroupsInput`](crate::input::ListPermissionGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionGroupsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionGroupsInputOperationOutputAlias = crate::operation::ListPermissionGroups;
#[doc(hidden)]
pub type ListPermissionGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPermissionGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissionGroups`](crate::operation::ListPermissionGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissionGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPermissionGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/permission-group").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListPermissionGroupsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_24) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPermissionGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissionGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissionGroups",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionGroupsInput`](crate::input::ListPermissionGroupsInput)
    pub fn builder() -> crate::input::list_permission_groups_input::Builder {
        crate::input::list_permission_groups_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where a results page should begin.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListUsersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/user").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListUsersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_25) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListUsersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListUsers",
                    "finspacedata",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
pub mod reset_user_password_input {
    /// A builder for [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the user that a temporary password is requested for.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the user that a temporary password is requested for.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetUserPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetUserPasswordInput {
                user_id: self.user_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetUserPasswordInputOperationOutputAlias = crate::operation::ResetUserPassword;
#[doc(hidden)]
pub type ResetUserPasswordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResetUserPasswordInput {
    /// Consumes the builder and constructs an Operation<[`ResetUserPassword`](crate::operation::ResetUserPassword)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetUserPassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::ResetUserPasswordInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.user_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_26, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/user/{userId}/password", userId = user_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ResetUserPasswordInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_reset_user_password(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetUserPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetUserPassword",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
    pub fn builder() -> crate::input::reset_user_password_input::Builder {
        crate::input::reset_user_password_input::Builder::default()
    }
}

/// See [`UpdateChangesetInput`](crate::input::UpdateChangesetInput)
pub mod update_changeset_input {
    /// A builder for [`UpdateChangesetInput`](crate::input::UpdateChangesetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) changeset_id: std::option::Option<std::string::String>,
        pub(crate) source_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) format_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>The unique identifier for the Changeset to update.</p>
        pub fn changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Changeset to update.</p>
        pub fn set_changeset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.changeset_id = input;
            self
        }
        /// Adds a key-value pair to `source_params`.
        ///
        /// To override the contents of this collection use [`set_source_params`](Self::set_source_params).
        ///
        /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
        /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
        /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
        /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
        /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a>section.</p>
        pub fn source_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.source_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.source_params = Some(hash_map);
            self
        }
        /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
        /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
        /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
        /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
        /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a>section.</p>
        pub fn set_source_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.source_params = input;
            self
        }
        /// Adds a key-value pair to `format_params`.
        ///
        /// To override the contents of this collection use [`set_format_params`](Self::set_format_params).
        ///
        /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
        /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
        /// <ul>
        /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
        /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
        /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
        /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
        /// </ul>
        /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
        /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
        /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
        /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
        /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
        pub fn format_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.format_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.format_params = Some(hash_map);
            self
        }
        /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
        /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
        /// <ul>
        /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
        /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
        /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
        /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
        /// </ul>
        /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
        /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
        /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
        /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
        /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
        pub fn set_format_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.format_params = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChangesetInput`](crate::input::UpdateChangesetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChangesetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChangesetInput {
                client_token: self.client_token,
                dataset_id: self.dataset_id,
                changeset_id: self.changeset_id,
                source_params: self.source_params,
                format_params: self.format_params,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChangesetInputOperationOutputAlias = crate::operation::UpdateChangeset;
#[doc(hidden)]
pub type UpdateChangesetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateChangesetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChangeset`](crate::operation::UpdateChangeset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChangeset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateChangesetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.dataset_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_27, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_28 = &_input.changeset_id;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "changeset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let changeset_id = aws_smithy_http::label::fmt_string(input_28, false);
                if changeset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "changeset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/datasets/{datasetId}/changesetsv2/{changesetId}",
                    datasetId = dataset_id,
                    changesetId = changeset_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateChangesetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_changeset(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChangeset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChangeset",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateChangesetInput`](crate::input::UpdateChangesetInput)
    pub fn builder() -> crate::input::update_changeset_input::Builder {
        crate::input::update_changeset_input::Builder::default()
    }
}

/// See [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
pub mod update_dataset_input {
    /// A builder for [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) dataset_title: std::option::Option<std::string::String>,
        pub(crate) kind: std::option::Option<crate::model::DatasetKind>,
        pub(crate) dataset_description: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) schema_definition: std::option::Option<crate::model::SchemaUnion>,
    }
    impl Builder {
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The unique identifier for the Dataset to update.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Dataset to update.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>A display title for the Dataset.</p>
        pub fn dataset_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_title = Some(input.into());
            self
        }
        /// <p>A display title for the Dataset.</p>
        pub fn set_dataset_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_title = input;
            self
        }
        /// <p>The format in which the Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::DatasetKind) -> Self {
            self.kind = Some(input);
            self
        }
        /// <p>The format in which the Dataset data is structured.</p>
        /// <ul>
        /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
        /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::DatasetKind>) -> Self {
            self.kind = input;
            self
        }
        /// <p>A description for the Dataset.</p>
        pub fn dataset_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_description = Some(input.into());
            self
        }
        /// <p>A description for the Dataset.</p>
        pub fn set_dataset_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_description = input;
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The unique resource identifier for a Dataset.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaUnion) -> Self {
            self.schema_definition = Some(input);
            self
        }
        /// <p>Definition for a schema on a tabular Dataset.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaUnion>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDatasetInput {
                client_token: self.client_token,
                dataset_id: self.dataset_id,
                dataset_title: self.dataset_title,
                kind: self.kind,
                dataset_description: self.dataset_description,
                alias: self.alias,
                schema_definition: self.schema_definition,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDatasetInputOperationOutputAlias = crate::operation::UpdateDataset;
#[doc(hidden)]
pub type UpdateDatasetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDatasetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataset`](crate::operation::UpdateDataset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDatasetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.dataset_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_id = aws_smithy_http::label::fmt_string(input_29, false);
                if dataset_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/datasetsv2/{datasetId}", datasetId = dataset_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDatasetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_dataset(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataset",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
    pub fn builder() -> crate::input::update_dataset_input::Builder {
        crate::input::update_dataset_input::Builder::default()
    }
}

/// See [`UpdatePermissionGroupInput`](crate::input::UpdatePermissionGroupInput)
pub mod update_permission_group_input {
    /// A builder for [`UpdatePermissionGroupInput`](crate::input::UpdatePermissionGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) application_permissions:
            std::option::Option<std::vec::Vec<crate::model::ApplicationPermission>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the permission group to update.</p>
        pub fn permission_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the permission group to update.</p>
        pub fn set_permission_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_group_id = input;
            self
        }
        /// <p>The name of the permission group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the permission group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A brief description for the permission group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A brief description for the permission group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `application_permissions`.
        ///
        /// To override the contents of this collection use [`set_application_permissions`](Self::set_application_permissions).
        ///
        /// <p>The permissions that are granted to a specific group for accessing the FinSpace application.</p>
        /// <ul>
        /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
        /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
        /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
        /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
        /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
        /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
        /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
        /// </ul>
        pub fn application_permissions(
            mut self,
            input: crate::model::ApplicationPermission,
        ) -> Self {
            let mut v = self.application_permissions.unwrap_or_default();
            v.push(input);
            self.application_permissions = Some(v);
            self
        }
        /// <p>The permissions that are granted to a specific group for accessing the FinSpace application.</p>
        /// <ul>
        /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
        /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
        /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
        /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
        /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
        /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
        /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
        /// </ul>
        pub fn set_application_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationPermission>>,
        ) -> Self {
            self.application_permissions = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePermissionGroupInput`](crate::input::UpdatePermissionGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePermissionGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePermissionGroupInput {
                permission_group_id: self.permission_group_id,
                name: self.name,
                description: self.description,
                application_permissions: self.application_permissions,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePermissionGroupInputOperationOutputAlias = crate::operation::UpdatePermissionGroup;
#[doc(hidden)]
pub type UpdatePermissionGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePermissionGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePermissionGroup`](crate::operation::UpdatePermissionGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePermissionGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePermissionGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.permission_group_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "permission_group_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let permission_group_id = aws_smithy_http::label::fmt_string(input_30, false);
                if permission_group_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "permission_group_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/permission-group/{permissionGroupId}",
                    permissionGroupId = permission_group_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePermissionGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_permission_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePermissionGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePermissionGroup",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePermissionGroupInput`](crate::input::UpdatePermissionGroupInput)
    pub fn builder() -> crate::input::update_permission_group_input::Builder {
        crate::input::update_permission_group_input::Builder::default()
    }
}

/// See [`UpdateUserInput`](crate::input::UpdateUserInput)
pub mod update_user_input {
    /// A builder for [`UpdateUserInput`](crate::input::UpdateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UserType>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) api_access: std::option::Option<crate::model::ApiAccess>,
        pub(crate) api_access_principal_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the user account to update.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user account to update.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The option to indicate the type of user.</p>
        /// <ul>
        /// <li> <p> <code>SUPER_USER</code>– A user with permission to all the functionality and data in FinSpace.</p> </li>
        /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The option to indicate the type of user.</p>
        /// <ul>
        /// <li> <p> <code>SUPER_USER</code>– A user with permission to all the functionality and data in FinSpace.</p> </li>
        /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The first name of the user.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name of the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name of the user.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name of the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
        /// </ul>
        pub fn api_access(mut self, input: crate::model::ApiAccess) -> Self {
            self.api_access = Some(input);
            self
        }
        /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
        /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
        /// </ul>
        pub fn set_api_access(
            mut self,
            input: std::option::Option<crate::model::ApiAccess>,
        ) -> Self {
            self.api_access = input;
            self
        }
        /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
        pub fn api_access_principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_access_principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
        pub fn set_api_access_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_access_principal_arn = input;
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserInput`](crate::input::UpdateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserInput {
                user_id: self.user_id,
                r#type: self.r#type,
                first_name: self.first_name,
                last_name: self.last_name,
                api_access: self.api_access,
                api_access_principal_arn: self.api_access_principal_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserInputOperationOutputAlias = crate::operation::UpdateUser;
#[doc(hidden)]
pub type UpdateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUser`](crate::operation::UpdateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.user_id;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_31, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/user/{userId}", userId = user_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUser",
            "finspacedata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserInput {
    /// <p>The unique identifier for the user account to update.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The option to indicate the type of user.</p>
    /// <ul>
    /// <li> <p> <code>SUPER_USER</code>– A user with permission to all the functionality and data in FinSpace.</p> </li>
    /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::UserType>,
    /// <p>The first name of the user.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name of the user.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
    /// </ul>
    pub api_access: std::option::Option<crate::model::ApiAccess>,
    /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
    pub api_access_principal_arn: std::option::Option<std::string::String>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateUserInput {
    /// <p>The unique identifier for the user account to update.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The option to indicate the type of user.</p>
    /// <ul>
    /// <li> <p> <code>SUPER_USER</code>– A user with permission to all the functionality and data in FinSpace.</p> </li>
    /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UserType> {
        self.r#type.as_ref()
    }
    /// <p>The first name of the user.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>The last name of the user.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
    /// </ul>
    pub fn api_access(&self) -> std::option::Option<&crate::model::ApiAccess> {
        self.api_access.as_ref()
    }
    /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
    pub fn api_access_principal_arn(&self) -> std::option::Option<&str> {
        self.api_access_principal_arn.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("first_name", &"*** Sensitive Data Redacted ***");
        formatter.field("last_name", &"*** Sensitive Data Redacted ***");
        formatter.field("api_access", &self.api_access);
        formatter.field("api_access_principal_arn", &self.api_access_principal_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePermissionGroupInput {
    /// <p>The unique identifier for the permission group to update.</p>
    pub permission_group_id: std::option::Option<std::string::String>,
    /// <p>The name of the permission group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A brief description for the permission group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The permissions that are granted to a specific group for accessing the FinSpace application.</p>
    /// <ul>
    /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
    /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
    /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
    /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
    /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
    /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
    /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
    /// </ul>
    pub application_permissions:
        std::option::Option<std::vec::Vec<crate::model::ApplicationPermission>>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdatePermissionGroupInput {
    /// <p>The unique identifier for the permission group to update.</p>
    pub fn permission_group_id(&self) -> std::option::Option<&str> {
        self.permission_group_id.as_deref()
    }
    /// <p>The name of the permission group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A brief description for the permission group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The permissions that are granted to a specific group for accessing the FinSpace application.</p>
    /// <ul>
    /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
    /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
    /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
    /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
    /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
    /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
    /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
    /// </ul>
    pub fn application_permissions(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationPermission]> {
        self.application_permissions.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdatePermissionGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePermissionGroupInput");
        formatter.field("permission_group_id", &self.permission_group_id);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("application_permissions", &self.application_permissions);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// The request for an UpdateDataset operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatasetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the Dataset to update.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>A display title for the Dataset.</p>
    pub dataset_title: std::option::Option<std::string::String>,
    /// <p>The format in which the Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub kind: std::option::Option<crate::model::DatasetKind>,
    /// <p>A description for the Dataset.</p>
    pub dataset_description: std::option::Option<std::string::String>,
    /// <p>The unique resource identifier for a Dataset.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub schema_definition: std::option::Option<crate::model::SchemaUnion>,
}
impl UpdateDatasetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The unique identifier for the Dataset to update.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>A display title for the Dataset.</p>
    pub fn dataset_title(&self) -> std::option::Option<&str> {
        self.dataset_title.as_deref()
    }
    /// <p>The format in which the Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub fn kind(&self) -> std::option::Option<&crate::model::DatasetKind> {
        self.kind.as_ref()
    }
    /// <p>A description for the Dataset.</p>
    pub fn dataset_description(&self) -> std::option::Option<&str> {
        self.dataset_description.as_deref()
    }
    /// <p>The unique resource identifier for a Dataset.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub fn schema_definition(&self) -> std::option::Option<&crate::model::SchemaUnion> {
        self.schema_definition.as_ref()
    }
}
impl std::fmt::Debug for UpdateDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatasetInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("dataset_title", &self.dataset_title);
        formatter.field("kind", &self.kind);
        formatter.field("dataset_description", &self.dataset_description);
        formatter.field("alias", &self.alias);
        formatter.field("schema_definition", &self.schema_definition);
        formatter.finish()
    }
}

/// Request to update an existing changeset.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChangesetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the Changeset to update.</p>
    pub changeset_id: std::option::Option<std::string::String>,
    /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
    /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
    /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
    /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
    /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a>section.</p>
    pub source_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
    /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
    /// <ul>
    /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
    /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
    /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
    /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
    /// </ul>
    /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
    /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
    /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
    /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
    /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
    pub format_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateChangesetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The unique identifier for the Changeset to update.</p>
    pub fn changeset_id(&self) -> std::option::Option<&str> {
        self.changeset_id.as_deref()
    }
    /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
    /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
    /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
    /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
    /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a>section.</p>
    pub fn source_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.source_params.as_ref()
    }
    /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
    /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
    /// <ul>
    /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
    /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
    /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
    /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
    /// </ul>
    /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
    /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
    /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
    /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
    /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
    pub fn format_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.format_params.as_ref()
    }
}
impl std::fmt::Debug for UpdateChangesetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChangesetInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("changeset_id", &self.changeset_id);
        formatter.field("source_params", &self.source_params);
        formatter.field("format_params", &self.format_params);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetUserPasswordInput {
    /// <p>The unique identifier of the user that a temporary password is requested for.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl ResetUserPasswordInput {
    /// <p>The unique identifier of the user that a temporary password is requested for.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for ResetUserPasswordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetUserPasswordInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersInput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results per page.</p>
    pub max_results: i32,
}
impl ListUsersInput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results per page.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionGroupsInput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results per page.</p>
    pub max_results: i32,
}
impl ListPermissionGroupsInput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results per page.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListPermissionGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// Request for a list data views.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataViewsInput {
    /// <p>The unique identifier of the Dataset for which to retrieve Dataviews.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDataViewsInput {
    /// <p>The unique identifier of the Dataset for which to retrieve Dataviews.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDataViewsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataViewsInput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// Request for the ListDatasets operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsInput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDatasetsInput {
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDatasetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// Request to ListChangesetsRequest. It exposes minimal query filters.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChangesetsInput {
    /// <p>The unique identifier for the FinSpace Dataset to which the Changeset belongs.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token that indicates where a results page should begin.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChangesetsInput {
    /// <p>The unique identifier for the FinSpace Dataset to which the Changeset belongs.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The maximum number of results per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token that indicates where a results page should begin.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChangesetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChangesetsInput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkingLocationInput {
    /// <p>Specify the type of the working location.</p>
    /// <ul>
    /// <li> <p> <code>SAGEMAKER</code> – Use the Amazon S3 location as a temporary location to store data content when working with FinSpace Notebooks that run on SageMaker studio.</p> </li>
    /// <li> <p> <code>INGESTION</code> – Use the Amazon S3 location as a staging location to copy your data content and then use the location with the Changeset creation operation.</p> </li>
    /// </ul>
    pub location_type: std::option::Option<crate::model::LocationType>,
}
impl GetWorkingLocationInput {
    /// <p>Specify the type of the working location.</p>
    /// <ul>
    /// <li> <p> <code>SAGEMAKER</code> – Use the Amazon S3 location as a temporary location to store data content when working with FinSpace Notebooks that run on SageMaker studio.</p> </li>
    /// <li> <p> <code>INGESTION</code> – Use the Amazon S3 location as a staging location to copy your data content and then use the location with the Changeset creation operation.</p> </li>
    /// </ul>
    pub fn location_type(&self) -> std::option::Option<&crate::model::LocationType> {
        self.location_type.as_ref()
    }
}
impl std::fmt::Debug for GetWorkingLocationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkingLocationInput");
        formatter.field("location_type", &self.location_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserInput {
    /// <p>The unique identifier of the user to get data for.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl GetUserInput {
    /// <p>The unique identifier of the user to get data for.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for GetUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

/// Request for GetProgrammaticAccessCredentials operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProgrammaticAccessCredentialsInput {
    /// <p>The time duration in which the credentials remain valid. </p>
    pub duration_in_minutes: i64,
    /// <p>The FinSpace environment identifier.</p>
    pub environment_id: std::option::Option<std::string::String>,
}
impl GetProgrammaticAccessCredentialsInput {
    /// <p>The time duration in which the credentials remain valid. </p>
    pub fn duration_in_minutes(&self) -> i64 {
        self.duration_in_minutes
    }
    /// <p>The FinSpace environment identifier.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
}
impl std::fmt::Debug for GetProgrammaticAccessCredentialsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProgrammaticAccessCredentialsInput");
        formatter.field("duration_in_minutes", &self.duration_in_minutes);
        formatter.field("environment_id", &self.environment_id);
        formatter.finish()
    }
}

/// Request for retrieving a data view detail. Grouped / accessible within a dataset by its dataset id.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataViewInput {
    /// <p>The unique identifier for the Dataview.</p>
    pub data_view_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the Dataset used in the Dataview.</p>
    pub dataset_id: std::option::Option<std::string::String>,
}
impl GetDataViewInput {
    /// <p>The unique identifier for the Dataview.</p>
    pub fn data_view_id(&self) -> std::option::Option<&str> {
        self.data_view_id.as_deref()
    }
    /// <p>The unique identifier for the Dataset used in the Dataview.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
}
impl std::fmt::Debug for GetDataViewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataViewInput");
        formatter.field("data_view_id", &self.data_view_id);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.finish()
    }
}

/// Request for the GetDataset operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDatasetInput {
    /// <p>The unique identifier for a Dataset.</p>
    pub dataset_id: std::option::Option<std::string::String>,
}
impl GetDatasetInput {
    /// <p>The unique identifier for a Dataset.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
}
impl std::fmt::Debug for GetDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDatasetInput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.finish()
    }
}

/// Request to describe a changeset.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangesetInput {
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the Changeset for which to get data.</p>
    pub changeset_id: std::option::Option<std::string::String>,
}
impl GetChangesetInput {
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The unique identifier of the Changeset for which to get data.</p>
    pub fn changeset_id(&self) -> std::option::Option<&str> {
        self.changeset_id.as_deref()
    }
}
impl std::fmt::Debug for GetChangesetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangesetInput");
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("changeset_id", &self.changeset_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableUserInput {
    /// <p>The unique identifier for the user account that you want to enable.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl EnableUserInput {
    /// <p>The unique identifier for the user account that you want to enable.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for EnableUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableUserInput {
    /// <p>The unique identifier for the user account that you want to disable.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisableUserInput {
    /// <p>The unique identifier for the user account that you want to disable.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisableUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePermissionGroupInput {
    /// <p>The unique identifier for the permission group that you want to delete.</p>
    pub permission_group_id: std::option::Option<std::string::String>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeletePermissionGroupInput {
    /// <p>The unique identifier for the permission group that you want to delete.</p>
    pub fn permission_group_id(&self) -> std::option::Option<&str> {
        self.permission_group_id.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeletePermissionGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePermissionGroupInput");
        formatter.field("permission_group_id", &self.permission_group_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// The request for a DeleteDataset operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the Dataset to be deleted.</p>
    pub dataset_id: std::option::Option<std::string::String>,
}
impl DeleteDatasetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The unique identifier of the Dataset to be deleted.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The email address of the user that you want to register. The email address serves as a uniquer identifier for each user and cannot be changed after it's created.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The option to indicate the type of user. Use one of the following options to specify this parameter:</p>
    /// <ul>
    /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
    /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permission group.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::UserType>,
    /// <p>The first name of the user that you want to register.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name of the user that you want to register.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
    /// </ul>
    pub api_access: std::option::Option<crate::model::ApiAccess>,
    /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
    pub api_access_principal_arn: std::option::Option<std::string::String>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateUserInput {
    /// <p>The email address of the user that you want to register. The email address serves as a uniquer identifier for each user and cannot be changed after it's created.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The option to indicate the type of user. Use one of the following options to specify this parameter:</p>
    /// <ul>
    /// <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li>
    /// <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permission group.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UserType> {
        self.r#type.as_ref()
    }
    /// <p>The first name of the user that you want to register.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>The last name of the user that you want to register.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li>
    /// <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li>
    /// </ul>
    pub fn api_access(&self) -> std::option::Option<&crate::model::ApiAccess> {
        self.api_access.as_ref()
    }
    /// <p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>
    pub fn api_access_principal_arn(&self) -> std::option::Option<&str> {
        self.api_access_principal_arn.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("first_name", &"*** Sensitive Data Redacted ***");
        formatter.field("last_name", &"*** Sensitive Data Redacted ***");
        formatter.field("api_access", &self.api_access);
        formatter.field("api_access_principal_arn", &self.api_access_principal_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePermissionGroupInput {
    /// <p>The name of the permission group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A brief description for the permission group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The option to indicate FinSpace application permissions that are granted to a specific group.</p>
    /// <ul>
    /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
    /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
    /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
    /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
    /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
    /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
    /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
    /// </ul>
    pub application_permissions:
        std::option::Option<std::vec::Vec<crate::model::ApplicationPermission>>,
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreatePermissionGroupInput {
    /// <p>The name of the permission group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A brief description for the permission group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The option to indicate FinSpace application permissions that are granted to a specific group.</p>
    /// <ul>
    /// <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li>
    /// <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li>
    /// <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li>
    /// <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li>
    /// <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li>
    /// <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li>
    /// <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li>
    /// </ul>
    pub fn application_permissions(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationPermission]> {
        self.application_permissions.as_deref()
    }
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreatePermissionGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePermissionGroupInput");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("application_permissions", &self.application_permissions);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// Request for creating a data view.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataViewInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The unique Dataset identifier that is used to create a Dataview.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>Flag to indicate Dataview should be updated automatically.</p>
    pub auto_update: bool,
    /// <p>Columns to be used for sorting the data.</p>
    pub sort_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Ordered set of column names used to partition data.</p>
    pub partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub as_of_timestamp: std::option::Option<i64>,
    /// <p>Options that define the destination type for the Dataview.</p>
    pub destination_type_params: std::option::Option<crate::model::DataViewDestinationTypeParams>,
}
impl CreateDataViewInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The unique Dataset identifier that is used to create a Dataview.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>Flag to indicate Dataview should be updated automatically.</p>
    pub fn auto_update(&self) -> bool {
        self.auto_update
    }
    /// <p>Columns to be used for sorting the data.</p>
    pub fn sort_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.sort_columns.as_deref()
    }
    /// <p>Ordered set of column names used to partition data.</p>
    pub fn partition_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_columns.as_deref()
    }
    /// <p>Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>
    pub fn as_of_timestamp(&self) -> std::option::Option<i64> {
        self.as_of_timestamp
    }
    /// <p>Options that define the destination type for the Dataview.</p>
    pub fn destination_type_params(
        &self,
    ) -> std::option::Option<&crate::model::DataViewDestinationTypeParams> {
        self.destination_type_params.as_ref()
    }
}
impl std::fmt::Debug for CreateDataViewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataViewInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("auto_update", &self.auto_update);
        formatter.field("sort_columns", &self.sort_columns);
        formatter.field("partition_columns", &self.partition_columns);
        formatter.field("as_of_timestamp", &self.as_of_timestamp);
        formatter.field("destination_type_params", &self.destination_type_params);
        formatter.finish()
    }
}

/// The request for a CreateDataset operation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Display title for a FinSpace Dataset.</p>
    pub dataset_title: std::option::Option<std::string::String>,
    /// <p>The format in which Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub kind: std::option::Option<crate::model::DatasetKind>,
    /// <p>Description of a Dataset.</p>
    pub dataset_description: std::option::Option<std::string::String>,
    /// <p>Contact information for a Dataset owner.</p>
    pub owner_info: std::option::Option<crate::model::DatasetOwnerInfo>,
    /// <p>Permission group parameters for Dataset permissions.</p>
    pub permission_group_params: std::option::Option<crate::model::PermissionGroupParams>,
    /// <p>The unique resource identifier for a Dataset.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub schema_definition: std::option::Option<crate::model::SchemaUnion>,
}
impl CreateDatasetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Display title for a FinSpace Dataset.</p>
    pub fn dataset_title(&self) -> std::option::Option<&str> {
        self.dataset_title.as_deref()
    }
    /// <p>The format in which Dataset data is structured.</p>
    /// <ul>
    /// <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li>
    /// <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li>
    /// </ul>
    pub fn kind(&self) -> std::option::Option<&crate::model::DatasetKind> {
        self.kind.as_ref()
    }
    /// <p>Description of a Dataset.</p>
    pub fn dataset_description(&self) -> std::option::Option<&str> {
        self.dataset_description.as_deref()
    }
    /// <p>Contact information for a Dataset owner.</p>
    pub fn owner_info(&self) -> std::option::Option<&crate::model::DatasetOwnerInfo> {
        self.owner_info.as_ref()
    }
    /// <p>Permission group parameters for Dataset permissions.</p>
    pub fn permission_group_params(
        &self,
    ) -> std::option::Option<&crate::model::PermissionGroupParams> {
        self.permission_group_params.as_ref()
    }
    /// <p>The unique resource identifier for a Dataset.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>Definition for a schema on a tabular Dataset.</p>
    pub fn schema_definition(&self) -> std::option::Option<&crate::model::SchemaUnion> {
        self.schema_definition.as_ref()
    }
}
impl std::fmt::Debug for CreateDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("dataset_title", &self.dataset_title);
        formatter.field("kind", &self.kind);
        formatter.field("dataset_description", &self.dataset_description);
        formatter.field("owner_info", &self.owner_info);
        formatter.field("permission_group_params", &self.permission_group_params);
        formatter.field("alias", &self.alias);
        formatter.field("schema_definition", &self.schema_definition);
        formatter.finish()
    }
}

/// The request for a CreateChangeset operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChangesetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset will be created. </p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>The option to indicate how a Changeset will be applied to a Dataset.</p>
    /// <ul>
    /// <li> <p> <code>REPLACE</code> – Changeset will be considered as a replacement to all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>APPEND</code> – Changeset will be considered as an addition to the end of all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
    /// </ul>
    pub change_type: std::option::Option<crate::model::ChangeType>,
    /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
    /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
    /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
    /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
    /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a> section.</p>
    pub source_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
    /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
    /// <ul>
    /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
    /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
    /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
    /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
    /// </ul>
    /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
    /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
    /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
    /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
    /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
    pub format_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateChangesetInput {
    /// <p>A token that ensures idempotency. This token expires in 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The unique identifier for the FinSpace Dataset where the Changeset will be created. </p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>The option to indicate how a Changeset will be applied to a Dataset.</p>
    /// <ul>
    /// <li> <p> <code>REPLACE</code> – Changeset will be considered as a replacement to all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>APPEND</code> – Changeset will be considered as an addition to the end of all prior loaded Changesets.</p> </li>
    /// <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li>
    /// </ul>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.change_type.as_ref()
    }
    /// <p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p>
    /// <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p>
    /// <p>Here is an example of how you could specify the <code>sourceParams</code>:</p>
    /// <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p>
    /// <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a> section.</p>
    pub fn source_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.source_params.as_ref()
    }
    /// <p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p>
    /// <p> <code>formatType</code> is a required attribute and can have the following values: </p>
    /// <ul>
    /// <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li>
    /// <li> <p> <code>CSV</code> – CSV source file format.</p> </li>
    /// <li> <p> <code>JSON</code> – JSON source file format.</p> </li>
    /// <li> <p> <code>XML</code> – XML source file format.</p> </li>
    /// </ul>
    /// <p>Here is an example of how you could specify the <code>formatParams</code>:</p>
    /// <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p>
    /// <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p>
    /// <p> <code> { "withHeader": "true", "separator": "," } </code> </p>
    /// <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>
    pub fn format_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.format_params.as_ref()
    }
}
impl std::fmt::Debug for CreateChangesetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChangesetInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("change_type", &self.change_type);
        formatter.field("source_params", &self.source_params);
        formatter.field("format_params", &self.format_params);
        formatter.finish()
    }
}
