// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocationType {
    #[allow(missing_docs)] // documentation missing in model
    Ingestion,
    #[allow(missing_docs)] // documentation missing in model
    Sagemaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocationType {
    fn from(s: &str) -> Self {
        match s {
            "INGESTION" => LocationType::Ingestion,
            "SAGEMAKER" => LocationType::Sagemaker,
            other => LocationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocationType::from(s))
    }
}
impl LocationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocationType::Ingestion => "INGESTION",
            LocationType::Sagemaker => "SAGEMAKER",
            LocationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INGESTION", "SAGEMAKER"]
    }
}
impl AsRef<str> for LocationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Set short term API credentials.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Credentials {
    /// <p>The access key identifier.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The access key.</p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p>The session token.</p>
    pub session_token: std::option::Option<std::string::String>,
}
impl Credentials {
    /// <p>The access key identifier.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The access key.</p>
    pub fn secret_access_key(&self) -> std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p>The session token.</p>
    pub fn session_token(&self) -> std::option::Option<&str> {
        self.session_token.as_deref()
    }
}
impl std::fmt::Debug for Credentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Credentials");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("secret_access_key", &self.secret_access_key);
        formatter.field("session_token", &self.session_token);
        formatter.finish()
    }
}
/// See [`Credentials`](crate::model::Credentials)
pub mod credentials {
    /// A builder for [`Credentials`](crate::model::Credentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) session_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access key identifier.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The access key identifier.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The access key.</p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p>The access key.</p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p>The session token.</p>
        pub fn session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_token = Some(input.into());
            self
        }
        /// <p>The session token.</p>
        pub fn set_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_token = input;
            self
        }
        /// Consumes the builder and constructs a [`Credentials`](crate::model::Credentials)
        pub fn build(self) -> crate::model::Credentials {
            crate::model::Credentials {
                access_key_id: self.access_key_id,
                secret_access_key: self.secret_access_key,
                session_token: self.session_token,
            }
        }
    }
}
impl Credentials {
    /// Creates a new builder-style object to manufacture [`Credentials`](crate::model::Credentials)
    pub fn builder() -> crate::model::credentials::Builder {
        crate::model::credentials::Builder::default()
    }
}

/// <p>A changeset is unit of data in a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangesetInfo {
    /// <p>Unique identifier for a changeset.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN identifier of the changeset.</p>
    pub changeset_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the FinSpace dataset in which the changeset is created.</p>
    pub dataset_id: std::option::Option<std::string::String>,
    /// <p>Change type indicates how a changeset is applied to a dataset.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded
    /// changesets.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>APPEND</code> - Changeset is considered as an addition to the end of all prior
    /// loaded changesets.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior
    /// ingested changeset.</p>
    /// </li>
    /// </ul>
    pub change_type: std::option::Option<crate::model::ChangeType>,
    /// <p>Type of the data source from which the files to create the changeset are sourced.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>S3</code> - Amazon S3.</p>
    /// </li>
    /// </ul>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>Source path from which the files to create the changeset are sourced.</p>
    pub source_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Format type of the input files loaded into the changeset.</p>
    pub format_type: std::option::Option<crate::model::FormatType>,
    /// <p>Structure of the source file(s).</p>
    pub format_params:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp at which the changeset was created in FinSpace.</p>
    pub create_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of changeset creation operation.</p>
    pub status: std::option::Option<crate::model::ChangesetStatus>,
    /// <p>The structure with error messages.</p>
    pub error_info: std::option::Option<crate::model::ErrorInfo>,
    /// <p>Tags associated with the changeset.</p>
    pub changeset_labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Unique identifier of the changeset that is updated.</p>
    pub updates_changeset_id: std::option::Option<std::string::String>,
    /// <p>Unique identifier of the changeset that is updated a changeset.</p>
    pub updated_by_changeset_id: std::option::Option<std::string::String>,
}
impl ChangesetInfo {
    /// <p>Unique identifier for a changeset.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN identifier of the changeset.</p>
    pub fn changeset_arn(&self) -> std::option::Option<&str> {
        self.changeset_arn.as_deref()
    }
    /// <p>The unique identifier for the FinSpace dataset in which the changeset is created.</p>
    pub fn dataset_id(&self) -> std::option::Option<&str> {
        self.dataset_id.as_deref()
    }
    /// <p>Change type indicates how a changeset is applied to a dataset.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded
    /// changesets.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>APPEND</code> - Changeset is considered as an addition to the end of all prior
    /// loaded changesets.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior
    /// ingested changeset.</p>
    /// </li>
    /// </ul>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.change_type.as_ref()
    }
    /// <p>Type of the data source from which the files to create the changeset are sourced.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>S3</code> - Amazon S3.</p>
    /// </li>
    /// </ul>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>Source path from which the files to create the changeset are sourced.</p>
    pub fn source_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.source_params.as_ref()
    }
    /// <p>Format type of the input files loaded into the changeset.</p>
    pub fn format_type(&self) -> std::option::Option<&crate::model::FormatType> {
        self.format_type.as_ref()
    }
    /// <p>Structure of the source file(s).</p>
    pub fn format_params(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.format_params.as_ref()
    }
    /// <p>The timestamp at which the changeset was created in FinSpace.</p>
    pub fn create_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_timestamp.as_ref()
    }
    /// <p>The status of changeset creation operation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChangesetStatus> {
        self.status.as_ref()
    }
    /// <p>The structure with error messages.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::ErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p>Tags associated with the changeset.</p>
    pub fn changeset_labels(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.changeset_labels.as_ref()
    }
    /// <p>Unique identifier of the changeset that is updated.</p>
    pub fn updates_changeset_id(&self) -> std::option::Option<&str> {
        self.updates_changeset_id.as_deref()
    }
    /// <p>Unique identifier of the changeset that is updated a changeset.</p>
    pub fn updated_by_changeset_id(&self) -> std::option::Option<&str> {
        self.updated_by_changeset_id.as_deref()
    }
}
impl std::fmt::Debug for ChangesetInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangesetInfo");
        formatter.field("id", &self.id);
        formatter.field("changeset_arn", &self.changeset_arn);
        formatter.field("dataset_id", &self.dataset_id);
        formatter.field("change_type", &self.change_type);
        formatter.field("source_type", &self.source_type);
        formatter.field("source_params", &self.source_params);
        formatter.field("format_type", &self.format_type);
        formatter.field("format_params", &self.format_params);
        formatter.field("create_timestamp", &self.create_timestamp);
        formatter.field("status", &self.status);
        formatter.field("error_info", &self.error_info);
        formatter.field("changeset_labels", &self.changeset_labels);
        formatter.field("updates_changeset_id", &self.updates_changeset_id);
        formatter.field("updated_by_changeset_id", &self.updated_by_changeset_id);
        formatter.finish()
    }
}
/// See [`ChangesetInfo`](crate::model::ChangesetInfo)
pub mod changeset_info {
    /// A builder for [`ChangesetInfo`](crate::model::ChangesetInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) changeset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_id: std::option::Option<std::string::String>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeType>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) source_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) format_type: std::option::Option<crate::model::FormatType>,
        pub(crate) format_params: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ChangesetStatus>,
        pub(crate) error_info: std::option::Option<crate::model::ErrorInfo>,
        pub(crate) changeset_labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updates_changeset_id: std::option::Option<std::string::String>,
        pub(crate) updated_by_changeset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique identifier for a changeset.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Unique identifier for a changeset.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN identifier of the changeset.</p>
        pub fn changeset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.changeset_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier of the changeset.</p>
        pub fn set_changeset_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.changeset_arn = input;
            self
        }
        /// <p>The unique identifier for the FinSpace dataset in which the changeset is created.</p>
        pub fn dataset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the FinSpace dataset in which the changeset is created.</p>
        pub fn set_dataset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_id = input;
            self
        }
        /// <p>Change type indicates how a changeset is applied to a dataset.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded
        /// changesets.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APPEND</code> - Changeset is considered as an addition to the end of all prior
        /// loaded changesets.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior
        /// ingested changeset.</p>
        /// </li>
        /// </ul>
        pub fn change_type(mut self, input: crate::model::ChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>Change type indicates how a changeset is applied to a dataset.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded
        /// changesets.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APPEND</code> - Changeset is considered as an addition to the end of all prior
        /// loaded changesets.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior
        /// ingested changeset.</p>
        /// </li>
        /// </ul>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// <p>Type of the data source from which the files to create the changeset are sourced.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code> - Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Type of the data source from which the files to create the changeset are sourced.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code> - Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// Adds a key-value pair to `source_params`.
        ///
        /// To override the contents of this collection use [`set_source_params`](Self::set_source_params).
        ///
        /// <p>Source path from which the files to create the changeset are sourced.</p>
        pub fn source_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.source_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.source_params = Some(hash_map);
            self
        }
        /// <p>Source path from which the files to create the changeset are sourced.</p>
        pub fn set_source_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.source_params = input;
            self
        }
        /// <p>Format type of the input files loaded into the changeset.</p>
        pub fn format_type(mut self, input: crate::model::FormatType) -> Self {
            self.format_type = Some(input);
            self
        }
        /// <p>Format type of the input files loaded into the changeset.</p>
        pub fn set_format_type(
            mut self,
            input: std::option::Option<crate::model::FormatType>,
        ) -> Self {
            self.format_type = input;
            self
        }
        /// Adds a key-value pair to `format_params`.
        ///
        /// To override the contents of this collection use [`set_format_params`](Self::set_format_params).
        ///
        /// <p>Structure of the source file(s).</p>
        pub fn format_params(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.format_params.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.format_params = Some(hash_map);
            self
        }
        /// <p>Structure of the source file(s).</p>
        pub fn set_format_params(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.format_params = input;
            self
        }
        /// <p>The timestamp at which the changeset was created in FinSpace.</p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_timestamp = Some(input);
            self
        }
        /// <p>The timestamp at which the changeset was created in FinSpace.</p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_timestamp = input;
            self
        }
        /// <p>The status of changeset creation operation.</p>
        pub fn status(mut self, input: crate::model::ChangesetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of changeset creation operation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChangesetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn error_info(mut self, input: crate::model::ErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>The structure with error messages.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::ErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// Adds a key-value pair to `changeset_labels`.
        ///
        /// To override the contents of this collection use [`set_changeset_labels`](Self::set_changeset_labels).
        ///
        /// <p>Tags associated with the changeset.</p>
        pub fn changeset_labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.changeset_labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.changeset_labels = Some(hash_map);
            self
        }
        /// <p>Tags associated with the changeset.</p>
        pub fn set_changeset_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.changeset_labels = input;
            self
        }
        /// <p>Unique identifier of the changeset that is updated.</p>
        pub fn updates_changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.updates_changeset_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the changeset that is updated.</p>
        pub fn set_updates_changeset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.updates_changeset_id = input;
            self
        }
        /// <p>Unique identifier of the changeset that is updated a changeset.</p>
        pub fn updated_by_changeset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by_changeset_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the changeset that is updated a changeset.</p>
        pub fn set_updated_by_changeset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.updated_by_changeset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangesetInfo`](crate::model::ChangesetInfo)
        pub fn build(self) -> crate::model::ChangesetInfo {
            crate::model::ChangesetInfo {
                id: self.id,
                changeset_arn: self.changeset_arn,
                dataset_id: self.dataset_id,
                change_type: self.change_type,
                source_type: self.source_type,
                source_params: self.source_params,
                format_type: self.format_type,
                format_params: self.format_params,
                create_timestamp: self.create_timestamp,
                status: self.status,
                error_info: self.error_info,
                changeset_labels: self.changeset_labels,
                updates_changeset_id: self.updates_changeset_id,
                updated_by_changeset_id: self.updated_by_changeset_id,
            }
        }
    }
}
impl ChangesetInfo {
    /// Creates a new builder-style object to manufacture [`ChangesetInfo`](crate::model::ChangesetInfo)
    pub fn builder() -> crate::model::changeset_info::Builder {
        crate::model::changeset_info::Builder::default()
    }
}

/// <p>Error message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorInfo {
    /// <p>The text of the error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The category of the error.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>VALIDATION</code> -The inputs to this request are invalid.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please
    /// contact AWS support to increase quotas.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCESS_DENIED</code> - Missing required permission to perform this
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not
    /// found.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process
    /// the request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has
    /// occurred.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELLED</code> - A user recoverable error has occurred.</p>
    /// </li>
    /// </ul>
    pub error_category: std::option::Option<crate::model::ErrorCategory>,
}
impl ErrorInfo {
    /// <p>The text of the error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The category of the error.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>VALIDATION</code> -The inputs to this request are invalid.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please
    /// contact AWS support to increase quotas.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCESS_DENIED</code> - Missing required permission to perform this
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not
    /// found.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process
    /// the request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has
    /// occurred.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELLED</code> - A user recoverable error has occurred.</p>
    /// </li>
    /// </ul>
    pub fn error_category(&self) -> std::option::Option<&crate::model::ErrorCategory> {
        self.error_category.as_ref()
    }
}
impl std::fmt::Debug for ErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorInfo");
        formatter.field("error_message", &self.error_message);
        formatter.field("error_category", &self.error_category);
        formatter.finish()
    }
}
/// See [`ErrorInfo`](crate::model::ErrorInfo)
pub mod error_info {
    /// A builder for [`ErrorInfo`](crate::model::ErrorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_category: std::option::Option<crate::model::ErrorCategory>,
    }
    impl Builder {
        /// <p>The text of the error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The category of the error.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>VALIDATION</code> -The inputs to this request are invalid.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please
        /// contact AWS support to increase quotas.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code> - Missing required permission to perform this
        /// request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not
        /// found.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process
        /// the request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has
        /// occurred.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELLED</code> - A user recoverable error has occurred.</p>
        /// </li>
        /// </ul>
        pub fn error_category(mut self, input: crate::model::ErrorCategory) -> Self {
            self.error_category = Some(input);
            self
        }
        /// <p>The category of the error.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>VALIDATION</code> -The inputs to this request are invalid.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please
        /// contact AWS support to increase quotas.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code> - Missing required permission to perform this
        /// request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not
        /// found.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process
        /// the request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has
        /// occurred.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELLED</code> - A user recoverable error has occurred.</p>
        /// </li>
        /// </ul>
        pub fn set_error_category(
            mut self,
            input: std::option::Option<crate::model::ErrorCategory>,
        ) -> Self {
            self.error_category = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorInfo`](crate::model::ErrorInfo)
        pub fn build(self) -> crate::model::ErrorInfo {
            crate::model::ErrorInfo {
                error_message: self.error_message,
                error_category: self.error_category,
            }
        }
    }
}
impl ErrorInfo {
    /// Creates a new builder-style object to manufacture [`ErrorInfo`](crate::model::ErrorInfo)
    pub fn builder() -> crate::model::error_info::Builder {
        crate::model::error_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCategory {
    #[allow(missing_docs)] // documentation missing in model
    UserRecoverable,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceException,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceeded,
    #[allow(missing_docs)] // documentation missing in model
    Validation,
    #[allow(missing_docs)] // documentation missing in model
    Throttling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCategory {
    fn from(s: &str) -> Self {
        match s {
            "A_user_recoverable_error_has_occurred" => ErrorCategory::UserRecoverable,
            "An_internal_error_has_occurred" => ErrorCategory::InternalServiceException,
            "Cancelled" => ErrorCategory::Cancelled,
            "Missing_required_permission_to_perform_this_request" => ErrorCategory::AccessDenied,
            "One_or_more_inputs_to_this_request_were_not_found" => ErrorCategory::ResourceNotFound,
            "Service_limits_have_been_exceeded" => ErrorCategory::ServiceQuotaExceeded,
            "The_inputs_to_this_request_are_invalid" => ErrorCategory::Validation,
            "The_system_temporarily_lacks_sufficient_resources_to_process_the_request" => {
                ErrorCategory::Throttling
            }
            other => ErrorCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCategory::from(s))
    }
}
impl ErrorCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCategory::UserRecoverable => "A_user_recoverable_error_has_occurred",
            ErrorCategory::InternalServiceException => "An_internal_error_has_occurred",
            ErrorCategory::Cancelled => "Cancelled",
            ErrorCategory::AccessDenied => "Missing_required_permission_to_perform_this_request",
            ErrorCategory::ResourceNotFound => "One_or_more_inputs_to_this_request_were_not_found",
            ErrorCategory::ServiceQuotaExceeded => "Service_limits_have_been_exceeded",
            ErrorCategory::Validation => "The_inputs_to_this_request_are_invalid",
            ErrorCategory::Throttling => {
                "The_system_temporarily_lacks_sufficient_resources_to_process_the_request"
            }
            ErrorCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "A_user_recoverable_error_has_occurred",
            "An_internal_error_has_occurred",
            "Cancelled",
            "Missing_required_permission_to_perform_this_request",
            "One_or_more_inputs_to_this_request_were_not_found",
            "Service_limits_have_been_exceeded",
            "The_inputs_to_this_request_are_invalid",
            "The_system_temporarily_lacks_sufficient_resources_to_process_the_request",
        ]
    }
}
impl AsRef<str> for ErrorCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangesetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    StopRequested,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangesetStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ChangesetStatus::Failed,
            "PENDING" => ChangesetStatus::Pending,
            "RUNNING" => ChangesetStatus::Running,
            "STOP_REQUESTED" => ChangesetStatus::StopRequested,
            "SUCCESS" => ChangesetStatus::Success,
            other => ChangesetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangesetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangesetStatus::from(s))
    }
}
impl ChangesetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangesetStatus::Failed => "FAILED",
            ChangesetStatus::Pending => "PENDING",
            ChangesetStatus::Running => "RUNNING",
            ChangesetStatus::StopRequested => "STOP_REQUESTED",
            ChangesetStatus::Success => "SUCCESS",
            ChangesetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "RUNNING", "STOP_REQUESTED", "SUCCESS"]
    }
}
impl AsRef<str> for ChangesetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FormatType {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    #[allow(missing_docs)] // documentation missing in model
    Xml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FormatType {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => FormatType::Csv,
            "JSON" => FormatType::Json,
            "PARQUET" => FormatType::Parquet,
            "XML" => FormatType::Xml,
            other => FormatType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FormatType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FormatType::from(s))
    }
}
impl FormatType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FormatType::Csv => "CSV",
            FormatType::Json => "JSON",
            FormatType::Parquet => "PARQUET",
            FormatType::Xml => "XML",
            FormatType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON", "PARQUET", "XML"]
    }
}
impl AsRef<str> for FormatType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "S3" => SourceType::S3,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::S3 => "S3",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3"]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeType {
    #[allow(missing_docs)] // documentation missing in model
    Append,
    #[allow(missing_docs)] // documentation missing in model
    Modify,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeType {
    fn from(s: &str) -> Self {
        match s {
            "APPEND" => ChangeType::Append,
            "MODIFY" => ChangeType::Modify,
            "REPLACE" => ChangeType::Replace,
            other => ChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeType::from(s))
    }
}
impl ChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeType::Append => "APPEND",
            ChangeType::Modify => "MODIFY",
            ChangeType::Replace => "REPLACE",
            ChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPEND", "MODIFY", "REPLACE"]
    }
}
impl AsRef<str> for ChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
