// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkingLocationOutput {
    /// <p>Returns the Amazon S3 URI for the working location.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>Returns the Amazon S3 Path for the working location.</p>
    pub s3_path: std::option::Option<std::string::String>,
    /// <p>Returns the Amazon S3 bucket name for the working location.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetWorkingLocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkingLocationOutput");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("s3_path", &self.s3_path);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.finish()
    }
}
/// See [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
pub mod get_working_location_output {
    /// A builder for [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) s3_path: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the Amazon S3 URI for the working location.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>Returns the Amazon S3 URI for the working location.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>Returns the Amazon S3 Path for the working location.</p>
        pub fn s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_path = Some(input.into());
            self
        }
        /// <p>Returns the Amazon S3 Path for the working location.</p>
        pub fn set_s3_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_path = input;
            self
        }
        /// <p>Returns the Amazon S3 bucket name for the working location.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>Returns the Amazon S3 bucket name for the working location.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
        pub fn build(self) -> crate::output::GetWorkingLocationOutput {
            crate::output::GetWorkingLocationOutput {
                s3_uri: self.s3_uri,
                s3_path: self.s3_path,
                s3_bucket: self.s3_bucket,
            }
        }
    }
}
impl GetWorkingLocationOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkingLocationOutput`](crate::output::GetWorkingLocationOutput)
    pub fn builder() -> crate::output::get_working_location_output::Builder {
        crate::output::get_working_location_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProgrammaticAccessCredentialsOutput {
    /// <p>Returns the programmatic credentials.</p>
    pub credentials: std::option::Option<crate::model::Credentials>,
    /// <p>Returns the duration in which the credentials will remain valid.</p>
    pub duration_in_minutes: i64,
}
impl std::fmt::Debug for GetProgrammaticAccessCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProgrammaticAccessCredentialsOutput");
        formatter.field("credentials", &self.credentials);
        formatter.field("duration_in_minutes", &self.duration_in_minutes);
        formatter.finish()
    }
}
/// See [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
pub mod get_programmatic_access_credentials_output {
    /// A builder for [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
        pub(crate) duration_in_minutes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Returns the programmatic credentials.</p>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>Returns the programmatic credentials.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// <p>Returns the duration in which the credentials will remain valid.</p>
        pub fn duration_in_minutes(mut self, input: i64) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>Returns the duration in which the credentials will remain valid.</p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
        pub fn build(self) -> crate::output::GetProgrammaticAccessCredentialsOutput {
            crate::output::GetProgrammaticAccessCredentialsOutput {
                credentials: self.credentials,
                duration_in_minutes: self.duration_in_minutes.unwrap_or_default(),
            }
        }
    }
}
impl GetProgrammaticAccessCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`GetProgrammaticAccessCredentialsOutput`](crate::output::GetProgrammaticAccessCredentialsOutput)
    pub fn builder() -> crate::output::get_programmatic_access_credentials_output::Builder {
        crate::output::get_programmatic_access_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChangesetOutput {
    /// <p>Returns the changeset details.</p>
    pub changeset: std::option::Option<crate::model::ChangesetInfo>,
}
impl std::fmt::Debug for CreateChangesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChangesetOutput");
        formatter.field("changeset", &self.changeset);
        formatter.finish()
    }
}
/// See [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
pub mod create_changeset_output {
    /// A builder for [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) changeset: std::option::Option<crate::model::ChangesetInfo>,
    }
    impl Builder {
        /// <p>Returns the changeset details.</p>
        pub fn changeset(mut self, input: crate::model::ChangesetInfo) -> Self {
            self.changeset = Some(input);
            self
        }
        /// <p>Returns the changeset details.</p>
        pub fn set_changeset(
            mut self,
            input: std::option::Option<crate::model::ChangesetInfo>,
        ) -> Self {
            self.changeset = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
        pub fn build(self) -> crate::output::CreateChangesetOutput {
            crate::output::CreateChangesetOutput {
                changeset: self.changeset,
            }
        }
    }
}
impl CreateChangesetOutput {
    /// Creates a new builder-style object to manufacture [`CreateChangesetOutput`](crate::output::CreateChangesetOutput)
    pub fn builder() -> crate::output::create_changeset_output::Builder {
        crate::output::create_changeset_output::Builder::default()
    }
}
