// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentOutput {
    /// <p>Returns the FinSpace environment object.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl UpdateEnvironmentOutput {
    /// <p>Returns the FinSpace environment object.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentOutput");
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
pub mod update_environment_output {
    /// A builder for [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>Returns the FinSpace environment object.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>Returns the FinSpace environment object.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
        pub fn build(self) -> crate::output::UpdateEnvironmentOutput {
            crate::output::UpdateEnvironmentOutput {
                environment: self.environment,
            }
        }
    }
}
impl UpdateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    pub fn builder() -> crate::output::update_environment_output::Builder {
        crate::output::update_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of all tags for a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of all tags for a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of all tags for a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of all tags for a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentsOutput {
    /// <p>A list of all of your FinSpace environments.</p>
    pub environments: std::option::Option<std::vec::Vec<crate::model::Environment>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEnvironmentsOutput {
    /// <p>A list of all of your FinSpace environments.</p>
    pub fn environments(&self) -> std::option::Option<&[crate::model::Environment]> {
        self.environments.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentsOutput");
        formatter.field("environments", &self.environments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
pub mod list_environments_output {
    /// A builder for [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environments: std::option::Option<std::vec::Vec<crate::model::Environment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `environments`.
        ///
        /// To override the contents of this collection use [`set_environments`](Self::set_environments).
        ///
        /// <p>A list of all of your FinSpace environments.</p>
        pub fn environments(mut self, input: crate::model::Environment) -> Self {
            let mut v = self.environments.unwrap_or_default();
            v.push(input);
            self.environments = Some(v);
            self
        }
        /// <p>A list of all of your FinSpace environments.</p>
        pub fn set_environments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Environment>>,
        ) -> Self {
            self.environments = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
        pub fn build(self) -> crate::output::ListEnvironmentsOutput {
            crate::output::ListEnvironmentsOutput {
                environments: self.environments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEnvironmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    pub fn builder() -> crate::output::list_environments_output::Builder {
        crate::output::list_environments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentOutput {
    /// <p>The name of the FinSpace environment.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl GetEnvironmentOutput {
    /// <p>The name of the FinSpace environment.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for GetEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentOutput");
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
pub mod get_environment_output {
    /// A builder for [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The name of the FinSpace environment.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The name of the FinSpace environment.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
        pub fn build(self) -> crate::output::GetEnvironmentOutput {
            crate::output::GetEnvironmentOutput {
                environment: self.environment,
            }
        }
    }
}
impl GetEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    pub fn builder() -> crate::output::get_environment_output::Builder {
        crate::output::get_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentOutput {}
impl std::fmt::Debug for DeleteEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentOutput");
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
pub mod delete_environment_output {
    /// A builder for [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentOutput {
            crate::output::DeleteEnvironmentOutput {}
        }
    }
}
impl DeleteEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    pub fn builder() -> crate::output::delete_environment_output::Builder {
        crate::output::delete_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentOutput {
    /// <p>The unique identifier for FinSpace environment that you created.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the FinSpace environment that you created.</p>
    pub environment_arn: std::option::Option<std::string::String>,
    /// <p>The sign-in url for the web application of the FinSpace environment you created.</p>
    pub environment_url: std::option::Option<std::string::String>,
}
impl CreateEnvironmentOutput {
    /// <p>The unique identifier for FinSpace environment that you created.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the FinSpace environment that you created.</p>
    pub fn environment_arn(&self) -> std::option::Option<&str> {
        self.environment_arn.as_deref()
    }
    /// <p>The sign-in url for the web application of the FinSpace environment you created.</p>
    pub fn environment_url(&self) -> std::option::Option<&str> {
        self.environment_url.as_deref()
    }
}
impl std::fmt::Debug for CreateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentOutput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_arn", &self.environment_arn);
        formatter.field("environment_url", &self.environment_url);
        formatter.finish()
    }
}
/// See [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
pub mod create_environment_output {
    /// A builder for [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_arn: std::option::Option<std::string::String>,
        pub(crate) environment_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for FinSpace environment that you created.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for FinSpace environment that you created.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FinSpace environment that you created.</p>
        pub fn environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FinSpace environment that you created.</p>
        pub fn set_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_arn = input;
            self
        }
        /// <p>The sign-in url for the web application of the FinSpace environment you created.</p>
        pub fn environment_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_url = Some(input.into());
            self
        }
        /// <p>The sign-in url for the web application of the FinSpace environment you created.</p>
        pub fn set_environment_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentOutput {
            crate::output::CreateEnvironmentOutput {
                environment_id: self.environment_id,
                environment_arn: self.environment_arn,
                environment_url: self.environment_url,
            }
        }
    }
}
impl CreateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    pub fn builder() -> crate::output::create_environment_output::Builder {
        crate::output::create_environment_output::Builder::default()
    }
}
