// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudWatch Evidently
///
/// Client for invoking operations on Amazon CloudWatch Evidently. Each operation on Amazon CloudWatch Evidently is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_evidently::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_evidently::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_evidently::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchEvaluateFeature`](crate::client::fluent_builders::BatchEvaluateFeature) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::BatchEvaluateFeature::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::BatchEvaluateFeature::set_project): <p>The name or ARN of the project that contains the feature being evaluated.</p>
    ///   - [`requests(Vec<EvaluationRequest>)`](crate::client::fluent_builders::BatchEvaluateFeature::requests) / [`set_requests(Option<Vec<EvaluationRequest>>)`](crate::client::fluent_builders::BatchEvaluateFeature::set_requests): <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
    /// - On success, responds with [`BatchEvaluateFeatureOutput`](crate::output::BatchEvaluateFeatureOutput) with field(s):
    ///   - [`results(Option<Vec<EvaluationResult>>)`](crate::output::BatchEvaluateFeatureOutput::results): <p>An array of structures, where each structure displays the results of one feature evaluation assignment to one user session.</p>
    /// - On failure, responds with [`SdkError<BatchEvaluateFeatureError>`](crate::error::BatchEvaluateFeatureError)
    pub fn batch_evaluate_feature(&self) -> fluent_builders::BatchEvaluateFeature {
        fluent_builders::BatchEvaluateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateExperiment`](crate::client::fluent_builders::CreateExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::CreateExperiment::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::CreateExperiment::set_project): <p>The name or ARN of the project that you want to create the new experiment in.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateExperiment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateExperiment::set_name): <p>A name for the new experiment.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateExperiment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateExperiment::set_description): <p>An optional description of the experiment.</p>
    ///   - [`treatments(Vec<TreatmentConfig>)`](crate::client::fluent_builders::CreateExperiment::treatments) / [`set_treatments(Option<Vec<TreatmentConfig>>)`](crate::client::fluent_builders::CreateExperiment::set_treatments): <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
    ///   - [`metric_goals(Vec<MetricGoalConfig>)`](crate::client::fluent_builders::CreateExperiment::metric_goals) / [`set_metric_goals(Option<Vec<MetricGoalConfig>>)`](crate::client::fluent_builders::CreateExperiment::set_metric_goals): <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    ///   - [`randomization_salt(impl Into<String>)`](crate::client::fluent_builders::CreateExperiment::randomization_salt) / [`set_randomization_salt(Option<String>)`](crate::client::fluent_builders::CreateExperiment::set_randomization_salt): <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
    ///   - [`sampling_rate(i64)`](crate::client::fluent_builders::CreateExperiment::sampling_rate) / [`set_sampling_rate(Option<i64>)`](crate::client::fluent_builders::CreateExperiment::set_sampling_rate): <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>  <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
    ///   - [`online_ab_config(OnlineAbConfig)`](crate::client::fluent_builders::CreateExperiment::online_ab_config) / [`set_online_ab_config(Option<OnlineAbConfig>)`](crate::client::fluent_builders::CreateExperiment::set_online_ab_config): <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateExperiment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateExperiment::set_tags): <p>Assigns one or more tags (key-value pairs) to the experiment.</p>  <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>  <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>  <p>You can associate as many as 50 tags with an experiment.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    /// - On success, responds with [`CreateExperimentOutput`](crate::output::CreateExperimentOutput) with field(s):
    ///   - [`experiment(Option<Experiment>)`](crate::output::CreateExperimentOutput::experiment): <p>A structure containing the configuration details of the experiment that you created.</p>
    /// - On failure, responds with [`SdkError<CreateExperimentError>`](crate::error::CreateExperimentError)
    pub fn create_experiment(&self) -> fluent_builders::CreateExperiment {
        fluent_builders::CreateExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFeature`](crate::client::fluent_builders::CreateFeature) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::CreateFeature::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::CreateFeature::set_project): <p>The name or ARN of the project that is to contain the new feature.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFeature::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFeature::set_name): <p>The name for the new feature.</p>
    ///   - [`evaluation_strategy(FeatureEvaluationStrategy)`](crate::client::fluent_builders::CreateFeature::evaluation_strategy) / [`set_evaluation_strategy(Option<FeatureEvaluationStrategy>)`](crate::client::fluent_builders::CreateFeature::set_evaluation_strategy): <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFeature::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFeature::set_description): <p>An optional description of the feature.</p>
    ///   - [`variations(Vec<VariationConfig>)`](crate::client::fluent_builders::CreateFeature::variations) / [`set_variations(Option<Vec<VariationConfig>>)`](crate::client::fluent_builders::CreateFeature::set_variations): <p>An array of structures that contain the configuration of the feature's different variations.</p>
    ///   - [`default_variation(impl Into<String>)`](crate::client::fluent_builders::CreateFeature::default_variation) / [`set_default_variation(Option<String>)`](crate::client::fluent_builders::CreateFeature::set_default_variation): <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>  <p>This variation must also be listed in the <code>variations</code> structure.</p>  <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFeature::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFeature::set_tags): <p>Assigns one or more tags (key-value pairs) to the feature.</p>  <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>  <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>  <p>You can associate as many as 50 tags with a feature.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    ///   - [`entity_overrides(HashMap<String, String>)`](crate::client::fluent_builders::CreateFeature::entity_overrides) / [`set_entity_overrides(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFeature::set_entity_overrides): <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
    /// - On success, responds with [`CreateFeatureOutput`](crate::output::CreateFeatureOutput) with field(s):
    ///   - [`feature(Option<Feature>)`](crate::output::CreateFeatureOutput::feature): <p>A structure that contains information about the new feature.</p>
    /// - On failure, responds with [`SdkError<CreateFeatureError>`](crate::error::CreateFeatureError)
    pub fn create_feature(&self) -> fluent_builders::CreateFeature {
        fluent_builders::CreateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLaunch`](crate::client::fluent_builders::CreateLaunch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::CreateLaunch::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::CreateLaunch::set_project): <p>The name or ARN of the project that you want to create the launch in.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateLaunch::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateLaunch::set_name): <p>The name for the new launch.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateLaunch::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateLaunch::set_description): <p>An optional description for the launch.</p>
    ///   - [`scheduled_splits_config(ScheduledSplitsLaunchConfig)`](crate::client::fluent_builders::CreateLaunch::scheduled_splits_config) / [`set_scheduled_splits_config(Option<ScheduledSplitsLaunchConfig>)`](crate::client::fluent_builders::CreateLaunch::set_scheduled_splits_config): <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    ///   - [`metric_monitors(Vec<MetricMonitorConfig>)`](crate::client::fluent_builders::CreateLaunch::metric_monitors) / [`set_metric_monitors(Option<Vec<MetricMonitorConfig>>)`](crate::client::fluent_builders::CreateLaunch::set_metric_monitors): <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
    ///   - [`groups(Vec<LaunchGroupConfig>)`](crate::client::fluent_builders::CreateLaunch::groups) / [`set_groups(Option<Vec<LaunchGroupConfig>>)`](crate::client::fluent_builders::CreateLaunch::set_groups): <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
    ///   - [`randomization_salt(impl Into<String>)`](crate::client::fluent_builders::CreateLaunch::randomization_salt) / [`set_randomization_salt(Option<String>)`](crate::client::fluent_builders::CreateLaunch::set_randomization_salt): <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateLaunch::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateLaunch::set_tags): <p>Assigns one or more tags (key-value pairs) to the launch.</p>  <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>  <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>  <p>You can associate as many as 50 tags with a launch.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    /// - On success, responds with [`CreateLaunchOutput`](crate::output::CreateLaunchOutput) with field(s):
    ///   - [`launch(Option<Launch>)`](crate::output::CreateLaunchOutput::launch): <p>A structure that contains the configuration of the launch that was created.</p>
    /// - On failure, responds with [`SdkError<CreateLaunchError>`](crate::error::CreateLaunchError)
    pub fn create_launch(&self) -> fluent_builders::CreateLaunch {
        fluent_builders::CreateLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProject`](crate::client::fluent_builders::CreateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_name): <p>The name for the project.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateProject::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateProject::set_description): <p>An optional description of the project.</p>
    ///   - [`data_delivery(ProjectDataDeliveryConfig)`](crate::client::fluent_builders::CreateProject::data_delivery) / [`set_data_delivery(Option<ProjectDataDeliveryConfig>)`](crate::client::fluent_builders::CreateProject::set_data_delivery): <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateProject::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProject::set_tags): <p>Assigns one or more tags (key-value pairs) to the project.</p>  <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>  <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>  <p>You can associate as many as 50 tags with a project.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    /// - On success, responds with [`CreateProjectOutput`](crate::output::CreateProjectOutput) with field(s):
    ///   - [`project(Option<Project>)`](crate::output::CreateProjectOutput::project): <p>A structure that contains information about the created project.</p>
    /// - On failure, responds with [`SdkError<CreateProjectError>`](crate::error::CreateProjectError)
    pub fn create_project(&self) -> fluent_builders::CreateProject {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteExperiment`](crate::client::fluent_builders::DeleteExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::DeleteExperiment::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::DeleteExperiment::set_project): <p>The name or ARN of the project that contains the experiment to delete.</p>
    ///   - [`experiment(impl Into<String>)`](crate::client::fluent_builders::DeleteExperiment::experiment) / [`set_experiment(Option<String>)`](crate::client::fluent_builders::DeleteExperiment::set_experiment): <p>The name of the experiment to delete.</p>
    /// - On success, responds with [`DeleteExperimentOutput`](crate::output::DeleteExperimentOutput)

    /// - On failure, responds with [`SdkError<DeleteExperimentError>`](crate::error::DeleteExperimentError)
    pub fn delete_experiment(&self) -> fluent_builders::DeleteExperiment {
        fluent_builders::DeleteExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFeature`](crate::client::fluent_builders::DeleteFeature) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::DeleteFeature::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::DeleteFeature::set_project): <p>The name or ARN of the project that contains the feature to delete.</p>
    ///   - [`feature(impl Into<String>)`](crate::client::fluent_builders::DeleteFeature::feature) / [`set_feature(Option<String>)`](crate::client::fluent_builders::DeleteFeature::set_feature): <p>The name of the feature to delete.</p>
    /// - On success, responds with [`DeleteFeatureOutput`](crate::output::DeleteFeatureOutput)

    /// - On failure, responds with [`SdkError<DeleteFeatureError>`](crate::error::DeleteFeatureError)
    pub fn delete_feature(&self) -> fluent_builders::DeleteFeature {
        fluent_builders::DeleteFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLaunch`](crate::client::fluent_builders::DeleteLaunch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunch::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::DeleteLaunch::set_project): <p>The name or ARN of the project that contains the launch to delete.</p>
    ///   - [`launch(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunch::launch) / [`set_launch(Option<String>)`](crate::client::fluent_builders::DeleteLaunch::set_launch): <p>The name of the launch to delete.</p>
    /// - On success, responds with [`DeleteLaunchOutput`](crate::output::DeleteLaunchOutput)

    /// - On failure, responds with [`SdkError<DeleteLaunchError>`](crate::error::DeleteLaunchError)
    pub fn delete_launch(&self) -> fluent_builders::DeleteLaunch {
        fluent_builders::DeleteLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProject`](crate::client::fluent_builders::DeleteProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_project): <p>The name or ARN of the project to delete.</p>
    /// - On success, responds with [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)

    /// - On failure, responds with [`SdkError<DeleteProjectError>`](crate::error::DeleteProjectError)
    pub fn delete_project(&self) -> fluent_builders::DeleteProject {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EvaluateFeature`](crate::client::fluent_builders::EvaluateFeature) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::EvaluateFeature::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::EvaluateFeature::set_project): <p>The name or ARN of the project that contains this feature.</p>
    ///   - [`feature(impl Into<String>)`](crate::client::fluent_builders::EvaluateFeature::feature) / [`set_feature(Option<String>)`](crate::client::fluent_builders::EvaluateFeature::set_feature): <p>The name of the feature being evaluated.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::EvaluateFeature::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::EvaluateFeature::set_entity_id): <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
    ///   - [`evaluation_context(impl Into<String>)`](crate::client::fluent_builders::EvaluateFeature::evaluation_context) / [`set_evaluation_context(Option<String>)`](crate::client::fluent_builders::EvaluateFeature::set_evaluation_context): <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
    /// - On success, responds with [`EvaluateFeatureOutput`](crate::output::EvaluateFeatureOutput) with field(s):
    ///   - [`variation(Option<String>)`](crate::output::EvaluateFeatureOutput::variation): <p>The name of the variation that was served to the user session.</p>
    ///   - [`value(Option<VariableValue>)`](crate::output::EvaluateFeatureOutput::value): <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
    ///   - [`reason(Option<String>)`](crate::output::EvaluateFeatureOutput::reason): <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code> matches an override rule.</p>
    ///   - [`details(Option<String>)`](crate::output::EvaluateFeatureOutput::details): <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
    /// - On failure, responds with [`SdkError<EvaluateFeatureError>`](crate::error::EvaluateFeatureError)
    pub fn evaluate_feature(&self) -> fluent_builders::EvaluateFeature {
        fluent_builders::EvaluateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExperiment`](crate::client::fluent_builders::GetExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::GetExperiment::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::GetExperiment::set_project): <p>The name or ARN of the project that contains the experiment.</p>
    ///   - [`experiment(impl Into<String>)`](crate::client::fluent_builders::GetExperiment::experiment) / [`set_experiment(Option<String>)`](crate::client::fluent_builders::GetExperiment::set_experiment): <p>The name of the experiment that you want to see the details of.</p>
    /// - On success, responds with [`GetExperimentOutput`](crate::output::GetExperimentOutput) with field(s):
    ///   - [`experiment(Option<Experiment>)`](crate::output::GetExperimentOutput::experiment): <p>A structure containing the configuration details of the experiment.</p>
    /// - On failure, responds with [`SdkError<GetExperimentError>`](crate::error::GetExperimentError)
    pub fn get_experiment(&self) -> fluent_builders::GetExperiment {
        fluent_builders::GetExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExperimentResults`](crate::client::fluent_builders::GetExperimentResults) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::GetExperimentResults::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::GetExperimentResults::set_project): <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
    ///   - [`experiment(impl Into<String>)`](crate::client::fluent_builders::GetExperimentResults::experiment) / [`set_experiment(Option<String>)`](crate::client::fluent_builders::GetExperimentResults::set_experiment): <p>The name of the experiment to retrieve the results of.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetExperimentResults::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetExperimentResults::set_start_time): <p>The date and time that the experiment started.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetExperimentResults::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetExperimentResults::set_end_time): <p>The date and time that the experiment ended, if it is completed.</p>
    ///   - [`metric_names(Vec<String>)`](crate::client::fluent_builders::GetExperimentResults::metric_names) / [`set_metric_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetExperimentResults::set_metric_names): <p>The names of the experiment metrics that you want to see the results of.</p>
    ///   - [`treatment_names(Vec<String>)`](crate::client::fluent_builders::GetExperimentResults::treatment_names) / [`set_treatment_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetExperimentResults::set_treatment_names): <p>The names of the experiment treatments that you want to see the results for.</p>
    ///   - [`base_stat(ExperimentBaseStat)`](crate::client::fluent_builders::GetExperimentResults::base_stat) / [`set_base_stat(Option<ExperimentBaseStat>)`](crate::client::fluent_builders::GetExperimentResults::set_base_stat): <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
    ///   - [`result_stats(Vec<ExperimentResultRequestType>)`](crate::client::fluent_builders::GetExperimentResults::result_stats) / [`set_result_stats(Option<Vec<ExperimentResultRequestType>>)`](crate::client::fluent_builders::GetExperimentResults::set_result_stats): <p>The statistics that you want to see in the returned results.</p>  <ul>   <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>   <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>   <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>   <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>  </ul>
    ///   - [`report_names(Vec<ExperimentReportName>)`](crate::client::fluent_builders::GetExperimentResults::report_names) / [`set_report_names(Option<Vec<ExperimentReportName>>)`](crate::client::fluent_builders::GetExperimentResults::set_report_names): <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
    ///   - [`period(i64)`](crate::client::fluent_builders::GetExperimentResults::period) / [`set_period(i64)`](crate::client::fluent_builders::GetExperimentResults::set_period): <p>In seconds, the amount of time to aggregate results together. </p>
    /// - On success, responds with [`GetExperimentResultsOutput`](crate::output::GetExperimentResultsOutput) with field(s):
    ///   - [`results_data(Option<Vec<ExperimentResultsData>>)`](crate::output::GetExperimentResultsOutput::results_data): <p>An array of structures that include experiment results including metric names and values. </p>
    ///   - [`reports(Option<Vec<ExperimentReport>>)`](crate::output::GetExperimentResultsOutput::reports): <p>An array of structures that include the reports that you requested.</p>
    ///   - [`timestamps(Option<Vec<DateTime>>)`](crate::output::GetExperimentResultsOutput::timestamps): <p>The timestamps of each result returned.</p>
    /// - On failure, responds with [`SdkError<GetExperimentResultsError>`](crate::error::GetExperimentResultsError)
    pub fn get_experiment_results(&self) -> fluent_builders::GetExperimentResults {
        fluent_builders::GetExperimentResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFeature`](crate::client::fluent_builders::GetFeature) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::GetFeature::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::GetFeature::set_project): <p>The name or ARN of the project that contains the feature.</p>
    ///   - [`feature(impl Into<String>)`](crate::client::fluent_builders::GetFeature::feature) / [`set_feature(Option<String>)`](crate::client::fluent_builders::GetFeature::set_feature): <p>The name of the feature that you want to retrieve information for.</p>
    /// - On success, responds with [`GetFeatureOutput`](crate::output::GetFeatureOutput) with field(s):
    ///   - [`feature(Option<Feature>)`](crate::output::GetFeatureOutput::feature): <p>A structure containing the configuration details of the feature.</p>
    /// - On failure, responds with [`SdkError<GetFeatureError>`](crate::error::GetFeatureError)
    pub fn get_feature(&self) -> fluent_builders::GetFeature {
        fluent_builders::GetFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLaunch`](crate::client::fluent_builders::GetLaunch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::GetLaunch::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::GetLaunch::set_project): <p>The name or ARN of the project that contains the launch.</p>
    ///   - [`launch(impl Into<String>)`](crate::client::fluent_builders::GetLaunch::launch) / [`set_launch(Option<String>)`](crate::client::fluent_builders::GetLaunch::set_launch): <p>The name of the launch that you want to see the details of.</p>
    /// - On success, responds with [`GetLaunchOutput`](crate::output::GetLaunchOutput) with field(s):
    ///   - [`launch(Option<Launch>)`](crate::output::GetLaunchOutput::launch): <p>A structure containing the configuration details of the launch.</p>
    /// - On failure, responds with [`SdkError<GetLaunchError>`](crate::error::GetLaunchError)
    pub fn get_launch(&self) -> fluent_builders::GetLaunch {
        fluent_builders::GetLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProject`](crate::client::fluent_builders::GetProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::GetProject::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::GetProject::set_project): <p>The name or ARN of the project that you want to see the details of.</p>
    /// - On success, responds with [`GetProjectOutput`](crate::output::GetProjectOutput) with field(s):
    ///   - [`project(Option<Project>)`](crate::output::GetProjectOutput::project): <p>A structure containing the configuration details of the project.</p>
    /// - On failure, responds with [`SdkError<GetProjectError>`](crate::error::GetProjectError)
    pub fn get_project(&self) -> fluent_builders::GetProject {
        fluent_builders::GetProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExperiments`](crate::client::fluent_builders::ListExperiments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExperiments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::ListExperiments::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::ListExperiments::set_project): <p>The name or ARN of the project to return the experiment list from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExperiments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExperiments::set_max_results): <p>The maximum number of results to include in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExperiments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExperiments::set_next_token): <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
    ///   - [`status(ExperimentStatus)`](crate::client::fluent_builders::ListExperiments::status) / [`set_status(Option<ExperimentStatus>)`](crate::client::fluent_builders::ListExperiments::set_status): <p>Use this optional parameter to limit the returned results to only the experiments with the status that you specify here.</p>
    /// - On success, responds with [`ListExperimentsOutput`](crate::output::ListExperimentsOutput) with field(s):
    ///   - [`experiments(Option<Vec<Experiment>>)`](crate::output::ListExperimentsOutput::experiments): <p>An array of structures that contain the configuration details of the experiments in the specified project.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExperimentsOutput::next_token): <p>The token to use in a subsequent <code>ListExperiments</code> operation to return the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListExperimentsError>`](crate::error::ListExperimentsError)
    pub fn list_experiments(&self) -> fluent_builders::ListExperiments {
        fluent_builders::ListExperiments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFeatures`](crate::client::fluent_builders::ListFeatures) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFeatures::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::ListFeatures::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::ListFeatures::set_project): <p>The name or ARN of the project to return the feature list from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFeatures::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFeatures::set_max_results): <p>The maximum number of results to include in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFeatures::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFeatures::set_next_token): <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
    /// - On success, responds with [`ListFeaturesOutput`](crate::output::ListFeaturesOutput) with field(s):
    ///   - [`features(Option<Vec<FeatureSummary>>)`](crate::output::ListFeaturesOutput::features): <p>An array of structures that contain the configuration details of the features in the specified project.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFeaturesOutput::next_token): <p>The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListFeaturesError>`](crate::error::ListFeaturesError)
    pub fn list_features(&self) -> fluent_builders::ListFeatures {
        fluent_builders::ListFeatures::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLaunches`](crate::client::fluent_builders::ListLaunches) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLaunches::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::ListLaunches::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::ListLaunches::set_project): <p>The name or ARN of the project to return the launch list from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLaunches::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLaunches::set_max_results): <p>The maximum number of results to include in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLaunches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLaunches::set_next_token): <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
    ///   - [`status(LaunchStatus)`](crate::client::fluent_builders::ListLaunches::status) / [`set_status(Option<LaunchStatus>)`](crate::client::fluent_builders::ListLaunches::set_status): <p>Use this optional parameter to limit the returned results to only the launches with the status that you specify here.</p>
    /// - On success, responds with [`ListLaunchesOutput`](crate::output::ListLaunchesOutput) with field(s):
    ///   - [`launches(Option<Vec<Launch>>)`](crate::output::ListLaunchesOutput::launches): <p>An array of structures that contain the configuration details of the launches in the specified project.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLaunchesOutput::next_token): <p>The token to use in a subsequent <code>ListLaunches</code> operation to return the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLaunchesError>`](crate::error::ListLaunchesError)
    pub fn list_launches(&self) -> fluent_builders::ListLaunches {
        fluent_builders::ListLaunches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProjects`](crate::client::fluent_builders::ListProjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProjects::set_max_results): <p>The maximum number of results to include in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProjects::set_next_token): <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
    /// - On success, responds with [`ListProjectsOutput`](crate::output::ListProjectsOutput) with field(s):
    ///   - [`projects(Option<Vec<ProjectSummary>>)`](crate::output::ListProjectsOutput::projects): <p>An array of structures that contain the configuration details of the projects in the Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProjectsOutput::next_token): <p>The token to use in a subsequent <code>ListProjects</code> operation to return the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListProjectsError>`](crate::error::ListProjectsError)
    pub fn list_projects(&self) -> fluent_builders::ListProjects {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource that you want to see the tags of.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tag keys and values associated with the resource you specified.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutProjectEvents`](crate::client::fluent_builders::PutProjectEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::PutProjectEvents::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::PutProjectEvents::set_project): <p>The name or ARN of the project to write the events to.</p>
    ///   - [`events(Vec<Event>)`](crate::client::fluent_builders::PutProjectEvents::events) / [`set_events(Option<Vec<Event>>)`](crate::client::fluent_builders::PutProjectEvents::set_events): <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
    /// - On success, responds with [`PutProjectEventsOutput`](crate::output::PutProjectEventsOutput) with field(s):
    ///   - [`failed_event_count(Option<i32>)`](crate::output::PutProjectEventsOutput::failed_event_count): <p>The number of events in the operation that could not be used by Evidently.</p>
    ///   - [`event_results(Option<Vec<PutProjectEventsResultEntry>>)`](crate::output::PutProjectEventsOutput::event_results): <p>A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any.</p>
    /// - On failure, responds with [`SdkError<PutProjectEventsError>`](crate::error::PutProjectEventsError)
    pub fn put_project_events(&self) -> fluent_builders::PutProjectEvents {
        fluent_builders::PutProjectEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartExperiment`](crate::client::fluent_builders::StartExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::StartExperiment::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::StartExperiment::set_project): <p>The name or ARN of the project that contains the experiment to start.</p>
    ///   - [`experiment(impl Into<String>)`](crate::client::fluent_builders::StartExperiment::experiment) / [`set_experiment(Option<String>)`](crate::client::fluent_builders::StartExperiment::set_experiment): <p>The name of the experiment to start.</p>
    ///   - [`analysis_complete_time(DateTime)`](crate::client::fluent_builders::StartExperiment::analysis_complete_time) / [`set_analysis_complete_time(Option<DateTime>)`](crate::client::fluent_builders::StartExperiment::set_analysis_complete_time): <p>The date and time to end the experiment.</p>
    /// - On success, responds with [`StartExperimentOutput`](crate::output::StartExperimentOutput) with field(s):
    ///   - [`started_time(Option<DateTime>)`](crate::output::StartExperimentOutput::started_time): <p>A timestamp that indicates when the experiment started.</p>
    /// - On failure, responds with [`SdkError<StartExperimentError>`](crate::error::StartExperimentError)
    pub fn start_experiment(&self) -> fluent_builders::StartExperiment {
        fluent_builders::StartExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartLaunch`](crate::client::fluent_builders::StartLaunch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::StartLaunch::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::StartLaunch::set_project): <p>The name or ARN of the project that contains the launch to start.</p>
    ///   - [`launch(impl Into<String>)`](crate::client::fluent_builders::StartLaunch::launch) / [`set_launch(Option<String>)`](crate::client::fluent_builders::StartLaunch::set_launch): <p>The name of the launch to start.</p>
    /// - On success, responds with [`StartLaunchOutput`](crate::output::StartLaunchOutput) with field(s):
    ///   - [`launch(Option<Launch>)`](crate::output::StartLaunchOutput::launch): <p>A structure that contains information about the launch that was started.</p>
    /// - On failure, responds with [`SdkError<StartLaunchError>`](crate::error::StartLaunchError)
    pub fn start_launch(&self) -> fluent_builders::StartLaunch {
        fluent_builders::StartLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopExperiment`](crate::client::fluent_builders::StopExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::StopExperiment::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::StopExperiment::set_project): <p>The name or ARN of the project that contains the experiment to stop.</p>
    ///   - [`experiment(impl Into<String>)`](crate::client::fluent_builders::StopExperiment::experiment) / [`set_experiment(Option<String>)`](crate::client::fluent_builders::StopExperiment::set_experiment): <p>The name of the experiment to stop.</p>
    ///   - [`desired_state(ExperimentStopDesiredState)`](crate::client::fluent_builders::StopExperiment::desired_state) / [`set_desired_state(Option<ExperimentStopDesiredState>)`](crate::client::fluent_builders::StopExperiment::set_desired_state): <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::StopExperiment::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::StopExperiment::set_reason): <p>A string that describes why you are stopping the experiment.</p>
    /// - On success, responds with [`StopExperimentOutput`](crate::output::StopExperimentOutput) with field(s):
    ///   - [`ended_time(Option<DateTime>)`](crate::output::StopExperimentOutput::ended_time): <p>The date and time that the experiment stopped.</p>
    /// - On failure, responds with [`SdkError<StopExperimentError>`](crate::error::StopExperimentError)
    pub fn stop_experiment(&self) -> fluent_builders::StopExperiment {
        fluent_builders::StopExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopLaunch`](crate::client::fluent_builders::StopLaunch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::StopLaunch::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::StopLaunch::set_project): <p>The name or ARN of the project that contains the launch that you want to stop.</p>
    ///   - [`launch(impl Into<String>)`](crate::client::fluent_builders::StopLaunch::launch) / [`set_launch(Option<String>)`](crate::client::fluent_builders::StopLaunch::set_launch): <p>The name of the launch to stop.</p>
    ///   - [`desired_state(LaunchStopDesiredState)`](crate::client::fluent_builders::StopLaunch::desired_state) / [`set_desired_state(Option<LaunchStopDesiredState>)`](crate::client::fluent_builders::StopLaunch::set_desired_state): <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::StopLaunch::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::StopLaunch::set_reason): <p>A string that describes why you are stopping the launch.</p>
    /// - On success, responds with [`StopLaunchOutput`](crate::output::StopLaunchOutput) with field(s):
    ///   - [`ended_time(Option<DateTime>)`](crate::output::StopLaunchOutput::ended_time): <p>The date and time that the launch stopped.</p>
    /// - On failure, responds with [`SdkError<StopLaunchError>`](crate::error::StopLaunchError)
    pub fn stop_launch(&self) -> fluent_builders::StopLaunch {
        fluent_builders::StopLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of key-value pairs to associate with the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateExperiment`](crate::client::fluent_builders::UpdateExperiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::UpdateExperiment::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::UpdateExperiment::set_project): <p>The name or ARN of the project that contains the experiment that you want to update.</p>
    ///   - [`experiment(impl Into<String>)`](crate::client::fluent_builders::UpdateExperiment::experiment) / [`set_experiment(Option<String>)`](crate::client::fluent_builders::UpdateExperiment::set_experiment): <p>The name of the experiment to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateExperiment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateExperiment::set_description): <p>An optional description of the experiment.</p>
    ///   - [`treatments(Vec<TreatmentConfig>)`](crate::client::fluent_builders::UpdateExperiment::treatments) / [`set_treatments(Option<Vec<TreatmentConfig>>)`](crate::client::fluent_builders::UpdateExperiment::set_treatments): <p>An array of structures that define the variations being tested in the experiment.</p>
    ///   - [`metric_goals(Vec<MetricGoalConfig>)`](crate::client::fluent_builders::UpdateExperiment::metric_goals) / [`set_metric_goals(Option<Vec<MetricGoalConfig>>)`](crate::client::fluent_builders::UpdateExperiment::set_metric_goals): <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    ///   - [`randomization_salt(impl Into<String>)`](crate::client::fluent_builders::UpdateExperiment::randomization_salt) / [`set_randomization_salt(Option<String>)`](crate::client::fluent_builders::UpdateExperiment::set_randomization_salt): <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
    ///   - [`sampling_rate(i64)`](crate::client::fluent_builders::UpdateExperiment::sampling_rate) / [`set_sampling_rate(Option<i64>)`](crate::client::fluent_builders::UpdateExperiment::set_sampling_rate): <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>  <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
    ///   - [`online_ab_config(OnlineAbConfig)`](crate::client::fluent_builders::UpdateExperiment::online_ab_config) / [`set_online_ab_config(Option<OnlineAbConfig>)`](crate::client::fluent_builders::UpdateExperiment::set_online_ab_config): <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    /// - On success, responds with [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput) with field(s):
    ///   - [`experiment(Option<Experiment>)`](crate::output::UpdateExperimentOutput::experiment): <p>A structure containing the configuration details of the experiment that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateExperimentError>`](crate::error::UpdateExperimentError)
    pub fn update_experiment(&self) -> fluent_builders::UpdateExperiment {
        fluent_builders::UpdateExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFeature`](crate::client::fluent_builders::UpdateFeature) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::UpdateFeature::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::UpdateFeature::set_project): <p>The name or ARN of the project that contains the feature to be updated.</p>
    ///   - [`feature(impl Into<String>)`](crate::client::fluent_builders::UpdateFeature::feature) / [`set_feature(Option<String>)`](crate::client::fluent_builders::UpdateFeature::set_feature): <p>The name of the feature to be updated.</p>
    ///   - [`evaluation_strategy(FeatureEvaluationStrategy)`](crate::client::fluent_builders::UpdateFeature::evaluation_strategy) / [`set_evaluation_strategy(Option<FeatureEvaluationStrategy>)`](crate::client::fluent_builders::UpdateFeature::set_evaluation_strategy): <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFeature::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFeature::set_description): <p>An optional description of the feature.</p>
    ///   - [`add_or_update_variations(Vec<VariationConfig>)`](crate::client::fluent_builders::UpdateFeature::add_or_update_variations) / [`set_add_or_update_variations(Option<Vec<VariationConfig>>)`](crate::client::fluent_builders::UpdateFeature::set_add_or_update_variations): <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
    ///   - [`remove_variations(Vec<String>)`](crate::client::fluent_builders::UpdateFeature::remove_variations) / [`set_remove_variations(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFeature::set_remove_variations): <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>  <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
    ///   - [`default_variation(impl Into<String>)`](crate::client::fluent_builders::UpdateFeature::default_variation) / [`set_default_variation(Option<String>)`](crate::client::fluent_builders::UpdateFeature::set_default_variation): <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    ///   - [`entity_overrides(HashMap<String, String>)`](crate::client::fluent_builders::UpdateFeature::entity_overrides) / [`set_entity_overrides(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateFeature::set_entity_overrides): <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
    /// - On success, responds with [`UpdateFeatureOutput`](crate::output::UpdateFeatureOutput) with field(s):
    ///   - [`feature(Option<Feature>)`](crate::output::UpdateFeatureOutput::feature): <p>A structure that contains information about the updated feature.</p>
    /// - On failure, responds with [`SdkError<UpdateFeatureError>`](crate::error::UpdateFeatureError)
    pub fn update_feature(&self) -> fluent_builders::UpdateFeature {
        fluent_builders::UpdateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLaunch`](crate::client::fluent_builders::UpdateLaunch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunch::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::UpdateLaunch::set_project): <p>The name or ARN of the project that contains the launch that you want to update.</p>
    ///   - [`launch(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunch::launch) / [`set_launch(Option<String>)`](crate::client::fluent_builders::UpdateLaunch::set_launch): <p>The name of the launch that is to be updated.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunch::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateLaunch::set_description): <p>An optional description for the launch.</p>
    ///   - [`groups(Vec<LaunchGroupConfig>)`](crate::client::fluent_builders::UpdateLaunch::groups) / [`set_groups(Option<Vec<LaunchGroupConfig>>)`](crate::client::fluent_builders::UpdateLaunch::set_groups): <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
    ///   - [`metric_monitors(Vec<MetricMonitorConfig>)`](crate::client::fluent_builders::UpdateLaunch::metric_monitors) / [`set_metric_monitors(Option<Vec<MetricMonitorConfig>>)`](crate::client::fluent_builders::UpdateLaunch::set_metric_monitors): <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
    ///   - [`randomization_salt(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunch::randomization_salt) / [`set_randomization_salt(Option<String>)`](crate::client::fluent_builders::UpdateLaunch::set_randomization_salt): <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
    ///   - [`scheduled_splits_config(ScheduledSplitsLaunchConfig)`](crate::client::fluent_builders::UpdateLaunch::scheduled_splits_config) / [`set_scheduled_splits_config(Option<ScheduledSplitsLaunchConfig>)`](crate::client::fluent_builders::UpdateLaunch::set_scheduled_splits_config): <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    /// - On success, responds with [`UpdateLaunchOutput`](crate::output::UpdateLaunchOutput) with field(s):
    ///   - [`launch(Option<Launch>)`](crate::output::UpdateLaunchOutput::launch): <p>A structure that contains the new configuration of the launch that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateLaunchError>`](crate::error::UpdateLaunchError)
    pub fn update_launch(&self) -> fluent_builders::UpdateLaunch {
        fluent_builders::UpdateLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProject`](crate::client::fluent_builders::UpdateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_project): <p>The name or ARN of the project to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_description): <p>An optional description of the project.</p>
    /// - On success, responds with [`UpdateProjectOutput`](crate::output::UpdateProjectOutput) with field(s):
    ///   - [`project(Option<Project>)`](crate::output::UpdateProjectOutput::project): <p>A structure containing information about the updated project.</p>
    /// - On failure, responds with [`SdkError<UpdateProjectError>`](crate::error::UpdateProjectError)
    pub fn update_project(&self) -> fluent_builders::UpdateProject {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProjectDataDelivery`](crate::client::fluent_builders::UpdateProjectDataDelivery) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project(impl Into<String>)`](crate::client::fluent_builders::UpdateProjectDataDelivery::project) / [`set_project(Option<String>)`](crate::client::fluent_builders::UpdateProjectDataDelivery::set_project): <p>The name or ARN of the project that you want to modify the data storage options for.</p>
    ///   - [`s3_destination(S3DestinationConfig)`](crate::client::fluent_builders::UpdateProjectDataDelivery::s3_destination) / [`set_s3_destination(Option<S3DestinationConfig>)`](crate::client::fluent_builders::UpdateProjectDataDelivery::set_s3_destination): <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
    ///   - [`cloud_watch_logs(CloudWatchLogsDestinationConfig)`](crate::client::fluent_builders::UpdateProjectDataDelivery::cloud_watch_logs) / [`set_cloud_watch_logs(Option<CloudWatchLogsDestinationConfig>)`](crate::client::fluent_builders::UpdateProjectDataDelivery::set_cloud_watch_logs): <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
    /// - On success, responds with [`UpdateProjectDataDeliveryOutput`](crate::output::UpdateProjectDataDeliveryOutput) with field(s):
    ///   - [`project(Option<Project>)`](crate::output::UpdateProjectDataDeliveryOutput::project): <p>A structure containing details about the project that you updated.</p>
    /// - On failure, responds with [`SdkError<UpdateProjectDataDeliveryError>`](crate::error::UpdateProjectDataDeliveryError)
    pub fn update_project_data_delivery(&self) -> fluent_builders::UpdateProjectDataDelivery {
        fluent_builders::UpdateProjectDataDelivery::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchEvaluateFeature`.
    ///
    /// <p>This operation assigns feature variation to user sessions. For each user session, you pass in an <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the variation.</p>
    /// <p>The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an override rule, the user is served the variation specified by that rule.</p>
    /// <p>Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch, the variation they are served depends on the allocation of the various feature variations used for the launch.</p>
    /// <p>If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be assigned to a variation in the experiment. The chance of this depends on the percentage of users that are allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on the allocation of the various feature variations used for the experiment. </p>
    /// <p>If the user is not assigned to a launch or experiment, they are served the default variation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchEvaluateFeature {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_evaluate_feature_input::Builder,
    }
    impl BatchEvaluateFeature {
        /// Creates a new `BatchEvaluateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchEvaluateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchEvaluateFeatureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// Appends an item to `requests`.
        ///
        /// To override the contents of this collection use [`set_requests`](Self::set_requests).
        ///
        /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
        pub fn requests(mut self, input: crate::model::EvaluationRequest) -> Self {
            self.inner = self.inner.requests(input);
            self
        }
        /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
        pub fn set_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExperiment`.
    ///
    /// <p>Creates an Evidently <i>experiment</i>. Before you create an experiment, you must create the feature to use for the experiment.</p>
    /// <p>An experiment helps you make feature design decisions based on evidence and data. An experiment can test as many as five variations at once. Evidently collects experiment data and analyzes it by statistical methods, and provides clear recommendations about which variations perform better.</p>
    /// <p>Don't use this operation to update an existing experiment. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_experiment_input::Builder,
    }
    impl CreateExperiment {
        /// Creates a new `CreateExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>A name for the new experiment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the new experiment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `treatments`.
        ///
        /// To override the contents of this collection use [`set_treatments`](Self::set_treatments).
        ///
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn treatments(mut self, input: crate::model::TreatmentConfig) -> Self {
            self.inner = self.inner.treatments(input);
            self
        }
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn set_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        ) -> Self {
            self.inner = self.inner.set_treatments(input);
            self
        }
        /// Appends an item to `metricGoals`.
        ///
        /// To override the contents of this collection use [`set_metric_goals`](Self::set_metric_goals).
        ///
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn metric_goals(mut self, input: crate::model::MetricGoalConfig) -> Self {
            self.inner = self.inner.metric_goals(input);
            self
        }
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn set_metric_goals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_goals(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.inner = self.inner.sampling_rate(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn online_ab_config(mut self, input: crate::model::OnlineAbConfig) -> Self {
            self.inner = self.inner.online_ab_config(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn set_online_ab_config(
            mut self,
            input: std::option::Option<crate::model::OnlineAbConfig>,
        ) -> Self {
            self.inner = self.inner.set_online_ab_config(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an experiment.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an experiment.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFeature`.
    ///
    /// <p>Creates an Evidently <i>feature</i> that you want to launch or test. You can define up to five variations of a feature, and use these variations in your launches and experiments. A feature must be created in a project. For information about creating a project, see <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html">CreateProject</a>.</p>
    /// <p>Don't use this operation to update an existing feature. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html">UpdateFeature</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFeature {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_feature_input::Builder,
    }
    impl CreateFeature {
        /// Creates a new `CreateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFeatureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that is to contain the new feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that is to contain the new feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name for the new feature.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the new feature.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.inner = self.inner.evaluation_strategy(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_strategy(input);
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `variations`.
        ///
        /// To override the contents of this collection use [`set_variations`](Self::set_variations).
        ///
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn variations(mut self, input: crate::model::VariationConfig) -> Self {
            self.inner = self.inner.variations(input);
            self
        }
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn set_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_variations(input);
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_variation(input.into());
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_variation(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a feature.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a feature.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `entityOverrides`.
        ///
        /// To override the contents of this collection use [`set_entity_overrides`](Self::set_entity_overrides).
        ///
        /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn entity_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.entity_overrides(k.into(), v.into());
            self
        }
        /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn set_entity_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entity_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLaunch`.
    ///
    /// <p>Creates a <i>launch</i> of a given feature. Before you create a launch, you must create the feature to use for the launch.</p>
    /// <p>You can use a launch to safely validate new features by serving them to a specified percentage of your users while you roll out the feature. You can monitor the performance of the new feature to help you decide when to ramp up traffic to more users. This helps you reduce risk and identify unintended consequences before you fully launch the feature.</p>
    /// <p>Don't use this operation to update an existing launch. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html">UpdateLaunch</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLaunch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_launch_input::Builder,
    }
    impl CreateLaunch {
        /// Creates a new `CreateLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLaunchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to create the launch in.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to create the launch in.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name for the new launch.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the new launch.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn scheduled_splits_config(
            mut self,
            input: crate::model::ScheduledSplitsLaunchConfig,
        ) -> Self {
            self.inner = self.inner.scheduled_splits_config(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn set_scheduled_splits_config(
            mut self,
            input: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_splits_config(input);
            self
        }
        /// Appends an item to `metricMonitors`.
        ///
        /// To override the contents of this collection use [`set_metric_monitors`](Self::set_metric_monitors).
        ///
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn metric_monitors(mut self, input: crate::model::MetricMonitorConfig) -> Self {
            self.inner = self.inner.metric_monitors(input);
            self
        }
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn set_metric_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_monitors(input);
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn groups(mut self, input: crate::model::LaunchGroupConfig) -> Self {
            self.inner = self.inner.groups(input);
            self
        }
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a launch.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a launch.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments. Use projects to group similar features together.</p>
    /// <p>To update an existing project, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html">UpdateProject</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_project_input::Builder,
    }
    impl CreateProject {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
        pub fn data_delivery(mut self, input: crate::model::ProjectDataDeliveryConfig) -> Self {
            self.inner = self.inner.data_delivery(input);
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
        pub fn set_data_delivery(
            mut self,
            input: std::option::Option<crate::model::ProjectDataDeliveryConfig>,
        ) -> Self {
            self.inner = self.inner.set_data_delivery(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a project.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a project.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExperiment`.
    ///
    /// <p>Deletes an Evidently experiment. The feature used for the experiment is not deleted.</p>
    /// <p>To stop an experiment without deleting it, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html">StopExperiment</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_experiment_input::Builder,
    }
    impl DeleteExperiment {
        /// Creates a new `DeleteExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFeature`.
    ///
    /// <p>Deletes an Evidently feature.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFeature {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_feature_input::Builder,
    }
    impl DeleteFeature {
        /// Creates a new `DeleteFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFeatureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature to delete.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature to delete.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLaunch`.
    ///
    /// <p>Deletes an Evidently launch. The feature used for the launch is not deleted.</p>
    /// <p>To stop a launch without deleting it, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html">StopLaunch</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLaunch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_launch_input::Builder,
    }
    impl DeleteLaunch {
        /// Creates a new `DeleteLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLaunchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch to delete.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch to delete.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an Evidently project. Before you can delete a project, you must delete all the features that the project contains. To delete a feature, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html">DeleteFeature</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl DeleteProject {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EvaluateFeature`.
    ///
    /// <p>This operation assigns a feature variation to one given user session. You pass in an <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the variation.</p>
    /// <p>The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an override rule, the user is served the variation specified by that rule.</p>
    /// <p>Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch, the variation they are served depends on the allocation of the various feature variations used for the launch.</p>
    /// <p>If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be assigned to a variation in the experiment. The chance of this depends on the percentage of users that are allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on the allocation of the various feature variations used for the experiment. </p>
    /// <p>If the user is not assigned to a launch or experiment, they are served the default variation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EvaluateFeature {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::evaluate_feature_input::Builder,
    }
    impl EvaluateFeature {
        /// Creates a new `EvaluateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EvaluateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::EvaluateFeatureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains this feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains this feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
        /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn evaluation_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_context(input.into());
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn set_evaluation_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExperiment`.
    ///
    /// <p>Returns the details about one experiment. You must already know the experiment name. To retrieve a list of experiments in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html">ListExperiments</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_experiment_input::Builder,
    }
    impl GetExperiment {
        /// Creates a new `GetExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment that you want to see the details of.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment that you want to see the details of.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExperimentResults`.
    ///
    /// <p>Retrieves the results of a running or completed experiment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExperimentResults {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_experiment_results_input::Builder,
    }
    impl GetExperimentResults {
        /// Creates a new `GetExperimentResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExperimentResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExperimentResultsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to retrieve the results of.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to retrieve the results of.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>The date and time that the experiment started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The date and time that the experiment started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The date and time that the experiment ended, if it is completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The date and time that the experiment ended, if it is completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// Appends an item to `metricNames`.
        ///
        /// To override the contents of this collection use [`set_metric_names`](Self::set_metric_names).
        ///
        /// <p>The names of the experiment metrics that you want to see the results of.</p>
        pub fn metric_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_names(input.into());
            self
        }
        /// <p>The names of the experiment metrics that you want to see the results of.</p>
        pub fn set_metric_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_metric_names(input);
            self
        }
        /// Appends an item to `treatmentNames`.
        ///
        /// To override the contents of this collection use [`set_treatment_names`](Self::set_treatment_names).
        ///
        /// <p>The names of the experiment treatments that you want to see the results for.</p>
        pub fn treatment_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.treatment_names(input.into());
            self
        }
        /// <p>The names of the experiment treatments that you want to see the results for.</p>
        pub fn set_treatment_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_treatment_names(input);
            self
        }
        /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
        pub fn base_stat(mut self, input: crate::model::ExperimentBaseStat) -> Self {
            self.inner = self.inner.base_stat(input);
            self
        }
        /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
        pub fn set_base_stat(
            mut self,
            input: std::option::Option<crate::model::ExperimentBaseStat>,
        ) -> Self {
            self.inner = self.inner.set_base_stat(input);
            self
        }
        /// Appends an item to `resultStats`.
        ///
        /// To override the contents of this collection use [`set_result_stats`](Self::set_result_stats).
        ///
        /// <p>The statistics that you want to see in the returned results.</p>
        /// <ul>
        /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
        /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
        /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
        /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
        /// </ul>
        pub fn result_stats(mut self, input: crate::model::ExperimentResultRequestType) -> Self {
            self.inner = self.inner.result_stats(input);
            self
        }
        /// <p>The statistics that you want to see in the returned results.</p>
        /// <ul>
        /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
        /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
        /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
        /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
        /// </ul>
        pub fn set_result_stats(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentResultRequestType>>,
        ) -> Self {
            self.inner = self.inner.set_result_stats(input);
            self
        }
        /// Appends an item to `reportNames`.
        ///
        /// To override the contents of this collection use [`set_report_names`](Self::set_report_names).
        ///
        /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
        pub fn report_names(mut self, input: crate::model::ExperimentReportName) -> Self {
            self.inner = self.inner.report_names(input);
            self
        }
        /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
        pub fn set_report_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentReportName>>,
        ) -> Self {
            self.inner = self.inner.set_report_names(input);
            self
        }
        /// <p>In seconds, the amount of time to aggregate results together. </p>
        pub fn period(mut self, input: i64) -> Self {
            self.inner = self.inner.period(input);
            self
        }
        /// <p>In seconds, the amount of time to aggregate results together. </p>
        pub fn set_period(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFeature`.
    ///
    /// <p>Returns the details about one feature. You must already know the feature name. To retrieve a list of features in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html">ListFeatures</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFeature {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_feature_input::Builder,
    }
    impl GetFeature {
        /// Creates a new `GetFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFeatureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature that you want to retrieve information for.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature that you want to retrieve information for.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunch`.
    ///
    /// <p>Returns the details about one launch. You must already know the launch name. To retrieve a list of launches in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html">ListLaunches</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_launch_input::Builder,
    }
    impl GetLaunch {
        /// Creates a new `GetLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch that you want to see the details of.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch that you want to see the details of.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProject`.
    ///
    /// <p>Returns the details about one launch. You must already know the project name. To retrieve a list of projects in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html">ListProjects</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_project_input::Builder,
    }
    impl GetProject {
        /// Creates a new `GetProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to see the details of.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to see the details of.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExperiments`.
    ///
    /// <p>Returns configuration details about all the experiments in the specified project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExperiments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_experiments_input::Builder,
    }
    impl ListExperiments {
        /// Creates a new `ListExperiments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExperimentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExperimentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExperimentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExperimentsPaginator {
            crate::paginator::ListExperimentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ARN of the project to return the experiment list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the experiment list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the experiments with the status that you specify here.</p>
        pub fn status(mut self, input: crate::model::ExperimentStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the experiments with the status that you specify here.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExperimentStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFeatures`.
    ///
    /// <p>Returns configuration details about all the features in the specified project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFeatures {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_features_input::Builder,
    }
    impl ListFeatures {
        /// Creates a new `ListFeatures`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFeaturesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFeaturesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFeaturesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFeaturesPaginator {
            crate::paginator::ListFeaturesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ARN of the project to return the feature list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the feature list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunches`.
    ///
    /// <p>Returns configuration details about all the launches in the specified project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLaunches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_launches_input::Builder,
    }
    impl ListLaunches {
        /// Creates a new `ListLaunches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLaunchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLaunchesPaginator {
            crate::paginator::ListLaunchesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ARN of the project to return the launch list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the launch list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the launches with the status that you specify here.</p>
        pub fn status(mut self, input: crate::model::LaunchStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the launches with the status that you specify here.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LaunchStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Returns configuration details about all the projects in the current Region in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl ListProjects {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProjectsPaginator {
            crate::paginator::ListProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with an Evidently resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProjectEvents`.
    ///
    /// <p>Sends performance events to Evidently. These events can be used to evaluate a launch or an experiment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutProjectEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_project_events_input::Builder,
    }
    impl PutProjectEvents {
        /// Creates a new `PutProjectEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProjectEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProjectEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project to write the events to.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to write the events to.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            self.inner = self.inner.events(input);
            self
        }
        /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.inner = self.inner.set_events(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExperiment`.
    ///
    /// <p>Starts an existing experiment. To create an experiment, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html">CreateExperiment</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_experiment_input::Builder,
    }
    impl StartExperiment {
        /// Creates a new `StartExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment to start.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to start.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to start.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to start.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>The date and time to end the experiment.</p>
        pub fn analysis_complete_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.analysis_complete_time(input);
            self
        }
        /// <p>The date and time to end the experiment.</p>
        pub fn set_analysis_complete_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_analysis_complete_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartLaunch`.
    ///
    /// <p>Starts an existing launch. To create a launch, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html">CreateLaunch</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartLaunch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_launch_input::Builder,
    }
    impl StartLaunch {
        /// Creates a new `StartLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartLaunchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch to start.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch to start.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch to start.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch to start.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopExperiment`.
    ///
    /// <p>Stops an experiment that is currently running. If you stop an experiment, you can't resume it or restart it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_experiment_input::Builder,
    }
    impl StopExperiment {
        /// Creates a new `StopExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment to stop.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to stop.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to stop.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to stop.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn desired_state(mut self, input: crate::model::ExperimentStopDesiredState) -> Self {
            self.inner = self.inner.desired_state(input);
            self
        }
        /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::ExperimentStopDesiredState>,
        ) -> Self {
            self.inner = self.inner.set_desired_state(input);
            self
        }
        /// <p>A string that describes why you are stopping the experiment.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A string that describes why you are stopping the experiment.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopLaunch`.
    ///
    /// <p>Stops a launch that is currently running. After you stop a launch, you will not be able to resume it or restart it. Also, it will not be evaluated as a rule for traffic allocation, and the traffic that was allocated to the launch will instead be available to the feature's experiment, if there is one. Otherwise, all traffic will be served the default variation after the launch is stopped.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopLaunch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_launch_input::Builder,
    }
    impl StopLaunch {
        /// Creates a new `StopLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::StopLaunchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch to stop.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch to stop.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
        /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn desired_state(mut self, input: crate::model::LaunchStopDesiredState) -> Self {
            self.inner = self.inner.desired_state(input);
            self
        }
        /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::LaunchStopDesiredState>,
        ) -> Self {
            self.inner = self.inner.set_desired_state(input);
            self
        }
        /// <p>A string that describes why you are stopping the launch.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A string that describes why you are stopping the launch.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently resource. Projects, features, launches, and experiments can be tagged.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateExperiment`.
    ///
    /// <p>Updates an Evidently experiment. </p>
    /// <p>Don't use this operation to update an experiment's tag. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateExperiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_experiment_input::Builder,
    }
    impl UpdateExperiment {
        /// Creates a new `UpdateExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateExperimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to update.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to update.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `treatments`.
        ///
        /// To override the contents of this collection use [`set_treatments`](Self::set_treatments).
        ///
        /// <p>An array of structures that define the variations being tested in the experiment.</p>
        pub fn treatments(mut self, input: crate::model::TreatmentConfig) -> Self {
            self.inner = self.inner.treatments(input);
            self
        }
        /// <p>An array of structures that define the variations being tested in the experiment.</p>
        pub fn set_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        ) -> Self {
            self.inner = self.inner.set_treatments(input);
            self
        }
        /// Appends an item to `metricGoals`.
        ///
        /// To override the contents of this collection use [`set_metric_goals`](Self::set_metric_goals).
        ///
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn metric_goals(mut self, input: crate::model::MetricGoalConfig) -> Self {
            self.inner = self.inner.metric_goals(input);
            self
        }
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn set_metric_goals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_goals(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.inner = self.inner.sampling_rate(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn online_ab_config(mut self, input: crate::model::OnlineAbConfig) -> Self {
            self.inner = self.inner.online_ab_config(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn set_online_ab_config(
            mut self,
            input: std::option::Option<crate::model::OnlineAbConfig>,
        ) -> Self {
            self.inner = self.inner.set_online_ab_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFeature`.
    ///
    /// <p>Updates an existing feature.</p>
    /// <p>You can't use this operation to update the tags of an existing feature. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFeature {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_feature_input::Builder,
    }
    impl UpdateFeature {
        /// Creates a new `UpdateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFeatureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature to be updated.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature to be updated.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature to be updated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature to be updated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.inner = self.inner.evaluation_strategy(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_strategy(input);
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `addOrUpdateVariations`.
        ///
        /// To override the contents of this collection use [`set_add_or_update_variations`](Self::set_add_or_update_variations).
        ///
        /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
        pub fn add_or_update_variations(mut self, input: crate::model::VariationConfig) -> Self {
            self.inner = self.inner.add_or_update_variations(input);
            self
        }
        /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
        pub fn set_add_or_update_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_add_or_update_variations(input);
            self
        }
        /// Appends an item to `removeVariations`.
        ///
        /// To override the contents of this collection use [`set_remove_variations`](Self::set_remove_variations).
        ///
        /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
        /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
        pub fn remove_variations(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_variations(input.into());
            self
        }
        /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
        /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
        pub fn set_remove_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_variations(input);
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_variation(input.into());
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_variation(input);
            self
        }
        /// Adds a key-value pair to `entityOverrides`.
        ///
        /// To override the contents of this collection use [`set_entity_overrides`](Self::set_entity_overrides).
        ///
        /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn entity_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.entity_overrides(k.into(), v.into());
            self
        }
        /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn set_entity_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entity_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunch`.
    ///
    /// <p>Updates a launch of a given feature. </p>
    /// <p>Don't use this operation to update the tags of an existing launch. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLaunch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_launch_input::Builder,
    }
    impl UpdateLaunch {
        /// Creates a new `UpdateLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch that is to be updated.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch that is to be updated.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn groups(mut self, input: crate::model::LaunchGroupConfig) -> Self {
            self.inner = self.inner.groups(input);
            self
        }
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// Appends an item to `metricMonitors`.
        ///
        /// To override the contents of this collection use [`set_metric_monitors`](Self::set_metric_monitors).
        ///
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn metric_monitors(mut self, input: crate::model::MetricMonitorConfig) -> Self {
            self.inner = self.inner.metric_monitors(input);
            self
        }
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn set_metric_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_monitors(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn scheduled_splits_config(
            mut self,
            input: crate::model::ScheduledSplitsLaunchConfig,
        ) -> Self {
            self.inner = self.inner.scheduled_splits_config(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn set_scheduled_splits_config(
            mut self,
            input: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_splits_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Updates the description of an existing project.</p>
    /// <p>To create a new project, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html">CreateProject</a>.</p>
    /// <p>Don't use this operation to update the data storage options of a project. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html">UpdateProjectDataDelivery</a>. </p>
    /// <p>Don't use this operation to update the tags of a project. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_project_input::Builder,
    }
    impl UpdateProject {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProjectDataDelivery`.
    ///
    /// <p>Updates the data storage options for this project. If you store evaluation events, you an keep them and analyze them on your own. If you choose not to store evaluation events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
    /// <p>You can't specify both <code>cloudWatchLogs</code> and <code>s3Destination</code> in the same operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProjectDataDelivery {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_project_data_delivery_input::Builder,
    }
    impl UpdateProjectDataDelivery {
        /// Creates a new `UpdateProjectDataDelivery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectDataDeliveryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectDataDeliveryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
        pub fn s3_destination(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.inner = self.inner.s3_destination(input);
            self
        }
        /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
        /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
        pub fn cloud_watch_logs(
            mut self,
            input: crate::model::CloudWatchLogsDestinationConfig,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs(input);
            self
        }
        /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
