// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchEvaluateFeatureInput`](crate::input::BatchEvaluateFeatureInput)
pub mod batch_evaluate_feature_input {
    /// A builder for [`BatchEvaluateFeatureInput`](crate::input::BatchEvaluateFeatureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) requests: std::option::Option<std::vec::Vec<crate::model::EvaluationRequest>>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// Appends an item to `requests`.
        ///
        /// To override the contents of this collection use [`set_requests`](Self::set_requests).
        ///
        /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
        pub fn requests(mut self, input: crate::model::EvaluationRequest) -> Self {
            let mut v = self.requests.unwrap_or_default();
            v.push(input);
            self.requests = Some(v);
            self
        }
        /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
        pub fn set_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationRequest>>,
        ) -> Self {
            self.requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEvaluateFeatureInput`](crate::input::BatchEvaluateFeatureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchEvaluateFeatureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchEvaluateFeatureInput {
                project: self.project,
                requests: self.requests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchEvaluateFeatureInputOperationOutputAlias = crate::operation::BatchEvaluateFeature;
#[doc(hidden)]
pub type BatchEvaluateFeatureInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchEvaluateFeatureInput {
    /// Consumes the builder and constructs an Operation<[`BatchEvaluateFeature`](crate::operation::BatchEvaluateFeature)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchEvaluateFeature,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchEvaluateFeatureInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.project;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_1, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}/evaluations", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchEvaluateFeatureInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_evaluate_feature(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("dataplane.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchEvaluateFeature::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchEvaluateFeature",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchEvaluateFeatureInput`](crate::input::BatchEvaluateFeatureInput)
    pub fn builder() -> crate::input::batch_evaluate_feature_input::Builder {
        crate::input::batch_evaluate_feature_input::Builder::default()
    }
}

/// See [`CreateExperimentInput`](crate::input::CreateExperimentInput)
pub mod create_experiment_input {
    /// A builder for [`CreateExperimentInput`](crate::input::CreateExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) treatments: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        pub(crate) metric_goals: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        pub(crate) randomization_salt: std::option::Option<std::string::String>,
        pub(crate) sampling_rate: std::option::Option<i64>,
        pub(crate) online_ab_config: std::option::Option<crate::model::OnlineAbConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>A name for the new experiment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the new experiment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `treatments`.
        ///
        /// To override the contents of this collection use [`set_treatments`](Self::set_treatments).
        ///
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn treatments(mut self, input: crate::model::TreatmentConfig) -> Self {
            let mut v = self.treatments.unwrap_or_default();
            v.push(input);
            self.treatments = Some(v);
            self
        }
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn set_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        ) -> Self {
            self.treatments = input;
            self
        }
        /// Appends an item to `metric_goals`.
        ///
        /// To override the contents of this collection use [`set_metric_goals`](Self::set_metric_goals).
        ///
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn metric_goals(mut self, input: crate::model::MetricGoalConfig) -> Self {
            let mut v = self.metric_goals.unwrap_or_default();
            v.push(input);
            self.metric_goals = Some(v);
            self
        }
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn set_metric_goals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        ) -> Self {
            self.metric_goals = input;
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.randomization_salt = Some(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.randomization_salt = input;
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.sampling_rate = Some(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.sampling_rate = input;
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn online_ab_config(mut self, input: crate::model::OnlineAbConfig) -> Self {
            self.online_ab_config = Some(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn set_online_ab_config(
            mut self,
            input: std::option::Option<crate::model::OnlineAbConfig>,
        ) -> Self {
            self.online_ab_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an experiment.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an experiment.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExperimentInput`](crate::input::CreateExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateExperimentInput {
                project: self.project,
                name: self.name,
                description: self.description,
                treatments: self.treatments,
                metric_goals: self.metric_goals,
                randomization_salt: self.randomization_salt,
                sampling_rate: self.sampling_rate,
                online_ab_config: self.online_ab_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateExperimentInputOperationOutputAlias = crate::operation::CreateExperiment;
#[doc(hidden)]
pub type CreateExperimentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateExperimentInput {
    /// Consumes the builder and constructs an Operation<[`CreateExperiment`](crate::operation::CreateExperiment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateExperiment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateExperimentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.project;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_2, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}/experiments", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateExperimentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_experiment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateExperiment",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateExperimentInput`](crate::input::CreateExperimentInput)
    pub fn builder() -> crate::input::create_experiment_input::Builder {
        crate::input::create_experiment_input::Builder::default()
    }
}

/// See [`CreateFeatureInput`](crate::input::CreateFeatureInput)
pub mod create_feature_input {
    /// A builder for [`CreateFeatureInput`](crate::input::CreateFeatureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) evaluation_strategy:
            std::option::Option<crate::model::FeatureEvaluationStrategy>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) variations: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        pub(crate) default_variation: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) entity_overrides: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name or ARN of the project that is to contain the new feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that is to contain the new feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name for the new feature.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new feature.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.evaluation_strategy = Some(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.evaluation_strategy = input;
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `variations`.
        ///
        /// To override the contents of this collection use [`set_variations`](Self::set_variations).
        ///
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn variations(mut self, input: crate::model::VariationConfig) -> Self {
            let mut v = self.variations.unwrap_or_default();
            v.push(input);
            self.variations = Some(v);
            self
        }
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn set_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        ) -> Self {
            self.variations = input;
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_variation = Some(input.into());
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_variation = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a feature.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a feature.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `entity_overrides`.
        ///
        /// To override the contents of this collection use [`set_entity_overrides`](Self::set_entity_overrides).
        ///
        /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn entity_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.entity_overrides.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.entity_overrides = Some(hash_map);
            self
        }
        /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn set_entity_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.entity_overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFeatureInput`](crate::input::CreateFeatureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFeatureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFeatureInput {
                project: self.project,
                name: self.name,
                evaluation_strategy: self.evaluation_strategy,
                description: self.description,
                variations: self.variations,
                default_variation: self.default_variation,
                tags: self.tags,
                entity_overrides: self.entity_overrides,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFeatureInputOperationOutputAlias = crate::operation::CreateFeature;
#[doc(hidden)]
pub type CreateFeatureInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFeatureInput {
    /// Consumes the builder and constructs an Operation<[`CreateFeature`](crate::operation::CreateFeature)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFeature,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFeatureInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.project;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_3, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}/features", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFeatureInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_feature(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFeature::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFeature",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFeatureInput`](crate::input::CreateFeatureInput)
    pub fn builder() -> crate::input::create_feature_input::Builder {
        crate::input::create_feature_input::Builder::default()
    }
}

/// See [`CreateLaunchInput`](crate::input::CreateLaunchInput)
pub mod create_launch_input {
    /// A builder for [`CreateLaunchInput`](crate::input::CreateLaunchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) scheduled_splits_config:
            std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
        pub(crate) metric_monitors:
            std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        pub(crate) randomization_salt: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name or ARN of the project that you want to create the launch in.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to create the launch in.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name for the new launch.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new launch.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn scheduled_splits_config(
            mut self,
            input: crate::model::ScheduledSplitsLaunchConfig,
        ) -> Self {
            self.scheduled_splits_config = Some(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn set_scheduled_splits_config(
            mut self,
            input: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
        ) -> Self {
            self.scheduled_splits_config = input;
            self
        }
        /// Appends an item to `metric_monitors`.
        ///
        /// To override the contents of this collection use [`set_metric_monitors`](Self::set_metric_monitors).
        ///
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn metric_monitors(mut self, input: crate::model::MetricMonitorConfig) -> Self {
            let mut v = self.metric_monitors.unwrap_or_default();
            v.push(input);
            self.metric_monitors = Some(v);
            self
        }
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn set_metric_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        ) -> Self {
            self.metric_monitors = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn groups(mut self, input: crate::model::LaunchGroupConfig) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.randomization_salt = Some(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.randomization_salt = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a launch.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a launch.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLaunchInput`](crate::input::CreateLaunchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLaunchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLaunchInput {
                project: self.project,
                name: self.name,
                description: self.description,
                scheduled_splits_config: self.scheduled_splits_config,
                metric_monitors: self.metric_monitors,
                groups: self.groups,
                randomization_salt: self.randomization_salt,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLaunchInputOperationOutputAlias = crate::operation::CreateLaunch;
#[doc(hidden)]
pub type CreateLaunchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLaunchInput {
    /// Consumes the builder and constructs an Operation<[`CreateLaunch`](crate::operation::CreateLaunch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLaunch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLaunchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.project;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_4, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}/launches", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLaunchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_launch(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLaunch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLaunch",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLaunchInput`](crate::input::CreateLaunchInput)
    pub fn builder() -> crate::input::create_launch_input::Builder {
        crate::input::create_launch_input::Builder::default()
    }
}

/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_delivery: std::option::Option<crate::model::ProjectDataDeliveryConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name for the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
        pub fn data_delivery(mut self, input: crate::model::ProjectDataDeliveryConfig) -> Self {
            self.data_delivery = Some(input);
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
        pub fn set_data_delivery(
            mut self,
            input: std::option::Option<crate::model::ProjectDataDeliveryConfig>,
        ) -> Self {
            self.data_delivery = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a project.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a project.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                name: self.name,
                description: self.description,
                data_delivery: self.data_delivery,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateProjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/projects").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateProjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_project(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
pub mod delete_experiment_input {
    /// A builder for [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) experiment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the experiment to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment = Some(input.into());
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.experiment = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteExperimentInput {
                project: self.project,
                experiment: self.experiment,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteExperimentInputOperationOutputAlias = crate::operation::DeleteExperiment;
#[doc(hidden)]
pub type DeleteExperimentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteExperimentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteExperiment`](crate::operation::DeleteExperiment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteExperiment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteExperimentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.project;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_5, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_6 = &_input.experiment;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    },
                )?;
                let experiment = aws_smithy_http::label::fmt_string(input_6, false);
                if experiment.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/experiments/{experiment}",
                    project = project,
                    experiment = experiment
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteExperimentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteExperiment",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
    pub fn builder() -> crate::input::delete_experiment_input::Builder {
        crate::input::delete_experiment_input::Builder::default()
    }
}

/// See [`DeleteFeatureInput`](crate::input::DeleteFeatureInput)
pub mod delete_feature_input {
    /// A builder for [`DeleteFeatureInput`](crate::input::DeleteFeatureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) feature: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the feature to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the feature to delete.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The name of the feature to delete.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFeatureInput`](crate::input::DeleteFeatureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFeatureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFeatureInput {
                project: self.project,
                feature: self.feature,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFeatureInputOperationOutputAlias = crate::operation::DeleteFeature;
#[doc(hidden)]
pub type DeleteFeatureInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFeatureInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFeature`](crate::operation::DeleteFeature)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFeature,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFeatureInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.project;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_7, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_8 = &_input.feature;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    },
                )?;
                let feature = aws_smithy_http::label::fmt_string(input_8, false);
                if feature.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/features/{feature}",
                    project = project,
                    feature = feature
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFeatureInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFeature::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFeature",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFeatureInput`](crate::input::DeleteFeatureInput)
    pub fn builder() -> crate::input::delete_feature_input::Builder {
        crate::input::delete_feature_input::Builder::default()
    }
}

/// See [`DeleteLaunchInput`](crate::input::DeleteLaunchInput)
pub mod delete_launch_input {
    /// A builder for [`DeleteLaunchInput`](crate::input::DeleteLaunchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) launch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the launch to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the launch to delete.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch = Some(input.into());
            self
        }
        /// <p>The name of the launch to delete.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLaunchInput`](crate::input::DeleteLaunchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLaunchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLaunchInput {
                project: self.project,
                launch: self.launch,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLaunchInputOperationOutputAlias = crate::operation::DeleteLaunch;
#[doc(hidden)]
pub type DeleteLaunchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLaunchInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLaunch`](crate::operation::DeleteLaunch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLaunch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLaunchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.project;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_9, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_10 = &_input.launch;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch = aws_smithy_http::label::fmt_string(input_10, false);
                if launch.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/launches/{launch}",
                    project = project,
                    launch = launch
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLaunchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLaunch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLaunch",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLaunchInput`](crate::input::DeleteLaunchInput)
    pub fn builder() -> crate::input::delete_launch_input::Builder {
        crate::input::delete_launch_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput {
                project: self.project,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.project;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_11, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`EvaluateFeatureInput`](crate::input::EvaluateFeatureInput)
pub mod evaluate_feature_input {
    /// A builder for [`EvaluateFeatureInput`](crate::input::EvaluateFeatureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) feature: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) evaluation_context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains this feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains this feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn evaluation_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_context = Some(input.into());
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn set_evaluation_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_context = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluateFeatureInput`](crate::input::EvaluateFeatureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EvaluateFeatureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EvaluateFeatureInput {
                project: self.project,
                feature: self.feature,
                entity_id: self.entity_id,
                evaluation_context: self.evaluation_context,
            })
        }
    }
}
#[doc(hidden)]
pub type EvaluateFeatureInputOperationOutputAlias = crate::operation::EvaluateFeature;
#[doc(hidden)]
pub type EvaluateFeatureInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EvaluateFeatureInput {
    /// Consumes the builder and constructs an Operation<[`EvaluateFeature`](crate::operation::EvaluateFeature)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EvaluateFeature,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::EvaluateFeatureInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.project;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_12, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.feature;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    },
                )?;
                let feature = aws_smithy_http::label::fmt_string(input_13, false);
                if feature.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/evaluations/{feature}",
                    project = project,
                    feature = feature
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EvaluateFeatureInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_evaluate_feature(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("dataplane.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EvaluateFeature::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EvaluateFeature",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EvaluateFeatureInput`](crate::input::EvaluateFeatureInput)
    pub fn builder() -> crate::input::evaluate_feature_input::Builder {
        crate::input::evaluate_feature_input::Builder::default()
    }
}

/// See [`GetExperimentInput`](crate::input::GetExperimentInput)
pub mod get_experiment_input {
    /// A builder for [`GetExperimentInput`](crate::input::GetExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) experiment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the experiment.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the experiment that you want to see the details of.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment = Some(input.into());
            self
        }
        /// <p>The name of the experiment that you want to see the details of.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.experiment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExperimentInput`](crate::input::GetExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExperimentInput {
                project: self.project,
                experiment: self.experiment,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExperimentInputOperationOutputAlias = crate::operation::GetExperiment;
#[doc(hidden)]
pub type GetExperimentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetExperimentInput {
    /// Consumes the builder and constructs an Operation<[`GetExperiment`](crate::operation::GetExperiment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExperiment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetExperimentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.project;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_14, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_15 = &_input.experiment;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    },
                )?;
                let experiment = aws_smithy_http::label::fmt_string(input_15, false);
                if experiment.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/experiments/{experiment}",
                    project = project,
                    experiment = experiment
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetExperimentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExperiment",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetExperimentInput`](crate::input::GetExperimentInput)
    pub fn builder() -> crate::input::get_experiment_input::Builder {
        crate::input::get_experiment_input::Builder::default()
    }
}

/// See [`GetExperimentResultsInput`](crate::input::GetExperimentResultsInput)
pub mod get_experiment_results_input {
    /// A builder for [`GetExperimentResultsInput`](crate::input::GetExperimentResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) experiment: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) metric_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) treatment_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) base_stat: std::option::Option<crate::model::ExperimentBaseStat>,
        pub(crate) result_stats:
            std::option::Option<std::vec::Vec<crate::model::ExperimentResultRequestType>>,
        pub(crate) report_names:
            std::option::Option<std::vec::Vec<crate::model::ExperimentReportName>>,
        pub(crate) period: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the experiment to retrieve the results of.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment = Some(input.into());
            self
        }
        /// <p>The name of the experiment to retrieve the results of.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.experiment = input;
            self
        }
        /// <p>The date and time that the experiment started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that the experiment started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time that the experiment ended, if it is completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time that the experiment ended, if it is completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Appends an item to `metric_names`.
        ///
        /// To override the contents of this collection use [`set_metric_names`](Self::set_metric_names).
        ///
        /// <p>The names of the experiment metrics that you want to see the results of.</p>
        pub fn metric_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metric_names.unwrap_or_default();
            v.push(input.into());
            self.metric_names = Some(v);
            self
        }
        /// <p>The names of the experiment metrics that you want to see the results of.</p>
        pub fn set_metric_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metric_names = input;
            self
        }
        /// Appends an item to `treatment_names`.
        ///
        /// To override the contents of this collection use [`set_treatment_names`](Self::set_treatment_names).
        ///
        /// <p>The names of the experiment treatments that you want to see the results for.</p>
        pub fn treatment_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.treatment_names.unwrap_or_default();
            v.push(input.into());
            self.treatment_names = Some(v);
            self
        }
        /// <p>The names of the experiment treatments that you want to see the results for.</p>
        pub fn set_treatment_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.treatment_names = input;
            self
        }
        /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
        pub fn base_stat(mut self, input: crate::model::ExperimentBaseStat) -> Self {
            self.base_stat = Some(input);
            self
        }
        /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
        pub fn set_base_stat(
            mut self,
            input: std::option::Option<crate::model::ExperimentBaseStat>,
        ) -> Self {
            self.base_stat = input;
            self
        }
        /// Appends an item to `result_stats`.
        ///
        /// To override the contents of this collection use [`set_result_stats`](Self::set_result_stats).
        ///
        /// <p>The statistics that you want to see in the returned results.</p>
        /// <ul>
        /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
        /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
        /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
        /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
        /// </ul>
        pub fn result_stats(mut self, input: crate::model::ExperimentResultRequestType) -> Self {
            let mut v = self.result_stats.unwrap_or_default();
            v.push(input);
            self.result_stats = Some(v);
            self
        }
        /// <p>The statistics that you want to see in the returned results.</p>
        /// <ul>
        /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
        /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
        /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
        /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
        /// </ul>
        pub fn set_result_stats(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentResultRequestType>>,
        ) -> Self {
            self.result_stats = input;
            self
        }
        /// Appends an item to `report_names`.
        ///
        /// To override the contents of this collection use [`set_report_names`](Self::set_report_names).
        ///
        /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
        pub fn report_names(mut self, input: crate::model::ExperimentReportName) -> Self {
            let mut v = self.report_names.unwrap_or_default();
            v.push(input);
            self.report_names = Some(v);
            self
        }
        /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
        pub fn set_report_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentReportName>>,
        ) -> Self {
            self.report_names = input;
            self
        }
        /// <p>In seconds, the amount of time to aggregate results together. </p>
        pub fn period(mut self, input: i64) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>In seconds, the amount of time to aggregate results together. </p>
        pub fn set_period(mut self, input: std::option::Option<i64>) -> Self {
            self.period = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExperimentResultsInput`](crate::input::GetExperimentResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExperimentResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExperimentResultsInput {
                project: self.project,
                experiment: self.experiment,
                start_time: self.start_time,
                end_time: self.end_time,
                metric_names: self.metric_names,
                treatment_names: self.treatment_names,
                base_stat: self.base_stat,
                result_stats: self.result_stats,
                report_names: self.report_names,
                period: self.period.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetExperimentResultsInputOperationOutputAlias = crate::operation::GetExperimentResults;
#[doc(hidden)]
pub type GetExperimentResultsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetExperimentResultsInput {
    /// Consumes the builder and constructs an Operation<[`GetExperimentResults`](crate::operation::GetExperimentResults)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExperimentResults,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetExperimentResultsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.project;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_16, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_17 = &_input.experiment;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    },
                )?;
                let experiment = aws_smithy_http::label::fmt_string(input_17, false);
                if experiment.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/experiments/{experiment}/results",
                    project = project,
                    experiment = experiment
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetExperimentResultsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_experiment_results(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExperimentResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExperimentResults",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetExperimentResultsInput`](crate::input::GetExperimentResultsInput)
    pub fn builder() -> crate::input::get_experiment_results_input::Builder {
        crate::input::get_experiment_results_input::Builder::default()
    }
}

/// See [`GetFeatureInput`](crate::input::GetFeatureInput)
pub mod get_feature_input {
    /// A builder for [`GetFeatureInput`](crate::input::GetFeatureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) feature: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the feature that you want to retrieve information for.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The name of the feature that you want to retrieve information for.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFeatureInput`](crate::input::GetFeatureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFeatureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFeatureInput {
                project: self.project,
                feature: self.feature,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFeatureInputOperationOutputAlias = crate::operation::GetFeature;
#[doc(hidden)]
pub type GetFeatureInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFeatureInput {
    /// Consumes the builder and constructs an Operation<[`GetFeature`](crate::operation::GetFeature)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFeature,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFeatureInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.project;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_18, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_19 = &_input.feature;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    },
                )?;
                let feature = aws_smithy_http::label::fmt_string(input_19, false);
                if feature.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/features/{feature}",
                    project = project,
                    feature = feature
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFeatureInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFeature::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFeature",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFeatureInput`](crate::input::GetFeatureInput)
    pub fn builder() -> crate::input::get_feature_input::Builder {
        crate::input::get_feature_input::Builder::default()
    }
}

/// See [`GetLaunchInput`](crate::input::GetLaunchInput)
pub mod get_launch_input {
    /// A builder for [`GetLaunchInput`](crate::input::GetLaunchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) launch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the launch that you want to see the details of.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch = Some(input.into());
            self
        }
        /// <p>The name of the launch that you want to see the details of.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchInput`](crate::input::GetLaunchInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetLaunchInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetLaunchInput {
                project: self.project,
                launch: self.launch,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLaunchInputOperationOutputAlias = crate::operation::GetLaunch;
#[doc(hidden)]
pub type GetLaunchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLaunchInput {
    /// Consumes the builder and constructs an Operation<[`GetLaunch`](crate::operation::GetLaunch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLaunch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLaunchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.project;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_20, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.launch;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch = aws_smithy_http::label::fmt_string(input_21, false);
                if launch.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/launches/{launch}",
                    project = project,
                    launch = launch
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLaunchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetLaunch::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetLaunch",
                    "evidently",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLaunchInput`](crate::input::GetLaunchInput)
    pub fn builder() -> crate::input::get_launch_input::Builder {
        crate::input::get_launch_input::Builder::default()
    }
}

/// See [`GetProjectInput`](crate::input::GetProjectInput)
pub mod get_project_input {
    /// A builder for [`GetProjectInput`](crate::input::GetProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that you want to see the details of.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to see the details of.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProjectInput`](crate::input::GetProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProjectInput {
                project: self.project,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProjectInputOperationOutputAlias = crate::operation::GetProject;
#[doc(hidden)]
pub type GetProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetProjectInput {
    /// Consumes the builder and constructs an Operation<[`GetProject`](crate::operation::GetProject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetProjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.project;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_22, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetProjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProject",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetProjectInput`](crate::input::GetProjectInput)
    pub fn builder() -> crate::input::get_project_input::Builder {
        crate::input::get_project_input::Builder::default()
    }
}

/// See [`ListExperimentsInput`](crate::input::ListExperimentsInput)
pub mod list_experiments_input {
    /// A builder for [`ListExperimentsInput`](crate::input::ListExperimentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ExperimentStatus>,
    }
    impl Builder {
        /// <p>The name or ARN of the project to return the experiment list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the experiment list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the experiments with the status that you specify here.</p>
        pub fn status(mut self, input: crate::model::ExperimentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the experiments with the status that you specify here.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExperimentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExperimentsInput`](crate::input::ListExperimentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExperimentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExperimentsInput {
                project: self.project,
                max_results: self.max_results,
                next_token: self.next_token,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExperimentsInputOperationOutputAlias = crate::operation::ListExperiments;
#[doc(hidden)]
pub type ListExperimentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListExperimentsInput {
    /// Consumes the builder and constructs an Operation<[`ListExperiments`](crate::operation::ListExperiments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExperiments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListExperimentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.project;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_23, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}/experiments", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListExperimentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_24) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_24).encode(),
                    );
                }
                if let Some(inner_25) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
                }
                if let Some(inner_26) = &_input.status {
                    query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_26));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListExperimentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExperiments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExperiments",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListExperimentsInput`](crate::input::ListExperimentsInput)
    pub fn builder() -> crate::input::list_experiments_input::Builder {
        crate::input::list_experiments_input::Builder::default()
    }
}

/// See [`ListFeaturesInput`](crate::input::ListFeaturesInput)
pub mod list_features_input {
    /// A builder for [`ListFeaturesInput`](crate::input::ListFeaturesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project to return the feature list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the feature list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFeaturesInput`](crate::input::ListFeaturesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFeaturesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFeaturesInput {
                project: self.project,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFeaturesInputOperationOutputAlias = crate::operation::ListFeatures;
#[doc(hidden)]
pub type ListFeaturesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFeaturesInput {
    /// Consumes the builder and constructs an Operation<[`ListFeatures`](crate::operation::ListFeatures)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFeatures,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFeaturesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.project;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_27, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}/features", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFeaturesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_28) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                    );
                }
                if let Some(inner_29) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_29));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFeaturesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFeatures::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFeatures",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFeaturesInput`](crate::input::ListFeaturesInput)
    pub fn builder() -> crate::input::list_features_input::Builder {
        crate::input::list_features_input::Builder::default()
    }
}

/// See [`ListLaunchesInput`](crate::input::ListLaunchesInput)
pub mod list_launches_input {
    /// A builder for [`ListLaunchesInput`](crate::input::ListLaunchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::LaunchStatus>,
    }
    impl Builder {
        /// <p>The name or ARN of the project to return the launch list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the launch list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the launches with the status that you specify here.</p>
        pub fn status(mut self, input: crate::model::LaunchStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Use this optional parameter to limit the returned results to only the launches with the status that you specify here.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LaunchStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLaunchesInput`](crate::input::ListLaunchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLaunchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLaunchesInput {
                project: self.project,
                max_results: self.max_results,
                next_token: self.next_token,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLaunchesInputOperationOutputAlias = crate::operation::ListLaunches;
#[doc(hidden)]
pub type ListLaunchesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLaunchesInput {
    /// Consumes the builder and constructs an Operation<[`ListLaunches`](crate::operation::ListLaunches)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLaunches,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLaunchesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.project;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_30, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}/launches", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListLaunchesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_31) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_31).encode(),
                    );
                }
                if let Some(inner_32) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                if let Some(inner_33) = &_input.status {
                    query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_33));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLaunchesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLaunches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLaunches",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLaunchesInput`](crate::input::ListLaunchesInput)
    pub fn builder() -> crate::input::list_launches_input::Builder {
        crate::input::list_launches_input::Builder::default()
    }
}

/// See [`ListProjectsInput`](crate::input::ListProjectsInput)
pub mod list_projects_input {
    /// A builder for [`ListProjectsInput`](crate::input::ListProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsInput`](crate::input::ListProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectsInputOperationOutputAlias = crate::operation::ListProjects;
#[doc(hidden)]
pub type ListProjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjects`](crate::operation::ListProjects)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProjectsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/projects").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProjectsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_34) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                    );
                }
                if let Some(inner_35) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_35));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProjectsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjects",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.resource_arn;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_36, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutProjectEventsInput`](crate::input::PutProjectEventsInput)
pub mod put_project_events_input {
    /// A builder for [`PutProjectEventsInput`](crate::input::PutProjectEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// <p>The name or ARN of the project to write the events to.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project to write the events to.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProjectEventsInput`](crate::input::PutProjectEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutProjectEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutProjectEventsInput {
                project: self.project,
                events: self.events,
            })
        }
    }
}
#[doc(hidden)]
pub type PutProjectEventsInputOperationOutputAlias = crate::operation::PutProjectEvents;
#[doc(hidden)]
pub type PutProjectEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutProjectEventsInput {
    /// Consumes the builder and constructs an Operation<[`PutProjectEvents`](crate::operation::PutProjectEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutProjectEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutProjectEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.project;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_37, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/events/projects/{project}", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutProjectEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_project_events(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("dataplane.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutProjectEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutProjectEvents",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutProjectEventsInput`](crate::input::PutProjectEventsInput)
    pub fn builder() -> crate::input::put_project_events_input::Builder {
        crate::input::put_project_events_input::Builder::default()
    }
}

/// See [`StartExperimentInput`](crate::input::StartExperimentInput)
pub mod start_experiment_input {
    /// A builder for [`StartExperimentInput`](crate::input::StartExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) experiment: std::option::Option<std::string::String>,
        pub(crate) analysis_complete_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the experiment to start.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to start.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the experiment to start.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment = Some(input.into());
            self
        }
        /// <p>The name of the experiment to start.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.experiment = input;
            self
        }
        /// <p>The date and time to end the experiment.</p>
        pub fn analysis_complete_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.analysis_complete_time = Some(input);
            self
        }
        /// <p>The date and time to end the experiment.</p>
        pub fn set_analysis_complete_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.analysis_complete_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExperimentInput`](crate::input::StartExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartExperimentInput {
                project: self.project,
                experiment: self.experiment,
                analysis_complete_time: self.analysis_complete_time,
            })
        }
    }
}
#[doc(hidden)]
pub type StartExperimentInputOperationOutputAlias = crate::operation::StartExperiment;
#[doc(hidden)]
pub type StartExperimentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartExperimentInput {
    /// Consumes the builder and constructs an Operation<[`StartExperiment`](crate::operation::StartExperiment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartExperiment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartExperimentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.project;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_38, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.experiment;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    },
                )?;
                let experiment = aws_smithy_http::label::fmt_string(input_39, false);
                if experiment.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/experiments/{experiment}/start",
                    project = project,
                    experiment = experiment
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartExperimentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_experiment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartExperiment",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartExperimentInput`](crate::input::StartExperimentInput)
    pub fn builder() -> crate::input::start_experiment_input::Builder {
        crate::input::start_experiment_input::Builder::default()
    }
}

/// See [`StartLaunchInput`](crate::input::StartLaunchInput)
pub mod start_launch_input {
    /// A builder for [`StartLaunchInput`](crate::input::StartLaunchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) launch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the launch to start.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch to start.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the launch to start.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch = Some(input.into());
            self
        }
        /// <p>The name of the launch to start.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch = input;
            self
        }
        /// Consumes the builder and constructs a [`StartLaunchInput`](crate::input::StartLaunchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartLaunchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartLaunchInput {
                project: self.project,
                launch: self.launch,
            })
        }
    }
}
#[doc(hidden)]
pub type StartLaunchInputOperationOutputAlias = crate::operation::StartLaunch;
#[doc(hidden)]
pub type StartLaunchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartLaunchInput {
    /// Consumes the builder and constructs an Operation<[`StartLaunch`](crate::operation::StartLaunch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartLaunch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartLaunchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.project;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_40, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_41 = &_input.launch;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch = aws_smithy_http::label::fmt_string(input_41, false);
                if launch.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/launches/{launch}/start",
                    project = project,
                    launch = launch
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartLaunchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartLaunch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartLaunch",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartLaunchInput`](crate::input::StartLaunchInput)
    pub fn builder() -> crate::input::start_launch_input::Builder {
        crate::input::start_launch_input::Builder::default()
    }
}

/// See [`StopExperimentInput`](crate::input::StopExperimentInput)
pub mod stop_experiment_input {
    /// A builder for [`StopExperimentInput`](crate::input::StopExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) experiment: std::option::Option<std::string::String>,
        pub(crate) desired_state: std::option::Option<crate::model::ExperimentStopDesiredState>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the experiment to stop.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to stop.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the experiment to stop.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment = Some(input.into());
            self
        }
        /// <p>The name of the experiment to stop.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.experiment = input;
            self
        }
        /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn desired_state(mut self, input: crate::model::ExperimentStopDesiredState) -> Self {
            self.desired_state = Some(input);
            self
        }
        /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::ExperimentStopDesiredState>,
        ) -> Self {
            self.desired_state = input;
            self
        }
        /// <p>A string that describes why you are stopping the experiment.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A string that describes why you are stopping the experiment.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`StopExperimentInput`](crate::input::StopExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopExperimentInput {
                project: self.project,
                experiment: self.experiment,
                desired_state: self.desired_state,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type StopExperimentInputOperationOutputAlias = crate::operation::StopExperiment;
#[doc(hidden)]
pub type StopExperimentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopExperimentInput {
    /// Consumes the builder and constructs an Operation<[`StopExperiment`](crate::operation::StopExperiment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopExperiment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopExperimentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.project;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_42, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_43 = &_input.experiment;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    },
                )?;
                let experiment = aws_smithy_http::label::fmt_string(input_43, false);
                if experiment.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/experiments/{experiment}/cancel",
                    project = project,
                    experiment = experiment
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopExperimentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_experiment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopExperiment",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopExperimentInput`](crate::input::StopExperimentInput)
    pub fn builder() -> crate::input::stop_experiment_input::Builder {
        crate::input::stop_experiment_input::Builder::default()
    }
}

/// See [`StopLaunchInput`](crate::input::StopLaunchInput)
pub mod stop_launch_input {
    /// A builder for [`StopLaunchInput`](crate::input::StopLaunchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) launch: std::option::Option<std::string::String>,
        pub(crate) desired_state: std::option::Option<crate::model::LaunchStopDesiredState>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the launch to stop.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch = Some(input.into());
            self
        }
        /// <p>The name of the launch to stop.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch = input;
            self
        }
        /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn desired_state(mut self, input: crate::model::LaunchStopDesiredState) -> Self {
            self.desired_state = Some(input);
            self
        }
        /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::LaunchStopDesiredState>,
        ) -> Self {
            self.desired_state = input;
            self
        }
        /// <p>A string that describes why you are stopping the launch.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A string that describes why you are stopping the launch.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`StopLaunchInput`](crate::input::StopLaunchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopLaunchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopLaunchInput {
                project: self.project,
                launch: self.launch,
                desired_state: self.desired_state,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type StopLaunchInputOperationOutputAlias = crate::operation::StopLaunch;
#[doc(hidden)]
pub type StopLaunchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopLaunchInput {
    /// Consumes the builder and constructs an Operation<[`StopLaunch`](crate::operation::StopLaunch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopLaunch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopLaunchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.project;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_44, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_45 = &_input.launch;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch = aws_smithy_http::label::fmt_string(input_45, false);
                if launch.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/launches/{launch}/cancel",
                    project = project,
                    launch = launch
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopLaunchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_launch(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopLaunch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopLaunch",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopLaunchInput`](crate::input::StopLaunchInput)
    pub fn builder() -> crate::input::stop_launch_input::Builder {
        crate::input::stop_launch_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.resource_arn;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_46, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_47 = &_input.resource_arn;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_47, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_48) = &_input.tag_keys {
                    for inner_49 in inner_48 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_49));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateExperimentInput`](crate::input::UpdateExperimentInput)
pub mod update_experiment_input {
    /// A builder for [`UpdateExperimentInput`](crate::input::UpdateExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) experiment: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) treatments: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        pub(crate) metric_goals: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        pub(crate) randomization_salt: std::option::Option<std::string::String>,
        pub(crate) sampling_rate: std::option::Option<i64>,
        pub(crate) online_ab_config: std::option::Option<crate::model::OnlineAbConfig>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the experiment to update.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment = Some(input.into());
            self
        }
        /// <p>The name of the experiment to update.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.experiment = input;
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `treatments`.
        ///
        /// To override the contents of this collection use [`set_treatments`](Self::set_treatments).
        ///
        /// <p>An array of structures that define the variations being tested in the experiment.</p>
        pub fn treatments(mut self, input: crate::model::TreatmentConfig) -> Self {
            let mut v = self.treatments.unwrap_or_default();
            v.push(input);
            self.treatments = Some(v);
            self
        }
        /// <p>An array of structures that define the variations being tested in the experiment.</p>
        pub fn set_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        ) -> Self {
            self.treatments = input;
            self
        }
        /// Appends an item to `metric_goals`.
        ///
        /// To override the contents of this collection use [`set_metric_goals`](Self::set_metric_goals).
        ///
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn metric_goals(mut self, input: crate::model::MetricGoalConfig) -> Self {
            let mut v = self.metric_goals.unwrap_or_default();
            v.push(input);
            self.metric_goals = Some(v);
            self
        }
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn set_metric_goals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        ) -> Self {
            self.metric_goals = input;
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.randomization_salt = Some(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.randomization_salt = input;
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.sampling_rate = Some(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.sampling_rate = input;
            self
        }
        /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn online_ab_config(mut self, input: crate::model::OnlineAbConfig) -> Self {
            self.online_ab_config = Some(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn set_online_ab_config(
            mut self,
            input: std::option::Option<crate::model::OnlineAbConfig>,
        ) -> Self {
            self.online_ab_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExperimentInput`](crate::input::UpdateExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateExperimentInput {
                project: self.project,
                experiment: self.experiment,
                description: self.description,
                treatments: self.treatments,
                metric_goals: self.metric_goals,
                randomization_salt: self.randomization_salt,
                sampling_rate: self.sampling_rate,
                online_ab_config: self.online_ab_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateExperimentInputOperationOutputAlias = crate::operation::UpdateExperiment;
#[doc(hidden)]
pub type UpdateExperimentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateExperimentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateExperiment`](crate::operation::UpdateExperiment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateExperiment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateExperimentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.project;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_50, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_51 = &_input.experiment;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    },
                )?;
                let experiment = aws_smithy_http::label::fmt_string(input_51, false);
                if experiment.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "experiment",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/experiments/{experiment}",
                    project = project,
                    experiment = experiment
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateExperimentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_experiment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateExperiment",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateExperimentInput`](crate::input::UpdateExperimentInput)
    pub fn builder() -> crate::input::update_experiment_input::Builder {
        crate::input::update_experiment_input::Builder::default()
    }
}

/// See [`UpdateFeatureInput`](crate::input::UpdateFeatureInput)
pub mod update_feature_input {
    /// A builder for [`UpdateFeatureInput`](crate::input::UpdateFeatureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) feature: std::option::Option<std::string::String>,
        pub(crate) evaluation_strategy:
            std::option::Option<crate::model::FeatureEvaluationStrategy>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) add_or_update_variations:
            std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        pub(crate) remove_variations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_variation: std::option::Option<std::string::String>,
        pub(crate) entity_overrides: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the feature to be updated.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature to be updated.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the feature to be updated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The name of the feature to be updated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.evaluation_strategy = Some(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.evaluation_strategy = input;
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `add_or_update_variations`.
        ///
        /// To override the contents of this collection use [`set_add_or_update_variations`](Self::set_add_or_update_variations).
        ///
        /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
        pub fn add_or_update_variations(mut self, input: crate::model::VariationConfig) -> Self {
            let mut v = self.add_or_update_variations.unwrap_or_default();
            v.push(input);
            self.add_or_update_variations = Some(v);
            self
        }
        /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
        pub fn set_add_or_update_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        ) -> Self {
            self.add_or_update_variations = input;
            self
        }
        /// Appends an item to `remove_variations`.
        ///
        /// To override the contents of this collection use [`set_remove_variations`](Self::set_remove_variations).
        ///
        /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
        /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
        pub fn remove_variations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.remove_variations.unwrap_or_default();
            v.push(input.into());
            self.remove_variations = Some(v);
            self
        }
        /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
        /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
        pub fn set_remove_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.remove_variations = input;
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_variation = Some(input.into());
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_variation = input;
            self
        }
        /// Adds a key-value pair to `entity_overrides`.
        ///
        /// To override the contents of this collection use [`set_entity_overrides`](Self::set_entity_overrides).
        ///
        /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn entity_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.entity_overrides.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.entity_overrides = Some(hash_map);
            self
        }
        /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn set_entity_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.entity_overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFeatureInput`](crate::input::UpdateFeatureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFeatureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFeatureInput {
                project: self.project,
                feature: self.feature,
                evaluation_strategy: self.evaluation_strategy,
                description: self.description,
                add_or_update_variations: self.add_or_update_variations,
                remove_variations: self.remove_variations,
                default_variation: self.default_variation,
                entity_overrides: self.entity_overrides,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFeatureInputOperationOutputAlias = crate::operation::UpdateFeature;
#[doc(hidden)]
pub type UpdateFeatureInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFeatureInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFeature`](crate::operation::UpdateFeature)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFeature,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFeatureInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.project;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_52, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_53 = &_input.feature;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    },
                )?;
                let feature = aws_smithy_http::label::fmt_string(input_53, false);
                if feature.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "feature",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/features/{feature}",
                    project = project,
                    feature = feature
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFeatureInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_feature(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFeature::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFeature",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFeatureInput`](crate::input::UpdateFeatureInput)
    pub fn builder() -> crate::input::update_feature_input::Builder {
        crate::input::update_feature_input::Builder::default()
    }
}

/// See [`UpdateLaunchInput`](crate::input::UpdateLaunchInput)
pub mod update_launch_input {
    /// A builder for [`UpdateLaunchInput`](crate::input::UpdateLaunchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) launch: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        pub(crate) metric_monitors:
            std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        pub(crate) randomization_salt: std::option::Option<std::string::String>,
        pub(crate) scheduled_splits_config:
            std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the launch that is to be updated.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch = Some(input.into());
            self
        }
        /// <p>The name of the launch that is to be updated.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch = input;
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn groups(mut self, input: crate::model::LaunchGroupConfig) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Appends an item to `metric_monitors`.
        ///
        /// To override the contents of this collection use [`set_metric_monitors`](Self::set_metric_monitors).
        ///
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn metric_monitors(mut self, input: crate::model::MetricMonitorConfig) -> Self {
            let mut v = self.metric_monitors.unwrap_or_default();
            v.push(input);
            self.metric_monitors = Some(v);
            self
        }
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn set_metric_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        ) -> Self {
            self.metric_monitors = input;
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.randomization_salt = Some(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.randomization_salt = input;
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn scheduled_splits_config(
            mut self,
            input: crate::model::ScheduledSplitsLaunchConfig,
        ) -> Self {
            self.scheduled_splits_config = Some(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn set_scheduled_splits_config(
            mut self,
            input: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
        ) -> Self {
            self.scheduled_splits_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLaunchInput`](crate::input::UpdateLaunchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLaunchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLaunchInput {
                project: self.project,
                launch: self.launch,
                description: self.description,
                groups: self.groups,
                metric_monitors: self.metric_monitors,
                randomization_salt: self.randomization_salt,
                scheduled_splits_config: self.scheduled_splits_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLaunchInputOperationOutputAlias = crate::operation::UpdateLaunch;
#[doc(hidden)]
pub type UpdateLaunchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLaunchInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLaunch`](crate::operation::UpdateLaunch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLaunch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateLaunchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_54 = &_input.project;
                let input_54 = input_54.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_54, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                let input_55 = &_input.launch;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch = aws_smithy_http::label::fmt_string(input_55, false);
                if launch.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/launches/{launch}",
                    project = project,
                    launch = launch
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateLaunchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_launch(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLaunch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLaunch",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateLaunchInput`](crate::input::UpdateLaunchInput)
    pub fn builder() -> crate::input::update_launch_input::Builder {
        crate::input::update_launch_input::Builder::default()
    }
}

/// See [`UpdateProjectInput`](crate::input::UpdateProjectInput)
pub mod update_project_input {
    /// A builder for [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectInput`](crate::input::UpdateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProjectInput {
                project: self.project,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProjectInputOperationOutputAlias = crate::operation::UpdateProject;
#[doc(hidden)]
pub type UpdateProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProjectInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProject`](crate::operation::UpdateProject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateProjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_56 = &_input.project;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_56, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/projects/{project}", project = project)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateProjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_project(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProject",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
}

/// See [`UpdateProjectDataDeliveryInput`](crate::input::UpdateProjectDataDeliveryInput)
pub mod update_project_data_delivery_input {
    /// A builder for [`UpdateProjectDataDeliveryInput`](crate::input::UpdateProjectDataDeliveryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3DestinationConfig>,
        pub(crate) cloud_watch_logs:
            std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
        pub fn s3_destination(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
        pub fn cloud_watch_logs(
            mut self,
            input: crate::model::CloudWatchLogsDestinationConfig,
        ) -> Self {
            self.cloud_watch_logs = Some(input);
            self
        }
        /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
        ) -> Self {
            self.cloud_watch_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectDataDeliveryInput`](crate::input::UpdateProjectDataDeliveryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProjectDataDeliveryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProjectDataDeliveryInput {
                project: self.project,
                s3_destination: self.s3_destination,
                cloud_watch_logs: self.cloud_watch_logs,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProjectDataDeliveryInputOperationOutputAlias =
    crate::operation::UpdateProjectDataDelivery;
#[doc(hidden)]
pub type UpdateProjectDataDeliveryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProjectDataDeliveryInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProjectDataDelivery`](crate::operation::UpdateProjectDataDelivery)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProjectDataDelivery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateProjectDataDeliveryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_57 = &_input.project;
                let input_57 = input_57.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project = aws_smithy_http::label::fmt_string(input_57, false);
                if project.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/projects/{project}/data-delivery",
                    project = project
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateProjectDataDeliveryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_project_data_delivery(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProjectDataDelivery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProjectDataDelivery",
            "evidently",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateProjectDataDeliveryInput`](crate::input::UpdateProjectDataDeliveryInput)
    pub fn builder() -> crate::input::update_project_data_delivery_input::Builder {
        crate::input::update_project_data_delivery_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectDataDeliveryInput {
    /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
    pub s3_destination: std::option::Option<crate::model::S3DestinationConfig>,
    /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
    pub cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
}
impl UpdateProjectDataDeliveryInput {
    /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
    pub fn s3_destination(&self) -> std::option::Option<&crate::model::S3DestinationConfig> {
        self.s3_destination.as_ref()
    }
    /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
    pub fn cloud_watch_logs(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestinationConfig> {
        self.cloud_watch_logs.as_ref()
    }
}
impl std::fmt::Debug for UpdateProjectDataDeliveryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectDataDeliveryInput");
        formatter.field("project", &self.project);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.field("cloud_watch_logs", &self.cloud_watch_logs);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectInput {
    /// <p>The name or ARN of the project to update.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>An optional description of the project.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateProjectInput {
    /// <p>The name or ARN of the project to update.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>An optional description of the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectInput");
        formatter.field("project", &self.project);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProjectEventsInput {
    /// <p>The name or ARN of the project to write the events to.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl PutProjectEventsInput {
    /// <p>The name or ARN of the project to write the events to.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for PutProjectEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProjectEventsInput");
        formatter.field("project", &self.project);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluateFeatureInput {
    /// <p>The name or ARN of the project that contains this feature.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the feature being evaluated.</p>
    pub feature: std::option::Option<std::string::String>,
    /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
    pub evaluation_context: std::option::Option<std::string::String>,
}
impl EvaluateFeatureInput {
    /// <p>The name or ARN of the project that contains this feature.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the feature being evaluated.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
    /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
    pub fn evaluation_context(&self) -> std::option::Option<&str> {
        self.evaluation_context.as_deref()
    }
}
impl std::fmt::Debug for EvaluateFeatureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluateFeatureInput");
        formatter.field("project", &self.project);
        formatter.field("feature", &self.feature);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("evaluation_context", &self.evaluation_context);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEvaluateFeatureInput {
    /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
    pub requests: std::option::Option<std::vec::Vec<crate::model::EvaluationRequest>>,
}
impl BatchEvaluateFeatureInput {
    /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
    pub fn requests(&self) -> std::option::Option<&[crate::model::EvaluationRequest]> {
        self.requests.as_deref()
    }
}
impl std::fmt::Debug for BatchEvaluateFeatureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEvaluateFeatureInput");
        formatter.field("project", &self.project);
        formatter.field("requests", &self.requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsInput {
    /// <p>The maximum number of results to include in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsInput {
    /// <p>The maximum number of results to include in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectInput {
    /// <p>The name for the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
    pub data_delivery: std::option::Option<crate::model::ProjectDataDeliveryConfig>,
    /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with a project.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateProjectInput {
    /// <p>The name for the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An optional description of the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
    pub fn data_delivery(&self) -> std::option::Option<&crate::model::ProjectDataDeliveryConfig> {
        self.data_delivery.as_ref()
    }
    /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with a project.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("data_delivery", &self.data_delivery);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectInput {
    /// <p>The name or ARN of the project to delete.</p>
    pub project: std::option::Option<std::string::String>,
}
impl DeleteProjectInput {
    /// <p>The name or ARN of the project to delete.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectInput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProjectInput {
    /// <p>The name or ARN of the project that you want to see the details of.</p>
    pub project: std::option::Option<std::string::String>,
}
impl GetProjectInput {
    /// <p>The name or ARN of the project that you want to see the details of.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
}
impl std::fmt::Debug for GetProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProjectInput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopLaunchInput {
    /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the launch to stop.</p>
    pub launch: std::option::Option<std::string::String>,
    /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
    pub desired_state: std::option::Option<crate::model::LaunchStopDesiredState>,
    /// <p>A string that describes why you are stopping the launch.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl StopLaunchInput {
    /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the launch to stop.</p>
    pub fn launch(&self) -> std::option::Option<&str> {
        self.launch.as_deref()
    }
    /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
    pub fn desired_state(&self) -> std::option::Option<&crate::model::LaunchStopDesiredState> {
        self.desired_state.as_ref()
    }
    /// <p>A string that describes why you are stopping the launch.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for StopLaunchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopLaunchInput");
        formatter.field("project", &self.project);
        formatter.field("launch", &self.launch);
        formatter.field("desired_state", &self.desired_state);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLaunchInput {
    /// <p>The name or ARN of the project that contains the launch to start.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the launch to start.</p>
    pub launch: std::option::Option<std::string::String>,
}
impl StartLaunchInput {
    /// <p>The name or ARN of the project that contains the launch to start.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the launch to start.</p>
    pub fn launch(&self) -> std::option::Option<&str> {
        self.launch.as_deref()
    }
}
impl std::fmt::Debug for StartLaunchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLaunchInput");
        formatter.field("project", &self.project);
        formatter.field("launch", &self.launch);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLaunchesInput {
    /// <p>The name or ARN of the project to return the launch list from.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Use this optional parameter to limit the returned results to only the launches with the status that you specify here.</p>
    pub status: std::option::Option<crate::model::LaunchStatus>,
}
impl ListLaunchesInput {
    /// <p>The name or ARN of the project to return the launch list from.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The maximum number of results to include in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Use this optional parameter to limit the returned results to only the launches with the status that you specify here.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LaunchStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ListLaunchesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLaunchesInput");
        formatter.field("project", &self.project);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLaunchInput {
    /// <p>The name or ARN of the project that you want to create the launch in.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name for the new launch.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description for the launch.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    pub scheduled_splits_config: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
    /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
    pub metric_monitors: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
    /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
    /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
    pub randomization_salt: std::option::Option<std::string::String>,
    /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with a launch.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateLaunchInput {
    /// <p>The name or ARN of the project that you want to create the launch in.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name for the new launch.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An optional description for the launch.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    pub fn scheduled_splits_config(
        &self,
    ) -> std::option::Option<&crate::model::ScheduledSplitsLaunchConfig> {
        self.scheduled_splits_config.as_ref()
    }
    /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
    pub fn metric_monitors(&self) -> std::option::Option<&[crate::model::MetricMonitorConfig]> {
        self.metric_monitors.as_deref()
    }
    /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::LaunchGroupConfig]> {
        self.groups.as_deref()
    }
    /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
    pub fn randomization_salt(&self) -> std::option::Option<&str> {
        self.randomization_salt.as_deref()
    }
    /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with a launch.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateLaunchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLaunchInput");
        formatter.field("project", &self.project);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("scheduled_splits_config", &self.scheduled_splits_config);
        formatter.field("metric_monitors", &self.metric_monitors);
        formatter.field("groups", &self.groups);
        formatter.field("randomization_salt", &self.randomization_salt);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLaunchInput {
    /// <p>The name or ARN of the project that contains the launch to delete.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the launch to delete.</p>
    pub launch: std::option::Option<std::string::String>,
}
impl DeleteLaunchInput {
    /// <p>The name or ARN of the project that contains the launch to delete.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the launch to delete.</p>
    pub fn launch(&self) -> std::option::Option<&str> {
        self.launch.as_deref()
    }
}
impl std::fmt::Debug for DeleteLaunchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLaunchInput");
        formatter.field("project", &self.project);
        formatter.field("launch", &self.launch);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLaunchInput {
    /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the launch that is to be updated.</p>
    pub launch: std::option::Option<std::string::String>,
    /// <p>An optional description for the launch.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
    /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
    pub metric_monitors: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
    /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
    pub randomization_salt: std::option::Option<std::string::String>,
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    pub scheduled_splits_config: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
}
impl UpdateLaunchInput {
    /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the launch that is to be updated.</p>
    pub fn launch(&self) -> std::option::Option<&str> {
        self.launch.as_deref()
    }
    /// <p>An optional description for the launch.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::LaunchGroupConfig]> {
        self.groups.as_deref()
    }
    /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
    pub fn metric_monitors(&self) -> std::option::Option<&[crate::model::MetricMonitorConfig]> {
        self.metric_monitors.as_deref()
    }
    /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
    pub fn randomization_salt(&self) -> std::option::Option<&str> {
        self.randomization_salt.as_deref()
    }
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    pub fn scheduled_splits_config(
        &self,
    ) -> std::option::Option<&crate::model::ScheduledSplitsLaunchConfig> {
        self.scheduled_splits_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateLaunchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLaunchInput");
        formatter.field("project", &self.project);
        formatter.field("launch", &self.launch);
        formatter.field("description", &self.description);
        formatter.field("groups", &self.groups);
        formatter.field("metric_monitors", &self.metric_monitors);
        formatter.field("randomization_salt", &self.randomization_salt);
        formatter.field("scheduled_splits_config", &self.scheduled_splits_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchInput {
    /// <p>The name or ARN of the project that contains the launch.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the launch that you want to see the details of.</p>
    pub launch: std::option::Option<std::string::String>,
}
impl GetLaunchInput {
    /// <p>The name or ARN of the project that contains the launch.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the launch that you want to see the details of.</p>
    pub fn launch(&self) -> std::option::Option<&str> {
        self.launch.as_deref()
    }
}
impl std::fmt::Debug for GetLaunchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchInput");
        formatter.field("project", &self.project);
        formatter.field("launch", &self.launch);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFeaturesInput {
    /// <p>The name or ARN of the project to return the feature list from.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFeaturesInput {
    /// <p>The name or ARN of the project to return the feature list from.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The maximum number of results to include in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFeaturesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFeaturesInput");
        formatter.field("project", &self.project);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFeatureInput {
    /// <p>The name or ARN of the project that is to contain the new feature.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name for the new feature.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
    pub evaluation_strategy: std::option::Option<crate::model::FeatureEvaluationStrategy>,
    /// <p>An optional description of the feature.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
    pub variations: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
    /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
    /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
    pub default_variation: std::option::Option<std::string::String>,
    /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with a feature.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
    pub entity_overrides:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateFeatureInput {
    /// <p>The name or ARN of the project that is to contain the new feature.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name for the new feature.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
    pub fn evaluation_strategy(
        &self,
    ) -> std::option::Option<&crate::model::FeatureEvaluationStrategy> {
        self.evaluation_strategy.as_ref()
    }
    /// <p>An optional description of the feature.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
    pub fn variations(&self) -> std::option::Option<&[crate::model::VariationConfig]> {
        self.variations.as_deref()
    }
    /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
    /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
    pub fn default_variation(&self) -> std::option::Option<&str> {
        self.default_variation.as_deref()
    }
    /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with a feature.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
    pub fn entity_overrides(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.entity_overrides.as_ref()
    }
}
impl std::fmt::Debug for CreateFeatureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFeatureInput");
        formatter.field("project", &self.project);
        formatter.field("name", &self.name);
        formatter.field("evaluation_strategy", &self.evaluation_strategy);
        formatter.field("description", &self.description);
        formatter.field("variations", &self.variations);
        formatter.field("default_variation", &self.default_variation);
        formatter.field("tags", &self.tags);
        formatter.field("entity_overrides", &self.entity_overrides);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFeatureInput {
    /// <p>The name or ARN of the project that contains the feature to delete.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the feature to delete.</p>
    pub feature: std::option::Option<std::string::String>,
}
impl DeleteFeatureInput {
    /// <p>The name or ARN of the project that contains the feature to delete.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the feature to delete.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
}
impl std::fmt::Debug for DeleteFeatureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFeatureInput");
        formatter.field("project", &self.project);
        formatter.field("feature", &self.feature);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFeatureInput {
    /// <p>The name or ARN of the project that contains the feature to be updated.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the feature to be updated.</p>
    pub feature: std::option::Option<std::string::String>,
    /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
    pub evaluation_strategy: std::option::Option<crate::model::FeatureEvaluationStrategy>,
    /// <p>An optional description of the feature.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
    pub add_or_update_variations: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
    /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
    /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
    pub remove_variations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    pub default_variation: std::option::Option<std::string::String>,
    /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
    pub entity_overrides:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateFeatureInput {
    /// <p>The name or ARN of the project that contains the feature to be updated.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the feature to be updated.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
    /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
    pub fn evaluation_strategy(
        &self,
    ) -> std::option::Option<&crate::model::FeatureEvaluationStrategy> {
        self.evaluation_strategy.as_ref()
    }
    /// <p>An optional description of the feature.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
    pub fn add_or_update_variations(
        &self,
    ) -> std::option::Option<&[crate::model::VariationConfig]> {
        self.add_or_update_variations.as_deref()
    }
    /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
    /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
    pub fn remove_variations(&self) -> std::option::Option<&[std::string::String]> {
        self.remove_variations.as_deref()
    }
    /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    pub fn default_variation(&self) -> std::option::Option<&str> {
        self.default_variation.as_deref()
    }
    /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
    pub fn entity_overrides(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.entity_overrides.as_ref()
    }
}
impl std::fmt::Debug for UpdateFeatureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFeatureInput");
        formatter.field("project", &self.project);
        formatter.field("feature", &self.feature);
        formatter.field("evaluation_strategy", &self.evaluation_strategy);
        formatter.field("description", &self.description);
        formatter.field("add_or_update_variations", &self.add_or_update_variations);
        formatter.field("remove_variations", &self.remove_variations);
        formatter.field("default_variation", &self.default_variation);
        formatter.field("entity_overrides", &self.entity_overrides);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFeatureInput {
    /// <p>The name or ARN of the project that contains the feature.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the feature that you want to retrieve information for.</p>
    pub feature: std::option::Option<std::string::String>,
}
impl GetFeatureInput {
    /// <p>The name or ARN of the project that contains the feature.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the feature that you want to retrieve information for.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
}
impl std::fmt::Debug for GetFeatureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFeatureInput");
        formatter.field("project", &self.project);
        formatter.field("feature", &self.feature);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment to stop.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the experiment to stop.</p>
    pub experiment: std::option::Option<std::string::String>,
    /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
    pub desired_state: std::option::Option<crate::model::ExperimentStopDesiredState>,
    /// <p>A string that describes why you are stopping the experiment.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl StopExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment to stop.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the experiment to stop.</p>
    pub fn experiment(&self) -> std::option::Option<&str> {
        self.experiment.as_deref()
    }
    /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
    pub fn desired_state(&self) -> std::option::Option<&crate::model::ExperimentStopDesiredState> {
        self.desired_state.as_ref()
    }
    /// <p>A string that describes why you are stopping the experiment.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for StopExperimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopExperimentInput");
        formatter.field("project", &self.project);
        formatter.field("experiment", &self.experiment);
        formatter.field("desired_state", &self.desired_state);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment to start.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the experiment to start.</p>
    pub experiment: std::option::Option<std::string::String>,
    /// <p>The date and time to end the experiment.</p>
    pub analysis_complete_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment to start.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the experiment to start.</p>
    pub fn experiment(&self) -> std::option::Option<&str> {
        self.experiment.as_deref()
    }
    /// <p>The date and time to end the experiment.</p>
    pub fn analysis_complete_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.analysis_complete_time.as_ref()
    }
}
impl std::fmt::Debug for StartExperimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExperimentInput");
        formatter.field("project", &self.project);
        formatter.field("experiment", &self.experiment);
        formatter.field("analysis_complete_time", &self.analysis_complete_time);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExperimentResultsInput {
    /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the experiment to retrieve the results of.</p>
    pub experiment: std::option::Option<std::string::String>,
    /// <p>The date and time that the experiment started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the experiment ended, if it is completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The names of the experiment metrics that you want to see the results of.</p>
    pub metric_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the experiment treatments that you want to see the results for.</p>
    pub treatment_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
    pub base_stat: std::option::Option<crate::model::ExperimentBaseStat>,
    /// <p>The statistics that you want to see in the returned results.</p>
    /// <ul>
    /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
    /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
    /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
    /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
    /// </ul>
    pub result_stats: std::option::Option<std::vec::Vec<crate::model::ExperimentResultRequestType>>,
    /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
    pub report_names: std::option::Option<std::vec::Vec<crate::model::ExperimentReportName>>,
    /// <p>In seconds, the amount of time to aggregate results together. </p>
    pub period: i64,
}
impl GetExperimentResultsInput {
    /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the experiment to retrieve the results of.</p>
    pub fn experiment(&self) -> std::option::Option<&str> {
        self.experiment.as_deref()
    }
    /// <p>The date and time that the experiment started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time that the experiment ended, if it is completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The names of the experiment metrics that you want to see the results of.</p>
    pub fn metric_names(&self) -> std::option::Option<&[std::string::String]> {
        self.metric_names.as_deref()
    }
    /// <p>The names of the experiment treatments that you want to see the results for.</p>
    pub fn treatment_names(&self) -> std::option::Option<&[std::string::String]> {
        self.treatment_names.as_deref()
    }
    /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
    pub fn base_stat(&self) -> std::option::Option<&crate::model::ExperimentBaseStat> {
        self.base_stat.as_ref()
    }
    /// <p>The statistics that you want to see in the returned results.</p>
    /// <ul>
    /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
    /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
    /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
    /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
    /// </ul>
    pub fn result_stats(
        &self,
    ) -> std::option::Option<&[crate::model::ExperimentResultRequestType]> {
        self.result_stats.as_deref()
    }
    /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
    pub fn report_names(&self) -> std::option::Option<&[crate::model::ExperimentReportName]> {
        self.report_names.as_deref()
    }
    /// <p>In seconds, the amount of time to aggregate results together. </p>
    pub fn period(&self) -> i64 {
        self.period
    }
}
impl std::fmt::Debug for GetExperimentResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExperimentResultsInput");
        formatter.field("project", &self.project);
        formatter.field("experiment", &self.experiment);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("metric_names", &self.metric_names);
        formatter.field("treatment_names", &self.treatment_names);
        formatter.field("base_stat", &self.base_stat);
        formatter.field("result_stats", &self.result_stats);
        formatter.field("report_names", &self.report_names);
        formatter.field("period", &self.period);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExperimentsInput {
    /// <p>The name or ARN of the project to return the experiment list from.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Use this optional parameter to limit the returned results to only the experiments with the status that you specify here.</p>
    pub status: std::option::Option<crate::model::ExperimentStatus>,
}
impl ListExperimentsInput {
    /// <p>The name or ARN of the project to return the experiment list from.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The maximum number of results to include in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Use this optional parameter to limit the returned results to only the experiments with the status that you specify here.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExperimentStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ListExperimentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExperimentsInput");
        formatter.field("project", &self.project);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExperimentInput {
    /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>A name for the new experiment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the experiment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
    pub treatments: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
    /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    pub metric_goals: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
    /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
    pub randomization_salt: std::option::Option<std::string::String>,
    /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
    /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
    pub sampling_rate: std::option::Option<i64>,
    /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    pub online_ab_config: std::option::Option<crate::model::OnlineAbConfig>,
    /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with an experiment.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateExperimentInput {
    /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>A name for the new experiment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An optional description of the experiment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
    pub fn treatments(&self) -> std::option::Option<&[crate::model::TreatmentConfig]> {
        self.treatments.as_deref()
    }
    /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    pub fn metric_goals(&self) -> std::option::Option<&[crate::model::MetricGoalConfig]> {
        self.metric_goals.as_deref()
    }
    /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
    pub fn randomization_salt(&self) -> std::option::Option<&str> {
        self.randomization_salt.as_deref()
    }
    /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
    /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
    pub fn sampling_rate(&self) -> std::option::Option<i64> {
        self.sampling_rate
    }
    /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    pub fn online_ab_config(&self) -> std::option::Option<&crate::model::OnlineAbConfig> {
        self.online_ab_config.as_ref()
    }
    /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can associate as many as 50 tags with an experiment.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateExperimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExperimentInput");
        formatter.field("project", &self.project);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("treatments", &self.treatments);
        formatter.field("metric_goals", &self.metric_goals);
        formatter.field("randomization_salt", &self.randomization_salt);
        formatter.field("sampling_rate", &self.sampling_rate);
        formatter.field("online_ab_config", &self.online_ab_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment to delete.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the experiment to delete.</p>
    pub experiment: std::option::Option<std::string::String>,
}
impl DeleteExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment to delete.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the experiment to delete.</p>
    pub fn experiment(&self) -> std::option::Option<&str> {
        self.experiment.as_deref()
    }
}
impl std::fmt::Debug for DeleteExperimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExperimentInput");
        formatter.field("project", &self.project);
        formatter.field("experiment", &self.experiment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the experiment to update.</p>
    pub experiment: std::option::Option<std::string::String>,
    /// <p>An optional description of the experiment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of structures that define the variations being tested in the experiment.</p>
    pub treatments: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
    /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    pub metric_goals: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
    /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
    pub randomization_salt: std::option::Option<std::string::String>,
    /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
    /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
    pub sampling_rate: std::option::Option<i64>,
    /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    pub online_ab_config: std::option::Option<crate::model::OnlineAbConfig>,
}
impl UpdateExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the experiment to update.</p>
    pub fn experiment(&self) -> std::option::Option<&str> {
        self.experiment.as_deref()
    }
    /// <p>An optional description of the experiment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of structures that define the variations being tested in the experiment.</p>
    pub fn treatments(&self) -> std::option::Option<&[crate::model::TreatmentConfig]> {
        self.treatments.as_deref()
    }
    /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    pub fn metric_goals(&self) -> std::option::Option<&[crate::model::MetricGoalConfig]> {
        self.metric_goals.as_deref()
    }
    /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
    pub fn randomization_salt(&self) -> std::option::Option<&str> {
        self.randomization_salt.as_deref()
    }
    /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
    /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
    pub fn sampling_rate(&self) -> std::option::Option<i64> {
        self.sampling_rate
    }
    /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    pub fn online_ab_config(&self) -> std::option::Option<&crate::model::OnlineAbConfig> {
        self.online_ab_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateExperimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExperimentInput");
        formatter.field("project", &self.project);
        formatter.field("experiment", &self.experiment);
        formatter.field("description", &self.description);
        formatter.field("treatments", &self.treatments);
        formatter.field("metric_goals", &self.metric_goals);
        formatter.field("randomization_salt", &self.randomization_salt);
        formatter.field("sampling_rate", &self.sampling_rate);
        formatter.field("online_ab_config", &self.online_ab_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the experiment that you want to see the details of.</p>
    pub experiment: std::option::Option<std::string::String>,
}
impl GetExperimentInput {
    /// <p>The name or ARN of the project that contains the experiment.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the experiment that you want to see the details of.</p>
    pub fn experiment(&self) -> std::option::Option<&str> {
        self.experiment.as_deref()
    }
}
impl std::fmt::Debug for GetExperimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExperimentInput");
        formatter.field("project", &self.project);
        formatter.field("experiment", &self.experiment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of key-value pairs to associate with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of key-value pairs to associate with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource that you want to see the tags of.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource that you want to see the tags of.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
