// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchEvaluateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchEvaluateFeatureError {
    /// Kind of error that occurred.
    pub kind: BatchEvaluateFeatureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchEvaluateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchEvaluateFeatureErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchEvaluateFeatureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchEvaluateFeatureErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchEvaluateFeatureErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchEvaluateFeatureErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchEvaluateFeatureErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchEvaluateFeatureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchEvaluateFeatureError {
    fn code(&self) -> Option<&str> {
        BatchEvaluateFeatureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchEvaluateFeatureError {
    /// Creates a new `BatchEvaluateFeatureError`.
    pub fn new(kind: BatchEvaluateFeatureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchEvaluateFeatureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchEvaluateFeatureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchEvaluateFeatureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchEvaluateFeatureErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchEvaluateFeatureErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEvaluateFeatureErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchEvaluateFeatureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEvaluateFeatureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchEvaluateFeatureErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEvaluateFeatureErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchEvaluateFeatureErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEvaluateFeatureErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchEvaluateFeatureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchEvaluateFeatureErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchEvaluateFeatureErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchEvaluateFeatureErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchEvaluateFeatureErrorKind::ValidationException(_inner) => Some(_inner),
            BatchEvaluateFeatureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExperimentError {
    /// Kind of error that occurred.
    pub kind: CreateExperimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExperimentErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExperimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExperimentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateExperimentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateExperimentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateExperimentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateExperimentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateExperimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExperimentError {
    fn code(&self) -> Option<&str> {
        CreateExperimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExperimentError {
    /// Creates a new `CreateExperimentError`.
    pub fn new(kind: CreateExperimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExperimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExperimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExperimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExperimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExperimentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperimentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperimentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateExperimentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateExperimentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperimentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperimentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperimentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperimentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperimentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateExperimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExperimentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateExperimentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateExperimentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateExperimentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateExperimentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateExperimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFeatureError {
    /// Kind of error that occurred.
    pub kind: CreateFeatureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFeatureErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFeatureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFeatureErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFeatureErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateFeatureErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFeatureErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateFeatureErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFeatureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFeatureError {
    fn code(&self) -> Option<&str> {
        CreateFeatureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFeatureError {
    /// Creates a new `CreateFeatureError`.
    pub fn new(kind: CreateFeatureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFeatureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFeatureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFeatureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFeatureErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFeatureErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateFeatureErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateFeatureErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateFeatureErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateFeatureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFeatureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFeatureErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFeatureErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFeatureErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateFeatureErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateFeatureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFeatureErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFeatureErrorKind::ConflictException(_inner) => Some(_inner),
            CreateFeatureErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFeatureErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateFeatureErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFeatureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLaunchError {
    /// Kind of error that occurred.
    pub kind: CreateLaunchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLaunchErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLaunchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLaunchErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLaunchErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateLaunchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateLaunchErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateLaunchErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateLaunchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLaunchError {
    fn code(&self) -> Option<&str> {
        CreateLaunchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLaunchError {
    /// Creates a new `CreateLaunchError`.
    pub fn new(kind: CreateLaunchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLaunchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLaunchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLaunchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLaunchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLaunchErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateLaunchErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateLaunchErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateLaunchErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateLaunchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLaunchErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLaunchErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateLaunchErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateLaunchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLaunchErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLaunchErrorKind::ConflictException(_inner) => Some(_inner),
            CreateLaunchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateLaunchErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateLaunchErrorKind::ValidationException(_inner) => Some(_inner),
            CreateLaunchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProjectError {
    /// Kind of error that occurred.
    pub kind: CreateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProjectErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProjectError {
    fn code(&self) -> Option<&str> {
        CreateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProjectError {
    /// Creates a new `CreateProjectError`.
    pub fn new(kind: CreateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateProjectErrorKind::ConflictException(_inner) => Some(_inner),
            CreateProjectErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateProjectErrorKind::ValidationException(_inner) => Some(_inner),
            CreateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteExperimentError {
    /// Kind of error that occurred.
    pub kind: DeleteExperimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteExperimentErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service was unavailable. Retry the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteExperimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteExperimentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteExperimentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteExperimentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteExperimentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteExperimentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteExperimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteExperimentError {
    fn code(&self) -> Option<&str> {
        DeleteExperimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteExperimentError {
    /// Creates a new `DeleteExperimentError`.
    pub fn new(kind: DeleteExperimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteExperimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteExperimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteExperimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteExperimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteExperimentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperimentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExperimentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteExperimentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteExperimentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperimentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExperimentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperimentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExperimentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperimentErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteExperimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteExperimentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteExperimentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteExperimentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteExperimentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteExperimentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteExperimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFeatureError {
    /// Kind of error that occurred.
    pub kind: DeleteFeatureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFeatureErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFeatureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFeatureErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFeatureErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteFeatureErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFeatureErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFeatureErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFeatureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFeatureError {
    fn code(&self) -> Option<&str> {
        DeleteFeatureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFeatureError {
    /// Creates a new `DeleteFeatureError`.
    pub fn new(kind: DeleteFeatureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFeatureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFeatureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFeatureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFeatureErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFeatureErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteFeatureErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteFeatureErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteFeatureErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteFeatureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFeatureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFeatureErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteFeatureErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteFeatureErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteFeatureErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteFeatureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFeatureErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFeatureErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteFeatureErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFeatureErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFeatureErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFeatureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLaunchError {
    /// Kind of error that occurred.
    pub kind: DeleteLaunchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLaunchErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLaunchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLaunchErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLaunchErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteLaunchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteLaunchErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteLaunchErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteLaunchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLaunchError {
    fn code(&self) -> Option<&str> {
        DeleteLaunchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLaunchError {
    /// Creates a new `DeleteLaunchError`.
    pub fn new(kind: DeleteLaunchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLaunchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLaunchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLaunchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLaunchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLaunchErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteLaunchErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteLaunchErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteLaunchErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteLaunchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLaunchErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteLaunchErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteLaunchErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteLaunchErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteLaunchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLaunchErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLaunchErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteLaunchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteLaunchErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteLaunchErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteLaunchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProjectErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProjectError {
    fn code(&self) -> Option<&str> {
        DeleteProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProjectError {
    /// Creates a new `DeleteProjectError`.
    pub fn new(kind: DeleteProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EvaluateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EvaluateFeatureError {
    /// Kind of error that occurred.
    pub kind: EvaluateFeatureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EvaluateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EvaluateFeatureErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EvaluateFeatureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EvaluateFeatureErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EvaluateFeatureErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EvaluateFeatureErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            EvaluateFeatureErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EvaluateFeatureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EvaluateFeatureError {
    fn code(&self) -> Option<&str> {
        EvaluateFeatureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EvaluateFeatureError {
    /// Creates a new `EvaluateFeatureError`.
    pub fn new(kind: EvaluateFeatureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EvaluateFeatureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EvaluateFeatureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EvaluateFeatureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EvaluateFeatureErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EvaluateFeatureErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluateFeatureErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluateFeatureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluateFeatureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluateFeatureErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, EvaluateFeatureErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `EvaluateFeatureErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, EvaluateFeatureErrorKind::ValidationException(_))
    }
}
impl std::error::Error for EvaluateFeatureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EvaluateFeatureErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EvaluateFeatureErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EvaluateFeatureErrorKind::ThrottlingException(_inner) => Some(_inner),
            EvaluateFeatureErrorKind::ValidationException(_inner) => Some(_inner),
            EvaluateFeatureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExperimentError {
    /// Kind of error that occurred.
    pub kind: GetExperimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExperimentErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExperimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExperimentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExperimentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetExperimentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetExperimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExperimentError {
    fn code(&self) -> Option<&str> {
        GetExperimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExperimentError {
    /// Creates a new `GetExperimentError`.
    pub fn new(kind: GetExperimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExperimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExperimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExperimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExperimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExperimentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetExperimentErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetExperimentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExperimentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExperimentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetExperimentErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetExperimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExperimentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExperimentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetExperimentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetExperimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExperimentResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExperimentResultsError {
    /// Kind of error that occurred.
    pub kind: GetExperimentResultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExperimentResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExperimentResultsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExperimentResultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExperimentResultsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExperimentResultsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetExperimentResultsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetExperimentResultsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetExperimentResultsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetExperimentResultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExperimentResultsError {
    fn code(&self) -> Option<&str> {
        GetExperimentResultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExperimentResultsError {
    /// Creates a new `GetExperimentResultsError`.
    pub fn new(kind: GetExperimentResultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExperimentResultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExperimentResultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExperimentResultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExperimentResultsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExperimentResultsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExperimentResultsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExperimentResultsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExperimentResultsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExperimentResultsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExperimentResultsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExperimentResultsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExperimentResultsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExperimentResultsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExperimentResultsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetExperimentResultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExperimentResultsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExperimentResultsErrorKind::ConflictException(_inner) => Some(_inner),
            GetExperimentResultsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetExperimentResultsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetExperimentResultsErrorKind::ValidationException(_inner) => Some(_inner),
            GetExperimentResultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFeatureError {
    /// Kind of error that occurred.
    pub kind: GetFeatureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFeatureErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFeatureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFeatureErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFeatureErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFeatureErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetFeatureErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFeatureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFeatureError {
    fn code(&self) -> Option<&str> {
        GetFeatureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFeatureError {
    /// Creates a new `GetFeatureError`.
    pub fn new(kind: GetFeatureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFeatureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFeatureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFeatureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFeatureErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFeatureErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetFeatureErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetFeatureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFeatureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFeatureErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetFeatureErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetFeatureErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetFeatureErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetFeatureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFeatureErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFeatureErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFeatureErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetFeatureErrorKind::ValidationException(_inner) => Some(_inner),
            GetFeatureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLaunchError {
    /// Kind of error that occurred.
    pub kind: GetLaunchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLaunchErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLaunchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLaunchErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLaunchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLaunchErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLaunchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLaunchError {
    fn code(&self) -> Option<&str> {
        GetLaunchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLaunchError {
    /// Creates a new `GetLaunchError`.
    pub fn new(kind: GetLaunchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLaunchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLaunchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLaunchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLaunchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLaunchErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetLaunchErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetLaunchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetLaunchErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetLaunchErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetLaunchErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetLaunchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLaunchErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLaunchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLaunchErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLaunchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProjectError {
    /// Kind of error that occurred.
    pub kind: GetProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProjectErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProjectError {
    fn code(&self) -> Option<&str> {
        GetProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProjectError {
    /// Creates a new `GetProjectError`.
    pub fn new(kind: GetProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetProjectErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetProjectErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetProjectErrorKind::ValidationException(_inner) => Some(_inner),
            GetProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExperiments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExperimentsError {
    /// Kind of error that occurred.
    pub kind: ListExperimentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExperiments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExperimentsErrorKind {
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExperimentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExperimentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListExperimentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListExperimentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExperimentsError {
    fn code(&self) -> Option<&str> {
        ListExperimentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExperimentsError {
    /// Creates a new `ListExperimentsError`.
    pub fn new(kind: ListExperimentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExperimentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExperimentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExperimentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExperimentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExperimentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperimentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperimentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListExperimentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListExperimentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExperimentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListExperimentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListExperimentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFeatures` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFeaturesError {
    /// Kind of error that occurred.
    pub kind: ListFeaturesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFeatures` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFeaturesErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFeaturesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFeaturesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFeaturesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFeaturesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFeaturesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFeaturesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFeaturesError {
    fn code(&self) -> Option<&str> {
        ListFeaturesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFeaturesError {
    /// Creates a new `ListFeaturesError`.
    pub fn new(kind: ListFeaturesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFeaturesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFeaturesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFeaturesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFeaturesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFeaturesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListFeaturesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListFeaturesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFeaturesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFeaturesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFeaturesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListFeaturesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFeaturesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFeaturesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFeaturesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFeaturesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFeaturesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFeaturesErrorKind::ValidationException(_inner) => Some(_inner),
            ListFeaturesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLaunches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLaunchesError {
    /// Kind of error that occurred.
    pub kind: ListLaunchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLaunches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLaunchesErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLaunchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLaunchesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLaunchesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLaunchesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLaunchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLaunchesError {
    fn code(&self) -> Option<&str> {
        ListLaunchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLaunchesError {
    /// Creates a new `ListLaunchesError`.
    pub fn new(kind: ListLaunchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLaunchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLaunchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLaunchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLaunchesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLaunchesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListLaunchesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListLaunchesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListLaunchesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListLaunchesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListLaunchesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListLaunchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLaunchesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLaunchesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLaunchesErrorKind::ValidationException(_inner) => Some(_inner),
            ListLaunchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectsError {
    /// Kind of error that occurred.
    pub kind: ListProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectsError {
    fn code(&self) -> Option<&str> {
        ListProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectsError {
    /// Creates a new `ListProjectsError`.
    pub fn new(kind: ListProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProjectsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListProjectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListProjectsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProjectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProjectsErrorKind::ValidationException(_inner) => Some(_inner),
            ListProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ConflictException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutProjectEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutProjectEventsError {
    /// Kind of error that occurred.
    pub kind: PutProjectEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutProjectEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutProjectEventsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutProjectEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutProjectEventsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutProjectEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutProjectEventsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutProjectEventsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutProjectEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutProjectEventsError {
    fn code(&self) -> Option<&str> {
        PutProjectEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutProjectEventsError {
    /// Creates a new `PutProjectEventsError`.
    pub fn new(kind: PutProjectEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutProjectEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutProjectEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutProjectEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutProjectEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutProjectEventsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProjectEventsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProjectEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProjectEventsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProjectEventsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProjectEventsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProjectEventsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProjectEventsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutProjectEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutProjectEventsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutProjectEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutProjectEventsErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutProjectEventsErrorKind::ValidationException(_inner) => Some(_inner),
            PutProjectEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartExperimentError {
    /// Kind of error that occurred.
    pub kind: StartExperimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartExperimentErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartExperimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartExperimentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartExperimentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartExperimentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartExperimentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartExperimentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartExperimentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartExperimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartExperimentError {
    fn code(&self) -> Option<&str> {
        StartExperimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartExperimentError {
    /// Creates a new `StartExperimentError`.
    pub fn new(kind: StartExperimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartExperimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartExperimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartExperimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartExperimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartExperimentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExperimentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExperimentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartExperimentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartExperimentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExperimentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExperimentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExperimentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExperimentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartExperimentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartExperimentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartExperimentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartExperimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartExperimentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartExperimentErrorKind::ConflictException(_inner) => Some(_inner),
            StartExperimentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartExperimentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartExperimentErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartExperimentErrorKind::ValidationException(_inner) => Some(_inner),
            StartExperimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartLaunchError {
    /// Kind of error that occurred.
    pub kind: StartLaunchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartLaunchErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartLaunchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartLaunchErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartLaunchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartLaunchErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartLaunchErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartLaunchErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartLaunchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartLaunchError {
    fn code(&self) -> Option<&str> {
        StartLaunchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartLaunchError {
    /// Creates a new `StartLaunchError`.
    pub fn new(kind: StartLaunchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartLaunchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartLaunchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartLaunchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartLaunchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartLaunchErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StartLaunchErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `StartLaunchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLaunchErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLaunchErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLaunchErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLaunchErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartLaunchErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartLaunchErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartLaunchErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartLaunchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartLaunchErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartLaunchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartLaunchErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartLaunchErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartLaunchErrorKind::ValidationException(_inner) => Some(_inner),
            StartLaunchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopExperimentError {
    /// Kind of error that occurred.
    pub kind: StopExperimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopExperimentErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopExperimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopExperimentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopExperimentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StopExperimentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopExperimentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StopExperimentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopExperimentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopExperimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopExperimentError {
    fn code(&self) -> Option<&str> {
        StopExperimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopExperimentError {
    /// Creates a new `StopExperimentError`.
    pub fn new(kind: StopExperimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopExperimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopExperimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopExperimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopExperimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopExperimentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopExperimentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopExperimentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StopExperimentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StopExperimentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopExperimentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopExperimentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopExperimentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StopExperimentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StopExperimentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StopExperimentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StopExperimentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StopExperimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopExperimentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopExperimentErrorKind::ConflictException(_inner) => Some(_inner),
            StopExperimentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopExperimentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StopExperimentErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopExperimentErrorKind::ValidationException(_inner) => Some(_inner),
            StopExperimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopLaunchError {
    /// Kind of error that occurred.
    pub kind: StopLaunchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopLaunchErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopLaunchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopLaunchErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopLaunchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopLaunchErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopLaunchErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopLaunchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopLaunchError {
    fn code(&self) -> Option<&str> {
        StopLaunchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopLaunchError {
    /// Creates a new `StopLaunchError`.
    pub fn new(kind: StopLaunchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopLaunchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopLaunchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopLaunchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopLaunchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopLaunchErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StopLaunchErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `StopLaunchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopLaunchErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopLaunchErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StopLaunchErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StopLaunchErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StopLaunchErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StopLaunchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopLaunchErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopLaunchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopLaunchErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopLaunchErrorKind::ValidationException(_inner) => Some(_inner),
            StopLaunchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateExperimentError {
    /// Kind of error that occurred.
    pub kind: UpdateExperimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateExperiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateExperimentErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateExperimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateExperimentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateExperimentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateExperimentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateExperimentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateExperimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateExperimentError {
    fn code(&self) -> Option<&str> {
        UpdateExperimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateExperimentError {
    /// Creates a new `UpdateExperimentError`.
    pub fn new(kind: UpdateExperimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateExperimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateExperimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateExperimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateExperimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateExperimentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperimentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExperimentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateExperimentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateExperimentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperimentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExperimentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperimentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateExperimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateExperimentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateExperimentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateExperimentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateExperimentErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateExperimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFeatureError {
    /// Kind of error that occurred.
    pub kind: UpdateFeatureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFeature` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFeatureErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFeatureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFeatureErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateFeatureErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFeatureErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFeatureErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateFeatureErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateFeatureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFeatureError {
    fn code(&self) -> Option<&str> {
        UpdateFeatureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFeatureError {
    /// Creates a new `UpdateFeatureError`.
    pub fn new(kind: UpdateFeatureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFeatureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFeatureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFeatureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFeatureErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFeatureErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateFeatureErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateFeatureErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateFeatureErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateFeatureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFeatureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFeatureErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFeatureErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFeatureErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateFeatureErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateFeatureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFeatureErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateFeatureErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFeatureErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFeatureErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateFeatureErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateFeatureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLaunchError {
    /// Kind of error that occurred.
    pub kind: UpdateLaunchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLaunchErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLaunchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLaunchErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLaunchErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLaunchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLaunchErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLaunchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLaunchError {
    fn code(&self) -> Option<&str> {
        UpdateLaunchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLaunchError {
    /// Creates a new `UpdateLaunchError`.
    pub fn new(kind: UpdateLaunchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLaunchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLaunchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLaunchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLaunchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLaunchErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateLaunchErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateLaunchErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateLaunchErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateLaunchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateLaunchErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateLaunchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLaunchErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLaunchErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLaunchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLaunchErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLaunchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectError {
    fn code(&self) -> Option<&str> {
        UpdateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectError {
    /// Creates a new `UpdateProjectError`.
    pub fn new(kind: UpdateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProjectDataDelivery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectDataDeliveryError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectDataDeliveryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProjectDataDelivery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectDataDeliveryErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectDataDeliveryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectDataDeliveryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateProjectDataDeliveryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateProjectDataDeliveryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectDataDeliveryErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateProjectDataDeliveryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateProjectDataDeliveryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectDataDeliveryError {
    fn code(&self) -> Option<&str> {
        UpdateProjectDataDeliveryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectDataDeliveryError {
    /// Creates a new `UpdateProjectDataDeliveryError`.
    pub fn new(kind: UpdateProjectDataDeliveryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectDataDeliveryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectDataDeliveryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectDataDeliveryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectDataDeliveryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateProjectDataDeliveryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectDataDeliveryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectDataDeliveryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectDataDeliveryErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectDataDeliveryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectDataDeliveryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectDataDeliveryErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectDataDeliveryErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectDataDeliveryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectDataDeliveryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateProjectDataDeliveryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectDataDeliveryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateProjectDataDeliveryErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateProjectDataDeliveryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProjectDataDeliveryErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            UpdateProjectDataDeliveryErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateProjectDataDeliveryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The value of a parameter in the request caused an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>A reason for the error.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The parameter that caused the exception.</p>
    pub field_list: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>A reason for the error.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The parameter that caused the exception.</p>
    pub fn field_list(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.field_list.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("field_list", &self.field_list);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) field_list:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A reason for the error.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>A reason for the error.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `field_list`.
        ///
        /// To override the contents of this collection use [`set_field_list`](Self::set_field_list).
        ///
        /// <p>The parameter that caused the exception.</p>
        pub fn field_list(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.field_list.unwrap_or_default();
            v.push(input);
            self.field_list = Some(v);
            self
        }
        /// <p>The parameter that caused the exception.</p>
        pub fn set_field_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.field_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                field_list: self.field_list,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request would cause a service quota to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that caused the exception.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that is associated with the error.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the service that is associated with the error.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The ID of the service quota that was exceeded.</p>
    pub quota_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The ID of the resource that caused the exception.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that is associated with the error.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the service that is associated with the error.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The ID of the service quota that was exceeded.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that caused the exception.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that caused the exception.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the service that is associated with the error.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The ID of the service that is associated with the error.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The request references a resource that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that caused the exception.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that is associated with the error.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The ID of the resource that caused the exception.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that is associated with the error.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that caused the exception.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that caused the exception.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>A resource was in an inconsistent state during an update or a deletion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that caused the exception.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that is associated with the error.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The ID of the resource that caused the exception.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that is associated with the error.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that caused the exception.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that caused the exception.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You do not have sufficient permissions to perform this action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request was denied because of request throttling. Retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the service that is associated with the error.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The ID of the service quota that was exceeded.</p>
    pub quota_code: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    /// <p>The ID of the service that is associated with the error.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The ID of the service quota that was exceeded.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the service that is associated with the error.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The ID of the service that is associated with the error.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The service was unavailable. Retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>Unexpected error while processing the request. Retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}
