// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchEvaluateFeature`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_evaluate_feature`](crate::client::Client::batch_evaluate_feature).
///
/// See [`crate::client::fluent_builders::BatchEvaluateFeature`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchEvaluateFeature {
    _private: (),
}
impl BatchEvaluateFeature {
    /// Creates a new builder-style object to manufacture [`BatchEvaluateFeatureInput`](crate::input::BatchEvaluateFeatureInput)
    pub fn builder() -> crate::input::batch_evaluate_feature_input::Builder {
        crate::input::batch_evaluate_feature_input::Builder::default()
    }
    /// Creates a new `BatchEvaluateFeature` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchEvaluateFeature {
    type Output = std::result::Result<
        crate::output::BatchEvaluateFeatureOutput,
        crate::error::BatchEvaluateFeatureError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_evaluate_feature_error(response)
        } else {
            crate::operation_deser::parse_batch_evaluate_feature_response(response)
        }
    }
}

/// Operation shape for `CreateExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_experiment`](crate::client::Client::create_experiment).
///
/// See [`crate::client::fluent_builders::CreateExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExperiment {
    _private: (),
}
impl CreateExperiment {
    /// Creates a new builder-style object to manufacture [`CreateExperimentInput`](crate::input::CreateExperimentInput)
    pub fn builder() -> crate::input::create_experiment_input::Builder {
        crate::input::create_experiment_input::Builder::default()
    }
    /// Creates a new `CreateExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExperiment {
    type Output = std::result::Result<
        crate::output::CreateExperimentOutput,
        crate::error::CreateExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_experiment_error(response)
        } else {
            crate::operation_deser::parse_create_experiment_response(response)
        }
    }
}

/// Operation shape for `CreateFeature`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_feature`](crate::client::Client::create_feature).
///
/// See [`crate::client::fluent_builders::CreateFeature`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFeature {
    _private: (),
}
impl CreateFeature {
    /// Creates a new builder-style object to manufacture [`CreateFeatureInput`](crate::input::CreateFeatureInput)
    pub fn builder() -> crate::input::create_feature_input::Builder {
        crate::input::create_feature_input::Builder::default()
    }
    /// Creates a new `CreateFeature` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFeature {
    type Output =
        std::result::Result<crate::output::CreateFeatureOutput, crate::error::CreateFeatureError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_feature_error(response)
        } else {
            crate::operation_deser::parse_create_feature_response(response)
        }
    }
}

/// Operation shape for `CreateLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_launch`](crate::client::Client::create_launch).
///
/// See [`crate::client::fluent_builders::CreateLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLaunch {
    _private: (),
}
impl CreateLaunch {
    /// Creates a new builder-style object to manufacture [`CreateLaunchInput`](crate::input::CreateLaunchInput)
    pub fn builder() -> crate::input::create_launch_input::Builder {
        crate::input::create_launch_input::Builder::default()
    }
    /// Creates a new `CreateLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLaunch {
    type Output =
        std::result::Result<crate::output::CreateLaunchOutput, crate::error::CreateLaunchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_launch_error(response)
        } else {
            crate::operation_deser::parse_create_launch_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `DeleteExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_experiment`](crate::client::Client::delete_experiment).
///
/// See [`crate::client::fluent_builders::DeleteExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteExperiment {
    _private: (),
}
impl DeleteExperiment {
    /// Creates a new builder-style object to manufacture [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
    pub fn builder() -> crate::input::delete_experiment_input::Builder {
        crate::input::delete_experiment_input::Builder::default()
    }
    /// Creates a new `DeleteExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteExperiment {
    type Output = std::result::Result<
        crate::output::DeleteExperimentOutput,
        crate::error::DeleteExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_experiment_error(response)
        } else {
            crate::operation_deser::parse_delete_experiment_response(response)
        }
    }
}

/// Operation shape for `DeleteFeature`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_feature`](crate::client::Client::delete_feature).
///
/// See [`crate::client::fluent_builders::DeleteFeature`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFeature {
    _private: (),
}
impl DeleteFeature {
    /// Creates a new builder-style object to manufacture [`DeleteFeatureInput`](crate::input::DeleteFeatureInput)
    pub fn builder() -> crate::input::delete_feature_input::Builder {
        crate::input::delete_feature_input::Builder::default()
    }
    /// Creates a new `DeleteFeature` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFeature {
    type Output =
        std::result::Result<crate::output::DeleteFeatureOutput, crate::error::DeleteFeatureError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_feature_error(response)
        } else {
            crate::operation_deser::parse_delete_feature_response(response)
        }
    }
}

/// Operation shape for `DeleteLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_launch`](crate::client::Client::delete_launch).
///
/// See [`crate::client::fluent_builders::DeleteLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLaunch {
    _private: (),
}
impl DeleteLaunch {
    /// Creates a new builder-style object to manufacture [`DeleteLaunchInput`](crate::input::DeleteLaunchInput)
    pub fn builder() -> crate::input::delete_launch_input::Builder {
        crate::input::delete_launch_input::Builder::default()
    }
    /// Creates a new `DeleteLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLaunch {
    type Output =
        std::result::Result<crate::output::DeleteLaunchOutput, crate::error::DeleteLaunchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_launch_error(response)
        } else {
            crate::operation_deser::parse_delete_launch_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `EvaluateFeature`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`evaluate_feature`](crate::client::Client::evaluate_feature).
///
/// See [`crate::client::fluent_builders::EvaluateFeature`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EvaluateFeature {
    _private: (),
}
impl EvaluateFeature {
    /// Creates a new builder-style object to manufacture [`EvaluateFeatureInput`](crate::input::EvaluateFeatureInput)
    pub fn builder() -> crate::input::evaluate_feature_input::Builder {
        crate::input::evaluate_feature_input::Builder::default()
    }
    /// Creates a new `EvaluateFeature` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EvaluateFeature {
    type Output = std::result::Result<
        crate::output::EvaluateFeatureOutput,
        crate::error::EvaluateFeatureError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_evaluate_feature_error(response)
        } else {
            crate::operation_deser::parse_evaluate_feature_response(response)
        }
    }
}

/// Operation shape for `GetExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_experiment`](crate::client::Client::get_experiment).
///
/// See [`crate::client::fluent_builders::GetExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExperiment {
    _private: (),
}
impl GetExperiment {
    /// Creates a new builder-style object to manufacture [`GetExperimentInput`](crate::input::GetExperimentInput)
    pub fn builder() -> crate::input::get_experiment_input::Builder {
        crate::input::get_experiment_input::Builder::default()
    }
    /// Creates a new `GetExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExperiment {
    type Output =
        std::result::Result<crate::output::GetExperimentOutput, crate::error::GetExperimentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_experiment_error(response)
        } else {
            crate::operation_deser::parse_get_experiment_response(response)
        }
    }
}

/// Operation shape for `GetExperimentResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_experiment_results`](crate::client::Client::get_experiment_results).
///
/// See [`crate::client::fluent_builders::GetExperimentResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExperimentResults {
    _private: (),
}
impl GetExperimentResults {
    /// Creates a new builder-style object to manufacture [`GetExperimentResultsInput`](crate::input::GetExperimentResultsInput)
    pub fn builder() -> crate::input::get_experiment_results_input::Builder {
        crate::input::get_experiment_results_input::Builder::default()
    }
    /// Creates a new `GetExperimentResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExperimentResults {
    type Output = std::result::Result<
        crate::output::GetExperimentResultsOutput,
        crate::error::GetExperimentResultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_experiment_results_error(response)
        } else {
            crate::operation_deser::parse_get_experiment_results_response(response)
        }
    }
}

/// Operation shape for `GetFeature`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_feature`](crate::client::Client::get_feature).
///
/// See [`crate::client::fluent_builders::GetFeature`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFeature {
    _private: (),
}
impl GetFeature {
    /// Creates a new builder-style object to manufacture [`GetFeatureInput`](crate::input::GetFeatureInput)
    pub fn builder() -> crate::input::get_feature_input::Builder {
        crate::input::get_feature_input::Builder::default()
    }
    /// Creates a new `GetFeature` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFeature {
    type Output =
        std::result::Result<crate::output::GetFeatureOutput, crate::error::GetFeatureError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_feature_error(response)
        } else {
            crate::operation_deser::parse_get_feature_response(response)
        }
    }
}

/// Operation shape for `GetLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_launch`](crate::client::Client::get_launch).
///
/// See [`crate::client::fluent_builders::GetLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLaunch {
    _private: (),
}
impl GetLaunch {
    /// Creates a new builder-style object to manufacture [`GetLaunchInput`](crate::input::GetLaunchInput)
    pub fn builder() -> crate::input::get_launch_input::Builder {
        crate::input::get_launch_input::Builder::default()
    }
    /// Creates a new `GetLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLaunch {
    type Output = std::result::Result<crate::output::GetLaunchOutput, crate::error::GetLaunchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_launch_error(response)
        } else {
            crate::operation_deser::parse_get_launch_response(response)
        }
    }
}

/// Operation shape for `GetProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_project`](crate::client::Client::get_project).
///
/// See [`crate::client::fluent_builders::GetProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProject {
    _private: (),
}
impl GetProject {
    /// Creates a new builder-style object to manufacture [`GetProjectInput`](crate::input::GetProjectInput)
    pub fn builder() -> crate::input::get_project_input::Builder {
        crate::input::get_project_input::Builder::default()
    }
    /// Creates a new `GetProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProject {
    type Output =
        std::result::Result<crate::output::GetProjectOutput, crate::error::GetProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_project_error(response)
        } else {
            crate::operation_deser::parse_get_project_response(response)
        }
    }
}

/// Operation shape for `ListExperiments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_experiments`](crate::client::Client::list_experiments).
///
/// See [`crate::client::fluent_builders::ListExperiments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExperiments {
    _private: (),
}
impl ListExperiments {
    /// Creates a new builder-style object to manufacture [`ListExperimentsInput`](crate::input::ListExperimentsInput)
    pub fn builder() -> crate::input::list_experiments_input::Builder {
        crate::input::list_experiments_input::Builder::default()
    }
    /// Creates a new `ListExperiments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExperiments {
    type Output = std::result::Result<
        crate::output::ListExperimentsOutput,
        crate::error::ListExperimentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_experiments_error(response)
        } else {
            crate::operation_deser::parse_list_experiments_response(response)
        }
    }
}

/// Operation shape for `ListFeatures`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_features`](crate::client::Client::list_features).
///
/// See [`crate::client::fluent_builders::ListFeatures`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFeatures {
    _private: (),
}
impl ListFeatures {
    /// Creates a new builder-style object to manufacture [`ListFeaturesInput`](crate::input::ListFeaturesInput)
    pub fn builder() -> crate::input::list_features_input::Builder {
        crate::input::list_features_input::Builder::default()
    }
    /// Creates a new `ListFeatures` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFeatures {
    type Output =
        std::result::Result<crate::output::ListFeaturesOutput, crate::error::ListFeaturesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_features_error(response)
        } else {
            crate::operation_deser::parse_list_features_response(response)
        }
    }
}

/// Operation shape for `ListLaunches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_launches`](crate::client::Client::list_launches).
///
/// See [`crate::client::fluent_builders::ListLaunches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLaunches {
    _private: (),
}
impl ListLaunches {
    /// Creates a new builder-style object to manufacture [`ListLaunchesInput`](crate::input::ListLaunchesInput)
    pub fn builder() -> crate::input::list_launches_input::Builder {
        crate::input::list_launches_input::Builder::default()
    }
    /// Creates a new `ListLaunches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLaunches {
    type Output =
        std::result::Result<crate::output::ListLaunchesOutput, crate::error::ListLaunchesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_launches_error(response)
        } else {
            crate::operation_deser::parse_list_launches_response(response)
        }
    }
}

/// Operation shape for `ListProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_projects`](crate::client::Client::list_projects).
///
/// See [`crate::client::fluent_builders::ListProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjects {
    _private: (),
}
impl ListProjects {
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
    /// Creates a new `ListProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjects {
    type Output =
        std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_projects_error(response)
        } else {
            crate::operation_deser::parse_list_projects_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutProjectEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_project_events`](crate::client::Client::put_project_events).
///
/// See [`crate::client::fluent_builders::PutProjectEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutProjectEvents {
    _private: (),
}
impl PutProjectEvents {
    /// Creates a new builder-style object to manufacture [`PutProjectEventsInput`](crate::input::PutProjectEventsInput)
    pub fn builder() -> crate::input::put_project_events_input::Builder {
        crate::input::put_project_events_input::Builder::default()
    }
    /// Creates a new `PutProjectEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutProjectEvents {
    type Output = std::result::Result<
        crate::output::PutProjectEventsOutput,
        crate::error::PutProjectEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_project_events_error(response)
        } else {
            crate::operation_deser::parse_put_project_events_response(response)
        }
    }
}

/// Operation shape for `StartExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_experiment`](crate::client::Client::start_experiment).
///
/// See [`crate::client::fluent_builders::StartExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartExperiment {
    _private: (),
}
impl StartExperiment {
    /// Creates a new builder-style object to manufacture [`StartExperimentInput`](crate::input::StartExperimentInput)
    pub fn builder() -> crate::input::start_experiment_input::Builder {
        crate::input::start_experiment_input::Builder::default()
    }
    /// Creates a new `StartExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartExperiment {
    type Output = std::result::Result<
        crate::output::StartExperimentOutput,
        crate::error::StartExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_experiment_error(response)
        } else {
            crate::operation_deser::parse_start_experiment_response(response)
        }
    }
}

/// Operation shape for `StartLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_launch`](crate::client::Client::start_launch).
///
/// See [`crate::client::fluent_builders::StartLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartLaunch {
    _private: (),
}
impl StartLaunch {
    /// Creates a new builder-style object to manufacture [`StartLaunchInput`](crate::input::StartLaunchInput)
    pub fn builder() -> crate::input::start_launch_input::Builder {
        crate::input::start_launch_input::Builder::default()
    }
    /// Creates a new `StartLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartLaunch {
    type Output =
        std::result::Result<crate::output::StartLaunchOutput, crate::error::StartLaunchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_launch_error(response)
        } else {
            crate::operation_deser::parse_start_launch_response(response)
        }
    }
}

/// Operation shape for `StopExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_experiment`](crate::client::Client::stop_experiment).
///
/// See [`crate::client::fluent_builders::StopExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopExperiment {
    _private: (),
}
impl StopExperiment {
    /// Creates a new builder-style object to manufacture [`StopExperimentInput`](crate::input::StopExperimentInput)
    pub fn builder() -> crate::input::stop_experiment_input::Builder {
        crate::input::stop_experiment_input::Builder::default()
    }
    /// Creates a new `StopExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopExperiment {
    type Output =
        std::result::Result<crate::output::StopExperimentOutput, crate::error::StopExperimentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_experiment_error(response)
        } else {
            crate::operation_deser::parse_stop_experiment_response(response)
        }
    }
}

/// Operation shape for `StopLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_launch`](crate::client::Client::stop_launch).
///
/// See [`crate::client::fluent_builders::StopLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopLaunch {
    _private: (),
}
impl StopLaunch {
    /// Creates a new builder-style object to manufacture [`StopLaunchInput`](crate::input::StopLaunchInput)
    pub fn builder() -> crate::input::stop_launch_input::Builder {
        crate::input::stop_launch_input::Builder::default()
    }
    /// Creates a new `StopLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopLaunch {
    type Output =
        std::result::Result<crate::output::StopLaunchOutput, crate::error::StopLaunchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_launch_error(response)
        } else {
            crate::operation_deser::parse_stop_launch_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_experiment`](crate::client::Client::update_experiment).
///
/// See [`crate::client::fluent_builders::UpdateExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateExperiment {
    _private: (),
}
impl UpdateExperiment {
    /// Creates a new builder-style object to manufacture [`UpdateExperimentInput`](crate::input::UpdateExperimentInput)
    pub fn builder() -> crate::input::update_experiment_input::Builder {
        crate::input::update_experiment_input::Builder::default()
    }
    /// Creates a new `UpdateExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateExperiment {
    type Output = std::result::Result<
        crate::output::UpdateExperimentOutput,
        crate::error::UpdateExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_experiment_error(response)
        } else {
            crate::operation_deser::parse_update_experiment_response(response)
        }
    }
}

/// Operation shape for `UpdateFeature`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_feature`](crate::client::Client::update_feature).
///
/// See [`crate::client::fluent_builders::UpdateFeature`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFeature {
    _private: (),
}
impl UpdateFeature {
    /// Creates a new builder-style object to manufacture [`UpdateFeatureInput`](crate::input::UpdateFeatureInput)
    pub fn builder() -> crate::input::update_feature_input::Builder {
        crate::input::update_feature_input::Builder::default()
    }
    /// Creates a new `UpdateFeature` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFeature {
    type Output =
        std::result::Result<crate::output::UpdateFeatureOutput, crate::error::UpdateFeatureError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_feature_error(response)
        } else {
            crate::operation_deser::parse_update_feature_response(response)
        }
    }
}

/// Operation shape for `UpdateLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_launch`](crate::client::Client::update_launch).
///
/// See [`crate::client::fluent_builders::UpdateLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLaunch {
    _private: (),
}
impl UpdateLaunch {
    /// Creates a new builder-style object to manufacture [`UpdateLaunchInput`](crate::input::UpdateLaunchInput)
    pub fn builder() -> crate::input::update_launch_input::Builder {
        crate::input::update_launch_input::Builder::default()
    }
    /// Creates a new `UpdateLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLaunch {
    type Output =
        std::result::Result<crate::output::UpdateLaunchOutput, crate::error::UpdateLaunchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_launch_error(response)
        } else {
            crate::operation_deser::parse_update_launch_response(response)
        }
    }
}

/// Operation shape for `UpdateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_project`](crate::client::Client::update_project).
///
/// See [`crate::client::fluent_builders::UpdateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProject {
    _private: (),
}
impl UpdateProject {
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
    /// Creates a new `UpdateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProject {
    type Output =
        std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_project_error(response)
        } else {
            crate::operation_deser::parse_update_project_response(response)
        }
    }
}

/// Operation shape for `UpdateProjectDataDelivery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_project_data_delivery`](crate::client::Client::update_project_data_delivery).
///
/// See [`crate::client::fluent_builders::UpdateProjectDataDelivery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProjectDataDelivery {
    _private: (),
}
impl UpdateProjectDataDelivery {
    /// Creates a new builder-style object to manufacture [`UpdateProjectDataDeliveryInput`](crate::input::UpdateProjectDataDeliveryInput)
    pub fn builder() -> crate::input::update_project_data_delivery_input::Builder {
        crate::input::update_project_data_delivery_input::Builder::default()
    }
    /// Creates a new `UpdateProjectDataDelivery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProjectDataDelivery {
    type Output = std::result::Result<
        crate::output::UpdateProjectDataDeliveryOutput,
        crate::error::UpdateProjectDataDeliveryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_project_data_delivery_error(response)
        } else {
            crate::operation_deser::parse_update_project_data_delivery_response(response)
        }
    }
}
