// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudWatch Evidently
///
/// Client for invoking operations on Amazon CloudWatch Evidently. Each operation on Amazon CloudWatch Evidently is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_evidently::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_evidently::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_evidently::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchEvaluateFeature` operation.
    ///
    /// See [`BatchEvaluateFeature`](crate::client::fluent_builders::BatchEvaluateFeature) for more information about the
    /// operation and its arguments.
    pub fn batch_evaluate_feature(&self) -> fluent_builders::BatchEvaluateFeature<C, M, R> {
        fluent_builders::BatchEvaluateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateExperiment` operation.
    ///
    /// See [`CreateExperiment`](crate::client::fluent_builders::CreateExperiment) for more information about the
    /// operation and its arguments.
    pub fn create_experiment(&self) -> fluent_builders::CreateExperiment<C, M, R> {
        fluent_builders::CreateExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFeature` operation.
    ///
    /// See [`CreateFeature`](crate::client::fluent_builders::CreateFeature) for more information about the
    /// operation and its arguments.
    pub fn create_feature(&self) -> fluent_builders::CreateFeature<C, M, R> {
        fluent_builders::CreateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLaunch` operation.
    ///
    /// See [`CreateLaunch`](crate::client::fluent_builders::CreateLaunch) for more information about the
    /// operation and its arguments.
    pub fn create_launch(&self) -> fluent_builders::CreateLaunch<C, M, R> {
        fluent_builders::CreateLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteExperiment` operation.
    ///
    /// See [`DeleteExperiment`](crate::client::fluent_builders::DeleteExperiment) for more information about the
    /// operation and its arguments.
    pub fn delete_experiment(&self) -> fluent_builders::DeleteExperiment<C, M, R> {
        fluent_builders::DeleteExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFeature` operation.
    ///
    /// See [`DeleteFeature`](crate::client::fluent_builders::DeleteFeature) for more information about the
    /// operation and its arguments.
    pub fn delete_feature(&self) -> fluent_builders::DeleteFeature<C, M, R> {
        fluent_builders::DeleteFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLaunch` operation.
    ///
    /// See [`DeleteLaunch`](crate::client::fluent_builders::DeleteLaunch) for more information about the
    /// operation and its arguments.
    pub fn delete_launch(&self) -> fluent_builders::DeleteLaunch<C, M, R> {
        fluent_builders::DeleteLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EvaluateFeature` operation.
    ///
    /// See [`EvaluateFeature`](crate::client::fluent_builders::EvaluateFeature) for more information about the
    /// operation and its arguments.
    pub fn evaluate_feature(&self) -> fluent_builders::EvaluateFeature<C, M, R> {
        fluent_builders::EvaluateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExperiment` operation.
    ///
    /// See [`GetExperiment`](crate::client::fluent_builders::GetExperiment) for more information about the
    /// operation and its arguments.
    pub fn get_experiment(&self) -> fluent_builders::GetExperiment<C, M, R> {
        fluent_builders::GetExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExperimentResults` operation.
    ///
    /// See [`GetExperimentResults`](crate::client::fluent_builders::GetExperimentResults) for more information about the
    /// operation and its arguments.
    pub fn get_experiment_results(&self) -> fluent_builders::GetExperimentResults<C, M, R> {
        fluent_builders::GetExperimentResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFeature` operation.
    ///
    /// See [`GetFeature`](crate::client::fluent_builders::GetFeature) for more information about the
    /// operation and its arguments.
    pub fn get_feature(&self) -> fluent_builders::GetFeature<C, M, R> {
        fluent_builders::GetFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunch` operation.
    ///
    /// See [`GetLaunch`](crate::client::fluent_builders::GetLaunch) for more information about the
    /// operation and its arguments.
    pub fn get_launch(&self) -> fluent_builders::GetLaunch<C, M, R> {
        fluent_builders::GetLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProject` operation.
    ///
    /// See [`GetProject`](crate::client::fluent_builders::GetProject) for more information about the
    /// operation and its arguments.
    pub fn get_project(&self) -> fluent_builders::GetProject<C, M, R> {
        fluent_builders::GetProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListExperiments` operation.
    ///
    /// See [`ListExperiments`](crate::client::fluent_builders::ListExperiments) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListExperiments::into_paginator).
    pub fn list_experiments(&self) -> fluent_builders::ListExperiments<C, M, R> {
        fluent_builders::ListExperiments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFeatures` operation.
    ///
    /// See [`ListFeatures`](crate::client::fluent_builders::ListFeatures) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFeatures::into_paginator).
    pub fn list_features(&self) -> fluent_builders::ListFeatures<C, M, R> {
        fluent_builders::ListFeatures::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLaunches` operation.
    ///
    /// See [`ListLaunches`](crate::client::fluent_builders::ListLaunches) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLaunches::into_paginator).
    pub fn list_launches(&self) -> fluent_builders::ListLaunches<C, M, R> {
        fluent_builders::ListLaunches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProjects::into_paginator).
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutProjectEvents` operation.
    ///
    /// See [`PutProjectEvents`](crate::client::fluent_builders::PutProjectEvents) for more information about the
    /// operation and its arguments.
    pub fn put_project_events(&self) -> fluent_builders::PutProjectEvents<C, M, R> {
        fluent_builders::PutProjectEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartExperiment` operation.
    ///
    /// See [`StartExperiment`](crate::client::fluent_builders::StartExperiment) for more information about the
    /// operation and its arguments.
    pub fn start_experiment(&self) -> fluent_builders::StartExperiment<C, M, R> {
        fluent_builders::StartExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartLaunch` operation.
    ///
    /// See [`StartLaunch`](crate::client::fluent_builders::StartLaunch) for more information about the
    /// operation and its arguments.
    pub fn start_launch(&self) -> fluent_builders::StartLaunch<C, M, R> {
        fluent_builders::StartLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopExperiment` operation.
    ///
    /// See [`StopExperiment`](crate::client::fluent_builders::StopExperiment) for more information about the
    /// operation and its arguments.
    pub fn stop_experiment(&self) -> fluent_builders::StopExperiment<C, M, R> {
        fluent_builders::StopExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopLaunch` operation.
    ///
    /// See [`StopLaunch`](crate::client::fluent_builders::StopLaunch) for more information about the
    /// operation and its arguments.
    pub fn stop_launch(&self) -> fluent_builders::StopLaunch<C, M, R> {
        fluent_builders::StopLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateExperiment` operation.
    ///
    /// See [`UpdateExperiment`](crate::client::fluent_builders::UpdateExperiment) for more information about the
    /// operation and its arguments.
    pub fn update_experiment(&self) -> fluent_builders::UpdateExperiment<C, M, R> {
        fluent_builders::UpdateExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFeature` operation.
    ///
    /// See [`UpdateFeature`](crate::client::fluent_builders::UpdateFeature) for more information about the
    /// operation and its arguments.
    pub fn update_feature(&self) -> fluent_builders::UpdateFeature<C, M, R> {
        fluent_builders::UpdateFeature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLaunch` operation.
    ///
    /// See [`UpdateLaunch`](crate::client::fluent_builders::UpdateLaunch) for more information about the
    /// operation and its arguments.
    pub fn update_launch(&self) -> fluent_builders::UpdateLaunch<C, M, R> {
        fluent_builders::UpdateLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProjectDataDelivery` operation.
    ///
    /// See [`UpdateProjectDataDelivery`](crate::client::fluent_builders::UpdateProjectDataDelivery) for more information about the
    /// operation and its arguments.
    pub fn update_project_data_delivery(
        &self,
    ) -> fluent_builders::UpdateProjectDataDelivery<C, M, R> {
        fluent_builders::UpdateProjectDataDelivery::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchEvaluateFeature`.
    ///
    /// <p>This operation assigns feature variation to user sessions. For each user session, you pass in an <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the variation.</p>
    /// <p>The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an override rule, the user is served the variation specified by that rule.</p>
    /// <p>Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch, the variation they are served depends on the allocation of the various feature variations used for the launch.</p>
    /// <p>If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be assigned to a variation in the experiment. The chance of this depends on the percentage of users that are allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on the allocation of the various feature variations used for the experiment. </p>
    /// <p>If the user is not assigned to a launch or experiment, they are served the default variation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchEvaluateFeature<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_evaluate_feature_input::Builder,
    }
    impl<C, M, R> BatchEvaluateFeature<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchEvaluateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchEvaluateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchEvaluateFeatureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchEvaluateFeatureInputOperationOutputAlias,
                crate::output::BatchEvaluateFeatureOutput,
                crate::error::BatchEvaluateFeatureError,
                crate::input::BatchEvaluateFeatureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// Appends an item to `requests`.
        ///
        /// To override the contents of this collection use [`set_requests`](Self::set_requests).
        ///
        /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
        pub fn requests(mut self, input: crate::model::EvaluationRequest) -> Self {
            self.inner = self.inner.requests(input);
            self
        }
        /// <p>An array of structures, where each structure assigns a feature variation to one user session.</p>
        pub fn set_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExperiment`.
    ///
    /// <p>Creates an Evidently <i>experiment</i>. Before you create an experiment, you must create the feature to use for the experiment.</p>
    /// <p>An experiment helps you make feature design decisions based on evidence and data. An experiment can test as many as five variations at once. Evidently collects experiment data and analyzes it by statistical methods, and provides clear recommendations about which variations perform better.</p>
    /// <p>Don't use this operation to update an existing experiment. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_experiment_input::Builder,
    }
    impl<C, M, R> CreateExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateExperimentInputOperationOutputAlias,
                crate::output::CreateExperimentOutput,
                crate::error::CreateExperimentError,
                crate::input::CreateExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to create the new experiment in.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>A name for the new experiment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the new experiment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `treatments`.
        ///
        /// To override the contents of this collection use [`set_treatments`](Self::set_treatments).
        ///
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn treatments(mut self, input: crate::model::TreatmentConfig) -> Self {
            self.inner = self.inner.treatments(input);
            self
        }
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn set_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        ) -> Self {
            self.inner = self.inner.set_treatments(input);
            self
        }
        /// Appends an item to `metricGoals`.
        ///
        /// To override the contents of this collection use [`set_metric_goals`](Self::set_metric_goals).
        ///
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn metric_goals(mut self, input: crate::model::MetricGoalConfig) -> Self {
            self.inner = self.inner.metric_goals(input);
            self
        }
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn set_metric_goals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_goals(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.inner = self.inner.sampling_rate(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn online_ab_config(mut self, input: crate::model::OnlineAbConfig) -> Self {
            self.inner = self.inner.online_ab_config(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn set_online_ab_config(
            mut self,
            input: std::option::Option<crate::model::OnlineAbConfig>,
        ) -> Self {
            self.inner = self.inner.set_online_ab_config(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an experiment.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the experiment.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an experiment.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFeature`.
    ///
    /// <p>Creates an Evidently <i>feature</i> that you want to launch or test. You can define up to five variations of a feature, and use these variations in your launches and experiments. A feature must be created in a project. For information about creating a project, see <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html">CreateProject</a>.</p>
    /// <p>Don't use this operation to update an existing feature. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html">UpdateFeature</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFeature<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_feature_input::Builder,
    }
    impl<C, M, R> CreateFeature<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFeatureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFeatureInputOperationOutputAlias,
                crate::output::CreateFeatureOutput,
                crate::error::CreateFeatureError,
                crate::input::CreateFeatureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that is to contain the new feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that is to contain the new feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name for the new feature.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the new feature.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.inner = self.inner.evaluation_strategy(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_strategy(input);
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `variations`.
        ///
        /// To override the contents of this collection use [`set_variations`](Self::set_variations).
        ///
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn variations(mut self, input: crate::model::VariationConfig) -> Self {
            self.inner = self.inner.variations(input);
            self
        }
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn set_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_variations(input);
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_variation(input.into());
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_variation(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a feature.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the feature.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a feature.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `entityOverrides`.
        ///
        /// To override the contents of this collection use [`set_entity_overrides`](Self::set_entity_overrides).
        ///
        /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn entity_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.entity_overrides(k.into(), v.into());
            self
        }
        /// <p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn set_entity_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entity_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLaunch`.
    ///
    /// <p>Creates a <i>launch</i> of a given feature. Before you create a launch, you must create the feature to use for the launch.</p>
    /// <p>You can use a launch to safely validate new features by serving them to a specified percentage of your users while you roll out the feature. You can monitor the performance of the new feature to help you decide when to ramp up traffic to more users. This helps you reduce risk and identify unintended consequences before you fully launch the feature.</p>
    /// <p>Don't use this operation to update an existing launch. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html">UpdateLaunch</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLaunch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_launch_input::Builder,
    }
    impl<C, M, R> CreateLaunch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLaunchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLaunchInputOperationOutputAlias,
                crate::output::CreateLaunchOutput,
                crate::error::CreateLaunchError,
                crate::input::CreateLaunchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to create the launch in.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to create the launch in.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name for the new launch.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the new launch.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn scheduled_splits_config(
            mut self,
            input: crate::model::ScheduledSplitsLaunchConfig,
        ) -> Self {
            self.inner = self.inner.scheduled_splits_config(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn set_scheduled_splits_config(
            mut self,
            input: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_splits_config(input);
            self
        }
        /// Appends an item to `metricMonitors`.
        ///
        /// To override the contents of this collection use [`set_metric_monitors`](Self::set_metric_monitors).
        ///
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn metric_monitors(mut self, input: crate::model::MetricMonitorConfig) -> Self {
            self.inner = self.inner.metric_monitors(input);
            self
        }
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn set_metric_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_monitors(input);
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn groups(mut self, input: crate::model::LaunchGroupConfig) -> Self {
            self.inner = self.inner.groups(input);
            self
        }
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a launch.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the launch.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a launch.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments. Use projects to group similar features together.</p>
    /// <p>To update an existing project, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html">UpdateProject</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
        pub fn data_delivery(mut self, input: crate::model::ProjectDataDeliveryConfig) -> Self {
            self.inner = self.inner.data_delivery(input);
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
        pub fn set_data_delivery(
            mut self,
            input: std::option::Option<crate::model::ProjectDataDeliveryConfig>,
        ) -> Self {
            self.inner = self.inner.set_data_delivery(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a project.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the project.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with a project.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExperiment`.
    ///
    /// <p>Deletes an Evidently experiment. The feature used for the experiment is not deleted.</p>
    /// <p>To stop an experiment without deleting it, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html">StopExperiment</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_experiment_input::Builder,
    }
    impl<C, M, R> DeleteExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteExperimentInputOperationOutputAlias,
                crate::output::DeleteExperimentOutput,
                crate::error::DeleteExperimentError,
                crate::input::DeleteExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFeature`.
    ///
    /// <p>Deletes an Evidently feature.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFeature<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_feature_input::Builder,
    }
    impl<C, M, R> DeleteFeature<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFeatureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFeatureInputOperationOutputAlias,
                crate::output::DeleteFeatureOutput,
                crate::error::DeleteFeatureError,
                crate::input::DeleteFeatureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature to delete.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature to delete.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLaunch`.
    ///
    /// <p>Deletes an Evidently launch. The feature used for the launch is not deleted.</p>
    /// <p>To stop a launch without deleting it, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html">StopLaunch</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLaunch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_launch_input::Builder,
    }
    impl<C, M, R> DeleteLaunch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLaunchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLaunchInputOperationOutputAlias,
                crate::output::DeleteLaunchOutput,
                crate::error::DeleteLaunchError,
                crate::input::DeleteLaunchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch to delete.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch to delete.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an Evidently project. Before you can delete a project, you must delete all the features that the project contains. To delete a feature, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html">DeleteFeature</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project to delete.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to delete.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EvaluateFeature`.
    ///
    /// <p>This operation assigns a feature variation to one given user session. You pass in an <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the variation.</p>
    /// <p>The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an override rule, the user is served the variation specified by that rule.</p>
    /// <p>Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch, the variation they are served depends on the allocation of the various feature variations used for the launch.</p>
    /// <p>If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be assigned to a variation in the experiment. The chance of this depends on the percentage of users that are allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on the allocation of the various feature variations used for the experiment. </p>
    /// <p>If the user is not assigned to a launch or experiment, they are served the default variation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EvaluateFeature<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::evaluate_feature_input::Builder,
    }
    impl<C, M, R> EvaluateFeature<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EvaluateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EvaluateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::EvaluateFeatureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EvaluateFeatureInputOperationOutputAlias,
                crate::output::EvaluateFeatureOutput,
                crate::error::EvaluateFeatureError,
                crate::input::EvaluateFeatureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains this feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains this feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
        /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn evaluation_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_context(input.into());
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn set_evaluation_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExperiment`.
    ///
    /// <p>Returns the details about one experiment. You must already know the experiment name. To retrieve a list of experiments in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html">ListExperiments</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_experiment_input::Builder,
    }
    impl<C, M, R> GetExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExperimentInputOperationOutputAlias,
                crate::output::GetExperimentOutput,
                crate::error::GetExperimentError,
                crate::input::GetExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment that you want to see the details of.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment that you want to see the details of.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExperimentResults`.
    ///
    /// <p>Retrieves the results of a running or completed experiment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExperimentResults<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_experiment_results_input::Builder,
    }
    impl<C, M, R> GetExperimentResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExperimentResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExperimentResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExperimentResultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExperimentResultsInputOperationOutputAlias,
                crate::output::GetExperimentResultsOutput,
                crate::error::GetExperimentResultsError,
                crate::input::GetExperimentResultsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to retrieve the results of.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to retrieve the results of.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>The date and time that the experiment started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The date and time that the experiment started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The date and time that the experiment ended, if it is completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The date and time that the experiment ended, if it is completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// Appends an item to `metricNames`.
        ///
        /// To override the contents of this collection use [`set_metric_names`](Self::set_metric_names).
        ///
        /// <p>The names of the experiment metrics that you want to see the results of.</p>
        pub fn metric_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_names(input.into());
            self
        }
        /// <p>The names of the experiment metrics that you want to see the results of.</p>
        pub fn set_metric_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_metric_names(input);
            self
        }
        /// Appends an item to `treatmentNames`.
        ///
        /// To override the contents of this collection use [`set_treatment_names`](Self::set_treatment_names).
        ///
        /// <p>The names of the experiment treatments that you want to see the results for.</p>
        pub fn treatment_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.treatment_names(input.into());
            self
        }
        /// <p>The names of the experiment treatments that you want to see the results for.</p>
        pub fn set_treatment_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_treatment_names(input);
            self
        }
        /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
        pub fn base_stat(mut self, input: crate::model::ExperimentBaseStat) -> Self {
            self.inner = self.inner.base_stat(input);
            self
        }
        /// <p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>
        pub fn set_base_stat(
            mut self,
            input: std::option::Option<crate::model::ExperimentBaseStat>,
        ) -> Self {
            self.inner = self.inner.set_base_stat(input);
            self
        }
        /// Appends an item to `resultStats`.
        ///
        /// To override the contents of this collection use [`set_result_stats`](Self::set_result_stats).
        ///
        /// <p>The statistics that you want to see in the returned results.</p>
        /// <ul>
        /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
        /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
        /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
        /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
        /// </ul>
        pub fn result_stats(mut self, input: crate::model::ExperimentResultRequestType) -> Self {
            self.inner = self.inner.result_stats(input);
            self
        }
        /// <p>The statistics that you want to see in the returned results.</p>
        /// <ul>
        /// <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li>
        /// <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li>
        /// <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li>
        /// <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li>
        /// </ul>
        pub fn set_result_stats(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentResultRequestType>>,
        ) -> Self {
            self.inner = self.inner.set_result_stats(input);
            self
        }
        /// Appends an item to `reportNames`.
        ///
        /// To override the contents of this collection use [`set_report_names`](Self::set_report_names).
        ///
        /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
        pub fn report_names(mut self, input: crate::model::ExperimentReportName) -> Self {
            self.inner = self.inner.report_names(input);
            self
        }
        /// <p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>
        pub fn set_report_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentReportName>>,
        ) -> Self {
            self.inner = self.inner.set_report_names(input);
            self
        }
        /// <p>In seconds, the amount of time to aggregate results together. </p>
        pub fn period(mut self, input: i64) -> Self {
            self.inner = self.inner.period(input);
            self
        }
        /// <p>In seconds, the amount of time to aggregate results together. </p>
        pub fn set_period(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFeature`.
    ///
    /// <p>Returns the details about one feature. You must already know the feature name. To retrieve a list of features in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html">ListFeatures</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFeature<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_feature_input::Builder,
    }
    impl<C, M, R> GetFeature<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFeatureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFeatureInputOperationOutputAlias,
                crate::output::GetFeatureOutput,
                crate::error::GetFeatureError,
                crate::input::GetFeatureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature that you want to retrieve information for.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature that you want to retrieve information for.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunch`.
    ///
    /// <p>Returns the details about one launch. You must already know the launch name. To retrieve a list of launches in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html">ListLaunches</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_launch_input::Builder,
    }
    impl<C, M, R> GetLaunch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLaunchInputOperationOutputAlias,
                crate::output::GetLaunchOutput,
                crate::error::GetLaunchError,
                crate::input::GetLaunchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch that you want to see the details of.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch that you want to see the details of.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProject`.
    ///
    /// <p>Returns the details about one launch. You must already know the project name. To retrieve a list of projects in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html">ListProjects</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_project_input::Builder,
    }
    impl<C, M, R> GetProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProjectInputOperationOutputAlias,
                crate::output::GetProjectOutput,
                crate::error::GetProjectError,
                crate::input::GetProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to see the details of.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to see the details of.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExperiments`.
    ///
    /// <p>Returns configuration details about all the experiments in the specified project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExperiments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_experiments_input::Builder,
    }
    impl<C, M, R> ListExperiments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListExperiments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExperimentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExperimentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListExperimentsInputOperationOutputAlias,
                crate::output::ListExperimentsOutput,
                crate::error::ListExperimentsError,
                crate::input::ListExperimentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExperimentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExperimentsPaginator<C, M, R> {
            crate::paginator::ListExperimentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ARN of the project to return the experiment list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the experiment list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFeatures`.
    ///
    /// <p>Returns configuration details about all the features in the specified project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFeatures<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_features_input::Builder,
    }
    impl<C, M, R> ListFeatures<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFeatures`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFeaturesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFeaturesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFeaturesInputOperationOutputAlias,
                crate::output::ListFeaturesOutput,
                crate::error::ListFeaturesError,
                crate::input::ListFeaturesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFeaturesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFeaturesPaginator<C, M, R> {
            crate::paginator::ListFeaturesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ARN of the project to return the feature list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the feature list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunches`.
    ///
    /// <p>Returns configuration details about all the launches in the specified project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLaunches<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_launches_input::Builder,
    }
    impl<C, M, R> ListLaunches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLaunches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLaunchesInputOperationOutputAlias,
                crate::output::ListLaunchesOutput,
                crate::error::ListLaunchesError,
                crate::input::ListLaunchesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLaunchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLaunchesPaginator<C, M, R> {
            crate::paginator::ListLaunchesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ARN of the project to return the launch list from.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to return the launch list from.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Returns configuration details about all the projects in the current Region in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProjectsPaginator<C, M, R> {
            crate::paginator::ListProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with an Evidently resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProjectEvents`.
    ///
    /// <p>Sends performance events to Evidently. These events can be used to evaluate a launch or an experiment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutProjectEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_project_events_input::Builder,
    }
    impl<C, M, R> PutProjectEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutProjectEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProjectEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProjectEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutProjectEventsInputOperationOutputAlias,
                crate::output::PutProjectEventsOutput,
                crate::error::PutProjectEventsError,
                crate::input::PutProjectEventsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project to write the events to.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to write the events to.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            self.inner = self.inner.events(input);
            self
        }
        /// <p>An array of event structures that contain the performance data that is being sent to Evidently.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.inner = self.inner.set_events(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExperiment`.
    ///
    /// <p>Starts an existing experiment. To create an experiment, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html">CreateExperiment</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_experiment_input::Builder,
    }
    impl<C, M, R> StartExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartExperimentInputOperationOutputAlias,
                crate::output::StartExperimentOutput,
                crate::error::StartExperimentError,
                crate::input::StartExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment to start.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to start.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to start.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to start.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>The date and time to end the experiment.</p>
        pub fn analysis_complete_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.analysis_complete_time(input);
            self
        }
        /// <p>The date and time to end the experiment.</p>
        pub fn set_analysis_complete_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_analysis_complete_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartLaunch`.
    ///
    /// <p>Starts an existing launch. To create a launch, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html">CreateLaunch</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartLaunch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_launch_input::Builder,
    }
    impl<C, M, R> StartLaunch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartLaunchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartLaunchInputOperationOutputAlias,
                crate::output::StartLaunchOutput,
                crate::error::StartLaunchError,
                crate::input::StartLaunchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch to start.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch to start.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch to start.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch to start.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopExperiment`.
    ///
    /// <p>Stops an experiment that is currently running. If you stop an experiment, you can't resume it or restart it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_experiment_input::Builder,
    }
    impl<C, M, R> StopExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopExperimentInputOperationOutputAlias,
                crate::output::StopExperimentOutput,
                crate::error::StopExperimentError,
                crate::input::StopExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment to stop.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment to stop.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to stop.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to stop.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn desired_state(mut self, input: crate::model::ExperimentStopDesiredState) -> Self {
            self.inner = self.inner.desired_state(input);
            self
        }
        /// <p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::ExperimentStopDesiredState>,
        ) -> Self {
            self.inner = self.inner.set_desired_state(input);
            self
        }
        /// <p>A string that describes why you are stopping the experiment.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A string that describes why you are stopping the experiment.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopLaunch`.
    ///
    /// <p>Stops a launch that is currently running. After you stop a launch, you will not be able to resume it or restart it. Also, it will not be evaluated as a rule for traffic allocation, and the traffic that was allocated to the launch will instead be available to the feature's experiment, if there is one. Otherwise, all traffic will be served the default variation after the launch is stopped.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopLaunch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_launch_input::Builder,
    }
    impl<C, M, R> StopLaunch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::StopLaunchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopLaunchInputOperationOutputAlias,
                crate::output::StopLaunchOutput,
                crate::error::StopLaunchError,
                crate::input::StopLaunchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch that you want to stop.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch to stop.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch to stop.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
        /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn desired_state(mut self, input: crate::model::LaunchStopDesiredState) -> Self {
            self.inner = self.inner.desired_state(input);
            self
        }
        /// <p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::LaunchStopDesiredState>,
        ) -> Self {
            self.inner = self.inner.set_desired_state(input);
            self
        }
        /// <p>A string that describes why you are stopping the launch.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>A string that describes why you are stopping the launch.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently resource. Projects, features, launches, and experiments can be tagged.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Evidently resource that you're removing tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateExperiment`.
    ///
    /// <p>Updates an Evidently experiment. </p>
    /// <p>Don't use this operation to update an experiment's tag. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_experiment_input::Builder,
    }
    impl<C, M, R> UpdateExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateExperimentInputOperationOutputAlias,
                crate::output::UpdateExperimentOutput,
                crate::error::UpdateExperimentError,
                crate::input::UpdateExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the experiment that you want to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the experiment to update.</p>
        pub fn experiment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment(input.into());
            self
        }
        /// <p>The name of the experiment to update.</p>
        pub fn set_experiment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_experiment(input);
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `treatments`.
        ///
        /// To override the contents of this collection use [`set_treatments`](Self::set_treatments).
        ///
        /// <p>An array of structures that define the variations being tested in the experiment.</p>
        pub fn treatments(mut self, input: crate::model::TreatmentConfig) -> Self {
            self.inner = self.inner.treatments(input);
            self
        }
        /// <p>An array of structures that define the variations being tested in the experiment.</p>
        pub fn set_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TreatmentConfig>>,
        ) -> Self {
            self.inner = self.inner.set_treatments(input);
            self
        }
        /// Appends an item to `metricGoals`.
        ///
        /// To override the contents of this collection use [`set_metric_goals`](Self::set_metric_goals).
        ///
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn metric_goals(mut self, input: crate::model::MetricGoalConfig) -> Self {
            self.inner = self.inner.metric_goals(input);
            self
        }
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn set_metric_goals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricGoalConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_goals(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.inner = self.inner.sampling_rate(input);
            self
        }
        /// <p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn online_ab_config(mut self, input: crate::model::OnlineAbConfig) -> Self {
            self.inner = self.inner.online_ab_config(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn set_online_ab_config(
            mut self,
            input: std::option::Option<crate::model::OnlineAbConfig>,
        ) -> Self {
            self.inner = self.inner.set_online_ab_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFeature`.
    ///
    /// <p>Updates an existing feature.</p>
    /// <p>You can't use this operation to update the tags of an existing feature. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFeature<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_feature_input::Builder,
    }
    impl<C, M, R> UpdateFeature<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFeature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFeatureOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFeatureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFeatureInputOperationOutputAlias,
                crate::output::UpdateFeatureOutput,
                crate::error::UpdateFeatureError,
                crate::input::UpdateFeatureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the feature to be updated.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature to be updated.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the feature to be updated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature(input.into());
            self
        }
        /// <p>The name of the feature to be updated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.inner = self.inner.evaluation_strategy(input);
            self
        }
        /// <p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_strategy(input);
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the feature.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `addOrUpdateVariations`.
        ///
        /// To override the contents of this collection use [`set_add_or_update_variations`](Self::set_add_or_update_variations).
        ///
        /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
        pub fn add_or_update_variations(mut self, input: crate::model::VariationConfig) -> Self {
            self.inner = self.inner.add_or_update_variations(input);
            self
        }
        /// <p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>
        pub fn set_add_or_update_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_add_or_update_variations(input);
            self
        }
        /// Appends an item to `removeVariations`.
        ///
        /// To override the contents of this collection use [`set_remove_variations`](Self::set_remove_variations).
        ///
        /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
        /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
        pub fn remove_variations(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_variations(input.into());
            self
        }
        /// <p>Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and does not report an error.</p>
        /// <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>
        pub fn set_remove_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_variations(input);
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_variation(input.into());
            self
        }
        /// <p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_variation(input);
            self
        }
        /// Adds a key-value pair to `entityOverrides`.
        ///
        /// To override the contents of this collection use [`set_entity_overrides`](Self::set_entity_overrides).
        ///
        /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn entity_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.entity_overrides(k.into(), v.into());
            self
        }
        /// <p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>
        pub fn set_entity_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entity_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunch`.
    ///
    /// <p>Updates a launch of a given feature. </p>
    /// <p>Don't use this operation to update the tags of an existing launch. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLaunch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_launch_input::Builder,
    }
    impl<C, M, R> UpdateLaunch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLaunchInputOperationOutputAlias,
                crate::output::UpdateLaunchOutput,
                crate::error::UpdateLaunchError,
                crate::input::UpdateLaunchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch that you want to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>The name of the launch that is to be updated.</p>
        pub fn launch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch(input.into());
            self
        }
        /// <p>The name of the launch that is to be updated.</p>
        pub fn set_launch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch(input);
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the launch.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn groups(mut self, input: crate::model::LaunchGroupConfig) -> Self {
            self.inner = self.inner.groups(input);
            self
        }
        /// <p>An array of structures that contains the feature and variations that are to be used for the launch.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchGroupConfig>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// Appends an item to `metricMonitors`.
        ///
        /// To override the contents of this collection use [`set_metric_monitors`](Self::set_metric_monitors).
        ///
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn metric_monitors(mut self, input: crate::model::MetricMonitorConfig) -> Self {
            self.inner = self.inner.metric_monitors(input);
            self
        }
        /// <p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>
        pub fn set_metric_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricMonitorConfig>>,
        ) -> Self {
            self.inner = self.inner.set_metric_monitors(input);
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.randomization_salt(input.into());
            self
        }
        /// <p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_randomization_salt(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn scheduled_splits_config(
            mut self,
            input: crate::model::ScheduledSplitsLaunchConfig,
        ) -> Self {
            self.inner = self.inner.scheduled_splits_config(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn set_scheduled_splits_config(
            mut self,
            input: std::option::Option<crate::model::ScheduledSplitsLaunchConfig>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_splits_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Updates the description of an existing project.</p>
    /// <p>To create a new project, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html">CreateProject</a>.</p>
    /// <p>Don't use this operation to update the data storage options of a project. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html">UpdateProjectDataDelivery</a>. </p>
    /// <p>Don't use this operation to update the tags of a project. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project to update.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project to update.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProjectDataDelivery`.
    ///
    /// <p>Updates the data storage options for this project. If you store evaluation events, you an keep them and analyze them on your own. If you choose not to store evaluation events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>
    /// <p>You can't specify both <code>cloudWatchLogs</code> and <code>s3Destination</code> in the same operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProjectDataDelivery<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_data_delivery_input::Builder,
    }
    impl<C, M, R> UpdateProjectDataDelivery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProjectDataDelivery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectDataDeliveryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectDataDeliveryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectDataDeliveryInputOperationOutputAlias,
                crate::output::UpdateProjectDataDeliveryOutput,
                crate::error::UpdateProjectDataDeliveryError,
                crate::input::UpdateProjectDataDeliveryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project(input.into());
            self
        }
        /// <p>The name or ARN of the project that you want to modify the data storage options for.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project(input);
            self
        }
        /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
        pub fn s3_destination(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.inner = self.inner.s3_destination(input);
            self
        }
        /// <p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
        /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
        pub fn cloud_watch_logs(
            mut self,
            input: crate::model::CloudWatchLogsDestinationConfig,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs(input);
            self
        }
        /// <p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
