// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectDataDeliveryOutput {
    /// <p>A structure containing details about the project that you updated.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl UpdateProjectDataDeliveryOutput {
    /// <p>A structure containing details about the project that you updated.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for UpdateProjectDataDeliveryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectDataDeliveryOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`UpdateProjectDataDeliveryOutput`](crate::output::UpdateProjectDataDeliveryOutput)
pub mod update_project_data_delivery_output {
    /// A builder for [`UpdateProjectDataDeliveryOutput`](crate::output::UpdateProjectDataDeliveryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>A structure containing details about the project that you updated.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>A structure containing details about the project that you updated.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectDataDeliveryOutput`](crate::output::UpdateProjectDataDeliveryOutput)
        pub fn build(self) -> crate::output::UpdateProjectDataDeliveryOutput {
            crate::output::UpdateProjectDataDeliveryOutput {
                project: self.project,
            }
        }
    }
}
impl UpdateProjectDataDeliveryOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectDataDeliveryOutput`](crate::output::UpdateProjectDataDeliveryOutput)
    pub fn builder() -> crate::output::update_project_data_delivery_output::Builder {
        crate::output::update_project_data_delivery_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectOutput {
    /// <p>A structure containing information about the updated project.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl UpdateProjectOutput {
    /// <p>A structure containing information about the updated project.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for UpdateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
pub mod update_project_output {
    /// A builder for [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>A structure containing information about the updated project.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>A structure containing information about the updated project.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
        pub fn build(self) -> crate::output::UpdateProjectOutput {
            crate::output::UpdateProjectOutput {
                project: self.project,
            }
        }
    }
}
impl UpdateProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    pub fn builder() -> crate::output::update_project_output::Builder {
        crate::output::update_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProjectEventsOutput {
    /// <p>The number of events in the operation that could not be used by Evidently.</p>
    pub failed_event_count: std::option::Option<i32>,
    /// <p>A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any.</p>
    pub event_results:
        std::option::Option<std::vec::Vec<crate::model::PutProjectEventsResultEntry>>,
}
impl PutProjectEventsOutput {
    /// <p>The number of events in the operation that could not be used by Evidently.</p>
    pub fn failed_event_count(&self) -> std::option::Option<i32> {
        self.failed_event_count
    }
    /// <p>A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any.</p>
    pub fn event_results(
        &self,
    ) -> std::option::Option<&[crate::model::PutProjectEventsResultEntry]> {
        self.event_results.as_deref()
    }
}
impl std::fmt::Debug for PutProjectEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProjectEventsOutput");
        formatter.field("failed_event_count", &self.failed_event_count);
        formatter.field("event_results", &self.event_results);
        formatter.finish()
    }
}
/// See [`PutProjectEventsOutput`](crate::output::PutProjectEventsOutput)
pub mod put_project_events_output {
    /// A builder for [`PutProjectEventsOutput`](crate::output::PutProjectEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_event_count: std::option::Option<i32>,
        pub(crate) event_results:
            std::option::Option<std::vec::Vec<crate::model::PutProjectEventsResultEntry>>,
    }
    impl Builder {
        /// <p>The number of events in the operation that could not be used by Evidently.</p>
        pub fn failed_event_count(mut self, input: i32) -> Self {
            self.failed_event_count = Some(input);
            self
        }
        /// <p>The number of events in the operation that could not be used by Evidently.</p>
        pub fn set_failed_event_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_event_count = input;
            self
        }
        /// Appends an item to `event_results`.
        ///
        /// To override the contents of this collection use [`set_event_results`](Self::set_event_results).
        ///
        /// <p>A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any.</p>
        pub fn event_results(mut self, input: crate::model::PutProjectEventsResultEntry) -> Self {
            let mut v = self.event_results.unwrap_or_default();
            v.push(input);
            self.event_results = Some(v);
            self
        }
        /// <p>A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any.</p>
        pub fn set_event_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutProjectEventsResultEntry>>,
        ) -> Self {
            self.event_results = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProjectEventsOutput`](crate::output::PutProjectEventsOutput)
        pub fn build(self) -> crate::output::PutProjectEventsOutput {
            crate::output::PutProjectEventsOutput {
                failed_event_count: self.failed_event_count,
                event_results: self.event_results,
            }
        }
    }
}
impl PutProjectEventsOutput {
    /// Creates a new builder-style object to manufacture [`PutProjectEventsOutput`](crate::output::PutProjectEventsOutput)
    pub fn builder() -> crate::output::put_project_events_output::Builder {
        crate::output::put_project_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluateFeatureOutput {
    /// <p>The name of the variation that was served to the user session.</p>
    pub variation: std::option::Option<std::string::String>,
    /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
    pub value: std::option::Option<crate::model::VariableValue>,
    /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code> matches an override rule.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
    pub details: std::option::Option<std::string::String>,
}
impl EvaluateFeatureOutput {
    /// <p>The name of the variation that was served to the user session.</p>
    pub fn variation(&self) -> std::option::Option<&str> {
        self.variation.as_deref()
    }
    /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::VariableValue> {
        self.value.as_ref()
    }
    /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code> matches an override rule.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for EvaluateFeatureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluateFeatureOutput");
        formatter.field("variation", &self.variation);
        formatter.field("value", &self.value);
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`EvaluateFeatureOutput`](crate::output::EvaluateFeatureOutput)
pub mod evaluate_feature_output {
    /// A builder for [`EvaluateFeatureOutput`](crate::output::EvaluateFeatureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variation: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::VariableValue>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variation that was served to the user session.</p>
        pub fn variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.variation = Some(input.into());
            self
        }
        /// <p>The name of the variation that was served to the user session.</p>
        pub fn set_variation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.variation = input;
            self
        }
        /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
        pub fn value(mut self, input: crate::model::VariableValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::VariableValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code> matches an override rule.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code> matches an override rule.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluateFeatureOutput`](crate::output::EvaluateFeatureOutput)
        pub fn build(self) -> crate::output::EvaluateFeatureOutput {
            crate::output::EvaluateFeatureOutput {
                variation: self.variation,
                value: self.value,
                reason: self.reason,
                details: self.details,
            }
        }
    }
}
impl EvaluateFeatureOutput {
    /// Creates a new builder-style object to manufacture [`EvaluateFeatureOutput`](crate::output::EvaluateFeatureOutput)
    pub fn builder() -> crate::output::evaluate_feature_output::Builder {
        crate::output::evaluate_feature_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEvaluateFeatureOutput {
    /// <p>An array of structures, where each structure displays the results of one feature evaluation assignment to one user session.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
}
impl BatchEvaluateFeatureOutput {
    /// <p>An array of structures, where each structure displays the results of one feature evaluation assignment to one user session.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::EvaluationResult]> {
        self.results.as_deref()
    }
}
impl std::fmt::Debug for BatchEvaluateFeatureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEvaluateFeatureOutput");
        formatter.field("results", &self.results);
        formatter.finish()
    }
}
/// See [`BatchEvaluateFeatureOutput`](crate::output::BatchEvaluateFeatureOutput)
pub mod batch_evaluate_feature_output {
    /// A builder for [`BatchEvaluateFeatureOutput`](crate::output::BatchEvaluateFeatureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>An array of structures, where each structure displays the results of one feature evaluation assignment to one user session.</p>
        pub fn results(mut self, input: crate::model::EvaluationResult) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input);
            self.results = Some(v);
            self
        }
        /// <p>An array of structures, where each structure displays the results of one feature evaluation assignment to one user session.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEvaluateFeatureOutput`](crate::output::BatchEvaluateFeatureOutput)
        pub fn build(self) -> crate::output::BatchEvaluateFeatureOutput {
            crate::output::BatchEvaluateFeatureOutput {
                results: self.results,
            }
        }
    }
}
impl BatchEvaluateFeatureOutput {
    /// Creates a new builder-style object to manufacture [`BatchEvaluateFeatureOutput`](crate::output::BatchEvaluateFeatureOutput)
    pub fn builder() -> crate::output::batch_evaluate_feature_output::Builder {
        crate::output::batch_evaluate_feature_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>An array of structures that contain the configuration details of the projects in the Region.</p>
    pub projects: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
    /// <p>The token to use in a subsequent <code>ListProjects</code> operation to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsOutput {
    /// <p>An array of structures that contain the configuration details of the projects in the Region.</p>
    pub fn projects(&self) -> std::option::Option<&[crate::model::ProjectSummary]> {
        self.projects.as_deref()
    }
    /// <p>The token to use in a subsequent <code>ListProjects</code> operation to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("projects", &self.projects);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projects: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p>An array of structures that contain the configuration details of the projects in the Region.</p>
        pub fn projects(mut self, input: crate::model::ProjectSummary) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input);
            self.projects = Some(v);
            self
        }
        /// <p>An array of structures that contain the configuration details of the projects in the Region.</p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// <p>The token to use in a subsequent <code>ListProjects</code> operation to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use in a subsequent <code>ListProjects</code> operation to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                projects: self.projects,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectOutput {
    /// <p>A structure that contains information about the created project.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl CreateProjectOutput {
    /// <p>A structure that contains information about the created project.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for CreateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`CreateProjectOutput`](crate::output::CreateProjectOutput)
pub mod create_project_output {
    /// A builder for [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>A structure that contains information about the created project.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>A structure that contains information about the created project.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectOutput`](crate::output::CreateProjectOutput)
        pub fn build(self) -> crate::output::CreateProjectOutput {
            crate::output::CreateProjectOutput {
                project: self.project,
            }
        }
    }
}
impl CreateProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    pub fn builder() -> crate::output::create_project_output::Builder {
        crate::output::create_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectOutput {}
impl std::fmt::Debug for DeleteProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectOutput");
        formatter.finish()
    }
}
/// See [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
pub mod delete_project_output {
    /// A builder for [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
        pub fn build(self) -> crate::output::DeleteProjectOutput {
            crate::output::DeleteProjectOutput {}
        }
    }
}
impl DeleteProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    pub fn builder() -> crate::output::delete_project_output::Builder {
        crate::output::delete_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProjectOutput {
    /// <p>A structure containing the configuration details of the project.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl GetProjectOutput {
    /// <p>A structure containing the configuration details of the project.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for GetProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`GetProjectOutput`](crate::output::GetProjectOutput)
pub mod get_project_output {
    /// A builder for [`GetProjectOutput`](crate::output::GetProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>A structure containing the configuration details of the project.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>A structure containing the configuration details of the project.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProjectOutput`](crate::output::GetProjectOutput)
        pub fn build(self) -> crate::output::GetProjectOutput {
            crate::output::GetProjectOutput {
                project: self.project,
            }
        }
    }
}
impl GetProjectOutput {
    /// Creates a new builder-style object to manufacture [`GetProjectOutput`](crate::output::GetProjectOutput)
    pub fn builder() -> crate::output::get_project_output::Builder {
        crate::output::get_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopLaunchOutput {
    /// <p>The date and time that the launch stopped.</p>
    pub ended_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl StopLaunchOutput {
    /// <p>The date and time that the launch stopped.</p>
    pub fn ended_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ended_time.as_ref()
    }
}
impl std::fmt::Debug for StopLaunchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopLaunchOutput");
        formatter.field("ended_time", &self.ended_time);
        formatter.finish()
    }
}
/// See [`StopLaunchOutput`](crate::output::StopLaunchOutput)
pub mod stop_launch_output {
    /// A builder for [`StopLaunchOutput`](crate::output::StopLaunchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ended_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time that the launch stopped.</p>
        pub fn ended_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ended_time = Some(input);
            self
        }
        /// <p>The date and time that the launch stopped.</p>
        pub fn set_ended_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ended_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StopLaunchOutput`](crate::output::StopLaunchOutput)
        pub fn build(self) -> crate::output::StopLaunchOutput {
            crate::output::StopLaunchOutput {
                ended_time: self.ended_time,
            }
        }
    }
}
impl StopLaunchOutput {
    /// Creates a new builder-style object to manufacture [`StopLaunchOutput`](crate::output::StopLaunchOutput)
    pub fn builder() -> crate::output::stop_launch_output::Builder {
        crate::output::stop_launch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLaunchOutput {
    /// <p>A structure that contains information about the launch that was started.</p>
    pub launch: std::option::Option<crate::model::Launch>,
}
impl StartLaunchOutput {
    /// <p>A structure that contains information about the launch that was started.</p>
    pub fn launch(&self) -> std::option::Option<&crate::model::Launch> {
        self.launch.as_ref()
    }
}
impl std::fmt::Debug for StartLaunchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLaunchOutput");
        formatter.field("launch", &self.launch);
        formatter.finish()
    }
}
/// See [`StartLaunchOutput`](crate::output::StartLaunchOutput)
pub mod start_launch_output {
    /// A builder for [`StartLaunchOutput`](crate::output::StartLaunchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch: std::option::Option<crate::model::Launch>,
    }
    impl Builder {
        /// <p>A structure that contains information about the launch that was started.</p>
        pub fn launch(mut self, input: crate::model::Launch) -> Self {
            self.launch = Some(input);
            self
        }
        /// <p>A structure that contains information about the launch that was started.</p>
        pub fn set_launch(mut self, input: std::option::Option<crate::model::Launch>) -> Self {
            self.launch = input;
            self
        }
        /// Consumes the builder and constructs a [`StartLaunchOutput`](crate::output::StartLaunchOutput)
        pub fn build(self) -> crate::output::StartLaunchOutput {
            crate::output::StartLaunchOutput {
                launch: self.launch,
            }
        }
    }
}
impl StartLaunchOutput {
    /// Creates a new builder-style object to manufacture [`StartLaunchOutput`](crate::output::StartLaunchOutput)
    pub fn builder() -> crate::output::start_launch_output::Builder {
        crate::output::start_launch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLaunchesOutput {
    /// <p>An array of structures that contain the configuration details of the launches in the specified project.</p>
    pub launches: std::option::Option<std::vec::Vec<crate::model::Launch>>,
    /// <p>The token to use in a subsequent <code>ListLaunches</code> operation to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLaunchesOutput {
    /// <p>An array of structures that contain the configuration details of the launches in the specified project.</p>
    pub fn launches(&self) -> std::option::Option<&[crate::model::Launch]> {
        self.launches.as_deref()
    }
    /// <p>The token to use in a subsequent <code>ListLaunches</code> operation to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLaunchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLaunchesOutput");
        formatter.field("launches", &self.launches);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLaunchesOutput`](crate::output::ListLaunchesOutput)
pub mod list_launches_output {
    /// A builder for [`ListLaunchesOutput`](crate::output::ListLaunchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launches: std::option::Option<std::vec::Vec<crate::model::Launch>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `launches`.
        ///
        /// To override the contents of this collection use [`set_launches`](Self::set_launches).
        ///
        /// <p>An array of structures that contain the configuration details of the launches in the specified project.</p>
        pub fn launches(mut self, input: crate::model::Launch) -> Self {
            let mut v = self.launches.unwrap_or_default();
            v.push(input);
            self.launches = Some(v);
            self
        }
        /// <p>An array of structures that contain the configuration details of the launches in the specified project.</p>
        pub fn set_launches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Launch>>,
        ) -> Self {
            self.launches = input;
            self
        }
        /// <p>The token to use in a subsequent <code>ListLaunches</code> operation to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use in a subsequent <code>ListLaunches</code> operation to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLaunchesOutput`](crate::output::ListLaunchesOutput)
        pub fn build(self) -> crate::output::ListLaunchesOutput {
            crate::output::ListLaunchesOutput {
                launches: self.launches,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLaunchesOutput {
    /// Creates a new builder-style object to manufacture [`ListLaunchesOutput`](crate::output::ListLaunchesOutput)
    pub fn builder() -> crate::output::list_launches_output::Builder {
        crate::output::list_launches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLaunchOutput {
    /// <p>A structure that contains the configuration of the launch that was created.</p>
    pub launch: std::option::Option<crate::model::Launch>,
}
impl CreateLaunchOutput {
    /// <p>A structure that contains the configuration of the launch that was created.</p>
    pub fn launch(&self) -> std::option::Option<&crate::model::Launch> {
        self.launch.as_ref()
    }
}
impl std::fmt::Debug for CreateLaunchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLaunchOutput");
        formatter.field("launch", &self.launch);
        formatter.finish()
    }
}
/// See [`CreateLaunchOutput`](crate::output::CreateLaunchOutput)
pub mod create_launch_output {
    /// A builder for [`CreateLaunchOutput`](crate::output::CreateLaunchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch: std::option::Option<crate::model::Launch>,
    }
    impl Builder {
        /// <p>A structure that contains the configuration of the launch that was created.</p>
        pub fn launch(mut self, input: crate::model::Launch) -> Self {
            self.launch = Some(input);
            self
        }
        /// <p>A structure that contains the configuration of the launch that was created.</p>
        pub fn set_launch(mut self, input: std::option::Option<crate::model::Launch>) -> Self {
            self.launch = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLaunchOutput`](crate::output::CreateLaunchOutput)
        pub fn build(self) -> crate::output::CreateLaunchOutput {
            crate::output::CreateLaunchOutput {
                launch: self.launch,
            }
        }
    }
}
impl CreateLaunchOutput {
    /// Creates a new builder-style object to manufacture [`CreateLaunchOutput`](crate::output::CreateLaunchOutput)
    pub fn builder() -> crate::output::create_launch_output::Builder {
        crate::output::create_launch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLaunchOutput {}
impl std::fmt::Debug for DeleteLaunchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLaunchOutput");
        formatter.finish()
    }
}
/// See [`DeleteLaunchOutput`](crate::output::DeleteLaunchOutput)
pub mod delete_launch_output {
    /// A builder for [`DeleteLaunchOutput`](crate::output::DeleteLaunchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLaunchOutput`](crate::output::DeleteLaunchOutput)
        pub fn build(self) -> crate::output::DeleteLaunchOutput {
            crate::output::DeleteLaunchOutput {}
        }
    }
}
impl DeleteLaunchOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLaunchOutput`](crate::output::DeleteLaunchOutput)
    pub fn builder() -> crate::output::delete_launch_output::Builder {
        crate::output::delete_launch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLaunchOutput {
    /// <p>A structure that contains the new configuration of the launch that was updated.</p>
    pub launch: std::option::Option<crate::model::Launch>,
}
impl UpdateLaunchOutput {
    /// <p>A structure that contains the new configuration of the launch that was updated.</p>
    pub fn launch(&self) -> std::option::Option<&crate::model::Launch> {
        self.launch.as_ref()
    }
}
impl std::fmt::Debug for UpdateLaunchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLaunchOutput");
        formatter.field("launch", &self.launch);
        formatter.finish()
    }
}
/// See [`UpdateLaunchOutput`](crate::output::UpdateLaunchOutput)
pub mod update_launch_output {
    /// A builder for [`UpdateLaunchOutput`](crate::output::UpdateLaunchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch: std::option::Option<crate::model::Launch>,
    }
    impl Builder {
        /// <p>A structure that contains the new configuration of the launch that was updated.</p>
        pub fn launch(mut self, input: crate::model::Launch) -> Self {
            self.launch = Some(input);
            self
        }
        /// <p>A structure that contains the new configuration of the launch that was updated.</p>
        pub fn set_launch(mut self, input: std::option::Option<crate::model::Launch>) -> Self {
            self.launch = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLaunchOutput`](crate::output::UpdateLaunchOutput)
        pub fn build(self) -> crate::output::UpdateLaunchOutput {
            crate::output::UpdateLaunchOutput {
                launch: self.launch,
            }
        }
    }
}
impl UpdateLaunchOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLaunchOutput`](crate::output::UpdateLaunchOutput)
    pub fn builder() -> crate::output::update_launch_output::Builder {
        crate::output::update_launch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchOutput {
    /// <p>A structure containing the configuration details of the launch.</p>
    pub launch: std::option::Option<crate::model::Launch>,
}
impl GetLaunchOutput {
    /// <p>A structure containing the configuration details of the launch.</p>
    pub fn launch(&self) -> std::option::Option<&crate::model::Launch> {
        self.launch.as_ref()
    }
}
impl std::fmt::Debug for GetLaunchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchOutput");
        formatter.field("launch", &self.launch);
        formatter.finish()
    }
}
/// See [`GetLaunchOutput`](crate::output::GetLaunchOutput)
pub mod get_launch_output {
    /// A builder for [`GetLaunchOutput`](crate::output::GetLaunchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch: std::option::Option<crate::model::Launch>,
    }
    impl Builder {
        /// <p>A structure containing the configuration details of the launch.</p>
        pub fn launch(mut self, input: crate::model::Launch) -> Self {
            self.launch = Some(input);
            self
        }
        /// <p>A structure containing the configuration details of the launch.</p>
        pub fn set_launch(mut self, input: std::option::Option<crate::model::Launch>) -> Self {
            self.launch = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchOutput`](crate::output::GetLaunchOutput)
        pub fn build(self) -> crate::output::GetLaunchOutput {
            crate::output::GetLaunchOutput {
                launch: self.launch,
            }
        }
    }
}
impl GetLaunchOutput {
    /// Creates a new builder-style object to manufacture [`GetLaunchOutput`](crate::output::GetLaunchOutput)
    pub fn builder() -> crate::output::get_launch_output::Builder {
        crate::output::get_launch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFeaturesOutput {
    /// <p>An array of structures that contain the configuration details of the features in the specified project.</p>
    pub features: std::option::Option<std::vec::Vec<crate::model::FeatureSummary>>,
    /// <p>The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFeaturesOutput {
    /// <p>An array of structures that contain the configuration details of the features in the specified project.</p>
    pub fn features(&self) -> std::option::Option<&[crate::model::FeatureSummary]> {
        self.features.as_deref()
    }
    /// <p>The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFeaturesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFeaturesOutput");
        formatter.field("features", &self.features);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFeaturesOutput`](crate::output::ListFeaturesOutput)
pub mod list_features_output {
    /// A builder for [`ListFeaturesOutput`](crate::output::ListFeaturesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) features: std::option::Option<std::vec::Vec<crate::model::FeatureSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `features`.
        ///
        /// To override the contents of this collection use [`set_features`](Self::set_features).
        ///
        /// <p>An array of structures that contain the configuration details of the features in the specified project.</p>
        pub fn features(mut self, input: crate::model::FeatureSummary) -> Self {
            let mut v = self.features.unwrap_or_default();
            v.push(input);
            self.features = Some(v);
            self
        }
        /// <p>An array of structures that contain the configuration details of the features in the specified project.</p>
        pub fn set_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureSummary>>,
        ) -> Self {
            self.features = input;
            self
        }
        /// <p>The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFeaturesOutput`](crate::output::ListFeaturesOutput)
        pub fn build(self) -> crate::output::ListFeaturesOutput {
            crate::output::ListFeaturesOutput {
                features: self.features,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFeaturesOutput {
    /// Creates a new builder-style object to manufacture [`ListFeaturesOutput`](crate::output::ListFeaturesOutput)
    pub fn builder() -> crate::output::list_features_output::Builder {
        crate::output::list_features_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFeatureOutput {
    /// <p>A structure that contains information about the new feature.</p>
    pub feature: std::option::Option<crate::model::Feature>,
}
impl CreateFeatureOutput {
    /// <p>A structure that contains information about the new feature.</p>
    pub fn feature(&self) -> std::option::Option<&crate::model::Feature> {
        self.feature.as_ref()
    }
}
impl std::fmt::Debug for CreateFeatureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFeatureOutput");
        formatter.field("feature", &self.feature);
        formatter.finish()
    }
}
/// See [`CreateFeatureOutput`](crate::output::CreateFeatureOutput)
pub mod create_feature_output {
    /// A builder for [`CreateFeatureOutput`](crate::output::CreateFeatureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature: std::option::Option<crate::model::Feature>,
    }
    impl Builder {
        /// <p>A structure that contains information about the new feature.</p>
        pub fn feature(mut self, input: crate::model::Feature) -> Self {
            self.feature = Some(input);
            self
        }
        /// <p>A structure that contains information about the new feature.</p>
        pub fn set_feature(mut self, input: std::option::Option<crate::model::Feature>) -> Self {
            self.feature = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFeatureOutput`](crate::output::CreateFeatureOutput)
        pub fn build(self) -> crate::output::CreateFeatureOutput {
            crate::output::CreateFeatureOutput {
                feature: self.feature,
            }
        }
    }
}
impl CreateFeatureOutput {
    /// Creates a new builder-style object to manufacture [`CreateFeatureOutput`](crate::output::CreateFeatureOutput)
    pub fn builder() -> crate::output::create_feature_output::Builder {
        crate::output::create_feature_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFeatureOutput {}
impl std::fmt::Debug for DeleteFeatureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFeatureOutput");
        formatter.finish()
    }
}
/// See [`DeleteFeatureOutput`](crate::output::DeleteFeatureOutput)
pub mod delete_feature_output {
    /// A builder for [`DeleteFeatureOutput`](crate::output::DeleteFeatureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFeatureOutput`](crate::output::DeleteFeatureOutput)
        pub fn build(self) -> crate::output::DeleteFeatureOutput {
            crate::output::DeleteFeatureOutput {}
        }
    }
}
impl DeleteFeatureOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFeatureOutput`](crate::output::DeleteFeatureOutput)
    pub fn builder() -> crate::output::delete_feature_output::Builder {
        crate::output::delete_feature_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFeatureOutput {
    /// <p>A structure that contains information about the updated feature.</p>
    pub feature: std::option::Option<crate::model::Feature>,
}
impl UpdateFeatureOutput {
    /// <p>A structure that contains information about the updated feature.</p>
    pub fn feature(&self) -> std::option::Option<&crate::model::Feature> {
        self.feature.as_ref()
    }
}
impl std::fmt::Debug for UpdateFeatureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFeatureOutput");
        formatter.field("feature", &self.feature);
        formatter.finish()
    }
}
/// See [`UpdateFeatureOutput`](crate::output::UpdateFeatureOutput)
pub mod update_feature_output {
    /// A builder for [`UpdateFeatureOutput`](crate::output::UpdateFeatureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature: std::option::Option<crate::model::Feature>,
    }
    impl Builder {
        /// <p>A structure that contains information about the updated feature.</p>
        pub fn feature(mut self, input: crate::model::Feature) -> Self {
            self.feature = Some(input);
            self
        }
        /// <p>A structure that contains information about the updated feature.</p>
        pub fn set_feature(mut self, input: std::option::Option<crate::model::Feature>) -> Self {
            self.feature = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFeatureOutput`](crate::output::UpdateFeatureOutput)
        pub fn build(self) -> crate::output::UpdateFeatureOutput {
            crate::output::UpdateFeatureOutput {
                feature: self.feature,
            }
        }
    }
}
impl UpdateFeatureOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFeatureOutput`](crate::output::UpdateFeatureOutput)
    pub fn builder() -> crate::output::update_feature_output::Builder {
        crate::output::update_feature_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFeatureOutput {
    /// <p>A structure containing the configuration details of the feature.</p>
    pub feature: std::option::Option<crate::model::Feature>,
}
impl GetFeatureOutput {
    /// <p>A structure containing the configuration details of the feature.</p>
    pub fn feature(&self) -> std::option::Option<&crate::model::Feature> {
        self.feature.as_ref()
    }
}
impl std::fmt::Debug for GetFeatureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFeatureOutput");
        formatter.field("feature", &self.feature);
        formatter.finish()
    }
}
/// See [`GetFeatureOutput`](crate::output::GetFeatureOutput)
pub mod get_feature_output {
    /// A builder for [`GetFeatureOutput`](crate::output::GetFeatureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature: std::option::Option<crate::model::Feature>,
    }
    impl Builder {
        /// <p>A structure containing the configuration details of the feature.</p>
        pub fn feature(mut self, input: crate::model::Feature) -> Self {
            self.feature = Some(input);
            self
        }
        /// <p>A structure containing the configuration details of the feature.</p>
        pub fn set_feature(mut self, input: std::option::Option<crate::model::Feature>) -> Self {
            self.feature = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFeatureOutput`](crate::output::GetFeatureOutput)
        pub fn build(self) -> crate::output::GetFeatureOutput {
            crate::output::GetFeatureOutput {
                feature: self.feature,
            }
        }
    }
}
impl GetFeatureOutput {
    /// Creates a new builder-style object to manufacture [`GetFeatureOutput`](crate::output::GetFeatureOutput)
    pub fn builder() -> crate::output::get_feature_output::Builder {
        crate::output::get_feature_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopExperimentOutput {
    /// <p>The date and time that the experiment stopped.</p>
    pub ended_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl StopExperimentOutput {
    /// <p>The date and time that the experiment stopped.</p>
    pub fn ended_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ended_time.as_ref()
    }
}
impl std::fmt::Debug for StopExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopExperimentOutput");
        formatter.field("ended_time", &self.ended_time);
        formatter.finish()
    }
}
/// See [`StopExperimentOutput`](crate::output::StopExperimentOutput)
pub mod stop_experiment_output {
    /// A builder for [`StopExperimentOutput`](crate::output::StopExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ended_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time that the experiment stopped.</p>
        pub fn ended_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ended_time = Some(input);
            self
        }
        /// <p>The date and time that the experiment stopped.</p>
        pub fn set_ended_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ended_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StopExperimentOutput`](crate::output::StopExperimentOutput)
        pub fn build(self) -> crate::output::StopExperimentOutput {
            crate::output::StopExperimentOutput {
                ended_time: self.ended_time,
            }
        }
    }
}
impl StopExperimentOutput {
    /// Creates a new builder-style object to manufacture [`StopExperimentOutput`](crate::output::StopExperimentOutput)
    pub fn builder() -> crate::output::stop_experiment_output::Builder {
        crate::output::stop_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExperimentOutput {
    /// <p>A timestamp that indicates when the experiment started.</p>
    pub started_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartExperimentOutput {
    /// <p>A timestamp that indicates when the experiment started.</p>
    pub fn started_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_time.as_ref()
    }
}
impl std::fmt::Debug for StartExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExperimentOutput");
        formatter.field("started_time", &self.started_time);
        formatter.finish()
    }
}
/// See [`StartExperimentOutput`](crate::output::StartExperimentOutput)
pub mod start_experiment_output {
    /// A builder for [`StartExperimentOutput`](crate::output::StartExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) started_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A timestamp that indicates when the experiment started.</p>
        pub fn started_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the experiment started.</p>
        pub fn set_started_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExperimentOutput`](crate::output::StartExperimentOutput)
        pub fn build(self) -> crate::output::StartExperimentOutput {
            crate::output::StartExperimentOutput {
                started_time: self.started_time,
            }
        }
    }
}
impl StartExperimentOutput {
    /// Creates a new builder-style object to manufacture [`StartExperimentOutput`](crate::output::StartExperimentOutput)
    pub fn builder() -> crate::output::start_experiment_output::Builder {
        crate::output::start_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExperimentResultsOutput {
    /// <p>An array of structures that include experiment results including metric names and values. </p>
    pub results_data: std::option::Option<std::vec::Vec<crate::model::ExperimentResultsData>>,
    /// <p>An array of structures that include the reports that you requested.</p>
    pub reports: std::option::Option<std::vec::Vec<crate::model::ExperimentReport>>,
    /// <p>The timestamps of each result returned.</p>
    pub timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
    /// <p>If the experiment doesn't yet have enough events to provide valid results, this field is returned with the message <code>Not enough events to generate results</code>. If there are enough events to provide valid results, this field is not returned.</p>
    pub details: std::option::Option<std::string::String>,
}
impl GetExperimentResultsOutput {
    /// <p>An array of structures that include experiment results including metric names and values. </p>
    pub fn results_data(&self) -> std::option::Option<&[crate::model::ExperimentResultsData]> {
        self.results_data.as_deref()
    }
    /// <p>An array of structures that include the reports that you requested.</p>
    pub fn reports(&self) -> std::option::Option<&[crate::model::ExperimentReport]> {
        self.reports.as_deref()
    }
    /// <p>The timestamps of each result returned.</p>
    pub fn timestamps(&self) -> std::option::Option<&[aws_smithy_types::DateTime]> {
        self.timestamps.as_deref()
    }
    /// <p>If the experiment doesn't yet have enough events to provide valid results, this field is returned with the message <code>Not enough events to generate results</code>. If there are enough events to provide valid results, this field is not returned.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for GetExperimentResultsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExperimentResultsOutput");
        formatter.field("results_data", &self.results_data);
        formatter.field("reports", &self.reports);
        formatter.field("timestamps", &self.timestamps);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`GetExperimentResultsOutput`](crate::output::GetExperimentResultsOutput)
pub mod get_experiment_results_output {
    /// A builder for [`GetExperimentResultsOutput`](crate::output::GetExperimentResultsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results_data:
            std::option::Option<std::vec::Vec<crate::model::ExperimentResultsData>>,
        pub(crate) reports: std::option::Option<std::vec::Vec<crate::model::ExperimentReport>>,
        pub(crate) timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results_data`.
        ///
        /// To override the contents of this collection use [`set_results_data`](Self::set_results_data).
        ///
        /// <p>An array of structures that include experiment results including metric names and values. </p>
        pub fn results_data(mut self, input: crate::model::ExperimentResultsData) -> Self {
            let mut v = self.results_data.unwrap_or_default();
            v.push(input);
            self.results_data = Some(v);
            self
        }
        /// <p>An array of structures that include experiment results including metric names and values. </p>
        pub fn set_results_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentResultsData>>,
        ) -> Self {
            self.results_data = input;
            self
        }
        /// Appends an item to `reports`.
        ///
        /// To override the contents of this collection use [`set_reports`](Self::set_reports).
        ///
        /// <p>An array of structures that include the reports that you requested.</p>
        pub fn reports(mut self, input: crate::model::ExperimentReport) -> Self {
            let mut v = self.reports.unwrap_or_default();
            v.push(input);
            self.reports = Some(v);
            self
        }
        /// <p>An array of structures that include the reports that you requested.</p>
        pub fn set_reports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentReport>>,
        ) -> Self {
            self.reports = input;
            self
        }
        /// Appends an item to `timestamps`.
        ///
        /// To override the contents of this collection use [`set_timestamps`](Self::set_timestamps).
        ///
        /// <p>The timestamps of each result returned.</p>
        pub fn timestamps(mut self, input: aws_smithy_types::DateTime) -> Self {
            let mut v = self.timestamps.unwrap_or_default();
            v.push(input);
            self.timestamps = Some(v);
            self
        }
        /// <p>The timestamps of each result returned.</p>
        pub fn set_timestamps(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        ) -> Self {
            self.timestamps = input;
            self
        }
        /// <p>If the experiment doesn't yet have enough events to provide valid results, this field is returned with the message <code>Not enough events to generate results</code>. If there are enough events to provide valid results, this field is not returned.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>If the experiment doesn't yet have enough events to provide valid results, this field is returned with the message <code>Not enough events to generate results</code>. If there are enough events to provide valid results, this field is not returned.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExperimentResultsOutput`](crate::output::GetExperimentResultsOutput)
        pub fn build(self) -> crate::output::GetExperimentResultsOutput {
            crate::output::GetExperimentResultsOutput {
                results_data: self.results_data,
                reports: self.reports,
                timestamps: self.timestamps,
                details: self.details,
            }
        }
    }
}
impl GetExperimentResultsOutput {
    /// Creates a new builder-style object to manufacture [`GetExperimentResultsOutput`](crate::output::GetExperimentResultsOutput)
    pub fn builder() -> crate::output::get_experiment_results_output::Builder {
        crate::output::get_experiment_results_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExperimentsOutput {
    /// <p>An array of structures that contain the configuration details of the experiments in the specified project.</p>
    pub experiments: std::option::Option<std::vec::Vec<crate::model::Experiment>>,
    /// <p>The token to use in a subsequent <code>ListExperiments</code> operation to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExperimentsOutput {
    /// <p>An array of structures that contain the configuration details of the experiments in the specified project.</p>
    pub fn experiments(&self) -> std::option::Option<&[crate::model::Experiment]> {
        self.experiments.as_deref()
    }
    /// <p>The token to use in a subsequent <code>ListExperiments</code> operation to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExperimentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExperimentsOutput");
        formatter.field("experiments", &self.experiments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
pub mod list_experiments_output {
    /// A builder for [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiments: std::option::Option<std::vec::Vec<crate::model::Experiment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `experiments`.
        ///
        /// To override the contents of this collection use [`set_experiments`](Self::set_experiments).
        ///
        /// <p>An array of structures that contain the configuration details of the experiments in the specified project.</p>
        pub fn experiments(mut self, input: crate::model::Experiment) -> Self {
            let mut v = self.experiments.unwrap_or_default();
            v.push(input);
            self.experiments = Some(v);
            self
        }
        /// <p>An array of structures that contain the configuration details of the experiments in the specified project.</p>
        pub fn set_experiments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Experiment>>,
        ) -> Self {
            self.experiments = input;
            self
        }
        /// <p>The token to use in a subsequent <code>ListExperiments</code> operation to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use in a subsequent <code>ListExperiments</code> operation to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
        pub fn build(self) -> crate::output::ListExperimentsOutput {
            crate::output::ListExperimentsOutput {
                experiments: self.experiments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListExperimentsOutput {
    /// Creates a new builder-style object to manufacture [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
    pub fn builder() -> crate::output::list_experiments_output::Builder {
        crate::output::list_experiments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExperimentOutput {
    /// <p>A structure containing the configuration details of the experiment that you created.</p>
    pub experiment: std::option::Option<crate::model::Experiment>,
}
impl CreateExperimentOutput {
    /// <p>A structure containing the configuration details of the experiment that you created.</p>
    pub fn experiment(&self) -> std::option::Option<&crate::model::Experiment> {
        self.experiment.as_ref()
    }
}
impl std::fmt::Debug for CreateExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExperimentOutput");
        formatter.field("experiment", &self.experiment);
        formatter.finish()
    }
}
/// See [`CreateExperimentOutput`](crate::output::CreateExperimentOutput)
pub mod create_experiment_output {
    /// A builder for [`CreateExperimentOutput`](crate::output::CreateExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment: std::option::Option<crate::model::Experiment>,
    }
    impl Builder {
        /// <p>A structure containing the configuration details of the experiment that you created.</p>
        pub fn experiment(mut self, input: crate::model::Experiment) -> Self {
            self.experiment = Some(input);
            self
        }
        /// <p>A structure containing the configuration details of the experiment that you created.</p>
        pub fn set_experiment(
            mut self,
            input: std::option::Option<crate::model::Experiment>,
        ) -> Self {
            self.experiment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExperimentOutput`](crate::output::CreateExperimentOutput)
        pub fn build(self) -> crate::output::CreateExperimentOutput {
            crate::output::CreateExperimentOutput {
                experiment: self.experiment,
            }
        }
    }
}
impl CreateExperimentOutput {
    /// Creates a new builder-style object to manufacture [`CreateExperimentOutput`](crate::output::CreateExperimentOutput)
    pub fn builder() -> crate::output::create_experiment_output::Builder {
        crate::output::create_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExperimentOutput {}
impl std::fmt::Debug for DeleteExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExperimentOutput");
        formatter.finish()
    }
}
/// See [`DeleteExperimentOutput`](crate::output::DeleteExperimentOutput)
pub mod delete_experiment_output {
    /// A builder for [`DeleteExperimentOutput`](crate::output::DeleteExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteExperimentOutput`](crate::output::DeleteExperimentOutput)
        pub fn build(self) -> crate::output::DeleteExperimentOutput {
            crate::output::DeleteExperimentOutput {}
        }
    }
}
impl DeleteExperimentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteExperimentOutput`](crate::output::DeleteExperimentOutput)
    pub fn builder() -> crate::output::delete_experiment_output::Builder {
        crate::output::delete_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExperimentOutput {
    /// <p>A structure containing the configuration details of the experiment that was updated.</p>
    pub experiment: std::option::Option<crate::model::Experiment>,
}
impl UpdateExperimentOutput {
    /// <p>A structure containing the configuration details of the experiment that was updated.</p>
    pub fn experiment(&self) -> std::option::Option<&crate::model::Experiment> {
        self.experiment.as_ref()
    }
}
impl std::fmt::Debug for UpdateExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExperimentOutput");
        formatter.field("experiment", &self.experiment);
        formatter.finish()
    }
}
/// See [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
pub mod update_experiment_output {
    /// A builder for [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment: std::option::Option<crate::model::Experiment>,
    }
    impl Builder {
        /// <p>A structure containing the configuration details of the experiment that was updated.</p>
        pub fn experiment(mut self, input: crate::model::Experiment) -> Self {
            self.experiment = Some(input);
            self
        }
        /// <p>A structure containing the configuration details of the experiment that was updated.</p>
        pub fn set_experiment(
            mut self,
            input: std::option::Option<crate::model::Experiment>,
        ) -> Self {
            self.experiment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
        pub fn build(self) -> crate::output::UpdateExperimentOutput {
            crate::output::UpdateExperimentOutput {
                experiment: self.experiment,
            }
        }
    }
}
impl UpdateExperimentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
    pub fn builder() -> crate::output::update_experiment_output::Builder {
        crate::output::update_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExperimentOutput {
    /// <p>A structure containing the configuration details of the experiment.</p>
    pub experiment: std::option::Option<crate::model::Experiment>,
}
impl GetExperimentOutput {
    /// <p>A structure containing the configuration details of the experiment.</p>
    pub fn experiment(&self) -> std::option::Option<&crate::model::Experiment> {
        self.experiment.as_ref()
    }
}
impl std::fmt::Debug for GetExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExperimentOutput");
        formatter.field("experiment", &self.experiment);
        formatter.finish()
    }
}
/// See [`GetExperimentOutput`](crate::output::GetExperimentOutput)
pub mod get_experiment_output {
    /// A builder for [`GetExperimentOutput`](crate::output::GetExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment: std::option::Option<crate::model::Experiment>,
    }
    impl Builder {
        /// <p>A structure containing the configuration details of the experiment.</p>
        pub fn experiment(mut self, input: crate::model::Experiment) -> Self {
            self.experiment = Some(input);
            self
        }
        /// <p>A structure containing the configuration details of the experiment.</p>
        pub fn set_experiment(
            mut self,
            input: std::option::Option<crate::model::Experiment>,
        ) -> Self {
            self.experiment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExperimentOutput`](crate::output::GetExperimentOutput)
        pub fn build(self) -> crate::output::GetExperimentOutput {
            crate::output::GetExperimentOutput {
                experiment: self.experiment,
            }
        }
    }
}
impl GetExperimentOutput {
    /// Creates a new builder-style object to manufacture [`GetExperimentOutput`](crate::output::GetExperimentOutput)
    pub fn builder() -> crate::output::get_experiment_output::Builder {
        crate::output::get_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tag keys and values associated with the resource you specified.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The list of tag keys and values associated with the resource you specified.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with the resource you specified.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with the resource you specified.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
