// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A structure containing an error name and message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The error name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The error name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The error name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "cannotParse" => ValidationExceptionReason::CannotParse,
            "fieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "other" => ValidationExceptionReason::Other,
            "unknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "cannotParse",
            ValidationExceptionReason::FieldValidationFailed => "fieldValidationFailed",
            ValidationExceptionReason::Other => "other",
            ValidationExceptionReason::UnknownOperation => "unknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cannotParse",
            "fieldValidationFailed",
            "other",
            "unknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure defines a project, which is the logical object in Evidently that can contain features, launches, and experiments. Use projects to group similar features together.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Project {
    /// <p>The name or ARN of the project.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current state of the project.</p>
    pub status: std::option::Option<crate::model::ProjectStatus>,
    /// <p>The user-entered description of the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the project is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the project was most recently updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of features currently in the project.</p>
    pub feature_count: std::option::Option<i64>,
    /// <p>The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.</p>
    pub launch_count: std::option::Option<i64>,
    /// <p>The number of ongoing launches currently in the project.</p>
    pub active_launch_count: std::option::Option<i64>,
    /// <p>The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.</p>
    pub experiment_count: std::option::Option<i64>,
    /// <p>The number of ongoing experiments currently in the project.</p>
    pub active_experiment_count: std::option::Option<i64>,
    /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>
    pub data_delivery: std::option::Option<crate::model::ProjectDataDelivery>,
    /// <p>The list of tag keys and values associated with this project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Project {
    /// <p>The name or ARN of the project.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current state of the project.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProjectStatus> {
        self.status.as_ref()
    }
    /// <p>The user-entered description of the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the project is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the project was most recently updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The number of features currently in the project.</p>
    pub fn feature_count(&self) -> std::option::Option<i64> {
        self.feature_count
    }
    /// <p>The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.</p>
    pub fn launch_count(&self) -> std::option::Option<i64> {
        self.launch_count
    }
    /// <p>The number of ongoing launches currently in the project.</p>
    pub fn active_launch_count(&self) -> std::option::Option<i64> {
        self.active_launch_count
    }
    /// <p>The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.</p>
    pub fn experiment_count(&self) -> std::option::Option<i64> {
        self.experiment_count
    }
    /// <p>The number of ongoing experiments currently in the project.</p>
    pub fn active_experiment_count(&self) -> std::option::Option<i64> {
        self.active_experiment_count
    }
    /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>
    pub fn data_delivery(&self) -> std::option::Option<&crate::model::ProjectDataDelivery> {
        self.data_delivery.as_ref()
    }
    /// <p>The list of tag keys and values associated with this project.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Project {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Project");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("feature_count", &self.feature_count);
        formatter.field("launch_count", &self.launch_count);
        formatter.field("active_launch_count", &self.active_launch_count);
        formatter.field("experiment_count", &self.experiment_count);
        formatter.field("active_experiment_count", &self.active_experiment_count);
        formatter.field("data_delivery", &self.data_delivery);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Project`](crate::model::Project)
pub mod project {
    /// A builder for [`Project`](crate::model::Project)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProjectStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) feature_count: std::option::Option<i64>,
        pub(crate) launch_count: std::option::Option<i64>,
        pub(crate) active_launch_count: std::option::Option<i64>,
        pub(crate) experiment_count: std::option::Option<i64>,
        pub(crate) active_experiment_count: std::option::Option<i64>,
        pub(crate) data_delivery: std::option::Option<crate::model::ProjectDataDelivery>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name or ARN of the project.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current state of the project.</p>
        pub fn status(mut self, input: crate::model::ProjectStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the project.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProjectStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The user-entered description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The user-entered description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the project is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the project is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the project was most recently updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time that the project was most recently updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The number of features currently in the project.</p>
        pub fn feature_count(mut self, input: i64) -> Self {
            self.feature_count = Some(input);
            self
        }
        /// <p>The number of features currently in the project.</p>
        pub fn set_feature_count(mut self, input: std::option::Option<i64>) -> Self {
            self.feature_count = input;
            self
        }
        /// <p>The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.</p>
        pub fn launch_count(mut self, input: i64) -> Self {
            self.launch_count = Some(input);
            self
        }
        /// <p>The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.</p>
        pub fn set_launch_count(mut self, input: std::option::Option<i64>) -> Self {
            self.launch_count = input;
            self
        }
        /// <p>The number of ongoing launches currently in the project.</p>
        pub fn active_launch_count(mut self, input: i64) -> Self {
            self.active_launch_count = Some(input);
            self
        }
        /// <p>The number of ongoing launches currently in the project.</p>
        pub fn set_active_launch_count(mut self, input: std::option::Option<i64>) -> Self {
            self.active_launch_count = input;
            self
        }
        /// <p>The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.</p>
        pub fn experiment_count(mut self, input: i64) -> Self {
            self.experiment_count = Some(input);
            self
        }
        /// <p>The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.</p>
        pub fn set_experiment_count(mut self, input: std::option::Option<i64>) -> Self {
            self.experiment_count = input;
            self
        }
        /// <p>The number of ongoing experiments currently in the project.</p>
        pub fn active_experiment_count(mut self, input: i64) -> Self {
            self.active_experiment_count = Some(input);
            self
        }
        /// <p>The number of ongoing experiments currently in the project.</p>
        pub fn set_active_experiment_count(mut self, input: std::option::Option<i64>) -> Self {
            self.active_experiment_count = input;
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>
        pub fn data_delivery(mut self, input: crate::model::ProjectDataDelivery) -> Self {
            self.data_delivery = Some(input);
            self
        }
        /// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>
        pub fn set_data_delivery(
            mut self,
            input: std::option::Option<crate::model::ProjectDataDelivery>,
        ) -> Self {
            self.data_delivery = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with this project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with this project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Project`](crate::model::Project)
        pub fn build(self) -> crate::model::Project {
            crate::model::Project {
                arn: self.arn,
                name: self.name,
                status: self.status,
                description: self.description,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                feature_count: self.feature_count,
                launch_count: self.launch_count,
                active_launch_count: self.active_launch_count,
                experiment_count: self.experiment_count,
                active_experiment_count: self.active_experiment_count,
                data_delivery: self.data_delivery,
                tags: self.tags,
            }
        }
    }
}
impl Project {
    /// Creates a new builder-style object to manufacture [`Project`](crate::model::Project)
    pub fn builder() -> crate::model::project::Builder {
        crate::model::project::Builder::default()
    }
}

/// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectDataDelivery {
    /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
    /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
    pub cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsDestination>,
}
impl ProjectDataDelivery {
    /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
    pub fn s3_destination(&self) -> std::option::Option<&crate::model::S3Destination> {
        self.s3_destination.as_ref()
    }
    /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
    pub fn cloud_watch_logs(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestination> {
        self.cloud_watch_logs.as_ref()
    }
}
impl std::fmt::Debug for ProjectDataDelivery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectDataDelivery");
        formatter.field("s3_destination", &self.s3_destination);
        formatter.field("cloud_watch_logs", &self.cloud_watch_logs);
        formatter.finish()
    }
}
/// See [`ProjectDataDelivery`](crate::model::ProjectDataDelivery)
pub mod project_data_delivery {
    /// A builder for [`ProjectDataDelivery`](crate::model::ProjectDataDelivery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
        pub(crate) cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsDestination>,
    }
    impl Builder {
        /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
        pub fn cloud_watch_logs(mut self, input: crate::model::CloudWatchLogsDestination) -> Self {
            self.cloud_watch_logs = Some(input);
            self
        }
        /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.cloud_watch_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectDataDelivery`](crate::model::ProjectDataDelivery)
        pub fn build(self) -> crate::model::ProjectDataDelivery {
            crate::model::ProjectDataDelivery {
                s3_destination: self.s3_destination,
                cloud_watch_logs: self.cloud_watch_logs,
            }
        }
    }
}
impl ProjectDataDelivery {
    /// Creates a new builder-style object to manufacture [`ProjectDataDelivery`](crate::model::ProjectDataDelivery)
    pub fn builder() -> crate::model::project_data_delivery::Builder {
        crate::model::project_data_delivery::Builder::default()
    }
}

/// <p>A structure containing the CloudWatch Logs log group where the project stores evaluation events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsDestination {
    /// <p>The name of the log group where the project stores evaluation events.</p>
    pub log_group: std::option::Option<std::string::String>,
}
impl CloudWatchLogsDestination {
    /// <p>The name of the log group where the project stores evaluation events.</p>
    pub fn log_group(&self) -> std::option::Option<&str> {
        self.log_group.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsDestination");
        formatter.field("log_group", &self.log_group);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
pub mod cloud_watch_logs_destination {
    /// A builder for [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the log group where the project stores evaluation events.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The name of the log group where the project stores evaluation events.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
        pub fn build(self) -> crate::model::CloudWatchLogsDestination {
            crate::model::CloudWatchLogsDestination {
                log_group: self.log_group,
            }
        }
    }
}
impl CloudWatchLogsDestination {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
    pub fn builder() -> crate::model::cloud_watch_logs_destination::Builder {
        crate::model::cloud_watch_logs_destination::Builder::default()
    }
}

/// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Destination {
    /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3Destination {
    /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Destination");
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3Destination`](crate::model::S3Destination)
pub mod s3_destination {
    /// A builder for [`S3Destination`](crate::model::S3Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Destination`](crate::model::S3Destination)
        pub fn build(self) -> crate::model::S3Destination {
            crate::model::S3Destination {
                bucket: self.bucket,
                prefix: self.prefix,
            }
        }
    }
}
impl S3Destination {
    /// Creates a new builder-style object to manufacture [`S3Destination`](crate::model::S3Destination)
    pub fn builder() -> crate::model::s3_destination::Builder {
        crate::model::s3_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProjectStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProjectStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ProjectStatus::Available,
            "UPDATING" => ProjectStatus::Updating,
            other => ProjectStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProjectStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProjectStatus::from(s))
    }
}
impl ProjectStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProjectStatus::Available => "AVAILABLE",
            ProjectStatus::Updating => "UPDATING",
            ProjectStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "UPDATING"]
    }
}
impl AsRef<str> for ProjectStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing the CloudWatch Logs log group where the project stores evaluation events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsDestinationConfig {
    /// <p>The name of the log group where the project stores evaluation events.</p>
    pub log_group: std::option::Option<std::string::String>,
}
impl CloudWatchLogsDestinationConfig {
    /// <p>The name of the log group where the project stores evaluation events.</p>
    pub fn log_group(&self) -> std::option::Option<&str> {
        self.log_group.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsDestinationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsDestinationConfig");
        formatter.field("log_group", &self.log_group);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsDestinationConfig`](crate::model::CloudWatchLogsDestinationConfig)
pub mod cloud_watch_logs_destination_config {
    /// A builder for [`CloudWatchLogsDestinationConfig`](crate::model::CloudWatchLogsDestinationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the log group where the project stores evaluation events.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The name of the log group where the project stores evaluation events.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsDestinationConfig`](crate::model::CloudWatchLogsDestinationConfig)
        pub fn build(self) -> crate::model::CloudWatchLogsDestinationConfig {
            crate::model::CloudWatchLogsDestinationConfig {
                log_group: self.log_group,
            }
        }
    }
}
impl CloudWatchLogsDestinationConfig {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsDestinationConfig`](crate::model::CloudWatchLogsDestinationConfig)
    pub fn builder() -> crate::model::cloud_watch_logs_destination_config::Builder {
        crate::model::cloud_watch_logs_destination_config::Builder::default()
    }
}

/// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationConfig {
    /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3DestinationConfig {
    /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3DestinationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationConfig");
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3DestinationConfig`](crate::model::S3DestinationConfig)
pub mod s3_destination_config {
    /// A builder for [`S3DestinationConfig`](crate::model::S3DestinationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket in which Evidently stores evaluation events.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The bucket prefix in which Evidently stores evaluation events.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationConfig`](crate::model::S3DestinationConfig)
        pub fn build(self) -> crate::model::S3DestinationConfig {
            crate::model::S3DestinationConfig {
                bucket: self.bucket,
                prefix: self.prefix,
            }
        }
    }
}
impl S3DestinationConfig {
    /// Creates a new builder-style object to manufacture [`S3DestinationConfig`](crate::model::S3DestinationConfig)
    pub fn builder() -> crate::model::s3_destination_config::Builder {
        crate::model::s3_destination_config::Builder::default()
    }
}

/// <p>A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProjectEventsResultEntry {
    /// <p>A unique ID assigned to this <code>PutProjectEvents</code> operation. </p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl PutProjectEventsResultEntry {
    /// <p>A unique ID assigned to this <code>PutProjectEvents</code> operation. </p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for PutProjectEventsResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProjectEventsResultEntry");
        formatter.field("event_id", &self.event_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PutProjectEventsResultEntry`](crate::model::PutProjectEventsResultEntry)
pub mod put_project_events_result_entry {
    /// A builder for [`PutProjectEventsResultEntry`](crate::model::PutProjectEventsResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique ID assigned to this <code>PutProjectEvents</code> operation. </p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>A unique ID assigned to this <code>PutProjectEvents</code> operation. </p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProjectEventsResultEntry`](crate::model::PutProjectEventsResultEntry)
        pub fn build(self) -> crate::model::PutProjectEventsResultEntry {
            crate::model::PutProjectEventsResultEntry {
                event_id: self.event_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PutProjectEventsResultEntry {
    /// Creates a new builder-style object to manufacture [`PutProjectEventsResultEntry`](crate::model::PutProjectEventsResultEntry)
    pub fn builder() -> crate::model::put_project_events_result_entry::Builder {
        crate::model::put_project_events_result_entry::Builder::default()
    }
}

/// <p>A structure that contains the information about one evaluation event or custom event sent to Evidently. This is a JSON payload. If this event specifies a pre-defined event type, the payload must follow the defined event schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The timestamp of the event.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> <code>aws.evidently.evaluation</code> specifies an evaluation event, which determines which feature variation that a user sees. <code>aws.evidently.custom</code> specifies a custom event, which generates metrics from user actions such as clicks and checkouts.</p>
    pub r#type: std::option::Option<crate::model::EventType>,
    /// <p>The event data.</p>
    pub data: std::option::Option<std::string::String>,
}
impl Event {
    /// <p>The timestamp of the event.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p> <code>aws.evidently.evaluation</code> specifies an evaluation event, which determines which feature variation that a user sees. <code>aws.evidently.custom</code> specifies a custom event, which generates metrics from user actions such as clicks and checkouts.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EventType> {
        self.r#type.as_ref()
    }
    /// <p>The event data.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("r#type", &self.r#type);
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) r#type: std::option::Option<crate::model::EventType>,
        pub(crate) data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The timestamp of the event.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the event.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p> <code>aws.evidently.evaluation</code> specifies an evaluation event, which determines which feature variation that a user sees. <code>aws.evidently.custom</code> specifies a custom event, which generates metrics from user actions such as clicks and checkouts.</p>
        pub fn r#type(mut self, input: crate::model::EventType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> <code>aws.evidently.evaluation</code> specifies an evaluation event, which determines which feature variation that a user sees. <code>aws.evidently.custom</code> specifies a custom event, which generates metrics from user actions such as clicks and checkouts.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::EventType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The event data.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The event data.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                timestamp: self.timestamp,
                r#type: self.r#type,
                data: self.data,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Evaluation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "aws.evidently.custom" => EventType::Custom,
            "aws.evidently.evaluation" => EventType::Evaluation,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::Custom => "aws.evidently.custom",
            EventType::Evaluation => "aws.evidently.evaluation",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["aws.evidently.custom", "aws.evidently.evaluation"]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The value assigned to a feature variation. This structure must contain exactly one field. It can be <code>boolValue</code>, <code>doubleValue</code>, <code>longValue</code>, or <code>stringValue</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum VariableValue {
    /// <p>If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.</p>
    BoolValue(bool),
    /// <p>If this feature uses the double integer variation type, this field contains the double integer value of this variation.</p>
    DoubleValue(f64),
    /// <p>If this feature uses the long variation type, this field contains the long value of this variation.</p>
    LongValue(i64),
    /// <p>If this feature uses the string variation type, this field contains the string value of this variation.</p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VariableValue {
    /// Tries to convert the enum instance into [`BoolValue`](crate::model::VariableValue::BoolValue), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_bool_value(&self) -> std::result::Result<&bool, &Self> {
        if let VariableValue::BoolValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`BoolValue`](crate::model::VariableValue::BoolValue).
    pub fn is_bool_value(&self) -> bool {
        self.as_bool_value().is_ok()
    }
    /// Tries to convert the enum instance into [`DoubleValue`](crate::model::VariableValue::DoubleValue), extracting the inner [`f64`](f64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_double_value(&self) -> std::result::Result<&f64, &Self> {
        if let VariableValue::DoubleValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`DoubleValue`](crate::model::VariableValue::DoubleValue).
    pub fn is_double_value(&self) -> bool {
        self.as_double_value().is_ok()
    }
    /// Tries to convert the enum instance into [`LongValue`](crate::model::VariableValue::LongValue), extracting the inner [`i64`](i64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_long_value(&self) -> std::result::Result<&i64, &Self> {
        if let VariableValue::LongValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`LongValue`](crate::model::VariableValue::LongValue).
    pub fn is_long_value(&self) -> bool {
        self.as_long_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::VariableValue::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let VariableValue::StringValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::VariableValue::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>This structure displays the results of one feature evaluation assignment to one user session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResult {
    /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The name of the feature being evaluated.</p>
    pub feature: std::option::Option<std::string::String>,
    /// <p>The name of the variation that was served to the user session.</p>
    pub variation: std::option::Option<std::string::String>,
    /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
    pub value: std::option::Option<crate::model::VariableValue>,
    /// <p>An internal ID that represents a unique user session of the application.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; or <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
    pub details: std::option::Option<std::string::String>,
}
impl EvaluationResult {
    /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The name of the feature being evaluated.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
    /// <p>The name of the variation that was served to the user session.</p>
    pub fn variation(&self) -> std::option::Option<&str> {
        self.variation.as_deref()
    }
    /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::VariableValue> {
        self.value.as_ref()
    }
    /// <p>An internal ID that represents a unique user session of the application.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; or <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for EvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResult");
        formatter.field("project", &self.project);
        formatter.field("feature", &self.feature);
        formatter.field("variation", &self.variation);
        formatter.field("value", &self.value);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("reason", &self.reason);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`EvaluationResult`](crate::model::EvaluationResult)
pub mod evaluation_result {
    /// A builder for [`EvaluationResult`](crate::model::EvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) feature: std::option::Option<std::string::String>,
        pub(crate) variation: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::VariableValue>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature being evaluated.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// <p>The name of the variation that was served to the user session.</p>
        pub fn variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.variation = Some(input.into());
            self
        }
        /// <p>The name of the variation that was served to the user session.</p>
        pub fn set_variation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.variation = input;
            self
        }
        /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
        pub fn value(mut self, input: crate::model::VariableValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::VariableValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>An internal ID that represents a unique user session of the application.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>An internal ID that represents a unique user session of the application.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; or <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; or <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResult`](crate::model::EvaluationResult)
        pub fn build(self) -> crate::model::EvaluationResult {
            crate::model::EvaluationResult {
                project: self.project,
                feature: self.feature,
                variation: self.variation,
                value: self.value,
                entity_id: self.entity_id,
                reason: self.reason,
                details: self.details,
            }
        }
    }
}
impl EvaluationResult {
    /// Creates a new builder-style object to manufacture [`EvaluationResult`](crate::model::EvaluationResult)
    pub fn builder() -> crate::model::evaluation_result::Builder {
        crate::model::evaluation_result::Builder::default()
    }
}

/// <p>This structure assigns a feature variation to one user session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationRequest {
    /// <p>The name of the feature being evaluated.</p>
    pub feature: std::option::Option<std::string::String>,
    /// <p>An internal ID that represents a unique user session of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
    pub evaluation_context: std::option::Option<std::string::String>,
}
impl EvaluationRequest {
    /// <p>The name of the feature being evaluated.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
    /// <p>An internal ID that represents a unique user session of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
    pub fn evaluation_context(&self) -> std::option::Option<&str> {
        self.evaluation_context.as_deref()
    }
}
impl std::fmt::Debug for EvaluationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationRequest");
        formatter.field("feature", &self.feature);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("evaluation_context", &self.evaluation_context);
        formatter.finish()
    }
}
/// See [`EvaluationRequest`](crate::model::EvaluationRequest)
pub mod evaluation_request {
    /// A builder for [`EvaluationRequest`](crate::model::EvaluationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) evaluation_context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the feature being evaluated.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The name of the feature being evaluated.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// <p>An internal ID that represents a unique user session of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>An internal ID that represents a unique user session of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn evaluation_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_context = Some(input.into());
            self
        }
        /// <p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>
        pub fn set_evaluation_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_context = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationRequest`](crate::model::EvaluationRequest)
        pub fn build(self) -> crate::model::EvaluationRequest {
            crate::model::EvaluationRequest {
                feature: self.feature,
                entity_id: self.entity_id,
                evaluation_context: self.evaluation_context,
            }
        }
    }
}
impl EvaluationRequest {
    /// Creates a new builder-style object to manufacture [`EvaluationRequest`](crate::model::EvaluationRequest)
    pub fn builder() -> crate::model::evaluation_request::Builder {
        crate::model::evaluation_request::Builder::default()
    }
}

/// <p>A structure that contains configuration information about an Evidently project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectSummary {
    /// <p>The name or ARN of the project.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current state of the project.</p>
    pub status: std::option::Option<crate::model::ProjectStatus>,
    /// <p>The description of the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the project is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the project was most recently updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of features currently in the project.</p>
    pub feature_count: std::option::Option<i64>,
    /// <p>The number of launches currently in the project, including launches that are ongoing, completed, and not started yet.</p>
    pub launch_count: std::option::Option<i64>,
    /// <p>The number of ongoing launches currently in the project.</p>
    pub active_launch_count: std::option::Option<i64>,
    /// <p>The number of experiments currently in the project.</p>
    pub experiment_count: std::option::Option<i64>,
    /// <p>The number of experiments currently in the project.</p>
    pub active_experiment_count: std::option::Option<i64>,
    /// <p>The list of tag keys and values associated with this project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ProjectSummary {
    /// <p>The name or ARN of the project.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current state of the project.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProjectStatus> {
        self.status.as_ref()
    }
    /// <p>The description of the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the project is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the project was most recently updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The number of features currently in the project.</p>
    pub fn feature_count(&self) -> std::option::Option<i64> {
        self.feature_count
    }
    /// <p>The number of launches currently in the project, including launches that are ongoing, completed, and not started yet.</p>
    pub fn launch_count(&self) -> std::option::Option<i64> {
        self.launch_count
    }
    /// <p>The number of ongoing launches currently in the project.</p>
    pub fn active_launch_count(&self) -> std::option::Option<i64> {
        self.active_launch_count
    }
    /// <p>The number of experiments currently in the project.</p>
    pub fn experiment_count(&self) -> std::option::Option<i64> {
        self.experiment_count
    }
    /// <p>The number of experiments currently in the project.</p>
    pub fn active_experiment_count(&self) -> std::option::Option<i64> {
        self.active_experiment_count
    }
    /// <p>The list of tag keys and values associated with this project.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ProjectSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("feature_count", &self.feature_count);
        formatter.field("launch_count", &self.launch_count);
        formatter.field("active_launch_count", &self.active_launch_count);
        formatter.field("experiment_count", &self.experiment_count);
        formatter.field("active_experiment_count", &self.active_experiment_count);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ProjectSummary`](crate::model::ProjectSummary)
pub mod project_summary {
    /// A builder for [`ProjectSummary`](crate::model::ProjectSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProjectStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) feature_count: std::option::Option<i64>,
        pub(crate) launch_count: std::option::Option<i64>,
        pub(crate) active_launch_count: std::option::Option<i64>,
        pub(crate) experiment_count: std::option::Option<i64>,
        pub(crate) active_experiment_count: std::option::Option<i64>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name or ARN of the project.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current state of the project.</p>
        pub fn status(mut self, input: crate::model::ProjectStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the project.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProjectStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the project is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the project is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the project was most recently updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time that the project was most recently updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The number of features currently in the project.</p>
        pub fn feature_count(mut self, input: i64) -> Self {
            self.feature_count = Some(input);
            self
        }
        /// <p>The number of features currently in the project.</p>
        pub fn set_feature_count(mut self, input: std::option::Option<i64>) -> Self {
            self.feature_count = input;
            self
        }
        /// <p>The number of launches currently in the project, including launches that are ongoing, completed, and not started yet.</p>
        pub fn launch_count(mut self, input: i64) -> Self {
            self.launch_count = Some(input);
            self
        }
        /// <p>The number of launches currently in the project, including launches that are ongoing, completed, and not started yet.</p>
        pub fn set_launch_count(mut self, input: std::option::Option<i64>) -> Self {
            self.launch_count = input;
            self
        }
        /// <p>The number of ongoing launches currently in the project.</p>
        pub fn active_launch_count(mut self, input: i64) -> Self {
            self.active_launch_count = Some(input);
            self
        }
        /// <p>The number of ongoing launches currently in the project.</p>
        pub fn set_active_launch_count(mut self, input: std::option::Option<i64>) -> Self {
            self.active_launch_count = input;
            self
        }
        /// <p>The number of experiments currently in the project.</p>
        pub fn experiment_count(mut self, input: i64) -> Self {
            self.experiment_count = Some(input);
            self
        }
        /// <p>The number of experiments currently in the project.</p>
        pub fn set_experiment_count(mut self, input: std::option::Option<i64>) -> Self {
            self.experiment_count = input;
            self
        }
        /// <p>The number of experiments currently in the project.</p>
        pub fn active_experiment_count(mut self, input: i64) -> Self {
            self.active_experiment_count = Some(input);
            self
        }
        /// <p>The number of experiments currently in the project.</p>
        pub fn set_active_experiment_count(mut self, input: std::option::Option<i64>) -> Self {
            self.active_experiment_count = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with this project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with this project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectSummary`](crate::model::ProjectSummary)
        pub fn build(self) -> crate::model::ProjectSummary {
            crate::model::ProjectSummary {
                arn: self.arn,
                name: self.name,
                status: self.status,
                description: self.description,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                feature_count: self.feature_count,
                launch_count: self.launch_count,
                active_launch_count: self.active_launch_count,
                experiment_count: self.experiment_count,
                active_experiment_count: self.active_experiment_count,
                tags: self.tags,
            }
        }
    }
}
impl ProjectSummary {
    /// Creates a new builder-style object to manufacture [`ProjectSummary`](crate::model::ProjectSummary)
    pub fn builder() -> crate::model::project_summary::Builder {
        crate::model::project_summary::Builder::default()
    }
}

/// <p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectDataDeliveryConfig {
    /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
    pub s3_destination: std::option::Option<crate::model::S3DestinationConfig>,
    /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
    pub cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
}
impl ProjectDataDeliveryConfig {
    /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
    pub fn s3_destination(&self) -> std::option::Option<&crate::model::S3DestinationConfig> {
        self.s3_destination.as_ref()
    }
    /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
    pub fn cloud_watch_logs(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestinationConfig> {
        self.cloud_watch_logs.as_ref()
    }
}
impl std::fmt::Debug for ProjectDataDeliveryConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectDataDeliveryConfig");
        formatter.field("s3_destination", &self.s3_destination);
        formatter.field("cloud_watch_logs", &self.cloud_watch_logs);
        formatter.finish()
    }
}
/// See [`ProjectDataDeliveryConfig`](crate::model::ProjectDataDeliveryConfig)
pub mod project_data_delivery_config {
    /// A builder for [`ProjectDataDeliveryConfig`](crate::model::ProjectDataDeliveryConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_destination: std::option::Option<crate::model::S3DestinationConfig>,
        pub(crate) cloud_watch_logs:
            std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
    }
    impl Builder {
        /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
        pub fn s3_destination(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
        pub fn cloud_watch_logs(
            mut self,
            input: crate::model::CloudWatchLogsDestinationConfig,
        ) -> Self {
            self.cloud_watch_logs = Some(input);
            self
        }
        /// <p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestinationConfig>,
        ) -> Self {
            self.cloud_watch_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectDataDeliveryConfig`](crate::model::ProjectDataDeliveryConfig)
        pub fn build(self) -> crate::model::ProjectDataDeliveryConfig {
            crate::model::ProjectDataDeliveryConfig {
                s3_destination: self.s3_destination,
                cloud_watch_logs: self.cloud_watch_logs,
            }
        }
    }
}
impl ProjectDataDeliveryConfig {
    /// Creates a new builder-style object to manufacture [`ProjectDataDeliveryConfig`](crate::model::ProjectDataDeliveryConfig)
    pub fn builder() -> crate::model::project_data_delivery_config::Builder {
        crate::model::project_data_delivery_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchStopDesiredState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchStopDesiredState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => LaunchStopDesiredState::Cancelled,
            "COMPLETED" => LaunchStopDesiredState::Completed,
            other => LaunchStopDesiredState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchStopDesiredState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchStopDesiredState::from(s))
    }
}
impl LaunchStopDesiredState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchStopDesiredState::Cancelled => "CANCELLED",
            LaunchStopDesiredState::Completed => "COMPLETED",
            LaunchStopDesiredState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "COMPLETED"]
    }
}
impl AsRef<str> for LaunchStopDesiredState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure contains the configuration details of one Evidently launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Launch {
    /// <p>The ARN of the launch.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the launch.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the project that contains the launch.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The current state of the launch.</p>
    pub status: std::option::Option<crate::model::LaunchStatus>,
    /// <p>If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The description of the launch.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the launch is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the launch was most recently updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A structure that contains information about the start and end times of the launch.</p>
    pub execution: std::option::Option<crate::model::LaunchExecution>,
    /// <p>An array of structures that define the feature variations that are being used in the launch.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::LaunchGroup>>,
    /// <p>An array of structures that define the metrics that are being used to monitor the launch performance.</p>
    pub metric_monitors: std::option::Option<std::vec::Vec<crate::model::MetricMonitor>>,
    /// <p>This value is used when Evidently assigns a particular user session to the launch, to help create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
    pub randomization_salt: std::option::Option<std::string::String>,
    /// <p>The type of launch.</p>
    pub r#type: std::option::Option<crate::model::LaunchType>,
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    pub scheduled_splits_definition:
        std::option::Option<crate::model::ScheduledSplitsLaunchDefinition>,
    /// <p>The list of tag keys and values associated with this launch.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Launch {
    /// <p>The ARN of the launch.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the launch.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the project that contains the launch.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The current state of the launch.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LaunchStatus> {
        self.status.as_ref()
    }
    /// <p>If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The description of the launch.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the launch is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the launch was most recently updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A structure that contains information about the start and end times of the launch.</p>
    pub fn execution(&self) -> std::option::Option<&crate::model::LaunchExecution> {
        self.execution.as_ref()
    }
    /// <p>An array of structures that define the feature variations that are being used in the launch.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::LaunchGroup]> {
        self.groups.as_deref()
    }
    /// <p>An array of structures that define the metrics that are being used to monitor the launch performance.</p>
    pub fn metric_monitors(&self) -> std::option::Option<&[crate::model::MetricMonitor]> {
        self.metric_monitors.as_deref()
    }
    /// <p>This value is used when Evidently assigns a particular user session to the launch, to help create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
    pub fn randomization_salt(&self) -> std::option::Option<&str> {
        self.randomization_salt.as_deref()
    }
    /// <p>The type of launch.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LaunchType> {
        self.r#type.as_ref()
    }
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
    pub fn scheduled_splits_definition(
        &self,
    ) -> std::option::Option<&crate::model::ScheduledSplitsLaunchDefinition> {
        self.scheduled_splits_definition.as_ref()
    }
    /// <p>The list of tag keys and values associated with this launch.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Launch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Launch");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("project", &self.project);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("execution", &self.execution);
        formatter.field("groups", &self.groups);
        formatter.field("metric_monitors", &self.metric_monitors);
        formatter.field("randomization_salt", &self.randomization_salt);
        formatter.field("r#type", &self.r#type);
        formatter.field(
            "scheduled_splits_definition",
            &self.scheduled_splits_definition,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Launch`](crate::model::Launch)
pub mod launch {
    /// A builder for [`Launch`](crate::model::Launch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::LaunchStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) execution: std::option::Option<crate::model::LaunchExecution>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::LaunchGroup>>,
        pub(crate) metric_monitors: std::option::Option<std::vec::Vec<crate::model::MetricMonitor>>,
        pub(crate) randomization_salt: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LaunchType>,
        pub(crate) scheduled_splits_definition:
            std::option::Option<crate::model::ScheduledSplitsLaunchDefinition>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the launch.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the launch.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the launch.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the launch.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The current state of the launch.</p>
        pub fn status(mut self, input: crate::model::LaunchStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the launch.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LaunchStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The description of the launch.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the launch.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the launch is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the launch is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the launch was most recently updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time that the launch was most recently updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A structure that contains information about the start and end times of the launch.</p>
        pub fn execution(mut self, input: crate::model::LaunchExecution) -> Self {
            self.execution = Some(input);
            self
        }
        /// <p>A structure that contains information about the start and end times of the launch.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::LaunchExecution>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array of structures that define the feature variations that are being used in the launch.</p>
        pub fn groups(mut self, input: crate::model::LaunchGroup) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>An array of structures that define the feature variations that are being used in the launch.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchGroup>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Appends an item to `metric_monitors`.
        ///
        /// To override the contents of this collection use [`set_metric_monitors`](Self::set_metric_monitors).
        ///
        /// <p>An array of structures that define the metrics that are being used to monitor the launch performance.</p>
        pub fn metric_monitors(mut self, input: crate::model::MetricMonitor) -> Self {
            let mut v = self.metric_monitors.unwrap_or_default();
            v.push(input);
            self.metric_monitors = Some(v);
            self
        }
        /// <p>An array of structures that define the metrics that are being used to monitor the launch performance.</p>
        pub fn set_metric_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricMonitor>>,
        ) -> Self {
            self.metric_monitors = input;
            self
        }
        /// <p>This value is used when Evidently assigns a particular user session to the launch, to help create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.randomization_salt = Some(input.into());
            self
        }
        /// <p>This value is used when Evidently assigns a particular user session to the launch, to help create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.randomization_salt = input;
            self
        }
        /// <p>The type of launch.</p>
        pub fn r#type(mut self, input: crate::model::LaunchType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of launch.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LaunchType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn scheduled_splits_definition(
            mut self,
            input: crate::model::ScheduledSplitsLaunchDefinition,
        ) -> Self {
            self.scheduled_splits_definition = Some(input);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>
        pub fn set_scheduled_splits_definition(
            mut self,
            input: std::option::Option<crate::model::ScheduledSplitsLaunchDefinition>,
        ) -> Self {
            self.scheduled_splits_definition = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with this launch.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with this launch.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Launch`](crate::model::Launch)
        pub fn build(self) -> crate::model::Launch {
            crate::model::Launch {
                arn: self.arn,
                name: self.name,
                project: self.project,
                status: self.status,
                status_reason: self.status_reason,
                description: self.description,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                execution: self.execution,
                groups: self.groups,
                metric_monitors: self.metric_monitors,
                randomization_salt: self.randomization_salt,
                r#type: self.r#type,
                scheduled_splits_definition: self.scheduled_splits_definition,
                tags: self.tags,
            }
        }
    }
}
impl Launch {
    /// Creates a new builder-style object to manufacture [`Launch`](crate::model::Launch)
    pub fn builder() -> crate::model::launch::Builder {
        crate::model::launch::Builder::default()
    }
}

/// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of a launch. This also defines the start time of each step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledSplitsLaunchDefinition {
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::ScheduledSplit>>,
}
impl ScheduledSplitsLaunchDefinition {
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::ScheduledSplit]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for ScheduledSplitsLaunchDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledSplitsLaunchDefinition");
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`ScheduledSplitsLaunchDefinition`](crate::model::ScheduledSplitsLaunchDefinition)
pub mod scheduled_splits_launch_definition {
    /// A builder for [`ScheduledSplitsLaunchDefinition`](crate::model::ScheduledSplitsLaunchDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::ScheduledSplit>>,
    }
    impl Builder {
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
        pub fn steps(mut self, input: crate::model::ScheduledSplit) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledSplit>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledSplitsLaunchDefinition`](crate::model::ScheduledSplitsLaunchDefinition)
        pub fn build(self) -> crate::model::ScheduledSplitsLaunchDefinition {
            crate::model::ScheduledSplitsLaunchDefinition { steps: self.steps }
        }
    }
}
impl ScheduledSplitsLaunchDefinition {
    /// Creates a new builder-style object to manufacture [`ScheduledSplitsLaunchDefinition`](crate::model::ScheduledSplitsLaunchDefinition)
    pub fn builder() -> crate::model::scheduled_splits_launch_definition::Builder {
        crate::model::scheduled_splits_launch_definition::Builder::default()
    }
}

/// <p>This structure defines the traffic allocation percentages among the feature variations during one step of a launch, and the start time of that step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledSplit {
    /// <p>The date and time that this step of the launch starts.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
    pub group_weights: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
}
impl ScheduledSplit {
    /// <p>The date and time that this step of the launch starts.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
    pub fn group_weights(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i64>> {
        self.group_weights.as_ref()
    }
}
impl std::fmt::Debug for ScheduledSplit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledSplit");
        formatter.field("start_time", &self.start_time);
        formatter.field("group_weights", &self.group_weights);
        formatter.finish()
    }
}
/// See [`ScheduledSplit`](crate::model::ScheduledSplit)
pub mod scheduled_split {
    /// A builder for [`ScheduledSplit`](crate::model::ScheduledSplit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) group_weights:
            std::option::Option<std::collections::HashMap<std::string::String, i64>>,
    }
    impl Builder {
        /// <p>The date and time that this step of the launch starts.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that this step of the launch starts.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Adds a key-value pair to `group_weights`.
        ///
        /// To override the contents of this collection use [`set_group_weights`](Self::set_group_weights).
        ///
        /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
        pub fn group_weights(mut self, k: impl Into<std::string::String>, v: i64) -> Self {
            let mut hash_map = self.group_weights.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.group_weights = Some(hash_map);
            self
        }
        /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
        pub fn set_group_weights(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
        ) -> Self {
            self.group_weights = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledSplit`](crate::model::ScheduledSplit)
        pub fn build(self) -> crate::model::ScheduledSplit {
            crate::model::ScheduledSplit {
                start_time: self.start_time,
                group_weights: self.group_weights,
            }
        }
    }
}
impl ScheduledSplit {
    /// Creates a new builder-style object to manufacture [`ScheduledSplit`](crate::model::ScheduledSplit)
    pub fn builder() -> crate::model::scheduled_split::Builder {
        crate::model::scheduled_split::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchType {
    #[allow(missing_docs)] // documentation missing in model
    ScheduledSplitsLaunch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchType {
    fn from(s: &str) -> Self {
        match s {
            "aws.evidently.splits" => LaunchType::ScheduledSplitsLaunch,
            other => LaunchType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchType::from(s))
    }
}
impl LaunchType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchType::ScheduledSplitsLaunch => "aws.evidently.splits",
            LaunchType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["aws.evidently.splits"]
    }
}
impl AsRef<str> for LaunchType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that defines a metric to be used to monitor performance of the variations during a launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricMonitor {
    /// <p>A structure that defines the metric.</p>
    pub metric_definition: std::option::Option<crate::model::MetricDefinition>,
}
impl MetricMonitor {
    /// <p>A structure that defines the metric.</p>
    pub fn metric_definition(&self) -> std::option::Option<&crate::model::MetricDefinition> {
        self.metric_definition.as_ref()
    }
}
impl std::fmt::Debug for MetricMonitor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricMonitor");
        formatter.field("metric_definition", &self.metric_definition);
        formatter.finish()
    }
}
/// See [`MetricMonitor`](crate::model::MetricMonitor)
pub mod metric_monitor {
    /// A builder for [`MetricMonitor`](crate::model::MetricMonitor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_definition: std::option::Option<crate::model::MetricDefinition>,
    }
    impl Builder {
        /// <p>A structure that defines the metric.</p>
        pub fn metric_definition(mut self, input: crate::model::MetricDefinition) -> Self {
            self.metric_definition = Some(input);
            self
        }
        /// <p>A structure that defines the metric.</p>
        pub fn set_metric_definition(
            mut self,
            input: std::option::Option<crate::model::MetricDefinition>,
        ) -> Self {
            self.metric_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricMonitor`](crate::model::MetricMonitor)
        pub fn build(self) -> crate::model::MetricMonitor {
            crate::model::MetricMonitor {
                metric_definition: self.metric_definition,
            }
        }
    }
}
impl MetricMonitor {
    /// Creates a new builder-style object to manufacture [`MetricMonitor`](crate::model::MetricMonitor)
    pub fn builder() -> crate::model::metric_monitor::Builder {
        crate::model::metric_monitor::Builder::default()
    }
}

/// <p>This structure defines a metric that is being used to evaluate the variations during a launch or experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDefinition {
    /// <p>The name of the metric.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded.</p>
    pub entity_id_key: std::option::Option<std::string::String>,
    /// <p>The value that is tracked to produce the metric.</p>
    pub value_key: std::option::Option<std::string::String>,
    /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
    /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>The label for the units that the metric is measuring.</p>
    pub unit_label: std::option::Option<std::string::String>,
}
impl MetricDefinition {
    /// <p>The name of the metric.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded.</p>
    pub fn entity_id_key(&self) -> std::option::Option<&str> {
        self.entity_id_key.as_deref()
    }
    /// <p>The value that is tracked to produce the metric.</p>
    pub fn value_key(&self) -> std::option::Option<&str> {
        self.value_key.as_deref()
    }
    /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
    /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>The label for the units that the metric is measuring.</p>
    pub fn unit_label(&self) -> std::option::Option<&str> {
        self.unit_label.as_deref()
    }
}
impl std::fmt::Debug for MetricDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDefinition");
        formatter.field("name", &self.name);
        formatter.field("entity_id_key", &self.entity_id_key);
        formatter.field("value_key", &self.value_key);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("unit_label", &self.unit_label);
        formatter.finish()
    }
}
/// See [`MetricDefinition`](crate::model::MetricDefinition)
pub mod metric_definition {
    /// A builder for [`MetricDefinition`](crate::model::MetricDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) entity_id_key: std::option::Option<std::string::String>,
        pub(crate) value_key: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) unit_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded.</p>
        pub fn entity_id_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id_key = Some(input.into());
            self
        }
        /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded.</p>
        pub fn set_entity_id_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_id_key = input;
            self
        }
        /// <p>The value that is tracked to produce the metric.</p>
        pub fn value_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.value_key = Some(input.into());
            self
        }
        /// <p>The value that is tracked to produce the metric.</p>
        pub fn set_value_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value_key = input;
            self
        }
        /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
        /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
        /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>The label for the units that the metric is measuring.</p>
        pub fn unit_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit_label = Some(input.into());
            self
        }
        /// <p>The label for the units that the metric is measuring.</p>
        pub fn set_unit_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit_label = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDefinition`](crate::model::MetricDefinition)
        pub fn build(self) -> crate::model::MetricDefinition {
            crate::model::MetricDefinition {
                name: self.name,
                entity_id_key: self.entity_id_key,
                value_key: self.value_key,
                event_pattern: self.event_pattern,
                unit_label: self.unit_label,
            }
        }
    }
}
impl MetricDefinition {
    /// Creates a new builder-style object to manufacture [`MetricDefinition`](crate::model::MetricDefinition)
    pub fn builder() -> crate::model::metric_definition::Builder {
        crate::model::metric_definition::Builder::default()
    }
}

/// <p>A structure that defines one launch group in a launch. A launch group is a variation of the feature that you are including in the launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchGroup {
    /// <p>The name of the launch group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the launch group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The feature variation for this launch group. This is a key-value pair.</p>
    pub feature_variations:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl LaunchGroup {
    /// <p>The name of the launch group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the launch group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The feature variation for this launch group. This is a key-value pair.</p>
    pub fn feature_variations(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.feature_variations.as_ref()
    }
}
impl std::fmt::Debug for LaunchGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchGroup");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("feature_variations", &self.feature_variations);
        formatter.finish()
    }
}
/// See [`LaunchGroup`](crate::model::LaunchGroup)
pub mod launch_group {
    /// A builder for [`LaunchGroup`](crate::model::LaunchGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) feature_variations: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the launch group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the launch group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the launch group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `feature_variations`.
        ///
        /// To override the contents of this collection use [`set_feature_variations`](Self::set_feature_variations).
        ///
        /// <p>The feature variation for this launch group. This is a key-value pair.</p>
        pub fn feature_variations(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.feature_variations.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.feature_variations = Some(hash_map);
            self
        }
        /// <p>The feature variation for this launch group. This is a key-value pair.</p>
        pub fn set_feature_variations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.feature_variations = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchGroup`](crate::model::LaunchGroup)
        pub fn build(self) -> crate::model::LaunchGroup {
            crate::model::LaunchGroup {
                name: self.name,
                description: self.description,
                feature_variations: self.feature_variations,
            }
        }
    }
}
impl LaunchGroup {
    /// Creates a new builder-style object to manufacture [`LaunchGroup`](crate::model::LaunchGroup)
    pub fn builder() -> crate::model::launch_group::Builder {
        crate::model::launch_group::Builder::default()
    }
}

/// <p>This structure contains information about the start and end times of the launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchExecution {
    /// <p>The date and time that the launch started.</p>
    pub started_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the launch ended.</p>
    pub ended_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl LaunchExecution {
    /// <p>The date and time that the launch started.</p>
    pub fn started_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_time.as_ref()
    }
    /// <p>The date and time that the launch ended.</p>
    pub fn ended_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ended_time.as_ref()
    }
}
impl std::fmt::Debug for LaunchExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchExecution");
        formatter.field("started_time", &self.started_time);
        formatter.field("ended_time", &self.ended_time);
        formatter.finish()
    }
}
/// See [`LaunchExecution`](crate::model::LaunchExecution)
pub mod launch_execution {
    /// A builder for [`LaunchExecution`](crate::model::LaunchExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) started_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ended_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time that the launch started.</p>
        pub fn started_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_time = Some(input);
            self
        }
        /// <p>The date and time that the launch started.</p>
        pub fn set_started_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_time = input;
            self
        }
        /// <p>The date and time that the launch ended.</p>
        pub fn ended_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ended_time = Some(input);
            self
        }
        /// <p>The date and time that the launch ended.</p>
        pub fn set_ended_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ended_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchExecution`](crate::model::LaunchExecution)
        pub fn build(self) -> crate::model::LaunchExecution {
            crate::model::LaunchExecution {
                started_time: self.started_time,
                ended_time: self.ended_time,
            }
        }
    }
}
impl LaunchExecution {
    /// Creates a new builder-style object to manufacture [`LaunchExecution`](crate::model::LaunchExecution)
    pub fn builder() -> crate::model::launch_execution::Builder {
        crate::model::launch_execution::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => LaunchStatus::Cancelled,
            "COMPLETED" => LaunchStatus::Completed,
            "CREATED" => LaunchStatus::Created,
            "RUNNING" => LaunchStatus::Running,
            "UPDATING" => LaunchStatus::Updating,
            other => LaunchStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchStatus::from(s))
    }
}
impl LaunchStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchStatus::Cancelled => "CANCELLED",
            LaunchStatus::Completed => "COMPLETED",
            LaunchStatus::Created => "CREATED",
            LaunchStatus::Running => "RUNNING",
            LaunchStatus::Updating => "UPDATING",
            LaunchStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "COMPLETED", "CREATED", "RUNNING", "UPDATING"]
    }
}
impl AsRef<str> for LaunchStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that defines one launch group in a launch. A launch group is a variation of the feature that you are including in the launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchGroupConfig {
    /// <p>A name for this launch group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the launch group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The feature that this launch is using.</p>
    pub feature: std::option::Option<std::string::String>,
    /// <p>The feature variation to use for this launch group.</p>
    pub variation: std::option::Option<std::string::String>,
}
impl LaunchGroupConfig {
    /// <p>A name for this launch group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the launch group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The feature that this launch is using.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
    /// <p>The feature variation to use for this launch group.</p>
    pub fn variation(&self) -> std::option::Option<&str> {
        self.variation.as_deref()
    }
}
impl std::fmt::Debug for LaunchGroupConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchGroupConfig");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("feature", &self.feature);
        formatter.field("variation", &self.variation);
        formatter.finish()
    }
}
/// See [`LaunchGroupConfig`](crate::model::LaunchGroupConfig)
pub mod launch_group_config {
    /// A builder for [`LaunchGroupConfig`](crate::model::LaunchGroupConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) feature: std::option::Option<std::string::String>,
        pub(crate) variation: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name for this launch group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for this launch group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the launch group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the launch group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The feature that this launch is using.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The feature that this launch is using.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// <p>The feature variation to use for this launch group.</p>
        pub fn variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.variation = Some(input.into());
            self
        }
        /// <p>The feature variation to use for this launch group.</p>
        pub fn set_variation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.variation = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchGroupConfig`](crate::model::LaunchGroupConfig)
        pub fn build(self) -> crate::model::LaunchGroupConfig {
            crate::model::LaunchGroupConfig {
                name: self.name,
                description: self.description,
                feature: self.feature,
                variation: self.variation,
            }
        }
    }
}
impl LaunchGroupConfig {
    /// Creates a new builder-style object to manufacture [`LaunchGroupConfig`](crate::model::LaunchGroupConfig)
    pub fn builder() -> crate::model::launch_group_config::Builder {
        crate::model::launch_group_config::Builder::default()
    }
}

/// <p>A structure that defines a metric to be used to monitor performance of the variations during a launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricMonitorConfig {
    /// <p>A structure that defines the metric.</p>
    pub metric_definition: std::option::Option<crate::model::MetricDefinitionConfig>,
}
impl MetricMonitorConfig {
    /// <p>A structure that defines the metric.</p>
    pub fn metric_definition(&self) -> std::option::Option<&crate::model::MetricDefinitionConfig> {
        self.metric_definition.as_ref()
    }
}
impl std::fmt::Debug for MetricMonitorConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricMonitorConfig");
        formatter.field("metric_definition", &self.metric_definition);
        formatter.finish()
    }
}
/// See [`MetricMonitorConfig`](crate::model::MetricMonitorConfig)
pub mod metric_monitor_config {
    /// A builder for [`MetricMonitorConfig`](crate::model::MetricMonitorConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_definition: std::option::Option<crate::model::MetricDefinitionConfig>,
    }
    impl Builder {
        /// <p>A structure that defines the metric.</p>
        pub fn metric_definition(mut self, input: crate::model::MetricDefinitionConfig) -> Self {
            self.metric_definition = Some(input);
            self
        }
        /// <p>A structure that defines the metric.</p>
        pub fn set_metric_definition(
            mut self,
            input: std::option::Option<crate::model::MetricDefinitionConfig>,
        ) -> Self {
            self.metric_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricMonitorConfig`](crate::model::MetricMonitorConfig)
        pub fn build(self) -> crate::model::MetricMonitorConfig {
            crate::model::MetricMonitorConfig {
                metric_definition: self.metric_definition,
            }
        }
    }
}
impl MetricMonitorConfig {
    /// Creates a new builder-style object to manufacture [`MetricMonitorConfig`](crate::model::MetricMonitorConfig)
    pub fn builder() -> crate::model::metric_monitor_config::Builder {
        crate::model::metric_monitor_config::Builder::default()
    }
}

/// <p>This structure defines a metric that you want to use to evaluate the variations during a launch or experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDefinitionConfig {
    /// <p>A name for the metric.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is <code>userDetails.userID</code>.</p>
    pub entity_id_key: std::option::Option<std::string::String>,
    /// <p>The value that is tracked to produce the metric.</p>
    pub value_key: std::option::Option<std::string::String>,
    /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
    /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>A label for the units that the metric is measuring.</p>
    pub unit_label: std::option::Option<std::string::String>,
}
impl MetricDefinitionConfig {
    /// <p>A name for the metric.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is <code>userDetails.userID</code>.</p>
    pub fn entity_id_key(&self) -> std::option::Option<&str> {
        self.entity_id_key.as_deref()
    }
    /// <p>The value that is tracked to produce the metric.</p>
    pub fn value_key(&self) -> std::option::Option<&str> {
        self.value_key.as_deref()
    }
    /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
    /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>A label for the units that the metric is measuring.</p>
    pub fn unit_label(&self) -> std::option::Option<&str> {
        self.unit_label.as_deref()
    }
}
impl std::fmt::Debug for MetricDefinitionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDefinitionConfig");
        formatter.field("name", &self.name);
        formatter.field("entity_id_key", &self.entity_id_key);
        formatter.field("value_key", &self.value_key);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("unit_label", &self.unit_label);
        formatter.finish()
    }
}
/// See [`MetricDefinitionConfig`](crate::model::MetricDefinitionConfig)
pub mod metric_definition_config {
    /// A builder for [`MetricDefinitionConfig`](crate::model::MetricDefinitionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) entity_id_key: std::option::Option<std::string::String>,
        pub(crate) value_key: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) unit_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name for the metric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the metric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is <code>userDetails.userID</code>.</p>
        pub fn entity_id_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id_key = Some(input.into());
            self
        }
        /// <p>The entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is <code>userDetails.userID</code>.</p>
        pub fn set_entity_id_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_id_key = input;
            self
        }
        /// <p>The value that is tracked to produce the metric.</p>
        pub fn value_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.value_key = Some(input.into());
            self
        }
        /// <p>The value that is tracked to produce the metric.</p>
        pub fn set_value_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value_key = input;
            self
        }
        /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
        /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The EventBridge event pattern that defines how the metric is recorded.</p>
        /// <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>A label for the units that the metric is measuring.</p>
        pub fn unit_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit_label = Some(input.into());
            self
        }
        /// <p>A label for the units that the metric is measuring.</p>
        pub fn set_unit_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit_label = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDefinitionConfig`](crate::model::MetricDefinitionConfig)
        pub fn build(self) -> crate::model::MetricDefinitionConfig {
            crate::model::MetricDefinitionConfig {
                name: self.name,
                entity_id_key: self.entity_id_key,
                value_key: self.value_key,
                event_pattern: self.event_pattern,
                unit_label: self.unit_label,
            }
        }
    }
}
impl MetricDefinitionConfig {
    /// Creates a new builder-style object to manufacture [`MetricDefinitionConfig`](crate::model::MetricDefinitionConfig)
    pub fn builder() -> crate::model::metric_definition_config::Builder {
        crate::model::metric_definition_config::Builder::default()
    }
}

/// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of a launch. This also defines the start time of each step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledSplitsLaunchConfig {
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::ScheduledSplitConfig>>,
}
impl ScheduledSplitsLaunchConfig {
    /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::ScheduledSplitConfig]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for ScheduledSplitsLaunchConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledSplitsLaunchConfig");
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`ScheduledSplitsLaunchConfig`](crate::model::ScheduledSplitsLaunchConfig)
pub mod scheduled_splits_launch_config {
    /// A builder for [`ScheduledSplitsLaunchConfig`](crate::model::ScheduledSplitsLaunchConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::ScheduledSplitConfig>>,
    }
    impl Builder {
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
        pub fn steps(mut self, input: crate::model::ScheduledSplitConfig) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledSplitConfig>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledSplitsLaunchConfig`](crate::model::ScheduledSplitsLaunchConfig)
        pub fn build(self) -> crate::model::ScheduledSplitsLaunchConfig {
            crate::model::ScheduledSplitsLaunchConfig { steps: self.steps }
        }
    }
}
impl ScheduledSplitsLaunchConfig {
    /// Creates a new builder-style object to manufacture [`ScheduledSplitsLaunchConfig`](crate::model::ScheduledSplitsLaunchConfig)
    pub fn builder() -> crate::model::scheduled_splits_launch_config::Builder {
        crate::model::scheduled_splits_launch_config::Builder::default()
    }
}

/// <p>This structure defines the traffic allocation percentages among the feature variations during one step of a launch, and the start time of that step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledSplitConfig {
    /// <p>The date and time that this step of the launch starts.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
    pub group_weights: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
}
impl ScheduledSplitConfig {
    /// <p>The date and time that this step of the launch starts.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
    pub fn group_weights(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i64>> {
        self.group_weights.as_ref()
    }
}
impl std::fmt::Debug for ScheduledSplitConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledSplitConfig");
        formatter.field("start_time", &self.start_time);
        formatter.field("group_weights", &self.group_weights);
        formatter.finish()
    }
}
/// See [`ScheduledSplitConfig`](crate::model::ScheduledSplitConfig)
pub mod scheduled_split_config {
    /// A builder for [`ScheduledSplitConfig`](crate::model::ScheduledSplitConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) group_weights:
            std::option::Option<std::collections::HashMap<std::string::String, i64>>,
    }
    impl Builder {
        /// <p>The date and time that this step of the launch starts.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that this step of the launch starts.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Adds a key-value pair to `group_weights`.
        ///
        /// To override the contents of this collection use [`set_group_weights`](Self::set_group_weights).
        ///
        /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
        pub fn group_weights(mut self, k: impl Into<std::string::String>, v: i64) -> Self {
            let mut hash_map = self.group_weights.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.group_weights = Some(hash_map);
            self
        }
        /// <p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>
        pub fn set_group_weights(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
        ) -> Self {
            self.group_weights = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledSplitConfig`](crate::model::ScheduledSplitConfig)
        pub fn build(self) -> crate::model::ScheduledSplitConfig {
            crate::model::ScheduledSplitConfig {
                start_time: self.start_time,
                group_weights: self.group_weights,
            }
        }
    }
}
impl ScheduledSplitConfig {
    /// Creates a new builder-style object to manufacture [`ScheduledSplitConfig`](crate::model::ScheduledSplitConfig)
    pub fn builder() -> crate::model::scheduled_split_config::Builder {
        crate::model::scheduled_split_config::Builder::default()
    }
}

/// <p>This structure contains information about one Evidently feature in your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeatureSummary {
    /// <p>The ARN of the feature.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the feature.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the project that contains the feature.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The current state of the feature.</p>
    pub status: std::option::Option<crate::model::FeatureStatus>,
    /// <p>The date and time that the feature is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the feature was most recently updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
    pub evaluation_strategy: std::option::Option<crate::model::FeatureEvaluationStrategy>,
    /// <p>An array of structures that define</p>
    pub evaluation_rules: std::option::Option<std::vec::Vec<crate::model::EvaluationRule>>,
    /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    pub default_variation: std::option::Option<std::string::String>,
    /// <p>The list of tag keys and values associated with this feature.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl FeatureSummary {
    /// <p>The ARN of the feature.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the feature.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the project that contains the feature.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The current state of the feature.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FeatureStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time that the feature is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the feature was most recently updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
    pub fn evaluation_strategy(
        &self,
    ) -> std::option::Option<&crate::model::FeatureEvaluationStrategy> {
        self.evaluation_strategy.as_ref()
    }
    /// <p>An array of structures that define</p>
    pub fn evaluation_rules(&self) -> std::option::Option<&[crate::model::EvaluationRule]> {
        self.evaluation_rules.as_deref()
    }
    /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    pub fn default_variation(&self) -> std::option::Option<&str> {
        self.default_variation.as_deref()
    }
    /// <p>The list of tag keys and values associated with this feature.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for FeatureSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeatureSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("project", &self.project);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("evaluation_strategy", &self.evaluation_strategy);
        formatter.field("evaluation_rules", &self.evaluation_rules);
        formatter.field("default_variation", &self.default_variation);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`FeatureSummary`](crate::model::FeatureSummary)
pub mod feature_summary {
    /// A builder for [`FeatureSummary`](crate::model::FeatureSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FeatureStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) evaluation_strategy:
            std::option::Option<crate::model::FeatureEvaluationStrategy>,
        pub(crate) evaluation_rules:
            std::option::Option<std::vec::Vec<crate::model::EvaluationRule>>,
        pub(crate) default_variation: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the feature.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the feature.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the feature.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the feature.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The current state of the feature.</p>
        pub fn status(mut self, input: crate::model::FeatureStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the feature.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FeatureStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the feature is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the feature is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the feature was most recently updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time that the feature was most recently updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.evaluation_strategy = Some(input);
            self
        }
        /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.evaluation_strategy = input;
            self
        }
        /// Appends an item to `evaluation_rules`.
        ///
        /// To override the contents of this collection use [`set_evaluation_rules`](Self::set_evaluation_rules).
        ///
        /// <p>An array of structures that define</p>
        pub fn evaluation_rules(mut self, input: crate::model::EvaluationRule) -> Self {
            let mut v = self.evaluation_rules.unwrap_or_default();
            v.push(input);
            self.evaluation_rules = Some(v);
            self
        }
        /// <p>An array of structures that define</p>
        pub fn set_evaluation_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationRule>>,
        ) -> Self {
            self.evaluation_rules = input;
            self
        }
        /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_variation = Some(input.into());
            self
        }
        /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_variation = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with this feature.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with this feature.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`FeatureSummary`](crate::model::FeatureSummary)
        pub fn build(self) -> crate::model::FeatureSummary {
            crate::model::FeatureSummary {
                arn: self.arn,
                name: self.name,
                project: self.project,
                status: self.status,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                evaluation_strategy: self.evaluation_strategy,
                evaluation_rules: self.evaluation_rules,
                default_variation: self.default_variation,
                tags: self.tags,
            }
        }
    }
}
impl FeatureSummary {
    /// Creates a new builder-style object to manufacture [`FeatureSummary`](crate::model::FeatureSummary)
    pub fn builder() -> crate::model::feature_summary::Builder {
        crate::model::feature_summary::Builder::default()
    }
}

/// <p>A structure that contains the information about an evaluation rule for this feature, if it is used in a launch or experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationRule {
    /// <p>The name of the experiment or launch.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>This value is <code>aws.evidently.splits</code> if this is an evaluation rule for a launch, and it is <code>aws.evidently.onlineab</code> if this is an evaluation rule for an experiment.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl EvaluationRule {
    /// <p>The name of the experiment or launch.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>This value is <code>aws.evidently.splits</code> if this is an evaluation rule for a launch, and it is <code>aws.evidently.onlineab</code> if this is an evaluation rule for an experiment.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for EvaluationRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationRule");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`EvaluationRule`](crate::model::EvaluationRule)
pub mod evaluation_rule {
    /// A builder for [`EvaluationRule`](crate::model::EvaluationRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the experiment or launch.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the experiment or launch.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>This value is <code>aws.evidently.splits</code> if this is an evaluation rule for a launch, and it is <code>aws.evidently.onlineab</code> if this is an evaluation rule for an experiment.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>This value is <code>aws.evidently.splits</code> if this is an evaluation rule for a launch, and it is <code>aws.evidently.onlineab</code> if this is an evaluation rule for an experiment.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationRule`](crate::model::EvaluationRule)
        pub fn build(self) -> crate::model::EvaluationRule {
            crate::model::EvaluationRule {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl EvaluationRule {
    /// Creates a new builder-style object to manufacture [`EvaluationRule`](crate::model::EvaluationRule)
    pub fn builder() -> crate::model::evaluation_rule::Builder {
        crate::model::evaluation_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeatureEvaluationStrategy {
    #[allow(missing_docs)] // documentation missing in model
    AllRules,
    #[allow(missing_docs)] // documentation missing in model
    DefaultVariation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeatureEvaluationStrategy {
    fn from(s: &str) -> Self {
        match s {
            "ALL_RULES" => FeatureEvaluationStrategy::AllRules,
            "DEFAULT_VARIATION" => FeatureEvaluationStrategy::DefaultVariation,
            other => FeatureEvaluationStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeatureEvaluationStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeatureEvaluationStrategy::from(s))
    }
}
impl FeatureEvaluationStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeatureEvaluationStrategy::AllRules => "ALL_RULES",
            FeatureEvaluationStrategy::DefaultVariation => "DEFAULT_VARIATION",
            FeatureEvaluationStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_RULES", "DEFAULT_VARIATION"]
    }
}
impl AsRef<str> for FeatureEvaluationStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeatureStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeatureStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => FeatureStatus::Available,
            "UPDATING" => FeatureStatus::Updating,
            other => FeatureStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeatureStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeatureStatus::from(s))
    }
}
impl FeatureStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeatureStatus::Available => "AVAILABLE",
            FeatureStatus::Updating => "UPDATING",
            FeatureStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "UPDATING"]
    }
}
impl AsRef<str> for FeatureStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure contains information about one Evidently feature in your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Feature {
    /// <p>The ARN of the feature.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the feature.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the project that contains the feature.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The current state of the feature.</p>
    pub status: std::option::Option<crate::model::FeatureStatus>,
    /// <p>The date and time that the feature is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the feature was most recently updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the feature.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
    pub evaluation_strategy: std::option::Option<crate::model::FeatureEvaluationStrategy>,
    /// <p>Defines the type of value used to define the different feature variations. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-variationtypes.html">Variation types</a> </p>
    pub value_type: std::option::Option<crate::model::VariationValueType>,
    /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
    pub variations: std::option::Option<std::vec::Vec<crate::model::Variation>>,
    /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
    /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
    pub default_variation: std::option::Option<std::string::String>,
    /// <p>An array of structures that define the evaluation rules for the feature.</p>
    pub evaluation_rules: std::option::Option<std::vec::Vec<crate::model::EvaluationRule>>,
    /// <p>The list of tag keys and values associated with this feature.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A set of key-value pairs that specify users who should always be served a specific variation of a feature. Each key specifies a user using their user ID, account ID, or some other identifier. The value specifies the name of the variation that the user is to be served.</p>
    /// <p>For the override to be successful, the value of the key must match the <code>entityId</code> used in the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation.</p>
    pub entity_overrides:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Feature {
    /// <p>The ARN of the feature.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the feature.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the project that contains the feature.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The current state of the feature.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FeatureStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time that the feature is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the feature was most recently updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The description of the feature.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
    pub fn evaluation_strategy(
        &self,
    ) -> std::option::Option<&crate::model::FeatureEvaluationStrategy> {
        self.evaluation_strategy.as_ref()
    }
    /// <p>Defines the type of value used to define the different feature variations. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-variationtypes.html">Variation types</a> </p>
    pub fn value_type(&self) -> std::option::Option<&crate::model::VariationValueType> {
        self.value_type.as_ref()
    }
    /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
    pub fn variations(&self) -> std::option::Option<&[crate::model::Variation]> {
        self.variations.as_deref()
    }
    /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
    /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
    /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
    pub fn default_variation(&self) -> std::option::Option<&str> {
        self.default_variation.as_deref()
    }
    /// <p>An array of structures that define the evaluation rules for the feature.</p>
    pub fn evaluation_rules(&self) -> std::option::Option<&[crate::model::EvaluationRule]> {
        self.evaluation_rules.as_deref()
    }
    /// <p>The list of tag keys and values associated with this feature.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A set of key-value pairs that specify users who should always be served a specific variation of a feature. Each key specifies a user using their user ID, account ID, or some other identifier. The value specifies the name of the variation that the user is to be served.</p>
    /// <p>For the override to be successful, the value of the key must match the <code>entityId</code> used in the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation.</p>
    pub fn entity_overrides(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.entity_overrides.as_ref()
    }
}
impl std::fmt::Debug for Feature {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Feature");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("project", &self.project);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("description", &self.description);
        formatter.field("evaluation_strategy", &self.evaluation_strategy);
        formatter.field("value_type", &self.value_type);
        formatter.field("variations", &self.variations);
        formatter.field("default_variation", &self.default_variation);
        formatter.field("evaluation_rules", &self.evaluation_rules);
        formatter.field("tags", &self.tags);
        formatter.field("entity_overrides", &self.entity_overrides);
        formatter.finish()
    }
}
/// See [`Feature`](crate::model::Feature)
pub mod feature {
    /// A builder for [`Feature`](crate::model::Feature)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FeatureStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) evaluation_strategy:
            std::option::Option<crate::model::FeatureEvaluationStrategy>,
        pub(crate) value_type: std::option::Option<crate::model::VariationValueType>,
        pub(crate) variations: std::option::Option<std::vec::Vec<crate::model::Variation>>,
        pub(crate) default_variation: std::option::Option<std::string::String>,
        pub(crate) evaluation_rules:
            std::option::Option<std::vec::Vec<crate::model::EvaluationRule>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) entity_overrides: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the feature.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the feature.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the feature.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the feature.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains the feature.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The current state of the feature.</p>
        pub fn status(mut self, input: crate::model::FeatureStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the feature.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FeatureStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the feature is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the feature is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the feature was most recently updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time that the feature was most recently updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The description of the feature.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the feature.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
        pub fn evaluation_strategy(
            mut self,
            input: crate::model::FeatureEvaluationStrategy,
        ) -> Self {
            self.evaluation_strategy = Some(input);
            self
        }
        /// <p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>
        pub fn set_evaluation_strategy(
            mut self,
            input: std::option::Option<crate::model::FeatureEvaluationStrategy>,
        ) -> Self {
            self.evaluation_strategy = input;
            self
        }
        /// <p>Defines the type of value used to define the different feature variations. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-variationtypes.html">Variation types</a> </p>
        pub fn value_type(mut self, input: crate::model::VariationValueType) -> Self {
            self.value_type = Some(input);
            self
        }
        /// <p>Defines the type of value used to define the different feature variations. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-variationtypes.html">Variation types</a> </p>
        pub fn set_value_type(
            mut self,
            input: std::option::Option<crate::model::VariationValueType>,
        ) -> Self {
            self.value_type = input;
            self
        }
        /// Appends an item to `variations`.
        ///
        /// To override the contents of this collection use [`set_variations`](Self::set_variations).
        ///
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn variations(mut self, input: crate::model::Variation) -> Self {
            let mut v = self.variations.unwrap_or_default();
            v.push(input);
            self.variations = Some(v);
            self
        }
        /// <p>An array of structures that contain the configuration of the feature's different variations.</p>
        pub fn set_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Variation>>,
        ) -> Self {
            self.variations = input;
            self
        }
        /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn default_variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_variation = Some(input.into());
            self
        }
        /// <p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>
        /// <p>This variation must also be listed in the <code>variations</code> structure.</p>
        /// <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>
        pub fn set_default_variation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_variation = input;
            self
        }
        /// Appends an item to `evaluation_rules`.
        ///
        /// To override the contents of this collection use [`set_evaluation_rules`](Self::set_evaluation_rules).
        ///
        /// <p>An array of structures that define the evaluation rules for the feature.</p>
        pub fn evaluation_rules(mut self, input: crate::model::EvaluationRule) -> Self {
            let mut v = self.evaluation_rules.unwrap_or_default();
            v.push(input);
            self.evaluation_rules = Some(v);
            self
        }
        /// <p>An array of structures that define the evaluation rules for the feature.</p>
        pub fn set_evaluation_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationRule>>,
        ) -> Self {
            self.evaluation_rules = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with this feature.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with this feature.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `entity_overrides`.
        ///
        /// To override the contents of this collection use [`set_entity_overrides`](Self::set_entity_overrides).
        ///
        /// <p>A set of key-value pairs that specify users who should always be served a specific variation of a feature. Each key specifies a user using their user ID, account ID, or some other identifier. The value specifies the name of the variation that the user is to be served.</p>
        /// <p>For the override to be successful, the value of the key must match the <code>entityId</code> used in the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation.</p>
        pub fn entity_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.entity_overrides.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.entity_overrides = Some(hash_map);
            self
        }
        /// <p>A set of key-value pairs that specify users who should always be served a specific variation of a feature. Each key specifies a user using their user ID, account ID, or some other identifier. The value specifies the name of the variation that the user is to be served.</p>
        /// <p>For the override to be successful, the value of the key must match the <code>entityId</code> used in the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation.</p>
        pub fn set_entity_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.entity_overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`Feature`](crate::model::Feature)
        pub fn build(self) -> crate::model::Feature {
            crate::model::Feature {
                arn: self.arn,
                name: self.name,
                project: self.project,
                status: self.status,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                description: self.description,
                evaluation_strategy: self.evaluation_strategy,
                value_type: self.value_type,
                variations: self.variations,
                default_variation: self.default_variation,
                evaluation_rules: self.evaluation_rules,
                tags: self.tags,
                entity_overrides: self.entity_overrides,
            }
        }
    }
}
impl Feature {
    /// Creates a new builder-style object to manufacture [`Feature`](crate::model::Feature)
    pub fn builder() -> crate::model::feature::Builder {
        crate::model::feature::Builder::default()
    }
}

/// <p>This structure contains the name and variation value of one variation of a feature.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Variation {
    /// <p>The name of the variation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value assigned to this variation.</p>
    pub value: std::option::Option<crate::model::VariableValue>,
}
impl Variation {
    /// <p>The name of the variation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value assigned to this variation.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::VariableValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for Variation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Variation");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Variation`](crate::model::Variation)
pub mod variation {
    /// A builder for [`Variation`](crate::model::Variation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::VariableValue>,
    }
    impl Builder {
        /// <p>The name of the variation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value assigned to this variation.</p>
        pub fn value(mut self, input: crate::model::VariableValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value assigned to this variation.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::VariableValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Variation`](crate::model::Variation)
        pub fn build(self) -> crate::model::Variation {
            crate::model::Variation {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Variation {
    /// Creates a new builder-style object to manufacture [`Variation`](crate::model::Variation)
    pub fn builder() -> crate::model::variation::Builder {
        crate::model::variation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VariationValueType {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Double,
    #[allow(missing_docs)] // documentation missing in model
    Long,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VariationValueType {
    fn from(s: &str) -> Self {
        match s {
            "BOOLEAN" => VariationValueType::Boolean,
            "DOUBLE" => VariationValueType::Double,
            "LONG" => VariationValueType::Long,
            "STRING" => VariationValueType::String,
            other => VariationValueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VariationValueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VariationValueType::from(s))
    }
}
impl VariationValueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VariationValueType::Boolean => "BOOLEAN",
            VariationValueType::Double => "DOUBLE",
            VariationValueType::Long => "LONG",
            VariationValueType::String => "STRING",
            VariationValueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOOLEAN", "DOUBLE", "LONG", "STRING"]
    }
}
impl AsRef<str> for VariationValueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure contains the name and variation value of one variation of a feature.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariationConfig {
    /// <p>The name of the variation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value assigned to this variation.</p>
    pub value: std::option::Option<crate::model::VariableValue>,
}
impl VariationConfig {
    /// <p>The name of the variation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value assigned to this variation.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::VariableValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for VariationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariationConfig");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`VariationConfig`](crate::model::VariationConfig)
pub mod variation_config {
    /// A builder for [`VariationConfig`](crate::model::VariationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::VariableValue>,
    }
    impl Builder {
        /// <p>The name of the variation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value assigned to this variation.</p>
        pub fn value(mut self, input: crate::model::VariableValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value assigned to this variation.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::VariableValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`VariationConfig`](crate::model::VariationConfig)
        pub fn build(self) -> crate::model::VariationConfig {
            crate::model::VariationConfig {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl VariationConfig {
    /// Creates a new builder-style object to manufacture [`VariationConfig`](crate::model::VariationConfig)
    pub fn builder() -> crate::model::variation_config::Builder {
        crate::model::variation_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentStopDesiredState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentStopDesiredState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => ExperimentStopDesiredState::Cancelled,
            "COMPLETED" => ExperimentStopDesiredState::Completed,
            other => ExperimentStopDesiredState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentStopDesiredState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentStopDesiredState::from(s))
    }
}
impl ExperimentStopDesiredState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentStopDesiredState::Cancelled => "CANCELLED",
            ExperimentStopDesiredState::Completed => "COMPLETED",
            ExperimentStopDesiredState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "COMPLETED"]
    }
}
impl AsRef<str> for ExperimentStopDesiredState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains results of an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentReport {
    /// <p>The name of the metric that is analyzed in this experiment report.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The name of the variation that this report pertains to.</p>
    pub treatment_name: std::option::Option<std::string::String>,
    /// <p>The type of analysis used for this report.</p>
    pub report_name: std::option::Option<crate::model::ExperimentReportName>,
    /// <p>The content of the report.</p>
    pub content: std::option::Option<std::string::String>,
}
impl ExperimentReport {
    /// <p>The name of the metric that is analyzed in this experiment report.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The name of the variation that this report pertains to.</p>
    pub fn treatment_name(&self) -> std::option::Option<&str> {
        self.treatment_name.as_deref()
    }
    /// <p>The type of analysis used for this report.</p>
    pub fn report_name(&self) -> std::option::Option<&crate::model::ExperimentReportName> {
        self.report_name.as_ref()
    }
    /// <p>The content of the report.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
}
impl std::fmt::Debug for ExperimentReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentReport");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("treatment_name", &self.treatment_name);
        formatter.field("report_name", &self.report_name);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`ExperimentReport`](crate::model::ExperimentReport)
pub mod experiment_report {
    /// A builder for [`ExperimentReport`](crate::model::ExperimentReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) treatment_name: std::option::Option<std::string::String>,
        pub(crate) report_name: std::option::Option<crate::model::ExperimentReportName>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric that is analyzed in this experiment report.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric that is analyzed in this experiment report.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The name of the variation that this report pertains to.</p>
        pub fn treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_name = Some(input.into());
            self
        }
        /// <p>The name of the variation that this report pertains to.</p>
        pub fn set_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_name = input;
            self
        }
        /// <p>The type of analysis used for this report.</p>
        pub fn report_name(mut self, input: crate::model::ExperimentReportName) -> Self {
            self.report_name = Some(input);
            self
        }
        /// <p>The type of analysis used for this report.</p>
        pub fn set_report_name(
            mut self,
            input: std::option::Option<crate::model::ExperimentReportName>,
        ) -> Self {
            self.report_name = input;
            self
        }
        /// <p>The content of the report.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the report.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentReport`](crate::model::ExperimentReport)
        pub fn build(self) -> crate::model::ExperimentReport {
            crate::model::ExperimentReport {
                metric_name: self.metric_name,
                treatment_name: self.treatment_name,
                report_name: self.report_name,
                content: self.content,
            }
        }
    }
}
impl ExperimentReport {
    /// Creates a new builder-style object to manufacture [`ExperimentReport`](crate::model::ExperimentReport)
    pub fn builder() -> crate::model::experiment_report::Builder {
        crate::model::experiment_report::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentReportName {
    #[allow(missing_docs)] // documentation missing in model
    BayesianInference,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentReportName {
    fn from(s: &str) -> Self {
        match s {
            "BayesianInference" => ExperimentReportName::BayesianInference,
            other => ExperimentReportName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentReportName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentReportName::from(s))
    }
}
impl ExperimentReportName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentReportName::BayesianInference => "BayesianInference",
            ExperimentReportName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BayesianInference"]
    }
}
impl AsRef<str> for ExperimentReportName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains experiment results for one metric that is monitored in the experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentResultsData {
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The treatment, or variation, that returned the <code>values</code> in this structure.</p>
    pub treatment_name: std::option::Option<std::string::String>,
    /// <p>The experiment statistic that these results pertain to.</p>
    pub result_stat: std::option::Option<crate::model::ExperimentResultResponseType>,
    /// <p>The values for the <code>metricName</code> that were recorded in the experiment.</p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
}
impl ExperimentResultsData {
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The treatment, or variation, that returned the <code>values</code> in this structure.</p>
    pub fn treatment_name(&self) -> std::option::Option<&str> {
        self.treatment_name.as_deref()
    }
    /// <p>The experiment statistic that these results pertain to.</p>
    pub fn result_stat(&self) -> std::option::Option<&crate::model::ExperimentResultResponseType> {
        self.result_stat.as_ref()
    }
    /// <p>The values for the <code>metricName</code> that were recorded in the experiment.</p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ExperimentResultsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentResultsData");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("treatment_name", &self.treatment_name);
        formatter.field("result_stat", &self.result_stat);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ExperimentResultsData`](crate::model::ExperimentResultsData)
pub mod experiment_results_data {
    /// A builder for [`ExperimentResultsData`](crate::model::ExperimentResultsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) treatment_name: std::option::Option<std::string::String>,
        pub(crate) result_stat: std::option::Option<crate::model::ExperimentResultResponseType>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The treatment, or variation, that returned the <code>values</code> in this structure.</p>
        pub fn treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_name = Some(input.into());
            self
        }
        /// <p>The treatment, or variation, that returned the <code>values</code> in this structure.</p>
        pub fn set_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_name = input;
            self
        }
        /// <p>The experiment statistic that these results pertain to.</p>
        pub fn result_stat(mut self, input: crate::model::ExperimentResultResponseType) -> Self {
            self.result_stat = Some(input);
            self
        }
        /// <p>The experiment statistic that these results pertain to.</p>
        pub fn set_result_stat(
            mut self,
            input: std::option::Option<crate::model::ExperimentResultResponseType>,
        ) -> Self {
            self.result_stat = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values for the <code>metricName</code> that were recorded in the experiment.</p>
        pub fn values(mut self, input: f64) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input);
            self.values = Some(v);
            self
        }
        /// <p>The values for the <code>metricName</code> that were recorded in the experiment.</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentResultsData`](crate::model::ExperimentResultsData)
        pub fn build(self) -> crate::model::ExperimentResultsData {
            crate::model::ExperimentResultsData {
                metric_name: self.metric_name,
                treatment_name: self.treatment_name,
                result_stat: self.result_stat,
                values: self.values,
            }
        }
    }
}
impl ExperimentResultsData {
    /// Creates a new builder-style object to manufacture [`ExperimentResultsData`](crate::model::ExperimentResultsData)
    pub fn builder() -> crate::model::experiment_results_data::Builder {
        crate::model::experiment_results_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentResultResponseType {
    #[allow(missing_docs)] // documentation missing in model
    ConfidenceIntervalLowerbound,
    #[allow(missing_docs)] // documentation missing in model
    ConfidenceIntervalUpperbound,
    #[allow(missing_docs)] // documentation missing in model
    Mean,
    #[allow(missing_docs)] // documentation missing in model
    PValue,
    #[allow(missing_docs)] // documentation missing in model
    TreatmentEffect,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentResultResponseType {
    fn from(s: &str) -> Self {
        match s {
            "ConfidenceIntervalLowerBound" => {
                ExperimentResultResponseType::ConfidenceIntervalLowerbound
            }
            "ConfidenceIntervalUpperBound" => {
                ExperimentResultResponseType::ConfidenceIntervalUpperbound
            }
            "Mean" => ExperimentResultResponseType::Mean,
            "PValue" => ExperimentResultResponseType::PValue,
            "TreatmentEffect" => ExperimentResultResponseType::TreatmentEffect,
            other => ExperimentResultResponseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentResultResponseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentResultResponseType::from(s))
    }
}
impl ExperimentResultResponseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentResultResponseType::ConfidenceIntervalLowerbound => {
                "ConfidenceIntervalLowerBound"
            }
            ExperimentResultResponseType::ConfidenceIntervalUpperbound => {
                "ConfidenceIntervalUpperBound"
            }
            ExperimentResultResponseType::Mean => "Mean",
            ExperimentResultResponseType::PValue => "PValue",
            ExperimentResultResponseType::TreatmentEffect => "TreatmentEffect",
            ExperimentResultResponseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ConfidenceIntervalLowerBound",
            "ConfidenceIntervalUpperBound",
            "Mean",
            "PValue",
            "TreatmentEffect",
        ]
    }
}
impl AsRef<str> for ExperimentResultResponseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentResultRequestType {
    #[allow(missing_docs)] // documentation missing in model
    BaseStat,
    #[allow(missing_docs)] // documentation missing in model
    ConfidenceInterval,
    #[allow(missing_docs)] // documentation missing in model
    PValue,
    #[allow(missing_docs)] // documentation missing in model
    TreatmentEffect,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentResultRequestType {
    fn from(s: &str) -> Self {
        match s {
            "BaseStat" => ExperimentResultRequestType::BaseStat,
            "ConfidenceInterval" => ExperimentResultRequestType::ConfidenceInterval,
            "PValue" => ExperimentResultRequestType::PValue,
            "TreatmentEffect" => ExperimentResultRequestType::TreatmentEffect,
            other => ExperimentResultRequestType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentResultRequestType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentResultRequestType::from(s))
    }
}
impl ExperimentResultRequestType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentResultRequestType::BaseStat => "BaseStat",
            ExperimentResultRequestType::ConfidenceInterval => "ConfidenceInterval",
            ExperimentResultRequestType::PValue => "PValue",
            ExperimentResultRequestType::TreatmentEffect => "TreatmentEffect",
            ExperimentResultRequestType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BaseStat",
            "ConfidenceInterval",
            "PValue",
            "TreatmentEffect",
        ]
    }
}
impl AsRef<str> for ExperimentResultRequestType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentBaseStat {
    #[allow(missing_docs)] // documentation missing in model
    Mean,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentBaseStat {
    fn from(s: &str) -> Self {
        match s {
            "Mean" => ExperimentBaseStat::Mean,
            other => ExperimentBaseStat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentBaseStat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentBaseStat::from(s))
    }
}
impl ExperimentBaseStat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentBaseStat::Mean => "Mean",
            ExperimentBaseStat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Mean"]
    }
}
impl AsRef<str> for ExperimentBaseStat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing the configuration details of an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Experiment {
    /// <p>The ARN of the experiment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the experiment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the project that contains this experiment.</p>
    pub project: std::option::Option<std::string::String>,
    /// <p>The current state of the experiment.</p>
    pub status: std::option::Option<crate::model::ExperimentStatus>,
    /// <p>If the experiment was stopped, this is the string that was entered by the person who stopped the experiment, to explain why it was stopped.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>A description of the experiment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the experiment is first created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the experiment was most recently updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A structure that contains the time and date that Evidently completed the analysis of the experiment.</p>
    pub schedule: std::option::Option<crate::model::ExperimentSchedule>,
    /// <p>A structure that contains the date and time that the experiment started and ended.</p>
    pub execution: std::option::Option<crate::model::ExperimentExecution>,
    /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
    pub treatments: std::option::Option<std::vec::Vec<crate::model::Treatment>>,
    /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    pub metric_goals: std::option::Option<std::vec::Vec<crate::model::MetricGoal>>,
    /// <p>This value is used when Evidently assigns a particular user session to the experiment. It helps create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
    pub randomization_salt: std::option::Option<std::string::String>,
    /// <p>In thousandths of a percent, the amount of the available audience that is allocated to this experiment. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
    /// <p>This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.</p>
    pub sampling_rate: i64,
    /// <p>The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.</p>
    pub r#type: std::option::Option<crate::model::ExperimentType>,
    /// <p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    pub online_ab_definition: std::option::Option<crate::model::OnlineAbDefinition>,
    /// <p>The list of tag keys and values associated with this experiment.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Experiment {
    /// <p>The ARN of the experiment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the experiment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the project that contains this experiment.</p>
    pub fn project(&self) -> std::option::Option<&str> {
        self.project.as_deref()
    }
    /// <p>The current state of the experiment.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExperimentStatus> {
        self.status.as_ref()
    }
    /// <p>If the experiment was stopped, this is the string that was entered by the person who stopped the experiment, to explain why it was stopped.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>A description of the experiment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the experiment is first created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the experiment was most recently updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A structure that contains the time and date that Evidently completed the analysis of the experiment.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::ExperimentSchedule> {
        self.schedule.as_ref()
    }
    /// <p>A structure that contains the date and time that the experiment started and ended.</p>
    pub fn execution(&self) -> std::option::Option<&crate::model::ExperimentExecution> {
        self.execution.as_ref()
    }
    /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
    pub fn treatments(&self) -> std::option::Option<&[crate::model::Treatment]> {
        self.treatments.as_deref()
    }
    /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
    pub fn metric_goals(&self) -> std::option::Option<&[crate::model::MetricGoal]> {
        self.metric_goals.as_deref()
    }
    /// <p>This value is used when Evidently assigns a particular user session to the experiment. It helps create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
    pub fn randomization_salt(&self) -> std::option::Option<&str> {
        self.randomization_salt.as_deref()
    }
    /// <p>In thousandths of a percent, the amount of the available audience that is allocated to this experiment. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
    /// <p>This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.</p>
    pub fn sampling_rate(&self) -> i64 {
        self.sampling_rate
    }
    /// <p>The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ExperimentType> {
        self.r#type.as_ref()
    }
    /// <p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
    pub fn online_ab_definition(&self) -> std::option::Option<&crate::model::OnlineAbDefinition> {
        self.online_ab_definition.as_ref()
    }
    /// <p>The list of tag keys and values associated with this experiment.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Experiment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Experiment");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("project", &self.project);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("schedule", &self.schedule);
        formatter.field("execution", &self.execution);
        formatter.field("treatments", &self.treatments);
        formatter.field("metric_goals", &self.metric_goals);
        formatter.field("randomization_salt", &self.randomization_salt);
        formatter.field("sampling_rate", &self.sampling_rate);
        formatter.field("r#type", &self.r#type);
        formatter.field("online_ab_definition", &self.online_ab_definition);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Experiment`](crate::model::Experiment)
pub mod experiment {
    /// A builder for [`Experiment`](crate::model::Experiment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) project: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ExperimentStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) schedule: std::option::Option<crate::model::ExperimentSchedule>,
        pub(crate) execution: std::option::Option<crate::model::ExperimentExecution>,
        pub(crate) treatments: std::option::Option<std::vec::Vec<crate::model::Treatment>>,
        pub(crate) metric_goals: std::option::Option<std::vec::Vec<crate::model::MetricGoal>>,
        pub(crate) randomization_salt: std::option::Option<std::string::String>,
        pub(crate) sampling_rate: std::option::Option<i64>,
        pub(crate) r#type: std::option::Option<crate::model::ExperimentType>,
        pub(crate) online_ab_definition: std::option::Option<crate::model::OnlineAbDefinition>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the experiment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the experiment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the experiment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the experiment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the project that contains this experiment.</p>
        pub fn project(mut self, input: impl Into<std::string::String>) -> Self {
            self.project = Some(input.into());
            self
        }
        /// <p>The name or ARN of the project that contains this experiment.</p>
        pub fn set_project(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project = input;
            self
        }
        /// <p>The current state of the experiment.</p>
        pub fn status(mut self, input: crate::model::ExperimentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the experiment.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExperimentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If the experiment was stopped, this is the string that was entered by the person who stopped the experiment, to explain why it was stopped.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>If the experiment was stopped, this is the string that was entered by the person who stopped the experiment, to explain why it was stopped.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>A description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the experiment is first created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the experiment is first created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the experiment was most recently updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time that the experiment was most recently updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A structure that contains the time and date that Evidently completed the analysis of the experiment.</p>
        pub fn schedule(mut self, input: crate::model::ExperimentSchedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>A structure that contains the time and date that Evidently completed the analysis of the experiment.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::ExperimentSchedule>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>A structure that contains the date and time that the experiment started and ended.</p>
        pub fn execution(mut self, input: crate::model::ExperimentExecution) -> Self {
            self.execution = Some(input);
            self
        }
        /// <p>A structure that contains the date and time that the experiment started and ended.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::ExperimentExecution>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// Appends an item to `treatments`.
        ///
        /// To override the contents of this collection use [`set_treatments`](Self::set_treatments).
        ///
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn treatments(mut self, input: crate::model::Treatment) -> Self {
            let mut v = self.treatments.unwrap_or_default();
            v.push(input);
            self.treatments = Some(v);
            self
        }
        /// <p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>
        pub fn set_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Treatment>>,
        ) -> Self {
            self.treatments = input;
            self
        }
        /// Appends an item to `metric_goals`.
        ///
        /// To override the contents of this collection use [`set_metric_goals`](Self::set_metric_goals).
        ///
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn metric_goals(mut self, input: crate::model::MetricGoal) -> Self {
            let mut v = self.metric_goals.unwrap_or_default();
            v.push(input);
            self.metric_goals = Some(v);
            self
        }
        /// <p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>
        pub fn set_metric_goals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricGoal>>,
        ) -> Self {
            self.metric_goals = input;
            self
        }
        /// <p>This value is used when Evidently assigns a particular user session to the experiment. It helps create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
        pub fn randomization_salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.randomization_salt = Some(input.into());
            self
        }
        /// <p>This value is used when Evidently assigns a particular user session to the experiment. It helps create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>
        pub fn set_randomization_salt(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.randomization_salt = input;
            self
        }
        /// <p>In thousandths of a percent, the amount of the available audience that is allocated to this experiment. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.sampling_rate = Some(input);
            self
        }
        /// <p>In thousandths of a percent, the amount of the available audience that is allocated to this experiment. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p>
        /// <p>This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.sampling_rate = input;
            self
        }
        /// <p>The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.</p>
        pub fn r#type(mut self, input: crate::model::ExperimentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ExperimentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn online_ab_definition(mut self, input: crate::model::OnlineAbDefinition) -> Self {
            self.online_ab_definition = Some(input);
            self
        }
        /// <p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
        pub fn set_online_ab_definition(
            mut self,
            input: std::option::Option<crate::model::OnlineAbDefinition>,
        ) -> Self {
            self.online_ab_definition = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with this experiment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with this experiment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Experiment`](crate::model::Experiment)
        pub fn build(self) -> crate::model::Experiment {
            crate::model::Experiment {
                arn: self.arn,
                name: self.name,
                project: self.project,
                status: self.status,
                status_reason: self.status_reason,
                description: self.description,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                schedule: self.schedule,
                execution: self.execution,
                treatments: self.treatments,
                metric_goals: self.metric_goals,
                randomization_salt: self.randomization_salt,
                sampling_rate: self.sampling_rate.unwrap_or_default(),
                r#type: self.r#type,
                online_ab_definition: self.online_ab_definition,
                tags: self.tags,
            }
        }
    }
}
impl Experiment {
    /// Creates a new builder-style object to manufacture [`Experiment`](crate::model::Experiment)
    pub fn builder() -> crate::model::experiment::Builder {
        crate::model::experiment::Builder::default()
    }
}

/// <p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnlineAbDefinition {
    /// <p>The name of the variation that is the default variation that the other variations are compared to.</p>
    pub control_treatment_name: std::option::Option<std::string::String>,
    /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. The traffic portion is specified in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
    pub treatment_weights: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
}
impl OnlineAbDefinition {
    /// <p>The name of the variation that is the default variation that the other variations are compared to.</p>
    pub fn control_treatment_name(&self) -> std::option::Option<&str> {
        self.control_treatment_name.as_deref()
    }
    /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. The traffic portion is specified in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
    pub fn treatment_weights(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i64>> {
        self.treatment_weights.as_ref()
    }
}
impl std::fmt::Debug for OnlineAbDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnlineAbDefinition");
        formatter.field("control_treatment_name", &self.control_treatment_name);
        formatter.field("treatment_weights", &self.treatment_weights);
        formatter.finish()
    }
}
/// See [`OnlineAbDefinition`](crate::model::OnlineAbDefinition)
pub mod online_ab_definition {
    /// A builder for [`OnlineAbDefinition`](crate::model::OnlineAbDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_treatment_name: std::option::Option<std::string::String>,
        pub(crate) treatment_weights:
            std::option::Option<std::collections::HashMap<std::string::String, i64>>,
    }
    impl Builder {
        /// <p>The name of the variation that is the default variation that the other variations are compared to.</p>
        pub fn control_treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_treatment_name = Some(input.into());
            self
        }
        /// <p>The name of the variation that is the default variation that the other variations are compared to.</p>
        pub fn set_control_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_treatment_name = input;
            self
        }
        /// Adds a key-value pair to `treatment_weights`.
        ///
        /// To override the contents of this collection use [`set_treatment_weights`](Self::set_treatment_weights).
        ///
        /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. The traffic portion is specified in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
        pub fn treatment_weights(mut self, k: impl Into<std::string::String>, v: i64) -> Self {
            let mut hash_map = self.treatment_weights.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.treatment_weights = Some(hash_map);
            self
        }
        /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. The traffic portion is specified in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
        pub fn set_treatment_weights(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
        ) -> Self {
            self.treatment_weights = input;
            self
        }
        /// Consumes the builder and constructs a [`OnlineAbDefinition`](crate::model::OnlineAbDefinition)
        pub fn build(self) -> crate::model::OnlineAbDefinition {
            crate::model::OnlineAbDefinition {
                control_treatment_name: self.control_treatment_name,
                treatment_weights: self.treatment_weights,
            }
        }
    }
}
impl OnlineAbDefinition {
    /// Creates a new builder-style object to manufacture [`OnlineAbDefinition`](crate::model::OnlineAbDefinition)
    pub fn builder() -> crate::model::online_ab_definition::Builder {
        crate::model::online_ab_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentType {
    #[allow(missing_docs)] // documentation missing in model
    OnlineAbExperiment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentType {
    fn from(s: &str) -> Self {
        match s {
            "aws.evidently.onlineab" => ExperimentType::OnlineAbExperiment,
            other => ExperimentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentType::from(s))
    }
}
impl ExperimentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentType::OnlineAbExperiment => "aws.evidently.onlineab",
            ExperimentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["aws.evidently.onlineab"]
    }
}
impl AsRef<str> for ExperimentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that tells Evidently whether higher or lower values are desired for a metric that is used in an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricGoal {
    /// <p>A structure that contains details about the metric.</p>
    pub metric_definition: std::option::Option<crate::model::MetricDefinition>,
    /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
    /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
    pub desired_change: std::option::Option<crate::model::ChangeDirectionEnum>,
}
impl MetricGoal {
    /// <p>A structure that contains details about the metric.</p>
    pub fn metric_definition(&self) -> std::option::Option<&crate::model::MetricDefinition> {
        self.metric_definition.as_ref()
    }
    /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
    /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
    pub fn desired_change(&self) -> std::option::Option<&crate::model::ChangeDirectionEnum> {
        self.desired_change.as_ref()
    }
}
impl std::fmt::Debug for MetricGoal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricGoal");
        formatter.field("metric_definition", &self.metric_definition);
        formatter.field("desired_change", &self.desired_change);
        formatter.finish()
    }
}
/// See [`MetricGoal`](crate::model::MetricGoal)
pub mod metric_goal {
    /// A builder for [`MetricGoal`](crate::model::MetricGoal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_definition: std::option::Option<crate::model::MetricDefinition>,
        pub(crate) desired_change: std::option::Option<crate::model::ChangeDirectionEnum>,
    }
    impl Builder {
        /// <p>A structure that contains details about the metric.</p>
        pub fn metric_definition(mut self, input: crate::model::MetricDefinition) -> Self {
            self.metric_definition = Some(input);
            self
        }
        /// <p>A structure that contains details about the metric.</p>
        pub fn set_metric_definition(
            mut self,
            input: std::option::Option<crate::model::MetricDefinition>,
        ) -> Self {
            self.metric_definition = input;
            self
        }
        /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
        /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
        pub fn desired_change(mut self, input: crate::model::ChangeDirectionEnum) -> Self {
            self.desired_change = Some(input);
            self
        }
        /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
        /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
        pub fn set_desired_change(
            mut self,
            input: std::option::Option<crate::model::ChangeDirectionEnum>,
        ) -> Self {
            self.desired_change = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricGoal`](crate::model::MetricGoal)
        pub fn build(self) -> crate::model::MetricGoal {
            crate::model::MetricGoal {
                metric_definition: self.metric_definition,
                desired_change: self.desired_change,
            }
        }
    }
}
impl MetricGoal {
    /// Creates a new builder-style object to manufacture [`MetricGoal`](crate::model::MetricGoal)
    pub fn builder() -> crate::model::metric_goal::Builder {
        crate::model::metric_goal::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeDirectionEnum {
    #[allow(missing_docs)] // documentation missing in model
    Decrease,
    #[allow(missing_docs)] // documentation missing in model
    Increase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeDirectionEnum {
    fn from(s: &str) -> Self {
        match s {
            "DECREASE" => ChangeDirectionEnum::Decrease,
            "INCREASE" => ChangeDirectionEnum::Increase,
            other => ChangeDirectionEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeDirectionEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeDirectionEnum::from(s))
    }
}
impl ChangeDirectionEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeDirectionEnum::Decrease => "DECREASE",
            ChangeDirectionEnum::Increase => "INCREASE",
            ChangeDirectionEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DECREASE", "INCREASE"]
    }
}
impl AsRef<str> for ChangeDirectionEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that defines one treatment in an experiment. A treatment is a variation of the feature that you are including in the experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Treatment {
    /// <p>The name of this treatment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the treatment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The feature variation used for this treatment. This is a key-value pair. The key is the feature name, and the value is the variation name.</p>
    pub feature_variations:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Treatment {
    /// <p>The name of this treatment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the treatment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The feature variation used for this treatment. This is a key-value pair. The key is the feature name, and the value is the variation name.</p>
    pub fn feature_variations(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.feature_variations.as_ref()
    }
}
impl std::fmt::Debug for Treatment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Treatment");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("feature_variations", &self.feature_variations);
        formatter.finish()
    }
}
/// See [`Treatment`](crate::model::Treatment)
pub mod treatment {
    /// A builder for [`Treatment`](crate::model::Treatment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) feature_variations: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of this treatment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this treatment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the treatment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the treatment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `feature_variations`.
        ///
        /// To override the contents of this collection use [`set_feature_variations`](Self::set_feature_variations).
        ///
        /// <p>The feature variation used for this treatment. This is a key-value pair. The key is the feature name, and the value is the variation name.</p>
        pub fn feature_variations(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.feature_variations.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.feature_variations = Some(hash_map);
            self
        }
        /// <p>The feature variation used for this treatment. This is a key-value pair. The key is the feature name, and the value is the variation name.</p>
        pub fn set_feature_variations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.feature_variations = input;
            self
        }
        /// Consumes the builder and constructs a [`Treatment`](crate::model::Treatment)
        pub fn build(self) -> crate::model::Treatment {
            crate::model::Treatment {
                name: self.name,
                description: self.description,
                feature_variations: self.feature_variations,
            }
        }
    }
}
impl Treatment {
    /// Creates a new builder-style object to manufacture [`Treatment`](crate::model::Treatment)
    pub fn builder() -> crate::model::treatment::Builder {
        crate::model::treatment::Builder::default()
    }
}

/// <p>This structure contains the date and time that the experiment started and ended.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentExecution {
    /// <p>The date and time that the experiment started.</p>
    pub started_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the experiment ended.</p>
    pub ended_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ExperimentExecution {
    /// <p>The date and time that the experiment started.</p>
    pub fn started_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_time.as_ref()
    }
    /// <p>The date and time that the experiment ended.</p>
    pub fn ended_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ended_time.as_ref()
    }
}
impl std::fmt::Debug for ExperimentExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentExecution");
        formatter.field("started_time", &self.started_time);
        formatter.field("ended_time", &self.ended_time);
        formatter.finish()
    }
}
/// See [`ExperimentExecution`](crate::model::ExperimentExecution)
pub mod experiment_execution {
    /// A builder for [`ExperimentExecution`](crate::model::ExperimentExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) started_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ended_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time that the experiment started.</p>
        pub fn started_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_time = Some(input);
            self
        }
        /// <p>The date and time that the experiment started.</p>
        pub fn set_started_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_time = input;
            self
        }
        /// <p>The date and time that the experiment ended.</p>
        pub fn ended_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ended_time = Some(input);
            self
        }
        /// <p>The date and time that the experiment ended.</p>
        pub fn set_ended_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ended_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentExecution`](crate::model::ExperimentExecution)
        pub fn build(self) -> crate::model::ExperimentExecution {
            crate::model::ExperimentExecution {
                started_time: self.started_time,
                ended_time: self.ended_time,
            }
        }
    }
}
impl ExperimentExecution {
    /// Creates a new builder-style object to manufacture [`ExperimentExecution`](crate::model::ExperimentExecution)
    pub fn builder() -> crate::model::experiment_execution::Builder {
        crate::model::experiment_execution::Builder::default()
    }
}

/// <p>This structure contains the time and date that Evidently completed the analysis of the experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExperimentSchedule {
    /// <p>The time and date that Evidently completed the analysis of the experiment.</p>
    pub analysis_complete_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ExperimentSchedule {
    /// <p>The time and date that Evidently completed the analysis of the experiment.</p>
    pub fn analysis_complete_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.analysis_complete_time.as_ref()
    }
}
impl std::fmt::Debug for ExperimentSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExperimentSchedule");
        formatter.field("analysis_complete_time", &self.analysis_complete_time);
        formatter.finish()
    }
}
/// See [`ExperimentSchedule`](crate::model::ExperimentSchedule)
pub mod experiment_schedule {
    /// A builder for [`ExperimentSchedule`](crate::model::ExperimentSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_complete_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The time and date that Evidently completed the analysis of the experiment.</p>
        pub fn analysis_complete_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.analysis_complete_time = Some(input);
            self
        }
        /// <p>The time and date that Evidently completed the analysis of the experiment.</p>
        pub fn set_analysis_complete_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.analysis_complete_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExperimentSchedule`](crate::model::ExperimentSchedule)
        pub fn build(self) -> crate::model::ExperimentSchedule {
            crate::model::ExperimentSchedule {
                analysis_complete_time: self.analysis_complete_time,
            }
        }
    }
}
impl ExperimentSchedule {
    /// Creates a new builder-style object to manufacture [`ExperimentSchedule`](crate::model::ExperimentSchedule)
    pub fn builder() -> crate::model::experiment_schedule::Builder {
        crate::model::experiment_schedule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExperimentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExperimentStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => ExperimentStatus::Cancelled,
            "COMPLETED" => ExperimentStatus::Completed,
            "CREATED" => ExperimentStatus::Created,
            "RUNNING" => ExperimentStatus::Running,
            "UPDATING" => ExperimentStatus::Updating,
            other => ExperimentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExperimentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExperimentStatus::from(s))
    }
}
impl ExperimentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExperimentStatus::Cancelled => "CANCELLED",
            ExperimentStatus::Completed => "COMPLETED",
            ExperimentStatus::Created => "CREATED",
            ExperimentStatus::Running => "RUNNING",
            ExperimentStatus::Updating => "UPDATING",
            ExperimentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "COMPLETED", "CREATED", "RUNNING", "UPDATING"]
    }
}
impl AsRef<str> for ExperimentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnlineAbConfig {
    /// <p>The name of the variation that is to be the default variation that the other variations are compared to.</p>
    pub control_treatment_name: std::option::Option<std::string::String>,
    /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
    pub treatment_weights: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
}
impl OnlineAbConfig {
    /// <p>The name of the variation that is to be the default variation that the other variations are compared to.</p>
    pub fn control_treatment_name(&self) -> std::option::Option<&str> {
        self.control_treatment_name.as_deref()
    }
    /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
    pub fn treatment_weights(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i64>> {
        self.treatment_weights.as_ref()
    }
}
impl std::fmt::Debug for OnlineAbConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnlineAbConfig");
        formatter.field("control_treatment_name", &self.control_treatment_name);
        formatter.field("treatment_weights", &self.treatment_weights);
        formatter.finish()
    }
}
/// See [`OnlineAbConfig`](crate::model::OnlineAbConfig)
pub mod online_ab_config {
    /// A builder for [`OnlineAbConfig`](crate::model::OnlineAbConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_treatment_name: std::option::Option<std::string::String>,
        pub(crate) treatment_weights:
            std::option::Option<std::collections::HashMap<std::string::String, i64>>,
    }
    impl Builder {
        /// <p>The name of the variation that is to be the default variation that the other variations are compared to.</p>
        pub fn control_treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_treatment_name = Some(input.into());
            self
        }
        /// <p>The name of the variation that is to be the default variation that the other variations are compared to.</p>
        pub fn set_control_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_treatment_name = input;
            self
        }
        /// Adds a key-value pair to `treatment_weights`.
        ///
        /// To override the contents of this collection use [`set_treatment_weights`](Self::set_treatment_weights).
        ///
        /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
        pub fn treatment_weights(mut self, k: impl Into<std::string::String>, v: i64) -> Self {
            let mut hash_map = self.treatment_weights.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.treatment_weights = Some(hash_map);
            self
        }
        /// <p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>
        pub fn set_treatment_weights(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i64>>,
        ) -> Self {
            self.treatment_weights = input;
            self
        }
        /// Consumes the builder and constructs a [`OnlineAbConfig`](crate::model::OnlineAbConfig)
        pub fn build(self) -> crate::model::OnlineAbConfig {
            crate::model::OnlineAbConfig {
                control_treatment_name: self.control_treatment_name,
                treatment_weights: self.treatment_weights,
            }
        }
    }
}
impl OnlineAbConfig {
    /// Creates a new builder-style object to manufacture [`OnlineAbConfig`](crate::model::OnlineAbConfig)
    pub fn builder() -> crate::model::online_ab_config::Builder {
        crate::model::online_ab_config::Builder::default()
    }
}

/// <p>Use this structure to tell Evidently whether higher or lower values are desired for a metric that is used in an experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricGoalConfig {
    /// <p>A structure that contains details about the metric.</p>
    pub metric_definition: std::option::Option<crate::model::MetricDefinitionConfig>,
    /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
    /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
    pub desired_change: std::option::Option<crate::model::ChangeDirectionEnum>,
}
impl MetricGoalConfig {
    /// <p>A structure that contains details about the metric.</p>
    pub fn metric_definition(&self) -> std::option::Option<&crate::model::MetricDefinitionConfig> {
        self.metric_definition.as_ref()
    }
    /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
    /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
    pub fn desired_change(&self) -> std::option::Option<&crate::model::ChangeDirectionEnum> {
        self.desired_change.as_ref()
    }
}
impl std::fmt::Debug for MetricGoalConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricGoalConfig");
        formatter.field("metric_definition", &self.metric_definition);
        formatter.field("desired_change", &self.desired_change);
        formatter.finish()
    }
}
/// See [`MetricGoalConfig`](crate::model::MetricGoalConfig)
pub mod metric_goal_config {
    /// A builder for [`MetricGoalConfig`](crate::model::MetricGoalConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_definition: std::option::Option<crate::model::MetricDefinitionConfig>,
        pub(crate) desired_change: std::option::Option<crate::model::ChangeDirectionEnum>,
    }
    impl Builder {
        /// <p>A structure that contains details about the metric.</p>
        pub fn metric_definition(mut self, input: crate::model::MetricDefinitionConfig) -> Self {
            self.metric_definition = Some(input);
            self
        }
        /// <p>A structure that contains details about the metric.</p>
        pub fn set_metric_definition(
            mut self,
            input: std::option::Option<crate::model::MetricDefinitionConfig>,
        ) -> Self {
            self.metric_definition = input;
            self
        }
        /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
        /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
        pub fn desired_change(mut self, input: crate::model::ChangeDirectionEnum) -> Self {
            self.desired_change = Some(input);
            self
        }
        /// <p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p>
        /// <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>
        pub fn set_desired_change(
            mut self,
            input: std::option::Option<crate::model::ChangeDirectionEnum>,
        ) -> Self {
            self.desired_change = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricGoalConfig`](crate::model::MetricGoalConfig)
        pub fn build(self) -> crate::model::MetricGoalConfig {
            crate::model::MetricGoalConfig {
                metric_definition: self.metric_definition,
                desired_change: self.desired_change,
            }
        }
    }
}
impl MetricGoalConfig {
    /// Creates a new builder-style object to manufacture [`MetricGoalConfig`](crate::model::MetricGoalConfig)
    pub fn builder() -> crate::model::metric_goal_config::Builder {
        crate::model::metric_goal_config::Builder::default()
    }
}

/// <p>A structure that defines one treatment in an experiment. A treatment is a variation of the feature that you are including in the experiment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TreatmentConfig {
    /// <p>A name for this treatment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description for this treatment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The feature that this experiment is testing.</p>
    pub feature: std::option::Option<std::string::String>,
    /// <p>The name of the variation to use as this treatment in the experiment.</p>
    pub variation: std::option::Option<std::string::String>,
}
impl TreatmentConfig {
    /// <p>A name for this treatment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description for this treatment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The feature that this experiment is testing.</p>
    pub fn feature(&self) -> std::option::Option<&str> {
        self.feature.as_deref()
    }
    /// <p>The name of the variation to use as this treatment in the experiment.</p>
    pub fn variation(&self) -> std::option::Option<&str> {
        self.variation.as_deref()
    }
}
impl std::fmt::Debug for TreatmentConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TreatmentConfig");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("feature", &self.feature);
        formatter.field("variation", &self.variation);
        formatter.finish()
    }
}
/// See [`TreatmentConfig`](crate::model::TreatmentConfig)
pub mod treatment_config {
    /// A builder for [`TreatmentConfig`](crate::model::TreatmentConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) feature: std::option::Option<std::string::String>,
        pub(crate) variation: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name for this treatment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for this treatment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description for this treatment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for this treatment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The feature that this experiment is testing.</p>
        pub fn feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature = Some(input.into());
            self
        }
        /// <p>The feature that this experiment is testing.</p>
        pub fn set_feature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature = input;
            self
        }
        /// <p>The name of the variation to use as this treatment in the experiment.</p>
        pub fn variation(mut self, input: impl Into<std::string::String>) -> Self {
            self.variation = Some(input.into());
            self
        }
        /// <p>The name of the variation to use as this treatment in the experiment.</p>
        pub fn set_variation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.variation = input;
            self
        }
        /// Consumes the builder and constructs a [`TreatmentConfig`](crate::model::TreatmentConfig)
        pub fn build(self) -> crate::model::TreatmentConfig {
            crate::model::TreatmentConfig {
                name: self.name,
                description: self.description,
                feature: self.feature,
                variation: self.variation,
            }
        }
    }
}
impl TreatmentConfig {
    /// Creates a new builder-style object to manufacture [`TreatmentConfig`](crate::model::TreatmentConfig)
    pub fn builder() -> crate::model::treatment_config::Builder {
        crate::model::treatment_config::Builder::default()
    }
}
