// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon EventBridge
///
/// Client for invoking operations on Amazon EventBridge. Each operation on Amazon EventBridge is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_eventbridge::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_eventbridge::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_eventbridge::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`ActivateEventSource`](crate::client::fluent_builders::ActivateEventSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ActivateEventSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ActivateEventSource::set_name): <p>The name of the partner event source to activate.</p>
    /// - On success, responds with [`ActivateEventSourceOutput`](crate::output::ActivateEventSourceOutput)

    /// - On failure, responds with [`SdkError<ActivateEventSourceError>`](crate::error::ActivateEventSourceError)
    pub fn activate_event_source(&self) -> fluent_builders::ActivateEventSource {
        fluent_builders::ActivateEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelReplay`](crate::client::fluent_builders::CancelReplay) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replay_name(impl Into<String>)`](crate::client::fluent_builders::CancelReplay::replay_name) / [`set_replay_name(Option<String>)`](crate::client::fluent_builders::CancelReplay::set_replay_name): <p>The name of the replay to cancel.</p>
    /// - On success, responds with [`CancelReplayOutput`](crate::output::CancelReplayOutput) with field(s):
    ///   - [`replay_arn(Option<String>)`](crate::output::CancelReplayOutput::replay_arn): <p>The ARN of the replay to cancel.</p>
    ///   - [`state(Option<ReplayState>)`](crate::output::CancelReplayOutput::state): <p>The current state of the replay.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::CancelReplayOutput::state_reason): <p>The reason that the replay is in the current state.</p>
    /// - On failure, responds with [`SdkError<CancelReplayError>`](crate::error::CancelReplayError)
    pub fn cancel_replay(&self) -> fluent_builders::CancelReplay {
        fluent_builders::CancelReplay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApiDestination`](crate::client::fluent_builders::CreateApiDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApiDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApiDestination::set_name): <p>The name for the API destination to create.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApiDestination::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApiDestination::set_description): <p>A description for the API destination to create.</p>
    ///   - [`connection_arn(impl Into<String>)`](crate::client::fluent_builders::CreateApiDestination::connection_arn) / [`set_connection_arn(Option<String>)`](crate::client::fluent_builders::CreateApiDestination::set_connection_arn): <p>The ARN of the connection to use for the API destination. The destination endpoint must support the authorization type specified for the connection.</p>
    ///   - [`invocation_endpoint(impl Into<String>)`](crate::client::fluent_builders::CreateApiDestination::invocation_endpoint) / [`set_invocation_endpoint(Option<String>)`](crate::client::fluent_builders::CreateApiDestination::set_invocation_endpoint): <p>The URL to the HTTP invocation endpoint for the API destination.</p>
    ///   - [`http_method(ApiDestinationHttpMethod)`](crate::client::fluent_builders::CreateApiDestination::http_method) / [`set_http_method(Option<ApiDestinationHttpMethod>)`](crate::client::fluent_builders::CreateApiDestination::set_http_method): <p>The method to use for the request to the HTTP invocation endpoint.</p>
    ///   - [`invocation_rate_limit_per_second(i32)`](crate::client::fluent_builders::CreateApiDestination::invocation_rate_limit_per_second) / [`set_invocation_rate_limit_per_second(Option<i32>)`](crate::client::fluent_builders::CreateApiDestination::set_invocation_rate_limit_per_second): <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
    /// - On success, responds with [`CreateApiDestinationOutput`](crate::output::CreateApiDestinationOutput) with field(s):
    ///   - [`api_destination_arn(Option<String>)`](crate::output::CreateApiDestinationOutput::api_destination_arn): <p>The ARN of the API destination that was created by the request.</p>
    ///   - [`api_destination_state(Option<ApiDestinationState>)`](crate::output::CreateApiDestinationOutput::api_destination_state): <p>The state of the API destination that was created by the request.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::CreateApiDestinationOutput::creation_time): <p>A time stamp indicating the time that the API destination was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::CreateApiDestinationOutput::last_modified_time): <p>A time stamp indicating the time that the API destination was last modified.</p>
    /// - On failure, responds with [`SdkError<CreateApiDestinationError>`](crate::error::CreateApiDestinationError)
    pub fn create_api_destination(&self) -> fluent_builders::CreateApiDestination {
        fluent_builders::CreateApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateArchive`](crate::client::fluent_builders::CreateArchive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`archive_name(impl Into<String>)`](crate::client::fluent_builders::CreateArchive::archive_name) / [`set_archive_name(Option<String>)`](crate::client::fluent_builders::CreateArchive::set_archive_name): <p>The name for the archive to create.</p>
    ///   - [`event_source_arn(impl Into<String>)`](crate::client::fluent_builders::CreateArchive::event_source_arn) / [`set_event_source_arn(Option<String>)`](crate::client::fluent_builders::CreateArchive::set_event_source_arn): <p>The ARN of the event bus that sends events to the archive.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateArchive::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateArchive::set_description): <p>A description for the archive.</p>
    ///   - [`event_pattern(impl Into<String>)`](crate::client::fluent_builders::CreateArchive::event_pattern) / [`set_event_pattern(Option<String>)`](crate::client::fluent_builders::CreateArchive::set_event_pattern): <p>An event pattern to use to filter events sent to the archive.</p>
    ///   - [`retention_days(i32)`](crate::client::fluent_builders::CreateArchive::retention_days) / [`set_retention_days(Option<i32>)`](crate::client::fluent_builders::CreateArchive::set_retention_days): <p>The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely</p>
    /// - On success, responds with [`CreateArchiveOutput`](crate::output::CreateArchiveOutput) with field(s):
    ///   - [`archive_arn(Option<String>)`](crate::output::CreateArchiveOutput::archive_arn): <p>The ARN of the archive that was created.</p>
    ///   - [`state(Option<ArchiveState>)`](crate::output::CreateArchiveOutput::state): <p>The state of the archive that was created.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::CreateArchiveOutput::state_reason): <p>The reason that the archive is in the state.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::CreateArchiveOutput::creation_time): <p>The time at which the archive was created.</p>
    /// - On failure, responds with [`SdkError<CreateArchiveError>`](crate::error::CreateArchiveError)
    pub fn create_archive(&self) -> fluent_builders::CreateArchive {
        fluent_builders::CreateArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConnection`](crate::client::fluent_builders::CreateConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_name): <p>The name for the connection to create.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_description): <p>A description for the connection to create.</p>
    ///   - [`authorization_type(ConnectionAuthorizationType)`](crate::client::fluent_builders::CreateConnection::authorization_type) / [`set_authorization_type(Option<ConnectionAuthorizationType>)`](crate::client::fluent_builders::CreateConnection::set_authorization_type): <p>The type of authorization to use for the connection.</p>
    ///   - [`auth_parameters(CreateConnectionAuthRequestParameters)`](crate::client::fluent_builders::CreateConnection::auth_parameters) / [`set_auth_parameters(Option<CreateConnectionAuthRequestParameters>)`](crate::client::fluent_builders::CreateConnection::set_auth_parameters): <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the authorization parameters to use to authorize with the endpoint. </p>
    /// - On success, responds with [`CreateConnectionOutput`](crate::output::CreateConnectionOutput) with field(s):
    ///   - [`connection_arn(Option<String>)`](crate::output::CreateConnectionOutput::connection_arn): <p>The ARN of the connection that was created by the request.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::CreateConnectionOutput::connection_state): <p>The state of the connection that was created by the request.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::CreateConnectionOutput::creation_time): <p>A time stamp for the time that the connection was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::CreateConnectionOutput::last_modified_time): <p>A time stamp for the time that the connection was last updated.</p>
    /// - On failure, responds with [`SdkError<CreateConnectionError>`](crate::error::CreateConnectionError)
    pub fn create_connection(&self) -> fluent_builders::CreateConnection {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventBus`](crate::client::fluent_builders::CreateEventBus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateEventBus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateEventBus::set_name): <p>The name of the new event bus. </p>  <p>Event bus names cannot contain the / character. You can't use the name <code>default</code> for a custom event bus, as this name is already used for your account's default event bus.</p>  <p>If this is a partner event bus, the name must exactly match the name of the partner event source that this event bus is matched to.</p>
    ///   - [`event_source_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventBus::event_source_name) / [`set_event_source_name(Option<String>)`](crate::client::fluent_builders::CreateEventBus::set_event_source_name): <p>If you are creating a partner event bus, this specifies the partner event source that the new event bus will be matched with.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEventBus::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEventBus::set_tags): <p>Tags to associate with the event bus.</p>
    /// - On success, responds with [`CreateEventBusOutput`](crate::output::CreateEventBusOutput) with field(s):
    ///   - [`event_bus_arn(Option<String>)`](crate::output::CreateEventBusOutput::event_bus_arn): <p>The ARN of the new event bus.</p>
    /// - On failure, responds with [`SdkError<CreateEventBusError>`](crate::error::CreateEventBusError)
    pub fn create_event_bus(&self) -> fluent_builders::CreateEventBus {
        fluent_builders::CreateEventBus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePartnerEventSource`](crate::client::fluent_builders::CreatePartnerEventSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePartnerEventSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePartnerEventSource::set_name): <p>The name of the partner event source. This name must be unique and must be in the format <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>. The Amazon Web Services account that wants to use this partner event source must create a partner event bus with a name that matches the name of the partner event source.</p>
    ///   - [`account(impl Into<String>)`](crate::client::fluent_builders::CreatePartnerEventSource::account) / [`set_account(Option<String>)`](crate::client::fluent_builders::CreatePartnerEventSource::set_account): <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this partner event source.</p>
    /// - On success, responds with [`CreatePartnerEventSourceOutput`](crate::output::CreatePartnerEventSourceOutput) with field(s):
    ///   - [`event_source_arn(Option<String>)`](crate::output::CreatePartnerEventSourceOutput::event_source_arn): <p>The ARN of the partner event source.</p>
    /// - On failure, responds with [`SdkError<CreatePartnerEventSourceError>`](crate::error::CreatePartnerEventSourceError)
    pub fn create_partner_event_source(&self) -> fluent_builders::CreatePartnerEventSource {
        fluent_builders::CreatePartnerEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeactivateEventSource`](crate::client::fluent_builders::DeactivateEventSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeactivateEventSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeactivateEventSource::set_name): <p>The name of the partner event source to deactivate.</p>
    /// - On success, responds with [`DeactivateEventSourceOutput`](crate::output::DeactivateEventSourceOutput)

    /// - On failure, responds with [`SdkError<DeactivateEventSourceError>`](crate::error::DeactivateEventSourceError)
    pub fn deactivate_event_source(&self) -> fluent_builders::DeactivateEventSource {
        fluent_builders::DeactivateEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeauthorizeConnection`](crate::client::fluent_builders::DeauthorizeConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeauthorizeConnection::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeauthorizeConnection::set_name): <p>The name of the connection to remove authorization from.</p>
    /// - On success, responds with [`DeauthorizeConnectionOutput`](crate::output::DeauthorizeConnectionOutput) with field(s):
    ///   - [`connection_arn(Option<String>)`](crate::output::DeauthorizeConnectionOutput::connection_arn): <p>The ARN of the connection that authorization was removed from.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::DeauthorizeConnectionOutput::connection_state): <p>The state of the connection.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DeauthorizeConnectionOutput::creation_time): <p>A time stamp for the time that the connection was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::DeauthorizeConnectionOutput::last_modified_time): <p>A time stamp for the time that the connection was last updated.</p>
    ///   - [`last_authorized_time(Option<DateTime>)`](crate::output::DeauthorizeConnectionOutput::last_authorized_time): <p>A time stamp for the time that the connection was last authorized.</p>
    /// - On failure, responds with [`SdkError<DeauthorizeConnectionError>`](crate::error::DeauthorizeConnectionError)
    pub fn deauthorize_connection(&self) -> fluent_builders::DeauthorizeConnection {
        fluent_builders::DeauthorizeConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApiDestination`](crate::client::fluent_builders::DeleteApiDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteApiDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteApiDestination::set_name): <p>The name of the destination to delete.</p>
    /// - On success, responds with [`DeleteApiDestinationOutput`](crate::output::DeleteApiDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteApiDestinationError>`](crate::error::DeleteApiDestinationError)
    pub fn delete_api_destination(&self) -> fluent_builders::DeleteApiDestination {
        fluent_builders::DeleteApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteArchive`](crate::client::fluent_builders::DeleteArchive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`archive_name(impl Into<String>)`](crate::client::fluent_builders::DeleteArchive::archive_name) / [`set_archive_name(Option<String>)`](crate::client::fluent_builders::DeleteArchive::set_archive_name): <p>The name of the archive to delete.</p>
    /// - On success, responds with [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)

    /// - On failure, responds with [`SdkError<DeleteArchiveError>`](crate::error::DeleteArchiveError)
    pub fn delete_archive(&self) -> fluent_builders::DeleteArchive {
        fluent_builders::DeleteArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteConnection::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteConnection::set_name): <p>The name of the connection to delete.</p>
    /// - On success, responds with [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput) with field(s):
    ///   - [`connection_arn(Option<String>)`](crate::output::DeleteConnectionOutput::connection_arn): <p>The ARN of the connection that was deleted.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::DeleteConnectionOutput::connection_state): <p>The state of the connection before it was deleted.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DeleteConnectionOutput::creation_time): <p>A time stamp for the time that the connection was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::DeleteConnectionOutput::last_modified_time): <p>A time stamp for the time that the connection was last modified before it was deleted.</p>
    ///   - [`last_authorized_time(Option<DateTime>)`](crate::output::DeleteConnectionOutput::last_authorized_time): <p>A time stamp for the time that the connection was last authorized before it wa deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteConnectionError>`](crate::error::DeleteConnectionError)
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventBus`](crate::client::fluent_builders::DeleteEventBus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventBus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteEventBus::set_name): <p>The name of the event bus to delete.</p>
    /// - On success, responds with [`DeleteEventBusOutput`](crate::output::DeleteEventBusOutput)

    /// - On failure, responds with [`SdkError<DeleteEventBusError>`](crate::error::DeleteEventBusError)
    pub fn delete_event_bus(&self) -> fluent_builders::DeleteEventBus {
        fluent_builders::DeleteEventBus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePartnerEventSource`](crate::client::fluent_builders::DeletePartnerEventSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeletePartnerEventSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeletePartnerEventSource::set_name): <p>The name of the event source to delete.</p>
    ///   - [`account(impl Into<String>)`](crate::client::fluent_builders::DeletePartnerEventSource::account) / [`set_account(Option<String>)`](crate::client::fluent_builders::DeletePartnerEventSource::set_account): <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
    /// - On success, responds with [`DeletePartnerEventSourceOutput`](crate::output::DeletePartnerEventSourceOutput)

    /// - On failure, responds with [`SdkError<DeletePartnerEventSourceError>`](crate::error::DeletePartnerEventSourceError)
    pub fn delete_partner_event_source(&self) -> fluent_builders::DeletePartnerEventSource {
        fluent_builders::DeletePartnerEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRule`](crate::client::fluent_builders::DeleteRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteRule::set_name): <p>The name of the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRule::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::DeleteRule::set_event_bus_name): <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteRule::force) / [`set_force(bool)`](crate::client::fluent_builders::DeleteRule::set_force): <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
    /// - On success, responds with [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteRuleError>`](crate::error::DeleteRuleError)
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApiDestination`](crate::client::fluent_builders::DescribeApiDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeApiDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeApiDestination::set_name): <p>The name of the API destination to retrieve.</p>
    /// - On success, responds with [`DescribeApiDestinationOutput`](crate::output::DescribeApiDestinationOutput) with field(s):
    ///   - [`api_destination_arn(Option<String>)`](crate::output::DescribeApiDestinationOutput::api_destination_arn): <p>The ARN of the API destination retrieved.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeApiDestinationOutput::name): <p>The name of the API destination retrieved.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeApiDestinationOutput::description): <p>The description for the API destination retrieved.</p>
    ///   - [`api_destination_state(Option<ApiDestinationState>)`](crate::output::DescribeApiDestinationOutput::api_destination_state): <p>The state of the API destination retrieved.</p>
    ///   - [`connection_arn(Option<String>)`](crate::output::DescribeApiDestinationOutput::connection_arn): <p>The ARN of the connection specified for the API destination retrieved.</p>
    ///   - [`invocation_endpoint(Option<String>)`](crate::output::DescribeApiDestinationOutput::invocation_endpoint): <p>The URL to use to connect to the HTTP endpoint.</p>
    ///   - [`http_method(Option<ApiDestinationHttpMethod>)`](crate::output::DescribeApiDestinationOutput::http_method): <p>The method to use to connect to the HTTP endpoint.</p>
    ///   - [`invocation_rate_limit_per_second(Option<i32>)`](crate::output::DescribeApiDestinationOutput::invocation_rate_limit_per_second): <p>The maximum number of invocations per second to specified for the API destination. Note that if you set the invocation rate maximum to a value lower the rate necessary to send all events received on to the destination HTTP endpoint, some events may not be delivered within the 24-hour retry window. If you plan to set the rate lower than the rate necessary to deliver all events, consider using a dead-letter queue to catch events that are not delivered within 24 hours.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeApiDestinationOutput::creation_time): <p>A time stamp for the time that the API destination was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::DescribeApiDestinationOutput::last_modified_time): <p>A time stamp for the time that the API destination was last modified.</p>
    /// - On failure, responds with [`SdkError<DescribeApiDestinationError>`](crate::error::DescribeApiDestinationError)
    pub fn describe_api_destination(&self) -> fluent_builders::DescribeApiDestination {
        fluent_builders::DescribeApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeArchive`](crate::client::fluent_builders::DescribeArchive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`archive_name(impl Into<String>)`](crate::client::fluent_builders::DescribeArchive::archive_name) / [`set_archive_name(Option<String>)`](crate::client::fluent_builders::DescribeArchive::set_archive_name): <p>The name of the archive to retrieve.</p>
    /// - On success, responds with [`DescribeArchiveOutput`](crate::output::DescribeArchiveOutput) with field(s):
    ///   - [`archive_arn(Option<String>)`](crate::output::DescribeArchiveOutput::archive_arn): <p>The ARN of the archive.</p>
    ///   - [`archive_name(Option<String>)`](crate::output::DescribeArchiveOutput::archive_name): <p>The name of the archive.</p>
    ///   - [`event_source_arn(Option<String>)`](crate::output::DescribeArchiveOutput::event_source_arn): <p>The ARN of the event source associated with the archive.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeArchiveOutput::description): <p>The description of the archive.</p>
    ///   - [`event_pattern(Option<String>)`](crate::output::DescribeArchiveOutput::event_pattern): <p>The event pattern used to filter events sent to the archive.</p>
    ///   - [`state(Option<ArchiveState>)`](crate::output::DescribeArchiveOutput::state): <p>The state of the archive.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::DescribeArchiveOutput::state_reason): <p>The reason that the archive is in the state.</p>
    ///   - [`retention_days(Option<i32>)`](crate::output::DescribeArchiveOutput::retention_days): <p>The number of days to retain events for in the archive.</p>
    ///   - [`size_bytes(i64)`](crate::output::DescribeArchiveOutput::size_bytes): <p>The size of the archive in bytes.</p>
    ///   - [`event_count(i64)`](crate::output::DescribeArchiveOutput::event_count): <p>The number of events in the archive.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeArchiveOutput::creation_time): <p>The time at which the archive was created.</p>
    /// - On failure, responds with [`SdkError<DescribeArchiveError>`](crate::error::DescribeArchiveError)
    pub fn describe_archive(&self) -> fluent_builders::DescribeArchive {
        fluent_builders::DescribeArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnection`](crate::client::fluent_builders::DescribeConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeConnection::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeConnection::set_name): <p>The name of the connection to retrieve.</p>
    /// - On success, responds with [`DescribeConnectionOutput`](crate::output::DescribeConnectionOutput) with field(s):
    ///   - [`connection_arn(Option<String>)`](crate::output::DescribeConnectionOutput::connection_arn): <p>The ARN of the connection retrieved.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeConnectionOutput::name): <p>The name of the connection retrieved.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeConnectionOutput::description): <p>The description for the connection retrieved.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::DescribeConnectionOutput::connection_state): <p>The state of the connection retrieved.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::DescribeConnectionOutput::state_reason): <p>The reason that the connection is in the current connection state.</p>
    ///   - [`authorization_type(Option<ConnectionAuthorizationType>)`](crate::output::DescribeConnectionOutput::authorization_type): <p>The type of authorization specified for the connection.</p>
    ///   - [`secret_arn(Option<String>)`](crate::output::DescribeConnectionOutput::secret_arn): <p>The ARN of the secret created from the authorization parameters specified for the connection.</p>
    ///   - [`auth_parameters(Option<ConnectionAuthResponseParameters>)`](crate::output::DescribeConnectionOutput::auth_parameters): <p>The parameters to use for authorization for the connection.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeConnectionOutput::creation_time): <p>A time stamp for the time that the connection was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::DescribeConnectionOutput::last_modified_time): <p>A time stamp for the time that the connection was last modified.</p>
    ///   - [`last_authorized_time(Option<DateTime>)`](crate::output::DescribeConnectionOutput::last_authorized_time): <p>A time stamp for the time that the connection was last authorized.</p>
    /// - On failure, responds with [`SdkError<DescribeConnectionError>`](crate::error::DescribeConnectionError)
    pub fn describe_connection(&self) -> fluent_builders::DescribeConnection {
        fluent_builders::DescribeConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventBus`](crate::client::fluent_builders::DescribeEventBus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeEventBus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeEventBus::set_name): <p>The name or ARN of the event bus to show details for. If you omit this, the default event bus is displayed.</p>
    /// - On success, responds with [`DescribeEventBusOutput`](crate::output::DescribeEventBusOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeEventBusOutput::name): <p>The name of the event bus. Currently, this is always <code>default</code>.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeEventBusOutput::arn): <p>The Amazon Resource Name (ARN) of the account permitted to write events to the current account.</p>
    ///   - [`policy(Option<String>)`](crate::output::DescribeEventBusOutput::policy): <p>The policy that enables the external account to send events to your account.</p>
    /// - On failure, responds with [`SdkError<DescribeEventBusError>`](crate::error::DescribeEventBusError)
    pub fn describe_event_bus(&self) -> fluent_builders::DescribeEventBus {
        fluent_builders::DescribeEventBus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventSource`](crate::client::fluent_builders::DescribeEventSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeEventSource::set_name): <p>The name of the partner event source to display the details of.</p>
    /// - On success, responds with [`DescribeEventSourceOutput`](crate::output::DescribeEventSourceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeEventSourceOutput::arn): <p>The ARN of the partner event source.</p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeEventSourceOutput::created_by): <p>The name of the SaaS partner that created the event source.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeEventSourceOutput::creation_time): <p>The date and time that the event source was created.</p>
    ///   - [`expiration_time(Option<DateTime>)`](crate::output::DescribeEventSourceOutput::expiration_time): <p>The date and time that the event source will expire if you do not create a matching event bus.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeEventSourceOutput::name): <p>The name of the partner event source.</p>
    ///   - [`state(Option<EventSourceState>)`](crate::output::DescribeEventSourceOutput::state): <p>The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event source, and that event bus is active. If it is PENDING, either you haven't yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has since been deleted.</p>
    /// - On failure, responds with [`SdkError<DescribeEventSourceError>`](crate::error::DescribeEventSourceError)
    pub fn describe_event_source(&self) -> fluent_builders::DescribeEventSource {
        fluent_builders::DescribeEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePartnerEventSource`](crate::client::fluent_builders::DescribePartnerEventSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribePartnerEventSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribePartnerEventSource::set_name): <p>The name of the event source to display.</p>
    /// - On success, responds with [`DescribePartnerEventSourceOutput`](crate::output::DescribePartnerEventSourceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribePartnerEventSourceOutput::arn): <p>The ARN of the event source.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribePartnerEventSourceOutput::name): <p>The name of the event source.</p>
    /// - On failure, responds with [`SdkError<DescribePartnerEventSourceError>`](crate::error::DescribePartnerEventSourceError)
    pub fn describe_partner_event_source(&self) -> fluent_builders::DescribePartnerEventSource {
        fluent_builders::DescribePartnerEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplay`](crate::client::fluent_builders::DescribeReplay) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replay_name(impl Into<String>)`](crate::client::fluent_builders::DescribeReplay::replay_name) / [`set_replay_name(Option<String>)`](crate::client::fluent_builders::DescribeReplay::set_replay_name): <p>The name of the replay to retrieve.</p>
    /// - On success, responds with [`DescribeReplayOutput`](crate::output::DescribeReplayOutput) with field(s):
    ///   - [`replay_name(Option<String>)`](crate::output::DescribeReplayOutput::replay_name): <p>The name of the replay.</p>
    ///   - [`replay_arn(Option<String>)`](crate::output::DescribeReplayOutput::replay_arn): <p>The ARN of the replay.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeReplayOutput::description): <p>The description of the replay.</p>
    ///   - [`state(Option<ReplayState>)`](crate::output::DescribeReplayOutput::state): <p>The current state of the replay.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::DescribeReplayOutput::state_reason): <p>The reason that the replay is in the current state.</p>
    ///   - [`event_source_arn(Option<String>)`](crate::output::DescribeReplayOutput::event_source_arn): <p>The ARN of the archive events were replayed from.</p>
    ///   - [`destination(Option<ReplayDestination>)`](crate::output::DescribeReplayOutput::destination): <p>A <code>ReplayDestination</code> object that contains details about the replay.</p>
    ///   - [`event_start_time(Option<DateTime>)`](crate::output::DescribeReplayOutput::event_start_time): <p>The time stamp of the first event that was last replayed from the archive.</p>
    ///   - [`event_end_time(Option<DateTime>)`](crate::output::DescribeReplayOutput::event_end_time): <p>The time stamp for the last event that was replayed from the archive.</p>
    ///   - [`event_last_replayed_time(Option<DateTime>)`](crate::output::DescribeReplayOutput::event_last_replayed_time): <p>The time that the event was last replayed.</p>
    ///   - [`replay_start_time(Option<DateTime>)`](crate::output::DescribeReplayOutput::replay_start_time): <p>A time stamp for the time that the replay started.</p>
    ///   - [`replay_end_time(Option<DateTime>)`](crate::output::DescribeReplayOutput::replay_end_time): <p>A time stamp for the time that the replay stopped.</p>
    /// - On failure, responds with [`SdkError<DescribeReplayError>`](crate::error::DescribeReplayError)
    pub fn describe_replay(&self) -> fluent_builders::DescribeReplay {
        fluent_builders::DescribeReplay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRule`](crate::client::fluent_builders::DescribeRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeRule::set_name): <p>The name of the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRule::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::DescribeRule::set_event_bus_name): <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    /// - On success, responds with [`DescribeRuleOutput`](crate::output::DescribeRuleOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeRuleOutput::name): <p>The name of the rule.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeRuleOutput::arn): <p>The Amazon Resource Name (ARN) of the rule.</p>
    ///   - [`event_pattern(Option<String>)`](crate::output::DescribeRuleOutput::event_pattern): <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    ///   - [`schedule_expression(Option<String>)`](crate::output::DescribeRuleOutput::schedule_expression): <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".</p>
    ///   - [`state(Option<RuleState>)`](crate::output::DescribeRuleOutput::state): <p>Specifies whether the rule is enabled or disabled.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeRuleOutput::description): <p>The description of the rule.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeRuleOutput::role_arn): <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
    ///   - [`managed_by(Option<String>)`](crate::output::DescribeRuleOutput::managed_by): <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, this field displays the principal name of the Amazon Web Services service that created the rule.</p>
    ///   - [`event_bus_name(Option<String>)`](crate::output::DescribeRuleOutput::event_bus_name): <p>The name of the event bus associated with the rule.</p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeRuleOutput::created_by): <p>The account ID of the user that created the rule. If you use <code>PutRule</code> to put a rule on an event bus in another account, the other account is the owner of the rule, and the rule ARN includes the account ID for that account. However, the value for <code>CreatedBy</code> is the account ID as the account that created the rule in the other account.</p>
    /// - On failure, responds with [`SdkError<DescribeRuleError>`](crate::error::DescribeRuleError)
    pub fn describe_rule(&self) -> fluent_builders::DescribeRule {
        fluent_builders::DescribeRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableRule`](crate::client::fluent_builders::DisableRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DisableRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DisableRule::set_name): <p>The name of the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::DisableRule::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::DisableRule::set_event_bus_name): <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    /// - On success, responds with [`DisableRuleOutput`](crate::output::DisableRuleOutput)

    /// - On failure, responds with [`SdkError<DisableRuleError>`](crate::error::DisableRuleError)
    pub fn disable_rule(&self) -> fluent_builders::DisableRule {
        fluent_builders::DisableRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableRule`](crate::client::fluent_builders::EnableRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::EnableRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::EnableRule::set_name): <p>The name of the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::EnableRule::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::EnableRule::set_event_bus_name): <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    /// - On success, responds with [`EnableRuleOutput`](crate::output::EnableRuleOutput)

    /// - On failure, responds with [`SdkError<EnableRuleError>`](crate::error::EnableRuleError)
    pub fn enable_rule(&self) -> fluent_builders::EnableRule {
        fluent_builders::EnableRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApiDestinations`](crate::client::fluent_builders::ListApiDestinations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListApiDestinations::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListApiDestinations::set_name_prefix): <p>A name prefix to filter results returned. Only API destinations with a name that starts with the prefix are returned.</p>
    ///   - [`connection_arn(impl Into<String>)`](crate::client::fluent_builders::ListApiDestinations::connection_arn) / [`set_connection_arn(Option<String>)`](crate::client::fluent_builders::ListApiDestinations::set_connection_arn): <p>The ARN of the connection specified for the API destination.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApiDestinations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApiDestinations::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListApiDestinations::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListApiDestinations::set_limit): <p>The maximum number of API destinations to include in the response.</p>
    /// - On success, responds with [`ListApiDestinationsOutput`](crate::output::ListApiDestinationsOutput) with field(s):
    ///   - [`api_destinations(Option<Vec<ApiDestination>>)`](crate::output::ListApiDestinationsOutput::api_destinations): <p>An array of <code>ApiDestination</code> objects that include information about an API destination.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApiDestinationsOutput::next_token): <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListApiDestinationsError>`](crate::error::ListApiDestinationsError)
    pub fn list_api_destinations(&self) -> fluent_builders::ListApiDestinations {
        fluent_builders::ListApiDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListArchives`](crate::client::fluent_builders::ListArchives) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListArchives::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListArchives::set_name_prefix): <p>A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.</p>
    ///   - [`event_source_arn(impl Into<String>)`](crate::client::fluent_builders::ListArchives::event_source_arn) / [`set_event_source_arn(Option<String>)`](crate::client::fluent_builders::ListArchives::set_event_source_arn): <p>The ARN of the event source associated with the archive.</p>
    ///   - [`state(ArchiveState)`](crate::client::fluent_builders::ListArchives::state) / [`set_state(Option<ArchiveState>)`](crate::client::fluent_builders::ListArchives::set_state): <p>The state of the archive.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListArchives::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListArchives::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListArchives::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListArchives::set_limit): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListArchivesOutput`](crate::output::ListArchivesOutput) with field(s):
    ///   - [`archives(Option<Vec<Archive>>)`](crate::output::ListArchivesOutput::archives): <p>An array of <code>Archive</code> objects that include details about an archive.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListArchivesOutput::next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListArchivesError>`](crate::error::ListArchivesError)
    pub fn list_archives(&self) -> fluent_builders::ListArchives {
        fluent_builders::ListArchives::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConnections`](crate::client::fluent_builders::ListConnections) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListConnections::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListConnections::set_name_prefix): <p>A name prefix to filter results returned. Only connections with a name that starts with the prefix are returned.</p>
    ///   - [`connection_state(ConnectionState)`](crate::client::fluent_builders::ListConnections::connection_state) / [`set_connection_state(Option<ConnectionState>)`](crate::client::fluent_builders::ListConnections::set_connection_state): <p>The state of the connection.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConnections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConnections::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListConnections::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListConnections::set_limit): <p>The maximum number of connections to return.</p>
    /// - On success, responds with [`ListConnectionsOutput`](crate::output::ListConnectionsOutput) with field(s):
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::ListConnectionsOutput::connections): <p>An array of connections objects that include details about the connections.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConnectionsOutput::next_token): <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListConnectionsError>`](crate::error::ListConnectionsError)
    pub fn list_connections(&self) -> fluent_builders::ListConnections {
        fluent_builders::ListConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventBuses`](crate::client::fluent_builders::ListEventBuses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListEventBuses::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListEventBuses::set_name_prefix): <p>Specifying this limits the results to only those event buses with names that start with the specified prefix.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventBuses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventBuses::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListEventBuses::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListEventBuses::set_limit): <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On success, responds with [`ListEventBusesOutput`](crate::output::ListEventBusesOutput) with field(s):
    ///   - [`event_buses(Option<Vec<EventBus>>)`](crate::output::ListEventBusesOutput::event_buses): <p>This list of event buses.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventBusesOutput::next_token): <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListEventBusesError>`](crate::error::ListEventBusesError)
    pub fn list_event_buses(&self) -> fluent_builders::ListEventBuses {
        fluent_builders::ListEventBuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventSources`](crate::client::fluent_builders::ListEventSources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListEventSources::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListEventSources::set_name_prefix): <p>Specifying this limits the results to only those partner event sources with names that start with the specified prefix.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventSources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventSources::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListEventSources::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListEventSources::set_limit): <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On success, responds with [`ListEventSourcesOutput`](crate::output::ListEventSourcesOutput) with field(s):
    ///   - [`event_sources(Option<Vec<EventSource>>)`](crate::output::ListEventSourcesOutput::event_sources): <p>The list of event sources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventSourcesOutput::next_token): <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListEventSourcesError>`](crate::error::ListEventSourcesError)
    pub fn list_event_sources(&self) -> fluent_builders::ListEventSources {
        fluent_builders::ListEventSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPartnerEventSourceAccounts`](crate::client::fluent_builders::ListPartnerEventSourceAccounts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_source_name(impl Into<String>)`](crate::client::fluent_builders::ListPartnerEventSourceAccounts::event_source_name) / [`set_event_source_name(Option<String>)`](crate::client::fluent_builders::ListPartnerEventSourceAccounts::set_event_source_name): <p>The name of the partner event source to display account information about.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPartnerEventSourceAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPartnerEventSourceAccounts::set_next_token): <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListPartnerEventSourceAccounts::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListPartnerEventSourceAccounts::set_limit): <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On success, responds with [`ListPartnerEventSourceAccountsOutput`](crate::output::ListPartnerEventSourceAccountsOutput) with field(s):
    ///   - [`partner_event_source_accounts(Option<Vec<PartnerEventSourceAccount>>)`](crate::output::ListPartnerEventSourceAccountsOutput::partner_event_source_accounts): <p>The list of partner event sources returned by the operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPartnerEventSourceAccountsOutput::next_token): <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListPartnerEventSourceAccountsError>`](crate::error::ListPartnerEventSourceAccountsError)
    pub fn list_partner_event_source_accounts(
        &self,
    ) -> fluent_builders::ListPartnerEventSourceAccounts {
        fluent_builders::ListPartnerEventSourceAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPartnerEventSources`](crate::client::fluent_builders::ListPartnerEventSources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListPartnerEventSources::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListPartnerEventSources::set_name_prefix): <p>If you specify this, the results are limited to only those partner event sources that start with the string you specify.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPartnerEventSources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPartnerEventSources::set_next_token): <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListPartnerEventSources::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListPartnerEventSources::set_limit): <p>pecifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On success, responds with [`ListPartnerEventSourcesOutput`](crate::output::ListPartnerEventSourcesOutput) with field(s):
    ///   - [`partner_event_sources(Option<Vec<PartnerEventSource>>)`](crate::output::ListPartnerEventSourcesOutput::partner_event_sources): <p>The list of partner event sources returned by the operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPartnerEventSourcesOutput::next_token): <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListPartnerEventSourcesError>`](crate::error::ListPartnerEventSourcesError)
    pub fn list_partner_event_sources(&self) -> fluent_builders::ListPartnerEventSources {
        fluent_builders::ListPartnerEventSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReplays`](crate::client::fluent_builders::ListReplays) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListReplays::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListReplays::set_name_prefix): <p>A name prefix to filter the replays returned. Only replays with name that match the prefix are returned.</p>
    ///   - [`state(ReplayState)`](crate::client::fluent_builders::ListReplays::state) / [`set_state(Option<ReplayState>)`](crate::client::fluent_builders::ListReplays::set_state): <p>The state of the replay.</p>
    ///   - [`event_source_arn(impl Into<String>)`](crate::client::fluent_builders::ListReplays::event_source_arn) / [`set_event_source_arn(Option<String>)`](crate::client::fluent_builders::ListReplays::set_event_source_arn): <p>The ARN of the archive from which the events are replayed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReplays::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReplays::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListReplays::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListReplays::set_limit): <p>The maximum number of replays to retrieve.</p>
    /// - On success, responds with [`ListReplaysOutput`](crate::output::ListReplaysOutput) with field(s):
    ///   - [`replays(Option<Vec<Replay>>)`](crate::output::ListReplaysOutput::replays): <p>An array of <code>Replay</code> objects that contain information about the replay.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListReplaysOutput::next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListReplaysError>`](crate::error::ListReplaysError)
    pub fn list_replays(&self) -> fluent_builders::ListReplays {
        fluent_builders::ListReplays::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRuleNamesByTarget`](crate::client::fluent_builders::ListRuleNamesByTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::ListRuleNamesByTarget::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::ListRuleNamesByTarget::set_target_arn): <p>The Amazon Resource Name (ARN) of the target resource.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::ListRuleNamesByTarget::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::ListRuleNamesByTarget::set_event_bus_name): <p>The name or ARN of the event bus to list rules for. If you omit this, the default event bus is used.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRuleNamesByTarget::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRuleNamesByTarget::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRuleNamesByTarget::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListRuleNamesByTarget::set_limit): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListRuleNamesByTargetOutput`](crate::output::ListRuleNamesByTargetOutput) with field(s):
    ///   - [`rule_names(Option<Vec<String>>)`](crate::output::ListRuleNamesByTargetOutput::rule_names): <p>The names of the rules that can invoke the given target.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRuleNamesByTargetOutput::next_token): <p>Indicates whether there are additional results to retrieve. If there are no more results, the value is null.</p>
    /// - On failure, responds with [`SdkError<ListRuleNamesByTargetError>`](crate::error::ListRuleNamesByTargetError)
    pub fn list_rule_names_by_target(&self) -> fluent_builders::ListRuleNamesByTarget {
        fluent_builders::ListRuleNamesByTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRules`](crate::client::fluent_builders::ListRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListRules::name_prefix) / [`set_name_prefix(Option<String>)`](crate::client::fluent_builders::ListRules::set_name_prefix): <p>The prefix matching the rule name.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::ListRules::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::ListRules::set_event_bus_name): <p>The name or ARN of the event bus to list the rules for. If you omit this, the default event bus is used.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRules::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRules::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListRules::set_limit): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListRulesOutput`](crate::output::ListRulesOutput) with field(s):
    ///   - [`rules(Option<Vec<Rule>>)`](crate::output::ListRulesOutput::rules): <p>The rules that match the specified criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRulesOutput::next_token): <p>Indicates whether there are additional results to retrieve. If there are no more results, the value is null.</p>
    /// - On failure, responds with [`SdkError<ListRulesError>`](crate::error::ListRulesError)
    pub fn list_rules(&self) -> fluent_builders::ListRules {
        fluent_builders::ListRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the EventBridge resource for which you want to view tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tag keys and values associated with the resource you specified</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTargetsByRule`](crate::client::fluent_builders::ListTargetsByRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule(impl Into<String>)`](crate::client::fluent_builders::ListTargetsByRule::rule) / [`set_rule(Option<String>)`](crate::client::fluent_builders::ListTargetsByRule::set_rule): <p>The name of the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::ListTargetsByRule::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::ListTargetsByRule::set_event_bus_name): <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTargetsByRule::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTargetsByRule::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTargetsByRule::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTargetsByRule::set_limit): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListTargetsByRuleOutput`](crate::output::ListTargetsByRuleOutput) with field(s):
    ///   - [`targets(Option<Vec<Target>>)`](crate::output::ListTargetsByRuleOutput::targets): <p>The targets assigned to the rule.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTargetsByRuleOutput::next_token): <p>Indicates whether there are additional results to retrieve. If there are no more results, the value is null.</p>
    /// - On failure, responds with [`SdkError<ListTargetsByRuleError>`](crate::error::ListTargetsByRuleError)
    pub fn list_targets_by_rule(&self) -> fluent_builders::ListTargetsByRule {
        fluent_builders::ListTargetsByRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEvents`](crate::client::fluent_builders::PutEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entries(Vec<PutEventsRequestEntry>)`](crate::client::fluent_builders::PutEvents::entries) / [`set_entries(Option<Vec<PutEventsRequestEntry>>)`](crate::client::fluent_builders::PutEvents::set_entries): <p>The entry that defines an event in your system. You can specify several parameters for the entry such as the source and type of the event, resources associated with the event, and so on.</p>
    /// - On success, responds with [`PutEventsOutput`](crate::output::PutEventsOutput) with field(s):
    ///   - [`failed_entry_count(i32)`](crate::output::PutEventsOutput::failed_entry_count): <p>The number of failed entries.</p>
    ///   - [`entries(Option<Vec<PutEventsResultEntry>>)`](crate::output::PutEventsOutput::entries): <p>The successfully and unsuccessfully ingested events results. If the ingestion was successful, the entry has the event ID in it. Otherwise, you can use the error code and error message to identify the problem with the entry.</p>
    /// - On failure, responds with [`SdkError<PutEventsError>`](crate::error::PutEventsError)
    pub fn put_events(&self) -> fluent_builders::PutEvents {
        fluent_builders::PutEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPartnerEvents`](crate::client::fluent_builders::PutPartnerEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entries(Vec<PutPartnerEventsRequestEntry>)`](crate::client::fluent_builders::PutPartnerEvents::entries) / [`set_entries(Option<Vec<PutPartnerEventsRequestEntry>>)`](crate::client::fluent_builders::PutPartnerEvents::set_entries): <p>The list of events to write to the event bus.</p>
    /// - On success, responds with [`PutPartnerEventsOutput`](crate::output::PutPartnerEventsOutput) with field(s):
    ///   - [`failed_entry_count(i32)`](crate::output::PutPartnerEventsOutput::failed_entry_count): <p>The number of events from this operation that could not be written to the partner event bus.</p>
    ///   - [`entries(Option<Vec<PutPartnerEventsResultEntry>>)`](crate::output::PutPartnerEventsOutput::entries): <p>The list of events from this operation that were successfully written to the partner event bus.</p>
    /// - On failure, responds with [`SdkError<PutPartnerEventsError>`](crate::error::PutPartnerEventsError)
    pub fn put_partner_events(&self) -> fluent_builders::PutPartnerEvents {
        fluent_builders::PutPartnerEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPermission`](crate::client::fluent_builders::PutPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::PutPermission::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::PutPermission::set_event_bus_name): <p>The name of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    ///   - [`action(impl Into<String>)`](crate::client::fluent_builders::PutPermission::action) / [`set_action(Option<String>)`](crate::client::fluent_builders::PutPermission::set_action): <p>The action that you are enabling the other account to perform.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::PutPermission::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::PutPermission::set_principal): <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.</p>  <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::PutPermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::PutPermission::set_statement_id): <p>An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p> <note>   <p>Each <code>StatementId</code> must be unique.</p>  </note>
    ///   - [`condition(Condition)`](crate::client::fluent_builders::PutPermission::condition) / [`set_condition(Option<Condition>)`](crate::client::fluent_builders::PutPermission::set_condition): <p>This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>  <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value for <code>Principal</code>, you grant permission to all the accounts in the named organization.</p>  <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and <code>Value</code> fields.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutPermission::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutPermission::set_policy): <p>A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
    /// - On success, responds with [`PutPermissionOutput`](crate::output::PutPermissionOutput)

    /// - On failure, responds with [`SdkError<PutPermissionError>`](crate::error::PutPermissionError)
    pub fn put_permission(&self) -> fluent_builders::PutPermission {
        fluent_builders::PutPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRule`](crate::client::fluent_builders::PutRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutRule::set_name): <p>The name of the rule that you are creating or updating.</p>
    ///   - [`schedule_expression(impl Into<String>)`](crate::client::fluent_builders::PutRule::schedule_expression) / [`set_schedule_expression(Option<String>)`](crate::client::fluent_builders::PutRule::set_schedule_expression): <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
    ///   - [`event_pattern(impl Into<String>)`](crate::client::fluent_builders::PutRule::event_pattern) / [`set_event_pattern(Option<String>)`](crate::client::fluent_builders::PutRule::set_event_pattern): <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    ///   - [`state(RuleState)`](crate::client::fluent_builders::PutRule::state) / [`set_state(Option<RuleState>)`](crate::client::fluent_builders::PutRule::set_state): <p>Indicates whether the rule is enabled or disabled.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutRule::set_description): <p>A description of the rule.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::PutRule::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::PutRule::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>  <p>If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutRule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutRule::set_tags): <p>The list of key-value pairs to associate with the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::PutRule::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::PutRule::set_event_bus_name): <p>The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.</p>
    /// - On success, responds with [`PutRuleOutput`](crate::output::PutRuleOutput) with field(s):
    ///   - [`rule_arn(Option<String>)`](crate::output::PutRuleOutput::rule_arn): <p>The Amazon Resource Name (ARN) of the rule.</p>
    /// - On failure, responds with [`SdkError<PutRuleError>`](crate::error::PutRuleError)
    pub fn put_rule(&self) -> fluent_builders::PutRule {
        fluent_builders::PutRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutTargets`](crate::client::fluent_builders::PutTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule(impl Into<String>)`](crate::client::fluent_builders::PutTargets::rule) / [`set_rule(Option<String>)`](crate::client::fluent_builders::PutTargets::set_rule): <p>The name of the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::PutTargets::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::PutTargets::set_event_bus_name): <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::PutTargets::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::PutTargets::set_targets): <p>The targets to update or add to the rule.</p>
    /// - On success, responds with [`PutTargetsOutput`](crate::output::PutTargetsOutput) with field(s):
    ///   - [`failed_entry_count(i32)`](crate::output::PutTargetsOutput::failed_entry_count): <p>The number of failed entries.</p>
    ///   - [`failed_entries(Option<Vec<PutTargetsResultEntry>>)`](crate::output::PutTargetsOutput::failed_entries): <p>The failed target entries.</p>
    /// - On failure, responds with [`SdkError<PutTargetsError>`](crate::error::PutTargetsError)
    pub fn put_targets(&self) -> fluent_builders::PutTargets {
        fluent_builders::PutTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemovePermission`](crate::client::fluent_builders::RemovePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::RemovePermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::RemovePermission::set_statement_id): <p>The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.</p>
    ///   - [`remove_all_permissions(bool)`](crate::client::fluent_builders::RemovePermission::remove_all_permissions) / [`set_remove_all_permissions(bool)`](crate::client::fluent_builders::RemovePermission::set_remove_all_permissions): <p>Specifies whether to remove all permissions.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::RemovePermission::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::RemovePermission::set_event_bus_name): <p>The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.</p>
    /// - On success, responds with [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)

    /// - On failure, responds with [`SdkError<RemovePermissionError>`](crate::error::RemovePermissionError)
    pub fn remove_permission(&self) -> fluent_builders::RemovePermission {
        fluent_builders::RemovePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTargets`](crate::client::fluent_builders::RemoveTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule(impl Into<String>)`](crate::client::fluent_builders::RemoveTargets::rule) / [`set_rule(Option<String>)`](crate::client::fluent_builders::RemoveTargets::set_rule): <p>The name of the rule.</p>
    ///   - [`event_bus_name(impl Into<String>)`](crate::client::fluent_builders::RemoveTargets::event_bus_name) / [`set_event_bus_name(Option<String>)`](crate::client::fluent_builders::RemoveTargets::set_event_bus_name): <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
    ///   - [`ids(Vec<String>)`](crate::client::fluent_builders::RemoveTargets::ids) / [`set_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTargets::set_ids): <p>The IDs of the targets to remove from the rule.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::RemoveTargets::force) / [`set_force(bool)`](crate::client::fluent_builders::RemoveTargets::set_force): <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
    /// - On success, responds with [`RemoveTargetsOutput`](crate::output::RemoveTargetsOutput) with field(s):
    ///   - [`failed_entry_count(i32)`](crate::output::RemoveTargetsOutput::failed_entry_count): <p>The number of failed entries.</p>
    ///   - [`failed_entries(Option<Vec<RemoveTargetsResultEntry>>)`](crate::output::RemoveTargetsOutput::failed_entries): <p>The failed target entries.</p>
    /// - On failure, responds with [`SdkError<RemoveTargetsError>`](crate::error::RemoveTargetsError)
    pub fn remove_targets(&self) -> fluent_builders::RemoveTargets {
        fluent_builders::RemoveTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartReplay`](crate::client::fluent_builders::StartReplay) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replay_name(impl Into<String>)`](crate::client::fluent_builders::StartReplay::replay_name) / [`set_replay_name(Option<String>)`](crate::client::fluent_builders::StartReplay::set_replay_name): <p>The name of the replay to start.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::StartReplay::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::StartReplay::set_description): <p>A description for the replay to start.</p>
    ///   - [`event_source_arn(impl Into<String>)`](crate::client::fluent_builders::StartReplay::event_source_arn) / [`set_event_source_arn(Option<String>)`](crate::client::fluent_builders::StartReplay::set_event_source_arn): <p>The ARN of the archive to replay events from.</p>
    ///   - [`event_start_time(DateTime)`](crate::client::fluent_builders::StartReplay::event_start_time) / [`set_event_start_time(Option<DateTime>)`](crate::client::fluent_builders::StartReplay::set_event_start_time): <p>A time stamp for the time to start replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
    ///   - [`event_end_time(DateTime)`](crate::client::fluent_builders::StartReplay::event_end_time) / [`set_event_end_time(Option<DateTime>)`](crate::client::fluent_builders::StartReplay::set_event_end_time): <p>A time stamp for the time to stop replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
    ///   - [`destination(ReplayDestination)`](crate::client::fluent_builders::StartReplay::destination) / [`set_destination(Option<ReplayDestination>)`](crate::client::fluent_builders::StartReplay::set_destination): <p>A <code>ReplayDestination</code> object that includes details about the destination for the replay.</p>
    /// - On success, responds with [`StartReplayOutput`](crate::output::StartReplayOutput) with field(s):
    ///   - [`replay_arn(Option<String>)`](crate::output::StartReplayOutput::replay_arn): <p>The ARN of the replay.</p>
    ///   - [`state(Option<ReplayState>)`](crate::output::StartReplayOutput::state): <p>The state of the replay.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::StartReplayOutput::state_reason): <p>The reason that the replay is in the state.</p>
    ///   - [`replay_start_time(Option<DateTime>)`](crate::output::StartReplayOutput::replay_start_time): <p>The time at which the replay started.</p>
    /// - On failure, responds with [`SdkError<StartReplayError>`](crate::error::StartReplayError)
    pub fn start_replay(&self) -> fluent_builders::StartReplay {
        fluent_builders::StartReplay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the EventBridge resource that you're adding tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of key-value pairs to associate with the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestEventPattern`](crate::client::fluent_builders::TestEventPattern) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_pattern(impl Into<String>)`](crate::client::fluent_builders::TestEventPattern::event_pattern) / [`set_event_pattern(Option<String>)`](crate::client::fluent_builders::TestEventPattern::set_event_pattern): <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    ///   - [`event(impl Into<String>)`](crate::client::fluent_builders::TestEventPattern::event) / [`set_event(Option<String>)`](crate::client::fluent_builders::TestEventPattern::set_event): <p>The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following fields are mandatory:</p>  <ul>   <li> <p> <code>id</code> </p> </li>   <li> <p> <code>account</code> </p> </li>   <li> <p> <code>source</code> </p> </li>   <li> <p> <code>time</code> </p> </li>   <li> <p> <code>region</code> </p> </li>   <li> <p> <code>resources</code> </p> </li>   <li> <p> <code>detail-type</code> </p> </li>  </ul>
    /// - On success, responds with [`TestEventPatternOutput`](crate::output::TestEventPatternOutput) with field(s):
    ///   - [`result(bool)`](crate::output::TestEventPatternOutput::result): <p>Indicates whether the event matches the event pattern.</p>
    /// - On failure, responds with [`SdkError<TestEventPatternError>`](crate::error::TestEventPatternError)
    pub fn test_event_pattern(&self) -> fluent_builders::TestEventPattern {
        fluent_builders::TestEventPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the EventBridge resource from which you are removing tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApiDestination`](crate::client::fluent_builders::UpdateApiDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateApiDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateApiDestination::set_name): <p>The name of the API destination to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApiDestination::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApiDestination::set_description): <p>The name of the API destination to update.</p>
    ///   - [`connection_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApiDestination::connection_arn) / [`set_connection_arn(Option<String>)`](crate::client::fluent_builders::UpdateApiDestination::set_connection_arn): <p>The ARN of the connection to use for the API destination.</p>
    ///   - [`invocation_endpoint(impl Into<String>)`](crate::client::fluent_builders::UpdateApiDestination::invocation_endpoint) / [`set_invocation_endpoint(Option<String>)`](crate::client::fluent_builders::UpdateApiDestination::set_invocation_endpoint): <p>The URL to the endpoint to use for the API destination.</p>
    ///   - [`http_method(ApiDestinationHttpMethod)`](crate::client::fluent_builders::UpdateApiDestination::http_method) / [`set_http_method(Option<ApiDestinationHttpMethod>)`](crate::client::fluent_builders::UpdateApiDestination::set_http_method): <p>The method to use for the API destination.</p>
    ///   - [`invocation_rate_limit_per_second(i32)`](crate::client::fluent_builders::UpdateApiDestination::invocation_rate_limit_per_second) / [`set_invocation_rate_limit_per_second(Option<i32>)`](crate::client::fluent_builders::UpdateApiDestination::set_invocation_rate_limit_per_second): <p>The maximum number of invocations per second to send to the API destination.</p>
    /// - On success, responds with [`UpdateApiDestinationOutput`](crate::output::UpdateApiDestinationOutput) with field(s):
    ///   - [`api_destination_arn(Option<String>)`](crate::output::UpdateApiDestinationOutput::api_destination_arn): <p>The ARN of the API destination that was updated.</p>
    ///   - [`api_destination_state(Option<ApiDestinationState>)`](crate::output::UpdateApiDestinationOutput::api_destination_state): <p>The state of the API destination that was updated.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::UpdateApiDestinationOutput::creation_time): <p>A time stamp for the time that the API destination was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::UpdateApiDestinationOutput::last_modified_time): <p>A time stamp for the time that the API destination was last modified.</p>
    /// - On failure, responds with [`SdkError<UpdateApiDestinationError>`](crate::error::UpdateApiDestinationError)
    pub fn update_api_destination(&self) -> fluent_builders::UpdateApiDestination {
        fluent_builders::UpdateApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateArchive`](crate::client::fluent_builders::UpdateArchive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`archive_name(impl Into<String>)`](crate::client::fluent_builders::UpdateArchive::archive_name) / [`set_archive_name(Option<String>)`](crate::client::fluent_builders::UpdateArchive::set_archive_name): <p>The name of the archive to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateArchive::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateArchive::set_description): <p>The description for the archive.</p>
    ///   - [`event_pattern(impl Into<String>)`](crate::client::fluent_builders::UpdateArchive::event_pattern) / [`set_event_pattern(Option<String>)`](crate::client::fluent_builders::UpdateArchive::set_event_pattern): <p>The event pattern to use to filter events sent to the archive.</p>
    ///   - [`retention_days(i32)`](crate::client::fluent_builders::UpdateArchive::retention_days) / [`set_retention_days(Option<i32>)`](crate::client::fluent_builders::UpdateArchive::set_retention_days): <p>The number of days to retain events in the archive.</p>
    /// - On success, responds with [`UpdateArchiveOutput`](crate::output::UpdateArchiveOutput) with field(s):
    ///   - [`archive_arn(Option<String>)`](crate::output::UpdateArchiveOutput::archive_arn): <p>The ARN of the archive.</p>
    ///   - [`state(Option<ArchiveState>)`](crate::output::UpdateArchiveOutput::state): <p>The state of the archive.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::UpdateArchiveOutput::state_reason): <p>The reason that the archive is in the current state.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::UpdateArchiveOutput::creation_time): <p>The time at which the archive was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateArchiveError>`](crate::error::UpdateArchiveError)
    pub fn update_archive(&self) -> fluent_builders::UpdateArchive {
        fluent_builders::UpdateArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConnection`](crate::client::fluent_builders::UpdateConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_name): <p>The name of the connection to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_description): <p>A description for the connection.</p>
    ///   - [`authorization_type(ConnectionAuthorizationType)`](crate::client::fluent_builders::UpdateConnection::authorization_type) / [`set_authorization_type(Option<ConnectionAuthorizationType>)`](crate::client::fluent_builders::UpdateConnection::set_authorization_type): <p>The type of authorization to use for the connection.</p>
    ///   - [`auth_parameters(UpdateConnectionAuthRequestParameters)`](crate::client::fluent_builders::UpdateConnection::auth_parameters) / [`set_auth_parameters(Option<UpdateConnectionAuthRequestParameters>)`](crate::client::fluent_builders::UpdateConnection::set_auth_parameters): <p>The authorization parameters to use for the connection.</p>
    /// - On success, responds with [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput) with field(s):
    ///   - [`connection_arn(Option<String>)`](crate::output::UpdateConnectionOutput::connection_arn): <p>The ARN of the connection that was updated.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::UpdateConnectionOutput::connection_state): <p>The state of the connection that was updated.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::UpdateConnectionOutput::creation_time): <p>A time stamp for the time that the connection was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::UpdateConnectionOutput::last_modified_time): <p>A time stamp for the time that the connection was last modified.</p>
    ///   - [`last_authorized_time(Option<DateTime>)`](crate::output::UpdateConnectionOutput::last_authorized_time): <p>A time stamp for the time that the connection was last authorized.</p>
    /// - On failure, responds with [`SdkError<UpdateConnectionError>`](crate::error::UpdateConnectionError)
    pub fn update_connection(&self) -> fluent_builders::UpdateConnection {
        fluent_builders::UpdateConnection::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateEventSource`.
    ///
    /// <p>Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivateEventSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::activate_event_source_input::Builder,
    }
    impl ActivateEventSource {
        /// Creates a new `ActivateEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateEventSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to activate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source to activate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelReplay`.
    ///
    /// <p>Cancels the specified replay.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelReplay {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_replay_input::Builder,
    }
    impl CancelReplay {
        /// Creates a new `CancelReplay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelReplayOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelReplayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replay to cancel.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replay_name(input.into());
            self
        }
        /// <p>The name of the replay to cancel.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_replay_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApiDestination`.
    ///
    /// <p>Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApiDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_api_destination_input::Builder,
    }
    impl CreateApiDestination {
        /// Creates a new `CreateApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the API destination to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the API destination to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the API destination to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the API destination to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the connection to use for the API destination. The destination endpoint must support the authorization type specified for the connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(input.into());
            self
        }
        /// <p>The ARN of the connection to use for the API destination. The destination endpoint must support the authorization type specified for the connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
        /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invocation_endpoint(input.into());
            self
        }
        /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invocation_endpoint(input);
            self
        }
        /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.inner = self.inner.http_method(input);
            self
        }
        /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.inner = self.inner.invocation_rate_limit_per_second(input);
            self
        }
        /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_invocation_rate_limit_per_second(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateArchive`.
    ///
    /// <p>Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateArchive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_archive_input::Builder,
    }
    impl CreateArchive {
        /// Creates a new `CreateArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateArchiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the archive to create.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name for the archive to create.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
        /// <p>The ARN of the event bus that sends events to the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the event bus that sends events to the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>A description for the archive.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the archive.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>An event pattern to use to filter events sent to the archive.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>An event pattern to use to filter events sent to the archive.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_days(input);
            self
        }
        /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl CreateConnection {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the connection to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the connection to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the connection to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the connection to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the authorization parameters to use to authorize with the endpoint. </p>
        pub fn auth_parameters(
            mut self,
            input: crate::model::CreateConnectionAuthRequestParameters,
        ) -> Self {
            self.inner = self.inner.auth_parameters(input);
            self
        }
        /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the authorization parameters to use to authorize with the endpoint. </p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::CreateConnectionAuthRequestParameters>,
        ) -> Self {
            self.inner = self.inner.set_auth_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventBus`.
    ///
    /// <p>Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventBus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_bus_input::Builder,
    }
    impl CreateEventBus {
        /// Creates a new `CreateEventBus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventBusOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventBusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new event bus. </p>
        /// <p>Event bus names cannot contain the / character. You can't use the name <code>default</code> for a custom event bus, as this name is already used for your account's default event bus.</p>
        /// <p>If this is a partner event bus, the name must exactly match the name of the partner event source that this event bus is matched to.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new event bus. </p>
        /// <p>Event bus names cannot contain the / character. You can't use the name <code>default</code> for a custom event bus, as this name is already used for your account's default event bus.</p>
        /// <p>If this is a partner event bus, the name must exactly match the name of the partner event source that this event bus is matched to.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If you are creating a partner event bus, this specifies the partner event source that the new event bus will be matched with.</p>
        pub fn event_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_name(input.into());
            self
        }
        /// <p>If you are creating a partner event bus, this specifies the partner event source that the new event bus will be matched with.</p>
        pub fn set_event_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associate with the event bus.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to associate with the event bus.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePartnerEventSource`.
    ///
    /// <p>Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.</p>
    /// <p>Each partner event source can be used by one Amazon Web Services account to create a matching partner event bus in that Amazon Web Services account. A SaaS partner must create one partner event source for each Amazon Web Services account that wants to receive those event types. </p>
    /// <p>A partner event source creates events based on resources within the SaaS partner's service or application.</p>
    /// <p>An Amazon Web Services account that creates a partner event bus that matches the partner event source can use that event bus to receive events from the partner, and then process them using Amazon Web Services Events rules and targets.</p>
    /// <p>Partner event source names follow this format:</p>
    /// <p> <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code> </p>
    /// <p> <i>partner_name</i> is determined during partner registration and identifies the partner to Amazon Web Services customers. <i>event_namespace</i> is determined by the partner and is a way for the partner to categorize their events. <i>event_name</i> is determined by the partner, and should uniquely identify an event-generating resource within the partner system. The combination of <i>event_namespace</i> and <i>event_name</i> should help Amazon Web Services customers decide whether to create an event bus to receive these events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePartnerEventSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_partner_event_source_input::Builder,
    }
    impl CreatePartnerEventSource {
        /// Creates a new `CreatePartnerEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePartnerEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePartnerEventSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source. This name must be unique and must be in the format <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>. The Amazon Web Services account that wants to use this partner event source must create a partner event bus with a name that matches the name of the partner event source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source. This name must be unique and must be in the format <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>. The Amazon Web Services account that wants to use this partner event source must create a partner event bus with a name that matches the name of the partner event source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this partner event source.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this partner event source.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateEventSource`.
    ///
    /// <p>You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted. </p>
    /// <p>When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state for more than two weeks, it is deleted.</p>
    /// <p>To activate a deactivated partner event source, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html">ActivateEventSource</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeactivateEventSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deactivate_event_source_input::Builder,
    }
    impl DeactivateEventSource {
        /// Creates a new `DeactivateEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateEventSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to deactivate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source to deactivate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeauthorizeConnection`.
    ///
    /// <p>Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeauthorizeConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deauthorize_connection_input::Builder,
    }
    impl DeauthorizeConnection {
        /// Creates a new `DeauthorizeConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeauthorizeConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeauthorizeConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to remove authorization from.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to remove authorization from.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiDestination`.
    ///
    /// <p>Deletes the specified API destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApiDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_api_destination_input::Builder,
    }
    impl DeleteApiDestination {
        /// Creates a new `DeleteApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the destination to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the destination to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteArchive`.
    ///
    /// <p>Deletes the specified archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteArchive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_archive_input::Builder,
    }
    impl DeleteArchive {
        /// Creates a new `DeleteArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteArchiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the archive to delete.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name of the archive to delete.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes a connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl DeleteConnection {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventBus`.
    ///
    /// <p>Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can't delete your account's default event bus.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventBus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_bus_input::Builder,
    }
    impl DeleteEventBus {
        /// Creates a new `DeleteEventBus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventBusOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventBusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event bus to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event bus to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePartnerEventSource`.
    ///
    /// <p>This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon Web Services customers.</p>
    /// <p>When you delete an event source, the status of the corresponding partner event bus in the Amazon Web Services customer account becomes DELETED.</p>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePartnerEventSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_partner_event_source_input::Builder,
    }
    impl DeletePartnerEventSource {
        /// Creates a new `DeletePartnerEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePartnerEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePartnerEventSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event source to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event source to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <p>Deletes the specified rule.</p>
    /// <p>Before you can delete the rule, you must remove all targets, using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html">RemoveTargets</a>.</p>
    /// <p>When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time for changes to take effect.</p>
    /// <p>If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a non-existent custom eventbus, <code>ResourceNotFoundException</code> is returned.</p>
    /// <p>Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These rules are created by those other Amazon Web Services services to support functionality in those services. You can delete these rules using the <code>Force</code> option, but you should do so only if you are sure the other service is not still using that rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl DeleteRule {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApiDestination`.
    ///
    /// <p>Retrieves details about an API destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApiDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_api_destination_input::Builder,
    }
    impl DescribeApiDestination {
        /// Creates a new `DescribeApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApiDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the API destination to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API destination to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeArchive`.
    ///
    /// <p>Retrieves details about an archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeArchive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_archive_input::Builder,
    }
    impl DescribeArchive {
        /// Creates a new `DescribeArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeArchiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the archive to retrieve.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name of the archive to retrieve.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnection`.
    ///
    /// <p>Retrieves details about a connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connection_input::Builder,
    }
    impl DescribeConnection {
        /// Creates a new `DescribeConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventBus`.
    ///
    /// <p>Displays details about an event bus in your account. This can include the external Amazon Web Services accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.</p>
    /// <p> To enable your account to receive events from other accounts on its default event bus, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.</p>
    /// <p>For more information about partner event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventBus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_bus_input::Builder,
    }
    impl DescribeEventBus {
        /// Creates a new `DescribeEventBus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventBusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventBusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event bus is displayed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event bus is displayed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSource`.
    ///
    /// <p>This operation lists details about a partner event source that is shared with your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_source_input::Builder,
    }
    impl DescribeEventSource {
        /// Creates a new `DescribeEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to display the details of.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source to display the details of.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePartnerEventSource`.
    ///
    /// <p>An SaaS partner can use this operation to list details about a partner event source that they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html">DescribeEventSource</a> to see details about a partner event source that is shared with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePartnerEventSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_partner_event_source_input::Builder,
    }
    impl DescribePartnerEventSource {
        /// Creates a new `DescribePartnerEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePartnerEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePartnerEventSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event source to display.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event source to display.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplay`.
    ///
    /// <p>Retrieves details about a replay. Use <code>DescribeReplay</code> to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use <code>StartReplay</code> and specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range associated with the last event replayed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplay {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replay_input::Builder,
    }
    impl DescribeReplay {
        /// Creates a new `DescribeReplay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplayOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replay to retrieve.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replay_name(input.into());
            self
        }
        /// <p>The name of the replay to retrieve.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_replay_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRule`.
    ///
    /// <p>Describes the specified rule.</p>
    /// <p>DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_rule_input::Builder,
    }
    impl DescribeRule {
        /// Creates a new `DescribeRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableRule`.
    ///
    /// <p>Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule expression.</p>
    /// <p>When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of time for changes to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_rule_input::Builder,
    }
    impl DisableRule {
        /// Creates a new `DisableRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableRule`.
    ///
    /// <p>Enables the specified rule. If the rule does not exist, the operation fails.</p>
    /// <p>When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a short period of time for changes to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_rule_input::Builder,
    }
    impl EnableRule {
        /// Creates a new `EnableRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApiDestinations`.
    ///
    /// <p>Retrieves a list of API destination in the account in the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApiDestinations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_api_destinations_input::Builder,
    }
    impl ListApiDestinations {
        /// Creates a new `ListApiDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApiDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApiDestinationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter results returned. Only API destinations with a name that starts with the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter results returned. Only API destinations with a name that starts with the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(input.into());
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of API destinations to include in the response.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of API destinations to include in the response.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArchives`.
    ///
    /// <p>Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListArchives {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_archives_input::Builder,
    }
    impl ListArchives {
        /// Creates a new `ListArchives`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArchivesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArchivesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The state of the archive.</p>
        pub fn state(mut self, input: crate::model::ArchiveState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the archive.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ArchiveState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnections`.
    ///
    /// <p>Retrieves a list of connections from the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_connections_input::Builder,
    }
    impl ListConnections {
        /// Creates a new `ListConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter results returned. Only connections with a name that starts with the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter results returned. Only connections with a name that starts with the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.inner = self.inner.connection_state(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.inner = self.inner.set_connection_state(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of connections to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of connections to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventBuses`.
    ///
    /// <p>Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventBuses {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_buses_input::Builder,
    }
    impl ListEventBuses {
        /// Creates a new `ListEventBuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventBusesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventBusesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifying this limits the results to only those event buses with names that start with the specified prefix.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those event buses with names that start with the specified prefix.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventSources`.
    ///
    /// <p>You can use this to see all the partner event sources that have been shared with your Amazon Web Services account. For more information about partner event sources, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventSources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_sources_input::Builder,
    }
    impl ListEventSources {
        /// Creates a new `ListEventSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventSourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifying this limits the results to only those partner event sources with names that start with the specified prefix.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those partner event sources with names that start with the specified prefix.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPartnerEventSourceAccounts`.
    ///
    /// <p>An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner event source name is associated with. This operation is not used by Amazon Web Services customers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPartnerEventSourceAccounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_partner_event_source_accounts_input::Builder,
    }
    impl ListPartnerEventSourceAccounts {
        /// Creates a new `ListPartnerEventSourceAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPartnerEventSourceAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPartnerEventSourceAccountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to display account information about.</p>
        pub fn event_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_name(input.into());
            self
        }
        /// <p>The name of the partner event source to display account information about.</p>
        pub fn set_event_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_name(input);
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPartnerEventSources`.
    ///
    /// <p>An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by Amazon Web Services customers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPartnerEventSources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_partner_event_sources_input::Builder,
    }
    impl ListPartnerEventSources {
        /// Creates a new `ListPartnerEventSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPartnerEventSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPartnerEventSourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify this, the results are limited to only those partner event sources that start with the string you specify.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>If you specify this, the results are limited to only those partner event sources that start with the string you specify.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>pecifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>pecifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReplays`.
    ///
    /// <p>Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReplays {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_replays_input::Builder,
    }
    impl ListReplays {
        /// Creates a new `ListReplays`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReplaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReplaysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The state of the replay.</p>
        pub fn state(mut self, input: crate::model::ReplayState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the replay.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ReplayState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The ARN of the archive from which the events are replayed.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the archive from which the events are replayed.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of replays to retrieve.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of replays to retrieve.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleNamesByTarget`.
    ///
    /// <p>Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRuleNamesByTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rule_names_by_target_input::Builder,
    }
    impl ListRuleNamesByTarget {
        /// Creates a new `ListRuleNamesByTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleNamesByTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleNamesByTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRules`.
    ///
    /// <p>Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.</p>
    /// <p>ListRules does not list the targets of a rule. To see the targets associated with a rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rules_input::Builder,
    }
    impl ListRules {
        /// Creates a new `ListRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The prefix matching the rule name.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>The prefix matching the rule name.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargetsByRule`.
    ///
    /// <p>Lists the targets assigned to the specified rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTargetsByRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_targets_by_rule_input::Builder,
    }
    impl ListTargetsByRule {
        /// Creates a new `ListTargetsByRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsByRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsByRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEvents`.
    ///
    /// <p>Sends custom events to Amazon EventBridge so that they can be matched to rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_events_input::Builder,
    }
    impl PutEvents {
        /// Creates a new `PutEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The entry that defines an event in your system. You can specify several parameters for the entry such as the source and type of the event, resources associated with the event, and so on.</p>
        pub fn entries(mut self, input: crate::model::PutEventsRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The entry that defines an event in your system. You can specify several parameters for the entry such as the source and type of the event, resources associated with the event, and so on.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutEventsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPartnerEvents`.
    ///
    /// <p>This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do not use this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPartnerEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_partner_events_input::Builder,
    }
    impl PutPartnerEvents {
        /// Creates a new `PutPartnerEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPartnerEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPartnerEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of events to write to the event bus.</p>
        pub fn entries(mut self, input: crate::model::PutPartnerEventsRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The list of events to write to the event bus.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPermission`.
    ///
    /// <p>Running <code>PutPermission</code> permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified <i>event bus</i>. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account. </p>
    /// <p>For another account to send events to your account, that external account must have an EventBridge rule with your account's event bus as a target.</p>
    /// <p>To enable multiple Amazon Web Services accounts to put events to your event bus, run <code>PutPermission</code> once for each of these accounts. Or, if all the accounts are members of the same Amazon Web Services organization, you can run <code>PutPermission</code> once specifying <code>Principal</code> as "*" and specifying the Amazon Web Services organization ID in <code>Condition</code>, to grant permissions to all accounts in that organization.</p>
    /// <p>If you grant permissions using an organization, then accounts in that organization must specify a <code>RoleArn</code> with proper permissions when they use <code>PutTarget</code> to add your account's event bus as a target. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    /// <p>The permission policy on the event bus cannot exceed 10 KB in size.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_permission_input::Builder,
    }
    impl PutPermission {
        /// Creates a new `PutPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The action that you are enabling the other account to perform.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The action that you are enabling the other account to perform.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.</p>
        /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.</p>
        /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p> <note>
        /// <p>Each <code>StatementId</code> must be unique.</p>
        /// </note>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p> <note>
        /// <p>Each <code>StatementId</code> must be unique.</p>
        /// </note>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
        /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value for <code>Principal</code>, you grant permission to all the accounts in the named organization.</p>
        /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and <code>Value</code> fields.</p>
        pub fn condition(mut self, input: crate::model::Condition) -> Self {
            self.inner = self.inner.condition(input);
            self
        }
        /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
        /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value for <code>Principal</code>, you grant permission to all the accounts in the named organization.</p>
        /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and <code>Value</code> fields.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::Condition>,
        ) -> Self {
            self.inner = self.inner.set_condition(input);
            self
        }
        /// <p>A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRule`.
    ///
    /// <p>Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule</a>.</p>
    /// <p>A single rule watches for events from a single event bus. Events generated by Amazon Web Services services go to your account's default event bus. Events generated by SaaS partner services or applications go to the matching partner event bus. If you have custom applications or services, you can specify whether their events go to your default event bus or a custom event bus that you have created. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>
    /// <p>If you are updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code> command. If you omit arguments in <code>PutRule</code>, the old values for those arguments are not kept. Instead, they are replaced with null values.</p>
    /// <p>When you create or update a rule, incoming events might not immediately start matching to new or updated rules. Allow a short period of time for changes to take effect.</p>
    /// <p>A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as on a schedule.</p>
    /// <p>When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only rules with certain tag values. To use the <code>PutRule</code> operation and assign tags, you must have both the <code>events:PutRule</code> and <code>events:TagResource</code> permissions.</p>
    /// <p>If you are updating an existing rule, any tags you specify in the <code>PutRule</code> operation are ignored. To update the tags of an existing rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html">UntagResource</a>.</p>
    /// <p>Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.</p>
    /// <p>In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again, creating an infinite loop.</p>
    /// <p>To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead of after any change. </p>
    /// <p>An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which alerts you when charges exceed your specified limit. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with Budgets</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_rule_input::Builder,
    }
    impl PutRule {
        /// Creates a new `PutRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule that you are creating or updating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule that you are creating or updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_expression(input.into());
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_expression(input);
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn state(mut self, input: crate::model::RuleState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RuleState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>A description of the rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the rule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of key-value pairs to associate with the rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutTargets`.
    ///
    /// <p>Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.</p>
    /// <p>Targets are the resources that are invoked when a rule is triggered.</p> <note>
    /// <p>Each rule can have up to five (5) targets associated with it at one time.</p>
    /// </note>
    /// <p>You can configure the following as targets for Events:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destination</a> </p> </li>
    /// <li> <p>Amazon API Gateway REST API endpoints</p> </li>
    /// <li> <p>API Gateway</p> </li>
    /// <li> <p>Batch job queue</p> </li>
    /// <li> <p>CloudWatch Logs group</p> </li>
    /// <li> <p>CodeBuild project</p> </li>
    /// <li> <p>CodePipeline</p> </li>
    /// <li> <p>Amazon EC2 <code>CreateSnapshot</code> API call</p> </li>
    /// <li> <p>EC2 Image Builder</p> </li>
    /// <li> <p>Amazon EC2 <code>RebootInstances</code> API call</p> </li>
    /// <li> <p>Amazon EC2 <code>StopInstances</code> API call</p> </li>
    /// <li> <p>Amazon EC2 <code>TerminateInstances</code> API call</p> </li>
    /// <li> <p>Amazon ECS tasks</p> </li>
    /// <li> <p>Event bus in a different Amazon Web Services account or Region.</p> <p>You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.</p> </li>
    /// <li> <p>Firehose delivery stream (Kinesis Data Firehose)</p> </li>
    /// <li> <p>Inspector assessment template (Amazon Inspector)</p> </li>
    /// <li> <p>Kinesis stream (Kinesis Data Stream)</p> </li>
    /// <li> <p>Lambda function</p> </li>
    /// <li> <p>Redshift clusters (Data API statement execution)</p> </li>
    /// <li> <p>Amazon SNS topic</p> </li>
    /// <li> <p>Amazon SQS queues (includes FIFO queues)</p> </li>
    /// <li> <p>SSM Automation</p> </li>
    /// <li> <p>SSM OpsItem</p> </li>
    /// <li> <p>SSM Run Command</p> </li>
    /// <li> <p>Step Functions state machines</p> </li>
    /// </ul>
    /// <p>Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The built-in targets are <code>EC2 CreateSnapshot API call</code>, <code>EC2 RebootInstances API call</code>, <code>EC2 StopInstances API call</code>, and <code>EC2 TerminateInstances API call</code>. </p>
    /// <p>For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.</p>
    /// <p>To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code>. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    /// <p>If another Amazon Web Services account is in the same region and has granted you permission (using <code>PutPermission</code>), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when you run <code>PutTargets</code>. If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="http://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a>.</p> <note>
    /// <p> <code>Input</code>, <code>InputPath</code>, and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different Amazon Web Services account.</p>
    /// </note>
    /// <p>If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    /// <p>For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.</p>
    /// <p> <b>Input</b>, <b>InputPath</b>, and <b>InputTransformer</b> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:</p>
    /// <ul>
    /// <li> <p>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</p> </li>
    /// <li> <p>If <b>Input</b> is specified in the form of valid JSON, then the matched event is overridden with this constant.</p> </li>
    /// <li> <p>If <b>InputPath</b> is specified in the form of JSONPath (for example, <code>$.detail</code>), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</p> </li>
    /// <li> <p>If <b>InputTransformer</b> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</p> </li>
    /// </ul>
    /// <p>When you specify <code>InputPath</code> or <code>InputTransformer</code>, you must use JSON dot notation, not bracket notation.</p>
    /// <p>When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.</p>
    /// <p>This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_targets_input::Builder,
    }
    impl PutTargets {
        /// Creates a new `PutTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets to update or add to the rule.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets to update or add to the rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemovePermission`.
    ///
    /// <p>Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the <code>StatementId</code> value that you associated with the account when you granted it permission with <code>PutPermission</code>. You can find the <code>StatementId</code> by using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html">DescribeEventBus</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemovePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_permission_input::Builder,
    }
    impl RemovePermission {
        /// Creates a new `RemovePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemovePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemovePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Specifies whether to remove all permissions.</p>
        pub fn remove_all_permissions(mut self, input: bool) -> Self {
            self.inner = self.inner.remove_all_permissions(input);
            self
        }
        /// <p>Specifies whether to remove all permissions.</p>
        pub fn set_remove_all_permissions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remove_all_permissions(input);
            self
        }
        /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTargets`.
    ///
    /// <p>Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be invoked.</p> <note>
    /// <p>A successful execution of <code>RemoveTargets</code> doesn't guarantee all targets are removed from the rule, it means that the target(s) listed in the request are removed.</p>
    /// </note>
    /// <p>When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow a short period of time for changes to take effect.</p>
    /// <p>This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_targets_input::Builder,
    }
    impl RemoveTargets {
        /// Creates a new `RemoveTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// Appends an item to `Ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the targets to remove from the rule.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>The IDs of the targets to remove from the rule.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplay`.
    ///
    /// <p>Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range associated with the last event replayed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartReplay {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_replay_input::Builder,
    }
    impl StartReplay {
        /// Creates a new `StartReplay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplayOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replay to start.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replay_name(input.into());
            self
        }
        /// <p>The name of the replay to start.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_replay_name(input);
            self
        }
        /// <p>A description for the replay to start.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the replay to start.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the archive to replay events from.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the archive to replay events from.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>A time stamp for the time to start replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn event_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.event_start_time(input);
            self
        }
        /// <p>A time stamp for the time to start replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn set_event_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_event_start_time(input);
            self
        }
        /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn event_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.event_end_time(input);
            self
        }
        /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn set_event_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_event_end_time(input);
            self
        }
        /// <p>A <code>ReplayDestination</code> object that includes details about the destination for the replay.</p>
        pub fn destination(mut self, input: crate::model::ReplayDestination) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>A <code>ReplayDestination</code> object that includes details about the destination for the replay.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::ReplayDestination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestEventPattern`.
    ///
    /// <p>Tests whether the specified event pattern matches the provided event.</p>
    /// <p>Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestEventPattern {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_event_pattern_input::Builder,
    }
    impl TestEventPattern {
        /// Creates a new `TestEventPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestEventPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::TestEventPatternError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following fields are mandatory:</p>
        /// <ul>
        /// <li> <p> <code>id</code> </p> </li>
        /// <li> <p> <code>account</code> </p> </li>
        /// <li> <p> <code>source</code> </p> </li>
        /// <li> <p> <code>time</code> </p> </li>
        /// <li> <p> <code>region</code> </p> </li>
        /// <li> <p> <code>resources</code> </p> </li>
        /// <li> <p> <code>detail-type</code> </p> </li>
        /// </ul>
        pub fn event(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event(input.into());
            self
        }
        /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following fields are mandatory:</p>
        /// <ul>
        /// <li> <p> <code>id</code> </p> </li>
        /// <li> <p> <code>account</code> </p> </li>
        /// <li> <p> <code>source</code> </p> </li>
        /// <li> <p> <code>time</code> </p> </li>
        /// <li> <p> <code>region</code> </p> </li>
        /// <li> <p> <code>resources</code> </p> </li>
        /// <li> <p> <code>detail-type</code> </p> </li>
        /// </ul>
        pub fn set_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events), rules and event buses can be tagged.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiDestination`.
    ///
    /// <p>Updates an API destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApiDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_api_destination_input::Builder,
    }
    impl UpdateApiDestination {
        /// Creates a new `UpdateApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the API destination to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the connection to use for the API destination.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(input.into());
            self
        }
        /// <p>The ARN of the connection to use for the API destination.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
        /// <p>The URL to the endpoint to use for the API destination.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invocation_endpoint(input.into());
            self
        }
        /// <p>The URL to the endpoint to use for the API destination.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invocation_endpoint(input);
            self
        }
        /// <p>The method to use for the API destination.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.inner = self.inner.http_method(input);
            self
        }
        /// <p>The method to use for the API destination.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>The maximum number of invocations per second to send to the API destination.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.inner = self.inner.invocation_rate_limit_per_second(input);
            self
        }
        /// <p>The maximum number of invocations per second to send to the API destination.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_invocation_rate_limit_per_second(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateArchive`.
    ///
    /// <p>Updates the specified archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateArchive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_archive_input::Builder,
    }
    impl UpdateArchive {
        /// Creates a new `UpdateArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateArchiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the archive to update.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name of the archive to update.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
        /// <p>The description for the archive.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the archive.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The event pattern to use to filter events sent to the archive.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>The event pattern to use to filter events sent to the archive.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>The number of days to retain events in the archive.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_days(input);
            self
        }
        /// <p>The number of days to retain events in the archive.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnection`.
    ///
    /// <p>Updates settings for a connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_connection_input::Builder,
    }
    impl UpdateConnection {
        /// Creates a new `UpdateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the connection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the connection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>The authorization parameters to use for the connection.</p>
        pub fn auth_parameters(
            mut self,
            input: crate::model::UpdateConnectionAuthRequestParameters,
        ) -> Self {
            self.inner = self.inner.auth_parameters(input);
            self
        }
        /// <p>The authorization parameters to use for the connection.</p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::UpdateConnectionAuthRequestParameters>,
        ) -> Self {
            self.inner = self.inner.set_auth_parameters(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
