// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ActivateEventSourceInput`](crate::input::ActivateEventSourceInput)
pub mod activate_event_source_input {
    /// A builder for [`ActivateEventSourceInput`](crate::input::ActivateEventSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the partner event source to activate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the partner event source to activate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateEventSourceInput`](crate::input::ActivateEventSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateEventSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateEventSourceInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type ActivateEventSourceInputOperationOutputAlias = crate::operation::ActivateEventSource;
#[doc(hidden)]
pub type ActivateEventSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ActivateEventSourceInput {
    /// Consumes the builder and constructs an Operation<[`ActivateEventSource`](crate::operation::ActivateEventSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateEventSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ActivateEventSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ActivateEventSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ActivateEventSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ActivateEventSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_activate_event_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateEventSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateEventSource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ActivateEventSourceInput`](crate::input::ActivateEventSourceInput)
    pub fn builder() -> crate::input::activate_event_source_input::Builder {
        crate::input::activate_event_source_input::Builder::default()
    }
}

/// See [`CancelReplayInput`](crate::input::CancelReplayInput)
pub mod cancel_replay_input {
    /// A builder for [`CancelReplayInput`](crate::input::CancelReplayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replay_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the replay to cancel.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_name = Some(input.into());
            self
        }
        /// <p>The name of the replay to cancel.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelReplayInput`](crate::input::CancelReplayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelReplayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelReplayInput {
                replay_name: self.replay_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelReplayInputOperationOutputAlias = crate::operation::CancelReplay;
#[doc(hidden)]
pub type CancelReplayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelReplayInput {
    /// Consumes the builder and constructs an Operation<[`CancelReplay`](crate::operation::CancelReplay)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelReplay,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelReplayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelReplayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelReplayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.CancelReplay",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_cancel_replay(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelReplay::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelReplay",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelReplayInput`](crate::input::CancelReplayInput)
    pub fn builder() -> crate::input::cancel_replay_input::Builder {
        crate::input::cancel_replay_input::Builder::default()
    }
}

/// See [`CreateApiDestinationInput`](crate::input::CreateApiDestinationInput)
pub mod create_api_destination_input {
    /// A builder for [`CreateApiDestinationInput`](crate::input::CreateApiDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) invocation_endpoint: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        pub(crate) invocation_rate_limit_per_second: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name for the API destination to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the API destination to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description for the API destination to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the API destination to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the connection to use for the API destination. The destination endpoint must
        /// support the authorization type specified for the connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection to use for the API destination. The destination endpoint must
        /// support the authorization type specified for the connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_endpoint = Some(input.into());
            self
        }
        /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_endpoint = input;
            self
        }
        /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.http_method = Some(input);
            self
        }
        /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.invocation_rate_limit_per_second = Some(input);
            self
        }
        /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.invocation_rate_limit_per_second = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiDestinationInput`](crate::input::CreateApiDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApiDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApiDestinationInput {
                name: self.name,
                description: self.description,
                connection_arn: self.connection_arn,
                invocation_endpoint: self.invocation_endpoint,
                http_method: self.http_method,
                invocation_rate_limit_per_second: self.invocation_rate_limit_per_second,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApiDestinationInputOperationOutputAlias = crate::operation::CreateApiDestination;
#[doc(hidden)]
pub type CreateApiDestinationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateApiDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApiDestination`](crate::operation::CreateApiDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApiDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApiDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApiDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApiDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.CreateApiDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_api_destination(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApiDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApiDestination",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApiDestinationInput`](crate::input::CreateApiDestinationInput)
    pub fn builder() -> crate::input::create_api_destination_input::Builder {
        crate::input::create_api_destination_input::Builder::default()
    }
}

/// See [`CreateArchiveInput`](crate::input::CreateArchiveInput)
pub mod create_archive_input {
    /// A builder for [`CreateArchiveInput`](crate::input::CreateArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_name: std::option::Option<std::string::String>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) retention_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name for the archive to create.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_name = Some(input.into());
            self
        }
        /// <p>The name for the archive to create.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_name = input;
            self
        }
        /// <p>The ARN of the event bus that sends events to the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus that sends events to the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>A description for the archive.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the archive.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An event pattern to use to filter events sent to the archive.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>An event pattern to use to filter events sent to the archive.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are
        /// retained indefinitely</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are
        /// retained indefinitely</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateArchiveInput`](crate::input::CreateArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateArchiveInput {
                archive_name: self.archive_name,
                event_source_arn: self.event_source_arn,
                description: self.description,
                event_pattern: self.event_pattern,
                retention_days: self.retention_days,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateArchiveInputOperationOutputAlias = crate::operation::CreateArchive;
#[doc(hidden)]
pub type CreateArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateArchiveInput {
    /// Consumes the builder and constructs an Operation<[`CreateArchive`](crate::operation::CreateArchive)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.CreateArchive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_archive(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateArchive",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateArchiveInput`](crate::input::CreateArchiveInput)
    pub fn builder() -> crate::input::create_archive_input::Builder {
        crate::input::create_archive_input::Builder::default()
    }
}

/// See [`CreateConnectionInput`](crate::input::CreateConnectionInput)
pub mod create_connection_input {
    /// A builder for [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) authorization_type:
            std::option::Option<crate::model::ConnectionAuthorizationType>,
        pub(crate) auth_parameters:
            std::option::Option<crate::model::CreateConnectionAuthRequestParameters>,
    }
    impl Builder {
        /// <p>The name for the connection to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the connection to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description for the connection to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the connection to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the
        /// authorization parameters to use to authorize with the endpoint. </p>
        pub fn auth_parameters(
            mut self,
            input: crate::model::CreateConnectionAuthRequestParameters,
        ) -> Self {
            self.auth_parameters = Some(input);
            self
        }
        /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the
        /// authorization parameters to use to authorize with the endpoint. </p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::CreateConnectionAuthRequestParameters>,
        ) -> Self {
            self.auth_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionInput`](crate::input::CreateConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectionInput {
                name: self.name,
                description: self.description,
                authorization_type: self.authorization_type,
                auth_parameters: self.auth_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectionInputOperationOutputAlias = crate::operation::CreateConnection;
#[doc(hidden)]
pub type CreateConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConnectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnection`](crate::operation::CreateConnection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.CreateConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connection(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnection",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
}

/// See [`CreateEventBusInput`](crate::input::CreateEventBusInput)
pub mod create_event_bus_input {
    /// A builder for [`CreateEventBusInput`](crate::input::CreateEventBusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_source_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the new event bus. </p>
        /// <p>Event bus names cannot contain the / character. You can't use the name
        /// <code>default</code> for a custom event bus, as this name is already used for your account's
        /// default event bus.</p>
        /// <p>If this is a partner event bus, the name must exactly match the name of the partner event
        /// source that this event bus is matched to.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new event bus. </p>
        /// <p>Event bus names cannot contain the / character. You can't use the name
        /// <code>default</code> for a custom event bus, as this name is already used for your account's
        /// default event bus.</p>
        /// <p>If this is a partner event bus, the name must exactly match the name of the partner event
        /// source that this event bus is matched to.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If you are creating a partner event bus, this specifies the partner event source that the
        /// new event bus will be matched with.</p>
        pub fn event_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_name = Some(input.into());
            self
        }
        /// <p>If you are creating a partner event bus, this specifies the partner event source that the
        /// new event bus will be matched with.</p>
        pub fn set_event_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associate with the event bus.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to associate with the event bus.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventBusInput`](crate::input::CreateEventBusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventBusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventBusInput {
                name: self.name,
                event_source_name: self.event_source_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventBusInputOperationOutputAlias = crate::operation::CreateEventBus;
#[doc(hidden)]
pub type CreateEventBusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEventBusInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventBus`](crate::operation::CreateEventBus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventBus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEventBusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEventBusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEventBusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.CreateEventBus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_event_bus(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventBus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventBus",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEventBusInput`](crate::input::CreateEventBusInput)
    pub fn builder() -> crate::input::create_event_bus_input::Builder {
        crate::input::create_event_bus_input::Builder::default()
    }
}

/// See [`CreatePartnerEventSourceInput`](crate::input::CreatePartnerEventSourceInput)
pub mod create_partner_event_source_input {
    /// A builder for [`CreatePartnerEventSourceInput`](crate::input::CreatePartnerEventSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the partner event source. This name must be unique and must be in the format
        /// <code>
        /// <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i>
        /// </code>.
        /// The Amazon Web Services account that wants to use this partner event source must create a partner event bus
        /// with a name that matches the name of the partner event source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the partner event source. This name must be unique and must be in the format
        /// <code>
        /// <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i>
        /// </code>.
        /// The Amazon Web Services account that wants to use this partner event source must create a partner event bus
        /// with a name that matches the name of the partner event source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this
        /// partner event source.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this
        /// partner event source.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePartnerEventSourceInput`](crate::input::CreatePartnerEventSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePartnerEventSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePartnerEventSourceInput {
                name: self.name,
                account: self.account,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePartnerEventSourceInputOperationOutputAlias =
    crate::operation::CreatePartnerEventSource;
#[doc(hidden)]
pub type CreatePartnerEventSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePartnerEventSourceInput {
    /// Consumes the builder and constructs an Operation<[`CreatePartnerEventSource`](crate::operation::CreatePartnerEventSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePartnerEventSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePartnerEventSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePartnerEventSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePartnerEventSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.CreatePartnerEventSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_partner_event_source(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePartnerEventSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePartnerEventSource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePartnerEventSourceInput`](crate::input::CreatePartnerEventSourceInput)
    pub fn builder() -> crate::input::create_partner_event_source_input::Builder {
        crate::input::create_partner_event_source_input::Builder::default()
    }
}

/// See [`DeactivateEventSourceInput`](crate::input::DeactivateEventSourceInput)
pub mod deactivate_event_source_input {
    /// A builder for [`DeactivateEventSourceInput`](crate::input::DeactivateEventSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the partner event source to deactivate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the partner event source to deactivate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateEventSourceInput`](crate::input::DeactivateEventSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateEventSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateEventSourceInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeactivateEventSourceInputOperationOutputAlias = crate::operation::DeactivateEventSource;
#[doc(hidden)]
pub type DeactivateEventSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeactivateEventSourceInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateEventSource`](crate::operation::DeactivateEventSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateEventSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeactivateEventSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeactivateEventSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeactivateEventSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeactivateEventSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deactivate_event_source(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateEventSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateEventSource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeactivateEventSourceInput`](crate::input::DeactivateEventSourceInput)
    pub fn builder() -> crate::input::deactivate_event_source_input::Builder {
        crate::input::deactivate_event_source_input::Builder::default()
    }
}

/// See [`DeauthorizeConnectionInput`](crate::input::DeauthorizeConnectionInput)
pub mod deauthorize_connection_input {
    /// A builder for [`DeauthorizeConnectionInput`](crate::input::DeauthorizeConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the connection to remove authorization from.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection to remove authorization from.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeauthorizeConnectionInput`](crate::input::DeauthorizeConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeauthorizeConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeauthorizeConnectionInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeauthorizeConnectionInputOperationOutputAlias = crate::operation::DeauthorizeConnection;
#[doc(hidden)]
pub type DeauthorizeConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeauthorizeConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeauthorizeConnection`](crate::operation::DeauthorizeConnection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeauthorizeConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeauthorizeConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeauthorizeConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeauthorizeConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeauthorizeConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deauthorize_connection(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeauthorizeConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeauthorizeConnection",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeauthorizeConnectionInput`](crate::input::DeauthorizeConnectionInput)
    pub fn builder() -> crate::input::deauthorize_connection_input::Builder {
        crate::input::deauthorize_connection_input::Builder::default()
    }
}

/// See [`DeleteApiDestinationInput`](crate::input::DeleteApiDestinationInput)
pub mod delete_api_destination_input {
    /// A builder for [`DeleteApiDestinationInput`](crate::input::DeleteApiDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the destination to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the destination to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApiDestinationInput`](crate::input::DeleteApiDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApiDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApiDestinationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteApiDestinationInputOperationOutputAlias = crate::operation::DeleteApiDestination;
#[doc(hidden)]
pub type DeleteApiDestinationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteApiDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApiDestination`](crate::operation::DeleteApiDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApiDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApiDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApiDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApiDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeleteApiDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_api_destination(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApiDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApiDestination",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApiDestinationInput`](crate::input::DeleteApiDestinationInput)
    pub fn builder() -> crate::input::delete_api_destination_input::Builder {
        crate::input::delete_api_destination_input::Builder::default()
    }
}

/// See [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
pub mod delete_archive_input {
    /// A builder for [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the archive to delete.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_name = Some(input.into());
            self
        }
        /// <p>The name of the archive to delete.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteArchiveInput {
                archive_name: self.archive_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteArchiveInputOperationOutputAlias = crate::operation::DeleteArchive;
#[doc(hidden)]
pub type DeleteArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteArchiveInput {
    /// Consumes the builder and constructs an Operation<[`DeleteArchive`](crate::operation::DeleteArchive)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeleteArchive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_archive(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteArchive",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
    pub fn builder() -> crate::input::delete_archive_input::Builder {
        crate::input::delete_archive_input::Builder::default()
    }
}

/// See [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
pub mod delete_connection_input {
    /// A builder for [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the connection to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectionInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectionInputOperationOutputAlias = crate::operation::DeleteConnection;
#[doc(hidden)]
pub type DeleteConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnection`](crate::operation::DeleteConnection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeleteConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_connection(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnection",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
}

/// See [`DeleteEventBusInput`](crate::input::DeleteEventBusInput)
pub mod delete_event_bus_input {
    /// A builder for [`DeleteEventBusInput`](crate::input::DeleteEventBusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event bus to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event bus to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventBusInput`](crate::input::DeleteEventBusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventBusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventBusInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventBusInputOperationOutputAlias = crate::operation::DeleteEventBus;
#[doc(hidden)]
pub type DeleteEventBusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventBusInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventBus`](crate::operation::DeleteEventBus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventBus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventBusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventBusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventBusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeleteEventBus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_event_bus(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventBus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventBus",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventBusInput`](crate::input::DeleteEventBusInput)
    pub fn builder() -> crate::input::delete_event_bus_input::Builder {
        crate::input::delete_event_bus_input::Builder::default()
    }
}

/// See [`DeletePartnerEventSourceInput`](crate::input::DeletePartnerEventSourceInput)
pub mod delete_partner_event_source_input {
    /// A builder for [`DeletePartnerEventSourceInput`](crate::input::DeletePartnerEventSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event source to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event source to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePartnerEventSourceInput`](crate::input::DeletePartnerEventSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePartnerEventSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePartnerEventSourceInput {
                name: self.name,
                account: self.account,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePartnerEventSourceInputOperationOutputAlias =
    crate::operation::DeletePartnerEventSource;
#[doc(hidden)]
pub type DeletePartnerEventSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePartnerEventSourceInput {
    /// Consumes the builder and constructs an Operation<[`DeletePartnerEventSource`](crate::operation::DeletePartnerEventSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePartnerEventSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePartnerEventSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePartnerEventSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePartnerEventSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeletePartnerEventSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_partner_event_source(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePartnerEventSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePartnerEventSource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePartnerEventSourceInput`](crate::input::DeletePartnerEventSourceInput)
    pub fn builder() -> crate::input::delete_partner_event_source_input::Builder {
        crate::input::delete_partner_event_source_input::Builder::default()
    }
}

/// See [`DeleteRuleInput`](crate::input::DeleteRuleInput)
pub mod delete_rule_input {
    /// A builder for [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
        /// <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for
        /// rules that are not managed rules. You can check whether a rule is a managed rule by using
        /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
        /// field of the response.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
        /// <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for
        /// rules that are not managed rules. You can check whether a rule is a managed rule by using
        /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
        /// field of the response.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRuleInput`](crate::input::DeleteRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRuleInput {
                name: self.name,
                event_bus_name: self.event_bus_name,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRuleInputOperationOutputAlias = crate::operation::DeleteRule;
#[doc(hidden)]
pub type DeleteRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRule`](crate::operation::DeleteRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DeleteRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRule",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    pub fn builder() -> crate::input::delete_rule_input::Builder {
        crate::input::delete_rule_input::Builder::default()
    }
}

/// See [`DescribeApiDestinationInput`](crate::input::DescribeApiDestinationInput)
pub mod describe_api_destination_input {
    /// A builder for [`DescribeApiDestinationInput`](crate::input::DescribeApiDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the API destination to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API destination to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApiDestinationInput`](crate::input::DescribeApiDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApiDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApiDestinationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeApiDestinationInputOperationOutputAlias = crate::operation::DescribeApiDestination;
#[doc(hidden)]
pub type DescribeApiDestinationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeApiDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApiDestination`](crate::operation::DescribeApiDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApiDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeApiDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeApiDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeApiDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribeApiDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_api_destination(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApiDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApiDestination",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeApiDestinationInput`](crate::input::DescribeApiDestinationInput)
    pub fn builder() -> crate::input::describe_api_destination_input::Builder {
        crate::input::describe_api_destination_input::Builder::default()
    }
}

/// See [`DescribeArchiveInput`](crate::input::DescribeArchiveInput)
pub mod describe_archive_input {
    /// A builder for [`DescribeArchiveInput`](crate::input::DescribeArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the archive to retrieve.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_name = Some(input.into());
            self
        }
        /// <p>The name of the archive to retrieve.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeArchiveInput`](crate::input::DescribeArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeArchiveInput {
                archive_name: self.archive_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeArchiveInputOperationOutputAlias = crate::operation::DescribeArchive;
#[doc(hidden)]
pub type DescribeArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeArchiveInput {
    /// Consumes the builder and constructs an Operation<[`DescribeArchive`](crate::operation::DescribeArchive)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribeArchive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_archive(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeArchive",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeArchiveInput`](crate::input::DescribeArchiveInput)
    pub fn builder() -> crate::input::describe_archive_input::Builder {
        crate::input::describe_archive_input::Builder::default()
    }
}

/// See [`DescribeConnectionInput`](crate::input::DescribeConnectionInput)
pub mod describe_connection_input {
    /// A builder for [`DescribeConnectionInput`](crate::input::DescribeConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the connection to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionInput`](crate::input::DescribeConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectionInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectionInputOperationOutputAlias = crate::operation::DescribeConnection;
#[doc(hidden)]
pub type DescribeConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnection`](crate::operation::DescribeConnection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribeConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connection(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnection",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectionInput`](crate::input::DescribeConnectionInput)
    pub fn builder() -> crate::input::describe_connection_input::Builder {
        crate::input::describe_connection_input::Builder::default()
    }
}

/// See [`DescribeEventBusInput`](crate::input::DescribeEventBusInput)
pub mod describe_event_bus_input {
    /// A builder for [`DescribeEventBusInput`](crate::input::DescribeEventBusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event
        /// bus is displayed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event
        /// bus is displayed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventBusInput`](crate::input::DescribeEventBusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventBusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventBusInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventBusInputOperationOutputAlias = crate::operation::DescribeEventBus;
#[doc(hidden)]
pub type DescribeEventBusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventBusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventBus`](crate::operation::DescribeEventBus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventBus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventBusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventBusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventBusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribeEventBus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_bus(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventBus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventBus",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventBusInput`](crate::input::DescribeEventBusInput)
    pub fn builder() -> crate::input::describe_event_bus_input::Builder {
        crate::input::describe_event_bus_input::Builder::default()
    }
}

/// See [`DescribeEventSourceInput`](crate::input::DescribeEventSourceInput)
pub mod describe_event_source_input {
    /// A builder for [`DescribeEventSourceInput`](crate::input::DescribeEventSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the partner event source to display the details of.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the partner event source to display the details of.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSourceInput`](crate::input::DescribeEventSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventSourceInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventSourceInputOperationOutputAlias = crate::operation::DescribeEventSource;
#[doc(hidden)]
pub type DescribeEventSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventSourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventSource`](crate::operation::DescribeEventSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribeEventSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventSource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventSourceInput`](crate::input::DescribeEventSourceInput)
    pub fn builder() -> crate::input::describe_event_source_input::Builder {
        crate::input::describe_event_source_input::Builder::default()
    }
}

/// See [`DescribePartnerEventSourceInput`](crate::input::DescribePartnerEventSourceInput)
pub mod describe_partner_event_source_input {
    /// A builder for [`DescribePartnerEventSourceInput`](crate::input::DescribePartnerEventSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event source to display.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event source to display.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePartnerEventSourceInput`](crate::input::DescribePartnerEventSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePartnerEventSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePartnerEventSourceInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribePartnerEventSourceInputOperationOutputAlias =
    crate::operation::DescribePartnerEventSource;
#[doc(hidden)]
pub type DescribePartnerEventSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePartnerEventSourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribePartnerEventSource`](crate::operation::DescribePartnerEventSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePartnerEventSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePartnerEventSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePartnerEventSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePartnerEventSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribePartnerEventSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_partner_event_source(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePartnerEventSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePartnerEventSource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePartnerEventSourceInput`](crate::input::DescribePartnerEventSourceInput)
    pub fn builder() -> crate::input::describe_partner_event_source_input::Builder {
        crate::input::describe_partner_event_source_input::Builder::default()
    }
}

/// See [`DescribeReplayInput`](crate::input::DescribeReplayInput)
pub mod describe_replay_input {
    /// A builder for [`DescribeReplayInput`](crate::input::DescribeReplayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replay_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the replay to retrieve.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_name = Some(input.into());
            self
        }
        /// <p>The name of the replay to retrieve.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplayInput`](crate::input::DescribeReplayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReplayInput {
                replay_name: self.replay_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReplayInputOperationOutputAlias = crate::operation::DescribeReplay;
#[doc(hidden)]
pub type DescribeReplayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReplayInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplay`](crate::operation::DescribeReplay)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplay,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribeReplay",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replay(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplay::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplay",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplayInput`](crate::input::DescribeReplayInput)
    pub fn builder() -> crate::input::describe_replay_input::Builder {
        crate::input::describe_replay_input::Builder::default()
    }
}

/// See [`DescribeRuleInput`](crate::input::DescribeRuleInput)
pub mod describe_rule_input {
    /// A builder for [`DescribeRuleInput`](crate::input::DescribeRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRuleInput`](crate::input::DescribeRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRuleInput {
                name: self.name,
                event_bus_name: self.event_bus_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRuleInputOperationOutputAlias = crate::operation::DescribeRule;
#[doc(hidden)]
pub type DescribeRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRuleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRule`](crate::operation::DescribeRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DescribeRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRule",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRuleInput`](crate::input::DescribeRuleInput)
    pub fn builder() -> crate::input::describe_rule_input::Builder {
        crate::input::describe_rule_input::Builder::default()
    }
}

/// See [`DisableRuleInput`](crate::input::DisableRuleInput)
pub mod disable_rule_input {
    /// A builder for [`DisableRuleInput`](crate::input::DisableRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableRuleInput`](crate::input::DisableRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableRuleInput {
                name: self.name,
                event_bus_name: self.event_bus_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableRuleInputOperationOutputAlias = crate::operation::DisableRule;
#[doc(hidden)]
pub type DisableRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableRuleInput {
    /// Consumes the builder and constructs an Operation<[`DisableRule`](crate::operation::DisableRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.DisableRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_disable_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableRule",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableRuleInput`](crate::input::DisableRuleInput)
    pub fn builder() -> crate::input::disable_rule_input::Builder {
        crate::input::disable_rule_input::Builder::default()
    }
}

/// See [`EnableRuleInput`](crate::input::EnableRuleInput)
pub mod enable_rule_input {
    /// A builder for [`EnableRuleInput`](crate::input::EnableRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableRuleInput`](crate::input::EnableRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableRuleInput {
                name: self.name,
                event_bus_name: self.event_bus_name,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableRuleInputOperationOutputAlias = crate::operation::EnableRule;
#[doc(hidden)]
pub type EnableRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableRuleInput {
    /// Consumes the builder and constructs an Operation<[`EnableRule`](crate::operation::EnableRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.EnableRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_enable_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableRule",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableRuleInput`](crate::input::EnableRuleInput)
    pub fn builder() -> crate::input::enable_rule_input::Builder {
        crate::input::enable_rule_input::Builder::default()
    }
}

/// See [`ListApiDestinationsInput`](crate::input::ListApiDestinationsInput)
pub mod list_api_destinations_input {
    /// A builder for [`ListApiDestinationsInput`](crate::input::ListApiDestinationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A name prefix to filter results returned. Only API destinations with a name that starts
        /// with the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>A name prefix to filter results returned. Only API destinations with a name that starts
        /// with the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of API destinations to include in the response.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of API destinations to include in the response.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApiDestinationsInput`](crate::input::ListApiDestinationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApiDestinationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApiDestinationsInput {
                name_prefix: self.name_prefix,
                connection_arn: self.connection_arn,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApiDestinationsInputOperationOutputAlias = crate::operation::ListApiDestinations;
#[doc(hidden)]
pub type ListApiDestinationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListApiDestinationsInput {
    /// Consumes the builder and constructs an Operation<[`ListApiDestinations`](crate::operation::ListApiDestinations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApiDestinations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApiDestinationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApiDestinationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApiDestinationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListApiDestinations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_api_destinations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApiDestinations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApiDestinations",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApiDestinationsInput`](crate::input::ListApiDestinationsInput)
    pub fn builder() -> crate::input::list_api_destinations_input::Builder {
        crate::input::list_api_destinations_input::Builder::default()
    }
}

/// See [`ListArchivesInput`](crate::input::ListArchivesInput)
pub mod list_archives_input {
    /// A builder for [`ListArchivesInput`](crate::input::ListArchivesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ArchiveState>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A name prefix to filter the archives returned. Only archives with name that match the
        /// prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>A name prefix to filter the archives returned. Only archives with name that match the
        /// prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The state of the archive.</p>
        pub fn state(mut self, input: crate::model::ArchiveState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the archive.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ArchiveState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArchivesInput`](crate::input::ListArchivesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListArchivesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListArchivesInput {
                name_prefix: self.name_prefix,
                event_source_arn: self.event_source_arn,
                state: self.state,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListArchivesInputOperationOutputAlias = crate::operation::ListArchives;
#[doc(hidden)]
pub type ListArchivesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListArchivesInput {
    /// Consumes the builder and constructs an Operation<[`ListArchives`](crate::operation::ListArchives)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListArchives,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListArchivesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListArchivesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListArchivesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListArchives",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_archives(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListArchives::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListArchives",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListArchivesInput`](crate::input::ListArchivesInput)
    pub fn builder() -> crate::input::list_archives_input::Builder {
        crate::input::list_archives_input::Builder::default()
    }
}

/// See [`ListConnectionsInput`](crate::input::ListConnectionsInput)
pub mod list_connections_input {
    /// A builder for [`ListConnectionsInput`](crate::input::ListConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A name prefix to filter results returned. Only connections with a name that starts with
        /// the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>A name prefix to filter results returned. Only connections with a name that starts with
        /// the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The state of the connection.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of connections to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of connections to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectionsInput`](crate::input::ListConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConnectionsInput {
                name_prefix: self.name_prefix,
                connection_state: self.connection_state,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConnectionsInputOperationOutputAlias = crate::operation::ListConnections;
#[doc(hidden)]
pub type ListConnectionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`ListConnections`](crate::operation::ListConnections)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConnections,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConnectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConnectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConnectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListConnections",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_connections(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConnections",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConnectionsInput`](crate::input::ListConnectionsInput)
    pub fn builder() -> crate::input::list_connections_input::Builder {
        crate::input::list_connections_input::Builder::default()
    }
}

/// See [`ListEventBusesInput`](crate::input::ListEventBusesInput)
pub mod list_event_buses_input {
    /// A builder for [`ListEventBusesInput`](crate::input::ListEventBusesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifying this limits the results to only those event buses with names that start with
        /// the specified prefix.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those event buses with names that start with
        /// the specified prefix.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation
        /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
        /// of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation
        /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
        /// of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventBusesInput`](crate::input::ListEventBusesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventBusesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventBusesInput {
                name_prefix: self.name_prefix,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventBusesInputOperationOutputAlias = crate::operation::ListEventBuses;
#[doc(hidden)]
pub type ListEventBusesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEventBusesInput {
    /// Consumes the builder and constructs an Operation<[`ListEventBuses`](crate::operation::ListEventBuses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventBuses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEventBusesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEventBusesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEventBusesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListEventBuses",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_event_buses(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventBuses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventBuses",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEventBusesInput`](crate::input::ListEventBusesInput)
    pub fn builder() -> crate::input::list_event_buses_input::Builder {
        crate::input::list_event_buses_input::Builder::default()
    }
}

/// See [`ListEventSourcesInput`](crate::input::ListEventSourcesInput)
pub mod list_event_sources_input {
    /// A builder for [`ListEventSourcesInput`](crate::input::ListEventSourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifying this limits the results to only those partner event sources with names that
        /// start with the specified prefix.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those partner event sources with names that
        /// start with the specified prefix.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation
        /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
        /// of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation
        /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
        /// of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventSourcesInput`](crate::input::ListEventSourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventSourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventSourcesInput {
                name_prefix: self.name_prefix,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventSourcesInputOperationOutputAlias = crate::operation::ListEventSources;
#[doc(hidden)]
pub type ListEventSourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEventSourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListEventSources`](crate::operation::ListEventSources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventSources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEventSourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEventSourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEventSourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListEventSources",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_event_sources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventSources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventSources",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEventSourcesInput`](crate::input::ListEventSourcesInput)
    pub fn builder() -> crate::input::list_event_sources_input::Builder {
        crate::input::list_event_sources_input::Builder::default()
    }
}

/// See [`ListPartnerEventSourceAccountsInput`](crate::input::ListPartnerEventSourceAccountsInput)
pub mod list_partner_event_source_accounts_input {
    /// A builder for [`ListPartnerEventSourceAccountsInput`](crate::input::ListPartnerEventSourceAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_source_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the partner event source to display account information about.</p>
        pub fn event_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_name = Some(input.into());
            self
        }
        /// <p>The name of the partner event source to display account information about.</p>
        pub fn set_event_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_name = input;
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
        /// next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
        /// next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation
        /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
        /// of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation
        /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
        /// of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartnerEventSourceAccountsInput`](crate::input::ListPartnerEventSourceAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPartnerEventSourceAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPartnerEventSourceAccountsInput {
                event_source_name: self.event_source_name,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPartnerEventSourceAccountsInputOperationOutputAlias =
    crate::operation::ListPartnerEventSourceAccounts;
#[doc(hidden)]
pub type ListPartnerEventSourceAccountsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPartnerEventSourceAccountsInput {
    /// Consumes the builder and constructs an Operation<[`ListPartnerEventSourceAccounts`](crate::operation::ListPartnerEventSourceAccounts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPartnerEventSourceAccounts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPartnerEventSourceAccountsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPartnerEventSourceAccountsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPartnerEventSourceAccountsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListPartnerEventSourceAccounts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_partner_event_source_accounts(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPartnerEventSourceAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPartnerEventSourceAccounts",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPartnerEventSourceAccountsInput`](crate::input::ListPartnerEventSourceAccountsInput)
    pub fn builder() -> crate::input::list_partner_event_source_accounts_input::Builder {
        crate::input::list_partner_event_source_accounts_input::Builder::default()
    }
}

/// See [`ListPartnerEventSourcesInput`](crate::input::ListPartnerEventSourcesInput)
pub mod list_partner_event_sources_input {
    /// A builder for [`ListPartnerEventSourcesInput`](crate::input::ListPartnerEventSourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If you specify this, the results are limited to only those partner event sources that
        /// start with the string you specify.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>If you specify this, the results are limited to only those partner event sources that
        /// start with the string you specify.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
        /// next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
        /// next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>pecifying this limits the number of results returned by this operation. The operation also
        /// returns a NextToken which you can use in a subsequent operation to retrieve the next set of
        /// results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>pecifying this limits the number of results returned by this operation. The operation also
        /// returns a NextToken which you can use in a subsequent operation to retrieve the next set of
        /// results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartnerEventSourcesInput`](crate::input::ListPartnerEventSourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPartnerEventSourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPartnerEventSourcesInput {
                name_prefix: self.name_prefix,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPartnerEventSourcesInputOperationOutputAlias =
    crate::operation::ListPartnerEventSources;
#[doc(hidden)]
pub type ListPartnerEventSourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPartnerEventSourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListPartnerEventSources`](crate::operation::ListPartnerEventSources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPartnerEventSources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPartnerEventSourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPartnerEventSourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPartnerEventSourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListPartnerEventSources",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_partner_event_sources(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPartnerEventSources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPartnerEventSources",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPartnerEventSourcesInput`](crate::input::ListPartnerEventSourcesInput)
    pub fn builder() -> crate::input::list_partner_event_sources_input::Builder {
        crate::input::list_partner_event_sources_input::Builder::default()
    }
}

/// See [`ListReplaysInput`](crate::input::ListReplaysInput)
pub mod list_replays_input {
    /// A builder for [`ListReplaysInput`](crate::input::ListReplaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReplayState>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix
        /// are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix
        /// are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The state of the replay.</p>
        pub fn state(mut self, input: crate::model::ReplayState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the replay.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ReplayState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The ARN of the archive from which the events are replayed.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the archive from which the events are replayed.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of replays to retrieve.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of replays to retrieve.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReplaysInput`](crate::input::ListReplaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReplaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReplaysInput {
                name_prefix: self.name_prefix,
                state: self.state,
                event_source_arn: self.event_source_arn,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReplaysInputOperationOutputAlias = crate::operation::ListReplays;
#[doc(hidden)]
pub type ListReplaysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReplaysInput {
    /// Consumes the builder and constructs an Operation<[`ListReplays`](crate::operation::ListReplays)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReplays,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReplaysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReplaysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReplaysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListReplays",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_replays(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReplays::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReplays",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReplaysInput`](crate::input::ListReplaysInput)
    pub fn builder() -> crate::input::list_replays_input::Builder {
        crate::input::list_replays_input::Builder::default()
    }
}

/// See [`ListRuleNamesByTargetInput`](crate::input::ListRuleNamesByTargetInput)
pub mod list_rule_names_by_target_input {
    /// A builder for [`ListRuleNamesByTargetInput`](crate::input::ListRuleNamesByTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event
        /// bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event
        /// bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRuleNamesByTargetInput`](crate::input::ListRuleNamesByTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRuleNamesByTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRuleNamesByTargetInput {
                target_arn: self.target_arn,
                event_bus_name: self.event_bus_name,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRuleNamesByTargetInputOperationOutputAlias = crate::operation::ListRuleNamesByTarget;
#[doc(hidden)]
pub type ListRuleNamesByTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRuleNamesByTargetInput {
    /// Consumes the builder and constructs an Operation<[`ListRuleNamesByTarget`](crate::operation::ListRuleNamesByTarget)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRuleNamesByTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRuleNamesByTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRuleNamesByTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRuleNamesByTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListRuleNamesByTarget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_rule_names_by_target(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRuleNamesByTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRuleNamesByTarget",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRuleNamesByTargetInput`](crate::input::ListRuleNamesByTargetInput)
    pub fn builder() -> crate::input::list_rule_names_by_target_input::Builder {
        crate::input::list_rule_names_by_target_input::Builder::default()
    }
}

/// See [`ListRulesInput`](crate::input::ListRulesInput)
pub mod list_rules_input {
    /// A builder for [`ListRulesInput`](crate::input::ListRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The prefix matching the rule name.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>The prefix matching the rule name.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesInput`](crate::input::ListRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListRulesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListRulesInput {
                name_prefix: self.name_prefix,
                event_bus_name: self.event_bus_name,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRulesInputOperationOutputAlias = crate::operation::ListRules;
#[doc(hidden)]
pub type ListRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListRules`](crate::operation::ListRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_rules(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListRules::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListRules",
                    "eventbridge",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRulesInput`](crate::input::ListRulesInput)
    pub fn builder() -> crate::input::list_rules_input::Builder {
        crate::input::list_rules_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTargetsByRuleInput`](crate::input::ListTargetsByRuleInput)
pub mod list_targets_by_rule_input {
    /// A builder for [`ListTargetsByRuleInput`](crate::input::ListTargetsByRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsByRuleInput`](crate::input::ListTargetsByRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTargetsByRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTargetsByRuleInput {
                rule: self.rule,
                event_bus_name: self.event_bus_name,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTargetsByRuleInputOperationOutputAlias = crate::operation::ListTargetsByRule;
#[doc(hidden)]
pub type ListTargetsByRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTargetsByRuleInput {
    /// Consumes the builder and constructs an Operation<[`ListTargetsByRule`](crate::operation::ListTargetsByRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTargetsByRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTargetsByRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTargetsByRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTargetsByRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.ListTargetsByRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_targets_by_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTargetsByRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTargetsByRule",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTargetsByRuleInput`](crate::input::ListTargetsByRuleInput)
    pub fn builder() -> crate::input::list_targets_by_rule_input::Builder {
        crate::input::list_targets_by_rule_input::Builder::default()
    }
}

/// See [`PutEventsInput`](crate::input::PutEventsInput)
pub mod put_events_input {
    /// A builder for [`PutEventsInput`](crate::input::PutEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries: std::option::Option<std::vec::Vec<crate::model::PutEventsRequestEntry>>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The entry that defines an event in your system. You can specify several parameters for the
        /// entry such as the source and type of the event, resources associated with the event, and so
        /// on.</p>
        pub fn entries(mut self, input: impl Into<crate::model::PutEventsRequestEntry>) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>The entry that defines an event in your system. You can specify several parameters for the
        /// entry such as the source and type of the event, resources associated with the event, and so
        /// on.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutEventsRequestEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventsInput`](crate::input::PutEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutEventsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutEventsInput {
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEventsInputOperationOutputAlias = crate::operation::PutEvents;
#[doc(hidden)]
pub type PutEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutEventsInput {
    /// Consumes the builder and constructs an Operation<[`PutEvents`](crate::operation::PutEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.PutEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutEvents::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutEvents",
                    "eventbridge",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutEventsInput`](crate::input::PutEventsInput)
    pub fn builder() -> crate::input::put_events_input::Builder {
        crate::input::put_events_input::Builder::default()
    }
}

/// See [`PutPartnerEventsInput`](crate::input::PutPartnerEventsInput)
pub mod put_partner_events_input {
    /// A builder for [`PutPartnerEventsInput`](crate::input::PutPartnerEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsRequestEntry>>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of events to write to the event bus.</p>
        pub fn entries(
            mut self,
            input: impl Into<crate::model::PutPartnerEventsRequestEntry>,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>The list of events to write to the event bus.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsRequestEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPartnerEventsInput`](crate::input::PutPartnerEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutPartnerEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutPartnerEventsInput {
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type PutPartnerEventsInputOperationOutputAlias = crate::operation::PutPartnerEvents;
#[doc(hidden)]
pub type PutPartnerEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutPartnerEventsInput {
    /// Consumes the builder and constructs an Operation<[`PutPartnerEvents`](crate::operation::PutPartnerEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutPartnerEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutPartnerEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutPartnerEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutPartnerEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.PutPartnerEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_partner_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutPartnerEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutPartnerEvents",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutPartnerEventsInput`](crate::input::PutPartnerEventsInput)
    pub fn builder() -> crate::input::put_partner_events_input::Builder {
        crate::input::put_partner_events_input::Builder::default()
    }
}

/// See [`PutPermissionInput`](crate::input::PutPermissionInput)
pub mod put_permission_input {
    /// A builder for [`PutPermissionInput`](crate::input::PutPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<crate::model::Condition>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event bus associated with the rule. If you omit this, the default event
        /// bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name of the event bus associated with the rule. If you omit this, the default event
        /// bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// <p>The action that you are enabling the other account to perform.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The action that you are enabling the other account to perform.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event
        /// bus. Specify "*" to permit any account to put events to your default event bus.</p>
        ///
        /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that
        /// may match undesirable events. To create more secure rules, make sure that the event pattern
        /// for each rule contains an <code>account</code> field with a specific account ID from which to
        /// receive events. Rules with an account field do not match any events sent from other
        /// accounts.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event
        /// bus. Specify "*" to permit any account to put events to your default event bus.</p>
        ///
        /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that
        /// may match undesirable events. To create more secure rules, make sure that the event pattern
        /// for each rule contains an <code>account</code> field with a specific account ID from which to
        /// receive events. Rules with an account field do not match any events sent from other
        /// accounts.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>An identifier string for the external account that you are granting permissions to. If you
        /// later want to revoke the permission for this external account, specify this
        /// <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>An identifier string for the external account that you are granting permissions to. If you
        /// later want to revoke the permission for this external account, specify this
        /// <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain
        /// condition, such as being a member of a certain Amazon Web Services organization. For more information about
        /// Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services
        /// Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
        /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the
        /// value for <code>Principal</code>, you grant permission to all the accounts in the named
        /// organization.</p>
        ///
        /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>,
        /// <code>Key</code>, and <code>Value</code> fields.</p>
        pub fn condition(mut self, input: crate::model::Condition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain
        /// condition, such as being a member of a certain Amazon Web Services organization. For more information about
        /// Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services
        /// Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
        /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the
        /// value for <code>Principal</code>, you grant permission to all the accounts in the named
        /// organization.</p>
        ///
        /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>,
        /// <code>Key</code>, and <code>Value</code> fields.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::Condition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>A JSON string that describes the permission policy statement. You can include a
        /// <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>,
        /// <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A JSON string that describes the permission policy statement. You can include a
        /// <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>,
        /// <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPermissionInput`](crate::input::PutPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutPermissionInput {
                event_bus_name: self.event_bus_name,
                action: self.action,
                principal: self.principal,
                statement_id: self.statement_id,
                condition: self.condition,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutPermissionInputOperationOutputAlias = crate::operation::PutPermission;
#[doc(hidden)]
pub type PutPermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutPermissionInput {
    /// Consumes the builder and constructs an Operation<[`PutPermission`](crate::operation::PutPermission)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutPermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.PutPermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_permission(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutPermission",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutPermissionInput`](crate::input::PutPermissionInput)
    pub fn builder() -> crate::input::put_permission_input::Builder {
        crate::input::put_permission_input::Builder::default()
    }
}

/// See [`PutRuleInput`](crate::input::PutRuleInput)
pub mod put_rule_input {
    /// A builder for [`PutRuleInput`](crate::input::PutRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::RuleState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule that you are creating or updating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule that you are creating or updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn state(mut self, input: crate::model::RuleState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RuleState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A description of the rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted
        /// permission to your account through an organization instead of directly by the account ID, you
        /// must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code>
        /// structure, instead of here in this parameter.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted
        /// permission to your account through an organization instead of directly by the account ID, you
        /// must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code>
        /// structure, instead of here in this parameter.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the rule.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of key-value pairs to associate with the rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the
        /// default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the
        /// default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRuleInput`](crate::input::PutRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutRuleInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutRuleInput {
                name: self.name,
                schedule_expression: self.schedule_expression,
                event_pattern: self.event_pattern,
                state: self.state,
                description: self.description,
                role_arn: self.role_arn,
                tags: self.tags,
                event_bus_name: self.event_bus_name,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRuleInputOperationOutputAlias = crate::operation::PutRule;
#[doc(hidden)]
pub type PutRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRuleInput {
    /// Consumes the builder and constructs an Operation<[`PutRule`](crate::operation::PutRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.PutRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutRule::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutRule",
                    "eventbridge",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRuleInput`](crate::input::PutRuleInput)
    pub fn builder() -> crate::input::put_rule_input::Builder {
        crate::input::put_rule_input::Builder::default()
    }
}

/// See [`PutTargetsInput`](crate::input::PutTargetsInput)
pub mod put_targets_input {
    /// A builder for [`PutTargetsInput`](crate::input::PutTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets to update or add to the rule.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets to update or add to the rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Consumes the builder and constructs a [`PutTargetsInput`](crate::input::PutTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutTargetsInput {
                rule: self.rule,
                event_bus_name: self.event_bus_name,
                targets: self.targets,
            })
        }
    }
}
#[doc(hidden)]
pub type PutTargetsInputOperationOutputAlias = crate::operation::PutTargets;
#[doc(hidden)]
pub type PutTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutTargetsInput {
    /// Consumes the builder and constructs an Operation<[`PutTargets`](crate::operation::PutTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.PutTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_targets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutTargets",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutTargetsInput`](crate::input::PutTargetsInput)
    pub fn builder() -> crate::input::put_targets_input::Builder {
        crate::input::put_targets_input::Builder::default()
    }
}

/// See [`RemovePermissionInput`](crate::input::RemovePermissionInput)
pub mod remove_permission_input {
    /// A builder for [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) remove_all_permissions: std::option::Option<bool>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The statement ID corresponding to the account that is no longer allowed to put events to
        /// the default event bus.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>The statement ID corresponding to the account that is no longer allowed to put events to
        /// the default event bus.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>Specifies whether to remove all permissions.</p>
        pub fn remove_all_permissions(mut self, input: bool) -> Self {
            self.remove_all_permissions = Some(input);
            self
        }
        /// <p>Specifies whether to remove all permissions.</p>
        pub fn set_remove_all_permissions(mut self, input: std::option::Option<bool>) -> Self {
            self.remove_all_permissions = input;
            self
        }
        /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event
        /// bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event
        /// bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RemovePermissionInput`](crate::input::RemovePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemovePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemovePermissionInput {
                statement_id: self.statement_id,
                remove_all_permissions: self.remove_all_permissions.unwrap_or_default(),
                event_bus_name: self.event_bus_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RemovePermissionInputOperationOutputAlias = crate::operation::RemovePermission;
#[doc(hidden)]
pub type RemovePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemovePermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemovePermission`](crate::operation::RemovePermission)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemovePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemovePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemovePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemovePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.RemovePermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_permission(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemovePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemovePermission",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
}

/// See [`RemoveTargetsInput`](crate::input::RemoveTargetsInput)
pub mod remove_targets_input {
    /// A builder for [`RemoveTargetsInput`](crate::input::RemoveTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the targets to remove from the rule.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>The IDs of the targets to remove from the rule.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
        /// <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for
        /// rules that are not managed rules. You can check whether a rule is a managed rule by using
        /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
        /// field of the response.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
        /// <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for
        /// rules that are not managed rules. You can check whether a rule is a managed rule by using
        /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
        /// field of the response.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTargetsInput`](crate::input::RemoveTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTargetsInput {
                rule: self.rule,
                event_bus_name: self.event_bus_name,
                ids: self.ids,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTargetsInputOperationOutputAlias = crate::operation::RemoveTargets;
#[doc(hidden)]
pub type RemoveTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTargetsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTargets`](crate::operation::RemoveTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.RemoveTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_remove_targets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTargets",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTargetsInput`](crate::input::RemoveTargetsInput)
    pub fn builder() -> crate::input::remove_targets_input::Builder {
        crate::input::remove_targets_input::Builder::default()
    }
}

/// See [`StartReplayInput`](crate::input::StartReplayInput)
pub mod start_replay_input {
    /// A builder for [`StartReplayInput`](crate::input::StartReplayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replay_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) event_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) destination: std::option::Option<crate::model::ReplayDestination>,
    }
    impl Builder {
        /// <p>The name of the replay to start.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_name = Some(input.into());
            self
        }
        /// <p>The name of the replay to start.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_name = input;
            self
        }
        /// <p>A description for the replay to start.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the replay to start.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the archive to replay events from.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the archive to replay events from.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>A time stamp for the time to start replaying events. Only events that occurred between the
        /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn event_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.event_start_time = Some(input);
            self
        }
        /// <p>A time stamp for the time to start replaying events. Only events that occurred between the
        /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn set_event_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.event_start_time = input;
            self
        }
        /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the
        /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn event_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.event_end_time = Some(input);
            self
        }
        /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the
        /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn set_event_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.event_end_time = input;
            self
        }
        /// <p>A <code>ReplayDestination</code> object that includes details about the destination for
        /// the replay.</p>
        pub fn destination(mut self, input: crate::model::ReplayDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>A <code>ReplayDestination</code> object that includes details about the destination for
        /// the replay.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::ReplayDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReplayInput`](crate::input::StartReplayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartReplayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartReplayInput {
                replay_name: self.replay_name,
                description: self.description,
                event_source_arn: self.event_source_arn,
                event_start_time: self.event_start_time,
                event_end_time: self.event_end_time,
                destination: self.destination,
            })
        }
    }
}
#[doc(hidden)]
pub type StartReplayInputOperationOutputAlias = crate::operation::StartReplay;
#[doc(hidden)]
pub type StartReplayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartReplayInput {
    /// Consumes the builder and constructs an Operation<[`StartReplay`](crate::operation::StartReplay)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartReplay,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartReplayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartReplayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartReplayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.StartReplay",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_replay(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartReplay::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartReplay",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartReplayInput`](crate::input::StartReplayInput)
    pub fn builder() -> crate::input::start_replay_input::Builder {
        crate::input::start_replay_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestEventPatternInput`](crate::input::TestEventPatternInput)
pub mod test_event_pattern_input {
    /// A builder for [`TestEventPatternInput`](crate::input::TestEventPatternInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) event: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the
        /// format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following
        /// fields are mandatory:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>account</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>source</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>time</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>region</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>detail-type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn event(mut self, input: impl Into<std::string::String>) -> Self {
            self.event = Some(input.into());
            self
        }
        /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the
        /// format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following
        /// fields are mandatory:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>account</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>source</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>time</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>region</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>detail-type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event = input;
            self
        }
        /// Consumes the builder and constructs a [`TestEventPatternInput`](crate::input::TestEventPatternInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestEventPatternInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestEventPatternInput {
                event_pattern: self.event_pattern,
                event: self.event,
            })
        }
    }
}
#[doc(hidden)]
pub type TestEventPatternInputOperationOutputAlias = crate::operation::TestEventPattern;
#[doc(hidden)]
pub type TestEventPatternInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestEventPatternInput {
    /// Consumes the builder and constructs an Operation<[`TestEventPattern`](crate::operation::TestEventPattern)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestEventPattern,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestEventPatternInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestEventPatternInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestEventPatternInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.TestEventPattern",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_test_event_pattern(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestEventPattern::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestEventPattern",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestEventPatternInput`](crate::input::TestEventPatternInput)
    pub fn builder() -> crate::input::test_event_pattern_input::Builder {
        crate::input::test_event_pattern_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApiDestinationInput`](crate::input::UpdateApiDestinationInput)
pub mod update_api_destination_input {
    /// A builder for [`UpdateApiDestinationInput`](crate::input::UpdateApiDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) invocation_endpoint: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        pub(crate) invocation_rate_limit_per_second: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the API destination to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the connection to use for the API destination.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection to use for the API destination.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The URL to the endpoint to use for the API destination.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_endpoint = Some(input.into());
            self
        }
        /// <p>The URL to the endpoint to use for the API destination.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_endpoint = input;
            self
        }
        /// <p>The method to use for the API destination.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.http_method = Some(input);
            self
        }
        /// <p>The method to use for the API destination.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The maximum number of invocations per second to send to the API destination.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.invocation_rate_limit_per_second = Some(input);
            self
        }
        /// <p>The maximum number of invocations per second to send to the API destination.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.invocation_rate_limit_per_second = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiDestinationInput`](crate::input::UpdateApiDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApiDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApiDestinationInput {
                name: self.name,
                description: self.description,
                connection_arn: self.connection_arn,
                invocation_endpoint: self.invocation_endpoint,
                http_method: self.http_method,
                invocation_rate_limit_per_second: self.invocation_rate_limit_per_second,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApiDestinationInputOperationOutputAlias = crate::operation::UpdateApiDestination;
#[doc(hidden)]
pub type UpdateApiDestinationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateApiDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApiDestination`](crate::operation::UpdateApiDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApiDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApiDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApiDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApiDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.UpdateApiDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_api_destination(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApiDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApiDestination",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApiDestinationInput`](crate::input::UpdateApiDestinationInput)
    pub fn builder() -> crate::input::update_api_destination_input::Builder {
        crate::input::update_api_destination_input::Builder::default()
    }
}

/// See [`UpdateArchiveInput`](crate::input::UpdateArchiveInput)
pub mod update_archive_input {
    /// A builder for [`UpdateArchiveInput`](crate::input::UpdateArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) retention_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the archive to update.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_name = Some(input.into());
            self
        }
        /// <p>The name of the archive to update.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_name = input;
            self
        }
        /// <p>The description for the archive.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the archive.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The event pattern to use to filter events sent to the archive.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The event pattern to use to filter events sent to the archive.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>The number of days to retain events in the archive.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain events in the archive.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateArchiveInput`](crate::input::UpdateArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateArchiveInput {
                archive_name: self.archive_name,
                description: self.description,
                event_pattern: self.event_pattern,
                retention_days: self.retention_days,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateArchiveInputOperationOutputAlias = crate::operation::UpdateArchive;
#[doc(hidden)]
pub type UpdateArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateArchiveInput {
    /// Consumes the builder and constructs an Operation<[`UpdateArchive`](crate::operation::UpdateArchive)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.UpdateArchive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_archive(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateArchive",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateArchiveInput`](crate::input::UpdateArchiveInput)
    pub fn builder() -> crate::input::update_archive_input::Builder {
        crate::input::update_archive_input::Builder::default()
    }
}

/// See [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
pub mod update_connection_input {
    /// A builder for [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) authorization_type:
            std::option::Option<crate::model::ConnectionAuthorizationType>,
        pub(crate) auth_parameters:
            std::option::Option<crate::model::UpdateConnectionAuthRequestParameters>,
    }
    impl Builder {
        /// <p>The name of the connection to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description for the connection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the connection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The authorization parameters to use for the connection.</p>
        pub fn auth_parameters(
            mut self,
            input: crate::model::UpdateConnectionAuthRequestParameters,
        ) -> Self {
            self.auth_parameters = Some(input);
            self
        }
        /// <p>The authorization parameters to use for the connection.</p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::UpdateConnectionAuthRequestParameters>,
        ) -> Self {
            self.auth_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectionInput {
                name: self.name,
                description: self.description,
                authorization_type: self.authorization_type,
                auth_parameters: self.auth_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectionInputOperationOutputAlias = crate::operation::UpdateConnection;
#[doc(hidden)]
pub type UpdateConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConnectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnection`](crate::operation::UpdateConnection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSEvents.UpdateConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connection(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnection",
            "eventbridge",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    pub fn builder() -> crate::input::update_connection_input::Builder {
        crate::input::update_connection_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionInput {
    /// <p>The name of the connection to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description for the connection.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of authorization to use for the connection.</p>
    pub authorization_type: std::option::Option<crate::model::ConnectionAuthorizationType>,
    /// <p>The authorization parameters to use for the connection.</p>
    pub auth_parameters: std::option::Option<crate::model::UpdateConnectionAuthRequestParameters>,
}
impl UpdateConnectionInput {
    /// <p>The name of the connection to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description for the connection.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of authorization to use for the connection.</p>
    pub fn authorization_type(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionAuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The authorization parameters to use for the connection.</p>
    pub fn auth_parameters(
        &self,
    ) -> std::option::Option<&crate::model::UpdateConnectionAuthRequestParameters> {
        self.auth_parameters.as_ref()
    }
}
impl std::fmt::Debug for UpdateConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("auth_parameters", &self.auth_parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateArchiveInput {
    /// <p>The name of the archive to update.</p>
    pub archive_name: std::option::Option<std::string::String>,
    /// <p>The description for the archive.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The event pattern to use to filter events sent to the archive.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>The number of days to retain events in the archive.</p>
    pub retention_days: std::option::Option<i32>,
}
impl UpdateArchiveInput {
    /// <p>The name of the archive to update.</p>
    pub fn archive_name(&self) -> std::option::Option<&str> {
        self.archive_name.as_deref()
    }
    /// <p>The description for the archive.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The event pattern to use to filter events sent to the archive.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>The number of days to retain events in the archive.</p>
    pub fn retention_days(&self) -> std::option::Option<i32> {
        self.retention_days
    }
}
impl std::fmt::Debug for UpdateArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateArchiveInput");
        formatter.field("archive_name", &self.archive_name);
        formatter.field("description", &self.description);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("retention_days", &self.retention_days);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiDestinationInput {
    /// <p>The name of the API destination to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the API destination to update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the connection to use for the API destination.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The URL to the endpoint to use for the API destination.</p>
    pub invocation_endpoint: std::option::Option<std::string::String>,
    /// <p>The method to use for the API destination.</p>
    pub http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
    /// <p>The maximum number of invocations per second to send to the API destination.</p>
    pub invocation_rate_limit_per_second: std::option::Option<i32>,
}
impl UpdateApiDestinationInput {
    /// <p>The name of the API destination to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the API destination to update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the connection to use for the API destination.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The URL to the endpoint to use for the API destination.</p>
    pub fn invocation_endpoint(&self) -> std::option::Option<&str> {
        self.invocation_endpoint.as_deref()
    }
    /// <p>The method to use for the API destination.</p>
    pub fn http_method(&self) -> std::option::Option<&crate::model::ApiDestinationHttpMethod> {
        self.http_method.as_ref()
    }
    /// <p>The maximum number of invocations per second to send to the API destination.</p>
    pub fn invocation_rate_limit_per_second(&self) -> std::option::Option<i32> {
        self.invocation_rate_limit_per_second
    }
}
impl std::fmt::Debug for UpdateApiDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiDestinationInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("invocation_endpoint", &self.invocation_endpoint);
        formatter.field("http_method", &self.http_method);
        formatter.field(
            "invocation_rate_limit_per_second",
            &self.invocation_rate_limit_per_second,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestEventPatternInput {
    /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
    /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the
    /// format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following
    /// fields are mandatory:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>account</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>source</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>time</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>region</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>resources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>detail-type</code>
    /// </p>
    /// </li>
    /// </ul>
    pub event: std::option::Option<std::string::String>,
}
impl TestEventPatternInput {
    /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
    /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the
    /// format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following
    /// fields are mandatory:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>account</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>source</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>time</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>region</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>resources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>detail-type</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn event(&self) -> std::option::Option<&str> {
        self.event.as_deref()
    }
}
impl std::fmt::Debug for TestEventPatternInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestEventPatternInput");
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("event", &self.event);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of key-value pairs to associate with the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of key-value pairs to associate with the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReplayInput {
    /// <p>The name of the replay to start.</p>
    pub replay_name: std::option::Option<std::string::String>,
    /// <p>A description for the replay to start.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the archive to replay events from.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>A time stamp for the time to start replaying events. Only events that occurred between the
    /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
    pub event_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the
    /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
    pub event_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A <code>ReplayDestination</code> object that includes details about the destination for
    /// the replay.</p>
    pub destination: std::option::Option<crate::model::ReplayDestination>,
}
impl StartReplayInput {
    /// <p>The name of the replay to start.</p>
    pub fn replay_name(&self) -> std::option::Option<&str> {
        self.replay_name.as_deref()
    }
    /// <p>A description for the replay to start.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the archive to replay events from.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>A time stamp for the time to start replaying events. Only events that occurred between the
    /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
    pub fn event_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.event_start_time.as_ref()
    }
    /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the
    /// <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
    pub fn event_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.event_end_time.as_ref()
    }
    /// <p>A <code>ReplayDestination</code> object that includes details about the destination for
    /// the replay.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::ReplayDestination> {
        self.destination.as_ref()
    }
}
impl std::fmt::Debug for StartReplayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReplayInput");
        formatter.field("replay_name", &self.replay_name);
        formatter.field("description", &self.description);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("event_start_time", &self.event_start_time);
        formatter.field("event_end_time", &self.event_end_time);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTargetsInput {
    /// <p>The name of the rule.</p>
    pub rule: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the targets to remove from the rule.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
    /// <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for
    /// rules that are not managed rules. You can check whether a rule is a managed rule by using
    /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
    /// field of the response.</p>
    pub force: bool,
}
impl RemoveTargetsInput {
    /// <p>The name of the rule.</p>
    pub fn rule(&self) -> std::option::Option<&str> {
        self.rule.as_deref()
    }
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>The IDs of the targets to remove from the rule.</p>
    pub fn ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ids.as_deref()
    }
    /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
    /// <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for
    /// rules that are not managed rules. You can check whether a rule is a managed rule by using
    /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
    /// field of the response.</p>
    pub fn force(&self) -> bool {
        self.force
    }
}
impl std::fmt::Debug for RemoveTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTargetsInput");
        formatter.field("rule", &self.rule);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("ids", &self.ids);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionInput {
    /// <p>The statement ID corresponding to the account that is no longer allowed to put events to
    /// the default event bus.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether to remove all permissions.</p>
    pub remove_all_permissions: bool,
    /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event
    /// bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
}
impl RemovePermissionInput {
    /// <p>The statement ID corresponding to the account that is no longer allowed to put events to
    /// the default event bus.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>Specifies whether to remove all permissions.</p>
    pub fn remove_all_permissions(&self) -> bool {
        self.remove_all_permissions
    }
    /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event
    /// bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
}
impl std::fmt::Debug for RemovePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionInput");
        formatter.field("statement_id", &self.statement_id);
        formatter.field("remove_all_permissions", &self.remove_all_permissions);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutTargetsInput {
    /// <p>The name of the rule.</p>
    pub rule: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>The targets to update or add to the rule.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
}
impl PutTargetsInput {
    /// <p>The name of the rule.</p>
    pub fn rule(&self) -> std::option::Option<&str> {
        self.rule.as_deref()
    }
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>The targets to update or add to the rule.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
}
impl std::fmt::Debug for PutTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutTargetsInput");
        formatter.field("rule", &self.rule);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("targets", &self.targets);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRuleInput {
    /// <p>The name of the rule that you are creating or updating.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
    /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>Indicates whether the rule is enabled or disabled.</p>
    pub state: std::option::Option<crate::model::RuleState>,
    /// <p>A description of the rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
    /// <p>If you're setting an event bus in another account as the target and that account granted
    /// permission to your account through an organization instead of directly by the account ID, you
    /// must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code>
    /// structure, instead of here in this parameter.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The list of key-value pairs to associate with the rule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the
    /// default event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
}
impl PutRuleInput {
    /// <p>The name of the rule that you are creating or updating.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
    pub fn schedule_expression(&self) -> std::option::Option<&str> {
        self.schedule_expression.as_deref()
    }
    /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
    /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>Indicates whether the rule is enabled or disabled.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::RuleState> {
        self.state.as_ref()
    }
    /// <p>A description of the rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
    /// <p>If you're setting an event bus in another account as the target and that account granted
    /// permission to your account through an organization instead of directly by the account ID, you
    /// must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code>
    /// structure, instead of here in this parameter.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The list of key-value pairs to associate with the rule.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the
    /// default event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
}
impl std::fmt::Debug for PutRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRuleInput");
        formatter.field("name", &self.name);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("state", &self.state);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPermissionInput {
    /// <p>The name of the event bus associated with the rule. If you omit this, the default event
    /// bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>The action that you are enabling the other account to perform.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event
    /// bus. Specify "*" to permit any account to put events to your default event bus.</p>
    ///
    /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that
    /// may match undesirable events. To create more secure rules, make sure that the event pattern
    /// for each rule contains an <code>account</code> field with a specific account ID from which to
    /// receive events. Rules with an account field do not match any events sent from other
    /// accounts.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>An identifier string for the external account that you are granting permissions to. If you
    /// later want to revoke the permission for this external account, specify this
    /// <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain
    /// condition, such as being a member of a certain Amazon Web Services organization. For more information about
    /// Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services
    /// Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
    /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the
    /// value for <code>Principal</code>, you grant permission to all the accounts in the named
    /// organization.</p>
    ///
    /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>,
    /// <code>Key</code>, and <code>Value</code> fields.</p>
    pub condition: std::option::Option<crate::model::Condition>,
    /// <p>A JSON string that describes the permission policy statement. You can include a
    /// <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>,
    /// <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutPermissionInput {
    /// <p>The name of the event bus associated with the rule. If you omit this, the default event
    /// bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>The action that you are enabling the other account to perform.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event
    /// bus. Specify "*" to permit any account to put events to your default event bus.</p>
    ///
    /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that
    /// may match undesirable events. To create more secure rules, make sure that the event pattern
    /// for each rule contains an <code>account</code> field with a specific account ID from which to
    /// receive events. Rules with an account field do not match any events sent from other
    /// accounts.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>An identifier string for the external account that you are granting permissions to. If you
    /// later want to revoke the permission for this external account, specify this
    /// <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain
    /// condition, such as being a member of a certain Amazon Web Services organization. For more information about
    /// Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services
    /// Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
    /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the
    /// value for <code>Principal</code>, you grant permission to all the accounts in the named
    /// organization.</p>
    ///
    /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>,
    /// <code>Key</code>, and <code>Value</code> fields.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::Condition> {
        self.condition.as_ref()
    }
    /// <p>A JSON string that describes the permission policy statement. You can include a
    /// <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>,
    /// <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPermissionInput");
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("action", &self.action);
        formatter.field("principal", &self.principal);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("condition", &self.condition);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPartnerEventsInput {
    /// <p>The list of events to write to the event bus.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsRequestEntry>>,
}
impl PutPartnerEventsInput {
    /// <p>The list of events to write to the event bus.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::PutPartnerEventsRequestEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for PutPartnerEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPartnerEventsInput");
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventsInput {
    /// <p>The entry that defines an event in your system. You can specify several parameters for the
    /// entry such as the source and type of the event, resources associated with the event, and so
    /// on.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::PutEventsRequestEntry>>,
}
impl PutEventsInput {
    /// <p>The entry that defines an event in your system. You can specify several parameters for the
    /// entry such as the source and type of the event, resources associated with the event, and so
    /// on.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::PutEventsRequestEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for PutEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventsInput");
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsByRuleInput {
    /// <p>The name of the rule.</p>
    pub rule: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub limit: std::option::Option<i32>,
}
impl ListTargetsByRuleInput {
    /// <p>The name of the rule.</p>
    pub fn rule(&self) -> std::option::Option<&str> {
        self.rule.as_deref()
    }
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListTargetsByRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsByRuleInput");
        formatter.field("rule", &self.rule);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesInput {
    /// <p>The prefix matching the rule name.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub limit: std::option::Option<i32>,
}
impl ListRulesInput {
    /// <p>The prefix matching the rule name.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRuleNamesByTargetInput {
    /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event
    /// bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub limit: std::option::Option<i32>,
}
impl ListRuleNamesByTargetInput {
    /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event
    /// bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListRuleNamesByTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRuleNamesByTargetInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReplaysInput {
    /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix
    /// are returned.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The state of the replay.</p>
    pub state: std::option::Option<crate::model::ReplayState>,
    /// <p>The ARN of the archive from which the events are replayed.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of replays to retrieve.</p>
    pub limit: std::option::Option<i32>,
}
impl ListReplaysInput {
    /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix
    /// are returned.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The state of the replay.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ReplayState> {
        self.state.as_ref()
    }
    /// <p>The ARN of the archive from which the events are replayed.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of replays to retrieve.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListReplaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReplaysInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("state", &self.state);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartnerEventSourcesInput {
    /// <p>If you specify this, the results are limited to only those partner event sources that
    /// start with the string you specify.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
    /// next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>pecifying this limits the number of results returned by this operation. The operation also
    /// returns a NextToken which you can use in a subsequent operation to retrieve the next set of
    /// results.</p>
    pub limit: std::option::Option<i32>,
}
impl ListPartnerEventSourcesInput {
    /// <p>If you specify this, the results are limited to only those partner event sources that
    /// start with the string you specify.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
    /// next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>pecifying this limits the number of results returned by this operation. The operation also
    /// returns a NextToken which you can use in a subsequent operation to retrieve the next set of
    /// results.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListPartnerEventSourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartnerEventSourcesInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartnerEventSourceAccountsInput {
    /// <p>The name of the partner event source to display account information about.</p>
    pub event_source_name: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
    /// next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the number of results returned by this operation. The operation
    /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
    /// of results.</p>
    pub limit: std::option::Option<i32>,
}
impl ListPartnerEventSourceAccountsInput {
    /// <p>The name of the partner event source to display account information about.</p>
    pub fn event_source_name(&self) -> std::option::Option<&str> {
        self.event_source_name.as_deref()
    }
    /// <p>The token returned by a previous call to this operation. Specifying this retrieves the
    /// next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifying this limits the number of results returned by this operation. The operation
    /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
    /// of results.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListPartnerEventSourceAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartnerEventSourceAccountsInput");
        formatter.field("event_source_name", &self.event_source_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventSourcesInput {
    /// <p>Specifying this limits the results to only those partner event sources with names that
    /// start with the specified prefix.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the number of results returned by this operation. The operation
    /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
    /// of results.</p>
    pub limit: std::option::Option<i32>,
}
impl ListEventSourcesInput {
    /// <p>Specifying this limits the results to only those partner event sources with names that
    /// start with the specified prefix.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifying this limits the number of results returned by this operation. The operation
    /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
    /// of results.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListEventSourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventSourcesInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventBusesInput {
    /// <p>Specifying this limits the results to only those event buses with names that start with
    /// the specified prefix.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the number of results returned by this operation. The operation
    /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
    /// of results.</p>
    pub limit: std::option::Option<i32>,
}
impl ListEventBusesInput {
    /// <p>Specifying this limits the results to only those event buses with names that start with
    /// the specified prefix.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifying this limits the number of results returned by this operation. The operation
    /// also returns a NextToken which you can use in a subsequent operation to retrieve the next set
    /// of results.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListEventBusesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventBusesInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectionsInput {
    /// <p>A name prefix to filter results returned. Only connections with a name that starts with
    /// the prefix are returned.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The state of the connection.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of connections to return.</p>
    pub limit: std::option::Option<i32>,
}
impl ListConnectionsInput {
    /// <p>A name prefix to filter results returned. Only connections with a name that starts with
    /// the prefix are returned.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The state of the connection.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of connections to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectionsInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArchivesInput {
    /// <p>A name prefix to filter the archives returned. Only archives with name that match the
    /// prefix are returned.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the event source associated with the archive.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The state of the archive.</p>
    pub state: std::option::Option<crate::model::ArchiveState>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub limit: std::option::Option<i32>,
}
impl ListArchivesInput {
    /// <p>A name prefix to filter the archives returned. Only archives with name that match the
    /// prefix are returned.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The ARN of the event source associated with the archive.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The state of the archive.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ArchiveState> {
        self.state.as_ref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListArchivesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArchivesInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("state", &self.state);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApiDestinationsInput {
    /// <p>A name prefix to filter results returned. Only API destinations with a name that starts
    /// with the prefix are returned.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the connection specified for the API destination.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of API destinations to include in the response.</p>
    pub limit: std::option::Option<i32>,
}
impl ListApiDestinationsInput {
    /// <p>A name prefix to filter results returned. Only API destinations with a name that starts
    /// with the prefix are returned.</p>
    pub fn name_prefix(&self) -> std::option::Option<&str> {
        self.name_prefix.as_deref()
    }
    /// <p>The ARN of the connection specified for the API destination.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of API destinations to include in the response.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListApiDestinationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApiDestinationsInput");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableRuleInput {
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
}
impl EnableRuleInput {
    /// <p>The name of the rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
}
impl std::fmt::Debug for EnableRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableRuleInput");
        formatter.field("name", &self.name);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableRuleInput {
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
}
impl DisableRuleInput {
    /// <p>The name of the rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
}
impl std::fmt::Debug for DisableRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableRuleInput");
        formatter.field("name", &self.name);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRuleInput {
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
}
impl DescribeRuleInput {
    /// <p>The name of the rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRuleInput");
        formatter.field("name", &self.name);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplayInput {
    /// <p>The name of the replay to retrieve.</p>
    pub replay_name: std::option::Option<std::string::String>,
}
impl DescribeReplayInput {
    /// <p>The name of the replay to retrieve.</p>
    pub fn replay_name(&self) -> std::option::Option<&str> {
        self.replay_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeReplayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplayInput");
        formatter.field("replay_name", &self.replay_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePartnerEventSourceInput {
    /// <p>The name of the event source to display.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribePartnerEventSourceInput {
    /// <p>The name of the event source to display.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribePartnerEventSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePartnerEventSourceInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSourceInput {
    /// <p>The name of the partner event source to display the details of.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeEventSourceInput {
    /// <p>The name of the partner event source to display the details of.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSourceInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventBusInput {
    /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event
    /// bus is displayed.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeEventBusInput {
    /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event
    /// bus is displayed.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventBusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventBusInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionInput {
    /// <p>The name of the connection to retrieve.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeConnectionInput {
    /// <p>The name of the connection to retrieve.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeArchiveInput {
    /// <p>The name of the archive to retrieve.</p>
    pub archive_name: std::option::Option<std::string::String>,
}
impl DescribeArchiveInput {
    /// <p>The name of the archive to retrieve.</p>
    pub fn archive_name(&self) -> std::option::Option<&str> {
        self.archive_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeArchiveInput");
        formatter.field("archive_name", &self.archive_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApiDestinationInput {
    /// <p>The name of the API destination to retrieve.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeApiDestinationInput {
    /// <p>The name of the API destination to retrieve.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeApiDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApiDestinationInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleInput {
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
    /// <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for
    /// rules that are not managed rules. You can check whether a rule is a managed rule by using
    /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
    /// field of the response.</p>
    pub force: bool,
}
impl DeleteRuleInput {
    /// <p>The name of the rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify
    /// <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for
    /// rules that are not managed rules. You can check whether a rule is a managed rule by using
    /// <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code>
    /// field of the response.</p>
    pub fn force(&self) -> bool {
        self.force
    }
}
impl std::fmt::Debug for DeleteRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleInput");
        formatter.field("name", &self.name);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePartnerEventSourceInput {
    /// <p>The name of the event source to delete.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
    pub account: std::option::Option<std::string::String>,
}
impl DeletePartnerEventSourceInput {
    /// <p>The name of the event source to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
}
impl std::fmt::Debug for DeletePartnerEventSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePartnerEventSourceInput");
        formatter.field("name", &self.name);
        formatter.field("account", &self.account);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventBusInput {
    /// <p>The name of the event bus to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteEventBusInput {
    /// <p>The name of the event bus to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventBusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventBusInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionInput {
    /// <p>The name of the connection to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteConnectionInput {
    /// <p>The name of the connection to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteArchiveInput {
    /// <p>The name of the archive to delete.</p>
    pub archive_name: std::option::Option<std::string::String>,
}
impl DeleteArchiveInput {
    /// <p>The name of the archive to delete.</p>
    pub fn archive_name(&self) -> std::option::Option<&str> {
        self.archive_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteArchiveInput");
        formatter.field("archive_name", &self.archive_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiDestinationInput {
    /// <p>The name of the destination to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteApiDestinationInput {
    /// <p>The name of the destination to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteApiDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiDestinationInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeauthorizeConnectionInput {
    /// <p>The name of the connection to remove authorization from.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeauthorizeConnectionInput {
    /// <p>The name of the connection to remove authorization from.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeauthorizeConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeauthorizeConnectionInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateEventSourceInput {
    /// <p>The name of the partner event source to deactivate.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeactivateEventSourceInput {
    /// <p>The name of the partner event source to deactivate.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeactivateEventSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateEventSourceInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePartnerEventSourceInput {
    /// <p>The name of the partner event source. This name must be unique and must be in the format
    /// <code>
    /// <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i>
    /// </code>.
    /// The Amazon Web Services account that wants to use this partner event source must create a partner event bus
    /// with a name that matches the name of the partner event source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this
    /// partner event source.</p>
    pub account: std::option::Option<std::string::String>,
}
impl CreatePartnerEventSourceInput {
    /// <p>The name of the partner event source. This name must be unique and must be in the format
    /// <code>
    /// <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i>
    /// </code>.
    /// The Amazon Web Services account that wants to use this partner event source must create a partner event bus
    /// with a name that matches the name of the partner event source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this
    /// partner event source.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
}
impl std::fmt::Debug for CreatePartnerEventSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePartnerEventSourceInput");
        formatter.field("name", &self.name);
        formatter.field("account", &self.account);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventBusInput {
    /// <p>The name of the new event bus. </p>
    /// <p>Event bus names cannot contain the / character. You can't use the name
    /// <code>default</code> for a custom event bus, as this name is already used for your account's
    /// default event bus.</p>
    /// <p>If this is a partner event bus, the name must exactly match the name of the partner event
    /// source that this event bus is matched to.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If you are creating a partner event bus, this specifies the partner event source that the
    /// new event bus will be matched with.</p>
    pub event_source_name: std::option::Option<std::string::String>,
    /// <p>Tags to associate with the event bus.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateEventBusInput {
    /// <p>The name of the new event bus. </p>
    /// <p>Event bus names cannot contain the / character. You can't use the name
    /// <code>default</code> for a custom event bus, as this name is already used for your account's
    /// default event bus.</p>
    /// <p>If this is a partner event bus, the name must exactly match the name of the partner event
    /// source that this event bus is matched to.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If you are creating a partner event bus, this specifies the partner event source that the
    /// new event bus will be matched with.</p>
    pub fn event_source_name(&self) -> std::option::Option<&str> {
        self.event_source_name.as_deref()
    }
    /// <p>Tags to associate with the event bus.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateEventBusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventBusInput");
        formatter.field("name", &self.name);
        formatter.field("event_source_name", &self.event_source_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionInput {
    /// <p>The name for the connection to create.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description for the connection to create.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of authorization to use for the connection.</p>
    pub authorization_type: std::option::Option<crate::model::ConnectionAuthorizationType>,
    /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the
    /// authorization parameters to use to authorize with the endpoint. </p>
    pub auth_parameters: std::option::Option<crate::model::CreateConnectionAuthRequestParameters>,
}
impl CreateConnectionInput {
    /// <p>The name for the connection to create.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description for the connection to create.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of authorization to use for the connection.</p>
    pub fn authorization_type(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionAuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the
    /// authorization parameters to use to authorize with the endpoint. </p>
    pub fn auth_parameters(
        &self,
    ) -> std::option::Option<&crate::model::CreateConnectionAuthRequestParameters> {
        self.auth_parameters.as_ref()
    }
}
impl std::fmt::Debug for CreateConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("auth_parameters", &self.auth_parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateArchiveInput {
    /// <p>The name for the archive to create.</p>
    pub archive_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the event bus that sends events to the archive.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>A description for the archive.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An event pattern to use to filter events sent to the archive.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are
    /// retained indefinitely</p>
    pub retention_days: std::option::Option<i32>,
}
impl CreateArchiveInput {
    /// <p>The name for the archive to create.</p>
    pub fn archive_name(&self) -> std::option::Option<&str> {
        self.archive_name.as_deref()
    }
    /// <p>The ARN of the event bus that sends events to the archive.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>A description for the archive.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An event pattern to use to filter events sent to the archive.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are
    /// retained indefinitely</p>
    pub fn retention_days(&self) -> std::option::Option<i32> {
        self.retention_days
    }
}
impl std::fmt::Debug for CreateArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateArchiveInput");
        formatter.field("archive_name", &self.archive_name);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("description", &self.description);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("retention_days", &self.retention_days);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiDestinationInput {
    /// <p>The name for the API destination to create.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description for the API destination to create.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the connection to use for the API destination. The destination endpoint must
    /// support the authorization type specified for the connection.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
    pub invocation_endpoint: std::option::Option<std::string::String>,
    /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
    pub http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
    /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
    pub invocation_rate_limit_per_second: std::option::Option<i32>,
}
impl CreateApiDestinationInput {
    /// <p>The name for the API destination to create.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description for the API destination to create.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the connection to use for the API destination. The destination endpoint must
    /// support the authorization type specified for the connection.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
    pub fn invocation_endpoint(&self) -> std::option::Option<&str> {
        self.invocation_endpoint.as_deref()
    }
    /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
    pub fn http_method(&self) -> std::option::Option<&crate::model::ApiDestinationHttpMethod> {
        self.http_method.as_ref()
    }
    /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
    pub fn invocation_rate_limit_per_second(&self) -> std::option::Option<i32> {
        self.invocation_rate_limit_per_second
    }
}
impl std::fmt::Debug for CreateApiDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiDestinationInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("invocation_endpoint", &self.invocation_endpoint);
        formatter.field("http_method", &self.http_method);
        formatter.field(
            "invocation_rate_limit_per_second",
            &self.invocation_rate_limit_per_second,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelReplayInput {
    /// <p>The name of the replay to cancel.</p>
    pub replay_name: std::option::Option<std::string::String>,
}
impl CancelReplayInput {
    /// <p>The name of the replay to cancel.</p>
    pub fn replay_name(&self) -> std::option::Option<&str> {
        self.replay_name.as_deref()
    }
}
impl std::fmt::Debug for CancelReplayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelReplayInput");
        formatter.field("replay_name", &self.replay_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateEventSourceInput {
    /// <p>The name of the partner event source to activate.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ActivateEventSourceInput {
    /// <p>The name of the partner event source to activate.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ActivateEventSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateEventSourceInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
