// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ActivateEventSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`activate_event_source`](crate::client::Client::activate_event_source).
///
/// See [`crate::client::fluent_builders::ActivateEventSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ActivateEventSource {
    _private: (),
}
impl ActivateEventSource {
    /// Creates a new builder-style object to manufacture [`ActivateEventSourceInput`](crate::input::ActivateEventSourceInput)
    pub fn builder() -> crate::input::activate_event_source_input::Builder {
        crate::input::activate_event_source_input::Builder::default()
    }
    /// Creates a new `ActivateEventSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ActivateEventSource {
    type Output = std::result::Result<
        crate::output::ActivateEventSourceOutput,
        crate::error::ActivateEventSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_activate_event_source_error(response)
        } else {
            crate::operation_deser::parse_activate_event_source_response(response)
        }
    }
}

/// Operation shape for `CancelReplay`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_replay`](crate::client::Client::cancel_replay).
///
/// See [`crate::client::fluent_builders::CancelReplay`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelReplay {
    _private: (),
}
impl CancelReplay {
    /// Creates a new builder-style object to manufacture [`CancelReplayInput`](crate::input::CancelReplayInput)
    pub fn builder() -> crate::input::cancel_replay_input::Builder {
        crate::input::cancel_replay_input::Builder::default()
    }
    /// Creates a new `CancelReplay` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelReplay {
    type Output =
        std::result::Result<crate::output::CancelReplayOutput, crate::error::CancelReplayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_replay_error(response)
        } else {
            crate::operation_deser::parse_cancel_replay_response(response)
        }
    }
}

/// Operation shape for `CreateApiDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_api_destination`](crate::client::Client::create_api_destination).
///
/// See [`crate::client::fluent_builders::CreateApiDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApiDestination {
    _private: (),
}
impl CreateApiDestination {
    /// Creates a new builder-style object to manufacture [`CreateApiDestinationInput`](crate::input::CreateApiDestinationInput)
    pub fn builder() -> crate::input::create_api_destination_input::Builder {
        crate::input::create_api_destination_input::Builder::default()
    }
    /// Creates a new `CreateApiDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApiDestination {
    type Output = std::result::Result<
        crate::output::CreateApiDestinationOutput,
        crate::error::CreateApiDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_api_destination_error(response)
        } else {
            crate::operation_deser::parse_create_api_destination_response(response)
        }
    }
}

/// Operation shape for `CreateArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_archive`](crate::client::Client::create_archive).
///
/// See [`crate::client::fluent_builders::CreateArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateArchive {
    _private: (),
}
impl CreateArchive {
    /// Creates a new builder-style object to manufacture [`CreateArchiveInput`](crate::input::CreateArchiveInput)
    pub fn builder() -> crate::input::create_archive_input::Builder {
        crate::input::create_archive_input::Builder::default()
    }
    /// Creates a new `CreateArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateArchive {
    type Output =
        std::result::Result<crate::output::CreateArchiveOutput, crate::error::CreateArchiveError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_archive_error(response)
        } else {
            crate::operation_deser::parse_create_archive_response(response)
        }
    }
}

/// Operation shape for `CreateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connection`](crate::client::Client::create_connection).
///
/// See [`crate::client::fluent_builders::CreateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnection {
    _private: (),
}
impl CreateConnection {
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
    /// Creates a new `CreateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnection {
    type Output = std::result::Result<
        crate::output::CreateConnectionOutput,
        crate::error::CreateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connection_error(response)
        } else {
            crate::operation_deser::parse_create_connection_response(response)
        }
    }
}

/// Operation shape for `CreateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_endpoint`](crate::client::Client::create_endpoint).
///
/// See [`crate::client::fluent_builders::CreateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEndpoint {
    _private: (),
}
impl CreateEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    pub fn builder() -> crate::input::create_endpoint_input::Builder {
        crate::input::create_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEndpoint {
    type Output =
        std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateEventBus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_bus`](crate::client::Client::create_event_bus).
///
/// See [`crate::client::fluent_builders::CreateEventBus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventBus {
    _private: (),
}
impl CreateEventBus {
    /// Creates a new builder-style object to manufacture [`CreateEventBusInput`](crate::input::CreateEventBusInput)
    pub fn builder() -> crate::input::create_event_bus_input::Builder {
        crate::input::create_event_bus_input::Builder::default()
    }
    /// Creates a new `CreateEventBus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventBus {
    type Output =
        std::result::Result<crate::output::CreateEventBusOutput, crate::error::CreateEventBusError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_event_bus_error(response)
        } else {
            crate::operation_deser::parse_create_event_bus_response(response)
        }
    }
}

/// Operation shape for `CreatePartnerEventSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_partner_event_source`](crate::client::Client::create_partner_event_source).
///
/// See [`crate::client::fluent_builders::CreatePartnerEventSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePartnerEventSource {
    _private: (),
}
impl CreatePartnerEventSource {
    /// Creates a new builder-style object to manufacture [`CreatePartnerEventSourceInput`](crate::input::CreatePartnerEventSourceInput)
    pub fn builder() -> crate::input::create_partner_event_source_input::Builder {
        crate::input::create_partner_event_source_input::Builder::default()
    }
    /// Creates a new `CreatePartnerEventSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePartnerEventSource {
    type Output = std::result::Result<
        crate::output::CreatePartnerEventSourceOutput,
        crate::error::CreatePartnerEventSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_partner_event_source_error(response)
        } else {
            crate::operation_deser::parse_create_partner_event_source_response(response)
        }
    }
}

/// Operation shape for `DeactivateEventSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deactivate_event_source`](crate::client::Client::deactivate_event_source).
///
/// See [`crate::client::fluent_builders::DeactivateEventSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeactivateEventSource {
    _private: (),
}
impl DeactivateEventSource {
    /// Creates a new builder-style object to manufacture [`DeactivateEventSourceInput`](crate::input::DeactivateEventSourceInput)
    pub fn builder() -> crate::input::deactivate_event_source_input::Builder {
        crate::input::deactivate_event_source_input::Builder::default()
    }
    /// Creates a new `DeactivateEventSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeactivateEventSource {
    type Output = std::result::Result<
        crate::output::DeactivateEventSourceOutput,
        crate::error::DeactivateEventSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deactivate_event_source_error(response)
        } else {
            crate::operation_deser::parse_deactivate_event_source_response(response)
        }
    }
}

/// Operation shape for `DeauthorizeConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deauthorize_connection`](crate::client::Client::deauthorize_connection).
///
/// See [`crate::client::fluent_builders::DeauthorizeConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeauthorizeConnection {
    _private: (),
}
impl DeauthorizeConnection {
    /// Creates a new builder-style object to manufacture [`DeauthorizeConnectionInput`](crate::input::DeauthorizeConnectionInput)
    pub fn builder() -> crate::input::deauthorize_connection_input::Builder {
        crate::input::deauthorize_connection_input::Builder::default()
    }
    /// Creates a new `DeauthorizeConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeauthorizeConnection {
    type Output = std::result::Result<
        crate::output::DeauthorizeConnectionOutput,
        crate::error::DeauthorizeConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deauthorize_connection_error(response)
        } else {
            crate::operation_deser::parse_deauthorize_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteApiDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_api_destination`](crate::client::Client::delete_api_destination).
///
/// See [`crate::client::fluent_builders::DeleteApiDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApiDestination {
    _private: (),
}
impl DeleteApiDestination {
    /// Creates a new builder-style object to manufacture [`DeleteApiDestinationInput`](crate::input::DeleteApiDestinationInput)
    pub fn builder() -> crate::input::delete_api_destination_input::Builder {
        crate::input::delete_api_destination_input::Builder::default()
    }
    /// Creates a new `DeleteApiDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApiDestination {
    type Output = std::result::Result<
        crate::output::DeleteApiDestinationOutput,
        crate::error::DeleteApiDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_api_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_api_destination_response(response)
        }
    }
}

/// Operation shape for `DeleteArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_archive`](crate::client::Client::delete_archive).
///
/// See [`crate::client::fluent_builders::DeleteArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteArchive {
    _private: (),
}
impl DeleteArchive {
    /// Creates a new builder-style object to manufacture [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
    pub fn builder() -> crate::input::delete_archive_input::Builder {
        crate::input::delete_archive_input::Builder::default()
    }
    /// Creates a new `DeleteArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteArchive {
    type Output =
        std::result::Result<crate::output::DeleteArchiveOutput, crate::error::DeleteArchiveError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_archive_error(response)
        } else {
            crate::operation_deser::parse_delete_archive_response(response)
        }
    }
}

/// Operation shape for `DeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection`](crate::client::Client::delete_connection).
///
/// See [`crate::client::fluent_builders::DeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnection {
    _private: (),
}
impl DeleteConnection {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
    /// Creates a new `DeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnection {
    type Output = std::result::Result<
        crate::output::DeleteConnectionOutput,
        crate::error::DeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint`](crate::client::Client::delete_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpoint {
    _private: (),
}
impl DeleteEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpoint {
    type Output =
        std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteEventBus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_bus`](crate::client::Client::delete_event_bus).
///
/// See [`crate::client::fluent_builders::DeleteEventBus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventBus {
    _private: (),
}
impl DeleteEventBus {
    /// Creates a new builder-style object to manufacture [`DeleteEventBusInput`](crate::input::DeleteEventBusInput)
    pub fn builder() -> crate::input::delete_event_bus_input::Builder {
        crate::input::delete_event_bus_input::Builder::default()
    }
    /// Creates a new `DeleteEventBus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventBus {
    type Output =
        std::result::Result<crate::output::DeleteEventBusOutput, crate::error::DeleteEventBusError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_bus_error(response)
        } else {
            crate::operation_deser::parse_delete_event_bus_response(response)
        }
    }
}

/// Operation shape for `DeletePartnerEventSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_partner_event_source`](crate::client::Client::delete_partner_event_source).
///
/// See [`crate::client::fluent_builders::DeletePartnerEventSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePartnerEventSource {
    _private: (),
}
impl DeletePartnerEventSource {
    /// Creates a new builder-style object to manufacture [`DeletePartnerEventSourceInput`](crate::input::DeletePartnerEventSourceInput)
    pub fn builder() -> crate::input::delete_partner_event_source_input::Builder {
        crate::input::delete_partner_event_source_input::Builder::default()
    }
    /// Creates a new `DeletePartnerEventSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePartnerEventSource {
    type Output = std::result::Result<
        crate::output::DeletePartnerEventSourceOutput,
        crate::error::DeletePartnerEventSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_partner_event_source_error(response)
        } else {
            crate::operation_deser::parse_delete_partner_event_source_response(response)
        }
    }
}

/// Operation shape for `DeleteRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rule`](crate::client::Client::delete_rule).
///
/// See [`crate::client::fluent_builders::DeleteRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRule {
    _private: (),
}
impl DeleteRule {
    /// Creates a new builder-style object to manufacture [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    pub fn builder() -> crate::input::delete_rule_input::Builder {
        crate::input::delete_rule_input::Builder::default()
    }
    /// Creates a new `DeleteRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRule {
    type Output =
        std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_rule_response(response)
        }
    }
}

/// Operation shape for `DescribeApiDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_api_destination`](crate::client::Client::describe_api_destination).
///
/// See [`crate::client::fluent_builders::DescribeApiDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApiDestination {
    _private: (),
}
impl DescribeApiDestination {
    /// Creates a new builder-style object to manufacture [`DescribeApiDestinationInput`](crate::input::DescribeApiDestinationInput)
    pub fn builder() -> crate::input::describe_api_destination_input::Builder {
        crate::input::describe_api_destination_input::Builder::default()
    }
    /// Creates a new `DescribeApiDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApiDestination {
    type Output = std::result::Result<
        crate::output::DescribeApiDestinationOutput,
        crate::error::DescribeApiDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_api_destination_error(response)
        } else {
            crate::operation_deser::parse_describe_api_destination_response(response)
        }
    }
}

/// Operation shape for `DescribeArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_archive`](crate::client::Client::describe_archive).
///
/// See [`crate::client::fluent_builders::DescribeArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeArchive {
    _private: (),
}
impl DescribeArchive {
    /// Creates a new builder-style object to manufacture [`DescribeArchiveInput`](crate::input::DescribeArchiveInput)
    pub fn builder() -> crate::input::describe_archive_input::Builder {
        crate::input::describe_archive_input::Builder::default()
    }
    /// Creates a new `DescribeArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeArchive {
    type Output = std::result::Result<
        crate::output::DescribeArchiveOutput,
        crate::error::DescribeArchiveError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_archive_error(response)
        } else {
            crate::operation_deser::parse_describe_archive_response(response)
        }
    }
}

/// Operation shape for `DescribeConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_connection`](crate::client::Client::describe_connection).
///
/// See [`crate::client::fluent_builders::DescribeConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConnection {
    _private: (),
}
impl DescribeConnection {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionInput`](crate::input::DescribeConnectionInput)
    pub fn builder() -> crate::input::describe_connection_input::Builder {
        crate::input::describe_connection_input::Builder::default()
    }
    /// Creates a new `DescribeConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConnection {
    type Output = std::result::Result<
        crate::output::DescribeConnectionOutput,
        crate::error::DescribeConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_connection_error(response)
        } else {
            crate::operation_deser::parse_describe_connection_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint`](crate::client::Client::describe_endpoint).
///
/// See [`crate::client::fluent_builders::DescribeEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpoint {
    _private: (),
}
impl DescribeEndpoint {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    pub fn builder() -> crate::input::describe_endpoint_input::Builder {
        crate::input::describe_endpoint_input::Builder::default()
    }
    /// Creates a new `DescribeEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpoint {
    type Output = std::result::Result<
        crate::output::DescribeEndpointOutput,
        crate::error::DescribeEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_response(response)
        }
    }
}

/// Operation shape for `DescribeEventBus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_bus`](crate::client::Client::describe_event_bus).
///
/// See [`crate::client::fluent_builders::DescribeEventBus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventBus {
    _private: (),
}
impl DescribeEventBus {
    /// Creates a new builder-style object to manufacture [`DescribeEventBusInput`](crate::input::DescribeEventBusInput)
    pub fn builder() -> crate::input::describe_event_bus_input::Builder {
        crate::input::describe_event_bus_input::Builder::default()
    }
    /// Creates a new `DescribeEventBus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventBus {
    type Output = std::result::Result<
        crate::output::DescribeEventBusOutput,
        crate::error::DescribeEventBusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_bus_error(response)
        } else {
            crate::operation_deser::parse_describe_event_bus_response(response)
        }
    }
}

/// Operation shape for `DescribeEventSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_source`](crate::client::Client::describe_event_source).
///
/// See [`crate::client::fluent_builders::DescribeEventSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventSource {
    _private: (),
}
impl DescribeEventSource {
    /// Creates a new builder-style object to manufacture [`DescribeEventSourceInput`](crate::input::DescribeEventSourceInput)
    pub fn builder() -> crate::input::describe_event_source_input::Builder {
        crate::input::describe_event_source_input::Builder::default()
    }
    /// Creates a new `DescribeEventSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventSource {
    type Output = std::result::Result<
        crate::output::DescribeEventSourceOutput,
        crate::error::DescribeEventSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_source_error(response)
        } else {
            crate::operation_deser::parse_describe_event_source_response(response)
        }
    }
}

/// Operation shape for `DescribePartnerEventSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_partner_event_source`](crate::client::Client::describe_partner_event_source).
///
/// See [`crate::client::fluent_builders::DescribePartnerEventSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePartnerEventSource {
    _private: (),
}
impl DescribePartnerEventSource {
    /// Creates a new builder-style object to manufacture [`DescribePartnerEventSourceInput`](crate::input::DescribePartnerEventSourceInput)
    pub fn builder() -> crate::input::describe_partner_event_source_input::Builder {
        crate::input::describe_partner_event_source_input::Builder::default()
    }
    /// Creates a new `DescribePartnerEventSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePartnerEventSource {
    type Output = std::result::Result<
        crate::output::DescribePartnerEventSourceOutput,
        crate::error::DescribePartnerEventSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_partner_event_source_error(response)
        } else {
            crate::operation_deser::parse_describe_partner_event_source_response(response)
        }
    }
}

/// Operation shape for `DescribeReplay`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replay`](crate::client::Client::describe_replay).
///
/// See [`crate::client::fluent_builders::DescribeReplay`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplay {
    _private: (),
}
impl DescribeReplay {
    /// Creates a new builder-style object to manufacture [`DescribeReplayInput`](crate::input::DescribeReplayInput)
    pub fn builder() -> crate::input::describe_replay_input::Builder {
        crate::input::describe_replay_input::Builder::default()
    }
    /// Creates a new `DescribeReplay` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplay {
    type Output =
        std::result::Result<crate::output::DescribeReplayOutput, crate::error::DescribeReplayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replay_error(response)
        } else {
            crate::operation_deser::parse_describe_replay_response(response)
        }
    }
}

/// Operation shape for `DescribeRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_rule`](crate::client::Client::describe_rule).
///
/// See [`crate::client::fluent_builders::DescribeRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRule {
    _private: (),
}
impl DescribeRule {
    /// Creates a new builder-style object to manufacture [`DescribeRuleInput`](crate::input::DescribeRuleInput)
    pub fn builder() -> crate::input::describe_rule_input::Builder {
        crate::input::describe_rule_input::Builder::default()
    }
    /// Creates a new `DescribeRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRule {
    type Output =
        std::result::Result<crate::output::DescribeRuleOutput, crate::error::DescribeRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_rule_error(response)
        } else {
            crate::operation_deser::parse_describe_rule_response(response)
        }
    }
}

/// Operation shape for `DisableRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_rule`](crate::client::Client::disable_rule).
///
/// See [`crate::client::fluent_builders::DisableRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableRule {
    _private: (),
}
impl DisableRule {
    /// Creates a new builder-style object to manufacture [`DisableRuleInput`](crate::input::DisableRuleInput)
    pub fn builder() -> crate::input::disable_rule_input::Builder {
        crate::input::disable_rule_input::Builder::default()
    }
    /// Creates a new `DisableRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableRule {
    type Output =
        std::result::Result<crate::output::DisableRuleOutput, crate::error::DisableRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_rule_error(response)
        } else {
            crate::operation_deser::parse_disable_rule_response(response)
        }
    }
}

/// Operation shape for `EnableRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_rule`](crate::client::Client::enable_rule).
///
/// See [`crate::client::fluent_builders::EnableRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableRule {
    _private: (),
}
impl EnableRule {
    /// Creates a new builder-style object to manufacture [`EnableRuleInput`](crate::input::EnableRuleInput)
    pub fn builder() -> crate::input::enable_rule_input::Builder {
        crate::input::enable_rule_input::Builder::default()
    }
    /// Creates a new `EnableRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableRule {
    type Output =
        std::result::Result<crate::output::EnableRuleOutput, crate::error::EnableRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_rule_error(response)
        } else {
            crate::operation_deser::parse_enable_rule_response(response)
        }
    }
}

/// Operation shape for `ListApiDestinations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_api_destinations`](crate::client::Client::list_api_destinations).
///
/// See [`crate::client::fluent_builders::ListApiDestinations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApiDestinations {
    _private: (),
}
impl ListApiDestinations {
    /// Creates a new builder-style object to manufacture [`ListApiDestinationsInput`](crate::input::ListApiDestinationsInput)
    pub fn builder() -> crate::input::list_api_destinations_input::Builder {
        crate::input::list_api_destinations_input::Builder::default()
    }
    /// Creates a new `ListApiDestinations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApiDestinations {
    type Output = std::result::Result<
        crate::output::ListApiDestinationsOutput,
        crate::error::ListApiDestinationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_api_destinations_error(response)
        } else {
            crate::operation_deser::parse_list_api_destinations_response(response)
        }
    }
}

/// Operation shape for `ListArchives`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_archives`](crate::client::Client::list_archives).
///
/// See [`crate::client::fluent_builders::ListArchives`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListArchives {
    _private: (),
}
impl ListArchives {
    /// Creates a new builder-style object to manufacture [`ListArchivesInput`](crate::input::ListArchivesInput)
    pub fn builder() -> crate::input::list_archives_input::Builder {
        crate::input::list_archives_input::Builder::default()
    }
    /// Creates a new `ListArchives` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListArchives {
    type Output =
        std::result::Result<crate::output::ListArchivesOutput, crate::error::ListArchivesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_archives_error(response)
        } else {
            crate::operation_deser::parse_list_archives_response(response)
        }
    }
}

/// Operation shape for `ListConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_connections`](crate::client::Client::list_connections).
///
/// See [`crate::client::fluent_builders::ListConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConnections {
    _private: (),
}
impl ListConnections {
    /// Creates a new builder-style object to manufacture [`ListConnectionsInput`](crate::input::ListConnectionsInput)
    pub fn builder() -> crate::input::list_connections_input::Builder {
        crate::input::list_connections_input::Builder::default()
    }
    /// Creates a new `ListConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConnections {
    type Output = std::result::Result<
        crate::output::ListConnectionsOutput,
        crate::error::ListConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_connections_error(response)
        } else {
            crate::operation_deser::parse_list_connections_response(response)
        }
    }
}

/// Operation shape for `ListEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_endpoints`](crate::client::Client::list_endpoints).
///
/// See [`crate::client::fluent_builders::ListEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEndpoints {
    _private: (),
}
impl ListEndpoints {
    /// Creates a new builder-style object to manufacture [`ListEndpointsInput`](crate::input::ListEndpointsInput)
    pub fn builder() -> crate::input::list_endpoints_input::Builder {
        crate::input::list_endpoints_input::Builder::default()
    }
    /// Creates a new `ListEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEndpoints {
    type Output =
        std::result::Result<crate::output::ListEndpointsOutput, crate::error::ListEndpointsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_endpoints_error(response)
        } else {
            crate::operation_deser::parse_list_endpoints_response(response)
        }
    }
}

/// Operation shape for `ListEventBuses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_event_buses`](crate::client::Client::list_event_buses).
///
/// See [`crate::client::fluent_builders::ListEventBuses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEventBuses {
    _private: (),
}
impl ListEventBuses {
    /// Creates a new builder-style object to manufacture [`ListEventBusesInput`](crate::input::ListEventBusesInput)
    pub fn builder() -> crate::input::list_event_buses_input::Builder {
        crate::input::list_event_buses_input::Builder::default()
    }
    /// Creates a new `ListEventBuses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEventBuses {
    type Output =
        std::result::Result<crate::output::ListEventBusesOutput, crate::error::ListEventBusesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_event_buses_error(response)
        } else {
            crate::operation_deser::parse_list_event_buses_response(response)
        }
    }
}

/// Operation shape for `ListEventSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_event_sources`](crate::client::Client::list_event_sources).
///
/// See [`crate::client::fluent_builders::ListEventSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEventSources {
    _private: (),
}
impl ListEventSources {
    /// Creates a new builder-style object to manufacture [`ListEventSourcesInput`](crate::input::ListEventSourcesInput)
    pub fn builder() -> crate::input::list_event_sources_input::Builder {
        crate::input::list_event_sources_input::Builder::default()
    }
    /// Creates a new `ListEventSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEventSources {
    type Output = std::result::Result<
        crate::output::ListEventSourcesOutput,
        crate::error::ListEventSourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_event_sources_error(response)
        } else {
            crate::operation_deser::parse_list_event_sources_response(response)
        }
    }
}

/// Operation shape for `ListPartnerEventSourceAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_partner_event_source_accounts`](crate::client::Client::list_partner_event_source_accounts).
///
/// See [`crate::client::fluent_builders::ListPartnerEventSourceAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPartnerEventSourceAccounts {
    _private: (),
}
impl ListPartnerEventSourceAccounts {
    /// Creates a new builder-style object to manufacture [`ListPartnerEventSourceAccountsInput`](crate::input::ListPartnerEventSourceAccountsInput)
    pub fn builder() -> crate::input::list_partner_event_source_accounts_input::Builder {
        crate::input::list_partner_event_source_accounts_input::Builder::default()
    }
    /// Creates a new `ListPartnerEventSourceAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPartnerEventSourceAccounts {
    type Output = std::result::Result<
        crate::output::ListPartnerEventSourceAccountsOutput,
        crate::error::ListPartnerEventSourceAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_partner_event_source_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_partner_event_source_accounts_response(response)
        }
    }
}

/// Operation shape for `ListPartnerEventSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_partner_event_sources`](crate::client::Client::list_partner_event_sources).
///
/// See [`crate::client::fluent_builders::ListPartnerEventSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPartnerEventSources {
    _private: (),
}
impl ListPartnerEventSources {
    /// Creates a new builder-style object to manufacture [`ListPartnerEventSourcesInput`](crate::input::ListPartnerEventSourcesInput)
    pub fn builder() -> crate::input::list_partner_event_sources_input::Builder {
        crate::input::list_partner_event_sources_input::Builder::default()
    }
    /// Creates a new `ListPartnerEventSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPartnerEventSources {
    type Output = std::result::Result<
        crate::output::ListPartnerEventSourcesOutput,
        crate::error::ListPartnerEventSourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_partner_event_sources_error(response)
        } else {
            crate::operation_deser::parse_list_partner_event_sources_response(response)
        }
    }
}

/// Operation shape for `ListReplays`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_replays`](crate::client::Client::list_replays).
///
/// See [`crate::client::fluent_builders::ListReplays`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReplays {
    _private: (),
}
impl ListReplays {
    /// Creates a new builder-style object to manufacture [`ListReplaysInput`](crate::input::ListReplaysInput)
    pub fn builder() -> crate::input::list_replays_input::Builder {
        crate::input::list_replays_input::Builder::default()
    }
    /// Creates a new `ListReplays` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReplays {
    type Output =
        std::result::Result<crate::output::ListReplaysOutput, crate::error::ListReplaysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_replays_error(response)
        } else {
            crate::operation_deser::parse_list_replays_response(response)
        }
    }
}

/// Operation shape for `ListRuleNamesByTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rule_names_by_target`](crate::client::Client::list_rule_names_by_target).
///
/// See [`crate::client::fluent_builders::ListRuleNamesByTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRuleNamesByTarget {
    _private: (),
}
impl ListRuleNamesByTarget {
    /// Creates a new builder-style object to manufacture [`ListRuleNamesByTargetInput`](crate::input::ListRuleNamesByTargetInput)
    pub fn builder() -> crate::input::list_rule_names_by_target_input::Builder {
        crate::input::list_rule_names_by_target_input::Builder::default()
    }
    /// Creates a new `ListRuleNamesByTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRuleNamesByTarget {
    type Output = std::result::Result<
        crate::output::ListRuleNamesByTargetOutput,
        crate::error::ListRuleNamesByTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rule_names_by_target_error(response)
        } else {
            crate::operation_deser::parse_list_rule_names_by_target_response(response)
        }
    }
}

/// Operation shape for `ListRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rules`](crate::client::Client::list_rules).
///
/// See [`crate::client::fluent_builders::ListRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRules {
    _private: (),
}
impl ListRules {
    /// Creates a new builder-style object to manufacture [`ListRulesInput`](crate::input::ListRulesInput)
    pub fn builder() -> crate::input::list_rules_input::Builder {
        crate::input::list_rules_input::Builder::default()
    }
    /// Creates a new `ListRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRules {
    type Output = std::result::Result<crate::output::ListRulesOutput, crate::error::ListRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rules_error(response)
        } else {
            crate::operation_deser::parse_list_rules_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTargetsByRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_targets_by_rule`](crate::client::Client::list_targets_by_rule).
///
/// See [`crate::client::fluent_builders::ListTargetsByRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTargetsByRule {
    _private: (),
}
impl ListTargetsByRule {
    /// Creates a new builder-style object to manufacture [`ListTargetsByRuleInput`](crate::input::ListTargetsByRuleInput)
    pub fn builder() -> crate::input::list_targets_by_rule_input::Builder {
        crate::input::list_targets_by_rule_input::Builder::default()
    }
    /// Creates a new `ListTargetsByRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTargetsByRule {
    type Output = std::result::Result<
        crate::output::ListTargetsByRuleOutput,
        crate::error::ListTargetsByRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_targets_by_rule_error(response)
        } else {
            crate::operation_deser::parse_list_targets_by_rule_response(response)
        }
    }
}

/// Operation shape for `PutEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_events`](crate::client::Client::put_events).
///
/// See [`crate::client::fluent_builders::PutEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEvents {
    _private: (),
}
impl PutEvents {
    /// Creates a new builder-style object to manufacture [`PutEventsInput`](crate::input::PutEventsInput)
    pub fn builder() -> crate::input::put_events_input::Builder {
        crate::input::put_events_input::Builder::default()
    }
    /// Creates a new `PutEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEvents {
    type Output = std::result::Result<crate::output::PutEventsOutput, crate::error::PutEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_events_error(response)
        } else {
            crate::operation_deser::parse_put_events_response(response)
        }
    }
}

/// Operation shape for `PutPartnerEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_partner_events`](crate::client::Client::put_partner_events).
///
/// See [`crate::client::fluent_builders::PutPartnerEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPartnerEvents {
    _private: (),
}
impl PutPartnerEvents {
    /// Creates a new builder-style object to manufacture [`PutPartnerEventsInput`](crate::input::PutPartnerEventsInput)
    pub fn builder() -> crate::input::put_partner_events_input::Builder {
        crate::input::put_partner_events_input::Builder::default()
    }
    /// Creates a new `PutPartnerEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPartnerEvents {
    type Output = std::result::Result<
        crate::output::PutPartnerEventsOutput,
        crate::error::PutPartnerEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_partner_events_error(response)
        } else {
            crate::operation_deser::parse_put_partner_events_response(response)
        }
    }
}

/// Operation shape for `PutPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_permission`](crate::client::Client::put_permission).
///
/// See [`crate::client::fluent_builders::PutPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPermission {
    _private: (),
}
impl PutPermission {
    /// Creates a new builder-style object to manufacture [`PutPermissionInput`](crate::input::PutPermissionInput)
    pub fn builder() -> crate::input::put_permission_input::Builder {
        crate::input::put_permission_input::Builder::default()
    }
    /// Creates a new `PutPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPermission {
    type Output =
        std::result::Result<crate::output::PutPermissionOutput, crate::error::PutPermissionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_permission_error(response)
        } else {
            crate::operation_deser::parse_put_permission_response(response)
        }
    }
}

/// Operation shape for `PutRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_rule`](crate::client::Client::put_rule).
///
/// See [`crate::client::fluent_builders::PutRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRule {
    _private: (),
}
impl PutRule {
    /// Creates a new builder-style object to manufacture [`PutRuleInput`](crate::input::PutRuleInput)
    pub fn builder() -> crate::input::put_rule_input::Builder {
        crate::input::put_rule_input::Builder::default()
    }
    /// Creates a new `PutRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRule {
    type Output = std::result::Result<crate::output::PutRuleOutput, crate::error::PutRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_rule_error(response)
        } else {
            crate::operation_deser::parse_put_rule_response(response)
        }
    }
}

/// Operation shape for `PutTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_targets`](crate::client::Client::put_targets).
///
/// See [`crate::client::fluent_builders::PutTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutTargets {
    _private: (),
}
impl PutTargets {
    /// Creates a new builder-style object to manufacture [`PutTargetsInput`](crate::input::PutTargetsInput)
    pub fn builder() -> crate::input::put_targets_input::Builder {
        crate::input::put_targets_input::Builder::default()
    }
    /// Creates a new `PutTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutTargets {
    type Output =
        std::result::Result<crate::output::PutTargetsOutput, crate::error::PutTargetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_targets_error(response)
        } else {
            crate::operation_deser::parse_put_targets_response(response)
        }
    }
}

/// Operation shape for `RemovePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_permission`](crate::client::Client::remove_permission).
///
/// See [`crate::client::fluent_builders::RemovePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemovePermission {
    _private: (),
}
impl RemovePermission {
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
    /// Creates a new `RemovePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemovePermission {
    type Output = std::result::Result<
        crate::output::RemovePermissionOutput,
        crate::error::RemovePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_permission_error(response)
        } else {
            crate::operation_deser::parse_remove_permission_response(response)
        }
    }
}

/// Operation shape for `RemoveTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_targets`](crate::client::Client::remove_targets).
///
/// See [`crate::client::fluent_builders::RemoveTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTargets {
    _private: (),
}
impl RemoveTargets {
    /// Creates a new builder-style object to manufacture [`RemoveTargetsInput`](crate::input::RemoveTargetsInput)
    pub fn builder() -> crate::input::remove_targets_input::Builder {
        crate::input::remove_targets_input::Builder::default()
    }
    /// Creates a new `RemoveTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTargets {
    type Output =
        std::result::Result<crate::output::RemoveTargetsOutput, crate::error::RemoveTargetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_targets_error(response)
        } else {
            crate::operation_deser::parse_remove_targets_response(response)
        }
    }
}

/// Operation shape for `StartReplay`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_replay`](crate::client::Client::start_replay).
///
/// See [`crate::client::fluent_builders::StartReplay`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartReplay {
    _private: (),
}
impl StartReplay {
    /// Creates a new builder-style object to manufacture [`StartReplayInput`](crate::input::StartReplayInput)
    pub fn builder() -> crate::input::start_replay_input::Builder {
        crate::input::start_replay_input::Builder::default()
    }
    /// Creates a new `StartReplay` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartReplay {
    type Output =
        std::result::Result<crate::output::StartReplayOutput, crate::error::StartReplayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_replay_error(response)
        } else {
            crate::operation_deser::parse_start_replay_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestEventPattern`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_event_pattern`](crate::client::Client::test_event_pattern).
///
/// See [`crate::client::fluent_builders::TestEventPattern`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestEventPattern {
    _private: (),
}
impl TestEventPattern {
    /// Creates a new builder-style object to manufacture [`TestEventPatternInput`](crate::input::TestEventPatternInput)
    pub fn builder() -> crate::input::test_event_pattern_input::Builder {
        crate::input::test_event_pattern_input::Builder::default()
    }
    /// Creates a new `TestEventPattern` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestEventPattern {
    type Output = std::result::Result<
        crate::output::TestEventPatternOutput,
        crate::error::TestEventPatternError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_event_pattern_error(response)
        } else {
            crate::operation_deser::parse_test_event_pattern_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApiDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_api_destination`](crate::client::Client::update_api_destination).
///
/// See [`crate::client::fluent_builders::UpdateApiDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApiDestination {
    _private: (),
}
impl UpdateApiDestination {
    /// Creates a new builder-style object to manufacture [`UpdateApiDestinationInput`](crate::input::UpdateApiDestinationInput)
    pub fn builder() -> crate::input::update_api_destination_input::Builder {
        crate::input::update_api_destination_input::Builder::default()
    }
    /// Creates a new `UpdateApiDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApiDestination {
    type Output = std::result::Result<
        crate::output::UpdateApiDestinationOutput,
        crate::error::UpdateApiDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_api_destination_error(response)
        } else {
            crate::operation_deser::parse_update_api_destination_response(response)
        }
    }
}

/// Operation shape for `UpdateArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_archive`](crate::client::Client::update_archive).
///
/// See [`crate::client::fluent_builders::UpdateArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateArchive {
    _private: (),
}
impl UpdateArchive {
    /// Creates a new builder-style object to manufacture [`UpdateArchiveInput`](crate::input::UpdateArchiveInput)
    pub fn builder() -> crate::input::update_archive_input::Builder {
        crate::input::update_archive_input::Builder::default()
    }
    /// Creates a new `UpdateArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateArchive {
    type Output =
        std::result::Result<crate::output::UpdateArchiveOutput, crate::error::UpdateArchiveError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_archive_error(response)
        } else {
            crate::operation_deser::parse_update_archive_response(response)
        }
    }
}

/// Operation shape for `UpdateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connection`](crate::client::Client::update_connection).
///
/// See [`crate::client::fluent_builders::UpdateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnection {
    _private: (),
}
impl UpdateConnection {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    pub fn builder() -> crate::input::update_connection_input::Builder {
        crate::input::update_connection_input::Builder::default()
    }
    /// Creates a new `UpdateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnection {
    type Output = std::result::Result<
        crate::output::UpdateConnectionOutput,
        crate::error::UpdateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connection_error(response)
        } else {
            crate::operation_deser::parse_update_connection_response(response)
        }
    }
}

/// Operation shape for `UpdateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_endpoint`](crate::client::Client::update_endpoint).
///
/// See [`crate::client::fluent_builders::UpdateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEndpoint {
    _private: (),
}
impl UpdateEndpoint {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    pub fn builder() -> crate::input::update_endpoint_input::Builder {
        crate::input::update_endpoint_input::Builder::default()
    }
    /// Creates a new `UpdateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEndpoint {
    type Output =
        std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_endpoint_error(response)
        } else {
            crate::operation_deser::parse_update_endpoint_response(response)
        }
    }
}
