// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionOutput {
    /// <p>The ARN of the connection that was updated.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The state of the connection that was updated.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>A time stamp for the time that the connection was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last authorized.</p>
    pub last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
}
impl UpdateConnectionOutput {
    /// <p>The ARN of the connection that was updated.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The state of the connection that was updated.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>A time stamp for the time that the connection was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last authorized.</p>
    pub fn last_authorized_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_authorized_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionOutput");
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_authorized_time", &self.last_authorized_time);
        formatter.finish()
    }
}
/// See [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
pub mod update_connection_output {
    /// A builder for [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the connection that was updated.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection that was updated.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The state of the connection that was updated.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection that was updated.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn last_authorized_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authorized_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn set_last_authorized_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authorized_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
        pub fn build(self) -> crate::output::UpdateConnectionOutput {
            crate::output::UpdateConnectionOutput {
                connection_arn: self.connection_arn,
                connection_state: self.connection_state,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_authorized_time: self.last_authorized_time,
            }
        }
    }
}
impl UpdateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    pub fn builder() -> crate::output::update_connection_output::Builder {
        crate::output::update_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateArchiveOutput {
    /// <p>The ARN of the archive.</p>
    pub archive_arn: std::option::Option<std::string::String>,
    /// <p>The state of the archive.</p>
    pub state: std::option::Option<crate::model::ArchiveState>,
    /// <p>The reason that the archive is in the current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The time at which the archive was updated.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl UpdateArchiveOutput {
    /// <p>The ARN of the archive.</p>
    pub fn archive_arn(&self) -> std::option::Option<&str> {
        self.archive_arn.as_deref()
    }
    /// <p>The state of the archive.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ArchiveState> {
        self.state.as_ref()
    }
    /// <p>The reason that the archive is in the current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The time at which the archive was updated.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateArchiveOutput");
        formatter.field("archive_arn", &self.archive_arn);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`UpdateArchiveOutput`](crate::output::UpdateArchiveOutput)
pub mod update_archive_output {
    /// A builder for [`UpdateArchiveOutput`](crate::output::UpdateArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ArchiveState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the archive.</p>
        pub fn archive_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the archive.</p>
        pub fn set_archive_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_arn = input;
            self
        }
        /// <p>The state of the archive.</p>
        pub fn state(mut self, input: crate::model::ArchiveState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the archive.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ArchiveState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason that the archive is in the current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the archive is in the current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The time at which the archive was updated.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the archive was updated.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateArchiveOutput`](crate::output::UpdateArchiveOutput)
        pub fn build(self) -> crate::output::UpdateArchiveOutput {
            crate::output::UpdateArchiveOutput {
                archive_arn: self.archive_arn,
                state: self.state,
                state_reason: self.state_reason,
                creation_time: self.creation_time,
            }
        }
    }
}
impl UpdateArchiveOutput {
    /// Creates a new builder-style object to manufacture [`UpdateArchiveOutput`](crate::output::UpdateArchiveOutput)
    pub fn builder() -> crate::output::update_archive_output::Builder {
        crate::output::update_archive_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiDestinationOutput {
    /// <p>The ARN of the API destination that was updated.</p>
    pub api_destination_arn: std::option::Option<std::string::String>,
    /// <p>The state of the API destination that was updated.</p>
    pub api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
    /// <p>A time stamp for the time that the API destination was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the API destination was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl UpdateApiDestinationOutput {
    /// <p>The ARN of the API destination that was updated.</p>
    pub fn api_destination_arn(&self) -> std::option::Option<&str> {
        self.api_destination_arn.as_deref()
    }
    /// <p>The state of the API destination that was updated.</p>
    pub fn api_destination_state(&self) -> std::option::Option<&crate::model::ApiDestinationState> {
        self.api_destination_state.as_ref()
    }
    /// <p>A time stamp for the time that the API destination was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp for the time that the API destination was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateApiDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiDestinationOutput");
        formatter.field("api_destination_arn", &self.api_destination_arn);
        formatter.field("api_destination_state", &self.api_destination_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`UpdateApiDestinationOutput`](crate::output::UpdateApiDestinationOutput)
pub mod update_api_destination_output {
    /// A builder for [`UpdateApiDestinationOutput`](crate::output::UpdateApiDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_destination_arn: std::option::Option<std::string::String>,
        pub(crate) api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the API destination that was updated.</p>
        pub fn api_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the API destination that was updated.</p>
        pub fn set_api_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_destination_arn = input;
            self
        }
        /// <p>The state of the API destination that was updated.</p>
        pub fn api_destination_state(mut self, input: crate::model::ApiDestinationState) -> Self {
            self.api_destination_state = Some(input);
            self
        }
        /// <p>The state of the API destination that was updated.</p>
        pub fn set_api_destination_state(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationState>,
        ) -> Self {
            self.api_destination_state = input;
            self
        }
        /// <p>A time stamp for the time that the API destination was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the API destination was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the API destination was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the API destination was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiDestinationOutput`](crate::output::UpdateApiDestinationOutput)
        pub fn build(self) -> crate::output::UpdateApiDestinationOutput {
            crate::output::UpdateApiDestinationOutput {
                api_destination_arn: self.api_destination_arn,
                api_destination_state: self.api_destination_state,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl UpdateApiDestinationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApiDestinationOutput`](crate::output::UpdateApiDestinationOutput)
    pub fn builder() -> crate::output::update_api_destination_output::Builder {
        crate::output::update_api_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestEventPatternOutput {
    /// <p>Indicates whether the event matches the event pattern.</p>
    pub result: bool,
}
impl TestEventPatternOutput {
    /// <p>Indicates whether the event matches the event pattern.</p>
    pub fn result(&self) -> bool {
        self.result
    }
}
impl std::fmt::Debug for TestEventPatternOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestEventPatternOutput");
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`TestEventPatternOutput`](crate::output::TestEventPatternOutput)
pub mod test_event_pattern_output {
    /// A builder for [`TestEventPatternOutput`](crate::output::TestEventPatternOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the event matches the event pattern.</p>
        pub fn result(mut self, input: bool) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>Indicates whether the event matches the event pattern.</p>
        pub fn set_result(mut self, input: std::option::Option<bool>) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`TestEventPatternOutput`](crate::output::TestEventPatternOutput)
        pub fn build(self) -> crate::output::TestEventPatternOutput {
            crate::output::TestEventPatternOutput {
                result: self.result.unwrap_or_default(),
            }
        }
    }
}
impl TestEventPatternOutput {
    /// Creates a new builder-style object to manufacture [`TestEventPatternOutput`](crate::output::TestEventPatternOutput)
    pub fn builder() -> crate::output::test_event_pattern_output::Builder {
        crate::output::test_event_pattern_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReplayOutput {
    /// <p>The ARN of the replay.</p>
    pub replay_arn: std::option::Option<std::string::String>,
    /// <p>The state of the replay.</p>
    pub state: std::option::Option<crate::model::ReplayState>,
    /// <p>The reason that the replay is in the state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The time at which the replay started.</p>
    pub replay_start_time: std::option::Option<aws_smithy_types::Instant>,
}
impl StartReplayOutput {
    /// <p>The ARN of the replay.</p>
    pub fn replay_arn(&self) -> std::option::Option<&str> {
        self.replay_arn.as_deref()
    }
    /// <p>The state of the replay.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ReplayState> {
        self.state.as_ref()
    }
    /// <p>The reason that the replay is in the state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The time at which the replay started.</p>
    pub fn replay_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.replay_start_time.as_ref()
    }
}
impl std::fmt::Debug for StartReplayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReplayOutput");
        formatter.field("replay_arn", &self.replay_arn);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("replay_start_time", &self.replay_start_time);
        formatter.finish()
    }
}
/// See [`StartReplayOutput`](crate::output::StartReplayOutput)
pub mod start_replay_output {
    /// A builder for [`StartReplayOutput`](crate::output::StartReplayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replay_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReplayState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) replay_start_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the replay.</p>
        pub fn replay_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the replay.</p>
        pub fn set_replay_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_arn = input;
            self
        }
        /// <p>The state of the replay.</p>
        pub fn state(mut self, input: crate::model::ReplayState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the replay.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ReplayState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason that the replay is in the state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the replay is in the state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The time at which the replay started.</p>
        pub fn replay_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.replay_start_time = Some(input);
            self
        }
        /// <p>The time at which the replay started.</p>
        pub fn set_replay_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.replay_start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReplayOutput`](crate::output::StartReplayOutput)
        pub fn build(self) -> crate::output::StartReplayOutput {
            crate::output::StartReplayOutput {
                replay_arn: self.replay_arn,
                state: self.state,
                state_reason: self.state_reason,
                replay_start_time: self.replay_start_time,
            }
        }
    }
}
impl StartReplayOutput {
    /// Creates a new builder-style object to manufacture [`StartReplayOutput`](crate::output::StartReplayOutput)
    pub fn builder() -> crate::output::start_replay_output::Builder {
        crate::output::start_replay_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTargetsOutput {
    /// <p>The number of failed entries.</p>
    pub failed_entry_count: i32,
    /// <p>The failed target entries.</p>
    pub failed_entries: std::option::Option<std::vec::Vec<crate::model::RemoveTargetsResultEntry>>,
}
impl RemoveTargetsOutput {
    /// <p>The number of failed entries.</p>
    pub fn failed_entry_count(&self) -> i32 {
        self.failed_entry_count
    }
    /// <p>The failed target entries.</p>
    pub fn failed_entries(&self) -> std::option::Option<&[crate::model::RemoveTargetsResultEntry]> {
        self.failed_entries.as_deref()
    }
}
impl std::fmt::Debug for RemoveTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTargetsOutput");
        formatter.field("failed_entry_count", &self.failed_entry_count);
        formatter.field("failed_entries", &self.failed_entries);
        formatter.finish()
    }
}
/// See [`RemoveTargetsOutput`](crate::output::RemoveTargetsOutput)
pub mod remove_targets_output {
    /// A builder for [`RemoveTargetsOutput`](crate::output::RemoveTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_entry_count: std::option::Option<i32>,
        pub(crate) failed_entries:
            std::option::Option<std::vec::Vec<crate::model::RemoveTargetsResultEntry>>,
    }
    impl Builder {
        /// <p>The number of failed entries.</p>
        pub fn failed_entry_count(mut self, input: i32) -> Self {
            self.failed_entry_count = Some(input);
            self
        }
        /// <p>The number of failed entries.</p>
        pub fn set_failed_entry_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_entry_count = input;
            self
        }
        /// Appends an item to `failed_entries`.
        ///
        /// To override the contents of this collection use [`set_failed_entries`](Self::set_failed_entries).
        ///
        /// <p>The failed target entries.</p>
        pub fn failed_entries(
            mut self,
            input: impl Into<crate::model::RemoveTargetsResultEntry>,
        ) -> Self {
            let mut v = self.failed_entries.unwrap_or_default();
            v.push(input.into());
            self.failed_entries = Some(v);
            self
        }
        /// <p>The failed target entries.</p>
        pub fn set_failed_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemoveTargetsResultEntry>>,
        ) -> Self {
            self.failed_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTargetsOutput`](crate::output::RemoveTargetsOutput)
        pub fn build(self) -> crate::output::RemoveTargetsOutput {
            crate::output::RemoveTargetsOutput {
                failed_entry_count: self.failed_entry_count.unwrap_or_default(),
                failed_entries: self.failed_entries,
            }
        }
    }
}
impl RemoveTargetsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTargetsOutput`](crate::output::RemoveTargetsOutput)
    pub fn builder() -> crate::output::remove_targets_output::Builder {
        crate::output::remove_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionOutput {}
impl std::fmt::Debug for RemovePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionOutput");
        formatter.finish()
    }
}
/// See [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
pub mod remove_permission_output {
    /// A builder for [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
        pub fn build(self) -> crate::output::RemovePermissionOutput {
            crate::output::RemovePermissionOutput {}
        }
    }
}
impl RemovePermissionOutput {
    /// Creates a new builder-style object to manufacture [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    pub fn builder() -> crate::output::remove_permission_output::Builder {
        crate::output::remove_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutTargetsOutput {
    /// <p>The number of failed entries.</p>
    pub failed_entry_count: i32,
    /// <p>The failed target entries.</p>
    pub failed_entries: std::option::Option<std::vec::Vec<crate::model::PutTargetsResultEntry>>,
}
impl PutTargetsOutput {
    /// <p>The number of failed entries.</p>
    pub fn failed_entry_count(&self) -> i32 {
        self.failed_entry_count
    }
    /// <p>The failed target entries.</p>
    pub fn failed_entries(&self) -> std::option::Option<&[crate::model::PutTargetsResultEntry]> {
        self.failed_entries.as_deref()
    }
}
impl std::fmt::Debug for PutTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutTargetsOutput");
        formatter.field("failed_entry_count", &self.failed_entry_count);
        formatter.field("failed_entries", &self.failed_entries);
        formatter.finish()
    }
}
/// See [`PutTargetsOutput`](crate::output::PutTargetsOutput)
pub mod put_targets_output {
    /// A builder for [`PutTargetsOutput`](crate::output::PutTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_entry_count: std::option::Option<i32>,
        pub(crate) failed_entries:
            std::option::Option<std::vec::Vec<crate::model::PutTargetsResultEntry>>,
    }
    impl Builder {
        /// <p>The number of failed entries.</p>
        pub fn failed_entry_count(mut self, input: i32) -> Self {
            self.failed_entry_count = Some(input);
            self
        }
        /// <p>The number of failed entries.</p>
        pub fn set_failed_entry_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_entry_count = input;
            self
        }
        /// Appends an item to `failed_entries`.
        ///
        /// To override the contents of this collection use [`set_failed_entries`](Self::set_failed_entries).
        ///
        /// <p>The failed target entries.</p>
        pub fn failed_entries(
            mut self,
            input: impl Into<crate::model::PutTargetsResultEntry>,
        ) -> Self {
            let mut v = self.failed_entries.unwrap_or_default();
            v.push(input.into());
            self.failed_entries = Some(v);
            self
        }
        /// <p>The failed target entries.</p>
        pub fn set_failed_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutTargetsResultEntry>>,
        ) -> Self {
            self.failed_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`PutTargetsOutput`](crate::output::PutTargetsOutput)
        pub fn build(self) -> crate::output::PutTargetsOutput {
            crate::output::PutTargetsOutput {
                failed_entry_count: self.failed_entry_count.unwrap_or_default(),
                failed_entries: self.failed_entries,
            }
        }
    }
}
impl PutTargetsOutput {
    /// Creates a new builder-style object to manufacture [`PutTargetsOutput`](crate::output::PutTargetsOutput)
    pub fn builder() -> crate::output::put_targets_output::Builder {
        crate::output::put_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the rule.</p>
    pub rule_arn: std::option::Option<std::string::String>,
}
impl PutRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the rule.</p>
    pub fn rule_arn(&self) -> std::option::Option<&str> {
        self.rule_arn.as_deref()
    }
}
impl std::fmt::Debug for PutRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRuleOutput");
        formatter.field("rule_arn", &self.rule_arn);
        formatter.finish()
    }
}
/// See [`PutRuleOutput`](crate::output::PutRuleOutput)
pub mod put_rule_output {
    /// A builder for [`PutRuleOutput`](crate::output::PutRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRuleOutput`](crate::output::PutRuleOutput)
        pub fn build(self) -> crate::output::PutRuleOutput {
            crate::output::PutRuleOutput {
                rule_arn: self.rule_arn,
            }
        }
    }
}
impl PutRuleOutput {
    /// Creates a new builder-style object to manufacture [`PutRuleOutput`](crate::output::PutRuleOutput)
    pub fn builder() -> crate::output::put_rule_output::Builder {
        crate::output::put_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPermissionOutput {}
impl std::fmt::Debug for PutPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPermissionOutput");
        formatter.finish()
    }
}
/// See [`PutPermissionOutput`](crate::output::PutPermissionOutput)
pub mod put_permission_output {
    /// A builder for [`PutPermissionOutput`](crate::output::PutPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutPermissionOutput`](crate::output::PutPermissionOutput)
        pub fn build(self) -> crate::output::PutPermissionOutput {
            crate::output::PutPermissionOutput {}
        }
    }
}
impl PutPermissionOutput {
    /// Creates a new builder-style object to manufacture [`PutPermissionOutput`](crate::output::PutPermissionOutput)
    pub fn builder() -> crate::output::put_permission_output::Builder {
        crate::output::put_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPartnerEventsOutput {
    /// <p>The number of events from this operation that could not be written to the partner event
    /// bus.</p>
    pub failed_entry_count: i32,
    /// <p>The list of events from this operation that were successfully written to the partner event
    /// bus.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsResultEntry>>,
}
impl PutPartnerEventsOutput {
    /// <p>The number of events from this operation that could not be written to the partner event
    /// bus.</p>
    pub fn failed_entry_count(&self) -> i32 {
        self.failed_entry_count
    }
    /// <p>The list of events from this operation that were successfully written to the partner event
    /// bus.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::PutPartnerEventsResultEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for PutPartnerEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPartnerEventsOutput");
        formatter.field("failed_entry_count", &self.failed_entry_count);
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}
/// See [`PutPartnerEventsOutput`](crate::output::PutPartnerEventsOutput)
pub mod put_partner_events_output {
    /// A builder for [`PutPartnerEventsOutput`](crate::output::PutPartnerEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_entry_count: std::option::Option<i32>,
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsResultEntry>>,
    }
    impl Builder {
        /// <p>The number of events from this operation that could not be written to the partner event
        /// bus.</p>
        pub fn failed_entry_count(mut self, input: i32) -> Self {
            self.failed_entry_count = Some(input);
            self
        }
        /// <p>The number of events from this operation that could not be written to the partner event
        /// bus.</p>
        pub fn set_failed_entry_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_entry_count = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of events from this operation that were successfully written to the partner event
        /// bus.</p>
        pub fn entries(
            mut self,
            input: impl Into<crate::model::PutPartnerEventsResultEntry>,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>The list of events from this operation that were successfully written to the partner event
        /// bus.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsResultEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPartnerEventsOutput`](crate::output::PutPartnerEventsOutput)
        pub fn build(self) -> crate::output::PutPartnerEventsOutput {
            crate::output::PutPartnerEventsOutput {
                failed_entry_count: self.failed_entry_count.unwrap_or_default(),
                entries: self.entries,
            }
        }
    }
}
impl PutPartnerEventsOutput {
    /// Creates a new builder-style object to manufacture [`PutPartnerEventsOutput`](crate::output::PutPartnerEventsOutput)
    pub fn builder() -> crate::output::put_partner_events_output::Builder {
        crate::output::put_partner_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventsOutput {
    /// <p>The number of failed entries.</p>
    pub failed_entry_count: i32,
    /// <p>The successfully and unsuccessfully ingested events results. If the ingestion was
    /// successful, the entry has the event ID in it. Otherwise, you can use the error code and error
    /// message to identify the problem with the entry.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::PutEventsResultEntry>>,
}
impl PutEventsOutput {
    /// <p>The number of failed entries.</p>
    pub fn failed_entry_count(&self) -> i32 {
        self.failed_entry_count
    }
    /// <p>The successfully and unsuccessfully ingested events results. If the ingestion was
    /// successful, the entry has the event ID in it. Otherwise, you can use the error code and error
    /// message to identify the problem with the entry.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::PutEventsResultEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for PutEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventsOutput");
        formatter.field("failed_entry_count", &self.failed_entry_count);
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}
/// See [`PutEventsOutput`](crate::output::PutEventsOutput)
pub mod put_events_output {
    /// A builder for [`PutEventsOutput`](crate::output::PutEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_entry_count: std::option::Option<i32>,
        pub(crate) entries: std::option::Option<std::vec::Vec<crate::model::PutEventsResultEntry>>,
    }
    impl Builder {
        /// <p>The number of failed entries.</p>
        pub fn failed_entry_count(mut self, input: i32) -> Self {
            self.failed_entry_count = Some(input);
            self
        }
        /// <p>The number of failed entries.</p>
        pub fn set_failed_entry_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_entry_count = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The successfully and unsuccessfully ingested events results. If the ingestion was
        /// successful, the entry has the event ID in it. Otherwise, you can use the error code and error
        /// message to identify the problem with the entry.</p>
        pub fn entries(mut self, input: impl Into<crate::model::PutEventsResultEntry>) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>The successfully and unsuccessfully ingested events results. If the ingestion was
        /// successful, the entry has the event ID in it. Otherwise, you can use the error code and error
        /// message to identify the problem with the entry.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutEventsResultEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventsOutput`](crate::output::PutEventsOutput)
        pub fn build(self) -> crate::output::PutEventsOutput {
            crate::output::PutEventsOutput {
                failed_entry_count: self.failed_entry_count.unwrap_or_default(),
                entries: self.entries,
            }
        }
    }
}
impl PutEventsOutput {
    /// Creates a new builder-style object to manufacture [`PutEventsOutput`](crate::output::PutEventsOutput)
    pub fn builder() -> crate::output::put_events_output::Builder {
        crate::output::put_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsByRuleOutput {
    /// <p>The targets assigned to the rule.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
    /// the value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTargetsByRuleOutput {
    /// <p>The targets assigned to the rule.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
    /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
    /// the value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTargetsByRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsByRuleOutput");
        formatter.field("targets", &self.targets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTargetsByRuleOutput`](crate::output::ListTargetsByRuleOutput)
pub mod list_targets_by_rule_output {
    /// A builder for [`ListTargetsByRuleOutput`](crate::output::ListTargetsByRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets assigned to the rule.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets assigned to the rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
        /// the value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
        /// the value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsByRuleOutput`](crate::output::ListTargetsByRuleOutput)
        pub fn build(self) -> crate::output::ListTargetsByRuleOutput {
            crate::output::ListTargetsByRuleOutput {
                targets: self.targets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTargetsByRuleOutput {
    /// Creates a new builder-style object to manufacture [`ListTargetsByRuleOutput`](crate::output::ListTargetsByRuleOutput)
    pub fn builder() -> crate::output::list_targets_by_rule_output::Builder {
        crate::output::list_targets_by_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tag keys and values associated with the resource you specified</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The list of tag keys and values associated with the resource you specified</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with the resource you specified</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tag keys and values associated with the resource you specified</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesOutput {
    /// <p>The rules that match the specified criteria.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
    /// the value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRulesOutput {
    /// <p>The rules that match the specified criteria.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
    /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
    /// the value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesOutput");
        formatter.field("rules", &self.rules);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRulesOutput`](crate::output::ListRulesOutput)
pub mod list_rules_output {
    /// A builder for [`ListRulesOutput`](crate::output::ListRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules that match the specified criteria.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>The rules that match the specified criteria.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
        /// the value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
        /// the value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesOutput`](crate::output::ListRulesOutput)
        pub fn build(self) -> crate::output::ListRulesOutput {
            crate::output::ListRulesOutput {
                rules: self.rules,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListRulesOutput`](crate::output::ListRulesOutput)
    pub fn builder() -> crate::output::list_rules_output::Builder {
        crate::output::list_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRuleNamesByTargetOutput {
    /// <p>The names of the rules that can invoke the given target.</p>
    pub rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
    /// the value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRuleNamesByTargetOutput {
    /// <p>The names of the rules that can invoke the given target.</p>
    pub fn rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.rule_names.as_deref()
    }
    /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
    /// the value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRuleNamesByTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRuleNamesByTargetOutput");
        formatter.field("rule_names", &self.rule_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRuleNamesByTargetOutput`](crate::output::ListRuleNamesByTargetOutput)
pub mod list_rule_names_by_target_output {
    /// A builder for [`ListRuleNamesByTargetOutput`](crate::output::ListRuleNamesByTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rule_names`.
        ///
        /// To override the contents of this collection use [`set_rule_names`](Self::set_rule_names).
        ///
        /// <p>The names of the rules that can invoke the given target.</p>
        pub fn rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rule_names.unwrap_or_default();
            v.push(input.into());
            self.rule_names = Some(v);
            self
        }
        /// <p>The names of the rules that can invoke the given target.</p>
        pub fn set_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rule_names = input;
            self
        }
        /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
        /// the value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Indicates whether there are additional results to retrieve. If there are no more results,
        /// the value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRuleNamesByTargetOutput`](crate::output::ListRuleNamesByTargetOutput)
        pub fn build(self) -> crate::output::ListRuleNamesByTargetOutput {
            crate::output::ListRuleNamesByTargetOutput {
                rule_names: self.rule_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRuleNamesByTargetOutput {
    /// Creates a new builder-style object to manufacture [`ListRuleNamesByTargetOutput`](crate::output::ListRuleNamesByTargetOutput)
    pub fn builder() -> crate::output::list_rule_names_by_target_output::Builder {
        crate::output::list_rule_names_by_target_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReplaysOutput {
    /// <p>An array of <code>Replay</code> objects that contain information about the replay.</p>
    pub replays: std::option::Option<std::vec::Vec<crate::model::Replay>>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReplaysOutput {
    /// <p>An array of <code>Replay</code> objects that contain information about the replay.</p>
    pub fn replays(&self) -> std::option::Option<&[crate::model::Replay]> {
        self.replays.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReplaysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReplaysOutput");
        formatter.field("replays", &self.replays);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListReplaysOutput`](crate::output::ListReplaysOutput)
pub mod list_replays_output {
    /// A builder for [`ListReplaysOutput`](crate::output::ListReplaysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replays: std::option::Option<std::vec::Vec<crate::model::Replay>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `replays`.
        ///
        /// To override the contents of this collection use [`set_replays`](Self::set_replays).
        ///
        /// <p>An array of <code>Replay</code> objects that contain information about the replay.</p>
        pub fn replays(mut self, input: impl Into<crate::model::Replay>) -> Self {
            let mut v = self.replays.unwrap_or_default();
            v.push(input.into());
            self.replays = Some(v);
            self
        }
        /// <p>An array of <code>Replay</code> objects that contain information about the replay.</p>
        pub fn set_replays(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Replay>>,
        ) -> Self {
            self.replays = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReplaysOutput`](crate::output::ListReplaysOutput)
        pub fn build(self) -> crate::output::ListReplaysOutput {
            crate::output::ListReplaysOutput {
                replays: self.replays,
                next_token: self.next_token,
            }
        }
    }
}
impl ListReplaysOutput {
    /// Creates a new builder-style object to manufacture [`ListReplaysOutput`](crate::output::ListReplaysOutput)
    pub fn builder() -> crate::output::list_replays_output::Builder {
        crate::output::list_replays_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartnerEventSourcesOutput {
    /// <p>The list of partner event sources returned by the operation.</p>
    pub partner_event_sources: std::option::Option<std::vec::Vec<crate::model::PartnerEventSource>>,
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPartnerEventSourcesOutput {
    /// <p>The list of partner event sources returned by the operation.</p>
    pub fn partner_event_sources(
        &self,
    ) -> std::option::Option<&[crate::model::PartnerEventSource]> {
        self.partner_event_sources.as_deref()
    }
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPartnerEventSourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartnerEventSourcesOutput");
        formatter.field("partner_event_sources", &self.partner_event_sources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPartnerEventSourcesOutput`](crate::output::ListPartnerEventSourcesOutput)
pub mod list_partner_event_sources_output {
    /// A builder for [`ListPartnerEventSourcesOutput`](crate::output::ListPartnerEventSourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partner_event_sources:
            std::option::Option<std::vec::Vec<crate::model::PartnerEventSource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `partner_event_sources`.
        ///
        /// To override the contents of this collection use [`set_partner_event_sources`](Self::set_partner_event_sources).
        ///
        /// <p>The list of partner event sources returned by the operation.</p>
        pub fn partner_event_sources(
            mut self,
            input: impl Into<crate::model::PartnerEventSource>,
        ) -> Self {
            let mut v = self.partner_event_sources.unwrap_or_default();
            v.push(input.into());
            self.partner_event_sources = Some(v);
            self
        }
        /// <p>The list of partner event sources returned by the operation.</p>
        pub fn set_partner_event_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartnerEventSource>>,
        ) -> Self {
            self.partner_event_sources = input;
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartnerEventSourcesOutput`](crate::output::ListPartnerEventSourcesOutput)
        pub fn build(self) -> crate::output::ListPartnerEventSourcesOutput {
            crate::output::ListPartnerEventSourcesOutput {
                partner_event_sources: self.partner_event_sources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPartnerEventSourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListPartnerEventSourcesOutput`](crate::output::ListPartnerEventSourcesOutput)
    pub fn builder() -> crate::output::list_partner_event_sources_output::Builder {
        crate::output::list_partner_event_sources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartnerEventSourceAccountsOutput {
    /// <p>The list of partner event sources returned by the operation.</p>
    pub partner_event_source_accounts:
        std::option::Option<std::vec::Vec<crate::model::PartnerEventSourceAccount>>,
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPartnerEventSourceAccountsOutput {
    /// <p>The list of partner event sources returned by the operation.</p>
    pub fn partner_event_source_accounts(
        &self,
    ) -> std::option::Option<&[crate::model::PartnerEventSourceAccount]> {
        self.partner_event_source_accounts.as_deref()
    }
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPartnerEventSourceAccountsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartnerEventSourceAccountsOutput");
        formatter.field(
            "partner_event_source_accounts",
            &self.partner_event_source_accounts,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPartnerEventSourceAccountsOutput`](crate::output::ListPartnerEventSourceAccountsOutput)
pub mod list_partner_event_source_accounts_output {
    /// A builder for [`ListPartnerEventSourceAccountsOutput`](crate::output::ListPartnerEventSourceAccountsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partner_event_source_accounts:
            std::option::Option<std::vec::Vec<crate::model::PartnerEventSourceAccount>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `partner_event_source_accounts`.
        ///
        /// To override the contents of this collection use [`set_partner_event_source_accounts`](Self::set_partner_event_source_accounts).
        ///
        /// <p>The list of partner event sources returned by the operation.</p>
        pub fn partner_event_source_accounts(
            mut self,
            input: impl Into<crate::model::PartnerEventSourceAccount>,
        ) -> Self {
            let mut v = self.partner_event_source_accounts.unwrap_or_default();
            v.push(input.into());
            self.partner_event_source_accounts = Some(v);
            self
        }
        /// <p>The list of partner event sources returned by the operation.</p>
        pub fn set_partner_event_source_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartnerEventSourceAccount>>,
        ) -> Self {
            self.partner_event_source_accounts = input;
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartnerEventSourceAccountsOutput`](crate::output::ListPartnerEventSourceAccountsOutput)
        pub fn build(self) -> crate::output::ListPartnerEventSourceAccountsOutput {
            crate::output::ListPartnerEventSourceAccountsOutput {
                partner_event_source_accounts: self.partner_event_source_accounts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPartnerEventSourceAccountsOutput {
    /// Creates a new builder-style object to manufacture [`ListPartnerEventSourceAccountsOutput`](crate::output::ListPartnerEventSourceAccountsOutput)
    pub fn builder() -> crate::output::list_partner_event_source_accounts_output::Builder {
        crate::output::list_partner_event_source_accounts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventSourcesOutput {
    /// <p>The list of event sources.</p>
    pub event_sources: std::option::Option<std::vec::Vec<crate::model::EventSource>>,
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEventSourcesOutput {
    /// <p>The list of event sources.</p>
    pub fn event_sources(&self) -> std::option::Option<&[crate::model::EventSource]> {
        self.event_sources.as_deref()
    }
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEventSourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventSourcesOutput");
        formatter.field("event_sources", &self.event_sources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEventSourcesOutput`](crate::output::ListEventSourcesOutput)
pub mod list_event_sources_output {
    /// A builder for [`ListEventSourcesOutput`](crate::output::ListEventSourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_sources: std::option::Option<std::vec::Vec<crate::model::EventSource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_sources`.
        ///
        /// To override the contents of this collection use [`set_event_sources`](Self::set_event_sources).
        ///
        /// <p>The list of event sources.</p>
        pub fn event_sources(mut self, input: impl Into<crate::model::EventSource>) -> Self {
            let mut v = self.event_sources.unwrap_or_default();
            v.push(input.into());
            self.event_sources = Some(v);
            self
        }
        /// <p>The list of event sources.</p>
        pub fn set_event_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSource>>,
        ) -> Self {
            self.event_sources = input;
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventSourcesOutput`](crate::output::ListEventSourcesOutput)
        pub fn build(self) -> crate::output::ListEventSourcesOutput {
            crate::output::ListEventSourcesOutput {
                event_sources: self.event_sources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEventSourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListEventSourcesOutput`](crate::output::ListEventSourcesOutput)
    pub fn builder() -> crate::output::list_event_sources_output::Builder {
        crate::output::list_event_sources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventBusesOutput {
    /// <p>This list of event buses.</p>
    pub event_buses: std::option::Option<std::vec::Vec<crate::model::EventBus>>,
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEventBusesOutput {
    /// <p>This list of event buses.</p>
    pub fn event_buses(&self) -> std::option::Option<&[crate::model::EventBus]> {
        self.event_buses.as_deref()
    }
    /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEventBusesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventBusesOutput");
        formatter.field("event_buses", &self.event_buses);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEventBusesOutput`](crate::output::ListEventBusesOutput)
pub mod list_event_buses_output {
    /// A builder for [`ListEventBusesOutput`](crate::output::ListEventBusesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_buses: std::option::Option<std::vec::Vec<crate::model::EventBus>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_buses`.
        ///
        /// To override the contents of this collection use [`set_event_buses`](Self::set_event_buses).
        ///
        /// <p>This list of event buses.</p>
        pub fn event_buses(mut self, input: impl Into<crate::model::EventBus>) -> Self {
            let mut v = self.event_buses.unwrap_or_default();
            v.push(input.into());
            self.event_buses = Some(v);
            self
        }
        /// <p>This list of event buses.</p>
        pub fn set_event_buses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventBus>>,
        ) -> Self {
            self.event_buses = input;
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventBusesOutput`](crate::output::ListEventBusesOutput)
        pub fn build(self) -> crate::output::ListEventBusesOutput {
            crate::output::ListEventBusesOutput {
                event_buses: self.event_buses,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEventBusesOutput {
    /// Creates a new builder-style object to manufacture [`ListEventBusesOutput`](crate::output::ListEventBusesOutput)
    pub fn builder() -> crate::output::list_event_buses_output::Builder {
        crate::output::list_event_buses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectionsOutput {
    /// <p>An array of connections objects that include details about the connections.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListConnectionsOutput {
    /// <p>An array of connections objects that include details about the connections.</p>
    pub fn connections(&self) -> std::option::Option<&[crate::model::Connection]> {
        self.connections.as_deref()
    }
    /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectionsOutput");
        formatter.field("connections", &self.connections);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
pub mod list_connections_output {
    /// A builder for [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>An array of connections objects that include details about the connections.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>An array of connections objects that include details about the connections.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
        pub fn build(self) -> crate::output::ListConnectionsOutput {
            crate::output::ListConnectionsOutput {
                connections: self.connections,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
    pub fn builder() -> crate::output::list_connections_output::Builder {
        crate::output::list_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArchivesOutput {
    /// <p>An array of <code>Archive</code> objects that include details about an archive.</p>
    pub archives: std::option::Option<std::vec::Vec<crate::model::Archive>>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListArchivesOutput {
    /// <p>An array of <code>Archive</code> objects that include details about an archive.</p>
    pub fn archives(&self) -> std::option::Option<&[crate::model::Archive]> {
        self.archives.as_deref()
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListArchivesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArchivesOutput");
        formatter.field("archives", &self.archives);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListArchivesOutput`](crate::output::ListArchivesOutput)
pub mod list_archives_output {
    /// A builder for [`ListArchivesOutput`](crate::output::ListArchivesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archives: std::option::Option<std::vec::Vec<crate::model::Archive>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `archives`.
        ///
        /// To override the contents of this collection use [`set_archives`](Self::set_archives).
        ///
        /// <p>An array of <code>Archive</code> objects that include details about an archive.</p>
        pub fn archives(mut self, input: impl Into<crate::model::Archive>) -> Self {
            let mut v = self.archives.unwrap_or_default();
            v.push(input.into());
            self.archives = Some(v);
            self
        }
        /// <p>An array of <code>Archive</code> objects that include details about an archive.</p>
        pub fn set_archives(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Archive>>,
        ) -> Self {
            self.archives = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArchivesOutput`](crate::output::ListArchivesOutput)
        pub fn build(self) -> crate::output::ListArchivesOutput {
            crate::output::ListArchivesOutput {
                archives: self.archives,
                next_token: self.next_token,
            }
        }
    }
}
impl ListArchivesOutput {
    /// Creates a new builder-style object to manufacture [`ListArchivesOutput`](crate::output::ListArchivesOutput)
    pub fn builder() -> crate::output::list_archives_output::Builder {
        crate::output::list_archives_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApiDestinationsOutput {
    /// <p>An array of <code>ApiDestination</code> objects that include information about an API
    /// destination.</p>
    pub api_destinations: std::option::Option<std::vec::Vec<crate::model::ApiDestination>>,
    /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApiDestinationsOutput {
    /// <p>An array of <code>ApiDestination</code> objects that include information about an API
    /// destination.</p>
    pub fn api_destinations(&self) -> std::option::Option<&[crate::model::ApiDestination]> {
        self.api_destinations.as_deref()
    }
    /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApiDestinationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApiDestinationsOutput");
        formatter.field("api_destinations", &self.api_destinations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApiDestinationsOutput`](crate::output::ListApiDestinationsOutput)
pub mod list_api_destinations_output {
    /// A builder for [`ListApiDestinationsOutput`](crate::output::ListApiDestinationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_destinations:
            std::option::Option<std::vec::Vec<crate::model::ApiDestination>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `api_destinations`.
        ///
        /// To override the contents of this collection use [`set_api_destinations`](Self::set_api_destinations).
        ///
        /// <p>An array of <code>ApiDestination</code> objects that include information about an API
        /// destination.</p>
        pub fn api_destinations(mut self, input: impl Into<crate::model::ApiDestination>) -> Self {
            let mut v = self.api_destinations.unwrap_or_default();
            v.push(input.into());
            self.api_destinations = Some(v);
            self
        }
        /// <p>An array of <code>ApiDestination</code> objects that include information about an API
        /// destination.</p>
        pub fn set_api_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiDestination>>,
        ) -> Self {
            self.api_destinations = input;
            self
        }
        /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use in a subsequent request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApiDestinationsOutput`](crate::output::ListApiDestinationsOutput)
        pub fn build(self) -> crate::output::ListApiDestinationsOutput {
            crate::output::ListApiDestinationsOutput {
                api_destinations: self.api_destinations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApiDestinationsOutput {
    /// Creates a new builder-style object to manufacture [`ListApiDestinationsOutput`](crate::output::ListApiDestinationsOutput)
    pub fn builder() -> crate::output::list_api_destinations_output::Builder {
        crate::output::list_api_destinations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableRuleOutput {}
impl std::fmt::Debug for EnableRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableRuleOutput");
        formatter.finish()
    }
}
/// See [`EnableRuleOutput`](crate::output::EnableRuleOutput)
pub mod enable_rule_output {
    /// A builder for [`EnableRuleOutput`](crate::output::EnableRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableRuleOutput`](crate::output::EnableRuleOutput)
        pub fn build(self) -> crate::output::EnableRuleOutput {
            crate::output::EnableRuleOutput {}
        }
    }
}
impl EnableRuleOutput {
    /// Creates a new builder-style object to manufacture [`EnableRuleOutput`](crate::output::EnableRuleOutput)
    pub fn builder() -> crate::output::enable_rule_output::Builder {
        crate::output::enable_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableRuleOutput {}
impl std::fmt::Debug for DisableRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableRuleOutput");
        formatter.finish()
    }
}
/// See [`DisableRuleOutput`](crate::output::DisableRuleOutput)
pub mod disable_rule_output {
    /// A builder for [`DisableRuleOutput`](crate::output::DisableRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableRuleOutput`](crate::output::DisableRuleOutput)
        pub fn build(self) -> crate::output::DisableRuleOutput {
            crate::output::DisableRuleOutput {}
        }
    }
}
impl DisableRuleOutput {
    /// Creates a new builder-style object to manufacture [`DisableRuleOutput`](crate::output::DisableRuleOutput)
    pub fn builder() -> crate::output::disable_rule_output::Builder {
        crate::output::disable_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRuleOutput {
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the rule.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
    /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>Specifies whether the rule is enabled or disabled.</p>
    pub state: std::option::Option<crate::model::RuleState>,
    /// <p>The description of the rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, this field displays
    /// the principal name of the Amazon Web Services service that created the rule.</p>
    pub managed_by: std::option::Option<std::string::String>,
    /// <p>The name of the event bus associated with the rule.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>The account ID of the user that created the rule. If you use <code>PutRule</code> to put a
    /// rule on an event bus in another account, the other account is the owner of the rule, and the
    /// rule ARN includes the account ID for that account. However, the value for
    /// <code>CreatedBy</code> is the account ID as the account that created the rule in the other
    /// account.</p>
    pub created_by: std::option::Option<std::string::String>,
}
impl DescribeRuleOutput {
    /// <p>The name of the rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
    /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".</p>
    pub fn schedule_expression(&self) -> std::option::Option<&str> {
        self.schedule_expression.as_deref()
    }
    /// <p>Specifies whether the rule is enabled or disabled.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::RuleState> {
        self.state.as_ref()
    }
    /// <p>The description of the rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, this field displays
    /// the principal name of the Amazon Web Services service that created the rule.</p>
    pub fn managed_by(&self) -> std::option::Option<&str> {
        self.managed_by.as_deref()
    }
    /// <p>The name of the event bus associated with the rule.</p>
    pub fn event_bus_name(&self) -> std::option::Option<&str> {
        self.event_bus_name.as_deref()
    }
    /// <p>The account ID of the user that created the rule. If you use <code>PutRule</code> to put a
    /// rule on an event bus in another account, the other account is the owner of the rule, and the
    /// rule ARN includes the account ID for that account. However, the value for
    /// <code>CreatedBy</code> is the account ID as the account that created the rule in the other
    /// account.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
}
impl std::fmt::Debug for DescribeRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRuleOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("state", &self.state);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("managed_by", &self.managed_by);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`DescribeRuleOutput`](crate::output::DescribeRuleOutput)
pub mod describe_rule_output {
    /// A builder for [`DescribeRuleOutput`](crate::output::DescribeRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::RuleState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>Specifies whether the rule is enabled or disabled.</p>
        pub fn state(mut self, input: crate::model::RuleState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Specifies whether the rule is enabled or disabled.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RuleState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The description of the rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, this field displays
        /// the principal name of the Amazon Web Services service that created the rule.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, this field displays
        /// the principal name of the Amazon Web Services service that created the rule.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// <p>The name of the event bus associated with the rule.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name of the event bus associated with the rule.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// <p>The account ID of the user that created the rule. If you use <code>PutRule</code> to put a
        /// rule on an event bus in another account, the other account is the owner of the rule, and the
        /// rule ARN includes the account ID for that account. However, the value for
        /// <code>CreatedBy</code> is the account ID as the account that created the rule in the other
        /// account.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The account ID of the user that created the rule. If you use <code>PutRule</code> to put a
        /// rule on an event bus in another account, the other account is the owner of the rule, and the
        /// rule ARN includes the account ID for that account. However, the value for
        /// <code>CreatedBy</code> is the account ID as the account that created the rule in the other
        /// account.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRuleOutput`](crate::output::DescribeRuleOutput)
        pub fn build(self) -> crate::output::DescribeRuleOutput {
            crate::output::DescribeRuleOutput {
                name: self.name,
                arn: self.arn,
                event_pattern: self.event_pattern,
                schedule_expression: self.schedule_expression,
                state: self.state,
                description: self.description,
                role_arn: self.role_arn,
                managed_by: self.managed_by,
                event_bus_name: self.event_bus_name,
                created_by: self.created_by,
            }
        }
    }
}
impl DescribeRuleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRuleOutput`](crate::output::DescribeRuleOutput)
    pub fn builder() -> crate::output::describe_rule_output::Builder {
        crate::output::describe_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplayOutput {
    /// <p>The name of the replay.</p>
    pub replay_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the replay.</p>
    pub replay_arn: std::option::Option<std::string::String>,
    /// <p>The description of the replay.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current state of the replay.</p>
    pub state: std::option::Option<crate::model::ReplayState>,
    /// <p>The reason that the replay is in the current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The ARN of the archive events were replayed from.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>A <code>ReplayDestination</code> object that contains details about the replay.</p>
    pub destination: std::option::Option<crate::model::ReplayDestination>,
    /// <p>The time stamp of the first event that was last replayed from the archive.</p>
    pub event_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time stamp for the last event that was replayed from the archive.</p>
    pub event_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the event was last replayed.</p>
    pub event_last_replayed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the replay started.</p>
    pub replay_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the replay stopped.</p>
    pub replay_end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeReplayOutput {
    /// <p>The name of the replay.</p>
    pub fn replay_name(&self) -> std::option::Option<&str> {
        self.replay_name.as_deref()
    }
    /// <p>The ARN of the replay.</p>
    pub fn replay_arn(&self) -> std::option::Option<&str> {
        self.replay_arn.as_deref()
    }
    /// <p>The description of the replay.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The current state of the replay.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ReplayState> {
        self.state.as_ref()
    }
    /// <p>The reason that the replay is in the current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The ARN of the archive events were replayed from.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>A <code>ReplayDestination</code> object that contains details about the replay.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::ReplayDestination> {
        self.destination.as_ref()
    }
    /// <p>The time stamp of the first event that was last replayed from the archive.</p>
    pub fn event_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_start_time.as_ref()
    }
    /// <p>The time stamp for the last event that was replayed from the archive.</p>
    pub fn event_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_end_time.as_ref()
    }
    /// <p>The time that the event was last replayed.</p>
    pub fn event_last_replayed_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_last_replayed_time.as_ref()
    }
    /// <p>A time stamp for the time that the replay started.</p>
    pub fn replay_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.replay_start_time.as_ref()
    }
    /// <p>A time stamp for the time that the replay stopped.</p>
    pub fn replay_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.replay_end_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeReplayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplayOutput");
        formatter.field("replay_name", &self.replay_name);
        formatter.field("replay_arn", &self.replay_arn);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("destination", &self.destination);
        formatter.field("event_start_time", &self.event_start_time);
        formatter.field("event_end_time", &self.event_end_time);
        formatter.field("event_last_replayed_time", &self.event_last_replayed_time);
        formatter.field("replay_start_time", &self.replay_start_time);
        formatter.field("replay_end_time", &self.replay_end_time);
        formatter.finish()
    }
}
/// See [`DescribeReplayOutput`](crate::output::DescribeReplayOutput)
pub mod describe_replay_output {
    /// A builder for [`DescribeReplayOutput`](crate::output::DescribeReplayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replay_name: std::option::Option<std::string::String>,
        pub(crate) replay_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReplayState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::ReplayDestination>,
        pub(crate) event_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_last_replayed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) replay_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) replay_end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the replay.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_name = Some(input.into());
            self
        }
        /// <p>The name of the replay.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_name = input;
            self
        }
        /// <p>The ARN of the replay.</p>
        pub fn replay_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the replay.</p>
        pub fn set_replay_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_arn = input;
            self
        }
        /// <p>The description of the replay.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the replay.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current state of the replay.</p>
        pub fn state(mut self, input: crate::model::ReplayState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the replay.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ReplayState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason that the replay is in the current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the replay is in the current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The ARN of the archive events were replayed from.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the archive events were replayed from.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>A <code>ReplayDestination</code> object that contains details about the replay.</p>
        pub fn destination(mut self, input: crate::model::ReplayDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>A <code>ReplayDestination</code> object that contains details about the replay.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::ReplayDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The time stamp of the first event that was last replayed from the archive.</p>
        pub fn event_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_start_time = Some(input);
            self
        }
        /// <p>The time stamp of the first event that was last replayed from the archive.</p>
        pub fn set_event_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_start_time = input;
            self
        }
        /// <p>The time stamp for the last event that was replayed from the archive.</p>
        pub fn event_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_end_time = Some(input);
            self
        }
        /// <p>The time stamp for the last event that was replayed from the archive.</p>
        pub fn set_event_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_end_time = input;
            self
        }
        /// <p>The time that the event was last replayed.</p>
        pub fn event_last_replayed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_last_replayed_time = Some(input);
            self
        }
        /// <p>The time that the event was last replayed.</p>
        pub fn set_event_last_replayed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_last_replayed_time = input;
            self
        }
        /// <p>A time stamp for the time that the replay started.</p>
        pub fn replay_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.replay_start_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the replay started.</p>
        pub fn set_replay_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.replay_start_time = input;
            self
        }
        /// <p>A time stamp for the time that the replay stopped.</p>
        pub fn replay_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.replay_end_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the replay stopped.</p>
        pub fn set_replay_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.replay_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplayOutput`](crate::output::DescribeReplayOutput)
        pub fn build(self) -> crate::output::DescribeReplayOutput {
            crate::output::DescribeReplayOutput {
                replay_name: self.replay_name,
                replay_arn: self.replay_arn,
                description: self.description,
                state: self.state,
                state_reason: self.state_reason,
                event_source_arn: self.event_source_arn,
                destination: self.destination,
                event_start_time: self.event_start_time,
                event_end_time: self.event_end_time,
                event_last_replayed_time: self.event_last_replayed_time,
                replay_start_time: self.replay_start_time,
                replay_end_time: self.replay_end_time,
            }
        }
    }
}
impl DescribeReplayOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReplayOutput`](crate::output::DescribeReplayOutput)
    pub fn builder() -> crate::output::describe_replay_output::Builder {
        crate::output::describe_replay_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePartnerEventSourceOutput {
    /// <p>The ARN of the event source.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the event source.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribePartnerEventSourceOutput {
    /// <p>The ARN of the event source.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the event source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribePartnerEventSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePartnerEventSourceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DescribePartnerEventSourceOutput`](crate::output::DescribePartnerEventSourceOutput)
pub mod describe_partner_event_source_output {
    /// A builder for [`DescribePartnerEventSourceOutput`](crate::output::DescribePartnerEventSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the event source.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event source.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the event source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePartnerEventSourceOutput`](crate::output::DescribePartnerEventSourceOutput)
        pub fn build(self) -> crate::output::DescribePartnerEventSourceOutput {
            crate::output::DescribePartnerEventSourceOutput {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl DescribePartnerEventSourceOutput {
    /// Creates a new builder-style object to manufacture [`DescribePartnerEventSourceOutput`](crate::output::DescribePartnerEventSourceOutput)
    pub fn builder() -> crate::output::describe_partner_event_source_output::Builder {
        crate::output::describe_partner_event_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSourceOutput {
    /// <p>The ARN of the partner event source.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the SaaS partner that created the event source.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the event source was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the event source will expire if you do not create a matching event
    /// bus.</p>
    pub expiration_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the partner event source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
    /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
    /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
    /// created a matching event bus, but the event source has since been deleted.</p>
    pub state: std::option::Option<crate::model::EventSourceState>,
}
impl DescribeEventSourceOutput {
    /// <p>The ARN of the partner event source.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the SaaS partner that created the event source.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The date and time that the event source was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time that the event source will expire if you do not create a matching event
    /// bus.</p>
    pub fn expiration_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expiration_time.as_ref()
    }
    /// <p>The name of the partner event source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
    /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
    /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
    /// created a matching event bus, but the event source has since been deleted.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::EventSourceState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for DescribeEventSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSourceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("created_by", &self.created_by);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`DescribeEventSourceOutput`](crate::output::DescribeEventSourceOutput)
pub mod describe_event_source_output {
    /// A builder for [`DescribeEventSourceOutput`](crate::output::DescribeEventSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EventSourceState>,
    }
    impl Builder {
        /// <p>The ARN of the partner event source.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the partner event source.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the SaaS partner that created the event source.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The name of the SaaS partner that created the event source.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time that the event source was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that the event source was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the event source will expire if you do not create a matching event
        /// bus.</p>
        pub fn expiration_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>The date and time that the event source will expire if you do not create a matching event
        /// bus.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p>The name of the partner event source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the partner event source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
        /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
        /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
        /// created a matching event bus, but the event source has since been deleted.</p>
        pub fn state(mut self, input: crate::model::EventSourceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
        /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
        /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
        /// created a matching event bus, but the event source has since been deleted.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EventSourceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSourceOutput`](crate::output::DescribeEventSourceOutput)
        pub fn build(self) -> crate::output::DescribeEventSourceOutput {
            crate::output::DescribeEventSourceOutput {
                arn: self.arn,
                created_by: self.created_by,
                creation_time: self.creation_time,
                expiration_time: self.expiration_time,
                name: self.name,
                state: self.state,
            }
        }
    }
}
impl DescribeEventSourceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventSourceOutput`](crate::output::DescribeEventSourceOutput)
    pub fn builder() -> crate::output::describe_event_source_output::Builder {
        crate::output::describe_event_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventBusOutput {
    /// <p>The name of the event bus. Currently, this is always <code>default</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the account permitted to write events to the current
    /// account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The policy that enables the external account to send events to your account.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl DescribeEventBusOutput {
    /// <p>The name of the event bus. Currently, this is always <code>default</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the account permitted to write events to the current
    /// account.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The policy that enables the external account to send events to your account.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventBusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventBusOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`DescribeEventBusOutput`](crate::output::DescribeEventBusOutput)
pub mod describe_event_bus_output {
    /// A builder for [`DescribeEventBusOutput`](crate::output::DescribeEventBusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event bus. Currently, this is always <code>default</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event bus. Currently, this is always <code>default</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account permitted to write events to the current
        /// account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account permitted to write events to the current
        /// account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The policy that enables the external account to send events to your account.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy that enables the external account to send events to your account.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventBusOutput`](crate::output::DescribeEventBusOutput)
        pub fn build(self) -> crate::output::DescribeEventBusOutput {
            crate::output::DescribeEventBusOutput {
                name: self.name,
                arn: self.arn,
                policy: self.policy,
            }
        }
    }
}
impl DescribeEventBusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventBusOutput`](crate::output::DescribeEventBusOutput)
    pub fn builder() -> crate::output::describe_event_bus_output::Builder {
        crate::output::describe_event_bus_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionOutput {
    /// <p>The ARN of the connection retrieved.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The name of the connection retrieved.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description for the connection retrieved.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the connection retrieved.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The reason that the connection is in the current connection state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The type of authorization specified for the connection.</p>
    pub authorization_type: std::option::Option<crate::model::ConnectionAuthorizationType>,
    /// <p>The ARN of the secret created from the authorization parameters specified for the
    /// connection.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The parameters to use for authorization for the connection.</p>
    pub auth_parameters: std::option::Option<crate::model::ConnectionAuthResponseParameters>,
    /// <p>A time stamp for the time that the connection was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last authorized.</p>
    pub last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeConnectionOutput {
    /// <p>The ARN of the connection retrieved.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The name of the connection retrieved.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description for the connection retrieved.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The state of the connection retrieved.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>The reason that the connection is in the current connection state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The type of authorization specified for the connection.</p>
    pub fn authorization_type(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionAuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The ARN of the secret created from the authorization parameters specified for the
    /// connection.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The parameters to use for authorization for the connection.</p>
    pub fn auth_parameters(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionAuthResponseParameters> {
        self.auth_parameters.as_ref()
    }
    /// <p>A time stamp for the time that the connection was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last authorized.</p>
    pub fn last_authorized_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_authorized_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionOutput");
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("auth_parameters", &self.auth_parameters);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_authorized_time", &self.last_authorized_time);
        formatter.finish()
    }
}
/// See [`DescribeConnectionOutput`](crate::output::DescribeConnectionOutput)
pub mod describe_connection_output {
    /// A builder for [`DescribeConnectionOutput`](crate::output::DescribeConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) authorization_type:
            std::option::Option<crate::model::ConnectionAuthorizationType>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) auth_parameters:
            std::option::Option<crate::model::ConnectionAuthResponseParameters>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the connection retrieved.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection retrieved.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The name of the connection retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description for the connection retrieved.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the connection retrieved.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the connection retrieved.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection retrieved.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The reason that the connection is in the current connection state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the connection is in the current connection state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The type of authorization specified for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The type of authorization specified for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The ARN of the secret created from the authorization parameters specified for the
        /// connection.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret created from the authorization parameters specified for the
        /// connection.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The parameters to use for authorization for the connection.</p>
        pub fn auth_parameters(
            mut self,
            input: crate::model::ConnectionAuthResponseParameters,
        ) -> Self {
            self.auth_parameters = Some(input);
            self
        }
        /// <p>The parameters to use for authorization for the connection.</p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthResponseParameters>,
        ) -> Self {
            self.auth_parameters = input;
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn last_authorized_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authorized_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn set_last_authorized_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authorized_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionOutput`](crate::output::DescribeConnectionOutput)
        pub fn build(self) -> crate::output::DescribeConnectionOutput {
            crate::output::DescribeConnectionOutput {
                connection_arn: self.connection_arn,
                name: self.name,
                description: self.description,
                connection_state: self.connection_state,
                state_reason: self.state_reason,
                authorization_type: self.authorization_type,
                secret_arn: self.secret_arn,
                auth_parameters: self.auth_parameters,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_authorized_time: self.last_authorized_time,
            }
        }
    }
}
impl DescribeConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionOutput`](crate::output::DescribeConnectionOutput)
    pub fn builder() -> crate::output::describe_connection_output::Builder {
        crate::output::describe_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeArchiveOutput {
    /// <p>The ARN of the archive.</p>
    pub archive_arn: std::option::Option<std::string::String>,
    /// <p>The name of the archive.</p>
    pub archive_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the event source associated with the archive.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The description of the archive.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The event pattern used to filter events sent to the archive.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>The state of the archive.</p>
    pub state: std::option::Option<crate::model::ArchiveState>,
    /// <p>The reason that the archive is in the state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The number of days to retain events for in the archive.</p>
    pub retention_days: std::option::Option<i32>,
    /// <p>The size of the archive in bytes.</p>
    pub size_bytes: i64,
    /// <p>The number of events in the archive.</p>
    pub event_count: i64,
    /// <p>The time at which the archive was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeArchiveOutput {
    /// <p>The ARN of the archive.</p>
    pub fn archive_arn(&self) -> std::option::Option<&str> {
        self.archive_arn.as_deref()
    }
    /// <p>The name of the archive.</p>
    pub fn archive_name(&self) -> std::option::Option<&str> {
        self.archive_name.as_deref()
    }
    /// <p>The ARN of the event source associated with the archive.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The description of the archive.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The event pattern used to filter events sent to the archive.</p>
    pub fn event_pattern(&self) -> std::option::Option<&str> {
        self.event_pattern.as_deref()
    }
    /// <p>The state of the archive.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ArchiveState> {
        self.state.as_ref()
    }
    /// <p>The reason that the archive is in the state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The number of days to retain events for in the archive.</p>
    pub fn retention_days(&self) -> std::option::Option<i32> {
        self.retention_days
    }
    /// <p>The size of the archive in bytes.</p>
    pub fn size_bytes(&self) -> i64 {
        self.size_bytes
    }
    /// <p>The number of events in the archive.</p>
    pub fn event_count(&self) -> i64 {
        self.event_count
    }
    /// <p>The time at which the archive was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeArchiveOutput");
        formatter.field("archive_arn", &self.archive_arn);
        formatter.field("archive_name", &self.archive_name);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("description", &self.description);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("retention_days", &self.retention_days);
        formatter.field("size_bytes", &self.size_bytes);
        formatter.field("event_count", &self.event_count);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeArchiveOutput`](crate::output::DescribeArchiveOutput)
pub mod describe_archive_output {
    /// A builder for [`DescribeArchiveOutput`](crate::output::DescribeArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_arn: std::option::Option<std::string::String>,
        pub(crate) archive_name: std::option::Option<std::string::String>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ArchiveState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) retention_days: std::option::Option<i32>,
        pub(crate) size_bytes: std::option::Option<i64>,
        pub(crate) event_count: std::option::Option<i64>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the archive.</p>
        pub fn archive_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the archive.</p>
        pub fn set_archive_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_arn = input;
            self
        }
        /// <p>The name of the archive.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_name = Some(input.into());
            self
        }
        /// <p>The name of the archive.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_name = input;
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The description of the archive.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the archive.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The event pattern used to filter events sent to the archive.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The event pattern used to filter events sent to the archive.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>The state of the archive.</p>
        pub fn state(mut self, input: crate::model::ArchiveState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the archive.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ArchiveState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason that the archive is in the state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the archive is in the state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The number of days to retain events for in the archive.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain events for in the archive.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// <p>The size of the archive in bytes.</p>
        pub fn size_bytes(mut self, input: i64) -> Self {
            self.size_bytes = Some(input);
            self
        }
        /// <p>The size of the archive in bytes.</p>
        pub fn set_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.size_bytes = input;
            self
        }
        /// <p>The number of events in the archive.</p>
        pub fn event_count(mut self, input: i64) -> Self {
            self.event_count = Some(input);
            self
        }
        /// <p>The number of events in the archive.</p>
        pub fn set_event_count(mut self, input: std::option::Option<i64>) -> Self {
            self.event_count = input;
            self
        }
        /// <p>The time at which the archive was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the archive was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeArchiveOutput`](crate::output::DescribeArchiveOutput)
        pub fn build(self) -> crate::output::DescribeArchiveOutput {
            crate::output::DescribeArchiveOutput {
                archive_arn: self.archive_arn,
                archive_name: self.archive_name,
                event_source_arn: self.event_source_arn,
                description: self.description,
                event_pattern: self.event_pattern,
                state: self.state,
                state_reason: self.state_reason,
                retention_days: self.retention_days,
                size_bytes: self.size_bytes.unwrap_or_default(),
                event_count: self.event_count.unwrap_or_default(),
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeArchiveOutput {
    /// Creates a new builder-style object to manufacture [`DescribeArchiveOutput`](crate::output::DescribeArchiveOutput)
    pub fn builder() -> crate::output::describe_archive_output::Builder {
        crate::output::describe_archive_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApiDestinationOutput {
    /// <p>The ARN of the API destination retrieved.</p>
    pub api_destination_arn: std::option::Option<std::string::String>,
    /// <p>The name of the API destination retrieved.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description for the API destination retrieved.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the API destination retrieved.</p>
    pub api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
    /// <p>The ARN of the connection specified for the API destination retrieved.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The URL to use to connect to the HTTP endpoint.</p>
    pub invocation_endpoint: std::option::Option<std::string::String>,
    /// <p>The method to use to connect to the HTTP endpoint.</p>
    pub http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
    /// <p>The maximum number of invocations per second to specified for the API destination. Note
    /// that if you set the invocation rate maximum to a value lower the rate necessary to send all
    /// events received on to the destination HTTP endpoint, some events may not be delivered within
    /// the 24-hour retry window. If you plan to set the rate lower than the rate necessary to deliver
    /// all events, consider using a dead-letter queue to catch events that are not delivered within
    /// 24 hours.</p>
    pub invocation_rate_limit_per_second: std::option::Option<i32>,
    /// <p>A time stamp for the time that the API destination was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the API destination was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeApiDestinationOutput {
    /// <p>The ARN of the API destination retrieved.</p>
    pub fn api_destination_arn(&self) -> std::option::Option<&str> {
        self.api_destination_arn.as_deref()
    }
    /// <p>The name of the API destination retrieved.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description for the API destination retrieved.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The state of the API destination retrieved.</p>
    pub fn api_destination_state(&self) -> std::option::Option<&crate::model::ApiDestinationState> {
        self.api_destination_state.as_ref()
    }
    /// <p>The ARN of the connection specified for the API destination retrieved.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The URL to use to connect to the HTTP endpoint.</p>
    pub fn invocation_endpoint(&self) -> std::option::Option<&str> {
        self.invocation_endpoint.as_deref()
    }
    /// <p>The method to use to connect to the HTTP endpoint.</p>
    pub fn http_method(&self) -> std::option::Option<&crate::model::ApiDestinationHttpMethod> {
        self.http_method.as_ref()
    }
    /// <p>The maximum number of invocations per second to specified for the API destination. Note
    /// that if you set the invocation rate maximum to a value lower the rate necessary to send all
    /// events received on to the destination HTTP endpoint, some events may not be delivered within
    /// the 24-hour retry window. If you plan to set the rate lower than the rate necessary to deliver
    /// all events, consider using a dead-letter queue to catch events that are not delivered within
    /// 24 hours.</p>
    pub fn invocation_rate_limit_per_second(&self) -> std::option::Option<i32> {
        self.invocation_rate_limit_per_second
    }
    /// <p>A time stamp for the time that the API destination was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp for the time that the API destination was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeApiDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApiDestinationOutput");
        formatter.field("api_destination_arn", &self.api_destination_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("api_destination_state", &self.api_destination_state);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("invocation_endpoint", &self.invocation_endpoint);
        formatter.field("http_method", &self.http_method);
        formatter.field(
            "invocation_rate_limit_per_second",
            &self.invocation_rate_limit_per_second,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`DescribeApiDestinationOutput`](crate::output::DescribeApiDestinationOutput)
pub mod describe_api_destination_output {
    /// A builder for [`DescribeApiDestinationOutput`](crate::output::DescribeApiDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_destination_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) invocation_endpoint: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        pub(crate) invocation_rate_limit_per_second: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the API destination retrieved.</p>
        pub fn api_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the API destination retrieved.</p>
        pub fn set_api_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_destination_arn = input;
            self
        }
        /// <p>The name of the API destination retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API destination retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description for the API destination retrieved.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the API destination retrieved.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the API destination retrieved.</p>
        pub fn api_destination_state(mut self, input: crate::model::ApiDestinationState) -> Self {
            self.api_destination_state = Some(input);
            self
        }
        /// <p>The state of the API destination retrieved.</p>
        pub fn set_api_destination_state(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationState>,
        ) -> Self {
            self.api_destination_state = input;
            self
        }
        /// <p>The ARN of the connection specified for the API destination retrieved.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection specified for the API destination retrieved.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The URL to use to connect to the HTTP endpoint.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_endpoint = Some(input.into());
            self
        }
        /// <p>The URL to use to connect to the HTTP endpoint.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_endpoint = input;
            self
        }
        /// <p>The method to use to connect to the HTTP endpoint.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.http_method = Some(input);
            self
        }
        /// <p>The method to use to connect to the HTTP endpoint.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The maximum number of invocations per second to specified for the API destination. Note
        /// that if you set the invocation rate maximum to a value lower the rate necessary to send all
        /// events received on to the destination HTTP endpoint, some events may not be delivered within
        /// the 24-hour retry window. If you plan to set the rate lower than the rate necessary to deliver
        /// all events, consider using a dead-letter queue to catch events that are not delivered within
        /// 24 hours.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.invocation_rate_limit_per_second = Some(input);
            self
        }
        /// <p>The maximum number of invocations per second to specified for the API destination. Note
        /// that if you set the invocation rate maximum to a value lower the rate necessary to send all
        /// events received on to the destination HTTP endpoint, some events may not be delivered within
        /// the 24-hour retry window. If you plan to set the rate lower than the rate necessary to deliver
        /// all events, consider using a dead-letter queue to catch events that are not delivered within
        /// 24 hours.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.invocation_rate_limit_per_second = input;
            self
        }
        /// <p>A time stamp for the time that the API destination was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the API destination was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the API destination was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the API destination was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApiDestinationOutput`](crate::output::DescribeApiDestinationOutput)
        pub fn build(self) -> crate::output::DescribeApiDestinationOutput {
            crate::output::DescribeApiDestinationOutput {
                api_destination_arn: self.api_destination_arn,
                name: self.name,
                description: self.description,
                api_destination_state: self.api_destination_state,
                connection_arn: self.connection_arn,
                invocation_endpoint: self.invocation_endpoint,
                http_method: self.http_method,
                invocation_rate_limit_per_second: self.invocation_rate_limit_per_second,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl DescribeApiDestinationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeApiDestinationOutput`](crate::output::DescribeApiDestinationOutput)
    pub fn builder() -> crate::output::describe_api_destination_output::Builder {
        crate::output::describe_api_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleOutput {}
impl std::fmt::Debug for DeleteRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
pub mod delete_rule_output {
    /// A builder for [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
        pub fn build(self) -> crate::output::DeleteRuleOutput {
            crate::output::DeleteRuleOutput {}
        }
    }
}
impl DeleteRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    pub fn builder() -> crate::output::delete_rule_output::Builder {
        crate::output::delete_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePartnerEventSourceOutput {}
impl std::fmt::Debug for DeletePartnerEventSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePartnerEventSourceOutput");
        formatter.finish()
    }
}
/// See [`DeletePartnerEventSourceOutput`](crate::output::DeletePartnerEventSourceOutput)
pub mod delete_partner_event_source_output {
    /// A builder for [`DeletePartnerEventSourceOutput`](crate::output::DeletePartnerEventSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePartnerEventSourceOutput`](crate::output::DeletePartnerEventSourceOutput)
        pub fn build(self) -> crate::output::DeletePartnerEventSourceOutput {
            crate::output::DeletePartnerEventSourceOutput {}
        }
    }
}
impl DeletePartnerEventSourceOutput {
    /// Creates a new builder-style object to manufacture [`DeletePartnerEventSourceOutput`](crate::output::DeletePartnerEventSourceOutput)
    pub fn builder() -> crate::output::delete_partner_event_source_output::Builder {
        crate::output::delete_partner_event_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventBusOutput {}
impl std::fmt::Debug for DeleteEventBusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventBusOutput");
        formatter.finish()
    }
}
/// See [`DeleteEventBusOutput`](crate::output::DeleteEventBusOutput)
pub mod delete_event_bus_output {
    /// A builder for [`DeleteEventBusOutput`](crate::output::DeleteEventBusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEventBusOutput`](crate::output::DeleteEventBusOutput)
        pub fn build(self) -> crate::output::DeleteEventBusOutput {
            crate::output::DeleteEventBusOutput {}
        }
    }
}
impl DeleteEventBusOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventBusOutput`](crate::output::DeleteEventBusOutput)
    pub fn builder() -> crate::output::delete_event_bus_output::Builder {
        crate::output::delete_event_bus_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionOutput {
    /// <p>The ARN of the connection that was deleted.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The state of the connection before it was deleted.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>A time stamp for the time that the connection was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last modified before it was
    /// deleted.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last authorized before it wa
    /// deleted.</p>
    pub last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DeleteConnectionOutput {
    /// <p>The ARN of the connection that was deleted.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The state of the connection before it was deleted.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>A time stamp for the time that the connection was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last modified before it was
    /// deleted.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last authorized before it wa
    /// deleted.</p>
    pub fn last_authorized_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_authorized_time.as_ref()
    }
}
impl std::fmt::Debug for DeleteConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionOutput");
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_authorized_time", &self.last_authorized_time);
        formatter.finish()
    }
}
/// See [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
pub mod delete_connection_output {
    /// A builder for [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the connection that was deleted.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection that was deleted.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The state of the connection before it was deleted.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection before it was deleted.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last modified before it was
        /// deleted.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last modified before it was
        /// deleted.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized before it wa
        /// deleted.</p>
        pub fn last_authorized_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authorized_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized before it wa
        /// deleted.</p>
        pub fn set_last_authorized_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authorized_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
        pub fn build(self) -> crate::output::DeleteConnectionOutput {
            crate::output::DeleteConnectionOutput {
                connection_arn: self.connection_arn,
                connection_state: self.connection_state,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_authorized_time: self.last_authorized_time,
            }
        }
    }
}
impl DeleteConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    pub fn builder() -> crate::output::delete_connection_output::Builder {
        crate::output::delete_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteArchiveOutput {}
impl std::fmt::Debug for DeleteArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteArchiveOutput");
        formatter.finish()
    }
}
/// See [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
pub mod delete_archive_output {
    /// A builder for [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
        pub fn build(self) -> crate::output::DeleteArchiveOutput {
            crate::output::DeleteArchiveOutput {}
        }
    }
}
impl DeleteArchiveOutput {
    /// Creates a new builder-style object to manufacture [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
    pub fn builder() -> crate::output::delete_archive_output::Builder {
        crate::output::delete_archive_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiDestinationOutput {}
impl std::fmt::Debug for DeleteApiDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiDestinationOutput");
        formatter.finish()
    }
}
/// See [`DeleteApiDestinationOutput`](crate::output::DeleteApiDestinationOutput)
pub mod delete_api_destination_output {
    /// A builder for [`DeleteApiDestinationOutput`](crate::output::DeleteApiDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApiDestinationOutput`](crate::output::DeleteApiDestinationOutput)
        pub fn build(self) -> crate::output::DeleteApiDestinationOutput {
            crate::output::DeleteApiDestinationOutput {}
        }
    }
}
impl DeleteApiDestinationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApiDestinationOutput`](crate::output::DeleteApiDestinationOutput)
    pub fn builder() -> crate::output::delete_api_destination_output::Builder {
        crate::output::delete_api_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeauthorizeConnectionOutput {
    /// <p>The ARN of the connection that authorization was removed from.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The state of the connection.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>A time stamp for the time that the connection was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last authorized.</p>
    pub last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DeauthorizeConnectionOutput {
    /// <p>The ARN of the connection that authorization was removed from.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The state of the connection.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>A time stamp for the time that the connection was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last updated.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last authorized.</p>
    pub fn last_authorized_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_authorized_time.as_ref()
    }
}
impl std::fmt::Debug for DeauthorizeConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeauthorizeConnectionOutput");
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_authorized_time", &self.last_authorized_time);
        formatter.finish()
    }
}
/// See [`DeauthorizeConnectionOutput`](crate::output::DeauthorizeConnectionOutput)
pub mod deauthorize_connection_output {
    /// A builder for [`DeauthorizeConnectionOutput`](crate::output::DeauthorizeConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the connection that authorization was removed from.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection that authorization was removed from.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The state of the connection.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn last_authorized_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authorized_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn set_last_authorized_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authorized_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeauthorizeConnectionOutput`](crate::output::DeauthorizeConnectionOutput)
        pub fn build(self) -> crate::output::DeauthorizeConnectionOutput {
            crate::output::DeauthorizeConnectionOutput {
                connection_arn: self.connection_arn,
                connection_state: self.connection_state,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_authorized_time: self.last_authorized_time,
            }
        }
    }
}
impl DeauthorizeConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeauthorizeConnectionOutput`](crate::output::DeauthorizeConnectionOutput)
    pub fn builder() -> crate::output::deauthorize_connection_output::Builder {
        crate::output::deauthorize_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateEventSourceOutput {}
impl std::fmt::Debug for DeactivateEventSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateEventSourceOutput");
        formatter.finish()
    }
}
/// See [`DeactivateEventSourceOutput`](crate::output::DeactivateEventSourceOutput)
pub mod deactivate_event_source_output {
    /// A builder for [`DeactivateEventSourceOutput`](crate::output::DeactivateEventSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeactivateEventSourceOutput`](crate::output::DeactivateEventSourceOutput)
        pub fn build(self) -> crate::output::DeactivateEventSourceOutput {
            crate::output::DeactivateEventSourceOutput {}
        }
    }
}
impl DeactivateEventSourceOutput {
    /// Creates a new builder-style object to manufacture [`DeactivateEventSourceOutput`](crate::output::DeactivateEventSourceOutput)
    pub fn builder() -> crate::output::deactivate_event_source_output::Builder {
        crate::output::deactivate_event_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePartnerEventSourceOutput {
    /// <p>The ARN of the partner event source.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
}
impl CreatePartnerEventSourceOutput {
    /// <p>The ARN of the partner event source.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
}
impl std::fmt::Debug for CreatePartnerEventSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePartnerEventSourceOutput");
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.finish()
    }
}
/// See [`CreatePartnerEventSourceOutput`](crate::output::CreatePartnerEventSourceOutput)
pub mod create_partner_event_source_output {
    /// A builder for [`CreatePartnerEventSourceOutput`](crate::output::CreatePartnerEventSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the partner event source.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the partner event source.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePartnerEventSourceOutput`](crate::output::CreatePartnerEventSourceOutput)
        pub fn build(self) -> crate::output::CreatePartnerEventSourceOutput {
            crate::output::CreatePartnerEventSourceOutput {
                event_source_arn: self.event_source_arn,
            }
        }
    }
}
impl CreatePartnerEventSourceOutput {
    /// Creates a new builder-style object to manufacture [`CreatePartnerEventSourceOutput`](crate::output::CreatePartnerEventSourceOutput)
    pub fn builder() -> crate::output::create_partner_event_source_output::Builder {
        crate::output::create_partner_event_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventBusOutput {
    /// <p>The ARN of the new event bus.</p>
    pub event_bus_arn: std::option::Option<std::string::String>,
}
impl CreateEventBusOutput {
    /// <p>The ARN of the new event bus.</p>
    pub fn event_bus_arn(&self) -> std::option::Option<&str> {
        self.event_bus_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateEventBusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventBusOutput");
        formatter.field("event_bus_arn", &self.event_bus_arn);
        formatter.finish()
    }
}
/// See [`CreateEventBusOutput`](crate::output::CreateEventBusOutput)
pub mod create_event_bus_output {
    /// A builder for [`CreateEventBusOutput`](crate::output::CreateEventBusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_bus_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the new event bus.</p>
        pub fn event_bus_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the new event bus.</p>
        pub fn set_event_bus_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventBusOutput`](crate::output::CreateEventBusOutput)
        pub fn build(self) -> crate::output::CreateEventBusOutput {
            crate::output::CreateEventBusOutput {
                event_bus_arn: self.event_bus_arn,
            }
        }
    }
}
impl CreateEventBusOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventBusOutput`](crate::output::CreateEventBusOutput)
    pub fn builder() -> crate::output::create_event_bus_output::Builder {
        crate::output::create_event_bus_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOutput {
    /// <p>The ARN of the connection that was created by the request.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The state of the connection that was created by the request.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>A time stamp for the time that the connection was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateConnectionOutput {
    /// <p>The ARN of the connection that was created by the request.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The state of the connection that was created by the request.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>A time stamp for the time that the connection was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp for the time that the connection was last updated.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
}
impl std::fmt::Debug for CreateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOutput");
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
pub mod create_connection_output {
    /// A builder for [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the connection that was created by the request.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection that was created by the request.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The state of the connection that was created by the request.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection that was created by the request.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
        pub fn build(self) -> crate::output::CreateConnectionOutput {
            crate::output::CreateConnectionOutput {
                connection_arn: self.connection_arn,
                connection_state: self.connection_state,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl CreateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    pub fn builder() -> crate::output::create_connection_output::Builder {
        crate::output::create_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateArchiveOutput {
    /// <p>The ARN of the archive that was created.</p>
    pub archive_arn: std::option::Option<std::string::String>,
    /// <p>The state of the archive that was created.</p>
    pub state: std::option::Option<crate::model::ArchiveState>,
    /// <p>The reason that the archive is in the state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The time at which the archive was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateArchiveOutput {
    /// <p>The ARN of the archive that was created.</p>
    pub fn archive_arn(&self) -> std::option::Option<&str> {
        self.archive_arn.as_deref()
    }
    /// <p>The state of the archive that was created.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ArchiveState> {
        self.state.as_ref()
    }
    /// <p>The reason that the archive is in the state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The time at which the archive was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for CreateArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateArchiveOutput");
        formatter.field("archive_arn", &self.archive_arn);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`CreateArchiveOutput`](crate::output::CreateArchiveOutput)
pub mod create_archive_output {
    /// A builder for [`CreateArchiveOutput`](crate::output::CreateArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ArchiveState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the archive that was created.</p>
        pub fn archive_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the archive that was created.</p>
        pub fn set_archive_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_arn = input;
            self
        }
        /// <p>The state of the archive that was created.</p>
        pub fn state(mut self, input: crate::model::ArchiveState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the archive that was created.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ArchiveState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason that the archive is in the state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the archive is in the state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The time at which the archive was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the archive was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateArchiveOutput`](crate::output::CreateArchiveOutput)
        pub fn build(self) -> crate::output::CreateArchiveOutput {
            crate::output::CreateArchiveOutput {
                archive_arn: self.archive_arn,
                state: self.state,
                state_reason: self.state_reason,
                creation_time: self.creation_time,
            }
        }
    }
}
impl CreateArchiveOutput {
    /// Creates a new builder-style object to manufacture [`CreateArchiveOutput`](crate::output::CreateArchiveOutput)
    pub fn builder() -> crate::output::create_archive_output::Builder {
        crate::output::create_archive_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiDestinationOutput {
    /// <p>The ARN of the API destination that was created by the request.</p>
    pub api_destination_arn: std::option::Option<std::string::String>,
    /// <p>The state of the API destination that was created by the request.</p>
    pub api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
    /// <p>A time stamp indicating the time that the API destination was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp indicating the time that the API destination was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateApiDestinationOutput {
    /// <p>The ARN of the API destination that was created by the request.</p>
    pub fn api_destination_arn(&self) -> std::option::Option<&str> {
        self.api_destination_arn.as_deref()
    }
    /// <p>The state of the API destination that was created by the request.</p>
    pub fn api_destination_state(&self) -> std::option::Option<&crate::model::ApiDestinationState> {
        self.api_destination_state.as_ref()
    }
    /// <p>A time stamp indicating the time that the API destination was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp indicating the time that the API destination was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
}
impl std::fmt::Debug for CreateApiDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiDestinationOutput");
        formatter.field("api_destination_arn", &self.api_destination_arn);
        formatter.field("api_destination_state", &self.api_destination_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`CreateApiDestinationOutput`](crate::output::CreateApiDestinationOutput)
pub mod create_api_destination_output {
    /// A builder for [`CreateApiDestinationOutput`](crate::output::CreateApiDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_destination_arn: std::option::Option<std::string::String>,
        pub(crate) api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the API destination that was created by the request.</p>
        pub fn api_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the API destination that was created by the request.</p>
        pub fn set_api_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_destination_arn = input;
            self
        }
        /// <p>The state of the API destination that was created by the request.</p>
        pub fn api_destination_state(mut self, input: crate::model::ApiDestinationState) -> Self {
            self.api_destination_state = Some(input);
            self
        }
        /// <p>The state of the API destination that was created by the request.</p>
        pub fn set_api_destination_state(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationState>,
        ) -> Self {
            self.api_destination_state = input;
            self
        }
        /// <p>A time stamp indicating the time that the API destination was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating the time that the API destination was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp indicating the time that the API destination was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp indicating the time that the API destination was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiDestinationOutput`](crate::output::CreateApiDestinationOutput)
        pub fn build(self) -> crate::output::CreateApiDestinationOutput {
            crate::output::CreateApiDestinationOutput {
                api_destination_arn: self.api_destination_arn,
                api_destination_state: self.api_destination_state,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl CreateApiDestinationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApiDestinationOutput`](crate::output::CreateApiDestinationOutput)
    pub fn builder() -> crate::output::create_api_destination_output::Builder {
        crate::output::create_api_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelReplayOutput {
    /// <p>The ARN of the replay to cancel.</p>
    pub replay_arn: std::option::Option<std::string::String>,
    /// <p>The current state of the replay.</p>
    pub state: std::option::Option<crate::model::ReplayState>,
    /// <p>The reason that the replay is in the current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
}
impl CancelReplayOutput {
    /// <p>The ARN of the replay to cancel.</p>
    pub fn replay_arn(&self) -> std::option::Option<&str> {
        self.replay_arn.as_deref()
    }
    /// <p>The current state of the replay.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ReplayState> {
        self.state.as_ref()
    }
    /// <p>The reason that the replay is in the current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
}
impl std::fmt::Debug for CancelReplayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelReplayOutput");
        formatter.field("replay_arn", &self.replay_arn);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.finish()
    }
}
/// See [`CancelReplayOutput`](crate::output::CancelReplayOutput)
pub mod cancel_replay_output {
    /// A builder for [`CancelReplayOutput`](crate::output::CancelReplayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replay_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReplayState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the replay to cancel.</p>
        pub fn replay_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the replay to cancel.</p>
        pub fn set_replay_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_arn = input;
            self
        }
        /// <p>The current state of the replay.</p>
        pub fn state(mut self, input: crate::model::ReplayState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the replay.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ReplayState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason that the replay is in the current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the replay is in the current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelReplayOutput`](crate::output::CancelReplayOutput)
        pub fn build(self) -> crate::output::CancelReplayOutput {
            crate::output::CancelReplayOutput {
                replay_arn: self.replay_arn,
                state: self.state,
                state_reason: self.state_reason,
            }
        }
    }
}
impl CancelReplayOutput {
    /// Creates a new builder-style object to manufacture [`CancelReplayOutput`](crate::output::CancelReplayOutput)
    pub fn builder() -> crate::output::cancel_replay_output::Builder {
        crate::output::cancel_replay_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateEventSourceOutput {}
impl std::fmt::Debug for ActivateEventSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateEventSourceOutput");
        formatter.finish()
    }
}
/// See [`ActivateEventSourceOutput`](crate::output::ActivateEventSourceOutput)
pub mod activate_event_source_output {
    /// A builder for [`ActivateEventSourceOutput`](crate::output::ActivateEventSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ActivateEventSourceOutput`](crate::output::ActivateEventSourceOutput)
        pub fn build(self) -> crate::output::ActivateEventSourceOutput {
            crate::output::ActivateEventSourceOutput {}
        }
    }
}
impl ActivateEventSourceOutput {
    /// Creates a new builder-style object to manufacture [`ActivateEventSourceOutput`](crate::output::ActivateEventSourceOutput)
    pub fn builder() -> crate::output::activate_event_source_output::Builder {
        crate::output::activate_event_source_output::Builder::default()
    }
}
