// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon EMR Containers
///
/// Client for invoking operations on Amazon EMR Containers. Each operation on Amazon EMR Containers is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_emrcontainers::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_emrcontainers::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_emrcontainers::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelJobRun`](crate::client::fluent_builders::CancelJobRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CancelJobRun::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CancelJobRun::set_id): <p>The ID of the job run to cancel.</p>
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::CancelJobRun::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::CancelJobRun::set_virtual_cluster_id): <p>The ID of the virtual cluster for which the job run will be canceled.</p>
    /// - On success, responds with [`CancelJobRunOutput`](crate::output::CancelJobRunOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CancelJobRunOutput::id): <p>The output contains the ID of the cancelled job run.</p>
    ///   - [`virtual_cluster_id(Option<String>)`](crate::output::CancelJobRunOutput::virtual_cluster_id): <p>The output contains the virtual cluster ID for which the job run is cancelled.</p>
    /// - On failure, responds with [`SdkError<CancelJobRunError>`](crate::error::CancelJobRunError)
    pub fn cancel_job_run(&self) -> fluent_builders::CancelJobRun {
        fluent_builders::CancelJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateManagedEndpoint`](crate::client::fluent_builders::CreateManagedEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_name): <p>The name of the managed endpoint.</p>
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_virtual_cluster_id): <p>The ID of the virtual cluster for which a managed endpoint is created.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_type): <p>The type of the managed endpoint.</p>
    ///   - [`release_label(impl Into<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::release_label) / [`set_release_label(Option<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_release_label): <p>The Amazon EMR release version.</p>
    ///   - [`execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::execution_role_arn) / [`set_execution_role_arn(Option<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_execution_role_arn): <p>The ARN of the execution role.</p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_certificate_arn): <p>The certificate ARN provided by users for the managed endpoint. This fiedd is under deprecation and will be removed in future releases.</p>
    ///   - [`configuration_overrides(ConfigurationOverrides)`](crate::client::fluent_builders::CreateManagedEndpoint::configuration_overrides) / [`set_configuration_overrides(Option<ConfigurationOverrides>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_configuration_overrides): <p>The configuration settings that will be used to override existing configurations.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_client_token): <p>The client idempotency token for this create call.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateManagedEndpoint::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateManagedEndpoint::set_tags): <p>The tags of the managed endpoint. </p>
    /// - On success, responds with [`CreateManagedEndpointOutput`](crate::output::CreateManagedEndpointOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateManagedEndpointOutput::id): <p>The output contains the ID of the managed endpoint.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateManagedEndpointOutput::name): <p>The output contains the name of the managed endpoint.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateManagedEndpointOutput::arn): <p>The output contains the ARN of the managed endpoint.</p>
    ///   - [`virtual_cluster_id(Option<String>)`](crate::output::CreateManagedEndpointOutput::virtual_cluster_id): <p>The output contains the ID of the virtual cluster.</p>
    /// - On failure, responds with [`SdkError<CreateManagedEndpointError>`](crate::error::CreateManagedEndpointError)
    pub fn create_managed_endpoint(&self) -> fluent_builders::CreateManagedEndpoint {
        fluent_builders::CreateManagedEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVirtualCluster`](crate::client::fluent_builders::CreateVirtualCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualCluster::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualCluster::set_name): <p>The specified name of the virtual cluster.</p>
    ///   - [`container_provider(ContainerProvider)`](crate::client::fluent_builders::CreateVirtualCluster::container_provider) / [`set_container_provider(Option<ContainerProvider>)`](crate::client::fluent_builders::CreateVirtualCluster::set_container_provider): <p>The container provider of the virtual cluster.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualCluster::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVirtualCluster::set_client_token): <p>The client token of the virtual cluster.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateVirtualCluster::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateVirtualCluster::set_tags): <p>The tags assigned to the virtual cluster.</p>
    /// - On success, responds with [`CreateVirtualClusterOutput`](crate::output::CreateVirtualClusterOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateVirtualClusterOutput::id): <p>This output contains the virtual cluster ID.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateVirtualClusterOutput::name): <p>This output contains the name of the virtual cluster.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateVirtualClusterOutput::arn): <p>This output contains the ARN of virtual cluster.</p>
    /// - On failure, responds with [`SdkError<CreateVirtualClusterError>`](crate::error::CreateVirtualClusterError)
    pub fn create_virtual_cluster(&self) -> fluent_builders::CreateVirtualCluster {
        fluent_builders::CreateVirtualCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteManagedEndpoint`](crate::client::fluent_builders::DeleteManagedEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteManagedEndpoint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteManagedEndpoint::set_id): <p>The ID of the managed endpoint.</p>
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::DeleteManagedEndpoint::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::DeleteManagedEndpoint::set_virtual_cluster_id): <p>The ID of the endpoint's virtual cluster.</p>
    /// - On success, responds with [`DeleteManagedEndpointOutput`](crate::output::DeleteManagedEndpointOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::DeleteManagedEndpointOutput::id): <p>The output displays the ID of the managed endpoint.</p>
    ///   - [`virtual_cluster_id(Option<String>)`](crate::output::DeleteManagedEndpointOutput::virtual_cluster_id): <p>The output displays the ID of the endpoint's virtual cluster.</p>
    /// - On failure, responds with [`SdkError<DeleteManagedEndpointError>`](crate::error::DeleteManagedEndpointError)
    pub fn delete_managed_endpoint(&self) -> fluent_builders::DeleteManagedEndpoint {
        fluent_builders::DeleteManagedEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVirtualCluster`](crate::client::fluent_builders::DeleteVirtualCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualCluster::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteVirtualCluster::set_id): <p>The ID of the virtual cluster that will be deleted.</p>
    /// - On success, responds with [`DeleteVirtualClusterOutput`](crate::output::DeleteVirtualClusterOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::DeleteVirtualClusterOutput::id): <p>This output contains the ID of the virtual cluster that will be deleted. </p>
    /// - On failure, responds with [`SdkError<DeleteVirtualClusterError>`](crate::error::DeleteVirtualClusterError)
    pub fn delete_virtual_cluster(&self) -> fluent_builders::DeleteVirtualCluster {
        fluent_builders::DeleteVirtualCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobRun`](crate::client::fluent_builders::DescribeJobRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeJobRun::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeJobRun::set_id): <p>The ID of the job run request. </p>
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJobRun::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::DescribeJobRun::set_virtual_cluster_id): <p>The ID of the virtual cluster for which the job run is submitted.</p>
    /// - On success, responds with [`DescribeJobRunOutput`](crate::output::DescribeJobRunOutput) with field(s):
    ///   - [`job_run(Option<JobRun>)`](crate::output::DescribeJobRunOutput::job_run): <p>The output displays information about a job run.</p>
    /// - On failure, responds with [`SdkError<DescribeJobRunError>`](crate::error::DescribeJobRunError)
    pub fn describe_job_run(&self) -> fluent_builders::DescribeJobRun {
        fluent_builders::DescribeJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeManagedEndpoint`](crate::client::fluent_builders::DescribeManagedEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedEndpoint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeManagedEndpoint::set_id): <p>This output displays ID of the managed endpoint.</p>
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedEndpoint::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::DescribeManagedEndpoint::set_virtual_cluster_id): <p>The ID of the endpoint's virtual cluster.</p>
    /// - On success, responds with [`DescribeManagedEndpointOutput`](crate::output::DescribeManagedEndpointOutput) with field(s):
    ///   - [`endpoint(Option<Endpoint>)`](crate::output::DescribeManagedEndpointOutput::endpoint): <p>This output displays information about a managed endpoint.</p>
    /// - On failure, responds with [`SdkError<DescribeManagedEndpointError>`](crate::error::DescribeManagedEndpointError)
    pub fn describe_managed_endpoint(&self) -> fluent_builders::DescribeManagedEndpoint {
        fluent_builders::DescribeManagedEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVirtualCluster`](crate::client::fluent_builders::DescribeVirtualCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualCluster::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeVirtualCluster::set_id): <p>The ID of the virtual cluster that will be described.</p>
    /// - On success, responds with [`DescribeVirtualClusterOutput`](crate::output::DescribeVirtualClusterOutput) with field(s):
    ///   - [`virtual_cluster(Option<VirtualCluster>)`](crate::output::DescribeVirtualClusterOutput::virtual_cluster): <p>This output displays information about the specified virtual cluster.</p>
    /// - On failure, responds with [`SdkError<DescribeVirtualClusterError>`](crate::error::DescribeVirtualClusterError)
    pub fn describe_virtual_cluster(&self) -> fluent_builders::DescribeVirtualCluster {
        fluent_builders::DescribeVirtualCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobRuns`](crate::client::fluent_builders::ListJobRuns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobRuns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListJobRuns::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::ListJobRuns::set_virtual_cluster_id): <p>The ID of the virtual cluster for which to list the job run. </p>
    ///   - [`created_before(DateTime)`](crate::client::fluent_builders::ListJobRuns::created_before) / [`set_created_before(Option<DateTime>)`](crate::client::fluent_builders::ListJobRuns::set_created_before): <p>The date and time before which the job runs were submitted.</p>
    ///   - [`created_after(DateTime)`](crate::client::fluent_builders::ListJobRuns::created_after) / [`set_created_after(Option<DateTime>)`](crate::client::fluent_builders::ListJobRuns::set_created_after): <p>The date and time after which the job runs were submitted.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListJobRuns::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListJobRuns::set_name): <p>The name of the job run.</p>
    ///   - [`states(Vec<JobRunState>)`](crate::client::fluent_builders::ListJobRuns::states) / [`set_states(Option<Vec<JobRunState>>)`](crate::client::fluent_builders::ListJobRuns::set_states): <p>The states of the job run.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobRuns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobRuns::set_max_results): <p>The maximum number of job runs that can be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobRuns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobRuns::set_next_token): <p>The token for the next set of job runs to return.</p>
    /// - On success, responds with [`ListJobRunsOutput`](crate::output::ListJobRunsOutput) with field(s):
    ///   - [`job_runs(Option<Vec<JobRun>>)`](crate::output::ListJobRunsOutput::job_runs): <p>This output lists information about the specified job runs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobRunsOutput::next_token): <p>This output displays the token for the next set of job runs.</p>
    /// - On failure, responds with [`SdkError<ListJobRunsError>`](crate::error::ListJobRunsError)
    pub fn list_job_runs(&self) -> fluent_builders::ListJobRuns {
        fluent_builders::ListJobRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListManagedEndpoints`](crate::client::fluent_builders::ListManagedEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListManagedEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListManagedEndpoints::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::ListManagedEndpoints::set_virtual_cluster_id): <p>The ID of the virtual cluster.</p>
    ///   - [`created_before(DateTime)`](crate::client::fluent_builders::ListManagedEndpoints::created_before) / [`set_created_before(Option<DateTime>)`](crate::client::fluent_builders::ListManagedEndpoints::set_created_before): <p>The date and time before which the endpoints are created.</p>
    ///   - [`created_after(DateTime)`](crate::client::fluent_builders::ListManagedEndpoints::created_after) / [`set_created_after(Option<DateTime>)`](crate::client::fluent_builders::ListManagedEndpoints::set_created_after): <p> The date and time after which the endpoints are created.</p>
    ///   - [`types(Vec<String>)`](crate::client::fluent_builders::ListManagedEndpoints::types) / [`set_types(Option<Vec<String>>)`](crate::client::fluent_builders::ListManagedEndpoints::set_types): <p>The types of the managed endpoints.</p>
    ///   - [`states(Vec<EndpointState>)`](crate::client::fluent_builders::ListManagedEndpoints::states) / [`set_states(Option<Vec<EndpointState>>)`](crate::client::fluent_builders::ListManagedEndpoints::set_states): <p>The states of the managed endpoints.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListManagedEndpoints::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListManagedEndpoints::set_max_results): <p>The maximum number of managed endpoints that can be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListManagedEndpoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListManagedEndpoints::set_next_token): <p> The token for the next set of managed endpoints to return. </p>
    /// - On success, responds with [`ListManagedEndpointsOutput`](crate::output::ListManagedEndpointsOutput) with field(s):
    ///   - [`endpoints(Option<Vec<Endpoint>>)`](crate::output::ListManagedEndpointsOutput::endpoints): <p>The managed endpoints to be listed.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListManagedEndpointsOutput::next_token): <p> The token for the next set of endpoints to return. </p>
    /// - On failure, responds with [`SdkError<ListManagedEndpointsError>`](crate::error::ListManagedEndpointsError)
    pub fn list_managed_endpoints(&self) -> fluent_builders::ListManagedEndpoints {
        fluent_builders::ListManagedEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of tagged resources.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags assigned to resources.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVirtualClusters`](crate::client::fluent_builders::ListVirtualClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVirtualClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_provider_id(impl Into<String>)`](crate::client::fluent_builders::ListVirtualClusters::container_provider_id) / [`set_container_provider_id(Option<String>)`](crate::client::fluent_builders::ListVirtualClusters::set_container_provider_id): <p>The container provider ID of the virtual cluster.</p>
    ///   - [`container_provider_type(ContainerProviderType)`](crate::client::fluent_builders::ListVirtualClusters::container_provider_type) / [`set_container_provider_type(Option<ContainerProviderType>)`](crate::client::fluent_builders::ListVirtualClusters::set_container_provider_type): <p>The container provider type of the virtual cluster. EKS is the only supported type as of now.</p>
    ///   - [`created_after(DateTime)`](crate::client::fluent_builders::ListVirtualClusters::created_after) / [`set_created_after(Option<DateTime>)`](crate::client::fluent_builders::ListVirtualClusters::set_created_after): <p>The date and time after which the virtual clusters are created.</p>
    ///   - [`created_before(DateTime)`](crate::client::fluent_builders::ListVirtualClusters::created_before) / [`set_created_before(Option<DateTime>)`](crate::client::fluent_builders::ListVirtualClusters::set_created_before): <p>The date and time before which the virtual clusters are created.</p>
    ///   - [`states(Vec<VirtualClusterState>)`](crate::client::fluent_builders::ListVirtualClusters::states) / [`set_states(Option<Vec<VirtualClusterState>>)`](crate::client::fluent_builders::ListVirtualClusters::set_states): <p>The states of the requested virtual clusters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListVirtualClusters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListVirtualClusters::set_max_results): <p>The maximum number of virtual clusters that can be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVirtualClusters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVirtualClusters::set_next_token): <p>The token for the next set of virtual clusters to return. </p>
    /// - On success, responds with [`ListVirtualClustersOutput`](crate::output::ListVirtualClustersOutput) with field(s):
    ///   - [`virtual_clusters(Option<Vec<VirtualCluster>>)`](crate::output::ListVirtualClustersOutput::virtual_clusters): <p>This output lists the specified virtual clusters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVirtualClustersOutput::next_token): <p>This output displays the token for the next set of virtual clusters.</p>
    /// - On failure, responds with [`SdkError<ListVirtualClustersError>`](crate::error::ListVirtualClustersError)
    pub fn list_virtual_clusters(&self) -> fluent_builders::ListVirtualClusters {
        fluent_builders::ListVirtualClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartJobRun`](crate::client::fluent_builders::StartJobRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartJobRun::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartJobRun::set_name): <p>The name of the job run.</p>
    ///   - [`virtual_cluster_id(impl Into<String>)`](crate::client::fluent_builders::StartJobRun::virtual_cluster_id) / [`set_virtual_cluster_id(Option<String>)`](crate::client::fluent_builders::StartJobRun::set_virtual_cluster_id): <p>The virtual cluster ID for which the job run request is submitted.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartJobRun::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartJobRun::set_client_token): <p>The client idempotency token of the job run request. </p>
    ///   - [`execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartJobRun::execution_role_arn) / [`set_execution_role_arn(Option<String>)`](crate::client::fluent_builders::StartJobRun::set_execution_role_arn): <p>The execution role ARN for the job run.</p>
    ///   - [`release_label(impl Into<String>)`](crate::client::fluent_builders::StartJobRun::release_label) / [`set_release_label(Option<String>)`](crate::client::fluent_builders::StartJobRun::set_release_label): <p>The Amazon EMR release version to use for the job run.</p>
    ///   - [`job_driver(JobDriver)`](crate::client::fluent_builders::StartJobRun::job_driver) / [`set_job_driver(Option<JobDriver>)`](crate::client::fluent_builders::StartJobRun::set_job_driver): <p>The job driver for the job run.</p>
    ///   - [`configuration_overrides(ConfigurationOverrides)`](crate::client::fluent_builders::StartJobRun::configuration_overrides) / [`set_configuration_overrides(Option<ConfigurationOverrides>)`](crate::client::fluent_builders::StartJobRun::set_configuration_overrides): <p>The configuration overrides for the job run.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartJobRun::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartJobRun::set_tags): <p>The tags assigned to job runs.</p>
    /// - On success, responds with [`StartJobRunOutput`](crate::output::StartJobRunOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::StartJobRunOutput::id): <p>This output displays the started job run ID.</p>
    ///   - [`name(Option<String>)`](crate::output::StartJobRunOutput::name): <p>This output displays the name of the started job run.</p>
    ///   - [`arn(Option<String>)`](crate::output::StartJobRunOutput::arn): <p>This output lists the ARN of job run.</p>
    ///   - [`virtual_cluster_id(Option<String>)`](crate::output::StartJobRunOutput::virtual_cluster_id): <p>This output displays the virtual cluster ID for which the job run was submitted.</p>
    /// - On failure, responds with [`SdkError<StartJobRunError>`](crate::error::StartJobRunError)
    pub fn start_job_run(&self) -> fluent_builders::StartJobRun {
        fluent_builders::StartJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of resources.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags assigned to resources.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of resources.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys of the resources.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelJobRun`.
    ///
    /// <p>Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJobRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_job_run_input::Builder,
    }
    impl CancelJobRun {
        /// Creates a new `CancelJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job run to cancel.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the job run to cancel.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the virtual cluster for which the job run will be canceled.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which the job run will be canceled.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateManagedEndpoint`.
    ///
    /// <p>Creates a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateManagedEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_managed_endpoint_input::Builder,
    }
    impl CreateManagedEndpoint {
        /// Creates a new `CreateManagedEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateManagedEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateManagedEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed endpoint.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed endpoint.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the virtual cluster for which a managed endpoint is created.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which a managed endpoint is created.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
        /// <p>The type of the managed endpoint.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of the managed endpoint.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Amazon EMR release version.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_label(input.into());
            self
        }
        /// <p>The Amazon EMR release version.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_label(input);
            self
        }
        /// <p>The ARN of the execution role.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p>The ARN of the execution role.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>The certificate ARN provided by users for the managed endpoint. This fiedd is under deprecation and will be removed in future releases.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The certificate ARN provided by users for the managed endpoint. This fiedd is under deprecation and will be removed in future releases.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The configuration settings that will be used to override existing configurations.</p>
        pub fn configuration_overrides(
            mut self,
            input: crate::model::ConfigurationOverrides,
        ) -> Self {
            self.inner = self.inner.configuration_overrides(input);
            self
        }
        /// <p>The configuration settings that will be used to override existing configurations.</p>
        pub fn set_configuration_overrides(
            mut self,
            input: std::option::Option<crate::model::ConfigurationOverrides>,
        ) -> Self {
            self.inner = self.inner.set_configuration_overrides(input);
            self
        }
        /// <p>The client idempotency token for this create call.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client idempotency token for this create call.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the managed endpoint. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags of the managed endpoint. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualCluster`.
    ///
    /// <p>Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVirtualCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_virtual_cluster_input::Builder,
    }
    impl CreateVirtualCluster {
        /// Creates a new `CreateVirtualCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The specified name of the virtual cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The specified name of the virtual cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The container provider of the virtual cluster.</p>
        pub fn container_provider(mut self, input: crate::model::ContainerProvider) -> Self {
            self.inner = self.inner.container_provider(input);
            self
        }
        /// <p>The container provider of the virtual cluster.</p>
        pub fn set_container_provider(
            mut self,
            input: std::option::Option<crate::model::ContainerProvider>,
        ) -> Self {
            self.inner = self.inner.set_container_provider(input);
            self
        }
        /// <p>The client token of the virtual cluster.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token of the virtual cluster.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the virtual cluster.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the virtual cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteManagedEndpoint`.
    ///
    /// <p>Deletes a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteManagedEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_managed_endpoint_input::Builder,
    }
    impl DeleteManagedEndpoint {
        /// Creates a new `DeleteManagedEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteManagedEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteManagedEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the managed endpoint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the managed endpoint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualCluster`.
    ///
    /// <p>Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVirtualCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_virtual_cluster_input::Builder,
    }
    impl DeleteVirtualCluster {
        /// Creates a new `DeleteVirtualCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual cluster that will be deleted.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the virtual cluster that will be deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobRun`.
    ///
    /// <p>Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_job_run_input::Builder,
    }
    impl DescribeJobRun {
        /// Creates a new `DescribeJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job run request. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the job run request. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the virtual cluster for which the job run is submitted.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which the job run is submitted.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeManagedEndpoint`.
    ///
    /// <p>Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeManagedEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_managed_endpoint_input::Builder,
    }
    impl DescribeManagedEndpoint {
        /// Creates a new `DescribeManagedEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeManagedEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeManagedEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This output displays ID of the managed endpoint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>This output displays ID of the managed endpoint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualCluster`.
    ///
    /// <p>Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVirtualCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_virtual_cluster_input::Builder,
    }
    impl DescribeVirtualCluster {
        /// Creates a new `DescribeVirtualCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual cluster that will be described.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the virtual cluster that will be described.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobRuns`.
    ///
    /// <p>Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobRuns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_job_runs_input::Builder,
    }
    impl ListJobRuns {
        /// Creates a new `ListJobRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobRunsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobRunsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobRunsPaginator {
            crate::paginator::ListJobRunsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the virtual cluster for which to list the job run. </p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which to list the job run. </p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
        /// <p>The date and time before which the job runs were submitted.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>The date and time before which the job runs were submitted.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// <p>The date and time after which the job runs were submitted.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>The date and time after which the job runs were submitted.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>The name of the job run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states of the job run.</p>
        pub fn states(mut self, input: crate::model::JobRunState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>The states of the job run.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobRunState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The maximum number of job runs that can be listed.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of job runs that can be listed.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of job runs to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of job runs to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedEndpoints`.
    ///
    /// <p>Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListManagedEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_managed_endpoints_input::Builder,
    }
    impl ListManagedEndpoints {
        /// Creates a new `ListManagedEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListManagedEndpointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListManagedEndpointsPaginator {
            crate::paginator::ListManagedEndpointsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The ID of the virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
        /// <p>The date and time before which the endpoints are created.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>The date and time before which the endpoints are created.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// <p> The date and time after which the endpoints are created.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p> The date and time after which the endpoints are created.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>The types of the managed endpoints.</p>
        pub fn types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.types(input.into());
            self
        }
        /// <p>The types of the managed endpoints.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_types(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states of the managed endpoints.</p>
        pub fn states(mut self, input: crate::model::EndpointState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>The states of the managed endpoints.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The maximum number of managed endpoints that can be listed.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of managed endpoints that can be listed.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of managed endpoints to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of managed endpoints to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags assigned to the resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of tagged resources.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of tagged resources.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualClusters`.
    ///
    /// <p>Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVirtualClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_virtual_clusters_input::Builder,
    }
    impl ListVirtualClusters {
        /// Creates a new `ListVirtualClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVirtualClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVirtualClustersPaginator {
            crate::paginator::ListVirtualClustersPaginator::new(self.handle, self.inner)
        }
        /// <p>The container provider ID of the virtual cluster.</p>
        pub fn container_provider_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_provider_id(input.into());
            self
        }
        /// <p>The container provider ID of the virtual cluster.</p>
        pub fn set_container_provider_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_provider_id(input);
            self
        }
        /// <p>The container provider type of the virtual cluster. EKS is the only supported type as of now.</p>
        pub fn container_provider_type(
            mut self,
            input: crate::model::ContainerProviderType,
        ) -> Self {
            self.inner = self.inner.container_provider_type(input);
            self
        }
        /// <p>The container provider type of the virtual cluster. EKS is the only supported type as of now.</p>
        pub fn set_container_provider_type(
            mut self,
            input: std::option::Option<crate::model::ContainerProviderType>,
        ) -> Self {
            self.inner = self.inner.set_container_provider_type(input);
            self
        }
        /// <p>The date and time after which the virtual clusters are created.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>The date and time after which the virtual clusters are created.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>The date and time before which the virtual clusters are created.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>The date and time before which the virtual clusters are created.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states of the requested virtual clusters.</p>
        pub fn states(mut self, input: crate::model::VirtualClusterState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>The states of the requested virtual clusters.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualClusterState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The maximum number of virtual clusters that can be listed.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of virtual clusters that can be listed.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of virtual clusters to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of virtual clusters to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJobRun`.
    ///
    /// <p>Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartJobRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_job_run_input::Builder,
    }
    impl StartJobRun {
        /// Creates a new `StartJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The virtual cluster ID for which the job run request is submitted.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_cluster_id(input.into());
            self
        }
        /// <p>The virtual cluster ID for which the job run request is submitted.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_cluster_id(input);
            self
        }
        /// <p>The client idempotency token of the job run request. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client idempotency token of the job run request. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The execution role ARN for the job run.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p>The execution role ARN for the job run.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>The Amazon EMR release version to use for the job run.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_label(input.into());
            self
        }
        /// <p>The Amazon EMR release version to use for the job run.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_label(input);
            self
        }
        /// <p>The job driver for the job run.</p>
        pub fn job_driver(mut self, input: crate::model::JobDriver) -> Self {
            self.inner = self.inner.job_driver(input);
            self
        }
        /// <p>The job driver for the job run.</p>
        pub fn set_job_driver(
            mut self,
            input: std::option::Option<crate::model::JobDriver>,
        ) -> Self {
            self.inner = self.inner.set_job_driver(input);
            self
        }
        /// <p>The configuration overrides for the job run.</p>
        pub fn configuration_overrides(
            mut self,
            input: crate::model::ConfigurationOverrides,
        ) -> Self {
            self.inner = self.inner.configuration_overrides(input);
            self
        }
        /// <p>The configuration overrides for the job run.</p>
        pub fn set_configuration_overrides(
            mut self,
            input: std::option::Option<crate::model::ConfigurationOverrides>,
        ) -> Self {
            self.inner = self.inner.set_configuration_overrides(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to job runs.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to job runs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns tags to resources. A tag is a label that you assign to an AWS resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your AWS resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it. For example, you can define a set of tags for your Amazon EMR on EKS clusters to help you track each cluster's owner and stack level. We recommend that you devise a consistent set of tag keys for each resource type. You can then search and filter the resources based on the tags that you add.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of resources.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of resources.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of resources.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of resources.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the resources.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys of the resources.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
