// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelJobRunInput`](crate::input::CancelJobRunInput)
pub mod cancel_job_run_input {
    /// A builder for [`CancelJobRunInput`](crate::input::CancelJobRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the job run to cancel.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the job run to cancel.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the virtual cluster for which the job run will be canceled.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which the job run will be canceled.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelJobRunInput`](crate::input::CancelJobRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelJobRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelJobRunInput {
                id: self.id,
                virtual_cluster_id: self.virtual_cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelJobRunInputOperationOutputAlias = crate::operation::CancelJobRun;
#[doc(hidden)]
pub type CancelJobRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelJobRunInput {
    /// Consumes the builder and constructs an Operation<[`CancelJobRun`](crate::operation::CancelJobRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelJobRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelJobRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.virtual_cluster_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_1, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_2, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/jobruns/{id}",
                virtualClusterId = virtual_cluster_id,
                id = id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelJobRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelJobRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelJobRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelJobRun",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelJobRunInput`](crate::input::CancelJobRunInput)
    pub fn builder() -> crate::input::cancel_job_run_input::Builder {
        crate::input::cancel_job_run_input::Builder::default()
    }
}

/// See [`CreateManagedEndpointInput`](crate::input::CreateManagedEndpointInput)
pub mod create_managed_endpoint_input {
    /// A builder for [`CreateManagedEndpointInput`](crate::input::CreateManagedEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) release_label: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_overrides:
            std::option::Option<crate::model::ConfigurationOverrides>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the managed endpoint.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the managed endpoint.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the virtual cluster for which a managed endpoint is created.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which a managed endpoint is created.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// <p>The type of the managed endpoint.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the managed endpoint.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon EMR release version.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_label = Some(input.into());
            self
        }
        /// <p>The Amazon EMR release version.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_label = input;
            self
        }
        /// <p>The ARN of the execution role.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the execution role.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The certificate ARN provided by users for the managed endpoint. This fiedd is under deprecation and will be removed in future releases.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The certificate ARN provided by users for the managed endpoint. This fiedd is under deprecation and will be removed in future releases.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The configuration settings that will be used to override existing configurations.</p>
        pub fn configuration_overrides(
            mut self,
            input: crate::model::ConfigurationOverrides,
        ) -> Self {
            self.configuration_overrides = Some(input);
            self
        }
        /// <p>The configuration settings that will be used to override existing configurations.</p>
        pub fn set_configuration_overrides(
            mut self,
            input: std::option::Option<crate::model::ConfigurationOverrides>,
        ) -> Self {
            self.configuration_overrides = input;
            self
        }
        /// <p>The client idempotency token for this create call.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The client idempotency token for this create call.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the managed endpoint.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the managed endpoint.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateManagedEndpointInput`](crate::input::CreateManagedEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateManagedEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateManagedEndpointInput {
                name: self.name,
                virtual_cluster_id: self.virtual_cluster_id,
                r#type: self.r#type,
                release_label: self.release_label,
                execution_role_arn: self.execution_role_arn,
                certificate_arn: self.certificate_arn,
                configuration_overrides: self.configuration_overrides,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateManagedEndpointInputOperationOutputAlias = crate::operation::CreateManagedEndpoint;
#[doc(hidden)]
pub type CreateManagedEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateManagedEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateManagedEndpoint`](crate::operation::CreateManagedEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateManagedEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateManagedEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.virtual_cluster_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_3, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/endpoints",
                virtualClusterId = virtual_cluster_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateManagedEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateManagedEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_managed_endpoint(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateManagedEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateManagedEndpoint",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateManagedEndpointInput`](crate::input::CreateManagedEndpointInput)
    pub fn builder() -> crate::input::create_managed_endpoint_input::Builder {
        crate::input::create_managed_endpoint_input::Builder::default()
    }
}

/// See [`CreateVirtualClusterInput`](crate::input::CreateVirtualClusterInput)
pub mod create_virtual_cluster_input {
    /// A builder for [`CreateVirtualClusterInput`](crate::input::CreateVirtualClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) container_provider: std::option::Option<crate::model::ContainerProvider>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The specified name of the virtual cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The specified name of the virtual cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The container provider of the virtual cluster.</p>
        pub fn container_provider(mut self, input: crate::model::ContainerProvider) -> Self {
            self.container_provider = Some(input);
            self
        }
        /// <p>The container provider of the virtual cluster.</p>
        pub fn set_container_provider(
            mut self,
            input: std::option::Option<crate::model::ContainerProvider>,
        ) -> Self {
            self.container_provider = input;
            self
        }
        /// <p>The client token of the virtual cluster.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The client token of the virtual cluster.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the virtual cluster.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the virtual cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualClusterInput`](crate::input::CreateVirtualClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVirtualClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVirtualClusterInput {
                name: self.name,
                container_provider: self.container_provider,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVirtualClusterInputOperationOutputAlias = crate::operation::CreateVirtualCluster;
#[doc(hidden)]
pub type CreateVirtualClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVirtualClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateVirtualCluster`](crate::operation::CreateVirtualCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVirtualCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVirtualClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/virtualclusters").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVirtualClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVirtualClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_virtual_cluster(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVirtualCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVirtualCluster",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVirtualClusterInput`](crate::input::CreateVirtualClusterInput)
    pub fn builder() -> crate::input::create_virtual_cluster_input::Builder {
        crate::input::create_virtual_cluster_input::Builder::default()
    }
}

/// See [`DeleteManagedEndpointInput`](crate::input::DeleteManagedEndpointInput)
pub mod delete_managed_endpoint_input {
    /// A builder for [`DeleteManagedEndpointInput`](crate::input::DeleteManagedEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the managed endpoint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the managed endpoint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteManagedEndpointInput`](crate::input::DeleteManagedEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteManagedEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteManagedEndpointInput {
                id: self.id,
                virtual_cluster_id: self.virtual_cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteManagedEndpointInputOperationOutputAlias = crate::operation::DeleteManagedEndpoint;
#[doc(hidden)]
pub type DeleteManagedEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteManagedEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteManagedEndpoint`](crate::operation::DeleteManagedEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteManagedEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteManagedEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.virtual_cluster_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_4, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_5, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/endpoints/{id}",
                virtualClusterId = virtual_cluster_id,
                id = id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteManagedEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteManagedEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteManagedEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteManagedEndpoint",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteManagedEndpointInput`](crate::input::DeleteManagedEndpointInput)
    pub fn builder() -> crate::input::delete_managed_endpoint_input::Builder {
        crate::input::delete_managed_endpoint_input::Builder::default()
    }
}

/// See [`DeleteVirtualClusterInput`](crate::input::DeleteVirtualClusterInput)
pub mod delete_virtual_cluster_input {
    /// A builder for [`DeleteVirtualClusterInput`](crate::input::DeleteVirtualClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual cluster that will be deleted.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster that will be deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualClusterInput`](crate::input::DeleteVirtualClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVirtualClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVirtualClusterInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteVirtualClusterInputOperationOutputAlias = crate::operation::DeleteVirtualCluster;
#[doc(hidden)]
pub type DeleteVirtualClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVirtualClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVirtualCluster`](crate::operation::DeleteVirtualCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVirtualCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVirtualClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_6, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/virtualclusters/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVirtualClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVirtualClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVirtualCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVirtualCluster",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVirtualClusterInput`](crate::input::DeleteVirtualClusterInput)
    pub fn builder() -> crate::input::delete_virtual_cluster_input::Builder {
        crate::input::delete_virtual_cluster_input::Builder::default()
    }
}

/// See [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
pub mod describe_job_run_input {
    /// A builder for [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the job run request. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the job run request. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the virtual cluster for which the job run is submitted.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which the job run is submitted.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobRunInput {
                id: self.id,
                virtual_cluster_id: self.virtual_cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobRunInputOperationOutputAlias = crate::operation::DescribeJobRun;
#[doc(hidden)]
pub type DescribeJobRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeJobRunInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobRun`](crate::operation::DescribeJobRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.virtual_cluster_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_7, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_8, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/jobruns/{id}",
                virtualClusterId = virtual_cluster_id,
                id = id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobRun",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
    pub fn builder() -> crate::input::describe_job_run_input::Builder {
        crate::input::describe_job_run_input::Builder::default()
    }
}

/// See [`DescribeManagedEndpointInput`](crate::input::DescribeManagedEndpointInput)
pub mod describe_managed_endpoint_input {
    /// A builder for [`DescribeManagedEndpointInput`](crate::input::DescribeManagedEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This output displays ID of the managed endpoint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>This output displays ID of the managed endpoint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeManagedEndpointInput`](crate::input::DescribeManagedEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeManagedEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeManagedEndpointInput {
                id: self.id,
                virtual_cluster_id: self.virtual_cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeManagedEndpointInputOperationOutputAlias =
    crate::operation::DescribeManagedEndpoint;
#[doc(hidden)]
pub type DescribeManagedEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeManagedEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DescribeManagedEndpoint`](crate::operation::DescribeManagedEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeManagedEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeManagedEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.virtual_cluster_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_9, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_10, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/endpoints/{id}",
                virtualClusterId = virtual_cluster_id,
                id = id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeManagedEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeManagedEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeManagedEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeManagedEndpoint",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeManagedEndpointInput`](crate::input::DescribeManagedEndpointInput)
    pub fn builder() -> crate::input::describe_managed_endpoint_input::Builder {
        crate::input::describe_managed_endpoint_input::Builder::default()
    }
}

/// See [`DescribeVirtualClusterInput`](crate::input::DescribeVirtualClusterInput)
pub mod describe_virtual_cluster_input {
    /// A builder for [`DescribeVirtualClusterInput`](crate::input::DescribeVirtualClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual cluster that will be described.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster that will be described.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualClusterInput`](crate::input::DescribeVirtualClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVirtualClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVirtualClusterInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DescribeVirtualClusterInputOperationOutputAlias = crate::operation::DescribeVirtualCluster;
#[doc(hidden)]
pub type DescribeVirtualClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeVirtualClusterInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVirtualCluster`](crate::operation::DescribeVirtualCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVirtualCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVirtualClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_11, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/virtualclusters/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVirtualClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVirtualClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVirtualCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVirtualCluster",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVirtualClusterInput`](crate::input::DescribeVirtualClusterInput)
    pub fn builder() -> crate::input::describe_virtual_cluster_input::Builder {
        crate::input::describe_virtual_cluster_input::Builder::default()
    }
}

/// See [`ListJobRunsInput`](crate::input::ListJobRunsInput)
pub mod list_job_runs_input {
    /// A builder for [`ListJobRunsInput`](crate::input::ListJobRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::JobRunState>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual cluster for which to list the job run. </p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster for which to list the job run. </p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// <p>The date and time before which the job runs were submitted.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>The date and time before which the job runs were submitted.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// <p>The date and time after which the job runs were submitted.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p>The date and time after which the job runs were submitted.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// <p>The name of the job run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states of the job run.</p>
        pub fn states(mut self, input: impl Into<crate::model::JobRunState>) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input.into());
            self.states = Some(v);
            self
        }
        /// <p>The states of the job run.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobRunState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The maximum number of job runs that can be listed.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of job runs that can be listed.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of job runs to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of job runs to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobRunsInput`](crate::input::ListJobRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListJobRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListJobRunsInput {
                virtual_cluster_id: self.virtual_cluster_id,
                created_before: self.created_before,
                created_after: self.created_after,
                name: self.name,
                states: self.states,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobRunsInputOperationOutputAlias = crate::operation::ListJobRuns;
#[doc(hidden)]
pub type ListJobRunsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListJobRunsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobRuns`](crate::operation::ListJobRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobRuns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.virtual_cluster_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_12, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/jobruns",
                virtualClusterId = virtual_cluster_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListJobRunsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.created_before {
                query.push_kv(
                    "createdBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_13,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_14) = &_input.created_after {
                query.push_kv(
                    "createdAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_14,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_15) = &_input.name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_15));
            }
            if let Some(inner_16) = &_input.states {
                for inner_17 in inner_16 {
                    query.push_kv("states", &aws_smithy_http::query::fmt_string(&inner_17));
                }
            }
            if let Some(inner_18) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_18).encode(),
                );
            }
            if let Some(inner_19) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListJobRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListJobRuns",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobRunsInput`](crate::input::ListJobRunsInput)
    pub fn builder() -> crate::input::list_job_runs_input::Builder {
        crate::input::list_job_runs_input::Builder::default()
    }
}

/// See [`ListManagedEndpointsInput`](crate::input::ListManagedEndpointsInput)
pub mod list_managed_endpoints_input {
    /// A builder for [`ListManagedEndpointsInput`](crate::input::ListManagedEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::EndpointState>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// <p>The date and time before which the endpoints are created.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>The date and time before which the endpoints are created.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// <p> The date and time after which the endpoints are created.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p> The date and time after which the endpoints are created.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>The types of the managed endpoints.</p>
        pub fn types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input.into());
            self.types = Some(v);
            self
        }
        /// <p>The types of the managed endpoints.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states of the managed endpoints.</p>
        pub fn states(mut self, input: impl Into<crate::model::EndpointState>) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input.into());
            self.states = Some(v);
            self
        }
        /// <p>The states of the managed endpoints.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The maximum number of managed endpoints that can be listed.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of managed endpoints that can be listed.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The token for the next set of managed endpoints to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The token for the next set of managed endpoints to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListManagedEndpointsInput`](crate::input::ListManagedEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListManagedEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListManagedEndpointsInput {
                virtual_cluster_id: self.virtual_cluster_id,
                created_before: self.created_before,
                created_after: self.created_after,
                types: self.types,
                states: self.states,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListManagedEndpointsInputOperationOutputAlias = crate::operation::ListManagedEndpoints;
#[doc(hidden)]
pub type ListManagedEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListManagedEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`ListManagedEndpoints`](crate::operation::ListManagedEndpoints)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListManagedEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListManagedEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.virtual_cluster_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_20, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/endpoints",
                virtualClusterId = virtual_cluster_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListManagedEndpointsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.created_before {
                query.push_kv(
                    "createdBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_21,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_22) = &_input.created_after {
                query.push_kv(
                    "createdAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_22,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_23) = &_input.types {
                for inner_24 in inner_23 {
                    query.push_kv("types", &aws_smithy_http::query::fmt_string(&inner_24));
                }
            }
            if let Some(inner_25) = &_input.states {
                for inner_26 in inner_25 {
                    query.push_kv("states", &aws_smithy_http::query::fmt_string(&inner_26));
                }
            }
            if let Some(inner_27) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_27).encode(),
                );
            }
            if let Some(inner_28) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_28));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListManagedEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListManagedEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListManagedEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListManagedEndpoints",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListManagedEndpointsInput`](crate::input::ListManagedEndpointsInput)
    pub fn builder() -> crate::input::list_managed_endpoints_input::Builder {
        crate::input::list_managed_endpoints_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of tagged resources.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of tagged resources.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.resource_arn;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_29, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListVirtualClustersInput`](crate::input::ListVirtualClustersInput)
pub mod list_virtual_clusters_input {
    /// A builder for [`ListVirtualClustersInput`](crate::input::ListVirtualClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_provider_id: std::option::Option<std::string::String>,
        pub(crate) container_provider_type:
            std::option::Option<crate::model::ContainerProviderType>,
        pub(crate) created_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::VirtualClusterState>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The container provider ID of the virtual cluster.</p>
        pub fn container_provider_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_provider_id = Some(input.into());
            self
        }
        /// <p>The container provider ID of the virtual cluster.</p>
        pub fn set_container_provider_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_provider_id = input;
            self
        }
        /// <p>The container provider type of the virtual cluster. EKS is the only supported type as of now.</p>
        pub fn container_provider_type(
            mut self,
            input: crate::model::ContainerProviderType,
        ) -> Self {
            self.container_provider_type = Some(input);
            self
        }
        /// <p>The container provider type of the virtual cluster. EKS is the only supported type as of now.</p>
        pub fn set_container_provider_type(
            mut self,
            input: std::option::Option<crate::model::ContainerProviderType>,
        ) -> Self {
            self.container_provider_type = input;
            self
        }
        /// <p>The date and time after which the virtual clusters are created.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p>The date and time after which the virtual clusters are created.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// <p>The date and time before which the virtual clusters are created.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>The date and time before which the virtual clusters are created.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states of the requested virtual clusters.</p>
        pub fn states(mut self, input: impl Into<crate::model::VirtualClusterState>) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input.into());
            self.states = Some(v);
            self
        }
        /// <p>The states of the requested virtual clusters.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualClusterState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The maximum number of virtual clusters that can be listed.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of virtual clusters that can be listed.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of virtual clusters to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of virtual clusters to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualClustersInput`](crate::input::ListVirtualClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVirtualClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVirtualClustersInput {
                container_provider_id: self.container_provider_id,
                container_provider_type: self.container_provider_type,
                created_after: self.created_after,
                created_before: self.created_before,
                states: self.states,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVirtualClustersInputOperationOutputAlias = crate::operation::ListVirtualClusters;
#[doc(hidden)]
pub type ListVirtualClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVirtualClustersInput {
    /// Consumes the builder and constructs an Operation<[`ListVirtualClusters`](crate::operation::ListVirtualClusters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVirtualClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVirtualClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/virtualclusters").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListVirtualClustersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_30) = &_input.container_provider_id {
                query.push_kv(
                    "containerProviderId",
                    &aws_smithy_http::query::fmt_string(&inner_30),
                );
            }
            if let Some(inner_31) = &_input.container_provider_type {
                query.push_kv(
                    "containerProviderType",
                    &aws_smithy_http::query::fmt_string(&inner_31),
                );
            }
            if let Some(inner_32) = &_input.created_after {
                query.push_kv(
                    "createdAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_32,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_33) = &_input.created_before {
                query.push_kv(
                    "createdBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_33,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_34) = &_input.states {
                for inner_35 in inner_34 {
                    query.push_kv("states", &aws_smithy_http::query::fmt_string(&inner_35));
                }
            }
            if let Some(inner_36) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_36).encode(),
                );
            }
            if let Some(inner_37) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_37));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVirtualClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVirtualClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVirtualClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVirtualClusters",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVirtualClustersInput`](crate::input::ListVirtualClustersInput)
    pub fn builder() -> crate::input::list_virtual_clusters_input::Builder {
        crate::input::list_virtual_clusters_input::Builder::default()
    }
}

/// See [`StartJobRunInput`](crate::input::StartJobRunInput)
pub mod start_job_run_input {
    /// A builder for [`StartJobRunInput`](crate::input::StartJobRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) release_label: std::option::Option<std::string::String>,
        pub(crate) job_driver: std::option::Option<crate::model::JobDriver>,
        pub(crate) configuration_overrides:
            std::option::Option<crate::model::ConfigurationOverrides>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the job run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The virtual cluster ID for which the job run request is submitted.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The virtual cluster ID for which the job run request is submitted.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// <p>The client idempotency token of the job run request. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The client idempotency token of the job run request. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The execution role ARN for the job run.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The execution role ARN for the job run.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The Amazon EMR release version to use for the job run.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_label = Some(input.into());
            self
        }
        /// <p>The Amazon EMR release version to use for the job run.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_label = input;
            self
        }
        /// <p>The job driver for the job run.</p>
        pub fn job_driver(mut self, input: crate::model::JobDriver) -> Self {
            self.job_driver = Some(input);
            self
        }
        /// <p>The job driver for the job run.</p>
        pub fn set_job_driver(
            mut self,
            input: std::option::Option<crate::model::JobDriver>,
        ) -> Self {
            self.job_driver = input;
            self
        }
        /// <p>The configuration overrides for the job run.</p>
        pub fn configuration_overrides(
            mut self,
            input: crate::model::ConfigurationOverrides,
        ) -> Self {
            self.configuration_overrides = Some(input);
            self
        }
        /// <p>The configuration overrides for the job run.</p>
        pub fn set_configuration_overrides(
            mut self,
            input: std::option::Option<crate::model::ConfigurationOverrides>,
        ) -> Self {
            self.configuration_overrides = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to job runs.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to job runs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartJobRunInput`](crate::input::StartJobRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartJobRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartJobRunInput {
                name: self.name,
                virtual_cluster_id: self.virtual_cluster_id,
                client_token: self.client_token,
                execution_role_arn: self.execution_role_arn,
                release_label: self.release_label,
                job_driver: self.job_driver,
                configuration_overrides: self.configuration_overrides,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartJobRunInputOperationOutputAlias = crate::operation::StartJobRun;
#[doc(hidden)]
pub type StartJobRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartJobRunInput {
    /// Consumes the builder and constructs an Operation<[`StartJobRun`](crate::operation::StartJobRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartJobRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartJobRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.virtual_cluster_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_cluster_id",
                        details: "cannot be empty or unset",
                    })?;
            let virtual_cluster_id = aws_smithy_http::label::fmt_string(input_38, false);
            if virtual_cluster_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "virtual_cluster_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/virtualclusters/{virtualClusterId}/jobruns",
                virtualClusterId = virtual_cluster_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartJobRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartJobRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_job_run(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartJobRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartJobRun",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartJobRunInput`](crate::input::StartJobRunInput)
    pub fn builder() -> crate::input::start_job_run_input::Builder {
        crate::input::start_job_run_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of resources.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of resources.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.resource_arn;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_39, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of resources.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of resources.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the resources.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys of the resources.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.resource_arn;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_40, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.tag_keys {
                for inner_42 in inner_41 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_42));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "emrcontainers",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of resources.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys of the resources.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of resources.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys of the resources.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of resources.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags assigned to resources.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of resources.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags assigned to resources.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobRunInput {
    /// <p>The name of the job run.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The virtual cluster ID for which the job run request is submitted.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
    /// <p>The client idempotency token of the job run request. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The execution role ARN for the job run.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon EMR release version to use for the job run.</p>
    pub release_label: std::option::Option<std::string::String>,
    /// <p>The job driver for the job run.</p>
    pub job_driver: std::option::Option<crate::model::JobDriver>,
    /// <p>The configuration overrides for the job run.</p>
    pub configuration_overrides: std::option::Option<crate::model::ConfigurationOverrides>,
    /// <p>The tags assigned to job runs.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartJobRunInput {
    /// <p>The name of the job run.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The virtual cluster ID for which the job run request is submitted.</p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
    /// <p>The client idempotency token of the job run request. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The execution role ARN for the job run.</p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>The Amazon EMR release version to use for the job run.</p>
    pub fn release_label(&self) -> std::option::Option<&str> {
        self.release_label.as_deref()
    }
    /// <p>The job driver for the job run.</p>
    pub fn job_driver(&self) -> std::option::Option<&crate::model::JobDriver> {
        self.job_driver.as_ref()
    }
    /// <p>The configuration overrides for the job run.</p>
    pub fn configuration_overrides(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationOverrides> {
        self.configuration_overrides.as_ref()
    }
    /// <p>The tags assigned to job runs.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartJobRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobRunInput");
        formatter.field("name", &self.name);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("release_label", &self.release_label);
        formatter.field("job_driver", &self.job_driver);
        formatter.field("configuration_overrides", &self.configuration_overrides);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualClustersInput {
    /// <p>The container provider ID of the virtual cluster.</p>
    pub container_provider_id: std::option::Option<std::string::String>,
    /// <p>The container provider type of the virtual cluster. EKS is the only supported type as of now.</p>
    pub container_provider_type: std::option::Option<crate::model::ContainerProviderType>,
    /// <p>The date and time after which the virtual clusters are created.</p>
    pub created_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time before which the virtual clusters are created.</p>
    pub created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The states of the requested virtual clusters.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::VirtualClusterState>>,
    /// <p>The maximum number of virtual clusters that can be listed.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of virtual clusters to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVirtualClustersInput {
    /// <p>The container provider ID of the virtual cluster.</p>
    pub fn container_provider_id(&self) -> std::option::Option<&str> {
        self.container_provider_id.as_deref()
    }
    /// <p>The container provider type of the virtual cluster. EKS is the only supported type as of now.</p>
    pub fn container_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::ContainerProviderType> {
        self.container_provider_type.as_ref()
    }
    /// <p>The date and time after which the virtual clusters are created.</p>
    pub fn created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_after.as_ref()
    }
    /// <p>The date and time before which the virtual clusters are created.</p>
    pub fn created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_before.as_ref()
    }
    /// <p>The states of the requested virtual clusters.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::VirtualClusterState]> {
        self.states.as_deref()
    }
    /// <p>The maximum number of virtual clusters that can be listed.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of virtual clusters to return. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualClustersInput");
        formatter.field("container_provider_id", &self.container_provider_id);
        formatter.field("container_provider_type", &self.container_provider_type);
        formatter.field("created_after", &self.created_after);
        formatter.field("created_before", &self.created_before);
        formatter.field("states", &self.states);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of tagged resources.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of tagged resources.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListManagedEndpointsInput {
    /// <p>The ID of the virtual cluster.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
    /// <p>The date and time before which the endpoints are created.</p>
    pub created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The date and time after which the endpoints are created.</p>
    pub created_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The types of the managed endpoints.</p>
    pub types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The states of the managed endpoints.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::EndpointState>>,
    /// <p>The maximum number of managed endpoints that can be listed.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> The token for the next set of managed endpoints to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListManagedEndpointsInput {
    /// <p>The ID of the virtual cluster.</p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
    /// <p>The date and time before which the endpoints are created.</p>
    pub fn created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_before.as_ref()
    }
    /// <p> The date and time after which the endpoints are created.</p>
    pub fn created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_after.as_ref()
    }
    /// <p>The types of the managed endpoints.</p>
    pub fn types(&self) -> std::option::Option<&[std::string::String]> {
        self.types.as_deref()
    }
    /// <p>The states of the managed endpoints.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::EndpointState]> {
        self.states.as_deref()
    }
    /// <p>The maximum number of managed endpoints that can be listed.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The token for the next set of managed endpoints to return. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListManagedEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListManagedEndpointsInput");
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.field("created_before", &self.created_before);
        formatter.field("created_after", &self.created_after);
        formatter.field("types", &self.types);
        formatter.field("states", &self.states);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobRunsInput {
    /// <p>The ID of the virtual cluster for which to list the job run. </p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
    /// <p>The date and time before which the job runs were submitted.</p>
    pub created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time after which the job runs were submitted.</p>
    pub created_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the job run.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The states of the job run.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::JobRunState>>,
    /// <p>The maximum number of job runs that can be listed.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of job runs to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobRunsInput {
    /// <p>The ID of the virtual cluster for which to list the job run. </p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
    /// <p>The date and time before which the job runs were submitted.</p>
    pub fn created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_before.as_ref()
    }
    /// <p>The date and time after which the job runs were submitted.</p>
    pub fn created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_after.as_ref()
    }
    /// <p>The name of the job run.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The states of the job run.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::JobRunState]> {
        self.states.as_deref()
    }
    /// <p>The maximum number of job runs that can be listed.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of job runs to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobRunsInput");
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.field("created_before", &self.created_before);
        formatter.field("created_after", &self.created_after);
        formatter.field("name", &self.name);
        formatter.field("states", &self.states);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualClusterInput {
    /// <p>The ID of the virtual cluster that will be described.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DescribeVirtualClusterInput {
    /// <p>The ID of the virtual cluster that will be described.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribeVirtualClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualClusterInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeManagedEndpointInput {
    /// <p>This output displays ID of the managed endpoint.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the endpoint's virtual cluster.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
}
impl DescribeManagedEndpointInput {
    /// <p>This output displays ID of the managed endpoint.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the endpoint's virtual cluster.</p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeManagedEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeManagedEndpointInput");
        formatter.field("id", &self.id);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobRunInput {
    /// <p>The ID of the job run request. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual cluster for which the job run is submitted.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
}
impl DescribeJobRunInput {
    /// <p>The ID of the job run request. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the virtual cluster for which the job run is submitted.</p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobRunInput");
        formatter.field("id", &self.id);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualClusterInput {
    /// <p>The ID of the virtual cluster that will be deleted.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteVirtualClusterInput {
    /// <p>The ID of the virtual cluster that will be deleted.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteVirtualClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualClusterInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteManagedEndpointInput {
    /// <p>The ID of the managed endpoint.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the endpoint's virtual cluster.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
}
impl DeleteManagedEndpointInput {
    /// <p>The ID of the managed endpoint.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the endpoint's virtual cluster.</p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteManagedEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteManagedEndpointInput");
        formatter.field("id", &self.id);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualClusterInput {
    /// <p>The specified name of the virtual cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The container provider of the virtual cluster.</p>
    pub container_provider: std::option::Option<crate::model::ContainerProvider>,
    /// <p>The client token of the virtual cluster.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags assigned to the virtual cluster.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateVirtualClusterInput {
    /// <p>The specified name of the virtual cluster.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The container provider of the virtual cluster.</p>
    pub fn container_provider(&self) -> std::option::Option<&crate::model::ContainerProvider> {
        self.container_provider.as_ref()
    }
    /// <p>The client token of the virtual cluster.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags assigned to the virtual cluster.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateVirtualClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualClusterInput");
        formatter.field("name", &self.name);
        formatter.field("container_provider", &self.container_provider);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateManagedEndpointInput {
    /// <p>The name of the managed endpoint.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual cluster for which a managed endpoint is created.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
    /// <p>The type of the managed endpoint.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The Amazon EMR release version.</p>
    pub release_label: std::option::Option<std::string::String>,
    /// <p>The ARN of the execution role.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The certificate ARN provided by users for the managed endpoint. This fiedd is under deprecation and will be removed in future releases.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The configuration settings that will be used to override existing configurations.</p>
    pub configuration_overrides: std::option::Option<crate::model::ConfigurationOverrides>,
    /// <p>The client idempotency token for this create call.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags of the managed endpoint.
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateManagedEndpointInput {
    /// <p>The name of the managed endpoint.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the virtual cluster for which a managed endpoint is created.</p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
    /// <p>The type of the managed endpoint.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The Amazon EMR release version.</p>
    pub fn release_label(&self) -> std::option::Option<&str> {
        self.release_label.as_deref()
    }
    /// <p>The ARN of the execution role.</p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>The certificate ARN provided by users for the managed endpoint. This fiedd is under deprecation and will be removed in future releases.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The configuration settings that will be used to override existing configurations.</p>
    pub fn configuration_overrides(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationOverrides> {
        self.configuration_overrides.as_ref()
    }
    /// <p>The client idempotency token for this create call.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags of the managed endpoint.
    /// </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateManagedEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateManagedEndpointInput");
        formatter.field("name", &self.name);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("release_label", &self.release_label);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("configuration_overrides", &self.configuration_overrides);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobRunInput {
    /// <p>The ID of the job run to cancel.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual cluster for which the job run will be canceled.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
}
impl CancelJobRunInput {
    /// <p>The ID of the job run to cancel.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the virtual cluster for which the job run will be canceled.</p>
    pub fn virtual_cluster_id(&self) -> std::option::Option<&str> {
        self.virtual_cluster_id.as_deref()
    }
}
impl std::fmt::Debug for CancelJobRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobRunInput");
        formatter.field("id", &self.id);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.finish()
    }
}
