// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A configuration specification to be used to override existing configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationOverrides {
    /// <p>The configurations for the application running by the job run. </p>
    pub application_configuration: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>The configurations for monitoring.</p>
    pub monitoring_configuration: std::option::Option<crate::model::MonitoringConfiguration>,
}
impl std::fmt::Debug for ConfigurationOverrides {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationOverrides");
        formatter.field("application_configuration", &self.application_configuration);
        formatter.field("monitoring_configuration", &self.monitoring_configuration);
        formatter.finish()
    }
}
/// See [`ConfigurationOverrides`](crate::model::ConfigurationOverrides)
pub mod configuration_overrides {
    /// A builder for [`ConfigurationOverrides`](crate::model::ConfigurationOverrides)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_configuration:
            std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) monitoring_configuration:
            std::option::Option<crate::model::MonitoringConfiguration>,
    }
    impl Builder {
        /// Appends an item to `application_configuration`.
        ///
        /// To override the contents of this collection use [`set_application_configuration`](Self::set_application_configuration).
        ///
        /// <p>The configurations for the application running by the job run. </p>
        pub fn application_configuration(
            mut self,
            input: impl Into<crate::model::Configuration>,
        ) -> Self {
            let mut v = self.application_configuration.unwrap_or_default();
            v.push(input.into());
            self.application_configuration = Some(v);
            self
        }
        /// <p>The configurations for the application running by the job run. </p>
        pub fn set_application_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.application_configuration = input;
            self
        }
        /// <p>The configurations for monitoring.</p>
        pub fn monitoring_configuration(
            mut self,
            input: crate::model::MonitoringConfiguration,
        ) -> Self {
            self.monitoring_configuration = Some(input);
            self
        }
        /// <p>The configurations for monitoring.</p>
        pub fn set_monitoring_configuration(
            mut self,
            input: std::option::Option<crate::model::MonitoringConfiguration>,
        ) -> Self {
            self.monitoring_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationOverrides`](crate::model::ConfigurationOverrides)
        pub fn build(self) -> crate::model::ConfigurationOverrides {
            crate::model::ConfigurationOverrides {
                application_configuration: self.application_configuration,
                monitoring_configuration: self.monitoring_configuration,
            }
        }
    }
}
impl ConfigurationOverrides {
    /// Creates a new builder-style object to manufacture [`ConfigurationOverrides`](crate::model::ConfigurationOverrides)
    pub fn builder() -> crate::model::configuration_overrides::Builder {
        crate::model::configuration_overrides::Builder::default()
    }
}

/// <p>Configuration setting for monitoring.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringConfiguration {
    /// <p>Monitoring configurations for the persistent application UI. </p>
    pub persistent_app_ui: std::option::Option<crate::model::PersistentAppUi>,
    /// <p>Monitoring configurations for CloudWatch.</p>
    pub cloud_watch_monitoring_configuration:
        std::option::Option<crate::model::CloudWatchMonitoringConfiguration>,
    /// <p>Amazon S3 configuration for monitoring log publishing.</p>
    pub s3_monitoring_configuration: std::option::Option<crate::model::S3MonitoringConfiguration>,
}
impl std::fmt::Debug for MonitoringConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringConfiguration");
        formatter.field("persistent_app_ui", &self.persistent_app_ui);
        formatter.field(
            "cloud_watch_monitoring_configuration",
            &self.cloud_watch_monitoring_configuration,
        );
        formatter.field(
            "s3_monitoring_configuration",
            &self.s3_monitoring_configuration,
        );
        formatter.finish()
    }
}
/// See [`MonitoringConfiguration`](crate::model::MonitoringConfiguration)
pub mod monitoring_configuration {
    /// A builder for [`MonitoringConfiguration`](crate::model::MonitoringConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) persistent_app_ui: std::option::Option<crate::model::PersistentAppUi>,
        pub(crate) cloud_watch_monitoring_configuration:
            std::option::Option<crate::model::CloudWatchMonitoringConfiguration>,
        pub(crate) s3_monitoring_configuration:
            std::option::Option<crate::model::S3MonitoringConfiguration>,
    }
    impl Builder {
        /// <p>Monitoring configurations for the persistent application UI. </p>
        pub fn persistent_app_ui(mut self, input: crate::model::PersistentAppUi) -> Self {
            self.persistent_app_ui = Some(input);
            self
        }
        /// <p>Monitoring configurations for the persistent application UI. </p>
        pub fn set_persistent_app_ui(
            mut self,
            input: std::option::Option<crate::model::PersistentAppUi>,
        ) -> Self {
            self.persistent_app_ui = input;
            self
        }
        /// <p>Monitoring configurations for CloudWatch.</p>
        pub fn cloud_watch_monitoring_configuration(
            mut self,
            input: crate::model::CloudWatchMonitoringConfiguration,
        ) -> Self {
            self.cloud_watch_monitoring_configuration = Some(input);
            self
        }
        /// <p>Monitoring configurations for CloudWatch.</p>
        pub fn set_cloud_watch_monitoring_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudWatchMonitoringConfiguration>,
        ) -> Self {
            self.cloud_watch_monitoring_configuration = input;
            self
        }
        /// <p>Amazon S3 configuration for monitoring log publishing.</p>
        pub fn s3_monitoring_configuration(
            mut self,
            input: crate::model::S3MonitoringConfiguration,
        ) -> Self {
            self.s3_monitoring_configuration = Some(input);
            self
        }
        /// <p>Amazon S3 configuration for monitoring log publishing.</p>
        pub fn set_s3_monitoring_configuration(
            mut self,
            input: std::option::Option<crate::model::S3MonitoringConfiguration>,
        ) -> Self {
            self.s3_monitoring_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringConfiguration`](crate::model::MonitoringConfiguration)
        pub fn build(self) -> crate::model::MonitoringConfiguration {
            crate::model::MonitoringConfiguration {
                persistent_app_ui: self.persistent_app_ui,
                cloud_watch_monitoring_configuration: self.cloud_watch_monitoring_configuration,
                s3_monitoring_configuration: self.s3_monitoring_configuration,
            }
        }
    }
}
impl MonitoringConfiguration {
    /// Creates a new builder-style object to manufacture [`MonitoringConfiguration`](crate::model::MonitoringConfiguration)
    pub fn builder() -> crate::model::monitoring_configuration::Builder {
        crate::model::monitoring_configuration::Builder::default()
    }
}

/// <p> Amazon S3 configuration for monitoring log publishing. You can configure your jobs to send log information to Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3MonitoringConfiguration {
    /// <p>Amazon S3 destination URI for log publishing.</p>
    pub log_uri: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3MonitoringConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3MonitoringConfiguration");
        formatter.field("log_uri", &self.log_uri);
        formatter.finish()
    }
}
/// See [`S3MonitoringConfiguration`](crate::model::S3MonitoringConfiguration)
pub mod s3_monitoring_configuration {
    /// A builder for [`S3MonitoringConfiguration`](crate::model::S3MonitoringConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon S3 destination URI for log publishing.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>Amazon S3 destination URI for log publishing.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`S3MonitoringConfiguration`](crate::model::S3MonitoringConfiguration)
        pub fn build(self) -> crate::model::S3MonitoringConfiguration {
            crate::model::S3MonitoringConfiguration {
                log_uri: self.log_uri,
            }
        }
    }
}
impl S3MonitoringConfiguration {
    /// Creates a new builder-style object to manufacture [`S3MonitoringConfiguration`](crate::model::S3MonitoringConfiguration)
    pub fn builder() -> crate::model::s3_monitoring_configuration::Builder {
        crate::model::s3_monitoring_configuration::Builder::default()
    }
}

/// <p>A configuration for CloudWatch monitoring. You can configure your jobs to send log information to CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchMonitoringConfiguration {
    /// <p>The name of the log group for log publishing.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>The specified name prefix for log streams.</p>
    pub log_stream_name_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchMonitoringConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchMonitoringConfiguration");
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("log_stream_name_prefix", &self.log_stream_name_prefix);
        formatter.finish()
    }
}
/// See [`CloudWatchMonitoringConfiguration`](crate::model::CloudWatchMonitoringConfiguration)
pub mod cloud_watch_monitoring_configuration {
    /// A builder for [`CloudWatchMonitoringConfiguration`](crate::model::CloudWatchMonitoringConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) log_stream_name_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the log group for log publishing.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group for log publishing.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>The specified name prefix for log streams.</p>
        pub fn log_stream_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_name_prefix = Some(input.into());
            self
        }
        /// <p>The specified name prefix for log streams.</p>
        pub fn set_log_stream_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_name_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchMonitoringConfiguration`](crate::model::CloudWatchMonitoringConfiguration)
        pub fn build(self) -> crate::model::CloudWatchMonitoringConfiguration {
            crate::model::CloudWatchMonitoringConfiguration {
                log_group_name: self.log_group_name,
                log_stream_name_prefix: self.log_stream_name_prefix,
            }
        }
    }
}
impl CloudWatchMonitoringConfiguration {
    /// Creates a new builder-style object to manufacture [`CloudWatchMonitoringConfiguration`](crate::model::CloudWatchMonitoringConfiguration)
    pub fn builder() -> crate::model::cloud_watch_monitoring_configuration::Builder {
        crate::model::cloud_watch_monitoring_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PersistentAppUi {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PersistentAppUi {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => PersistentAppUi::Disabled,
            "ENABLED" => PersistentAppUi::Enabled,
            other => PersistentAppUi::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PersistentAppUi {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PersistentAppUi::from(s))
    }
}
impl PersistentAppUi {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PersistentAppUi::Disabled => "DISABLED",
            PersistentAppUi::Enabled => "ENABLED",
            PersistentAppUi::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for PersistentAppUi {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A configuration specification to be used when provisioning virtual clusters, which can include configurations for applications and software bundled with Amazon EMR on EKS. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Configuration {
    /// <p>The classification within a configuration.</p>
    pub classification: std::option::Option<std::string::String>,
    /// <p>A set of properties specified within a configuration classification.</p>
    pub properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of additional configurations to apply within a configuration object.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
}
impl std::fmt::Debug for Configuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Configuration");
        formatter.field("classification", &self.classification);
        formatter.field("properties", &"*** Sensitive Data Redacted ***");
        formatter.field("configurations", &self.configurations);
        formatter.finish()
    }
}
/// See [`Configuration`](crate::model::Configuration)
pub mod configuration {
    /// A builder for [`Configuration`](crate::model::Configuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) classification: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    }
    impl Builder {
        /// <p>The classification within a configuration.</p>
        pub fn classification(mut self, input: impl Into<std::string::String>) -> Self {
            self.classification = Some(input.into());
            self
        }
        /// <p>The classification within a configuration.</p>
        pub fn set_classification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classification = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A set of properties specified within a configuration classification.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.properties = Some(hash_map);
            self
        }
        /// <p>A set of properties specified within a configuration classification.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A list of additional configurations to apply within a configuration object.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>A list of additional configurations to apply within a configuration object.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`Configuration`](crate::model::Configuration)
        pub fn build(self) -> crate::model::Configuration {
            crate::model::Configuration {
                classification: self.classification,
                properties: self.properties,
                configurations: self.configurations,
            }
        }
    }
}
impl Configuration {
    /// Creates a new builder-style object to manufacture [`Configuration`](crate::model::Configuration)
    pub fn builder() -> crate::model::configuration::Builder {
        crate::model::configuration::Builder::default()
    }
}

/// <p>Specify the driver that the job runs on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobDriver {
    /// <p>The job driver parameters specified for spark submit.</p>
    pub spark_submit_job_driver: std::option::Option<crate::model::SparkSubmitJobDriver>,
}
impl std::fmt::Debug for JobDriver {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobDriver");
        formatter.field("spark_submit_job_driver", &self.spark_submit_job_driver);
        formatter.finish()
    }
}
/// See [`JobDriver`](crate::model::JobDriver)
pub mod job_driver {
    /// A builder for [`JobDriver`](crate::model::JobDriver)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) spark_submit_job_driver: std::option::Option<crate::model::SparkSubmitJobDriver>,
    }
    impl Builder {
        /// <p>The job driver parameters specified for spark submit.</p>
        pub fn spark_submit_job_driver(
            mut self,
            input: crate::model::SparkSubmitJobDriver,
        ) -> Self {
            self.spark_submit_job_driver = Some(input);
            self
        }
        /// <p>The job driver parameters specified for spark submit.</p>
        pub fn set_spark_submit_job_driver(
            mut self,
            input: std::option::Option<crate::model::SparkSubmitJobDriver>,
        ) -> Self {
            self.spark_submit_job_driver = input;
            self
        }
        /// Consumes the builder and constructs a [`JobDriver`](crate::model::JobDriver)
        pub fn build(self) -> crate::model::JobDriver {
            crate::model::JobDriver {
                spark_submit_job_driver: self.spark_submit_job_driver,
            }
        }
    }
}
impl JobDriver {
    /// Creates a new builder-style object to manufacture [`JobDriver`](crate::model::JobDriver)
    pub fn builder() -> crate::model::job_driver::Builder {
        crate::model::job_driver::Builder::default()
    }
}

/// <p>The information about job driver for Spark submit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SparkSubmitJobDriver {
    /// <p>The entry point of job application.</p>
    pub entry_point: std::option::Option<std::string::String>,
    /// <p>The arguments for job application.</p>
    pub entry_point_arguments: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Spark submit parameters that are used for job runs.</p>
    pub spark_submit_parameters: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SparkSubmitJobDriver {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SparkSubmitJobDriver");
        formatter.field("entry_point", &"*** Sensitive Data Redacted ***");
        formatter.field("entry_point_arguments", &self.entry_point_arguments);
        formatter.field(
            "spark_submit_parameters",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.finish()
    }
}
/// See [`SparkSubmitJobDriver`](crate::model::SparkSubmitJobDriver)
pub mod spark_submit_job_driver {
    /// A builder for [`SparkSubmitJobDriver`](crate::model::SparkSubmitJobDriver)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_point: std::option::Option<std::string::String>,
        pub(crate) entry_point_arguments: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) spark_submit_parameters: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The entry point of job application.</p>
        pub fn entry_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_point = Some(input.into());
            self
        }
        /// <p>The entry point of job application.</p>
        pub fn set_entry_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_point = input;
            self
        }
        /// Appends an item to `entry_point_arguments`.
        ///
        /// To override the contents of this collection use [`set_entry_point_arguments`](Self::set_entry_point_arguments).
        ///
        /// <p>The arguments for job application.</p>
        pub fn entry_point_arguments(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entry_point_arguments.unwrap_or_default();
            v.push(input.into());
            self.entry_point_arguments = Some(v);
            self
        }
        /// <p>The arguments for job application.</p>
        pub fn set_entry_point_arguments(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entry_point_arguments = input;
            self
        }
        /// <p>The Spark submit parameters that are used for job runs.</p>
        pub fn spark_submit_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.spark_submit_parameters = Some(input.into());
            self
        }
        /// <p>The Spark submit parameters that are used for job runs.</p>
        pub fn set_spark_submit_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spark_submit_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`SparkSubmitJobDriver`](crate::model::SparkSubmitJobDriver)
        pub fn build(self) -> crate::model::SparkSubmitJobDriver {
            crate::model::SparkSubmitJobDriver {
                entry_point: self.entry_point,
                entry_point_arguments: self.entry_point_arguments,
                spark_submit_parameters: self.spark_submit_parameters,
            }
        }
    }
}
impl SparkSubmitJobDriver {
    /// Creates a new builder-style object to manufacture [`SparkSubmitJobDriver`](crate::model::SparkSubmitJobDriver)
    pub fn builder() -> crate::model::spark_submit_job_driver::Builder {
        crate::model::spark_submit_job_driver::Builder::default()
    }
}

/// <p>This entity describes a virtual cluster. A virtual cluster is a Kubernetes namespace that Amazon EMR is registered with. Amazon EMR uses virtual clusters to run jobs and host endpoints. Multiple virtual clusters can be backed by the same physical cluster. However, each virtual cluster maps to one namespace on an EKS cluster. Virtual clusters do not create any active resources that contribute to your bill or that require lifecycle management outside the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualCluster {
    /// <p>The ID of the virtual cluster.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the virtual cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the virtual cluster.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The state of the virtual cluster.</p>
    pub state: std::option::Option<crate::model::VirtualClusterState>,
    /// <p>The container provider of the virtual cluster.</p>
    pub container_provider: std::option::Option<crate::model::ContainerProvider>,
    /// <p>The date and time when the virtual cluster is created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The assigned tags of the virtual cluster.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for VirtualCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualCluster");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("state", &self.state);
        formatter.field("container_provider", &self.container_provider);
        formatter.field("created_at", &self.created_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`VirtualCluster`](crate::model::VirtualCluster)
pub mod virtual_cluster {
    /// A builder for [`VirtualCluster`](crate::model::VirtualCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::VirtualClusterState>,
        pub(crate) container_provider: std::option::Option<crate::model::ContainerProvider>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the virtual cluster.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual cluster.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the virtual cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the virtual cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the virtual cluster.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the virtual cluster.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The state of the virtual cluster.</p>
        pub fn state(mut self, input: crate::model::VirtualClusterState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the virtual cluster.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::VirtualClusterState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The container provider of the virtual cluster.</p>
        pub fn container_provider(mut self, input: crate::model::ContainerProvider) -> Self {
            self.container_provider = Some(input);
            self
        }
        /// <p>The container provider of the virtual cluster.</p>
        pub fn set_container_provider(
            mut self,
            input: std::option::Option<crate::model::ContainerProvider>,
        ) -> Self {
            self.container_provider = input;
            self
        }
        /// <p>The date and time when the virtual cluster is created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time when the virtual cluster is created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The assigned tags of the virtual cluster.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The assigned tags of the virtual cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualCluster`](crate::model::VirtualCluster)
        pub fn build(self) -> crate::model::VirtualCluster {
            crate::model::VirtualCluster {
                id: self.id,
                name: self.name,
                arn: self.arn,
                state: self.state,
                container_provider: self.container_provider,
                created_at: self.created_at,
                tags: self.tags,
            }
        }
    }
}
impl VirtualCluster {
    /// Creates a new builder-style object to manufacture [`VirtualCluster`](crate::model::VirtualCluster)
    pub fn builder() -> crate::model::virtual_cluster::Builder {
        crate::model::virtual_cluster::Builder::default()
    }
}

/// <p>The information about the container provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerProvider {
    /// <p>The type of the container provider. EKS is the only supported type as of now.</p>
    pub r#type: std::option::Option<crate::model::ContainerProviderType>,
    /// <p>The ID of the container cluster.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The information about the container cluster.</p>
    pub info: std::option::Option<crate::model::ContainerInfo>,
}
impl std::fmt::Debug for ContainerProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerProvider");
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("info", &self.info);
        formatter.finish()
    }
}
/// See [`ContainerProvider`](crate::model::ContainerProvider)
pub mod container_provider {
    /// A builder for [`ContainerProvider`](crate::model::ContainerProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ContainerProviderType>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) info: std::option::Option<crate::model::ContainerInfo>,
    }
    impl Builder {
        /// <p>The type of the container provider. EKS is the only supported type as of now.</p>
        pub fn r#type(mut self, input: crate::model::ContainerProviderType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the container provider. EKS is the only supported type as of now.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ContainerProviderType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the container cluster.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the container cluster.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The information about the container cluster.</p>
        pub fn info(mut self, input: crate::model::ContainerInfo) -> Self {
            self.info = Some(input);
            self
        }
        /// <p>The information about the container cluster.</p>
        pub fn set_info(mut self, input: std::option::Option<crate::model::ContainerInfo>) -> Self {
            self.info = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerProvider`](crate::model::ContainerProvider)
        pub fn build(self) -> crate::model::ContainerProvider {
            crate::model::ContainerProvider {
                r#type: self.r#type,
                id: self.id,
                info: self.info,
            }
        }
    }
}
impl ContainerProvider {
    /// Creates a new builder-style object to manufacture [`ContainerProvider`](crate::model::ContainerProvider)
    pub fn builder() -> crate::model::container_provider::Builder {
        crate::model::container_provider::Builder::default()
    }
}

/// <p>The information about the container used for a job run or a managed endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ContainerInfo {
    /// <p>The information about the EKS cluster.</p>
    EksInfo(crate::model::EksInfo),
}
impl ContainerInfo {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into its [`ContainerInfo`](crate::model::ContainerInfo) variant.
    /// Returns `Err(&Self) if it can't be converted.`
    pub fn as_eks_info(&self) -> std::result::Result<&crate::model::EksInfo, &Self> {
        if let ContainerInfo::EksInfo(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if the enum instance is the `ContainerInfo` variant.
    pub fn is_eks_info(&self) -> bool {
        self.as_eks_info().is_ok()
    }
}

/// <p>The information about the EKS cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EksInfo {
    /// <p>The namespaces of the EKS cluster.</p>
    pub namespace: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EksInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EksInfo");
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`EksInfo`](crate::model::EksInfo)
pub mod eks_info {
    /// A builder for [`EksInfo`](crate::model::EksInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespaces of the EKS cluster.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespaces of the EKS cluster.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`EksInfo`](crate::model::EksInfo)
        pub fn build(self) -> crate::model::EksInfo {
            crate::model::EksInfo {
                namespace: self.namespace,
            }
        }
    }
}
impl EksInfo {
    /// Creates a new builder-style object to manufacture [`EksInfo`](crate::model::EksInfo)
    pub fn builder() -> crate::model::eks_info::Builder {
        crate::model::eks_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerProviderType {
    #[allow(missing_docs)] // documentation missing in model
    Eks,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerProviderType {
    fn from(s: &str) -> Self {
        match s {
            "EKS" => ContainerProviderType::Eks,
            other => ContainerProviderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerProviderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerProviderType::from(s))
    }
}
impl ContainerProviderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerProviderType::Eks => "EKS",
            ContainerProviderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EKS"]
    }
}
impl AsRef<str> for ContainerProviderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualClusterState {
    #[allow(missing_docs)] // documentation missing in model
    Arrested,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualClusterState {
    fn from(s: &str) -> Self {
        match s {
            "ARRESTED" => VirtualClusterState::Arrested,
            "RUNNING" => VirtualClusterState::Running,
            "TERMINATED" => VirtualClusterState::Terminated,
            "TERMINATING" => VirtualClusterState::Terminating,
            other => VirtualClusterState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualClusterState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualClusterState::from(s))
    }
}
impl VirtualClusterState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualClusterState::Arrested => "ARRESTED",
            VirtualClusterState::Running => "RUNNING",
            VirtualClusterState::Terminated => "TERMINATED",
            VirtualClusterState::Terminating => "TERMINATING",
            VirtualClusterState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARRESTED", "RUNNING", "TERMINATED", "TERMINATING"]
    }
}
impl AsRef<str> for VirtualClusterState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This entity represents the endpoint that is managed by Amazon EMR on EKS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The ID of the endpoint.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the endpoint.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the endpoint's virtual cluster.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The state of the endpoint.</p>
    pub state: std::option::Option<crate::model::EndpointState>,
    /// <p>The EMR release version to be used for the endpoint.</p>
    pub release_label: std::option::Option<std::string::String>,
    /// <p>The execution role ARN of the endpoint.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The certificate ARN of the endpoint.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The configuration settings that are used to override existing configurations for endpoints.</p>
    pub configuration_overrides: std::option::Option<crate::model::ConfigurationOverrides>,
    /// <p>The server URL of the endpoint.</p>
    pub server_url: std::option::Option<std::string::String>,
    /// <p>The date and time when the endpoint was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The security group configuration of the endpoint.
    /// </p>
    pub security_group: std::option::Option<std::string::String>,
    /// <p>The subnet IDs of the endpoint.
    /// </p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// Additional details of the endpoint state.
    /// </p>
    pub state_details: std::option::Option<std::string::String>,
    /// <p>
    /// The reasons why the endpoint has failed.
    /// </p>
    pub failure_reason: std::option::Option<crate::model::FailureReason>,
    /// <p>The tags of the endpoint.
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field("release_label", &self.release_label);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("configuration_overrides", &self.configuration_overrides);
        formatter.field("server_url", &self.server_url);
        formatter.field("created_at", &self.created_at);
        formatter.field("security_group", &self.security_group);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("state_details", &self.state_details);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EndpointState>,
        pub(crate) release_label: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_overrides:
            std::option::Option<crate::model::ConfigurationOverrides>,
        pub(crate) server_url: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) security_group: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state_details: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<crate::model::FailureReason>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the endpoint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the endpoint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the endpoint.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the endpoint.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the endpoint's virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// <p>The type of the endpoint.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The state of the endpoint.</p>
        pub fn state(mut self, input: crate::model::EndpointState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the endpoint.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EndpointState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The EMR release version to be used for the endpoint.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_label = Some(input.into());
            self
        }
        /// <p>The EMR release version to be used for the endpoint.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_label = input;
            self
        }
        /// <p>The execution role ARN of the endpoint.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The execution role ARN of the endpoint.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The certificate ARN of the endpoint.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The certificate ARN of the endpoint.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The configuration settings that are used to override existing configurations for endpoints.</p>
        pub fn configuration_overrides(
            mut self,
            input: crate::model::ConfigurationOverrides,
        ) -> Self {
            self.configuration_overrides = Some(input);
            self
        }
        /// <p>The configuration settings that are used to override existing configurations for endpoints.</p>
        pub fn set_configuration_overrides(
            mut self,
            input: std::option::Option<crate::model::ConfigurationOverrides>,
        ) -> Self {
            self.configuration_overrides = input;
            self
        }
        /// <p>The server URL of the endpoint.</p>
        pub fn server_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_url = Some(input.into());
            self
        }
        /// <p>The server URL of the endpoint.</p>
        pub fn set_server_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_url = input;
            self
        }
        /// <p>The date and time when the endpoint was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time when the endpoint was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The security group configuration of the endpoint.
        /// </p>
        pub fn security_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group = Some(input.into());
            self
        }
        /// <p>The security group configuration of the endpoint.
        /// </p>
        pub fn set_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnet IDs of the endpoint.
        /// </p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnet IDs of the endpoint.
        /// </p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>
        /// Additional details of the endpoint state.
        /// </p>
        pub fn state_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_details = Some(input.into());
            self
        }
        /// <p>
        /// Additional details of the endpoint state.
        /// </p>
        pub fn set_state_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_details = input;
            self
        }
        /// <p>
        /// The reasons why the endpoint has failed.
        /// </p>
        pub fn failure_reason(mut self, input: crate::model::FailureReason) -> Self {
            self.failure_reason = Some(input);
            self
        }
        /// <p>
        /// The reasons why the endpoint has failed.
        /// </p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<crate::model::FailureReason>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the endpoint.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the endpoint.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                id: self.id,
                name: self.name,
                arn: self.arn,
                virtual_cluster_id: self.virtual_cluster_id,
                r#type: self.r#type,
                state: self.state,
                release_label: self.release_label,
                execution_role_arn: self.execution_role_arn,
                certificate_arn: self.certificate_arn,
                configuration_overrides: self.configuration_overrides,
                server_url: self.server_url,
                created_at: self.created_at,
                security_group: self.security_group,
                subnet_ids: self.subnet_ids,
                state_details: self.state_details,
                failure_reason: self.failure_reason,
                tags: self.tags,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailureReason {
    #[allow(missing_docs)] // documentation missing in model
    ClusterUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    UserError,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailureReason {
    fn from(s: &str) -> Self {
        match s {
            "CLUSTER_UNAVAILABLE" => FailureReason::ClusterUnavailable,
            "INTERNAL_ERROR" => FailureReason::InternalError,
            "USER_ERROR" => FailureReason::UserError,
            "VALIDATION_ERROR" => FailureReason::ValidationError,
            other => FailureReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailureReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailureReason::from(s))
    }
}
impl FailureReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailureReason::ClusterUnavailable => "CLUSTER_UNAVAILABLE",
            FailureReason::InternalError => "INTERNAL_ERROR",
            FailureReason::UserError => "USER_ERROR",
            FailureReason::ValidationError => "VALIDATION_ERROR",
            FailureReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLUSTER_UNAVAILABLE",
            "INTERNAL_ERROR",
            "USER_ERROR",
            "VALIDATION_ERROR",
        ]
    }
}
impl AsRef<str> for FailureReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    TerminatedWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => EndpointState::Active,
            "CREATING" => EndpointState::Creating,
            "TERMINATED" => EndpointState::Terminated,
            "TERMINATED_WITH_ERRORS" => EndpointState::TerminatedWithErrors,
            "TERMINATING" => EndpointState::Terminating,
            other => EndpointState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointState::from(s))
    }
}
impl EndpointState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointState::Active => "ACTIVE",
            EndpointState::Creating => "CREATING",
            EndpointState::Terminated => "TERMINATED",
            EndpointState::TerminatedWithErrors => "TERMINATED_WITH_ERRORS",
            EndpointState::Terminating => "TERMINATING",
            EndpointState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "TERMINATED",
            "TERMINATED_WITH_ERRORS",
            "TERMINATING",
        ]
    }
}
impl AsRef<str> for EndpointState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This entity describes a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobRun {
    /// <p>The ID of the job run.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the job run.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the job run's virtual cluster.</p>
    pub virtual_cluster_id: std::option::Option<std::string::String>,
    /// <p>The ARN of job run.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The state of the job run. </p>
    pub state: std::option::Option<crate::model::JobRunState>,
    /// <p>The client token used to start a job run.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The execution role ARN of the job run.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The release version of Amazon EMR.</p>
    pub release_label: std::option::Option<std::string::String>,
    /// <p>The configuration settings that are used to override default configuration.</p>
    pub configuration_overrides: std::option::Option<crate::model::ConfigurationOverrides>,
    /// <p>Parameters of job driver for the job run.</p>
    pub job_driver: std::option::Option<crate::model::JobDriver>,
    /// <p>The date and time when the job run was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user who created the job run.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the job run has finished.</p>
    pub finished_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Additional details of the job run state.</p>
    pub state_details: std::option::Option<std::string::String>,
    /// <p>The reasons why the job run has failed.</p>
    pub failure_reason: std::option::Option<crate::model::FailureReason>,
    /// <p>The assigned tags of the job run.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for JobRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobRun");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("virtual_cluster_id", &self.virtual_cluster_id);
        formatter.field("arn", &self.arn);
        formatter.field("state", &self.state);
        formatter.field("client_token", &self.client_token);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("release_label", &self.release_label);
        formatter.field("configuration_overrides", &self.configuration_overrides);
        formatter.field("job_driver", &self.job_driver);
        formatter.field("created_at", &self.created_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("finished_at", &self.finished_at);
        formatter.field("state_details", &self.state_details);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`JobRun`](crate::model::JobRun)
pub mod job_run {
    /// A builder for [`JobRun`](crate::model::JobRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) virtual_cluster_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::JobRunState>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) release_label: std::option::Option<std::string::String>,
        pub(crate) configuration_overrides:
            std::option::Option<crate::model::ConfigurationOverrides>,
        pub(crate) job_driver: std::option::Option<crate::model::JobDriver>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) finished_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state_details: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<crate::model::FailureReason>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the job run.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the job run.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the job run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the job run's virtual cluster.</p>
        pub fn virtual_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the job run's virtual cluster.</p>
        pub fn set_virtual_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_cluster_id = input;
            self
        }
        /// <p>The ARN of job run.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of job run.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The state of the job run. </p>
        pub fn state(mut self, input: crate::model::JobRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the job run. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::JobRunState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The client token used to start a job run.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The client token used to start a job run.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The execution role ARN of the job run.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The execution role ARN of the job run.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The release version of Amazon EMR.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_label = Some(input.into());
            self
        }
        /// <p>The release version of Amazon EMR.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_label = input;
            self
        }
        /// <p>The configuration settings that are used to override default configuration.</p>
        pub fn configuration_overrides(
            mut self,
            input: crate::model::ConfigurationOverrides,
        ) -> Self {
            self.configuration_overrides = Some(input);
            self
        }
        /// <p>The configuration settings that are used to override default configuration.</p>
        pub fn set_configuration_overrides(
            mut self,
            input: std::option::Option<crate::model::ConfigurationOverrides>,
        ) -> Self {
            self.configuration_overrides = input;
            self
        }
        /// <p>Parameters of job driver for the job run.</p>
        pub fn job_driver(mut self, input: crate::model::JobDriver) -> Self {
            self.job_driver = Some(input);
            self
        }
        /// <p>Parameters of job driver for the job run.</p>
        pub fn set_job_driver(
            mut self,
            input: std::option::Option<crate::model::JobDriver>,
        ) -> Self {
            self.job_driver = input;
            self
        }
        /// <p>The date and time when the job run was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time when the job run was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The user who created the job run.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The user who created the job run.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time when the job run has finished.</p>
        pub fn finished_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.finished_at = Some(input);
            self
        }
        /// <p>The date and time when the job run has finished.</p>
        pub fn set_finished_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.finished_at = input;
            self
        }
        /// <p>Additional details of the job run state.</p>
        pub fn state_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_details = Some(input.into());
            self
        }
        /// <p>Additional details of the job run state.</p>
        pub fn set_state_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_details = input;
            self
        }
        /// <p>The reasons why the job run has failed.</p>
        pub fn failure_reason(mut self, input: crate::model::FailureReason) -> Self {
            self.failure_reason = Some(input);
            self
        }
        /// <p>The reasons why the job run has failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<crate::model::FailureReason>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The assigned tags of the job run.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The assigned tags of the job run.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`JobRun`](crate::model::JobRun)
        pub fn build(self) -> crate::model::JobRun {
            crate::model::JobRun {
                id: self.id,
                name: self.name,
                virtual_cluster_id: self.virtual_cluster_id,
                arn: self.arn,
                state: self.state,
                client_token: self.client_token,
                execution_role_arn: self.execution_role_arn,
                release_label: self.release_label,
                configuration_overrides: self.configuration_overrides,
                job_driver: self.job_driver,
                created_at: self.created_at,
                created_by: self.created_by,
                finished_at: self.finished_at,
                state_details: self.state_details,
                failure_reason: self.failure_reason,
                tags: self.tags,
            }
        }
    }
}
impl JobRun {
    /// Creates a new builder-style object to manufacture [`JobRun`](crate::model::JobRun)
    pub fn builder() -> crate::model::job_run::Builder {
        crate::model::job_run::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobRunState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    CancelPending,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobRunState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => JobRunState::Cancelled,
            "CANCEL_PENDING" => JobRunState::CancelPending,
            "COMPLETED" => JobRunState::Completed,
            "FAILED" => JobRunState::Failed,
            "PENDING" => JobRunState::Pending,
            "RUNNING" => JobRunState::Running,
            "SUBMITTED" => JobRunState::Submitted,
            other => JobRunState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobRunState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobRunState::from(s))
    }
}
impl JobRunState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobRunState::Cancelled => "CANCELLED",
            JobRunState::CancelPending => "CANCEL_PENDING",
            JobRunState::Completed => "COMPLETED",
            JobRunState::Failed => "FAILED",
            JobRunState::Pending => "PENDING",
            JobRunState::Running => "RUNNING",
            JobRunState::Submitted => "SUBMITTED",
            JobRunState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "CANCEL_PENDING",
            "COMPLETED",
            "FAILED",
            "PENDING",
            "RUNNING",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for JobRunState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
