// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddInstanceFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_instance_fleet`](crate::client::Client::add_instance_fleet).
///
/// See [`crate::client::fluent_builders::AddInstanceFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddInstanceFleet {
    _private: (),
}
impl AddInstanceFleet {
    /// Creates a new builder-style object to manufacture [`AddInstanceFleetInput`](crate::input::AddInstanceFleetInput)
    pub fn builder() -> crate::input::add_instance_fleet_input::Builder {
        crate::input::add_instance_fleet_input::Builder::default()
    }
    /// Creates a new `AddInstanceFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddInstanceFleet {
    type Output = std::result::Result<
        crate::output::AddInstanceFleetOutput,
        crate::error::AddInstanceFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_instance_fleet_error(response)
        } else {
            crate::operation_deser::parse_add_instance_fleet_response(response)
        }
    }
}

/// Operation shape for `AddInstanceGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_instance_groups`](crate::client::Client::add_instance_groups).
///
/// See [`crate::client::fluent_builders::AddInstanceGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddInstanceGroups {
    _private: (),
}
impl AddInstanceGroups {
    /// Creates a new builder-style object to manufacture [`AddInstanceGroupsInput`](crate::input::AddInstanceGroupsInput)
    pub fn builder() -> crate::input::add_instance_groups_input::Builder {
        crate::input::add_instance_groups_input::Builder::default()
    }
    /// Creates a new `AddInstanceGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddInstanceGroups {
    type Output = std::result::Result<
        crate::output::AddInstanceGroupsOutput,
        crate::error::AddInstanceGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_instance_groups_error(response)
        } else {
            crate::operation_deser::parse_add_instance_groups_response(response)
        }
    }
}

/// Operation shape for `AddJobFlowSteps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_job_flow_steps`](crate::client::Client::add_job_flow_steps).
///
/// See [`crate::client::fluent_builders::AddJobFlowSteps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddJobFlowSteps {
    _private: (),
}
impl AddJobFlowSteps {
    /// Creates a new builder-style object to manufacture [`AddJobFlowStepsInput`](crate::input::AddJobFlowStepsInput)
    pub fn builder() -> crate::input::add_job_flow_steps_input::Builder {
        crate::input::add_job_flow_steps_input::Builder::default()
    }
    /// Creates a new `AddJobFlowSteps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddJobFlowSteps {
    type Output = std::result::Result<
        crate::output::AddJobFlowStepsOutput,
        crate::error::AddJobFlowStepsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_job_flow_steps_error(response)
        } else {
            crate::operation_deser::parse_add_job_flow_steps_response(response)
        }
    }
}

/// Operation shape for `AddTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags`](crate::client::Client::add_tags).
///
/// See [`crate::client::fluent_builders::AddTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTags {
    _private: (),
}
impl AddTags {
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
    /// Creates a new `AddTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTags {
    type Output = std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_error(response)
        } else {
            crate::operation_deser::parse_add_tags_response(response)
        }
    }
}

/// Operation shape for `CancelSteps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_steps`](crate::client::Client::cancel_steps).
///
/// See [`crate::client::fluent_builders::CancelSteps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelSteps {
    _private: (),
}
impl CancelSteps {
    /// Creates a new builder-style object to manufacture [`CancelStepsInput`](crate::input::CancelStepsInput)
    pub fn builder() -> crate::input::cancel_steps_input::Builder {
        crate::input::cancel_steps_input::Builder::default()
    }
    /// Creates a new `CancelSteps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelSteps {
    type Output =
        std::result::Result<crate::output::CancelStepsOutput, crate::error::CancelStepsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_steps_error(response)
        } else {
            crate::operation_deser::parse_cancel_steps_response(response)
        }
    }
}

/// Operation shape for `CreateSecurityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_security_configuration`](crate::client::Client::create_security_configuration).
///
/// See [`crate::client::fluent_builders::CreateSecurityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSecurityConfiguration {
    _private: (),
}
impl CreateSecurityConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateSecurityConfigurationInput`](crate::input::CreateSecurityConfigurationInput)
    pub fn builder() -> crate::input::create_security_configuration_input::Builder {
        crate::input::create_security_configuration_input::Builder::default()
    }
    /// Creates a new `CreateSecurityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSecurityConfiguration {
    type Output = std::result::Result<
        crate::output::CreateSecurityConfigurationOutput,
        crate::error::CreateSecurityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_security_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_security_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_studio`](crate::client::Client::create_studio).
///
/// See [`crate::client::fluent_builders::CreateStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStudio {
    _private: (),
}
impl CreateStudio {
    /// Creates a new builder-style object to manufacture [`CreateStudioInput`](crate::input::CreateStudioInput)
    pub fn builder() -> crate::input::create_studio_input::Builder {
        crate::input::create_studio_input::Builder::default()
    }
    /// Creates a new `CreateStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStudio {
    type Output =
        std::result::Result<crate::output::CreateStudioOutput, crate::error::CreateStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_studio_error(response)
        } else {
            crate::operation_deser::parse_create_studio_response(response)
        }
    }
}

/// Operation shape for `CreateStudioSessionMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_studio_session_mapping`](crate::client::Client::create_studio_session_mapping).
///
/// See [`crate::client::fluent_builders::CreateStudioSessionMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStudioSessionMapping {
    _private: (),
}
impl CreateStudioSessionMapping {
    /// Creates a new builder-style object to manufacture [`CreateStudioSessionMappingInput`](crate::input::CreateStudioSessionMappingInput)
    pub fn builder() -> crate::input::create_studio_session_mapping_input::Builder {
        crate::input::create_studio_session_mapping_input::Builder::default()
    }
    /// Creates a new `CreateStudioSessionMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStudioSessionMapping {
    type Output = std::result::Result<
        crate::output::CreateStudioSessionMappingOutput,
        crate::error::CreateStudioSessionMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_studio_session_mapping_error(response)
        } else {
            crate::operation_deser::parse_create_studio_session_mapping_response(response)
        }
    }
}

/// Operation shape for `DeleteSecurityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_security_configuration`](crate::client::Client::delete_security_configuration).
///
/// See [`crate::client::fluent_builders::DeleteSecurityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSecurityConfiguration {
    _private: (),
}
impl DeleteSecurityConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteSecurityConfigurationInput`](crate::input::DeleteSecurityConfigurationInput)
    pub fn builder() -> crate::input::delete_security_configuration_input::Builder {
        crate::input::delete_security_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteSecurityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSecurityConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteSecurityConfigurationOutput,
        crate::error::DeleteSecurityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_security_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_security_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_studio`](crate::client::Client::delete_studio).
///
/// See [`crate::client::fluent_builders::DeleteStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStudio {
    _private: (),
}
impl DeleteStudio {
    /// Creates a new builder-style object to manufacture [`DeleteStudioInput`](crate::input::DeleteStudioInput)
    pub fn builder() -> crate::input::delete_studio_input::Builder {
        crate::input::delete_studio_input::Builder::default()
    }
    /// Creates a new `DeleteStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStudio {
    type Output =
        std::result::Result<crate::output::DeleteStudioOutput, crate::error::DeleteStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_studio_error(response)
        } else {
            crate::operation_deser::parse_delete_studio_response(response)
        }
    }
}

/// Operation shape for `DeleteStudioSessionMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_studio_session_mapping`](crate::client::Client::delete_studio_session_mapping).
///
/// See [`crate::client::fluent_builders::DeleteStudioSessionMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStudioSessionMapping {
    _private: (),
}
impl DeleteStudioSessionMapping {
    /// Creates a new builder-style object to manufacture [`DeleteStudioSessionMappingInput`](crate::input::DeleteStudioSessionMappingInput)
    pub fn builder() -> crate::input::delete_studio_session_mapping_input::Builder {
        crate::input::delete_studio_session_mapping_input::Builder::default()
    }
    /// Creates a new `DeleteStudioSessionMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStudioSessionMapping {
    type Output = std::result::Result<
        crate::output::DeleteStudioSessionMappingOutput,
        crate::error::DeleteStudioSessionMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_studio_session_mapping_error(response)
        } else {
            crate::operation_deser::parse_delete_studio_session_mapping_response(response)
        }
    }
}

/// Operation shape for `DescribeCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster`](crate::client::Client::describe_cluster).
///
/// See [`crate::client::fluent_builders::DescribeCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCluster {
    _private: (),
}
impl DescribeCluster {
    /// Creates a new builder-style object to manufacture [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    pub fn builder() -> crate::input::describe_cluster_input::Builder {
        crate::input::describe_cluster_input::Builder::default()
    }
    /// Creates a new `DescribeCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCluster {
    type Output = std::result::Result<
        crate::output::DescribeClusterOutput,
        crate::error::DescribeClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_response(response)
        }
    }
}

/// Operation shape for `DescribeJobFlows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job_flows`](crate::client::Client::describe_job_flows).
///
/// See [`crate::client::fluent_builders::DescribeJobFlows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJobFlows {
    _private: (),
}
impl DescribeJobFlows {
    /// Creates a new builder-style object to manufacture [`DescribeJobFlowsInput`](crate::input::DescribeJobFlowsInput)
    pub fn builder() -> crate::input::describe_job_flows_input::Builder {
        crate::input::describe_job_flows_input::Builder::default()
    }
    /// Creates a new `DescribeJobFlows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJobFlows {
    type Output = std::result::Result<
        crate::output::DescribeJobFlowsOutput,
        crate::error::DescribeJobFlowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_flows_error(response)
        } else {
            crate::operation_deser::parse_describe_job_flows_response(response)
        }
    }
}

/// Operation shape for `DescribeNotebookExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_notebook_execution`](crate::client::Client::describe_notebook_execution).
///
/// See [`crate::client::fluent_builders::DescribeNotebookExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNotebookExecution {
    _private: (),
}
impl DescribeNotebookExecution {
    /// Creates a new builder-style object to manufacture [`DescribeNotebookExecutionInput`](crate::input::DescribeNotebookExecutionInput)
    pub fn builder() -> crate::input::describe_notebook_execution_input::Builder {
        crate::input::describe_notebook_execution_input::Builder::default()
    }
    /// Creates a new `DescribeNotebookExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNotebookExecution {
    type Output = std::result::Result<
        crate::output::DescribeNotebookExecutionOutput,
        crate::error::DescribeNotebookExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_notebook_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_notebook_execution_response(response)
        }
    }
}

/// Operation shape for `DescribeReleaseLabel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_release_label`](crate::client::Client::describe_release_label).
///
/// See [`crate::client::fluent_builders::DescribeReleaseLabel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReleaseLabel {
    _private: (),
}
impl DescribeReleaseLabel {
    /// Creates a new builder-style object to manufacture [`DescribeReleaseLabelInput`](crate::input::DescribeReleaseLabelInput)
    pub fn builder() -> crate::input::describe_release_label_input::Builder {
        crate::input::describe_release_label_input::Builder::default()
    }
    /// Creates a new `DescribeReleaseLabel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReleaseLabel {
    type Output = std::result::Result<
        crate::output::DescribeReleaseLabelOutput,
        crate::error::DescribeReleaseLabelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_release_label_error(response)
        } else {
            crate::operation_deser::parse_describe_release_label_response(response)
        }
    }
}

/// Operation shape for `DescribeSecurityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_security_configuration`](crate::client::Client::describe_security_configuration).
///
/// See [`crate::client::fluent_builders::DescribeSecurityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSecurityConfiguration {
    _private: (),
}
impl DescribeSecurityConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityConfigurationInput`](crate::input::DescribeSecurityConfigurationInput)
    pub fn builder() -> crate::input::describe_security_configuration_input::Builder {
        crate::input::describe_security_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeSecurityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSecurityConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeSecurityConfigurationOutput,
        crate::error::DescribeSecurityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_security_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_security_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeStep`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_step`](crate::client::Client::describe_step).
///
/// See [`crate::client::fluent_builders::DescribeStep`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStep {
    _private: (),
}
impl DescribeStep {
    /// Creates a new builder-style object to manufacture [`DescribeStepInput`](crate::input::DescribeStepInput)
    pub fn builder() -> crate::input::describe_step_input::Builder {
        crate::input::describe_step_input::Builder::default()
    }
    /// Creates a new `DescribeStep` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStep {
    type Output =
        std::result::Result<crate::output::DescribeStepOutput, crate::error::DescribeStepError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_step_error(response)
        } else {
            crate::operation_deser::parse_describe_step_response(response)
        }
    }
}

/// Operation shape for `DescribeStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_studio`](crate::client::Client::describe_studio).
///
/// See [`crate::client::fluent_builders::DescribeStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStudio {
    _private: (),
}
impl DescribeStudio {
    /// Creates a new builder-style object to manufacture [`DescribeStudioInput`](crate::input::DescribeStudioInput)
    pub fn builder() -> crate::input::describe_studio_input::Builder {
        crate::input::describe_studio_input::Builder::default()
    }
    /// Creates a new `DescribeStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStudio {
    type Output =
        std::result::Result<crate::output::DescribeStudioOutput, crate::error::DescribeStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_studio_error(response)
        } else {
            crate::operation_deser::parse_describe_studio_response(response)
        }
    }
}

/// Operation shape for `GetAutoTerminationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_auto_termination_policy`](crate::client::Client::get_auto_termination_policy).
///
/// See [`crate::client::fluent_builders::GetAutoTerminationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAutoTerminationPolicy {
    _private: (),
}
impl GetAutoTerminationPolicy {
    /// Creates a new builder-style object to manufacture [`GetAutoTerminationPolicyInput`](crate::input::GetAutoTerminationPolicyInput)
    pub fn builder() -> crate::input::get_auto_termination_policy_input::Builder {
        crate::input::get_auto_termination_policy_input::Builder::default()
    }
    /// Creates a new `GetAutoTerminationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAutoTerminationPolicy {
    type Output = std::result::Result<
        crate::output::GetAutoTerminationPolicyOutput,
        crate::error::GetAutoTerminationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_auto_termination_policy_error(response)
        } else {
            crate::operation_deser::parse_get_auto_termination_policy_response(response)
        }
    }
}

/// Operation shape for `GetBlockPublicAccessConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_block_public_access_configuration`](crate::client::Client::get_block_public_access_configuration).
///
/// See [`crate::client::fluent_builders::GetBlockPublicAccessConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBlockPublicAccessConfiguration {
    _private: (),
}
impl GetBlockPublicAccessConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBlockPublicAccessConfigurationInput`](crate::input::GetBlockPublicAccessConfigurationInput)
    pub fn builder() -> crate::input::get_block_public_access_configuration_input::Builder {
        crate::input::get_block_public_access_configuration_input::Builder::default()
    }
    /// Creates a new `GetBlockPublicAccessConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBlockPublicAccessConfiguration {
    type Output = std::result::Result<
        crate::output::GetBlockPublicAccessConfigurationOutput,
        crate::error::GetBlockPublicAccessConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_block_public_access_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_block_public_access_configuration_response(response)
        }
    }
}

/// Operation shape for `GetManagedScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_managed_scaling_policy`](crate::client::Client::get_managed_scaling_policy).
///
/// See [`crate::client::fluent_builders::GetManagedScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetManagedScalingPolicy {
    _private: (),
}
impl GetManagedScalingPolicy {
    /// Creates a new builder-style object to manufacture [`GetManagedScalingPolicyInput`](crate::input::GetManagedScalingPolicyInput)
    pub fn builder() -> crate::input::get_managed_scaling_policy_input::Builder {
        crate::input::get_managed_scaling_policy_input::Builder::default()
    }
    /// Creates a new `GetManagedScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetManagedScalingPolicy {
    type Output = std::result::Result<
        crate::output::GetManagedScalingPolicyOutput,
        crate::error::GetManagedScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_managed_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_get_managed_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `GetStudioSessionMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_studio_session_mapping`](crate::client::Client::get_studio_session_mapping).
///
/// See [`crate::client::fluent_builders::GetStudioSessionMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStudioSessionMapping {
    _private: (),
}
impl GetStudioSessionMapping {
    /// Creates a new builder-style object to manufacture [`GetStudioSessionMappingInput`](crate::input::GetStudioSessionMappingInput)
    pub fn builder() -> crate::input::get_studio_session_mapping_input::Builder {
        crate::input::get_studio_session_mapping_input::Builder::default()
    }
    /// Creates a new `GetStudioSessionMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStudioSessionMapping {
    type Output = std::result::Result<
        crate::output::GetStudioSessionMappingOutput,
        crate::error::GetStudioSessionMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_studio_session_mapping_error(response)
        } else {
            crate::operation_deser::parse_get_studio_session_mapping_response(response)
        }
    }
}

/// Operation shape for `ListBootstrapActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bootstrap_actions`](crate::client::Client::list_bootstrap_actions).
///
/// See [`crate::client::fluent_builders::ListBootstrapActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBootstrapActions {
    _private: (),
}
impl ListBootstrapActions {
    /// Creates a new builder-style object to manufacture [`ListBootstrapActionsInput`](crate::input::ListBootstrapActionsInput)
    pub fn builder() -> crate::input::list_bootstrap_actions_input::Builder {
        crate::input::list_bootstrap_actions_input::Builder::default()
    }
    /// Creates a new `ListBootstrapActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBootstrapActions {
    type Output = std::result::Result<
        crate::output::ListBootstrapActionsOutput,
        crate::error::ListBootstrapActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bootstrap_actions_error(response)
        } else {
            crate::operation_deser::parse_list_bootstrap_actions_response(response)
        }
    }
}

/// Operation shape for `ListClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_clusters`](crate::client::Client::list_clusters).
///
/// See [`crate::client::fluent_builders::ListClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListClusters {
    _private: (),
}
impl ListClusters {
    /// Creates a new builder-style object to manufacture [`ListClustersInput`](crate::input::ListClustersInput)
    pub fn builder() -> crate::input::list_clusters_input::Builder {
        crate::input::list_clusters_input::Builder::default()
    }
    /// Creates a new `ListClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListClusters {
    type Output =
        std::result::Result<crate::output::ListClustersOutput, crate::error::ListClustersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_clusters_error(response)
        } else {
            crate::operation_deser::parse_list_clusters_response(response)
        }
    }
}

/// Operation shape for `ListInstanceFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instance_fleets`](crate::client::Client::list_instance_fleets).
///
/// See [`crate::client::fluent_builders::ListInstanceFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstanceFleets {
    _private: (),
}
impl ListInstanceFleets {
    /// Creates a new builder-style object to manufacture [`ListInstanceFleetsInput`](crate::input::ListInstanceFleetsInput)
    pub fn builder() -> crate::input::list_instance_fleets_input::Builder {
        crate::input::list_instance_fleets_input::Builder::default()
    }
    /// Creates a new `ListInstanceFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstanceFleets {
    type Output = std::result::Result<
        crate::output::ListInstanceFleetsOutput,
        crate::error::ListInstanceFleetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instance_fleets_error(response)
        } else {
            crate::operation_deser::parse_list_instance_fleets_response(response)
        }
    }
}

/// Operation shape for `ListInstanceGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instance_groups`](crate::client::Client::list_instance_groups).
///
/// See [`crate::client::fluent_builders::ListInstanceGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstanceGroups {
    _private: (),
}
impl ListInstanceGroups {
    /// Creates a new builder-style object to manufacture [`ListInstanceGroupsInput`](crate::input::ListInstanceGroupsInput)
    pub fn builder() -> crate::input::list_instance_groups_input::Builder {
        crate::input::list_instance_groups_input::Builder::default()
    }
    /// Creates a new `ListInstanceGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstanceGroups {
    type Output = std::result::Result<
        crate::output::ListInstanceGroupsOutput,
        crate::error::ListInstanceGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instance_groups_error(response)
        } else {
            crate::operation_deser::parse_list_instance_groups_response(response)
        }
    }
}

/// Operation shape for `ListInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instances`](crate::client::Client::list_instances).
///
/// See [`crate::client::fluent_builders::ListInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstances {
    _private: (),
}
impl ListInstances {
    /// Creates a new builder-style object to manufacture [`ListInstancesInput`](crate::input::ListInstancesInput)
    pub fn builder() -> crate::input::list_instances_input::Builder {
        crate::input::list_instances_input::Builder::default()
    }
    /// Creates a new `ListInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstances {
    type Output =
        std::result::Result<crate::output::ListInstancesOutput, crate::error::ListInstancesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instances_error(response)
        } else {
            crate::operation_deser::parse_list_instances_response(response)
        }
    }
}

/// Operation shape for `ListNotebookExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_notebook_executions`](crate::client::Client::list_notebook_executions).
///
/// See [`crate::client::fluent_builders::ListNotebookExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNotebookExecutions {
    _private: (),
}
impl ListNotebookExecutions {
    /// Creates a new builder-style object to manufacture [`ListNotebookExecutionsInput`](crate::input::ListNotebookExecutionsInput)
    pub fn builder() -> crate::input::list_notebook_executions_input::Builder {
        crate::input::list_notebook_executions_input::Builder::default()
    }
    /// Creates a new `ListNotebookExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNotebookExecutions {
    type Output = std::result::Result<
        crate::output::ListNotebookExecutionsOutput,
        crate::error::ListNotebookExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_notebook_executions_error(response)
        } else {
            crate::operation_deser::parse_list_notebook_executions_response(response)
        }
    }
}

/// Operation shape for `ListReleaseLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_release_labels`](crate::client::Client::list_release_labels).
///
/// See [`crate::client::fluent_builders::ListReleaseLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReleaseLabels {
    _private: (),
}
impl ListReleaseLabels {
    /// Creates a new builder-style object to manufacture [`ListReleaseLabelsInput`](crate::input::ListReleaseLabelsInput)
    pub fn builder() -> crate::input::list_release_labels_input::Builder {
        crate::input::list_release_labels_input::Builder::default()
    }
    /// Creates a new `ListReleaseLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReleaseLabels {
    type Output = std::result::Result<
        crate::output::ListReleaseLabelsOutput,
        crate::error::ListReleaseLabelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_release_labels_error(response)
        } else {
            crate::operation_deser::parse_list_release_labels_response(response)
        }
    }
}

/// Operation shape for `ListSecurityConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_security_configurations`](crate::client::Client::list_security_configurations).
///
/// See [`crate::client::fluent_builders::ListSecurityConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSecurityConfigurations {
    _private: (),
}
impl ListSecurityConfigurations {
    /// Creates a new builder-style object to manufacture [`ListSecurityConfigurationsInput`](crate::input::ListSecurityConfigurationsInput)
    pub fn builder() -> crate::input::list_security_configurations_input::Builder {
        crate::input::list_security_configurations_input::Builder::default()
    }
    /// Creates a new `ListSecurityConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSecurityConfigurations {
    type Output = std::result::Result<
        crate::output::ListSecurityConfigurationsOutput,
        crate::error::ListSecurityConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_security_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_security_configurations_response(response)
        }
    }
}

/// Operation shape for `ListSteps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_steps`](crate::client::Client::list_steps).
///
/// See [`crate::client::fluent_builders::ListSteps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSteps {
    _private: (),
}
impl ListSteps {
    /// Creates a new builder-style object to manufacture [`ListStepsInput`](crate::input::ListStepsInput)
    pub fn builder() -> crate::input::list_steps_input::Builder {
        crate::input::list_steps_input::Builder::default()
    }
    /// Creates a new `ListSteps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSteps {
    type Output = std::result::Result<crate::output::ListStepsOutput, crate::error::ListStepsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_steps_error(response)
        } else {
            crate::operation_deser::parse_list_steps_response(response)
        }
    }
}

/// Operation shape for `ListStudios`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_studios`](crate::client::Client::list_studios).
///
/// See [`crate::client::fluent_builders::ListStudios`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStudios {
    _private: (),
}
impl ListStudios {
    /// Creates a new builder-style object to manufacture [`ListStudiosInput`](crate::input::ListStudiosInput)
    pub fn builder() -> crate::input::list_studios_input::Builder {
        crate::input::list_studios_input::Builder::default()
    }
    /// Creates a new `ListStudios` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStudios {
    type Output =
        std::result::Result<crate::output::ListStudiosOutput, crate::error::ListStudiosError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_studios_error(response)
        } else {
            crate::operation_deser::parse_list_studios_response(response)
        }
    }
}

/// Operation shape for `ListStudioSessionMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_studio_session_mappings`](crate::client::Client::list_studio_session_mappings).
///
/// See [`crate::client::fluent_builders::ListStudioSessionMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStudioSessionMappings {
    _private: (),
}
impl ListStudioSessionMappings {
    /// Creates a new builder-style object to manufacture [`ListStudioSessionMappingsInput`](crate::input::ListStudioSessionMappingsInput)
    pub fn builder() -> crate::input::list_studio_session_mappings_input::Builder {
        crate::input::list_studio_session_mappings_input::Builder::default()
    }
    /// Creates a new `ListStudioSessionMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStudioSessionMappings {
    type Output = std::result::Result<
        crate::output::ListStudioSessionMappingsOutput,
        crate::error::ListStudioSessionMappingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_studio_session_mappings_error(response)
        } else {
            crate::operation_deser::parse_list_studio_session_mappings_response(response)
        }
    }
}

/// Operation shape for `ModifyCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster`](crate::client::Client::modify_cluster).
///
/// See [`crate::client::fluent_builders::ModifyCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCluster {
    _private: (),
}
impl ModifyCluster {
    /// Creates a new builder-style object to manufacture [`ModifyClusterInput`](crate::input::ModifyClusterInput)
    pub fn builder() -> crate::input::modify_cluster_input::Builder {
        crate::input::modify_cluster_input::Builder::default()
    }
    /// Creates a new `ModifyCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCluster {
    type Output =
        std::result::Result<crate::output::ModifyClusterOutput, crate::error::ModifyClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_response(response)
        }
    }
}

/// Operation shape for `ModifyInstanceFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_fleet`](crate::client::Client::modify_instance_fleet).
///
/// See [`crate::client::fluent_builders::ModifyInstanceFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceFleet {
    _private: (),
}
impl ModifyInstanceFleet {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceFleetInput`](crate::input::ModifyInstanceFleetInput)
    pub fn builder() -> crate::input::modify_instance_fleet_input::Builder {
        crate::input::modify_instance_fleet_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstanceFleet {
    type Output = std::result::Result<
        crate::output::ModifyInstanceFleetOutput,
        crate::error::ModifyInstanceFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_fleet_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_fleet_response(response)
        }
    }
}

/// Operation shape for `ModifyInstanceGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_groups`](crate::client::Client::modify_instance_groups).
///
/// See [`crate::client::fluent_builders::ModifyInstanceGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceGroups {
    _private: (),
}
impl ModifyInstanceGroups {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceGroupsInput`](crate::input::ModifyInstanceGroupsInput)
    pub fn builder() -> crate::input::modify_instance_groups_input::Builder {
        crate::input::modify_instance_groups_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstanceGroups {
    type Output = std::result::Result<
        crate::output::ModifyInstanceGroupsOutput,
        crate::error::ModifyInstanceGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_groups_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_groups_response(response)
        }
    }
}

/// Operation shape for `PutAutoScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_auto_scaling_policy`](crate::client::Client::put_auto_scaling_policy).
///
/// See [`crate::client::fluent_builders::PutAutoScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAutoScalingPolicy {
    _private: (),
}
impl PutAutoScalingPolicy {
    /// Creates a new builder-style object to manufacture [`PutAutoScalingPolicyInput`](crate::input::PutAutoScalingPolicyInput)
    pub fn builder() -> crate::input::put_auto_scaling_policy_input::Builder {
        crate::input::put_auto_scaling_policy_input::Builder::default()
    }
    /// Creates a new `PutAutoScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAutoScalingPolicy {
    type Output = std::result::Result<
        crate::output::PutAutoScalingPolicyOutput,
        crate::error::PutAutoScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_auto_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_put_auto_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `PutAutoTerminationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_auto_termination_policy`](crate::client::Client::put_auto_termination_policy).
///
/// See [`crate::client::fluent_builders::PutAutoTerminationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAutoTerminationPolicy {
    _private: (),
}
impl PutAutoTerminationPolicy {
    /// Creates a new builder-style object to manufacture [`PutAutoTerminationPolicyInput`](crate::input::PutAutoTerminationPolicyInput)
    pub fn builder() -> crate::input::put_auto_termination_policy_input::Builder {
        crate::input::put_auto_termination_policy_input::Builder::default()
    }
    /// Creates a new `PutAutoTerminationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAutoTerminationPolicy {
    type Output = std::result::Result<
        crate::output::PutAutoTerminationPolicyOutput,
        crate::error::PutAutoTerminationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_auto_termination_policy_error(response)
        } else {
            crate::operation_deser::parse_put_auto_termination_policy_response(response)
        }
    }
}

/// Operation shape for `PutBlockPublicAccessConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_block_public_access_configuration`](crate::client::Client::put_block_public_access_configuration).
///
/// See [`crate::client::fluent_builders::PutBlockPublicAccessConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBlockPublicAccessConfiguration {
    _private: (),
}
impl PutBlockPublicAccessConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBlockPublicAccessConfigurationInput`](crate::input::PutBlockPublicAccessConfigurationInput)
    pub fn builder() -> crate::input::put_block_public_access_configuration_input::Builder {
        crate::input::put_block_public_access_configuration_input::Builder::default()
    }
    /// Creates a new `PutBlockPublicAccessConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBlockPublicAccessConfiguration {
    type Output = std::result::Result<
        crate::output::PutBlockPublicAccessConfigurationOutput,
        crate::error::PutBlockPublicAccessConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_block_public_access_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_block_public_access_configuration_response(response)
        }
    }
}

/// Operation shape for `PutManagedScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_managed_scaling_policy`](crate::client::Client::put_managed_scaling_policy).
///
/// See [`crate::client::fluent_builders::PutManagedScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutManagedScalingPolicy {
    _private: (),
}
impl PutManagedScalingPolicy {
    /// Creates a new builder-style object to manufacture [`PutManagedScalingPolicyInput`](crate::input::PutManagedScalingPolicyInput)
    pub fn builder() -> crate::input::put_managed_scaling_policy_input::Builder {
        crate::input::put_managed_scaling_policy_input::Builder::default()
    }
    /// Creates a new `PutManagedScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutManagedScalingPolicy {
    type Output = std::result::Result<
        crate::output::PutManagedScalingPolicyOutput,
        crate::error::PutManagedScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_managed_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_put_managed_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `RemoveAutoScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_auto_scaling_policy`](crate::client::Client::remove_auto_scaling_policy).
///
/// See [`crate::client::fluent_builders::RemoveAutoScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveAutoScalingPolicy {
    _private: (),
}
impl RemoveAutoScalingPolicy {
    /// Creates a new builder-style object to manufacture [`RemoveAutoScalingPolicyInput`](crate::input::RemoveAutoScalingPolicyInput)
    pub fn builder() -> crate::input::remove_auto_scaling_policy_input::Builder {
        crate::input::remove_auto_scaling_policy_input::Builder::default()
    }
    /// Creates a new `RemoveAutoScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveAutoScalingPolicy {
    type Output = std::result::Result<
        crate::output::RemoveAutoScalingPolicyOutput,
        crate::error::RemoveAutoScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_auto_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_remove_auto_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `RemoveAutoTerminationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_auto_termination_policy`](crate::client::Client::remove_auto_termination_policy).
///
/// See [`crate::client::fluent_builders::RemoveAutoTerminationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveAutoTerminationPolicy {
    _private: (),
}
impl RemoveAutoTerminationPolicy {
    /// Creates a new builder-style object to manufacture [`RemoveAutoTerminationPolicyInput`](crate::input::RemoveAutoTerminationPolicyInput)
    pub fn builder() -> crate::input::remove_auto_termination_policy_input::Builder {
        crate::input::remove_auto_termination_policy_input::Builder::default()
    }
    /// Creates a new `RemoveAutoTerminationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveAutoTerminationPolicy {
    type Output = std::result::Result<
        crate::output::RemoveAutoTerminationPolicyOutput,
        crate::error::RemoveAutoTerminationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_auto_termination_policy_error(response)
        } else {
            crate::operation_deser::parse_remove_auto_termination_policy_response(response)
        }
    }
}

/// Operation shape for `RemoveManagedScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_managed_scaling_policy`](crate::client::Client::remove_managed_scaling_policy).
///
/// See [`crate::client::fluent_builders::RemoveManagedScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveManagedScalingPolicy {
    _private: (),
}
impl RemoveManagedScalingPolicy {
    /// Creates a new builder-style object to manufacture [`RemoveManagedScalingPolicyInput`](crate::input::RemoveManagedScalingPolicyInput)
    pub fn builder() -> crate::input::remove_managed_scaling_policy_input::Builder {
        crate::input::remove_managed_scaling_policy_input::Builder::default()
    }
    /// Creates a new `RemoveManagedScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveManagedScalingPolicy {
    type Output = std::result::Result<
        crate::output::RemoveManagedScalingPolicyOutput,
        crate::error::RemoveManagedScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_managed_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_remove_managed_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `RemoveTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags`](crate::client::Client::remove_tags).
///
/// See [`crate::client::fluent_builders::RemoveTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTags {
    _private: (),
}
impl RemoveTags {
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
    /// Creates a new `RemoveTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTags {
    type Output =
        std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_response(response)
        }
    }
}

/// Operation shape for `RunJobFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`run_job_flow`](crate::client::Client::run_job_flow).
///
/// See [`crate::client::fluent_builders::RunJobFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RunJobFlow {
    _private: (),
}
impl RunJobFlow {
    /// Creates a new builder-style object to manufacture [`RunJobFlowInput`](crate::input::RunJobFlowInput)
    pub fn builder() -> crate::input::run_job_flow_input::Builder {
        crate::input::run_job_flow_input::Builder::default()
    }
    /// Creates a new `RunJobFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RunJobFlow {
    type Output =
        std::result::Result<crate::output::RunJobFlowOutput, crate::error::RunJobFlowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_run_job_flow_error(response)
        } else {
            crate::operation_deser::parse_run_job_flow_response(response)
        }
    }
}

/// Operation shape for `SetTerminationProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_termination_protection`](crate::client::Client::set_termination_protection).
///
/// See [`crate::client::fluent_builders::SetTerminationProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetTerminationProtection {
    _private: (),
}
impl SetTerminationProtection {
    /// Creates a new builder-style object to manufacture [`SetTerminationProtectionInput`](crate::input::SetTerminationProtectionInput)
    pub fn builder() -> crate::input::set_termination_protection_input::Builder {
        crate::input::set_termination_protection_input::Builder::default()
    }
    /// Creates a new `SetTerminationProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetTerminationProtection {
    type Output = std::result::Result<
        crate::output::SetTerminationProtectionOutput,
        crate::error::SetTerminationProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_termination_protection_error(response)
        } else {
            crate::operation_deser::parse_set_termination_protection_response(response)
        }
    }
}

/// Operation shape for `SetVisibleToAllUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_visible_to_all_users`](crate::client::Client::set_visible_to_all_users).
///
/// See [`crate::client::fluent_builders::SetVisibleToAllUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetVisibleToAllUsers {
    _private: (),
}
impl SetVisibleToAllUsers {
    /// Creates a new builder-style object to manufacture [`SetVisibleToAllUsersInput`](crate::input::SetVisibleToAllUsersInput)
    pub fn builder() -> crate::input::set_visible_to_all_users_input::Builder {
        crate::input::set_visible_to_all_users_input::Builder::default()
    }
    /// Creates a new `SetVisibleToAllUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetVisibleToAllUsers {
    type Output = std::result::Result<
        crate::output::SetVisibleToAllUsersOutput,
        crate::error::SetVisibleToAllUsersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_visible_to_all_users_error(response)
        } else {
            crate::operation_deser::parse_set_visible_to_all_users_response(response)
        }
    }
}

/// Operation shape for `StartNotebookExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_notebook_execution`](crate::client::Client::start_notebook_execution).
///
/// See [`crate::client::fluent_builders::StartNotebookExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartNotebookExecution {
    _private: (),
}
impl StartNotebookExecution {
    /// Creates a new builder-style object to manufacture [`StartNotebookExecutionInput`](crate::input::StartNotebookExecutionInput)
    pub fn builder() -> crate::input::start_notebook_execution_input::Builder {
        crate::input::start_notebook_execution_input::Builder::default()
    }
    /// Creates a new `StartNotebookExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartNotebookExecution {
    type Output = std::result::Result<
        crate::output::StartNotebookExecutionOutput,
        crate::error::StartNotebookExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_notebook_execution_error(response)
        } else {
            crate::operation_deser::parse_start_notebook_execution_response(response)
        }
    }
}

/// Operation shape for `StopNotebookExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_notebook_execution`](crate::client::Client::stop_notebook_execution).
///
/// See [`crate::client::fluent_builders::StopNotebookExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopNotebookExecution {
    _private: (),
}
impl StopNotebookExecution {
    /// Creates a new builder-style object to manufacture [`StopNotebookExecutionInput`](crate::input::StopNotebookExecutionInput)
    pub fn builder() -> crate::input::stop_notebook_execution_input::Builder {
        crate::input::stop_notebook_execution_input::Builder::default()
    }
    /// Creates a new `StopNotebookExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopNotebookExecution {
    type Output = std::result::Result<
        crate::output::StopNotebookExecutionOutput,
        crate::error::StopNotebookExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_notebook_execution_error(response)
        } else {
            crate::operation_deser::parse_stop_notebook_execution_response(response)
        }
    }
}

/// Operation shape for `TerminateJobFlows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_job_flows`](crate::client::Client::terminate_job_flows).
///
/// See [`crate::client::fluent_builders::TerminateJobFlows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateJobFlows {
    _private: (),
}
impl TerminateJobFlows {
    /// Creates a new builder-style object to manufacture [`TerminateJobFlowsInput`](crate::input::TerminateJobFlowsInput)
    pub fn builder() -> crate::input::terminate_job_flows_input::Builder {
        crate::input::terminate_job_flows_input::Builder::default()
    }
    /// Creates a new `TerminateJobFlows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateJobFlows {
    type Output = std::result::Result<
        crate::output::TerminateJobFlowsOutput,
        crate::error::TerminateJobFlowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_job_flows_error(response)
        } else {
            crate::operation_deser::parse_terminate_job_flows_response(response)
        }
    }
}

/// Operation shape for `UpdateStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_studio`](crate::client::Client::update_studio).
///
/// See [`crate::client::fluent_builders::UpdateStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStudio {
    _private: (),
}
impl UpdateStudio {
    /// Creates a new builder-style object to manufacture [`UpdateStudioInput`](crate::input::UpdateStudioInput)
    pub fn builder() -> crate::input::update_studio_input::Builder {
        crate::input::update_studio_input::Builder::default()
    }
    /// Creates a new `UpdateStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStudio {
    type Output =
        std::result::Result<crate::output::UpdateStudioOutput, crate::error::UpdateStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_studio_error(response)
        } else {
            crate::operation_deser::parse_update_studio_response(response)
        }
    }
}

/// Operation shape for `UpdateStudioSessionMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_studio_session_mapping`](crate::client::Client::update_studio_session_mapping).
///
/// See [`crate::client::fluent_builders::UpdateStudioSessionMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStudioSessionMapping {
    _private: (),
}
impl UpdateStudioSessionMapping {
    /// Creates a new builder-style object to manufacture [`UpdateStudioSessionMappingInput`](crate::input::UpdateStudioSessionMappingInput)
    pub fn builder() -> crate::input::update_studio_session_mapping_input::Builder {
        crate::input::update_studio_session_mapping_input::Builder::default()
    }
    /// Creates a new `UpdateStudioSessionMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStudioSessionMapping {
    type Output = std::result::Result<
        crate::output::UpdateStudioSessionMappingOutput,
        crate::error::UpdateStudioSessionMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_studio_session_mapping_error(response)
        } else {
            crate::operation_deser::parse_update_studio_session_mapping_response(response)
        }
    }
}
