// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon EMR
///
/// Client for invoking operations on Amazon EMR. Each operation on Amazon EMR is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_emr::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_emr::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_emr::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddInstanceFleet`](crate::client::fluent_builders::AddInstanceFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::AddInstanceFleet::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::AddInstanceFleet::set_cluster_id): <p>The unique identifier of the cluster.</p>
    ///   - [`instance_fleet(InstanceFleetConfig)`](crate::client::fluent_builders::AddInstanceFleet::instance_fleet) / [`set_instance_fleet(Option<InstanceFleetConfig>)`](crate::client::fluent_builders::AddInstanceFleet::set_instance_fleet): <p>Specifies the configuration of the instance fleet.</p>
    /// - On success, responds with [`AddInstanceFleetOutput`](crate::output::AddInstanceFleetOutput) with field(s):
    ///   - [`cluster_id(Option<String>)`](crate::output::AddInstanceFleetOutput::cluster_id): <p>The unique identifier of the cluster.</p>
    ///   - [`instance_fleet_id(Option<String>)`](crate::output::AddInstanceFleetOutput::instance_fleet_id): <p>The unique identifier of the instance fleet.</p>
    ///   - [`cluster_arn(Option<String>)`](crate::output::AddInstanceFleetOutput::cluster_arn): <p>The Amazon Resource Name of the cluster.</p>
    /// - On failure, responds with [`SdkError<AddInstanceFleetError>`](crate::error::AddInstanceFleetError)
    pub fn add_instance_fleet(&self) -> fluent_builders::AddInstanceFleet {
        fluent_builders::AddInstanceFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddInstanceGroups`](crate::client::fluent_builders::AddInstanceGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_groups(Vec<InstanceGroupConfig>)`](crate::client::fluent_builders::AddInstanceGroups::instance_groups) / [`set_instance_groups(Option<Vec<InstanceGroupConfig>>)`](crate::client::fluent_builders::AddInstanceGroups::set_instance_groups): <p>Instance groups to add.</p>
    ///   - [`job_flow_id(impl Into<String>)`](crate::client::fluent_builders::AddInstanceGroups::job_flow_id) / [`set_job_flow_id(Option<String>)`](crate::client::fluent_builders::AddInstanceGroups::set_job_flow_id): <p>Job flow in which to add the instance groups.</p>
    /// - On success, responds with [`AddInstanceGroupsOutput`](crate::output::AddInstanceGroupsOutput) with field(s):
    ///   - [`job_flow_id(Option<String>)`](crate::output::AddInstanceGroupsOutput::job_flow_id): <p>The job flow ID in which the instance groups are added.</p>
    ///   - [`instance_group_ids(Option<Vec<String>>)`](crate::output::AddInstanceGroupsOutput::instance_group_ids): <p>Instance group IDs of the newly created instance groups.</p>
    ///   - [`cluster_arn(Option<String>)`](crate::output::AddInstanceGroupsOutput::cluster_arn): <p>The Amazon Resource Name of the cluster.</p>
    /// - On failure, responds with [`SdkError<AddInstanceGroupsError>`](crate::error::AddInstanceGroupsError)
    pub fn add_instance_groups(&self) -> fluent_builders::AddInstanceGroups {
        fluent_builders::AddInstanceGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddJobFlowSteps`](crate::client::fluent_builders::AddJobFlowSteps) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_flow_id(impl Into<String>)`](crate::client::fluent_builders::AddJobFlowSteps::job_flow_id) / [`set_job_flow_id(Option<String>)`](crate::client::fluent_builders::AddJobFlowSteps::set_job_flow_id): <p>A string that uniquely identifies the job flow. This identifier is returned by <code>RunJobFlow</code> and can also be obtained from <code>ListClusters</code>. </p>
    ///   - [`steps(Vec<StepConfig>)`](crate::client::fluent_builders::AddJobFlowSteps::steps) / [`set_steps(Option<Vec<StepConfig>>)`](crate::client::fluent_builders::AddJobFlowSteps::set_steps): <p> A list of <code>StepConfig</code> to be executed by the job flow. </p>
    /// - On success, responds with [`AddJobFlowStepsOutput`](crate::output::AddJobFlowStepsOutput) with field(s):
    ///   - [`step_ids(Option<Vec<String>>)`](crate::output::AddJobFlowStepsOutput::step_ids): <p>The identifiers of the list of steps added to the job flow.</p>
    /// - On failure, responds with [`SdkError<AddJobFlowStepsError>`](crate::error::AddJobFlowStepsError)
    pub fn add_job_flow_steps(&self) -> fluent_builders::AddJobFlowSteps {
        fluent_builders::AddJobFlowSteps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTags`](crate::client::fluent_builders::AddTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AddTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AddTags::set_resource_id): <p>The Amazon EMR resource identifier to which tags will be added. For example, a cluster identifier or an Amazon EMR Studio ID.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTags::set_tags): <p>A list of tags to associate with a resource. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>
    /// - On success, responds with [`AddTagsOutput`](crate::output::AddTagsOutput)

    /// - On failure, responds with [`SdkError<AddTagsError>`](crate::error::AddTagsError)
    pub fn add_tags(&self) -> fluent_builders::AddTags {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelSteps`](crate::client::fluent_builders::CancelSteps) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::CancelSteps::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::CancelSteps::set_cluster_id): <p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <code>RunJobFlow</code> and <code>ListClusters</code> to get ClusterIDs. </p>
    ///   - [`step_ids(Vec<String>)`](crate::client::fluent_builders::CancelSteps::step_ids) / [`set_step_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CancelSteps::set_step_ids): <p>The list of <code>StepIDs</code> to cancel. Use <code>ListSteps</code> to get steps and their states for the specified cluster.</p>
    ///   - [`step_cancellation_option(StepCancellationOption)`](crate::client::fluent_builders::CancelSteps::step_cancellation_option) / [`set_step_cancellation_option(Option<StepCancellationOption>)`](crate::client::fluent_builders::CancelSteps::set_step_cancellation_option): <p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is <code>SEND_INTERRUPT</code>.</p>
    /// - On success, responds with [`CancelStepsOutput`](crate::output::CancelStepsOutput) with field(s):
    ///   - [`cancel_steps_info_list(Option<Vec<CancelStepsInfo>>)`](crate::output::CancelStepsOutput::cancel_steps_info_list): <p>A list of <code>CancelStepsInfo</code>, which shows the status of specified cancel requests for each <code>StepID</code> specified.</p>
    /// - On failure, responds with [`SdkError<CancelStepsError>`](crate::error::CancelStepsError)
    pub fn cancel_steps(&self) -> fluent_builders::CancelSteps {
        fluent_builders::CancelSteps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSecurityConfiguration`](crate::client::fluent_builders::CreateSecurityConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSecurityConfiguration::set_name): <p>The name of the security configuration.</p>
    ///   - [`security_configuration(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityConfiguration::security_configuration) / [`set_security_configuration(Option<String>)`](crate::client::fluent_builders::CreateSecurityConfiguration::set_security_configuration): <p>The security configuration details in JSON format. For JSON parameters and examples, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.</p>
    /// - On success, responds with [`CreateSecurityConfigurationOutput`](crate::output::CreateSecurityConfigurationOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateSecurityConfigurationOutput::name): <p>The name of the security configuration.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateSecurityConfigurationOutput::creation_date_time): <p>The date and time the security configuration was created.</p>
    /// - On failure, responds with [`SdkError<CreateSecurityConfigurationError>`](crate::error::CreateSecurityConfigurationError)
    pub fn create_security_configuration(&self) -> fluent_builders::CreateSecurityConfiguration {
        fluent_builders::CreateSecurityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStudio`](crate::client::fluent_builders::CreateStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_name): <p>A descriptive name for the Amazon EMR Studio.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_description): <p>A detailed description of the Amazon EMR Studio.</p>
    ///   - [`auth_mode(AuthMode)`](crate::client::fluent_builders::CreateStudio::auth_mode) / [`set_auth_mode(Option<AuthMode>)`](crate::client::fluent_builders::CreateStudio::set_auth_mode): <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_vpc_id): <p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateStudio::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateStudio::set_subnet_ids): <p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace in any of the specified subnets.</p>
    ///   - [`service_role(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::service_role) / [`set_service_role(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_service_role): <p>The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>
    ///   - [`user_role(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::user_role) / [`set_user_role(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_user_role): <p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to the <code>UserRole</code> can be scoped down for each user or group using session policies.</p>
    ///   - [`workspace_security_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::workspace_security_group_id) / [`set_workspace_security_group_id(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_workspace_security_group_id): <p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>
    ///   - [`engine_security_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::engine_security_group_id) / [`set_engine_security_group_id(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_engine_security_group_id): <p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>
    ///   - [`default_s3_location(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::default_s3_location) / [`set_default_s3_location(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_default_s3_location): <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>
    ///   - [`idp_auth_url(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::idp_auth_url) / [`set_idp_auth_url(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_idp_auth_url): <p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>
    ///   - [`idp_relay_state_parameter_name(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::idp_relay_state_parameter_name) / [`set_idp_relay_state_parameter_name(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_idp_relay_state_parameter_name): <p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateStudio::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateStudio::set_tags): <p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>
    /// - On success, responds with [`CreateStudioOutput`](crate::output::CreateStudioOutput) with field(s):
    ///   - [`studio_id(Option<String>)`](crate::output::CreateStudioOutput::studio_id): <p>The ID of the Amazon EMR Studio.</p>
    ///   - [`url(Option<String>)`](crate::output::CreateStudioOutput::url): <p>The unique Studio access URL.</p>
    /// - On failure, responds with [`SdkError<CreateStudioError>`](crate::error::CreateStudioError)
    pub fn create_studio(&self) -> fluent_builders::CreateStudio {
        fluent_builders::CreateStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStudioSessionMapping`](crate::client::fluent_builders::CreateStudioSessionMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::set_studio_id): <p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::set_identity_id): <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
    ///   - [`identity_name(impl Into<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::identity_name) / [`set_identity_name(Option<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::set_identity_name): <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::CreateStudioSessionMapping::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::CreateStudioSessionMapping::set_identity_type): <p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>
    ///   - [`session_policy_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::session_policy_arn) / [`set_session_policy_arn(Option<String>)`](crate::client::fluent_builders::CreateStudioSessionMapping::set_session_policy_arn): <p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>
    /// - On success, responds with [`CreateStudioSessionMappingOutput`](crate::output::CreateStudioSessionMappingOutput)

    /// - On failure, responds with [`SdkError<CreateStudioSessionMappingError>`](crate::error::CreateStudioSessionMappingError)
    pub fn create_studio_session_mapping(&self) -> fluent_builders::CreateStudioSessionMapping {
        fluent_builders::CreateStudioSessionMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSecurityConfiguration`](crate::client::fluent_builders::DeleteSecurityConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteSecurityConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteSecurityConfiguration::set_name): <p>The name of the security configuration.</p>
    /// - On success, responds with [`DeleteSecurityConfigurationOutput`](crate::output::DeleteSecurityConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteSecurityConfigurationError>`](crate::error::DeleteSecurityConfigurationError)
    pub fn delete_security_configuration(&self) -> fluent_builders::DeleteSecurityConfiguration {
        fluent_builders::DeleteSecurityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStudio`](crate::client::fluent_builders::DeleteStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudio::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteStudio::set_studio_id): <p>The ID of the Amazon EMR Studio.</p>
    /// - On success, responds with [`DeleteStudioOutput`](crate::output::DeleteStudioOutput)

    /// - On failure, responds with [`SdkError<DeleteStudioError>`](crate::error::DeleteStudioError)
    pub fn delete_studio(&self) -> fluent_builders::DeleteStudio {
        fluent_builders::DeleteStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStudioSessionMapping`](crate::client::fluent_builders::DeleteStudioSessionMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioSessionMapping::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteStudioSessionMapping::set_studio_id): <p>The ID of the Amazon EMR Studio.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioSessionMapping::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::DeleteStudioSessionMapping::set_identity_id): <p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    ///   - [`identity_name(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioSessionMapping::identity_name) / [`set_identity_name(Option<String>)`](crate::client::fluent_builders::DeleteStudioSessionMapping::set_identity_name): <p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::DeleteStudioSessionMapping::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::DeleteStudioSessionMapping::set_identity_type): <p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>
    /// - On success, responds with [`DeleteStudioSessionMappingOutput`](crate::output::DeleteStudioSessionMappingOutput)

    /// - On failure, responds with [`SdkError<DeleteStudioSessionMappingError>`](crate::error::DeleteStudioSessionMappingError)
    pub fn delete_studio_session_mapping(&self) -> fluent_builders::DeleteStudioSessionMapping {
        fluent_builders::DeleteStudioSessionMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCluster`](crate::client::fluent_builders::DescribeCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::DescribeCluster::set_cluster_id): <p>The identifier of the cluster to describe.</p>
    /// - On success, responds with [`DescribeClusterOutput`](crate::output::DescribeClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DescribeClusterOutput::cluster): <p>This output contains the details for the requested cluster.</p>
    /// - On failure, responds with [`SdkError<DescribeClusterError>`](crate::error::DescribeClusterError)
    pub fn describe_cluster(&self) -> fluent_builders::DescribeCluster {
        fluent_builders::DescribeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobFlows`](crate::client::fluent_builders::DescribeJobFlows) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`created_after(DateTime)`](crate::client::fluent_builders::DescribeJobFlows::created_after) / [`set_created_after(Option<DateTime>)`](crate::client::fluent_builders::DescribeJobFlows::set_created_after): <p>Return only job flows created after this date and time.</p>
    ///   - [`created_before(DateTime)`](crate::client::fluent_builders::DescribeJobFlows::created_before) / [`set_created_before(Option<DateTime>)`](crate::client::fluent_builders::DescribeJobFlows::set_created_before): <p>Return only job flows created before this date and time.</p>
    ///   - [`job_flow_ids(Vec<String>)`](crate::client::fluent_builders::DescribeJobFlows::job_flow_ids) / [`set_job_flow_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeJobFlows::set_job_flow_ids): <p>Return only job flows whose job flow ID is contained in this list.</p>
    ///   - [`job_flow_states(Vec<JobFlowExecutionState>)`](crate::client::fluent_builders::DescribeJobFlows::job_flow_states) / [`set_job_flow_states(Option<Vec<JobFlowExecutionState>>)`](crate::client::fluent_builders::DescribeJobFlows::set_job_flow_states): <p>Return only job flows whose state is contained in this list.</p>
    /// - On success, responds with [`DescribeJobFlowsOutput`](crate::output::DescribeJobFlowsOutput) with field(s):
    ///   - [`job_flows(Option<Vec<JobFlowDetail>>)`](crate::output::DescribeJobFlowsOutput::job_flows): <p>A list of job flows matching the parameters supplied.</p>
    /// - On failure, responds with [`SdkError<DescribeJobFlowsError>`](crate::error::DescribeJobFlowsError)
    pub fn describe_job_flows(&self) -> fluent_builders::DescribeJobFlows {
        fluent_builders::DescribeJobFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNotebookExecution`](crate::client::fluent_builders::DescribeNotebookExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`notebook_execution_id(impl Into<String>)`](crate::client::fluent_builders::DescribeNotebookExecution::notebook_execution_id) / [`set_notebook_execution_id(Option<String>)`](crate::client::fluent_builders::DescribeNotebookExecution::set_notebook_execution_id): <p>The unique identifier of the notebook execution.</p>
    /// - On success, responds with [`DescribeNotebookExecutionOutput`](crate::output::DescribeNotebookExecutionOutput) with field(s):
    ///   - [`notebook_execution(Option<NotebookExecution>)`](crate::output::DescribeNotebookExecutionOutput::notebook_execution): <p>Properties of the notebook execution.</p>
    /// - On failure, responds with [`SdkError<DescribeNotebookExecutionError>`](crate::error::DescribeNotebookExecutionError)
    pub fn describe_notebook_execution(&self) -> fluent_builders::DescribeNotebookExecution {
        fluent_builders::DescribeNotebookExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReleaseLabel`](crate::client::fluent_builders::DescribeReleaseLabel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`release_label(impl Into<String>)`](crate::client::fluent_builders::DescribeReleaseLabel::release_label) / [`set_release_label(Option<String>)`](crate::client::fluent_builders::DescribeReleaseLabel::set_release_label): <p>The target release label to be described.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReleaseLabel::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReleaseLabel::set_next_token): <p>The pagination token. Reserved for future use. Currently set to null.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReleaseLabel::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeReleaseLabel::set_max_results): <p>Reserved for future use. Currently set to null.</p>
    /// - On success, responds with [`DescribeReleaseLabelOutput`](crate::output::DescribeReleaseLabelOutput) with field(s):
    ///   - [`release_label(Option<String>)`](crate::output::DescribeReleaseLabelOutput::release_label): <p>The target release label described in the response.</p>
    ///   - [`applications(Option<Vec<SimplifiedApplication>>)`](crate::output::DescribeReleaseLabelOutput::applications): <p>The list of applications available for the target release label. <code>Name</code> is the name of the application. <code>Version</code> is the concise version of the application.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReleaseLabelOutput::next_token): <p>The pagination token. Reserved for future use. Currently set to null.</p>
    /// - On failure, responds with [`SdkError<DescribeReleaseLabelError>`](crate::error::DescribeReleaseLabelError)
    pub fn describe_release_label(&self) -> fluent_builders::DescribeReleaseLabel {
        fluent_builders::DescribeReleaseLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecurityConfiguration`](crate::client::fluent_builders::DescribeSecurityConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeSecurityConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeSecurityConfiguration::set_name): <p>The name of the security configuration.</p>
    /// - On success, responds with [`DescribeSecurityConfigurationOutput`](crate::output::DescribeSecurityConfigurationOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeSecurityConfigurationOutput::name): <p>The name of the security configuration.</p>
    ///   - [`security_configuration(Option<String>)`](crate::output::DescribeSecurityConfigurationOutput::security_configuration): <p>The security configuration details in JSON format.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeSecurityConfigurationOutput::creation_date_time): <p>The date and time the security configuration was created</p>
    /// - On failure, responds with [`SdkError<DescribeSecurityConfigurationError>`](crate::error::DescribeSecurityConfigurationError)
    pub fn describe_security_configuration(
        &self,
    ) -> fluent_builders::DescribeSecurityConfiguration {
        fluent_builders::DescribeSecurityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStep`](crate::client::fluent_builders::DescribeStep) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeStep::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::DescribeStep::set_cluster_id): <p>The identifier of the cluster with steps to describe.</p>
    ///   - [`step_id(impl Into<String>)`](crate::client::fluent_builders::DescribeStep::step_id) / [`set_step_id(Option<String>)`](crate::client::fluent_builders::DescribeStep::set_step_id): <p>The identifier of the step to describe.</p>
    /// - On success, responds with [`DescribeStepOutput`](crate::output::DescribeStepOutput) with field(s):
    ///   - [`step(Option<Step>)`](crate::output::DescribeStepOutput::step): <p>The step details for the requested step identifier.</p>
    /// - On failure, responds with [`SdkError<DescribeStepError>`](crate::error::DescribeStepError)
    pub fn describe_step(&self) -> fluent_builders::DescribeStep {
        fluent_builders::DescribeStep::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStudio`](crate::client::fluent_builders::DescribeStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DescribeStudio::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DescribeStudio::set_studio_id): <p>The Amazon EMR Studio ID.</p>
    /// - On success, responds with [`DescribeStudioOutput`](crate::output::DescribeStudioOutput) with field(s):
    ///   - [`studio(Option<Studio>)`](crate::output::DescribeStudioOutput::studio): <p>The Amazon EMR Studio details.</p>
    /// - On failure, responds with [`SdkError<DescribeStudioError>`](crate::error::DescribeStudioError)
    pub fn describe_studio(&self) -> fluent_builders::DescribeStudio {
        fluent_builders::DescribeStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAutoTerminationPolicy`](crate::client::fluent_builders::GetAutoTerminationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::GetAutoTerminationPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::GetAutoTerminationPolicy::set_cluster_id): <p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>
    /// - On success, responds with [`GetAutoTerminationPolicyOutput`](crate::output::GetAutoTerminationPolicyOutput) with field(s):
    ///   - [`auto_termination_policy(Option<AutoTerminationPolicy>)`](crate::output::GetAutoTerminationPolicyOutput::auto_termination_policy): <p>Specifies the auto-termination policy that is attached to an Amazon EMR cluster. </p>
    /// - On failure, responds with [`SdkError<GetAutoTerminationPolicyError>`](crate::error::GetAutoTerminationPolicyError)
    pub fn get_auto_termination_policy(&self) -> fluent_builders::GetAutoTerminationPolicy {
        fluent_builders::GetAutoTerminationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBlockPublicAccessConfiguration`](crate::client::fluent_builders::GetBlockPublicAccessConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetBlockPublicAccessConfiguration::send) it.

    /// - On success, responds with [`GetBlockPublicAccessConfigurationOutput`](crate::output::GetBlockPublicAccessConfigurationOutput) with field(s):
    ///   - [`block_public_access_configuration(Option<BlockPublicAccessConfiguration>)`](crate::output::GetBlockPublicAccessConfigurationOutput::block_public_access_configuration): <p>A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating the block public access configuration to remove the exception.</p> <note>   <p>For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an EMR cluster in a Region before this date, block public access is enabled by default in that Region.</p>  </note>
    ///   - [`block_public_access_configuration_metadata(Option<BlockPublicAccessConfigurationMetadata>)`](crate::output::GetBlockPublicAccessConfigurationOutput::block_public_access_configuration_metadata): <p>Properties that describe the Amazon Web Services principal that created the <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code> action as well as the date and time that the configuration was created. Each time a configuration for block public access is updated, Amazon EMR updates this metadata.</p>
    /// - On failure, responds with [`SdkError<GetBlockPublicAccessConfigurationError>`](crate::error::GetBlockPublicAccessConfigurationError)
    pub fn get_block_public_access_configuration(
        &self,
    ) -> fluent_builders::GetBlockPublicAccessConfiguration {
        fluent_builders::GetBlockPublicAccessConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetManagedScalingPolicy`](crate::client::fluent_builders::GetManagedScalingPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::GetManagedScalingPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::GetManagedScalingPolicy::set_cluster_id): <p>Specifies the ID of the cluster for which the managed scaling policy will be fetched. </p>
    /// - On success, responds with [`GetManagedScalingPolicyOutput`](crate::output::GetManagedScalingPolicyOutput) with field(s):
    ///   - [`managed_scaling_policy(Option<ManagedScalingPolicy>)`](crate::output::GetManagedScalingPolicyOutput::managed_scaling_policy): <p>Specifies the managed scaling policy that is attached to an Amazon EMR cluster. </p>
    /// - On failure, responds with [`SdkError<GetManagedScalingPolicyError>`](crate::error::GetManagedScalingPolicyError)
    pub fn get_managed_scaling_policy(&self) -> fluent_builders::GetManagedScalingPolicy {
        fluent_builders::GetManagedScalingPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStudioSessionMapping`](crate::client::fluent_builders::GetStudioSessionMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetStudioSessionMapping::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetStudioSessionMapping::set_studio_id): <p>The ID of the Amazon EMR Studio.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::GetStudioSessionMapping::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::GetStudioSessionMapping::set_identity_id): <p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    ///   - [`identity_name(impl Into<String>)`](crate::client::fluent_builders::GetStudioSessionMapping::identity_name) / [`set_identity_name(Option<String>)`](crate::client::fluent_builders::GetStudioSessionMapping::set_identity_name): <p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::GetStudioSessionMapping::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::GetStudioSessionMapping::set_identity_type): <p>Specifies whether the identity to fetch is a user or a group.</p>
    /// - On success, responds with [`GetStudioSessionMappingOutput`](crate::output::GetStudioSessionMappingOutput) with field(s):
    ///   - [`session_mapping(Option<SessionMappingDetail>)`](crate::output::GetStudioSessionMappingOutput::session_mapping): <p>The session mapping details for the specified Amazon EMR Studio and identity, including session policy ARN and creation time.</p>
    /// - On failure, responds with [`SdkError<GetStudioSessionMappingError>`](crate::error::GetStudioSessionMappingError)
    pub fn get_studio_session_mapping(&self) -> fluent_builders::GetStudioSessionMapping {
        fluent_builders::GetStudioSessionMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBootstrapActions`](crate::client::fluent_builders::ListBootstrapActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBootstrapActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListBootstrapActions::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ListBootstrapActions::set_cluster_id): <p>The cluster identifier for the bootstrap actions to list.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListBootstrapActions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListBootstrapActions::set_marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListBootstrapActionsOutput`](crate::output::ListBootstrapActionsOutput) with field(s):
    ///   - [`bootstrap_actions(Option<Vec<Command>>)`](crate::output::ListBootstrapActionsOutput::bootstrap_actions): <p>The bootstrap actions associated with the cluster.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListBootstrapActionsOutput::marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListBootstrapActionsError>`](crate::error::ListBootstrapActionsError)
    pub fn list_bootstrap_actions(&self) -> fluent_builders::ListBootstrapActions {
        fluent_builders::ListBootstrapActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClusters`](crate::client::fluent_builders::ListClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`created_after(DateTime)`](crate::client::fluent_builders::ListClusters::created_after) / [`set_created_after(Option<DateTime>)`](crate::client::fluent_builders::ListClusters::set_created_after): <p>The creation date and time beginning value filter for listing clusters.</p>
    ///   - [`created_before(DateTime)`](crate::client::fluent_builders::ListClusters::created_before) / [`set_created_before(Option<DateTime>)`](crate::client::fluent_builders::ListClusters::set_created_before): <p>The creation date and time end value filter for listing clusters.</p>
    ///   - [`cluster_states(Vec<ClusterState>)`](crate::client::fluent_builders::ListClusters::cluster_states) / [`set_cluster_states(Option<Vec<ClusterState>>)`](crate::client::fluent_builders::ListClusters::set_cluster_states): <p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListClusters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListClusters::set_marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListClustersOutput`](crate::output::ListClustersOutput) with field(s):
    ///   - [`clusters(Option<Vec<ClusterSummary>>)`](crate::output::ListClustersOutput::clusters): <p>The list of clusters for the account based on the given filters.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListClustersOutput::marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListClustersError>`](crate::error::ListClustersError)
    pub fn list_clusters(&self) -> fluent_builders::ListClusters {
        fluent_builders::ListClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstanceFleets`](crate::client::fluent_builders::ListInstanceFleets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstanceFleets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListInstanceFleets::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ListInstanceFleets::set_cluster_id): <p>The unique identifier of the cluster.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListInstanceFleets::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListInstanceFleets::set_marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListInstanceFleetsOutput`](crate::output::ListInstanceFleetsOutput) with field(s):
    ///   - [`instance_fleets(Option<Vec<InstanceFleet>>)`](crate::output::ListInstanceFleetsOutput::instance_fleets): <p>The list of instance fleets for the cluster and given filters.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListInstanceFleetsOutput::marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListInstanceFleetsError>`](crate::error::ListInstanceFleetsError)
    pub fn list_instance_fleets(&self) -> fluent_builders::ListInstanceFleets {
        fluent_builders::ListInstanceFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstanceGroups`](crate::client::fluent_builders::ListInstanceGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstanceGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListInstanceGroups::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ListInstanceGroups::set_cluster_id): <p>The identifier of the cluster for which to list the instance groups.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListInstanceGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListInstanceGroups::set_marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListInstanceGroupsOutput`](crate::output::ListInstanceGroupsOutput) with field(s):
    ///   - [`instance_groups(Option<Vec<InstanceGroup>>)`](crate::output::ListInstanceGroupsOutput::instance_groups): <p>The list of instance groups for the cluster and given filters.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListInstanceGroupsOutput::marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListInstanceGroupsError>`](crate::error::ListInstanceGroupsError)
    pub fn list_instance_groups(&self) -> fluent_builders::ListInstanceGroups {
        fluent_builders::ListInstanceGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstances`](crate::client::fluent_builders::ListInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListInstances::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ListInstances::set_cluster_id): <p>The identifier of the cluster for which to list the instances.</p>
    ///   - [`instance_group_id(impl Into<String>)`](crate::client::fluent_builders::ListInstances::instance_group_id) / [`set_instance_group_id(Option<String>)`](crate::client::fluent_builders::ListInstances::set_instance_group_id): <p>The identifier of the instance group for which to list the instances.</p>
    ///   - [`instance_group_types(Vec<InstanceGroupType>)`](crate::client::fluent_builders::ListInstances::instance_group_types) / [`set_instance_group_types(Option<Vec<InstanceGroupType>>)`](crate::client::fluent_builders::ListInstances::set_instance_group_types): <p>The type of instance group for which to list the instances.</p>
    ///   - [`instance_fleet_id(impl Into<String>)`](crate::client::fluent_builders::ListInstances::instance_fleet_id) / [`set_instance_fleet_id(Option<String>)`](crate::client::fluent_builders::ListInstances::set_instance_fleet_id): <p>The unique identifier of the instance fleet.</p>
    ///   - [`instance_fleet_type(InstanceFleetType)`](crate::client::fluent_builders::ListInstances::instance_fleet_type) / [`set_instance_fleet_type(Option<InstanceFleetType>)`](crate::client::fluent_builders::ListInstances::set_instance_fleet_type): <p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>
    ///   - [`instance_states(Vec<InstanceState>)`](crate::client::fluent_builders::ListInstances::instance_states) / [`set_instance_states(Option<Vec<InstanceState>>)`](crate::client::fluent_builders::ListInstances::set_instance_states): <p>A list of instance states that will filter the instances returned with this request.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListInstances::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListInstances::set_marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListInstancesOutput`](crate::output::ListInstancesOutput) with field(s):
    ///   - [`instances(Option<Vec<Instance>>)`](crate::output::ListInstancesOutput::instances): <p>The list of instances for the cluster and given filters.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListInstancesOutput::marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListInstancesError>`](crate::error::ListInstancesError)
    pub fn list_instances(&self) -> fluent_builders::ListInstances {
        fluent_builders::ListInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNotebookExecutions`](crate::client::fluent_builders::ListNotebookExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNotebookExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`editor_id(impl Into<String>)`](crate::client::fluent_builders::ListNotebookExecutions::editor_id) / [`set_editor_id(Option<String>)`](crate::client::fluent_builders::ListNotebookExecutions::set_editor_id): <p>The unique ID of the editor associated with the notebook execution.</p>
    ///   - [`status(NotebookExecutionStatus)`](crate::client::fluent_builders::ListNotebookExecutions::status) / [`set_status(Option<NotebookExecutionStatus>)`](crate::client::fluent_builders::ListNotebookExecutions::set_status): <p>The status filter for listing notebook executions.</p>  <ul>   <li> <p> <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not begun.</p> </li>   <li> <p> <code>STARTING</code> indicates that the execution is starting on the cluster.</p> </li>   <li> <p> <code>RUNNING</code> indicates that the execution is being processed by the cluster.</p> </li>   <li> <p> <code>FINISHING</code> indicates that execution processing is in the final stages.</p> </li>   <li> <p> <code>FINISHED</code> indicates that the execution has completed without error.</p> </li>   <li> <p> <code>FAILING</code> indicates that the execution is failing and will not finish successfully.</p> </li>   <li> <p> <code>FAILED</code> indicates that the execution failed.</p> </li>   <li> <p> <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request and the stop is pending.</p> </li>   <li> <p> <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a <code>StopNotebookExecution</code> request.</p> </li>   <li> <p> <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code> request.</p> </li>  </ul>
    ///   - [`from(DateTime)`](crate::client::fluent_builders::ListNotebookExecutions::from) / [`set_from(Option<DateTime>)`](crate::client::fluent_builders::ListNotebookExecutions::set_from): <p>The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago.</p>
    ///   - [`to(DateTime)`](crate::client::fluent_builders::ListNotebookExecutions::to) / [`set_to(Option<DateTime>)`](crate::client::fluent_builders::ListNotebookExecutions::set_to): <p>The end of time range filter for listing notebook executions. The default is the current timestamp.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListNotebookExecutions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListNotebookExecutions::set_marker): <p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates the start of the list for this <code>ListNotebookExecutions</code> call.</p>
    /// - On success, responds with [`ListNotebookExecutionsOutput`](crate::output::ListNotebookExecutionsOutput) with field(s):
    ///   - [`notebook_executions(Option<Vec<NotebookExecutionSummary>>)`](crate::output::ListNotebookExecutionsOutput::notebook_executions): <p>A list of notebook executions.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListNotebookExecutionsOutput::marker): <p>A pagination token that a subsequent <code>ListNotebookExecutions</code> can use to determine the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListNotebookExecutionsError>`](crate::error::ListNotebookExecutionsError)
    pub fn list_notebook_executions(&self) -> fluent_builders::ListNotebookExecutions {
        fluent_builders::ListNotebookExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReleaseLabels`](crate::client::fluent_builders::ListReleaseLabels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReleaseLabels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(ReleaseLabelFilter)`](crate::client::fluent_builders::ListReleaseLabels::filters) / [`set_filters(Option<ReleaseLabelFilter>)`](crate::client::fluent_builders::ListReleaseLabels::set_filters): <p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReleaseLabels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReleaseLabels::set_next_token): <p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReleaseLabels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReleaseLabels::set_max_results): <p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>
    /// - On success, responds with [`ListReleaseLabelsOutput`](crate::output::ListReleaseLabelsOutput) with field(s):
    ///   - [`release_labels(Option<Vec<String>>)`](crate::output::ListReleaseLabelsOutput::release_labels): <p>The returned release labels.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListReleaseLabelsOutput::next_token): <p>Used to paginate the next page of results if specified in the next <code>ListReleaseLabels</code> request.</p>
    /// - On failure, responds with [`SdkError<ListReleaseLabelsError>`](crate::error::ListReleaseLabelsError)
    pub fn list_release_labels(&self) -> fluent_builders::ListReleaseLabels {
        fluent_builders::ListReleaseLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecurityConfigurations`](crate::client::fluent_builders::ListSecurityConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecurityConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListSecurityConfigurations::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListSecurityConfigurations::set_marker): <p>The pagination token that indicates the set of results to retrieve.</p>
    /// - On success, responds with [`ListSecurityConfigurationsOutput`](crate::output::ListSecurityConfigurationsOutput) with field(s):
    ///   - [`security_configurations(Option<Vec<SecurityConfigurationSummary>>)`](crate::output::ListSecurityConfigurationsOutput::security_configurations): <p>The creation date and time, and name, of each security configuration.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListSecurityConfigurationsOutput::marker): <p>A pagination token that indicates the next set of results to retrieve. Include the marker in the next ListSecurityConfiguration call to retrieve the next page of results, if required.</p>
    /// - On failure, responds with [`SdkError<ListSecurityConfigurationsError>`](crate::error::ListSecurityConfigurationsError)
    pub fn list_security_configurations(&self) -> fluent_builders::ListSecurityConfigurations {
        fluent_builders::ListSecurityConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSteps`](crate::client::fluent_builders::ListSteps) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSteps::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListSteps::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ListSteps::set_cluster_id): <p>The identifier of the cluster for which to list the steps.</p>
    ///   - [`step_states(Vec<StepState>)`](crate::client::fluent_builders::ListSteps::step_states) / [`set_step_states(Option<Vec<StepState>>)`](crate::client::fluent_builders::ListSteps::set_step_states): <p>The filter to limit the step list based on certain states.</p>
    ///   - [`step_ids(Vec<String>)`](crate::client::fluent_builders::ListSteps::step_ids) / [`set_step_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListSteps::set_step_ids): <p>The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step IDs. The character constraint applies to the overall length of the array.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListSteps::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListSteps::set_marker): <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListStepsOutput`](crate::output::ListStepsOutput) with field(s):
    ///   - [`steps(Option<Vec<StepSummary>>)`](crate::output::ListStepsOutput::steps): <p>The filtered list of steps for the cluster.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListStepsOutput::marker): <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListStepsError>`](crate::error::ListStepsError)
    pub fn list_steps(&self) -> fluent_builders::ListSteps {
        fluent_builders::ListSteps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStudios`](crate::client::fluent_builders::ListStudios) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStudios::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListStudios::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListStudios::set_marker): <p>The pagination token that indicates the set of results to retrieve.</p>
    /// - On success, responds with [`ListStudiosOutput`](crate::output::ListStudiosOutput) with field(s):
    ///   - [`studios(Option<Vec<StudioSummary>>)`](crate::output::ListStudiosOutput::studios): <p>The list of Studio summary objects.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListStudiosOutput::marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListStudiosError>`](crate::error::ListStudiosError)
    pub fn list_studios(&self) -> fluent_builders::ListStudios {
        fluent_builders::ListStudios::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStudioSessionMappings`](crate::client::fluent_builders::ListStudioSessionMappings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStudioSessionMappings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListStudioSessionMappings::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListStudioSessionMappings::set_studio_id): <p>The ID of the Amazon EMR Studio.</p>
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::ListStudioSessionMappings::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::ListStudioSessionMappings::set_identity_type): <p>Specifies whether to return session mappings for users or groups. If not specified, the results include session mapping details for both users and groups.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListStudioSessionMappings::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListStudioSessionMappings::set_marker): <p>The pagination token that indicates the set of results to retrieve.</p>
    /// - On success, responds with [`ListStudioSessionMappingsOutput`](crate::output::ListStudioSessionMappingsOutput) with field(s):
    ///   - [`session_mappings(Option<Vec<SessionMappingSummary>>)`](crate::output::ListStudioSessionMappingsOutput::session_mappings): <p>A list of session mapping summary objects. Each object includes session mapping details such as creation time, identity type (user or group), and Amazon EMR Studio ID.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListStudioSessionMappingsOutput::marker): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListStudioSessionMappingsError>`](crate::error::ListStudioSessionMappingsError)
    pub fn list_studio_session_mappings(&self) -> fluent_builders::ListStudioSessionMappings {
        fluent_builders::ListStudioSessionMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCluster`](crate::client::fluent_builders::ModifyCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_cluster_id): <p>The unique identifier of the cluster.</p>
    ///   - [`step_concurrency_level(i32)`](crate::client::fluent_builders::ModifyCluster::step_concurrency_level) / [`set_step_concurrency_level(Option<i32>)`](crate::client::fluent_builders::ModifyCluster::set_step_concurrency_level): <p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <code>Step$ActionOnFailure</code>.</p>
    /// - On success, responds with [`ModifyClusterOutput`](crate::output::ModifyClusterOutput) with field(s):
    ///   - [`step_concurrency_level(Option<i32>)`](crate::output::ModifyClusterOutput::step_concurrency_level): <p>The number of steps that can be executed concurrently.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterError>`](crate::error::ModifyClusterError)
    pub fn modify_cluster(&self) -> fluent_builders::ModifyCluster {
        fluent_builders::ModifyCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyInstanceFleet`](crate::client::fluent_builders::ModifyInstanceFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ModifyInstanceFleet::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ModifyInstanceFleet::set_cluster_id): <p>The unique identifier of the cluster.</p>
    ///   - [`instance_fleet(InstanceFleetModifyConfig)`](crate::client::fluent_builders::ModifyInstanceFleet::instance_fleet) / [`set_instance_fleet(Option<InstanceFleetModifyConfig>)`](crate::client::fluent_builders::ModifyInstanceFleet::set_instance_fleet): <p>The configuration parameters of the instance fleet.</p>
    /// - On success, responds with [`ModifyInstanceFleetOutput`](crate::output::ModifyInstanceFleetOutput)

    /// - On failure, responds with [`SdkError<ModifyInstanceFleetError>`](crate::error::ModifyInstanceFleetError)
    pub fn modify_instance_fleet(&self) -> fluent_builders::ModifyInstanceFleet {
        fluent_builders::ModifyInstanceFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyInstanceGroups`](crate::client::fluent_builders::ModifyInstanceGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ModifyInstanceGroups::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ModifyInstanceGroups::set_cluster_id): <p>The ID of the cluster to which the instance group belongs.</p>
    ///   - [`instance_groups(Vec<InstanceGroupModifyConfig>)`](crate::client::fluent_builders::ModifyInstanceGroups::instance_groups) / [`set_instance_groups(Option<Vec<InstanceGroupModifyConfig>>)`](crate::client::fluent_builders::ModifyInstanceGroups::set_instance_groups): <p>Instance groups to change.</p>
    /// - On success, responds with [`ModifyInstanceGroupsOutput`](crate::output::ModifyInstanceGroupsOutput)

    /// - On failure, responds with [`SdkError<ModifyInstanceGroupsError>`](crate::error::ModifyInstanceGroupsError)
    pub fn modify_instance_groups(&self) -> fluent_builders::ModifyInstanceGroups {
        fluent_builders::ModifyInstanceGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAutoScalingPolicy`](crate::client::fluent_builders::PutAutoScalingPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::PutAutoScalingPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::PutAutoScalingPolicy::set_cluster_id): <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>
    ///   - [`instance_group_id(impl Into<String>)`](crate::client::fluent_builders::PutAutoScalingPolicy::instance_group_id) / [`set_instance_group_id(Option<String>)`](crate::client::fluent_builders::PutAutoScalingPolicy::set_instance_group_id): <p>Specifies the ID of the instance group to which the automatic scaling policy is applied.</p>
    ///   - [`auto_scaling_policy(AutoScalingPolicy)`](crate::client::fluent_builders::PutAutoScalingPolicy::auto_scaling_policy) / [`set_auto_scaling_policy(Option<AutoScalingPolicy>)`](crate::client::fluent_builders::PutAutoScalingPolicy::set_auto_scaling_policy): <p>Specifies the definition of the automatic scaling policy.</p>
    /// - On success, responds with [`PutAutoScalingPolicyOutput`](crate::output::PutAutoScalingPolicyOutput) with field(s):
    ///   - [`cluster_id(Option<String>)`](crate::output::PutAutoScalingPolicyOutput::cluster_id): <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>
    ///   - [`instance_group_id(Option<String>)`](crate::output::PutAutoScalingPolicyOutput::instance_group_id): <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
    ///   - [`auto_scaling_policy(Option<AutoScalingPolicyDescription>)`](crate::output::PutAutoScalingPolicyOutput::auto_scaling_policy): <p>The automatic scaling policy definition.</p>
    ///   - [`cluster_arn(Option<String>)`](crate::output::PutAutoScalingPolicyOutput::cluster_arn): <p>The Amazon Resource Name (ARN) of the cluster.</p>
    /// - On failure, responds with [`SdkError<PutAutoScalingPolicyError>`](crate::error::PutAutoScalingPolicyError)
    pub fn put_auto_scaling_policy(&self) -> fluent_builders::PutAutoScalingPolicy {
        fluent_builders::PutAutoScalingPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAutoTerminationPolicy`](crate::client::fluent_builders::PutAutoTerminationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::PutAutoTerminationPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::PutAutoTerminationPolicy::set_cluster_id): <p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>
    ///   - [`auto_termination_policy(AutoTerminationPolicy)`](crate::client::fluent_builders::PutAutoTerminationPolicy::auto_termination_policy) / [`set_auto_termination_policy(Option<AutoTerminationPolicy>)`](crate::client::fluent_builders::PutAutoTerminationPolicy::set_auto_termination_policy): <p>Specifies the auto-termination policy to attach to the cluster.</p>
    /// - On success, responds with [`PutAutoTerminationPolicyOutput`](crate::output::PutAutoTerminationPolicyOutput)

    /// - On failure, responds with [`SdkError<PutAutoTerminationPolicyError>`](crate::error::PutAutoTerminationPolicyError)
    pub fn put_auto_termination_policy(&self) -> fluent_builders::PutAutoTerminationPolicy {
        fluent_builders::PutAutoTerminationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBlockPublicAccessConfiguration`](crate::client::fluent_builders::PutBlockPublicAccessConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`block_public_access_configuration(BlockPublicAccessConfiguration)`](crate::client::fluent_builders::PutBlockPublicAccessConfiguration::block_public_access_configuration) / [`set_block_public_access_configuration(Option<BlockPublicAccessConfiguration>)`](crate::client::fluent_builders::PutBlockPublicAccessConfiguration::set_block_public_access_configuration): <p>A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p> <note>   <p>For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an EMR cluster in a Region before this date, block public access is enabled by default in that Region.</p>  </note>
    /// - On success, responds with [`PutBlockPublicAccessConfigurationOutput`](crate::output::PutBlockPublicAccessConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBlockPublicAccessConfigurationError>`](crate::error::PutBlockPublicAccessConfigurationError)
    pub fn put_block_public_access_configuration(
        &self,
    ) -> fluent_builders::PutBlockPublicAccessConfiguration {
        fluent_builders::PutBlockPublicAccessConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutManagedScalingPolicy`](crate::client::fluent_builders::PutManagedScalingPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::PutManagedScalingPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::PutManagedScalingPolicy::set_cluster_id): <p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>
    ///   - [`managed_scaling_policy(ManagedScalingPolicy)`](crate::client::fluent_builders::PutManagedScalingPolicy::managed_scaling_policy) / [`set_managed_scaling_policy(Option<ManagedScalingPolicy>)`](crate::client::fluent_builders::PutManagedScalingPolicy::set_managed_scaling_policy): <p>Specifies the constraints for the managed scaling policy. </p>
    /// - On success, responds with [`PutManagedScalingPolicyOutput`](crate::output::PutManagedScalingPolicyOutput)

    /// - On failure, responds with [`SdkError<PutManagedScalingPolicyError>`](crate::error::PutManagedScalingPolicyError)
    pub fn put_managed_scaling_policy(&self) -> fluent_builders::PutManagedScalingPolicy {
        fluent_builders::PutManagedScalingPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveAutoScalingPolicy`](crate::client::fluent_builders::RemoveAutoScalingPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::RemoveAutoScalingPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::RemoveAutoScalingPolicy::set_cluster_id): <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>
    ///   - [`instance_group_id(impl Into<String>)`](crate::client::fluent_builders::RemoveAutoScalingPolicy::instance_group_id) / [`set_instance_group_id(Option<String>)`](crate::client::fluent_builders::RemoveAutoScalingPolicy::set_instance_group_id): <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
    /// - On success, responds with [`RemoveAutoScalingPolicyOutput`](crate::output::RemoveAutoScalingPolicyOutput)

    /// - On failure, responds with [`SdkError<RemoveAutoScalingPolicyError>`](crate::error::RemoveAutoScalingPolicyError)
    pub fn remove_auto_scaling_policy(&self) -> fluent_builders::RemoveAutoScalingPolicy {
        fluent_builders::RemoveAutoScalingPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveAutoTerminationPolicy`](crate::client::fluent_builders::RemoveAutoTerminationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::RemoveAutoTerminationPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::RemoveAutoTerminationPolicy::set_cluster_id): <p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>
    /// - On success, responds with [`RemoveAutoTerminationPolicyOutput`](crate::output::RemoveAutoTerminationPolicyOutput)

    /// - On failure, responds with [`SdkError<RemoveAutoTerminationPolicyError>`](crate::error::RemoveAutoTerminationPolicyError)
    pub fn remove_auto_termination_policy(&self) -> fluent_builders::RemoveAutoTerminationPolicy {
        fluent_builders::RemoveAutoTerminationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveManagedScalingPolicy`](crate::client::fluent_builders::RemoveManagedScalingPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::RemoveManagedScalingPolicy::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::RemoveManagedScalingPolicy::set_cluster_id): <p> Specifies the ID of the cluster from which the managed scaling policy will be removed. </p>
    /// - On success, responds with [`RemoveManagedScalingPolicyOutput`](crate::output::RemoveManagedScalingPolicyOutput)

    /// - On failure, responds with [`SdkError<RemoveManagedScalingPolicyError>`](crate::error::RemoveManagedScalingPolicyError)
    pub fn remove_managed_scaling_policy(&self) -> fluent_builders::RemoveManagedScalingPolicy {
        fluent_builders::RemoveManagedScalingPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTags`](crate::client::fluent_builders::RemoveTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::RemoveTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::RemoveTags::set_resource_id): <p>The Amazon EMR resource identifier from which tags will be removed. For example, a cluster identifier or an Amazon EMR Studio ID.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTags::set_tag_keys): <p>A list of tag keys to remove from the resource.</p>
    /// - On success, responds with [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsError>`](crate::error::RemoveTagsError)
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RunJobFlow`](crate::client::fluent_builders::RunJobFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_name): <p>The name of the job flow.</p>
    ///   - [`log_uri(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::log_uri) / [`set_log_uri(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_log_uri): <p>The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not created.</p>
    ///   - [`log_encryption_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::log_encryption_kms_key_id) / [`set_log_encryption_kms_key_id(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_log_encryption_kms_key_id): <p>The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256. This attribute is only available with Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>
    ///   - [`additional_info(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::additional_info) / [`set_additional_info(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_additional_info): <p>A JSON string for selecting additional features.</p>
    ///   - [`ami_version(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::ami_version) / [`set_ami_version(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_ami_version): <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.</p>
    ///   - [`release_label(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::release_label) / [`set_release_label(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_release_label): <p>The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.</p>
    ///   - [`instances(JobFlowInstancesConfig)`](crate::client::fluent_builders::RunJobFlow::instances) / [`set_instances(Option<JobFlowInstancesConfig>)`](crate::client::fluent_builders::RunJobFlow::set_instances): <p>A specification of the number and type of Amazon EC2 instances.</p>
    ///   - [`steps(Vec<StepConfig>)`](crate::client::fluent_builders::RunJobFlow::steps) / [`set_steps(Option<Vec<StepConfig>>)`](crate::client::fluent_builders::RunJobFlow::set_steps): <p>A list of steps to run.</p>
    ///   - [`bootstrap_actions(Vec<BootstrapActionConfig>)`](crate::client::fluent_builders::RunJobFlow::bootstrap_actions) / [`set_bootstrap_actions(Option<Vec<BootstrapActionConfig>>)`](crate::client::fluent_builders::RunJobFlow::set_bootstrap_actions): <p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>
    ///   - [`supported_products(Vec<String>)`](crate::client::fluent_builders::RunJobFlow::supported_products) / [`set_supported_products(Option<Vec<String>>)`](crate::client::fluent_builders::RunJobFlow::set_supported_products): <note>   <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p>  </note>  <p>A list of strings that indicates third-party software to use. For more information, see the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Currently supported values are:</p>  <ul>   <li> <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p> </li>   <li> <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p> </li>  </ul>
    ///   - [`new_supported_products(Vec<SupportedProductConfig>)`](crate::client::fluent_builders::RunJobFlow::new_supported_products) / [`set_new_supported_products(Option<Vec<SupportedProductConfig>>)`](crate::client::fluent_builders::RunJobFlow::set_new_supported_products): <note>   <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p>  </note>  <p>A list of strings that indicates third-party software to use with the job flow that accepts a user argument list. EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported values are:</p>  <ul>   <li> <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p> </li>   <li> <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p> </li>   <li> <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5 Edition respectively.</p> </li>   <li> <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p> </li>   <li> <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p> </li>   <li> <p>"hue"- launch the cluster with Hue installed.</p> </li>   <li> <p>"spark" - launch the cluster with Apache Spark installed.</p> </li>   <li> <p>"ganglia" - launch the cluster with the Ganglia Monitoring System installed.</p> </li>  </ul>
    ///   - [`applications(Vec<Application>)`](crate::client::fluent_builders::RunJobFlow::applications) / [`set_applications(Option<Vec<Application>>)`](crate::client::fluent_builders::RunJobFlow::set_applications): <p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease Guide</a>.</p>
    ///   - [`configurations(Vec<Configuration>)`](crate::client::fluent_builders::RunJobFlow::configurations) / [`set_configurations(Option<Vec<Configuration>>)`](crate::client::fluent_builders::RunJobFlow::set_configurations): <p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR cluster you are creating.</p>
    ///   - [`visible_to_all_users(bool)`](crate::client::fluent_builders::RunJobFlow::visible_to_all_users) / [`set_visible_to_all_users(bool)`](crate::client::fluent_builders::RunJobFlow::set_visible_to_all_users): <important>   <p>The VisibleToAllUsers parameter is no longer supported. By default, the value is set to <code>true</code>. Setting it to <code>false</code> now has no effect.</p>  </important>  <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p>  <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
    ///   - [`job_flow_role(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::job_flow_role) / [`set_job_flow_role(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_job_flow_role): <p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have already created it using the CLI or console.</p>
    ///   - [`service_role(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::service_role) / [`set_service_role(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_service_role): <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RunJobFlow::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RunJobFlow::set_tags): <p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>
    ///   - [`security_configuration(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::security_configuration) / [`set_security_configuration(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_security_configuration): <p>The name of a security configuration to apply to the cluster.</p>
    ///   - [`auto_scaling_role(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::auto_scaling_role) / [`set_auto_scaling_role(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_auto_scaling_role): <p>An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.</p>
    ///   - [`scale_down_behavior(ScaleDownBehavior)`](crate::client::fluent_builders::RunJobFlow::scale_down_behavior) / [`set_scale_down_behavior(Option<ScaleDownBehavior>)`](crate::client::fluent_builders::RunJobFlow::set_scale_down_behavior): <p>Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
    ///   - [`custom_ami_id(impl Into<String>)`](crate::client::fluent_builders::RunJobFlow::custom_ami_id) / [`set_custom_ami_id(Option<String>)`](crate::client::fluent_builders::RunJobFlow::set_custom_ami_id): <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2 instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p>  <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux AMI</a>. </p>
    ///   - [`ebs_root_volume_size(i32)`](crate::client::fluent_builders::RunJobFlow::ebs_root_volume_size) / [`set_ebs_root_volume_size(Option<i32>)`](crate::client::fluent_builders::RunJobFlow::set_ebs_root_volume_size): <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
    ///   - [`repo_upgrade_on_boot(RepoUpgradeOnBoot)`](crate::client::fluent_builders::RunJobFlow::repo_upgrade_on_boot) / [`set_repo_upgrade_on_boot(Option<RepoUpgradeOnBoot>)`](crate::client::fluent_builders::RunJobFlow::set_repo_upgrade_on_boot): <p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package repositories to apply automatically when the instance boots using the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.</p>
    ///   - [`kerberos_attributes(KerberosAttributes)`](crate::client::fluent_builders::RunJobFlow::kerberos_attributes) / [`set_kerberos_attributes(Option<KerberosAttributes>)`](crate::client::fluent_builders::RunJobFlow::set_kerberos_attributes): <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.</p>
    ///   - [`step_concurrency_level(i32)`](crate::client::fluent_builders::RunJobFlow::step_concurrency_level) / [`set_step_concurrency_level(Option<i32>)`](crate::client::fluent_builders::RunJobFlow::set_step_concurrency_level): <p>Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>. The maximum value is <code>256</code>.</p>
    ///   - [`managed_scaling_policy(ManagedScalingPolicy)`](crate::client::fluent_builders::RunJobFlow::managed_scaling_policy) / [`set_managed_scaling_policy(Option<ManagedScalingPolicy>)`](crate::client::fluent_builders::RunJobFlow::set_managed_scaling_policy): <p> The specified managed scaling policy for an Amazon EMR cluster. </p>
    ///   - [`placement_group_configs(Vec<PlacementGroupConfig>)`](crate::client::fluent_builders::RunJobFlow::placement_group_configs) / [`set_placement_group_configs(Option<Vec<PlacementGroupConfig>>)`](crate::client::fluent_builders::RunJobFlow::set_placement_group_configs): <p>The specified placement group configuration for an Amazon EMR cluster.</p>
    ///   - [`auto_termination_policy(AutoTerminationPolicy)`](crate::client::fluent_builders::RunJobFlow::auto_termination_policy) / [`set_auto_termination_policy(Option<AutoTerminationPolicy>)`](crate::client::fluent_builders::RunJobFlow::set_auto_termination_policy): <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
    /// - On success, responds with [`RunJobFlowOutput`](crate::output::RunJobFlowOutput) with field(s):
    ///   - [`job_flow_id(Option<String>)`](crate::output::RunJobFlowOutput::job_flow_id): <p>A unique identifier for the job flow.</p>
    ///   - [`cluster_arn(Option<String>)`](crate::output::RunJobFlowOutput::cluster_arn): <p>The Amazon Resource Name (ARN) of the cluster.</p>
    /// - On failure, responds with [`SdkError<RunJobFlowError>`](crate::error::RunJobFlowError)
    pub fn run_job_flow(&self) -> fluent_builders::RunJobFlow {
        fluent_builders::RunJobFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetTerminationProtection`](crate::client::fluent_builders::SetTerminationProtection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_flow_ids(Vec<String>)`](crate::client::fluent_builders::SetTerminationProtection::job_flow_ids) / [`set_job_flow_ids(Option<Vec<String>>)`](crate::client::fluent_builders::SetTerminationProtection::set_job_flow_ids): <p> A list of strings that uniquely identify the clusters to protect. This identifier is returned by <code>RunJobFlow</code> and can also be obtained from <code>DescribeJobFlows</code> . </p>
    ///   - [`termination_protected(bool)`](crate::client::fluent_builders::SetTerminationProtection::termination_protected) / [`set_termination_protected(bool)`](crate::client::fluent_builders::SetTerminationProtection::set_termination_protected): <p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the cluster from shutting down due to API calls, user intervention, or job-flow error.</p>
    /// - On success, responds with [`SetTerminationProtectionOutput`](crate::output::SetTerminationProtectionOutput)

    /// - On failure, responds with [`SdkError<SetTerminationProtectionError>`](crate::error::SetTerminationProtectionError)
    pub fn set_termination_protection(&self) -> fluent_builders::SetTerminationProtection {
        fluent_builders::SetTerminationProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetVisibleToAllUsers`](crate::client::fluent_builders::SetVisibleToAllUsers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_flow_ids(Vec<String>)`](crate::client::fluent_builders::SetVisibleToAllUsers::job_flow_ids) / [`set_job_flow_ids(Option<Vec<String>>)`](crate::client::fluent_builders::SetVisibleToAllUsers::set_job_flow_ids): <p>The unique identifier of the job flow (cluster).</p>
    ///   - [`visible_to_all_users(bool)`](crate::client::fluent_builders::SetVisibleToAllUsers::visible_to_all_users) / [`set_visible_to_all_users(bool)`](crate::client::fluent_builders::SetVisibleToAllUsers::set_visible_to_all_users): <p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform EMR actions on the cluster that the IAM policies attached to the principal allow. A value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>
    /// - On success, responds with [`SetVisibleToAllUsersOutput`](crate::output::SetVisibleToAllUsersOutput)

    /// - On failure, responds with [`SdkError<SetVisibleToAllUsersError>`](crate::error::SetVisibleToAllUsersError)
    pub fn set_visible_to_all_users(&self) -> fluent_builders::SetVisibleToAllUsers {
        fluent_builders::SetVisibleToAllUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartNotebookExecution`](crate::client::fluent_builders::StartNotebookExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`editor_id(impl Into<String>)`](crate::client::fluent_builders::StartNotebookExecution::editor_id) / [`set_editor_id(Option<String>)`](crate::client::fluent_builders::StartNotebookExecution::set_editor_id): <p>The unique identifier of the EMR Notebook to use for notebook execution.</p>
    ///   - [`relative_path(impl Into<String>)`](crate::client::fluent_builders::StartNotebookExecution::relative_path) / [`set_relative_path(Option<String>)`](crate::client::fluent_builders::StartNotebookExecution::set_relative_path): <p>The path and file name of the notebook file for this execution, relative to the path specified for the EMR Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this request), and you specify a <code>RelativePath</code> of <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the notebook execution is <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>
    ///   - [`notebook_execution_name(impl Into<String>)`](crate::client::fluent_builders::StartNotebookExecution::notebook_execution_name) / [`set_notebook_execution_name(Option<String>)`](crate::client::fluent_builders::StartNotebookExecution::set_notebook_execution_name): <p>An optional name for the notebook execution.</p>
    ///   - [`notebook_params(impl Into<String>)`](crate::client::fluent_builders::StartNotebookExecution::notebook_params) / [`set_notebook_params(Option<String>)`](crate::client::fluent_builders::StartNotebookExecution::set_notebook_params): <p>Input parameters in JSON format passed to the EMR Notebook at runtime for execution.</p>
    ///   - [`execution_engine(ExecutionEngineConfig)`](crate::client::fluent_builders::StartNotebookExecution::execution_engine) / [`set_execution_engine(Option<ExecutionEngineConfig>)`](crate::client::fluent_builders::StartNotebookExecution::set_execution_engine): <p>Specifies the execution engine (cluster) that runs the notebook execution.</p>
    ///   - [`service_role(impl Into<String>)`](crate::client::fluent_builders::StartNotebookExecution::service_role) / [`set_service_role(Option<String>)`](crate::client::fluent_builders::StartNotebookExecution::set_service_role): <p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the notebook execution.</p>
    ///   - [`notebook_instance_security_group_id(impl Into<String>)`](crate::client::fluent_builders::StartNotebookExecution::notebook_instance_security_group_id) / [`set_notebook_instance_security_group_id(Option<String>)`](crate::client::fluent_builders::StartNotebookExecution::set_notebook_instance_security_group_id): <p>The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this notebook execution.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartNotebookExecution::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartNotebookExecution::set_tags): <p>A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.</p>
    /// - On success, responds with [`StartNotebookExecutionOutput`](crate::output::StartNotebookExecutionOutput) with field(s):
    ///   - [`notebook_execution_id(Option<String>)`](crate::output::StartNotebookExecutionOutput::notebook_execution_id): <p>The unique identifier of the notebook execution.</p>
    /// - On failure, responds with [`SdkError<StartNotebookExecutionError>`](crate::error::StartNotebookExecutionError)
    pub fn start_notebook_execution(&self) -> fluent_builders::StartNotebookExecution {
        fluent_builders::StartNotebookExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopNotebookExecution`](crate::client::fluent_builders::StopNotebookExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`notebook_execution_id(impl Into<String>)`](crate::client::fluent_builders::StopNotebookExecution::notebook_execution_id) / [`set_notebook_execution_id(Option<String>)`](crate::client::fluent_builders::StopNotebookExecution::set_notebook_execution_id): <p>The unique identifier of the notebook execution.</p>
    /// - On success, responds with [`StopNotebookExecutionOutput`](crate::output::StopNotebookExecutionOutput)

    /// - On failure, responds with [`SdkError<StopNotebookExecutionError>`](crate::error::StopNotebookExecutionError)
    pub fn stop_notebook_execution(&self) -> fluent_builders::StopNotebookExecution {
        fluent_builders::StopNotebookExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateJobFlows`](crate::client::fluent_builders::TerminateJobFlows) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_flow_ids(Vec<String>)`](crate::client::fluent_builders::TerminateJobFlows::job_flow_ids) / [`set_job_flow_ids(Option<Vec<String>>)`](crate::client::fluent_builders::TerminateJobFlows::set_job_flow_ids): <p>A list of job flows to be shut down.</p>
    /// - On success, responds with [`TerminateJobFlowsOutput`](crate::output::TerminateJobFlowsOutput)

    /// - On failure, responds with [`SdkError<TerminateJobFlowsError>`](crate::error::TerminateJobFlowsError)
    pub fn terminate_job_flows(&self) -> fluent_builders::TerminateJobFlows {
        fluent_builders::TerminateJobFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStudio`](crate::client::fluent_builders::UpdateStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_studio_id): <p>The ID of the Amazon EMR Studio to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_name): <p>A descriptive name for the Amazon EMR Studio.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_description): <p>A detailed description to assign to the Amazon EMR Studio.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::UpdateStudio::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateStudio::set_subnet_ids): <p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>
    ///   - [`default_s3_location(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::default_s3_location) / [`set_default_s3_location(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_default_s3_location): <p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>
    /// - On success, responds with [`UpdateStudioOutput`](crate::output::UpdateStudioOutput)

    /// - On failure, responds with [`SdkError<UpdateStudioError>`](crate::error::UpdateStudioError)
    pub fn update_studio(&self) -> fluent_builders::UpdateStudio {
        fluent_builders::UpdateStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStudioSessionMapping`](crate::client::fluent_builders::UpdateStudioSessionMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::set_studio_id): <p>The ID of the Amazon EMR Studio.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::set_identity_id): <p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    ///   - [`identity_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::identity_name) / [`set_identity_name(Option<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::set_identity_name): <p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::UpdateStudioSessionMapping::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::set_identity_type): <p>Specifies whether the identity to update is a user or a group.</p>
    ///   - [`session_policy_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::session_policy_arn) / [`set_session_policy_arn(Option<String>)`](crate::client::fluent_builders::UpdateStudioSessionMapping::set_session_policy_arn): <p>The Amazon Resource Name (ARN) of the session policy to associate with the specified user or group.</p>
    /// - On success, responds with [`UpdateStudioSessionMappingOutput`](crate::output::UpdateStudioSessionMappingOutput)

    /// - On failure, responds with [`SdkError<UpdateStudioSessionMappingError>`](crate::error::UpdateStudioSessionMappingError)
    pub fn update_studio_session_mapping(&self) -> fluent_builders::UpdateStudioSessionMapping {
        fluent_builders::UpdateStudioSessionMapping::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddInstanceFleet`.
    ///
    /// <p>Adds an instance fleet to a running cluster.</p> <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddInstanceFleet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_instance_fleet_input::Builder,
    }
    impl AddInstanceFleet {
        /// Creates a new `AddInstanceFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddInstanceFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::AddInstanceFleetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>Specifies the configuration of the instance fleet.</p>
        pub fn instance_fleet(mut self, input: crate::model::InstanceFleetConfig) -> Self {
            self.inner = self.inner.instance_fleet(input);
            self
        }
        /// <p>Specifies the configuration of the instance fleet.</p>
        pub fn set_instance_fleet(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetConfig>,
        ) -> Self {
            self.inner = self.inner.set_instance_fleet(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddInstanceGroups`.
    ///
    /// <p>Adds one or more instance groups to a running cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddInstanceGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_instance_groups_input::Builder,
    }
    impl AddInstanceGroups {
        /// Creates a new `AddInstanceGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddInstanceGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddInstanceGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `InstanceGroups`.
        ///
        /// To override the contents of this collection use [`set_instance_groups`](Self::set_instance_groups).
        ///
        /// <p>Instance groups to add.</p>
        pub fn instance_groups(mut self, input: crate::model::InstanceGroupConfig) -> Self {
            self.inner = self.inner.instance_groups(input);
            self
        }
        /// <p>Instance groups to add.</p>
        pub fn set_instance_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupConfig>>,
        ) -> Self {
            self.inner = self.inner.set_instance_groups(input);
            self
        }
        /// <p>Job flow in which to add the instance groups.</p>
        pub fn job_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_flow_id(input.into());
            self
        }
        /// <p>Job flow in which to add the instance groups.</p>
        pub fn set_job_flow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_flow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddJobFlowSteps`.
    ///
    /// <p>AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.</p>
    /// <p>If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop. For more information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a Cluster</a> in the <i>Amazon EMR Management Guide</i>.</p>
    /// <p>A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each step is performed by the main function of the main class of the JAR file. The main class can be specified either in the manifest of the JAR or by using the MainFunction parameter of the step.</p>
    /// <p>Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run successfully.</p>
    /// <p>You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.</p> <note>
    /// <p>The string values passed into <code>HadoopJarStep</code> object cannot exceed a total of 10240 characters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddJobFlowSteps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_job_flow_steps_input::Builder,
    }
    impl AddJobFlowSteps {
        /// Creates a new `AddJobFlowSteps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddJobFlowStepsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddJobFlowStepsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string that uniquely identifies the job flow. This identifier is returned by <code>RunJobFlow</code> and can also be obtained from <code>ListClusters</code>. </p>
        pub fn job_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_flow_id(input.into());
            self
        }
        /// <p>A string that uniquely identifies the job flow. This identifier is returned by <code>RunJobFlow</code> and can also be obtained from <code>ListClusters</code>. </p>
        pub fn set_job_flow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_flow_id(input);
            self
        }
        /// Appends an item to `Steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p> A list of <code>StepConfig</code> to be executed by the job flow. </p>
        pub fn steps(mut self, input: crate::model::StepConfig) -> Self {
            self.inner = self.inner.steps(input);
            self
        }
        /// <p> A list of <code>StepConfig</code> to be executed by the job flow. </p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
        ) -> Self {
            self.inner = self.inner.set_steps(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl AddTags {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon EMR resource identifier to which tags will be added. For example, a cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The Amazon EMR resource identifier to which tags will be added. For example, a cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with a resource. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with a resource. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSteps`.
    ///
    /// <p>Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a <code>PENDING</code> or <code>RUNNING</code> state. In earlier versions of Amazon EMR, you can only cancel steps that are in a <code>PENDING</code> state. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelSteps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_steps_input::Builder,
    }
    impl CancelSteps {
        /// Creates a new `CancelSteps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelStepsOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelStepsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <code>RunJobFlow</code> and <code>ListClusters</code> to get ClusterIDs. </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <code>RunJobFlow</code> and <code>ListClusters</code> to get ClusterIDs. </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// Appends an item to `StepIds`.
        ///
        /// To override the contents of this collection use [`set_step_ids`](Self::set_step_ids).
        ///
        /// <p>The list of <code>StepIDs</code> to cancel. Use <code>ListSteps</code> to get steps and their states for the specified cluster.</p>
        pub fn step_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.step_ids(input.into());
            self
        }
        /// <p>The list of <code>StepIDs</code> to cancel. Use <code>ListSteps</code> to get steps and their states for the specified cluster.</p>
        pub fn set_step_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_step_ids(input);
            self
        }
        /// <p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is <code>SEND_INTERRUPT</code>.</p>
        pub fn step_cancellation_option(
            mut self,
            input: crate::model::StepCancellationOption,
        ) -> Self {
            self.inner = self.inner.step_cancellation_option(input);
            self
        }
        /// <p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is <code>SEND_INTERRUPT</code>.</p>
        pub fn set_step_cancellation_option(
            mut self,
            input: std::option::Option<crate::model::StepCancellationOption>,
        ) -> Self {
            self.inner = self.inner.set_step_cancellation_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecurityConfiguration`.
    ///
    /// <p>Creates a security configuration, which is stored in the service and can be specified when a cluster is created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSecurityConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_security_configuration_input::Builder,
    }
    impl CreateSecurityConfiguration {
        /// Creates a new `CreateSecurityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecurityConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecurityConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The security configuration details in JSON format. For JSON parameters and examples, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_configuration(input.into());
            self
        }
        /// <p>The security configuration details in JSON format. For JSON parameters and examples, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStudio`.
    ///
    /// <p>Creates a new Amazon EMR Studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_studio_input::Builder,
    }
    impl CreateStudio {
        /// Creates a new `CreateStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A detailed description of the Amazon EMR Studio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A detailed description of the Amazon EMR Studio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.inner = self.inner.auth_mode(input);
            self
        }
        /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn set_auth_mode(mut self, input: std::option::Option<crate::model::AuthMode>) -> Self {
            self.inner = self.inner.set_auth_mode(input);
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace in any of the specified subnets.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace in any of the specified subnets.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// <p>The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role(input.into());
            self
        }
        /// <p>The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_role(input);
            self
        }
        /// <p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to the <code>UserRole</code> can be scoped down for each user or group using session policies.</p>
        pub fn user_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_role(input.into());
            self
        }
        /// <p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to the <code>UserRole</code> can be scoped down for each user or group using session policies.</p>
        pub fn set_user_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_role(input);
            self
        }
        /// <p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>
        pub fn workspace_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.workspace_security_group_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>
        pub fn set_workspace_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workspace_security_group_id(input);
            self
        }
        /// <p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>
        pub fn engine_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_security_group_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>
        pub fn set_engine_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_security_group_id(input);
            self
        }
        /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>
        pub fn default_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_s3_location(input.into());
            self
        }
        /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>
        pub fn set_default_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_s3_location(input);
            self
        }
        /// <p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>
        pub fn idp_auth_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idp_auth_url(input.into());
            self
        }
        /// <p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>
        pub fn set_idp_auth_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_idp_auth_url(input);
            self
        }
        /// <p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>
        pub fn idp_relay_state_parameter_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.idp_relay_state_parameter_name(input.into());
            self
        }
        /// <p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>
        pub fn set_idp_relay_state_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idp_relay_state_parameter_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStudioSessionMapping`.
    ///
    /// <p>Maps a user or group to the Amazon EMR Studio specified by <code>StudioId</code>, and applies a session policy to refine Studio permissions for that user or group. Use <code>CreateStudioSessionMapping</code> to assign users to a Studio when you use Amazon Web Services SSO authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups">Assign a user or group to your EMR Studio</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStudioSessionMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_studio_session_mapping_input::Builder,
    }
    impl CreateStudioSessionMapping {
        /// Creates a new `CreateStudioSessionMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStudioSessionMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStudioSessionMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_name(input.into());
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_name(input);
            self
        }
        /// <p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>
        pub fn session_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>
        pub fn set_session_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecurityConfiguration`.
    ///
    /// <p>Deletes a security configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSecurityConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_security_configuration_input::Builder,
    }
    impl DeleteSecurityConfiguration {
        /// Creates a new `DeleteSecurityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecurityConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecurityConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudio`.
    ///
    /// <p>Removes an Amazon EMR Studio from the Studio metadata store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_studio_input::Builder,
    }
    impl DeleteStudio {
        /// Creates a new `DeleteStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudioSessionMapping`.
    ///
    /// <p>Removes a user or group from an Amazon EMR Studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStudioSessionMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_studio_session_mapping_input::Builder,
    }
    impl DeleteStudioSessionMapping {
        /// Creates a new `DeleteStudioSessionMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioSessionMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioSessionMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_name(input.into());
            self
        }
        /// <p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_name(input);
            self
        }
        /// <p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCluster`.
    ///
    /// <p>Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_input::Builder,
    }
    impl DescribeCluster {
        /// Creates a new `DescribeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to describe.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier of the cluster to describe.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobFlows`.
    ///
    /// <p>This API is no longer supported and will eventually be removed. We recommend you use <code>ListClusters</code>, <code>DescribeCluster</code>, <code>ListSteps</code>, <code>ListInstanceGroups</code> and <code>ListBootstrapActions</code> instead.</p>
    /// <p>DescribeJobFlows returns a list of job flows that match all of the supplied parameters. The parameters can include a list of job flow IDs, job flow states, and restrictions on job flow creation date and time.</p>
    /// <p>Regardless of supplied parameters, only job flows created within the last two months are returned.</p>
    /// <p>If no parameters are supplied, then job flows matching either of the following criteria are returned:</p>
    /// <ul>
    /// <li> <p>Job flows created and completed in the last two weeks</p> </li>
    /// <li> <p> Job flows created within the last two months that are in one of the following states: <code>RUNNING</code>, <code>WAITING</code>, <code>SHUTTING_DOWN</code>, <code>STARTING</code> </p> </li>
    /// </ul>
    /// <p>Amazon EMR can return a maximum of 512 job flow descriptions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobFlows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_job_flows_input::Builder,
    }
    impl DescribeJobFlows {
        /// Creates a new `DescribeJobFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobFlowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Return only job flows created after this date and time.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>Return only job flows created after this date and time.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>Return only job flows created before this date and time.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>Return only job flows created before this date and time.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// Appends an item to `JobFlowIds`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p>Return only job flows whose job flow ID is contained in this list.</p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_flow_ids(input.into());
            self
        }
        /// <p>Return only job flows whose job flow ID is contained in this list.</p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_flow_ids(input);
            self
        }
        /// Appends an item to `JobFlowStates`.
        ///
        /// To override the contents of this collection use [`set_job_flow_states`](Self::set_job_flow_states).
        ///
        /// <p>Return only job flows whose state is contained in this list.</p>
        pub fn job_flow_states(mut self, input: crate::model::JobFlowExecutionState) -> Self {
            self.inner = self.inner.job_flow_states(input);
            self
        }
        /// <p>Return only job flows whose state is contained in this list.</p>
        pub fn set_job_flow_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobFlowExecutionState>>,
        ) -> Self {
            self.inner = self.inner.set_job_flow_states(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotebookExecution`.
    ///
    /// <p>Provides details of a notebook execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNotebookExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_notebook_execution_input::Builder,
    }
    impl DescribeNotebookExecution {
        /// Creates a new `DescribeNotebookExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotebookExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNotebookExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn notebook_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_execution_id(input.into());
            self
        }
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn set_notebook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReleaseLabel`.
    ///
    /// <p>Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReleaseLabel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_release_label_input::Builder,
    }
    impl DescribeReleaseLabel {
        /// Creates a new `DescribeReleaseLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReleaseLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReleaseLabelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The target release label to be described.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_label(input.into());
            self
        }
        /// <p>The target release label to be described.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_label(input);
            self
        }
        /// <p>The pagination token. Reserved for future use. Currently set to null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token. Reserved for future use. Currently set to null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Reserved for future use. Currently set to null.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Reserved for future use. Currently set to null.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecurityConfiguration`.
    ///
    /// <p>Provides the details of a security configuration by returning the configuration JSON.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSecurityConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_security_configuration_input::Builder,
    }
    impl DescribeSecurityConfiguration {
        /// Creates a new `DescribeSecurityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecurityConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecurityConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStep`.
    ///
    /// <p>Provides more detail about the cluster step.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStep {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_step_input::Builder,
    }
    impl DescribeStep {
        /// Creates a new `DescribeStep`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStepOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStepError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster with steps to describe.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier of the cluster with steps to describe.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The identifier of the step to describe.</p>
        pub fn step_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.step_id(input.into());
            self
        }
        /// <p>The identifier of the step to describe.</p>
        pub fn set_step_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_step_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStudio`.
    ///
    /// <p>Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_studio_input::Builder,
    }
    impl DescribeStudio {
        /// Creates a new `DescribeStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon EMR Studio ID.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The Amazon EMR Studio ID.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAutoTerminationPolicy`.
    ///
    /// <p>Returns the auto-termination policy for an Amazon EMR cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAutoTerminationPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_auto_termination_policy_input::Builder,
    }
    impl GetAutoTerminationPolicy {
        /// Creates a new `GetAutoTerminationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAutoTerminationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAutoTerminationPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlockPublicAccessConfiguration`.
    ///
    /// <p>Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBlockPublicAccessConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_block_public_access_configuration_input::Builder,
    }
    impl GetBlockPublicAccessConfiguration {
        /// Creates a new `GetBlockPublicAccessConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlockPublicAccessConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlockPublicAccessConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetManagedScalingPolicy`.
    ///
    /// <p>Fetches the attached managed scaling policy for an Amazon EMR cluster. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetManagedScalingPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_managed_scaling_policy_input::Builder,
    }
    impl GetManagedScalingPolicy {
        /// Creates a new `GetManagedScalingPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetManagedScalingPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetManagedScalingPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ID of the cluster for which the managed scaling policy will be fetched. </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>Specifies the ID of the cluster for which the managed scaling policy will be fetched. </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStudioSessionMapping`.
    ///
    /// <p>Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStudioSessionMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_studio_session_mapping_input::Builder,
    }
    impl GetStudioSessionMapping {
        /// Creates a new `GetStudioSessionMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStudioSessionMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStudioSessionMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_name(input.into());
            self
        }
        /// <p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_name(input);
            self
        }
        /// <p>Specifies whether the identity to fetch is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>Specifies whether the identity to fetch is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBootstrapActions`.
    ///
    /// <p>Provides information about the bootstrap actions associated with a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBootstrapActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bootstrap_actions_input::Builder,
    }
    impl ListBootstrapActions {
        /// Creates a new `ListBootstrapActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBootstrapActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBootstrapActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBootstrapActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBootstrapActionsPaginator {
            crate::paginator::ListBootstrapActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier for the bootstrap actions to list.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The cluster identifier for the bootstrap actions to list.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClusters`.
    ///
    /// <p>Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the cluster list across multiple ListClusters calls.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_clusters_input::Builder,
    }
    impl ListClusters {
        /// Creates a new `ListClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListClustersPaginator {
            crate::paginator::ListClustersPaginator::new(self.handle, self.inner)
        }
        /// <p>The creation date and time beginning value filter for listing clusters.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>The creation date and time beginning value filter for listing clusters.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>The creation date and time end value filter for listing clusters.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>The creation date and time end value filter for listing clusters.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// Appends an item to `ClusterStates`.
        ///
        /// To override the contents of this collection use [`set_cluster_states`](Self::set_cluster_states).
        ///
        /// <p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>
        pub fn cluster_states(mut self, input: crate::model::ClusterState) -> Self {
            self.inner = self.inner.cluster_states(input);
            self
        }
        /// <p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>
        pub fn set_cluster_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterState>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_states(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceFleets`.
    ///
    /// <p>Lists all available details about the instance fleets in a cluster.</p> <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstanceFleets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_instance_fleets_input::Builder,
    }
    impl ListInstanceFleets {
        /// Creates a new `ListInstanceFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceFleetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstanceFleetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstanceFleetsPaginator {
            crate::paginator::ListInstanceFleetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceGroups`.
    ///
    /// <p>Provides all available details about the instance groups in a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstanceGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_instance_groups_input::Builder,
    }
    impl ListInstanceGroups {
        /// Creates a new `ListInstanceGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstanceGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstanceGroupsPaginator {
            crate::paginator::ListInstanceGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the cluster for which to list the instance groups.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier of the cluster for which to list the instance groups.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstances`.
    ///
    /// <p>Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_instances_input::Builder,
    }
    impl ListInstances {
        /// Creates a new `ListInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstancesPaginator {
            crate::paginator::ListInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the cluster for which to list the instances.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier of the cluster for which to list the instances.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The identifier of the instance group for which to list the instances.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_group_id(input.into());
            self
        }
        /// <p>The identifier of the instance group for which to list the instances.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_group_id(input);
            self
        }
        /// Appends an item to `InstanceGroupTypes`.
        ///
        /// To override the contents of this collection use [`set_instance_group_types`](Self::set_instance_group_types).
        ///
        /// <p>The type of instance group for which to list the instances.</p>
        pub fn instance_group_types(mut self, input: crate::model::InstanceGroupType) -> Self {
            self.inner = self.inner.instance_group_types(input);
            self
        }
        /// <p>The type of instance group for which to list the instances.</p>
        pub fn set_instance_group_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupType>>,
        ) -> Self {
            self.inner = self.inner.set_instance_group_types(input);
            self
        }
        /// <p>The unique identifier of the instance fleet.</p>
        pub fn instance_fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_fleet_id(input.into());
            self
        }
        /// <p>The unique identifier of the instance fleet.</p>
        pub fn set_instance_fleet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_fleet_id(input);
            self
        }
        /// <p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>
        pub fn instance_fleet_type(mut self, input: crate::model::InstanceFleetType) -> Self {
            self.inner = self.inner.instance_fleet_type(input);
            self
        }
        /// <p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>
        pub fn set_instance_fleet_type(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetType>,
        ) -> Self {
            self.inner = self.inner.set_instance_fleet_type(input);
            self
        }
        /// Appends an item to `InstanceStates`.
        ///
        /// To override the contents of this collection use [`set_instance_states`](Self::set_instance_states).
        ///
        /// <p>A list of instance states that will filter the instances returned with this request.</p>
        pub fn instance_states(mut self, input: crate::model::InstanceState) -> Self {
            self.inner = self.inner.instance_states(input);
            self
        }
        /// <p>A list of instance states that will filter the instances returned with this request.</p>
        pub fn set_instance_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceState>>,
        ) -> Self {
            self.inner = self.inner.set_instance_states(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotebookExecutions`.
    ///
    /// <p>Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNotebookExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_notebook_executions_input::Builder,
    }
    impl ListNotebookExecutions {
        /// Creates a new `ListNotebookExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotebookExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotebookExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNotebookExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNotebookExecutionsPaginator {
            crate::paginator::ListNotebookExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID of the editor associated with the notebook execution.</p>
        pub fn editor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.editor_id(input.into());
            self
        }
        /// <p>The unique ID of the editor associated with the notebook execution.</p>
        pub fn set_editor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_editor_id(input);
            self
        }
        /// <p>The status filter for listing notebook executions.</p>
        /// <ul>
        /// <li> <p> <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not begun.</p> </li>
        /// <li> <p> <code>STARTING</code> indicates that the execution is starting on the cluster.</p> </li>
        /// <li> <p> <code>RUNNING</code> indicates that the execution is being processed by the cluster.</p> </li>
        /// <li> <p> <code>FINISHING</code> indicates that execution processing is in the final stages.</p> </li>
        /// <li> <p> <code>FINISHED</code> indicates that the execution has completed without error.</p> </li>
        /// <li> <p> <code>FAILING</code> indicates that the execution is failing and will not finish successfully.</p> </li>
        /// <li> <p> <code>FAILED</code> indicates that the execution failed.</p> </li>
        /// <li> <p> <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request and the stop is pending.</p> </li>
        /// <li> <p> <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a <code>StopNotebookExecution</code> request.</p> </li>
        /// <li> <p> <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code> request.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::NotebookExecutionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status filter for listing notebook executions.</p>
        /// <ul>
        /// <li> <p> <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not begun.</p> </li>
        /// <li> <p> <code>STARTING</code> indicates that the execution is starting on the cluster.</p> </li>
        /// <li> <p> <code>RUNNING</code> indicates that the execution is being processed by the cluster.</p> </li>
        /// <li> <p> <code>FINISHING</code> indicates that execution processing is in the final stages.</p> </li>
        /// <li> <p> <code>FINISHED</code> indicates that the execution has completed without error.</p> </li>
        /// <li> <p> <code>FAILING</code> indicates that the execution is failing and will not finish successfully.</p> </li>
        /// <li> <p> <code>FAILED</code> indicates that the execution failed.</p> </li>
        /// <li> <p> <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request and the stop is pending.</p> </li>
        /// <li> <p> <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a <code>StopNotebookExecution</code> request.</p> </li>
        /// <li> <p> <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code> request.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotebookExecutionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago.</p>
        pub fn from(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.from(input);
            self
        }
        /// <p>The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago.</p>
        pub fn set_from(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.inner = self.inner.set_from(input);
            self
        }
        /// <p>The end of time range filter for listing notebook executions. The default is the current timestamp.</p>
        pub fn to(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.to(input);
            self
        }
        /// <p>The end of time range filter for listing notebook executions. The default is the current timestamp.</p>
        pub fn set_to(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.inner = self.inner.set_to(input);
            self
        }
        /// <p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates the start of the list for this <code>ListNotebookExecutions</code> call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates the start of the list for this <code>ListNotebookExecutions</code> call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReleaseLabels`.
    ///
    /// <p>Retrieves release labels of EMR services in the region where the API is called.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReleaseLabels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_release_labels_input::Builder,
    }
    impl ListReleaseLabels {
        /// Creates a new `ListReleaseLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReleaseLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReleaseLabelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReleaseLabelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReleaseLabelsPaginator {
            crate::paginator::ListReleaseLabelsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>
        pub fn filters(mut self, input: crate::model::ReleaseLabelFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ReleaseLabelFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityConfigurations`.
    ///
    /// <p>Lists all the security configurations visible to this account, providing their creation dates and times, and their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple ListSecurityConfigurations calls.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecurityConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_security_configurations_input::Builder,
    }
    impl ListSecurityConfigurations {
        /// Creates a new `ListSecurityConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecurityConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecurityConfigurationsPaginator {
            crate::paginator::ListSecurityConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSteps`.
    ///
    /// <p>Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the request or filter by <code>StepStates</code>. You can specify a maximum of 10 <code>stepIDs</code>. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a <code>Marker</code>, which is a pagination token that indicates the next set of steps to retrieve.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSteps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_steps_input::Builder,
    }
    impl ListSteps {
        /// Creates a new `ListSteps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStepsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStepsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStepsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStepsPaginator {
            crate::paginator::ListStepsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the cluster for which to list the steps.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier of the cluster for which to list the steps.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// Appends an item to `StepStates`.
        ///
        /// To override the contents of this collection use [`set_step_states`](Self::set_step_states).
        ///
        /// <p>The filter to limit the step list based on certain states.</p>
        pub fn step_states(mut self, input: crate::model::StepState) -> Self {
            self.inner = self.inner.step_states(input);
            self
        }
        /// <p>The filter to limit the step list based on certain states.</p>
        pub fn set_step_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepState>>,
        ) -> Self {
            self.inner = self.inner.set_step_states(input);
            self
        }
        /// Appends an item to `StepIds`.
        ///
        /// To override the contents of this collection use [`set_step_ids`](Self::set_step_ids).
        ///
        /// <p>The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step IDs. The character constraint applies to the overall length of the array.</p>
        pub fn step_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.step_ids(input.into());
            self
        }
        /// <p>The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step IDs. The character constraint applies to the overall length of the array.</p>
        pub fn set_step_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_step_ids(input);
            self
        }
        /// <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudios`.
    ///
    /// <p>Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes details such as ID, Studio Access URL, and creation time for each Studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStudios {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_studios_input::Builder,
    }
    impl ListStudios {
        /// Creates a new `ListStudios`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudiosOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudiosError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStudiosPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStudiosPaginator {
            crate::paginator::ListStudiosPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudioSessionMappings`.
    ///
    /// <p>Returns a list of all user or group session mappings for the Amazon EMR Studio specified by <code>StudioId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStudioSessionMappings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_studio_session_mappings_input::Builder,
    }
    impl ListStudioSessionMappings {
        /// Creates a new `ListStudioSessionMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudioSessionMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudioSessionMappingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStudioSessionMappingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStudioSessionMappingsPaginator {
            crate::paginator::ListStudioSessionMappingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>Specifies whether to return session mappings for users or groups. If not specified, the results include session mapping details for both users and groups.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>Specifies whether to return session mappings for users or groups. If not specified, the results include session mapping details for both users and groups.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCluster`.
    ///
    /// <p>Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_input::Builder,
    }
    impl ModifyCluster {
        /// Creates a new `ModifyCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <code>Step$ActionOnFailure</code>.</p>
        pub fn step_concurrency_level(mut self, input: i32) -> Self {
            self.inner = self.inner.step_concurrency_level(input);
            self
        }
        /// <p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <code>Step$ActionOnFailure</code>.</p>
        pub fn set_step_concurrency_level(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_step_concurrency_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyInstanceFleet`.
    ///
    /// <p>Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.</p> <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyInstanceFleet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_instance_fleet_input::Builder,
    }
    impl ModifyInstanceFleet {
        /// Creates a new `ModifyInstanceFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyInstanceFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyInstanceFleetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The configuration parameters of the instance fleet.</p>
        pub fn instance_fleet(mut self, input: crate::model::InstanceFleetModifyConfig) -> Self {
            self.inner = self.inner.instance_fleet(input);
            self
        }
        /// <p>The configuration parameters of the instance fleet.</p>
        pub fn set_instance_fleet(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetModifyConfig>,
        ) -> Self {
            self.inner = self.inner.set_instance_fleet(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyInstanceGroups`.
    ///
    /// <p>ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input parameters include the new target instance count for the group and the instance group ID. The call will either succeed or fail atomically.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyInstanceGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_instance_groups_input::Builder,
    }
    impl ModifyInstanceGroups {
        /// Creates a new `ModifyInstanceGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyInstanceGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyInstanceGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the cluster to which the instance group belongs.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The ID of the cluster to which the instance group belongs.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// Appends an item to `InstanceGroups`.
        ///
        /// To override the contents of this collection use [`set_instance_groups`](Self::set_instance_groups).
        ///
        /// <p>Instance groups to change.</p>
        pub fn instance_groups(mut self, input: crate::model::InstanceGroupModifyConfig) -> Self {
            self.inner = self.inner.instance_groups(input);
            self
        }
        /// <p>Instance groups to change.</p>
        pub fn set_instance_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupModifyConfig>>,
        ) -> Self {
            self.inner = self.inner.set_instance_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAutoScalingPolicy`.
    ///
    /// <p>Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAutoScalingPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_auto_scaling_policy_input::Builder,
    }
    impl PutAutoScalingPolicy {
        /// Creates a new `PutAutoScalingPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAutoScalingPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAutoScalingPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>Specifies the ID of the instance group to which the automatic scaling policy is applied.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_group_id(input.into());
            self
        }
        /// <p>Specifies the ID of the instance group to which the automatic scaling policy is applied.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_group_id(input);
            self
        }
        /// <p>Specifies the definition of the automatic scaling policy.</p>
        pub fn auto_scaling_policy(mut self, input: crate::model::AutoScalingPolicy) -> Self {
            self.inner = self.inner.auto_scaling_policy(input);
            self
        }
        /// <p>Specifies the definition of the automatic scaling policy.</p>
        pub fn set_auto_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicy>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAutoTerminationPolicy`.
    ///
    /// <note>
    /// <p>Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html">Using an auto-termination policy</a>.</p>
    /// </note>
    /// <p>Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAutoTerminationPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_auto_termination_policy_input::Builder,
    }
    impl PutAutoTerminationPolicy {
        /// Creates a new `PutAutoTerminationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAutoTerminationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAutoTerminationPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>Specifies the auto-termination policy to attach to the cluster.</p>
        pub fn auto_termination_policy(
            mut self,
            input: crate::model::AutoTerminationPolicy,
        ) -> Self {
            self.inner = self.inner.auto_termination_policy(input);
            self
        }
        /// <p>Specifies the auto-termination policy to attach to the cluster.</p>
        pub fn set_auto_termination_policy(
            mut self,
            input: std::option::Option<crate::model::AutoTerminationPolicy>,
        ) -> Self {
            self.inner = self.inner.set_auto_termination_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBlockPublicAccessConfiguration`.
    ///
    /// <p>Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBlockPublicAccessConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_block_public_access_configuration_input::Builder,
    }
    impl PutBlockPublicAccessConfiguration {
        /// Creates a new `PutBlockPublicAccessConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBlockPublicAccessConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBlockPublicAccessConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p> <note>
        /// <p>For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an EMR cluster in a Region before this date, block public access is enabled by default in that Region.</p>
        /// </note>
        pub fn block_public_access_configuration(
            mut self,
            input: crate::model::BlockPublicAccessConfiguration,
        ) -> Self {
            self.inner = self.inner.block_public_access_configuration(input);
            self
        }
        /// <p>A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p> <note>
        /// <p>For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an EMR cluster in a Region before this date, block public access is enabled by default in that Region.</p>
        /// </note>
        pub fn set_block_public_access_configuration(
            mut self,
            input: std::option::Option<crate::model::BlockPublicAccessConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_block_public_access_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutManagedScalingPolicy`.
    ///
    /// <p>Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutManagedScalingPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_managed_scaling_policy_input::Builder,
    }
    impl PutManagedScalingPolicy {
        /// Creates a new `PutManagedScalingPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutManagedScalingPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutManagedScalingPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>Specifies the constraints for the managed scaling policy. </p>
        pub fn managed_scaling_policy(mut self, input: crate::model::ManagedScalingPolicy) -> Self {
            self.inner = self.inner.managed_scaling_policy(input);
            self
        }
        /// <p>Specifies the constraints for the managed scaling policy. </p>
        pub fn set_managed_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::ManagedScalingPolicy>,
        ) -> Self {
            self.inner = self.inner.set_managed_scaling_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAutoScalingPolicy`.
    ///
    /// <p>Removes an automatic scaling policy from a specified instance group within an EMR cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveAutoScalingPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_auto_scaling_policy_input::Builder,
    }
    impl RemoveAutoScalingPolicy {
        /// Creates a new `RemoveAutoScalingPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAutoScalingPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAutoScalingPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_group_id(input.into());
            self
        }
        /// <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAutoTerminationPolicy`.
    ///
    /// <p>Removes an auto-termination policy from an Amazon EMR cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveAutoTerminationPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_auto_termination_policy_input::Builder,
    }
    impl RemoveAutoTerminationPolicy {
        /// Creates a new `RemoveAutoTerminationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAutoTerminationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAutoTerminationPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveManagedScalingPolicy`.
    ///
    /// <p> Removes a managed scaling policy from a specified EMR cluster. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveManagedScalingPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_managed_scaling_policy_input::Builder,
    }
    impl RemoveManagedScalingPolicy {
        /// Creates a new `RemoveManagedScalingPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveManagedScalingPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveManagedScalingPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specifies the ID of the cluster from which the managed scaling policy will be removed. </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p> Specifies the ID of the cluster from which the managed scaling policy will be removed. </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>. </p>
    /// <p>The following example removes the stack tag with value Prod from a cluster:</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl RemoveTags {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon EMR resource identifier from which tags will be removed. For example, a cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The Amazon EMR resource identifier from which tags will be removed. For example, a cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RunJobFlow`.
    ///
    /// <p>RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last step of the job flow to store results in Amazon S3. If the <code>JobFlowInstancesConfig</code> <code>KeepJobFlowAliveWhenNoSteps</code> parameter is set to <code>TRUE</code>, the cluster transitions to the WAITING state rather than shutting down after the steps have completed. </p>
    /// <p>For additional protection, you can set the <code>JobFlowInstancesConfig</code> <code>TerminationProtected</code> parameter to <code>TRUE</code> to lock the cluster and prevent it from being terminated by API call, user intervention, or in the event of a job flow error.</p>
    /// <p>A maximum of 256 steps are allowed in each job flow.</p>
    /// <p>If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop. For more information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a Cluster</a> in the <i>Amazon EMR Management Guide</i>.</p>
    /// <p>For long running clusters, we recommend that you periodically store your results.</p> <note>
    /// <p>The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not both.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RunJobFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::run_job_flow_input::Builder,
    }
    impl RunJobFlow {
        /// Creates a new `RunJobFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RunJobFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::RunJobFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not created.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_uri(input.into());
            self
        }
        /// <p>The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not created.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_log_uri(input);
            self
        }
        /// <p>The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256. This attribute is only available with Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>
        pub fn log_encryption_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_encryption_kms_key_id(input.into());
            self
        }
        /// <p>The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256. This attribute is only available with Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>
        pub fn set_log_encryption_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_encryption_kms_key_id(input);
            self
        }
        /// <p>A JSON string for selecting additional features.</p>
        pub fn additional_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_info(input.into());
            self
        }
        /// <p>A JSON string for selecting additional features.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_info(input);
            self
        }
        /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.</p>
        pub fn ami_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ami_version(input.into());
            self
        }
        /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.</p>
        pub fn set_ami_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ami_version(input);
            self
        }
        /// <p>The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_label(input.into());
            self
        }
        /// <p>The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_label(input);
            self
        }
        /// <p>A specification of the number and type of Amazon EC2 instances.</p>
        pub fn instances(mut self, input: crate::model::JobFlowInstancesConfig) -> Self {
            self.inner = self.inner.instances(input);
            self
        }
        /// <p>A specification of the number and type of Amazon EC2 instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<crate::model::JobFlowInstancesConfig>,
        ) -> Self {
            self.inner = self.inner.set_instances(input);
            self
        }
        /// Appends an item to `Steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>A list of steps to run.</p>
        pub fn steps(mut self, input: crate::model::StepConfig) -> Self {
            self.inner = self.inner.steps(input);
            self
        }
        /// <p>A list of steps to run.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
        ) -> Self {
            self.inner = self.inner.set_steps(input);
            self
        }
        /// Appends an item to `BootstrapActions`.
        ///
        /// To override the contents of this collection use [`set_bootstrap_actions`](Self::set_bootstrap_actions).
        ///
        /// <p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>
        pub fn bootstrap_actions(mut self, input: crate::model::BootstrapActionConfig) -> Self {
            self.inner = self.inner.bootstrap_actions(input);
            self
        }
        /// <p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>
        pub fn set_bootstrap_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BootstrapActionConfig>>,
        ) -> Self {
            self.inner = self.inner.set_bootstrap_actions(input);
            self
        }
        /// Appends an item to `SupportedProducts`.
        ///
        /// To override the contents of this collection use [`set_supported_products`](Self::set_supported_products).
        ///
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use. For more information, see the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Currently supported values are:</p>
        /// <ul>
        /// <li> <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p> </li>
        /// <li> <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p> </li>
        /// </ul>
        pub fn supported_products(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.supported_products(input.into());
            self
        }
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use. For more information, see the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Currently supported values are:</p>
        /// <ul>
        /// <li> <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p> </li>
        /// <li> <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p> </li>
        /// </ul>
        pub fn set_supported_products(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_supported_products(input);
            self
        }
        /// Appends an item to `NewSupportedProducts`.
        ///
        /// To override the contents of this collection use [`set_new_supported_products`](Self::set_new_supported_products).
        ///
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use with the job flow that accepts a user argument list. EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported values are:</p>
        /// <ul>
        /// <li> <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p> </li>
        /// <li> <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p> </li>
        /// <li> <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5 Edition respectively.</p> </li>
        /// <li> <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p> </li>
        /// <li> <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p> </li>
        /// <li> <p>"hue"- launch the cluster with Hue installed.</p> </li>
        /// <li> <p>"spark" - launch the cluster with Apache Spark installed.</p> </li>
        /// <li> <p>"ganglia" - launch the cluster with the Ganglia Monitoring System installed.</p> </li>
        /// </ul>
        pub fn new_supported_products(
            mut self,
            input: crate::model::SupportedProductConfig,
        ) -> Self {
            self.inner = self.inner.new_supported_products(input);
            self
        }
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use with the job flow that accepts a user argument list. EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported values are:</p>
        /// <ul>
        /// <li> <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p> </li>
        /// <li> <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p> </li>
        /// <li> <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5 Edition respectively.</p> </li>
        /// <li> <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p> </li>
        /// <li> <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p> </li>
        /// <li> <p>"hue"- launch the cluster with Hue installed.</p> </li>
        /// <li> <p>"spark" - launch the cluster with Apache Spark installed.</p> </li>
        /// <li> <p>"ganglia" - launch the cluster with the Ganglia Monitoring System installed.</p> </li>
        /// </ul>
        pub fn set_new_supported_products(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupportedProductConfig>>,
        ) -> Self {
            self.inner = self.inner.set_new_supported_products(input);
            self
        }
        /// Appends an item to `Applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease Guide</a>.</p>
        pub fn applications(mut self, input: crate::model::Application) -> Self {
            self.inner = self.inner.applications(input);
            self
        }
        /// <p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease Guide</a>.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.inner = self.inner.set_applications(input);
            self
        }
        /// Appends an item to `Configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR cluster you are creating.</p>
        pub fn configurations(mut self, input: crate::model::Configuration) -> Self {
            self.inner = self.inner.configurations(input);
            self
        }
        /// <p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR cluster you are creating.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.inner = self.inner.set_configurations(input);
            self
        }
        /// <important>
        /// <p>The VisibleToAllUsers parameter is no longer supported. By default, the value is set to <code>true</code>. Setting it to <code>false</code> now has no effect.</p>
        /// </important>
        /// <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p>
        /// <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn visible_to_all_users(mut self, input: bool) -> Self {
            self.inner = self.inner.visible_to_all_users(input);
            self
        }
        /// <important>
        /// <p>The VisibleToAllUsers parameter is no longer supported. By default, the value is set to <code>true</code>. Setting it to <code>false</code> now has no effect.</p>
        /// </important>
        /// <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p>
        /// <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn set_visible_to_all_users(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_visible_to_all_users(input);
            self
        }
        /// <p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have already created it using the CLI or console.</p>
        pub fn job_flow_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_flow_role(input.into());
            self
        }
        /// <p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have already created it using the CLI or console.</p>
        pub fn set_job_flow_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_flow_role(input);
            self
        }
        /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role(input.into());
            self
        }
        /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_role(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of a security configuration to apply to the cluster.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_configuration(input.into());
            self
        }
        /// <p>The name of a security configuration to apply to the cluster.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_configuration(input);
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.</p>
        pub fn auto_scaling_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_scaling_role(input.into());
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.</p>
        pub fn set_auto_scaling_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_role(input);
            self
        }
        /// <p>Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
        pub fn scale_down_behavior(mut self, input: crate::model::ScaleDownBehavior) -> Self {
            self.inner = self.inner.scale_down_behavior(input);
            self
        }
        /// <p>Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
        pub fn set_scale_down_behavior(
            mut self,
            input: std::option::Option<crate::model::ScaleDownBehavior>,
        ) -> Self {
            self.inner = self.inner.set_scale_down_behavior(input);
            self
        }
        /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2 instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p>
        /// <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux AMI</a>. </p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_ami_id(input.into());
            self
        }
        /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2 instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p>
        /// <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux AMI</a>. </p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_ami_id(input);
            self
        }
        /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
        pub fn ebs_root_volume_size(mut self, input: i32) -> Self {
            self.inner = self.inner.ebs_root_volume_size(input);
            self
        }
        /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
        pub fn set_ebs_root_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ebs_root_volume_size(input);
            self
        }
        /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package repositories to apply automatically when the instance boots using the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.</p>
        pub fn repo_upgrade_on_boot(mut self, input: crate::model::RepoUpgradeOnBoot) -> Self {
            self.inner = self.inner.repo_upgrade_on_boot(input);
            self
        }
        /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package repositories to apply automatically when the instance boots using the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.</p>
        pub fn set_repo_upgrade_on_boot(
            mut self,
            input: std::option::Option<crate::model::RepoUpgradeOnBoot>,
        ) -> Self {
            self.inner = self.inner.set_repo_upgrade_on_boot(input);
            self
        }
        /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn kerberos_attributes(mut self, input: crate::model::KerberosAttributes) -> Self {
            self.inner = self.inner.kerberos_attributes(input);
            self
        }
        /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn set_kerberos_attributes(
            mut self,
            input: std::option::Option<crate::model::KerberosAttributes>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_attributes(input);
            self
        }
        /// <p>Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>. The maximum value is <code>256</code>.</p>
        pub fn step_concurrency_level(mut self, input: i32) -> Self {
            self.inner = self.inner.step_concurrency_level(input);
            self
        }
        /// <p>Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>. The maximum value is <code>256</code>.</p>
        pub fn set_step_concurrency_level(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_step_concurrency_level(input);
            self
        }
        /// <p> The specified managed scaling policy for an Amazon EMR cluster. </p>
        pub fn managed_scaling_policy(mut self, input: crate::model::ManagedScalingPolicy) -> Self {
            self.inner = self.inner.managed_scaling_policy(input);
            self
        }
        /// <p> The specified managed scaling policy for an Amazon EMR cluster. </p>
        pub fn set_managed_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::ManagedScalingPolicy>,
        ) -> Self {
            self.inner = self.inner.set_managed_scaling_policy(input);
            self
        }
        /// Appends an item to `PlacementGroupConfigs`.
        ///
        /// To override the contents of this collection use [`set_placement_group_configs`](Self::set_placement_group_configs).
        ///
        /// <p>The specified placement group configuration for an Amazon EMR cluster.</p>
        pub fn placement_group_configs(
            mut self,
            input: crate::model::PlacementGroupConfig,
        ) -> Self {
            self.inner = self.inner.placement_group_configs(input);
            self
        }
        /// <p>The specified placement group configuration for an Amazon EMR cluster.</p>
        pub fn set_placement_group_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementGroupConfig>>,
        ) -> Self {
            self.inner = self.inner.set_placement_group_configs(input);
            self
        }
        /// <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
        pub fn auto_termination_policy(
            mut self,
            input: crate::model::AutoTerminationPolicy,
        ) -> Self {
            self.inner = self.inner.auto_termination_policy(input);
            self
        }
        /// <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
        pub fn set_auto_termination_policy(
            mut self,
            input: std::option::Option<crate::model::AutoTerminationPolicy>,
        ) -> Self {
            self.inner = self.inner.set_auto_termination_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetTerminationProtection`.
    ///
    /// <p>SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful completion of the job flow. Calling <code>SetTerminationProtection</code> on a cluster is similar to calling the Amazon EC2 <code>DisableAPITermination</code> API on all EC2 instances in a cluster.</p>
    /// <p> <code>SetTerminationProtection</code> is used to prevent accidental termination of a cluster and to ensure that in the event of an error, the instances persist so that you can recover any data stored in their ephemeral instance storage.</p>
    /// <p> To terminate a cluster that has been locked by setting <code>SetTerminationProtection</code> to <code>true</code>, you must first unlock the job flow by a subsequent call to <code>SetTerminationProtection</code> in which you set the value to <code>false</code>. </p>
    /// <p> For more information, see<a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing Cluster Termination</a> in the <i>Amazon EMR Management Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetTerminationProtection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_termination_protection_input::Builder,
    }
    impl SetTerminationProtection {
        /// Creates a new `SetTerminationProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetTerminationProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::SetTerminationProtectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobFlowIds`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p> A list of strings that uniquely identify the clusters to protect. This identifier is returned by <code>RunJobFlow</code> and can also be obtained from <code>DescribeJobFlows</code> . </p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_flow_ids(input.into());
            self
        }
        /// <p> A list of strings that uniquely identify the clusters to protect. This identifier is returned by <code>RunJobFlow</code> and can also be obtained from <code>DescribeJobFlows</code> . </p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_flow_ids(input);
            self
        }
        /// <p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the cluster from shutting down due to API calls, user intervention, or job-flow error.</p>
        pub fn termination_protected(mut self, input: bool) -> Self {
            self.inner = self.inner.termination_protected(input);
            self
        }
        /// <p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the cluster from shutting down due to API calls, user intervention, or job-flow error.</p>
        pub fn set_termination_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_termination_protected(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetVisibleToAllUsers`.
    ///
    /// <important>
    /// <p>The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account. To restrict cluster access using an IAM policy, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html">Identity and Access Management for EMR</a>. </p>
    /// </important>
    /// <p>Sets the <code>Cluster$VisibleToAllUsers</code> value for an EMR cluster. When <code>true</code>, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.</p>
    /// <p>This action works on running clusters. When you create a cluster, use the <code>RunJobFlowInput$VisibleToAllUsers</code> parameter.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetVisibleToAllUsers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_visible_to_all_users_input::Builder,
    }
    impl SetVisibleToAllUsers {
        /// Creates a new `SetVisibleToAllUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetVisibleToAllUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::SetVisibleToAllUsersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobFlowIds`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p>The unique identifier of the job flow (cluster).</p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_flow_ids(input.into());
            self
        }
        /// <p>The unique identifier of the job flow (cluster).</p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_flow_ids(input);
            self
        }
        /// <p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform EMR actions on the cluster that the IAM policies attached to the principal allow. A value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>
        pub fn visible_to_all_users(mut self, input: bool) -> Self {
            self.inner = self.inner.visible_to_all_users(input);
            self
        }
        /// <p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform EMR actions on the cluster that the IAM policies attached to the principal allow. A value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>
        pub fn set_visible_to_all_users(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_visible_to_all_users(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartNotebookExecution`.
    ///
    /// <p>Starts a notebook execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartNotebookExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_notebook_execution_input::Builder,
    }
    impl StartNotebookExecution {
        /// Creates a new `StartNotebookExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartNotebookExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartNotebookExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the EMR Notebook to use for notebook execution.</p>
        pub fn editor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.editor_id(input.into());
            self
        }
        /// <p>The unique identifier of the EMR Notebook to use for notebook execution.</p>
        pub fn set_editor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_editor_id(input);
            self
        }
        /// <p>The path and file name of the notebook file for this execution, relative to the path specified for the EMR Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this request), and you specify a <code>RelativePath</code> of <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the notebook execution is <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>
        pub fn relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relative_path(input.into());
            self
        }
        /// <p>The path and file name of the notebook file for this execution, relative to the path specified for the EMR Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this request), and you specify a <code>RelativePath</code> of <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the notebook execution is <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>
        pub fn set_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relative_path(input);
            self
        }
        /// <p>An optional name for the notebook execution.</p>
        pub fn notebook_execution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_execution_name(input.into());
            self
        }
        /// <p>An optional name for the notebook execution.</p>
        pub fn set_notebook_execution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_execution_name(input);
            self
        }
        /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for execution.</p>
        pub fn notebook_params(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_params(input.into());
            self
        }
        /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for execution.</p>
        pub fn set_notebook_params(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_params(input);
            self
        }
        /// <p>Specifies the execution engine (cluster) that runs the notebook execution.</p>
        pub fn execution_engine(mut self, input: crate::model::ExecutionEngineConfig) -> Self {
            self.inner = self.inner.execution_engine(input);
            self
        }
        /// <p>Specifies the execution engine (cluster) that runs the notebook execution.</p>
        pub fn set_execution_engine(
            mut self,
            input: std::option::Option<crate::model::ExecutionEngineConfig>,
        ) -> Self {
            self.inner = self.inner.set_execution_engine(input);
            self
        }
        /// <p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the notebook execution.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role(input.into());
            self
        }
        /// <p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the notebook execution.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_role(input);
            self
        }
        /// <p>The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this notebook execution.</p>
        pub fn notebook_instance_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.notebook_instance_security_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this notebook execution.</p>
        pub fn set_notebook_instance_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_instance_security_group_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopNotebookExecution`.
    ///
    /// <p>Stops a notebook execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopNotebookExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_notebook_execution_input::Builder,
    }
    impl StopNotebookExecution {
        /// Creates a new `StopNotebookExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopNotebookExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopNotebookExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn notebook_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_execution_id(input.into());
            self
        }
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn set_notebook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateJobFlows`.
    ///
    /// <p>TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.</p>
    /// <p>The maximum number of clusters allowed is 10. The call to <code>TerminateJobFlows</code> is asynchronous. Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely terminate and release allocated resources, such as Amazon EC2 instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateJobFlows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::terminate_job_flows_input::Builder,
    }
    impl TerminateJobFlows {
        /// Creates a new `TerminateJobFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateJobFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateJobFlowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobFlowIds`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p>A list of job flows to be shut down.</p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_flow_ids(input.into());
            self
        }
        /// <p>A list of job flows to be shut down.</p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_flow_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStudio`.
    ///
    /// <p>Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_studio_input::Builder,
    }
    impl UpdateStudio {
        /// Creates a new `UpdateStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon EMR Studio to update.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio to update.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A detailed description to assign to the Amazon EMR Studio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A detailed description to assign to the Amazon EMR Studio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// <p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>
        pub fn default_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_s3_location(input.into());
            self
        }
        /// <p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>
        pub fn set_default_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_s3_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStudioSessionMapping`.
    ///
    /// <p>Updates the session policy attached to the user or group for the specified Amazon EMR Studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStudioSessionMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_studio_session_mapping_input::Builder,
    }
    impl UpdateStudioSessionMapping {
        /// Creates a new `UpdateStudioSessionMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStudioSessionMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStudioSessionMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_name(input.into());
            self
        }
        /// <p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_name(input);
            self
        }
        /// <p>Specifies whether the identity to update is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>Specifies whether the identity to update is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy to associate with the specified user or group.</p>
        pub fn session_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy to associate with the specified user or group.</p>
        pub fn set_session_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_policy_arn(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
