// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddInstanceFleetInput`](crate::input::AddInstanceFleetInput)
pub mod add_instance_fleet_input {
    /// A builder for [`AddInstanceFleetInput`](crate::input::AddInstanceFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) instance_fleet: std::option::Option<crate::model::InstanceFleetConfig>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>Specifies the configuration of the instance fleet.</p>
        pub fn instance_fleet(mut self, input: crate::model::InstanceFleetConfig) -> Self {
            self.instance_fleet = Some(input);
            self
        }
        /// <p>Specifies the configuration of the instance fleet.</p>
        pub fn set_instance_fleet(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetConfig>,
        ) -> Self {
            self.instance_fleet = input;
            self
        }
        /// Consumes the builder and constructs a [`AddInstanceFleetInput`](crate::input::AddInstanceFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddInstanceFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddInstanceFleetInput {
                cluster_id: self.cluster_id,
                instance_fleet: self.instance_fleet,
            })
        }
    }
}
#[doc(hidden)]
pub type AddInstanceFleetInputOperationOutputAlias = crate::operation::AddInstanceFleet;
#[doc(hidden)]
pub type AddInstanceFleetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddInstanceFleetInput {
    /// Consumes the builder and constructs an Operation<[`AddInstanceFleet`](crate::operation::AddInstanceFleet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddInstanceFleet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddInstanceFleetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddInstanceFleetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddInstanceFleetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.AddInstanceFleet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_instance_fleet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddInstanceFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddInstanceFleet",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddInstanceFleetInput`](crate::input::AddInstanceFleetInput)
    pub fn builder() -> crate::input::add_instance_fleet_input::Builder {
        crate::input::add_instance_fleet_input::Builder::default()
    }
}

/// See [`AddInstanceGroupsInput`](crate::input::AddInstanceGroupsInput)
pub mod add_instance_groups_input {
    /// A builder for [`AddInstanceGroupsInput`](crate::input::AddInstanceGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_groups:
            std::option::Option<std::vec::Vec<crate::model::InstanceGroupConfig>>,
        pub(crate) job_flow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_groups`.
        ///
        /// To override the contents of this collection use [`set_instance_groups`](Self::set_instance_groups).
        ///
        /// <p>Instance groups to add.</p>
        pub fn instance_groups(
            mut self,
            input: impl Into<crate::model::InstanceGroupConfig>,
        ) -> Self {
            let mut v = self.instance_groups.unwrap_or_default();
            v.push(input.into());
            self.instance_groups = Some(v);
            self
        }
        /// <p>Instance groups to add.</p>
        pub fn set_instance_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupConfig>>,
        ) -> Self {
            self.instance_groups = input;
            self
        }
        /// <p>Job flow in which to add the instance groups.</p>
        pub fn job_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_flow_id = Some(input.into());
            self
        }
        /// <p>Job flow in which to add the instance groups.</p>
        pub fn set_job_flow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_flow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddInstanceGroupsInput`](crate::input::AddInstanceGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddInstanceGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddInstanceGroupsInput {
                instance_groups: self.instance_groups,
                job_flow_id: self.job_flow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AddInstanceGroupsInputOperationOutputAlias = crate::operation::AddInstanceGroups;
#[doc(hidden)]
pub type AddInstanceGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddInstanceGroupsInput {
    /// Consumes the builder and constructs an Operation<[`AddInstanceGroups`](crate::operation::AddInstanceGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddInstanceGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddInstanceGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddInstanceGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddInstanceGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.AddInstanceGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_instance_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddInstanceGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddInstanceGroups",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddInstanceGroupsInput`](crate::input::AddInstanceGroupsInput)
    pub fn builder() -> crate::input::add_instance_groups_input::Builder {
        crate::input::add_instance_groups_input::Builder::default()
    }
}

/// See [`AddJobFlowStepsInput`](crate::input::AddJobFlowStepsInput)
pub mod add_job_flow_steps_input {
    /// A builder for [`AddJobFlowStepsInput`](crate::input::AddJobFlowStepsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_flow_id: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
    }
    impl Builder {
        /// <p>A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can also be obtained from <a>ListClusters</a>.
        /// </p>
        pub fn job_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_flow_id = Some(input.into());
            self
        }
        /// <p>A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can also be obtained from <a>ListClusters</a>.
        /// </p>
        pub fn set_job_flow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_flow_id = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p> A list of <a>StepConfig</a> to be executed by the job flow. </p>
        pub fn steps(mut self, input: impl Into<crate::model::StepConfig>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p> A list of <a>StepConfig</a> to be executed by the job flow. </p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`AddJobFlowStepsInput`](crate::input::AddJobFlowStepsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddJobFlowStepsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddJobFlowStepsInput {
                job_flow_id: self.job_flow_id,
                steps: self.steps,
            })
        }
    }
}
#[doc(hidden)]
pub type AddJobFlowStepsInputOperationOutputAlias = crate::operation::AddJobFlowSteps;
#[doc(hidden)]
pub type AddJobFlowStepsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddJobFlowStepsInput {
    /// Consumes the builder and constructs an Operation<[`AddJobFlowSteps`](crate::operation::AddJobFlowSteps)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddJobFlowSteps,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddJobFlowStepsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddJobFlowStepsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddJobFlowStepsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.AddJobFlowSteps",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_job_flow_steps(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddJobFlowSteps::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddJobFlowSteps",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddJobFlowStepsInput`](crate::input::AddJobFlowStepsInput)
    pub fn builder() -> crate::input::add_job_flow_steps_input::Builder {
        crate::input::add_job_flow_steps_input::Builder::default()
    }
}

/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon EMR resource identifier to which tags will be added. For example, a
        /// cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The Amazon EMR resource identifier to which tags will be added. For example, a
        /// cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with a resource. Tags are
        /// user-defined key-value pairs that consist of a required key string with a maximum of 128
        /// characters, and an optional value string with a maximum of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associate with a resource. Tags are
        /// user-defined key-value pairs that consist of a required key string with a maximum of 128
        /// characters, and an optional value string with a maximum of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                resource_id: self.resource_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.AddTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("AddTags", "emr"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`CancelStepsInput`](crate::input::CancelStepsInput)
pub mod cancel_steps_input {
    /// A builder for [`CancelStepsInput`](crate::input::CancelStepsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) step_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) step_cancellation_option:
            std::option::Option<crate::model::StepCancellationOption>,
    }
    impl Builder {
        /// <p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and <a>ListClusters</a> to get ClusterIDs. </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and <a>ListClusters</a> to get ClusterIDs. </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Appends an item to `step_ids`.
        ///
        /// To override the contents of this collection use [`set_step_ids`](Self::set_step_ids).
        ///
        /// <p>The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps
        /// and their states for the specified cluster.</p>
        pub fn step_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.step_ids.unwrap_or_default();
            v.push(input.into());
            self.step_ids = Some(v);
            self
        }
        /// <p>The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps
        /// and their states for the specified cluster.</p>
        pub fn set_step_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.step_ids = input;
            self
        }
        /// <p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
        /// <code>SEND_INTERRUPT</code>.</p>
        pub fn step_cancellation_option(
            mut self,
            input: crate::model::StepCancellationOption,
        ) -> Self {
            self.step_cancellation_option = Some(input);
            self
        }
        /// <p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
        /// <code>SEND_INTERRUPT</code>.</p>
        pub fn set_step_cancellation_option(
            mut self,
            input: std::option::Option<crate::model::StepCancellationOption>,
        ) -> Self {
            self.step_cancellation_option = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelStepsInput`](crate::input::CancelStepsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelStepsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelStepsInput {
                cluster_id: self.cluster_id,
                step_ids: self.step_ids,
                step_cancellation_option: self.step_cancellation_option,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelStepsInputOperationOutputAlias = crate::operation::CancelSteps;
#[doc(hidden)]
pub type CancelStepsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelStepsInput {
    /// Consumes the builder and constructs an Operation<[`CancelSteps`](crate::operation::CancelSteps)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelSteps,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelStepsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelStepsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelStepsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.CancelSteps",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_cancel_steps(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelSteps::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelSteps",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelStepsInput`](crate::input::CancelStepsInput)
    pub fn builder() -> crate::input::cancel_steps_input::Builder {
        crate::input::cancel_steps_input::Builder::default()
    }
}

/// See [`CreateSecurityConfigurationInput`](crate::input::CreateSecurityConfigurationInput)
pub mod create_security_configuration_input {
    /// A builder for [`CreateSecurityConfigurationInput`](crate::input::CreateSecurityConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The security configuration details in JSON format. For JSON parameters and examples, see
        /// <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security
        /// Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management
        /// Guide</i>.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The security configuration details in JSON format. For JSON parameters and examples, see
        /// <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security
        /// Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management
        /// Guide</i>.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSecurityConfigurationInput`](crate::input::CreateSecurityConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSecurityConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSecurityConfigurationInput {
                name: self.name,
                security_configuration: self.security_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSecurityConfigurationInputOperationOutputAlias =
    crate::operation::CreateSecurityConfiguration;
#[doc(hidden)]
pub type CreateSecurityConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSecurityConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateSecurityConfiguration`](crate::operation::CreateSecurityConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSecurityConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSecurityConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSecurityConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSecurityConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.CreateSecurityConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_security_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSecurityConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSecurityConfiguration",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSecurityConfigurationInput`](crate::input::CreateSecurityConfigurationInput)
    pub fn builder() -> crate::input::create_security_configuration_input::Builder {
        crate::input::create_security_configuration_input::Builder::default()
    }
}

/// See [`CreateStudioInput`](crate::input::CreateStudioInput)
pub mod create_studio_input {
    /// A builder for [`CreateStudioInput`](crate::input::CreateStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) auth_mode: std::option::Option<crate::model::AuthMode>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) user_role: std::option::Option<std::string::String>,
        pub(crate) workspace_security_group_id: std::option::Option<std::string::String>,
        pub(crate) engine_security_group_id: std::option::Option<std::string::String>,
        pub(crate) default_s3_location: std::option::Option<std::string::String>,
        pub(crate) idp_auth_url: std::option::Option<std::string::String>,
        pub(crate) idp_relay_state_parameter_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A detailed description of the Amazon EMR Studio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A detailed description of the Amazon EMR Studio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.auth_mode = Some(input);
            self
        }
        /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn set_auth_mode(mut self, input: std::option::Option<crate::model::AuthMode>) -> Self {
            self.auth_mode = input;
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the
        /// Studio.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the
        /// Studio.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC
        /// specified by <code>VpcId</code>. Studio users can create a Workspace in any of the
        /// specified subnets.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC
        /// specified by <code>VpcId</code>. Studio users can create a Workspace in any of the
        /// specified subnets.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The IAM role that the Amazon EMR Studio assumes. The service role provides a
        /// way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The IAM role that the Amazon EMR Studio assumes. The service role provides a
        /// way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The
        /// permissions attached to the <code>UserRole</code> can be scoped down for each user or group using
        /// session policies.</p>
        pub fn user_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_role = Some(input.into());
            self
        }
        /// <p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The
        /// permissions attached to the <code>UserRole</code> can be scoped down for each user or group using
        /// session policies.</p>
        pub fn set_user_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_role = input;
            self
        }
        /// <p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group
        /// allows outbound network traffic to resources in the Engine security group, and it must be
        /// in the same VPC specified by <code>VpcId</code>.</p>
        pub fn workspace_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.workspace_security_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group
        /// allows outbound network traffic to resources in the Engine security group, and it must be
        /// in the same VPC specified by <code>VpcId</code>.</p>
        pub fn set_workspace_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_security_group_id = input;
            self
        }
        /// <p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows
        /// inbound network traffic from the Workspace security group, and it must be in the same VPC
        /// specified by <code>VpcId</code>.</p>
        pub fn engine_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_security_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows
        /// inbound network traffic from the Workspace security group, and it must be in the same VPC
        /// specified by <code>VpcId</code>.</p>
        pub fn set_engine_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_security_group_id = input;
            self
        }
        /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>
        pub fn default_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_s3_location = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>
        pub fn set_default_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_s3_location = input;
            self
        }
        /// <p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>
        pub fn idp_auth_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.idp_auth_url = Some(input.into());
            self
        }
        /// <p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>
        pub fn set_idp_auth_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.idp_auth_url = input;
            self
        }
        /// <p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>
        pub fn idp_relay_state_parameter_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.idp_relay_state_parameter_name = Some(input.into());
            self
        }
        /// <p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>
        pub fn set_idp_relay_state_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idp_relay_state_parameter_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
        /// consist of a required key string with a maximum of 128 characters, and an optional value
        /// string with a maximum of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
        /// consist of a required key string with a maximum of 128 characters, and an optional value
        /// string with a maximum of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStudioInput`](crate::input::CreateStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStudioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStudioInput {
                name: self.name,
                description: self.description,
                auth_mode: self.auth_mode,
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                service_role: self.service_role,
                user_role: self.user_role,
                workspace_security_group_id: self.workspace_security_group_id,
                engine_security_group_id: self.engine_security_group_id,
                default_s3_location: self.default_s3_location,
                idp_auth_url: self.idp_auth_url,
                idp_relay_state_parameter_name: self.idp_relay_state_parameter_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStudioInputOperationOutputAlias = crate::operation::CreateStudio;
#[doc(hidden)]
pub type CreateStudioInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStudioInput {
    /// Consumes the builder and constructs an Operation<[`CreateStudio`](crate::operation::CreateStudio)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStudio,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStudioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStudioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStudioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.CreateStudio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_studio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStudio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStudio",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStudioInput`](crate::input::CreateStudioInput)
    pub fn builder() -> crate::input::create_studio_input::Builder {
        crate::input::create_studio_input::Builder::default()
    }
}

/// See [`CreateStudioSessionMappingInput`](crate::input::CreateStudioSessionMappingInput)
pub mod create_studio_session_mapping_input {
    /// A builder for [`CreateStudioSessionMappingInput`](crate::input::CreateStudioSessionMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_name: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) session_policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
        /// Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
        /// Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_name = Some(input.into());
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_name = input;
            self
        }
        /// <p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user
        /// or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>
        pub fn session_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user
        /// or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>
        pub fn set_session_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStudioSessionMappingInput`](crate::input::CreateStudioSessionMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStudioSessionMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStudioSessionMappingInput {
                studio_id: self.studio_id,
                identity_id: self.identity_id,
                identity_name: self.identity_name,
                identity_type: self.identity_type,
                session_policy_arn: self.session_policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStudioSessionMappingInputOperationOutputAlias =
    crate::operation::CreateStudioSessionMapping;
#[doc(hidden)]
pub type CreateStudioSessionMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStudioSessionMappingInput {
    /// Consumes the builder and constructs an Operation<[`CreateStudioSessionMapping`](crate::operation::CreateStudioSessionMapping)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStudioSessionMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStudioSessionMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStudioSessionMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStudioSessionMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.CreateStudioSessionMapping",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_studio_session_mapping(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStudioSessionMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStudioSessionMapping",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStudioSessionMappingInput`](crate::input::CreateStudioSessionMappingInput)
    pub fn builder() -> crate::input::create_studio_session_mapping_input::Builder {
        crate::input::create_studio_session_mapping_input::Builder::default()
    }
}

/// See [`DeleteSecurityConfigurationInput`](crate::input::DeleteSecurityConfigurationInput)
pub mod delete_security_configuration_input {
    /// A builder for [`DeleteSecurityConfigurationInput`](crate::input::DeleteSecurityConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSecurityConfigurationInput`](crate::input::DeleteSecurityConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSecurityConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSecurityConfigurationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteSecurityConfigurationInputOperationOutputAlias =
    crate::operation::DeleteSecurityConfiguration;
#[doc(hidden)]
pub type DeleteSecurityConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSecurityConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSecurityConfiguration`](crate::operation::DeleteSecurityConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSecurityConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSecurityConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSecurityConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSecurityConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DeleteSecurityConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_security_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSecurityConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSecurityConfiguration",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSecurityConfigurationInput`](crate::input::DeleteSecurityConfigurationInput)
    pub fn builder() -> crate::input::delete_security_configuration_input::Builder {
        crate::input::delete_security_configuration_input::Builder::default()
    }
}

/// See [`DeleteStudioInput`](crate::input::DeleteStudioInput)
pub mod delete_studio_input {
    /// A builder for [`DeleteStudioInput`](crate::input::DeleteStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStudioInput`](crate::input::DeleteStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStudioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStudioInput {
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStudioInputOperationOutputAlias = crate::operation::DeleteStudio;
#[doc(hidden)]
pub type DeleteStudioInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStudioInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStudio`](crate::operation::DeleteStudio)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStudio,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStudioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStudioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStudioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DeleteStudio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_studio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStudio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStudio",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStudioInput`](crate::input::DeleteStudioInput)
    pub fn builder() -> crate::input::delete_studio_input::Builder {
        crate::input::delete_studio_input::Builder::default()
    }
}

/// See [`DeleteStudioSessionMappingInput`](crate::input::DeleteStudioSessionMappingInput)
pub mod delete_studio_session_mapping_input {
    /// A builder for [`DeleteStudioSessionMappingInput`](crate::input::DeleteStudioSessionMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_name: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR
        /// Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR
        /// Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see
        /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_name = Some(input.into());
            self
        }
        /// <p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see
        /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_name = input;
            self
        }
        /// <p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStudioSessionMappingInput`](crate::input::DeleteStudioSessionMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStudioSessionMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStudioSessionMappingInput {
                studio_id: self.studio_id,
                identity_id: self.identity_id,
                identity_name: self.identity_name,
                identity_type: self.identity_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStudioSessionMappingInputOperationOutputAlias =
    crate::operation::DeleteStudioSessionMapping;
#[doc(hidden)]
pub type DeleteStudioSessionMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStudioSessionMappingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStudioSessionMapping`](crate::operation::DeleteStudioSessionMapping)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStudioSessionMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStudioSessionMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStudioSessionMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStudioSessionMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DeleteStudioSessionMapping",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_studio_session_mapping(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStudioSessionMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStudioSessionMapping",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStudioSessionMappingInput`](crate::input::DeleteStudioSessionMappingInput)
    pub fn builder() -> crate::input::delete_studio_session_mapping_input::Builder {
        crate::input::delete_studio_session_mapping_input::Builder::default()
    }
}

/// See [`DescribeClusterInput`](crate::input::DescribeClusterInput)
pub mod describe_cluster_input {
    /// A builder for [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster to describe.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to describe.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterInput`](crate::input::DescribeClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterInput {
                cluster_id: self.cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterInputOperationOutputAlias = crate::operation::DescribeCluster;
#[doc(hidden)]
pub type DescribeClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCluster`](crate::operation::DescribeCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DescribeCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCluster",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    pub fn builder() -> crate::input::describe_cluster_input::Builder {
        crate::input::describe_cluster_input::Builder::default()
    }
}

/// See [`DescribeJobFlowsInput`](crate::input::DescribeJobFlowsInput)
pub mod describe_job_flows_input {
    /// A builder for [`DescribeJobFlowsInput`](crate::input::DescribeJobFlowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) job_flow_states:
            std::option::Option<std::vec::Vec<crate::model::JobFlowExecutionState>>,
    }
    impl Builder {
        /// <p>Return only job flows created after this date and time.</p>
        pub fn created_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p>Return only job flows created after this date and time.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// <p>Return only job flows created before this date and time.</p>
        pub fn created_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>Return only job flows created before this date and time.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// Appends an item to `job_flow_ids`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p>Return only job flows whose job flow ID is contained in this list.</p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_flow_ids.unwrap_or_default();
            v.push(input.into());
            self.job_flow_ids = Some(v);
            self
        }
        /// <p>Return only job flows whose job flow ID is contained in this list.</p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_flow_ids = input;
            self
        }
        /// Appends an item to `job_flow_states`.
        ///
        /// To override the contents of this collection use [`set_job_flow_states`](Self::set_job_flow_states).
        ///
        /// <p>Return only job flows whose state is contained in this list.</p>
        pub fn job_flow_states(
            mut self,
            input: impl Into<crate::model::JobFlowExecutionState>,
        ) -> Self {
            let mut v = self.job_flow_states.unwrap_or_default();
            v.push(input.into());
            self.job_flow_states = Some(v);
            self
        }
        /// <p>Return only job flows whose state is contained in this list.</p>
        pub fn set_job_flow_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobFlowExecutionState>>,
        ) -> Self {
            self.job_flow_states = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobFlowsInput`](crate::input::DescribeJobFlowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobFlowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobFlowsInput {
                created_after: self.created_after,
                created_before: self.created_before,
                job_flow_ids: self.job_flow_ids,
                job_flow_states: self.job_flow_states,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobFlowsInputOperationOutputAlias = crate::operation::DescribeJobFlows;
#[doc(hidden)]
pub type DescribeJobFlowsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeJobFlowsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobFlows`](crate::operation::DescribeJobFlows)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobFlows,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobFlowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobFlowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobFlowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DescribeJobFlows",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_job_flows(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobFlows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobFlows",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobFlowsInput`](crate::input::DescribeJobFlowsInput)
    pub fn builder() -> crate::input::describe_job_flows_input::Builder {
        crate::input::describe_job_flows_input::Builder::default()
    }
}

/// See [`DescribeNotebookExecutionInput`](crate::input::DescribeNotebookExecutionInput)
pub mod describe_notebook_execution_input {
    /// A builder for [`DescribeNotebookExecutionInput`](crate::input::DescribeNotebookExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn notebook_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_execution_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn set_notebook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotebookExecutionInput`](crate::input::DescribeNotebookExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNotebookExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNotebookExecutionInput {
                notebook_execution_id: self.notebook_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNotebookExecutionInputOperationOutputAlias =
    crate::operation::DescribeNotebookExecution;
#[doc(hidden)]
pub type DescribeNotebookExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNotebookExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNotebookExecution`](crate::operation::DescribeNotebookExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNotebookExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNotebookExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNotebookExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNotebookExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DescribeNotebookExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_notebook_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNotebookExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNotebookExecution",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNotebookExecutionInput`](crate::input::DescribeNotebookExecutionInput)
    pub fn builder() -> crate::input::describe_notebook_execution_input::Builder {
        crate::input::describe_notebook_execution_input::Builder::default()
    }
}

/// See [`DescribeReleaseLabelInput`](crate::input::DescribeReleaseLabelInput)
pub mod describe_release_label_input {
    /// A builder for [`DescribeReleaseLabelInput`](crate::input::DescribeReleaseLabelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) release_label: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The target release label to be described.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_label = Some(input.into());
            self
        }
        /// <p>The target release label to be described.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_label = input;
            self
        }
        /// <p>The pagination token. Reserved for future use. Currently set to null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token. Reserved for future use. Currently set to null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Reserved for future use. Currently set to null.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Reserved for future use. Currently set to null.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReleaseLabelInput`](crate::input::DescribeReleaseLabelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReleaseLabelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReleaseLabelInput {
                release_label: self.release_label,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReleaseLabelInputOperationOutputAlias = crate::operation::DescribeReleaseLabel;
#[doc(hidden)]
pub type DescribeReleaseLabelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReleaseLabelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReleaseLabel`](crate::operation::DescribeReleaseLabel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReleaseLabel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReleaseLabelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReleaseLabelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReleaseLabelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DescribeReleaseLabel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_release_label(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReleaseLabel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReleaseLabel",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReleaseLabelInput`](crate::input::DescribeReleaseLabelInput)
    pub fn builder() -> crate::input::describe_release_label_input::Builder {
        crate::input::describe_release_label_input::Builder::default()
    }
}

/// See [`DescribeSecurityConfigurationInput`](crate::input::DescribeSecurityConfigurationInput)
pub mod describe_security_configuration_input {
    /// A builder for [`DescribeSecurityConfigurationInput`](crate::input::DescribeSecurityConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSecurityConfigurationInput`](crate::input::DescribeSecurityConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSecurityConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSecurityConfigurationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeSecurityConfigurationInputOperationOutputAlias =
    crate::operation::DescribeSecurityConfiguration;
#[doc(hidden)]
pub type DescribeSecurityConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSecurityConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSecurityConfiguration`](crate::operation::DescribeSecurityConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSecurityConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSecurityConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSecurityConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSecurityConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DescribeSecurityConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_security_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSecurityConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSecurityConfiguration",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSecurityConfigurationInput`](crate::input::DescribeSecurityConfigurationInput)
    pub fn builder() -> crate::input::describe_security_configuration_input::Builder {
        crate::input::describe_security_configuration_input::Builder::default()
    }
}

/// See [`DescribeStepInput`](crate::input::DescribeStepInput)
pub mod describe_step_input {
    /// A builder for [`DescribeStepInput`](crate::input::DescribeStepInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) step_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster with steps to describe.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster with steps to describe.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The identifier of the step to describe.</p>
        pub fn step_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.step_id = Some(input.into());
            self
        }
        /// <p>The identifier of the step to describe.</p>
        pub fn set_step_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.step_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStepInput`](crate::input::DescribeStepInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStepInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStepInput {
                cluster_id: self.cluster_id,
                step_id: self.step_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStepInputOperationOutputAlias = crate::operation::DescribeStep;
#[doc(hidden)]
pub type DescribeStepInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStepInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStep`](crate::operation::DescribeStep)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStep,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStepInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStepInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStepInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DescribeStep",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_step(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStep::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStep",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStepInput`](crate::input::DescribeStepInput)
    pub fn builder() -> crate::input::describe_step_input::Builder {
        crate::input::describe_step_input::Builder::default()
    }
}

/// See [`DescribeStudioInput`](crate::input::DescribeStudioInput)
pub mod describe_studio_input {
    /// A builder for [`DescribeStudioInput`](crate::input::DescribeStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EMR Studio ID.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The Amazon EMR Studio ID.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStudioInput`](crate::input::DescribeStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStudioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStudioInput {
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStudioInputOperationOutputAlias = crate::operation::DescribeStudio;
#[doc(hidden)]
pub type DescribeStudioInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStudioInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStudio`](crate::operation::DescribeStudio)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStudio,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStudioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStudioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStudioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.DescribeStudio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_studio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStudio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStudio",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStudioInput`](crate::input::DescribeStudioInput)
    pub fn builder() -> crate::input::describe_studio_input::Builder {
        crate::input::describe_studio_input::Builder::default()
    }
}

/// See [`GetAutoTerminationPolicyInput`](crate::input::GetAutoTerminationPolicyInput)
pub mod get_auto_termination_policy_input {
    /// A builder for [`GetAutoTerminationPolicyInput`](crate::input::GetAutoTerminationPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAutoTerminationPolicyInput`](crate::input::GetAutoTerminationPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAutoTerminationPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAutoTerminationPolicyInput {
                cluster_id: self.cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAutoTerminationPolicyInputOperationOutputAlias =
    crate::operation::GetAutoTerminationPolicy;
#[doc(hidden)]
pub type GetAutoTerminationPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAutoTerminationPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetAutoTerminationPolicy`](crate::operation::GetAutoTerminationPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAutoTerminationPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAutoTerminationPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAutoTerminationPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAutoTerminationPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.GetAutoTerminationPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_auto_termination_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAutoTerminationPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAutoTerminationPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAutoTerminationPolicyInput`](crate::input::GetAutoTerminationPolicyInput)
    pub fn builder() -> crate::input::get_auto_termination_policy_input::Builder {
        crate::input::get_auto_termination_policy_input::Builder::default()
    }
}

/// See [`GetBlockPublicAccessConfigurationInput`](crate::input::GetBlockPublicAccessConfigurationInput)
pub mod get_block_public_access_configuration_input {
    /// A builder for [`GetBlockPublicAccessConfigurationInput`](crate::input::GetBlockPublicAccessConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetBlockPublicAccessConfigurationInput`](crate::input::GetBlockPublicAccessConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBlockPublicAccessConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBlockPublicAccessConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type GetBlockPublicAccessConfigurationInputOperationOutputAlias =
    crate::operation::GetBlockPublicAccessConfiguration;
#[doc(hidden)]
pub type GetBlockPublicAccessConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBlockPublicAccessConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBlockPublicAccessConfiguration`](crate::operation::GetBlockPublicAccessConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBlockPublicAccessConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBlockPublicAccessConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBlockPublicAccessConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBlockPublicAccessConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.GetBlockPublicAccessConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_block_public_access_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBlockPublicAccessConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBlockPublicAccessConfiguration",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBlockPublicAccessConfigurationInput`](crate::input::GetBlockPublicAccessConfigurationInput)
    pub fn builder() -> crate::input::get_block_public_access_configuration_input::Builder {
        crate::input::get_block_public_access_configuration_input::Builder::default()
    }
}

/// See [`GetManagedScalingPolicyInput`](crate::input::GetManagedScalingPolicyInput)
pub mod get_managed_scaling_policy_input {
    /// A builder for [`GetManagedScalingPolicyInput`](crate::input::GetManagedScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ID of the cluster for which the managed scaling policy will be fetched.
        /// </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the cluster for which the managed scaling policy will be fetched.
        /// </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetManagedScalingPolicyInput`](crate::input::GetManagedScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetManagedScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetManagedScalingPolicyInput {
                cluster_id: self.cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetManagedScalingPolicyInputOperationOutputAlias =
    crate::operation::GetManagedScalingPolicy;
#[doc(hidden)]
pub type GetManagedScalingPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetManagedScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetManagedScalingPolicy`](crate::operation::GetManagedScalingPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetManagedScalingPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetManagedScalingPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetManagedScalingPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetManagedScalingPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.GetManagedScalingPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_managed_scaling_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetManagedScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetManagedScalingPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetManagedScalingPolicyInput`](crate::input::GetManagedScalingPolicyInput)
    pub fn builder() -> crate::input::get_managed_scaling_policy_input::Builder {
        crate::input::get_managed_scaling_policy_input::Builder::default()
    }
}

/// See [`GetStudioSessionMappingInput`](crate::input::GetStudioSessionMappingInput)
pub mod get_studio_session_mapping_input {
    /// A builder for [`GetStudioSessionMappingInput`](crate::input::GetStudioSessionMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_name: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
        /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
        /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_name = Some(input.into());
            self
        }
        /// <p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_name = input;
            self
        }
        /// <p>Specifies whether the identity to fetch is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Specifies whether the identity to fetch is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStudioSessionMappingInput`](crate::input::GetStudioSessionMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStudioSessionMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStudioSessionMappingInput {
                studio_id: self.studio_id,
                identity_id: self.identity_id,
                identity_name: self.identity_name,
                identity_type: self.identity_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStudioSessionMappingInputOperationOutputAlias =
    crate::operation::GetStudioSessionMapping;
#[doc(hidden)]
pub type GetStudioSessionMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetStudioSessionMappingInput {
    /// Consumes the builder and constructs an Operation<[`GetStudioSessionMapping`](crate::operation::GetStudioSessionMapping)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStudioSessionMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetStudioSessionMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetStudioSessionMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetStudioSessionMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.GetStudioSessionMapping",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_studio_session_mapping(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStudioSessionMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStudioSessionMapping",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetStudioSessionMappingInput`](crate::input::GetStudioSessionMappingInput)
    pub fn builder() -> crate::input::get_studio_session_mapping_input::Builder {
        crate::input::get_studio_session_mapping_input::Builder::default()
    }
}

/// See [`ListBootstrapActionsInput`](crate::input::ListBootstrapActionsInput)
pub mod list_bootstrap_actions_input {
    /// A builder for [`ListBootstrapActionsInput`](crate::input::ListBootstrapActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier for the bootstrap actions to list.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster identifier for the bootstrap actions to list.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBootstrapActionsInput`](crate::input::ListBootstrapActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBootstrapActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBootstrapActionsInput {
                cluster_id: self.cluster_id,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBootstrapActionsInputOperationOutputAlias = crate::operation::ListBootstrapActions;
#[doc(hidden)]
pub type ListBootstrapActionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBootstrapActionsInput {
    /// Consumes the builder and constructs an Operation<[`ListBootstrapActions`](crate::operation::ListBootstrapActions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBootstrapActions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBootstrapActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBootstrapActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBootstrapActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListBootstrapActions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_bootstrap_actions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBootstrapActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBootstrapActions",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBootstrapActionsInput`](crate::input::ListBootstrapActionsInput)
    pub fn builder() -> crate::input::list_bootstrap_actions_input::Builder {
        crate::input::list_bootstrap_actions_input::Builder::default()
    }
}

/// See [`ListClustersInput`](crate::input::ListClustersInput)
pub mod list_clusters_input {
    /// A builder for [`ListClustersInput`](crate::input::ListClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cluster_states: std::option::Option<std::vec::Vec<crate::model::ClusterState>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The creation date and time beginning value filter for listing clusters.</p>
        pub fn created_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p>The creation date and time beginning value filter for listing clusters.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// <p>The creation date and time end value filter for listing clusters.</p>
        pub fn created_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>The creation date and time end value filter for listing clusters.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// Appends an item to `cluster_states`.
        ///
        /// To override the contents of this collection use [`set_cluster_states`](Self::set_cluster_states).
        ///
        /// <p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>
        pub fn cluster_states(mut self, input: impl Into<crate::model::ClusterState>) -> Self {
            let mut v = self.cluster_states.unwrap_or_default();
            v.push(input.into());
            self.cluster_states = Some(v);
            self
        }
        /// <p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>
        pub fn set_cluster_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterState>>,
        ) -> Self {
            self.cluster_states = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClustersInput`](crate::input::ListClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListClustersInput {
                created_after: self.created_after,
                created_before: self.created_before,
                cluster_states: self.cluster_states,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListClustersInputOperationOutputAlias = crate::operation::ListClusters;
#[doc(hidden)]
pub type ListClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListClustersInput {
    /// Consumes the builder and constructs an Operation<[`ListClusters`](crate::operation::ListClusters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListClusters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_clusters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClusters",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListClustersInput`](crate::input::ListClustersInput)
    pub fn builder() -> crate::input::list_clusters_input::Builder {
        crate::input::list_clusters_input::Builder::default()
    }
}

/// See [`ListInstanceFleetsInput`](crate::input::ListInstanceFleetsInput)
pub mod list_instance_fleets_input {
    /// A builder for [`ListInstanceFleetsInput`](crate::input::ListInstanceFleetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceFleetsInput`](crate::input::ListInstanceFleetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceFleetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceFleetsInput {
                cluster_id: self.cluster_id,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceFleetsInputOperationOutputAlias = crate::operation::ListInstanceFleets;
#[doc(hidden)]
pub type ListInstanceFleetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInstanceFleetsInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceFleets`](crate::operation::ListInstanceFleets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceFleets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceFleetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceFleetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceFleetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListInstanceFleets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_instance_fleets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceFleets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceFleets",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceFleetsInput`](crate::input::ListInstanceFleetsInput)
    pub fn builder() -> crate::input::list_instance_fleets_input::Builder {
        crate::input::list_instance_fleets_input::Builder::default()
    }
}

/// See [`ListInstanceGroupsInput`](crate::input::ListInstanceGroupsInput)
pub mod list_instance_groups_input {
    /// A builder for [`ListInstanceGroupsInput`](crate::input::ListInstanceGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster for which to list the instance groups.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster for which to list the instance groups.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceGroupsInput`](crate::input::ListInstanceGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceGroupsInput {
                cluster_id: self.cluster_id,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceGroupsInputOperationOutputAlias = crate::operation::ListInstanceGroups;
#[doc(hidden)]
pub type ListInstanceGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInstanceGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceGroups`](crate::operation::ListInstanceGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListInstanceGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_instance_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceGroups",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceGroupsInput`](crate::input::ListInstanceGroupsInput)
    pub fn builder() -> crate::input::list_instance_groups_input::Builder {
        crate::input::list_instance_groups_input::Builder::default()
    }
}

/// See [`ListInstancesInput`](crate::input::ListInstancesInput)
pub mod list_instances_input {
    /// A builder for [`ListInstancesInput`](crate::input::ListInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) instance_group_id: std::option::Option<std::string::String>,
        pub(crate) instance_group_types:
            std::option::Option<std::vec::Vec<crate::model::InstanceGroupType>>,
        pub(crate) instance_fleet_id: std::option::Option<std::string::String>,
        pub(crate) instance_fleet_type: std::option::Option<crate::model::InstanceFleetType>,
        pub(crate) instance_states: std::option::Option<std::vec::Vec<crate::model::InstanceState>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster for which to list the instances.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster for which to list the instances.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The identifier of the instance group for which to list the instances.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the instance group for which to list the instances.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_group_id = input;
            self
        }
        /// Appends an item to `instance_group_types`.
        ///
        /// To override the contents of this collection use [`set_instance_group_types`](Self::set_instance_group_types).
        ///
        /// <p>The type of instance group for which to list the instances.</p>
        pub fn instance_group_types(
            mut self,
            input: impl Into<crate::model::InstanceGroupType>,
        ) -> Self {
            let mut v = self.instance_group_types.unwrap_or_default();
            v.push(input.into());
            self.instance_group_types = Some(v);
            self
        }
        /// <p>The type of instance group for which to list the instances.</p>
        pub fn set_instance_group_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupType>>,
        ) -> Self {
            self.instance_group_types = input;
            self
        }
        /// <p>The unique identifier of the instance fleet.</p>
        pub fn instance_fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_fleet_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the instance fleet.</p>
        pub fn set_instance_fleet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_fleet_id = input;
            self
        }
        /// <p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>
        pub fn instance_fleet_type(mut self, input: crate::model::InstanceFleetType) -> Self {
            self.instance_fleet_type = Some(input);
            self
        }
        /// <p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>
        pub fn set_instance_fleet_type(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetType>,
        ) -> Self {
            self.instance_fleet_type = input;
            self
        }
        /// Appends an item to `instance_states`.
        ///
        /// To override the contents of this collection use [`set_instance_states`](Self::set_instance_states).
        ///
        /// <p>A list of instance states that will filter the instances returned with this
        /// request.</p>
        pub fn instance_states(mut self, input: impl Into<crate::model::InstanceState>) -> Self {
            let mut v = self.instance_states.unwrap_or_default();
            v.push(input.into());
            self.instance_states = Some(v);
            self
        }
        /// <p>A list of instance states that will filter the instances returned with this
        /// request.</p>
        pub fn set_instance_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceState>>,
        ) -> Self {
            self.instance_states = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstancesInput`](crate::input::ListInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstancesInput {
                cluster_id: self.cluster_id,
                instance_group_id: self.instance_group_id,
                instance_group_types: self.instance_group_types,
                instance_fleet_id: self.instance_fleet_id,
                instance_fleet_type: self.instance_fleet_type,
                instance_states: self.instance_states,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstancesInputOperationOutputAlias = crate::operation::ListInstances;
#[doc(hidden)]
pub type ListInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListInstances`](crate::operation::ListInstances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_instances(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstances",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstancesInput`](crate::input::ListInstancesInput)
    pub fn builder() -> crate::input::list_instances_input::Builder {
        crate::input::list_instances_input::Builder::default()
    }
}

/// See [`ListNotebookExecutionsInput`](crate::input::ListNotebookExecutionsInput)
pub mod list_notebook_executions_input {
    /// A builder for [`ListNotebookExecutionsInput`](crate::input::ListNotebookExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) editor_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NotebookExecutionStatus>,
        pub(crate) from: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) to: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the editor associated with the notebook execution.</p>
        pub fn editor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.editor_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the editor associated with the notebook execution.</p>
        pub fn set_editor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.editor_id = input;
            self
        }
        /// <p>The status filter for listing notebook executions.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START_PENDING</code> indicates that the cluster has received the execution
        /// request but execution has not begun.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STARTING</code> indicates that the execution is starting on the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> indicates that the execution is being processed by the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHING</code> indicates that execution processing is in the final
        /// stages.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHED</code> indicates that the execution has completed without
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILING</code> indicates that the execution is failing and will not finish
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> indicates that the execution failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_PENDING</code> indicates that the cluster has received a
        /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
        /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> indicates that the execution stopped because of a
        /// <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::NotebookExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status filter for listing notebook executions.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START_PENDING</code> indicates that the cluster has received the execution
        /// request but execution has not begun.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STARTING</code> indicates that the execution is starting on the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> indicates that the execution is being processed by the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHING</code> indicates that execution processing is in the final
        /// stages.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHED</code> indicates that the execution has completed without
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILING</code> indicates that the execution is failing and will not finish
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> indicates that the execution failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_PENDING</code> indicates that the cluster has received a
        /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
        /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> indicates that the execution stopped because of a
        /// <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotebookExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The beginning of time range filter for listing notebook executions. The default is the
        /// timestamp of 30 days ago.</p>
        pub fn from(mut self, input: aws_smithy_types::Instant) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The beginning of time range filter for listing notebook executions. The default is the
        /// timestamp of 30 days ago.</p>
        pub fn set_from(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.from = input;
            self
        }
        /// <p>The end of time range filter for listing notebook executions. The default is the current
        /// timestamp.</p>
        pub fn to(mut self, input: aws_smithy_types::Instant) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The end of time range filter for listing notebook executions. The default is the current
        /// timestamp.</p>
        pub fn set_to(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.to = input;
            self
        }
        /// <p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call,
        /// that indicates the start of the list for this <code>ListNotebookExecutions</code>
        /// call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call,
        /// that indicates the start of the list for this <code>ListNotebookExecutions</code>
        /// call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotebookExecutionsInput`](crate::input::ListNotebookExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNotebookExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNotebookExecutionsInput {
                editor_id: self.editor_id,
                status: self.status,
                from: self.from,
                to: self.to,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNotebookExecutionsInputOperationOutputAlias = crate::operation::ListNotebookExecutions;
#[doc(hidden)]
pub type ListNotebookExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListNotebookExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListNotebookExecutions`](crate::operation::ListNotebookExecutions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNotebookExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNotebookExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNotebookExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNotebookExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListNotebookExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_notebook_executions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNotebookExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNotebookExecutions",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNotebookExecutionsInput`](crate::input::ListNotebookExecutionsInput)
    pub fn builder() -> crate::input::list_notebook_executions_input::Builder {
        crate::input::list_notebook_executions_input::Builder::default()
    }
}

/// See [`ListReleaseLabelsInput`](crate::input::ListReleaseLabelsInput)
pub mod list_release_labels_input {
    /// A builder for [`ListReleaseLabelsInput`](crate::input::ListReleaseLabelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<crate::model::ReleaseLabelFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>
        pub fn filters(mut self, input: crate::model::ReleaseLabelFilter) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ReleaseLabelFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReleaseLabelsInput`](crate::input::ListReleaseLabelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReleaseLabelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReleaseLabelsInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReleaseLabelsInputOperationOutputAlias = crate::operation::ListReleaseLabels;
#[doc(hidden)]
pub type ListReleaseLabelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReleaseLabelsInput {
    /// Consumes the builder and constructs an Operation<[`ListReleaseLabels`](crate::operation::ListReleaseLabels)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReleaseLabels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReleaseLabelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReleaseLabelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReleaseLabelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListReleaseLabels",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_release_labels(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReleaseLabels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReleaseLabels",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReleaseLabelsInput`](crate::input::ListReleaseLabelsInput)
    pub fn builder() -> crate::input::list_release_labels_input::Builder {
        crate::input::list_release_labels_input::Builder::default()
    }
}

/// See [`ListSecurityConfigurationsInput`](crate::input::ListSecurityConfigurationsInput)
pub mod list_security_configurations_input {
    /// A builder for [`ListSecurityConfigurationsInput`](crate::input::ListSecurityConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityConfigurationsInput`](crate::input::ListSecurityConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSecurityConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSecurityConfigurationsInput {
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSecurityConfigurationsInputOperationOutputAlias =
    crate::operation::ListSecurityConfigurations;
#[doc(hidden)]
pub type ListSecurityConfigurationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSecurityConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListSecurityConfigurations`](crate::operation::ListSecurityConfigurations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSecurityConfigurations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSecurityConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSecurityConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSecurityConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListSecurityConfigurations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_security_configurations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSecurityConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSecurityConfigurations",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSecurityConfigurationsInput`](crate::input::ListSecurityConfigurationsInput)
    pub fn builder() -> crate::input::list_security_configurations_input::Builder {
        crate::input::list_security_configurations_input::Builder::default()
    }
}

/// See [`ListStepsInput`](crate::input::ListStepsInput)
pub mod list_steps_input {
    /// A builder for [`ListStepsInput`](crate::input::ListStepsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) step_states: std::option::Option<std::vec::Vec<crate::model::StepState>>,
        pub(crate) step_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster for which to list the steps.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster for which to list the steps.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Appends an item to `step_states`.
        ///
        /// To override the contents of this collection use [`set_step_states`](Self::set_step_states).
        ///
        /// <p>The filter to limit the step list based on certain states.</p>
        pub fn step_states(mut self, input: impl Into<crate::model::StepState>) -> Self {
            let mut v = self.step_states.unwrap_or_default();
            v.push(input.into());
            self.step_states = Some(v);
            self
        }
        /// <p>The filter to limit the step list based on certain states.</p>
        pub fn set_step_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepState>>,
        ) -> Self {
            self.step_states = input;
            self
        }
        /// Appends an item to `step_ids`.
        ///
        /// To override the contents of this collection use [`set_step_ids`](Self::set_step_ids).
        ///
        /// <p>The filter to limit the step list based on the identifier of the steps. You can specify
        /// a maximum of ten Step IDs. The character constraint applies to the overall length of the
        /// array.</p>
        pub fn step_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.step_ids.unwrap_or_default();
            v.push(input.into());
            self.step_ids = Some(v);
            self
        }
        /// <p>The filter to limit the step list based on the identifier of the steps. You can specify
        /// a maximum of ten Step IDs. The character constraint applies to the overall length of the
        /// array.</p>
        pub fn set_step_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.step_ids = input;
            self
        }
        /// <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStepsInput`](crate::input::ListStepsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListStepsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListStepsInput {
                cluster_id: self.cluster_id,
                step_states: self.step_states,
                step_ids: self.step_ids,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStepsInputOperationOutputAlias = crate::operation::ListSteps;
#[doc(hidden)]
pub type ListStepsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStepsInput {
    /// Consumes the builder and constructs an Operation<[`ListSteps`](crate::operation::ListSteps)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSteps,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStepsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStepsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStepsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListSteps",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_steps(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListSteps::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListSteps",
                    "emr",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStepsInput`](crate::input::ListStepsInput)
    pub fn builder() -> crate::input::list_steps_input::Builder {
        crate::input::list_steps_input::Builder::default()
    }
}

/// See [`ListStudiosInput`](crate::input::ListStudiosInput)
pub mod list_studios_input {
    /// A builder for [`ListStudiosInput`](crate::input::ListStudiosInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStudiosInput`](crate::input::ListStudiosInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStudiosInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStudiosInput {
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStudiosInputOperationOutputAlias = crate::operation::ListStudios;
#[doc(hidden)]
pub type ListStudiosInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStudiosInput {
    /// Consumes the builder and constructs an Operation<[`ListStudios`](crate::operation::ListStudios)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStudios,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStudiosInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStudiosInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStudiosInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListStudios",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_studios(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStudios::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStudios",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStudiosInput`](crate::input::ListStudiosInput)
    pub fn builder() -> crate::input::list_studios_input::Builder {
        crate::input::list_studios_input::Builder::default()
    }
}

/// See [`ListStudioSessionMappingsInput`](crate::input::ListStudioSessionMappingsInput)
pub mod list_studio_session_mappings_input {
    /// A builder for [`ListStudioSessionMappingsInput`](crate::input::ListStudioSessionMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>Specifies whether to return session mappings for users or groups. If not specified, the
        /// results include session mapping details for both users and groups.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Specifies whether to return session mappings for users or groups. If not specified, the
        /// results include session mapping details for both users and groups.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the set of results to retrieve.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStudioSessionMappingsInput`](crate::input::ListStudioSessionMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStudioSessionMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStudioSessionMappingsInput {
                studio_id: self.studio_id,
                identity_type: self.identity_type,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStudioSessionMappingsInputOperationOutputAlias =
    crate::operation::ListStudioSessionMappings;
#[doc(hidden)]
pub type ListStudioSessionMappingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStudioSessionMappingsInput {
    /// Consumes the builder and constructs an Operation<[`ListStudioSessionMappings`](crate::operation::ListStudioSessionMappings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStudioSessionMappings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStudioSessionMappingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStudioSessionMappingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStudioSessionMappingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ListStudioSessionMappings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_studio_session_mappings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStudioSessionMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStudioSessionMappings",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStudioSessionMappingsInput`](crate::input::ListStudioSessionMappingsInput)
    pub fn builder() -> crate::input::list_studio_session_mappings_input::Builder {
        crate::input::list_studio_session_mappings_input::Builder::default()
    }
}

/// See [`ModifyClusterInput`](crate::input::ModifyClusterInput)
pub mod modify_cluster_input {
    /// A builder for [`ModifyClusterInput`](crate::input::ModifyClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) step_concurrency_level: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <a>Step$ActionOnFailure</a>.</p>
        pub fn step_concurrency_level(mut self, input: i32) -> Self {
            self.step_concurrency_level = Some(input);
            self
        }
        /// <p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <a>Step$ActionOnFailure</a>.</p>
        pub fn set_step_concurrency_level(mut self, input: std::option::Option<i32>) -> Self {
            self.step_concurrency_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterInput`](crate::input::ModifyClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterInput {
                cluster_id: self.cluster_id,
                step_concurrency_level: self.step_concurrency_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterInputOperationOutputAlias = crate::operation::ModifyCluster;
#[doc(hidden)]
pub type ModifyClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterInput {
    /// Consumes the builder and constructs an Operation<[`ModifyCluster`](crate::operation::ModifyCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ModifyCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyCluster",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterInput`](crate::input::ModifyClusterInput)
    pub fn builder() -> crate::input::modify_cluster_input::Builder {
        crate::input::modify_cluster_input::Builder::default()
    }
}

/// See [`ModifyInstanceFleetInput`](crate::input::ModifyInstanceFleetInput)
pub mod modify_instance_fleet_input {
    /// A builder for [`ModifyInstanceFleetInput`](crate::input::ModifyInstanceFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) instance_fleet: std::option::Option<crate::model::InstanceFleetModifyConfig>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The configuration parameters of the instance fleet.</p>
        pub fn instance_fleet(mut self, input: crate::model::InstanceFleetModifyConfig) -> Self {
            self.instance_fleet = Some(input);
            self
        }
        /// <p>The configuration parameters of the instance fleet.</p>
        pub fn set_instance_fleet(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetModifyConfig>,
        ) -> Self {
            self.instance_fleet = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyInstanceFleetInput`](crate::input::ModifyInstanceFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyInstanceFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyInstanceFleetInput {
                cluster_id: self.cluster_id,
                instance_fleet: self.instance_fleet,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyInstanceFleetInputOperationOutputAlias = crate::operation::ModifyInstanceFleet;
#[doc(hidden)]
pub type ModifyInstanceFleetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyInstanceFleetInput {
    /// Consumes the builder and constructs an Operation<[`ModifyInstanceFleet`](crate::operation::ModifyInstanceFleet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyInstanceFleet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyInstanceFleetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyInstanceFleetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyInstanceFleetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ModifyInstanceFleet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_instance_fleet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyInstanceFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyInstanceFleet",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyInstanceFleetInput`](crate::input::ModifyInstanceFleetInput)
    pub fn builder() -> crate::input::modify_instance_fleet_input::Builder {
        crate::input::modify_instance_fleet_input::Builder::default()
    }
}

/// See [`ModifyInstanceGroupsInput`](crate::input::ModifyInstanceGroupsInput)
pub mod modify_instance_groups_input {
    /// A builder for [`ModifyInstanceGroupsInput`](crate::input::ModifyInstanceGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) instance_groups:
            std::option::Option<std::vec::Vec<crate::model::InstanceGroupModifyConfig>>,
    }
    impl Builder {
        /// <p>The ID of the cluster to which the instance group belongs.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the cluster to which the instance group belongs.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Appends an item to `instance_groups`.
        ///
        /// To override the contents of this collection use [`set_instance_groups`](Self::set_instance_groups).
        ///
        /// <p>Instance groups to change.</p>
        pub fn instance_groups(
            mut self,
            input: impl Into<crate::model::InstanceGroupModifyConfig>,
        ) -> Self {
            let mut v = self.instance_groups.unwrap_or_default();
            v.push(input.into());
            self.instance_groups = Some(v);
            self
        }
        /// <p>Instance groups to change.</p>
        pub fn set_instance_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupModifyConfig>>,
        ) -> Self {
            self.instance_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyInstanceGroupsInput`](crate::input::ModifyInstanceGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyInstanceGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyInstanceGroupsInput {
                cluster_id: self.cluster_id,
                instance_groups: self.instance_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyInstanceGroupsInputOperationOutputAlias = crate::operation::ModifyInstanceGroups;
#[doc(hidden)]
pub type ModifyInstanceGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyInstanceGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ModifyInstanceGroups`](crate::operation::ModifyInstanceGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyInstanceGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyInstanceGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyInstanceGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyInstanceGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.ModifyInstanceGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_instance_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyInstanceGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyInstanceGroups",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyInstanceGroupsInput`](crate::input::ModifyInstanceGroupsInput)
    pub fn builder() -> crate::input::modify_instance_groups_input::Builder {
        crate::input::modify_instance_groups_input::Builder::default()
    }
}

/// See [`PutAutoScalingPolicyInput`](crate::input::PutAutoScalingPolicyInput)
pub mod put_auto_scaling_policy_input {
    /// A builder for [`PutAutoScalingPolicyInput`](crate::input::PutAutoScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) instance_group_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_policy: std::option::Option<crate::model::AutoScalingPolicy>,
    }
    impl Builder {
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
        /// is applied is within this cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
        /// is applied is within this cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>Specifies the ID of the instance group to which the automatic scaling policy is
        /// applied.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_group_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the instance group to which the automatic scaling policy is
        /// applied.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_group_id = input;
            self
        }
        /// <p>Specifies the definition of the automatic scaling policy.</p>
        pub fn auto_scaling_policy(mut self, input: crate::model::AutoScalingPolicy) -> Self {
            self.auto_scaling_policy = Some(input);
            self
        }
        /// <p>Specifies the definition of the automatic scaling policy.</p>
        pub fn set_auto_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicy>,
        ) -> Self {
            self.auto_scaling_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAutoScalingPolicyInput`](crate::input::PutAutoScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAutoScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAutoScalingPolicyInput {
                cluster_id: self.cluster_id,
                instance_group_id: self.instance_group_id,
                auto_scaling_policy: self.auto_scaling_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAutoScalingPolicyInputOperationOutputAlias = crate::operation::PutAutoScalingPolicy;
#[doc(hidden)]
pub type PutAutoScalingPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutAutoScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutAutoScalingPolicy`](crate::operation::PutAutoScalingPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAutoScalingPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAutoScalingPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAutoScalingPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAutoScalingPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.PutAutoScalingPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_auto_scaling_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAutoScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAutoScalingPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAutoScalingPolicyInput`](crate::input::PutAutoScalingPolicyInput)
    pub fn builder() -> crate::input::put_auto_scaling_policy_input::Builder {
        crate::input::put_auto_scaling_policy_input::Builder::default()
    }
}

/// See [`PutAutoTerminationPolicyInput`](crate::input::PutAutoTerminationPolicyInput)
pub mod put_auto_termination_policy_input {
    /// A builder for [`PutAutoTerminationPolicyInput`](crate::input::PutAutoTerminationPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) auto_termination_policy:
            std::option::Option<crate::model::AutoTerminationPolicy>,
    }
    impl Builder {
        /// <p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>Specifies the auto-termination policy to attach to the cluster.</p>
        pub fn auto_termination_policy(
            mut self,
            input: crate::model::AutoTerminationPolicy,
        ) -> Self {
            self.auto_termination_policy = Some(input);
            self
        }
        /// <p>Specifies the auto-termination policy to attach to the cluster.</p>
        pub fn set_auto_termination_policy(
            mut self,
            input: std::option::Option<crate::model::AutoTerminationPolicy>,
        ) -> Self {
            self.auto_termination_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAutoTerminationPolicyInput`](crate::input::PutAutoTerminationPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAutoTerminationPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAutoTerminationPolicyInput {
                cluster_id: self.cluster_id,
                auto_termination_policy: self.auto_termination_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAutoTerminationPolicyInputOperationOutputAlias =
    crate::operation::PutAutoTerminationPolicy;
#[doc(hidden)]
pub type PutAutoTerminationPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutAutoTerminationPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutAutoTerminationPolicy`](crate::operation::PutAutoTerminationPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAutoTerminationPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAutoTerminationPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAutoTerminationPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAutoTerminationPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.PutAutoTerminationPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_auto_termination_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAutoTerminationPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAutoTerminationPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAutoTerminationPolicyInput`](crate::input::PutAutoTerminationPolicyInput)
    pub fn builder() -> crate::input::put_auto_termination_policy_input::Builder {
        crate::input::put_auto_termination_policy_input::Builder::default()
    }
}

/// See [`PutBlockPublicAccessConfigurationInput`](crate::input::PutBlockPublicAccessConfigurationInput)
pub mod put_block_public_access_configuration_input {
    /// A builder for [`PutBlockPublicAccessConfigurationInput`](crate::input::PutBlockPublicAccessConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_public_access_configuration:
            std::option::Option<crate::model::BlockPublicAccessConfiguration>,
    }
    impl Builder {
        /// <p>A configuration for Amazon EMR block public access. The configuration applies to all
        /// clusters created in your account for the current Region. The configuration specifies
        /// whether block public access is enabled. If block public access is enabled, security groups
        /// associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or
        /// ::/0 on a port, unless the port is specified as an exception using
        /// <code>PermittedPublicSecurityGroupRuleRanges</code> in the
        /// <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception,
        /// and public access is allowed on this port. You can change this by updating
        /// <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p>
        /// <note>
        /// <p>For accounts that created clusters in a Region before November 25, 2019, block public
        /// access is disabled by default in that Region. To use this feature, you must manually
        /// enable and configure it. For accounts that did not create an EMR cluster in a Region
        /// before this date, block public access is enabled by default in that Region.</p>
        /// </note>
        pub fn block_public_access_configuration(
            mut self,
            input: crate::model::BlockPublicAccessConfiguration,
        ) -> Self {
            self.block_public_access_configuration = Some(input);
            self
        }
        /// <p>A configuration for Amazon EMR block public access. The configuration applies to all
        /// clusters created in your account for the current Region. The configuration specifies
        /// whether block public access is enabled. If block public access is enabled, security groups
        /// associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or
        /// ::/0 on a port, unless the port is specified as an exception using
        /// <code>PermittedPublicSecurityGroupRuleRanges</code> in the
        /// <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception,
        /// and public access is allowed on this port. You can change this by updating
        /// <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p>
        /// <note>
        /// <p>For accounts that created clusters in a Region before November 25, 2019, block public
        /// access is disabled by default in that Region. To use this feature, you must manually
        /// enable and configure it. For accounts that did not create an EMR cluster in a Region
        /// before this date, block public access is enabled by default in that Region.</p>
        /// </note>
        pub fn set_block_public_access_configuration(
            mut self,
            input: std::option::Option<crate::model::BlockPublicAccessConfiguration>,
        ) -> Self {
            self.block_public_access_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBlockPublicAccessConfigurationInput`](crate::input::PutBlockPublicAccessConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBlockPublicAccessConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBlockPublicAccessConfigurationInput {
                block_public_access_configuration: self.block_public_access_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBlockPublicAccessConfigurationInputOperationOutputAlias =
    crate::operation::PutBlockPublicAccessConfiguration;
#[doc(hidden)]
pub type PutBlockPublicAccessConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutBlockPublicAccessConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBlockPublicAccessConfiguration`](crate::operation::PutBlockPublicAccessConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBlockPublicAccessConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBlockPublicAccessConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBlockPublicAccessConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBlockPublicAccessConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.PutBlockPublicAccessConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_block_public_access_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBlockPublicAccessConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBlockPublicAccessConfiguration",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBlockPublicAccessConfigurationInput`](crate::input::PutBlockPublicAccessConfigurationInput)
    pub fn builder() -> crate::input::put_block_public_access_configuration_input::Builder {
        crate::input::put_block_public_access_configuration_input::Builder::default()
    }
}

/// See [`PutManagedScalingPolicyInput`](crate::input::PutManagedScalingPolicyInput)
pub mod put_managed_scaling_policy_input {
    /// A builder for [`PutManagedScalingPolicyInput`](crate::input::PutManagedScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) managed_scaling_policy: std::option::Option<crate::model::ManagedScalingPolicy>,
    }
    impl Builder {
        /// <p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>Specifies the constraints for the managed scaling policy. </p>
        pub fn managed_scaling_policy(mut self, input: crate::model::ManagedScalingPolicy) -> Self {
            self.managed_scaling_policy = Some(input);
            self
        }
        /// <p>Specifies the constraints for the managed scaling policy. </p>
        pub fn set_managed_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::ManagedScalingPolicy>,
        ) -> Self {
            self.managed_scaling_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutManagedScalingPolicyInput`](crate::input::PutManagedScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutManagedScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutManagedScalingPolicyInput {
                cluster_id: self.cluster_id,
                managed_scaling_policy: self.managed_scaling_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutManagedScalingPolicyInputOperationOutputAlias =
    crate::operation::PutManagedScalingPolicy;
#[doc(hidden)]
pub type PutManagedScalingPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutManagedScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutManagedScalingPolicy`](crate::operation::PutManagedScalingPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutManagedScalingPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutManagedScalingPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutManagedScalingPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutManagedScalingPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.PutManagedScalingPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_managed_scaling_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutManagedScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutManagedScalingPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutManagedScalingPolicyInput`](crate::input::PutManagedScalingPolicyInput)
    pub fn builder() -> crate::input::put_managed_scaling_policy_input::Builder {
        crate::input::put_managed_scaling_policy_input::Builder::default()
    }
}

/// See [`RemoveAutoScalingPolicyInput`](crate::input::RemoveAutoScalingPolicyInput)
pub mod remove_auto_scaling_policy_input {
    /// A builder for [`RemoveAutoScalingPolicyInput`](crate::input::RemoveAutoScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) instance_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
        /// is applied is within this cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
        /// is applied is within this cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_group_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAutoScalingPolicyInput`](crate::input::RemoveAutoScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAutoScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAutoScalingPolicyInput {
                cluster_id: self.cluster_id,
                instance_group_id: self.instance_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAutoScalingPolicyInputOperationOutputAlias =
    crate::operation::RemoveAutoScalingPolicy;
#[doc(hidden)]
pub type RemoveAutoScalingPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveAutoScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAutoScalingPolicy`](crate::operation::RemoveAutoScalingPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAutoScalingPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveAutoScalingPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveAutoScalingPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveAutoScalingPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.RemoveAutoScalingPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_auto_scaling_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAutoScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAutoScalingPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveAutoScalingPolicyInput`](crate::input::RemoveAutoScalingPolicyInput)
    pub fn builder() -> crate::input::remove_auto_scaling_policy_input::Builder {
        crate::input::remove_auto_scaling_policy_input::Builder::default()
    }
}

/// See [`RemoveAutoTerminationPolicyInput`](crate::input::RemoveAutoTerminationPolicyInput)
pub mod remove_auto_termination_policy_input {
    /// A builder for [`RemoveAutoTerminationPolicyInput`](crate::input::RemoveAutoTerminationPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAutoTerminationPolicyInput`](crate::input::RemoveAutoTerminationPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAutoTerminationPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAutoTerminationPolicyInput {
                cluster_id: self.cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAutoTerminationPolicyInputOperationOutputAlias =
    crate::operation::RemoveAutoTerminationPolicy;
#[doc(hidden)]
pub type RemoveAutoTerminationPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveAutoTerminationPolicyInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAutoTerminationPolicy`](crate::operation::RemoveAutoTerminationPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAutoTerminationPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveAutoTerminationPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveAutoTerminationPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveAutoTerminationPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.RemoveAutoTerminationPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_auto_termination_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAutoTerminationPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAutoTerminationPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveAutoTerminationPolicyInput`](crate::input::RemoveAutoTerminationPolicyInput)
    pub fn builder() -> crate::input::remove_auto_termination_policy_input::Builder {
        crate::input::remove_auto_termination_policy_input::Builder::default()
    }
}

/// See [`RemoveManagedScalingPolicyInput`](crate::input::RemoveManagedScalingPolicyInput)
pub mod remove_managed_scaling_policy_input {
    /// A builder for [`RemoveManagedScalingPolicyInput`](crate::input::RemoveManagedScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies the ID of the cluster from which the managed scaling policy will be removed.
        /// </p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p> Specifies the ID of the cluster from which the managed scaling policy will be removed.
        /// </p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveManagedScalingPolicyInput`](crate::input::RemoveManagedScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveManagedScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveManagedScalingPolicyInput {
                cluster_id: self.cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveManagedScalingPolicyInputOperationOutputAlias =
    crate::operation::RemoveManagedScalingPolicy;
#[doc(hidden)]
pub type RemoveManagedScalingPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveManagedScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`RemoveManagedScalingPolicy`](crate::operation::RemoveManagedScalingPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveManagedScalingPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveManagedScalingPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveManagedScalingPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveManagedScalingPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.RemoveManagedScalingPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_managed_scaling_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveManagedScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveManagedScalingPolicy",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveManagedScalingPolicyInput`](crate::input::RemoveManagedScalingPolicyInput)
    pub fn builder() -> crate::input::remove_managed_scaling_policy_input::Builder {
        crate::input::remove_managed_scaling_policy_input::Builder::default()
    }
}

/// See [`RemoveTagsInput`](crate::input::RemoveTagsInput)
pub mod remove_tags_input {
    /// A builder for [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon EMR resource identifier from which tags will be removed. For example, a
        /// cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The Amazon EMR resource identifier from which tags will be removed. For example, a
        /// cluster identifier or an Amazon EMR Studio ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsInput`](crate::input::RemoveTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsInput {
                resource_id: self.resource_id,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsInputOperationOutputAlias = crate::operation::RemoveTags;
#[doc(hidden)]
pub type RemoveTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTags`](crate::operation::RemoveTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.RemoveTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_remove_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTags",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
}

/// See [`RunJobFlowInput`](crate::input::RunJobFlowInput)
pub mod run_job_flow_input {
    /// A builder for [`RunJobFlowInput`](crate::input::RunJobFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) log_encryption_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) additional_info: std::option::Option<std::string::String>,
        pub(crate) ami_version: std::option::Option<std::string::String>,
        pub(crate) release_label: std::option::Option<std::string::String>,
        pub(crate) instances: std::option::Option<crate::model::JobFlowInstancesConfig>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
        pub(crate) bootstrap_actions:
            std::option::Option<std::vec::Vec<crate::model::BootstrapActionConfig>>,
        pub(crate) supported_products: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) new_supported_products:
            std::option::Option<std::vec::Vec<crate::model::SupportedProductConfig>>,
        pub(crate) applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) visible_to_all_users: std::option::Option<bool>,
        pub(crate) job_flow_role: std::option::Option<std::string::String>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_role: std::option::Option<std::string::String>,
        pub(crate) scale_down_behavior: std::option::Option<crate::model::ScaleDownBehavior>,
        pub(crate) custom_ami_id: std::option::Option<std::string::String>,
        pub(crate) ebs_root_volume_size: std::option::Option<i32>,
        pub(crate) repo_upgrade_on_boot: std::option::Option<crate::model::RepoUpgradeOnBoot>,
        pub(crate) kerberos_attributes: std::option::Option<crate::model::KerberosAttributes>,
        pub(crate) step_concurrency_level: std::option::Option<i32>,
        pub(crate) managed_scaling_policy: std::option::Option<crate::model::ManagedScalingPolicy>,
        pub(crate) placement_group_configs:
            std::option::Option<std::vec::Vec<crate::model::PlacementGroupConfig>>,
        pub(crate) auto_termination_policy:
            std::option::Option<crate::model::AutoTerminationPolicy>,
    }
    impl Builder {
        /// <p>The name of the job flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The location in Amazon S3 to write the log files of the job flow. If a value is not
        /// provided, logs are not created.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>The location in Amazon S3 to write the log files of the job flow. If a value is not
        /// provided, logs are not created.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>The KMS key used for encrypting log files. If a value is not
        /// provided, the logs remain encrypted by AES-256. This attribute is only available with
        /// Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>
        pub fn log_encryption_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_encryption_kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key used for encrypting log files. If a value is not
        /// provided, the logs remain encrypted by AES-256. This attribute is only available with
        /// Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>
        pub fn set_log_encryption_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_encryption_kms_key_id = input;
            self
        }
        /// <p>A JSON string for selecting additional features.</p>
        pub fn additional_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_info = Some(input.into());
            self
        }
        /// <p>A JSON string for selecting additional features.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_info = input;
            self
        }
        /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
        /// later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use
        /// <code>CustomAmiID</code>.</p>
        pub fn ami_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_version = Some(input.into());
            self
        }
        /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
        /// later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use
        /// <code>CustomAmiID</code>.</p>
        pub fn set_ami_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_version = input;
            self
        }
        /// <p>The Amazon EMR release label, which determines the version of open-source application
        /// packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>,
        /// where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more
        /// information about Amazon EMR release versions and included application versions and
        /// features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release
        /// label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
        /// <code>AmiVersion</code>.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_label = Some(input.into());
            self
        }
        /// <p>The Amazon EMR release label, which determines the version of open-source application
        /// packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>,
        /// where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more
        /// information about Amazon EMR release versions and included application versions and
        /// features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release
        /// label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
        /// <code>AmiVersion</code>.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_label = input;
            self
        }
        /// <p>A specification of the number and type of Amazon EC2 instances.</p>
        pub fn instances(mut self, input: crate::model::JobFlowInstancesConfig) -> Self {
            self.instances = Some(input);
            self
        }
        /// <p>A specification of the number and type of Amazon EC2 instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<crate::model::JobFlowInstancesConfig>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>A list of steps to run.</p>
        pub fn steps(mut self, input: impl Into<crate::model::StepConfig>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p>A list of steps to run.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Appends an item to `bootstrap_actions`.
        ///
        /// To override the contents of this collection use [`set_bootstrap_actions`](Self::set_bootstrap_actions).
        ///
        /// <p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>
        pub fn bootstrap_actions(
            mut self,
            input: impl Into<crate::model::BootstrapActionConfig>,
        ) -> Self {
            let mut v = self.bootstrap_actions.unwrap_or_default();
            v.push(input.into());
            self.bootstrap_actions = Some(v);
            self
        }
        /// <p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>
        pub fn set_bootstrap_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BootstrapActionConfig>>,
        ) -> Self {
            self.bootstrap_actions = input;
            self
        }
        /// Appends an item to `supported_products`.
        ///
        /// To override the contents of this collection use [`set_supported_products`](Self::set_supported_products).
        ///
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
        /// Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use. For more information, see
        /// the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR
        /// Developer Guide</a>. Currently supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p>
        /// </li>
        /// </ul>
        pub fn supported_products(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_products.unwrap_or_default();
            v.push(input.into());
            self.supported_products = Some(v);
            self
        }
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
        /// Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use. For more information, see
        /// the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR
        /// Developer Guide</a>. Currently supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p>
        /// </li>
        /// </ul>
        pub fn set_supported_products(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_products = input;
            self
        }
        /// Appends an item to `new_supported_products`.
        ///
        /// To override the contents of this collection use [`set_new_supported_products`](Self::set_new_supported_products).
        ///
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
        /// Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use with the job flow that
        /// accepts a user argument list. EMR accepts and forwards the argument list to the
        /// corresponding installation script as bootstrap action arguments. For more information, see
        /// "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported
        /// values are:</p>
        /// <ul>
        /// <li>
        /// <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" -
        /// launch the job flow using MapR M3 or M5 Edition respectively.</p>
        /// </li>
        /// <li>
        /// <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p>
        /// </li>
        /// <li>
        /// <p>"hue"- launch the cluster with Hue installed.</p>
        /// </li>
        /// <li>
        /// <p>"spark" - launch the cluster with Apache Spark installed.</p>
        /// </li>
        /// <li>
        /// <p>"ganglia" - launch the cluster with the Ganglia Monitoring System
        /// installed.</p>
        /// </li>
        /// </ul>
        pub fn new_supported_products(
            mut self,
            input: impl Into<crate::model::SupportedProductConfig>,
        ) -> Self {
            let mut v = self.new_supported_products.unwrap_or_default();
            v.push(input.into());
            self.new_supported_products = Some(v);
            self
        }
        /// <note>
        /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
        /// Applications.</p>
        /// </note>
        /// <p>A list of strings that indicates third-party software to use with the job flow that
        /// accepts a user argument list. EMR accepts and forwards the argument list to the
        /// corresponding installation script as bootstrap action arguments. For more information, see
        /// "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported
        /// values are:</p>
        /// <ul>
        /// <li>
        /// <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" -
        /// launch the job flow using MapR M3 or M5 Edition respectively.</p>
        /// </li>
        /// <li>
        /// <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p>
        /// </li>
        /// <li>
        /// <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p>
        /// </li>
        /// <li>
        /// <p>"hue"- launch the cluster with Hue installed.</p>
        /// </li>
        /// <li>
        /// <p>"spark" - launch the cluster with Apache Spark installed.</p>
        /// </li>
        /// <li>
        /// <p>"ganglia" - launch the cluster with the Ganglia Monitoring System
        /// installed.</p>
        /// </li>
        /// </ul>
        pub fn set_new_supported_products(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupportedProductConfig>>,
        ) -> Self {
            self.new_supported_products = input;
            self
        }
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications
        /// for Amazon EMR to install and configure when launching the cluster. For a list of
        /// applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMR Release
        /// Guide</a>.</p>
        pub fn applications(mut self, input: impl Into<crate::model::Application>) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input.into());
            self.applications = Some(v);
            self
        }
        /// <p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications
        /// for Amazon EMR to install and configure when launching the cluster. For a list of
        /// applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMR Release
        /// Guide</a>.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR
        /// cluster you are creating.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR
        /// cluster you are creating.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p>
        /// <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn visible_to_all_users(mut self, input: bool) -> Self {
            self.visible_to_all_users = Some(input);
            self
        }
        /// <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p>
        /// <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn set_visible_to_all_users(mut self, input: std::option::Option<bool>) -> Self {
            self.visible_to_all_users = input;
            self
        }
        /// <p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2
        /// instances of the cluster assume this role. The default role is
        /// <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have
        /// already created it using the CLI or console.</p>
        pub fn job_flow_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_flow_role = Some(input.into());
            self
        }
        /// <p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2
        /// instances of the cluster assume this role. The default role is
        /// <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have
        /// already created it using the CLI or console.</p>
        pub fn set_job_flow_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_flow_role = input;
            self
        }
        /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
        /// your behalf.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
        /// your behalf.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of a security configuration to apply to the cluster.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of a security configuration to apply to the cluster.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is
        /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the
        /// automatic scaling feature requires to launch and terminate EC2 instances in an instance
        /// group.</p>
        pub fn auto_scaling_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_role = Some(input.into());
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is
        /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the
        /// automatic scaling feature requires to launch and terminate EC2 instances in an instance
        /// group.</p>
        pub fn set_auto_scaling_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_role = input;
            self
        }
        /// <p>Specifies the way that individual Amazon EC2 instances terminate when an automatic
        /// scale-in activity occurs or an instance group is resized.
        /// <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at
        /// the instance-hour boundary, regardless of when the request to terminate the instance was
        /// submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default
        /// for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code>
        /// indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
        /// terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
        /// behavior, Amazon EMR removes the least active nodes first and blocks instance termination
        /// if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available
        /// only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR
        /// earlier than 5.1.0.</p>
        pub fn scale_down_behavior(mut self, input: crate::model::ScaleDownBehavior) -> Self {
            self.scale_down_behavior = Some(input);
            self
        }
        /// <p>Specifies the way that individual Amazon EC2 instances terminate when an automatic
        /// scale-in activity occurs or an instance group is resized.
        /// <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at
        /// the instance-hour boundary, regardless of when the request to terminate the instance was
        /// submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default
        /// for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code>
        /// indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
        /// terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
        /// behavior, Amazon EMR removes the least active nodes first and blocks instance termination
        /// if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available
        /// only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR
        /// earlier than 5.1.0.</p>
        pub fn set_scale_down_behavior(
            mut self,
            input: std::option::Option<crate::model::ScaleDownBehavior>,
        ) -> Self {
            self.scale_down_behavior = input;
            self
        }
        /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
        /// EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2
        /// instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom
        /// AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the
        /// cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR
        /// versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p>
        /// <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed
        /// Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux
        /// Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux
        /// AMI</a>. </p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_ami_id = Some(input.into());
            self
        }
        /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
        /// EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2
        /// instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom
        /// AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the
        /// cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR
        /// versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p>
        /// <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed
        /// Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux
        /// Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux
        /// AMI</a>. </p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_ami_id = input;
            self
        }
        /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
        /// each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
        pub fn ebs_root_volume_size(mut self, input: i32) -> Self {
            self.ebs_root_volume_size = Some(input);
            self
        }
        /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
        /// each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
        pub fn set_ebs_root_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.ebs_root_volume_size = input;
            self
        }
        /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the
        /// Amazon Linux AMI package repositories to apply automatically when the instance boots using
        /// the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only
        /// security updates are applied. If <code>NONE</code> is specified, no updates are applied,
        /// and all updates must be applied manually.</p>
        pub fn repo_upgrade_on_boot(mut self, input: crate::model::RepoUpgradeOnBoot) -> Self {
            self.repo_upgrade_on_boot = Some(input);
            self
        }
        /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the
        /// Amazon Linux AMI package repositories to apply automatically when the instance boots using
        /// the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only
        /// security updates are applied. If <code>NONE</code> is specified, no updates are applied,
        /// and all updates must be applied manually.</p>
        pub fn set_repo_upgrade_on_boot(
            mut self,
            input: std::option::Option<crate::model::RepoUpgradeOnBoot>,
        ) -> Self {
            self.repo_upgrade_on_boot = input;
            self
        }
        /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
        /// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
        /// in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn kerberos_attributes(mut self, input: crate::model::KerberosAttributes) -> Self {
            self.kerberos_attributes = Some(input);
            self
        }
        /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
        /// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
        /// in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn set_kerberos_attributes(
            mut self,
            input: std::option::Option<crate::model::KerberosAttributes>,
        ) -> Self {
            self.kerberos_attributes = input;
            self
        }
        /// <p>Specifies the number of steps that can be executed concurrently. The default value is
        /// <code>1</code>. The maximum value is <code>256</code>.</p>
        pub fn step_concurrency_level(mut self, input: i32) -> Self {
            self.step_concurrency_level = Some(input);
            self
        }
        /// <p>Specifies the number of steps that can be executed concurrently. The default value is
        /// <code>1</code>. The maximum value is <code>256</code>.</p>
        pub fn set_step_concurrency_level(mut self, input: std::option::Option<i32>) -> Self {
            self.step_concurrency_level = input;
            self
        }
        /// <p> The specified managed scaling policy for an Amazon EMR cluster. </p>
        pub fn managed_scaling_policy(mut self, input: crate::model::ManagedScalingPolicy) -> Self {
            self.managed_scaling_policy = Some(input);
            self
        }
        /// <p> The specified managed scaling policy for an Amazon EMR cluster. </p>
        pub fn set_managed_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::ManagedScalingPolicy>,
        ) -> Self {
            self.managed_scaling_policy = input;
            self
        }
        /// Appends an item to `placement_group_configs`.
        ///
        /// To override the contents of this collection use [`set_placement_group_configs`](Self::set_placement_group_configs).
        ///
        /// <p>The specified placement group configuration for an Amazon EMR cluster.</p>
        pub fn placement_group_configs(
            mut self,
            input: impl Into<crate::model::PlacementGroupConfig>,
        ) -> Self {
            let mut v = self.placement_group_configs.unwrap_or_default();
            v.push(input.into());
            self.placement_group_configs = Some(v);
            self
        }
        /// <p>The specified placement group configuration for an Amazon EMR cluster.</p>
        pub fn set_placement_group_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementGroupConfig>>,
        ) -> Self {
            self.placement_group_configs = input;
            self
        }
        /// <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
        pub fn auto_termination_policy(
            mut self,
            input: crate::model::AutoTerminationPolicy,
        ) -> Self {
            self.auto_termination_policy = Some(input);
            self
        }
        /// <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
        pub fn set_auto_termination_policy(
            mut self,
            input: std::option::Option<crate::model::AutoTerminationPolicy>,
        ) -> Self {
            self.auto_termination_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`RunJobFlowInput`](crate::input::RunJobFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RunJobFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RunJobFlowInput {
                name: self.name,
                log_uri: self.log_uri,
                log_encryption_kms_key_id: self.log_encryption_kms_key_id,
                additional_info: self.additional_info,
                ami_version: self.ami_version,
                release_label: self.release_label,
                instances: self.instances,
                steps: self.steps,
                bootstrap_actions: self.bootstrap_actions,
                supported_products: self.supported_products,
                new_supported_products: self.new_supported_products,
                applications: self.applications,
                configurations: self.configurations,
                visible_to_all_users: self.visible_to_all_users.unwrap_or_default(),
                job_flow_role: self.job_flow_role,
                service_role: self.service_role,
                tags: self.tags,
                security_configuration: self.security_configuration,
                auto_scaling_role: self.auto_scaling_role,
                scale_down_behavior: self.scale_down_behavior,
                custom_ami_id: self.custom_ami_id,
                ebs_root_volume_size: self.ebs_root_volume_size,
                repo_upgrade_on_boot: self.repo_upgrade_on_boot,
                kerberos_attributes: self.kerberos_attributes,
                step_concurrency_level: self.step_concurrency_level,
                managed_scaling_policy: self.managed_scaling_policy,
                placement_group_configs: self.placement_group_configs,
                auto_termination_policy: self.auto_termination_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type RunJobFlowInputOperationOutputAlias = crate::operation::RunJobFlow;
#[doc(hidden)]
pub type RunJobFlowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RunJobFlowInput {
    /// Consumes the builder and constructs an Operation<[`RunJobFlow`](crate::operation::RunJobFlow)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RunJobFlow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RunJobFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RunJobFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RunJobFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.RunJobFlow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_run_job_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RunJobFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RunJobFlow",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RunJobFlowInput`](crate::input::RunJobFlowInput)
    pub fn builder() -> crate::input::run_job_flow_input::Builder {
        crate::input::run_job_flow_input::Builder::default()
    }
}

/// See [`SetTerminationProtectionInput`](crate::input::SetTerminationProtectionInput)
pub mod set_termination_protection_input {
    /// A builder for [`SetTerminationProtectionInput`](crate::input::SetTerminationProtectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) termination_protected: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `job_flow_ids`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p> A list of strings that uniquely identify the clusters to protect. This identifier is
        /// returned by <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> . </p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_flow_ids.unwrap_or_default();
            v.push(input.into());
            self.job_flow_ids = Some(v);
            self
        }
        /// <p> A list of strings that uniquely identify the clusters to protect. This identifier is
        /// returned by <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> . </p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_flow_ids = input;
            self
        }
        /// <p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2
        /// instances in the cluster from shutting down due to API calls, user intervention, or
        /// job-flow error.</p>
        pub fn termination_protected(mut self, input: bool) -> Self {
            self.termination_protected = Some(input);
            self
        }
        /// <p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2
        /// instances in the cluster from shutting down due to API calls, user intervention, or
        /// job-flow error.</p>
        pub fn set_termination_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.termination_protected = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTerminationProtectionInput`](crate::input::SetTerminationProtectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetTerminationProtectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetTerminationProtectionInput {
                job_flow_ids: self.job_flow_ids,
                termination_protected: self.termination_protected.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SetTerminationProtectionInputOperationOutputAlias =
    crate::operation::SetTerminationProtection;
#[doc(hidden)]
pub type SetTerminationProtectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetTerminationProtectionInput {
    /// Consumes the builder and constructs an Operation<[`SetTerminationProtection`](crate::operation::SetTerminationProtection)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetTerminationProtection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetTerminationProtectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetTerminationProtectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetTerminationProtectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.SetTerminationProtection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_termination_protection(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetTerminationProtection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetTerminationProtection",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetTerminationProtectionInput`](crate::input::SetTerminationProtectionInput)
    pub fn builder() -> crate::input::set_termination_protection_input::Builder {
        crate::input::set_termination_protection_input::Builder::default()
    }
}

/// See [`SetVisibleToAllUsersInput`](crate::input::SetVisibleToAllUsersInput)
pub mod set_visible_to_all_users_input {
    /// A builder for [`SetVisibleToAllUsersInput`](crate::input::SetVisibleToAllUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) visible_to_all_users: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `job_flow_ids`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p>The unique identifier of the job flow (cluster).</p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_flow_ids.unwrap_or_default();
            v.push(input.into());
            self.job_flow_ids = Some(v);
            self
        }
        /// <p>The unique identifier of the job flow (cluster).</p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_flow_ids = input;
            self
        }
        /// <p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform
        /// EMR actions on the cluster that the IAM policies attached to the principal allow. A
        /// value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>
        pub fn visible_to_all_users(mut self, input: bool) -> Self {
            self.visible_to_all_users = Some(input);
            self
        }
        /// <p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform
        /// EMR actions on the cluster that the IAM policies attached to the principal allow. A
        /// value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>
        pub fn set_visible_to_all_users(mut self, input: std::option::Option<bool>) -> Self {
            self.visible_to_all_users = input;
            self
        }
        /// Consumes the builder and constructs a [`SetVisibleToAllUsersInput`](crate::input::SetVisibleToAllUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetVisibleToAllUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetVisibleToAllUsersInput {
                job_flow_ids: self.job_flow_ids,
                visible_to_all_users: self.visible_to_all_users.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SetVisibleToAllUsersInputOperationOutputAlias = crate::operation::SetVisibleToAllUsers;
#[doc(hidden)]
pub type SetVisibleToAllUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetVisibleToAllUsersInput {
    /// Consumes the builder and constructs an Operation<[`SetVisibleToAllUsers`](crate::operation::SetVisibleToAllUsers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetVisibleToAllUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetVisibleToAllUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetVisibleToAllUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetVisibleToAllUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.SetVisibleToAllUsers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_visible_to_all_users(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetVisibleToAllUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetVisibleToAllUsers",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetVisibleToAllUsersInput`](crate::input::SetVisibleToAllUsersInput)
    pub fn builder() -> crate::input::set_visible_to_all_users_input::Builder {
        crate::input::set_visible_to_all_users_input::Builder::default()
    }
}

/// See [`StartNotebookExecutionInput`](crate::input::StartNotebookExecutionInput)
pub mod start_notebook_execution_input {
    /// A builder for [`StartNotebookExecutionInput`](crate::input::StartNotebookExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) editor_id: std::option::Option<std::string::String>,
        pub(crate) relative_path: std::option::Option<std::string::String>,
        pub(crate) notebook_execution_name: std::option::Option<std::string::String>,
        pub(crate) notebook_params: std::option::Option<std::string::String>,
        pub(crate) execution_engine: std::option::Option<crate::model::ExecutionEngineConfig>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) notebook_instance_security_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The unique identifier of the EMR Notebook to use for notebook execution.</p>
        pub fn editor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.editor_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the EMR Notebook to use for notebook execution.</p>
        pub fn set_editor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.editor_id = input;
            self
        }
        /// <p>The path and file name of the notebook file for this execution, relative to the path
        /// specified for the EMR Notebook. For example, if you specify a path of
        /// <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook
        /// with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this
        /// request), and you specify a <code>RelativePath</code> of
        /// <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file
        /// for the notebook execution is
        /// <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>
        pub fn relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.relative_path = Some(input.into());
            self
        }
        /// <p>The path and file name of the notebook file for this execution, relative to the path
        /// specified for the EMR Notebook. For example, if you specify a path of
        /// <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook
        /// with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this
        /// request), and you specify a <code>RelativePath</code> of
        /// <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file
        /// for the notebook execution is
        /// <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>
        pub fn set_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relative_path = input;
            self
        }
        /// <p>An optional name for the notebook execution.</p>
        pub fn notebook_execution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_execution_name = Some(input.into());
            self
        }
        /// <p>An optional name for the notebook execution.</p>
        pub fn set_notebook_execution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_execution_name = input;
            self
        }
        /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for
        /// execution.</p>
        pub fn notebook_params(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_params = Some(input.into());
            self
        }
        /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for
        /// execution.</p>
        pub fn set_notebook_params(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_params = input;
            self
        }
        /// <p>Specifies the execution engine (cluster) that runs the notebook execution.</p>
        pub fn execution_engine(mut self, input: crate::model::ExecutionEngineConfig) -> Self {
            self.execution_engine = Some(input);
            self
        }
        /// <p>Specifies the execution engine (cluster) that runs the notebook execution.</p>
        pub fn set_execution_engine(
            mut self,
            input: std::option::Option<crate::model::ExecutionEngineConfig>,
        ) -> Self {
            self.execution_engine = input;
            self
        }
        /// <p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR
        /// role) for the notebook execution.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR
        /// role) for the notebook execution.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>The unique identifier of the Amazon EC2 security group to associate with the EMR
        /// Notebook for this notebook execution.</p>
        pub fn notebook_instance_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notebook_instance_security_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Amazon EC2 security group to associate with the EMR
        /// Notebook for this notebook execution.</p>
        pub fn set_notebook_instance_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_security_group_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value
        /// pairs that consist of a required key string with a maximum of 128 characters and an
        /// optional value string with a maximum of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value
        /// pairs that consist of a required key string with a maximum of 128 characters and an
        /// optional value string with a maximum of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartNotebookExecutionInput`](crate::input::StartNotebookExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartNotebookExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartNotebookExecutionInput {
                editor_id: self.editor_id,
                relative_path: self.relative_path,
                notebook_execution_name: self.notebook_execution_name,
                notebook_params: self.notebook_params,
                execution_engine: self.execution_engine,
                service_role: self.service_role,
                notebook_instance_security_group_id: self.notebook_instance_security_group_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartNotebookExecutionInputOperationOutputAlias = crate::operation::StartNotebookExecution;
#[doc(hidden)]
pub type StartNotebookExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartNotebookExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartNotebookExecution`](crate::operation::StartNotebookExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartNotebookExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartNotebookExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartNotebookExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartNotebookExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.StartNotebookExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_notebook_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartNotebookExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartNotebookExecution",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartNotebookExecutionInput`](crate::input::StartNotebookExecutionInput)
    pub fn builder() -> crate::input::start_notebook_execution_input::Builder {
        crate::input::start_notebook_execution_input::Builder::default()
    }
}

/// See [`StopNotebookExecutionInput`](crate::input::StopNotebookExecutionInput)
pub mod stop_notebook_execution_input {
    /// A builder for [`StopNotebookExecutionInput`](crate::input::StopNotebookExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn notebook_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_execution_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn set_notebook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopNotebookExecutionInput`](crate::input::StopNotebookExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopNotebookExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopNotebookExecutionInput {
                notebook_execution_id: self.notebook_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopNotebookExecutionInputOperationOutputAlias = crate::operation::StopNotebookExecution;
#[doc(hidden)]
pub type StopNotebookExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopNotebookExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StopNotebookExecution`](crate::operation::StopNotebookExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopNotebookExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopNotebookExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopNotebookExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopNotebookExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.StopNotebookExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_notebook_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopNotebookExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopNotebookExecution",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopNotebookExecutionInput`](crate::input::StopNotebookExecutionInput)
    pub fn builder() -> crate::input::stop_notebook_execution_input::Builder {
        crate::input::stop_notebook_execution_input::Builder::default()
    }
}

/// See [`TerminateJobFlowsInput`](crate::input::TerminateJobFlowsInput)
pub mod terminate_job_flows_input {
    /// A builder for [`TerminateJobFlowsInput`](crate::input::TerminateJobFlowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `job_flow_ids`.
        ///
        /// To override the contents of this collection use [`set_job_flow_ids`](Self::set_job_flow_ids).
        ///
        /// <p>A list of job flows to be shut down.</p>
        pub fn job_flow_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_flow_ids.unwrap_or_default();
            v.push(input.into());
            self.job_flow_ids = Some(v);
            self
        }
        /// <p>A list of job flows to be shut down.</p>
        pub fn set_job_flow_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_flow_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateJobFlowsInput`](crate::input::TerminateJobFlowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateJobFlowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateJobFlowsInput {
                job_flow_ids: self.job_flow_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateJobFlowsInputOperationOutputAlias = crate::operation::TerminateJobFlows;
#[doc(hidden)]
pub type TerminateJobFlowsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TerminateJobFlowsInput {
    /// Consumes the builder and constructs an Operation<[`TerminateJobFlows`](crate::operation::TerminateJobFlows)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateJobFlows,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TerminateJobFlowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TerminateJobFlowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TerminateJobFlowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.TerminateJobFlows",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_terminate_job_flows(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateJobFlows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateJobFlows",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TerminateJobFlowsInput`](crate::input::TerminateJobFlowsInput)
    pub fn builder() -> crate::input::terminate_job_flows_input::Builder {
        crate::input::terminate_job_flows_input::Builder::default()
    }
}

/// See [`UpdateStudioInput`](crate::input::UpdateStudioInput)
pub mod update_studio_input {
    /// A builder for [`UpdateStudioInput`](crate::input::UpdateStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_s3_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio to update.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio to update.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive name for the Amazon EMR Studio.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A detailed description to assign to the Amazon EMR Studio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A detailed description to assign to the Amazon EMR Studio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>
        pub fn default_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_s3_location = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>
        pub fn set_default_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStudioInput`](crate::input::UpdateStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStudioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStudioInput {
                studio_id: self.studio_id,
                name: self.name,
                description: self.description,
                subnet_ids: self.subnet_ids,
                default_s3_location: self.default_s3_location,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStudioInputOperationOutputAlias = crate::operation::UpdateStudio;
#[doc(hidden)]
pub type UpdateStudioInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStudioInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStudio`](crate::operation::UpdateStudio)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStudio,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStudioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStudioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStudioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.UpdateStudio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_studio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStudio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStudio",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStudioInput`](crate::input::UpdateStudioInput)
    pub fn builder() -> crate::input::update_studio_input::Builder {
        crate::input::update_studio_input::Builder::default()
    }
}

/// See [`UpdateStudioSessionMappingInput`](crate::input::UpdateStudioSessionMappingInput)
pub mod update_studio_session_mapping_input {
    /// A builder for [`UpdateStudioSessionMappingInput`](crate::input::UpdateStudioSessionMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_name: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) session_policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
        /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
        /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_name = Some(input.into());
            self
        }
        /// <p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
        /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_name = input;
            self
        }
        /// <p>Specifies whether the identity to update is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Specifies whether the identity to update is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy to associate with the specified
        /// user or group.</p>
        pub fn session_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy to associate with the specified
        /// user or group.</p>
        pub fn set_session_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStudioSessionMappingInput`](crate::input::UpdateStudioSessionMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStudioSessionMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStudioSessionMappingInput {
                studio_id: self.studio_id,
                identity_id: self.identity_id,
                identity_name: self.identity_name,
                identity_type: self.identity_type,
                session_policy_arn: self.session_policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStudioSessionMappingInputOperationOutputAlias =
    crate::operation::UpdateStudioSessionMapping;
#[doc(hidden)]
pub type UpdateStudioSessionMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStudioSessionMappingInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStudioSessionMapping`](crate::operation::UpdateStudioSessionMapping)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStudioSessionMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStudioSessionMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStudioSessionMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStudioSessionMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ElasticMapReduce.UpdateStudioSessionMapping",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_studio_session_mapping(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStudioSessionMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStudioSessionMapping",
            "emr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStudioSessionMappingInput`](crate::input::UpdateStudioSessionMappingInput)
    pub fn builder() -> crate::input::update_studio_session_mapping_input::Builder {
        crate::input::update_studio_session_mapping_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
    /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub identity_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the identity to update is a user or a group.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The Amazon Resource Name (ARN) of the session policy to associate with the specified
    /// user or group.</p>
    pub session_policy_arn: std::option::Option<std::string::String>,
}
impl UpdateStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
    /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub fn identity_name(&self) -> std::option::Option<&str> {
        self.identity_name.as_deref()
    }
    /// <p>Specifies whether the identity to update is a user or a group.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the session policy to associate with the specified
    /// user or group.</p>
    pub fn session_policy_arn(&self) -> std::option::Option<&str> {
        self.session_policy_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateStudioSessionMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStudioSessionMappingInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_name", &self.identity_name);
        formatter.field("identity_type", &self.identity_type);
        formatter.field("session_policy_arn", &self.session_policy_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStudioInput {
    /// <p>The ID of the Amazon EMR Studio to update.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>A descriptive name for the Amazon EMR Studio.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A detailed description to assign to the Amazon EMR Studio.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>
    pub default_s3_location: std::option::Option<std::string::String>,
}
impl UpdateStudioInput {
    /// <p>The ID of the Amazon EMR Studio to update.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>A descriptive name for the Amazon EMR Studio.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A detailed description to assign to the Amazon EMR Studio.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>
    pub fn default_s3_location(&self) -> std::option::Option<&str> {
        self.default_s3_location.as_deref()
    }
}
impl std::fmt::Debug for UpdateStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStudioInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("default_s3_location", &self.default_s3_location);
        formatter.finish()
    }
}

/// <p> Input to the <a>TerminateJobFlows</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateJobFlowsInput {
    /// <p>A list of job flows to be shut down.</p>
    pub job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TerminateJobFlowsInput {
    /// <p>A list of job flows to be shut down.</p>
    pub fn job_flow_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.job_flow_ids.as_deref()
    }
}
impl std::fmt::Debug for TerminateJobFlowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateJobFlowsInput");
        formatter.field("job_flow_ids", &self.job_flow_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopNotebookExecutionInput {
    /// <p>The unique identifier of the notebook execution.</p>
    pub notebook_execution_id: std::option::Option<std::string::String>,
}
impl StopNotebookExecutionInput {
    /// <p>The unique identifier of the notebook execution.</p>
    pub fn notebook_execution_id(&self) -> std::option::Option<&str> {
        self.notebook_execution_id.as_deref()
    }
}
impl std::fmt::Debug for StopNotebookExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopNotebookExecutionInput");
        formatter.field("notebook_execution_id", &self.notebook_execution_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartNotebookExecutionInput {
    /// <p>The unique identifier of the EMR Notebook to use for notebook execution.</p>
    pub editor_id: std::option::Option<std::string::String>,
    /// <p>The path and file name of the notebook file for this execution, relative to the path
    /// specified for the EMR Notebook. For example, if you specify a path of
    /// <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook
    /// with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this
    /// request), and you specify a <code>RelativePath</code> of
    /// <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file
    /// for the notebook execution is
    /// <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>
    pub relative_path: std::option::Option<std::string::String>,
    /// <p>An optional name for the notebook execution.</p>
    pub notebook_execution_name: std::option::Option<std::string::String>,
    /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for
    /// execution.</p>
    pub notebook_params: std::option::Option<std::string::String>,
    /// <p>Specifies the execution engine (cluster) that runs the notebook execution.</p>
    pub execution_engine: std::option::Option<crate::model::ExecutionEngineConfig>,
    /// <p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR
    /// role) for the notebook execution.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the Amazon EC2 security group to associate with the EMR
    /// Notebook for this notebook execution.</p>
    pub notebook_instance_security_group_id: std::option::Option<std::string::String>,
    /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value
    /// pairs that consist of a required key string with a maximum of 128 characters and an
    /// optional value string with a maximum of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl StartNotebookExecutionInput {
    /// <p>The unique identifier of the EMR Notebook to use for notebook execution.</p>
    pub fn editor_id(&self) -> std::option::Option<&str> {
        self.editor_id.as_deref()
    }
    /// <p>The path and file name of the notebook file for this execution, relative to the path
    /// specified for the EMR Notebook. For example, if you specify a path of
    /// <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook
    /// with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this
    /// request), and you specify a <code>RelativePath</code> of
    /// <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file
    /// for the notebook execution is
    /// <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>
    pub fn relative_path(&self) -> std::option::Option<&str> {
        self.relative_path.as_deref()
    }
    /// <p>An optional name for the notebook execution.</p>
    pub fn notebook_execution_name(&self) -> std::option::Option<&str> {
        self.notebook_execution_name.as_deref()
    }
    /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for
    /// execution.</p>
    pub fn notebook_params(&self) -> std::option::Option<&str> {
        self.notebook_params.as_deref()
    }
    /// <p>Specifies the execution engine (cluster) that runs the notebook execution.</p>
    pub fn execution_engine(&self) -> std::option::Option<&crate::model::ExecutionEngineConfig> {
        self.execution_engine.as_ref()
    }
    /// <p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR
    /// role) for the notebook execution.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p>The unique identifier of the Amazon EC2 security group to associate with the EMR
    /// Notebook for this notebook execution.</p>
    pub fn notebook_instance_security_group_id(&self) -> std::option::Option<&str> {
        self.notebook_instance_security_group_id.as_deref()
    }
    /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value
    /// pairs that consist of a required key string with a maximum of 128 characters and an
    /// optional value string with a maximum of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for StartNotebookExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartNotebookExecutionInput");
        formatter.field("editor_id", &self.editor_id);
        formatter.field("relative_path", &self.relative_path);
        formatter.field("notebook_execution_name", &self.notebook_execution_name);
        formatter.field("notebook_params", &self.notebook_params);
        formatter.field("execution_engine", &self.execution_engine);
        formatter.field("service_role", &self.service_role);
        formatter.field(
            "notebook_instance_security_group_id",
            &self.notebook_instance_security_group_id,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The input to the SetVisibleToAllUsers action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVisibleToAllUsersInput {
    /// <p>The unique identifier of the job flow (cluster).</p>
    pub job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform
    /// EMR actions on the cluster that the IAM policies attached to the principal allow. A
    /// value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>
    pub visible_to_all_users: bool,
}
impl SetVisibleToAllUsersInput {
    /// <p>The unique identifier of the job flow (cluster).</p>
    pub fn job_flow_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.job_flow_ids.as_deref()
    }
    /// <p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform
    /// EMR actions on the cluster that the IAM policies attached to the principal allow. A
    /// value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>
    pub fn visible_to_all_users(&self) -> bool {
        self.visible_to_all_users
    }
}
impl std::fmt::Debug for SetVisibleToAllUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVisibleToAllUsersInput");
        formatter.field("job_flow_ids", &self.job_flow_ids);
        formatter.field("visible_to_all_users", &self.visible_to_all_users);
        formatter.finish()
    }
}

/// <p> The input argument to the <a>TerminationProtection</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTerminationProtectionInput {
    /// <p> A list of strings that uniquely identify the clusters to protect. This identifier is
    /// returned by <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> . </p>
    pub job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2
    /// instances in the cluster from shutting down due to API calls, user intervention, or
    /// job-flow error.</p>
    pub termination_protected: bool,
}
impl SetTerminationProtectionInput {
    /// <p> A list of strings that uniquely identify the clusters to protect. This identifier is
    /// returned by <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> . </p>
    pub fn job_flow_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.job_flow_ids.as_deref()
    }
    /// <p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2
    /// instances in the cluster from shutting down due to API calls, user intervention, or
    /// job-flow error.</p>
    pub fn termination_protected(&self) -> bool {
        self.termination_protected
    }
}
impl std::fmt::Debug for SetTerminationProtectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTerminationProtectionInput");
        formatter.field("job_flow_ids", &self.job_flow_ids);
        formatter.field("termination_protected", &self.termination_protected);
        formatter.finish()
    }
}

/// <p> Input to the <a>RunJobFlow</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RunJobFlowInput {
    /// <p>The name of the job flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The location in Amazon S3 to write the log files of the job flow. If a value is not
    /// provided, logs are not created.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>The KMS key used for encrypting log files. If a value is not
    /// provided, the logs remain encrypted by AES-256. This attribute is only available with
    /// Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>
    pub log_encryption_kms_key_id: std::option::Option<std::string::String>,
    /// <p>A JSON string for selecting additional features.</p>
    pub additional_info: std::option::Option<std::string::String>,
    /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
    /// later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use
    /// <code>CustomAmiID</code>.</p>
    pub ami_version: std::option::Option<std::string::String>,
    /// <p>The Amazon EMR release label, which determines the version of open-source application
    /// packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>,
    /// where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more
    /// information about Amazon EMR release versions and included application versions and
    /// features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release
    /// label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
    /// <code>AmiVersion</code>.</p>
    pub release_label: std::option::Option<std::string::String>,
    /// <p>A specification of the number and type of Amazon EC2 instances.</p>
    pub instances: std::option::Option<crate::model::JobFlowInstancesConfig>,
    /// <p>A list of steps to run.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
    /// <p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>
    pub bootstrap_actions: std::option::Option<std::vec::Vec<crate::model::BootstrapActionConfig>>,
    /// <note>
    /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
    /// Applications.</p>
    /// </note>
    /// <p>A list of strings that indicates third-party software to use. For more information, see
    /// the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR
    /// Developer Guide</a>. Currently supported values are:</p>
    /// <ul>
    /// <li>
    /// <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p>
    /// </li>
    /// </ul>
    pub supported_products: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <note>
    /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
    /// Applications.</p>
    /// </note>
    /// <p>A list of strings that indicates third-party software to use with the job flow that
    /// accepts a user argument list. EMR accepts and forwards the argument list to the
    /// corresponding installation script as bootstrap action arguments. For more information, see
    /// "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported
    /// values are:</p>
    /// <ul>
    /// <li>
    /// <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" -
    /// launch the job flow using MapR M3 or M5 Edition respectively.</p>
    /// </li>
    /// <li>
    /// <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p>
    /// </li>
    /// <li>
    /// <p>"hue"- launch the cluster with Hue installed.</p>
    /// </li>
    /// <li>
    /// <p>"spark" - launch the cluster with Apache Spark installed.</p>
    /// </li>
    /// <li>
    /// <p>"ganglia" - launch the cluster with the Ganglia Monitoring System
    /// installed.</p>
    /// </li>
    /// </ul>
    pub new_supported_products:
        std::option::Option<std::vec::Vec<crate::model::SupportedProductConfig>>,
    /// <p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications
    /// for Amazon EMR to install and configure when launching the cluster. For a list of
    /// applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMR Release
    /// Guide</a>.</p>
    pub applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
    /// <p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR
    /// cluster you are creating.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p>
    /// <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
    pub visible_to_all_users: bool,
    /// <p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2
    /// instances of the cluster assume this role. The default role is
    /// <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have
    /// already created it using the CLI or console.</p>
    pub job_flow_role: std::option::Option<std::string::String>,
    /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
    /// your behalf.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of a security configuration to apply to the cluster.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>An IAM role for automatic scaling policies. The default role is
    /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the
    /// automatic scaling feature requires to launch and terminate EC2 instances in an instance
    /// group.</p>
    pub auto_scaling_role: std::option::Option<std::string::String>,
    /// <p>Specifies the way that individual Amazon EC2 instances terminate when an automatic
    /// scale-in activity occurs or an instance group is resized.
    /// <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at
    /// the instance-hour boundary, regardless of when the request to terminate the instance was
    /// submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default
    /// for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code>
    /// indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
    /// terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
    /// behavior, Amazon EMR removes the least active nodes first and blocks instance termination
    /// if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available
    /// only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR
    /// earlier than 5.1.0.</p>
    pub scale_down_behavior: std::option::Option<crate::model::ScaleDownBehavior>,
    /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
    /// EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2
    /// instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom
    /// AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the
    /// cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR
    /// versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p>
    /// <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed
    /// Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux
    /// Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux
    /// AMI</a>. </p>
    pub custom_ami_id: std::option::Option<std::string::String>,
    /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
    /// each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
    pub ebs_root_volume_size: std::option::Option<i32>,
    /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the
    /// Amazon Linux AMI package repositories to apply automatically when the instance boots using
    /// the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only
    /// security updates are applied. If <code>NONE</code> is specified, no updates are applied,
    /// and all updates must be applied manually.</p>
    pub repo_upgrade_on_boot: std::option::Option<crate::model::RepoUpgradeOnBoot>,
    /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
    /// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
    /// in the <i>Amazon EMR Management Guide</i>.</p>
    pub kerberos_attributes: std::option::Option<crate::model::KerberosAttributes>,
    /// <p>Specifies the number of steps that can be executed concurrently. The default value is
    /// <code>1</code>. The maximum value is <code>256</code>.</p>
    pub step_concurrency_level: std::option::Option<i32>,
    /// <p> The specified managed scaling policy for an Amazon EMR cluster. </p>
    pub managed_scaling_policy: std::option::Option<crate::model::ManagedScalingPolicy>,
    /// <p>The specified placement group configuration for an Amazon EMR cluster.</p>
    pub placement_group_configs:
        std::option::Option<std::vec::Vec<crate::model::PlacementGroupConfig>>,
    /// <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
    pub auto_termination_policy: std::option::Option<crate::model::AutoTerminationPolicy>,
}
impl RunJobFlowInput {
    /// <p>The name of the job flow.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The location in Amazon S3 to write the log files of the job flow. If a value is not
    /// provided, logs are not created.</p>
    pub fn log_uri(&self) -> std::option::Option<&str> {
        self.log_uri.as_deref()
    }
    /// <p>The KMS key used for encrypting log files. If a value is not
    /// provided, the logs remain encrypted by AES-256. This attribute is only available with
    /// Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>
    pub fn log_encryption_kms_key_id(&self) -> std::option::Option<&str> {
        self.log_encryption_kms_key_id.as_deref()
    }
    /// <p>A JSON string for selecting additional features.</p>
    pub fn additional_info(&self) -> std::option::Option<&str> {
        self.additional_info.as_deref()
    }
    /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
    /// later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use
    /// <code>CustomAmiID</code>.</p>
    pub fn ami_version(&self) -> std::option::Option<&str> {
        self.ami_version.as_deref()
    }
    /// <p>The Amazon EMR release label, which determines the version of open-source application
    /// packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>,
    /// where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more
    /// information about Amazon EMR release versions and included application versions and
    /// features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release
    /// label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
    /// <code>AmiVersion</code>.</p>
    pub fn release_label(&self) -> std::option::Option<&str> {
        self.release_label.as_deref()
    }
    /// <p>A specification of the number and type of Amazon EC2 instances.</p>
    pub fn instances(&self) -> std::option::Option<&crate::model::JobFlowInstancesConfig> {
        self.instances.as_ref()
    }
    /// <p>A list of steps to run.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::StepConfig]> {
        self.steps.as_deref()
    }
    /// <p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>
    pub fn bootstrap_actions(&self) -> std::option::Option<&[crate::model::BootstrapActionConfig]> {
        self.bootstrap_actions.as_deref()
    }
    /// <note>
    /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
    /// Applications.</p>
    /// </note>
    /// <p>A list of strings that indicates third-party software to use. For more information, see
    /// the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR
    /// Developer Guide</a>. Currently supported values are:</p>
    /// <ul>
    /// <li>
    /// <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p>
    /// </li>
    /// </ul>
    pub fn supported_products(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_products.as_deref()
    }
    /// <note>
    /// <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
    /// Applications.</p>
    /// </note>
    /// <p>A list of strings that indicates third-party software to use with the job flow that
    /// accepts a user argument list. EMR accepts and forwards the argument list to the
    /// corresponding installation script as bootstrap action arguments. For more information, see
    /// "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported
    /// values are:</p>
    /// <ul>
    /// <li>
    /// <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" -
    /// launch the job flow using MapR M3 or M5 Edition respectively.</p>
    /// </li>
    /// <li>
    /// <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p>
    /// </li>
    /// <li>
    /// <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p>
    /// </li>
    /// <li>
    /// <p>"hue"- launch the cluster with Hue installed.</p>
    /// </li>
    /// <li>
    /// <p>"spark" - launch the cluster with Apache Spark installed.</p>
    /// </li>
    /// <li>
    /// <p>"ganglia" - launch the cluster with the Ganglia Monitoring System
    /// installed.</p>
    /// </li>
    /// </ul>
    pub fn new_supported_products(
        &self,
    ) -> std::option::Option<&[crate::model::SupportedProductConfig]> {
        self.new_supported_products.as_deref()
    }
    /// <p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications
    /// for Amazon EMR to install and configure when launching the cluster. For a list of
    /// applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMR Release
    /// Guide</a>.</p>
    pub fn applications(&self) -> std::option::Option<&[crate::model::Application]> {
        self.applications.as_deref()
    }
    /// <p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR
    /// cluster you are creating.</p>
    pub fn configurations(&self) -> std::option::Option<&[crate::model::Configuration]> {
        self.configurations.as_deref()
    }
    /// <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p>
    /// <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
    pub fn visible_to_all_users(&self) -> bool {
        self.visible_to_all_users
    }
    /// <p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2
    /// instances of the cluster assume this role. The default role is
    /// <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have
    /// already created it using the CLI or console.</p>
    pub fn job_flow_role(&self) -> std::option::Option<&str> {
        self.job_flow_role.as_deref()
    }
    /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
    /// your behalf.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The name of a security configuration to apply to the cluster.</p>
    pub fn security_configuration(&self) -> std::option::Option<&str> {
        self.security_configuration.as_deref()
    }
    /// <p>An IAM role for automatic scaling policies. The default role is
    /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the
    /// automatic scaling feature requires to launch and terminate EC2 instances in an instance
    /// group.</p>
    pub fn auto_scaling_role(&self) -> std::option::Option<&str> {
        self.auto_scaling_role.as_deref()
    }
    /// <p>Specifies the way that individual Amazon EC2 instances terminate when an automatic
    /// scale-in activity occurs or an instance group is resized.
    /// <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at
    /// the instance-hour boundary, regardless of when the request to terminate the instance was
    /// submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default
    /// for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code>
    /// indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
    /// terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
    /// behavior, Amazon EMR removes the least active nodes first and blocks instance termination
    /// if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available
    /// only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR
    /// earlier than 5.1.0.</p>
    pub fn scale_down_behavior(&self) -> std::option::Option<&crate::model::ScaleDownBehavior> {
        self.scale_down_behavior.as_ref()
    }
    /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
    /// EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2
    /// instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom
    /// AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the
    /// cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR
    /// versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p>
    /// <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed
    /// Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux
    /// Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux
    /// AMI</a>. </p>
    pub fn custom_ami_id(&self) -> std::option::Option<&str> {
        self.custom_ami_id.as_deref()
    }
    /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
    /// each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
    pub fn ebs_root_volume_size(&self) -> std::option::Option<i32> {
        self.ebs_root_volume_size
    }
    /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the
    /// Amazon Linux AMI package repositories to apply automatically when the instance boots using
    /// the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only
    /// security updates are applied. If <code>NONE</code> is specified, no updates are applied,
    /// and all updates must be applied manually.</p>
    pub fn repo_upgrade_on_boot(&self) -> std::option::Option<&crate::model::RepoUpgradeOnBoot> {
        self.repo_upgrade_on_boot.as_ref()
    }
    /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
    /// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
    /// in the <i>Amazon EMR Management Guide</i>.</p>
    pub fn kerberos_attributes(&self) -> std::option::Option<&crate::model::KerberosAttributes> {
        self.kerberos_attributes.as_ref()
    }
    /// <p>Specifies the number of steps that can be executed concurrently. The default value is
    /// <code>1</code>. The maximum value is <code>256</code>.</p>
    pub fn step_concurrency_level(&self) -> std::option::Option<i32> {
        self.step_concurrency_level
    }
    /// <p> The specified managed scaling policy for an Amazon EMR cluster. </p>
    pub fn managed_scaling_policy(
        &self,
    ) -> std::option::Option<&crate::model::ManagedScalingPolicy> {
        self.managed_scaling_policy.as_ref()
    }
    /// <p>The specified placement group configuration for an Amazon EMR cluster.</p>
    pub fn placement_group_configs(
        &self,
    ) -> std::option::Option<&[crate::model::PlacementGroupConfig]> {
        self.placement_group_configs.as_deref()
    }
    /// <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
    pub fn auto_termination_policy(
        &self,
    ) -> std::option::Option<&crate::model::AutoTerminationPolicy> {
        self.auto_termination_policy.as_ref()
    }
}
impl std::fmt::Debug for RunJobFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RunJobFlowInput");
        formatter.field("name", &self.name);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("log_encryption_kms_key_id", &self.log_encryption_kms_key_id);
        formatter.field("additional_info", &self.additional_info);
        formatter.field("ami_version", &self.ami_version);
        formatter.field("release_label", &self.release_label);
        formatter.field("instances", &self.instances);
        formatter.field("steps", &self.steps);
        formatter.field("bootstrap_actions", &self.bootstrap_actions);
        formatter.field("supported_products", &self.supported_products);
        formatter.field("new_supported_products", &self.new_supported_products);
        formatter.field("applications", &self.applications);
        formatter.field("configurations", &self.configurations);
        formatter.field("visible_to_all_users", &self.visible_to_all_users);
        formatter.field("job_flow_role", &self.job_flow_role);
        formatter.field("service_role", &self.service_role);
        formatter.field("tags", &self.tags);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("auto_scaling_role", &self.auto_scaling_role);
        formatter.field("scale_down_behavior", &self.scale_down_behavior);
        formatter.field("custom_ami_id", &self.custom_ami_id);
        formatter.field("ebs_root_volume_size", &self.ebs_root_volume_size);
        formatter.field("repo_upgrade_on_boot", &self.repo_upgrade_on_boot);
        formatter.field("kerberos_attributes", &self.kerberos_attributes);
        formatter.field("step_concurrency_level", &self.step_concurrency_level);
        formatter.field("managed_scaling_policy", &self.managed_scaling_policy);
        formatter.field("placement_group_configs", &self.placement_group_configs);
        formatter.field("auto_termination_policy", &self.auto_termination_policy);
        formatter.finish()
    }
}

/// <p>This input identifies an Amazon EMR resource and a list of tags to remove.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsInput {
    /// <p>The Amazon EMR resource identifier from which tags will be removed. For example, a
    /// cluster identifier or an Amazon EMR Studio ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsInput {
    /// <p>The Amazon EMR resource identifier from which tags will be removed. For example, a
    /// cluster identifier or an Amazon EMR Studio ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>A list of tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveManagedScalingPolicyInput {
    /// <p> Specifies the ID of the cluster from which the managed scaling policy will be removed.
    /// </p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl RemoveManagedScalingPolicyInput {
    /// <p> Specifies the ID of the cluster from which the managed scaling policy will be removed.
    /// </p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveManagedScalingPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveManagedScalingPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAutoTerminationPolicyInput {
    /// <p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl RemoveAutoTerminationPolicyInput {
    /// <p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveAutoTerminationPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAutoTerminationPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAutoScalingPolicyInput {
    /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
    /// is applied is within this cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
    pub instance_group_id: std::option::Option<std::string::String>,
}
impl RemoveAutoScalingPolicyInput {
    /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
    /// is applied is within this cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>Specifies the ID of the instance group to which the scaling policy is applied.</p>
    pub fn instance_group_id(&self) -> std::option::Option<&str> {
        self.instance_group_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveAutoScalingPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAutoScalingPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("instance_group_id", &self.instance_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutManagedScalingPolicyInput {
    /// <p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>Specifies the constraints for the managed scaling policy. </p>
    pub managed_scaling_policy: std::option::Option<crate::model::ManagedScalingPolicy>,
}
impl PutManagedScalingPolicyInput {
    /// <p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>Specifies the constraints for the managed scaling policy. </p>
    pub fn managed_scaling_policy(
        &self,
    ) -> std::option::Option<&crate::model::ManagedScalingPolicy> {
        self.managed_scaling_policy.as_ref()
    }
}
impl std::fmt::Debug for PutManagedScalingPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutManagedScalingPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("managed_scaling_policy", &self.managed_scaling_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBlockPublicAccessConfigurationInput {
    /// <p>A configuration for Amazon EMR block public access. The configuration applies to all
    /// clusters created in your account for the current Region. The configuration specifies
    /// whether block public access is enabled. If block public access is enabled, security groups
    /// associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or
    /// ::/0 on a port, unless the port is specified as an exception using
    /// <code>PermittedPublicSecurityGroupRuleRanges</code> in the
    /// <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception,
    /// and public access is allowed on this port. You can change this by updating
    /// <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p>
    /// <note>
    /// <p>For accounts that created clusters in a Region before November 25, 2019, block public
    /// access is disabled by default in that Region. To use this feature, you must manually
    /// enable and configure it. For accounts that did not create an EMR cluster in a Region
    /// before this date, block public access is enabled by default in that Region.</p>
    /// </note>
    pub block_public_access_configuration:
        std::option::Option<crate::model::BlockPublicAccessConfiguration>,
}
impl PutBlockPublicAccessConfigurationInput {
    /// <p>A configuration for Amazon EMR block public access. The configuration applies to all
    /// clusters created in your account for the current Region. The configuration specifies
    /// whether block public access is enabled. If block public access is enabled, security groups
    /// associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or
    /// ::/0 on a port, unless the port is specified as an exception using
    /// <code>PermittedPublicSecurityGroupRuleRanges</code> in the
    /// <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception,
    /// and public access is allowed on this port. You can change this by updating
    /// <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p>
    /// <note>
    /// <p>For accounts that created clusters in a Region before November 25, 2019, block public
    /// access is disabled by default in that Region. To use this feature, you must manually
    /// enable and configure it. For accounts that did not create an EMR cluster in a Region
    /// before this date, block public access is enabled by default in that Region.</p>
    /// </note>
    pub fn block_public_access_configuration(
        &self,
    ) -> std::option::Option<&crate::model::BlockPublicAccessConfiguration> {
        self.block_public_access_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutBlockPublicAccessConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBlockPublicAccessConfigurationInput");
        formatter.field(
            "block_public_access_configuration",
            &self.block_public_access_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAutoTerminationPolicyInput {
    /// <p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>Specifies the auto-termination policy to attach to the cluster.</p>
    pub auto_termination_policy: std::option::Option<crate::model::AutoTerminationPolicy>,
}
impl PutAutoTerminationPolicyInput {
    /// <p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>Specifies the auto-termination policy to attach to the cluster.</p>
    pub fn auto_termination_policy(
        &self,
    ) -> std::option::Option<&crate::model::AutoTerminationPolicy> {
        self.auto_termination_policy.as_ref()
    }
}
impl std::fmt::Debug for PutAutoTerminationPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAutoTerminationPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("auto_termination_policy", &self.auto_termination_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAutoScalingPolicyInput {
    /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
    /// is applied is within this cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>Specifies the ID of the instance group to which the automatic scaling policy is
    /// applied.</p>
    pub instance_group_id: std::option::Option<std::string::String>,
    /// <p>Specifies the definition of the automatic scaling policy.</p>
    pub auto_scaling_policy: std::option::Option<crate::model::AutoScalingPolicy>,
}
impl PutAutoScalingPolicyInput {
    /// <p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy
    /// is applied is within this cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>Specifies the ID of the instance group to which the automatic scaling policy is
    /// applied.</p>
    pub fn instance_group_id(&self) -> std::option::Option<&str> {
        self.instance_group_id.as_deref()
    }
    /// <p>Specifies the definition of the automatic scaling policy.</p>
    pub fn auto_scaling_policy(&self) -> std::option::Option<&crate::model::AutoScalingPolicy> {
        self.auto_scaling_policy.as_ref()
    }
}
impl std::fmt::Debug for PutAutoScalingPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAutoScalingPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("instance_group_id", &self.instance_group_id);
        formatter.field("auto_scaling_policy", &self.auto_scaling_policy);
        formatter.finish()
    }
}

/// <p>Change the size of some instance groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyInstanceGroupsInput {
    /// <p>The ID of the cluster to which the instance group belongs.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>Instance groups to change.</p>
    pub instance_groups:
        std::option::Option<std::vec::Vec<crate::model::InstanceGroupModifyConfig>>,
}
impl ModifyInstanceGroupsInput {
    /// <p>The ID of the cluster to which the instance group belongs.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>Instance groups to change.</p>
    pub fn instance_groups(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceGroupModifyConfig]> {
        self.instance_groups.as_deref()
    }
}
impl std::fmt::Debug for ModifyInstanceGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyInstanceGroupsInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("instance_groups", &self.instance_groups);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyInstanceFleetInput {
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The configuration parameters of the instance fleet.</p>
    pub instance_fleet: std::option::Option<crate::model::InstanceFleetModifyConfig>,
}
impl ModifyInstanceFleetInput {
    /// <p>The unique identifier of the cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The configuration parameters of the instance fleet.</p>
    pub fn instance_fleet(&self) -> std::option::Option<&crate::model::InstanceFleetModifyConfig> {
        self.instance_fleet.as_ref()
    }
}
impl std::fmt::Debug for ModifyInstanceFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyInstanceFleetInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("instance_fleet", &self.instance_fleet);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterInput {
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <a>Step$ActionOnFailure</a>.</p>
    pub step_concurrency_level: std::option::Option<i32>,
}
impl ModifyClusterInput {
    /// <p>The unique identifier of the cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <a>Step$ActionOnFailure</a>.</p>
    pub fn step_concurrency_level(&self) -> std::option::Option<i32> {
        self.step_concurrency_level
    }
}
impl std::fmt::Debug for ModifyClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("step_concurrency_level", &self.step_concurrency_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStudioSessionMappingsInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether to return session mappings for users or groups. If not specified, the
    /// results include session mapping details for both users and groups.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The pagination token that indicates the set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListStudioSessionMappingsInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>Specifies whether to return session mappings for users or groups. If not specified, the
    /// results include session mapping details for both users and groups.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
    /// <p>The pagination token that indicates the set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListStudioSessionMappingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStudioSessionMappingsInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("identity_type", &self.identity_type);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStudiosInput {
    /// <p>The pagination token that indicates the set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListStudiosInput {
    /// <p>The pagination token that indicates the set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListStudiosInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStudiosInput");
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>This input determines which steps to list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStepsInput {
    /// <p>The identifier of the cluster for which to list the steps.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The filter to limit the step list based on certain states.</p>
    pub step_states: std::option::Option<std::vec::Vec<crate::model::StepState>>,
    /// <p>The filter to limit the step list based on the identifier of the steps. You can specify
    /// a maximum of ten Step IDs. The character constraint applies to the overall length of the
    /// array.</p>
    pub step_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListStepsInput {
    /// <p>The identifier of the cluster for which to list the steps.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The filter to limit the step list based on certain states.</p>
    pub fn step_states(&self) -> std::option::Option<&[crate::model::StepState]> {
        self.step_states.as_deref()
    }
    /// <p>The filter to limit the step list based on the identifier of the steps. You can specify
    /// a maximum of ten Step IDs. The character constraint applies to the overall length of the
    /// array.</p>
    pub fn step_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.step_ids.as_deref()
    }
    /// <p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListStepsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStepsInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("step_states", &self.step_states);
        formatter.field("step_ids", &self.step_ids);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSecurityConfigurationsInput {
    /// <p>The pagination token that indicates the set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListSecurityConfigurationsInput {
    /// <p>The pagination token that indicates the set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListSecurityConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSecurityConfigurationsInput");
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReleaseLabelsInput {
    /// <p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>
    pub filters: std::option::Option<crate::model::ReleaseLabelFilter>,
    /// <p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListReleaseLabelsInput {
    /// <p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ReleaseLabelFilter> {
        self.filters.as_ref()
    }
    /// <p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListReleaseLabelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReleaseLabelsInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotebookExecutionsInput {
    /// <p>The unique ID of the editor associated with the notebook execution.</p>
    pub editor_id: std::option::Option<std::string::String>,
    /// <p>The status filter for listing notebook executions.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>START_PENDING</code> indicates that the cluster has received the execution
    /// request but execution has not begun.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STARTING</code> indicates that the execution is starting on the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RUNNING</code> indicates that the execution is being processed by the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHING</code> indicates that execution processing is in the final
    /// stages.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHED</code> indicates that the execution has completed without
    /// error.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILING</code> indicates that the execution is failing and will not finish
    /// successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> indicates that the execution failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOP_PENDING</code> indicates that the cluster has received a
    /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
    /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> indicates that the execution stopped because of a
    /// <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::NotebookExecutionStatus>,
    /// <p>The beginning of time range filter for listing notebook executions. The default is the
    /// timestamp of 30 days ago.</p>
    pub from: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of time range filter for listing notebook executions. The default is the current
    /// timestamp.</p>
    pub to: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call,
    /// that indicates the start of the list for this <code>ListNotebookExecutions</code>
    /// call.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListNotebookExecutionsInput {
    /// <p>The unique ID of the editor associated with the notebook execution.</p>
    pub fn editor_id(&self) -> std::option::Option<&str> {
        self.editor_id.as_deref()
    }
    /// <p>The status filter for listing notebook executions.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>START_PENDING</code> indicates that the cluster has received the execution
    /// request but execution has not begun.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STARTING</code> indicates that the execution is starting on the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RUNNING</code> indicates that the execution is being processed by the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHING</code> indicates that execution processing is in the final
    /// stages.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHED</code> indicates that the execution has completed without
    /// error.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILING</code> indicates that the execution is failing and will not finish
    /// successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> indicates that the execution failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOP_PENDING</code> indicates that the cluster has received a
    /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
    /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> indicates that the execution stopped because of a
    /// <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::NotebookExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The beginning of time range filter for listing notebook executions. The default is the
    /// timestamp of 30 days ago.</p>
    pub fn from(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.from.as_ref()
    }
    /// <p>The end of time range filter for listing notebook executions. The default is the current
    /// timestamp.</p>
    pub fn to(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.to.as_ref()
    }
    /// <p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call,
    /// that indicates the start of the list for this <code>ListNotebookExecutions</code>
    /// call.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListNotebookExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotebookExecutionsInput");
        formatter.field("editor_id", &self.editor_id);
        formatter.field("status", &self.status);
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>This input determines which instances to list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstancesInput {
    /// <p>The identifier of the cluster for which to list the instances.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the instance group for which to list the instances.</p>
    pub instance_group_id: std::option::Option<std::string::String>,
    /// <p>The type of instance group for which to list the instances.</p>
    pub instance_group_types: std::option::Option<std::vec::Vec<crate::model::InstanceGroupType>>,
    /// <p>The unique identifier of the instance fleet.</p>
    pub instance_fleet_id: std::option::Option<std::string::String>,
    /// <p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>
    pub instance_fleet_type: std::option::Option<crate::model::InstanceFleetType>,
    /// <p>A list of instance states that will filter the instances returned with this
    /// request.</p>
    pub instance_states: std::option::Option<std::vec::Vec<crate::model::InstanceState>>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListInstancesInput {
    /// <p>The identifier of the cluster for which to list the instances.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The identifier of the instance group for which to list the instances.</p>
    pub fn instance_group_id(&self) -> std::option::Option<&str> {
        self.instance_group_id.as_deref()
    }
    /// <p>The type of instance group for which to list the instances.</p>
    pub fn instance_group_types(&self) -> std::option::Option<&[crate::model::InstanceGroupType]> {
        self.instance_group_types.as_deref()
    }
    /// <p>The unique identifier of the instance fleet.</p>
    pub fn instance_fleet_id(&self) -> std::option::Option<&str> {
        self.instance_fleet_id.as_deref()
    }
    /// <p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>
    pub fn instance_fleet_type(&self) -> std::option::Option<&crate::model::InstanceFleetType> {
        self.instance_fleet_type.as_ref()
    }
    /// <p>A list of instance states that will filter the instances returned with this
    /// request.</p>
    pub fn instance_states(&self) -> std::option::Option<&[crate::model::InstanceState]> {
        self.instance_states.as_deref()
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstancesInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("instance_group_id", &self.instance_group_id);
        formatter.field("instance_group_types", &self.instance_group_types);
        formatter.field("instance_fleet_id", &self.instance_fleet_id);
        formatter.field("instance_fleet_type", &self.instance_fleet_type);
        formatter.field("instance_states", &self.instance_states);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>This input determines which instance groups to retrieve.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceGroupsInput {
    /// <p>The identifier of the cluster for which to list the instance groups.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListInstanceGroupsInput {
    /// <p>The identifier of the cluster for which to list the instance groups.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceGroupsInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceFleetsInput {
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListInstanceFleetsInput {
    /// <p>The unique identifier of the cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceFleetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceFleetsInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>This input determines how the ListClusters action filters the list of clusters that it
/// returns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClustersInput {
    /// <p>The creation date and time beginning value filter for listing clusters.</p>
    pub created_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The creation date and time end value filter for listing clusters.</p>
    pub created_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>
    pub cluster_states: std::option::Option<std::vec::Vec<crate::model::ClusterState>>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListClustersInput {
    /// <p>The creation date and time beginning value filter for listing clusters.</p>
    pub fn created_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_after.as_ref()
    }
    /// <p>The creation date and time end value filter for listing clusters.</p>
    pub fn created_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_before.as_ref()
    }
    /// <p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>
    pub fn cluster_states(&self) -> std::option::Option<&[crate::model::ClusterState]> {
        self.cluster_states.as_deref()
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClustersInput");
        formatter.field("created_after", &self.created_after);
        formatter.field("created_before", &self.created_before);
        formatter.field("cluster_states", &self.cluster_states);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>This input determines which bootstrap actions to retrieve.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBootstrapActionsInput {
    /// <p>The cluster identifier for the bootstrap actions to list.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListBootstrapActionsInput {
    /// <p>The cluster identifier for the bootstrap actions to list.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListBootstrapActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBootstrapActionsInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
    /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub identity_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the identity to fetch is a user or a group.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
}
impl GetStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The globally unique identifier (GUID) of the user or group. For more information, see
    /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub fn identity_name(&self) -> std::option::Option<&str> {
        self.identity_name.as_deref()
    }
    /// <p>Specifies whether the identity to fetch is a user or a group.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
}
impl std::fmt::Debug for GetStudioSessionMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStudioSessionMappingInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_name", &self.identity_name);
        formatter.field("identity_type", &self.identity_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetManagedScalingPolicyInput {
    /// <p>Specifies the ID of the cluster for which the managed scaling policy will be fetched.
    /// </p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl GetManagedScalingPolicyInput {
    /// <p>Specifies the ID of the cluster for which the managed scaling policy will be fetched.
    /// </p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for GetManagedScalingPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetManagedScalingPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlockPublicAccessConfigurationInput {}
impl std::fmt::Debug for GetBlockPublicAccessConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlockPublicAccessConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAutoTerminationPolicyInput {
    /// <p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl GetAutoTerminationPolicyInput {
    /// <p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for GetAutoTerminationPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAutoTerminationPolicyInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStudioInput {
    /// <p>The Amazon EMR Studio ID.</p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DescribeStudioInput {
    /// <p>The Amazon EMR Studio ID.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStudioInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

/// <p>This input determines which step to describe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStepInput {
    /// <p>The identifier of the cluster with steps to describe.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the step to describe.</p>
    pub step_id: std::option::Option<std::string::String>,
}
impl DescribeStepInput {
    /// <p>The identifier of the cluster with steps to describe.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The identifier of the step to describe.</p>
    pub fn step_id(&self) -> std::option::Option<&str> {
        self.step_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeStepInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStepInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("step_id", &self.step_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSecurityConfigurationInput {
    /// <p>The name of the security configuration.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeSecurityConfigurationInput {
    /// <p>The name of the security configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeSecurityConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSecurityConfigurationInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReleaseLabelInput {
    /// <p>The target release label to be described.</p>
    pub release_label: std::option::Option<std::string::String>,
    /// <p>The pagination token. Reserved for future use. Currently set to null.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Reserved for future use. Currently set to null.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeReleaseLabelInput {
    /// <p>The target release label to be described.</p>
    pub fn release_label(&self) -> std::option::Option<&str> {
        self.release_label.as_deref()
    }
    /// <p>The pagination token. Reserved for future use. Currently set to null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Reserved for future use. Currently set to null.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeReleaseLabelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReleaseLabelInput");
        formatter.field("release_label", &self.release_label);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotebookExecutionInput {
    /// <p>The unique identifier of the notebook execution.</p>
    pub notebook_execution_id: std::option::Option<std::string::String>,
}
impl DescribeNotebookExecutionInput {
    /// <p>The unique identifier of the notebook execution.</p>
    pub fn notebook_execution_id(&self) -> std::option::Option<&str> {
        self.notebook_execution_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeNotebookExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotebookExecutionInput");
        formatter.field("notebook_execution_id", &self.notebook_execution_id);
        formatter.finish()
    }
}

/// <p> The input for the <a>DescribeJobFlows</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobFlowsInput {
    /// <p>Return only job flows created after this date and time.</p>
    pub created_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Return only job flows created before this date and time.</p>
    pub created_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Return only job flows whose job flow ID is contained in this list.</p>
    pub job_flow_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Return only job flows whose state is contained in this list.</p>
    pub job_flow_states: std::option::Option<std::vec::Vec<crate::model::JobFlowExecutionState>>,
}
impl DescribeJobFlowsInput {
    /// <p>Return only job flows created after this date and time.</p>
    pub fn created_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_after.as_ref()
    }
    /// <p>Return only job flows created before this date and time.</p>
    pub fn created_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_before.as_ref()
    }
    /// <p>Return only job flows whose job flow ID is contained in this list.</p>
    pub fn job_flow_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.job_flow_ids.as_deref()
    }
    /// <p>Return only job flows whose state is contained in this list.</p>
    pub fn job_flow_states(&self) -> std::option::Option<&[crate::model::JobFlowExecutionState]> {
        self.job_flow_states.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobFlowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobFlowsInput");
        formatter.field("created_after", &self.created_after);
        formatter.field("created_before", &self.created_before);
        formatter.field("job_flow_ids", &self.job_flow_ids);
        formatter.field("job_flow_states", &self.job_flow_states);
        formatter.finish()
    }
}

/// <p>This input determines which cluster to describe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterInput {
    /// <p>The identifier of the cluster to describe.</p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl DescribeClusterInput {
    /// <p>The identifier of the cluster to describe.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR
    /// Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see
    /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub identity_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
}
impl DeleteStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR
    /// Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see
    /// <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>
    pub fn identity_name(&self) -> std::option::Option<&str> {
        self.identity_name.as_deref()
    }
    /// <p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
}
impl std::fmt::Debug for DeleteStudioSessionMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStudioSessionMappingInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_name", &self.identity_name);
        formatter.field("identity_type", &self.identity_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStudioInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteStudioInput {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStudioInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSecurityConfigurationInput {
    /// <p>The name of the security configuration.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteSecurityConfigurationInput {
    /// <p>The name of the security configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteSecurityConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSecurityConfigurationInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
    /// Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
    pub identity_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user
    /// or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>
    pub session_policy_arn: std::option::Option<std::string::String>,
}
impl CreateStudioSessionMappingInput {
    /// <p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
    /// Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
    /// Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>
    pub fn identity_name(&self) -> std::option::Option<&str> {
        self.identity_name.as_deref()
    }
    /// <p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user
    /// or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>
    pub fn session_policy_arn(&self) -> std::option::Option<&str> {
        self.session_policy_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateStudioSessionMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStudioSessionMappingInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_name", &self.identity_name);
        formatter.field("identity_type", &self.identity_type);
        formatter.field("session_policy_arn", &self.session_policy_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStudioInput {
    /// <p>A descriptive name for the Amazon EMR Studio.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A detailed description of the Amazon EMR Studio.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
    pub auth_mode: std::option::Option<crate::model::AuthMode>,
    /// <p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the
    /// Studio.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC
    /// specified by <code>VpcId</code>. Studio users can create a Workspace in any of the
    /// specified subnets.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IAM role that the Amazon EMR Studio assumes. The service role provides a
    /// way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The
    /// permissions attached to the <code>UserRole</code> can be scoped down for each user or group using
    /// session policies.</p>
    pub user_role: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group
    /// allows outbound network traffic to resources in the Engine security group, and it must be
    /// in the same VPC specified by <code>VpcId</code>.</p>
    pub workspace_security_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows
    /// inbound network traffic from the Workspace security group, and it must be in the same VPC
    /// specified by <code>VpcId</code>.</p>
    pub engine_security_group_id: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>
    pub default_s3_location: std::option::Option<std::string::String>,
    /// <p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>
    pub idp_auth_url: std::option::Option<std::string::String>,
    /// <p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>
    pub idp_relay_state_parameter_name: std::option::Option<std::string::String>,
    /// <p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
    /// consist of a required key string with a maximum of 128 characters, and an optional value
    /// string with a maximum of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateStudioInput {
    /// <p>A descriptive name for the Amazon EMR Studio.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A detailed description of the Amazon EMR Studio.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
    pub fn auth_mode(&self) -> std::option::Option<&crate::model::AuthMode> {
        self.auth_mode.as_ref()
    }
    /// <p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the
    /// Studio.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC
    /// specified by <code>VpcId</code>. Studio users can create a Workspace in any of the
    /// specified subnets.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The IAM role that the Amazon EMR Studio assumes. The service role provides a
    /// way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The
    /// permissions attached to the <code>UserRole</code> can be scoped down for each user or group using
    /// session policies.</p>
    pub fn user_role(&self) -> std::option::Option<&str> {
        self.user_role.as_deref()
    }
    /// <p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group
    /// allows outbound network traffic to resources in the Engine security group, and it must be
    /// in the same VPC specified by <code>VpcId</code>.</p>
    pub fn workspace_security_group_id(&self) -> std::option::Option<&str> {
        self.workspace_security_group_id.as_deref()
    }
    /// <p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows
    /// inbound network traffic from the Workspace security group, and it must be in the same VPC
    /// specified by <code>VpcId</code>.</p>
    pub fn engine_security_group_id(&self) -> std::option::Option<&str> {
        self.engine_security_group_id.as_deref()
    }
    /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>
    pub fn default_s3_location(&self) -> std::option::Option<&str> {
        self.default_s3_location.as_deref()
    }
    /// <p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>
    pub fn idp_auth_url(&self) -> std::option::Option<&str> {
        self.idp_auth_url.as_deref()
    }
    /// <p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>
    pub fn idp_relay_state_parameter_name(&self) -> std::option::Option<&str> {
        self.idp_relay_state_parameter_name.as_deref()
    }
    /// <p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
    /// consist of a required key string with a maximum of 128 characters, and an optional value
    /// string with a maximum of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStudioInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("auth_mode", &self.auth_mode);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("service_role", &self.service_role);
        formatter.field("user_role", &self.user_role);
        formatter.field(
            "workspace_security_group_id",
            &self.workspace_security_group_id,
        );
        formatter.field("engine_security_group_id", &self.engine_security_group_id);
        formatter.field("default_s3_location", &self.default_s3_location);
        formatter.field("idp_auth_url", &self.idp_auth_url);
        formatter.field(
            "idp_relay_state_parameter_name",
            &self.idp_relay_state_parameter_name,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSecurityConfigurationInput {
    /// <p>The name of the security configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The security configuration details in JSON format. For JSON parameters and examples, see
    /// <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security
    /// Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management
    /// Guide</i>.</p>
    pub security_configuration: std::option::Option<std::string::String>,
}
impl CreateSecurityConfigurationInput {
    /// <p>The name of the security configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The security configuration details in JSON format. For JSON parameters and examples, see
    /// <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security
    /// Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management
    /// Guide</i>.</p>
    pub fn security_configuration(&self) -> std::option::Option<&str> {
        self.security_configuration.as_deref()
    }
}
impl std::fmt::Debug for CreateSecurityConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSecurityConfigurationInput");
        formatter.field("name", &self.name);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.finish()
    }
}

/// <p>The input argument to the <a>CancelSteps</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelStepsInput {
    /// <p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and <a>ListClusters</a> to get ClusterIDs. </p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps
    /// and their states for the specified cluster.</p>
    pub step_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
    /// <code>SEND_INTERRUPT</code>.</p>
    pub step_cancellation_option: std::option::Option<crate::model::StepCancellationOption>,
}
impl CancelStepsInput {
    /// <p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and <a>ListClusters</a> to get ClusterIDs. </p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps
    /// and their states for the specified cluster.</p>
    pub fn step_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.step_ids.as_deref()
    }
    /// <p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
    /// <code>SEND_INTERRUPT</code>.</p>
    pub fn step_cancellation_option(
        &self,
    ) -> std::option::Option<&crate::model::StepCancellationOption> {
        self.step_cancellation_option.as_ref()
    }
}
impl std::fmt::Debug for CancelStepsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelStepsInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("step_ids", &self.step_ids);
        formatter.field("step_cancellation_option", &self.step_cancellation_option);
        formatter.finish()
    }
}

/// <p>This input identifies an Amazon EMR resource and a list of tags to attach.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p>The Amazon EMR resource identifier to which tags will be added. For example, a
    /// cluster identifier or an Amazon EMR Studio ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>A list of tags to associate with a resource. Tags are
    /// user-defined key-value pairs that consist of a required key string with a maximum of 128
    /// characters, and an optional value string with a maximum of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsInput {
    /// <p>The Amazon EMR resource identifier to which tags will be added. For example, a
    /// cluster identifier or an Amazon EMR Studio ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>A list of tags to associate with a resource. Tags are
    /// user-defined key-value pairs that consist of a required key string with a maximum of 128
    /// characters, and an optional value string with a maximum of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p> The input argument to the <a>AddJobFlowSteps</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddJobFlowStepsInput {
    /// <p>A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can also be obtained from <a>ListClusters</a>.
    /// </p>
    pub job_flow_id: std::option::Option<std::string::String>,
    /// <p> A list of <a>StepConfig</a> to be executed by the job flow. </p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::StepConfig>>,
}
impl AddJobFlowStepsInput {
    /// <p>A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can also be obtained from <a>ListClusters</a>.
    /// </p>
    pub fn job_flow_id(&self) -> std::option::Option<&str> {
        self.job_flow_id.as_deref()
    }
    /// <p> A list of <a>StepConfig</a> to be executed by the job flow. </p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::StepConfig]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for AddJobFlowStepsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddJobFlowStepsInput");
        formatter.field("job_flow_id", &self.job_flow_id);
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}

/// <p>Input to an AddInstanceGroups call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddInstanceGroupsInput {
    /// <p>Instance groups to add.</p>
    pub instance_groups: std::option::Option<std::vec::Vec<crate::model::InstanceGroupConfig>>,
    /// <p>Job flow in which to add the instance groups.</p>
    pub job_flow_id: std::option::Option<std::string::String>,
}
impl AddInstanceGroupsInput {
    /// <p>Instance groups to add.</p>
    pub fn instance_groups(&self) -> std::option::Option<&[crate::model::InstanceGroupConfig]> {
        self.instance_groups.as_deref()
    }
    /// <p>Job flow in which to add the instance groups.</p>
    pub fn job_flow_id(&self) -> std::option::Option<&str> {
        self.job_flow_id.as_deref()
    }
}
impl std::fmt::Debug for AddInstanceGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddInstanceGroupsInput");
        formatter.field("instance_groups", &self.instance_groups);
        formatter.field("job_flow_id", &self.job_flow_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddInstanceFleetInput {
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>Specifies the configuration of the instance fleet.</p>
    pub instance_fleet: std::option::Option<crate::model::InstanceFleetConfig>,
}
impl AddInstanceFleetInput {
    /// <p>The unique identifier of the cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>Specifies the configuration of the instance fleet.</p>
    pub fn instance_fleet(&self) -> std::option::Option<&crate::model::InstanceFleetConfig> {
        self.instance_fleet.as_ref()
    }
}
impl std::fmt::Debug for AddInstanceFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddInstanceFleetInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("instance_fleet", &self.instance_fleet);
        formatter.finish()
    }
}
