// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => IdentityType::Group,
            "USER" => IdentityType::User,
            other => IdentityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityType::from(s))
    }
}
impl IdentityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityType::Group => "GROUP",
            IdentityType::User => "USER",
            IdentityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "USER"]
    }
}
impl AsRef<str> for IdentityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key-value pair containing user-defined metadata that you can associate with an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as grouping
/// clusters to track your Amazon EMR resource allocation costs. For more information, see
/// <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag
/// Clusters</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A user-defined key, which is the minimum required information for a valid tag. For more
    /// information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag </a>. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A user-defined value, which is optional in a tag. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag
    /// Clusters</a>. </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-defined key, which is the minimum required information for a valid tag. For more
        /// information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag </a>. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A user-defined key, which is the minimum required information for a valid tag. For more
        /// information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag </a>. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A user-defined value, which is optional in a tag. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag
        /// Clusters</a>. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A user-defined value, which is optional in a tag. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag
        /// Clusters</a>. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Specifies the execution engine (cluster) to run the notebook and perform the notebook
/// execution, for example, an EMR cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionEngineConfig {
    /// <p>The unique identifier of the execution engine. For an EMR cluster, this is the cluster
    /// ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of execution engine. A value of <code>EMR</code> specifies an EMR
    /// cluster.</p>
    pub r#type: std::option::Option<crate::model::ExecutionEngineType>,
    /// <p>An optional unique ID of an EC2 security group to associate with the master instance of
    /// the EMR cluster for this notebook execution. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
    /// EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management
    /// Guide</i>.</p>
    pub master_instance_security_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExecutionEngineConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionEngineConfig");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field(
            "master_instance_security_group_id",
            &self.master_instance_security_group_id,
        );
        formatter.finish()
    }
}
/// See [`ExecutionEngineConfig`](crate::model::ExecutionEngineConfig)
pub mod execution_engine_config {
    /// A builder for [`ExecutionEngineConfig`](crate::model::ExecutionEngineConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ExecutionEngineType>,
        pub(crate) master_instance_security_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the execution engine. For an EMR cluster, this is the cluster
        /// ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the execution engine. For an EMR cluster, this is the cluster
        /// ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of execution engine. A value of <code>EMR</code> specifies an EMR
        /// cluster.</p>
        pub fn r#type(mut self, input: crate::model::ExecutionEngineType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of execution engine. A value of <code>EMR</code> specifies an EMR
        /// cluster.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ExecutionEngineType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>An optional unique ID of an EC2 security group to associate with the master instance of
        /// the EMR cluster for this notebook execution. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
        /// EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management
        /// Guide</i>.</p>
        pub fn master_instance_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.master_instance_security_group_id = Some(input.into());
            self
        }
        /// <p>An optional unique ID of an EC2 security group to associate with the master instance of
        /// the EMR cluster for this notebook execution. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
        /// EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management
        /// Guide</i>.</p>
        pub fn set_master_instance_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_instance_security_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionEngineConfig`](crate::model::ExecutionEngineConfig)
        pub fn build(self) -> crate::model::ExecutionEngineConfig {
            crate::model::ExecutionEngineConfig {
                id: self.id,
                r#type: self.r#type,
                master_instance_security_group_id: self.master_instance_security_group_id,
            }
        }
    }
}
impl ExecutionEngineConfig {
    /// Creates a new builder-style object to manufacture [`ExecutionEngineConfig`](crate::model::ExecutionEngineConfig)
    pub fn builder() -> crate::model::execution_engine_config::Builder {
        crate::model::execution_engine_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionEngineType {
    #[allow(missing_docs)] // documentation missing in model
    Emr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionEngineType {
    fn from(s: &str) -> Self {
        match s {
            "EMR" => ExecutionEngineType::Emr,
            other => ExecutionEngineType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionEngineType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionEngineType::from(s))
    }
}
impl ExecutionEngineType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionEngineType::Emr => "EMR",
            ExecutionEngineType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMR"]
    }
}
impl AsRef<str> for ExecutionEngineType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTerminationPolicy {
    /// <p>Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).</p>
    pub idle_timeout: i64,
}
impl std::fmt::Debug for AutoTerminationPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTerminationPolicy");
        formatter.field("idle_timeout", &self.idle_timeout);
        formatter.finish()
    }
}
/// See [`AutoTerminationPolicy`](crate::model::AutoTerminationPolicy)
pub mod auto_termination_policy {
    /// A builder for [`AutoTerminationPolicy`](crate::model::AutoTerminationPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) idle_timeout: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).</p>
        pub fn idle_timeout(mut self, input: i64) -> Self {
            self.idle_timeout = Some(input);
            self
        }
        /// <p>Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).</p>
        pub fn set_idle_timeout(mut self, input: std::option::Option<i64>) -> Self {
            self.idle_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTerminationPolicy`](crate::model::AutoTerminationPolicy)
        pub fn build(self) -> crate::model::AutoTerminationPolicy {
            crate::model::AutoTerminationPolicy {
                idle_timeout: self.idle_timeout.unwrap_or_default(),
            }
        }
    }
}
impl AutoTerminationPolicy {
    /// Creates a new builder-style object to manufacture [`AutoTerminationPolicy`](crate::model::AutoTerminationPolicy)
    pub fn builder() -> crate::model::auto_termination_policy::Builder {
        crate::model::auto_termination_policy::Builder::default()
    }
}

/// <p>Placement group configuration for an Amazon EMR cluster. The configuration specifies the
/// placement strategy that can be applied to instance roles during cluster creation.</p>
/// <p>To use this configuration, consider attaching managed policy
/// AmazonElasticMapReducePlacementGroupPolicy to the EMR role.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacementGroupConfig {
    /// <p>Role of the instance in the cluster.</p>
    /// <p>Starting with Amazon EMR version 5.23.0, the only supported instance role is
    /// <code>MASTER</code>.</p>
    pub instance_role: std::option::Option<crate::model::InstanceRoleType>,
    /// <p>EC2 Placement Group strategy associated with instance role.</p>
    /// <p>Starting with Amazon EMR version 5.23.0, the only supported placement strategy is
    /// <code>SPREAD</code> for the <code>MASTER</code> instance role.</p>
    pub placement_strategy: std::option::Option<crate::model::PlacementGroupStrategy>,
}
impl std::fmt::Debug for PlacementGroupConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacementGroupConfig");
        formatter.field("instance_role", &self.instance_role);
        formatter.field("placement_strategy", &self.placement_strategy);
        formatter.finish()
    }
}
/// See [`PlacementGroupConfig`](crate::model::PlacementGroupConfig)
pub mod placement_group_config {
    /// A builder for [`PlacementGroupConfig`](crate::model::PlacementGroupConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_role: std::option::Option<crate::model::InstanceRoleType>,
        pub(crate) placement_strategy: std::option::Option<crate::model::PlacementGroupStrategy>,
    }
    impl Builder {
        /// <p>Role of the instance in the cluster.</p>
        /// <p>Starting with Amazon EMR version 5.23.0, the only supported instance role is
        /// <code>MASTER</code>.</p>
        pub fn instance_role(mut self, input: crate::model::InstanceRoleType) -> Self {
            self.instance_role = Some(input);
            self
        }
        /// <p>Role of the instance in the cluster.</p>
        /// <p>Starting with Amazon EMR version 5.23.0, the only supported instance role is
        /// <code>MASTER</code>.</p>
        pub fn set_instance_role(
            mut self,
            input: std::option::Option<crate::model::InstanceRoleType>,
        ) -> Self {
            self.instance_role = input;
            self
        }
        /// <p>EC2 Placement Group strategy associated with instance role.</p>
        /// <p>Starting with Amazon EMR version 5.23.0, the only supported placement strategy is
        /// <code>SPREAD</code> for the <code>MASTER</code> instance role.</p>
        pub fn placement_strategy(mut self, input: crate::model::PlacementGroupStrategy) -> Self {
            self.placement_strategy = Some(input);
            self
        }
        /// <p>EC2 Placement Group strategy associated with instance role.</p>
        /// <p>Starting with Amazon EMR version 5.23.0, the only supported placement strategy is
        /// <code>SPREAD</code> for the <code>MASTER</code> instance role.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<crate::model::PlacementGroupStrategy>,
        ) -> Self {
            self.placement_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacementGroupConfig`](crate::model::PlacementGroupConfig)
        pub fn build(self) -> crate::model::PlacementGroupConfig {
            crate::model::PlacementGroupConfig {
                instance_role: self.instance_role,
                placement_strategy: self.placement_strategy,
            }
        }
    }
}
impl PlacementGroupConfig {
    /// Creates a new builder-style object to manufacture [`PlacementGroupConfig`](crate::model::PlacementGroupConfig)
    pub fn builder() -> crate::model::placement_group_config::Builder {
        crate::model::placement_group_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlacementGroupStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Cluster,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Partition,
    #[allow(missing_docs)] // documentation missing in model
    Spread,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlacementGroupStrategy {
    fn from(s: &str) -> Self {
        match s {
            "CLUSTER" => PlacementGroupStrategy::Cluster,
            "NONE" => PlacementGroupStrategy::None,
            "PARTITION" => PlacementGroupStrategy::Partition,
            "SPREAD" => PlacementGroupStrategy::Spread,
            other => PlacementGroupStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlacementGroupStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlacementGroupStrategy::from(s))
    }
}
impl PlacementGroupStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlacementGroupStrategy::Cluster => "CLUSTER",
            PlacementGroupStrategy::None => "NONE",
            PlacementGroupStrategy::Partition => "PARTITION",
            PlacementGroupStrategy::Spread => "SPREAD",
            PlacementGroupStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLUSTER", "NONE", "PARTITION", "SPREAD"]
    }
}
impl AsRef<str> for PlacementGroupStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceRoleType {
    #[allow(missing_docs)] // documentation missing in model
    Core,
    #[allow(missing_docs)] // documentation missing in model
    Master,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceRoleType {
    fn from(s: &str) -> Self {
        match s {
            "CORE" => InstanceRoleType::Core,
            "MASTER" => InstanceRoleType::Master,
            "TASK" => InstanceRoleType::Task,
            other => InstanceRoleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceRoleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceRoleType::from(s))
    }
}
impl InstanceRoleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceRoleType::Core => "CORE",
            InstanceRoleType::Master => "MASTER",
            InstanceRoleType::Task => "TASK",
            InstanceRoleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CORE", "MASTER", "TASK"]
    }
}
impl AsRef<str> for InstanceRoleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Managed scaling policy for an Amazon EMR cluster. The policy specifies the limits for
/// resources that can be added or terminated from a cluster. The policy only applies to the
/// core and task nodes. The master node cannot be scaled after initial configuration. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedScalingPolicy {
    /// <p>The EC2 unit limits for a managed scaling policy. The managed scaling activity of a
    /// cluster is not allowed to go above or below these limits. The limit only applies to the
    /// core and task nodes. The master node cannot be scaled after initial configuration.</p>
    pub compute_limits: std::option::Option<crate::model::ComputeLimits>,
}
impl std::fmt::Debug for ManagedScalingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedScalingPolicy");
        formatter.field("compute_limits", &self.compute_limits);
        formatter.finish()
    }
}
/// See [`ManagedScalingPolicy`](crate::model::ManagedScalingPolicy)
pub mod managed_scaling_policy {
    /// A builder for [`ManagedScalingPolicy`](crate::model::ManagedScalingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compute_limits: std::option::Option<crate::model::ComputeLimits>,
    }
    impl Builder {
        /// <p>The EC2 unit limits for a managed scaling policy. The managed scaling activity of a
        /// cluster is not allowed to go above or below these limits. The limit only applies to the
        /// core and task nodes. The master node cannot be scaled after initial configuration.</p>
        pub fn compute_limits(mut self, input: crate::model::ComputeLimits) -> Self {
            self.compute_limits = Some(input);
            self
        }
        /// <p>The EC2 unit limits for a managed scaling policy. The managed scaling activity of a
        /// cluster is not allowed to go above or below these limits. The limit only applies to the
        /// core and task nodes. The master node cannot be scaled after initial configuration.</p>
        pub fn set_compute_limits(
            mut self,
            input: std::option::Option<crate::model::ComputeLimits>,
        ) -> Self {
            self.compute_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedScalingPolicy`](crate::model::ManagedScalingPolicy)
        pub fn build(self) -> crate::model::ManagedScalingPolicy {
            crate::model::ManagedScalingPolicy {
                compute_limits: self.compute_limits,
            }
        }
    }
}
impl ManagedScalingPolicy {
    /// Creates a new builder-style object to manufacture [`ManagedScalingPolicy`](crate::model::ManagedScalingPolicy)
    pub fn builder() -> crate::model::managed_scaling_policy::Builder {
        crate::model::managed_scaling_policy::Builder::default()
    }
}

/// <p> The EC2 unit limits for a managed scaling policy. The managed scaling activity of a
/// cluster can not be above or below these limits. The limit only applies to the core and task
/// nodes. The master node cannot be scaled after initial configuration. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComputeLimits {
    /// <p> The unit type used for specifying a managed scaling policy. </p>
    pub unit_type: std::option::Option<crate::model::ComputeLimitsUnitType>,
    /// <p> The lower boundary of EC2 units. It is measured through vCPU cores or instances for
    /// instance groups and measured through units for instance fleets. Managed scaling activities
    /// are not allowed beyond this boundary. The limit only applies to the core and task nodes.
    /// The master node cannot be scaled after initial configuration. </p>
    pub minimum_capacity_units: std::option::Option<i32>,
    /// <p> The upper boundary of EC2 units. It is measured through vCPU cores or instances for
    /// instance groups and measured through units for instance fleets. Managed scaling activities
    /// are not allowed beyond this boundary. The limit only applies to the core and task nodes.
    /// The master node cannot be scaled after initial configuration. </p>
    pub maximum_capacity_units: std::option::Option<i32>,
    /// <p> The upper boundary of On-Demand EC2 units. It is measured through vCPU cores or
    /// instances for instance groups and measured through units for instance fleets. The On-Demand
    /// units are not allowed to scale beyond this boundary. The parameter is used to split
    /// capacity allocation between On-Demand and Spot Instances. </p>
    pub maximum_on_demand_capacity_units: std::option::Option<i32>,
    /// <p> The upper boundary of EC2 units for core node type in a cluster. It is measured through
    /// vCPU cores or instances for instance groups and measured through units for instance fleets.
    /// The core units are not allowed to scale beyond this boundary. The parameter is used to
    /// split capacity allocation between core and task nodes. </p>
    pub maximum_core_capacity_units: std::option::Option<i32>,
}
impl std::fmt::Debug for ComputeLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComputeLimits");
        formatter.field("unit_type", &self.unit_type);
        formatter.field("minimum_capacity_units", &self.minimum_capacity_units);
        formatter.field("maximum_capacity_units", &self.maximum_capacity_units);
        formatter.field(
            "maximum_on_demand_capacity_units",
            &self.maximum_on_demand_capacity_units,
        );
        formatter.field(
            "maximum_core_capacity_units",
            &self.maximum_core_capacity_units,
        );
        formatter.finish()
    }
}
/// See [`ComputeLimits`](crate::model::ComputeLimits)
pub mod compute_limits {
    /// A builder for [`ComputeLimits`](crate::model::ComputeLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unit_type: std::option::Option<crate::model::ComputeLimitsUnitType>,
        pub(crate) minimum_capacity_units: std::option::Option<i32>,
        pub(crate) maximum_capacity_units: std::option::Option<i32>,
        pub(crate) maximum_on_demand_capacity_units: std::option::Option<i32>,
        pub(crate) maximum_core_capacity_units: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The unit type used for specifying a managed scaling policy. </p>
        pub fn unit_type(mut self, input: crate::model::ComputeLimitsUnitType) -> Self {
            self.unit_type = Some(input);
            self
        }
        /// <p> The unit type used for specifying a managed scaling policy. </p>
        pub fn set_unit_type(
            mut self,
            input: std::option::Option<crate::model::ComputeLimitsUnitType>,
        ) -> Self {
            self.unit_type = input;
            self
        }
        /// <p> The lower boundary of EC2 units. It is measured through vCPU cores or instances for
        /// instance groups and measured through units for instance fleets. Managed scaling activities
        /// are not allowed beyond this boundary. The limit only applies to the core and task nodes.
        /// The master node cannot be scaled after initial configuration. </p>
        pub fn minimum_capacity_units(mut self, input: i32) -> Self {
            self.minimum_capacity_units = Some(input);
            self
        }
        /// <p> The lower boundary of EC2 units. It is measured through vCPU cores or instances for
        /// instance groups and measured through units for instance fleets. Managed scaling activities
        /// are not allowed beyond this boundary. The limit only applies to the core and task nodes.
        /// The master node cannot be scaled after initial configuration. </p>
        pub fn set_minimum_capacity_units(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_capacity_units = input;
            self
        }
        /// <p> The upper boundary of EC2 units. It is measured through vCPU cores or instances for
        /// instance groups and measured through units for instance fleets. Managed scaling activities
        /// are not allowed beyond this boundary. The limit only applies to the core and task nodes.
        /// The master node cannot be scaled after initial configuration. </p>
        pub fn maximum_capacity_units(mut self, input: i32) -> Self {
            self.maximum_capacity_units = Some(input);
            self
        }
        /// <p> The upper boundary of EC2 units. It is measured through vCPU cores or instances for
        /// instance groups and measured through units for instance fleets. Managed scaling activities
        /// are not allowed beyond this boundary. The limit only applies to the core and task nodes.
        /// The master node cannot be scaled after initial configuration. </p>
        pub fn set_maximum_capacity_units(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_capacity_units = input;
            self
        }
        /// <p> The upper boundary of On-Demand EC2 units. It is measured through vCPU cores or
        /// instances for instance groups and measured through units for instance fleets. The On-Demand
        /// units are not allowed to scale beyond this boundary. The parameter is used to split
        /// capacity allocation between On-Demand and Spot Instances. </p>
        pub fn maximum_on_demand_capacity_units(mut self, input: i32) -> Self {
            self.maximum_on_demand_capacity_units = Some(input);
            self
        }
        /// <p> The upper boundary of On-Demand EC2 units. It is measured through vCPU cores or
        /// instances for instance groups and measured through units for instance fleets. The On-Demand
        /// units are not allowed to scale beyond this boundary. The parameter is used to split
        /// capacity allocation between On-Demand and Spot Instances. </p>
        pub fn set_maximum_on_demand_capacity_units(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_on_demand_capacity_units = input;
            self
        }
        /// <p> The upper boundary of EC2 units for core node type in a cluster. It is measured through
        /// vCPU cores or instances for instance groups and measured through units for instance fleets.
        /// The core units are not allowed to scale beyond this boundary. The parameter is used to
        /// split capacity allocation between core and task nodes. </p>
        pub fn maximum_core_capacity_units(mut self, input: i32) -> Self {
            self.maximum_core_capacity_units = Some(input);
            self
        }
        /// <p> The upper boundary of EC2 units for core node type in a cluster. It is measured through
        /// vCPU cores or instances for instance groups and measured through units for instance fleets.
        /// The core units are not allowed to scale beyond this boundary. The parameter is used to
        /// split capacity allocation between core and task nodes. </p>
        pub fn set_maximum_core_capacity_units(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_core_capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`ComputeLimits`](crate::model::ComputeLimits)
        pub fn build(self) -> crate::model::ComputeLimits {
            crate::model::ComputeLimits {
                unit_type: self.unit_type,
                minimum_capacity_units: self.minimum_capacity_units,
                maximum_capacity_units: self.maximum_capacity_units,
                maximum_on_demand_capacity_units: self.maximum_on_demand_capacity_units,
                maximum_core_capacity_units: self.maximum_core_capacity_units,
            }
        }
    }
}
impl ComputeLimits {
    /// Creates a new builder-style object to manufacture [`ComputeLimits`](crate::model::ComputeLimits)
    pub fn builder() -> crate::model::compute_limits::Builder {
        crate::model::compute_limits::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputeLimitsUnitType {
    #[allow(missing_docs)] // documentation missing in model
    InstanceFleetUnits,
    #[allow(missing_docs)] // documentation missing in model
    Instances,
    #[allow(missing_docs)] // documentation missing in model
    Vcpu,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputeLimitsUnitType {
    fn from(s: &str) -> Self {
        match s {
            "InstanceFleetUnits" => ComputeLimitsUnitType::InstanceFleetUnits,
            "Instances" => ComputeLimitsUnitType::Instances,
            "VCPU" => ComputeLimitsUnitType::Vcpu,
            other => ComputeLimitsUnitType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputeLimitsUnitType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputeLimitsUnitType::from(s))
    }
}
impl ComputeLimitsUnitType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputeLimitsUnitType::InstanceFleetUnits => "InstanceFleetUnits",
            ComputeLimitsUnitType::Instances => "Instances",
            ComputeLimitsUnitType::Vcpu => "VCPU",
            ComputeLimitsUnitType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InstanceFleetUnits", "Instances", "VCPU"]
    }
}
impl AsRef<str> for ComputeLimitsUnitType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
/// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
/// in the <i>Amazon EMR Management Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KerberosAttributes {
    /// <p>The name of the Kerberos realm to which all nodes in a cluster belong. For example,
    /// <code>EC2.INTERNAL</code>. </p>
    pub realm: std::option::Option<std::string::String>,
    /// <p>The password used within the cluster for the kadmin service on the cluster-dedicated
    /// KDC, which maintains Kerberos principals, password policies, and keytabs for the
    /// cluster.</p>
    pub kdc_admin_password: std::option::Option<std::string::String>,
    /// <p>Required only when establishing a cross-realm trust with a KDC in a different realm. The
    /// cross-realm principal password, which must be identical across realms.</p>
    pub cross_realm_trust_principal_password: std::option::Option<std::string::String>,
    /// <p>Required only when establishing a cross-realm trust with an Active Directory domain. A
    /// user with sufficient privileges to join resources to the domain.</p>
    pub ad_domain_join_user: std::option::Option<std::string::String>,
    /// <p>The Active Directory password for <code>ADDomainJoinUser</code>.</p>
    pub ad_domain_join_password: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KerberosAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KerberosAttributes");
        formatter.field("realm", &self.realm);
        formatter.field("kdc_admin_password", &self.kdc_admin_password);
        formatter.field(
            "cross_realm_trust_principal_password",
            &self.cross_realm_trust_principal_password,
        );
        formatter.field("ad_domain_join_user", &self.ad_domain_join_user);
        formatter.field("ad_domain_join_password", &self.ad_domain_join_password);
        formatter.finish()
    }
}
/// See [`KerberosAttributes`](crate::model::KerberosAttributes)
pub mod kerberos_attributes {
    /// A builder for [`KerberosAttributes`](crate::model::KerberosAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) realm: std::option::Option<std::string::String>,
        pub(crate) kdc_admin_password: std::option::Option<std::string::String>,
        pub(crate) cross_realm_trust_principal_password: std::option::Option<std::string::String>,
        pub(crate) ad_domain_join_user: std::option::Option<std::string::String>,
        pub(crate) ad_domain_join_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Kerberos realm to which all nodes in a cluster belong. For example,
        /// <code>EC2.INTERNAL</code>. </p>
        pub fn realm(mut self, input: impl Into<std::string::String>) -> Self {
            self.realm = Some(input.into());
            self
        }
        /// <p>The name of the Kerberos realm to which all nodes in a cluster belong. For example,
        /// <code>EC2.INTERNAL</code>. </p>
        pub fn set_realm(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.realm = input;
            self
        }
        /// <p>The password used within the cluster for the kadmin service on the cluster-dedicated
        /// KDC, which maintains Kerberos principals, password policies, and keytabs for the
        /// cluster.</p>
        pub fn kdc_admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.kdc_admin_password = Some(input.into());
            self
        }
        /// <p>The password used within the cluster for the kadmin service on the cluster-dedicated
        /// KDC, which maintains Kerberos principals, password policies, and keytabs for the
        /// cluster.</p>
        pub fn set_kdc_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kdc_admin_password = input;
            self
        }
        /// <p>Required only when establishing a cross-realm trust with a KDC in a different realm. The
        /// cross-realm principal password, which must be identical across realms.</p>
        pub fn cross_realm_trust_principal_password(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_realm_trust_principal_password = Some(input.into());
            self
        }
        /// <p>Required only when establishing a cross-realm trust with a KDC in a different realm. The
        /// cross-realm principal password, which must be identical across realms.</p>
        pub fn set_cross_realm_trust_principal_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_realm_trust_principal_password = input;
            self
        }
        /// <p>Required only when establishing a cross-realm trust with an Active Directory domain. A
        /// user with sufficient privileges to join resources to the domain.</p>
        pub fn ad_domain_join_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.ad_domain_join_user = Some(input.into());
            self
        }
        /// <p>Required only when establishing a cross-realm trust with an Active Directory domain. A
        /// user with sufficient privileges to join resources to the domain.</p>
        pub fn set_ad_domain_join_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ad_domain_join_user = input;
            self
        }
        /// <p>The Active Directory password for <code>ADDomainJoinUser</code>.</p>
        pub fn ad_domain_join_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.ad_domain_join_password = Some(input.into());
            self
        }
        /// <p>The Active Directory password for <code>ADDomainJoinUser</code>.</p>
        pub fn set_ad_domain_join_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ad_domain_join_password = input;
            self
        }
        /// Consumes the builder and constructs a [`KerberosAttributes`](crate::model::KerberosAttributes)
        pub fn build(self) -> crate::model::KerberosAttributes {
            crate::model::KerberosAttributes {
                realm: self.realm,
                kdc_admin_password: self.kdc_admin_password,
                cross_realm_trust_principal_password: self.cross_realm_trust_principal_password,
                ad_domain_join_user: self.ad_domain_join_user,
                ad_domain_join_password: self.ad_domain_join_password,
            }
        }
    }
}
impl KerberosAttributes {
    /// Creates a new builder-style object to manufacture [`KerberosAttributes`](crate::model::KerberosAttributes)
    pub fn builder() -> crate::model::kerberos_attributes::Builder {
        crate::model::kerberos_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RepoUpgradeOnBoot {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Security,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RepoUpgradeOnBoot {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => RepoUpgradeOnBoot::None,
            "SECURITY" => RepoUpgradeOnBoot::Security,
            other => RepoUpgradeOnBoot::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RepoUpgradeOnBoot {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RepoUpgradeOnBoot::from(s))
    }
}
impl RepoUpgradeOnBoot {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RepoUpgradeOnBoot::None => "NONE",
            RepoUpgradeOnBoot::Security => "SECURITY",
            RepoUpgradeOnBoot::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SECURITY"]
    }
}
impl AsRef<str> for RepoUpgradeOnBoot {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScaleDownBehavior {
    #[allow(missing_docs)] // documentation missing in model
    TerminateAtInstanceHour,
    #[allow(missing_docs)] // documentation missing in model
    TerminateAtTaskCompletion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScaleDownBehavior {
    fn from(s: &str) -> Self {
        match s {
            "TERMINATE_AT_INSTANCE_HOUR" => ScaleDownBehavior::TerminateAtInstanceHour,
            "TERMINATE_AT_TASK_COMPLETION" => ScaleDownBehavior::TerminateAtTaskCompletion,
            other => ScaleDownBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScaleDownBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScaleDownBehavior::from(s))
    }
}
impl ScaleDownBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScaleDownBehavior::TerminateAtInstanceHour => "TERMINATE_AT_INSTANCE_HOUR",
            ScaleDownBehavior::TerminateAtTaskCompletion => "TERMINATE_AT_TASK_COMPLETION",
            ScaleDownBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TERMINATE_AT_INSTANCE_HOUR", "TERMINATE_AT_TASK_COMPLETION"]
    }
}
impl AsRef<str> for ScaleDownBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>Amazon EMR releases 4.x or later.</p>
/// </note>
/// <p>An optional configuration specification to be used when provisioning cluster instances,
/// which can include configurations for applications and software bundled with Amazon EMR. A
/// configuration consists of a classification, properties, and optional nested configurations.
/// A classification refers to an application-specific configuration file. Properties are the
/// settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring
/// Applications</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Configuration {
    /// <p>The classification within a configuration.</p>
    pub classification: std::option::Option<std::string::String>,
    /// <p>A list of additional configurations to apply within a configuration object.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>A set of properties specified within a configuration classification.</p>
    pub properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Configuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Configuration");
        formatter.field("classification", &self.classification);
        formatter.field("configurations", &self.configurations);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`Configuration`](crate::model::Configuration)
pub mod configuration {
    /// A builder for [`Configuration`](crate::model::Configuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) classification: std::option::Option<std::string::String>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The classification within a configuration.</p>
        pub fn classification(mut self, input: impl Into<std::string::String>) -> Self {
            self.classification = Some(input.into());
            self
        }
        /// <p>The classification within a configuration.</p>
        pub fn set_classification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classification = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A list of additional configurations to apply within a configuration object.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>A list of additional configurations to apply within a configuration object.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A set of properties specified within a configuration classification.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.properties = Some(hash_map);
            self
        }
        /// <p>A set of properties specified within a configuration classification.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`Configuration`](crate::model::Configuration)
        pub fn build(self) -> crate::model::Configuration {
            crate::model::Configuration {
                classification: self.classification,
                configurations: self.configurations,
                properties: self.properties,
            }
        }
    }
}
impl Configuration {
    /// Creates a new builder-style object to manufacture [`Configuration`](crate::model::Configuration)
    pub fn builder() -> crate::model::configuration::Builder {
        crate::model::configuration::Builder::default()
    }
}

/// <p>With Amazon EMR release version 4.0 and later, the only accepted parameter is the
/// application name. To pass arguments to applications, you use configuration classifications
/// specified using configuration JSON objects. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring
/// Applications</a>.</p>
/// <p>With earlier Amazon EMR releases, the application is any Amazon or third-party software
/// that you can add to the cluster. This structure contains a list of strings that indicates
/// the software to use with the cluster and accepts a user argument list. Amazon EMR accepts
/// and forwards the argument list to the corresponding installation script as bootstrap action
/// argument.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Application {
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Arguments for Amazon EMR to pass to the application.</p>
    pub args: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>This option is for advanced users only. This is meta information about third-party
    /// applications that third-party vendors use for testing purposes.</p>
    pub additional_info:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Application {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Application");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("args", &self.args);
        formatter.field("additional_info", &self.additional_info);
        formatter.finish()
    }
}
/// See [`Application`](crate::model::Application)
pub mod application {
    /// A builder for [`Application`](crate::model::Application)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) args: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) additional_info: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>Arguments for Amazon EMR to pass to the application.</p>
        pub fn args(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.args.unwrap_or_default();
            v.push(input.into());
            self.args = Some(v);
            self
        }
        /// <p>Arguments for Amazon EMR to pass to the application.</p>
        pub fn set_args(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.args = input;
            self
        }
        /// Adds a key-value pair to `additional_info`.
        ///
        /// To override the contents of this collection use [`set_additional_info`](Self::set_additional_info).
        ///
        /// <p>This option is for advanced users only. This is meta information about third-party
        /// applications that third-party vendors use for testing purposes.</p>
        pub fn additional_info(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_info.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_info = Some(hash_map);
            self
        }
        /// <p>This option is for advanced users only. This is meta information about third-party
        /// applications that third-party vendors use for testing purposes.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_info = input;
            self
        }
        /// Consumes the builder and constructs a [`Application`](crate::model::Application)
        pub fn build(self) -> crate::model::Application {
            crate::model::Application {
                name: self.name,
                version: self.version,
                args: self.args,
                additional_info: self.additional_info,
            }
        }
    }
}
impl Application {
    /// Creates a new builder-style object to manufacture [`Application`](crate::model::Application)
    pub fn builder() -> crate::model::application::Builder {
        crate::model::application::Builder::default()
    }
}

/// <p>The list of supported product configurations that allow user-supplied arguments. EMR
/// accepts these arguments and forwards them to the corresponding installation script as
/// bootstrap action arguments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SupportedProductConfig {
    /// <p>The name of the product configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The list of user-supplied arguments.</p>
    pub args: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SupportedProductConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SupportedProductConfig");
        formatter.field("name", &self.name);
        formatter.field("args", &self.args);
        formatter.finish()
    }
}
/// See [`SupportedProductConfig`](crate::model::SupportedProductConfig)
pub mod supported_product_config {
    /// A builder for [`SupportedProductConfig`](crate::model::SupportedProductConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) args: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the product configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the product configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>The list of user-supplied arguments.</p>
        pub fn args(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.args.unwrap_or_default();
            v.push(input.into());
            self.args = Some(v);
            self
        }
        /// <p>The list of user-supplied arguments.</p>
        pub fn set_args(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.args = input;
            self
        }
        /// Consumes the builder and constructs a [`SupportedProductConfig`](crate::model::SupportedProductConfig)
        pub fn build(self) -> crate::model::SupportedProductConfig {
            crate::model::SupportedProductConfig {
                name: self.name,
                args: self.args,
            }
        }
    }
}
impl SupportedProductConfig {
    /// Creates a new builder-style object to manufacture [`SupportedProductConfig`](crate::model::SupportedProductConfig)
    pub fn builder() -> crate::model::supported_product_config::Builder {
        crate::model::supported_product_config::Builder::default()
    }
}

/// <p>Configuration of a bootstrap action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BootstrapActionConfig {
    /// <p>The name of the bootstrap action.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The script run by the bootstrap action.</p>
    pub script_bootstrap_action: std::option::Option<crate::model::ScriptBootstrapActionConfig>,
}
impl std::fmt::Debug for BootstrapActionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BootstrapActionConfig");
        formatter.field("name", &self.name);
        formatter.field("script_bootstrap_action", &self.script_bootstrap_action);
        formatter.finish()
    }
}
/// See [`BootstrapActionConfig`](crate::model::BootstrapActionConfig)
pub mod bootstrap_action_config {
    /// A builder for [`BootstrapActionConfig`](crate::model::BootstrapActionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) script_bootstrap_action:
            std::option::Option<crate::model::ScriptBootstrapActionConfig>,
    }
    impl Builder {
        /// <p>The name of the bootstrap action.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bootstrap action.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The script run by the bootstrap action.</p>
        pub fn script_bootstrap_action(
            mut self,
            input: crate::model::ScriptBootstrapActionConfig,
        ) -> Self {
            self.script_bootstrap_action = Some(input);
            self
        }
        /// <p>The script run by the bootstrap action.</p>
        pub fn set_script_bootstrap_action(
            mut self,
            input: std::option::Option<crate::model::ScriptBootstrapActionConfig>,
        ) -> Self {
            self.script_bootstrap_action = input;
            self
        }
        /// Consumes the builder and constructs a [`BootstrapActionConfig`](crate::model::BootstrapActionConfig)
        pub fn build(self) -> crate::model::BootstrapActionConfig {
            crate::model::BootstrapActionConfig {
                name: self.name,
                script_bootstrap_action: self.script_bootstrap_action,
            }
        }
    }
}
impl BootstrapActionConfig {
    /// Creates a new builder-style object to manufacture [`BootstrapActionConfig`](crate::model::BootstrapActionConfig)
    pub fn builder() -> crate::model::bootstrap_action_config::Builder {
        crate::model::bootstrap_action_config::Builder::default()
    }
}

/// <p>Configuration of the script to run during a bootstrap action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScriptBootstrapActionConfig {
    /// <p>Location in Amazon S3 of the script to run during a bootstrap action.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>A list of command line arguments to pass to the bootstrap action script.</p>
    pub args: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ScriptBootstrapActionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScriptBootstrapActionConfig");
        formatter.field("path", &self.path);
        formatter.field("args", &self.args);
        formatter.finish()
    }
}
/// See [`ScriptBootstrapActionConfig`](crate::model::ScriptBootstrapActionConfig)
pub mod script_bootstrap_action_config {
    /// A builder for [`ScriptBootstrapActionConfig`](crate::model::ScriptBootstrapActionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) args: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Location in Amazon S3 of the script to run during a bootstrap action.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>Location in Amazon S3 of the script to run during a bootstrap action.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>A list of command line arguments to pass to the bootstrap action script.</p>
        pub fn args(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.args.unwrap_or_default();
            v.push(input.into());
            self.args = Some(v);
            self
        }
        /// <p>A list of command line arguments to pass to the bootstrap action script.</p>
        pub fn set_args(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.args = input;
            self
        }
        /// Consumes the builder and constructs a [`ScriptBootstrapActionConfig`](crate::model::ScriptBootstrapActionConfig)
        pub fn build(self) -> crate::model::ScriptBootstrapActionConfig {
            crate::model::ScriptBootstrapActionConfig {
                path: self.path,
                args: self.args,
            }
        }
    }
}
impl ScriptBootstrapActionConfig {
    /// Creates a new builder-style object to manufacture [`ScriptBootstrapActionConfig`](crate::model::ScriptBootstrapActionConfig)
    pub fn builder() -> crate::model::script_bootstrap_action_config::Builder {
        crate::model::script_bootstrap_action_config::Builder::default()
    }
}

/// <p>Specification for a cluster (job flow) step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepConfig {
    /// <p>The name of the step.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The action to take when the step fails. Use one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TERMINATE_CLUSTER</code> - Shuts down the cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCEL_AND_WAIT</code> - Cancels any pending steps and returns the cluster to the <code>WAITING</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONTINUE</code> - Continues to the next step in the queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TERMINATE_JOB_FLOW</code> - Shuts down the cluster. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
    /// </li>
    /// </ul>
    /// <p>If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p>
    /// <p>If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>
    pub action_on_failure: std::option::Option<crate::model::ActionOnFailure>,
    /// <p>The JAR file used for the step.</p>
    pub hadoop_jar_step: std::option::Option<crate::model::HadoopJarStepConfig>,
}
impl std::fmt::Debug for StepConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepConfig");
        formatter.field("name", &self.name);
        formatter.field("action_on_failure", &self.action_on_failure);
        formatter.field("hadoop_jar_step", &self.hadoop_jar_step);
        formatter.finish()
    }
}
/// See [`StepConfig`](crate::model::StepConfig)
pub mod step_config {
    /// A builder for [`StepConfig`](crate::model::StepConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) action_on_failure: std::option::Option<crate::model::ActionOnFailure>,
        pub(crate) hadoop_jar_step: std::option::Option<crate::model::HadoopJarStepConfig>,
    }
    impl Builder {
        /// <p>The name of the step.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the step.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The action to take when the step fails. Use one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE_CLUSTER</code> - Shuts down the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_AND_WAIT</code> - Cancels any pending steps and returns the cluster to the <code>WAITING</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONTINUE</code> - Continues to the next step in the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATE_JOB_FLOW</code> - Shuts down the cluster. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
        /// </li>
        /// </ul>
        /// <p>If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p>
        /// <p>If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>
        pub fn action_on_failure(mut self, input: crate::model::ActionOnFailure) -> Self {
            self.action_on_failure = Some(input);
            self
        }
        /// <p>The action to take when the step fails. Use one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TERMINATE_CLUSTER</code> - Shuts down the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_AND_WAIT</code> - Cancels any pending steps and returns the cluster to the <code>WAITING</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONTINUE</code> - Continues to the next step in the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATE_JOB_FLOW</code> - Shuts down the cluster. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
        /// </li>
        /// </ul>
        /// <p>If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p>
        /// <p>If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>
        pub fn set_action_on_failure(
            mut self,
            input: std::option::Option<crate::model::ActionOnFailure>,
        ) -> Self {
            self.action_on_failure = input;
            self
        }
        /// <p>The JAR file used for the step.</p>
        pub fn hadoop_jar_step(mut self, input: crate::model::HadoopJarStepConfig) -> Self {
            self.hadoop_jar_step = Some(input);
            self
        }
        /// <p>The JAR file used for the step.</p>
        pub fn set_hadoop_jar_step(
            mut self,
            input: std::option::Option<crate::model::HadoopJarStepConfig>,
        ) -> Self {
            self.hadoop_jar_step = input;
            self
        }
        /// Consumes the builder and constructs a [`StepConfig`](crate::model::StepConfig)
        pub fn build(self) -> crate::model::StepConfig {
            crate::model::StepConfig {
                name: self.name,
                action_on_failure: self.action_on_failure,
                hadoop_jar_step: self.hadoop_jar_step,
            }
        }
    }
}
impl StepConfig {
    /// Creates a new builder-style object to manufacture [`StepConfig`](crate::model::StepConfig)
    pub fn builder() -> crate::model::step_config::Builder {
        crate::model::step_config::Builder::default()
    }
}

/// <p>A job flow step consisting of a JAR file whose main function will be executed. The main
/// function submits a job for Hadoop to execute and waits for the job to finish or
/// fail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HadoopJarStepConfig {
    /// <p>A list of Java properties that are set when the step runs. You can use these properties
    /// to pass key-value pairs to your main function.</p>
    pub properties: std::option::Option<std::vec::Vec<crate::model::KeyValue>>,
    /// <p>A path to a JAR file run during the step.</p>
    pub jar: std::option::Option<std::string::String>,
    /// <p>The name of the main class in the specified Java file. If not specified, the JAR file
    /// should specify a Main-Class in its manifest file.</p>
    pub main_class: std::option::Option<std::string::String>,
    /// <p>A list of command line arguments passed to the JAR file's main function when
    /// executed.</p>
    pub args: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for HadoopJarStepConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HadoopJarStepConfig");
        formatter.field("properties", &self.properties);
        formatter.field("jar", &self.jar);
        formatter.field("main_class", &self.main_class);
        formatter.field("args", &self.args);
        formatter.finish()
    }
}
/// See [`HadoopJarStepConfig`](crate::model::HadoopJarStepConfig)
pub mod hadoop_jar_step_config {
    /// A builder for [`HadoopJarStepConfig`](crate::model::HadoopJarStepConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) properties: std::option::Option<std::vec::Vec<crate::model::KeyValue>>,
        pub(crate) jar: std::option::Option<std::string::String>,
        pub(crate) main_class: std::option::Option<std::string::String>,
        pub(crate) args: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of Java properties that are set when the step runs. You can use these properties
        /// to pass key-value pairs to your main function.</p>
        pub fn properties(mut self, input: impl Into<crate::model::KeyValue>) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input.into());
            self.properties = Some(v);
            self
        }
        /// <p>A list of Java properties that are set when the step runs. You can use these properties
        /// to pass key-value pairs to your main function.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValue>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>A path to a JAR file run during the step.</p>
        pub fn jar(mut self, input: impl Into<std::string::String>) -> Self {
            self.jar = Some(input.into());
            self
        }
        /// <p>A path to a JAR file run during the step.</p>
        pub fn set_jar(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.jar = input;
            self
        }
        /// <p>The name of the main class in the specified Java file. If not specified, the JAR file
        /// should specify a Main-Class in its manifest file.</p>
        pub fn main_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.main_class = Some(input.into());
            self
        }
        /// <p>The name of the main class in the specified Java file. If not specified, the JAR file
        /// should specify a Main-Class in its manifest file.</p>
        pub fn set_main_class(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.main_class = input;
            self
        }
        /// Appends an item to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>A list of command line arguments passed to the JAR file's main function when
        /// executed.</p>
        pub fn args(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.args.unwrap_or_default();
            v.push(input.into());
            self.args = Some(v);
            self
        }
        /// <p>A list of command line arguments passed to the JAR file's main function when
        /// executed.</p>
        pub fn set_args(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.args = input;
            self
        }
        /// Consumes the builder and constructs a [`HadoopJarStepConfig`](crate::model::HadoopJarStepConfig)
        pub fn build(self) -> crate::model::HadoopJarStepConfig {
            crate::model::HadoopJarStepConfig {
                properties: self.properties,
                jar: self.jar,
                main_class: self.main_class,
                args: self.args,
            }
        }
    }
}
impl HadoopJarStepConfig {
    /// Creates a new builder-style object to manufacture [`HadoopJarStepConfig`](crate::model::HadoopJarStepConfig)
    pub fn builder() -> crate::model::hadoop_jar_step_config::Builder {
        crate::model::hadoop_jar_step_config::Builder::default()
    }
}

/// <p>A key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyValue {
    /// <p>The unique identifier of a key-value pair.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value part of the identified key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeyValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyValue");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`KeyValue`](crate::model::KeyValue)
pub mod key_value {
    /// A builder for [`KeyValue`](crate::model::KeyValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a key-value pair.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The unique identifier of a key-value pair.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value part of the identified key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value part of the identified key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyValue`](crate::model::KeyValue)
        pub fn build(self) -> crate::model::KeyValue {
            crate::model::KeyValue {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl KeyValue {
    /// Creates a new builder-style object to manufacture [`KeyValue`](crate::model::KeyValue)
    pub fn builder() -> crate::model::key_value::Builder {
        crate::model::key_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionOnFailure {
    #[allow(missing_docs)] // documentation missing in model
    CancelAndWait,
    #[allow(missing_docs)] // documentation missing in model
    Continue,
    #[allow(missing_docs)] // documentation missing in model
    TerminateCluster,
    #[allow(missing_docs)] // documentation missing in model
    TerminateJobFlow,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionOnFailure {
    fn from(s: &str) -> Self {
        match s {
            "CANCEL_AND_WAIT" => ActionOnFailure::CancelAndWait,
            "CONTINUE" => ActionOnFailure::Continue,
            "TERMINATE_CLUSTER" => ActionOnFailure::TerminateCluster,
            "TERMINATE_JOB_FLOW" => ActionOnFailure::TerminateJobFlow,
            other => ActionOnFailure::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionOnFailure {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionOnFailure::from(s))
    }
}
impl ActionOnFailure {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionOnFailure::CancelAndWait => "CANCEL_AND_WAIT",
            ActionOnFailure::Continue => "CONTINUE",
            ActionOnFailure::TerminateCluster => "TERMINATE_CLUSTER",
            ActionOnFailure::TerminateJobFlow => "TERMINATE_JOB_FLOW",
            ActionOnFailure::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCEL_AND_WAIT",
            "CONTINUE",
            "TERMINATE_CLUSTER",
            "TERMINATE_JOB_FLOW",
        ]
    }
}
impl AsRef<str> for ActionOnFailure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A description of the Amazon EC2 instance on which the cluster (job flow) runs. A valid
/// JobFlowInstancesConfig must contain either InstanceGroups or InstanceFleets. They cannot be
/// used together. You may also have MasterInstanceType, SlaveInstanceType, and InstanceCount
/// (all three must be present), but we don't recommend this configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobFlowInstancesConfig {
    /// <p>The EC2 instance type of the master node.</p>
    pub master_instance_type: std::option::Option<std::string::String>,
    /// <p>The EC2 instance type of the core and task nodes.</p>
    pub slave_instance_type: std::option::Option<std::string::String>,
    /// <p>The number of EC2 instances in the cluster.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>Configuration for the instance groups in a cluster.</p>
    pub instance_groups: std::option::Option<std::vec::Vec<crate::model::InstanceGroupConfig>>,
    /// <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
    /// later, excluding 5.0.x versions.</p>
    /// </note>
    /// <p>Describes the EC2 instances and instance configurations for clusters that use the
    /// instance fleet configuration.</p>
    pub instance_fleets: std::option::Option<std::vec::Vec<crate::model::InstanceFleetConfig>>,
    /// <p>The name of the EC2 key pair that can be used to connect to the master node using SSH as
    /// the user called "hadoop."</p>
    pub ec2_key_name: std::option::Option<std::string::String>,
    /// <p>The Availability Zone in which the cluster runs.</p>
    pub placement: std::option::Option<crate::model::PlacementType>,
    /// <p>Specifies whether the cluster should remain available after completing all steps. Defaults to <code>true</code>. For more information about configuring cluster termination, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control Cluster Termination</a> in the <i>EMR Management Guide</i>.</p>
    pub keep_job_flow_alive_when_no_steps: bool,
    /// <p>Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being
    /// terminated by API call, user intervention, or in the event of a job-flow error.</p>
    pub termination_protected: bool,
    /// <p>Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the
    /// cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained),
    /// "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this
    /// value, the default of 0.18 is used, unless the <code>AmiVersion</code> parameter is set in
    /// the RunJobFlow call, in which case the default version of Hadoop for that AMI version is
    /// used.</p>
    pub hadoop_version: std::option::Option<std::string::String>,
    /// <p>Applies to clusters that use the uniform instance group configuration. To launch the
    /// cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier
    /// of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this
    /// value and your account supports EC2-Classic, the cluster launches in EC2-Classic.</p>
    pub ec2_subnet_id: std::option::Option<std::string::String>,
    /// <p>Applies to clusters that use the instance fleet configuration. When multiple EC2 subnet
    /// IDs are specified, Amazon EMR evaluates them and launches instances in the optimal
    /// subnet.</p>
    /// <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
    /// later, excluding 5.0.x versions.</p>
    /// </note>
    pub ec2_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifier of the Amazon EC2 security group for the master node. If you specify <code>EmrManagedMasterSecurityGroup</code>, you must also specify <code>EmrManagedSlaveSecurityGroup</code>.</p>
    pub emr_managed_master_security_group: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon EC2 security group for the core and task nodes. If you specify <code>EmrManagedSlaveSecurityGroup</code>, you must also specify <code>EmrManagedMasterSecurityGroup</code>.</p>
    pub emr_managed_slave_security_group: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access
    /// clusters in VPC private subnets.</p>
    pub service_access_security_group: std::option::Option<std::string::String>,
    /// <p>A list of additional Amazon EC2 security group IDs for the master node.</p>
    pub additional_master_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>
    pub additional_slave_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for JobFlowInstancesConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobFlowInstancesConfig");
        formatter.field("master_instance_type", &self.master_instance_type);
        formatter.field("slave_instance_type", &self.slave_instance_type);
        formatter.field("instance_count", &self.instance_count);
        formatter.field("instance_groups", &self.instance_groups);
        formatter.field("instance_fleets", &self.instance_fleets);
        formatter.field("ec2_key_name", &self.ec2_key_name);
        formatter.field("placement", &self.placement);
        formatter.field(
            "keep_job_flow_alive_when_no_steps",
            &self.keep_job_flow_alive_when_no_steps,
        );
        formatter.field("termination_protected", &self.termination_protected);
        formatter.field("hadoop_version", &self.hadoop_version);
        formatter.field("ec2_subnet_id", &self.ec2_subnet_id);
        formatter.field("ec2_subnet_ids", &self.ec2_subnet_ids);
        formatter.field(
            "emr_managed_master_security_group",
            &self.emr_managed_master_security_group,
        );
        formatter.field(
            "emr_managed_slave_security_group",
            &self.emr_managed_slave_security_group,
        );
        formatter.field(
            "service_access_security_group",
            &self.service_access_security_group,
        );
        formatter.field(
            "additional_master_security_groups",
            &self.additional_master_security_groups,
        );
        formatter.field(
            "additional_slave_security_groups",
            &self.additional_slave_security_groups,
        );
        formatter.finish()
    }
}
/// See [`JobFlowInstancesConfig`](crate::model::JobFlowInstancesConfig)
pub mod job_flow_instances_config {
    /// A builder for [`JobFlowInstancesConfig`](crate::model::JobFlowInstancesConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) master_instance_type: std::option::Option<std::string::String>,
        pub(crate) slave_instance_type: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) instance_groups:
            std::option::Option<std::vec::Vec<crate::model::InstanceGroupConfig>>,
        pub(crate) instance_fleets:
            std::option::Option<std::vec::Vec<crate::model::InstanceFleetConfig>>,
        pub(crate) ec2_key_name: std::option::Option<std::string::String>,
        pub(crate) placement: std::option::Option<crate::model::PlacementType>,
        pub(crate) keep_job_flow_alive_when_no_steps: std::option::Option<bool>,
        pub(crate) termination_protected: std::option::Option<bool>,
        pub(crate) hadoop_version: std::option::Option<std::string::String>,
        pub(crate) ec2_subnet_id: std::option::Option<std::string::String>,
        pub(crate) ec2_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) emr_managed_master_security_group: std::option::Option<std::string::String>,
        pub(crate) emr_managed_slave_security_group: std::option::Option<std::string::String>,
        pub(crate) service_access_security_group: std::option::Option<std::string::String>,
        pub(crate) additional_master_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) additional_slave_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The EC2 instance type of the master node.</p>
        pub fn master_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 instance type of the master node.</p>
        pub fn set_master_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_instance_type = input;
            self
        }
        /// <p>The EC2 instance type of the core and task nodes.</p>
        pub fn slave_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.slave_instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 instance type of the core and task nodes.</p>
        pub fn set_slave_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slave_instance_type = input;
            self
        }
        /// <p>The number of EC2 instances in the cluster.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of EC2 instances in the cluster.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// Appends an item to `instance_groups`.
        ///
        /// To override the contents of this collection use [`set_instance_groups`](Self::set_instance_groups).
        ///
        /// <p>Configuration for the instance groups in a cluster.</p>
        pub fn instance_groups(
            mut self,
            input: impl Into<crate::model::InstanceGroupConfig>,
        ) -> Self {
            let mut v = self.instance_groups.unwrap_or_default();
            v.push(input.into());
            self.instance_groups = Some(v);
            self
        }
        /// <p>Configuration for the instance groups in a cluster.</p>
        pub fn set_instance_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupConfig>>,
        ) -> Self {
            self.instance_groups = input;
            self
        }
        /// Appends an item to `instance_fleets`.
        ///
        /// To override the contents of this collection use [`set_instance_fleets`](Self::set_instance_fleets).
        ///
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        /// <p>Describes the EC2 instances and instance configurations for clusters that use the
        /// instance fleet configuration.</p>
        pub fn instance_fleets(
            mut self,
            input: impl Into<crate::model::InstanceFleetConfig>,
        ) -> Self {
            let mut v = self.instance_fleets.unwrap_or_default();
            v.push(input.into());
            self.instance_fleets = Some(v);
            self
        }
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        /// <p>Describes the EC2 instances and instance configurations for clusters that use the
        /// instance fleet configuration.</p>
        pub fn set_instance_fleets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceFleetConfig>>,
        ) -> Self {
            self.instance_fleets = input;
            self
        }
        /// <p>The name of the EC2 key pair that can be used to connect to the master node using SSH as
        /// the user called "hadoop."</p>
        pub fn ec2_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_key_name = Some(input.into());
            self
        }
        /// <p>The name of the EC2 key pair that can be used to connect to the master node using SSH as
        /// the user called "hadoop."</p>
        pub fn set_ec2_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_key_name = input;
            self
        }
        /// <p>The Availability Zone in which the cluster runs.</p>
        pub fn placement(mut self, input: crate::model::PlacementType) -> Self {
            self.placement = Some(input);
            self
        }
        /// <p>The Availability Zone in which the cluster runs.</p>
        pub fn set_placement(
            mut self,
            input: std::option::Option<crate::model::PlacementType>,
        ) -> Self {
            self.placement = input;
            self
        }
        /// <p>Specifies whether the cluster should remain available after completing all steps. Defaults to <code>true</code>. For more information about configuring cluster termination, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control Cluster Termination</a> in the <i>EMR Management Guide</i>.</p>
        pub fn keep_job_flow_alive_when_no_steps(mut self, input: bool) -> Self {
            self.keep_job_flow_alive_when_no_steps = Some(input);
            self
        }
        /// <p>Specifies whether the cluster should remain available after completing all steps. Defaults to <code>true</code>. For more information about configuring cluster termination, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control Cluster Termination</a> in the <i>EMR Management Guide</i>.</p>
        pub fn set_keep_job_flow_alive_when_no_steps(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.keep_job_flow_alive_when_no_steps = input;
            self
        }
        /// <p>Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being
        /// terminated by API call, user intervention, or in the event of a job-flow error.</p>
        pub fn termination_protected(mut self, input: bool) -> Self {
            self.termination_protected = Some(input);
            self
        }
        /// <p>Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being
        /// terminated by API call, user intervention, or in the event of a job-flow error.</p>
        pub fn set_termination_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.termination_protected = input;
            self
        }
        /// <p>Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the
        /// cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained),
        /// "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this
        /// value, the default of 0.18 is used, unless the <code>AmiVersion</code> parameter is set in
        /// the RunJobFlow call, in which case the default version of Hadoop for that AMI version is
        /// used.</p>
        pub fn hadoop_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.hadoop_version = Some(input.into());
            self
        }
        /// <p>Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the
        /// cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained),
        /// "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this
        /// value, the default of 0.18 is used, unless the <code>AmiVersion</code> parameter is set in
        /// the RunJobFlow call, in which case the default version of Hadoop for that AMI version is
        /// used.</p>
        pub fn set_hadoop_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hadoop_version = input;
            self
        }
        /// <p>Applies to clusters that use the uniform instance group configuration. To launch the
        /// cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier
        /// of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this
        /// value and your account supports EC2-Classic, the cluster launches in EC2-Classic.</p>
        pub fn ec2_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_subnet_id = Some(input.into());
            self
        }
        /// <p>Applies to clusters that use the uniform instance group configuration. To launch the
        /// cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier
        /// of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this
        /// value and your account supports EC2-Classic, the cluster launches in EC2-Classic.</p>
        pub fn set_ec2_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_subnet_id = input;
            self
        }
        /// Appends an item to `ec2_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_subnet_ids`](Self::set_ec2_subnet_ids).
        ///
        /// <p>Applies to clusters that use the instance fleet configuration. When multiple EC2 subnet
        /// IDs are specified, Amazon EMR evaluates them and launches instances in the optimal
        /// subnet.</p>
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        pub fn ec2_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_subnet_ids = Some(v);
            self
        }
        /// <p>Applies to clusters that use the instance fleet configuration. When multiple EC2 subnet
        /// IDs are specified, Amazon EMR evaluates them and launches instances in the optimal
        /// subnet.</p>
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        pub fn set_ec2_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_subnet_ids = input;
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the master node. If you specify <code>EmrManagedMasterSecurityGroup</code>, you must also specify <code>EmrManagedSlaveSecurityGroup</code>.</p>
        pub fn emr_managed_master_security_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.emr_managed_master_security_group = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the master node. If you specify <code>EmrManagedMasterSecurityGroup</code>, you must also specify <code>EmrManagedSlaveSecurityGroup</code>.</p>
        pub fn set_emr_managed_master_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.emr_managed_master_security_group = input;
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the core and task nodes. If you specify <code>EmrManagedSlaveSecurityGroup</code>, you must also specify <code>EmrManagedMasterSecurityGroup</code>.</p>
        pub fn emr_managed_slave_security_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.emr_managed_slave_security_group = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the core and task nodes. If you specify <code>EmrManagedSlaveSecurityGroup</code>, you must also specify <code>EmrManagedMasterSecurityGroup</code>.</p>
        pub fn set_emr_managed_slave_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.emr_managed_slave_security_group = input;
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access
        /// clusters in VPC private subnets.</p>
        pub fn service_access_security_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.service_access_security_group = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access
        /// clusters in VPC private subnets.</p>
        pub fn set_service_access_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_security_group = input;
            self
        }
        /// Appends an item to `additional_master_security_groups`.
        ///
        /// To override the contents of this collection use [`set_additional_master_security_groups`](Self::set_additional_master_security_groups).
        ///
        /// <p>A list of additional Amazon EC2 security group IDs for the master node.</p>
        pub fn additional_master_security_groups(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_master_security_groups.unwrap_or_default();
            v.push(input.into());
            self.additional_master_security_groups = Some(v);
            self
        }
        /// <p>A list of additional Amazon EC2 security group IDs for the master node.</p>
        pub fn set_additional_master_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_master_security_groups = input;
            self
        }
        /// Appends an item to `additional_slave_security_groups`.
        ///
        /// To override the contents of this collection use [`set_additional_slave_security_groups`](Self::set_additional_slave_security_groups).
        ///
        /// <p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>
        pub fn additional_slave_security_groups(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_slave_security_groups.unwrap_or_default();
            v.push(input.into());
            self.additional_slave_security_groups = Some(v);
            self
        }
        /// <p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>
        pub fn set_additional_slave_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_slave_security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`JobFlowInstancesConfig`](crate::model::JobFlowInstancesConfig)
        pub fn build(self) -> crate::model::JobFlowInstancesConfig {
            crate::model::JobFlowInstancesConfig {
                master_instance_type: self.master_instance_type,
                slave_instance_type: self.slave_instance_type,
                instance_count: self.instance_count,
                instance_groups: self.instance_groups,
                instance_fleets: self.instance_fleets,
                ec2_key_name: self.ec2_key_name,
                placement: self.placement,
                keep_job_flow_alive_when_no_steps: self
                    .keep_job_flow_alive_when_no_steps
                    .unwrap_or_default(),
                termination_protected: self.termination_protected.unwrap_or_default(),
                hadoop_version: self.hadoop_version,
                ec2_subnet_id: self.ec2_subnet_id,
                ec2_subnet_ids: self.ec2_subnet_ids,
                emr_managed_master_security_group: self.emr_managed_master_security_group,
                emr_managed_slave_security_group: self.emr_managed_slave_security_group,
                service_access_security_group: self.service_access_security_group,
                additional_master_security_groups: self.additional_master_security_groups,
                additional_slave_security_groups: self.additional_slave_security_groups,
            }
        }
    }
}
impl JobFlowInstancesConfig {
    /// Creates a new builder-style object to manufacture [`JobFlowInstancesConfig`](crate::model::JobFlowInstancesConfig)
    pub fn builder() -> crate::model::job_flow_instances_config::Builder {
        crate::model::job_flow_instances_config::Builder::default()
    }
}

/// <p>The Amazon EC2 Availability Zone configuration of the cluster (job flow).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacementType {
    /// <p>The Amazon EC2 Availability Zone for the cluster. <code>AvailabilityZone</code> is used
    /// for uniform instance groups, while <code>AvailabilityZones</code> (plural) is used for
    /// instance fleets.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>When multiple Availability Zones are specified, Amazon EMR evaluates them and launches
    /// instances in the optimal Availability Zone. <code>AvailabilityZones</code> is used for
    /// instance fleets, while <code>AvailabilityZone</code> (singular) is used for uniform
    /// instance groups.</p>
    /// <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
    /// later, excluding 5.0.x versions.</p>
    /// </note>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PlacementType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacementType");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.finish()
    }
}
/// See [`PlacementType`](crate::model::PlacementType)
pub mod placement_type {
    /// A builder for [`PlacementType`](crate::model::PlacementType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon EC2 Availability Zone for the cluster. <code>AvailabilityZone</code> is used
        /// for uniform instance groups, while <code>AvailabilityZones</code> (plural) is used for
        /// instance fleets.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 Availability Zone for the cluster. <code>AvailabilityZone</code> is used
        /// for uniform instance groups, while <code>AvailabilityZones</code> (plural) is used for
        /// instance fleets.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>When multiple Availability Zones are specified, Amazon EMR evaluates them and launches
        /// instances in the optimal Availability Zone. <code>AvailabilityZones</code> is used for
        /// instance fleets, while <code>AvailabilityZone</code> (singular) is used for uniform
        /// instance groups.</p>
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>When multiple Availability Zones are specified, Amazon EMR evaluates them and launches
        /// instances in the optimal Availability Zone. <code>AvailabilityZones</code> is used for
        /// instance fleets, while <code>AvailabilityZone</code> (singular) is used for uniform
        /// instance groups.</p>
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacementType`](crate::model::PlacementType)
        pub fn build(self) -> crate::model::PlacementType {
            crate::model::PlacementType {
                availability_zone: self.availability_zone,
                availability_zones: self.availability_zones,
            }
        }
    }
}
impl PlacementType {
    /// Creates a new builder-style object to manufacture [`PlacementType`](crate::model::PlacementType)
    pub fn builder() -> crate::model::placement_type::Builder {
        crate::model::placement_type::Builder::default()
    }
}

/// <p>The configuration that defines an instance fleet.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceFleetConfig {
    /// <p>The friendly name of the instance fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, and
    /// TASK.</p>
    pub instance_fleet_type: std::option::Option<crate::model::InstanceFleetType>,
    /// <p>The target capacity of On-Demand units for the instance fleet, which determines how many
    /// On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to
    /// provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each
    /// instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand
    /// Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target
    /// capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled,
    /// even if this results in an overage. For example, if there are 2 units remaining to fulfill
    /// capacity, and Amazon EMR can only provision an instance with a
    /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
    /// capacity is exceeded by 3 units.</p>
    /// <note>
    /// <p>If not specified or set to 0, only Spot Instances are provisioned for the instance
    /// fleet using <code>TargetSpotCapacity</code>. At least one of
    /// <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be
    /// greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code>
    /// and <code>TargetOnDemandCapacity</code> can be specified, and its value must be
    /// 1.</p>
    /// </note>
    pub target_on_demand_capacity: std::option::Option<i32>,
    /// <p>The target capacity of Spot units for the instance fleet, which determines how many Spot
    /// Instances to provision. When the instance fleet launches, Amazon EMR tries to provision
    /// Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance
    /// configuration has a specified <code>WeightedCapacity</code>. When a Spot Instance is
    /// provisioned, the <code>WeightedCapacity</code> units count toward the target capacity.
    /// Amazon EMR provisions instances until the target capacity is totally fulfilled, even if
    /// this results in an overage. For example, if there are 2 units remaining to fulfill
    /// capacity, and Amazon EMR can only provision an instance with a
    /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
    /// capacity is exceeded by 3 units.</p>
    /// <note>
    /// <p>If not specified or set to 0, only On-Demand Instances are provisioned for the
    /// instance fleet. At least one of <code>TargetSpotCapacity</code> and
    /// <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance
    /// fleet, only one of <code>TargetSpotCapacity</code> and
    /// <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p>
    /// </note>
    pub target_spot_capacity: std::option::Option<i32>,
    /// <p>The instance type configurations that define the EC2 instances in the instance
    /// fleet.</p>
    pub instance_type_configs: std::option::Option<std::vec::Vec<crate::model::InstanceTypeConfig>>,
    /// <p>The launch specification for the instance fleet.</p>
    pub launch_specifications:
        std::option::Option<crate::model::InstanceFleetProvisioningSpecifications>,
}
impl std::fmt::Debug for InstanceFleetConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceFleetConfig");
        formatter.field("name", &self.name);
        formatter.field("instance_fleet_type", &self.instance_fleet_type);
        formatter.field("target_on_demand_capacity", &self.target_on_demand_capacity);
        formatter.field("target_spot_capacity", &self.target_spot_capacity);
        formatter.field("instance_type_configs", &self.instance_type_configs);
        formatter.field("launch_specifications", &self.launch_specifications);
        formatter.finish()
    }
}
/// See [`InstanceFleetConfig`](crate::model::InstanceFleetConfig)
pub mod instance_fleet_config {
    /// A builder for [`InstanceFleetConfig`](crate::model::InstanceFleetConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) instance_fleet_type: std::option::Option<crate::model::InstanceFleetType>,
        pub(crate) target_on_demand_capacity: std::option::Option<i32>,
        pub(crate) target_spot_capacity: std::option::Option<i32>,
        pub(crate) instance_type_configs:
            std::option::Option<std::vec::Vec<crate::model::InstanceTypeConfig>>,
        pub(crate) launch_specifications:
            std::option::Option<crate::model::InstanceFleetProvisioningSpecifications>,
    }
    impl Builder {
        /// <p>The friendly name of the instance fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the instance fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, and
        /// TASK.</p>
        pub fn instance_fleet_type(mut self, input: crate::model::InstanceFleetType) -> Self {
            self.instance_fleet_type = Some(input);
            self
        }
        /// <p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, and
        /// TASK.</p>
        pub fn set_instance_fleet_type(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetType>,
        ) -> Self {
            self.instance_fleet_type = input;
            self
        }
        /// <p>The target capacity of On-Demand units for the instance fleet, which determines how many
        /// On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to
        /// provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each
        /// instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand
        /// Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target
        /// capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled,
        /// even if this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units.</p>
        /// <note>
        /// <p>If not specified or set to 0, only Spot Instances are provisioned for the instance
        /// fleet using <code>TargetSpotCapacity</code>. At least one of
        /// <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be
        /// greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code>
        /// and <code>TargetOnDemandCapacity</code> can be specified, and its value must be
        /// 1.</p>
        /// </note>
        pub fn target_on_demand_capacity(mut self, input: i32) -> Self {
            self.target_on_demand_capacity = Some(input);
            self
        }
        /// <p>The target capacity of On-Demand units for the instance fleet, which determines how many
        /// On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to
        /// provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each
        /// instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand
        /// Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target
        /// capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled,
        /// even if this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units.</p>
        /// <note>
        /// <p>If not specified or set to 0, only Spot Instances are provisioned for the instance
        /// fleet using <code>TargetSpotCapacity</code>. At least one of
        /// <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be
        /// greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code>
        /// and <code>TargetOnDemandCapacity</code> can be specified, and its value must be
        /// 1.</p>
        /// </note>
        pub fn set_target_on_demand_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.target_on_demand_capacity = input;
            self
        }
        /// <p>The target capacity of Spot units for the instance fleet, which determines how many Spot
        /// Instances to provision. When the instance fleet launches, Amazon EMR tries to provision
        /// Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance
        /// configuration has a specified <code>WeightedCapacity</code>. When a Spot Instance is
        /// provisioned, the <code>WeightedCapacity</code> units count toward the target capacity.
        /// Amazon EMR provisions instances until the target capacity is totally fulfilled, even if
        /// this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units.</p>
        /// <note>
        /// <p>If not specified or set to 0, only On-Demand Instances are provisioned for the
        /// instance fleet. At least one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance
        /// fleet, only one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p>
        /// </note>
        pub fn target_spot_capacity(mut self, input: i32) -> Self {
            self.target_spot_capacity = Some(input);
            self
        }
        /// <p>The target capacity of Spot units for the instance fleet, which determines how many Spot
        /// Instances to provision. When the instance fleet launches, Amazon EMR tries to provision
        /// Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance
        /// configuration has a specified <code>WeightedCapacity</code>. When a Spot Instance is
        /// provisioned, the <code>WeightedCapacity</code> units count toward the target capacity.
        /// Amazon EMR provisions instances until the target capacity is totally fulfilled, even if
        /// this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units.</p>
        /// <note>
        /// <p>If not specified or set to 0, only On-Demand Instances are provisioned for the
        /// instance fleet. At least one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance
        /// fleet, only one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p>
        /// </note>
        pub fn set_target_spot_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.target_spot_capacity = input;
            self
        }
        /// Appends an item to `instance_type_configs`.
        ///
        /// To override the contents of this collection use [`set_instance_type_configs`](Self::set_instance_type_configs).
        ///
        /// <p>The instance type configurations that define the EC2 instances in the instance
        /// fleet.</p>
        pub fn instance_type_configs(
            mut self,
            input: impl Into<crate::model::InstanceTypeConfig>,
        ) -> Self {
            let mut v = self.instance_type_configs.unwrap_or_default();
            v.push(input.into());
            self.instance_type_configs = Some(v);
            self
        }
        /// <p>The instance type configurations that define the EC2 instances in the instance
        /// fleet.</p>
        pub fn set_instance_type_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceTypeConfig>>,
        ) -> Self {
            self.instance_type_configs = input;
            self
        }
        /// <p>The launch specification for the instance fleet.</p>
        pub fn launch_specifications(
            mut self,
            input: crate::model::InstanceFleetProvisioningSpecifications,
        ) -> Self {
            self.launch_specifications = Some(input);
            self
        }
        /// <p>The launch specification for the instance fleet.</p>
        pub fn set_launch_specifications(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetProvisioningSpecifications>,
        ) -> Self {
            self.launch_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceFleetConfig`](crate::model::InstanceFleetConfig)
        pub fn build(self) -> crate::model::InstanceFleetConfig {
            crate::model::InstanceFleetConfig {
                name: self.name,
                instance_fleet_type: self.instance_fleet_type,
                target_on_demand_capacity: self.target_on_demand_capacity,
                target_spot_capacity: self.target_spot_capacity,
                instance_type_configs: self.instance_type_configs,
                launch_specifications: self.launch_specifications,
            }
        }
    }
}
impl InstanceFleetConfig {
    /// Creates a new builder-style object to manufacture [`InstanceFleetConfig`](crate::model::InstanceFleetConfig)
    pub fn builder() -> crate::model::instance_fleet_config::Builder {
        crate::model::instance_fleet_config::Builder::default()
    }
}

/// <p>The launch specification for Spot Instances in the fleet, which determines the defined
/// duration, provisioning timeout behavior, and allocation strategy.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions. On-Demand and Spot Instance allocation strategies are
/// available in Amazon EMR version 5.12.1 and later.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceFleetProvisioningSpecifications {
    /// <p>The launch specification for Spot Instances in the fleet, which determines the defined
    /// duration, provisioning timeout behavior, and allocation strategy.</p>
    pub spot_specification: std::option::Option<crate::model::SpotProvisioningSpecification>,
    /// <p> The launch specification for On-Demand Instances in the instance fleet, which
    /// determines the allocation strategy. </p>
    /// <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
    /// later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in
    /// Amazon EMR version 5.12.1 and later.</p>
    /// </note>
    pub on_demand_specification:
        std::option::Option<crate::model::OnDemandProvisioningSpecification>,
}
impl std::fmt::Debug for InstanceFleetProvisioningSpecifications {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceFleetProvisioningSpecifications");
        formatter.field("spot_specification", &self.spot_specification);
        formatter.field("on_demand_specification", &self.on_demand_specification);
        formatter.finish()
    }
}
/// See [`InstanceFleetProvisioningSpecifications`](crate::model::InstanceFleetProvisioningSpecifications)
pub mod instance_fleet_provisioning_specifications {
    /// A builder for [`InstanceFleetProvisioningSpecifications`](crate::model::InstanceFleetProvisioningSpecifications)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) spot_specification:
            std::option::Option<crate::model::SpotProvisioningSpecification>,
        pub(crate) on_demand_specification:
            std::option::Option<crate::model::OnDemandProvisioningSpecification>,
    }
    impl Builder {
        /// <p>The launch specification for Spot Instances in the fleet, which determines the defined
        /// duration, provisioning timeout behavior, and allocation strategy.</p>
        pub fn spot_specification(
            mut self,
            input: crate::model::SpotProvisioningSpecification,
        ) -> Self {
            self.spot_specification = Some(input);
            self
        }
        /// <p>The launch specification for Spot Instances in the fleet, which determines the defined
        /// duration, provisioning timeout behavior, and allocation strategy.</p>
        pub fn set_spot_specification(
            mut self,
            input: std::option::Option<crate::model::SpotProvisioningSpecification>,
        ) -> Self {
            self.spot_specification = input;
            self
        }
        /// <p> The launch specification for On-Demand Instances in the instance fleet, which
        /// determines the allocation strategy. </p>
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in
        /// Amazon EMR version 5.12.1 and later.</p>
        /// </note>
        pub fn on_demand_specification(
            mut self,
            input: crate::model::OnDemandProvisioningSpecification,
        ) -> Self {
            self.on_demand_specification = Some(input);
            self
        }
        /// <p> The launch specification for On-Demand Instances in the instance fleet, which
        /// determines the allocation strategy. </p>
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in
        /// Amazon EMR version 5.12.1 and later.</p>
        /// </note>
        pub fn set_on_demand_specification(
            mut self,
            input: std::option::Option<crate::model::OnDemandProvisioningSpecification>,
        ) -> Self {
            self.on_demand_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceFleetProvisioningSpecifications`](crate::model::InstanceFleetProvisioningSpecifications)
        pub fn build(self) -> crate::model::InstanceFleetProvisioningSpecifications {
            crate::model::InstanceFleetProvisioningSpecifications {
                spot_specification: self.spot_specification,
                on_demand_specification: self.on_demand_specification,
            }
        }
    }
}
impl InstanceFleetProvisioningSpecifications {
    /// Creates a new builder-style object to manufacture [`InstanceFleetProvisioningSpecifications`](crate::model::InstanceFleetProvisioningSpecifications)
    pub fn builder() -> crate::model::instance_fleet_provisioning_specifications::Builder {
        crate::model::instance_fleet_provisioning_specifications::Builder::default()
    }
}

/// <p> The launch specification for On-Demand Instances in the instance fleet, which
/// determines the allocation strategy. </p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in
/// Amazon EMR version 5.12.1 and later.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnDemandProvisioningSpecification {
    /// <p>Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is <code>lowest-price</code> (the default), which launches the lowest price first.</p>
    pub allocation_strategy:
        std::option::Option<crate::model::OnDemandProvisioningAllocationStrategy>,
    /// <p>The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.</p>
    pub capacity_reservation_options:
        std::option::Option<crate::model::OnDemandCapacityReservationOptions>,
}
impl std::fmt::Debug for OnDemandProvisioningSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnDemandProvisioningSpecification");
        formatter.field("allocation_strategy", &self.allocation_strategy);
        formatter.field(
            "capacity_reservation_options",
            &self.capacity_reservation_options,
        );
        formatter.finish()
    }
}
/// See [`OnDemandProvisioningSpecification`](crate::model::OnDemandProvisioningSpecification)
pub mod on_demand_provisioning_specification {
    /// A builder for [`OnDemandProvisioningSpecification`](crate::model::OnDemandProvisioningSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allocation_strategy:
            std::option::Option<crate::model::OnDemandProvisioningAllocationStrategy>,
        pub(crate) capacity_reservation_options:
            std::option::Option<crate::model::OnDemandCapacityReservationOptions>,
    }
    impl Builder {
        /// <p>Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is <code>lowest-price</code> (the default), which launches the lowest price first.</p>
        pub fn allocation_strategy(
            mut self,
            input: crate::model::OnDemandProvisioningAllocationStrategy,
        ) -> Self {
            self.allocation_strategy = Some(input);
            self
        }
        /// <p>Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is <code>lowest-price</code> (the default), which launches the lowest price first.</p>
        pub fn set_allocation_strategy(
            mut self,
            input: std::option::Option<crate::model::OnDemandProvisioningAllocationStrategy>,
        ) -> Self {
            self.allocation_strategy = input;
            self
        }
        /// <p>The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.</p>
        pub fn capacity_reservation_options(
            mut self,
            input: crate::model::OnDemandCapacityReservationOptions,
        ) -> Self {
            self.capacity_reservation_options = Some(input);
            self
        }
        /// <p>The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.</p>
        pub fn set_capacity_reservation_options(
            mut self,
            input: std::option::Option<crate::model::OnDemandCapacityReservationOptions>,
        ) -> Self {
            self.capacity_reservation_options = input;
            self
        }
        /// Consumes the builder and constructs a [`OnDemandProvisioningSpecification`](crate::model::OnDemandProvisioningSpecification)
        pub fn build(self) -> crate::model::OnDemandProvisioningSpecification {
            crate::model::OnDemandProvisioningSpecification {
                allocation_strategy: self.allocation_strategy,
                capacity_reservation_options: self.capacity_reservation_options,
            }
        }
    }
}
impl OnDemandProvisioningSpecification {
    /// Creates a new builder-style object to manufacture [`OnDemandProvisioningSpecification`](crate::model::OnDemandProvisioningSpecification)
    pub fn builder() -> crate::model::on_demand_provisioning_specification::Builder {
        crate::model::on_demand_provisioning_specification::Builder::default()
    }
}

/// <p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnDemandCapacityReservationOptions {
    /// <p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
    /// <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code>).</p>
    /// <p>If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>
    pub usage_strategy: std::option::Option<crate::model::OnDemandCapacityReservationUsageStrategy>,
    /// <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p>
    /// </li>
    /// </ul>
    pub capacity_reservation_preference:
        std::option::Option<crate::model::OnDemandCapacityReservationPreference>,
    /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
    pub capacity_reservation_resource_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OnDemandCapacityReservationOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnDemandCapacityReservationOptions");
        formatter.field("usage_strategy", &self.usage_strategy);
        formatter.field(
            "capacity_reservation_preference",
            &self.capacity_reservation_preference,
        );
        formatter.field(
            "capacity_reservation_resource_group_arn",
            &self.capacity_reservation_resource_group_arn,
        );
        formatter.finish()
    }
}
/// See [`OnDemandCapacityReservationOptions`](crate::model::OnDemandCapacityReservationOptions)
pub mod on_demand_capacity_reservation_options {
    /// A builder for [`OnDemandCapacityReservationOptions`](crate::model::OnDemandCapacityReservationOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_strategy:
            std::option::Option<crate::model::OnDemandCapacityReservationUsageStrategy>,
        pub(crate) capacity_reservation_preference:
            std::option::Option<crate::model::OnDemandCapacityReservationPreference>,
        pub(crate) capacity_reservation_resource_group_arn:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
        /// <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code>).</p>
        /// <p>If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>
        pub fn usage_strategy(
            mut self,
            input: crate::model::OnDemandCapacityReservationUsageStrategy,
        ) -> Self {
            self.usage_strategy = Some(input);
            self
        }
        /// <p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
        /// <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code>).</p>
        /// <p>If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>
        pub fn set_usage_strategy(
            mut self,
            input: std::option::Option<crate::model::OnDemandCapacityReservationUsageStrategy>,
        ) -> Self {
            self.usage_strategy = input;
            self
        }
        /// <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p>
        /// </li>
        /// </ul>
        pub fn capacity_reservation_preference(
            mut self,
            input: crate::model::OnDemandCapacityReservationPreference,
        ) -> Self {
            self.capacity_reservation_preference = Some(input);
            self
        }
        /// <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p>
        /// </li>
        /// </ul>
        pub fn set_capacity_reservation_preference(
            mut self,
            input: std::option::Option<crate::model::OnDemandCapacityReservationPreference>,
        ) -> Self {
            self.capacity_reservation_preference = input;
            self
        }
        /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
        pub fn capacity_reservation_resource_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.capacity_reservation_resource_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
        pub fn set_capacity_reservation_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_reservation_resource_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`OnDemandCapacityReservationOptions`](crate::model::OnDemandCapacityReservationOptions)
        pub fn build(self) -> crate::model::OnDemandCapacityReservationOptions {
            crate::model::OnDemandCapacityReservationOptions {
                usage_strategy: self.usage_strategy,
                capacity_reservation_preference: self.capacity_reservation_preference,
                capacity_reservation_resource_group_arn: self
                    .capacity_reservation_resource_group_arn,
            }
        }
    }
}
impl OnDemandCapacityReservationOptions {
    /// Creates a new builder-style object to manufacture [`OnDemandCapacityReservationOptions`](crate::model::OnDemandCapacityReservationOptions)
    pub fn builder() -> crate::model::on_demand_capacity_reservation_options::Builder {
        crate::model::on_demand_capacity_reservation_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OnDemandCapacityReservationPreference {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OnDemandCapacityReservationPreference {
    fn from(s: &str) -> Self {
        match s {
            "none" => OnDemandCapacityReservationPreference::None,
            "open" => OnDemandCapacityReservationPreference::Open,
            other => OnDemandCapacityReservationPreference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OnDemandCapacityReservationPreference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OnDemandCapacityReservationPreference::from(s))
    }
}
impl OnDemandCapacityReservationPreference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OnDemandCapacityReservationPreference::None => "none",
            OnDemandCapacityReservationPreference::Open => "open",
            OnDemandCapacityReservationPreference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["none", "open"]
    }
}
impl AsRef<str> for OnDemandCapacityReservationPreference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OnDemandCapacityReservationUsageStrategy {
    #[allow(missing_docs)] // documentation missing in model
    UseCapacityReservationsFirst,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OnDemandCapacityReservationUsageStrategy {
    fn from(s: &str) -> Self {
        match s {
            "use-capacity-reservations-first" => {
                OnDemandCapacityReservationUsageStrategy::UseCapacityReservationsFirst
            }
            other => OnDemandCapacityReservationUsageStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OnDemandCapacityReservationUsageStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OnDemandCapacityReservationUsageStrategy::from(s))
    }
}
impl OnDemandCapacityReservationUsageStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OnDemandCapacityReservationUsageStrategy::UseCapacityReservationsFirst => {
                "use-capacity-reservations-first"
            }
            OnDemandCapacityReservationUsageStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["use-capacity-reservations-first"]
    }
}
impl AsRef<str> for OnDemandCapacityReservationUsageStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OnDemandProvisioningAllocationStrategy {
    #[allow(missing_docs)] // documentation missing in model
    LowestPrice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OnDemandProvisioningAllocationStrategy {
    fn from(s: &str) -> Self {
        match s {
            "lowest-price" => OnDemandProvisioningAllocationStrategy::LowestPrice,
            other => OnDemandProvisioningAllocationStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OnDemandProvisioningAllocationStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OnDemandProvisioningAllocationStrategy::from(s))
    }
}
impl OnDemandProvisioningAllocationStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OnDemandProvisioningAllocationStrategy::LowestPrice => "lowest-price",
            OnDemandProvisioningAllocationStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["lowest-price"]
    }
}
impl AsRef<str> for OnDemandProvisioningAllocationStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The launch specification for Spot Instances in the instance fleet, which determines the
/// defined duration, provisioning timeout behavior, and allocation strategy.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions. Spot Instance allocation strategy is available in
/// Amazon EMR version 5.12.1 and later.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpotProvisioningSpecification {
    /// <p>The spot provisioning timeout period in minutes. If Spot Instances are not provisioned
    /// within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and
    /// maximum value is 1440. The timeout applies only during initial provisioning, when the
    /// cluster is first created.</p>
    pub timeout_duration_minutes: std::option::Option<i32>,
    /// <p>The action to take when <code>TargetSpotCapacity</code> has not been fulfilled when the
    /// <code>TimeoutDurationMinutes</code> has expired; that is, when all Spot Instances could
    /// not be provisioned within the Spot provisioning timeout. Valid values are
    /// <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code>. SWITCH_TO_ON_DEMAND
    /// specifies that if no Spot Instances are available, On-Demand Instances should be
    /// provisioned to fulfill any remaining Spot capacity.</p>
    pub timeout_action: std::option::Option<crate::model::SpotProvisioningTimeoutAction>,
    /// <p>The defined duration for Spot Instances (also known as Spot blocks) in minutes. When
    /// specified, the Spot Instance does not terminate before the defined duration expires, and
    /// defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240,
    /// 300, or 360. The duration period starts as soon as a Spot Instance receives its instance
    /// ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and
    /// provides a Spot Instance termination notice, which gives the instance a two-minute warning
    /// before it terminates. </p>
    pub block_duration_minutes: std::option::Option<i32>,
    /// <p> Specifies the strategy to use in launching Spot Instance fleets. Currently, the only
    /// option is capacity-optimized (the default), which launches instances from Spot Instance
    /// pools with optimal capacity for the number of instances that are launching. </p>
    pub allocation_strategy: std::option::Option<crate::model::SpotProvisioningAllocationStrategy>,
}
impl std::fmt::Debug for SpotProvisioningSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpotProvisioningSpecification");
        formatter.field("timeout_duration_minutes", &self.timeout_duration_minutes);
        formatter.field("timeout_action", &self.timeout_action);
        formatter.field("block_duration_minutes", &self.block_duration_minutes);
        formatter.field("allocation_strategy", &self.allocation_strategy);
        formatter.finish()
    }
}
/// See [`SpotProvisioningSpecification`](crate::model::SpotProvisioningSpecification)
pub mod spot_provisioning_specification {
    /// A builder for [`SpotProvisioningSpecification`](crate::model::SpotProvisioningSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_duration_minutes: std::option::Option<i32>,
        pub(crate) timeout_action: std::option::Option<crate::model::SpotProvisioningTimeoutAction>,
        pub(crate) block_duration_minutes: std::option::Option<i32>,
        pub(crate) allocation_strategy:
            std::option::Option<crate::model::SpotProvisioningAllocationStrategy>,
    }
    impl Builder {
        /// <p>The spot provisioning timeout period in minutes. If Spot Instances are not provisioned
        /// within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and
        /// maximum value is 1440. The timeout applies only during initial provisioning, when the
        /// cluster is first created.</p>
        pub fn timeout_duration_minutes(mut self, input: i32) -> Self {
            self.timeout_duration_minutes = Some(input);
            self
        }
        /// <p>The spot provisioning timeout period in minutes. If Spot Instances are not provisioned
        /// within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and
        /// maximum value is 1440. The timeout applies only during initial provisioning, when the
        /// cluster is first created.</p>
        pub fn set_timeout_duration_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_duration_minutes = input;
            self
        }
        /// <p>The action to take when <code>TargetSpotCapacity</code> has not been fulfilled when the
        /// <code>TimeoutDurationMinutes</code> has expired; that is, when all Spot Instances could
        /// not be provisioned within the Spot provisioning timeout. Valid values are
        /// <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code>. SWITCH_TO_ON_DEMAND
        /// specifies that if no Spot Instances are available, On-Demand Instances should be
        /// provisioned to fulfill any remaining Spot capacity.</p>
        pub fn timeout_action(
            mut self,
            input: crate::model::SpotProvisioningTimeoutAction,
        ) -> Self {
            self.timeout_action = Some(input);
            self
        }
        /// <p>The action to take when <code>TargetSpotCapacity</code> has not been fulfilled when the
        /// <code>TimeoutDurationMinutes</code> has expired; that is, when all Spot Instances could
        /// not be provisioned within the Spot provisioning timeout. Valid values are
        /// <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code>. SWITCH_TO_ON_DEMAND
        /// specifies that if no Spot Instances are available, On-Demand Instances should be
        /// provisioned to fulfill any remaining Spot capacity.</p>
        pub fn set_timeout_action(
            mut self,
            input: std::option::Option<crate::model::SpotProvisioningTimeoutAction>,
        ) -> Self {
            self.timeout_action = input;
            self
        }
        /// <p>The defined duration for Spot Instances (also known as Spot blocks) in minutes. When
        /// specified, the Spot Instance does not terminate before the defined duration expires, and
        /// defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240,
        /// 300, or 360. The duration period starts as soon as a Spot Instance receives its instance
        /// ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and
        /// provides a Spot Instance termination notice, which gives the instance a two-minute warning
        /// before it terminates. </p>
        pub fn block_duration_minutes(mut self, input: i32) -> Self {
            self.block_duration_minutes = Some(input);
            self
        }
        /// <p>The defined duration for Spot Instances (also known as Spot blocks) in minutes. When
        /// specified, the Spot Instance does not terminate before the defined duration expires, and
        /// defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240,
        /// 300, or 360. The duration period starts as soon as a Spot Instance receives its instance
        /// ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and
        /// provides a Spot Instance termination notice, which gives the instance a two-minute warning
        /// before it terminates. </p>
        pub fn set_block_duration_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.block_duration_minutes = input;
            self
        }
        /// <p> Specifies the strategy to use in launching Spot Instance fleets. Currently, the only
        /// option is capacity-optimized (the default), which launches instances from Spot Instance
        /// pools with optimal capacity for the number of instances that are launching. </p>
        pub fn allocation_strategy(
            mut self,
            input: crate::model::SpotProvisioningAllocationStrategy,
        ) -> Self {
            self.allocation_strategy = Some(input);
            self
        }
        /// <p> Specifies the strategy to use in launching Spot Instance fleets. Currently, the only
        /// option is capacity-optimized (the default), which launches instances from Spot Instance
        /// pools with optimal capacity for the number of instances that are launching. </p>
        pub fn set_allocation_strategy(
            mut self,
            input: std::option::Option<crate::model::SpotProvisioningAllocationStrategy>,
        ) -> Self {
            self.allocation_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`SpotProvisioningSpecification`](crate::model::SpotProvisioningSpecification)
        pub fn build(self) -> crate::model::SpotProvisioningSpecification {
            crate::model::SpotProvisioningSpecification {
                timeout_duration_minutes: self.timeout_duration_minutes,
                timeout_action: self.timeout_action,
                block_duration_minutes: self.block_duration_minutes,
                allocation_strategy: self.allocation_strategy,
            }
        }
    }
}
impl SpotProvisioningSpecification {
    /// Creates a new builder-style object to manufacture [`SpotProvisioningSpecification`](crate::model::SpotProvisioningSpecification)
    pub fn builder() -> crate::model::spot_provisioning_specification::Builder {
        crate::model::spot_provisioning_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SpotProvisioningAllocationStrategy {
    #[allow(missing_docs)] // documentation missing in model
    CapacityOptimized,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SpotProvisioningAllocationStrategy {
    fn from(s: &str) -> Self {
        match s {
            "capacity-optimized" => SpotProvisioningAllocationStrategy::CapacityOptimized,
            other => SpotProvisioningAllocationStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SpotProvisioningAllocationStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SpotProvisioningAllocationStrategy::from(s))
    }
}
impl SpotProvisioningAllocationStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SpotProvisioningAllocationStrategy::CapacityOptimized => "capacity-optimized",
            SpotProvisioningAllocationStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["capacity-optimized"]
    }
}
impl AsRef<str> for SpotProvisioningAllocationStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SpotProvisioningTimeoutAction {
    #[allow(missing_docs)] // documentation missing in model
    SwitchToOnDemand,
    #[allow(missing_docs)] // documentation missing in model
    TerminateCluster,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SpotProvisioningTimeoutAction {
    fn from(s: &str) -> Self {
        match s {
            "SWITCH_TO_ON_DEMAND" => SpotProvisioningTimeoutAction::SwitchToOnDemand,
            "TERMINATE_CLUSTER" => SpotProvisioningTimeoutAction::TerminateCluster,
            other => SpotProvisioningTimeoutAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SpotProvisioningTimeoutAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SpotProvisioningTimeoutAction::from(s))
    }
}
impl SpotProvisioningTimeoutAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SpotProvisioningTimeoutAction::SwitchToOnDemand => "SWITCH_TO_ON_DEMAND",
            SpotProvisioningTimeoutAction::TerminateCluster => "TERMINATE_CLUSTER",
            SpotProvisioningTimeoutAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SWITCH_TO_ON_DEMAND", "TERMINATE_CLUSTER"]
    }
}
impl AsRef<str> for SpotProvisioningTimeoutAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An instance type configuration for each instance type in an instance fleet, which
/// determines the EC2 instances Amazon EMR attempts to provision to fulfill On-Demand and Spot
/// target capacities. When you use an allocation strategy, you can include a maximum of 30 instance type configurations for a fleet. For more information about how to use an allocation strategy, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html">Configure Instance Fleets</a>. Without an allocation strategy, you may specify a maximum of five instance type configurations for a fleet.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceTypeConfig {
    /// <p>An EC2 instance type, such as <code>m3.xlarge</code>. </p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The number of units that a provisioned instance of this type provides toward fulfilling
    /// the target capacities defined in <a>InstanceFleetConfig</a>. This value is 1 for
    /// a master instance fleet, and must be 1 or greater for core and task instance fleets.
    /// Defaults to 1 if not specified. </p>
    pub weighted_capacity: std::option::Option<i32>,
    /// <p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>.
    /// Expressed in USD. If neither <code>BidPrice</code> nor
    /// <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided,
    /// <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%. </p>
    pub bid_price: std::option::Option<std::string::String>,
    /// <p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined
    /// by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%). If
    /// neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is
    /// provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.</p>
    pub bid_price_as_percentage_of_on_demand_price: std::option::Option<f64>,
    /// <p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance
    /// as defined by <code>InstanceType</code>. </p>
    pub ebs_configuration: std::option::Option<crate::model::EbsConfiguration>,
    /// <p>A configuration classification that applies when provisioning cluster instances, which
    /// can include configurations for applications and software that run on the cluster.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>The custom AMI ID to use for the instance type.</p>
    pub custom_ami_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceTypeConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceTypeConfig");
        formatter.field("instance_type", &self.instance_type);
        formatter.field("weighted_capacity", &self.weighted_capacity);
        formatter.field("bid_price", &self.bid_price);
        formatter.field(
            "bid_price_as_percentage_of_on_demand_price",
            &self.bid_price_as_percentage_of_on_demand_price,
        );
        formatter.field("ebs_configuration", &self.ebs_configuration);
        formatter.field("configurations", &self.configurations);
        formatter.field("custom_ami_id", &self.custom_ami_id);
        formatter.finish()
    }
}
/// See [`InstanceTypeConfig`](crate::model::InstanceTypeConfig)
pub mod instance_type_config {
    /// A builder for [`InstanceTypeConfig`](crate::model::InstanceTypeConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) weighted_capacity: std::option::Option<i32>,
        pub(crate) bid_price: std::option::Option<std::string::String>,
        pub(crate) bid_price_as_percentage_of_on_demand_price: std::option::Option<f64>,
        pub(crate) ebs_configuration: std::option::Option<crate::model::EbsConfiguration>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) custom_ami_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An EC2 instance type, such as <code>m3.xlarge</code>. </p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>An EC2 instance type, such as <code>m3.xlarge</code>. </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The number of units that a provisioned instance of this type provides toward fulfilling
        /// the target capacities defined in <a>InstanceFleetConfig</a>. This value is 1 for
        /// a master instance fleet, and must be 1 or greater for core and task instance fleets.
        /// Defaults to 1 if not specified. </p>
        pub fn weighted_capacity(mut self, input: i32) -> Self {
            self.weighted_capacity = Some(input);
            self
        }
        /// <p>The number of units that a provisioned instance of this type provides toward fulfilling
        /// the target capacities defined in <a>InstanceFleetConfig</a>. This value is 1 for
        /// a master instance fleet, and must be 1 or greater for core and task instance fleets.
        /// Defaults to 1 if not specified. </p>
        pub fn set_weighted_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.weighted_capacity = input;
            self
        }
        /// <p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>.
        /// Expressed in USD. If neither <code>BidPrice</code> nor
        /// <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided,
        /// <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%. </p>
        pub fn bid_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.bid_price = Some(input.into());
            self
        }
        /// <p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>.
        /// Expressed in USD. If neither <code>BidPrice</code> nor
        /// <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided,
        /// <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%. </p>
        pub fn set_bid_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bid_price = input;
            self
        }
        /// <p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined
        /// by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%). If
        /// neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is
        /// provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.</p>
        pub fn bid_price_as_percentage_of_on_demand_price(mut self, input: f64) -> Self {
            self.bid_price_as_percentage_of_on_demand_price = Some(input);
            self
        }
        /// <p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined
        /// by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%). If
        /// neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is
        /// provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.</p>
        pub fn set_bid_price_as_percentage_of_on_demand_price(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.bid_price_as_percentage_of_on_demand_price = input;
            self
        }
        /// <p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance
        /// as defined by <code>InstanceType</code>. </p>
        pub fn ebs_configuration(mut self, input: crate::model::EbsConfiguration) -> Self {
            self.ebs_configuration = Some(input);
            self
        }
        /// <p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance
        /// as defined by <code>InstanceType</code>. </p>
        pub fn set_ebs_configuration(
            mut self,
            input: std::option::Option<crate::model::EbsConfiguration>,
        ) -> Self {
            self.ebs_configuration = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A configuration classification that applies when provisioning cluster instances, which
        /// can include configurations for applications and software that run on the cluster.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>A configuration classification that applies when provisioning cluster instances, which
        /// can include configurations for applications and software that run on the cluster.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>The custom AMI ID to use for the instance type.</p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_ami_id = Some(input.into());
            self
        }
        /// <p>The custom AMI ID to use for the instance type.</p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_ami_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceTypeConfig`](crate::model::InstanceTypeConfig)
        pub fn build(self) -> crate::model::InstanceTypeConfig {
            crate::model::InstanceTypeConfig {
                instance_type: self.instance_type,
                weighted_capacity: self.weighted_capacity,
                bid_price: self.bid_price,
                bid_price_as_percentage_of_on_demand_price: self
                    .bid_price_as_percentage_of_on_demand_price,
                ebs_configuration: self.ebs_configuration,
                configurations: self.configurations,
                custom_ami_id: self.custom_ami_id,
            }
        }
    }
}
impl InstanceTypeConfig {
    /// Creates a new builder-style object to manufacture [`InstanceTypeConfig`](crate::model::InstanceTypeConfig)
    pub fn builder() -> crate::model::instance_type_config::Builder {
        crate::model::instance_type_config::Builder::default()
    }
}

/// <p>The Amazon EBS configuration of a cluster instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsConfiguration {
    /// <p>An array of Amazon EBS volume specifications attached to a cluster instance.</p>
    pub ebs_block_device_configs:
        std::option::Option<std::vec::Vec<crate::model::EbsBlockDeviceConfig>>,
    /// <p>Indicates whether an Amazon EBS volume is EBS-optimized.</p>
    pub ebs_optimized: std::option::Option<bool>,
}
impl std::fmt::Debug for EbsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsConfiguration");
        formatter.field("ebs_block_device_configs", &self.ebs_block_device_configs);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.finish()
    }
}
/// See [`EbsConfiguration`](crate::model::EbsConfiguration)
pub mod ebs_configuration {
    /// A builder for [`EbsConfiguration`](crate::model::EbsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ebs_block_device_configs:
            std::option::Option<std::vec::Vec<crate::model::EbsBlockDeviceConfig>>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `ebs_block_device_configs`.
        ///
        /// To override the contents of this collection use [`set_ebs_block_device_configs`](Self::set_ebs_block_device_configs).
        ///
        /// <p>An array of Amazon EBS volume specifications attached to a cluster instance.</p>
        pub fn ebs_block_device_configs(
            mut self,
            input: impl Into<crate::model::EbsBlockDeviceConfig>,
        ) -> Self {
            let mut v = self.ebs_block_device_configs.unwrap_or_default();
            v.push(input.into());
            self.ebs_block_device_configs = Some(v);
            self
        }
        /// <p>An array of Amazon EBS volume specifications attached to a cluster instance.</p>
        pub fn set_ebs_block_device_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EbsBlockDeviceConfig>>,
        ) -> Self {
            self.ebs_block_device_configs = input;
            self
        }
        /// <p>Indicates whether an Amazon EBS volume is EBS-optimized.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Indicates whether an Amazon EBS volume is EBS-optimized.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsConfiguration`](crate::model::EbsConfiguration)
        pub fn build(self) -> crate::model::EbsConfiguration {
            crate::model::EbsConfiguration {
                ebs_block_device_configs: self.ebs_block_device_configs,
                ebs_optimized: self.ebs_optimized,
            }
        }
    }
}
impl EbsConfiguration {
    /// Creates a new builder-style object to manufacture [`EbsConfiguration`](crate::model::EbsConfiguration)
    pub fn builder() -> crate::model::ebs_configuration::Builder {
        crate::model::ebs_configuration::Builder::default()
    }
}

/// <p>Configuration of requested EBS block device associated with the instance group with
/// count of volumes that will be associated to every instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsBlockDeviceConfig {
    /// <p>EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
    /// requested for the EBS volume attached to an EC2 instance in the cluster.</p>
    pub volume_specification: std::option::Option<crate::model::VolumeSpecification>,
    /// <p>Number of EBS volumes with a specific volume configuration that will be associated with
    /// every instance in the instance group</p>
    pub volumes_per_instance: std::option::Option<i32>,
}
impl std::fmt::Debug for EbsBlockDeviceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsBlockDeviceConfig");
        formatter.field("volume_specification", &self.volume_specification);
        formatter.field("volumes_per_instance", &self.volumes_per_instance);
        formatter.finish()
    }
}
/// See [`EbsBlockDeviceConfig`](crate::model::EbsBlockDeviceConfig)
pub mod ebs_block_device_config {
    /// A builder for [`EbsBlockDeviceConfig`](crate::model::EbsBlockDeviceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_specification: std::option::Option<crate::model::VolumeSpecification>,
        pub(crate) volumes_per_instance: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
        /// requested for the EBS volume attached to an EC2 instance in the cluster.</p>
        pub fn volume_specification(mut self, input: crate::model::VolumeSpecification) -> Self {
            self.volume_specification = Some(input);
            self
        }
        /// <p>EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
        /// requested for the EBS volume attached to an EC2 instance in the cluster.</p>
        pub fn set_volume_specification(
            mut self,
            input: std::option::Option<crate::model::VolumeSpecification>,
        ) -> Self {
            self.volume_specification = input;
            self
        }
        /// <p>Number of EBS volumes with a specific volume configuration that will be associated with
        /// every instance in the instance group</p>
        pub fn volumes_per_instance(mut self, input: i32) -> Self {
            self.volumes_per_instance = Some(input);
            self
        }
        /// <p>Number of EBS volumes with a specific volume configuration that will be associated with
        /// every instance in the instance group</p>
        pub fn set_volumes_per_instance(mut self, input: std::option::Option<i32>) -> Self {
            self.volumes_per_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsBlockDeviceConfig`](crate::model::EbsBlockDeviceConfig)
        pub fn build(self) -> crate::model::EbsBlockDeviceConfig {
            crate::model::EbsBlockDeviceConfig {
                volume_specification: self.volume_specification,
                volumes_per_instance: self.volumes_per_instance,
            }
        }
    }
}
impl EbsBlockDeviceConfig {
    /// Creates a new builder-style object to manufacture [`EbsBlockDeviceConfig`](crate::model::EbsBlockDeviceConfig)
    pub fn builder() -> crate::model::ebs_block_device_config::Builder {
        crate::model::ebs_block_device_config::Builder::default()
    }
}

/// <p>EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
/// requested for the EBS volume attached to an EC2 instance in the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeSpecification {
    /// <p>The volume type. Volume types supported are gp2, io1, standard.</p>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>The number of I/O operations per second (IOPS) that the volume supports.</p>
    pub iops: std::option::Option<i32>,
    /// <p>The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume
    /// type is EBS-optimized, the minimum value is 10.</p>
    pub size_in_gb: std::option::Option<i32>,
}
impl std::fmt::Debug for VolumeSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeSpecification");
        formatter.field("volume_type", &self.volume_type);
        formatter.field("iops", &self.iops);
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.finish()
    }
}
/// See [`VolumeSpecification`](crate::model::VolumeSpecification)
pub mod volume_specification {
    /// A builder for [`VolumeSpecification`](crate::model::VolumeSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) size_in_gb: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The volume type. Volume types supported are gp2, io1, standard.</p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type. Volume types supported are gp2, io1, standard.</p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>The number of I/O operations per second (IOPS) that the volume supports.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The number of I/O operations per second (IOPS) that the volume supports.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume
        /// type is EBS-optimized, the minimum value is 10.</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume
        /// type is EBS-optimized, the minimum value is 10.</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeSpecification`](crate::model::VolumeSpecification)
        pub fn build(self) -> crate::model::VolumeSpecification {
            crate::model::VolumeSpecification {
                volume_type: self.volume_type,
                iops: self.iops,
                size_in_gb: self.size_in_gb,
            }
        }
    }
}
impl VolumeSpecification {
    /// Creates a new builder-style object to manufacture [`VolumeSpecification`](crate::model::VolumeSpecification)
    pub fn builder() -> crate::model::volume_specification::Builder {
        crate::model::volume_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceFleetType {
    #[allow(missing_docs)] // documentation missing in model
    Core,
    #[allow(missing_docs)] // documentation missing in model
    Master,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceFleetType {
    fn from(s: &str) -> Self {
        match s {
            "CORE" => InstanceFleetType::Core,
            "MASTER" => InstanceFleetType::Master,
            "TASK" => InstanceFleetType::Task,
            other => InstanceFleetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceFleetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceFleetType::from(s))
    }
}
impl InstanceFleetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceFleetType::Core => "CORE",
            InstanceFleetType::Master => "MASTER",
            InstanceFleetType::Task => "TASK",
            InstanceFleetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CORE", "MASTER", "TASK"]
    }
}
impl AsRef<str> for InstanceFleetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration defining a new instance group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceGroupConfig {
    /// <p>Friendly name given to the instance group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Market type of the EC2 instances used to create a cluster node.</p>
    pub market: std::option::Option<crate::model::MarketType>,
    /// <p>The role of the instance group in the cluster.</p>
    pub instance_role: std::option::Option<crate::model::InstanceRoleType>,
    /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
    pub bid_price: std::option::Option<std::string::String>,
    /// <p>The EC2 instance type for all instances in the instance group.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>Target number of instances for the instance group.</p>
    pub instance_count: std::option::Option<i32>,
    /// <note>
    /// <p>Amazon EMR releases 4.x or later.</p>
    /// </note>
    /// <p>The list of configurations supplied for an EMR cluster instance group. You can specify a
    /// separate configuration for each instance group (master, core, and task).</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>EBS configurations that will be attached to each EC2 instance in the instance
    /// group.</p>
    pub ebs_configuration: std::option::Option<crate::model::EbsConfiguration>,
    /// <p>An automatic scaling policy for a core instance group or task instance group in an
    /// Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
    /// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
    /// <a>PutAutoScalingPolicy</a>.</p>
    pub auto_scaling_policy: std::option::Option<crate::model::AutoScalingPolicy>,
    /// <p>The custom AMI ID to use for the provisioned instance group.</p>
    pub custom_ami_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceGroupConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceGroupConfig");
        formatter.field("name", &self.name);
        formatter.field("market", &self.market);
        formatter.field("instance_role", &self.instance_role);
        formatter.field("bid_price", &self.bid_price);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("instance_count", &self.instance_count);
        formatter.field("configurations", &self.configurations);
        formatter.field("ebs_configuration", &self.ebs_configuration);
        formatter.field("auto_scaling_policy", &self.auto_scaling_policy);
        formatter.field("custom_ami_id", &self.custom_ami_id);
        formatter.finish()
    }
}
/// See [`InstanceGroupConfig`](crate::model::InstanceGroupConfig)
pub mod instance_group_config {
    /// A builder for [`InstanceGroupConfig`](crate::model::InstanceGroupConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) market: std::option::Option<crate::model::MarketType>,
        pub(crate) instance_role: std::option::Option<crate::model::InstanceRoleType>,
        pub(crate) bid_price: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) ebs_configuration: std::option::Option<crate::model::EbsConfiguration>,
        pub(crate) auto_scaling_policy: std::option::Option<crate::model::AutoScalingPolicy>,
        pub(crate) custom_ami_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Friendly name given to the instance group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Friendly name given to the instance group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Market type of the EC2 instances used to create a cluster node.</p>
        pub fn market(mut self, input: crate::model::MarketType) -> Self {
            self.market = Some(input);
            self
        }
        /// <p>Market type of the EC2 instances used to create a cluster node.</p>
        pub fn set_market(mut self, input: std::option::Option<crate::model::MarketType>) -> Self {
            self.market = input;
            self
        }
        /// <p>The role of the instance group in the cluster.</p>
        pub fn instance_role(mut self, input: crate::model::InstanceRoleType) -> Self {
            self.instance_role = Some(input);
            self
        }
        /// <p>The role of the instance group in the cluster.</p>
        pub fn set_instance_role(
            mut self,
            input: std::option::Option<crate::model::InstanceRoleType>,
        ) -> Self {
            self.instance_role = input;
            self
        }
        /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
        pub fn bid_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.bid_price = Some(input.into());
            self
        }
        /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
        pub fn set_bid_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bid_price = input;
            self
        }
        /// <p>The EC2 instance type for all instances in the instance group.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 instance type for all instances in the instance group.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>Target number of instances for the instance group.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>Target number of instances for the instance group.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <note>
        /// <p>Amazon EMR releases 4.x or later.</p>
        /// </note>
        /// <p>The list of configurations supplied for an EMR cluster instance group. You can specify a
        /// separate configuration for each instance group (master, core, and task).</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <note>
        /// <p>Amazon EMR releases 4.x or later.</p>
        /// </note>
        /// <p>The list of configurations supplied for an EMR cluster instance group. You can specify a
        /// separate configuration for each instance group (master, core, and task).</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>EBS configurations that will be attached to each EC2 instance in the instance
        /// group.</p>
        pub fn ebs_configuration(mut self, input: crate::model::EbsConfiguration) -> Self {
            self.ebs_configuration = Some(input);
            self
        }
        /// <p>EBS configurations that will be attached to each EC2 instance in the instance
        /// group.</p>
        pub fn set_ebs_configuration(
            mut self,
            input: std::option::Option<crate::model::EbsConfiguration>,
        ) -> Self {
            self.ebs_configuration = input;
            self
        }
        /// <p>An automatic scaling policy for a core instance group or task instance group in an
        /// Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
        /// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
        /// <a>PutAutoScalingPolicy</a>.</p>
        pub fn auto_scaling_policy(mut self, input: crate::model::AutoScalingPolicy) -> Self {
            self.auto_scaling_policy = Some(input);
            self
        }
        /// <p>An automatic scaling policy for a core instance group or task instance group in an
        /// Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
        /// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
        /// <a>PutAutoScalingPolicy</a>.</p>
        pub fn set_auto_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicy>,
        ) -> Self {
            self.auto_scaling_policy = input;
            self
        }
        /// <p>The custom AMI ID to use for the provisioned instance group.</p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_ami_id = Some(input.into());
            self
        }
        /// <p>The custom AMI ID to use for the provisioned instance group.</p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_ami_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceGroupConfig`](crate::model::InstanceGroupConfig)
        pub fn build(self) -> crate::model::InstanceGroupConfig {
            crate::model::InstanceGroupConfig {
                name: self.name,
                market: self.market,
                instance_role: self.instance_role,
                bid_price: self.bid_price,
                instance_type: self.instance_type,
                instance_count: self.instance_count,
                configurations: self.configurations,
                ebs_configuration: self.ebs_configuration,
                auto_scaling_policy: self.auto_scaling_policy,
                custom_ami_id: self.custom_ami_id,
            }
        }
    }
}
impl InstanceGroupConfig {
    /// Creates a new builder-style object to manufacture [`InstanceGroupConfig`](crate::model::InstanceGroupConfig)
    pub fn builder() -> crate::model::instance_group_config::Builder {
        crate::model::instance_group_config::Builder::default()
    }
}

/// <p>An automatic scaling policy for a core instance group or task instance group in an
/// Amazon EMR cluster. An automatic scaling policy defines how an instance group dynamically
/// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
/// <a>PutAutoScalingPolicy</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingPolicy {
    /// <p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
    /// scaling activity will not cause an instance group to grow above or below these
    /// limits.</p>
    pub constraints: std::option::Option<crate::model::ScalingConstraints>,
    /// <p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ScalingRule>>,
}
impl std::fmt::Debug for AutoScalingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingPolicy");
        formatter.field("constraints", &self.constraints);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`AutoScalingPolicy`](crate::model::AutoScalingPolicy)
pub mod auto_scaling_policy {
    /// A builder for [`AutoScalingPolicy`](crate::model::AutoScalingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constraints: std::option::Option<crate::model::ScalingConstraints>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::ScalingRule>>,
    }
    impl Builder {
        /// <p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
        /// scaling activity will not cause an instance group to grow above or below these
        /// limits.</p>
        pub fn constraints(mut self, input: crate::model::ScalingConstraints) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
        /// scaling activity will not cause an instance group to grow above or below these
        /// limits.</p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::ScalingConstraints>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>
        pub fn rules(mut self, input: impl Into<crate::model::ScalingRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingPolicy`](crate::model::AutoScalingPolicy)
        pub fn build(self) -> crate::model::AutoScalingPolicy {
            crate::model::AutoScalingPolicy {
                constraints: self.constraints,
                rules: self.rules,
            }
        }
    }
}
impl AutoScalingPolicy {
    /// Creates a new builder-style object to manufacture [`AutoScalingPolicy`](crate::model::AutoScalingPolicy)
    pub fn builder() -> crate::model::auto_scaling_policy::Builder {
        crate::model::auto_scaling_policy::Builder::default()
    }
}

/// <p>A scale-in or scale-out rule that defines scaling activity, including the CloudWatch
/// metric alarm that triggers activity, how EC2 instances are added or removed, and the
/// periodicity of adjustments. The automatic scaling policy for an instance group can comprise
/// one or more automatic scaling rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingRule {
    /// <p>The name used to identify an automatic scaling rule. Rule names must be unique within a
    /// scaling policy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A friendly, more verbose description of the automatic scaling rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The conditions that trigger an automatic scaling activity.</p>
    pub action: std::option::Option<crate::model::ScalingAction>,
    /// <p>The CloudWatch alarm definition that determines when automatic scaling activity is
    /// triggered.</p>
    pub trigger: std::option::Option<crate::model::ScalingTrigger>,
}
impl std::fmt::Debug for ScalingRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingRule");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("action", &self.action);
        formatter.field("trigger", &self.trigger);
        formatter.finish()
    }
}
/// See [`ScalingRule`](crate::model::ScalingRule)
pub mod scaling_rule {
    /// A builder for [`ScalingRule`](crate::model::ScalingRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::ScalingAction>,
        pub(crate) trigger: std::option::Option<crate::model::ScalingTrigger>,
    }
    impl Builder {
        /// <p>The name used to identify an automatic scaling rule. Rule names must be unique within a
        /// scaling policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name used to identify an automatic scaling rule. Rule names must be unique within a
        /// scaling policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A friendly, more verbose description of the automatic scaling rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A friendly, more verbose description of the automatic scaling rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The conditions that trigger an automatic scaling activity.</p>
        pub fn action(mut self, input: crate::model::ScalingAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The conditions that trigger an automatic scaling activity.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ScalingAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The CloudWatch alarm definition that determines when automatic scaling activity is
        /// triggered.</p>
        pub fn trigger(mut self, input: crate::model::ScalingTrigger) -> Self {
            self.trigger = Some(input);
            self
        }
        /// <p>The CloudWatch alarm definition that determines when automatic scaling activity is
        /// triggered.</p>
        pub fn set_trigger(
            mut self,
            input: std::option::Option<crate::model::ScalingTrigger>,
        ) -> Self {
            self.trigger = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingRule`](crate::model::ScalingRule)
        pub fn build(self) -> crate::model::ScalingRule {
            crate::model::ScalingRule {
                name: self.name,
                description: self.description,
                action: self.action,
                trigger: self.trigger,
            }
        }
    }
}
impl ScalingRule {
    /// Creates a new builder-style object to manufacture [`ScalingRule`](crate::model::ScalingRule)
    pub fn builder() -> crate::model::scaling_rule::Builder {
        crate::model::scaling_rule::Builder::default()
    }
}

/// <p>The conditions that trigger an automatic scaling activity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingTrigger {
    /// <p>The definition of a CloudWatch metric alarm. When the defined alarm conditions are met
    /// along with other trigger parameters, scaling activity begins.</p>
    pub cloud_watch_alarm_definition: std::option::Option<crate::model::CloudWatchAlarmDefinition>,
}
impl std::fmt::Debug for ScalingTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingTrigger");
        formatter.field(
            "cloud_watch_alarm_definition",
            &self.cloud_watch_alarm_definition,
        );
        formatter.finish()
    }
}
/// See [`ScalingTrigger`](crate::model::ScalingTrigger)
pub mod scaling_trigger {
    /// A builder for [`ScalingTrigger`](crate::model::ScalingTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_alarm_definition:
            std::option::Option<crate::model::CloudWatchAlarmDefinition>,
    }
    impl Builder {
        /// <p>The definition of a CloudWatch metric alarm. When the defined alarm conditions are met
        /// along with other trigger parameters, scaling activity begins.</p>
        pub fn cloud_watch_alarm_definition(
            mut self,
            input: crate::model::CloudWatchAlarmDefinition,
        ) -> Self {
            self.cloud_watch_alarm_definition = Some(input);
            self
        }
        /// <p>The definition of a CloudWatch metric alarm. When the defined alarm conditions are met
        /// along with other trigger parameters, scaling activity begins.</p>
        pub fn set_cloud_watch_alarm_definition(
            mut self,
            input: std::option::Option<crate::model::CloudWatchAlarmDefinition>,
        ) -> Self {
            self.cloud_watch_alarm_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingTrigger`](crate::model::ScalingTrigger)
        pub fn build(self) -> crate::model::ScalingTrigger {
            crate::model::ScalingTrigger {
                cloud_watch_alarm_definition: self.cloud_watch_alarm_definition,
            }
        }
    }
}
impl ScalingTrigger {
    /// Creates a new builder-style object to manufacture [`ScalingTrigger`](crate::model::ScalingTrigger)
    pub fn builder() -> crate::model::scaling_trigger::Builder {
        crate::model::scaling_trigger::Builder::default()
    }
}

/// <p>The definition of a CloudWatch metric alarm, which determines when an automatic scaling
/// activity is triggered. When the defined alarm conditions are satisfied, scaling activity
/// begins.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchAlarmDefinition {
    /// <p>Determines how the metric specified by <code>MetricName</code> is compared to the value
    /// specified by <code>Threshold</code>.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>The number of periods, in five-minute increments, during which the alarm condition must
    /// exist before the alarm triggers automatic scaling activity. The default value is
    /// <code>1</code>.</p>
    pub evaluation_periods: std::option::Option<i32>,
    /// <p>The name of the CloudWatch metric that is watched to determine an alarm
    /// condition.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace for the CloudWatch metric. The default is
    /// <code>AWS/ElasticMapReduce</code>.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The period, in seconds, over which the statistic is applied. EMR CloudWatch metrics are
    /// emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified,
    /// specify <code>300</code>.</p>
    pub period: std::option::Option<i32>,
    /// <p>The statistic to apply to the metric associated with the alarm. The default is
    /// <code>AVERAGE</code>.</p>
    pub statistic: std::option::Option<crate::model::Statistic>,
    /// <p>The value against which the specified statistic is compared.</p>
    pub threshold: std::option::Option<f64>,
    /// <p>The unit of measure associated with the CloudWatch metric being watched. The value
    /// specified for <code>Unit</code> must correspond to the units specified in the CloudWatch
    /// metric.</p>
    pub unit: std::option::Option<crate::model::Unit>,
    /// <p>A CloudWatch metric dimension.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
}
impl std::fmt::Debug for CloudWatchAlarmDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchAlarmDefinition");
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("evaluation_periods", &self.evaluation_periods);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("period", &self.period);
        formatter.field("statistic", &self.statistic);
        formatter.field("threshold", &self.threshold);
        formatter.field("unit", &self.unit);
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`CloudWatchAlarmDefinition`](crate::model::CloudWatchAlarmDefinition)
pub mod cloud_watch_alarm_definition {
    /// A builder for [`CloudWatchAlarmDefinition`](crate::model::CloudWatchAlarmDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) evaluation_periods: std::option::Option<i32>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) statistic: std::option::Option<crate::model::Statistic>,
        pub(crate) threshold: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<crate::model::Unit>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
    }
    impl Builder {
        /// <p>Determines how the metric specified by <code>MetricName</code> is compared to the value
        /// specified by <code>Threshold</code>.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>Determines how the metric specified by <code>MetricName</code> is compared to the value
        /// specified by <code>Threshold</code>.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>The number of periods, in five-minute increments, during which the alarm condition must
        /// exist before the alarm triggers automatic scaling activity. The default value is
        /// <code>1</code>.</p>
        pub fn evaluation_periods(mut self, input: i32) -> Self {
            self.evaluation_periods = Some(input);
            self
        }
        /// <p>The number of periods, in five-minute increments, during which the alarm condition must
        /// exist before the alarm triggers automatic scaling activity. The default value is
        /// <code>1</code>.</p>
        pub fn set_evaluation_periods(mut self, input: std::option::Option<i32>) -> Self {
            self.evaluation_periods = input;
            self
        }
        /// <p>The name of the CloudWatch metric that is watched to determine an alarm
        /// condition.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch metric that is watched to determine an alarm
        /// condition.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace for the CloudWatch metric. The default is
        /// <code>AWS/ElasticMapReduce</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace for the CloudWatch metric. The default is
        /// <code>AWS/ElasticMapReduce</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The period, in seconds, over which the statistic is applied. EMR CloudWatch metrics are
        /// emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified,
        /// specify <code>300</code>.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The period, in seconds, over which the statistic is applied. EMR CloudWatch metrics are
        /// emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified,
        /// specify <code>300</code>.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The statistic to apply to the metric associated with the alarm. The default is
        /// <code>AVERAGE</code>.</p>
        pub fn statistic(mut self, input: crate::model::Statistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic to apply to the metric associated with the alarm. The default is
        /// <code>AVERAGE</code>.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::Statistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The value against which the specified statistic is compared.</p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The value against which the specified statistic is compared.</p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>The unit of measure associated with the CloudWatch metric being watched. The value
        /// specified for <code>Unit</code> must correspond to the units specified in the CloudWatch
        /// metric.</p>
        pub fn unit(mut self, input: crate::model::Unit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit of measure associated with the CloudWatch metric being watched. The value
        /// specified for <code>Unit</code> must correspond to the units specified in the CloudWatch
        /// metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::Unit>) -> Self {
            self.unit = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A CloudWatch metric dimension.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::MetricDimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>A CloudWatch metric dimension.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchAlarmDefinition`](crate::model::CloudWatchAlarmDefinition)
        pub fn build(self) -> crate::model::CloudWatchAlarmDefinition {
            crate::model::CloudWatchAlarmDefinition {
                comparison_operator: self.comparison_operator,
                evaluation_periods: self.evaluation_periods,
                metric_name: self.metric_name,
                namespace: self.namespace,
                period: self.period,
                statistic: self.statistic,
                threshold: self.threshold,
                unit: self.unit,
                dimensions: self.dimensions,
            }
        }
    }
}
impl CloudWatchAlarmDefinition {
    /// Creates a new builder-style object to manufacture [`CloudWatchAlarmDefinition`](crate::model::CloudWatchAlarmDefinition)
    pub fn builder() -> crate::model::cloud_watch_alarm_definition::Builder {
        crate::model::cloud_watch_alarm_definition::Builder::default()
    }
}

/// <p>A CloudWatch dimension, which is specified using a <code>Key</code> (known as a
/// <code>Name</code> in CloudWatch), <code>Value</code> pair. By default, Amazon EMR uses
/// one dimension whose <code>Key</code> is <code>JobFlowID</code> and <code>Value</code> is a
/// variable representing the cluster ID, which is <code>${emr.clusterId}</code>. This enables
/// the rule to bootstrap when the cluster ID becomes available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDimension {
    /// <p>The dimension name.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The dimension value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MetricDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDimension");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MetricDimension`](crate::model::MetricDimension)
pub mod metric_dimension {
    /// A builder for [`MetricDimension`](crate::model::MetricDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The dimension name.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The dimension name.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The dimension value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The dimension value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDimension`](crate::model::MetricDimension)
        pub fn build(self) -> crate::model::MetricDimension {
            crate::model::MetricDimension {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl MetricDimension {
    /// Creates a new builder-style object to manufacture [`MetricDimension`](crate::model::MetricDimension)
    pub fn builder() -> crate::model::metric_dimension::Builder {
        crate::model::metric_dimension::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Unit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    GigaBits,
    #[allow(missing_docs)] // documentation missing in model
    GigaBitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    GigaBytes,
    #[allow(missing_docs)] // documentation missing in model
    GigaBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    KiloBits,
    #[allow(missing_docs)] // documentation missing in model
    KiloBitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    KiloBytes,
    #[allow(missing_docs)] // documentation missing in model
    KiloBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    MegaBits,
    #[allow(missing_docs)] // documentation missing in model
    MegaBitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    MegaBytes,
    #[allow(missing_docs)] // documentation missing in model
    MegaBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    MicroSeconds,
    #[allow(missing_docs)] // documentation missing in model
    MilliSeconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    TeraBits,
    #[allow(missing_docs)] // documentation missing in model
    TeraBitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    TeraBytes,
    #[allow(missing_docs)] // documentation missing in model
    TeraBytesPerSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Unit {
    fn from(s: &str) -> Self {
        match s {
            "BITS" => Unit::Bits,
            "BITS_PER_SECOND" => Unit::BitsPerSecond,
            "BYTES" => Unit::Bytes,
            "BYTES_PER_SECOND" => Unit::BytesPerSecond,
            "COUNT" => Unit::Count,
            "COUNT_PER_SECOND" => Unit::CountPerSecond,
            "GIGA_BITS" => Unit::GigaBits,
            "GIGA_BITS_PER_SECOND" => Unit::GigaBitsPerSecond,
            "GIGA_BYTES" => Unit::GigaBytes,
            "GIGA_BYTES_PER_SECOND" => Unit::GigaBytesPerSecond,
            "KILO_BITS" => Unit::KiloBits,
            "KILO_BITS_PER_SECOND" => Unit::KiloBitsPerSecond,
            "KILO_BYTES" => Unit::KiloBytes,
            "KILO_BYTES_PER_SECOND" => Unit::KiloBytesPerSecond,
            "MEGA_BITS" => Unit::MegaBits,
            "MEGA_BITS_PER_SECOND" => Unit::MegaBitsPerSecond,
            "MEGA_BYTES" => Unit::MegaBytes,
            "MEGA_BYTES_PER_SECOND" => Unit::MegaBytesPerSecond,
            "MICRO_SECONDS" => Unit::MicroSeconds,
            "MILLI_SECONDS" => Unit::MilliSeconds,
            "NONE" => Unit::None,
            "PERCENT" => Unit::Percent,
            "SECONDS" => Unit::Seconds,
            "TERA_BITS" => Unit::TeraBits,
            "TERA_BITS_PER_SECOND" => Unit::TeraBitsPerSecond,
            "TERA_BYTES" => Unit::TeraBytes,
            "TERA_BYTES_PER_SECOND" => Unit::TeraBytesPerSecond,
            other => Unit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Unit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Unit::from(s))
    }
}
impl Unit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Unit::Bits => "BITS",
            Unit::BitsPerSecond => "BITS_PER_SECOND",
            Unit::Bytes => "BYTES",
            Unit::BytesPerSecond => "BYTES_PER_SECOND",
            Unit::Count => "COUNT",
            Unit::CountPerSecond => "COUNT_PER_SECOND",
            Unit::GigaBits => "GIGA_BITS",
            Unit::GigaBitsPerSecond => "GIGA_BITS_PER_SECOND",
            Unit::GigaBytes => "GIGA_BYTES",
            Unit::GigaBytesPerSecond => "GIGA_BYTES_PER_SECOND",
            Unit::KiloBits => "KILO_BITS",
            Unit::KiloBitsPerSecond => "KILO_BITS_PER_SECOND",
            Unit::KiloBytes => "KILO_BYTES",
            Unit::KiloBytesPerSecond => "KILO_BYTES_PER_SECOND",
            Unit::MegaBits => "MEGA_BITS",
            Unit::MegaBitsPerSecond => "MEGA_BITS_PER_SECOND",
            Unit::MegaBytes => "MEGA_BYTES",
            Unit::MegaBytesPerSecond => "MEGA_BYTES_PER_SECOND",
            Unit::MicroSeconds => "MICRO_SECONDS",
            Unit::MilliSeconds => "MILLI_SECONDS",
            Unit::None => "NONE",
            Unit::Percent => "PERCENT",
            Unit::Seconds => "SECONDS",
            Unit::TeraBits => "TERA_BITS",
            Unit::TeraBitsPerSecond => "TERA_BITS_PER_SECOND",
            Unit::TeraBytes => "TERA_BYTES",
            Unit::TeraBytesPerSecond => "TERA_BYTES_PER_SECOND",
            Unit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BITS",
            "BITS_PER_SECOND",
            "BYTES",
            "BYTES_PER_SECOND",
            "COUNT",
            "COUNT_PER_SECOND",
            "GIGA_BITS",
            "GIGA_BITS_PER_SECOND",
            "GIGA_BYTES",
            "GIGA_BYTES_PER_SECOND",
            "KILO_BITS",
            "KILO_BITS_PER_SECOND",
            "KILO_BYTES",
            "KILO_BYTES_PER_SECOND",
            "MEGA_BITS",
            "MEGA_BITS_PER_SECOND",
            "MEGA_BYTES",
            "MEGA_BYTES_PER_SECOND",
            "MICRO_SECONDS",
            "MILLI_SECONDS",
            "NONE",
            "PERCENT",
            "SECONDS",
            "TERA_BITS",
            "TERA_BITS_PER_SECOND",
            "TERA_BYTES",
            "TERA_BYTES_PER_SECOND",
        ]
    }
}
impl AsRef<str> for Unit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Statistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Statistic {
    fn from(s: &str) -> Self {
        match s {
            "AVERAGE" => Statistic::Average,
            "MAXIMUM" => Statistic::Maximum,
            "MINIMUM" => Statistic::Minimum,
            "SAMPLE_COUNT" => Statistic::SampleCount,
            "SUM" => Statistic::Sum,
            other => Statistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Statistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Statistic::from(s))
    }
}
impl Statistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Statistic::Average => "AVERAGE",
            Statistic::Maximum => "MAXIMUM",
            Statistic::Minimum => "MINIMUM",
            Statistic::SampleCount => "SAMPLE_COUNT",
            Statistic::Sum => "SUM",
            Statistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVERAGE", "MAXIMUM", "MINIMUM", "SAMPLE_COUNT", "SUM"]
    }
}
impl AsRef<str> for Statistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "GREATER_THAN" => ComparisonOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL" => ComparisonOperator::GreaterThanOrEqual,
            "LESS_THAN" => ComparisonOperator::LessThan,
            "LESS_THAN_OR_EQUAL" => ComparisonOperator::LessThanOrEqual,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::GreaterThan => "GREATER_THAN",
            ComparisonOperator::GreaterThanOrEqual => "GREATER_THAN_OR_EQUAL",
            ComparisonOperator::LessThan => "LESS_THAN",
            ComparisonOperator::LessThanOrEqual => "LESS_THAN_OR_EQUAL",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The type of adjustment the automatic scaling activity makes when triggered, and the
/// periodicity of the adjustment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingAction {
    /// <p>Not available for instance groups. Instance groups use the market type specified for the
    /// group.</p>
    pub market: std::option::Option<crate::model::MarketType>,
    /// <p>The type of adjustment the automatic scaling activity makes when triggered, and the
    /// periodicity of the adjustment.</p>
    pub simple_scaling_policy_configuration:
        std::option::Option<crate::model::SimpleScalingPolicyConfiguration>,
}
impl std::fmt::Debug for ScalingAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingAction");
        formatter.field("market", &self.market);
        formatter.field(
            "simple_scaling_policy_configuration",
            &self.simple_scaling_policy_configuration,
        );
        formatter.finish()
    }
}
/// See [`ScalingAction`](crate::model::ScalingAction)
pub mod scaling_action {
    /// A builder for [`ScalingAction`](crate::model::ScalingAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) market: std::option::Option<crate::model::MarketType>,
        pub(crate) simple_scaling_policy_configuration:
            std::option::Option<crate::model::SimpleScalingPolicyConfiguration>,
    }
    impl Builder {
        /// <p>Not available for instance groups. Instance groups use the market type specified for the
        /// group.</p>
        pub fn market(mut self, input: crate::model::MarketType) -> Self {
            self.market = Some(input);
            self
        }
        /// <p>Not available for instance groups. Instance groups use the market type specified for the
        /// group.</p>
        pub fn set_market(mut self, input: std::option::Option<crate::model::MarketType>) -> Self {
            self.market = input;
            self
        }
        /// <p>The type of adjustment the automatic scaling activity makes when triggered, and the
        /// periodicity of the adjustment.</p>
        pub fn simple_scaling_policy_configuration(
            mut self,
            input: crate::model::SimpleScalingPolicyConfiguration,
        ) -> Self {
            self.simple_scaling_policy_configuration = Some(input);
            self
        }
        /// <p>The type of adjustment the automatic scaling activity makes when triggered, and the
        /// periodicity of the adjustment.</p>
        pub fn set_simple_scaling_policy_configuration(
            mut self,
            input: std::option::Option<crate::model::SimpleScalingPolicyConfiguration>,
        ) -> Self {
            self.simple_scaling_policy_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingAction`](crate::model::ScalingAction)
        pub fn build(self) -> crate::model::ScalingAction {
            crate::model::ScalingAction {
                market: self.market,
                simple_scaling_policy_configuration: self.simple_scaling_policy_configuration,
            }
        }
    }
}
impl ScalingAction {
    /// Creates a new builder-style object to manufacture [`ScalingAction`](crate::model::ScalingAction)
    pub fn builder() -> crate::model::scaling_action::Builder {
        crate::model::scaling_action::Builder::default()
    }
}

/// <p>An automatic scaling configuration, which describes how the policy adds or removes
/// instances, the cooldown period, and the number of EC2 instances that will be added each
/// time the CloudWatch metric alarm condition is satisfied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimpleScalingPolicyConfiguration {
    /// <p>The way in which EC2 instances are added (if <code>ScalingAdjustment</code> is a
    /// positive number) or terminated (if <code>ScalingAdjustment</code> is a negative number)
    /// each time the scaling activity is triggered. <code>CHANGE_IN_CAPACITY</code> is the
    /// default. <code>CHANGE_IN_CAPACITY</code> indicates that the EC2 instance count increments
    /// or decrements by <code>ScalingAdjustment</code>, which should be expressed as an integer.
    /// <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or
    /// decrements by the percentage specified by <code>ScalingAdjustment</code>, which should be
    /// expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster
    /// capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance
    /// group with the number of EC2 instances specified by <code>ScalingAdjustment</code>, which
    /// should be expressed as a positive integer.</p>
    pub adjustment_type: std::option::Option<crate::model::AdjustmentType>,
    /// <p>The amount by which to scale in or scale out, based on the specified
    /// <code>AdjustmentType</code>. A positive value adds to the instance group's EC2 instance
    /// count while a negative number removes instances. If <code>AdjustmentType</code> is set to
    /// <code>EXACT_CAPACITY</code>, the number should only be a positive integer. If
    /// <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code>, the value
    /// should express the percentage as an integer. For example, -20 indicates a decrease in 20%
    /// increments of cluster capacity.</p>
    pub scaling_adjustment: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, after a scaling activity completes before any further
    /// trigger-related scaling activities can start. The default value is 0.</p>
    pub cool_down: std::option::Option<i32>,
}
impl std::fmt::Debug for SimpleScalingPolicyConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimpleScalingPolicyConfiguration");
        formatter.field("adjustment_type", &self.adjustment_type);
        formatter.field("scaling_adjustment", &self.scaling_adjustment);
        formatter.field("cool_down", &self.cool_down);
        formatter.finish()
    }
}
/// See [`SimpleScalingPolicyConfiguration`](crate::model::SimpleScalingPolicyConfiguration)
pub mod simple_scaling_policy_configuration {
    /// A builder for [`SimpleScalingPolicyConfiguration`](crate::model::SimpleScalingPolicyConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adjustment_type: std::option::Option<crate::model::AdjustmentType>,
        pub(crate) scaling_adjustment: std::option::Option<i32>,
        pub(crate) cool_down: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The way in which EC2 instances are added (if <code>ScalingAdjustment</code> is a
        /// positive number) or terminated (if <code>ScalingAdjustment</code> is a negative number)
        /// each time the scaling activity is triggered. <code>CHANGE_IN_CAPACITY</code> is the
        /// default. <code>CHANGE_IN_CAPACITY</code> indicates that the EC2 instance count increments
        /// or decrements by <code>ScalingAdjustment</code>, which should be expressed as an integer.
        /// <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or
        /// decrements by the percentage specified by <code>ScalingAdjustment</code>, which should be
        /// expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster
        /// capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance
        /// group with the number of EC2 instances specified by <code>ScalingAdjustment</code>, which
        /// should be expressed as a positive integer.</p>
        pub fn adjustment_type(mut self, input: crate::model::AdjustmentType) -> Self {
            self.adjustment_type = Some(input);
            self
        }
        /// <p>The way in which EC2 instances are added (if <code>ScalingAdjustment</code> is a
        /// positive number) or terminated (if <code>ScalingAdjustment</code> is a negative number)
        /// each time the scaling activity is triggered. <code>CHANGE_IN_CAPACITY</code> is the
        /// default. <code>CHANGE_IN_CAPACITY</code> indicates that the EC2 instance count increments
        /// or decrements by <code>ScalingAdjustment</code>, which should be expressed as an integer.
        /// <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or
        /// decrements by the percentage specified by <code>ScalingAdjustment</code>, which should be
        /// expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster
        /// capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance
        /// group with the number of EC2 instances specified by <code>ScalingAdjustment</code>, which
        /// should be expressed as a positive integer.</p>
        pub fn set_adjustment_type(
            mut self,
            input: std::option::Option<crate::model::AdjustmentType>,
        ) -> Self {
            self.adjustment_type = input;
            self
        }
        /// <p>The amount by which to scale in or scale out, based on the specified
        /// <code>AdjustmentType</code>. A positive value adds to the instance group's EC2 instance
        /// count while a negative number removes instances. If <code>AdjustmentType</code> is set to
        /// <code>EXACT_CAPACITY</code>, the number should only be a positive integer. If
        /// <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code>, the value
        /// should express the percentage as an integer. For example, -20 indicates a decrease in 20%
        /// increments of cluster capacity.</p>
        pub fn scaling_adjustment(mut self, input: i32) -> Self {
            self.scaling_adjustment = Some(input);
            self
        }
        /// <p>The amount by which to scale in or scale out, based on the specified
        /// <code>AdjustmentType</code>. A positive value adds to the instance group's EC2 instance
        /// count while a negative number removes instances. If <code>AdjustmentType</code> is set to
        /// <code>EXACT_CAPACITY</code>, the number should only be a positive integer. If
        /// <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code>, the value
        /// should express the percentage as an integer. For example, -20 indicates a decrease in 20%
        /// increments of cluster capacity.</p>
        pub fn set_scaling_adjustment(mut self, input: std::option::Option<i32>) -> Self {
            self.scaling_adjustment = input;
            self
        }
        /// <p>The amount of time, in seconds, after a scaling activity completes before any further
        /// trigger-related scaling activities can start. The default value is 0.</p>
        pub fn cool_down(mut self, input: i32) -> Self {
            self.cool_down = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after a scaling activity completes before any further
        /// trigger-related scaling activities can start. The default value is 0.</p>
        pub fn set_cool_down(mut self, input: std::option::Option<i32>) -> Self {
            self.cool_down = input;
            self
        }
        /// Consumes the builder and constructs a [`SimpleScalingPolicyConfiguration`](crate::model::SimpleScalingPolicyConfiguration)
        pub fn build(self) -> crate::model::SimpleScalingPolicyConfiguration {
            crate::model::SimpleScalingPolicyConfiguration {
                adjustment_type: self.adjustment_type,
                scaling_adjustment: self.scaling_adjustment,
                cool_down: self.cool_down,
            }
        }
    }
}
impl SimpleScalingPolicyConfiguration {
    /// Creates a new builder-style object to manufacture [`SimpleScalingPolicyConfiguration`](crate::model::SimpleScalingPolicyConfiguration)
    pub fn builder() -> crate::model::simple_scaling_policy_configuration::Builder {
        crate::model::simple_scaling_policy_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdjustmentType {
    #[allow(missing_docs)] // documentation missing in model
    ChangeInCapacity,
    #[allow(missing_docs)] // documentation missing in model
    ExactCapacity,
    #[allow(missing_docs)] // documentation missing in model
    PercentChangeInCapacity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdjustmentType {
    fn from(s: &str) -> Self {
        match s {
            "CHANGE_IN_CAPACITY" => AdjustmentType::ChangeInCapacity,
            "EXACT_CAPACITY" => AdjustmentType::ExactCapacity,
            "PERCENT_CHANGE_IN_CAPACITY" => AdjustmentType::PercentChangeInCapacity,
            other => AdjustmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdjustmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdjustmentType::from(s))
    }
}
impl AdjustmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdjustmentType::ChangeInCapacity => "CHANGE_IN_CAPACITY",
            AdjustmentType::ExactCapacity => "EXACT_CAPACITY",
            AdjustmentType::PercentChangeInCapacity => "PERCENT_CHANGE_IN_CAPACITY",
            AdjustmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CHANGE_IN_CAPACITY",
            "EXACT_CAPACITY",
            "PERCENT_CHANGE_IN_CAPACITY",
        ]
    }
}
impl AsRef<str> for AdjustmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MarketType {
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    #[allow(missing_docs)] // documentation missing in model
    Spot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MarketType {
    fn from(s: &str) -> Self {
        match s {
            "ON_DEMAND" => MarketType::OnDemand,
            "SPOT" => MarketType::Spot,
            other => MarketType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MarketType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MarketType::from(s))
    }
}
impl MarketType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MarketType::OnDemand => "ON_DEMAND",
            MarketType::Spot => "SPOT",
            MarketType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ON_DEMAND", "SPOT"]
    }
}
impl AsRef<str> for MarketType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
/// scaling activities triggered by automatic scaling rules will not cause an instance group to
/// grow above or below these limits.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingConstraints {
    /// <p>The lower boundary of EC2 instances in an instance group below which scaling activities
    /// are not allowed to shrink. Scale-in activities will not terminate instances below this
    /// boundary.</p>
    pub min_capacity: std::option::Option<i32>,
    /// <p>The upper boundary of EC2 instances in an instance group beyond which scaling activities
    /// are not allowed to grow. Scale-out activities will not add instances beyond this
    /// boundary.</p>
    pub max_capacity: std::option::Option<i32>,
}
impl std::fmt::Debug for ScalingConstraints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingConstraints");
        formatter.field("min_capacity", &self.min_capacity);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.finish()
    }
}
/// See [`ScalingConstraints`](crate::model::ScalingConstraints)
pub mod scaling_constraints {
    /// A builder for [`ScalingConstraints`](crate::model::ScalingConstraints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_capacity: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The lower boundary of EC2 instances in an instance group below which scaling activities
        /// are not allowed to shrink. Scale-in activities will not terminate instances below this
        /// boundary.</p>
        pub fn min_capacity(mut self, input: i32) -> Self {
            self.min_capacity = Some(input);
            self
        }
        /// <p>The lower boundary of EC2 instances in an instance group below which scaling activities
        /// are not allowed to shrink. Scale-in activities will not terminate instances below this
        /// boundary.</p>
        pub fn set_min_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.min_capacity = input;
            self
        }
        /// <p>The upper boundary of EC2 instances in an instance group beyond which scaling activities
        /// are not allowed to grow. Scale-out activities will not add instances beyond this
        /// boundary.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The upper boundary of EC2 instances in an instance group beyond which scaling activities
        /// are not allowed to grow. Scale-out activities will not add instances beyond this
        /// boundary.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingConstraints`](crate::model::ScalingConstraints)
        pub fn build(self) -> crate::model::ScalingConstraints {
            crate::model::ScalingConstraints {
                min_capacity: self.min_capacity,
                max_capacity: self.max_capacity,
            }
        }
    }
}
impl ScalingConstraints {
    /// Creates a new builder-style object to manufacture [`ScalingConstraints`](crate::model::ScalingConstraints)
    pub fn builder() -> crate::model::scaling_constraints::Builder {
        crate::model::scaling_constraints::Builder::default()
    }
}

/// <p>A configuration for Amazon EMR block public access. When
/// <code>BlockPublicSecurityGroupRules</code> is set to <code>true</code>, Amazon EMR
/// prevents cluster creation if one of the cluster's security groups has a rule that allows
/// inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an
/// exception using <code>PermittedPublicSecurityGroupRuleRanges</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockPublicAccessConfiguration {
    /// <p>Indicates whether Amazon EMR block public access is enabled (<code>true</code>) or
    /// disabled (<code>false</code>). By default, the value is <code>false</code> for accounts
    /// that have created EMR clusters before July 2019. For accounts created after this, the
    /// default is <code>true</code>.</p>
    pub block_public_security_group_rules: bool,
    /// <p>Specifies ports and port ranges that are permitted to have security group rules that
    /// allow inbound traffic from all public sources. For example, if Port 23 (Telnet) is
    /// specified for <code>PermittedPublicSecurityGroupRuleRanges</code>, Amazon EMR allows
    /// cluster creation if a security group associated with the cluster has a rule that allows
    /// inbound traffic on Port 23 from IPv4 0.0.0.0/0 or IPv6 port ::/0 as the source.</p>
    /// <p>By default, Port 22, which is used for SSH access to the cluster EC2 instances, is in
    /// the list of <code>PermittedPublicSecurityGroupRuleRanges</code>.</p>
    pub permitted_public_security_group_rule_ranges:
        std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The classification within a configuration.</p>
    pub classification: std::option::Option<std::string::String>,
    /// <p>A list of additional configurations to apply within a configuration object.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>A set of properties specified within a configuration classification.</p>
    pub properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for BlockPublicAccessConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockPublicAccessConfiguration");
        formatter.field(
            "block_public_security_group_rules",
            &self.block_public_security_group_rules,
        );
        formatter.field(
            "permitted_public_security_group_rule_ranges",
            &self.permitted_public_security_group_rule_ranges,
        );
        formatter.field("classification", &self.classification);
        formatter.field("configurations", &self.configurations);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`BlockPublicAccessConfiguration`](crate::model::BlockPublicAccessConfiguration)
pub mod block_public_access_configuration {
    /// A builder for [`BlockPublicAccessConfiguration`](crate::model::BlockPublicAccessConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_public_security_group_rules: std::option::Option<bool>,
        pub(crate) permitted_public_security_group_rule_ranges:
            std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) classification: std::option::Option<std::string::String>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Indicates whether Amazon EMR block public access is enabled (<code>true</code>) or
        /// disabled (<code>false</code>). By default, the value is <code>false</code> for accounts
        /// that have created EMR clusters before July 2019. For accounts created after this, the
        /// default is <code>true</code>.</p>
        pub fn block_public_security_group_rules(mut self, input: bool) -> Self {
            self.block_public_security_group_rules = Some(input);
            self
        }
        /// <p>Indicates whether Amazon EMR block public access is enabled (<code>true</code>) or
        /// disabled (<code>false</code>). By default, the value is <code>false</code> for accounts
        /// that have created EMR clusters before July 2019. For accounts created after this, the
        /// default is <code>true</code>.</p>
        pub fn set_block_public_security_group_rules(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.block_public_security_group_rules = input;
            self
        }
        /// Appends an item to `permitted_public_security_group_rule_ranges`.
        ///
        /// To override the contents of this collection use [`set_permitted_public_security_group_rule_ranges`](Self::set_permitted_public_security_group_rule_ranges).
        ///
        /// <p>Specifies ports and port ranges that are permitted to have security group rules that
        /// allow inbound traffic from all public sources. For example, if Port 23 (Telnet) is
        /// specified for <code>PermittedPublicSecurityGroupRuleRanges</code>, Amazon EMR allows
        /// cluster creation if a security group associated with the cluster has a rule that allows
        /// inbound traffic on Port 23 from IPv4 0.0.0.0/0 or IPv6 port ::/0 as the source.</p>
        /// <p>By default, Port 22, which is used for SSH access to the cluster EC2 instances, is in
        /// the list of <code>PermittedPublicSecurityGroupRuleRanges</code>.</p>
        pub fn permitted_public_security_group_rule_ranges(
            mut self,
            input: impl Into<crate::model::PortRange>,
        ) -> Self {
            let mut v = self
                .permitted_public_security_group_rule_ranges
                .unwrap_or_default();
            v.push(input.into());
            self.permitted_public_security_group_rule_ranges = Some(v);
            self
        }
        /// <p>Specifies ports and port ranges that are permitted to have security group rules that
        /// allow inbound traffic from all public sources. For example, if Port 23 (Telnet) is
        /// specified for <code>PermittedPublicSecurityGroupRuleRanges</code>, Amazon EMR allows
        /// cluster creation if a security group associated with the cluster has a rule that allows
        /// inbound traffic on Port 23 from IPv4 0.0.0.0/0 or IPv6 port ::/0 as the source.</p>
        /// <p>By default, Port 22, which is used for SSH access to the cluster EC2 instances, is in
        /// the list of <code>PermittedPublicSecurityGroupRuleRanges</code>.</p>
        pub fn set_permitted_public_security_group_rule_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.permitted_public_security_group_rule_ranges = input;
            self
        }
        /// <p>The classification within a configuration.</p>
        pub fn classification(mut self, input: impl Into<std::string::String>) -> Self {
            self.classification = Some(input.into());
            self
        }
        /// <p>The classification within a configuration.</p>
        pub fn set_classification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classification = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A list of additional configurations to apply within a configuration object.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>A list of additional configurations to apply within a configuration object.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A set of properties specified within a configuration classification.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.properties = Some(hash_map);
            self
        }
        /// <p>A set of properties specified within a configuration classification.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockPublicAccessConfiguration`](crate::model::BlockPublicAccessConfiguration)
        pub fn build(self) -> crate::model::BlockPublicAccessConfiguration {
            crate::model::BlockPublicAccessConfiguration {
                block_public_security_group_rules: self
                    .block_public_security_group_rules
                    .unwrap_or_default(),
                permitted_public_security_group_rule_ranges: self
                    .permitted_public_security_group_rule_ranges,
                classification: self.classification,
                configurations: self.configurations,
                properties: self.properties,
            }
        }
    }
}
impl BlockPublicAccessConfiguration {
    /// Creates a new builder-style object to manufacture [`BlockPublicAccessConfiguration`](crate::model::BlockPublicAccessConfiguration)
    pub fn builder() -> crate::model::block_public_access_configuration::Builder {
        crate::model::block_public_access_configuration::Builder::default()
    }
}

/// <p>A list of port ranges that are permitted to allow inbound traffic from all public IP
/// addresses. To specify a single port, use the same value for <code>MinRange</code> and
/// <code>MaxRange</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortRange {
    /// <p>The smallest port number in a specified range of port numbers.</p>
    pub min_range: std::option::Option<i32>,
    /// <p>The smallest port number in a specified range of port numbers.</p>
    pub max_range: std::option::Option<i32>,
}
impl std::fmt::Debug for PortRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortRange");
        formatter.field("min_range", &self.min_range);
        formatter.field("max_range", &self.max_range);
        formatter.finish()
    }
}
/// See [`PortRange`](crate::model::PortRange)
pub mod port_range {
    /// A builder for [`PortRange`](crate::model::PortRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_range: std::option::Option<i32>,
        pub(crate) max_range: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The smallest port number in a specified range of port numbers.</p>
        pub fn min_range(mut self, input: i32) -> Self {
            self.min_range = Some(input);
            self
        }
        /// <p>The smallest port number in a specified range of port numbers.</p>
        pub fn set_min_range(mut self, input: std::option::Option<i32>) -> Self {
            self.min_range = input;
            self
        }
        /// <p>The smallest port number in a specified range of port numbers.</p>
        pub fn max_range(mut self, input: i32) -> Self {
            self.max_range = Some(input);
            self
        }
        /// <p>The smallest port number in a specified range of port numbers.</p>
        pub fn set_max_range(mut self, input: std::option::Option<i32>) -> Self {
            self.max_range = input;
            self
        }
        /// Consumes the builder and constructs a [`PortRange`](crate::model::PortRange)
        pub fn build(self) -> crate::model::PortRange {
            crate::model::PortRange {
                min_range: self.min_range,
                max_range: self.max_range,
            }
        }
    }
}
impl PortRange {
    /// Creates a new builder-style object to manufacture [`PortRange`](crate::model::PortRange)
    pub fn builder() -> crate::model::port_range::Builder {
        crate::model::port_range::Builder::default()
    }
}

/// <p>An automatic scaling policy for a core instance group or task instance group in an
/// Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
/// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
/// <a>PutAutoScalingPolicy</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingPolicyDescription {
    /// <p>The status of an automatic scaling policy. </p>
    pub status: std::option::Option<crate::model::AutoScalingPolicyStatus>,
    /// <p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
    /// scaling activity will not cause an instance group to grow above or below these
    /// limits.</p>
    pub constraints: std::option::Option<crate::model::ScalingConstraints>,
    /// <p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ScalingRule>>,
}
impl std::fmt::Debug for AutoScalingPolicyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingPolicyDescription");
        formatter.field("status", &self.status);
        formatter.field("constraints", &self.constraints);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
pub mod auto_scaling_policy_description {
    /// A builder for [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AutoScalingPolicyStatus>,
        pub(crate) constraints: std::option::Option<crate::model::ScalingConstraints>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::ScalingRule>>,
    }
    impl Builder {
        /// <p>The status of an automatic scaling policy. </p>
        pub fn status(mut self, input: crate::model::AutoScalingPolicyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of an automatic scaling policy. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
        /// scaling activity will not cause an instance group to grow above or below these
        /// limits.</p>
        pub fn constraints(mut self, input: crate::model::ScalingConstraints) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
        /// scaling activity will not cause an instance group to grow above or below these
        /// limits.</p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::ScalingConstraints>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>
        pub fn rules(mut self, input: impl Into<crate::model::ScalingRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
        pub fn build(self) -> crate::model::AutoScalingPolicyDescription {
            crate::model::AutoScalingPolicyDescription {
                status: self.status,
                constraints: self.constraints,
                rules: self.rules,
            }
        }
    }
}
impl AutoScalingPolicyDescription {
    /// Creates a new builder-style object to manufacture [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
    pub fn builder() -> crate::model::auto_scaling_policy_description::Builder {
        crate::model::auto_scaling_policy_description::Builder::default()
    }
}

/// <p>The status of an automatic scaling policy.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingPolicyStatus {
    /// <p>Indicates the status of the automatic scaling policy.</p>
    pub state: std::option::Option<crate::model::AutoScalingPolicyState>,
    /// <p>The reason for a change in status.</p>
    pub state_change_reason: std::option::Option<crate::model::AutoScalingPolicyStateChangeReason>,
}
impl std::fmt::Debug for AutoScalingPolicyStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingPolicyStatus");
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.finish()
    }
}
/// See [`AutoScalingPolicyStatus`](crate::model::AutoScalingPolicyStatus)
pub mod auto_scaling_policy_status {
    /// A builder for [`AutoScalingPolicyStatus`](crate::model::AutoScalingPolicyStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::AutoScalingPolicyState>,
        pub(crate) state_change_reason:
            std::option::Option<crate::model::AutoScalingPolicyStateChangeReason>,
    }
    impl Builder {
        /// <p>Indicates the status of the automatic scaling policy.</p>
        pub fn state(mut self, input: crate::model::AutoScalingPolicyState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates the status of the automatic scaling policy.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicyState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for a change in status.</p>
        pub fn state_change_reason(
            mut self,
            input: crate::model::AutoScalingPolicyStateChangeReason,
        ) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>The reason for a change in status.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicyStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingPolicyStatus`](crate::model::AutoScalingPolicyStatus)
        pub fn build(self) -> crate::model::AutoScalingPolicyStatus {
            crate::model::AutoScalingPolicyStatus {
                state: self.state,
                state_change_reason: self.state_change_reason,
            }
        }
    }
}
impl AutoScalingPolicyStatus {
    /// Creates a new builder-style object to manufacture [`AutoScalingPolicyStatus`](crate::model::AutoScalingPolicyStatus)
    pub fn builder() -> crate::model::auto_scaling_policy_status::Builder {
        crate::model::auto_scaling_policy_status::Builder::default()
    }
}

/// <p>The reason for an <a>AutoScalingPolicyStatus</a> change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingPolicyStateChangeReason {
    /// <p>The code indicating the reason for the change in status.<code>USER_REQUEST</code>
    /// indicates that the scaling policy status was changed by a user.
    /// <code>PROVISION_FAILURE</code> indicates that the status change was because the policy
    /// failed to provision. <code>CLEANUP_FAILURE</code> indicates an error.</p>
    pub code: std::option::Option<crate::model::AutoScalingPolicyStateChangeReasonCode>,
    /// <p>A friendly, more verbose message that accompanies an automatic scaling policy state
    /// change.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutoScalingPolicyStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingPolicyStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`AutoScalingPolicyStateChangeReason`](crate::model::AutoScalingPolicyStateChangeReason)
pub mod auto_scaling_policy_state_change_reason {
    /// A builder for [`AutoScalingPolicyStateChangeReason`](crate::model::AutoScalingPolicyStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::AutoScalingPolicyStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The code indicating the reason for the change in status.<code>USER_REQUEST</code>
        /// indicates that the scaling policy status was changed by a user.
        /// <code>PROVISION_FAILURE</code> indicates that the status change was because the policy
        /// failed to provision. <code>CLEANUP_FAILURE</code> indicates an error.</p>
        pub fn code(mut self, input: crate::model::AutoScalingPolicyStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The code indicating the reason for the change in status.<code>USER_REQUEST</code>
        /// indicates that the scaling policy status was changed by a user.
        /// <code>PROVISION_FAILURE</code> indicates that the status change was because the policy
        /// failed to provision. <code>CLEANUP_FAILURE</code> indicates an error.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicyStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>A friendly, more verbose message that accompanies an automatic scaling policy state
        /// change.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A friendly, more verbose message that accompanies an automatic scaling policy state
        /// change.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingPolicyStateChangeReason`](crate::model::AutoScalingPolicyStateChangeReason)
        pub fn build(self) -> crate::model::AutoScalingPolicyStateChangeReason {
            crate::model::AutoScalingPolicyStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl AutoScalingPolicyStateChangeReason {
    /// Creates a new builder-style object to manufacture [`AutoScalingPolicyStateChangeReason`](crate::model::AutoScalingPolicyStateChangeReason)
    pub fn builder() -> crate::model::auto_scaling_policy_state_change_reason::Builder {
        crate::model::auto_scaling_policy_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoScalingPolicyStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    CleanupFailure,
    #[allow(missing_docs)] // documentation missing in model
    ProvisionFailure,
    #[allow(missing_docs)] // documentation missing in model
    UserRequest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoScalingPolicyStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "CLEANUP_FAILURE" => AutoScalingPolicyStateChangeReasonCode::CleanupFailure,
            "PROVISION_FAILURE" => AutoScalingPolicyStateChangeReasonCode::ProvisionFailure,
            "USER_REQUEST" => AutoScalingPolicyStateChangeReasonCode::UserRequest,
            other => AutoScalingPolicyStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoScalingPolicyStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoScalingPolicyStateChangeReasonCode::from(s))
    }
}
impl AutoScalingPolicyStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoScalingPolicyStateChangeReasonCode::CleanupFailure => "CLEANUP_FAILURE",
            AutoScalingPolicyStateChangeReasonCode::ProvisionFailure => "PROVISION_FAILURE",
            AutoScalingPolicyStateChangeReasonCode::UserRequest => "USER_REQUEST",
            AutoScalingPolicyStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLEANUP_FAILURE", "PROVISION_FAILURE", "USER_REQUEST"]
    }
}
impl AsRef<str> for AutoScalingPolicyStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoScalingPolicyState {
    #[allow(missing_docs)] // documentation missing in model
    Attached,
    #[allow(missing_docs)] // documentation missing in model
    Attaching,
    #[allow(missing_docs)] // documentation missing in model
    Detached,
    #[allow(missing_docs)] // documentation missing in model
    Detaching,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoScalingPolicyState {
    fn from(s: &str) -> Self {
        match s {
            "ATTACHED" => AutoScalingPolicyState::Attached,
            "ATTACHING" => AutoScalingPolicyState::Attaching,
            "DETACHED" => AutoScalingPolicyState::Detached,
            "DETACHING" => AutoScalingPolicyState::Detaching,
            "FAILED" => AutoScalingPolicyState::Failed,
            "PENDING" => AutoScalingPolicyState::Pending,
            other => AutoScalingPolicyState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoScalingPolicyState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoScalingPolicyState::from(s))
    }
}
impl AutoScalingPolicyState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoScalingPolicyState::Attached => "ATTACHED",
            AutoScalingPolicyState::Attaching => "ATTACHING",
            AutoScalingPolicyState::Detached => "DETACHED",
            AutoScalingPolicyState::Detaching => "DETACHING",
            AutoScalingPolicyState::Failed => "FAILED",
            AutoScalingPolicyState::Pending => "PENDING",
            AutoScalingPolicyState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ATTACHED",
            "ATTACHING",
            "DETACHED",
            "DETACHING",
            "FAILED",
            "PENDING",
        ]
    }
}
impl AsRef<str> for AutoScalingPolicyState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Modify the size or configurations of an instance group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceGroupModifyConfig {
    /// <p>Unique ID of the instance group to modify.</p>
    pub instance_group_id: std::option::Option<std::string::String>,
    /// <p>Target size for the instance group.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>The EC2 InstanceIds to terminate. After you terminate the instances, the instance group
    /// will not return to its original requested size.</p>
    pub ec2_instance_ids_to_terminate: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Policy for customizing shrink operations.</p>
    pub shrink_policy: std::option::Option<crate::model::ShrinkPolicy>,
    /// <p>A list of new or modified configurations to apply for an instance group.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
}
impl std::fmt::Debug for InstanceGroupModifyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceGroupModifyConfig");
        formatter.field("instance_group_id", &self.instance_group_id);
        formatter.field("instance_count", &self.instance_count);
        formatter.field(
            "ec2_instance_ids_to_terminate",
            &self.ec2_instance_ids_to_terminate,
        );
        formatter.field("shrink_policy", &self.shrink_policy);
        formatter.field("configurations", &self.configurations);
        formatter.finish()
    }
}
/// See [`InstanceGroupModifyConfig`](crate::model::InstanceGroupModifyConfig)
pub mod instance_group_modify_config {
    /// A builder for [`InstanceGroupModifyConfig`](crate::model::InstanceGroupModifyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_group_id: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) ec2_instance_ids_to_terminate:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) shrink_policy: std::option::Option<crate::model::ShrinkPolicy>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    }
    impl Builder {
        /// <p>Unique ID of the instance group to modify.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_group_id = Some(input.into());
            self
        }
        /// <p>Unique ID of the instance group to modify.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_group_id = input;
            self
        }
        /// <p>Target size for the instance group.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>Target size for the instance group.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// Appends an item to `ec2_instance_ids_to_terminate`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_ids_to_terminate`](Self::set_ec2_instance_ids_to_terminate).
        ///
        /// <p>The EC2 InstanceIds to terminate. After you terminate the instances, the instance group
        /// will not return to its original requested size.</p>
        pub fn ec2_instance_ids_to_terminate(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.ec2_instance_ids_to_terminate.unwrap_or_default();
            v.push(input.into());
            self.ec2_instance_ids_to_terminate = Some(v);
            self
        }
        /// <p>The EC2 InstanceIds to terminate. After you terminate the instances, the instance group
        /// will not return to its original requested size.</p>
        pub fn set_ec2_instance_ids_to_terminate(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_instance_ids_to_terminate = input;
            self
        }
        /// <p>Policy for customizing shrink operations.</p>
        pub fn shrink_policy(mut self, input: crate::model::ShrinkPolicy) -> Self {
            self.shrink_policy = Some(input);
            self
        }
        /// <p>Policy for customizing shrink operations.</p>
        pub fn set_shrink_policy(
            mut self,
            input: std::option::Option<crate::model::ShrinkPolicy>,
        ) -> Self {
            self.shrink_policy = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A list of new or modified configurations to apply for an instance group.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>A list of new or modified configurations to apply for an instance group.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceGroupModifyConfig`](crate::model::InstanceGroupModifyConfig)
        pub fn build(self) -> crate::model::InstanceGroupModifyConfig {
            crate::model::InstanceGroupModifyConfig {
                instance_group_id: self.instance_group_id,
                instance_count: self.instance_count,
                ec2_instance_ids_to_terminate: self.ec2_instance_ids_to_terminate,
                shrink_policy: self.shrink_policy,
                configurations: self.configurations,
            }
        }
    }
}
impl InstanceGroupModifyConfig {
    /// Creates a new builder-style object to manufacture [`InstanceGroupModifyConfig`](crate::model::InstanceGroupModifyConfig)
    pub fn builder() -> crate::model::instance_group_modify_config::Builder {
        crate::model::instance_group_modify_config::Builder::default()
    }
}

/// <p>Policy for customizing shrink operations. Allows configuration of decommissioning
/// timeout and targeted instance shrinking.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShrinkPolicy {
    /// <p>The desired timeout for decommissioning an instance. Overrides the default YARN
    /// decommissioning timeout.</p>
    pub decommission_timeout: std::option::Option<i32>,
    /// <p>Custom policy for requesting termination protection or termination of specific instances
    /// when shrinking an instance group.</p>
    pub instance_resize_policy: std::option::Option<crate::model::InstanceResizePolicy>,
}
impl std::fmt::Debug for ShrinkPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShrinkPolicy");
        formatter.field("decommission_timeout", &self.decommission_timeout);
        formatter.field("instance_resize_policy", &self.instance_resize_policy);
        formatter.finish()
    }
}
/// See [`ShrinkPolicy`](crate::model::ShrinkPolicy)
pub mod shrink_policy {
    /// A builder for [`ShrinkPolicy`](crate::model::ShrinkPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) decommission_timeout: std::option::Option<i32>,
        pub(crate) instance_resize_policy: std::option::Option<crate::model::InstanceResizePolicy>,
    }
    impl Builder {
        /// <p>The desired timeout for decommissioning an instance. Overrides the default YARN
        /// decommissioning timeout.</p>
        pub fn decommission_timeout(mut self, input: i32) -> Self {
            self.decommission_timeout = Some(input);
            self
        }
        /// <p>The desired timeout for decommissioning an instance. Overrides the default YARN
        /// decommissioning timeout.</p>
        pub fn set_decommission_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.decommission_timeout = input;
            self
        }
        /// <p>Custom policy for requesting termination protection or termination of specific instances
        /// when shrinking an instance group.</p>
        pub fn instance_resize_policy(mut self, input: crate::model::InstanceResizePolicy) -> Self {
            self.instance_resize_policy = Some(input);
            self
        }
        /// <p>Custom policy for requesting termination protection or termination of specific instances
        /// when shrinking an instance group.</p>
        pub fn set_instance_resize_policy(
            mut self,
            input: std::option::Option<crate::model::InstanceResizePolicy>,
        ) -> Self {
            self.instance_resize_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`ShrinkPolicy`](crate::model::ShrinkPolicy)
        pub fn build(self) -> crate::model::ShrinkPolicy {
            crate::model::ShrinkPolicy {
                decommission_timeout: self.decommission_timeout,
                instance_resize_policy: self.instance_resize_policy,
            }
        }
    }
}
impl ShrinkPolicy {
    /// Creates a new builder-style object to manufacture [`ShrinkPolicy`](crate::model::ShrinkPolicy)
    pub fn builder() -> crate::model::shrink_policy::Builder {
        crate::model::shrink_policy::Builder::default()
    }
}

/// <p>Custom policy for requesting termination protection or termination of specific instances
/// when shrinking an instance group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceResizePolicy {
    /// <p>Specific list of instances to be terminated when shrinking an instance group.</p>
    pub instances_to_terminate: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specific list of instances to be protected when shrinking an instance group.</p>
    pub instances_to_protect: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Decommissioning timeout override for the specific list of instances to be
    /// terminated.</p>
    pub instance_termination_timeout: std::option::Option<i32>,
}
impl std::fmt::Debug for InstanceResizePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceResizePolicy");
        formatter.field("instances_to_terminate", &self.instances_to_terminate);
        formatter.field("instances_to_protect", &self.instances_to_protect);
        formatter.field(
            "instance_termination_timeout",
            &self.instance_termination_timeout,
        );
        formatter.finish()
    }
}
/// See [`InstanceResizePolicy`](crate::model::InstanceResizePolicy)
pub mod instance_resize_policy {
    /// A builder for [`InstanceResizePolicy`](crate::model::InstanceResizePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances_to_terminate: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instances_to_protect: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_termination_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `instances_to_terminate`.
        ///
        /// To override the contents of this collection use [`set_instances_to_terminate`](Self::set_instances_to_terminate).
        ///
        /// <p>Specific list of instances to be terminated when shrinking an instance group.</p>
        pub fn instances_to_terminate(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instances_to_terminate.unwrap_or_default();
            v.push(input.into());
            self.instances_to_terminate = Some(v);
            self
        }
        /// <p>Specific list of instances to be terminated when shrinking an instance group.</p>
        pub fn set_instances_to_terminate(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instances_to_terminate = input;
            self
        }
        /// Appends an item to `instances_to_protect`.
        ///
        /// To override the contents of this collection use [`set_instances_to_protect`](Self::set_instances_to_protect).
        ///
        /// <p>Specific list of instances to be protected when shrinking an instance group.</p>
        pub fn instances_to_protect(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instances_to_protect.unwrap_or_default();
            v.push(input.into());
            self.instances_to_protect = Some(v);
            self
        }
        /// <p>Specific list of instances to be protected when shrinking an instance group.</p>
        pub fn set_instances_to_protect(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instances_to_protect = input;
            self
        }
        /// <p>Decommissioning timeout override for the specific list of instances to be
        /// terminated.</p>
        pub fn instance_termination_timeout(mut self, input: i32) -> Self {
            self.instance_termination_timeout = Some(input);
            self
        }
        /// <p>Decommissioning timeout override for the specific list of instances to be
        /// terminated.</p>
        pub fn set_instance_termination_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_termination_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceResizePolicy`](crate::model::InstanceResizePolicy)
        pub fn build(self) -> crate::model::InstanceResizePolicy {
            crate::model::InstanceResizePolicy {
                instances_to_terminate: self.instances_to_terminate,
                instances_to_protect: self.instances_to_protect,
                instance_termination_timeout: self.instance_termination_timeout,
            }
        }
    }
}
impl InstanceResizePolicy {
    /// Creates a new builder-style object to manufacture [`InstanceResizePolicy`](crate::model::InstanceResizePolicy)
    pub fn builder() -> crate::model::instance_resize_policy::Builder {
        crate::model::instance_resize_policy::Builder::default()
    }
}

/// <p>Configuration parameters for an instance fleet modification request.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceFleetModifyConfig {
    /// <p>A unique identifier for the instance fleet.</p>
    pub instance_fleet_id: std::option::Option<std::string::String>,
    /// <p>The target capacity of On-Demand units for the instance fleet. For more information see
    /// <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.</p>
    pub target_on_demand_capacity: std::option::Option<i32>,
    /// <p>The target capacity of Spot units for the instance fleet. For more information, see
    /// <a>InstanceFleetConfig$TargetSpotCapacity</a>.</p>
    pub target_spot_capacity: std::option::Option<i32>,
}
impl std::fmt::Debug for InstanceFleetModifyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceFleetModifyConfig");
        formatter.field("instance_fleet_id", &self.instance_fleet_id);
        formatter.field("target_on_demand_capacity", &self.target_on_demand_capacity);
        formatter.field("target_spot_capacity", &self.target_spot_capacity);
        formatter.finish()
    }
}
/// See [`InstanceFleetModifyConfig`](crate::model::InstanceFleetModifyConfig)
pub mod instance_fleet_modify_config {
    /// A builder for [`InstanceFleetModifyConfig`](crate::model::InstanceFleetModifyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_fleet_id: std::option::Option<std::string::String>,
        pub(crate) target_on_demand_capacity: std::option::Option<i32>,
        pub(crate) target_spot_capacity: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A unique identifier for the instance fleet.</p>
        pub fn instance_fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the instance fleet.</p>
        pub fn set_instance_fleet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_fleet_id = input;
            self
        }
        /// <p>The target capacity of On-Demand units for the instance fleet. For more information see
        /// <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.</p>
        pub fn target_on_demand_capacity(mut self, input: i32) -> Self {
            self.target_on_demand_capacity = Some(input);
            self
        }
        /// <p>The target capacity of On-Demand units for the instance fleet. For more information see
        /// <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.</p>
        pub fn set_target_on_demand_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.target_on_demand_capacity = input;
            self
        }
        /// <p>The target capacity of Spot units for the instance fleet. For more information, see
        /// <a>InstanceFleetConfig$TargetSpotCapacity</a>.</p>
        pub fn target_spot_capacity(mut self, input: i32) -> Self {
            self.target_spot_capacity = Some(input);
            self
        }
        /// <p>The target capacity of Spot units for the instance fleet. For more information, see
        /// <a>InstanceFleetConfig$TargetSpotCapacity</a>.</p>
        pub fn set_target_spot_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.target_spot_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceFleetModifyConfig`](crate::model::InstanceFleetModifyConfig)
        pub fn build(self) -> crate::model::InstanceFleetModifyConfig {
            crate::model::InstanceFleetModifyConfig {
                instance_fleet_id: self.instance_fleet_id,
                target_on_demand_capacity: self.target_on_demand_capacity,
                target_spot_capacity: self.target_spot_capacity,
            }
        }
    }
}
impl InstanceFleetModifyConfig {
    /// Creates a new builder-style object to manufacture [`InstanceFleetModifyConfig`](crate::model::InstanceFleetModifyConfig)
    pub fn builder() -> crate::model::instance_fleet_modify_config::Builder {
        crate::model::instance_fleet_modify_config::Builder::default()
    }
}

/// <p>Details for an Amazon EMR Studio session mapping. The details do not include the time
/// the session mapping was last modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionMappingSummary {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
    /// Store.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API
    /// Reference</i>.</p>
    pub identity_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The Amazon Resource Name (ARN) of the session policy associated with the user or
    /// group.</p>
    pub session_policy_arn: std::option::Option<std::string::String>,
    /// <p>The time the session mapping was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SessionMappingSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionMappingSummary");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_name", &self.identity_name);
        formatter.field("identity_type", &self.identity_type);
        formatter.field("session_policy_arn", &self.session_policy_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`SessionMappingSummary`](crate::model::SessionMappingSummary)
pub mod session_mapping_summary {
    /// A builder for [`SessionMappingSummary`](crate::model::SessionMappingSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_name: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) session_policy_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
        /// Store.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
        /// Store.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API
        /// Reference</i>.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_name = Some(input.into());
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API
        /// Reference</i>.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_name = input;
            self
        }
        /// <p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy associated with the user or
        /// group.</p>
        pub fn session_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy associated with the user or
        /// group.</p>
        pub fn set_session_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_policy_arn = input;
            self
        }
        /// <p>The time the session mapping was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the session mapping was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionMappingSummary`](crate::model::SessionMappingSummary)
        pub fn build(self) -> crate::model::SessionMappingSummary {
            crate::model::SessionMappingSummary {
                studio_id: self.studio_id,
                identity_id: self.identity_id,
                identity_name: self.identity_name,
                identity_type: self.identity_type,
                session_policy_arn: self.session_policy_arn,
                creation_time: self.creation_time,
            }
        }
    }
}
impl SessionMappingSummary {
    /// Creates a new builder-style object to manufacture [`SessionMappingSummary`](crate::model::SessionMappingSummary)
    pub fn builder() -> crate::model::session_mapping_summary::Builder {
        crate::model::session_mapping_summary::Builder::default()
    }
}

/// <p>Details for an Amazon EMR Studio, including ID, Name, VPC, and Description. The details
/// do not include subnets, IAM roles, security groups, or tags associated with the
/// Studio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StudioSummary {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon EMR Studio.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR
    /// Studio.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The detailed description of the Amazon EMR Studio.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique access URL of the Amazon EMR Studio.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
    pub auth_mode: std::option::Option<crate::model::AuthMode>,
    /// <p>The time when the Amazon EMR Studio was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for StudioSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StudioSummary");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("name", &self.name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("description", &self.description);
        formatter.field("url", &self.url);
        formatter.field("auth_mode", &self.auth_mode);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`StudioSummary`](crate::model::StudioSummary)
pub mod studio_summary {
    /// A builder for [`StudioSummary`](crate::model::StudioSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) auth_mode: std::option::Option<crate::model::AuthMode>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The name of the Amazon EMR Studio.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EMR Studio.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR
        /// Studio.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR
        /// Studio.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The detailed description of the Amazon EMR Studio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The detailed description of the Amazon EMR Studio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique access URL of the Amazon EMR Studio.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The unique access URL of the Amazon EMR Studio.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.auth_mode = Some(input);
            self
        }
        /// <p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn set_auth_mode(mut self, input: std::option::Option<crate::model::AuthMode>) -> Self {
            self.auth_mode = input;
            self
        }
        /// <p>The time when the Amazon EMR Studio was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the Amazon EMR Studio was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StudioSummary`](crate::model::StudioSummary)
        pub fn build(self) -> crate::model::StudioSummary {
            crate::model::StudioSummary {
                studio_id: self.studio_id,
                name: self.name,
                vpc_id: self.vpc_id,
                description: self.description,
                url: self.url,
                auth_mode: self.auth_mode,
                creation_time: self.creation_time,
            }
        }
    }
}
impl StudioSummary {
    /// Creates a new builder-style object to manufacture [`StudioSummary`](crate::model::StudioSummary)
    pub fn builder() -> crate::model::studio_summary::Builder {
        crate::model::studio_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthMode {
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    #[allow(missing_docs)] // documentation missing in model
    Sso,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthMode {
    fn from(s: &str) -> Self {
        match s {
            "IAM" => AuthMode::Iam,
            "SSO" => AuthMode::Sso,
            other => AuthMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthMode::from(s))
    }
}
impl AuthMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthMode::Iam => "IAM",
            AuthMode::Sso => "SSO",
            AuthMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IAM", "SSO"]
    }
}
impl AsRef<str> for AuthMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary of the cluster step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepSummary {
    /// <p>The identifier of the cluster step.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the cluster step.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Hadoop job configuration of the cluster step.</p>
    pub config: std::option::Option<crate::model::HadoopStepConfig>,
    /// <p>The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
    /// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is available for backward compatibility.</p>
    pub action_on_failure: std::option::Option<crate::model::ActionOnFailure>,
    /// <p>The current execution status details of the cluster step.</p>
    pub status: std::option::Option<crate::model::StepStatus>,
}
impl std::fmt::Debug for StepSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("config", &self.config);
        formatter.field("action_on_failure", &self.action_on_failure);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StepSummary`](crate::model::StepSummary)
pub mod step_summary {
    /// A builder for [`StepSummary`](crate::model::StepSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) config: std::option::Option<crate::model::HadoopStepConfig>,
        pub(crate) action_on_failure: std::option::Option<crate::model::ActionOnFailure>,
        pub(crate) status: std::option::Option<crate::model::StepStatus>,
    }
    impl Builder {
        /// <p>The identifier of the cluster step.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster step.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the cluster step.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster step.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Hadoop job configuration of the cluster step.</p>
        pub fn config(mut self, input: crate::model::HadoopStepConfig) -> Self {
            self.config = Some(input);
            self
        }
        /// <p>The Hadoop job configuration of the cluster step.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::HadoopStepConfig>,
        ) -> Self {
            self.config = input;
            self
        }
        /// <p>The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
        /// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is available for backward compatibility.</p>
        pub fn action_on_failure(mut self, input: crate::model::ActionOnFailure) -> Self {
            self.action_on_failure = Some(input);
            self
        }
        /// <p>The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
        /// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is available for backward compatibility.</p>
        pub fn set_action_on_failure(
            mut self,
            input: std::option::Option<crate::model::ActionOnFailure>,
        ) -> Self {
            self.action_on_failure = input;
            self
        }
        /// <p>The current execution status details of the cluster step.</p>
        pub fn status(mut self, input: crate::model::StepStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current execution status details of the cluster step.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StepStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StepSummary`](crate::model::StepSummary)
        pub fn build(self) -> crate::model::StepSummary {
            crate::model::StepSummary {
                id: self.id,
                name: self.name,
                config: self.config,
                action_on_failure: self.action_on_failure,
                status: self.status,
            }
        }
    }
}
impl StepSummary {
    /// Creates a new builder-style object to manufacture [`StepSummary`](crate::model::StepSummary)
    pub fn builder() -> crate::model::step_summary::Builder {
        crate::model::step_summary::Builder::default()
    }
}

/// <p>The execution status details of the cluster step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepStatus {
    /// <p>The execution state of the cluster step.</p>
    pub state: std::option::Option<crate::model::StepState>,
    /// <p>The reason for the step execution status change.</p>
    pub state_change_reason: std::option::Option<crate::model::StepStateChangeReason>,
    /// <p>The details for the step failure including reason, message, and log file path where the
    /// root cause was identified.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
    /// <p>The timeline of the cluster step status over time.</p>
    pub timeline: std::option::Option<crate::model::StepTimeline>,
}
impl std::fmt::Debug for StepStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepStatus");
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("timeline", &self.timeline);
        formatter.finish()
    }
}
/// See [`StepStatus`](crate::model::StepStatus)
pub mod step_status {
    /// A builder for [`StepStatus`](crate::model::StepStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::StepState>,
        pub(crate) state_change_reason: std::option::Option<crate::model::StepStateChangeReason>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
        pub(crate) timeline: std::option::Option<crate::model::StepTimeline>,
    }
    impl Builder {
        /// <p>The execution state of the cluster step.</p>
        pub fn state(mut self, input: crate::model::StepState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The execution state of the cluster step.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StepState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the step execution status change.</p>
        pub fn state_change_reason(mut self, input: crate::model::StepStateChangeReason) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>The reason for the step execution status change.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::StepStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// <p>The details for the step failure including reason, message, and log file path where the
        /// root cause was identified.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>The details for the step failure including reason, message, and log file path where the
        /// root cause was identified.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>The timeline of the cluster step status over time.</p>
        pub fn timeline(mut self, input: crate::model::StepTimeline) -> Self {
            self.timeline = Some(input);
            self
        }
        /// <p>The timeline of the cluster step status over time.</p>
        pub fn set_timeline(
            mut self,
            input: std::option::Option<crate::model::StepTimeline>,
        ) -> Self {
            self.timeline = input;
            self
        }
        /// Consumes the builder and constructs a [`StepStatus`](crate::model::StepStatus)
        pub fn build(self) -> crate::model::StepStatus {
            crate::model::StepStatus {
                state: self.state,
                state_change_reason: self.state_change_reason,
                failure_details: self.failure_details,
                timeline: self.timeline,
            }
        }
    }
}
impl StepStatus {
    /// Creates a new builder-style object to manufacture [`StepStatus`](crate::model::StepStatus)
    pub fn builder() -> crate::model::step_status::Builder {
        crate::model::step_status::Builder::default()
    }
}

/// <p>The timeline of the cluster step lifecycle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepTimeline {
    /// <p>The date and time when the cluster step was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the cluster step execution started.</p>
    pub start_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the cluster step execution completed or failed.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for StepTimeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepTimeline");
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.finish()
    }
}
/// See [`StepTimeline`](crate::model::StepTimeline)
pub mod step_timeline {
    /// A builder for [`StepTimeline`](crate::model::StepTimeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The date and time when the cluster step was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the cluster step was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the cluster step execution started.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date_time = Some(input);
            self
        }
        /// <p>The date and time when the cluster step execution started.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>The date and time when the cluster step execution completed or failed.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The date and time when the cluster step execution completed or failed.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StepTimeline`](crate::model::StepTimeline)
        pub fn build(self) -> crate::model::StepTimeline {
            crate::model::StepTimeline {
                creation_date_time: self.creation_date_time,
                start_date_time: self.start_date_time,
                end_date_time: self.end_date_time,
            }
        }
    }
}
impl StepTimeline {
    /// Creates a new builder-style object to manufacture [`StepTimeline`](crate::model::StepTimeline)
    pub fn builder() -> crate::model::step_timeline::Builder {
        crate::model::step_timeline::Builder::default()
    }
}

/// <p>The details of the step failure. The service attempts to detect the root cause for many
/// common failures.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureDetails {
    /// <p>The reason for the step failure. In the case where the service cannot successfully
    /// determine the root cause of the failure, it returns "Unknown Error" as a reason.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The descriptive message including the error the Amazon EMR service has identified as the
    /// cause of step failure. This is text from an error log that describes the root cause of the
    /// failure.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The path to the log file where the step failure root cause was originally
    /// recorded.</p>
    pub log_file: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureDetails");
        formatter.field("reason", &self.reason);
        formatter.field("message", &self.message);
        formatter.field("log_file", &self.log_file);
        formatter.finish()
    }
}
/// See [`FailureDetails`](crate::model::FailureDetails)
pub mod failure_details {
    /// A builder for [`FailureDetails`](crate::model::FailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) log_file: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reason for the step failure. In the case where the service cannot successfully
        /// determine the root cause of the failure, it returns "Unknown Error" as a reason.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the step failure. In the case where the service cannot successfully
        /// determine the root cause of the failure, it returns "Unknown Error" as a reason.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The descriptive message including the error the Amazon EMR service has identified as the
        /// cause of step failure. This is text from an error log that describes the root cause of the
        /// failure.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message including the error the Amazon EMR service has identified as the
        /// cause of step failure. This is text from an error log that describes the root cause of the
        /// failure.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The path to the log file where the step failure root cause was originally
        /// recorded.</p>
        pub fn log_file(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_file = Some(input.into());
            self
        }
        /// <p>The path to the log file where the step failure root cause was originally
        /// recorded.</p>
        pub fn set_log_file(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_file = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureDetails`](crate::model::FailureDetails)
        pub fn build(self) -> crate::model::FailureDetails {
            crate::model::FailureDetails {
                reason: self.reason,
                message: self.message,
                log_file: self.log_file,
            }
        }
    }
}
impl FailureDetails {
    /// Creates a new builder-style object to manufacture [`FailureDetails`](crate::model::FailureDetails)
    pub fn builder() -> crate::model::failure_details::Builder {
        crate::model::failure_details::Builder::default()
    }
}

/// <p>The details of the step state change reason.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepStateChangeReason {
    /// <p>The programmable code for the state change reason. Note: Currently, the service provides
    /// no code for the state change.</p>
    pub code: std::option::Option<crate::model::StepStateChangeReasonCode>,
    /// <p>The descriptive message for the state change reason.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StepStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`StepStateChangeReason`](crate::model::StepStateChangeReason)
pub mod step_state_change_reason {
    /// A builder for [`StepStateChangeReason`](crate::model::StepStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::StepStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The programmable code for the state change reason. Note: Currently, the service provides
        /// no code for the state change.</p>
        pub fn code(mut self, input: crate::model::StepStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The programmable code for the state change reason. Note: Currently, the service provides
        /// no code for the state change.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::StepStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The descriptive message for the state change reason.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the state change reason.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StepStateChangeReason`](crate::model::StepStateChangeReason)
        pub fn build(self) -> crate::model::StepStateChangeReason {
            crate::model::StepStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl StepStateChangeReason {
    /// Creates a new builder-style object to manufacture [`StepStateChangeReason`](crate::model::StepStateChangeReason)
    pub fn builder() -> crate::model::step_state_change_reason::Builder {
        crate::model::step_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StepStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StepStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => StepStateChangeReasonCode::None,
            other => StepStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StepStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StepStateChangeReasonCode::from(s))
    }
}
impl StepStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StepStateChangeReasonCode::None => "NONE",
            StepStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE"]
    }
}
impl AsRef<str> for StepStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StepState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    CancelPending,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Interrupted,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StepState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => StepState::Cancelled,
            "CANCEL_PENDING" => StepState::CancelPending,
            "COMPLETED" => StepState::Completed,
            "FAILED" => StepState::Failed,
            "INTERRUPTED" => StepState::Interrupted,
            "PENDING" => StepState::Pending,
            "RUNNING" => StepState::Running,
            other => StepState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StepState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StepState::from(s))
    }
}
impl StepState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StepState::Cancelled => "CANCELLED",
            StepState::CancelPending => "CANCEL_PENDING",
            StepState::Completed => "COMPLETED",
            StepState::Failed => "FAILED",
            StepState::Interrupted => "INTERRUPTED",
            StepState::Pending => "PENDING",
            StepState::Running => "RUNNING",
            StepState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "CANCEL_PENDING",
            "COMPLETED",
            "FAILED",
            "INTERRUPTED",
            "PENDING",
            "RUNNING",
        ]
    }
}
impl AsRef<str> for StepState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A cluster step consisting of a JAR file whose main function will be executed. The main
/// function submits a job for Hadoop to execute and waits for the job to finish or
/// fail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HadoopStepConfig {
    /// <p>The path to the JAR file that runs during the step.</p>
    pub jar: std::option::Option<std::string::String>,
    /// <p>The list of Java properties that are set when the step runs. You can use these
    /// properties to pass key-value pairs to your main function.</p>
    pub properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the main class in the specified Java file. If not specified, the JAR file
    /// should specify a main class in its manifest file.</p>
    pub main_class: std::option::Option<std::string::String>,
    /// <p>The list of command line arguments to pass to the JAR file's main function for
    /// execution.</p>
    pub args: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for HadoopStepConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HadoopStepConfig");
        formatter.field("jar", &self.jar);
        formatter.field("properties", &self.properties);
        formatter.field("main_class", &self.main_class);
        formatter.field("args", &self.args);
        formatter.finish()
    }
}
/// See [`HadoopStepConfig`](crate::model::HadoopStepConfig)
pub mod hadoop_step_config {
    /// A builder for [`HadoopStepConfig`](crate::model::HadoopStepConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jar: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) main_class: std::option::Option<std::string::String>,
        pub(crate) args: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The path to the JAR file that runs during the step.</p>
        pub fn jar(mut self, input: impl Into<std::string::String>) -> Self {
            self.jar = Some(input.into());
            self
        }
        /// <p>The path to the JAR file that runs during the step.</p>
        pub fn set_jar(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.jar = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The list of Java properties that are set when the step runs. You can use these
        /// properties to pass key-value pairs to your main function.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.properties = Some(hash_map);
            self
        }
        /// <p>The list of Java properties that are set when the step runs. You can use these
        /// properties to pass key-value pairs to your main function.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>The name of the main class in the specified Java file. If not specified, the JAR file
        /// should specify a main class in its manifest file.</p>
        pub fn main_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.main_class = Some(input.into());
            self
        }
        /// <p>The name of the main class in the specified Java file. If not specified, the JAR file
        /// should specify a main class in its manifest file.</p>
        pub fn set_main_class(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.main_class = input;
            self
        }
        /// Appends an item to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>The list of command line arguments to pass to the JAR file's main function for
        /// execution.</p>
        pub fn args(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.args.unwrap_or_default();
            v.push(input.into());
            self.args = Some(v);
            self
        }
        /// <p>The list of command line arguments to pass to the JAR file's main function for
        /// execution.</p>
        pub fn set_args(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.args = input;
            self
        }
        /// Consumes the builder and constructs a [`HadoopStepConfig`](crate::model::HadoopStepConfig)
        pub fn build(self) -> crate::model::HadoopStepConfig {
            crate::model::HadoopStepConfig {
                jar: self.jar,
                properties: self.properties,
                main_class: self.main_class,
                args: self.args,
            }
        }
    }
}
impl HadoopStepConfig {
    /// Creates a new builder-style object to manufacture [`HadoopStepConfig`](crate::model::HadoopStepConfig)
    pub fn builder() -> crate::model::hadoop_step_config::Builder {
        crate::model::hadoop_step_config::Builder::default()
    }
}

/// <p>The creation date and time, and name, of a security configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityConfigurationSummary {
    /// <p>The name of the security configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date and time the security configuration was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SecurityConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityConfigurationSummary");
        formatter.field("name", &self.name);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`SecurityConfigurationSummary`](crate::model::SecurityConfigurationSummary)
pub mod security_configuration_summary {
    /// A builder for [`SecurityConfigurationSummary`](crate::model::SecurityConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date and time the security configuration was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time the security configuration was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityConfigurationSummary`](crate::model::SecurityConfigurationSummary)
        pub fn build(self) -> crate::model::SecurityConfigurationSummary {
            crate::model::SecurityConfigurationSummary {
                name: self.name,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl SecurityConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`SecurityConfigurationSummary`](crate::model::SecurityConfigurationSummary)
    pub fn builder() -> crate::model::security_configuration_summary::Builder {
        crate::model::security_configuration_summary::Builder::default()
    }
}

/// <p>The release label filters by application or version prefix.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReleaseLabelFilter {
    /// <p>Optional release label version prefix filter. For example, <code>emr-5</code>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Optional release label application filter. For example, <code>spark@2.1.0</code>.</p>
    pub application: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReleaseLabelFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReleaseLabelFilter");
        formatter.field("prefix", &self.prefix);
        formatter.field("application", &self.application);
        formatter.finish()
    }
}
/// See [`ReleaseLabelFilter`](crate::model::ReleaseLabelFilter)
pub mod release_label_filter {
    /// A builder for [`ReleaseLabelFilter`](crate::model::ReleaseLabelFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) application: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Optional release label version prefix filter. For example, <code>emr-5</code>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Optional release label version prefix filter. For example, <code>emr-5</code>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Optional release label application filter. For example, <code>spark@2.1.0</code>.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>Optional release label application filter. For example, <code>spark@2.1.0</code>.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// Consumes the builder and constructs a [`ReleaseLabelFilter`](crate::model::ReleaseLabelFilter)
        pub fn build(self) -> crate::model::ReleaseLabelFilter {
            crate::model::ReleaseLabelFilter {
                prefix: self.prefix,
                application: self.application,
            }
        }
    }
}
impl ReleaseLabelFilter {
    /// Creates a new builder-style object to manufacture [`ReleaseLabelFilter`](crate::model::ReleaseLabelFilter)
    pub fn builder() -> crate::model::release_label_filter::Builder {
        crate::model::release_label_filter::Builder::default()
    }
}

/// <p>Details for a notebook execution. The details include information such as the unique ID and status of the notebook execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotebookExecutionSummary {
    /// <p>The unique identifier of the notebook execution.</p>
    pub notebook_execution_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the editor associated with the notebook execution.</p>
    pub editor_id: std::option::Option<std::string::String>,
    /// <p>The name of the notebook execution.</p>
    pub notebook_execution_name: std::option::Option<std::string::String>,
    /// <p>The status of the notebook execution.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>START_PENDING</code> indicates that the cluster has received the execution
    /// request but execution has not begun.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STARTING</code> indicates that the execution is starting on the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RUNNING</code> indicates that the execution is being processed by the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHING</code> indicates that execution processing is in the final
    /// stages.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHED</code> indicates that the execution has completed without
    /// error.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILING</code> indicates that the execution is failing and will not finish
    /// successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> indicates that the execution failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOP_PENDING</code> indicates that the cluster has received a
    /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
    /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> indicates that the execution stopped because of a
    /// <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::NotebookExecutionStatus>,
    /// <p>The timestamp when notebook execution started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when notebook execution started.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for NotebookExecutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotebookExecutionSummary");
        formatter.field("notebook_execution_id", &self.notebook_execution_id);
        formatter.field("editor_id", &self.editor_id);
        formatter.field("notebook_execution_name", &self.notebook_execution_name);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`NotebookExecutionSummary`](crate::model::NotebookExecutionSummary)
pub mod notebook_execution_summary {
    /// A builder for [`NotebookExecutionSummary`](crate::model::NotebookExecutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_execution_id: std::option::Option<std::string::String>,
        pub(crate) editor_id: std::option::Option<std::string::String>,
        pub(crate) notebook_execution_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NotebookExecutionStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn notebook_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_execution_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the notebook execution.</p>
        pub fn set_notebook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_execution_id = input;
            self
        }
        /// <p>The unique identifier of the editor associated with the notebook execution.</p>
        pub fn editor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.editor_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the editor associated with the notebook execution.</p>
        pub fn set_editor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.editor_id = input;
            self
        }
        /// <p>The name of the notebook execution.</p>
        pub fn notebook_execution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_execution_name = Some(input.into());
            self
        }
        /// <p>The name of the notebook execution.</p>
        pub fn set_notebook_execution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_execution_name = input;
            self
        }
        /// <p>The status of the notebook execution.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START_PENDING</code> indicates that the cluster has received the execution
        /// request but execution has not begun.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STARTING</code> indicates that the execution is starting on the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> indicates that the execution is being processed by the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHING</code> indicates that execution processing is in the final
        /// stages.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHED</code> indicates that the execution has completed without
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILING</code> indicates that the execution is failing and will not finish
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> indicates that the execution failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_PENDING</code> indicates that the cluster has received a
        /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
        /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> indicates that the execution stopped because of a
        /// <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::NotebookExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the notebook execution.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START_PENDING</code> indicates that the cluster has received the execution
        /// request but execution has not begun.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STARTING</code> indicates that the execution is starting on the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> indicates that the execution is being processed by the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHING</code> indicates that execution processing is in the final
        /// stages.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHED</code> indicates that the execution has completed without
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILING</code> indicates that the execution is failing and will not finish
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> indicates that the execution failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_PENDING</code> indicates that the cluster has received a
        /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
        /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> indicates that the execution stopped because of a
        /// <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotebookExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp when notebook execution started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp when notebook execution started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp when notebook execution started.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The timestamp when notebook execution started.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`NotebookExecutionSummary`](crate::model::NotebookExecutionSummary)
        pub fn build(self) -> crate::model::NotebookExecutionSummary {
            crate::model::NotebookExecutionSummary {
                notebook_execution_id: self.notebook_execution_id,
                editor_id: self.editor_id,
                notebook_execution_name: self.notebook_execution_name,
                status: self.status,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl NotebookExecutionSummary {
    /// Creates a new builder-style object to manufacture [`NotebookExecutionSummary`](crate::model::NotebookExecutionSummary)
    pub fn builder() -> crate::model::notebook_execution_summary::Builder {
        crate::model::notebook_execution_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotebookExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Failing,
    #[allow(missing_docs)] // documentation missing in model
    Finished,
    #[allow(missing_docs)] // documentation missing in model
    Finishing,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    StartPending,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    StopPending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotebookExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => NotebookExecutionStatus::Failed,
            "FAILING" => NotebookExecutionStatus::Failing,
            "FINISHED" => NotebookExecutionStatus::Finished,
            "FINISHING" => NotebookExecutionStatus::Finishing,
            "RUNNING" => NotebookExecutionStatus::Running,
            "STARTING" => NotebookExecutionStatus::Starting,
            "START_PENDING" => NotebookExecutionStatus::StartPending,
            "STOPPED" => NotebookExecutionStatus::Stopped,
            "STOPPING" => NotebookExecutionStatus::Stopping,
            "STOP_PENDING" => NotebookExecutionStatus::StopPending,
            other => NotebookExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotebookExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotebookExecutionStatus::from(s))
    }
}
impl NotebookExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotebookExecutionStatus::Failed => "FAILED",
            NotebookExecutionStatus::Failing => "FAILING",
            NotebookExecutionStatus::Finished => "FINISHED",
            NotebookExecutionStatus::Finishing => "FINISHING",
            NotebookExecutionStatus::Running => "RUNNING",
            NotebookExecutionStatus::Starting => "STARTING",
            NotebookExecutionStatus::StartPending => "START_PENDING",
            NotebookExecutionStatus::Stopped => "STOPPED",
            NotebookExecutionStatus::Stopping => "STOPPING",
            NotebookExecutionStatus::StopPending => "STOP_PENDING",
            NotebookExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "FAILING",
            "FINISHED",
            "FINISHING",
            "RUNNING",
            "STARTING",
            "START_PENDING",
            "STOPPED",
            "STOPPING",
            "STOP_PENDING",
        ]
    }
}
impl AsRef<str> for NotebookExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents an EC2 instance provisioned as part of cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The unique identifier for the instance in Amazon EMR.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the instance in Amazon EC2.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>The public DNS name of the instance.</p>
    pub public_dns_name: std::option::Option<std::string::String>,
    /// <p>The public IP address of the instance.</p>
    pub public_ip_address: std::option::Option<std::string::String>,
    /// <p>The private DNS name of the instance.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The private IP address of the instance.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The current status of the instance.</p>
    pub status: std::option::Option<crate::model::InstanceStatus>,
    /// <p>The identifier of the instance group to which this instance belongs.</p>
    pub instance_group_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the instance fleet to which an EC2 instance belongs.</p>
    pub instance_fleet_id: std::option::Option<std::string::String>,
    /// <p>The instance purchasing option. Valid values are <code>ON_DEMAND</code> or
    /// <code>SPOT</code>. </p>
    pub market: std::option::Option<crate::model::MarketType>,
    /// <p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The list of Amazon EBS volumes that are attached to this instance.</p>
    pub ebs_volumes: std::option::Option<std::vec::Vec<crate::model::EbsVolume>>,
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("id", &self.id);
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("public_dns_name", &self.public_dns_name);
        formatter.field("public_ip_address", &self.public_ip_address);
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("status", &self.status);
        formatter.field("instance_group_id", &self.instance_group_id);
        formatter.field("instance_fleet_id", &self.instance_fleet_id);
        formatter.field("market", &self.market);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("ebs_volumes", &self.ebs_volumes);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) public_dns_name: std::option::Option<std::string::String>,
        pub(crate) public_ip_address: std::option::Option<std::string::String>,
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::InstanceStatus>,
        pub(crate) instance_group_id: std::option::Option<std::string::String>,
        pub(crate) instance_fleet_id: std::option::Option<std::string::String>,
        pub(crate) market: std::option::Option<crate::model::MarketType>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) ebs_volumes: std::option::Option<std::vec::Vec<crate::model::EbsVolume>>,
    }
    impl Builder {
        /// <p>The unique identifier for the instance in Amazon EMR.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the instance in Amazon EMR.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The unique identifier of the instance in Amazon EC2.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the instance in Amazon EC2.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>The public DNS name of the instance.</p>
        pub fn public_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_dns_name = Some(input.into());
            self
        }
        /// <p>The public DNS name of the instance.</p>
        pub fn set_public_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_dns_name = input;
            self
        }
        /// <p>The public IP address of the instance.</p>
        pub fn public_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip_address = Some(input.into());
            self
        }
        /// <p>The public IP address of the instance.</p>
        pub fn set_public_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_ip_address = input;
            self
        }
        /// <p>The private DNS name of the instance.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The private DNS name of the instance.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The private IP address of the instance.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address of the instance.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// <p>The current status of the instance.</p>
        pub fn status(mut self, input: crate::model::InstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the instance.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The identifier of the instance group to which this instance belongs.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the instance group to which this instance belongs.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_group_id = input;
            self
        }
        /// <p>The unique identifier of the instance fleet to which an EC2 instance belongs.</p>
        pub fn instance_fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_fleet_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the instance fleet to which an EC2 instance belongs.</p>
        pub fn set_instance_fleet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_fleet_id = input;
            self
        }
        /// <p>The instance purchasing option. Valid values are <code>ON_DEMAND</code> or
        /// <code>SPOT</code>. </p>
        pub fn market(mut self, input: crate::model::MarketType) -> Self {
            self.market = Some(input);
            self
        }
        /// <p>The instance purchasing option. Valid values are <code>ON_DEMAND</code> or
        /// <code>SPOT</code>. </p>
        pub fn set_market(mut self, input: std::option::Option<crate::model::MarketType>) -> Self {
            self.market = input;
            self
        }
        /// <p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// Appends an item to `ebs_volumes`.
        ///
        /// To override the contents of this collection use [`set_ebs_volumes`](Self::set_ebs_volumes).
        ///
        /// <p>The list of Amazon EBS volumes that are attached to this instance.</p>
        pub fn ebs_volumes(mut self, input: impl Into<crate::model::EbsVolume>) -> Self {
            let mut v = self.ebs_volumes.unwrap_or_default();
            v.push(input.into());
            self.ebs_volumes = Some(v);
            self
        }
        /// <p>The list of Amazon EBS volumes that are attached to this instance.</p>
        pub fn set_ebs_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EbsVolume>>,
        ) -> Self {
            self.ebs_volumes = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                id: self.id,
                ec2_instance_id: self.ec2_instance_id,
                public_dns_name: self.public_dns_name,
                public_ip_address: self.public_ip_address,
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
                status: self.status,
                instance_group_id: self.instance_group_id,
                instance_fleet_id: self.instance_fleet_id,
                market: self.market,
                instance_type: self.instance_type,
                ebs_volumes: self.ebs_volumes,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>EBS block device that's attached to an EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsVolume {
    /// <p>The device name that is exposed to the instance, such as /dev/sdh.</p>
    pub device: std::option::Option<std::string::String>,
    /// <p>The volume identifier of the EBS volume.</p>
    pub volume_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EbsVolume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsVolume");
        formatter.field("device", &self.device);
        formatter.field("volume_id", &self.volume_id);
        formatter.finish()
    }
}
/// See [`EbsVolume`](crate::model::EbsVolume)
pub mod ebs_volume {
    /// A builder for [`EbsVolume`](crate::model::EbsVolume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device name that is exposed to the instance, such as /dev/sdh.</p>
        pub fn device(mut self, input: impl Into<std::string::String>) -> Self {
            self.device = Some(input.into());
            self
        }
        /// <p>The device name that is exposed to the instance, such as /dev/sdh.</p>
        pub fn set_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device = input;
            self
        }
        /// <p>The volume identifier of the EBS volume.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The volume identifier of the EBS volume.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsVolume`](crate::model::EbsVolume)
        pub fn build(self) -> crate::model::EbsVolume {
            crate::model::EbsVolume {
                device: self.device,
                volume_id: self.volume_id,
            }
        }
    }
}
impl EbsVolume {
    /// Creates a new builder-style object to manufacture [`EbsVolume`](crate::model::EbsVolume)
    pub fn builder() -> crate::model::ebs_volume::Builder {
        crate::model::ebs_volume::Builder::default()
    }
}

/// <p>The instance status details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceStatus {
    /// <p>The current state of the instance.</p>
    pub state: std::option::Option<crate::model::InstanceState>,
    /// <p>The details of the status change reason for the instance.</p>
    pub state_change_reason: std::option::Option<crate::model::InstanceStateChangeReason>,
    /// <p>The timeline of the instance status over time.</p>
    pub timeline: std::option::Option<crate::model::InstanceTimeline>,
}
impl std::fmt::Debug for InstanceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceStatus");
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("timeline", &self.timeline);
        formatter.finish()
    }
}
/// See [`InstanceStatus`](crate::model::InstanceStatus)
pub mod instance_status {
    /// A builder for [`InstanceStatus`](crate::model::InstanceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::InstanceState>,
        pub(crate) state_change_reason:
            std::option::Option<crate::model::InstanceStateChangeReason>,
        pub(crate) timeline: std::option::Option<crate::model::InstanceTimeline>,
    }
    impl Builder {
        /// <p>The current state of the instance.</p>
        pub fn state(mut self, input: crate::model::InstanceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the instance.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The details of the status change reason for the instance.</p>
        pub fn state_change_reason(
            mut self,
            input: crate::model::InstanceStateChangeReason,
        ) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>The details of the status change reason for the instance.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::InstanceStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// <p>The timeline of the instance status over time.</p>
        pub fn timeline(mut self, input: crate::model::InstanceTimeline) -> Self {
            self.timeline = Some(input);
            self
        }
        /// <p>The timeline of the instance status over time.</p>
        pub fn set_timeline(
            mut self,
            input: std::option::Option<crate::model::InstanceTimeline>,
        ) -> Self {
            self.timeline = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceStatus`](crate::model::InstanceStatus)
        pub fn build(self) -> crate::model::InstanceStatus {
            crate::model::InstanceStatus {
                state: self.state,
                state_change_reason: self.state_change_reason,
                timeline: self.timeline,
            }
        }
    }
}
impl InstanceStatus {
    /// Creates a new builder-style object to manufacture [`InstanceStatus`](crate::model::InstanceStatus)
    pub fn builder() -> crate::model::instance_status::Builder {
        crate::model::instance_status::Builder::default()
    }
}

/// <p>The timeline of the instance lifecycle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceTimeline {
    /// <p>The creation date and time of the instance.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the instance was ready to perform tasks.</p>
    pub ready_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the instance was terminated.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for InstanceTimeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceTimeline");
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("ready_date_time", &self.ready_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.finish()
    }
}
/// See [`InstanceTimeline`](crate::model::InstanceTimeline)
pub mod instance_timeline {
    /// A builder for [`InstanceTimeline`](crate::model::InstanceTimeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ready_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The creation date and time of the instance.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time of the instance.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the instance was ready to perform tasks.</p>
        pub fn ready_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ready_date_time = Some(input);
            self
        }
        /// <p>The date and time when the instance was ready to perform tasks.</p>
        pub fn set_ready_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ready_date_time = input;
            self
        }
        /// <p>The date and time when the instance was terminated.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The date and time when the instance was terminated.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceTimeline`](crate::model::InstanceTimeline)
        pub fn build(self) -> crate::model::InstanceTimeline {
            crate::model::InstanceTimeline {
                creation_date_time: self.creation_date_time,
                ready_date_time: self.ready_date_time,
                end_date_time: self.end_date_time,
            }
        }
    }
}
impl InstanceTimeline {
    /// Creates a new builder-style object to manufacture [`InstanceTimeline`](crate::model::InstanceTimeline)
    pub fn builder() -> crate::model::instance_timeline::Builder {
        crate::model::instance_timeline::Builder::default()
    }
}

/// <p>The details of the status change reason for the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceStateChangeReason {
    /// <p>The programmable code for the state change reason.</p>
    pub code: std::option::Option<crate::model::InstanceStateChangeReasonCode>,
    /// <p>The status change reason description.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`InstanceStateChangeReason`](crate::model::InstanceStateChangeReason)
pub mod instance_state_change_reason {
    /// A builder for [`InstanceStateChangeReason`](crate::model::InstanceStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::InstanceStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The programmable code for the state change reason.</p>
        pub fn code(mut self, input: crate::model::InstanceStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The programmable code for the state change reason.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::InstanceStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The status change reason description.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The status change reason description.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceStateChangeReason`](crate::model::InstanceStateChangeReason)
        pub fn build(self) -> crate::model::InstanceStateChangeReason {
            crate::model::InstanceStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InstanceStateChangeReason {
    /// Creates a new builder-style object to manufacture [`InstanceStateChangeReason`](crate::model::InstanceStateChangeReason)
    pub fn builder() -> crate::model::instance_state_change_reason::Builder {
        crate::model::instance_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    BootstrapFailure,
    #[allow(missing_docs)] // documentation missing in model
    ClusterTerminated,
    #[allow(missing_docs)] // documentation missing in model
    InstanceFailure,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "BOOTSTRAP_FAILURE" => InstanceStateChangeReasonCode::BootstrapFailure,
            "CLUSTER_TERMINATED" => InstanceStateChangeReasonCode::ClusterTerminated,
            "INSTANCE_FAILURE" => InstanceStateChangeReasonCode::InstanceFailure,
            "INTERNAL_ERROR" => InstanceStateChangeReasonCode::InternalError,
            "VALIDATION_ERROR" => InstanceStateChangeReasonCode::ValidationError,
            other => InstanceStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStateChangeReasonCode::from(s))
    }
}
impl InstanceStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStateChangeReasonCode::BootstrapFailure => "BOOTSTRAP_FAILURE",
            InstanceStateChangeReasonCode::ClusterTerminated => "CLUSTER_TERMINATED",
            InstanceStateChangeReasonCode::InstanceFailure => "INSTANCE_FAILURE",
            InstanceStateChangeReasonCode::InternalError => "INTERNAL_ERROR",
            InstanceStateChangeReasonCode::ValidationError => "VALIDATION_ERROR",
            InstanceStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOOTSTRAP_FAILURE",
            "CLUSTER_TERMINATED",
            "INSTANCE_FAILURE",
            "INTERNAL_ERROR",
            "VALIDATION_ERROR",
        ]
    }
}
impl AsRef<str> for InstanceStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceState {
    #[allow(missing_docs)] // documentation missing in model
    AwaitingFulfillment,
    #[allow(missing_docs)] // documentation missing in model
    Bootstrapping,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceState {
    fn from(s: &str) -> Self {
        match s {
            "AWAITING_FULFILLMENT" => InstanceState::AwaitingFulfillment,
            "BOOTSTRAPPING" => InstanceState::Bootstrapping,
            "PROVISIONING" => InstanceState::Provisioning,
            "RUNNING" => InstanceState::Running,
            "TERMINATED" => InstanceState::Terminated,
            other => InstanceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceState::from(s))
    }
}
impl InstanceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceState::AwaitingFulfillment => "AWAITING_FULFILLMENT",
            InstanceState::Bootstrapping => "BOOTSTRAPPING",
            InstanceState::Provisioning => "PROVISIONING",
            InstanceState::Running => "RUNNING",
            InstanceState::Terminated => "TERMINATED",
            InstanceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWAITING_FULFILLMENT",
            "BOOTSTRAPPING",
            "PROVISIONING",
            "RUNNING",
            "TERMINATED",
        ]
    }
}
impl AsRef<str> for InstanceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceGroupType {
    #[allow(missing_docs)] // documentation missing in model
    Core,
    #[allow(missing_docs)] // documentation missing in model
    Master,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceGroupType {
    fn from(s: &str) -> Self {
        match s {
            "CORE" => InstanceGroupType::Core,
            "MASTER" => InstanceGroupType::Master,
            "TASK" => InstanceGroupType::Task,
            other => InstanceGroupType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceGroupType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceGroupType::from(s))
    }
}
impl InstanceGroupType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceGroupType::Core => "CORE",
            InstanceGroupType::Master => "MASTER",
            InstanceGroupType::Task => "TASK",
            InstanceGroupType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CORE", "MASTER", "TASK"]
    }
}
impl AsRef<str> for InstanceGroupType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This entity represents an instance group, which is a group of instances that have common
/// purpose. For example, CORE instance group is used for HDFS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceGroup {
    /// <p>The identifier of the instance group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the instance group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The marketplace to provision instances for this group. Valid values are ON_DEMAND or
    /// SPOT.</p>
    pub market: std::option::Option<crate::model::MarketType>,
    /// <p>The type of the instance group. Valid values are MASTER, CORE or TASK.</p>
    pub instance_group_type: std::option::Option<crate::model::InstanceGroupType>,
    /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
    pub bid_price: std::option::Option<std::string::String>,
    /// <p>The EC2 instance type for all instances in the instance group.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The target number of instances for the instance group.</p>
    pub requested_instance_count: std::option::Option<i32>,
    /// <p>The number of instances currently running in this instance group.</p>
    pub running_instance_count: std::option::Option<i32>,
    /// <p>The current status of the instance group.</p>
    pub status: std::option::Option<crate::model::InstanceGroupStatus>,
    /// <note>
    /// <p>Amazon EMR releases 4.x or later.</p>
    /// </note>
    /// <p>The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a
    /// separate configuration for each instance group (master, core, and task).</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>The version number of the requested configuration specification for this instance
    /// group.</p>
    pub configurations_version: i64,
    /// <p>A list of configurations that were successfully applied for an instance group last
    /// time.</p>
    pub last_successfully_applied_configurations:
        std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>The version number of a configuration specification that was successfully applied for an
    /// instance group last time. </p>
    pub last_successfully_applied_configurations_version: i64,
    /// <p>The EBS block devices that are mapped to this instance group.</p>
    pub ebs_block_devices: std::option::Option<std::vec::Vec<crate::model::EbsBlockDevice>>,
    /// <p>If the instance group is EBS-optimized. An Amazon EBS-optimized instance uses an
    /// optimized configuration stack and provides additional, dedicated capacity for Amazon EBS
    /// I/O.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>Policy for customizing shrink operations.</p>
    pub shrink_policy: std::option::Option<crate::model::ShrinkPolicy>,
    /// <p>An automatic scaling policy for a core instance group or task instance group in an
    /// Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
    /// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
    /// PutAutoScalingPolicy.</p>
    pub auto_scaling_policy: std::option::Option<crate::model::AutoScalingPolicyDescription>,
    /// <p>The custom AMI ID to use for the provisioned instance group.</p>
    pub custom_ami_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceGroup");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("market", &self.market);
        formatter.field("instance_group_type", &self.instance_group_type);
        formatter.field("bid_price", &self.bid_price);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("requested_instance_count", &self.requested_instance_count);
        formatter.field("running_instance_count", &self.running_instance_count);
        formatter.field("status", &self.status);
        formatter.field("configurations", &self.configurations);
        formatter.field("configurations_version", &self.configurations_version);
        formatter.field(
            "last_successfully_applied_configurations",
            &self.last_successfully_applied_configurations,
        );
        formatter.field(
            "last_successfully_applied_configurations_version",
            &self.last_successfully_applied_configurations_version,
        );
        formatter.field("ebs_block_devices", &self.ebs_block_devices);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("shrink_policy", &self.shrink_policy);
        formatter.field("auto_scaling_policy", &self.auto_scaling_policy);
        formatter.field("custom_ami_id", &self.custom_ami_id);
        formatter.finish()
    }
}
/// See [`InstanceGroup`](crate::model::InstanceGroup)
pub mod instance_group {
    /// A builder for [`InstanceGroup`](crate::model::InstanceGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) market: std::option::Option<crate::model::MarketType>,
        pub(crate) instance_group_type: std::option::Option<crate::model::InstanceGroupType>,
        pub(crate) bid_price: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) requested_instance_count: std::option::Option<i32>,
        pub(crate) running_instance_count: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::InstanceGroupStatus>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) configurations_version: std::option::Option<i64>,
        pub(crate) last_successfully_applied_configurations:
            std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) last_successfully_applied_configurations_version: std::option::Option<i64>,
        pub(crate) ebs_block_devices:
            std::option::Option<std::vec::Vec<crate::model::EbsBlockDevice>>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) shrink_policy: std::option::Option<crate::model::ShrinkPolicy>,
        pub(crate) auto_scaling_policy:
            std::option::Option<crate::model::AutoScalingPolicyDescription>,
        pub(crate) custom_ami_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the instance group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the instance group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the instance group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the instance group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The marketplace to provision instances for this group. Valid values are ON_DEMAND or
        /// SPOT.</p>
        pub fn market(mut self, input: crate::model::MarketType) -> Self {
            self.market = Some(input);
            self
        }
        /// <p>The marketplace to provision instances for this group. Valid values are ON_DEMAND or
        /// SPOT.</p>
        pub fn set_market(mut self, input: std::option::Option<crate::model::MarketType>) -> Self {
            self.market = input;
            self
        }
        /// <p>The type of the instance group. Valid values are MASTER, CORE or TASK.</p>
        pub fn instance_group_type(mut self, input: crate::model::InstanceGroupType) -> Self {
            self.instance_group_type = Some(input);
            self
        }
        /// <p>The type of the instance group. Valid values are MASTER, CORE or TASK.</p>
        pub fn set_instance_group_type(
            mut self,
            input: std::option::Option<crate::model::InstanceGroupType>,
        ) -> Self {
            self.instance_group_type = input;
            self
        }
        /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
        pub fn bid_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.bid_price = Some(input.into());
            self
        }
        /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
        pub fn set_bid_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bid_price = input;
            self
        }
        /// <p>The EC2 instance type for all instances in the instance group.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 instance type for all instances in the instance group.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The target number of instances for the instance group.</p>
        pub fn requested_instance_count(mut self, input: i32) -> Self {
            self.requested_instance_count = Some(input);
            self
        }
        /// <p>The target number of instances for the instance group.</p>
        pub fn set_requested_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.requested_instance_count = input;
            self
        }
        /// <p>The number of instances currently running in this instance group.</p>
        pub fn running_instance_count(mut self, input: i32) -> Self {
            self.running_instance_count = Some(input);
            self
        }
        /// <p>The number of instances currently running in this instance group.</p>
        pub fn set_running_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.running_instance_count = input;
            self
        }
        /// <p>The current status of the instance group.</p>
        pub fn status(mut self, input: crate::model::InstanceGroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the instance group.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InstanceGroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <note>
        /// <p>Amazon EMR releases 4.x or later.</p>
        /// </note>
        /// <p>The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a
        /// separate configuration for each instance group (master, core, and task).</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <note>
        /// <p>Amazon EMR releases 4.x or later.</p>
        /// </note>
        /// <p>The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a
        /// separate configuration for each instance group (master, core, and task).</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>The version number of the requested configuration specification for this instance
        /// group.</p>
        pub fn configurations_version(mut self, input: i64) -> Self {
            self.configurations_version = Some(input);
            self
        }
        /// <p>The version number of the requested configuration specification for this instance
        /// group.</p>
        pub fn set_configurations_version(mut self, input: std::option::Option<i64>) -> Self {
            self.configurations_version = input;
            self
        }
        /// Appends an item to `last_successfully_applied_configurations`.
        ///
        /// To override the contents of this collection use [`set_last_successfully_applied_configurations`](Self::set_last_successfully_applied_configurations).
        ///
        /// <p>A list of configurations that were successfully applied for an instance group last
        /// time.</p>
        pub fn last_successfully_applied_configurations(
            mut self,
            input: impl Into<crate::model::Configuration>,
        ) -> Self {
            let mut v = self
                .last_successfully_applied_configurations
                .unwrap_or_default();
            v.push(input.into());
            self.last_successfully_applied_configurations = Some(v);
            self
        }
        /// <p>A list of configurations that were successfully applied for an instance group last
        /// time.</p>
        pub fn set_last_successfully_applied_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.last_successfully_applied_configurations = input;
            self
        }
        /// <p>The version number of a configuration specification that was successfully applied for an
        /// instance group last time. </p>
        pub fn last_successfully_applied_configurations_version(mut self, input: i64) -> Self {
            self.last_successfully_applied_configurations_version = Some(input);
            self
        }
        /// <p>The version number of a configuration specification that was successfully applied for an
        /// instance group last time. </p>
        pub fn set_last_successfully_applied_configurations_version(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.last_successfully_applied_configurations_version = input;
            self
        }
        /// Appends an item to `ebs_block_devices`.
        ///
        /// To override the contents of this collection use [`set_ebs_block_devices`](Self::set_ebs_block_devices).
        ///
        /// <p>The EBS block devices that are mapped to this instance group.</p>
        pub fn ebs_block_devices(mut self, input: impl Into<crate::model::EbsBlockDevice>) -> Self {
            let mut v = self.ebs_block_devices.unwrap_or_default();
            v.push(input.into());
            self.ebs_block_devices = Some(v);
            self
        }
        /// <p>The EBS block devices that are mapped to this instance group.</p>
        pub fn set_ebs_block_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EbsBlockDevice>>,
        ) -> Self {
            self.ebs_block_devices = input;
            self
        }
        /// <p>If the instance group is EBS-optimized. An Amazon EBS-optimized instance uses an
        /// optimized configuration stack and provides additional, dedicated capacity for Amazon EBS
        /// I/O.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>If the instance group is EBS-optimized. An Amazon EBS-optimized instance uses an
        /// optimized configuration stack and provides additional, dedicated capacity for Amazon EBS
        /// I/O.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>Policy for customizing shrink operations.</p>
        pub fn shrink_policy(mut self, input: crate::model::ShrinkPolicy) -> Self {
            self.shrink_policy = Some(input);
            self
        }
        /// <p>Policy for customizing shrink operations.</p>
        pub fn set_shrink_policy(
            mut self,
            input: std::option::Option<crate::model::ShrinkPolicy>,
        ) -> Self {
            self.shrink_policy = input;
            self
        }
        /// <p>An automatic scaling policy for a core instance group or task instance group in an
        /// Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
        /// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
        /// PutAutoScalingPolicy.</p>
        pub fn auto_scaling_policy(
            mut self,
            input: crate::model::AutoScalingPolicyDescription,
        ) -> Self {
            self.auto_scaling_policy = Some(input);
            self
        }
        /// <p>An automatic scaling policy for a core instance group or task instance group in an
        /// Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
        /// adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
        /// PutAutoScalingPolicy.</p>
        pub fn set_auto_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicyDescription>,
        ) -> Self {
            self.auto_scaling_policy = input;
            self
        }
        /// <p>The custom AMI ID to use for the provisioned instance group.</p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_ami_id = Some(input.into());
            self
        }
        /// <p>The custom AMI ID to use for the provisioned instance group.</p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_ami_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceGroup`](crate::model::InstanceGroup)
        pub fn build(self) -> crate::model::InstanceGroup {
            crate::model::InstanceGroup {
                id: self.id,
                name: self.name,
                market: self.market,
                instance_group_type: self.instance_group_type,
                bid_price: self.bid_price,
                instance_type: self.instance_type,
                requested_instance_count: self.requested_instance_count,
                running_instance_count: self.running_instance_count,
                status: self.status,
                configurations: self.configurations,
                configurations_version: self.configurations_version.unwrap_or_default(),
                last_successfully_applied_configurations: self
                    .last_successfully_applied_configurations,
                last_successfully_applied_configurations_version: self
                    .last_successfully_applied_configurations_version
                    .unwrap_or_default(),
                ebs_block_devices: self.ebs_block_devices,
                ebs_optimized: self.ebs_optimized,
                shrink_policy: self.shrink_policy,
                auto_scaling_policy: self.auto_scaling_policy,
                custom_ami_id: self.custom_ami_id,
            }
        }
    }
}
impl InstanceGroup {
    /// Creates a new builder-style object to manufacture [`InstanceGroup`](crate::model::InstanceGroup)
    pub fn builder() -> crate::model::instance_group::Builder {
        crate::model::instance_group::Builder::default()
    }
}

/// <p>Configuration of requested EBS block device associated with the instance group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsBlockDevice {
    /// <p>EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
    /// requested for the EBS volume attached to an EC2 instance in the cluster.</p>
    pub volume_specification: std::option::Option<crate::model::VolumeSpecification>,
    /// <p>The device name that is exposed to the instance, such as /dev/sdh.</p>
    pub device: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EbsBlockDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsBlockDevice");
        formatter.field("volume_specification", &self.volume_specification);
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`EbsBlockDevice`](crate::model::EbsBlockDevice)
pub mod ebs_block_device {
    /// A builder for [`EbsBlockDevice`](crate::model::EbsBlockDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_specification: std::option::Option<crate::model::VolumeSpecification>,
        pub(crate) device: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
        /// requested for the EBS volume attached to an EC2 instance in the cluster.</p>
        pub fn volume_specification(mut self, input: crate::model::VolumeSpecification) -> Self {
            self.volume_specification = Some(input);
            self
        }
        /// <p>EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
        /// requested for the EBS volume attached to an EC2 instance in the cluster.</p>
        pub fn set_volume_specification(
            mut self,
            input: std::option::Option<crate::model::VolumeSpecification>,
        ) -> Self {
            self.volume_specification = input;
            self
        }
        /// <p>The device name that is exposed to the instance, such as /dev/sdh.</p>
        pub fn device(mut self, input: impl Into<std::string::String>) -> Self {
            self.device = Some(input.into());
            self
        }
        /// <p>The device name that is exposed to the instance, such as /dev/sdh.</p>
        pub fn set_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsBlockDevice`](crate::model::EbsBlockDevice)
        pub fn build(self) -> crate::model::EbsBlockDevice {
            crate::model::EbsBlockDevice {
                volume_specification: self.volume_specification,
                device: self.device,
            }
        }
    }
}
impl EbsBlockDevice {
    /// Creates a new builder-style object to manufacture [`EbsBlockDevice`](crate::model::EbsBlockDevice)
    pub fn builder() -> crate::model::ebs_block_device::Builder {
        crate::model::ebs_block_device::Builder::default()
    }
}

/// <p>The details of the instance group status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceGroupStatus {
    /// <p>The current state of the instance group.</p>
    pub state: std::option::Option<crate::model::InstanceGroupState>,
    /// <p>The status change reason details for the instance group.</p>
    pub state_change_reason: std::option::Option<crate::model::InstanceGroupStateChangeReason>,
    /// <p>The timeline of the instance group status over time.</p>
    pub timeline: std::option::Option<crate::model::InstanceGroupTimeline>,
}
impl std::fmt::Debug for InstanceGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceGroupStatus");
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("timeline", &self.timeline);
        formatter.finish()
    }
}
/// See [`InstanceGroupStatus`](crate::model::InstanceGroupStatus)
pub mod instance_group_status {
    /// A builder for [`InstanceGroupStatus`](crate::model::InstanceGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::InstanceGroupState>,
        pub(crate) state_change_reason:
            std::option::Option<crate::model::InstanceGroupStateChangeReason>,
        pub(crate) timeline: std::option::Option<crate::model::InstanceGroupTimeline>,
    }
    impl Builder {
        /// <p>The current state of the instance group.</p>
        pub fn state(mut self, input: crate::model::InstanceGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the instance group.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The status change reason details for the instance group.</p>
        pub fn state_change_reason(
            mut self,
            input: crate::model::InstanceGroupStateChangeReason,
        ) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>The status change reason details for the instance group.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::InstanceGroupStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// <p>The timeline of the instance group status over time.</p>
        pub fn timeline(mut self, input: crate::model::InstanceGroupTimeline) -> Self {
            self.timeline = Some(input);
            self
        }
        /// <p>The timeline of the instance group status over time.</p>
        pub fn set_timeline(
            mut self,
            input: std::option::Option<crate::model::InstanceGroupTimeline>,
        ) -> Self {
            self.timeline = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceGroupStatus`](crate::model::InstanceGroupStatus)
        pub fn build(self) -> crate::model::InstanceGroupStatus {
            crate::model::InstanceGroupStatus {
                state: self.state,
                state_change_reason: self.state_change_reason,
                timeline: self.timeline,
            }
        }
    }
}
impl InstanceGroupStatus {
    /// Creates a new builder-style object to manufacture [`InstanceGroupStatus`](crate::model::InstanceGroupStatus)
    pub fn builder() -> crate::model::instance_group_status::Builder {
        crate::model::instance_group_status::Builder::default()
    }
}

/// <p>The timeline of the instance group lifecycle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceGroupTimeline {
    /// <p>The creation date and time of the instance group.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the instance group became ready to perform tasks.</p>
    pub ready_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the instance group terminated.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for InstanceGroupTimeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceGroupTimeline");
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("ready_date_time", &self.ready_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.finish()
    }
}
/// See [`InstanceGroupTimeline`](crate::model::InstanceGroupTimeline)
pub mod instance_group_timeline {
    /// A builder for [`InstanceGroupTimeline`](crate::model::InstanceGroupTimeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ready_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The creation date and time of the instance group.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time of the instance group.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the instance group became ready to perform tasks.</p>
        pub fn ready_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ready_date_time = Some(input);
            self
        }
        /// <p>The date and time when the instance group became ready to perform tasks.</p>
        pub fn set_ready_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ready_date_time = input;
            self
        }
        /// <p>The date and time when the instance group terminated.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The date and time when the instance group terminated.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceGroupTimeline`](crate::model::InstanceGroupTimeline)
        pub fn build(self) -> crate::model::InstanceGroupTimeline {
            crate::model::InstanceGroupTimeline {
                creation_date_time: self.creation_date_time,
                ready_date_time: self.ready_date_time,
                end_date_time: self.end_date_time,
            }
        }
    }
}
impl InstanceGroupTimeline {
    /// Creates a new builder-style object to manufacture [`InstanceGroupTimeline`](crate::model::InstanceGroupTimeline)
    pub fn builder() -> crate::model::instance_group_timeline::Builder {
        crate::model::instance_group_timeline::Builder::default()
    }
}

/// <p>The status change reason details for the instance group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceGroupStateChangeReason {
    /// <p>The programmable code for the state change reason.</p>
    pub code: std::option::Option<crate::model::InstanceGroupStateChangeReasonCode>,
    /// <p>The status change reason description.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceGroupStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceGroupStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`InstanceGroupStateChangeReason`](crate::model::InstanceGroupStateChangeReason)
pub mod instance_group_state_change_reason {
    /// A builder for [`InstanceGroupStateChangeReason`](crate::model::InstanceGroupStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::InstanceGroupStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The programmable code for the state change reason.</p>
        pub fn code(mut self, input: crate::model::InstanceGroupStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The programmable code for the state change reason.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::InstanceGroupStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The status change reason description.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The status change reason description.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceGroupStateChangeReason`](crate::model::InstanceGroupStateChangeReason)
        pub fn build(self) -> crate::model::InstanceGroupStateChangeReason {
            crate::model::InstanceGroupStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InstanceGroupStateChangeReason {
    /// Creates a new builder-style object to manufacture [`InstanceGroupStateChangeReason`](crate::model::InstanceGroupStateChangeReason)
    pub fn builder() -> crate::model::instance_group_state_change_reason::Builder {
        crate::model::instance_group_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceGroupStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    ClusterTerminated,
    #[allow(missing_docs)] // documentation missing in model
    InstanceFailure,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceGroupStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "CLUSTER_TERMINATED" => InstanceGroupStateChangeReasonCode::ClusterTerminated,
            "INSTANCE_FAILURE" => InstanceGroupStateChangeReasonCode::InstanceFailure,
            "INTERNAL_ERROR" => InstanceGroupStateChangeReasonCode::InternalError,
            "VALIDATION_ERROR" => InstanceGroupStateChangeReasonCode::ValidationError,
            other => InstanceGroupStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceGroupStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceGroupStateChangeReasonCode::from(s))
    }
}
impl InstanceGroupStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceGroupStateChangeReasonCode::ClusterTerminated => "CLUSTER_TERMINATED",
            InstanceGroupStateChangeReasonCode::InstanceFailure => "INSTANCE_FAILURE",
            InstanceGroupStateChangeReasonCode::InternalError => "INTERNAL_ERROR",
            InstanceGroupStateChangeReasonCode::ValidationError => "VALIDATION_ERROR",
            InstanceGroupStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLUSTER_TERMINATED",
            "INSTANCE_FAILURE",
            "INTERNAL_ERROR",
            "VALIDATION_ERROR",
        ]
    }
}
impl AsRef<str> for InstanceGroupStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceGroupState {
    #[allow(missing_docs)] // documentation missing in model
    Arrested,
    #[allow(missing_docs)] // documentation missing in model
    Bootstrapping,
    #[allow(missing_docs)] // documentation missing in model
    Ended,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Reconfiguring,
    #[allow(missing_docs)] // documentation missing in model
    Resizing,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    ShuttingDown,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceGroupState {
    fn from(s: &str) -> Self {
        match s {
            "ARRESTED" => InstanceGroupState::Arrested,
            "BOOTSTRAPPING" => InstanceGroupState::Bootstrapping,
            "ENDED" => InstanceGroupState::Ended,
            "PROVISIONING" => InstanceGroupState::Provisioning,
            "RECONFIGURING" => InstanceGroupState::Reconfiguring,
            "RESIZING" => InstanceGroupState::Resizing,
            "RUNNING" => InstanceGroupState::Running,
            "SHUTTING_DOWN" => InstanceGroupState::ShuttingDown,
            "SUSPENDED" => InstanceGroupState::Suspended,
            "TERMINATED" => InstanceGroupState::Terminated,
            "TERMINATING" => InstanceGroupState::Terminating,
            other => InstanceGroupState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceGroupState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceGroupState::from(s))
    }
}
impl InstanceGroupState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceGroupState::Arrested => "ARRESTED",
            InstanceGroupState::Bootstrapping => "BOOTSTRAPPING",
            InstanceGroupState::Ended => "ENDED",
            InstanceGroupState::Provisioning => "PROVISIONING",
            InstanceGroupState::Reconfiguring => "RECONFIGURING",
            InstanceGroupState::Resizing => "RESIZING",
            InstanceGroupState::Running => "RUNNING",
            InstanceGroupState::ShuttingDown => "SHUTTING_DOWN",
            InstanceGroupState::Suspended => "SUSPENDED",
            InstanceGroupState::Terminated => "TERMINATED",
            InstanceGroupState::Terminating => "TERMINATING",
            InstanceGroupState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ARRESTED",
            "BOOTSTRAPPING",
            "ENDED",
            "PROVISIONING",
            "RECONFIGURING",
            "RESIZING",
            "RUNNING",
            "SHUTTING_DOWN",
            "SUSPENDED",
            "TERMINATED",
            "TERMINATING",
        ]
    }
}
impl AsRef<str> for InstanceGroupState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an instance fleet, which is a group of EC2 instances that host a particular
/// node type (master, core, or task) in an Amazon EMR cluster. Instance fleets can consist of
/// a mix of instance types and On-Demand and Spot Instances, which are provisioned to meet a
/// defined target capacity. </p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceFleet {
    /// <p>The unique identifier of the instance fleet.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A friendly name for the instance fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the instance fleet. </p>
    pub status: std::option::Option<crate::model::InstanceFleetStatus>,
    /// <p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, or TASK.
    /// </p>
    pub instance_fleet_type: std::option::Option<crate::model::InstanceFleetType>,
    /// <p>The target capacity of On-Demand units for the instance fleet, which determines how many
    /// On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to
    /// provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each
    /// instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand
    /// Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target
    /// capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled,
    /// even if this results in an overage. For example, if there are 2 units remaining to fulfill
    /// capacity, and Amazon EMR can only provision an instance with a
    /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
    /// capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedOnDemandCapacity</a> to determine the Spot capacity
    /// units that have been provisioned for the instance fleet.</p>
    /// <note>
    /// <p>If not specified or set to 0, only Spot Instances are provisioned for the instance
    /// fleet using <code>TargetSpotCapacity</code>. At least one of
    /// <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be
    /// greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code>
    /// and <code>TargetOnDemandCapacity</code> can be specified, and its value must be
    /// 1.</p>
    /// </note>
    pub target_on_demand_capacity: std::option::Option<i32>,
    /// <p>The target capacity of Spot units for the instance fleet, which determines how many Spot
    /// Instances to provision. When the instance fleet launches, Amazon EMR tries to provision
    /// Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance
    /// configuration has a specified <code>WeightedCapacity</code>. When a Spot instance is
    /// provisioned, the <code>WeightedCapacity</code> units count toward the target capacity.
    /// Amazon EMR provisions instances until the target capacity is totally fulfilled, even if
    /// this results in an overage. For example, if there are 2 units remaining to fulfill
    /// capacity, and Amazon EMR can only provision an instance with a
    /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
    /// capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedSpotCapacity</a> to determine the Spot capacity units
    /// that have been provisioned for the instance fleet.</p>
    /// <note>
    /// <p>If not specified or set to 0, only On-Demand Instances are provisioned for the
    /// instance fleet. At least one of <code>TargetSpotCapacity</code> and
    /// <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance
    /// fleet, only one of <code>TargetSpotCapacity</code> and
    /// <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p>
    /// </note>
    pub target_spot_capacity: std::option::Option<i32>,
    /// <p>The number of On-Demand units that have been provisioned for the instance fleet to
    /// fulfill <code>TargetOnDemandCapacity</code>. This provisioned capacity might be less than
    /// or greater than <code>TargetOnDemandCapacity</code>.</p>
    pub provisioned_on_demand_capacity: std::option::Option<i32>,
    /// <p>The number of Spot units that have been provisioned for this instance fleet to fulfill
    /// <code>TargetSpotCapacity</code>. This provisioned capacity might be less than or greater
    /// than <code>TargetSpotCapacity</code>.</p>
    pub provisioned_spot_capacity: std::option::Option<i32>,
    /// <p>An array of specifications for the instance types that comprise an instance fleet.</p>
    pub instance_type_specifications:
        std::option::Option<std::vec::Vec<crate::model::InstanceTypeSpecification>>,
    /// <p>Describes the launch specification for an instance fleet. </p>
    pub launch_specifications:
        std::option::Option<crate::model::InstanceFleetProvisioningSpecifications>,
}
impl std::fmt::Debug for InstanceFleet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceFleet");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("instance_fleet_type", &self.instance_fleet_type);
        formatter.field("target_on_demand_capacity", &self.target_on_demand_capacity);
        formatter.field("target_spot_capacity", &self.target_spot_capacity);
        formatter.field(
            "provisioned_on_demand_capacity",
            &self.provisioned_on_demand_capacity,
        );
        formatter.field("provisioned_spot_capacity", &self.provisioned_spot_capacity);
        formatter.field(
            "instance_type_specifications",
            &self.instance_type_specifications,
        );
        formatter.field("launch_specifications", &self.launch_specifications);
        formatter.finish()
    }
}
/// See [`InstanceFleet`](crate::model::InstanceFleet)
pub mod instance_fleet {
    /// A builder for [`InstanceFleet`](crate::model::InstanceFleet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::InstanceFleetStatus>,
        pub(crate) instance_fleet_type: std::option::Option<crate::model::InstanceFleetType>,
        pub(crate) target_on_demand_capacity: std::option::Option<i32>,
        pub(crate) target_spot_capacity: std::option::Option<i32>,
        pub(crate) provisioned_on_demand_capacity: std::option::Option<i32>,
        pub(crate) provisioned_spot_capacity: std::option::Option<i32>,
        pub(crate) instance_type_specifications:
            std::option::Option<std::vec::Vec<crate::model::InstanceTypeSpecification>>,
        pub(crate) launch_specifications:
            std::option::Option<crate::model::InstanceFleetProvisioningSpecifications>,
    }
    impl Builder {
        /// <p>The unique identifier of the instance fleet.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the instance fleet.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A friendly name for the instance fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name for the instance fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the instance fleet. </p>
        pub fn status(mut self, input: crate::model::InstanceFleetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the instance fleet. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, or TASK.
        /// </p>
        pub fn instance_fleet_type(mut self, input: crate::model::InstanceFleetType) -> Self {
            self.instance_fleet_type = Some(input);
            self
        }
        /// <p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, or TASK.
        /// </p>
        pub fn set_instance_fleet_type(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetType>,
        ) -> Self {
            self.instance_fleet_type = input;
            self
        }
        /// <p>The target capacity of On-Demand units for the instance fleet, which determines how many
        /// On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to
        /// provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each
        /// instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand
        /// Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target
        /// capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled,
        /// even if this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedOnDemandCapacity</a> to determine the Spot capacity
        /// units that have been provisioned for the instance fleet.</p>
        /// <note>
        /// <p>If not specified or set to 0, only Spot Instances are provisioned for the instance
        /// fleet using <code>TargetSpotCapacity</code>. At least one of
        /// <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be
        /// greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code>
        /// and <code>TargetOnDemandCapacity</code> can be specified, and its value must be
        /// 1.</p>
        /// </note>
        pub fn target_on_demand_capacity(mut self, input: i32) -> Self {
            self.target_on_demand_capacity = Some(input);
            self
        }
        /// <p>The target capacity of On-Demand units for the instance fleet, which determines how many
        /// On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to
        /// provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each
        /// instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand
        /// Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target
        /// capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled,
        /// even if this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedOnDemandCapacity</a> to determine the Spot capacity
        /// units that have been provisioned for the instance fleet.</p>
        /// <note>
        /// <p>If not specified or set to 0, only Spot Instances are provisioned for the instance
        /// fleet using <code>TargetSpotCapacity</code>. At least one of
        /// <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be
        /// greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code>
        /// and <code>TargetOnDemandCapacity</code> can be specified, and its value must be
        /// 1.</p>
        /// </note>
        pub fn set_target_on_demand_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.target_on_demand_capacity = input;
            self
        }
        /// <p>The target capacity of Spot units for the instance fleet, which determines how many Spot
        /// Instances to provision. When the instance fleet launches, Amazon EMR tries to provision
        /// Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance
        /// configuration has a specified <code>WeightedCapacity</code>. When a Spot instance is
        /// provisioned, the <code>WeightedCapacity</code> units count toward the target capacity.
        /// Amazon EMR provisions instances until the target capacity is totally fulfilled, even if
        /// this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedSpotCapacity</a> to determine the Spot capacity units
        /// that have been provisioned for the instance fleet.</p>
        /// <note>
        /// <p>If not specified or set to 0, only On-Demand Instances are provisioned for the
        /// instance fleet. At least one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance
        /// fleet, only one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p>
        /// </note>
        pub fn target_spot_capacity(mut self, input: i32) -> Self {
            self.target_spot_capacity = Some(input);
            self
        }
        /// <p>The target capacity of Spot units for the instance fleet, which determines how many Spot
        /// Instances to provision. When the instance fleet launches, Amazon EMR tries to provision
        /// Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance
        /// configuration has a specified <code>WeightedCapacity</code>. When a Spot instance is
        /// provisioned, the <code>WeightedCapacity</code> units count toward the target capacity.
        /// Amazon EMR provisions instances until the target capacity is totally fulfilled, even if
        /// this results in an overage. For example, if there are 2 units remaining to fulfill
        /// capacity, and Amazon EMR can only provision an instance with a
        /// <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target
        /// capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedSpotCapacity</a> to determine the Spot capacity units
        /// that have been provisioned for the instance fleet.</p>
        /// <note>
        /// <p>If not specified or set to 0, only On-Demand Instances are provisioned for the
        /// instance fleet. At least one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance
        /// fleet, only one of <code>TargetSpotCapacity</code> and
        /// <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p>
        /// </note>
        pub fn set_target_spot_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.target_spot_capacity = input;
            self
        }
        /// <p>The number of On-Demand units that have been provisioned for the instance fleet to
        /// fulfill <code>TargetOnDemandCapacity</code>. This provisioned capacity might be less than
        /// or greater than <code>TargetOnDemandCapacity</code>.</p>
        pub fn provisioned_on_demand_capacity(mut self, input: i32) -> Self {
            self.provisioned_on_demand_capacity = Some(input);
            self
        }
        /// <p>The number of On-Demand units that have been provisioned for the instance fleet to
        /// fulfill <code>TargetOnDemandCapacity</code>. This provisioned capacity might be less than
        /// or greater than <code>TargetOnDemandCapacity</code>.</p>
        pub fn set_provisioned_on_demand_capacity(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.provisioned_on_demand_capacity = input;
            self
        }
        /// <p>The number of Spot units that have been provisioned for this instance fleet to fulfill
        /// <code>TargetSpotCapacity</code>. This provisioned capacity might be less than or greater
        /// than <code>TargetSpotCapacity</code>.</p>
        pub fn provisioned_spot_capacity(mut self, input: i32) -> Self {
            self.provisioned_spot_capacity = Some(input);
            self
        }
        /// <p>The number of Spot units that have been provisioned for this instance fleet to fulfill
        /// <code>TargetSpotCapacity</code>. This provisioned capacity might be less than or greater
        /// than <code>TargetSpotCapacity</code>.</p>
        pub fn set_provisioned_spot_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.provisioned_spot_capacity = input;
            self
        }
        /// Appends an item to `instance_type_specifications`.
        ///
        /// To override the contents of this collection use [`set_instance_type_specifications`](Self::set_instance_type_specifications).
        ///
        /// <p>An array of specifications for the instance types that comprise an instance fleet.</p>
        pub fn instance_type_specifications(
            mut self,
            input: impl Into<crate::model::InstanceTypeSpecification>,
        ) -> Self {
            let mut v = self.instance_type_specifications.unwrap_or_default();
            v.push(input.into());
            self.instance_type_specifications = Some(v);
            self
        }
        /// <p>An array of specifications for the instance types that comprise an instance fleet.</p>
        pub fn set_instance_type_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceTypeSpecification>>,
        ) -> Self {
            self.instance_type_specifications = input;
            self
        }
        /// <p>Describes the launch specification for an instance fleet. </p>
        pub fn launch_specifications(
            mut self,
            input: crate::model::InstanceFleetProvisioningSpecifications,
        ) -> Self {
            self.launch_specifications = Some(input);
            self
        }
        /// <p>Describes the launch specification for an instance fleet. </p>
        pub fn set_launch_specifications(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetProvisioningSpecifications>,
        ) -> Self {
            self.launch_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceFleet`](crate::model::InstanceFleet)
        pub fn build(self) -> crate::model::InstanceFleet {
            crate::model::InstanceFleet {
                id: self.id,
                name: self.name,
                status: self.status,
                instance_fleet_type: self.instance_fleet_type,
                target_on_demand_capacity: self.target_on_demand_capacity,
                target_spot_capacity: self.target_spot_capacity,
                provisioned_on_demand_capacity: self.provisioned_on_demand_capacity,
                provisioned_spot_capacity: self.provisioned_spot_capacity,
                instance_type_specifications: self.instance_type_specifications,
                launch_specifications: self.launch_specifications,
            }
        }
    }
}
impl InstanceFleet {
    /// Creates a new builder-style object to manufacture [`InstanceFleet`](crate::model::InstanceFleet)
    pub fn builder() -> crate::model::instance_fleet::Builder {
        crate::model::instance_fleet::Builder::default()
    }
}

/// <p>The configuration specification for each instance type in an instance fleet.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceTypeSpecification {
    /// <p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The number of units that a provisioned instance of this type provides toward fulfilling
    /// the target capacities defined in <a>InstanceFleetConfig</a>. Capacity values
    /// represent performance characteristics such as vCPUs, memory, or I/O. If not specified, the
    /// default value is 1.</p>
    pub weighted_capacity: std::option::Option<i32>,
    /// <p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>.
    /// Expressed in USD.</p>
    pub bid_price: std::option::Option<std::string::String>,
    /// <p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined
    /// by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%).</p>
    pub bid_price_as_percentage_of_on_demand_price: std::option::Option<f64>,
    /// <p>A configuration classification that applies when provisioning cluster instances, which
    /// can include configurations for applications and software bundled with Amazon EMR.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance
    /// as defined by <code>InstanceType</code>.</p>
    pub ebs_block_devices: std::option::Option<std::vec::Vec<crate::model::EbsBlockDevice>>,
    /// <p>Evaluates to <code>TRUE</code> when the specified <code>InstanceType</code> is
    /// EBS-optimized.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>The custom AMI ID to use for the instance type.</p>
    pub custom_ami_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceTypeSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceTypeSpecification");
        formatter.field("instance_type", &self.instance_type);
        formatter.field("weighted_capacity", &self.weighted_capacity);
        formatter.field("bid_price", &self.bid_price);
        formatter.field(
            "bid_price_as_percentage_of_on_demand_price",
            &self.bid_price_as_percentage_of_on_demand_price,
        );
        formatter.field("configurations", &self.configurations);
        formatter.field("ebs_block_devices", &self.ebs_block_devices);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("custom_ami_id", &self.custom_ami_id);
        formatter.finish()
    }
}
/// See [`InstanceTypeSpecification`](crate::model::InstanceTypeSpecification)
pub mod instance_type_specification {
    /// A builder for [`InstanceTypeSpecification`](crate::model::InstanceTypeSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) weighted_capacity: std::option::Option<i32>,
        pub(crate) bid_price: std::option::Option<std::string::String>,
        pub(crate) bid_price_as_percentage_of_on_demand_price: std::option::Option<f64>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) ebs_block_devices:
            std::option::Option<std::vec::Vec<crate::model::EbsBlockDevice>>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) custom_ami_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The number of units that a provisioned instance of this type provides toward fulfilling
        /// the target capacities defined in <a>InstanceFleetConfig</a>. Capacity values
        /// represent performance characteristics such as vCPUs, memory, or I/O. If not specified, the
        /// default value is 1.</p>
        pub fn weighted_capacity(mut self, input: i32) -> Self {
            self.weighted_capacity = Some(input);
            self
        }
        /// <p>The number of units that a provisioned instance of this type provides toward fulfilling
        /// the target capacities defined in <a>InstanceFleetConfig</a>. Capacity values
        /// represent performance characteristics such as vCPUs, memory, or I/O. If not specified, the
        /// default value is 1.</p>
        pub fn set_weighted_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.weighted_capacity = input;
            self
        }
        /// <p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>.
        /// Expressed in USD.</p>
        pub fn bid_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.bid_price = Some(input.into());
            self
        }
        /// <p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>.
        /// Expressed in USD.</p>
        pub fn set_bid_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bid_price = input;
            self
        }
        /// <p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined
        /// by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%).</p>
        pub fn bid_price_as_percentage_of_on_demand_price(mut self, input: f64) -> Self {
            self.bid_price_as_percentage_of_on_demand_price = Some(input);
            self
        }
        /// <p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined
        /// by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%).</p>
        pub fn set_bid_price_as_percentage_of_on_demand_price(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.bid_price_as_percentage_of_on_demand_price = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A configuration classification that applies when provisioning cluster instances, which
        /// can include configurations for applications and software bundled with Amazon EMR.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>A configuration classification that applies when provisioning cluster instances, which
        /// can include configurations for applications and software bundled with Amazon EMR.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// Appends an item to `ebs_block_devices`.
        ///
        /// To override the contents of this collection use [`set_ebs_block_devices`](Self::set_ebs_block_devices).
        ///
        /// <p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance
        /// as defined by <code>InstanceType</code>.</p>
        pub fn ebs_block_devices(mut self, input: impl Into<crate::model::EbsBlockDevice>) -> Self {
            let mut v = self.ebs_block_devices.unwrap_or_default();
            v.push(input.into());
            self.ebs_block_devices = Some(v);
            self
        }
        /// <p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance
        /// as defined by <code>InstanceType</code>.</p>
        pub fn set_ebs_block_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EbsBlockDevice>>,
        ) -> Self {
            self.ebs_block_devices = input;
            self
        }
        /// <p>Evaluates to <code>TRUE</code> when the specified <code>InstanceType</code> is
        /// EBS-optimized.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Evaluates to <code>TRUE</code> when the specified <code>InstanceType</code> is
        /// EBS-optimized.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>The custom AMI ID to use for the instance type.</p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_ami_id = Some(input.into());
            self
        }
        /// <p>The custom AMI ID to use for the instance type.</p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_ami_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceTypeSpecification`](crate::model::InstanceTypeSpecification)
        pub fn build(self) -> crate::model::InstanceTypeSpecification {
            crate::model::InstanceTypeSpecification {
                instance_type: self.instance_type,
                weighted_capacity: self.weighted_capacity,
                bid_price: self.bid_price,
                bid_price_as_percentage_of_on_demand_price: self
                    .bid_price_as_percentage_of_on_demand_price,
                configurations: self.configurations,
                ebs_block_devices: self.ebs_block_devices,
                ebs_optimized: self.ebs_optimized,
                custom_ami_id: self.custom_ami_id,
            }
        }
    }
}
impl InstanceTypeSpecification {
    /// Creates a new builder-style object to manufacture [`InstanceTypeSpecification`](crate::model::InstanceTypeSpecification)
    pub fn builder() -> crate::model::instance_type_specification::Builder {
        crate::model::instance_type_specification::Builder::default()
    }
}

/// <p>The status of the instance fleet.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceFleetStatus {
    /// <p>A code representing the instance fleet status.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is
    /// not yet ready to run jobs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned
    /// and the bootstrap actions specified for the instances are underway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RUNNING</code>—EC2 instances and other resources are running. They are
    /// either executing jobs or waiting to execute jobs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESIZING</code>—A resize operation is underway. EC2 instances are either
    /// being added or removed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2
    /// instances are running, but instances can't be added or removed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2
    /// instances have been terminated.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::InstanceFleetState>,
    /// <p>Provides status change reason details for the instance fleet.</p>
    pub state_change_reason: std::option::Option<crate::model::InstanceFleetStateChangeReason>,
    /// <p>Provides historical timestamps for the instance fleet, including the time of creation,
    /// the time it became ready to run jobs, and the time of termination.</p>
    pub timeline: std::option::Option<crate::model::InstanceFleetTimeline>,
}
impl std::fmt::Debug for InstanceFleetStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceFleetStatus");
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("timeline", &self.timeline);
        formatter.finish()
    }
}
/// See [`InstanceFleetStatus`](crate::model::InstanceFleetStatus)
pub mod instance_fleet_status {
    /// A builder for [`InstanceFleetStatus`](crate::model::InstanceFleetStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::InstanceFleetState>,
        pub(crate) state_change_reason:
            std::option::Option<crate::model::InstanceFleetStateChangeReason>,
        pub(crate) timeline: std::option::Option<crate::model::InstanceFleetTimeline>,
    }
    impl Builder {
        /// <p>A code representing the instance fleet status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is
        /// not yet ready to run jobs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned
        /// and the bootstrap actions specified for the instances are underway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code>—EC2 instances and other resources are running. They are
        /// either executing jobs or waiting to execute jobs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESIZING</code>—A resize operation is underway. EC2 instances are either
        /// being added or removed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2
        /// instances are running, but instances can't be added or removed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2
        /// instances have been terminated.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::InstanceFleetState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>A code representing the instance fleet status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is
        /// not yet ready to run jobs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned
        /// and the bootstrap actions specified for the instances are underway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code>—EC2 instances and other resources are running. They are
        /// either executing jobs or waiting to execute jobs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESIZING</code>—A resize operation is underway. EC2 instances are either
        /// being added or removed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2
        /// instances are running, but instances can't be added or removed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2
        /// instances have been terminated.</p>
        /// </li>
        /// </ul>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Provides status change reason details for the instance fleet.</p>
        pub fn state_change_reason(
            mut self,
            input: crate::model::InstanceFleetStateChangeReason,
        ) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>Provides status change reason details for the instance fleet.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// <p>Provides historical timestamps for the instance fleet, including the time of creation,
        /// the time it became ready to run jobs, and the time of termination.</p>
        pub fn timeline(mut self, input: crate::model::InstanceFleetTimeline) -> Self {
            self.timeline = Some(input);
            self
        }
        /// <p>Provides historical timestamps for the instance fleet, including the time of creation,
        /// the time it became ready to run jobs, and the time of termination.</p>
        pub fn set_timeline(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetTimeline>,
        ) -> Self {
            self.timeline = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceFleetStatus`](crate::model::InstanceFleetStatus)
        pub fn build(self) -> crate::model::InstanceFleetStatus {
            crate::model::InstanceFleetStatus {
                state: self.state,
                state_change_reason: self.state_change_reason,
                timeline: self.timeline,
            }
        }
    }
}
impl InstanceFleetStatus {
    /// Creates a new builder-style object to manufacture [`InstanceFleetStatus`](crate::model::InstanceFleetStatus)
    pub fn builder() -> crate::model::instance_fleet_status::Builder {
        crate::model::instance_fleet_status::Builder::default()
    }
}

/// <p>Provides historical timestamps for the instance fleet, including the time of creation,
/// the time it became ready to run jobs, and the time of termination.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceFleetTimeline {
    /// <p>The time and date the instance fleet was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time and date the instance fleet was ready to run jobs.</p>
    pub ready_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time and date the instance fleet terminated.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for InstanceFleetTimeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceFleetTimeline");
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("ready_date_time", &self.ready_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.finish()
    }
}
/// See [`InstanceFleetTimeline`](crate::model::InstanceFleetTimeline)
pub mod instance_fleet_timeline {
    /// A builder for [`InstanceFleetTimeline`](crate::model::InstanceFleetTimeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ready_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The time and date the instance fleet was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The time and date the instance fleet was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The time and date the instance fleet was ready to run jobs.</p>
        pub fn ready_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ready_date_time = Some(input);
            self
        }
        /// <p>The time and date the instance fleet was ready to run jobs.</p>
        pub fn set_ready_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ready_date_time = input;
            self
        }
        /// <p>The time and date the instance fleet terminated.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The time and date the instance fleet terminated.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceFleetTimeline`](crate::model::InstanceFleetTimeline)
        pub fn build(self) -> crate::model::InstanceFleetTimeline {
            crate::model::InstanceFleetTimeline {
                creation_date_time: self.creation_date_time,
                ready_date_time: self.ready_date_time,
                end_date_time: self.end_date_time,
            }
        }
    }
}
impl InstanceFleetTimeline {
    /// Creates a new builder-style object to manufacture [`InstanceFleetTimeline`](crate::model::InstanceFleetTimeline)
    pub fn builder() -> crate::model::instance_fleet_timeline::Builder {
        crate::model::instance_fleet_timeline::Builder::default()
    }
}

/// <p>Provides status change reason details for the instance fleet.</p>
/// <note>
/// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
/// later, excluding 5.0.x versions.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceFleetStateChangeReason {
    /// <p>A code corresponding to the reason the state change occurred.</p>
    pub code: std::option::Option<crate::model::InstanceFleetStateChangeReasonCode>,
    /// <p>An explanatory message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceFleetStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceFleetStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`InstanceFleetStateChangeReason`](crate::model::InstanceFleetStateChangeReason)
pub mod instance_fleet_state_change_reason {
    /// A builder for [`InstanceFleetStateChangeReason`](crate::model::InstanceFleetStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::InstanceFleetStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A code corresponding to the reason the state change occurred.</p>
        pub fn code(mut self, input: crate::model::InstanceFleetStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>A code corresponding to the reason the state change occurred.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::InstanceFleetStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>An explanatory message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An explanatory message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceFleetStateChangeReason`](crate::model::InstanceFleetStateChangeReason)
        pub fn build(self) -> crate::model::InstanceFleetStateChangeReason {
            crate::model::InstanceFleetStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InstanceFleetStateChangeReason {
    /// Creates a new builder-style object to manufacture [`InstanceFleetStateChangeReason`](crate::model::InstanceFleetStateChangeReason)
    pub fn builder() -> crate::model::instance_fleet_state_change_reason::Builder {
        crate::model::instance_fleet_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceFleetStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    ClusterTerminated,
    #[allow(missing_docs)] // documentation missing in model
    InstanceFailure,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceFleetStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "CLUSTER_TERMINATED" => InstanceFleetStateChangeReasonCode::ClusterTerminated,
            "INSTANCE_FAILURE" => InstanceFleetStateChangeReasonCode::InstanceFailure,
            "INTERNAL_ERROR" => InstanceFleetStateChangeReasonCode::InternalError,
            "VALIDATION_ERROR" => InstanceFleetStateChangeReasonCode::ValidationError,
            other => InstanceFleetStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceFleetStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceFleetStateChangeReasonCode::from(s))
    }
}
impl InstanceFleetStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceFleetStateChangeReasonCode::ClusterTerminated => "CLUSTER_TERMINATED",
            InstanceFleetStateChangeReasonCode::InstanceFailure => "INSTANCE_FAILURE",
            InstanceFleetStateChangeReasonCode::InternalError => "INTERNAL_ERROR",
            InstanceFleetStateChangeReasonCode::ValidationError => "VALIDATION_ERROR",
            InstanceFleetStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLUSTER_TERMINATED",
            "INSTANCE_FAILURE",
            "INTERNAL_ERROR",
            "VALIDATION_ERROR",
        ]
    }
}
impl AsRef<str> for InstanceFleetStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceFleetState {
    #[allow(missing_docs)] // documentation missing in model
    Bootstrapping,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Resizing,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceFleetState {
    fn from(s: &str) -> Self {
        match s {
            "BOOTSTRAPPING" => InstanceFleetState::Bootstrapping,
            "PROVISIONING" => InstanceFleetState::Provisioning,
            "RESIZING" => InstanceFleetState::Resizing,
            "RUNNING" => InstanceFleetState::Running,
            "SUSPENDED" => InstanceFleetState::Suspended,
            "TERMINATED" => InstanceFleetState::Terminated,
            "TERMINATING" => InstanceFleetState::Terminating,
            other => InstanceFleetState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceFleetState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceFleetState::from(s))
    }
}
impl InstanceFleetState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceFleetState::Bootstrapping => "BOOTSTRAPPING",
            InstanceFleetState::Provisioning => "PROVISIONING",
            InstanceFleetState::Resizing => "RESIZING",
            InstanceFleetState::Running => "RUNNING",
            InstanceFleetState::Suspended => "SUSPENDED",
            InstanceFleetState::Terminated => "TERMINATED",
            InstanceFleetState::Terminating => "TERMINATING",
            InstanceFleetState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOOTSTRAPPING",
            "PROVISIONING",
            "RESIZING",
            "RUNNING",
            "SUSPENDED",
            "TERMINATED",
            "TERMINATING",
        ]
    }
}
impl AsRef<str> for InstanceFleetState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary description of the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSummary {
    /// <p>The unique identifier for the cluster.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The details about the current status of the cluster.</p>
    pub status: std::option::Option<crate::model::ClusterStatus>,
    /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
    /// is incremented one time for every hour an m1.small instance runs. Larger instances are
    /// weighted more, so an EC2 instance that is roughly four times more expensive would result in
    /// the normalized instance hours being incremented by four. This result is only an
    /// approximation and does not reflect the actual billing rate.</p>
    pub normalized_instance_hours: std::option::Option<i32>,
    /// <p>The Amazon Resource Name of the cluster.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>
    pub outpost_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("normalized_instance_hours", &self.normalized_instance_hours);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("outpost_arn", &self.outpost_arn);
        formatter.finish()
    }
}
/// See [`ClusterSummary`](crate::model::ClusterSummary)
pub mod cluster_summary {
    /// A builder for [`ClusterSummary`](crate::model::ClusterSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ClusterStatus>,
        pub(crate) normalized_instance_hours: std::option::Option<i32>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the cluster.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cluster.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The details about the current status of the cluster.</p>
        pub fn status(mut self, input: crate::model::ClusterStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The details about the current status of the cluster.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ClusterStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
        /// is incremented one time for every hour an m1.small instance runs. Larger instances are
        /// weighted more, so an EC2 instance that is roughly four times more expensive would result in
        /// the normalized instance hours being incremented by four. This result is only an
        /// approximation and does not reflect the actual billing rate.</p>
        pub fn normalized_instance_hours(mut self, input: i32) -> Self {
            self.normalized_instance_hours = Some(input);
            self
        }
        /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
        /// is incremented one time for every hour an m1.small instance runs. Larger instances are
        /// weighted more, so an EC2 instance that is roughly four times more expensive would result in
        /// the normalized instance hours being incremented by four. This result is only an
        /// approximation and does not reflect the actual billing rate.</p>
        pub fn set_normalized_instance_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.normalized_instance_hours = input;
            self
        }
        /// <p>The Amazon Resource Name of the cluster.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the cluster.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSummary`](crate::model::ClusterSummary)
        pub fn build(self) -> crate::model::ClusterSummary {
            crate::model::ClusterSummary {
                id: self.id,
                name: self.name,
                status: self.status,
                normalized_instance_hours: self.normalized_instance_hours,
                cluster_arn: self.cluster_arn,
                outpost_arn: self.outpost_arn,
            }
        }
    }
}
impl ClusterSummary {
    /// Creates a new builder-style object to manufacture [`ClusterSummary`](crate::model::ClusterSummary)
    pub fn builder() -> crate::model::cluster_summary::Builder {
        crate::model::cluster_summary::Builder::default()
    }
}

/// <p>The detailed status of the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterStatus {
    /// <p>The current state of the cluster.</p>
    pub state: std::option::Option<crate::model::ClusterState>,
    /// <p>The reason for the cluster status change.</p>
    pub state_change_reason: std::option::Option<crate::model::ClusterStateChangeReason>,
    /// <p>A timeline that represents the status of a cluster over the lifetime of the
    /// cluster.</p>
    pub timeline: std::option::Option<crate::model::ClusterTimeline>,
}
impl std::fmt::Debug for ClusterStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterStatus");
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("timeline", &self.timeline);
        formatter.finish()
    }
}
/// See [`ClusterStatus`](crate::model::ClusterStatus)
pub mod cluster_status {
    /// A builder for [`ClusterStatus`](crate::model::ClusterStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::ClusterState>,
        pub(crate) state_change_reason: std::option::Option<crate::model::ClusterStateChangeReason>,
        pub(crate) timeline: std::option::Option<crate::model::ClusterTimeline>,
    }
    impl Builder {
        /// <p>The current state of the cluster.</p>
        pub fn state(mut self, input: crate::model::ClusterState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the cluster.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ClusterState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the cluster status change.</p>
        pub fn state_change_reason(
            mut self,
            input: crate::model::ClusterStateChangeReason,
        ) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>The reason for the cluster status change.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::ClusterStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// <p>A timeline that represents the status of a cluster over the lifetime of the
        /// cluster.</p>
        pub fn timeline(mut self, input: crate::model::ClusterTimeline) -> Self {
            self.timeline = Some(input);
            self
        }
        /// <p>A timeline that represents the status of a cluster over the lifetime of the
        /// cluster.</p>
        pub fn set_timeline(
            mut self,
            input: std::option::Option<crate::model::ClusterTimeline>,
        ) -> Self {
            self.timeline = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterStatus`](crate::model::ClusterStatus)
        pub fn build(self) -> crate::model::ClusterStatus {
            crate::model::ClusterStatus {
                state: self.state,
                state_change_reason: self.state_change_reason,
                timeline: self.timeline,
            }
        }
    }
}
impl ClusterStatus {
    /// Creates a new builder-style object to manufacture [`ClusterStatus`](crate::model::ClusterStatus)
    pub fn builder() -> crate::model::cluster_status::Builder {
        crate::model::cluster_status::Builder::default()
    }
}

/// <p>Represents the timeline of the cluster's lifecycle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterTimeline {
    /// <p>The creation date and time of the cluster.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the cluster was ready to run steps.</p>
    pub ready_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the cluster was terminated.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ClusterTimeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterTimeline");
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("ready_date_time", &self.ready_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.finish()
    }
}
/// See [`ClusterTimeline`](crate::model::ClusterTimeline)
pub mod cluster_timeline {
    /// A builder for [`ClusterTimeline`](crate::model::ClusterTimeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ready_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The creation date and time of the cluster.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time of the cluster.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the cluster was ready to run steps.</p>
        pub fn ready_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ready_date_time = Some(input);
            self
        }
        /// <p>The date and time when the cluster was ready to run steps.</p>
        pub fn set_ready_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ready_date_time = input;
            self
        }
        /// <p>The date and time when the cluster was terminated.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The date and time when the cluster was terminated.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterTimeline`](crate::model::ClusterTimeline)
        pub fn build(self) -> crate::model::ClusterTimeline {
            crate::model::ClusterTimeline {
                creation_date_time: self.creation_date_time,
                ready_date_time: self.ready_date_time,
                end_date_time: self.end_date_time,
            }
        }
    }
}
impl ClusterTimeline {
    /// Creates a new builder-style object to manufacture [`ClusterTimeline`](crate::model::ClusterTimeline)
    pub fn builder() -> crate::model::cluster_timeline::Builder {
        crate::model::cluster_timeline::Builder::default()
    }
}

/// <p>The reason that the cluster changed to its current state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterStateChangeReason {
    /// <p>The programmatic code for the state change reason.</p>
    pub code: std::option::Option<crate::model::ClusterStateChangeReasonCode>,
    /// <p>The descriptive message for the state change reason.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ClusterStateChangeReason`](crate::model::ClusterStateChangeReason)
pub mod cluster_state_change_reason {
    /// A builder for [`ClusterStateChangeReason`](crate::model::ClusterStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ClusterStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The programmatic code for the state change reason.</p>
        pub fn code(mut self, input: crate::model::ClusterStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The programmatic code for the state change reason.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::ClusterStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The descriptive message for the state change reason.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the state change reason.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterStateChangeReason`](crate::model::ClusterStateChangeReason)
        pub fn build(self) -> crate::model::ClusterStateChangeReason {
            crate::model::ClusterStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ClusterStateChangeReason {
    /// Creates a new builder-style object to manufacture [`ClusterStateChangeReason`](crate::model::ClusterStateChangeReason)
    pub fn builder() -> crate::model::cluster_state_change_reason::Builder {
        crate::model::cluster_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClusterStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    AllStepsCompleted,
    #[allow(missing_docs)] // documentation missing in model
    BootstrapFailure,
    #[allow(missing_docs)] // documentation missing in model
    InstanceFailure,
    #[allow(missing_docs)] // documentation missing in model
    InstanceFleetTimeout,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    StepFailure,
    #[allow(missing_docs)] // documentation missing in model
    UserRequest,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClusterStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "ALL_STEPS_COMPLETED" => ClusterStateChangeReasonCode::AllStepsCompleted,
            "BOOTSTRAP_FAILURE" => ClusterStateChangeReasonCode::BootstrapFailure,
            "INSTANCE_FAILURE" => ClusterStateChangeReasonCode::InstanceFailure,
            "INSTANCE_FLEET_TIMEOUT" => ClusterStateChangeReasonCode::InstanceFleetTimeout,
            "INTERNAL_ERROR" => ClusterStateChangeReasonCode::InternalError,
            "STEP_FAILURE" => ClusterStateChangeReasonCode::StepFailure,
            "USER_REQUEST" => ClusterStateChangeReasonCode::UserRequest,
            "VALIDATION_ERROR" => ClusterStateChangeReasonCode::ValidationError,
            other => ClusterStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClusterStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClusterStateChangeReasonCode::from(s))
    }
}
impl ClusterStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClusterStateChangeReasonCode::AllStepsCompleted => "ALL_STEPS_COMPLETED",
            ClusterStateChangeReasonCode::BootstrapFailure => "BOOTSTRAP_FAILURE",
            ClusterStateChangeReasonCode::InstanceFailure => "INSTANCE_FAILURE",
            ClusterStateChangeReasonCode::InstanceFleetTimeout => "INSTANCE_FLEET_TIMEOUT",
            ClusterStateChangeReasonCode::InternalError => "INTERNAL_ERROR",
            ClusterStateChangeReasonCode::StepFailure => "STEP_FAILURE",
            ClusterStateChangeReasonCode::UserRequest => "USER_REQUEST",
            ClusterStateChangeReasonCode::ValidationError => "VALIDATION_ERROR",
            ClusterStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL_STEPS_COMPLETED",
            "BOOTSTRAP_FAILURE",
            "INSTANCE_FAILURE",
            "INSTANCE_FLEET_TIMEOUT",
            "INTERNAL_ERROR",
            "STEP_FAILURE",
            "USER_REQUEST",
            "VALIDATION_ERROR",
        ]
    }
}
impl AsRef<str> for ClusterStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClusterState {
    #[allow(missing_docs)] // documentation missing in model
    Bootstrapping,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    TerminatedWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    #[allow(missing_docs)] // documentation missing in model
    Waiting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClusterState {
    fn from(s: &str) -> Self {
        match s {
            "BOOTSTRAPPING" => ClusterState::Bootstrapping,
            "RUNNING" => ClusterState::Running,
            "STARTING" => ClusterState::Starting,
            "TERMINATED" => ClusterState::Terminated,
            "TERMINATED_WITH_ERRORS" => ClusterState::TerminatedWithErrors,
            "TERMINATING" => ClusterState::Terminating,
            "WAITING" => ClusterState::Waiting,
            other => ClusterState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClusterState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClusterState::from(s))
    }
}
impl ClusterState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClusterState::Bootstrapping => "BOOTSTRAPPING",
            ClusterState::Running => "RUNNING",
            ClusterState::Starting => "STARTING",
            ClusterState::Terminated => "TERMINATED",
            ClusterState::TerminatedWithErrors => "TERMINATED_WITH_ERRORS",
            ClusterState::Terminating => "TERMINATING",
            ClusterState::Waiting => "WAITING",
            ClusterState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOOTSTRAPPING",
            "RUNNING",
            "STARTING",
            "TERMINATED",
            "TERMINATED_WITH_ERRORS",
            "TERMINATING",
            "WAITING",
        ]
    }
}
impl AsRef<str> for ClusterState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An entity describing an executable that runs on a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Command {
    /// <p>The name of the command.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of the command script.</p>
    pub script_path: std::option::Option<std::string::String>,
    /// <p>Arguments for Amazon EMR to pass to the command for execution.</p>
    pub args: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Command {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Command");
        formatter.field("name", &self.name);
        formatter.field("script_path", &self.script_path);
        formatter.field("args", &self.args);
        formatter.finish()
    }
}
/// See [`Command`](crate::model::Command)
pub mod command {
    /// A builder for [`Command`](crate::model::Command)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) script_path: std::option::Option<std::string::String>,
        pub(crate) args: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the command.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the command.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon S3 location of the command script.</p>
        pub fn script_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of the command script.</p>
        pub fn set_script_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_path = input;
            self
        }
        /// Appends an item to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>Arguments for Amazon EMR to pass to the command for execution.</p>
        pub fn args(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.args.unwrap_or_default();
            v.push(input.into());
            self.args = Some(v);
            self
        }
        /// <p>Arguments for Amazon EMR to pass to the command for execution.</p>
        pub fn set_args(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.args = input;
            self
        }
        /// Consumes the builder and constructs a [`Command`](crate::model::Command)
        pub fn build(self) -> crate::model::Command {
            crate::model::Command {
                name: self.name,
                script_path: self.script_path,
                args: self.args,
            }
        }
    }
}
impl Command {
    /// Creates a new builder-style object to manufacture [`Command`](crate::model::Command)
    pub fn builder() -> crate::model::command::Builder {
        crate::model::command::Builder::default()
    }
}

/// <p>Details for an Amazon EMR Studio session mapping including creation time, user or group
/// ID, Studio ID, and so on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionMappingDetail {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The globally unique identifier (GUID) of the user or group.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API
    /// Reference</i>.</p>
    pub identity_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The Amazon Resource Name (ARN) of the session policy associated with the user or
    /// group.</p>
    pub session_policy_arn: std::option::Option<std::string::String>,
    /// <p>The time the session mapping was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the session mapping was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SessionMappingDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionMappingDetail");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_name", &self.identity_name);
        formatter.field("identity_type", &self.identity_type);
        formatter.field("session_policy_arn", &self.session_policy_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`SessionMappingDetail`](crate::model::SessionMappingDetail)
pub mod session_mapping_detail {
    /// A builder for [`SessionMappingDetail`](crate::model::SessionMappingDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_name: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) session_policy_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The globally unique identifier (GUID) of the user or group.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API
        /// Reference</i>.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_name = Some(input.into());
            self
        }
        /// <p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API
        /// Reference</i>.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_name = input;
            self
        }
        /// <p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy associated with the user or
        /// group.</p>
        pub fn session_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session policy associated with the user or
        /// group.</p>
        pub fn set_session_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_policy_arn = input;
            self
        }
        /// <p>The time the session mapping was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the session mapping was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the session mapping was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time the session mapping was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionMappingDetail`](crate::model::SessionMappingDetail)
        pub fn build(self) -> crate::model::SessionMappingDetail {
            crate::model::SessionMappingDetail {
                studio_id: self.studio_id,
                identity_id: self.identity_id,
                identity_name: self.identity_name,
                identity_type: self.identity_type,
                session_policy_arn: self.session_policy_arn,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl SessionMappingDetail {
    /// Creates a new builder-style object to manufacture [`SessionMappingDetail`](crate::model::SessionMappingDetail)
    pub fn builder() -> crate::model::session_mapping_detail::Builder {
        crate::model::session_mapping_detail::Builder::default()
    }
}

/// <p>Properties that describe the Amazon Web Services principal that created the
/// <code>BlockPublicAccessConfiguration</code> using the
/// <code>PutBlockPublicAccessConfiguration</code> action as well as the date and time that
/// the configuration was created. Each time a configuration for block public access is
/// updated, Amazon EMR updates this metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockPublicAccessConfigurationMetadata {
    /// <p>The date and time that the configuration was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name that created or last modified the configuration.</p>
    pub created_by_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BlockPublicAccessConfigurationMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockPublicAccessConfigurationMetadata");
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("created_by_arn", &self.created_by_arn);
        formatter.finish()
    }
}
/// See [`BlockPublicAccessConfigurationMetadata`](crate::model::BlockPublicAccessConfigurationMetadata)
pub mod block_public_access_configuration_metadata {
    /// A builder for [`BlockPublicAccessConfigurationMetadata`](crate::model::BlockPublicAccessConfigurationMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time that the configuration was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the configuration was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The Amazon Resource Name that created or last modified the configuration.</p>
        pub fn created_by_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name that created or last modified the configuration.</p>
        pub fn set_created_by_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockPublicAccessConfigurationMetadata`](crate::model::BlockPublicAccessConfigurationMetadata)
        pub fn build(self) -> crate::model::BlockPublicAccessConfigurationMetadata {
            crate::model::BlockPublicAccessConfigurationMetadata {
                creation_date_time: self.creation_date_time,
                created_by_arn: self.created_by_arn,
            }
        }
    }
}
impl BlockPublicAccessConfigurationMetadata {
    /// Creates a new builder-style object to manufacture [`BlockPublicAccessConfigurationMetadata`](crate::model::BlockPublicAccessConfigurationMetadata)
    pub fn builder() -> crate::model::block_public_access_configuration_metadata::Builder {
        crate::model::block_public_access_configuration_metadata::Builder::default()
    }
}

/// <p>Details for an Amazon EMR Studio including ID, creation time, name, and so on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Studio {
    /// <p>The ID of the Amazon EMR Studio.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon EMR Studio.</p>
    pub studio_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon EMR Studio.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The detailed description of the Amazon EMR Studio.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Amazon EMR Studio authenticates users using IAM or Amazon Web Services SSO.</p>
    pub auth_mode: std::option::Option<crate::model::AuthMode>,
    /// <p>The ID of the VPC associated with the Amazon EMR Studio.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The list of IDs of the subnets associated with the Amazon EMR Studio.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the IAM role assumed by the Amazon EMR Studio.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>The name of the IAM role assumed by users logged in to the Amazon EMR Studio. A Studio only requires a <code>UserRole</code> when you use IAM authentication.</p>
    pub user_role: std::option::Option<std::string::String>,
    /// <p>The ID of the Workspace security group associated with the Amazon EMR Studio. The
    /// Workspace security group allows outbound network traffic to resources in the Engine
    /// security group and to the internet.</p>
    pub workspace_security_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Engine security group associated with the Amazon EMR Studio. The Engine
    /// security group allows inbound network traffic from resources in the Workspace security
    /// group.</p>
    pub engine_security_group_id: std::option::Option<std::string::String>,
    /// <p>The unique access URL of the Amazon EMR Studio.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The time the Amazon EMR Studio was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook
    /// files.</p>
    pub default_s3_location: std::option::Option<std::string::String>,
    /// <p>Your identity provider's authentication endpoint. Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.</p>
    pub idp_auth_url: std::option::Option<std::string::String>,
    /// <p>The name of your identity provider's <code>RelayState</code> parameter.</p>
    pub idp_relay_state_parameter_name: std::option::Option<std::string::String>,
    /// <p>A list of tags associated with the Amazon EMR Studio.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for Studio {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Studio");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("studio_arn", &self.studio_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("auth_mode", &self.auth_mode);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("service_role", &self.service_role);
        formatter.field("user_role", &self.user_role);
        formatter.field(
            "workspace_security_group_id",
            &self.workspace_security_group_id,
        );
        formatter.field("engine_security_group_id", &self.engine_security_group_id);
        formatter.field("url", &self.url);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("default_s3_location", &self.default_s3_location);
        formatter.field("idp_auth_url", &self.idp_auth_url);
        formatter.field(
            "idp_relay_state_parameter_name",
            &self.idp_relay_state_parameter_name,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Studio`](crate::model::Studio)
pub mod studio {
    /// A builder for [`Studio`](crate::model::Studio)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) studio_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) auth_mode: std::option::Option<crate::model::AuthMode>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) user_role: std::option::Option<std::string::String>,
        pub(crate) workspace_security_group_id: std::option::Option<std::string::String>,
        pub(crate) engine_security_group_id: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) default_s3_location: std::option::Option<std::string::String>,
        pub(crate) idp_auth_url: std::option::Option<std::string::String>,
        pub(crate) idp_relay_state_parameter_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EMR Studio.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon EMR Studio.</p>
        pub fn studio_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon EMR Studio.</p>
        pub fn set_studio_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_arn = input;
            self
        }
        /// <p>The name of the Amazon EMR Studio.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EMR Studio.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The detailed description of the Amazon EMR Studio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The detailed description of the Amazon EMR Studio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether the Amazon EMR Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.auth_mode = Some(input);
            self
        }
        /// <p>Specifies whether the Amazon EMR Studio authenticates users using IAM or Amazon Web Services SSO.</p>
        pub fn set_auth_mode(mut self, input: std::option::Option<crate::model::AuthMode>) -> Self {
            self.auth_mode = input;
            self
        }
        /// <p>The ID of the VPC associated with the Amazon EMR Studio.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC associated with the Amazon EMR Studio.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The list of IDs of the subnets associated with the Amazon EMR Studio.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The list of IDs of the subnets associated with the Amazon EMR Studio.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The name of the IAM role assumed by the Amazon EMR Studio.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The name of the IAM role assumed by the Amazon EMR Studio.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>The name of the IAM role assumed by users logged in to the Amazon EMR Studio. A Studio only requires a <code>UserRole</code> when you use IAM authentication.</p>
        pub fn user_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_role = Some(input.into());
            self
        }
        /// <p>The name of the IAM role assumed by users logged in to the Amazon EMR Studio. A Studio only requires a <code>UserRole</code> when you use IAM authentication.</p>
        pub fn set_user_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_role = input;
            self
        }
        /// <p>The ID of the Workspace security group associated with the Amazon EMR Studio. The
        /// Workspace security group allows outbound network traffic to resources in the Engine
        /// security group and to the internet.</p>
        pub fn workspace_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.workspace_security_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the Workspace security group associated with the Amazon EMR Studio. The
        /// Workspace security group allows outbound network traffic to resources in the Engine
        /// security group and to the internet.</p>
        pub fn set_workspace_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_security_group_id = input;
            self
        }
        /// <p>The ID of the Engine security group associated with the Amazon EMR Studio. The Engine
        /// security group allows inbound network traffic from resources in the Workspace security
        /// group.</p>
        pub fn engine_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_security_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the Engine security group associated with the Amazon EMR Studio. The Engine
        /// security group allows inbound network traffic from resources in the Workspace security
        /// group.</p>
        pub fn set_engine_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_security_group_id = input;
            self
        }
        /// <p>The unique access URL of the Amazon EMR Studio.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The unique access URL of the Amazon EMR Studio.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The time the Amazon EMR Studio was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the Amazon EMR Studio was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook
        /// files.</p>
        pub fn default_s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_s3_location = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook
        /// files.</p>
        pub fn set_default_s3_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_s3_location = input;
            self
        }
        /// <p>Your identity provider's authentication endpoint. Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.</p>
        pub fn idp_auth_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.idp_auth_url = Some(input.into());
            self
        }
        /// <p>Your identity provider's authentication endpoint. Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.</p>
        pub fn set_idp_auth_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.idp_auth_url = input;
            self
        }
        /// <p>The name of your identity provider's <code>RelayState</code> parameter.</p>
        pub fn idp_relay_state_parameter_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.idp_relay_state_parameter_name = Some(input.into());
            self
        }
        /// <p>The name of your identity provider's <code>RelayState</code> parameter.</p>
        pub fn set_idp_relay_state_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idp_relay_state_parameter_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the Amazon EMR Studio.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with the Amazon EMR Studio.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Studio`](crate::model::Studio)
        pub fn build(self) -> crate::model::Studio {
            crate::model::Studio {
                studio_id: self.studio_id,
                studio_arn: self.studio_arn,
                name: self.name,
                description: self.description,
                auth_mode: self.auth_mode,
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                service_role: self.service_role,
                user_role: self.user_role,
                workspace_security_group_id: self.workspace_security_group_id,
                engine_security_group_id: self.engine_security_group_id,
                url: self.url,
                creation_time: self.creation_time,
                default_s3_location: self.default_s3_location,
                idp_auth_url: self.idp_auth_url,
                idp_relay_state_parameter_name: self.idp_relay_state_parameter_name,
                tags: self.tags,
            }
        }
    }
}
impl Studio {
    /// Creates a new builder-style object to manufacture [`Studio`](crate::model::Studio)
    pub fn builder() -> crate::model::studio::Builder {
        crate::model::studio::Builder::default()
    }
}

/// <p>This represents a step in a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Step {
    /// <p>The identifier of the cluster step.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the cluster step.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Hadoop job configuration of the cluster step.</p>
    pub config: std::option::Option<crate::model::HadoopStepConfig>,
    /// <p>The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
    /// <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility.
    /// We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
    /// <p>If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p>
    /// <p>If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>
    pub action_on_failure: std::option::Option<crate::model::ActionOnFailure>,
    /// <p>The current execution status details of the cluster step.</p>
    pub status: std::option::Option<crate::model::StepStatus>,
}
impl std::fmt::Debug for Step {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Step");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("config", &self.config);
        formatter.field("action_on_failure", &self.action_on_failure);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Step`](crate::model::Step)
pub mod step {
    /// A builder for [`Step`](crate::model::Step)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) config: std::option::Option<crate::model::HadoopStepConfig>,
        pub(crate) action_on_failure: std::option::Option<crate::model::ActionOnFailure>,
        pub(crate) status: std::option::Option<crate::model::StepStatus>,
    }
    impl Builder {
        /// <p>The identifier of the cluster step.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster step.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the cluster step.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster step.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Hadoop job configuration of the cluster step.</p>
        pub fn config(mut self, input: crate::model::HadoopStepConfig) -> Self {
            self.config = Some(input);
            self
        }
        /// <p>The Hadoop job configuration of the cluster step.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::HadoopStepConfig>,
        ) -> Self {
            self.config = input;
            self
        }
        /// <p>The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
        /// <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility.
        /// We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
        /// <p>If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p>
        /// <p>If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>
        pub fn action_on_failure(mut self, input: crate::model::ActionOnFailure) -> Self {
            self.action_on_failure = Some(input);
            self
        }
        /// <p>The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
        /// <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility.
        /// We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
        /// <p>If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p>
        /// <p>If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>
        pub fn set_action_on_failure(
            mut self,
            input: std::option::Option<crate::model::ActionOnFailure>,
        ) -> Self {
            self.action_on_failure = input;
            self
        }
        /// <p>The current execution status details of the cluster step.</p>
        pub fn status(mut self, input: crate::model::StepStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current execution status details of the cluster step.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StepStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Step`](crate::model::Step)
        pub fn build(self) -> crate::model::Step {
            crate::model::Step {
                id: self.id,
                name: self.name,
                config: self.config,
                action_on_failure: self.action_on_failure,
                status: self.status,
            }
        }
    }
}
impl Step {
    /// Creates a new builder-style object to manufacture [`Step`](crate::model::Step)
    pub fn builder() -> crate::model::step::Builder {
        crate::model::step::Builder::default()
    }
}

/// <p>The returned release label application names or versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimplifiedApplication {
    /// <p>The returned release label application name. For example, <code>hadoop</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The returned release label application version. For example, <code>3.2.1</code>.</p>
    pub version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SimplifiedApplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimplifiedApplication");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`SimplifiedApplication`](crate::model::SimplifiedApplication)
pub mod simplified_application {
    /// A builder for [`SimplifiedApplication`](crate::model::SimplifiedApplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The returned release label application name. For example, <code>hadoop</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The returned release label application name. For example, <code>hadoop</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The returned release label application version. For example, <code>3.2.1</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The returned release label application version. For example, <code>3.2.1</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`SimplifiedApplication`](crate::model::SimplifiedApplication)
        pub fn build(self) -> crate::model::SimplifiedApplication {
            crate::model::SimplifiedApplication {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl SimplifiedApplication {
    /// Creates a new builder-style object to manufacture [`SimplifiedApplication`](crate::model::SimplifiedApplication)
    pub fn builder() -> crate::model::simplified_application::Builder {
        crate::model::simplified_application::Builder::default()
    }
}

/// <p>A notebook execution. An execution is a specific instance that an EMR Notebook is run
/// using the <code>StartNotebookExecution</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotebookExecution {
    /// <p>The unique identifier of a notebook execution.</p>
    pub notebook_execution_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the EMR Notebook that is used for the notebook
    /// execution.</p>
    pub editor_id: std::option::Option<std::string::String>,
    /// <p>The execution engine, such as an EMR cluster, used to run the EMR notebook and perform
    /// the notebook execution.</p>
    pub execution_engine: std::option::Option<crate::model::ExecutionEngineConfig>,
    /// <p>A name for the notebook execution.</p>
    pub notebook_execution_name: std::option::Option<std::string::String>,
    /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for
    /// execution.</p>
    pub notebook_params: std::option::Option<std::string::String>,
    /// <p>The status of the notebook execution.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>START_PENDING</code> indicates that the cluster has received the execution
    /// request but execution has not begun.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STARTING</code> indicates that the execution is starting on the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RUNNING</code> indicates that the execution is being processed by the
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHING</code> indicates that execution processing is in the final
    /// stages.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FINISHED</code> indicates that the execution has completed without
    /// error.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILING</code> indicates that the execution is failing and will not finish
    /// successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> indicates that the execution failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOP_PENDING</code> indicates that the cluster has received a
    /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
    /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> indicates that the execution stopped because of a
    /// <code>StopNotebookExecution</code> request.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::NotebookExecutionStatus>,
    /// <p>The timestamp when notebook execution started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when notebook execution ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the notebook execution.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The location of the notebook execution's output file in Amazon S3.</p>
    pub output_notebook_uri: std::option::Option<std::string::String>,
    /// <p>The reason for the latest status change of the notebook execution.</p>
    pub last_state_change_reason: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the EC2 security group associated with the EMR Notebook
    /// instance. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
    /// EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management
    /// Guide</i>.</p>
    pub notebook_instance_security_group_id: std::option::Option<std::string::String>,
    /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value
    /// pairs that consist of a required key string with a maximum of 128 characters and an
    /// optional value string with a maximum of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for NotebookExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotebookExecution");
        formatter.field("notebook_execution_id", &self.notebook_execution_id);
        formatter.field("editor_id", &self.editor_id);
        formatter.field("execution_engine", &self.execution_engine);
        formatter.field("notebook_execution_name", &self.notebook_execution_name);
        formatter.field("notebook_params", &self.notebook_params);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("arn", &self.arn);
        formatter.field("output_notebook_uri", &self.output_notebook_uri);
        formatter.field("last_state_change_reason", &self.last_state_change_reason);
        formatter.field(
            "notebook_instance_security_group_id",
            &self.notebook_instance_security_group_id,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NotebookExecution`](crate::model::NotebookExecution)
pub mod notebook_execution {
    /// A builder for [`NotebookExecution`](crate::model::NotebookExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_execution_id: std::option::Option<std::string::String>,
        pub(crate) editor_id: std::option::Option<std::string::String>,
        pub(crate) execution_engine: std::option::Option<crate::model::ExecutionEngineConfig>,
        pub(crate) notebook_execution_name: std::option::Option<std::string::String>,
        pub(crate) notebook_params: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NotebookExecutionStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) output_notebook_uri: std::option::Option<std::string::String>,
        pub(crate) last_state_change_reason: std::option::Option<std::string::String>,
        pub(crate) notebook_instance_security_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The unique identifier of a notebook execution.</p>
        pub fn notebook_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_execution_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a notebook execution.</p>
        pub fn set_notebook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_execution_id = input;
            self
        }
        /// <p>The unique identifier of the EMR Notebook that is used for the notebook
        /// execution.</p>
        pub fn editor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.editor_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the EMR Notebook that is used for the notebook
        /// execution.</p>
        pub fn set_editor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.editor_id = input;
            self
        }
        /// <p>The execution engine, such as an EMR cluster, used to run the EMR notebook and perform
        /// the notebook execution.</p>
        pub fn execution_engine(mut self, input: crate::model::ExecutionEngineConfig) -> Self {
            self.execution_engine = Some(input);
            self
        }
        /// <p>The execution engine, such as an EMR cluster, used to run the EMR notebook and perform
        /// the notebook execution.</p>
        pub fn set_execution_engine(
            mut self,
            input: std::option::Option<crate::model::ExecutionEngineConfig>,
        ) -> Self {
            self.execution_engine = input;
            self
        }
        /// <p>A name for the notebook execution.</p>
        pub fn notebook_execution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_execution_name = Some(input.into());
            self
        }
        /// <p>A name for the notebook execution.</p>
        pub fn set_notebook_execution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_execution_name = input;
            self
        }
        /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for
        /// execution.</p>
        pub fn notebook_params(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_params = Some(input.into());
            self
        }
        /// <p>Input parameters in JSON format passed to the EMR Notebook at runtime for
        /// execution.</p>
        pub fn set_notebook_params(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_params = input;
            self
        }
        /// <p>The status of the notebook execution.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START_PENDING</code> indicates that the cluster has received the execution
        /// request but execution has not begun.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STARTING</code> indicates that the execution is starting on the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> indicates that the execution is being processed by the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHING</code> indicates that execution processing is in the final
        /// stages.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHED</code> indicates that the execution has completed without
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILING</code> indicates that the execution is failing and will not finish
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> indicates that the execution failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_PENDING</code> indicates that the cluster has received a
        /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
        /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> indicates that the execution stopped because of a
        /// <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::NotebookExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the notebook execution.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START_PENDING</code> indicates that the cluster has received the execution
        /// request but execution has not begun.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STARTING</code> indicates that the execution is starting on the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> indicates that the execution is being processed by the
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHING</code> indicates that execution processing is in the final
        /// stages.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FINISHED</code> indicates that the execution has completed without
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILING</code> indicates that the execution is failing and will not finish
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> indicates that the execution failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_PENDING</code> indicates that the cluster has received a
        /// <code>StopNotebookExecution</code> request and the stop is pending.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPING</code> indicates that the cluster is in the process of stopping the
        /// execution as a result of a <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> indicates that the execution stopped because of a
        /// <code>StopNotebookExecution</code> request.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotebookExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp when notebook execution started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp when notebook execution started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp when notebook execution ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The timestamp when notebook execution ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notebook execution.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notebook execution.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The location of the notebook execution's output file in Amazon S3.</p>
        pub fn output_notebook_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_notebook_uri = Some(input.into());
            self
        }
        /// <p>The location of the notebook execution's output file in Amazon S3.</p>
        pub fn set_output_notebook_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_notebook_uri = input;
            self
        }
        /// <p>The reason for the latest status change of the notebook execution.</p>
        pub fn last_state_change_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_state_change_reason = Some(input.into());
            self
        }
        /// <p>The reason for the latest status change of the notebook execution.</p>
        pub fn set_last_state_change_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_state_change_reason = input;
            self
        }
        /// <p>The unique identifier of the EC2 security group associated with the EMR Notebook
        /// instance. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
        /// EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management
        /// Guide</i>.</p>
        pub fn notebook_instance_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notebook_instance_security_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the EC2 security group associated with the EMR Notebook
        /// instance. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
        /// EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management
        /// Guide</i>.</p>
        pub fn set_notebook_instance_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_security_group_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value
        /// pairs that consist of a required key string with a maximum of 128 characters and an
        /// optional value string with a maximum of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with a notebook execution. Tags are user-defined key-value
        /// pairs that consist of a required key string with a maximum of 128 characters and an
        /// optional value string with a maximum of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NotebookExecution`](crate::model::NotebookExecution)
        pub fn build(self) -> crate::model::NotebookExecution {
            crate::model::NotebookExecution {
                notebook_execution_id: self.notebook_execution_id,
                editor_id: self.editor_id,
                execution_engine: self.execution_engine,
                notebook_execution_name: self.notebook_execution_name,
                notebook_params: self.notebook_params,
                status: self.status,
                start_time: self.start_time,
                end_time: self.end_time,
                arn: self.arn,
                output_notebook_uri: self.output_notebook_uri,
                last_state_change_reason: self.last_state_change_reason,
                notebook_instance_security_group_id: self.notebook_instance_security_group_id,
                tags: self.tags,
            }
        }
    }
}
impl NotebookExecution {
    /// Creates a new builder-style object to manufacture [`NotebookExecution`](crate::model::NotebookExecution)
    pub fn builder() -> crate::model::notebook_execution::Builder {
        crate::model::notebook_execution::Builder::default()
    }
}

/// <p>A description of a cluster (job flow).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobFlowDetail {
    /// <p>The job flow identifier.</p>
    pub job_flow_id: std::option::Option<std::string::String>,
    /// <p>The name of the job flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The location in Amazon S3 where log files for the job are stored.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>The KMS key used for encrypting log files. This attribute is
    /// only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.</p>
    pub log_encryption_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
    /// later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use
    /// <code>CustomAmiID</code>.</p>
    pub ami_version: std::option::Option<std::string::String>,
    /// <p>Describes the execution status of the job flow.</p>
    pub execution_status_detail: std::option::Option<crate::model::JobFlowExecutionStatusDetail>,
    /// <p>Describes the Amazon EC2 instances of the job flow.</p>
    pub instances: std::option::Option<crate::model::JobFlowInstancesDetail>,
    /// <p>A list of steps run by the job flow.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::StepDetail>>,
    /// <p>A list of the bootstrap actions run by the job flow.</p>
    pub bootstrap_actions: std::option::Option<std::vec::Vec<crate::model::BootstrapActionDetail>>,
    /// <p>A list of strings set by third-party software when the job flow is launched. If you are
    /// not using third-party software to manage the job flow, this value is empty.</p>
    pub supported_products: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
    /// with the cluster. When <code>true</code>, IAM principals in the
    /// Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p>
    /// <p>The default value is <code>true</code> if a value is not provided when creating a
    /// cluster using the EMR API <a>RunJobFlow</a> command, the CLI
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console. IAM principals that are authorized to perform actions on the cluster can use the <a>SetVisibleToAllUsers</a> action to change the value on a running cluster. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
    pub visible_to_all_users: bool,
    /// <p>The IAM role that was specified when the job flow was launched. The EC2 instances of the
    /// job flow assume this role.</p>
    pub job_flow_role: std::option::Option<std::string::String>,
    /// <p>The IAM role that is assumed by the Amazon EMR service to access Amazon Web Services resources on your
    /// behalf.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>An IAM role for automatic scaling policies. The default role is
    /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides a way for the automatic
    /// scaling feature to get the required permissions it needs to launch and terminate EC2
    /// instances in an instance group.</p>
    pub auto_scaling_role: std::option::Option<std::string::String>,
    /// <p>The way that individual Amazon EC2 instances terminate when an automatic scale-in
    /// activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code>
    /// indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
    /// when the request to terminate the instance was submitted. This option is only available
    /// with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
    /// <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny
    /// list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
    /// the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
    /// first and blocks instance termination if it could lead to HDFS corruption.
    /// <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and
    /// later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
    pub scale_down_behavior: std::option::Option<crate::model::ScaleDownBehavior>,
}
impl std::fmt::Debug for JobFlowDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobFlowDetail");
        formatter.field("job_flow_id", &self.job_flow_id);
        formatter.field("name", &self.name);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("log_encryption_kms_key_id", &self.log_encryption_kms_key_id);
        formatter.field("ami_version", &self.ami_version);
        formatter.field("execution_status_detail", &self.execution_status_detail);
        formatter.field("instances", &self.instances);
        formatter.field("steps", &self.steps);
        formatter.field("bootstrap_actions", &self.bootstrap_actions);
        formatter.field("supported_products", &self.supported_products);
        formatter.field("visible_to_all_users", &self.visible_to_all_users);
        formatter.field("job_flow_role", &self.job_flow_role);
        formatter.field("service_role", &self.service_role);
        formatter.field("auto_scaling_role", &self.auto_scaling_role);
        formatter.field("scale_down_behavior", &self.scale_down_behavior);
        formatter.finish()
    }
}
/// See [`JobFlowDetail`](crate::model::JobFlowDetail)
pub mod job_flow_detail {
    /// A builder for [`JobFlowDetail`](crate::model::JobFlowDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_flow_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) log_encryption_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) ami_version: std::option::Option<std::string::String>,
        pub(crate) execution_status_detail:
            std::option::Option<crate::model::JobFlowExecutionStatusDetail>,
        pub(crate) instances: std::option::Option<crate::model::JobFlowInstancesDetail>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::StepDetail>>,
        pub(crate) bootstrap_actions:
            std::option::Option<std::vec::Vec<crate::model::BootstrapActionDetail>>,
        pub(crate) supported_products: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) visible_to_all_users: std::option::Option<bool>,
        pub(crate) job_flow_role: std::option::Option<std::string::String>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_role: std::option::Option<std::string::String>,
        pub(crate) scale_down_behavior: std::option::Option<crate::model::ScaleDownBehavior>,
    }
    impl Builder {
        /// <p>The job flow identifier.</p>
        pub fn job_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_flow_id = Some(input.into());
            self
        }
        /// <p>The job flow identifier.</p>
        pub fn set_job_flow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_flow_id = input;
            self
        }
        /// <p>The name of the job flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The location in Amazon S3 where log files for the job are stored.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>The location in Amazon S3 where log files for the job are stored.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>The KMS key used for encrypting log files. This attribute is
        /// only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.</p>
        pub fn log_encryption_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_encryption_kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key used for encrypting log files. This attribute is
        /// only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.</p>
        pub fn set_log_encryption_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_encryption_kms_key_id = input;
            self
        }
        /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
        /// later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use
        /// <code>CustomAmiID</code>.</p>
        pub fn ami_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_version = Some(input.into());
            self
        }
        /// <p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
        /// later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use
        /// <code>CustomAmiID</code>.</p>
        pub fn set_ami_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_version = input;
            self
        }
        /// <p>Describes the execution status of the job flow.</p>
        pub fn execution_status_detail(
            mut self,
            input: crate::model::JobFlowExecutionStatusDetail,
        ) -> Self {
            self.execution_status_detail = Some(input);
            self
        }
        /// <p>Describes the execution status of the job flow.</p>
        pub fn set_execution_status_detail(
            mut self,
            input: std::option::Option<crate::model::JobFlowExecutionStatusDetail>,
        ) -> Self {
            self.execution_status_detail = input;
            self
        }
        /// <p>Describes the Amazon EC2 instances of the job flow.</p>
        pub fn instances(mut self, input: crate::model::JobFlowInstancesDetail) -> Self {
            self.instances = Some(input);
            self
        }
        /// <p>Describes the Amazon EC2 instances of the job flow.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<crate::model::JobFlowInstancesDetail>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>A list of steps run by the job flow.</p>
        pub fn steps(mut self, input: impl Into<crate::model::StepDetail>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p>A list of steps run by the job flow.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepDetail>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Appends an item to `bootstrap_actions`.
        ///
        /// To override the contents of this collection use [`set_bootstrap_actions`](Self::set_bootstrap_actions).
        ///
        /// <p>A list of the bootstrap actions run by the job flow.</p>
        pub fn bootstrap_actions(
            mut self,
            input: impl Into<crate::model::BootstrapActionDetail>,
        ) -> Self {
            let mut v = self.bootstrap_actions.unwrap_or_default();
            v.push(input.into());
            self.bootstrap_actions = Some(v);
            self
        }
        /// <p>A list of the bootstrap actions run by the job flow.</p>
        pub fn set_bootstrap_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BootstrapActionDetail>>,
        ) -> Self {
            self.bootstrap_actions = input;
            self
        }
        /// Appends an item to `supported_products`.
        ///
        /// To override the contents of this collection use [`set_supported_products`](Self::set_supported_products).
        ///
        /// <p>A list of strings set by third-party software when the job flow is launched. If you are
        /// not using third-party software to manage the job flow, this value is empty.</p>
        pub fn supported_products(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_products.unwrap_or_default();
            v.push(input.into());
            self.supported_products = Some(v);
            self
        }
        /// <p>A list of strings set by third-party software when the job flow is launched. If you are
        /// not using third-party software to manage the job flow, this value is empty.</p>
        pub fn set_supported_products(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_products = input;
            self
        }
        /// <p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
        /// with the cluster. When <code>true</code>, IAM principals in the
        /// Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p>
        /// <p>The default value is <code>true</code> if a value is not provided when creating a
        /// cluster using the EMR API <a>RunJobFlow</a> command, the CLI
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console. IAM principals that are authorized to perform actions on the cluster can use the <a>SetVisibleToAllUsers</a> action to change the value on a running cluster. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn visible_to_all_users(mut self, input: bool) -> Self {
            self.visible_to_all_users = Some(input);
            self
        }
        /// <p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
        /// with the cluster. When <code>true</code>, IAM principals in the
        /// Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p>
        /// <p>The default value is <code>true</code> if a value is not provided when creating a
        /// cluster using the EMR API <a>RunJobFlow</a> command, the CLI
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console. IAM principals that are authorized to perform actions on the cluster can use the <a>SetVisibleToAllUsers</a> action to change the value on a running cluster. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn set_visible_to_all_users(mut self, input: std::option::Option<bool>) -> Self {
            self.visible_to_all_users = input;
            self
        }
        /// <p>The IAM role that was specified when the job flow was launched. The EC2 instances of the
        /// job flow assume this role.</p>
        pub fn job_flow_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_flow_role = Some(input.into());
            self
        }
        /// <p>The IAM role that was specified when the job flow was launched. The EC2 instances of the
        /// job flow assume this role.</p>
        pub fn set_job_flow_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_flow_role = input;
            self
        }
        /// <p>The IAM role that is assumed by the Amazon EMR service to access Amazon Web Services resources on your
        /// behalf.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The IAM role that is assumed by the Amazon EMR service to access Amazon Web Services resources on your
        /// behalf.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is
        /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides a way for the automatic
        /// scaling feature to get the required permissions it needs to launch and terminate EC2
        /// instances in an instance group.</p>
        pub fn auto_scaling_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_role = Some(input.into());
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is
        /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides a way for the automatic
        /// scaling feature to get the required permissions it needs to launch and terminate EC2
        /// instances in an instance group.</p>
        pub fn set_auto_scaling_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_role = input;
            self
        }
        /// <p>The way that individual Amazon EC2 instances terminate when an automatic scale-in
        /// activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code>
        /// indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
        /// when the request to terminate the instance was submitted. This option is only available
        /// with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny
        /// list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
        /// the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
        /// first and blocks instance termination if it could lead to HDFS corruption.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and
        /// later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
        pub fn scale_down_behavior(mut self, input: crate::model::ScaleDownBehavior) -> Self {
            self.scale_down_behavior = Some(input);
            self
        }
        /// <p>The way that individual Amazon EC2 instances terminate when an automatic scale-in
        /// activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code>
        /// indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
        /// when the request to terminate the instance was submitted. This option is only available
        /// with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny
        /// list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
        /// the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
        /// first and blocks instance termination if it could lead to HDFS corruption.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and
        /// later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
        pub fn set_scale_down_behavior(
            mut self,
            input: std::option::Option<crate::model::ScaleDownBehavior>,
        ) -> Self {
            self.scale_down_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`JobFlowDetail`](crate::model::JobFlowDetail)
        pub fn build(self) -> crate::model::JobFlowDetail {
            crate::model::JobFlowDetail {
                job_flow_id: self.job_flow_id,
                name: self.name,
                log_uri: self.log_uri,
                log_encryption_kms_key_id: self.log_encryption_kms_key_id,
                ami_version: self.ami_version,
                execution_status_detail: self.execution_status_detail,
                instances: self.instances,
                steps: self.steps,
                bootstrap_actions: self.bootstrap_actions,
                supported_products: self.supported_products,
                visible_to_all_users: self.visible_to_all_users.unwrap_or_default(),
                job_flow_role: self.job_flow_role,
                service_role: self.service_role,
                auto_scaling_role: self.auto_scaling_role,
                scale_down_behavior: self.scale_down_behavior,
            }
        }
    }
}
impl JobFlowDetail {
    /// Creates a new builder-style object to manufacture [`JobFlowDetail`](crate::model::JobFlowDetail)
    pub fn builder() -> crate::model::job_flow_detail::Builder {
        crate::model::job_flow_detail::Builder::default()
    }
}

/// <p>Reports the configuration of a bootstrap action in a cluster (job flow).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BootstrapActionDetail {
    /// <p>A description of the bootstrap action.</p>
    pub bootstrap_action_config: std::option::Option<crate::model::BootstrapActionConfig>,
}
impl std::fmt::Debug for BootstrapActionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BootstrapActionDetail");
        formatter.field("bootstrap_action_config", &self.bootstrap_action_config);
        formatter.finish()
    }
}
/// See [`BootstrapActionDetail`](crate::model::BootstrapActionDetail)
pub mod bootstrap_action_detail {
    /// A builder for [`BootstrapActionDetail`](crate::model::BootstrapActionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bootstrap_action_config:
            std::option::Option<crate::model::BootstrapActionConfig>,
    }
    impl Builder {
        /// <p>A description of the bootstrap action.</p>
        pub fn bootstrap_action_config(
            mut self,
            input: crate::model::BootstrapActionConfig,
        ) -> Self {
            self.bootstrap_action_config = Some(input);
            self
        }
        /// <p>A description of the bootstrap action.</p>
        pub fn set_bootstrap_action_config(
            mut self,
            input: std::option::Option<crate::model::BootstrapActionConfig>,
        ) -> Self {
            self.bootstrap_action_config = input;
            self
        }
        /// Consumes the builder and constructs a [`BootstrapActionDetail`](crate::model::BootstrapActionDetail)
        pub fn build(self) -> crate::model::BootstrapActionDetail {
            crate::model::BootstrapActionDetail {
                bootstrap_action_config: self.bootstrap_action_config,
            }
        }
    }
}
impl BootstrapActionDetail {
    /// Creates a new builder-style object to manufacture [`BootstrapActionDetail`](crate::model::BootstrapActionDetail)
    pub fn builder() -> crate::model::bootstrap_action_detail::Builder {
        crate::model::bootstrap_action_detail::Builder::default()
    }
}

/// <p>Combines the execution state and configuration of a step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepDetail {
    /// <p>The step configuration.</p>
    pub step_config: std::option::Option<crate::model::StepConfig>,
    /// <p>The description of the step status.</p>
    pub execution_status_detail: std::option::Option<crate::model::StepExecutionStatusDetail>,
}
impl std::fmt::Debug for StepDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepDetail");
        formatter.field("step_config", &self.step_config);
        formatter.field("execution_status_detail", &self.execution_status_detail);
        formatter.finish()
    }
}
/// See [`StepDetail`](crate::model::StepDetail)
pub mod step_detail {
    /// A builder for [`StepDetail`](crate::model::StepDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) step_config: std::option::Option<crate::model::StepConfig>,
        pub(crate) execution_status_detail:
            std::option::Option<crate::model::StepExecutionStatusDetail>,
    }
    impl Builder {
        /// <p>The step configuration.</p>
        pub fn step_config(mut self, input: crate::model::StepConfig) -> Self {
            self.step_config = Some(input);
            self
        }
        /// <p>The step configuration.</p>
        pub fn set_step_config(
            mut self,
            input: std::option::Option<crate::model::StepConfig>,
        ) -> Self {
            self.step_config = input;
            self
        }
        /// <p>The description of the step status.</p>
        pub fn execution_status_detail(
            mut self,
            input: crate::model::StepExecutionStatusDetail,
        ) -> Self {
            self.execution_status_detail = Some(input);
            self
        }
        /// <p>The description of the step status.</p>
        pub fn set_execution_status_detail(
            mut self,
            input: std::option::Option<crate::model::StepExecutionStatusDetail>,
        ) -> Self {
            self.execution_status_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`StepDetail`](crate::model::StepDetail)
        pub fn build(self) -> crate::model::StepDetail {
            crate::model::StepDetail {
                step_config: self.step_config,
                execution_status_detail: self.execution_status_detail,
            }
        }
    }
}
impl StepDetail {
    /// Creates a new builder-style object to manufacture [`StepDetail`](crate::model::StepDetail)
    pub fn builder() -> crate::model::step_detail::Builder {
        crate::model::step_detail::Builder::default()
    }
}

/// <p>The execution state of a step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepExecutionStatusDetail {
    /// <p>The state of the step.</p>
    pub state: std::option::Option<crate::model::StepExecutionState>,
    /// <p>The creation date and time of the step.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The start date and time of the step.</p>
    pub start_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The completion date and time of the step.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A description of the step's current state.</p>
    pub last_state_change_reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StepExecutionStatusDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepExecutionStatusDetail");
        formatter.field("state", &self.state);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.field("last_state_change_reason", &self.last_state_change_reason);
        formatter.finish()
    }
}
/// See [`StepExecutionStatusDetail`](crate::model::StepExecutionStatusDetail)
pub mod step_execution_status_detail {
    /// A builder for [`StepExecutionStatusDetail`](crate::model::StepExecutionStatusDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::StepExecutionState>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_state_change_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the step.</p>
        pub fn state(mut self, input: crate::model::StepExecutionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the step.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::StepExecutionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The creation date and time of the step.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time of the step.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The start date and time of the step.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date_time = Some(input);
            self
        }
        /// <p>The start date and time of the step.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>The completion date and time of the step.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The completion date and time of the step.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// <p>A description of the step's current state.</p>
        pub fn last_state_change_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_state_change_reason = Some(input.into());
            self
        }
        /// <p>A description of the step's current state.</p>
        pub fn set_last_state_change_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_state_change_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`StepExecutionStatusDetail`](crate::model::StepExecutionStatusDetail)
        pub fn build(self) -> crate::model::StepExecutionStatusDetail {
            crate::model::StepExecutionStatusDetail {
                state: self.state,
                creation_date_time: self.creation_date_time,
                start_date_time: self.start_date_time,
                end_date_time: self.end_date_time,
                last_state_change_reason: self.last_state_change_reason,
            }
        }
    }
}
impl StepExecutionStatusDetail {
    /// Creates a new builder-style object to manufacture [`StepExecutionStatusDetail`](crate::model::StepExecutionStatusDetail)
    pub fn builder() -> crate::model::step_execution_status_detail::Builder {
        crate::model::step_execution_status_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StepExecutionState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Continue,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Interrupted,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StepExecutionState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => StepExecutionState::Cancelled,
            "COMPLETED" => StepExecutionState::Completed,
            "CONTINUE" => StepExecutionState::Continue,
            "FAILED" => StepExecutionState::Failed,
            "INTERRUPTED" => StepExecutionState::Interrupted,
            "PENDING" => StepExecutionState::Pending,
            "RUNNING" => StepExecutionState::Running,
            other => StepExecutionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StepExecutionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StepExecutionState::from(s))
    }
}
impl StepExecutionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StepExecutionState::Cancelled => "CANCELLED",
            StepExecutionState::Completed => "COMPLETED",
            StepExecutionState::Continue => "CONTINUE",
            StepExecutionState::Failed => "FAILED",
            StepExecutionState::Interrupted => "INTERRUPTED",
            StepExecutionState::Pending => "PENDING",
            StepExecutionState::Running => "RUNNING",
            StepExecutionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "COMPLETED",
            "CONTINUE",
            "FAILED",
            "INTERRUPTED",
            "PENDING",
            "RUNNING",
        ]
    }
}
impl AsRef<str> for StepExecutionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specify the type of Amazon EC2 instances that the cluster (job flow) runs on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobFlowInstancesDetail {
    /// <p>The Amazon EC2 master node instance type.</p>
    pub master_instance_type: std::option::Option<std::string::String>,
    /// <p>The DNS name of the master node. If the cluster is on a private subnet, this is the
    /// private DNS name. On a public subnet, this is the public DNS name.</p>
    pub master_public_dns_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 instance identifier of the master node.</p>
    pub master_instance_id: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 core and task node instance type.</p>
    pub slave_instance_type: std::option::Option<std::string::String>,
    /// <p>The number of Amazon EC2 instances in the cluster. If the value is 1, the same instance
    /// serves as both the master and core and task node. If the value is greater than 1, one
    /// instance is the master node and all others are core and task nodes.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>Details about the instance groups in a cluster.</p>
    pub instance_groups: std::option::Option<std::vec::Vec<crate::model::InstanceGroupDetail>>,
    /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
    /// is increased one time for every hour that an m1.small instance runs. Larger instances are
    /// weighted more heavily, so an Amazon EC2 instance that is roughly four times more expensive
    /// would result in the normalized instance hours being increased incrementally four times.
    /// This result is only an approximation and does not reflect the actual billing rate.</p>
    pub normalized_instance_hours: std::option::Option<i32>,
    /// <p>The name of an Amazon EC2 key pair that can be used to connect to the master node using
    /// SSH.</p>
    pub ec2_key_name: std::option::Option<std::string::String>,
    /// <p>For clusters launched within Amazon Virtual Private Cloud, this is the identifier of the
    /// subnet where the cluster was launched.</p>
    pub ec2_subnet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 Availability Zone for the cluster.</p>
    pub placement: std::option::Option<crate::model::PlacementType>,
    /// <p>Specifies whether the cluster should remain available after completing all steps.</p>
    pub keep_job_flow_alive_when_no_steps: bool,
    /// <p>Specifies whether the Amazon EC2 instances in the cluster are protected from termination
    /// by API calls, user intervention, or in the event of a job-flow error.</p>
    pub termination_protected: bool,
    /// <p>The Hadoop version for the cluster.</p>
    pub hadoop_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobFlowInstancesDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobFlowInstancesDetail");
        formatter.field("master_instance_type", &self.master_instance_type);
        formatter.field("master_public_dns_name", &self.master_public_dns_name);
        formatter.field("master_instance_id", &self.master_instance_id);
        formatter.field("slave_instance_type", &self.slave_instance_type);
        formatter.field("instance_count", &self.instance_count);
        formatter.field("instance_groups", &self.instance_groups);
        formatter.field("normalized_instance_hours", &self.normalized_instance_hours);
        formatter.field("ec2_key_name", &self.ec2_key_name);
        formatter.field("ec2_subnet_id", &self.ec2_subnet_id);
        formatter.field("placement", &self.placement);
        formatter.field(
            "keep_job_flow_alive_when_no_steps",
            &self.keep_job_flow_alive_when_no_steps,
        );
        formatter.field("termination_protected", &self.termination_protected);
        formatter.field("hadoop_version", &self.hadoop_version);
        formatter.finish()
    }
}
/// See [`JobFlowInstancesDetail`](crate::model::JobFlowInstancesDetail)
pub mod job_flow_instances_detail {
    /// A builder for [`JobFlowInstancesDetail`](crate::model::JobFlowInstancesDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) master_instance_type: std::option::Option<std::string::String>,
        pub(crate) master_public_dns_name: std::option::Option<std::string::String>,
        pub(crate) master_instance_id: std::option::Option<std::string::String>,
        pub(crate) slave_instance_type: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) instance_groups:
            std::option::Option<std::vec::Vec<crate::model::InstanceGroupDetail>>,
        pub(crate) normalized_instance_hours: std::option::Option<i32>,
        pub(crate) ec2_key_name: std::option::Option<std::string::String>,
        pub(crate) ec2_subnet_id: std::option::Option<std::string::String>,
        pub(crate) placement: std::option::Option<crate::model::PlacementType>,
        pub(crate) keep_job_flow_alive_when_no_steps: std::option::Option<bool>,
        pub(crate) termination_protected: std::option::Option<bool>,
        pub(crate) hadoop_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EC2 master node instance type.</p>
        pub fn master_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_instance_type = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 master node instance type.</p>
        pub fn set_master_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_instance_type = input;
            self
        }
        /// <p>The DNS name of the master node. If the cluster is on a private subnet, this is the
        /// private DNS name. On a public subnet, this is the public DNS name.</p>
        pub fn master_public_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_public_dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name of the master node. If the cluster is on a private subnet, this is the
        /// private DNS name. On a public subnet, this is the public DNS name.</p>
        pub fn set_master_public_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_public_dns_name = input;
            self
        }
        /// <p>The Amazon EC2 instance identifier of the master node.</p>
        pub fn master_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_instance_id = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 instance identifier of the master node.</p>
        pub fn set_master_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_instance_id = input;
            self
        }
        /// <p>The Amazon EC2 core and task node instance type.</p>
        pub fn slave_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.slave_instance_type = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 core and task node instance type.</p>
        pub fn set_slave_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slave_instance_type = input;
            self
        }
        /// <p>The number of Amazon EC2 instances in the cluster. If the value is 1, the same instance
        /// serves as both the master and core and task node. If the value is greater than 1, one
        /// instance is the master node and all others are core and task nodes.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of Amazon EC2 instances in the cluster. If the value is 1, the same instance
        /// serves as both the master and core and task node. If the value is greater than 1, one
        /// instance is the master node and all others are core and task nodes.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// Appends an item to `instance_groups`.
        ///
        /// To override the contents of this collection use [`set_instance_groups`](Self::set_instance_groups).
        ///
        /// <p>Details about the instance groups in a cluster.</p>
        pub fn instance_groups(
            mut self,
            input: impl Into<crate::model::InstanceGroupDetail>,
        ) -> Self {
            let mut v = self.instance_groups.unwrap_or_default();
            v.push(input.into());
            self.instance_groups = Some(v);
            self
        }
        /// <p>Details about the instance groups in a cluster.</p>
        pub fn set_instance_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGroupDetail>>,
        ) -> Self {
            self.instance_groups = input;
            self
        }
        /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
        /// is increased one time for every hour that an m1.small instance runs. Larger instances are
        /// weighted more heavily, so an Amazon EC2 instance that is roughly four times more expensive
        /// would result in the normalized instance hours being increased incrementally four times.
        /// This result is only an approximation and does not reflect the actual billing rate.</p>
        pub fn normalized_instance_hours(mut self, input: i32) -> Self {
            self.normalized_instance_hours = Some(input);
            self
        }
        /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
        /// is increased one time for every hour that an m1.small instance runs. Larger instances are
        /// weighted more heavily, so an Amazon EC2 instance that is roughly four times more expensive
        /// would result in the normalized instance hours being increased incrementally four times.
        /// This result is only an approximation and does not reflect the actual billing rate.</p>
        pub fn set_normalized_instance_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.normalized_instance_hours = input;
            self
        }
        /// <p>The name of an Amazon EC2 key pair that can be used to connect to the master node using
        /// SSH.</p>
        pub fn ec2_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_key_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon EC2 key pair that can be used to connect to the master node using
        /// SSH.</p>
        pub fn set_ec2_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_key_name = input;
            self
        }
        /// <p>For clusters launched within Amazon Virtual Private Cloud, this is the identifier of the
        /// subnet where the cluster was launched.</p>
        pub fn ec2_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_subnet_id = Some(input.into());
            self
        }
        /// <p>For clusters launched within Amazon Virtual Private Cloud, this is the identifier of the
        /// subnet where the cluster was launched.</p>
        pub fn set_ec2_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_subnet_id = input;
            self
        }
        /// <p>The Amazon EC2 Availability Zone for the cluster.</p>
        pub fn placement(mut self, input: crate::model::PlacementType) -> Self {
            self.placement = Some(input);
            self
        }
        /// <p>The Amazon EC2 Availability Zone for the cluster.</p>
        pub fn set_placement(
            mut self,
            input: std::option::Option<crate::model::PlacementType>,
        ) -> Self {
            self.placement = input;
            self
        }
        /// <p>Specifies whether the cluster should remain available after completing all steps.</p>
        pub fn keep_job_flow_alive_when_no_steps(mut self, input: bool) -> Self {
            self.keep_job_flow_alive_when_no_steps = Some(input);
            self
        }
        /// <p>Specifies whether the cluster should remain available after completing all steps.</p>
        pub fn set_keep_job_flow_alive_when_no_steps(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.keep_job_flow_alive_when_no_steps = input;
            self
        }
        /// <p>Specifies whether the Amazon EC2 instances in the cluster are protected from termination
        /// by API calls, user intervention, or in the event of a job-flow error.</p>
        pub fn termination_protected(mut self, input: bool) -> Self {
            self.termination_protected = Some(input);
            self
        }
        /// <p>Specifies whether the Amazon EC2 instances in the cluster are protected from termination
        /// by API calls, user intervention, or in the event of a job-flow error.</p>
        pub fn set_termination_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.termination_protected = input;
            self
        }
        /// <p>The Hadoop version for the cluster.</p>
        pub fn hadoop_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.hadoop_version = Some(input.into());
            self
        }
        /// <p>The Hadoop version for the cluster.</p>
        pub fn set_hadoop_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hadoop_version = input;
            self
        }
        /// Consumes the builder and constructs a [`JobFlowInstancesDetail`](crate::model::JobFlowInstancesDetail)
        pub fn build(self) -> crate::model::JobFlowInstancesDetail {
            crate::model::JobFlowInstancesDetail {
                master_instance_type: self.master_instance_type,
                master_public_dns_name: self.master_public_dns_name,
                master_instance_id: self.master_instance_id,
                slave_instance_type: self.slave_instance_type,
                instance_count: self.instance_count,
                instance_groups: self.instance_groups,
                normalized_instance_hours: self.normalized_instance_hours,
                ec2_key_name: self.ec2_key_name,
                ec2_subnet_id: self.ec2_subnet_id,
                placement: self.placement,
                keep_job_flow_alive_when_no_steps: self
                    .keep_job_flow_alive_when_no_steps
                    .unwrap_or_default(),
                termination_protected: self.termination_protected.unwrap_or_default(),
                hadoop_version: self.hadoop_version,
            }
        }
    }
}
impl JobFlowInstancesDetail {
    /// Creates a new builder-style object to manufacture [`JobFlowInstancesDetail`](crate::model::JobFlowInstancesDetail)
    pub fn builder() -> crate::model::job_flow_instances_detail::Builder {
        crate::model::job_flow_instances_detail::Builder::default()
    }
}

/// <p>Detailed information about an instance group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceGroupDetail {
    /// <p>Unique identifier for the instance group.</p>
    pub instance_group_id: std::option::Option<std::string::String>,
    /// <p>Friendly name for the instance group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Market type of the EC2 instances used to create a cluster node.</p>
    pub market: std::option::Option<crate::model::MarketType>,
    /// <p>Instance group role in the cluster</p>
    pub instance_role: std::option::Option<crate::model::InstanceRoleType>,
    /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
    pub bid_price: std::option::Option<std::string::String>,
    /// <p>EC2 instance type.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>Target number of instances to run in the instance group.</p>
    pub instance_request_count: std::option::Option<i32>,
    /// <p>Actual count of running instances.</p>
    pub instance_running_count: std::option::Option<i32>,
    /// <p>State of instance group. The following values are deprecated: STARTING, TERMINATED, and
    /// FAILED.</p>
    pub state: std::option::Option<crate::model::InstanceGroupState>,
    /// <p>Details regarding the state of the instance group.</p>
    pub last_state_change_reason: std::option::Option<std::string::String>,
    /// <p>The date/time the instance group was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date/time the instance group was started.</p>
    pub start_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date/time the instance group was available to the cluster.</p>
    pub ready_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date/time the instance group was terminated.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The custom AMI ID to use for the provisioned instance group.</p>
    pub custom_ami_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceGroupDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceGroupDetail");
        formatter.field("instance_group_id", &self.instance_group_id);
        formatter.field("name", &self.name);
        formatter.field("market", &self.market);
        formatter.field("instance_role", &self.instance_role);
        formatter.field("bid_price", &self.bid_price);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("instance_request_count", &self.instance_request_count);
        formatter.field("instance_running_count", &self.instance_running_count);
        formatter.field("state", &self.state);
        formatter.field("last_state_change_reason", &self.last_state_change_reason);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("ready_date_time", &self.ready_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.field("custom_ami_id", &self.custom_ami_id);
        formatter.finish()
    }
}
/// See [`InstanceGroupDetail`](crate::model::InstanceGroupDetail)
pub mod instance_group_detail {
    /// A builder for [`InstanceGroupDetail`](crate::model::InstanceGroupDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) market: std::option::Option<crate::model::MarketType>,
        pub(crate) instance_role: std::option::Option<crate::model::InstanceRoleType>,
        pub(crate) bid_price: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) instance_request_count: std::option::Option<i32>,
        pub(crate) instance_running_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::InstanceGroupState>,
        pub(crate) last_state_change_reason: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ready_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) custom_ami_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique identifier for the instance group.</p>
        pub fn instance_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_group_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the instance group.</p>
        pub fn set_instance_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_group_id = input;
            self
        }
        /// <p>Friendly name for the instance group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Friendly name for the instance group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Market type of the EC2 instances used to create a cluster node.</p>
        pub fn market(mut self, input: crate::model::MarketType) -> Self {
            self.market = Some(input);
            self
        }
        /// <p>Market type of the EC2 instances used to create a cluster node.</p>
        pub fn set_market(mut self, input: std::option::Option<crate::model::MarketType>) -> Self {
            self.market = input;
            self
        }
        /// <p>Instance group role in the cluster</p>
        pub fn instance_role(mut self, input: crate::model::InstanceRoleType) -> Self {
            self.instance_role = Some(input);
            self
        }
        /// <p>Instance group role in the cluster</p>
        pub fn set_instance_role(
            mut self,
            input: std::option::Option<crate::model::InstanceRoleType>,
        ) -> Self {
            self.instance_role = input;
            self
        }
        /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
        pub fn bid_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.bid_price = Some(input.into());
            self
        }
        /// <p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>
        pub fn set_bid_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bid_price = input;
            self
        }
        /// <p>EC2 instance type.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>EC2 instance type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>Target number of instances to run in the instance group.</p>
        pub fn instance_request_count(mut self, input: i32) -> Self {
            self.instance_request_count = Some(input);
            self
        }
        /// <p>Target number of instances to run in the instance group.</p>
        pub fn set_instance_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_request_count = input;
            self
        }
        /// <p>Actual count of running instances.</p>
        pub fn instance_running_count(mut self, input: i32) -> Self {
            self.instance_running_count = Some(input);
            self
        }
        /// <p>Actual count of running instances.</p>
        pub fn set_instance_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_running_count = input;
            self
        }
        /// <p>State of instance group. The following values are deprecated: STARTING, TERMINATED, and
        /// FAILED.</p>
        pub fn state(mut self, input: crate::model::InstanceGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>State of instance group. The following values are deprecated: STARTING, TERMINATED, and
        /// FAILED.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Details regarding the state of the instance group.</p>
        pub fn last_state_change_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_state_change_reason = Some(input.into());
            self
        }
        /// <p>Details regarding the state of the instance group.</p>
        pub fn set_last_state_change_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_state_change_reason = input;
            self
        }
        /// <p>The date/time the instance group was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date/time the instance group was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date/time the instance group was started.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date_time = Some(input);
            self
        }
        /// <p>The date/time the instance group was started.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>The date/time the instance group was available to the cluster.</p>
        pub fn ready_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ready_date_time = Some(input);
            self
        }
        /// <p>The date/time the instance group was available to the cluster.</p>
        pub fn set_ready_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ready_date_time = input;
            self
        }
        /// <p>The date/time the instance group was terminated.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The date/time the instance group was terminated.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// <p>The custom AMI ID to use for the provisioned instance group.</p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_ami_id = Some(input.into());
            self
        }
        /// <p>The custom AMI ID to use for the provisioned instance group.</p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_ami_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceGroupDetail`](crate::model::InstanceGroupDetail)
        pub fn build(self) -> crate::model::InstanceGroupDetail {
            crate::model::InstanceGroupDetail {
                instance_group_id: self.instance_group_id,
                name: self.name,
                market: self.market,
                instance_role: self.instance_role,
                bid_price: self.bid_price,
                instance_type: self.instance_type,
                instance_request_count: self.instance_request_count,
                instance_running_count: self.instance_running_count,
                state: self.state,
                last_state_change_reason: self.last_state_change_reason,
                creation_date_time: self.creation_date_time,
                start_date_time: self.start_date_time,
                ready_date_time: self.ready_date_time,
                end_date_time: self.end_date_time,
                custom_ami_id: self.custom_ami_id,
            }
        }
    }
}
impl InstanceGroupDetail {
    /// Creates a new builder-style object to manufacture [`InstanceGroupDetail`](crate::model::InstanceGroupDetail)
    pub fn builder() -> crate::model::instance_group_detail::Builder {
        crate::model::instance_group_detail::Builder::default()
    }
}

/// <p>Describes the status of the cluster (job flow).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobFlowExecutionStatusDetail {
    /// <p>The state of the job flow.</p>
    pub state: std::option::Option<crate::model::JobFlowExecutionState>,
    /// <p>The creation date and time of the job flow.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The start date and time of the job flow.</p>
    pub start_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the job flow was ready to start running bootstrap actions.</p>
    pub ready_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The completion date and time of the job flow.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Description of the job flow last changed state.</p>
    pub last_state_change_reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobFlowExecutionStatusDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobFlowExecutionStatusDetail");
        formatter.field("state", &self.state);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("ready_date_time", &self.ready_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.field("last_state_change_reason", &self.last_state_change_reason);
        formatter.finish()
    }
}
/// See [`JobFlowExecutionStatusDetail`](crate::model::JobFlowExecutionStatusDetail)
pub mod job_flow_execution_status_detail {
    /// A builder for [`JobFlowExecutionStatusDetail`](crate::model::JobFlowExecutionStatusDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::JobFlowExecutionState>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ready_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_state_change_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the job flow.</p>
        pub fn state(mut self, input: crate::model::JobFlowExecutionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the job flow.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::JobFlowExecutionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The creation date and time of the job flow.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time of the job flow.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The start date and time of the job flow.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date_time = Some(input);
            self
        }
        /// <p>The start date and time of the job flow.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>The date and time when the job flow was ready to start running bootstrap actions.</p>
        pub fn ready_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ready_date_time = Some(input);
            self
        }
        /// <p>The date and time when the job flow was ready to start running bootstrap actions.</p>
        pub fn set_ready_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ready_date_time = input;
            self
        }
        /// <p>The completion date and time of the job flow.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The completion date and time of the job flow.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// <p>Description of the job flow last changed state.</p>
        pub fn last_state_change_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_state_change_reason = Some(input.into());
            self
        }
        /// <p>Description of the job flow last changed state.</p>
        pub fn set_last_state_change_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_state_change_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`JobFlowExecutionStatusDetail`](crate::model::JobFlowExecutionStatusDetail)
        pub fn build(self) -> crate::model::JobFlowExecutionStatusDetail {
            crate::model::JobFlowExecutionStatusDetail {
                state: self.state,
                creation_date_time: self.creation_date_time,
                start_date_time: self.start_date_time,
                ready_date_time: self.ready_date_time,
                end_date_time: self.end_date_time,
                last_state_change_reason: self.last_state_change_reason,
            }
        }
    }
}
impl JobFlowExecutionStatusDetail {
    /// Creates a new builder-style object to manufacture [`JobFlowExecutionStatusDetail`](crate::model::JobFlowExecutionStatusDetail)
    pub fn builder() -> crate::model::job_flow_execution_status_detail::Builder {
        crate::model::job_flow_execution_status_detail::Builder::default()
    }
}

/// <p>The type of instance.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobFlowExecutionState {
    #[allow(missing_docs)] // documentation missing in model
    Bootstrapping,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    ShuttingDown,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Waiting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobFlowExecutionState {
    fn from(s: &str) -> Self {
        match s {
            "BOOTSTRAPPING" => JobFlowExecutionState::Bootstrapping,
            "COMPLETED" => JobFlowExecutionState::Completed,
            "FAILED" => JobFlowExecutionState::Failed,
            "RUNNING" => JobFlowExecutionState::Running,
            "SHUTTING_DOWN" => JobFlowExecutionState::ShuttingDown,
            "STARTING" => JobFlowExecutionState::Starting,
            "TERMINATED" => JobFlowExecutionState::Terminated,
            "WAITING" => JobFlowExecutionState::Waiting,
            other => JobFlowExecutionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobFlowExecutionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobFlowExecutionState::from(s))
    }
}
impl JobFlowExecutionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobFlowExecutionState::Bootstrapping => "BOOTSTRAPPING",
            JobFlowExecutionState::Completed => "COMPLETED",
            JobFlowExecutionState::Failed => "FAILED",
            JobFlowExecutionState::Running => "RUNNING",
            JobFlowExecutionState::ShuttingDown => "SHUTTING_DOWN",
            JobFlowExecutionState::Starting => "STARTING",
            JobFlowExecutionState::Terminated => "TERMINATED",
            JobFlowExecutionState::Waiting => "WAITING",
            JobFlowExecutionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOOTSTRAPPING",
            "COMPLETED",
            "FAILED",
            "RUNNING",
            "SHUTTING_DOWN",
            "STARTING",
            "TERMINATED",
            "WAITING",
        ]
    }
}
impl AsRef<str> for JobFlowExecutionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The detailed description of the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The unique identifier for the cluster.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status details about the cluster.</p>
    pub status: std::option::Option<crate::model::ClusterStatus>,
    /// <p>Provides information about the EC2 instances in a cluster grouped by category. For
    /// example, key name, subnet ID, IAM instance profile, and so on.</p>
    pub ec2_instance_attributes: std::option::Option<crate::model::Ec2InstanceAttributes>,
    /// <note>
    /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
    /// later, excluding 5.0.x versions.</p>
    /// </note>
    /// <p>The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code>
    /// indicates a uniform instance group configuration. A value of <code>INSTANCE_FLEET</code>
    /// indicates an instance fleets configuration.</p>
    pub instance_collection_type: std::option::Option<crate::model::InstanceCollectionType>,
    /// <p>The path to the Amazon S3 location where logs for this cluster are stored.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p> The KMS key used for encrypting log files. This attribute is
    /// only available with EMR version 5.30.0 and later, excluding EMR 6.0.0. </p>
    pub log_encryption_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The AMI version requested for this cluster.</p>
    pub requested_ami_version: std::option::Option<std::string::String>,
    /// <p>The AMI version running on this cluster.</p>
    pub running_ami_version: std::option::Option<std::string::String>,
    /// <p>The Amazon EMR release label, which determines the version of open-source application
    /// packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>,
    /// where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more
    /// information about Amazon EMR release versions and included application versions and
    /// features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release
    /// label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
    /// <code>AmiVersion</code>.</p>
    pub release_label: std::option::Option<std::string::String>,
    /// <p>Specifies whether the cluster should terminate after completing all steps.</p>
    pub auto_terminate: bool,
    /// <p>Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from
    /// being terminated by an API call or user intervention, or in the event of a cluster
    /// error.</p>
    pub termination_protected: bool,
    /// <p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
    /// with the cluster. When <code>true</code>, IAM principals in the
    /// Amazon Web Services account can perform EMR cluster actions on the cluster that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p>
    /// <p>The default value is <code>true</code> if a value is not provided when creating a
    /// cluster using the EMR API <a>RunJobFlow</a> command, the CLI
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console. IAM principals that are
    /// allowed to perform actions on the cluster can use the <a>SetVisibleToAllUsers</a> action to change the value on a running cluster. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
    pub visible_to_all_users: bool,
    /// <p>The applications installed on this cluster.</p>
    pub applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
    /// <p>A list of tags associated with a cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
    /// your behalf.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
    /// is incremented one time for every hour an m1.small instance runs. Larger instances are
    /// weighted more, so an EC2 instance that is roughly four times more expensive would result in
    /// the normalized instance hours being incremented by four. This result is only an
    /// approximation and does not reflect the actual billing rate.</p>
    pub normalized_instance_hours: std::option::Option<i32>,
    /// <p>The DNS name of the master node. If the cluster is on a private subnet, this is the
    /// private DNS name. On a public subnet, this is the public DNS name.</p>
    pub master_public_dns_name: std::option::Option<std::string::String>,
    /// <p>Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied
    /// to the EMR cluster.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
    /// <p>The name of the security configuration applied to the cluster.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>An IAM role for automatic scaling policies. The default role is
    /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the
    /// automatic scaling feature requires to launch and terminate EC2 instances in an instance
    /// group.</p>
    pub auto_scaling_role: std::option::Option<std::string::String>,
    /// <p>The way that individual Amazon EC2 instances terminate when an automatic scale-in
    /// activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code>
    /// indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
    /// when the request to terminate the instance was submitted. This option is only available
    /// with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
    /// <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny
    /// list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
    /// the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
    /// first and blocks instance termination if it could lead to HDFS corruption.
    /// <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0
    /// and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
    pub scale_down_behavior: std::option::Option<crate::model::ScaleDownBehavior>,
    /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
    /// EBS-backed Linux AMI if the cluster uses a custom AMI.</p>
    pub custom_ami_id: std::option::Option<std::string::String>,
    /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
    /// each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
    pub ebs_root_volume_size: std::option::Option<i32>,
    /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that
    /// are applied from the Amazon Linux AMI package repositories when an instance boots using the
    /// AMI.</p>
    pub repo_upgrade_on_boot: std::option::Option<crate::model::RepoUpgradeOnBoot>,
    /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
    /// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
    /// in the <i>Amazon EMR Management Guide</i>.</p>
    pub kerberos_attributes: std::option::Option<crate::model::KerberosAttributes>,
    /// <p>The Amazon Resource Name of the cluster.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>
    pub outpost_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the number of steps that can be executed concurrently.</p>
    pub step_concurrency_level: std::option::Option<i32>,
    /// <p>Placement group configured for an Amazon EMR cluster.</p>
    pub placement_groups: std::option::Option<std::vec::Vec<crate::model::PlacementGroupConfig>>,
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("ec2_instance_attributes", &self.ec2_instance_attributes);
        formatter.field("instance_collection_type", &self.instance_collection_type);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("log_encryption_kms_key_id", &self.log_encryption_kms_key_id);
        formatter.field("requested_ami_version", &self.requested_ami_version);
        formatter.field("running_ami_version", &self.running_ami_version);
        formatter.field("release_label", &self.release_label);
        formatter.field("auto_terminate", &self.auto_terminate);
        formatter.field("termination_protected", &self.termination_protected);
        formatter.field("visible_to_all_users", &self.visible_to_all_users);
        formatter.field("applications", &self.applications);
        formatter.field("tags", &self.tags);
        formatter.field("service_role", &self.service_role);
        formatter.field("normalized_instance_hours", &self.normalized_instance_hours);
        formatter.field("master_public_dns_name", &self.master_public_dns_name);
        formatter.field("configurations", &self.configurations);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("auto_scaling_role", &self.auto_scaling_role);
        formatter.field("scale_down_behavior", &self.scale_down_behavior);
        formatter.field("custom_ami_id", &self.custom_ami_id);
        formatter.field("ebs_root_volume_size", &self.ebs_root_volume_size);
        formatter.field("repo_upgrade_on_boot", &self.repo_upgrade_on_boot);
        formatter.field("kerberos_attributes", &self.kerberos_attributes);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("outpost_arn", &self.outpost_arn);
        formatter.field("step_concurrency_level", &self.step_concurrency_level);
        formatter.field("placement_groups", &self.placement_groups);
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ClusterStatus>,
        pub(crate) ec2_instance_attributes:
            std::option::Option<crate::model::Ec2InstanceAttributes>,
        pub(crate) instance_collection_type:
            std::option::Option<crate::model::InstanceCollectionType>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) log_encryption_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) requested_ami_version: std::option::Option<std::string::String>,
        pub(crate) running_ami_version: std::option::Option<std::string::String>,
        pub(crate) release_label: std::option::Option<std::string::String>,
        pub(crate) auto_terminate: std::option::Option<bool>,
        pub(crate) termination_protected: std::option::Option<bool>,
        pub(crate) visible_to_all_users: std::option::Option<bool>,
        pub(crate) applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) normalized_instance_hours: std::option::Option<i32>,
        pub(crate) master_public_dns_name: std::option::Option<std::string::String>,
        pub(crate) configurations: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_role: std::option::Option<std::string::String>,
        pub(crate) scale_down_behavior: std::option::Option<crate::model::ScaleDownBehavior>,
        pub(crate) custom_ami_id: std::option::Option<std::string::String>,
        pub(crate) ebs_root_volume_size: std::option::Option<i32>,
        pub(crate) repo_upgrade_on_boot: std::option::Option<crate::model::RepoUpgradeOnBoot>,
        pub(crate) kerberos_attributes: std::option::Option<crate::model::KerberosAttributes>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) step_concurrency_level: std::option::Option<i32>,
        pub(crate) placement_groups:
            std::option::Option<std::vec::Vec<crate::model::PlacementGroupConfig>>,
    }
    impl Builder {
        /// <p>The unique identifier for the cluster.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cluster.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status details about the cluster.</p>
        pub fn status(mut self, input: crate::model::ClusterStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status details about the cluster.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ClusterStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides information about the EC2 instances in a cluster grouped by category. For
        /// example, key name, subnet ID, IAM instance profile, and so on.</p>
        pub fn ec2_instance_attributes(
            mut self,
            input: crate::model::Ec2InstanceAttributes,
        ) -> Self {
            self.ec2_instance_attributes = Some(input);
            self
        }
        /// <p>Provides information about the EC2 instances in a cluster grouped by category. For
        /// example, key name, subnet ID, IAM instance profile, and so on.</p>
        pub fn set_ec2_instance_attributes(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceAttributes>,
        ) -> Self {
            self.ec2_instance_attributes = input;
            self
        }
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        /// <p>The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code>
        /// indicates a uniform instance group configuration. A value of <code>INSTANCE_FLEET</code>
        /// indicates an instance fleets configuration.</p>
        pub fn instance_collection_type(
            mut self,
            input: crate::model::InstanceCollectionType,
        ) -> Self {
            self.instance_collection_type = Some(input);
            self
        }
        /// <note>
        /// <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
        /// later, excluding 5.0.x versions.</p>
        /// </note>
        /// <p>The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code>
        /// indicates a uniform instance group configuration. A value of <code>INSTANCE_FLEET</code>
        /// indicates an instance fleets configuration.</p>
        pub fn set_instance_collection_type(
            mut self,
            input: std::option::Option<crate::model::InstanceCollectionType>,
        ) -> Self {
            self.instance_collection_type = input;
            self
        }
        /// <p>The path to the Amazon S3 location where logs for this cluster are stored.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>The path to the Amazon S3 location where logs for this cluster are stored.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p> The KMS key used for encrypting log files. This attribute is
        /// only available with EMR version 5.30.0 and later, excluding EMR 6.0.0. </p>
        pub fn log_encryption_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_encryption_kms_key_id = Some(input.into());
            self
        }
        /// <p> The KMS key used for encrypting log files. This attribute is
        /// only available with EMR version 5.30.0 and later, excluding EMR 6.0.0. </p>
        pub fn set_log_encryption_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_encryption_kms_key_id = input;
            self
        }
        /// <p>The AMI version requested for this cluster.</p>
        pub fn requested_ami_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.requested_ami_version = Some(input.into());
            self
        }
        /// <p>The AMI version requested for this cluster.</p>
        pub fn set_requested_ami_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requested_ami_version = input;
            self
        }
        /// <p>The AMI version running on this cluster.</p>
        pub fn running_ami_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.running_ami_version = Some(input.into());
            self
        }
        /// <p>The AMI version running on this cluster.</p>
        pub fn set_running_ami_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.running_ami_version = input;
            self
        }
        /// <p>The Amazon EMR release label, which determines the version of open-source application
        /// packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>,
        /// where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more
        /// information about Amazon EMR release versions and included application versions and
        /// features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release
        /// label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
        /// <code>AmiVersion</code>.</p>
        pub fn release_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_label = Some(input.into());
            self
        }
        /// <p>The Amazon EMR release label, which determines the version of open-source application
        /// packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>,
        /// where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more
        /// information about Amazon EMR release versions and included application versions and
        /// features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release
        /// label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
        /// <code>AmiVersion</code>.</p>
        pub fn set_release_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_label = input;
            self
        }
        /// <p>Specifies whether the cluster should terminate after completing all steps.</p>
        pub fn auto_terminate(mut self, input: bool) -> Self {
            self.auto_terminate = Some(input);
            self
        }
        /// <p>Specifies whether the cluster should terminate after completing all steps.</p>
        pub fn set_auto_terminate(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_terminate = input;
            self
        }
        /// <p>Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from
        /// being terminated by an API call or user intervention, or in the event of a cluster
        /// error.</p>
        pub fn termination_protected(mut self, input: bool) -> Self {
            self.termination_protected = Some(input);
            self
        }
        /// <p>Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from
        /// being terminated by an API call or user intervention, or in the event of a cluster
        /// error.</p>
        pub fn set_termination_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.termination_protected = input;
            self
        }
        /// <p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
        /// with the cluster. When <code>true</code>, IAM principals in the
        /// Amazon Web Services account can perform EMR cluster actions on the cluster that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p>
        /// <p>The default value is <code>true</code> if a value is not provided when creating a
        /// cluster using the EMR API <a>RunJobFlow</a> command, the CLI
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console. IAM principals that are
        /// allowed to perform actions on the cluster can use the <a>SetVisibleToAllUsers</a> action to change the value on a running cluster. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn visible_to_all_users(mut self, input: bool) -> Self {
            self.visible_to_all_users = Some(input);
            self
        }
        /// <p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
        /// with the cluster. When <code>true</code>, IAM principals in the
        /// Amazon Web Services account can perform EMR cluster actions on the cluster that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p>
        /// <p>The default value is <code>true</code> if a value is not provided when creating a
        /// cluster using the EMR API <a>RunJobFlow</a> command, the CLI
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console. IAM principals that are
        /// allowed to perform actions on the cluster can use the <a>SetVisibleToAllUsers</a> action to change the value on a running cluster. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>
        pub fn set_visible_to_all_users(mut self, input: std::option::Option<bool>) -> Self {
            self.visible_to_all_users = input;
            self
        }
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>The applications installed on this cluster.</p>
        pub fn applications(mut self, input: impl Into<crate::model::Application>) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input.into());
            self.applications = Some(v);
            self
        }
        /// <p>The applications installed on this cluster.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with a cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with a cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
        /// your behalf.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
        /// your behalf.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
        /// is incremented one time for every hour an m1.small instance runs. Larger instances are
        /// weighted more, so an EC2 instance that is roughly four times more expensive would result in
        /// the normalized instance hours being incremented by four. This result is only an
        /// approximation and does not reflect the actual billing rate.</p>
        pub fn normalized_instance_hours(mut self, input: i32) -> Self {
            self.normalized_instance_hours = Some(input);
            self
        }
        /// <p>An approximation of the cost of the cluster, represented in m1.small/hours. This value
        /// is incremented one time for every hour an m1.small instance runs. Larger instances are
        /// weighted more, so an EC2 instance that is roughly four times more expensive would result in
        /// the normalized instance hours being incremented by four. This result is only an
        /// approximation and does not reflect the actual billing rate.</p>
        pub fn set_normalized_instance_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.normalized_instance_hours = input;
            self
        }
        /// <p>The DNS name of the master node. If the cluster is on a private subnet, this is the
        /// private DNS name. On a public subnet, this is the public DNS name.</p>
        pub fn master_public_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_public_dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name of the master node. If the cluster is on a private subnet, this is the
        /// private DNS name. On a public subnet, this is the public DNS name.</p>
        pub fn set_master_public_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_public_dns_name = input;
            self
        }
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied
        /// to the EMR cluster.</p>
        pub fn configurations(mut self, input: impl Into<crate::model::Configuration>) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input.into());
            self.configurations = Some(v);
            self
        }
        /// <p>Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied
        /// to the EMR cluster.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Configuration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>The name of the security configuration applied to the cluster.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the security configuration applied to the cluster.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is
        /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the
        /// automatic scaling feature requires to launch and terminate EC2 instances in an instance
        /// group.</p>
        pub fn auto_scaling_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_role = Some(input.into());
            self
        }
        /// <p>An IAM role for automatic scaling policies. The default role is
        /// <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the
        /// automatic scaling feature requires to launch and terminate EC2 instances in an instance
        /// group.</p>
        pub fn set_auto_scaling_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_role = input;
            self
        }
        /// <p>The way that individual Amazon EC2 instances terminate when an automatic scale-in
        /// activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code>
        /// indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
        /// when the request to terminate the instance was submitted. This option is only available
        /// with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny
        /// list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
        /// the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
        /// first and blocks instance termination if it could lead to HDFS corruption.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0
        /// and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
        pub fn scale_down_behavior(mut self, input: crate::model::ScaleDownBehavior) -> Self {
            self.scale_down_behavior = Some(input);
            self
        }
        /// <p>The way that individual Amazon EC2 instances terminate when an automatic scale-in
        /// activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code>
        /// indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
        /// when the request to terminate the instance was submitted. This option is only available
        /// with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny
        /// list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
        /// the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
        /// first and blocks instance termination if it could lead to HDFS corruption.
        /// <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0
        /// and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>
        pub fn set_scale_down_behavior(
            mut self,
            input: std::option::Option<crate::model::ScaleDownBehavior>,
        ) -> Self {
            self.scale_down_behavior = input;
            self
        }
        /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
        /// EBS-backed Linux AMI if the cluster uses a custom AMI.</p>
        pub fn custom_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_ami_id = Some(input.into());
            self
        }
        /// <p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
        /// EBS-backed Linux AMI if the cluster uses a custom AMI.</p>
        pub fn set_custom_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_ami_id = input;
            self
        }
        /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
        /// each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
        pub fn ebs_root_volume_size(mut self, input: i32) -> Self {
            self.ebs_root_volume_size = Some(input);
            self
        }
        /// <p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
        /// each EC2 instance. Available in Amazon EMR version 4.x and later.</p>
        pub fn set_ebs_root_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.ebs_root_volume_size = input;
            self
        }
        /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that
        /// are applied from the Amazon Linux AMI package repositories when an instance boots using the
        /// AMI.</p>
        pub fn repo_upgrade_on_boot(mut self, input: crate::model::RepoUpgradeOnBoot) -> Self {
            self.repo_upgrade_on_boot = Some(input);
            self
        }
        /// <p>Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that
        /// are applied from the Amazon Linux AMI package repositories when an instance boots using the
        /// AMI.</p>
        pub fn set_repo_upgrade_on_boot(
            mut self,
            input: std::option::Option<crate::model::RepoUpgradeOnBoot>,
        ) -> Self {
            self.repo_upgrade_on_boot = input;
            self
        }
        /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
        /// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
        /// in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn kerberos_attributes(mut self, input: crate::model::KerberosAttributes) -> Self {
            self.kerberos_attributes = Some(input);
            self
        }
        /// <p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a
        /// security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a>
        /// in the <i>Amazon EMR Management Guide</i>.</p>
        pub fn set_kerberos_attributes(
            mut self,
            input: std::option::Option<crate::model::KerberosAttributes>,
        ) -> Self {
            self.kerberos_attributes = input;
            self
        }
        /// <p>The Amazon Resource Name of the cluster.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the cluster.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>Specifies the number of steps that can be executed concurrently.</p>
        pub fn step_concurrency_level(mut self, input: i32) -> Self {
            self.step_concurrency_level = Some(input);
            self
        }
        /// <p>Specifies the number of steps that can be executed concurrently.</p>
        pub fn set_step_concurrency_level(mut self, input: std::option::Option<i32>) -> Self {
            self.step_concurrency_level = input;
            self
        }
        /// Appends an item to `placement_groups`.
        ///
        /// To override the contents of this collection use [`set_placement_groups`](Self::set_placement_groups).
        ///
        /// <p>Placement group configured for an Amazon EMR cluster.</p>
        pub fn placement_groups(
            mut self,
            input: impl Into<crate::model::PlacementGroupConfig>,
        ) -> Self {
            let mut v = self.placement_groups.unwrap_or_default();
            v.push(input.into());
            self.placement_groups = Some(v);
            self
        }
        /// <p>Placement group configured for an Amazon EMR cluster.</p>
        pub fn set_placement_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementGroupConfig>>,
        ) -> Self {
            self.placement_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                id: self.id,
                name: self.name,
                status: self.status,
                ec2_instance_attributes: self.ec2_instance_attributes,
                instance_collection_type: self.instance_collection_type,
                log_uri: self.log_uri,
                log_encryption_kms_key_id: self.log_encryption_kms_key_id,
                requested_ami_version: self.requested_ami_version,
                running_ami_version: self.running_ami_version,
                release_label: self.release_label,
                auto_terminate: self.auto_terminate.unwrap_or_default(),
                termination_protected: self.termination_protected.unwrap_or_default(),
                visible_to_all_users: self.visible_to_all_users.unwrap_or_default(),
                applications: self.applications,
                tags: self.tags,
                service_role: self.service_role,
                normalized_instance_hours: self.normalized_instance_hours,
                master_public_dns_name: self.master_public_dns_name,
                configurations: self.configurations,
                security_configuration: self.security_configuration,
                auto_scaling_role: self.auto_scaling_role,
                scale_down_behavior: self.scale_down_behavior,
                custom_ami_id: self.custom_ami_id,
                ebs_root_volume_size: self.ebs_root_volume_size,
                repo_upgrade_on_boot: self.repo_upgrade_on_boot,
                kerberos_attributes: self.kerberos_attributes,
                cluster_arn: self.cluster_arn,
                outpost_arn: self.outpost_arn,
                step_concurrency_level: self.step_concurrency_level,
                placement_groups: self.placement_groups,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceCollectionType {
    #[allow(missing_docs)] // documentation missing in model
    InstanceFleet,
    #[allow(missing_docs)] // documentation missing in model
    InstanceGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceCollectionType {
    fn from(s: &str) -> Self {
        match s {
            "INSTANCE_FLEET" => InstanceCollectionType::InstanceFleet,
            "INSTANCE_GROUP" => InstanceCollectionType::InstanceGroup,
            other => InstanceCollectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceCollectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceCollectionType::from(s))
    }
}
impl InstanceCollectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceCollectionType::InstanceFleet => "INSTANCE_FLEET",
            InstanceCollectionType::InstanceGroup => "INSTANCE_GROUP",
            InstanceCollectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSTANCE_FLEET", "INSTANCE_GROUP"]
    }
}
impl AsRef<str> for InstanceCollectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the EC2 instances in a cluster grouped by category. For
/// example, key name, subnet ID, IAM instance profile, and so on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceAttributes {
    /// <p>The name of the Amazon EC2 key pair to use when connecting with SSH into the master node
    /// as a user named "hadoop".</p>
    pub ec2_key_name: std::option::Option<std::string::String>,
    /// <p>Set this parameter to the identifier of the Amazon VPC subnet where you want the cluster
    /// to launch. If you do not specify this value, and your account supports EC2-Classic, the
    /// cluster launches in EC2-Classic.</p>
    pub ec2_subnet_id: std::option::Option<std::string::String>,
    /// <p>Applies to clusters configured with the instance fleets option. Specifies the unique
    /// identifier of one or more Amazon EC2 subnets in which to launch EC2 cluster instances.
    /// Subnets must exist within the same VPC. Amazon EMR chooses the EC2 subnet with the best fit
    /// from among the list of <code>RequestedEc2SubnetIds</code>, and then launches all cluster
    /// instances within that Subnet. If this value is not specified, and the account and Region
    /// support EC2-Classic networks, the cluster launches instances in the EC2-Classic network and
    /// uses <code>RequestedEc2AvailabilityZones</code> instead of this setting. If EC2-Classic is
    /// not supported, and no Subnet is specified, Amazon EMR chooses the subnet for you.
    /// <code>RequestedEc2SubnetIDs</code> and <code>RequestedEc2AvailabilityZones</code> cannot
    /// be specified together.</p>
    pub requested_ec2_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Availability Zone in which the cluster will run. </p>
    pub ec2_availability_zone: std::option::Option<std::string::String>,
    /// <p>Applies to clusters configured with the instance fleets option. Specifies one or more
    /// Availability Zones in which to launch EC2 cluster instances when the EC2-Classic network
    /// configuration is supported. Amazon EMR chooses the Availability Zone with the best fit from
    /// among the list of <code>RequestedEc2AvailabilityZones</code>, and then launches all cluster
    /// instances within that Availability Zone. If you do not specify this value, Amazon EMR
    /// chooses the Availability Zone for you. <code>RequestedEc2SubnetIDs</code> and
    /// <code>RequestedEc2AvailabilityZones</code> cannot be specified together.</p>
    pub requested_ec2_availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IAM role that was specified when the cluster was launched. The EC2 instances of the
    /// cluster assume this role.</p>
    pub iam_instance_profile: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon EC2 security group for the master node.</p>
    pub emr_managed_master_security_group: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon EC2 security group for the core and task nodes.</p>
    pub emr_managed_slave_security_group: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access
    /// clusters in VPC private subnets.</p>
    pub service_access_security_group: std::option::Option<std::string::String>,
    /// <p>A list of additional Amazon EC2 security group IDs for the master node.</p>
    pub additional_master_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>
    pub additional_slave_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Ec2InstanceAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceAttributes");
        formatter.field("ec2_key_name", &self.ec2_key_name);
        formatter.field("ec2_subnet_id", &self.ec2_subnet_id);
        formatter.field("requested_ec2_subnet_ids", &self.requested_ec2_subnet_ids);
        formatter.field("ec2_availability_zone", &self.ec2_availability_zone);
        formatter.field(
            "requested_ec2_availability_zones",
            &self.requested_ec2_availability_zones,
        );
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field(
            "emr_managed_master_security_group",
            &self.emr_managed_master_security_group,
        );
        formatter.field(
            "emr_managed_slave_security_group",
            &self.emr_managed_slave_security_group,
        );
        formatter.field(
            "service_access_security_group",
            &self.service_access_security_group,
        );
        formatter.field(
            "additional_master_security_groups",
            &self.additional_master_security_groups,
        );
        formatter.field(
            "additional_slave_security_groups",
            &self.additional_slave_security_groups,
        );
        formatter.finish()
    }
}
/// See [`Ec2InstanceAttributes`](crate::model::Ec2InstanceAttributes)
pub mod ec2_instance_attributes {
    /// A builder for [`Ec2InstanceAttributes`](crate::model::Ec2InstanceAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_key_name: std::option::Option<std::string::String>,
        pub(crate) ec2_subnet_id: std::option::Option<std::string::String>,
        pub(crate) requested_ec2_subnet_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ec2_availability_zone: std::option::Option<std::string::String>,
        pub(crate) requested_ec2_availability_zones:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) iam_instance_profile: std::option::Option<std::string::String>,
        pub(crate) emr_managed_master_security_group: std::option::Option<std::string::String>,
        pub(crate) emr_managed_slave_security_group: std::option::Option<std::string::String>,
        pub(crate) service_access_security_group: std::option::Option<std::string::String>,
        pub(crate) additional_master_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) additional_slave_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Amazon EC2 key pair to use when connecting with SSH into the master node
        /// as a user named "hadoop".</p>
        pub fn ec2_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_key_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EC2 key pair to use when connecting with SSH into the master node
        /// as a user named "hadoop".</p>
        pub fn set_ec2_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_key_name = input;
            self
        }
        /// <p>Set this parameter to the identifier of the Amazon VPC subnet where you want the cluster
        /// to launch. If you do not specify this value, and your account supports EC2-Classic, the
        /// cluster launches in EC2-Classic.</p>
        pub fn ec2_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_subnet_id = Some(input.into());
            self
        }
        /// <p>Set this parameter to the identifier of the Amazon VPC subnet where you want the cluster
        /// to launch. If you do not specify this value, and your account supports EC2-Classic, the
        /// cluster launches in EC2-Classic.</p>
        pub fn set_ec2_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_subnet_id = input;
            self
        }
        /// Appends an item to `requested_ec2_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_requested_ec2_subnet_ids`](Self::set_requested_ec2_subnet_ids).
        ///
        /// <p>Applies to clusters configured with the instance fleets option. Specifies the unique
        /// identifier of one or more Amazon EC2 subnets in which to launch EC2 cluster instances.
        /// Subnets must exist within the same VPC. Amazon EMR chooses the EC2 subnet with the best fit
        /// from among the list of <code>RequestedEc2SubnetIds</code>, and then launches all cluster
        /// instances within that Subnet. If this value is not specified, and the account and Region
        /// support EC2-Classic networks, the cluster launches instances in the EC2-Classic network and
        /// uses <code>RequestedEc2AvailabilityZones</code> instead of this setting. If EC2-Classic is
        /// not supported, and no Subnet is specified, Amazon EMR chooses the subnet for you.
        /// <code>RequestedEc2SubnetIDs</code> and <code>RequestedEc2AvailabilityZones</code> cannot
        /// be specified together.</p>
        pub fn requested_ec2_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.requested_ec2_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.requested_ec2_subnet_ids = Some(v);
            self
        }
        /// <p>Applies to clusters configured with the instance fleets option. Specifies the unique
        /// identifier of one or more Amazon EC2 subnets in which to launch EC2 cluster instances.
        /// Subnets must exist within the same VPC. Amazon EMR chooses the EC2 subnet with the best fit
        /// from among the list of <code>RequestedEc2SubnetIds</code>, and then launches all cluster
        /// instances within that Subnet. If this value is not specified, and the account and Region
        /// support EC2-Classic networks, the cluster launches instances in the EC2-Classic network and
        /// uses <code>RequestedEc2AvailabilityZones</code> instead of this setting. If EC2-Classic is
        /// not supported, and no Subnet is specified, Amazon EMR chooses the subnet for you.
        /// <code>RequestedEc2SubnetIDs</code> and <code>RequestedEc2AvailabilityZones</code> cannot
        /// be specified together.</p>
        pub fn set_requested_ec2_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.requested_ec2_subnet_ids = input;
            self
        }
        /// <p>The Availability Zone in which the cluster will run. </p>
        pub fn ec2_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the cluster will run. </p>
        pub fn set_ec2_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_availability_zone = input;
            self
        }
        /// Appends an item to `requested_ec2_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_requested_ec2_availability_zones`](Self::set_requested_ec2_availability_zones).
        ///
        /// <p>Applies to clusters configured with the instance fleets option. Specifies one or more
        /// Availability Zones in which to launch EC2 cluster instances when the EC2-Classic network
        /// configuration is supported. Amazon EMR chooses the Availability Zone with the best fit from
        /// among the list of <code>RequestedEc2AvailabilityZones</code>, and then launches all cluster
        /// instances within that Availability Zone. If you do not specify this value, Amazon EMR
        /// chooses the Availability Zone for you. <code>RequestedEc2SubnetIDs</code> and
        /// <code>RequestedEc2AvailabilityZones</code> cannot be specified together.</p>
        pub fn requested_ec2_availability_zones(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.requested_ec2_availability_zones.unwrap_or_default();
            v.push(input.into());
            self.requested_ec2_availability_zones = Some(v);
            self
        }
        /// <p>Applies to clusters configured with the instance fleets option. Specifies one or more
        /// Availability Zones in which to launch EC2 cluster instances when the EC2-Classic network
        /// configuration is supported. Amazon EMR chooses the Availability Zone with the best fit from
        /// among the list of <code>RequestedEc2AvailabilityZones</code>, and then launches all cluster
        /// instances within that Availability Zone. If you do not specify this value, Amazon EMR
        /// chooses the Availability Zone for you. <code>RequestedEc2SubnetIDs</code> and
        /// <code>RequestedEc2AvailabilityZones</code> cannot be specified together.</p>
        pub fn set_requested_ec2_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.requested_ec2_availability_zones = input;
            self
        }
        /// <p>The IAM role that was specified when the cluster was launched. The EC2 instances of the
        /// cluster assume this role.</p>
        pub fn iam_instance_profile(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_instance_profile = Some(input.into());
            self
        }
        /// <p>The IAM role that was specified when the cluster was launched. The EC2 instances of the
        /// cluster assume this role.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the master node.</p>
        pub fn emr_managed_master_security_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.emr_managed_master_security_group = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the master node.</p>
        pub fn set_emr_managed_master_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.emr_managed_master_security_group = input;
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the core and task nodes.</p>
        pub fn emr_managed_slave_security_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.emr_managed_slave_security_group = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the core and task nodes.</p>
        pub fn set_emr_managed_slave_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.emr_managed_slave_security_group = input;
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access
        /// clusters in VPC private subnets.</p>
        pub fn service_access_security_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.service_access_security_group = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access
        /// clusters in VPC private subnets.</p>
        pub fn set_service_access_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_security_group = input;
            self
        }
        /// Appends an item to `additional_master_security_groups`.
        ///
        /// To override the contents of this collection use [`set_additional_master_security_groups`](Self::set_additional_master_security_groups).
        ///
        /// <p>A list of additional Amazon EC2 security group IDs for the master node.</p>
        pub fn additional_master_security_groups(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_master_security_groups.unwrap_or_default();
            v.push(input.into());
            self.additional_master_security_groups = Some(v);
            self
        }
        /// <p>A list of additional Amazon EC2 security group IDs for the master node.</p>
        pub fn set_additional_master_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_master_security_groups = input;
            self
        }
        /// Appends an item to `additional_slave_security_groups`.
        ///
        /// To override the contents of this collection use [`set_additional_slave_security_groups`](Self::set_additional_slave_security_groups).
        ///
        /// <p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>
        pub fn additional_slave_security_groups(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_slave_security_groups.unwrap_or_default();
            v.push(input.into());
            self.additional_slave_security_groups = Some(v);
            self
        }
        /// <p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>
        pub fn set_additional_slave_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_slave_security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceAttributes`](crate::model::Ec2InstanceAttributes)
        pub fn build(self) -> crate::model::Ec2InstanceAttributes {
            crate::model::Ec2InstanceAttributes {
                ec2_key_name: self.ec2_key_name,
                ec2_subnet_id: self.ec2_subnet_id,
                requested_ec2_subnet_ids: self.requested_ec2_subnet_ids,
                ec2_availability_zone: self.ec2_availability_zone,
                requested_ec2_availability_zones: self.requested_ec2_availability_zones,
                iam_instance_profile: self.iam_instance_profile,
                emr_managed_master_security_group: self.emr_managed_master_security_group,
                emr_managed_slave_security_group: self.emr_managed_slave_security_group,
                service_access_security_group: self.service_access_security_group,
                additional_master_security_groups: self.additional_master_security_groups,
                additional_slave_security_groups: self.additional_slave_security_groups,
            }
        }
    }
}
impl Ec2InstanceAttributes {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceAttributes`](crate::model::Ec2InstanceAttributes)
    pub fn builder() -> crate::model::ec2_instance_attributes::Builder {
        crate::model::ec2_instance_attributes::Builder::default()
    }
}

/// <p>Specification of the status of a CancelSteps request. Available only in Amazon EMR
/// version 4.8.0 and later, excluding version 5.0.0.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelStepsInfo {
    /// <p>The encrypted StepId of a step.</p>
    pub step_id: std::option::Option<std::string::String>,
    /// <p>The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.</p>
    pub status: std::option::Option<crate::model::CancelStepsRequestStatus>,
    /// <p>The reason for the failure if the CancelSteps request fails.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelStepsInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelStepsInfo");
        formatter.field("step_id", &self.step_id);
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`CancelStepsInfo`](crate::model::CancelStepsInfo)
pub mod cancel_steps_info {
    /// A builder for [`CancelStepsInfo`](crate::model::CancelStepsInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) step_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CancelStepsRequestStatus>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encrypted StepId of a step.</p>
        pub fn step_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.step_id = Some(input.into());
            self
        }
        /// <p>The encrypted StepId of a step.</p>
        pub fn set_step_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.step_id = input;
            self
        }
        /// <p>The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.</p>
        pub fn status(mut self, input: crate::model::CancelStepsRequestStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CancelStepsRequestStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the failure if the CancelSteps request fails.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the failure if the CancelSteps request fails.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelStepsInfo`](crate::model::CancelStepsInfo)
        pub fn build(self) -> crate::model::CancelStepsInfo {
            crate::model::CancelStepsInfo {
                step_id: self.step_id,
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl CancelStepsInfo {
    /// Creates a new builder-style object to manufacture [`CancelStepsInfo`](crate::model::CancelStepsInfo)
    pub fn builder() -> crate::model::cancel_steps_info::Builder {
        crate::model::cancel_steps_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CancelStepsRequestStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CancelStepsRequestStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => CancelStepsRequestStatus::Failed,
            "SUBMITTED" => CancelStepsRequestStatus::Submitted,
            other => CancelStepsRequestStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CancelStepsRequestStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CancelStepsRequestStatus::from(s))
    }
}
impl CancelStepsRequestStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CancelStepsRequestStatus::Failed => "FAILED",
            CancelStepsRequestStatus::Submitted => "SUBMITTED",
            CancelStepsRequestStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "SUBMITTED"]
    }
}
impl AsRef<str> for CancelStepsRequestStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StepCancellationOption {
    #[allow(missing_docs)] // documentation missing in model
    SendInterrupt,
    #[allow(missing_docs)] // documentation missing in model
    TerminateProcess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StepCancellationOption {
    fn from(s: &str) -> Self {
        match s {
            "SEND_INTERRUPT" => StepCancellationOption::SendInterrupt,
            "TERMINATE_PROCESS" => StepCancellationOption::TerminateProcess,
            other => StepCancellationOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StepCancellationOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StepCancellationOption::from(s))
    }
}
impl StepCancellationOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StepCancellationOption::SendInterrupt => "SEND_INTERRUPT",
            StepCancellationOption::TerminateProcess => "TERMINATE_PROCESS",
            StepCancellationOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SEND_INTERRUPT", "TERMINATE_PROCESS"]
    }
}
impl AsRef<str> for StepCancellationOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
