// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddInstanceFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddInstanceFleetError {
    /// Kind of error that occurred.
    pub kind: AddInstanceFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddInstanceFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddInstanceFleetErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddInstanceFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddInstanceFleetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AddInstanceFleetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AddInstanceFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddInstanceFleetError {
    fn code(&self) -> Option<&str> {
        AddInstanceFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddInstanceFleetError {
    /// Creates a new `AddInstanceFleetError`.
    pub fn new(kind: AddInstanceFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddInstanceFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddInstanceFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddInstanceFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddInstanceFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddInstanceFleetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddInstanceFleetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AddInstanceFleetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddInstanceFleetErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for AddInstanceFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddInstanceFleetErrorKind::InternalServerException(_inner) => Some(_inner),
            AddInstanceFleetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AddInstanceFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddInstanceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddInstanceGroupsError {
    /// Kind of error that occurred.
    pub kind: AddInstanceGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddInstanceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddInstanceGroupsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddInstanceGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddInstanceGroupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddInstanceGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddInstanceGroupsError {
    fn code(&self) -> Option<&str> {
        AddInstanceGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddInstanceGroupsError {
    /// Creates a new `AddInstanceGroupsError`.
    pub fn new(kind: AddInstanceGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddInstanceGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddInstanceGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddInstanceGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddInstanceGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddInstanceGroupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AddInstanceGroupsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for AddInstanceGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddInstanceGroupsErrorKind::InternalServerError(_inner) => Some(_inner),
            AddInstanceGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddJobFlowSteps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddJobFlowStepsError {
    /// Kind of error that occurred.
    pub kind: AddJobFlowStepsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddJobFlowSteps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddJobFlowStepsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddJobFlowStepsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddJobFlowStepsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddJobFlowStepsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddJobFlowStepsError {
    fn code(&self) -> Option<&str> {
        AddJobFlowStepsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddJobFlowStepsError {
    /// Creates a new `AddJobFlowStepsError`.
    pub fn new(kind: AddJobFlowStepsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddJobFlowStepsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddJobFlowStepsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddJobFlowStepsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddJobFlowStepsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddJobFlowStepsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, AddJobFlowStepsErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for AddJobFlowStepsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddJobFlowStepsErrorKind::InternalServerError(_inner) => Some(_inner),
            AddJobFlowStepsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsError {
    /// Kind of error that occurred.
    pub kind: AddTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsError {
    fn code(&self) -> Option<&str> {
        AddTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsError {
    /// Creates a new `AddTagsError`.
    pub fn new(kind: AddTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for AddTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsErrorKind::InternalServerException(_inner) => Some(_inner),
            AddTagsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AddTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelSteps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelStepsError {
    /// Kind of error that occurred.
    pub kind: CancelStepsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelSteps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelStepsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelStepsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelStepsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CancelStepsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CancelStepsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelStepsError {
    fn code(&self) -> Option<&str> {
        CancelStepsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelStepsError {
    /// Creates a new `CancelStepsError`.
    pub fn new(kind: CancelStepsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelStepsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelStepsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelStepsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelStepsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelStepsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CancelStepsErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CancelStepsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CancelStepsErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for CancelStepsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelStepsErrorKind::InternalServerError(_inner) => Some(_inner),
            CancelStepsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CancelStepsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSecurityConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateSecurityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSecurityConfigurationErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSecurityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSecurityConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSecurityConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateSecurityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSecurityConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateSecurityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSecurityConfigurationError {
    /// Creates a new `CreateSecurityConfigurationError`.
    pub fn new(kind: CreateSecurityConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSecurityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSecurityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSecurityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSecurityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSecurityConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityConfigurationErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateSecurityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSecurityConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSecurityConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateSecurityConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStudioError {
    /// Kind of error that occurred.
    pub kind: CreateStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStudioErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStudioErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStudioError {
    fn code(&self) -> Option<&str> {
        CreateStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStudioError {
    /// Creates a new `CreateStudioError`.
    pub fn new(kind: CreateStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStudioErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStudioErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStudioErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateStudioErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStudioSessionMappingError {
    /// Kind of error that occurred.
    pub kind: CreateStudioSessionMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStudioSessionMappingErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStudioSessionMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStudioSessionMappingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateStudioSessionMappingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateStudioSessionMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStudioSessionMappingError {
    fn code(&self) -> Option<&str> {
        CreateStudioSessionMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStudioSessionMappingError {
    /// Creates a new `CreateStudioSessionMappingError`.
    pub fn new(kind: CreateStudioSessionMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStudioSessionMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStudioSessionMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStudioSessionMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStudioSessionMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStudioSessionMappingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioSessionMappingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStudioSessionMappingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStudioSessionMappingErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateStudioSessionMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStudioSessionMappingErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateStudioSessionMappingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateStudioSessionMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSecurityConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteSecurityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSecurityConfigurationErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSecurityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSecurityConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSecurityConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteSecurityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSecurityConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteSecurityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSecurityConfigurationError {
    /// Creates a new `DeleteSecurityConfigurationError`.
    pub fn new(kind: DeleteSecurityConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSecurityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSecurityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSecurityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSecurityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSecurityConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityConfigurationErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteSecurityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSecurityConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSecurityConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteSecurityConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStudioError {
    /// Kind of error that occurred.
    pub kind: DeleteStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStudioErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStudioErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStudioError {
    fn code(&self) -> Option<&str> {
        DeleteStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStudioError {
    /// Creates a new `DeleteStudioError`.
    pub fn new(kind: DeleteStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStudioErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStudioErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStudioErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteStudioErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStudioSessionMappingError {
    /// Kind of error that occurred.
    pub kind: DeleteStudioSessionMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStudioSessionMappingErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStudioSessionMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStudioSessionMappingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteStudioSessionMappingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteStudioSessionMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStudioSessionMappingError {
    fn code(&self) -> Option<&str> {
        DeleteStudioSessionMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStudioSessionMappingError {
    /// Creates a new `DeleteStudioSessionMappingError`.
    pub fn new(kind: DeleteStudioSessionMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStudioSessionMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStudioSessionMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStudioSessionMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStudioSessionMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStudioSessionMappingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioSessionMappingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStudioSessionMappingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStudioSessionMappingErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteStudioSessionMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStudioSessionMappingErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteStudioSessionMappingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteStudioSessionMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterError {
    fn code(&self) -> Option<&str> {
        DescribeClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterError {
    /// Creates a new `DescribeClusterError`.
    pub fn new(kind: DescribeClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeClusterErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobFlowsError {
    /// Kind of error that occurred.
    pub kind: DescribeJobFlowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobFlowsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobFlowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobFlowsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeJobFlowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobFlowsError {
    fn code(&self) -> Option<&str> {
        DescribeJobFlowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobFlowsError {
    /// Creates a new `DescribeJobFlowsError`.
    pub fn new(kind: DescribeJobFlowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobFlowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobFlowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobFlowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobFlowsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobFlowsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobFlowsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeJobFlowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobFlowsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeJobFlowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNotebookExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNotebookExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeNotebookExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNotebookExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNotebookExecutionErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNotebookExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNotebookExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeNotebookExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeNotebookExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNotebookExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeNotebookExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNotebookExecutionError {
    /// Creates a new `DescribeNotebookExecutionError`.
    pub fn new(kind: DescribeNotebookExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNotebookExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNotebookExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNotebookExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNotebookExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNotebookExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotebookExecutionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNotebookExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotebookExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeNotebookExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNotebookExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeNotebookExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeNotebookExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReleaseLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReleaseLabelError {
    /// Kind of error that occurred.
    pub kind: DescribeReleaseLabelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReleaseLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReleaseLabelErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReleaseLabelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReleaseLabelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeReleaseLabelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeReleaseLabelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReleaseLabelError {
    fn code(&self) -> Option<&str> {
        DescribeReleaseLabelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReleaseLabelError {
    /// Creates a new `DescribeReleaseLabelError`.
    pub fn new(kind: DescribeReleaseLabelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReleaseLabelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReleaseLabelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReleaseLabelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReleaseLabelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReleaseLabelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReleaseLabelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReleaseLabelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReleaseLabelErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeReleaseLabelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReleaseLabelErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeReleaseLabelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeReleaseLabelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSecurityConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeSecurityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSecurityConfigurationErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSecurityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSecurityConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSecurityConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSecurityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSecurityConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeSecurityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSecurityConfigurationError {
    /// Creates a new `DescribeSecurityConfigurationError`.
    pub fn new(
        kind: DescribeSecurityConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSecurityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSecurityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSecurityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSecurityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSecurityConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityConfigurationErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeSecurityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSecurityConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSecurityConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeSecurityConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStep` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStepError {
    /// Kind of error that occurred.
    pub kind: DescribeStepErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStep` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStepErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStepError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStepErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeStepErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeStepErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStepError {
    fn code(&self) -> Option<&str> {
        DescribeStepError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStepError {
    /// Creates a new `DescribeStepError`.
    pub fn new(kind: DescribeStepErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStepError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStepErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStepError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStepErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStepErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStepErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStepErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStepErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeStepError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStepErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeStepErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeStepErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStudioError {
    /// Kind of error that occurred.
    pub kind: DescribeStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStudioErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStudioErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeStudioErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStudioError {
    fn code(&self) -> Option<&str> {
        DescribeStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStudioError {
    /// Creates a new `DescribeStudioError`.
    pub fn new(kind: DescribeStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStudioErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStudioErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStudioErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStudioErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStudioErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeStudioErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAutoTerminationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAutoTerminationPolicyError {
    /// Kind of error that occurred.
    pub kind: GetAutoTerminationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAutoTerminationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAutoTerminationPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAutoTerminationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAutoTerminationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAutoTerminationPolicyError {
    fn code(&self) -> Option<&str> {
        GetAutoTerminationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAutoTerminationPolicyError {
    /// Creates a new `GetAutoTerminationPolicyError`.
    pub fn new(kind: GetAutoTerminationPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAutoTerminationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAutoTerminationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAutoTerminationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAutoTerminationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetAutoTerminationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAutoTerminationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBlockPublicAccessConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBlockPublicAccessConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetBlockPublicAccessConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBlockPublicAccessConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBlockPublicAccessConfigurationErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBlockPublicAccessConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBlockPublicAccessConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetBlockPublicAccessConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetBlockPublicAccessConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBlockPublicAccessConfigurationError {
    fn code(&self) -> Option<&str> {
        GetBlockPublicAccessConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBlockPublicAccessConfigurationError {
    /// Creates a new `GetBlockPublicAccessConfigurationError`.
    pub fn new(
        kind: GetBlockPublicAccessConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBlockPublicAccessConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBlockPublicAccessConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBlockPublicAccessConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBlockPublicAccessConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBlockPublicAccessConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlockPublicAccessConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlockPublicAccessConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlockPublicAccessConfigurationErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for GetBlockPublicAccessConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBlockPublicAccessConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetBlockPublicAccessConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            GetBlockPublicAccessConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetManagedScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetManagedScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: GetManagedScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetManagedScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetManagedScalingPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetManagedScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetManagedScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetManagedScalingPolicyError {
    fn code(&self) -> Option<&str> {
        GetManagedScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetManagedScalingPolicyError {
    /// Creates a new `GetManagedScalingPolicyError`.
    pub fn new(kind: GetManagedScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetManagedScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetManagedScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetManagedScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetManagedScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetManagedScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetManagedScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStudioSessionMappingError {
    /// Kind of error that occurred.
    pub kind: GetStudioSessionMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStudioSessionMappingErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStudioSessionMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStudioSessionMappingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetStudioSessionMappingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetStudioSessionMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStudioSessionMappingError {
    fn code(&self) -> Option<&str> {
        GetStudioSessionMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStudioSessionMappingError {
    /// Creates a new `GetStudioSessionMappingError`.
    pub fn new(kind: GetStudioSessionMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStudioSessionMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStudioSessionMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStudioSessionMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStudioSessionMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStudioSessionMappingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioSessionMappingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetStudioSessionMappingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStudioSessionMappingErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for GetStudioSessionMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStudioSessionMappingErrorKind::InternalServerError(_inner) => Some(_inner),
            GetStudioSessionMappingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetStudioSessionMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBootstrapActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBootstrapActionsError {
    /// Kind of error that occurred.
    pub kind: ListBootstrapActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBootstrapActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBootstrapActionsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBootstrapActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBootstrapActionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBootstrapActionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListBootstrapActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBootstrapActionsError {
    fn code(&self) -> Option<&str> {
        ListBootstrapActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBootstrapActionsError {
    /// Creates a new `ListBootstrapActionsError`.
    pub fn new(kind: ListBootstrapActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBootstrapActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBootstrapActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBootstrapActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBootstrapActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBootstrapActionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBootstrapActionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBootstrapActionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBootstrapActionsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListBootstrapActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBootstrapActionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBootstrapActionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListBootstrapActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClustersError {
    /// Kind of error that occurred.
    pub kind: ListClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClustersErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClustersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClustersError {
    fn code(&self) -> Option<&str> {
        ListClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClustersError {
    /// Creates a new `ListClustersError`.
    pub fn new(kind: ListClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClustersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClustersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListClustersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceFleetsError {
    /// Kind of error that occurred.
    pub kind: ListInstanceFleetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceFleetsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceFleetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceFleetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListInstanceFleetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListInstanceFleetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceFleetsError {
    fn code(&self) -> Option<&str> {
        ListInstanceFleetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceFleetsError {
    /// Creates a new `ListInstanceFleetsError`.
    pub fn new(kind: ListInstanceFleetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceFleetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceFleetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceFleetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceFleetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstanceFleetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceFleetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceFleetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceFleetsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListInstanceFleetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceFleetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListInstanceFleetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListInstanceFleetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceGroupsError {
    /// Kind of error that occurred.
    pub kind: ListInstanceGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceGroupsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceGroupsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListInstanceGroupsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListInstanceGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceGroupsError {
    fn code(&self) -> Option<&str> {
        ListInstanceGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceGroupsError {
    /// Creates a new `ListInstanceGroupsError`.
    pub fn new(kind: ListInstanceGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstanceGroupsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceGroupsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceGroupsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceGroupsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListInstanceGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceGroupsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListInstanceGroupsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListInstanceGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstancesError {
    /// Kind of error that occurred.
    pub kind: ListInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstancesErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstancesError {
    fn code(&self) -> Option<&str> {
        ListInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstancesError {
    /// Creates a new `ListInstancesError`.
    pub fn new(kind: ListInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstancesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstancesErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstancesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListInstancesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNotebookExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNotebookExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListNotebookExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNotebookExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNotebookExecutionsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNotebookExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNotebookExecutionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListNotebookExecutionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListNotebookExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNotebookExecutionsError {
    fn code(&self) -> Option<&str> {
        ListNotebookExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNotebookExecutionsError {
    /// Creates a new `ListNotebookExecutionsError`.
    pub fn new(kind: ListNotebookExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNotebookExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNotebookExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNotebookExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNotebookExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNotebookExecutionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListNotebookExecutionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListNotebookExecutionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotebookExecutionsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListNotebookExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNotebookExecutionsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListNotebookExecutionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListNotebookExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReleaseLabels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReleaseLabelsError {
    /// Kind of error that occurred.
    pub kind: ListReleaseLabelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReleaseLabels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReleaseLabelsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReleaseLabelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReleaseLabelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListReleaseLabelsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListReleaseLabelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReleaseLabelsError {
    fn code(&self) -> Option<&str> {
        ListReleaseLabelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReleaseLabelsError {
    /// Creates a new `ListReleaseLabelsError`.
    pub fn new(kind: ListReleaseLabelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReleaseLabelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReleaseLabelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReleaseLabelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReleaseLabelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReleaseLabelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReleaseLabelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReleaseLabelsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReleaseLabelsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListReleaseLabelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReleaseLabelsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListReleaseLabelsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListReleaseLabelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSecurityConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSecurityConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListSecurityConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSecurityConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSecurityConfigurationsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSecurityConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSecurityConfigurationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSecurityConfigurationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListSecurityConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSecurityConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListSecurityConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSecurityConfigurationsError {
    /// Creates a new `ListSecurityConfigurationsError`.
    pub fn new(kind: ListSecurityConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSecurityConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSecurityConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSecurityConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSecurityConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSecurityConfigurationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityConfigurationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityConfigurationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityConfigurationsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListSecurityConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSecurityConfigurationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSecurityConfigurationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListSecurityConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSteps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStepsError {
    /// Kind of error that occurred.
    pub kind: ListStepsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSteps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStepsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStepsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStepsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListStepsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListStepsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStepsError {
    fn code(&self) -> Option<&str> {
        ListStepsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStepsError {
    /// Creates a new `ListStepsError`.
    pub fn new(kind: ListStepsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStepsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStepsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStepsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStepsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStepsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListStepsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListStepsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListStepsErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ListStepsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStepsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListStepsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListStepsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStudios` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStudiosError {
    /// Kind of error that occurred.
    pub kind: ListStudiosErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStudios` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStudiosErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStudiosError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStudiosErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListStudiosErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStudiosError {
    fn code(&self) -> Option<&str> {
        ListStudiosError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStudiosError {
    /// Creates a new `ListStudiosError`.
    pub fn new(kind: ListStudiosErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStudiosError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStudiosErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStudiosError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStudiosErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStudiosErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListStudiosErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListStudiosErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListStudiosErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ListStudiosError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStudiosErrorKind::InternalServerException(_inner) => Some(_inner),
            ListStudiosErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListStudiosErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStudioSessionMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStudioSessionMappingsError {
    /// Kind of error that occurred.
    pub kind: ListStudioSessionMappingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStudioSessionMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStudioSessionMappingsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStudioSessionMappingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStudioSessionMappingsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListStudioSessionMappingsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListStudioSessionMappingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStudioSessionMappingsError {
    fn code(&self) -> Option<&str> {
        ListStudioSessionMappingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStudioSessionMappingsError {
    /// Creates a new `ListStudioSessionMappingsError`.
    pub fn new(kind: ListStudioSessionMappingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStudioSessionMappingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStudioSessionMappingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStudioSessionMappingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStudioSessionMappingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStudioSessionMappingsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioSessionMappingsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListStudioSessionMappingsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStudioSessionMappingsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListStudioSessionMappingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStudioSessionMappingsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListStudioSessionMappingsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListStudioSessionMappingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterError {
    fn code(&self) -> Option<&str> {
        ModifyClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterError {
    /// Creates a new `ModifyClusterError`.
    pub fn new(kind: ModifyClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ModifyClusterErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ModifyClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterErrorKind::InternalServerError(_inner) => Some(_inner),
            ModifyClusterErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ModifyClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyInstanceFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyInstanceFleetError {
    /// Kind of error that occurred.
    pub kind: ModifyInstanceFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyInstanceFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyInstanceFleetErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyInstanceFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyInstanceFleetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ModifyInstanceFleetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ModifyInstanceFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyInstanceFleetError {
    fn code(&self) -> Option<&str> {
        ModifyInstanceFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyInstanceFleetError {
    /// Creates a new `ModifyInstanceFleetError`.
    pub fn new(kind: ModifyInstanceFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyInstanceFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyInstanceFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyInstanceFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyInstanceFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyInstanceFleetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyInstanceFleetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyInstanceFleetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyInstanceFleetErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ModifyInstanceFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyInstanceFleetErrorKind::InternalServerException(_inner) => Some(_inner),
            ModifyInstanceFleetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ModifyInstanceFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyInstanceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyInstanceGroupsError {
    /// Kind of error that occurred.
    pub kind: ModifyInstanceGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyInstanceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyInstanceGroupsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyInstanceGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyInstanceGroupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ModifyInstanceGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyInstanceGroupsError {
    fn code(&self) -> Option<&str> {
        ModifyInstanceGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyInstanceGroupsError {
    /// Creates a new `ModifyInstanceGroupsError`.
    pub fn new(kind: ModifyInstanceGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyInstanceGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyInstanceGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyInstanceGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyInstanceGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyInstanceGroupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ModifyInstanceGroupsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for ModifyInstanceGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyInstanceGroupsErrorKind::InternalServerError(_inner) => Some(_inner),
            ModifyInstanceGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAutoScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAutoScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: PutAutoScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAutoScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAutoScalingPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAutoScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAutoScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAutoScalingPolicyError {
    fn code(&self) -> Option<&str> {
        PutAutoScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAutoScalingPolicyError {
    /// Creates a new `PutAutoScalingPolicyError`.
    pub fn new(kind: PutAutoScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAutoScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAutoScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAutoScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAutoScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for PutAutoScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAutoScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAutoTerminationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAutoTerminationPolicyError {
    /// Kind of error that occurred.
    pub kind: PutAutoTerminationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAutoTerminationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAutoTerminationPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAutoTerminationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAutoTerminationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAutoTerminationPolicyError {
    fn code(&self) -> Option<&str> {
        PutAutoTerminationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAutoTerminationPolicyError {
    /// Creates a new `PutAutoTerminationPolicyError`.
    pub fn new(kind: PutAutoTerminationPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAutoTerminationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAutoTerminationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAutoTerminationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAutoTerminationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for PutAutoTerminationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAutoTerminationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutBlockPublicAccessConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutBlockPublicAccessConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutBlockPublicAccessConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutBlockPublicAccessConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutBlockPublicAccessConfigurationErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutBlockPublicAccessConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutBlockPublicAccessConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            PutBlockPublicAccessConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutBlockPublicAccessConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutBlockPublicAccessConfigurationError {
    fn code(&self) -> Option<&str> {
        PutBlockPublicAccessConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutBlockPublicAccessConfigurationError {
    /// Creates a new `PutBlockPublicAccessConfigurationError`.
    pub fn new(
        kind: PutBlockPublicAccessConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutBlockPublicAccessConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutBlockPublicAccessConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutBlockPublicAccessConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutBlockPublicAccessConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutBlockPublicAccessConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBlockPublicAccessConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBlockPublicAccessConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBlockPublicAccessConfigurationErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for PutBlockPublicAccessConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutBlockPublicAccessConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            PutBlockPublicAccessConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            PutBlockPublicAccessConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutManagedScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutManagedScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: PutManagedScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutManagedScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutManagedScalingPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutManagedScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutManagedScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutManagedScalingPolicyError {
    fn code(&self) -> Option<&str> {
        PutManagedScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutManagedScalingPolicyError {
    /// Creates a new `PutManagedScalingPolicyError`.
    pub fn new(kind: PutManagedScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutManagedScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutManagedScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutManagedScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutManagedScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for PutManagedScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutManagedScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveAutoScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveAutoScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: RemoveAutoScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveAutoScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveAutoScalingPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveAutoScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveAutoScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveAutoScalingPolicyError {
    fn code(&self) -> Option<&str> {
        RemoveAutoScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveAutoScalingPolicyError {
    /// Creates a new `RemoveAutoScalingPolicyError`.
    pub fn new(kind: RemoveAutoScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveAutoScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveAutoScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveAutoScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveAutoScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RemoveAutoScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveAutoScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveAutoTerminationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveAutoTerminationPolicyError {
    /// Kind of error that occurred.
    pub kind: RemoveAutoTerminationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveAutoTerminationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveAutoTerminationPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveAutoTerminationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveAutoTerminationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveAutoTerminationPolicyError {
    fn code(&self) -> Option<&str> {
        RemoveAutoTerminationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveAutoTerminationPolicyError {
    /// Creates a new `RemoveAutoTerminationPolicyError`.
    pub fn new(kind: RemoveAutoTerminationPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveAutoTerminationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveAutoTerminationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveAutoTerminationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveAutoTerminationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RemoveAutoTerminationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveAutoTerminationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveManagedScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveManagedScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: RemoveManagedScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveManagedScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveManagedScalingPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveManagedScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveManagedScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveManagedScalingPolicyError {
    fn code(&self) -> Option<&str> {
        RemoveManagedScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveManagedScalingPolicyError {
    /// Creates a new `RemoveManagedScalingPolicyError`.
    pub fn new(kind: RemoveManagedScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveManagedScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveManagedScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveManagedScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveManagedScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RemoveManagedScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveManagedScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsError {
    fn code(&self) -> Option<&str> {
        RemoveTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsError {
    /// Creates a new `RemoveTagsError`.
    pub fn new(kind: RemoveTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for RemoveTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsErrorKind::InternalServerException(_inner) => Some(_inner),
            RemoveTagsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RemoveTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RunJobFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RunJobFlowError {
    /// Kind of error that occurred.
    pub kind: RunJobFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RunJobFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RunJobFlowErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RunJobFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RunJobFlowErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RunJobFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RunJobFlowError {
    fn code(&self) -> Option<&str> {
        RunJobFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RunJobFlowError {
    /// Creates a new `RunJobFlowError`.
    pub fn new(kind: RunJobFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RunJobFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RunJobFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RunJobFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RunJobFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RunJobFlowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, RunJobFlowErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for RunJobFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RunJobFlowErrorKind::InternalServerError(_inner) => Some(_inner),
            RunJobFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetTerminationProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetTerminationProtectionError {
    /// Kind of error that occurred.
    pub kind: SetTerminationProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetTerminationProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetTerminationProtectionErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetTerminationProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetTerminationProtectionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            SetTerminationProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetTerminationProtectionError {
    fn code(&self) -> Option<&str> {
        SetTerminationProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetTerminationProtectionError {
    /// Creates a new `SetTerminationProtectionError`.
    pub fn new(kind: SetTerminationProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetTerminationProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetTerminationProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetTerminationProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetTerminationProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetTerminationProtectionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            SetTerminationProtectionErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for SetTerminationProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetTerminationProtectionErrorKind::InternalServerError(_inner) => Some(_inner),
            SetTerminationProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetVisibleToAllUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetVisibleToAllUsersError {
    /// Kind of error that occurred.
    pub kind: SetVisibleToAllUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetVisibleToAllUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetVisibleToAllUsersErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetVisibleToAllUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetVisibleToAllUsersErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            SetVisibleToAllUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetVisibleToAllUsersError {
    fn code(&self) -> Option<&str> {
        SetVisibleToAllUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetVisibleToAllUsersError {
    /// Creates a new `SetVisibleToAllUsersError`.
    pub fn new(kind: SetVisibleToAllUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetVisibleToAllUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetVisibleToAllUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetVisibleToAllUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetVisibleToAllUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetVisibleToAllUsersErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            SetVisibleToAllUsersErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for SetVisibleToAllUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetVisibleToAllUsersErrorKind::InternalServerError(_inner) => Some(_inner),
            SetVisibleToAllUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartNotebookExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartNotebookExecutionError {
    /// Kind of error that occurred.
    pub kind: StartNotebookExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartNotebookExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartNotebookExecutionErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartNotebookExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartNotebookExecutionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartNotebookExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartNotebookExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartNotebookExecutionError {
    fn code(&self) -> Option<&str> {
        StartNotebookExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartNotebookExecutionError {
    /// Creates a new `StartNotebookExecutionError`.
    pub fn new(kind: StartNotebookExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartNotebookExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartNotebookExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartNotebookExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartNotebookExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartNotebookExecutionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartNotebookExecutionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartNotebookExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartNotebookExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for StartNotebookExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartNotebookExecutionErrorKind::InternalServerException(_inner) => Some(_inner),
            StartNotebookExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartNotebookExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopNotebookExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopNotebookExecutionError {
    /// Kind of error that occurred.
    pub kind: StopNotebookExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopNotebookExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopNotebookExecutionErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopNotebookExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopNotebookExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StopNotebookExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopNotebookExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopNotebookExecutionError {
    fn code(&self) -> Option<&str> {
        StopNotebookExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopNotebookExecutionError {
    /// Creates a new `StopNotebookExecutionError`.
    pub fn new(kind: StopNotebookExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopNotebookExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopNotebookExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopNotebookExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopNotebookExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopNotebookExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StopNotebookExecutionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `StopNotebookExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopNotebookExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for StopNotebookExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopNotebookExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            StopNotebookExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopNotebookExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateJobFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateJobFlowsError {
    /// Kind of error that occurred.
    pub kind: TerminateJobFlowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateJobFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateJobFlowsErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateJobFlowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateJobFlowsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TerminateJobFlowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateJobFlowsError {
    fn code(&self) -> Option<&str> {
        TerminateJobFlowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateJobFlowsError {
    /// Creates a new `TerminateJobFlowsError`.
    pub fn new(kind: TerminateJobFlowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateJobFlowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateJobFlowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateJobFlowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateJobFlowsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TerminateJobFlowsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            TerminateJobFlowsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for TerminateJobFlowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateJobFlowsErrorKind::InternalServerError(_inner) => Some(_inner),
            TerminateJobFlowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStudioError {
    /// Kind of error that occurred.
    pub kind: UpdateStudioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStudio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStudioErrorKind {
    /// <p>This exception occurs when there is an internal failure in the Amazon EMR
    /// service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStudioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStudioErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateStudioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStudioError {
    fn code(&self) -> Option<&str> {
        UpdateStudioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStudioError {
    /// Creates a new `UpdateStudioError`.
    pub fn new(kind: UpdateStudioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStudioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStudioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStudioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStudioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStudioErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStudioErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateStudioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStudioErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateStudioErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateStudioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStudioSessionMappingError {
    /// Kind of error that occurred.
    pub kind: UpdateStudioSessionMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStudioSessionMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStudioSessionMappingErrorKind {
    /// <p>Indicates that an error occurred while processing the request and that the request was
    /// not completed.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>This exception occurs when there is something wrong with user input.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStudioSessionMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStudioSessionMappingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateStudioSessionMappingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateStudioSessionMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStudioSessionMappingError {
    fn code(&self) -> Option<&str> {
        UpdateStudioSessionMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStudioSessionMappingError {
    /// Creates a new `UpdateStudioSessionMappingError`.
    pub fn new(kind: UpdateStudioSessionMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStudioSessionMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStudioSessionMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStudioSessionMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStudioSessionMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStudioSessionMappingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioSessionMappingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStudioSessionMappingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStudioSessionMappingErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateStudioSessionMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStudioSessionMappingErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateStudioSessionMappingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateStudioSessionMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>This exception occurs when there is something wrong with user input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The error code associated with the exception.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code associated with the exception.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code associated with the exception.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>Indicates that an error occurred while processing the request and that the request was
/// not completed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>This exception occurs when there is an internal failure in the Amazon EMR
/// service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// <p>The message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}
