// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Elastic Transcoder
///
/// Client for invoking operations on Amazon Elastic Transcoder. Each operation on Amazon Elastic Transcoder is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elastictranscoder::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_elastictranscoder::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_elastictranscoder::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelJob`](crate::client::fluent_builders::CancelJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CancelJob::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CancelJob::set_id): <p>The identifier of the job that you want to cancel.</p>  <p>To get a list of the jobs (including their <code>jobId</code>) that have a status of <code>Submitted</code>, use the <code>ListJobsByStatus</code> API action.</p>
    /// - On success, responds with [`CancelJobOutput`](crate::output::CancelJobOutput)

    /// - On failure, responds with [`SdkError<CancelJobError>`](crate::error::CancelJobError)
    pub fn cancel_job(&self) -> fluent_builders::CancelJob {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJob`](crate::client::fluent_builders::CreateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_pipeline_id): <p>The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.</p>
    ///   - [`input(JobInput)`](crate::client::fluent_builders::CreateJob::input) / [`set_input(Option<JobInput>)`](crate::client::fluent_builders::CreateJob::set_input): <p>A section of the request body that provides information about the file that is being transcoded.</p>
    ///   - [`inputs(Vec<JobInput>)`](crate::client::fluent_builders::CreateJob::inputs) / [`set_inputs(Option<Vec<JobInput>>)`](crate::client::fluent_builders::CreateJob::set_inputs): <p>A section of the request body that provides information about the files that are being transcoded.</p>
    ///   - [`output(CreateJobOutput)`](crate::client::fluent_builders::CreateJob::output) / [`set_output(Option<CreateJobOutput>)`](crate::client::fluent_builders::CreateJob::set_output): <p> A section of the request body that provides information about the transcoded (target) file. We strongly recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax. </p>
    ///   - [`outputs(Vec<CreateJobOutput>)`](crate::client::fluent_builders::CreateJob::outputs) / [`set_outputs(Option<Vec<CreateJobOutput>>)`](crate::client::fluent_builders::CreateJob::set_outputs): <p> A section of the request body that provides information about the transcoded (target) files. We recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax. </p>
    ///   - [`output_key_prefix(impl Into<String>)`](crate::client::fluent_builders::CreateJob::output_key_prefix) / [`set_output_key_prefix(Option<String>)`](crate::client::fluent_builders::CreateJob::set_output_key_prefix): <p>The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists.</p>
    ///   - [`playlists(Vec<CreateJobPlaylist>)`](crate::client::fluent_builders::CreateJob::playlists) / [`set_playlists(Option<Vec<CreateJobPlaylist>>)`](crate::client::fluent_builders::CreateJob::set_playlists): <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4 (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want Elastic Transcoder to create.</p>  <p>The maximum number of master playlists in a job is 30.</p>
    ///   - [`user_metadata(HashMap<String, String>)`](crate::client::fluent_builders::CreateJob::user_metadata) / [`set_user_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateJob::set_user_metadata): <p>User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.</p>
    /// - On success, responds with [`CreateJobOutput`](crate::output::CreateJobOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::CreateJobOutput::job): <p>A section of the response body that provides information about the job that is created.</p>
    /// - On failure, responds with [`SdkError<CreateJobError>`](crate::error::CreateJobError)
    pub fn create_job(&self) -> fluent_builders::CreateJob {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePipeline`](crate::client::fluent_builders::CreatePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_name): <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>  <p>Constraints: Maximum 40 characters.</p>
    ///   - [`input_bucket(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::input_bucket) / [`set_input_bucket(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_input_bucket): <p>The Amazon S3 bucket in which you saved the media files that you want to transcode.</p>
    ///   - [`output_bucket(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::output_bucket) / [`set_output_bucket(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_output_bucket): <p>The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. (Use this, or use ContentConfig:Bucket plus ThumbnailConfig:Bucket.)</p>  <p>Specify this value when all of the following are true:</p>  <ul>   <li> <p>You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.</p> </li>   <li> <p>You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.</p> </li>   <li> <p>You do not want to specify the permissions that Elastic Transcoder grants to the files. </p> <important>     <p>When Elastic Transcoder saves files in <code>OutputBucket</code>, it grants full control over the files only to the AWS account that owns the role that is specified by <code>Role</code>.</p>    </important> </li>   <li> <p>You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.</p> </li>  </ul>  <p>If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit <code>OutputBucket</code> and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_role): <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to create the pipeline.</p>
    ///   - [`aws_kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::aws_kms_key_arn) / [`set_aws_kms_key_arn(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_aws_kms_key_arn): <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>  <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
    ///   - [`notifications(Notifications)`](crate::client::fluent_builders::CreatePipeline::notifications) / [`set_notifications(Option<Notifications>)`](crate::client::fluent_builders::CreatePipeline::set_notifications): <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>   <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>  </important>  <ul>   <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic. For more information, see Create a Topic in the Amazon Simple Notification Service Developer Guide.</p> </li>   <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>  </ul>
    ///   - [`content_config(PipelineOutputConfig)`](crate::client::fluent_builders::CreatePipeline::content_config) / [`set_content_config(Option<PipelineOutputConfig>)`](crate::client::fluent_builders::CreatePipeline::set_content_config): <p>The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>  <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code>.</p>  <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>  <ul>   <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>   <li> <p> <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>   <li> <p> <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object: </p>    <ul>     <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.</p> <important>       <p>A canonical user ID is not the same as an AWS account number.</p>      </important> </li>     <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>     <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>    </ul> </li>   <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group </p> </li>   <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include: </p>    <ul>     <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>    </ul> </li>   <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.</p> </li>  </ul>
    ///   - [`thumbnail_config(PipelineOutputConfig)`](crate::client::fluent_builders::CreatePipeline::thumbnail_config) / [`set_thumbnail_config(Option<PipelineOutputConfig>)`](crate::client::fluent_builders::CreatePipeline::set_thumbnail_config): <p>The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>  <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code> even if you don't want to create thumbnails.</p>  <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>  <ul>   <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.</p> </li>   <li> <p> <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>   <li> <p> <b>GranteeType</b>: Specify the type of value that appears in the Grantee object: </p>    <ul>     <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>       <p>A canonical user ID is not the same as an AWS account number.</p>      </important> </li>     <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account. </p> </li>     <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>    </ul> </li>   <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group. </p> </li>   <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include: </p>    <ul>     <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>    </ul> </li>   <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>  </ul>
    /// - On success, responds with [`CreatePipelineOutput`](crate::output::CreatePipelineOutput) with field(s):
    ///   - [`pipeline(Option<Pipeline>)`](crate::output::CreatePipelineOutput::pipeline): <p>A section of the response body that provides information about the pipeline that is created.</p>
    ///   - [`warnings(Option<Vec<Warning>>)`](crate::output::CreatePipelineOutput::warnings): <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the pipeline.</p>  <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    /// - On failure, responds with [`SdkError<CreatePipelineError>`](crate::error::CreatePipelineError)
    pub fn create_pipeline(&self) -> fluent_builders::CreatePipeline {
        fluent_builders::CreatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePreset`](crate::client::fluent_builders::CreatePreset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePreset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePreset::set_name): <p>The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePreset::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePreset::set_description): <p>A description of the preset.</p>
    ///   - [`container(impl Into<String>)`](crate::client::fluent_builders::CreatePreset::container) / [`set_container(Option<String>)`](crate::client::fluent_builders::CreatePreset::set_container): <p>The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
    ///   - [`video(VideoParameters)`](crate::client::fluent_builders::CreatePreset::video) / [`set_video(Option<VideoParameters>)`](crate::client::fluent_builders::CreatePreset::set_video): <p>A section of the request body that specifies the video parameters.</p>
    ///   - [`audio(AudioParameters)`](crate::client::fluent_builders::CreatePreset::audio) / [`set_audio(Option<AudioParameters>)`](crate::client::fluent_builders::CreatePreset::set_audio): <p>A section of the request body that specifies the audio parameters.</p>
    ///   - [`thumbnails(Thumbnails)`](crate::client::fluent_builders::CreatePreset::thumbnails) / [`set_thumbnails(Option<Thumbnails>)`](crate::client::fluent_builders::CreatePreset::set_thumbnails): <p>A section of the request body that specifies the thumbnail parameters, if any.</p>
    /// - On success, responds with [`CreatePresetOutput`](crate::output::CreatePresetOutput) with field(s):
    ///   - [`preset(Option<Preset>)`](crate::output::CreatePresetOutput::preset): <p>A section of the response body that provides information about the preset that is created.</p>
    ///   - [`warning(Option<String>)`](crate::output::CreatePresetOutput::warning): <p>If the preset settings don't comply with the standards for the video codec but Elastic Transcoder created the preset, this message explains the reason the preset settings don't meet the standard. Elastic Transcoder created the preset because the settings might produce acceptable output.</p>
    /// - On failure, responds with [`SdkError<CreatePresetError>`](crate::error::CreatePresetError)
    pub fn create_preset(&self) -> fluent_builders::CreatePreset {
        fluent_builders::CreatePreset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePipeline`](crate::client::fluent_builders::DeletePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeletePipeline::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeletePipeline::set_id): <p>The identifier of the pipeline that you want to delete.</p>
    /// - On success, responds with [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)

    /// - On failure, responds with [`SdkError<DeletePipelineError>`](crate::error::DeletePipelineError)
    pub fn delete_pipeline(&self) -> fluent_builders::DeletePipeline {
        fluent_builders::DeletePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePreset`](crate::client::fluent_builders::DeletePreset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeletePreset::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeletePreset::set_id): <p>The identifier of the preset for which you want to get detailed information.</p>
    /// - On success, responds with [`DeletePresetOutput`](crate::output::DeletePresetOutput)

    /// - On failure, responds with [`SdkError<DeletePresetError>`](crate::error::DeletePresetError)
    pub fn delete_preset(&self) -> fluent_builders::DeletePreset {
        fluent_builders::DeletePreset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobsByPipeline`](crate::client::fluent_builders::ListJobsByPipeline) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobsByPipeline::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::ListJobsByPipeline::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::ListJobsByPipeline::set_pipeline_id): <p>The ID of the pipeline for which you want to get job information.</p>
    ///   - [`ascending(impl Into<String>)`](crate::client::fluent_builders::ListJobsByPipeline::ascending) / [`set_ascending(Option<String>)`](crate::client::fluent_builders::ListJobsByPipeline::set_ascending): <p> To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>. </p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListJobsByPipeline::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListJobsByPipeline::set_page_token): <p> When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
    /// - On success, responds with [`ListJobsByPipelineOutput`](crate::output::ListJobsByPipelineOutput) with field(s):
    ///   - [`jobs(Option<Vec<Job>>)`](crate::output::ListJobsByPipelineOutput::jobs): <p>An array of <code>Job</code> objects that are in the specified pipeline.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListJobsByPipelineOutput::next_page_token): <p> A value that you use to access the second and subsequent pages of results, if any. When the jobs in the specified pipeline fit on one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
    /// - On failure, responds with [`SdkError<ListJobsByPipelineError>`](crate::error::ListJobsByPipelineError)
    pub fn list_jobs_by_pipeline(&self) -> fluent_builders::ListJobsByPipeline {
        fluent_builders::ListJobsByPipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobsByStatus`](crate::client::fluent_builders::ListJobsByStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobsByStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`status(impl Into<String>)`](crate::client::fluent_builders::ListJobsByStatus::status) / [`set_status(Option<String>)`](crate::client::fluent_builders::ListJobsByStatus::set_status): <p>To get information about all of the jobs associated with the current AWS account that have a given status, specify the following status: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.</p>
    ///   - [`ascending(impl Into<String>)`](crate::client::fluent_builders::ListJobsByStatus::ascending) / [`set_ascending(Option<String>)`](crate::client::fluent_builders::ListJobsByStatus::set_ascending): <p> To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>. </p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListJobsByStatus::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListJobsByStatus::set_page_token): <p> When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
    /// - On success, responds with [`ListJobsByStatusOutput`](crate::output::ListJobsByStatusOutput) with field(s):
    ///   - [`jobs(Option<Vec<Job>>)`](crate::output::ListJobsByStatusOutput::jobs): <p>An array of <code>Job</code> objects that have the specified status.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListJobsByStatusOutput::next_page_token): <p> A value that you use to access the second and subsequent pages of results, if any. When the jobs in the specified pipeline fit on one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
    /// - On failure, responds with [`SdkError<ListJobsByStatusError>`](crate::error::ListJobsByStatusError)
    pub fn list_jobs_by_status(&self) -> fluent_builders::ListJobsByStatus {
        fluent_builders::ListJobsByStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPipelines`](crate::client::fluent_builders::ListPipelines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPipelines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`ascending(impl Into<String>)`](crate::client::fluent_builders::ListPipelines::ascending) / [`set_ascending(Option<String>)`](crate::client::fluent_builders::ListPipelines::set_ascending): <p>To list pipelines in chronological order by the date and time that they were created, enter <code>true</code>. To list pipelines in reverse chronological order, enter <code>false</code>.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListPipelines::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListPipelines::set_page_token): <p>When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
    /// - On success, responds with [`ListPipelinesOutput`](crate::output::ListPipelinesOutput) with field(s):
    ///   - [`pipelines(Option<Vec<Pipeline>>)`](crate::output::ListPipelinesOutput::pipelines): <p>An array of <code>Pipeline</code> objects.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListPipelinesOutput::next_page_token): <p>A value that you use to access the second and subsequent pages of results, if any. When the pipelines fit on one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListPipelinesError>`](crate::error::ListPipelinesError)
    pub fn list_pipelines(&self) -> fluent_builders::ListPipelines {
        fluent_builders::ListPipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPresets`](crate::client::fluent_builders::ListPresets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPresets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`ascending(impl Into<String>)`](crate::client::fluent_builders::ListPresets::ascending) / [`set_ascending(Option<String>)`](crate::client::fluent_builders::ListPresets::set_ascending): <p>To list presets in chronological order by the date and time that they were created, enter <code>true</code>. To list presets in reverse chronological order, enter <code>false</code>.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListPresets::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListPresets::set_page_token): <p>When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
    /// - On success, responds with [`ListPresetsOutput`](crate::output::ListPresetsOutput) with field(s):
    ///   - [`presets(Option<Vec<Preset>>)`](crate::output::ListPresetsOutput::presets): <p>An array of <code>Preset</code> objects.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListPresetsOutput::next_page_token): <p>A value that you use to access the second and subsequent pages of results, if any. When the presets fit on one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListPresetsError>`](crate::error::ListPresetsError)
    pub fn list_presets(&self) -> fluent_builders::ListPresets {
        fluent_builders::ListPresets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReadJob`](crate::client::fluent_builders::ReadJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ReadJob::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ReadJob::set_id): <p>The identifier of the job for which you want to get detailed information.</p>
    /// - On success, responds with [`ReadJobOutput`](crate::output::ReadJobOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::ReadJobOutput::job): <p>A section of the response body that provides information about the job.</p>
    /// - On failure, responds with [`SdkError<ReadJobError>`](crate::error::ReadJobError)
    pub fn read_job(&self) -> fluent_builders::ReadJob {
        fluent_builders::ReadJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReadPipeline`](crate::client::fluent_builders::ReadPipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ReadPipeline::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ReadPipeline::set_id): <p>The identifier of the pipeline to read.</p>
    /// - On success, responds with [`ReadPipelineOutput`](crate::output::ReadPipelineOutput) with field(s):
    ///   - [`pipeline(Option<Pipeline>)`](crate::output::ReadPipelineOutput::pipeline): <p>A section of the response body that provides information about the pipeline.</p>
    ///   - [`warnings(Option<Vec<Warning>>)`](crate::output::ReadPipelineOutput::warnings): <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the pipeline.</p>  <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    /// - On failure, responds with [`SdkError<ReadPipelineError>`](crate::error::ReadPipelineError)
    pub fn read_pipeline(&self) -> fluent_builders::ReadPipeline {
        fluent_builders::ReadPipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReadPreset`](crate::client::fluent_builders::ReadPreset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ReadPreset::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ReadPreset::set_id): <p>The identifier of the preset for which you want to get detailed information.</p>
    /// - On success, responds with [`ReadPresetOutput`](crate::output::ReadPresetOutput) with field(s):
    ///   - [`preset(Option<Preset>)`](crate::output::ReadPresetOutput::preset): <p>A section of the response body that provides information about the preset.</p>
    /// - On failure, responds with [`SdkError<ReadPresetError>`](crate::error::ReadPresetError)
    pub fn read_preset(&self) -> fluent_builders::ReadPreset {
        fluent_builders::ReadPreset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestRole`](crate::client::fluent_builders::TestRole) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::TestRole::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::TestRole::set_role): <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to test.</p>
    ///   - [`input_bucket(impl Into<String>)`](crate::client::fluent_builders::TestRole::input_bucket) / [`set_input_bucket(Option<String>)`](crate::client::fluent_builders::TestRole::set_input_bucket): <p>The Amazon S3 bucket that contains media files to be transcoded. The action attempts to read from this bucket.</p>
    ///   - [`output_bucket(impl Into<String>)`](crate::client::fluent_builders::TestRole::output_bucket) / [`set_output_bucket(Option<String>)`](crate::client::fluent_builders::TestRole::set_output_bucket): <p>The Amazon S3 bucket that Elastic Transcoder writes transcoded media files to. The action attempts to read from this bucket.</p>
    ///   - [`topics(Vec<String>)`](crate::client::fluent_builders::TestRole::topics) / [`set_topics(Option<Vec<String>>)`](crate::client::fluent_builders::TestRole::set_topics): <p>The ARNs of one or more Amazon Simple Notification Service (Amazon SNS) topics that you want the action to send a test notification to.</p>
    /// - On success, responds with [`TestRoleOutput`](crate::output::TestRoleOutput) with field(s):
    ///   - [`success(Option<String>)`](crate::output::TestRoleOutput::success): <p>If the operation is successful, this value is <code>true</code>; otherwise, the value is <code>false</code>.</p>
    ///   - [`messages(Option<Vec<String>>)`](crate::output::TestRoleOutput::messages): <p>If the <code>Success</code> element contains <code>false</code>, this value is an array of one or more error messages that were generated during the test process.</p>
    /// - On failure, responds with [`SdkError<TestRoleError>`](crate::error::TestRoleError)
    pub fn test_role(&self) -> fluent_builders::TestRole {
        fluent_builders::TestRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePipeline`](crate::client::fluent_builders::UpdatePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePipeline::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePipeline::set_id): <p>The ID of the pipeline that you want to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdatePipeline::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdatePipeline::set_name): <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>  <p>Constraints: Maximum 40 characters</p>
    ///   - [`input_bucket(impl Into<String>)`](crate::client::fluent_builders::UpdatePipeline::input_bucket) / [`set_input_bucket(Option<String>)`](crate::client::fluent_builders::UpdatePipeline::set_input_bucket): <p>The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::UpdatePipeline::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::UpdatePipeline::set_role): <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.</p>
    ///   - [`aws_kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePipeline::aws_kms_key_arn) / [`set_aws_kms_key_arn(Option<String>)`](crate::client::fluent_builders::UpdatePipeline::set_aws_kms_key_arn): <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>  <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
    ///   - [`notifications(Notifications)`](crate::client::fluent_builders::UpdatePipeline::notifications) / [`set_notifications(Option<Notifications>)`](crate::client::fluent_builders::UpdatePipeline::set_notifications): <p>The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>   <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>  </important>  <ul>   <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>  </ul>
    ///   - [`content_config(PipelineOutputConfig)`](crate::client::fluent_builders::UpdatePipeline::content_config) / [`set_content_config(Option<PipelineOutputConfig>)`](crate::client::fluent_builders::UpdatePipeline::set_content_config): <p>The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>  <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code>.</p>  <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>  <ul>   <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>   <li> <p> <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>   <li> <p> <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:</p>    <ul>     <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.</p> <important>       <p>A canonical user ID is not the same as an AWS account number.</p>      </important> </li>     <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>     <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>    </ul> </li>   <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group </p> </li>   <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include: </p>    <ul>     <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket. </p> </li>     <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>    </ul> </li>   <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.</p> </li>  </ul>
    ///   - [`thumbnail_config(PipelineOutputConfig)`](crate::client::fluent_builders::UpdatePipeline::thumbnail_config) / [`set_thumbnail_config(Option<PipelineOutputConfig>)`](crate::client::fluent_builders::UpdatePipeline::set_thumbnail_config): <p>The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>  <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code> even if you don't want to create thumbnails.</p>  <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>  <ul>   <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.</p> </li>   <li> <p> <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>   <li> <p> <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:</p>    <ul>     <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>       <p>A canonical user ID is not the same as an AWS account number.</p>      </important> </li>     <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>     <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>    </ul> </li>   <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group. </p> </li>   <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include: </p>    <ul>     <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>     <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket. </p> </li>    </ul> </li>   <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>  </ul>
    /// - On success, responds with [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput) with field(s):
    ///   - [`pipeline(Option<Pipeline>)`](crate::output::UpdatePipelineOutput::pipeline): <p>The pipeline updated by this <code>UpdatePipelineResponse</code> call.</p>
    ///   - [`warnings(Option<Vec<Warning>>)`](crate::output::UpdatePipelineOutput::warnings): <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the pipeline.</p>  <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    /// - On failure, responds with [`SdkError<UpdatePipelineError>`](crate::error::UpdatePipelineError)
    pub fn update_pipeline(&self) -> fluent_builders::UpdatePipeline {
        fluent_builders::UpdatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePipelineNotifications`](crate::client::fluent_builders::UpdatePipelineNotifications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePipelineNotifications::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePipelineNotifications::set_id): <p>The identifier of the pipeline for which you want to change notification settings.</p>
    ///   - [`notifications(Notifications)`](crate::client::fluent_builders::UpdatePipelineNotifications::notifications) / [`set_notifications(Option<Notifications>)`](crate::client::fluent_builders::UpdatePipelineNotifications::set_notifications): <p>The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>   <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>  </important>  <ul>   <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>   <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>  </ul>
    /// - On success, responds with [`UpdatePipelineNotificationsOutput`](crate::output::UpdatePipelineNotificationsOutput) with field(s):
    ///   - [`pipeline(Option<Pipeline>)`](crate::output::UpdatePipelineNotificationsOutput::pipeline): <p>A section of the response body that provides information about the pipeline associated with this notification.</p>
    /// - On failure, responds with [`SdkError<UpdatePipelineNotificationsError>`](crate::error::UpdatePipelineNotificationsError)
    pub fn update_pipeline_notifications(&self) -> fluent_builders::UpdatePipelineNotifications {
        fluent_builders::UpdatePipelineNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePipelineStatus`](crate::client::fluent_builders::UpdatePipelineStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePipelineStatus::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePipelineStatus::set_id): <p>The identifier of the pipeline to update.</p>
    ///   - [`status(impl Into<String>)`](crate::client::fluent_builders::UpdatePipelineStatus::status) / [`set_status(Option<String>)`](crate::client::fluent_builders::UpdatePipelineStatus::set_status): <p>The desired status of the pipeline:</p>  <ul>   <li> <p> <code>Active</code>: The pipeline is processing jobs.</p> </li>   <li> <p> <code>Paused</code>: The pipeline is not currently processing jobs.</p> </li>  </ul>
    /// - On success, responds with [`UpdatePipelineStatusOutput`](crate::output::UpdatePipelineStatusOutput) with field(s):
    ///   - [`pipeline(Option<Pipeline>)`](crate::output::UpdatePipelineStatusOutput::pipeline): <p>A section of the response body that provides information about the pipeline.</p>
    /// - On failure, responds with [`SdkError<UpdatePipelineStatusError>`](crate::error::UpdatePipelineStatusError)
    pub fn update_pipeline_status(&self) -> fluent_builders::UpdatePipelineStatus {
        fluent_builders::UpdatePipelineStatus::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// <p>The CancelJob operation cancels an unfinished job.</p> <note>
    /// <p>You can only cancel a job that has a status of <code>Submitted</code>. To prevent a pipeline from starting to process a job while you're getting the job identifier, use <code>UpdatePipelineStatus</code> to temporarily pause the pipeline.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl CancelJob {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the job that you want to cancel.</p>
        /// <p>To get a list of the jobs (including their <code>jobId</code>) that have a status of <code>Submitted</code>, use the <code>ListJobsByStatus</code> API action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the job that you want to cancel.</p>
        /// <p>To get a list of the jobs (including their <code>jobId</code>) that have a status of <code>Submitted</code>, use the <code>ListJobsByStatus</code> API action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.</p>
    /// <p>If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_job_input::Builder,
    }
    impl CreateJob {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// <p>A section of the request body that provides information about the file that is being transcoded.</p>
        pub fn input(mut self, input: crate::model::JobInput) -> Self {
            self.inner = self.inner.input(input);
            self
        }
        /// <p>A section of the request body that provides information about the file that is being transcoded.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::JobInput>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// Appends an item to `Inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// <p>A section of the request body that provides information about the files that are being transcoded.</p>
        pub fn inputs(mut self, input: crate::model::JobInput) -> Self {
            self.inner = self.inner.inputs(input);
            self
        }
        /// <p>A section of the request body that provides information about the files that are being transcoded.</p>
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobInput>>,
        ) -> Self {
            self.inner = self.inner.set_inputs(input);
            self
        }
        /// <p> A section of the request body that provides information about the transcoded (target) file. We strongly recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax. </p>
        pub fn output(mut self, input: crate::model::CreateJobOutput) -> Self {
            self.inner = self.inner.output(input);
            self
        }
        /// <p> A section of the request body that provides information about the transcoded (target) file. We strongly recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax. </p>
        pub fn set_output(
            mut self,
            input: std::option::Option<crate::model::CreateJobOutput>,
        ) -> Self {
            self.inner = self.inner.set_output(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p> A section of the request body that provides information about the transcoded (target) files. We recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax. </p>
        pub fn outputs(mut self, input: crate::model::CreateJobOutput) -> Self {
            self.inner = self.inner.outputs(input);
            self
        }
        /// <p> A section of the request body that provides information about the transcoded (target) files. We recommend that you use the <code>Outputs</code> syntax instead of the <code>Output</code> syntax. </p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateJobOutput>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// <p>The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists.</p>
        pub fn output_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_key_prefix(input.into());
            self
        }
        /// <p>The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists.</p>
        pub fn set_output_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_key_prefix(input);
            self
        }
        /// Appends an item to `Playlists`.
        ///
        /// To override the contents of this collection use [`set_playlists`](Self::set_playlists).
        ///
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4 (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want Elastic Transcoder to create.</p>
        /// <p>The maximum number of master playlists in a job is 30.</p>
        pub fn playlists(mut self, input: crate::model::CreateJobPlaylist) -> Self {
            self.inner = self.inner.playlists(input);
            self
        }
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4 (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want Elastic Transcoder to create.</p>
        /// <p>The maximum number of master playlists in a job is 30.</p>
        pub fn set_playlists(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateJobPlaylist>>,
        ) -> Self {
            self.inner = self.inner.set_playlists(input);
            self
        }
        /// Adds a key-value pair to `UserMetadata`.
        ///
        /// To override the contents of this collection use [`set_user_metadata`](Self::set_user_metadata).
        ///
        /// <p>User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.</p>
        pub fn user_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.user_metadata(k.into(), v.into());
            self
        }
        /// <p>User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.</p>
        pub fn set_user_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_user_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePipeline`.
    ///
    /// <p>The CreatePipeline operation creates a pipeline with settings that you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pipeline_input::Builder,
    }
    impl CreatePipeline {
        /// Creates a new `CreatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        /// <p>Constraints: Maximum 40 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        /// <p>Constraints: Maximum 40 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon S3 bucket in which you saved the media files that you want to transcode.</p>
        pub fn input_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket in which you saved the media files that you want to transcode.</p>
        pub fn set_input_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_bucket(input);
            self
        }
        /// <p>The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. (Use this, or use ContentConfig:Bucket plus ThumbnailConfig:Bucket.)</p>
        /// <p>Specify this value when all of the following are true:</p>
        /// <ul>
        /// <li> <p>You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.</p> </li>
        /// <li> <p>You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.</p> </li>
        /// <li> <p>You do not want to specify the permissions that Elastic Transcoder grants to the files. </p> <important>
        /// <p>When Elastic Transcoder saves files in <code>OutputBucket</code>, it grants full control over the files only to the AWS account that owns the role that is specified by <code>Role</code>.</p>
        /// </important> </li>
        /// <li> <p>You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.</p> </li>
        /// </ul>
        /// <p>If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit <code>OutputBucket</code> and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead.</p>
        pub fn output_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. (Use this, or use ContentConfig:Bucket plus ThumbnailConfig:Bucket.)</p>
        /// <p>Specify this value when all of the following are true:</p>
        /// <ul>
        /// <li> <p>You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.</p> </li>
        /// <li> <p>You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.</p> </li>
        /// <li> <p>You do not want to specify the permissions that Elastic Transcoder grants to the files. </p> <important>
        /// <p>When Elastic Transcoder saves files in <code>OutputBucket</code>, it grants full control over the files only to the AWS account that owns the role that is specified by <code>Role</code>.</p>
        /// </important> </li>
        /// <li> <p>You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.</p> </li>
        /// </ul>
        /// <p>If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit <code>OutputBucket</code> and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead.</p>
        pub fn set_output_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_bucket(input);
            self
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to create the pipeline.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to create the pipeline.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
        /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
        pub fn aws_kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_kms_key_arn(input.into());
            self
        }
        /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
        /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
        pub fn set_aws_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_kms_key_arn(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic. For more information, see Create a Topic in the Amazon Simple Notification Service Developer Guide.</p> </li>
        /// <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// </ul>
        pub fn notifications(mut self, input: crate::model::Notifications) -> Self {
            self.inner = self.inner.notifications(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic. For more information, see Create a Topic in the Amazon Simple Notification Service Developer Guide.</p> </li>
        /// <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// </ul>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<crate::model::Notifications>,
        ) -> Self {
            self.inner = self.inner.set_notifications(input);
            self
        }
        /// <p>The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code>.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object: </p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn content_config(mut self, input: crate::model::PipelineOutputConfig) -> Self {
            self.inner = self.inner.content_config(input);
            self
        }
        /// <p>The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code>.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object: </p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_content_config(
            mut self,
            input: std::option::Option<crate::model::PipelineOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_content_config(input);
            self
        }
        /// <p>The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code> even if you don't want to create thumbnails.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>GranteeType</b>: Specify the type of value that appears in the Grantee object: </p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account. </p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group. </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn thumbnail_config(mut self, input: crate::model::PipelineOutputConfig) -> Self {
            self.inner = self.inner.thumbnail_config(input);
            self
        }
        /// <p>The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code> even if you don't want to create thumbnails.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>GranteeType</b>: Specify the type of value that appears in the Grantee object: </p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account. </p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group. </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_thumbnail_config(
            mut self,
            input: std::option::Option<crate::model::PipelineOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_thumbnail_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePreset`.
    ///
    /// <p>The CreatePreset operation creates a preset with settings that you specify.</p> <important>
    /// <p>Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (<code>ValidationException</code>) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.</p>
    /// </important>
    /// <p>Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication <i>Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePreset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_preset_input::Builder,
    }
    impl CreatePreset {
        /// Creates a new `CreatePreset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePresetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePresetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the preset.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the preset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
        pub fn container(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container(input.into());
            self
        }
        /// <p>The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
        pub fn set_container(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_container(input);
            self
        }
        /// <p>A section of the request body that specifies the video parameters.</p>
        pub fn video(mut self, input: crate::model::VideoParameters) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>A section of the request body that specifies the video parameters.</p>
        pub fn set_video(
            mut self,
            input: std::option::Option<crate::model::VideoParameters>,
        ) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>A section of the request body that specifies the audio parameters.</p>
        pub fn audio(mut self, input: crate::model::AudioParameters) -> Self {
            self.inner = self.inner.audio(input);
            self
        }
        /// <p>A section of the request body that specifies the audio parameters.</p>
        pub fn set_audio(
            mut self,
            input: std::option::Option<crate::model::AudioParameters>,
        ) -> Self {
            self.inner = self.inner.set_audio(input);
            self
        }
        /// <p>A section of the request body that specifies the thumbnail parameters, if any.</p>
        pub fn thumbnails(mut self, input: crate::model::Thumbnails) -> Self {
            self.inner = self.inner.thumbnails(input);
            self
        }
        /// <p>A section of the request body that specifies the thumbnail parameters, if any.</p>
        pub fn set_thumbnails(
            mut self,
            input: std::option::Option<crate::model::Thumbnails>,
        ) -> Self {
            self.inner = self.inner.set_thumbnails(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePipeline`.
    ///
    /// <p>The DeletePipeline operation removes a pipeline.</p>
    /// <p> You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, <code>DeletePipeline</code> returns an error. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_pipeline_input::Builder,
    }
    impl DeletePipeline {
        /// Creates a new `DeletePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the pipeline that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the pipeline that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePreset`.
    ///
    /// <p>The DeletePreset operation removes a preset that you've added in an AWS region.</p> <note>
    /// <p>You can't delete the default presets that are included with Elastic Transcoder.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePreset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_preset_input::Builder,
    }
    impl DeletePreset {
        /// Creates a new `DeletePreset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePresetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePresetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the preset for which you want to get detailed information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the preset for which you want to get detailed information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobsByPipeline`.
    ///
    /// <p>The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.</p>
    /// <p>Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobsByPipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_jobs_by_pipeline_input::Builder,
    }
    impl ListJobsByPipeline {
        /// Creates a new `ListJobsByPipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsByPipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsByPipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsByPipelinePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsByPipelinePaginator {
            crate::paginator::ListJobsByPipelinePaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the pipeline for which you want to get job information.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline for which you want to get job information.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// <p> To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>. </p>
        pub fn ascending(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ascending(input.into());
            self
        }
        /// <p> To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>. </p>
        pub fn set_ascending(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ascending(input);
            self
        }
        /// <p> When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p> When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobsByStatus`.
    ///
    /// <p>The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobsByStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_jobs_by_status_input::Builder,
    }
    impl ListJobsByStatus {
        /// Creates a new `ListJobsByStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsByStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsByStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsByStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsByStatusPaginator {
            crate::paginator::ListJobsByStatusPaginator::new(self.handle, self.inner)
        }
        /// <p>To get information about all of the jobs associated with the current AWS account that have a given status, specify the following status: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>To get information about all of the jobs associated with the current AWS account that have a given status, specify the following status: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p> To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>. </p>
        pub fn ascending(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ascending(input.into());
            self
        }
        /// <p> To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>. </p>
        pub fn set_ascending(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ascending(input);
            self
        }
        /// <p> When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p> When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPipelines`.
    ///
    /// <p>The ListPipelines operation gets a list of the pipelines associated with the current AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPipelines {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pipelines_input::Builder,
    }
    impl ListPipelines {
        /// Creates a new `ListPipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPipelinesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPipelinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPipelinesPaginator {
            crate::paginator::ListPipelinesPaginator::new(self.handle, self.inner)
        }
        /// <p>To list pipelines in chronological order by the date and time that they were created, enter <code>true</code>. To list pipelines in reverse chronological order, enter <code>false</code>.</p>
        pub fn ascending(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ascending(input.into());
            self
        }
        /// <p>To list pipelines in chronological order by the date and time that they were created, enter <code>true</code>. To list pipelines in reverse chronological order, enter <code>false</code>.</p>
        pub fn set_ascending(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ascending(input);
            self
        }
        /// <p>When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPresets`.
    ///
    /// <p>The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPresets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_presets_input::Builder,
    }
    impl ListPresets {
        /// Creates a new `ListPresets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPresetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPresetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPresetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPresetsPaginator {
            crate::paginator::ListPresetsPaginator::new(self.handle, self.inner)
        }
        /// <p>To list presets in chronological order by the date and time that they were created, enter <code>true</code>. To list presets in reverse chronological order, enter <code>false</code>.</p>
        pub fn ascending(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ascending(input.into());
            self
        }
        /// <p>To list presets in chronological order by the date and time that they were created, enter <code>true</code>. To list presets in reverse chronological order, enter <code>false</code>.</p>
        pub fn set_ascending(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ascending(input);
            self
        }
        /// <p>When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent <code>GET</code> requests to get each successive page of results. </p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReadJob`.
    ///
    /// <p>The ReadJob operation returns detailed information about a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReadJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::read_job_input::Builder,
    }
    impl ReadJob {
        /// Creates a new `ReadJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReadJobOutput,
            aws_smithy_http::result::SdkError<crate::error::ReadJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the job for which you want to get detailed information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the job for which you want to get detailed information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReadPipeline`.
    ///
    /// <p>The ReadPipeline operation gets detailed information about a pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReadPipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::read_pipeline_input::Builder,
    }
    impl ReadPipeline {
        /// Creates a new `ReadPipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReadPipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::ReadPipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the pipeline to read.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the pipeline to read.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReadPreset`.
    ///
    /// <p>The ReadPreset operation gets detailed information about a preset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReadPreset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::read_preset_input::Builder,
    }
    impl ReadPreset {
        /// Creates a new `ReadPreset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReadPresetOutput,
            aws_smithy_http::result::SdkError<crate::error::ReadPresetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the preset for which you want to get detailed information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the preset for which you want to get detailed information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestRole`.
    ///
    /// <p>The TestRole operation tests the IAM role used to create the pipeline.</p>
    /// <p>The <code>TestRole</code> action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_role_input::Builder,
    }
    impl TestRole {
        /// Creates a new `TestRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::TestRoleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to test.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to test.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The Amazon S3 bucket that contains media files to be transcoded. The action attempts to read from this bucket.</p>
        pub fn input_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket that contains media files to be transcoded. The action attempts to read from this bucket.</p>
        pub fn set_input_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_bucket(input);
            self
        }
        /// <p>The Amazon S3 bucket that Elastic Transcoder writes transcoded media files to. The action attempts to read from this bucket.</p>
        pub fn output_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket that Elastic Transcoder writes transcoded media files to. The action attempts to read from this bucket.</p>
        pub fn set_output_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_bucket(input);
            self
        }
        /// Appends an item to `Topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The ARNs of one or more Amazon Simple Notification Service (Amazon SNS) topics that you want the action to send a test notification to.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topics(input.into());
            self
        }
        /// <p>The ARNs of one or more Amazon Simple Notification Service (Amazon SNS) topics that you want the action to send a test notification to.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_topics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePipeline`.
    ///
    /// <p> Use the <code>UpdatePipeline</code> operation to update settings for a pipeline.</p> <important>
    /// <p>When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pipeline_input::Builder,
    }
    impl UpdatePipeline {
        /// Creates a new `UpdatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline that you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the pipeline that you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        /// <p>Constraints: Maximum 40 characters</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        /// <p>Constraints: Maximum 40 characters</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.</p>
        pub fn input_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.</p>
        pub fn set_input_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_bucket(input);
            self
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
        /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
        pub fn aws_kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_kms_key_arn(input.into());
            self
        }
        /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
        /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
        pub fn set_aws_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_kms_key_arn(input);
            self
        }
        /// <p>The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// </ul>
        pub fn notifications(mut self, input: crate::model::Notifications) -> Self {
            self.inner = self.inner.notifications(input);
            self
        }
        /// <p>The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// </ul>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<crate::model::Notifications>,
        ) -> Self {
            self.inner = self.inner.set_notifications(input);
            self
        }
        /// <p>The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code>.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:</p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket. </p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn content_config(mut self, input: crate::model::PipelineOutputConfig) -> Self {
            self.inner = self.inner.content_config(input);
            self
        }
        /// <p>The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code>.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:</p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket. </p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_content_config(
            mut self,
            input: std::option::Option<crate::model::PipelineOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_content_config(input);
            self
        }
        /// <p>The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code> even if you don't want to create thumbnails.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:</p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group. </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket. </p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn thumbnail_config(mut self, input: crate::model::PipelineOutputConfig) -> Self {
            self.inner = self.inner.thumbnail_config(input);
            self
        }
        /// <p>The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.</p>
        /// <p>If you specify values for <code>ContentConfig</code>, you must also specify values for <code>ThumbnailConfig</code> even if you don't want to create thumbnails.</p>
        /// <p>If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the <code>OutputBucket</code> object.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.</p> </li>
        /// <li> <p> <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p> </li>
        /// <li> <p> <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:</p>
        /// <ul>
        /// <li> <p> <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.</p> </li>
        /// <li> <p> <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group. </p> </li>
        /// <li> <p> <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket. </p> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_thumbnail_config(
            mut self,
            input: std::option::Option<crate::model::PipelineOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_thumbnail_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePipelineNotifications`.
    ///
    /// <p>With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.</p>
    /// <p>When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePipelineNotifications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pipeline_notifications_input::Builder,
    }
    impl UpdatePipelineNotifications {
        /// Creates a new `UpdatePipelineNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePipelineNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePipelineNotificationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the pipeline for which you want to change notification settings.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the pipeline for which you want to change notification settings.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// </ul>
        pub fn notifications(mut self, input: crate::model::Notifications) -> Self {
            self.inner = self.inner.notifications(input);
            self
        }
        /// <p>The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// <li> <p> <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.</p> </li>
        /// </ul>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<crate::model::Notifications>,
        ) -> Self {
            self.inner = self.inner.set_notifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePipelineStatus`.
    ///
    /// <p>The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.</p>
    /// <p>Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a <code>CancelJob</code> request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePipelineStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pipeline_status_input::Builder,
    }
    impl UpdatePipelineStatus {
        /// Creates a new `UpdatePipelineStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePipelineStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePipelineStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the pipeline to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the pipeline to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The desired status of the pipeline:</p>
        /// <ul>
        /// <li> <p> <code>Active</code>: The pipeline is processing jobs.</p> </li>
        /// <li> <p> <code>Paused</code>: The pipeline is not currently processing jobs.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>The desired status of the pipeline:</p>
        /// <ul>
        /// <li> <p> <code>Active</code>: The pipeline is processing jobs.</p> </li>
        /// <li> <p> <code>Paused</code>: The pipeline is not currently processing jobs.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
