// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelJobError {
    /// Kind of error that occurred.
    pub kind: CancelJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelJobErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The resource you are attempting to change is in use. For example, you are attempting to delete a pipeline that is currently in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelJobError {
    fn code(&self) -> Option<&str> {
        CancelJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelJobError {
    /// Creates a new `CancelJobError`.
    pub fn new(kind: CancelJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CancelJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelJobErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            CancelJobErrorKind::InternalServiceException(_inner) => Some(_inner),
            CancelJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CancelJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelJobErrorKind::ValidationException(_inner) => Some(_inner),
            CancelJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobError {
    /// Kind of error that occurred.
    pub kind: CreateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Too many operations for a given AWS account. For example, the number of pipelines exceeds the maximum allowed.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobError {
    fn code(&self) -> Option<&str> {
        CreateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobError {
    /// Creates a new `CreateJobError`.
    pub fn new(kind: CreateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateJobErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            CreateJobErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateJobErrorKind::ValidationException(_inner) => Some(_inner),
            CreateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePipelineError {
    /// Kind of error that occurred.
    pub kind: CreatePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePipelineErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Too many operations for a given AWS account. For example, the number of pipelines exceeds the maximum allowed.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePipelineErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePipelineError {
    fn code(&self) -> Option<&str> {
        CreatePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePipelineError {
    /// Creates a new `CreatePipelineError`.
    pub fn new(kind: CreatePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePipelineErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePipelineErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            CreatePipelineErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreatePipelineErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePipelineErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePresetError {
    /// Kind of error that occurred.
    pub kind: CreatePresetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePresetErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Too many operations for a given AWS account. For example, the number of pipelines exceeds the maximum allowed.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePresetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePresetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePresetError {
    fn code(&self) -> Option<&str> {
        CreatePresetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePresetError {
    /// Creates a new `CreatePresetError`.
    pub fn new(kind: CreatePresetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePresetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePresetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePresetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePresetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreatePresetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePresetErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePresetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreatePresetErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePresetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePresetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePresetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePresetErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            CreatePresetErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreatePresetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePresetErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePresetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePipelineError {
    /// Kind of error that occurred.
    pub kind: DeletePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePipelineErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The resource you are attempting to change is in use. For example, you are attempting to delete a pipeline that is currently in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePipelineErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePipelineError {
    fn code(&self) -> Option<&str> {
        DeletePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePipelineError {
    /// Creates a new `DeletePipelineError`.
    pub fn new(kind: DeletePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePipelineErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePipelineErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            DeletePipelineErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeletePipelineErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeletePipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePipelineErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePresetError {
    /// Kind of error that occurred.
    pub kind: DeletePresetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePresetErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePresetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePresetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePresetError {
    fn code(&self) -> Option<&str> {
        DeletePresetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePresetError {
    /// Creates a new `DeletePresetError`.
    pub fn new(kind: DeletePresetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePresetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePresetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePresetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePresetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeletePresetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePresetErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePresetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePresetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePresetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePresetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePresetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePresetErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            DeletePresetErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeletePresetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePresetErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePresetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobsByPipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsByPipelineError {
    /// Kind of error that occurred.
    pub kind: ListJobsByPipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobsByPipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsByPipelineErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsByPipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsByPipelineErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListJobsByPipelineErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            ListJobsByPipelineErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListJobsByPipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListJobsByPipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListJobsByPipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsByPipelineError {
    fn code(&self) -> Option<&str> {
        ListJobsByPipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsByPipelineError {
    /// Creates a new `ListJobsByPipelineError`.
    pub fn new(kind: ListJobsByPipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsByPipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsByPipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsByPipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsByPipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsByPipelineErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByPipelineErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByPipelineErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByPipelineErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByPipelineErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByPipelineErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByPipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByPipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByPipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByPipelineErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListJobsByPipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsByPipelineErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListJobsByPipelineErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            ListJobsByPipelineErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListJobsByPipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListJobsByPipelineErrorKind::ValidationException(_inner) => Some(_inner),
            ListJobsByPipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobsByStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsByStatusError {
    /// Kind of error that occurred.
    pub kind: ListJobsByStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobsByStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsByStatusErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsByStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsByStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListJobsByStatusErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            ListJobsByStatusErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListJobsByStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListJobsByStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListJobsByStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsByStatusError {
    fn code(&self) -> Option<&str> {
        ListJobsByStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsByStatusError {
    /// Creates a new `ListJobsByStatusError`.
    pub fn new(kind: ListJobsByStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsByStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsByStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsByStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsByStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsByStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByStatusErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByStatusErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByStatusErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByStatusErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsByStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsByStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListJobsByStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsByStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListJobsByStatusErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            ListJobsByStatusErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListJobsByStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListJobsByStatusErrorKind::ValidationException(_inner) => Some(_inner),
            ListJobsByStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPipelinesError {
    /// Kind of error that occurred.
    pub kind: ListPipelinesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPipelinesErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPipelinesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPipelinesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPipelinesError {
    fn code(&self) -> Option<&str> {
        ListPipelinesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPipelinesError {
    /// Creates a new `ListPipelinesError`.
    pub fn new(kind: ListPipelinesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPipelinesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPipelinesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPipelinesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPipelinesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListPipelinesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelinesErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelinesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListPipelinesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListPipelinesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPipelinesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPipelinesErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            ListPipelinesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListPipelinesErrorKind::ValidationException(_inner) => Some(_inner),
            ListPipelinesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPresets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPresetsError {
    /// Kind of error that occurred.
    pub kind: ListPresetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPresets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPresetsErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPresetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPresetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPresetsError {
    fn code(&self) -> Option<&str> {
        ListPresetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPresetsError {
    /// Creates a new `ListPresetsError`.
    pub fn new(kind: ListPresetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPresetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPresetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPresetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPresetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListPresetsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPresetsErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPresetsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListPresetsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListPresetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPresetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPresetsErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            ListPresetsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListPresetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPresetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReadJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReadJobError {
    /// Kind of error that occurred.
    pub kind: ReadJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReadJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReadJobErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReadJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReadJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ReadJobErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            ReadJobErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ReadJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ReadJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ReadJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReadJobError {
    fn code(&self) -> Option<&str> {
        ReadJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReadJobError {
    /// Creates a new `ReadJobError`.
    pub fn new(kind: ReadJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReadJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReadJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReadJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReadJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReadJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ReadJobErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ReadJobErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReadJobErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `ReadJobErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ReadJobErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ReadJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ReadJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ReadJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ReadJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ReadJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReadJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ReadJobErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            ReadJobErrorKind::InternalServiceException(_inner) => Some(_inner),
            ReadJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ReadJobErrorKind::ValidationException(_inner) => Some(_inner),
            ReadJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReadPipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReadPipelineError {
    /// Kind of error that occurred.
    pub kind: ReadPipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReadPipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReadPipelineErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReadPipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReadPipelineErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ReadPipelineErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            ReadPipelineErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ReadPipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ReadPipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ReadPipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReadPipelineError {
    fn code(&self) -> Option<&str> {
        ReadPipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReadPipelineError {
    /// Creates a new `ReadPipelineError`.
    pub fn new(kind: ReadPipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReadPipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReadPipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReadPipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReadPipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReadPipelineErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ReadPipelineErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ReadPipelineErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReadPipelineErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `ReadPipelineErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReadPipelineErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ReadPipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReadPipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ReadPipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ReadPipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ReadPipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReadPipelineErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ReadPipelineErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            ReadPipelineErrorKind::InternalServiceException(_inner) => Some(_inner),
            ReadPipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ReadPipelineErrorKind::ValidationException(_inner) => Some(_inner),
            ReadPipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReadPreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReadPresetError {
    /// Kind of error that occurred.
    pub kind: ReadPresetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReadPreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReadPresetErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReadPresetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReadPresetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ReadPresetErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            ReadPresetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ReadPresetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ReadPresetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ReadPresetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReadPresetError {
    fn code(&self) -> Option<&str> {
        ReadPresetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReadPresetError {
    /// Creates a new `ReadPresetError`.
    pub fn new(kind: ReadPresetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReadPresetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReadPresetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReadPresetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReadPresetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReadPresetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ReadPresetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ReadPresetErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReadPresetErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `ReadPresetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ReadPresetErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ReadPresetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReadPresetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ReadPresetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ReadPresetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ReadPresetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReadPresetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ReadPresetErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            ReadPresetErrorKind::InternalServiceException(_inner) => Some(_inner),
            ReadPresetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ReadPresetErrorKind::ValidationException(_inner) => Some(_inner),
            ReadPresetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestRoleError {
    /// Kind of error that occurred.
    pub kind: TestRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestRoleErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestRoleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TestRoleErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            TestRoleErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            TestRoleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TestRoleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TestRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestRoleError {
    fn code(&self) -> Option<&str> {
        TestRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestRoleError {
    /// Creates a new `TestRoleError`.
    pub fn new(kind: TestRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestRoleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestRoleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TestRoleErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TestRoleErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRoleErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRoleErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, TestRoleErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `TestRoleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, TestRoleErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `TestRoleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TestRoleErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TestRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestRoleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TestRoleErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            TestRoleErrorKind::InternalServiceException(_inner) => Some(_inner),
            TestRoleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TestRoleErrorKind::ValidationException(_inner) => Some(_inner),
            TestRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePipelineError {
    /// Kind of error that occurred.
    pub kind: UpdatePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePipelineErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The resource you are attempting to change is in use. For example, you are attempting to delete a pipeline that is currently in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePipelineErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePipelineError {
    fn code(&self) -> Option<&str> {
        UpdatePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePipelineError {
    /// Creates a new `UpdatePipelineError`.
    pub fn new(kind: UpdatePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdatePipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdatePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePipelineErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePipelineNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePipelineNotificationsError {
    /// Kind of error that occurred.
    pub kind: UpdatePipelineNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePipelineNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePipelineNotificationsErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The resource you are attempting to change is in use. For example, you are attempting to delete a pipeline that is currently in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePipelineNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePipelineNotificationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePipelineNotificationsErrorKind::IncompatibleVersionException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePipelineNotificationsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdatePipelineNotificationsErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdatePipelineNotificationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePipelineNotificationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePipelineNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePipelineNotificationsError {
    fn code(&self) -> Option<&str> {
        UpdatePipelineNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePipelineNotificationsError {
    /// Creates a new `UpdatePipelineNotificationsError`.
    pub fn new(kind: UpdatePipelineNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePipelineNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePipelineNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePipelineNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePipelineNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePipelineNotificationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineNotificationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineNotificationsErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineNotificationsErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineNotificationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineNotificationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineNotificationsErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineNotificationsErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineNotificationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineNotificationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineNotificationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineNotificationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePipelineNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePipelineNotificationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePipelineNotificationsErrorKind::IncompatibleVersionException(_inner) => {
                Some(_inner)
            }
            UpdatePipelineNotificationsErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdatePipelineNotificationsErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdatePipelineNotificationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePipelineNotificationsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePipelineNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePipelineStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePipelineStatusError {
    /// Kind of error that occurred.
    pub kind: UpdatePipelineStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePipelineStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePipelineStatusErrorKind {
    /// <p>General authentication failure. The request was not signed correctly.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleVersionException(crate::error::IncompatibleVersionException),
    /// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The resource you are attempting to change is in use. For example, you are attempting to delete a pipeline that is currently in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more required parameter values were not provided in the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePipelineStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePipelineStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePipelineStatusErrorKind::IncompatibleVersionException(_inner) => _inner.fmt(f),
            UpdatePipelineStatusErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdatePipelineStatusErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdatePipelineStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePipelineStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePipelineStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePipelineStatusError {
    fn code(&self) -> Option<&str> {
        UpdatePipelineStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePipelineStatusError {
    /// Creates a new `UpdatePipelineStatusError`.
    pub fn new(kind: UpdatePipelineStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePipelineStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePipelineStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePipelineStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePipelineStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePipelineStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineStatusErrorKind::IncompatibleVersionException`.
    pub fn is_incompatible_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineStatusErrorKind::IncompatibleVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineStatusErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineStatusErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineStatusErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineStatusErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePipelineStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePipelineStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePipelineStatusErrorKind::IncompatibleVersionException(_inner) => Some(_inner),
            UpdatePipelineStatusErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdatePipelineStatusErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdatePipelineStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePipelineStatusErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePipelineStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>One or more required parameter values were not provided in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The requested resource does not exist or is not available. For example, the pipeline to which you're trying to add a job doesn't exist or is still being created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The resource you are attempting to change is in use. For example, you are attempting to delete a pipeline that is currently in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>Elastic Transcoder encountered an unexpected exception while trying to fulfill the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleVersionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatibleVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleVersionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleVersionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatibleVersionException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleVersionException {}
/// See [`IncompatibleVersionException`](crate::error::IncompatibleVersionException)
pub mod incompatible_version_exception {
    /// A builder for [`IncompatibleVersionException`](crate::error::IncompatibleVersionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleVersionException`](crate::error::IncompatibleVersionException)
        pub fn build(self) -> crate::error::IncompatibleVersionException {
            crate::error::IncompatibleVersionException {
                message: self.message,
            }
        }
    }
}
impl IncompatibleVersionException {
    /// Creates a new builder-style object to manufacture [`IncompatibleVersionException`](crate::error::IncompatibleVersionException)
    pub fn builder() -> crate::error::incompatible_version_exception::Builder {
        crate::error::incompatible_version_exception::Builder::default()
    }
}

/// <p>General authentication failure. The request was not signed correctly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Too many operations for a given AWS account. For example, the number of pipelines exceeds the maximum allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
