// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The pipeline (queue) that is used to manage jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Pipeline {
    /// <p>The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a variety of operations, such as creating a job or a preset.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the pipeline.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
    /// <p>Constraints: Maximum 40 characters</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the pipeline:</p>
    /// <ul>
    /// <li> <p> <code>Active</code>: The pipeline is processing jobs.</p> </li>
    /// <li> <p> <code>Paused</code>: The pipeline is not currently processing jobs.</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files, if any, that you want to use for watermarks.</p>
    pub input_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and playlists. Either you specify this value, or you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>.</p>
    pub output_bucket: std::option::Option<std::string::String>,
    /// <p>The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this pipeline.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
    /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
    pub aws_kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
    /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
    /// </important>
    /// <ul>
    /// <li> <p> <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p> </li>
    /// <li> <p> <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p> </li>
    /// <li> <p> <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p> </li>
    /// <li> <p> <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p> </li>
    /// </ul>
    pub notifications: std::option::Option<crate::model::Notifications>,
    /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
    /// <ul>
    /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
    /// <li> <p> <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access that you want them to have. </p>
    /// <ul>
    /// <li> <p>GranteeType: The type of value that appears in the <code>Grantee</code> object: </p>
    /// <ul>
    /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> </li>
    /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
    /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and playlists.</p> </li>
    /// <li> <p> <code>Access</code>: The permission that you want to give to the AWS user that is listed in <code>Grantee</code>. Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p> </li>
    /// </ul>
    pub content_config: std::option::Option<crate::model::PipelineOutputConfig>,
    /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
    /// <ul>
    /// <li> <p> <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. </p> </li>
    /// <li> <p> <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access that you want them to have. </p>
    /// <ul>
    /// <li> <p>GranteeType: The type of value that appears in the Grantee object:</p>
    /// <ul>
    /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
    /// <p>A canonical user ID is not the same as an AWS account number.</p>
    /// </important> </li>
    /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
    /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.</p> </li>
    /// <li> <p>Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
    /// <ul>
    /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p> <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
    /// </ul>
    pub thumbnail_config: std::option::Option<crate::model::PipelineOutputConfig>,
}
impl Pipeline {
    /// <p>The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a variety of operations, such as creating a job or a preset.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the pipeline.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
    /// <p>Constraints: Maximum 40 characters</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the pipeline:</p>
    /// <ul>
    /// <li> <p> <code>Active</code>: The pipeline is processing jobs.</p> </li>
    /// <li> <p> <code>Paused</code>: The pipeline is not currently processing jobs.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files, if any, that you want to use for watermarks.</p>
    pub fn input_bucket(&self) -> std::option::Option<&str> {
        self.input_bucket.as_deref()
    }
    /// <p>The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and playlists. Either you specify this value, or you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>.</p>
    pub fn output_bucket(&self) -> std::option::Option<&str> {
        self.output_bucket.as_deref()
    }
    /// <p>The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this pipeline.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
    /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
    pub fn aws_kms_key_arn(&self) -> std::option::Option<&str> {
        self.aws_kms_key_arn.as_deref()
    }
    /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
    /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
    /// </important>
    /// <ul>
    /// <li> <p> <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p> </li>
    /// <li> <p> <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p> </li>
    /// <li> <p> <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p> </li>
    /// <li> <p> <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p> </li>
    /// </ul>
    pub fn notifications(&self) -> std::option::Option<&crate::model::Notifications> {
        self.notifications.as_ref()
    }
    /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
    /// <ul>
    /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
    /// <li> <p> <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access that you want them to have. </p>
    /// <ul>
    /// <li> <p>GranteeType: The type of value that appears in the <code>Grantee</code> object: </p>
    /// <ul>
    /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> </li>
    /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
    /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and playlists.</p> </li>
    /// <li> <p> <code>Access</code>: The permission that you want to give to the AWS user that is listed in <code>Grantee</code>. Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p> </li>
    /// </ul>
    pub fn content_config(&self) -> std::option::Option<&crate::model::PipelineOutputConfig> {
        self.content_config.as_ref()
    }
    /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
    /// <ul>
    /// <li> <p> <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. </p> </li>
    /// <li> <p> <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access that you want them to have. </p>
    /// <ul>
    /// <li> <p>GranteeType: The type of value that appears in the Grantee object:</p>
    /// <ul>
    /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
    /// <p>A canonical user ID is not the same as an AWS account number.</p>
    /// </important> </li>
    /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
    /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.</p> </li>
    /// <li> <p>Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
    /// <ul>
    /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p> <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
    /// </ul>
    pub fn thumbnail_config(&self) -> std::option::Option<&crate::model::PipelineOutputConfig> {
        self.thumbnail_config.as_ref()
    }
}
impl std::fmt::Debug for Pipeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Pipeline");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("input_bucket", &self.input_bucket);
        formatter.field("output_bucket", &self.output_bucket);
        formatter.field("role", &self.role);
        formatter.field("aws_kms_key_arn", &self.aws_kms_key_arn);
        formatter.field("notifications", &self.notifications);
        formatter.field("content_config", &self.content_config);
        formatter.field("thumbnail_config", &self.thumbnail_config);
        formatter.finish()
    }
}
/// See [`Pipeline`](crate::model::Pipeline)
pub mod pipeline {
    /// A builder for [`Pipeline`](crate::model::Pipeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) input_bucket: std::option::Option<std::string::String>,
        pub(crate) output_bucket: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) aws_kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) notifications: std::option::Option<crate::model::Notifications>,
        pub(crate) content_config: std::option::Option<crate::model::PipelineOutputConfig>,
        pub(crate) thumbnail_config: std::option::Option<crate::model::PipelineOutputConfig>,
    }
    impl Builder {
        /// <p>The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a variety of operations, such as creating a job or a preset.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a variety of operations, such as creating a job or a preset.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the pipeline.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the pipeline.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        /// <p>Constraints: Maximum 40 characters</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.</p>
        /// <p>Constraints: Maximum 40 characters</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the pipeline:</p>
        /// <ul>
        /// <li> <p> <code>Active</code>: The pipeline is processing jobs.</p> </li>
        /// <li> <p> <code>Paused</code>: The pipeline is not currently processing jobs.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the pipeline:</p>
        /// <ul>
        /// <li> <p> <code>Active</code>: The pipeline is processing jobs.</p> </li>
        /// <li> <p> <code>Paused</code>: The pipeline is not currently processing jobs.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files, if any, that you want to use for watermarks.</p>
        pub fn input_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files, if any, that you want to use for watermarks.</p>
        pub fn set_input_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_bucket = input;
            self
        }
        /// <p>The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and playlists. Either you specify this value, or you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>.</p>
        pub fn output_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and playlists. Either you specify this value, or you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>.</p>
        pub fn set_output_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_bucket = input;
            self
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this pipeline.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this pipeline.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
        /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
        pub fn aws_kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_kms_key_arn = Some(input.into());
            self
        }
        /// <p>The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
        /// <p>If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.</p>
        pub fn set_aws_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_kms_key_arn = input;
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p> </li>
        /// <li> <p> <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p> </li>
        /// <li> <p> <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p> </li>
        /// <li> <p> <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p> </li>
        /// </ul>
        pub fn notifications(mut self, input: crate::model::Notifications) -> Self {
            self.notifications = Some(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.</p> <important>
        /// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
        /// </important>
        /// <ul>
        /// <li> <p> <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p> </li>
        /// <li> <p> <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p> </li>
        /// <li> <p> <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p> </li>
        /// <li> <p> <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p> </li>
        /// </ul>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<crate::model::Notifications>,
        ) -> Self {
            self.notifications = input;
            self
        }
        /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
        /// <li> <p> <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access that you want them to have. </p>
        /// <ul>
        /// <li> <p>GranteeType: The type of value that appears in the <code>Grantee</code> object: </p>
        /// <ul>
        /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> </li>
        /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
        /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and playlists.</p> </li>
        /// <li> <p> <code>Access</code>: The permission that you want to give to the AWS user that is listed in <code>Grantee</code>. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p> </li>
        /// </ul>
        pub fn content_config(mut self, input: crate::model::PipelineOutputConfig) -> Self {
            self.content_config = Some(input);
            self
        }
        /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
        /// <ul>
        /// <li> <p> <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.</p> </li>
        /// <li> <p> <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access that you want them to have. </p>
        /// <ul>
        /// <li> <p>GranteeType: The type of value that appears in the <code>Grantee</code> object: </p>
        /// <ul>
        /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> </li>
        /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
        /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and playlists.</p> </li>
        /// <li> <p> <code>Access</code>: The permission that you want to give to the AWS user that is listed in <code>Grantee</code>. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// <li> <p> <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p> </li>
        /// </ul>
        pub fn set_content_config(
            mut self,
            input: std::option::Option<crate::model::PipelineOutputConfig>,
        ) -> Self {
            self.content_config = input;
            self
        }
        /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
        /// <ul>
        /// <li> <p> <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. </p> </li>
        /// <li> <p> <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access that you want them to have. </p>
        /// <ul>
        /// <li> <p>GranteeType: The type of value that appears in the Grantee object:</p>
        /// <ul>
        /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
        /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.</p> </li>
        /// <li> <p>Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// <li> <p> <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn thumbnail_config(mut self, input: crate::model::PipelineOutputConfig) -> Self {
            self.thumbnail_config = Some(input);
            self
        }
        /// <p>Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify <code>OutputBucket</code>.</p>
        /// <ul>
        /// <li> <p> <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. </p> </li>
        /// <li> <p> <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access that you want them to have. </p>
        /// <ul>
        /// <li> <p>GranteeType: The type of value that appears in the Grantee object:</p>
        /// <ul>
        /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
        /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.</p> </li>
        /// <li> <p>Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// <li> <p> <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_thumbnail_config(
            mut self,
            input: std::option::Option<crate::model::PipelineOutputConfig>,
        ) -> Self {
            self.thumbnail_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Pipeline`](crate::model::Pipeline)
        pub fn build(self) -> crate::model::Pipeline {
            crate::model::Pipeline {
                id: self.id,
                arn: self.arn,
                name: self.name,
                status: self.status,
                input_bucket: self.input_bucket,
                output_bucket: self.output_bucket,
                role: self.role,
                aws_kms_key_arn: self.aws_kms_key_arn,
                notifications: self.notifications,
                content_config: self.content_config,
                thumbnail_config: self.thumbnail_config,
            }
        }
    }
}
impl Pipeline {
    /// Creates a new builder-style object to manufacture [`Pipeline`](crate::model::Pipeline)
    pub fn builder() -> crate::model::pipeline::Builder {
        crate::model::pipeline::Builder::default()
    }
}

/// <p>The <code>PipelineOutputConfig</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineOutputConfig {
    /// <p> The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value when all of the following are true:</p>
    /// <ul>
    /// <li> <p>You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.</p> </li>
    /// <li> <p>You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.</p> </li>
    /// <li> <p>You do not want to specify the permissions that Elastic Transcoder grants to the files.</p> </li>
    /// <li> <p>You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.</p> </li>
    /// </ul>
    /// <p>If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit OutputBucket and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p> The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p>
    pub storage_class: std::option::Option<std::string::String>,
    /// <p>Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p>
    /// <p>If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that user to have full control, you must explicitly grant full control to the user.</p>
    /// <p> If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any other user or group.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
}
impl PipelineOutputConfig {
    /// <p> The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value when all of the following are true:</p>
    /// <ul>
    /// <li> <p>You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.</p> </li>
    /// <li> <p>You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.</p> </li>
    /// <li> <p>You do not want to specify the permissions that Elastic Transcoder grants to the files.</p> </li>
    /// <li> <p>You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.</p> </li>
    /// </ul>
    /// <p>If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit OutputBucket and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p> The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p>
    pub fn storage_class(&self) -> std::option::Option<&str> {
        self.storage_class.as_deref()
    }
    /// <p>Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p>
    /// <p>If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that user to have full control, you must explicitly grant full control to the user.</p>
    /// <p> If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any other user or group.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
}
impl std::fmt::Debug for PipelineOutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineOutputConfig");
        formatter.field("bucket", &self.bucket);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("permissions", &self.permissions);
        formatter.finish()
    }
}
/// See [`PipelineOutputConfig`](crate::model::PipelineOutputConfig)
pub mod pipeline_output_config {
    /// A builder for [`PipelineOutputConfig`](crate::model::PipelineOutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) storage_class: std::option::Option<std::string::String>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    }
    impl Builder {
        /// <p> The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value when all of the following are true:</p>
        /// <ul>
        /// <li> <p>You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.</p> </li>
        /// <li> <p>You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.</p> </li>
        /// <li> <p>You do not want to specify the permissions that Elastic Transcoder grants to the files.</p> </li>
        /// <li> <p>You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.</p> </li>
        /// </ul>
        /// <p>If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit OutputBucket and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p> The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value when all of the following are true:</p>
        /// <ul>
        /// <li> <p>You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.</p> </li>
        /// <li> <p>You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.</p> </li>
        /// <li> <p>You do not want to specify the permissions that Elastic Transcoder grants to the files.</p> </li>
        /// <li> <p>You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.</p> </li>
        /// </ul>
        /// <p>If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit OutputBucket and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p> The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p>
        pub fn storage_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_class = Some(input.into());
            self
        }
        /// <p> The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket. </p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p>
        /// <p>If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that user to have full control, you must explicitly grant full control to the user.</p>
        /// <p> If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any other user or group.</p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p>
        /// <p>If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that user to have full control, you must explicitly grant full control to the user.</p>
        /// <p> If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any other user or group.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineOutputConfig`](crate::model::PipelineOutputConfig)
        pub fn build(self) -> crate::model::PipelineOutputConfig {
            crate::model::PipelineOutputConfig {
                bucket: self.bucket,
                storage_class: self.storage_class,
                permissions: self.permissions,
            }
        }
    }
}
impl PipelineOutputConfig {
    /// Creates a new builder-style object to manufacture [`PipelineOutputConfig`](crate::model::PipelineOutputConfig)
    pub fn builder() -> crate::model::pipeline_output_config::Builder {
        crate::model::pipeline_output_config::Builder::default()
    }
}

/// <p>The <code>Permission</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Permission {
    /// <p>The type of value that appears in the Grantee object:</p>
    /// <ul>
    /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
    /// <p>A canonical user ID is not the same as an AWS account number.</p>
    /// </important> </li>
    /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
    /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
    /// </ul>
    pub grantee_type: std::option::Option<std::string::String>,
    /// <p>The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.</p>
    pub grantee: std::option::Option<std::string::String>,
    /// <p> The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
    /// <ul>
    /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// </ul>
    pub access: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Permission {
    /// <p>The type of value that appears in the Grantee object:</p>
    /// <ul>
    /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
    /// <p>A canonical user ID is not the same as an AWS account number.</p>
    /// </important> </li>
    /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
    /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
    /// </ul>
    pub fn grantee_type(&self) -> std::option::Option<&str> {
        self.grantee_type.as_deref()
    }
    /// <p>The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.</p>
    pub fn grantee(&self) -> std::option::Option<&str> {
        self.grantee.as_deref()
    }
    /// <p> The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
    /// <ul>
    /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
    /// </ul>
    pub fn access(&self) -> std::option::Option<&[std::string::String]> {
        self.access.as_deref()
    }
}
impl std::fmt::Debug for Permission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Permission");
        formatter.field("grantee_type", &self.grantee_type);
        formatter.field("grantee", &self.grantee);
        formatter.field("access", &self.access);
        formatter.finish()
    }
}
/// See [`Permission`](crate::model::Permission)
pub mod permission {
    /// A builder for [`Permission`](crate::model::Permission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantee_type: std::option::Option<std::string::String>,
        pub(crate) grantee: std::option::Option<std::string::String>,
        pub(crate) access: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of value that appears in the Grantee object:</p>
        /// <ul>
        /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
        /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul>
        pub fn grantee_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee_type = Some(input.into());
            self
        }
        /// <p>The type of value that appears in the Grantee object:</p>
        /// <ul>
        /// <li> <p> <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.</p> <important>
        /// <p>A canonical user ID is not the same as an AWS account number.</p>
        /// </important> </li>
        /// <li> <p> <code>Email</code>: The registered email address of an AWS account.</p> </li>
        /// <li> <p> <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.</p> </li>
        /// </ul>
        pub fn set_grantee_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee_type = input;
            self
        }
        /// <p>The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.</p>
        pub fn grantee(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee = Some(input.into());
            self
        }
        /// <p>The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.</p>
        pub fn set_grantee(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee = input;
            self
        }
        /// Appends an item to `access`.
        ///
        /// To override the contents of this collection use [`set_access`](Self::set_access).
        ///
        /// <p> The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn access(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.access.unwrap_or_default();
            v.push(input.into());
            self.access = Some(v);
            self
        }
        /// <p> The permission that you want to give to the AWS user that is listed in Grantee. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// <li> <p> <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_access(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.access = input;
            self
        }
        /// Consumes the builder and constructs a [`Permission`](crate::model::Permission)
        pub fn build(self) -> crate::model::Permission {
            crate::model::Permission {
                grantee_type: self.grantee_type,
                grantee: self.grantee,
                access: self.access,
            }
        }
    }
}
impl Permission {
    /// Creates a new builder-style object to manufacture [`Permission`](crate::model::Permission)
    pub fn builder() -> crate::model::permission::Builder {
        crate::model::permission::Builder::default()
    }
}

/// <p>The Amazon Simple Notification Service (Amazon SNS) topic or topics to notify in order to report job status.</p> <important>
/// <p>To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Notifications {
    /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p>
    pub progressing: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p>
    pub completed: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p>
    pub warning: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p>
    pub error: std::option::Option<std::string::String>,
}
impl Notifications {
    /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p>
    pub fn progressing(&self) -> std::option::Option<&str> {
        self.progressing.as_deref()
    }
    /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p>
    pub fn completed(&self) -> std::option::Option<&str> {
        self.completed.as_deref()
    }
    /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p>
    pub fn warning(&self) -> std::option::Option<&str> {
        self.warning.as_deref()
    }
    /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
}
impl std::fmt::Debug for Notifications {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Notifications");
        formatter.field("progressing", &self.progressing);
        formatter.field("completed", &self.completed);
        formatter.field("warning", &self.warning);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`Notifications`](crate::model::Notifications)
pub mod notifications {
    /// A builder for [`Notifications`](crate::model::Notifications)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progressing: std::option::Option<std::string::String>,
        pub(crate) completed: std::option::Option<std::string::String>,
        pub(crate) warning: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p>
        pub fn progressing(mut self, input: impl Into<std::string::String>) -> Self {
            self.progressing = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.</p>
        pub fn set_progressing(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.progressing = input;
            self
        }
        /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p>
        pub fn completed(mut self, input: impl Into<std::string::String>) -> Self {
            self.completed = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.</p>
        pub fn set_completed(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.completed = input;
            self
        }
        /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p>
        pub fn warning(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.</p>
        pub fn set_warning(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warning = input;
            self
        }
        /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`Notifications`](crate::model::Notifications)
        pub fn build(self) -> crate::model::Notifications {
            crate::model::Notifications {
                progressing: self.progressing,
                completed: self.completed,
                warning: self.warning,
                error: self.error,
            }
        }
    }
}
impl Notifications {
    /// Creates a new builder-style object to manufacture [`Notifications`](crate::model::Notifications)
    pub fn builder() -> crate::model::notifications::Builder {
        crate::model::notifications::Builder::default()
    }
}

/// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the pipeline.</p>
/// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Warning {
    /// <p>The code of the cross-regional warning.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message explaining what resources are in a different region from the pipeline.</p> <note>
    /// <p>AWS KMS keys must be in the same region as the pipeline.</p>
    /// </note>
    pub message: std::option::Option<std::string::String>,
}
impl Warning {
    /// <p>The code of the cross-regional warning.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The message explaining what resources are in a different region from the pipeline.</p> <note>
    /// <p>AWS KMS keys must be in the same region as the pipeline.</p>
    /// </note>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for Warning {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Warning");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`Warning`](crate::model::Warning)
pub mod warning {
    /// A builder for [`Warning`](crate::model::Warning)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The code of the cross-regional warning.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The code of the cross-regional warning.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message explaining what resources are in a different region from the pipeline.</p> <note>
        /// <p>AWS KMS keys must be in the same region as the pipeline.</p>
        /// </note>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message explaining what resources are in a different region from the pipeline.</p> <note>
        /// <p>AWS KMS keys must be in the same region as the pipeline.</p>
        /// </note>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Warning`](crate::model::Warning)
        pub fn build(self) -> crate::model::Warning {
            crate::model::Warning {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl Warning {
    /// Creates a new builder-style object to manufacture [`Warning`](crate::model::Warning)
    pub fn builder() -> crate::model::warning::Builder {
        crate::model::warning::Builder::default()
    }
}

/// <p>Presets are templates that contain most of the settings for transcoding media files from one format to another. Elastic Transcoder includes some default presets for common formats, for example, several iPod and iPhone versions. You can also create your own presets for formats that aren't included among the default presets. You specify which preset you want to use when you create a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Preset {
    /// <p>Identifier for the new preset. You use this value to get settings for the preset or to delete it.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the preset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the preset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the preset.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
    pub container: std::option::Option<std::string::String>,
    /// <p>A section of the response body that provides information about the audio preset values.</p>
    pub audio: std::option::Option<crate::model::AudioParameters>,
    /// <p>A section of the response body that provides information about the video preset values.</p>
    pub video: std::option::Option<crate::model::VideoParameters>,
    /// <p>A section of the response body that provides information about the thumbnail preset values, if any.</p>
    pub thumbnails: std::option::Option<crate::model::Thumbnails>,
    /// <p>Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a preset that you have defined (<code>Custom</code>).</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl Preset {
    /// <p>Identifier for the new preset. You use this value to get settings for the preset or to delete it.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the preset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the preset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the preset.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
    pub fn container(&self) -> std::option::Option<&str> {
        self.container.as_deref()
    }
    /// <p>A section of the response body that provides information about the audio preset values.</p>
    pub fn audio(&self) -> std::option::Option<&crate::model::AudioParameters> {
        self.audio.as_ref()
    }
    /// <p>A section of the response body that provides information about the video preset values.</p>
    pub fn video(&self) -> std::option::Option<&crate::model::VideoParameters> {
        self.video.as_ref()
    }
    /// <p>A section of the response body that provides information about the thumbnail preset values, if any.</p>
    pub fn thumbnails(&self) -> std::option::Option<&crate::model::Thumbnails> {
        self.thumbnails.as_ref()
    }
    /// <p>Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a preset that you have defined (<code>Custom</code>).</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for Preset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Preset");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("container", &self.container);
        formatter.field("audio", &self.audio);
        formatter.field("video", &self.video);
        formatter.field("thumbnails", &self.thumbnails);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Preset`](crate::model::Preset)
pub mod preset {
    /// A builder for [`Preset`](crate::model::Preset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) container: std::option::Option<std::string::String>,
        pub(crate) audio: std::option::Option<crate::model::AudioParameters>,
        pub(crate) video: std::option::Option<crate::model::VideoParameters>,
        pub(crate) thumbnails: std::option::Option<crate::model::Thumbnails>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for the new preset. You use this value to get settings for the preset or to delete it.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Identifier for the new preset. You use this value to get settings for the preset or to delete it.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the preset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the preset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the preset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the preset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the preset.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the preset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
        pub fn container(mut self, input: impl Into<std::string::String>) -> Self {
            self.container = Some(input.into());
            self
        }
        /// <p>The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
        pub fn set_container(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.container = input;
            self
        }
        /// <p>A section of the response body that provides information about the audio preset values.</p>
        pub fn audio(mut self, input: crate::model::AudioParameters) -> Self {
            self.audio = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the audio preset values.</p>
        pub fn set_audio(
            mut self,
            input: std::option::Option<crate::model::AudioParameters>,
        ) -> Self {
            self.audio = input;
            self
        }
        /// <p>A section of the response body that provides information about the video preset values.</p>
        pub fn video(mut self, input: crate::model::VideoParameters) -> Self {
            self.video = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the video preset values.</p>
        pub fn set_video(
            mut self,
            input: std::option::Option<crate::model::VideoParameters>,
        ) -> Self {
            self.video = input;
            self
        }
        /// <p>A section of the response body that provides information about the thumbnail preset values, if any.</p>
        pub fn thumbnails(mut self, input: crate::model::Thumbnails) -> Self {
            self.thumbnails = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the thumbnail preset values, if any.</p>
        pub fn set_thumbnails(
            mut self,
            input: std::option::Option<crate::model::Thumbnails>,
        ) -> Self {
            self.thumbnails = input;
            self
        }
        /// <p>Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a preset that you have defined (<code>Custom</code>).</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a preset that you have defined (<code>Custom</code>).</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Preset`](crate::model::Preset)
        pub fn build(self) -> crate::model::Preset {
            crate::model::Preset {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                container: self.container,
                audio: self.audio,
                video: self.video,
                thumbnails: self.thumbnails,
                r#type: self.r#type,
            }
        }
    }
}
impl Preset {
    /// Creates a new builder-style object to manufacture [`Preset`](crate::model::Preset)
    pub fn builder() -> crate::model::preset::Builder {
        crate::model::preset::Builder::default()
    }
}

/// <p>Thumbnails for videos.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Thumbnails {
    /// <p>The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>. </p>
    /// <p>You specify whether you want Elastic Transcoder to create thumbnails when you create a job.</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>The approximate number of seconds between thumbnails. Specify an integer value.</p>
    pub interval: std::option::Option<std::string::String>,
    /// <important>
    /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The width and height of thumbnail files in pixels. Specify a value in the format <code> <i>width</i> </code> x <code> <i>height</i> </code> where both values are even integers. The values cannot exceed the width and height that you specified in the <code>Video:Resolution</code> object.</p>
    pub resolution: std::option::Option<std::string::String>,
    /// <important>
    /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The aspect ratio of thumbnails. Valid values include:</p>
    /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video in the output file.</p>
    pub aspect_ratio: std::option::Option<std::string::String>,
    /// <p>The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096.</p>
    pub max_width: std::option::Option<std::string::String>,
    /// <p>The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.</p>
    pub max_height: std::option::Option<std::string::String>,
    /// <p>Specify one of the following values to control scaling of thumbnails:</p>
    /// <ul>
    /// <li> <p> <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail MaxWidth or MaxHeight settings without exceeding the other value. </p> </li>
    /// <li> <p> <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the maximum value.</p> </li>
    /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions of the input video and thumbnails are different, the thumbnails will be distorted.</p> </li>
    /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input video exceeds the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings, Elastic Transcoder crops the thumbnails.</p> </li>
    /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
    /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
    /// </ul>
    pub sizing_policy: std::option::Option<std::string::String>,
    /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings.</p>
    pub padding_policy: std::option::Option<std::string::String>,
}
impl Thumbnails {
    /// <p>The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>. </p>
    /// <p>You specify whether you want Elastic Transcoder to create thumbnails when you create a job.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>The approximate number of seconds between thumbnails. Specify an integer value.</p>
    pub fn interval(&self) -> std::option::Option<&str> {
        self.interval.as_deref()
    }
    /// <important>
    /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The width and height of thumbnail files in pixels. Specify a value in the format <code> <i>width</i> </code> x <code> <i>height</i> </code> where both values are even integers. The values cannot exceed the width and height that you specified in the <code>Video:Resolution</code> object.</p>
    pub fn resolution(&self) -> std::option::Option<&str> {
        self.resolution.as_deref()
    }
    /// <important>
    /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The aspect ratio of thumbnails. Valid values include:</p>
    /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video in the output file.</p>
    pub fn aspect_ratio(&self) -> std::option::Option<&str> {
        self.aspect_ratio.as_deref()
    }
    /// <p>The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096.</p>
    pub fn max_width(&self) -> std::option::Option<&str> {
        self.max_width.as_deref()
    }
    /// <p>The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.</p>
    pub fn max_height(&self) -> std::option::Option<&str> {
        self.max_height.as_deref()
    }
    /// <p>Specify one of the following values to control scaling of thumbnails:</p>
    /// <ul>
    /// <li> <p> <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail MaxWidth or MaxHeight settings without exceeding the other value. </p> </li>
    /// <li> <p> <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the maximum value.</p> </li>
    /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions of the input video and thumbnails are different, the thumbnails will be distorted.</p> </li>
    /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input video exceeds the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings, Elastic Transcoder crops the thumbnails.</p> </li>
    /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
    /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
    /// </ul>
    pub fn sizing_policy(&self) -> std::option::Option<&str> {
        self.sizing_policy.as_deref()
    }
    /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings.</p>
    pub fn padding_policy(&self) -> std::option::Option<&str> {
        self.padding_policy.as_deref()
    }
}
impl std::fmt::Debug for Thumbnails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Thumbnails");
        formatter.field("format", &self.format);
        formatter.field("interval", &self.interval);
        formatter.field("resolution", &self.resolution);
        formatter.field("aspect_ratio", &self.aspect_ratio);
        formatter.field("max_width", &self.max_width);
        formatter.field("max_height", &self.max_height);
        formatter.field("sizing_policy", &self.sizing_policy);
        formatter.field("padding_policy", &self.padding_policy);
        formatter.finish()
    }
}
/// See [`Thumbnails`](crate::model::Thumbnails)
pub mod thumbnails {
    /// A builder for [`Thumbnails`](crate::model::Thumbnails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) interval: std::option::Option<std::string::String>,
        pub(crate) resolution: std::option::Option<std::string::String>,
        pub(crate) aspect_ratio: std::option::Option<std::string::String>,
        pub(crate) max_width: std::option::Option<std::string::String>,
        pub(crate) max_height: std::option::Option<std::string::String>,
        pub(crate) sizing_policy: std::option::Option<std::string::String>,
        pub(crate) padding_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>. </p>
        /// <p>You specify whether you want Elastic Transcoder to create thumbnails when you create a job.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>The format of thumbnails, if any. Valid values are <code>jpg</code> and <code>png</code>. </p>
        /// <p>You specify whether you want Elastic Transcoder to create thumbnails when you create a job.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>The approximate number of seconds between thumbnails. Specify an integer value.</p>
        pub fn interval(mut self, input: impl Into<std::string::String>) -> Self {
            self.interval = Some(input.into());
            self
        }
        /// <p>The approximate number of seconds between thumbnails. Specify an integer value.</p>
        pub fn set_interval(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.interval = input;
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The width and height of thumbnail files in pixels. Specify a value in the format <code> <i>width</i> </code> x <code> <i>height</i> </code> where both values are even integers. The values cannot exceed the width and height that you specified in the <code>Video:Resolution</code> object.</p>
        pub fn resolution(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution = Some(input.into());
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The width and height of thumbnail files in pixels. Specify a value in the format <code> <i>width</i> </code> x <code> <i>height</i> </code> where both values are even integers. The values cannot exceed the width and height that you specified in the <code>Video:Resolution</code> object.</p>
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolution = input;
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The aspect ratio of thumbnails. Valid values include:</p>
        /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video in the output file.</p>
        pub fn aspect_ratio(mut self, input: impl Into<std::string::String>) -> Self {
            self.aspect_ratio = Some(input.into());
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of thumbnails, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, and <code>PaddingPolicy</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The aspect ratio of thumbnails. Valid values include:</p>
        /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the video in the output file.</p>
        pub fn set_aspect_ratio(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aspect_ratio = input;
            self
        }
        /// <p>The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096.</p>
        pub fn max_width(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_width = Some(input.into());
            self
        }
        /// <p>The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096.</p>
        pub fn set_max_width(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_width = input;
            self
        }
        /// <p>The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.</p>
        pub fn max_height(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_height = Some(input.into());
            self
        }
        /// <p>The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.</p>
        pub fn set_max_height(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_height = input;
            self
        }
        /// <p>Specify one of the following values to control scaling of thumbnails:</p>
        /// <ul>
        /// <li> <p> <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail MaxWidth or MaxHeight settings without exceeding the other value. </p> </li>
        /// <li> <p> <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the maximum value.</p> </li>
        /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions of the input video and thumbnails are different, the thumbnails will be distorted.</p> </li>
        /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input video exceeds the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings, Elastic Transcoder crops the thumbnails.</p> </li>
        /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
        /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
        /// </ul>
        pub fn sizing_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.sizing_policy = Some(input.into());
            self
        }
        /// <p>Specify one of the following values to control scaling of thumbnails:</p>
        /// <ul>
        /// <li> <p> <code>Fit</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail MaxWidth or MaxHeight settings without exceeding the other value. </p> </li>
        /// <li> <p> <code>Fill</code>: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail <code>MaxWidth</code> or <code>MaxHeight</code> settings and matches or exceeds the other value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the maximum value.</p> </li>
        /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches thumbnails to match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings. If the relative proportions of the input video and thumbnails are different, the thumbnails will be distorted.</p> </li>
        /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale thumbnails. If either dimension of the input video exceeds the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings, Elastic Transcoder crops the thumbnails.</p> </li>
        /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
        /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.</p> </li>
        /// </ul>
        pub fn set_sizing_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sizing_policy = input;
            self
        }
        /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings.</p>
        pub fn padding_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.padding_policy = Some(input.into());
            self
        }
        /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail <code>MaxWidth</code> and <code>MaxHeight</code> settings.</p>
        pub fn set_padding_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.padding_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`Thumbnails`](crate::model::Thumbnails)
        pub fn build(self) -> crate::model::Thumbnails {
            crate::model::Thumbnails {
                format: self.format,
                interval: self.interval,
                resolution: self.resolution,
                aspect_ratio: self.aspect_ratio,
                max_width: self.max_width,
                max_height: self.max_height,
                sizing_policy: self.sizing_policy,
                padding_policy: self.padding_policy,
            }
        }
    }
}
impl Thumbnails {
    /// Creates a new builder-style object to manufacture [`Thumbnails`](crate::model::Thumbnails)
    pub fn builder() -> crate::model::thumbnails::Builder {
        crate::model::thumbnails::Builder::default()
    }
}

/// <p>The <code>VideoParameters</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoParameters {
    /// <p>The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>, <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container type is <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.</p>
    pub codec: std::option::Option<std::string::String>,
    /// <p> <b>Profile (H.264/VP8/VP9 Only)</b> </p>
    /// <p>The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following profiles:</p>
    /// <ul>
    /// <li> <p> <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile applications.</p> </li>
    /// <li> <p> <code>main</code>: The profile used for standard-definition digital TV broadcasts.</p> </li>
    /// <li> <p> <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.</p> </li>
    /// </ul>
    /// <p> <b>Level (H.264 Only)</b> </p>
    /// <p>The H.264 level that you want to use for the output file. Elastic Transcoder supports the following levels:</p>
    /// <p> <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>, <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>, <code>4.1</code> </p>
    /// <p> <b>MaxReferenceFrames (H.264 Only)</b> </p>
    /// <p>Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded frames to use as a reference for decoding future frames. Valid values are integers 0 through 16, but we recommend that you not use a value greater than the following:</p>
    /// <p> <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code> </p>
    /// <p>where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or Resolution. <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the <code>Level</code> object. See the list below. (A macroblock is a block of pixels measuring 16x16.) </p>
    /// <ul>
    /// <li> <p>1 - 396</p> </li>
    /// <li> <p>1b - 396</p> </li>
    /// <li> <p>1.1 - 900</p> </li>
    /// <li> <p>1.2 - 2376</p> </li>
    /// <li> <p>1.3 - 2376</p> </li>
    /// <li> <p>2 - 2376</p> </li>
    /// <li> <p>2.1 - 4752</p> </li>
    /// <li> <p>2.2 - 8100</p> </li>
    /// <li> <p>3 - 8100</p> </li>
    /// <li> <p>3.1 - 18000</p> </li>
    /// <li> <p>3.2 - 20480</p> </li>
    /// <li> <p>4 - 32768</p> </li>
    /// <li> <p>4.1 - 32768</p> </li>
    /// </ul>
    /// <p> <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
    /// <p>The maximum number of bits per second in a video buffer; the size of the buffer is specified by <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required to stream a video by reducing the maximum bit rate, but this also reduces the quality of the video.</p>
    /// <p> <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
    /// <p>The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds, the standard segment duration when you're using FMP4 or MPEG-TS for the container type of the output video. Specify an integer greater than 0. If you specify <code>MaxBitRate</code> and omit <code>BufferSize</code>, Elastic Transcoder sets <code>BufferSize</code> to 10 times the value of <code>MaxBitRate</code>.</p>
    /// <p> <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b> </p>
    /// <p>The interlace mode for the output video.</p>
    /// <p>Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one field on every other line, the other field on the other lines) so that the human eye registers multiple pictures per frame. Interlacing reduces the bandwidth required for transmitting a video, but can result in blurred images and flickering.</p>
    /// <p>Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code> (top field first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.</p>
    /// <p>If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for the output. If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.</p>
    /// <p> <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b> </p>
    /// <p>The color space conversion Elastic Transcoder applies to the output video. Color spaces are the algorithms used by the computer to store information about how to render color. <code>Bt.601</code> is the standard for standard definition video, while <code>Bt.709</code> is the standard for high definition video.</p>
    /// <p>Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and <code>Auto</code>.</p>
    /// <p>If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is interlaced, your frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>50</code>, or <code>60</code>, your <code>SegmentDuration</code> is null, and you are using one of the resolution changes from the list below, Elastic Transcoder applies the following color space conversions:</p>
    /// <ul>
    /// <li> <p> <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
    /// <li> <p> <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
    /// <li> <p> <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
    /// <li> <p> <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
    /// </ul> <note>
    /// <p>Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code> <code>Auto</code> mode in the future. All outputs in a playlist must use the same <code>ColorSpaceConversionMode</code>.</p>
    /// </note>
    /// <p>If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the color space of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to your output file, you can check the <code>AppliedColorSpaceConversion</code> parameter included in your job response. If your job does not have an <code>AppliedColorSpaceConversion</code> in its response, no <code>ColorSpaceConversionMode</code> was applied.</p>
    /// <p> <b>ChromaSubsampling</b> </p>
    /// <p>The sampling pattern for the chroma (color) channels of the output video. Valid values include <code>yuv420p</code> and <code>yuv422p</code>.</p>
    /// <p> <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical line, <code>yuv422p</code> samples the color information of every horizontal line and every other vertical line.</p>
    /// <p> <b>LoopCount (Gif Only)</b> </p>
    /// <p>The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and integers between <code>0</code> and <code>100</code>, inclusive.</p>
    pub codec_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
    /// <p>The maximum number of frames between key frames. Key frames are fully encoded frames; the frames between key frames are encoded based, in part, on the content of the key frames. The value is an integer formatted as a string; valid values are between 1 (every frame is a key frame) and 100000, inclusive. A higher value results in higher compression but may also discernibly decrease video quality.</p>
    /// <p>For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different quality levels while the file is being played.</p>
    /// <p>For example, an input file can have a <code>FrameRate</code> of 30 with a <code>KeyframesMaxDist</code> of 90. The output file then needs to have a ratio of 1:3. Valid outputs would have <code>FrameRate</code> of 30, 25, and 10, and <code>KeyframesMaxDist</code> of 90, 75, and 30, respectively.</p>
    /// <p>Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values for <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.</p>
    pub keyframes_max_dist: std::option::Option<std::string::String>,
    /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
    /// <p>Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and <code>false</code>:</p>
    /// <ul>
    /// <li> <p> <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance between key frames (the number of frames in a group of pictures, or GOP).</p> </li>
    /// <li> <p> <code>false</code>: The distance between key frames can vary.</p> </li>
    /// </ul> <important>
    /// <p> <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.</p>
    /// </important>
    pub fixed_gop: std::option::Option<std::string::String>,
    /// <p>The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the values of <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic Transcoder uses the detected bit rate of the input source. If you specify a value other than <code>auto</code>, we recommend that you specify a value less than or equal to the maximum H.264-compliant value listed for your level and profile:</p>
    /// <p> <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit rate in kilobits/second (high Profile)</i> </p>
    /// <ul>
    /// <li> <p>1 - 64 : 80</p> </li>
    /// <li> <p>1b - 128 : 160</p> </li>
    /// <li> <p>1.1 - 192 : 240</p> </li>
    /// <li> <p>1.2 - 384 : 480</p> </li>
    /// <li> <p>1.3 - 768 : 960</p> </li>
    /// <li> <p>2 - 2000 : 2500</p> </li>
    /// <li> <p>3 - 10000 : 12500</p> </li>
    /// <li> <p>3.1 - 14000 : 17500</p> </li>
    /// <li> <p>3.2 - 20000 : 25000</p> </li>
    /// <li> <p>4 - 20000 : 25000</p> </li>
    /// <li> <p>4.1 - 50000 : 62500</p> </li>
    /// </ul>
    pub bit_rate: std::option::Option<std::string::String>,
    /// <p>The frames per second for the video stream in the output file. Valid values include:</p>
    /// <p> <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source. If you specify a frame rate, we recommend that you perform the following calculation:</p>
    /// <p> <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code> </p>
    /// <p>where:</p>
    /// <ul>
    /// <li> <p> <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.</p> </li>
    /// <li> <p> <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum value listed in the following table, based on the value that you specified for Level.</p> </li>
    /// </ul>
    /// <p>The maximum recommended decoding speed in Luma samples/second for each level is described in the following list (<i>Level - Decoding speed</i>):</p>
    /// <ul>
    /// <li> <p>1 - 380160</p> </li>
    /// <li> <p>1b - 380160</p> </li>
    /// <li> <p>1.1 - 76800</p> </li>
    /// <li> <p>1.2 - 1536000</p> </li>
    /// <li> <p>1.3 - 3041280</p> </li>
    /// <li> <p>2 - 3041280</p> </li>
    /// <li> <p>2.1 - 5068800</p> </li>
    /// <li> <p>2.2 - 5184000</p> </li>
    /// <li> <p>3 - 10368000</p> </li>
    /// <li> <p>3.1 - 27648000</p> </li>
    /// <li> <p>3.2 - 55296000</p> </li>
    /// <li> <p>4 - 62914560</p> </li>
    /// <li> <p>4.1 - 62914560</p> </li>
    /// </ul>
    pub frame_rate: std::option::Option<std::string::String>,
    /// <p>If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of the input video for the frame rate of the output video. Specify the maximum frame rate that you want Elastic Transcoder to use when the frame rate of the input video is greater than the desired maximum frame rate of the output video. Valid values include: <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code>.</p>
    pub max_frame_rate: std::option::Option<std::string::String>,
    /// <important>
    /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The width and height of the video in the output file, in pixels. Valid values are <code>auto</code> and <i>width</i> x <i>height</i>:</p>
    /// <ul>
    /// <li> <p> <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file, subject to the following rules.</p> </li>
    /// <li> <p> <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.</p> </li>
    /// </ul>
    /// <p>Note the following about specifying the width and height:</p>
    /// <ul>
    /// <li> <p>The width must be an even integer between 128 and 4096, inclusive.</p> </li>
    /// <li> <p>The height must be an even integer between 96 and 3072, inclusive.</p> </li>
    /// <li> <p>If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder rescales the output file to the lower resolution.</p> </li>
    /// <li> <p>If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder rescales the output to the higher resolution.</p> </li>
    /// <li> <p>We recommend that you specify a resolution for which the product of width and height is less than or equal to the applicable value in the following list (<i>List - Max width x height value</i>):</p>
    /// <ul>
    /// <li> <p>1 - 25344</p> </li>
    /// <li> <p>1b - 25344</p> </li>
    /// <li> <p>1.1 - 101376</p> </li>
    /// <li> <p>1.2 - 101376</p> </li>
    /// <li> <p>1.3 - 101376</p> </li>
    /// <li> <p>2 - 101376</p> </li>
    /// <li> <p>2.1 - 202752</p> </li>
    /// <li> <p>2.2 - 404720</p> </li>
    /// <li> <p>3 - 404720</p> </li>
    /// <li> <p>3.1 - 921600</p> </li>
    /// <li> <p>3.2 - 1310720</p> </li>
    /// <li> <p>4 - 2097152</p> </li>
    /// <li> <p>4.1 - 2097152</p> </li>
    /// </ul> </li>
    /// </ul>
    pub resolution: std::option::Option<std::string::String>,
    /// <important>
    /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The display aspect ratio of the video in the output file. Valid values include:</p>
    /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input file.</p>
    /// <p>If you specify an aspect ratio for the output file that differs from aspect ratio of the input file, Elastic Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top and bottom) to maintain the aspect ratio of the active region of the video.</p>
    pub aspect_ratio: std::option::Option<std::string::String>,
    /// <p> The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and 4096. </p>
    pub max_width: std::option::Option<std::string::String>,
    /// <p>The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and 3072.</p>
    pub max_height: std::option::Option<std::string::String>,
    /// <p>The value that Elastic Transcoder adds to the metadata in the output file.</p>
    pub display_aspect_ratio: std::option::Option<std::string::String>,
    /// <p>Specify one of the following values to control scaling of the output video:</p>
    /// <ul>
    /// <li> <p> <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
    /// <li> <p> <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output video and then crops it in the dimension (if any) that exceeds the maximum value.</p> </li>
    /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input video and the output video are different, the output video will be distorted.</p> </li>
    /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the input video exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output video.</p> </li>
    /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
    /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
    /// </ul>
    pub sizing_policy: std::option::Option<std::string::String>,
    /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of the output video to make the total size of the output video match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
    pub padding_policy: std::option::Option<std::string::String>,
    /// <p>Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in the specified size and location, and with the specified opacity for the duration of the transcoded video.</p>
    /// <p>Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png format, which supports transparency.</p>
    /// <p>When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have different dimensions.</p>
    pub watermarks: std::option::Option<std::vec::Vec<crate::model::PresetWatermark>>,
}
impl VideoParameters {
    /// <p>The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>, <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container type is <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.</p>
    pub fn codec(&self) -> std::option::Option<&str> {
        self.codec.as_deref()
    }
    /// <p> <b>Profile (H.264/VP8/VP9 Only)</b> </p>
    /// <p>The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following profiles:</p>
    /// <ul>
    /// <li> <p> <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile applications.</p> </li>
    /// <li> <p> <code>main</code>: The profile used for standard-definition digital TV broadcasts.</p> </li>
    /// <li> <p> <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.</p> </li>
    /// </ul>
    /// <p> <b>Level (H.264 Only)</b> </p>
    /// <p>The H.264 level that you want to use for the output file. Elastic Transcoder supports the following levels:</p>
    /// <p> <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>, <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>, <code>4.1</code> </p>
    /// <p> <b>MaxReferenceFrames (H.264 Only)</b> </p>
    /// <p>Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded frames to use as a reference for decoding future frames. Valid values are integers 0 through 16, but we recommend that you not use a value greater than the following:</p>
    /// <p> <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code> </p>
    /// <p>where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or Resolution. <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the <code>Level</code> object. See the list below. (A macroblock is a block of pixels measuring 16x16.) </p>
    /// <ul>
    /// <li> <p>1 - 396</p> </li>
    /// <li> <p>1b - 396</p> </li>
    /// <li> <p>1.1 - 900</p> </li>
    /// <li> <p>1.2 - 2376</p> </li>
    /// <li> <p>1.3 - 2376</p> </li>
    /// <li> <p>2 - 2376</p> </li>
    /// <li> <p>2.1 - 4752</p> </li>
    /// <li> <p>2.2 - 8100</p> </li>
    /// <li> <p>3 - 8100</p> </li>
    /// <li> <p>3.1 - 18000</p> </li>
    /// <li> <p>3.2 - 20480</p> </li>
    /// <li> <p>4 - 32768</p> </li>
    /// <li> <p>4.1 - 32768</p> </li>
    /// </ul>
    /// <p> <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
    /// <p>The maximum number of bits per second in a video buffer; the size of the buffer is specified by <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required to stream a video by reducing the maximum bit rate, but this also reduces the quality of the video.</p>
    /// <p> <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
    /// <p>The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds, the standard segment duration when you're using FMP4 or MPEG-TS for the container type of the output video. Specify an integer greater than 0. If you specify <code>MaxBitRate</code> and omit <code>BufferSize</code>, Elastic Transcoder sets <code>BufferSize</code> to 10 times the value of <code>MaxBitRate</code>.</p>
    /// <p> <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b> </p>
    /// <p>The interlace mode for the output video.</p>
    /// <p>Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one field on every other line, the other field on the other lines) so that the human eye registers multiple pictures per frame. Interlacing reduces the bandwidth required for transmitting a video, but can result in blurred images and flickering.</p>
    /// <p>Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code> (top field first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.</p>
    /// <p>If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for the output. If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.</p>
    /// <p> <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b> </p>
    /// <p>The color space conversion Elastic Transcoder applies to the output video. Color spaces are the algorithms used by the computer to store information about how to render color. <code>Bt.601</code> is the standard for standard definition video, while <code>Bt.709</code> is the standard for high definition video.</p>
    /// <p>Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and <code>Auto</code>.</p>
    /// <p>If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is interlaced, your frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>50</code>, or <code>60</code>, your <code>SegmentDuration</code> is null, and you are using one of the resolution changes from the list below, Elastic Transcoder applies the following color space conversions:</p>
    /// <ul>
    /// <li> <p> <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
    /// <li> <p> <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
    /// <li> <p> <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
    /// <li> <p> <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
    /// </ul> <note>
    /// <p>Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code> <code>Auto</code> mode in the future. All outputs in a playlist must use the same <code>ColorSpaceConversionMode</code>.</p>
    /// </note>
    /// <p>If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the color space of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to your output file, you can check the <code>AppliedColorSpaceConversion</code> parameter included in your job response. If your job does not have an <code>AppliedColorSpaceConversion</code> in its response, no <code>ColorSpaceConversionMode</code> was applied.</p>
    /// <p> <b>ChromaSubsampling</b> </p>
    /// <p>The sampling pattern for the chroma (color) channels of the output video. Valid values include <code>yuv420p</code> and <code>yuv422p</code>.</p>
    /// <p> <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical line, <code>yuv422p</code> samples the color information of every horizontal line and every other vertical line.</p>
    /// <p> <b>LoopCount (Gif Only)</b> </p>
    /// <p>The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and integers between <code>0</code> and <code>100</code>, inclusive.</p>
    pub fn codec_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.codec_options.as_ref()
    }
    /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
    /// <p>The maximum number of frames between key frames. Key frames are fully encoded frames; the frames between key frames are encoded based, in part, on the content of the key frames. The value is an integer formatted as a string; valid values are between 1 (every frame is a key frame) and 100000, inclusive. A higher value results in higher compression but may also discernibly decrease video quality.</p>
    /// <p>For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different quality levels while the file is being played.</p>
    /// <p>For example, an input file can have a <code>FrameRate</code> of 30 with a <code>KeyframesMaxDist</code> of 90. The output file then needs to have a ratio of 1:3. Valid outputs would have <code>FrameRate</code> of 30, 25, and 10, and <code>KeyframesMaxDist</code> of 90, 75, and 30, respectively.</p>
    /// <p>Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values for <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.</p>
    pub fn keyframes_max_dist(&self) -> std::option::Option<&str> {
        self.keyframes_max_dist.as_deref()
    }
    /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
    /// <p>Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and <code>false</code>:</p>
    /// <ul>
    /// <li> <p> <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance between key frames (the number of frames in a group of pictures, or GOP).</p> </li>
    /// <li> <p> <code>false</code>: The distance between key frames can vary.</p> </li>
    /// </ul> <important>
    /// <p> <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.</p>
    /// </important>
    pub fn fixed_gop(&self) -> std::option::Option<&str> {
        self.fixed_gop.as_deref()
    }
    /// <p>The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the values of <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic Transcoder uses the detected bit rate of the input source. If you specify a value other than <code>auto</code>, we recommend that you specify a value less than or equal to the maximum H.264-compliant value listed for your level and profile:</p>
    /// <p> <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit rate in kilobits/second (high Profile)</i> </p>
    /// <ul>
    /// <li> <p>1 - 64 : 80</p> </li>
    /// <li> <p>1b - 128 : 160</p> </li>
    /// <li> <p>1.1 - 192 : 240</p> </li>
    /// <li> <p>1.2 - 384 : 480</p> </li>
    /// <li> <p>1.3 - 768 : 960</p> </li>
    /// <li> <p>2 - 2000 : 2500</p> </li>
    /// <li> <p>3 - 10000 : 12500</p> </li>
    /// <li> <p>3.1 - 14000 : 17500</p> </li>
    /// <li> <p>3.2 - 20000 : 25000</p> </li>
    /// <li> <p>4 - 20000 : 25000</p> </li>
    /// <li> <p>4.1 - 50000 : 62500</p> </li>
    /// </ul>
    pub fn bit_rate(&self) -> std::option::Option<&str> {
        self.bit_rate.as_deref()
    }
    /// <p>The frames per second for the video stream in the output file. Valid values include:</p>
    /// <p> <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source. If you specify a frame rate, we recommend that you perform the following calculation:</p>
    /// <p> <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code> </p>
    /// <p>where:</p>
    /// <ul>
    /// <li> <p> <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.</p> </li>
    /// <li> <p> <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum value listed in the following table, based on the value that you specified for Level.</p> </li>
    /// </ul>
    /// <p>The maximum recommended decoding speed in Luma samples/second for each level is described in the following list (<i>Level - Decoding speed</i>):</p>
    /// <ul>
    /// <li> <p>1 - 380160</p> </li>
    /// <li> <p>1b - 380160</p> </li>
    /// <li> <p>1.1 - 76800</p> </li>
    /// <li> <p>1.2 - 1536000</p> </li>
    /// <li> <p>1.3 - 3041280</p> </li>
    /// <li> <p>2 - 3041280</p> </li>
    /// <li> <p>2.1 - 5068800</p> </li>
    /// <li> <p>2.2 - 5184000</p> </li>
    /// <li> <p>3 - 10368000</p> </li>
    /// <li> <p>3.1 - 27648000</p> </li>
    /// <li> <p>3.2 - 55296000</p> </li>
    /// <li> <p>4 - 62914560</p> </li>
    /// <li> <p>4.1 - 62914560</p> </li>
    /// </ul>
    pub fn frame_rate(&self) -> std::option::Option<&str> {
        self.frame_rate.as_deref()
    }
    /// <p>If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of the input video for the frame rate of the output video. Specify the maximum frame rate that you want Elastic Transcoder to use when the frame rate of the input video is greater than the desired maximum frame rate of the output video. Valid values include: <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code>.</p>
    pub fn max_frame_rate(&self) -> std::option::Option<&str> {
        self.max_frame_rate.as_deref()
    }
    /// <important>
    /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The width and height of the video in the output file, in pixels. Valid values are <code>auto</code> and <i>width</i> x <i>height</i>:</p>
    /// <ul>
    /// <li> <p> <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file, subject to the following rules.</p> </li>
    /// <li> <p> <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.</p> </li>
    /// </ul>
    /// <p>Note the following about specifying the width and height:</p>
    /// <ul>
    /// <li> <p>The width must be an even integer between 128 and 4096, inclusive.</p> </li>
    /// <li> <p>The height must be an even integer between 96 and 3072, inclusive.</p> </li>
    /// <li> <p>If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder rescales the output file to the lower resolution.</p> </li>
    /// <li> <p>If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder rescales the output to the higher resolution.</p> </li>
    /// <li> <p>We recommend that you specify a resolution for which the product of width and height is less than or equal to the applicable value in the following list (<i>List - Max width x height value</i>):</p>
    /// <ul>
    /// <li> <p>1 - 25344</p> </li>
    /// <li> <p>1b - 25344</p> </li>
    /// <li> <p>1.1 - 101376</p> </li>
    /// <li> <p>1.2 - 101376</p> </li>
    /// <li> <p>1.3 - 101376</p> </li>
    /// <li> <p>2 - 101376</p> </li>
    /// <li> <p>2.1 - 202752</p> </li>
    /// <li> <p>2.2 - 404720</p> </li>
    /// <li> <p>3 - 404720</p> </li>
    /// <li> <p>3.1 - 921600</p> </li>
    /// <li> <p>3.2 - 1310720</p> </li>
    /// <li> <p>4 - 2097152</p> </li>
    /// <li> <p>4.1 - 2097152</p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn resolution(&self) -> std::option::Option<&str> {
        self.resolution.as_deref()
    }
    /// <important>
    /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
    /// </important>
    /// <p>The display aspect ratio of the video in the output file. Valid values include:</p>
    /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input file.</p>
    /// <p>If you specify an aspect ratio for the output file that differs from aspect ratio of the input file, Elastic Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top and bottom) to maintain the aspect ratio of the active region of the video.</p>
    pub fn aspect_ratio(&self) -> std::option::Option<&str> {
        self.aspect_ratio.as_deref()
    }
    /// <p> The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and 4096. </p>
    pub fn max_width(&self) -> std::option::Option<&str> {
        self.max_width.as_deref()
    }
    /// <p>The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and 3072.</p>
    pub fn max_height(&self) -> std::option::Option<&str> {
        self.max_height.as_deref()
    }
    /// <p>The value that Elastic Transcoder adds to the metadata in the output file.</p>
    pub fn display_aspect_ratio(&self) -> std::option::Option<&str> {
        self.display_aspect_ratio.as_deref()
    }
    /// <p>Specify one of the following values to control scaling of the output video:</p>
    /// <ul>
    /// <li> <p> <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
    /// <li> <p> <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output video and then crops it in the dimension (if any) that exceeds the maximum value.</p> </li>
    /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input video and the output video are different, the output video will be distorted.</p> </li>
    /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the input video exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output video.</p> </li>
    /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
    /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
    /// </ul>
    pub fn sizing_policy(&self) -> std::option::Option<&str> {
        self.sizing_policy.as_deref()
    }
    /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of the output video to make the total size of the output video match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
    pub fn padding_policy(&self) -> std::option::Option<&str> {
        self.padding_policy.as_deref()
    }
    /// <p>Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in the specified size and location, and with the specified opacity for the duration of the transcoded video.</p>
    /// <p>Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png format, which supports transparency.</p>
    /// <p>When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have different dimensions.</p>
    pub fn watermarks(&self) -> std::option::Option<&[crate::model::PresetWatermark]> {
        self.watermarks.as_deref()
    }
}
impl std::fmt::Debug for VideoParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoParameters");
        formatter.field("codec", &self.codec);
        formatter.field("codec_options", &self.codec_options);
        formatter.field("keyframes_max_dist", &self.keyframes_max_dist);
        formatter.field("fixed_gop", &self.fixed_gop);
        formatter.field("bit_rate", &self.bit_rate);
        formatter.field("frame_rate", &self.frame_rate);
        formatter.field("max_frame_rate", &self.max_frame_rate);
        formatter.field("resolution", &self.resolution);
        formatter.field("aspect_ratio", &self.aspect_ratio);
        formatter.field("max_width", &self.max_width);
        formatter.field("max_height", &self.max_height);
        formatter.field("display_aspect_ratio", &self.display_aspect_ratio);
        formatter.field("sizing_policy", &self.sizing_policy);
        formatter.field("padding_policy", &self.padding_policy);
        formatter.field("watermarks", &self.watermarks);
        formatter.finish()
    }
}
/// See [`VideoParameters`](crate::model::VideoParameters)
pub mod video_parameters {
    /// A builder for [`VideoParameters`](crate::model::VideoParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) codec: std::option::Option<std::string::String>,
        pub(crate) codec_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) keyframes_max_dist: std::option::Option<std::string::String>,
        pub(crate) fixed_gop: std::option::Option<std::string::String>,
        pub(crate) bit_rate: std::option::Option<std::string::String>,
        pub(crate) frame_rate: std::option::Option<std::string::String>,
        pub(crate) max_frame_rate: std::option::Option<std::string::String>,
        pub(crate) resolution: std::option::Option<std::string::String>,
        pub(crate) aspect_ratio: std::option::Option<std::string::String>,
        pub(crate) max_width: std::option::Option<std::string::String>,
        pub(crate) max_height: std::option::Option<std::string::String>,
        pub(crate) display_aspect_ratio: std::option::Option<std::string::String>,
        pub(crate) sizing_policy: std::option::Option<std::string::String>,
        pub(crate) padding_policy: std::option::Option<std::string::String>,
        pub(crate) watermarks: std::option::Option<std::vec::Vec<crate::model::PresetWatermark>>,
    }
    impl Builder {
        /// <p>The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>, <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container type is <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.</p>
        pub fn codec(mut self, input: impl Into<std::string::String>) -> Self {
            self.codec = Some(input.into());
            self
        }
        /// <p>The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>, <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container type is <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.</p>
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.codec = input;
            self
        }
        /// Adds a key-value pair to `codec_options`.
        ///
        /// To override the contents of this collection use [`set_codec_options`](Self::set_codec_options).
        ///
        /// <p> <b>Profile (H.264/VP8/VP9 Only)</b> </p>
        /// <p>The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following profiles:</p>
        /// <ul>
        /// <li> <p> <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile applications.</p> </li>
        /// <li> <p> <code>main</code>: The profile used for standard-definition digital TV broadcasts.</p> </li>
        /// <li> <p> <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.</p> </li>
        /// </ul>
        /// <p> <b>Level (H.264 Only)</b> </p>
        /// <p>The H.264 level that you want to use for the output file. Elastic Transcoder supports the following levels:</p>
        /// <p> <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>, <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>, <code>4.1</code> </p>
        /// <p> <b>MaxReferenceFrames (H.264 Only)</b> </p>
        /// <p>Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded frames to use as a reference for decoding future frames. Valid values are integers 0 through 16, but we recommend that you not use a value greater than the following:</p>
        /// <p> <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code> </p>
        /// <p>where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or Resolution. <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the <code>Level</code> object. See the list below. (A macroblock is a block of pixels measuring 16x16.) </p>
        /// <ul>
        /// <li> <p>1 - 396</p> </li>
        /// <li> <p>1b - 396</p> </li>
        /// <li> <p>1.1 - 900</p> </li>
        /// <li> <p>1.2 - 2376</p> </li>
        /// <li> <p>1.3 - 2376</p> </li>
        /// <li> <p>2 - 2376</p> </li>
        /// <li> <p>2.1 - 4752</p> </li>
        /// <li> <p>2.2 - 8100</p> </li>
        /// <li> <p>3 - 8100</p> </li>
        /// <li> <p>3.1 - 18000</p> </li>
        /// <li> <p>3.2 - 20480</p> </li>
        /// <li> <p>4 - 32768</p> </li>
        /// <li> <p>4.1 - 32768</p> </li>
        /// </ul>
        /// <p> <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
        /// <p>The maximum number of bits per second in a video buffer; the size of the buffer is specified by <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required to stream a video by reducing the maximum bit rate, but this also reduces the quality of the video.</p>
        /// <p> <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
        /// <p>The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds, the standard segment duration when you're using FMP4 or MPEG-TS for the container type of the output video. Specify an integer greater than 0. If you specify <code>MaxBitRate</code> and omit <code>BufferSize</code>, Elastic Transcoder sets <code>BufferSize</code> to 10 times the value of <code>MaxBitRate</code>.</p>
        /// <p> <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b> </p>
        /// <p>The interlace mode for the output video.</p>
        /// <p>Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one field on every other line, the other field on the other lines) so that the human eye registers multiple pictures per frame. Interlacing reduces the bandwidth required for transmitting a video, but can result in blurred images and flickering.</p>
        /// <p>Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code> (top field first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.</p>
        /// <p>If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for the output. If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.</p>
        /// <p> <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b> </p>
        /// <p>The color space conversion Elastic Transcoder applies to the output video. Color spaces are the algorithms used by the computer to store information about how to render color. <code>Bt.601</code> is the standard for standard definition video, while <code>Bt.709</code> is the standard for high definition video.</p>
        /// <p>Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and <code>Auto</code>.</p>
        /// <p>If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is interlaced, your frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>50</code>, or <code>60</code>, your <code>SegmentDuration</code> is null, and you are using one of the resolution changes from the list below, Elastic Transcoder applies the following color space conversions:</p>
        /// <ul>
        /// <li> <p> <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
        /// <li> <p> <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
        /// <li> <p> <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
        /// <li> <p> <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
        /// </ul> <note>
        /// <p>Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code> <code>Auto</code> mode in the future. All outputs in a playlist must use the same <code>ColorSpaceConversionMode</code>.</p>
        /// </note>
        /// <p>If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the color space of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to your output file, you can check the <code>AppliedColorSpaceConversion</code> parameter included in your job response. If your job does not have an <code>AppliedColorSpaceConversion</code> in its response, no <code>ColorSpaceConversionMode</code> was applied.</p>
        /// <p> <b>ChromaSubsampling</b> </p>
        /// <p>The sampling pattern for the chroma (color) channels of the output video. Valid values include <code>yuv420p</code> and <code>yuv422p</code>.</p>
        /// <p> <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical line, <code>yuv422p</code> samples the color information of every horizontal line and every other vertical line.</p>
        /// <p> <b>LoopCount (Gif Only)</b> </p>
        /// <p>The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and integers between <code>0</code> and <code>100</code>, inclusive.</p>
        pub fn codec_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.codec_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.codec_options = Some(hash_map);
            self
        }
        /// <p> <b>Profile (H.264/VP8/VP9 Only)</b> </p>
        /// <p>The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following profiles:</p>
        /// <ul>
        /// <li> <p> <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile applications.</p> </li>
        /// <li> <p> <code>main</code>: The profile used for standard-definition digital TV broadcasts.</p> </li>
        /// <li> <p> <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.</p> </li>
        /// </ul>
        /// <p> <b>Level (H.264 Only)</b> </p>
        /// <p>The H.264 level that you want to use for the output file. Elastic Transcoder supports the following levels:</p>
        /// <p> <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>, <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>, <code>4.1</code> </p>
        /// <p> <b>MaxReferenceFrames (H.264 Only)</b> </p>
        /// <p>Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded frames to use as a reference for decoding future frames. Valid values are integers 0 through 16, but we recommend that you not use a value greater than the following:</p>
        /// <p> <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code> </p>
        /// <p>where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or Resolution. <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the <code>Level</code> object. See the list below. (A macroblock is a block of pixels measuring 16x16.) </p>
        /// <ul>
        /// <li> <p>1 - 396</p> </li>
        /// <li> <p>1b - 396</p> </li>
        /// <li> <p>1.1 - 900</p> </li>
        /// <li> <p>1.2 - 2376</p> </li>
        /// <li> <p>1.3 - 2376</p> </li>
        /// <li> <p>2 - 2376</p> </li>
        /// <li> <p>2.1 - 4752</p> </li>
        /// <li> <p>2.2 - 8100</p> </li>
        /// <li> <p>3 - 8100</p> </li>
        /// <li> <p>3.1 - 18000</p> </li>
        /// <li> <p>3.2 - 20480</p> </li>
        /// <li> <p>4 - 32768</p> </li>
        /// <li> <p>4.1 - 32768</p> </li>
        /// </ul>
        /// <p> <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
        /// <p>The maximum number of bits per second in a video buffer; the size of the buffer is specified by <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required to stream a video by reducing the maximum bit rate, but this also reduces the quality of the video.</p>
        /// <p> <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b> </p>
        /// <p>The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds, the standard segment duration when you're using FMP4 or MPEG-TS for the container type of the output video. Specify an integer greater than 0. If you specify <code>MaxBitRate</code> and omit <code>BufferSize</code>, Elastic Transcoder sets <code>BufferSize</code> to 10 times the value of <code>MaxBitRate</code>.</p>
        /// <p> <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b> </p>
        /// <p>The interlace mode for the output video.</p>
        /// <p>Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one field on every other line, the other field on the other lines) so that the human eye registers multiple pictures per frame. Interlacing reduces the bandwidth required for transmitting a video, but can result in blurred images and flickering.</p>
        /// <p>Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code> (top field first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.</p>
        /// <p>If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for the output. If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.</p>
        /// <p> <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b> </p>
        /// <p>The color space conversion Elastic Transcoder applies to the output video. Color spaces are the algorithms used by the computer to store information about how to render color. <code>Bt.601</code> is the standard for standard definition video, while <code>Bt.709</code> is the standard for high definition video.</p>
        /// <p>Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and <code>Auto</code>.</p>
        /// <p>If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is interlaced, your frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>50</code>, or <code>60</code>, your <code>SegmentDuration</code> is null, and you are using one of the resolution changes from the list below, Elastic Transcoder applies the following color space conversions:</p>
        /// <ul>
        /// <li> <p> <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
        /// <li> <p> <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code> </p> </li>
        /// <li> <p> <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
        /// <li> <p> <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code> </p> </li>
        /// </ul> <note>
        /// <p>Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code> <code>Auto</code> mode in the future. All outputs in a playlist must use the same <code>ColorSpaceConversionMode</code>.</p>
        /// </note>
        /// <p>If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the color space of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to your output file, you can check the <code>AppliedColorSpaceConversion</code> parameter included in your job response. If your job does not have an <code>AppliedColorSpaceConversion</code> in its response, no <code>ColorSpaceConversionMode</code> was applied.</p>
        /// <p> <b>ChromaSubsampling</b> </p>
        /// <p>The sampling pattern for the chroma (color) channels of the output video. Valid values include <code>yuv420p</code> and <code>yuv422p</code>.</p>
        /// <p> <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical line, <code>yuv422p</code> samples the color information of every horizontal line and every other vertical line.</p>
        /// <p> <b>LoopCount (Gif Only)</b> </p>
        /// <p>The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and integers between <code>0</code> and <code>100</code>, inclusive.</p>
        pub fn set_codec_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.codec_options = input;
            self
        }
        /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
        /// <p>The maximum number of frames between key frames. Key frames are fully encoded frames; the frames between key frames are encoded based, in part, on the content of the key frames. The value is an integer formatted as a string; valid values are between 1 (every frame is a key frame) and 100000, inclusive. A higher value results in higher compression but may also discernibly decrease video quality.</p>
        /// <p>For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different quality levels while the file is being played.</p>
        /// <p>For example, an input file can have a <code>FrameRate</code> of 30 with a <code>KeyframesMaxDist</code> of 90. The output file then needs to have a ratio of 1:3. Valid outputs would have <code>FrameRate</code> of 30, 25, and 10, and <code>KeyframesMaxDist</code> of 90, 75, and 30, respectively.</p>
        /// <p>Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values for <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.</p>
        pub fn keyframes_max_dist(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyframes_max_dist = Some(input.into());
            self
        }
        /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
        /// <p>The maximum number of frames between key frames. Key frames are fully encoded frames; the frames between key frames are encoded based, in part, on the content of the key frames. The value is an integer formatted as a string; valid values are between 1 (every frame is a key frame) and 100000, inclusive. A higher value results in higher compression but may also discernibly decrease video quality.</p>
        /// <p>For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different quality levels while the file is being played.</p>
        /// <p>For example, an input file can have a <code>FrameRate</code> of 30 with a <code>KeyframesMaxDist</code> of 90. The output file then needs to have a ratio of 1:3. Valid outputs would have <code>FrameRate</code> of 30, 25, and 10, and <code>KeyframesMaxDist</code> of 90, 75, and 30, respectively.</p>
        /// <p>Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values for <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.</p>
        pub fn set_keyframes_max_dist(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyframes_max_dist = input;
            self
        }
        /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
        /// <p>Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and <code>false</code>:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance between key frames (the number of frames in a group of pictures, or GOP).</p> </li>
        /// <li> <p> <code>false</code>: The distance between key frames can vary.</p> </li>
        /// </ul> <important>
        /// <p> <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.</p>
        /// </important>
        pub fn fixed_gop(mut self, input: impl Into<std::string::String>) -> Self {
            self.fixed_gop = Some(input.into());
            self
        }
        /// <p>Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or <code>VP8</code>.</p>
        /// <p>Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and <code>false</code>:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance between key frames (the number of frames in a group of pictures, or GOP).</p> </li>
        /// <li> <p> <code>false</code>: The distance between key frames can vary.</p> </li>
        /// </ul> <important>
        /// <p> <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.</p>
        /// </important>
        pub fn set_fixed_gop(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fixed_gop = input;
            self
        }
        /// <p>The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the values of <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic Transcoder uses the detected bit rate of the input source. If you specify a value other than <code>auto</code>, we recommend that you specify a value less than or equal to the maximum H.264-compliant value listed for your level and profile:</p>
        /// <p> <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit rate in kilobits/second (high Profile)</i> </p>
        /// <ul>
        /// <li> <p>1 - 64 : 80</p> </li>
        /// <li> <p>1b - 128 : 160</p> </li>
        /// <li> <p>1.1 - 192 : 240</p> </li>
        /// <li> <p>1.2 - 384 : 480</p> </li>
        /// <li> <p>1.3 - 768 : 960</p> </li>
        /// <li> <p>2 - 2000 : 2500</p> </li>
        /// <li> <p>3 - 10000 : 12500</p> </li>
        /// <li> <p>3.1 - 14000 : 17500</p> </li>
        /// <li> <p>3.2 - 20000 : 25000</p> </li>
        /// <li> <p>4 - 20000 : 25000</p> </li>
        /// <li> <p>4.1 - 50000 : 62500</p> </li>
        /// </ul>
        pub fn bit_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.bit_rate = Some(input.into());
            self
        }
        /// <p>The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the values of <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic Transcoder uses the detected bit rate of the input source. If you specify a value other than <code>auto</code>, we recommend that you specify a value less than or equal to the maximum H.264-compliant value listed for your level and profile:</p>
        /// <p> <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit rate in kilobits/second (high Profile)</i> </p>
        /// <ul>
        /// <li> <p>1 - 64 : 80</p> </li>
        /// <li> <p>1b - 128 : 160</p> </li>
        /// <li> <p>1.1 - 192 : 240</p> </li>
        /// <li> <p>1.2 - 384 : 480</p> </li>
        /// <li> <p>1.3 - 768 : 960</p> </li>
        /// <li> <p>2 - 2000 : 2500</p> </li>
        /// <li> <p>3 - 10000 : 12500</p> </li>
        /// <li> <p>3.1 - 14000 : 17500</p> </li>
        /// <li> <p>3.2 - 20000 : 25000</p> </li>
        /// <li> <p>4 - 20000 : 25000</p> </li>
        /// <li> <p>4.1 - 50000 : 62500</p> </li>
        /// </ul>
        pub fn set_bit_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bit_rate = input;
            self
        }
        /// <p>The frames per second for the video stream in the output file. Valid values include:</p>
        /// <p> <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source. If you specify a frame rate, we recommend that you perform the following calculation:</p>
        /// <p> <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code> </p>
        /// <p>where:</p>
        /// <ul>
        /// <li> <p> <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.</p> </li>
        /// <li> <p> <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum value listed in the following table, based on the value that you specified for Level.</p> </li>
        /// </ul>
        /// <p>The maximum recommended decoding speed in Luma samples/second for each level is described in the following list (<i>Level - Decoding speed</i>):</p>
        /// <ul>
        /// <li> <p>1 - 380160</p> </li>
        /// <li> <p>1b - 380160</p> </li>
        /// <li> <p>1.1 - 76800</p> </li>
        /// <li> <p>1.2 - 1536000</p> </li>
        /// <li> <p>1.3 - 3041280</p> </li>
        /// <li> <p>2 - 3041280</p> </li>
        /// <li> <p>2.1 - 5068800</p> </li>
        /// <li> <p>2.2 - 5184000</p> </li>
        /// <li> <p>3 - 10368000</p> </li>
        /// <li> <p>3.1 - 27648000</p> </li>
        /// <li> <p>3.2 - 55296000</p> </li>
        /// <li> <p>4 - 62914560</p> </li>
        /// <li> <p>4.1 - 62914560</p> </li>
        /// </ul>
        pub fn frame_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.frame_rate = Some(input.into());
            self
        }
        /// <p>The frames per second for the video stream in the output file. Valid values include:</p>
        /// <p> <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source. If you specify a frame rate, we recommend that you perform the following calculation:</p>
        /// <p> <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code> </p>
        /// <p>where:</p>
        /// <ul>
        /// <li> <p> <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.</p> </li>
        /// <li> <p> <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum value listed in the following table, based on the value that you specified for Level.</p> </li>
        /// </ul>
        /// <p>The maximum recommended decoding speed in Luma samples/second for each level is described in the following list (<i>Level - Decoding speed</i>):</p>
        /// <ul>
        /// <li> <p>1 - 380160</p> </li>
        /// <li> <p>1b - 380160</p> </li>
        /// <li> <p>1.1 - 76800</p> </li>
        /// <li> <p>1.2 - 1536000</p> </li>
        /// <li> <p>1.3 - 3041280</p> </li>
        /// <li> <p>2 - 3041280</p> </li>
        /// <li> <p>2.1 - 5068800</p> </li>
        /// <li> <p>2.2 - 5184000</p> </li>
        /// <li> <p>3 - 10368000</p> </li>
        /// <li> <p>3.1 - 27648000</p> </li>
        /// <li> <p>3.2 - 55296000</p> </li>
        /// <li> <p>4 - 62914560</p> </li>
        /// <li> <p>4.1 - 62914560</p> </li>
        /// </ul>
        pub fn set_frame_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.frame_rate = input;
            self
        }
        /// <p>If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of the input video for the frame rate of the output video. Specify the maximum frame rate that you want Elastic Transcoder to use when the frame rate of the input video is greater than the desired maximum frame rate of the output video. Valid values include: <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code>.</p>
        pub fn max_frame_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_frame_rate = Some(input.into());
            self
        }
        /// <p>If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of the input video for the frame rate of the output video. Specify the maximum frame rate that you want Elastic Transcoder to use when the frame rate of the input video is greater than the desired maximum frame rate of the output video. Valid values include: <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code>.</p>
        pub fn set_max_frame_rate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_frame_rate = input;
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The width and height of the video in the output file, in pixels. Valid values are <code>auto</code> and <i>width</i> x <i>height</i>:</p>
        /// <ul>
        /// <li> <p> <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file, subject to the following rules.</p> </li>
        /// <li> <p> <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.</p> </li>
        /// </ul>
        /// <p>Note the following about specifying the width and height:</p>
        /// <ul>
        /// <li> <p>The width must be an even integer between 128 and 4096, inclusive.</p> </li>
        /// <li> <p>The height must be an even integer between 96 and 3072, inclusive.</p> </li>
        /// <li> <p>If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder rescales the output file to the lower resolution.</p> </li>
        /// <li> <p>If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder rescales the output to the higher resolution.</p> </li>
        /// <li> <p>We recommend that you specify a resolution for which the product of width and height is less than or equal to the applicable value in the following list (<i>List - Max width x height value</i>):</p>
        /// <ul>
        /// <li> <p>1 - 25344</p> </li>
        /// <li> <p>1b - 25344</p> </li>
        /// <li> <p>1.1 - 101376</p> </li>
        /// <li> <p>1.2 - 101376</p> </li>
        /// <li> <p>1.3 - 101376</p> </li>
        /// <li> <p>2 - 101376</p> </li>
        /// <li> <p>2.1 - 202752</p> </li>
        /// <li> <p>2.2 - 404720</p> </li>
        /// <li> <p>3 - 404720</p> </li>
        /// <li> <p>3.1 - 921600</p> </li>
        /// <li> <p>3.2 - 1310720</p> </li>
        /// <li> <p>4 - 2097152</p> </li>
        /// <li> <p>4.1 - 2097152</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn resolution(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution = Some(input.into());
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The width and height of the video in the output file, in pixels. Valid values are <code>auto</code> and <i>width</i> x <i>height</i>:</p>
        /// <ul>
        /// <li> <p> <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file, subject to the following rules.</p> </li>
        /// <li> <p> <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.</p> </li>
        /// </ul>
        /// <p>Note the following about specifying the width and height:</p>
        /// <ul>
        /// <li> <p>The width must be an even integer between 128 and 4096, inclusive.</p> </li>
        /// <li> <p>The height must be an even integer between 96 and 3072, inclusive.</p> </li>
        /// <li> <p>If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder rescales the output file to the lower resolution.</p> </li>
        /// <li> <p>If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder rescales the output to the higher resolution.</p> </li>
        /// <li> <p>We recommend that you specify a resolution for which the product of width and height is less than or equal to the applicable value in the following list (<i>List - Max width x height value</i>):</p>
        /// <ul>
        /// <li> <p>1 - 25344</p> </li>
        /// <li> <p>1b - 25344</p> </li>
        /// <li> <p>1.1 - 101376</p> </li>
        /// <li> <p>1.2 - 101376</p> </li>
        /// <li> <p>1.3 - 101376</p> </li>
        /// <li> <p>2 - 101376</p> </li>
        /// <li> <p>2.1 - 202752</p> </li>
        /// <li> <p>2.2 - 404720</p> </li>
        /// <li> <p>3 - 404720</p> </li>
        /// <li> <p>3.1 - 921600</p> </li>
        /// <li> <p>3.2 - 1310720</p> </li>
        /// <li> <p>4 - 2097152</p> </li>
        /// <li> <p>4.1 - 2097152</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolution = input;
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The display aspect ratio of the video in the output file. Valid values include:</p>
        /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input file.</p>
        /// <p>If you specify an aspect ratio for the output file that differs from aspect ratio of the input file, Elastic Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top and bottom) to maintain the aspect ratio of the active region of the video.</p>
        pub fn aspect_ratio(mut self, input: impl Into<std::string::String>) -> Self {
            self.aspect_ratio = Some(input.into());
            self
        }
        /// <important>
        /// <p>To better control resolution and aspect ratio of output videos, we recommend that you use the values <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups of settings are mutually exclusive. Do not use them together.</p>
        /// </important>
        /// <p>The display aspect ratio of the video in the output file. Valid values include:</p>
        /// <p> <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input file.</p>
        /// <p>If you specify an aspect ratio for the output file that differs from aspect ratio of the input file, Elastic Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top and bottom) to maintain the aspect ratio of the active region of the video.</p>
        pub fn set_aspect_ratio(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aspect_ratio = input;
            self
        }
        /// <p> The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and 4096. </p>
        pub fn max_width(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_width = Some(input.into());
            self
        }
        /// <p> The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and 4096. </p>
        pub fn set_max_width(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_width = input;
            self
        }
        /// <p>The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and 3072.</p>
        pub fn max_height(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_height = Some(input.into());
            self
        }
        /// <p>The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and 3072.</p>
        pub fn set_max_height(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_height = input;
            self
        }
        /// <p>The value that Elastic Transcoder adds to the metadata in the output file.</p>
        pub fn display_aspect_ratio(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_aspect_ratio = Some(input.into());
            self
        }
        /// <p>The value that Elastic Transcoder adds to the metadata in the output file.</p>
        pub fn set_display_aspect_ratio(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.display_aspect_ratio = input;
            self
        }
        /// <p>Specify one of the following values to control scaling of the output video:</p>
        /// <ul>
        /// <li> <p> <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
        /// <li> <p> <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output video and then crops it in the dimension (if any) that exceeds the maximum value.</p> </li>
        /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input video and the output video are different, the output video will be distorted.</p> </li>
        /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the input video exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output video.</p> </li>
        /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
        /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
        /// </ul>
        pub fn sizing_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.sizing_policy = Some(input.into());
            self
        }
        /// <p>Specify one of the following values to control scaling of the output video:</p>
        /// <ul>
        /// <li> <p> <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
        /// <li> <p> <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output video and then crops it in the dimension (if any) that exceeds the maximum value.</p> </li>
        /// <li> <p> <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input video and the output video are different, the output video will be distorted.</p> </li>
        /// <li> <p> <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the input video exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output video.</p> </li>
        /// <li> <p> <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
        /// <li> <p> <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the video up.</p> </li>
        /// </ul>
        pub fn set_sizing_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sizing_policy = input;
            self
        }
        /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of the output video to make the total size of the output video match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
        pub fn padding_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.padding_policy = Some(input.into());
            self
        }
        /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of the output video to make the total size of the output video match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
        pub fn set_padding_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.padding_policy = input;
            self
        }
        /// Appends an item to `watermarks`.
        ///
        /// To override the contents of this collection use [`set_watermarks`](Self::set_watermarks).
        ///
        /// <p>Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in the specified size and location, and with the specified opacity for the duration of the transcoded video.</p>
        /// <p>Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png format, which supports transparency.</p>
        /// <p>When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have different dimensions.</p>
        pub fn watermarks(mut self, input: crate::model::PresetWatermark) -> Self {
            let mut v = self.watermarks.unwrap_or_default();
            v.push(input);
            self.watermarks = Some(v);
            self
        }
        /// <p>Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in the specified size and location, and with the specified opacity for the duration of the transcoded video.</p>
        /// <p>Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png format, which supports transparency.</p>
        /// <p>When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have different dimensions.</p>
        pub fn set_watermarks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PresetWatermark>>,
        ) -> Self {
            self.watermarks = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoParameters`](crate::model::VideoParameters)
        pub fn build(self) -> crate::model::VideoParameters {
            crate::model::VideoParameters {
                codec: self.codec,
                codec_options: self.codec_options,
                keyframes_max_dist: self.keyframes_max_dist,
                fixed_gop: self.fixed_gop,
                bit_rate: self.bit_rate,
                frame_rate: self.frame_rate,
                max_frame_rate: self.max_frame_rate,
                resolution: self.resolution,
                aspect_ratio: self.aspect_ratio,
                max_width: self.max_width,
                max_height: self.max_height,
                display_aspect_ratio: self.display_aspect_ratio,
                sizing_policy: self.sizing_policy,
                padding_policy: self.padding_policy,
                watermarks: self.watermarks,
            }
        }
    }
}
impl VideoParameters {
    /// Creates a new builder-style object to manufacture [`VideoParameters`](crate::model::VideoParameters)
    pub fn builder() -> crate::model::video_parameters::Builder {
        crate::model::video_parameters::Builder::default()
    }
}

/// <p>Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in the specified size and location, and with the specified opacity for the duration of the transcoded video.</p>
/// <p>Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png format, which supports transparency.</p>
/// <p>When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have different dimensions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PresetWatermark {
    /// <p> A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40 characters long. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The maximum width of the watermark in one of the following formats: </p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxWidth</code>.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxWidth</code>.</p> </li>
    /// </ul>
    pub max_width: std::option::Option<std::string::String>,
    /// <p>The maximum height of the watermark in one of the following formats: </p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> </li>
    /// </ul>
    /// <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxHeight</code>.</p>
    pub max_height: std::option::Option<std::string::String>,
    /// <p>A value that controls scaling of the watermark: </p>
    /// <ul>
    /// <li> <p> <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
    /// <li> <p> <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the values of <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be distorted.</p> </li>
    /// <li> <p> <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the watermark up.</p> </li>
    /// </ul>
    pub sizing_policy: std::option::Option<std::string::String>,
    /// <p>The horizontal position of the watermark unless you specify a non-zero value for <code>HorizontalOffset</code>: </p>
    /// <ul>
    /// <li> <p> <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.</p> </li>
    /// <li> <p> <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.</p> </li>
    /// <li> <p> <b>Center</b>: The watermark is centered between the left and right borders.</p> </li>
    /// </ul>
    pub horizontal_align: std::option::Option<std::string::String>,
    /// <p>The amount by which you want the horizontal position of the watermark to be offset from the position specified by HorizontalAlign: </p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
    /// </ul>
    /// <p>For example, if you specify Left for <code>HorizontalAlign</code> and 5px for <code>HorizontalOffset</code>, the left side of the watermark appears 5 pixels from the left border of the output video.</p>
    /// <p> <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is <code>Left</code> or <code>Right</code>. If you specify an offset that causes the watermark to extend beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
    /// <p>Use the value of <code>Target</code> to specify whether you want to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
    pub horizontal_offset: std::option::Option<std::string::String>,
    /// <p>The vertical position of the watermark unless you specify a non-zero value for <code>VerticalOffset</code>: </p>
    /// <ul>
    /// <li> <p> <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.</p> </li>
    /// <li> <p> <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.</p> </li>
    /// <li> <p> <b>Center</b>: The watermark is centered between the top and bottom borders.</p> </li>
    /// </ul>
    pub vertical_align: std::option::Option<std::string::String>,
    /// <p> <code>VerticalOffset</code> </p>
    /// <p>The amount by which you want the vertical position of the watermark to be offset from the position specified by VerticalAlign:</p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
    /// </ul>
    /// <p>For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the output video.</p>
    /// <p> <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.</p>
    /// <p>If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
    /// <p>Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
    pub vertical_offset: std::option::Option<std::string::String>,
    /// <p>A percentage that indicates how much you want a watermark to obscure the video in the location where it appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video in the specified location). The datatype of <code>Opacity</code> is float.</p>
    /// <p>Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion of the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg file format doesn't support transparency.</p>
    pub opacity: std::option::Option<std::string::String>,
    /// <p>A value that determines how Elastic Transcoder interprets values that you specified for <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and <code>MaxHeight</code>:</p>
    /// <ul>
    /// <li> <p> <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any.</p> </li>
    /// <li> <p> <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any.</p> </li>
    /// </ul>
    pub target: std::option::Option<std::string::String>,
}
impl PresetWatermark {
    /// <p> A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40 characters long. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The maximum width of the watermark in one of the following formats: </p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxWidth</code>.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxWidth</code>.</p> </li>
    /// </ul>
    pub fn max_width(&self) -> std::option::Option<&str> {
        self.max_width.as_deref()
    }
    /// <p>The maximum height of the watermark in one of the following formats: </p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> </li>
    /// </ul>
    /// <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxHeight</code>.</p>
    pub fn max_height(&self) -> std::option::Option<&str> {
        self.max_height.as_deref()
    }
    /// <p>A value that controls scaling of the watermark: </p>
    /// <ul>
    /// <li> <p> <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
    /// <li> <p> <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the values of <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be distorted.</p> </li>
    /// <li> <p> <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the watermark up.</p> </li>
    /// </ul>
    pub fn sizing_policy(&self) -> std::option::Option<&str> {
        self.sizing_policy.as_deref()
    }
    /// <p>The horizontal position of the watermark unless you specify a non-zero value for <code>HorizontalOffset</code>: </p>
    /// <ul>
    /// <li> <p> <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.</p> </li>
    /// <li> <p> <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.</p> </li>
    /// <li> <p> <b>Center</b>: The watermark is centered between the left and right borders.</p> </li>
    /// </ul>
    pub fn horizontal_align(&self) -> std::option::Option<&str> {
        self.horizontal_align.as_deref()
    }
    /// <p>The amount by which you want the horizontal position of the watermark to be offset from the position specified by HorizontalAlign: </p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
    /// </ul>
    /// <p>For example, if you specify Left for <code>HorizontalAlign</code> and 5px for <code>HorizontalOffset</code>, the left side of the watermark appears 5 pixels from the left border of the output video.</p>
    /// <p> <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is <code>Left</code> or <code>Right</code>. If you specify an offset that causes the watermark to extend beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
    /// <p>Use the value of <code>Target</code> to specify whether you want to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
    pub fn horizontal_offset(&self) -> std::option::Option<&str> {
        self.horizontal_offset.as_deref()
    }
    /// <p>The vertical position of the watermark unless you specify a non-zero value for <code>VerticalOffset</code>: </p>
    /// <ul>
    /// <li> <p> <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.</p> </li>
    /// <li> <p> <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.</p> </li>
    /// <li> <p> <b>Center</b>: The watermark is centered between the top and bottom borders.</p> </li>
    /// </ul>
    pub fn vertical_align(&self) -> std::option::Option<&str> {
        self.vertical_align.as_deref()
    }
    /// <p> <code>VerticalOffset</code> </p>
    /// <p>The amount by which you want the vertical position of the watermark to be offset from the position specified by VerticalAlign:</p>
    /// <ul>
    /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
    /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
    /// </ul>
    /// <p>For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the output video.</p>
    /// <p> <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.</p>
    /// <p>If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
    /// <p>Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
    pub fn vertical_offset(&self) -> std::option::Option<&str> {
        self.vertical_offset.as_deref()
    }
    /// <p>A percentage that indicates how much you want a watermark to obscure the video in the location where it appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video in the specified location). The datatype of <code>Opacity</code> is float.</p>
    /// <p>Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion of the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg file format doesn't support transparency.</p>
    pub fn opacity(&self) -> std::option::Option<&str> {
        self.opacity.as_deref()
    }
    /// <p>A value that determines how Elastic Transcoder interprets values that you specified for <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and <code>MaxHeight</code>:</p>
    /// <ul>
    /// <li> <p> <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any.</p> </li>
    /// <li> <p> <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any.</p> </li>
    /// </ul>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for PresetWatermark {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PresetWatermark");
        formatter.field("id", &self.id);
        formatter.field("max_width", &self.max_width);
        formatter.field("max_height", &self.max_height);
        formatter.field("sizing_policy", &self.sizing_policy);
        formatter.field("horizontal_align", &self.horizontal_align);
        formatter.field("horizontal_offset", &self.horizontal_offset);
        formatter.field("vertical_align", &self.vertical_align);
        formatter.field("vertical_offset", &self.vertical_offset);
        formatter.field("opacity", &self.opacity);
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`PresetWatermark`](crate::model::PresetWatermark)
pub mod preset_watermark {
    /// A builder for [`PresetWatermark`](crate::model::PresetWatermark)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) max_width: std::option::Option<std::string::String>,
        pub(crate) max_height: std::option::Option<std::string::String>,
        pub(crate) sizing_policy: std::option::Option<std::string::String>,
        pub(crate) horizontal_align: std::option::Option<std::string::String>,
        pub(crate) horizontal_offset: std::option::Option<std::string::String>,
        pub(crate) vertical_align: std::option::Option<std::string::String>,
        pub(crate) vertical_offset: std::option::Option<std::string::String>,
        pub(crate) opacity: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40 characters long. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> A unique identifier for the settings for one watermark. The value of <code>Id</code> can be up to 40 characters long. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The maximum width of the watermark in one of the following formats: </p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxWidth</code>.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxWidth</code>.</p> </li>
        /// </ul>
        pub fn max_width(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_width = Some(input.into());
            self
        }
        /// <p>The maximum width of the watermark in one of the following formats: </p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxWidth</code>.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxWidth</code>.</p> </li>
        /// </ul>
        pub fn set_max_width(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_width = input;
            self
        }
        /// <p>The maximum height of the watermark in one of the following formats: </p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> </li>
        /// </ul>
        /// <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxHeight</code>.</p>
        pub fn max_height(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_height = Some(input.into());
            self
        }
        /// <p>The maximum height of the watermark in one of the following formats: </p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100. Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.</p> </li>
        /// </ul>
        /// <p>If you specify the value in pixels, it must be less than or equal to the value of <code>MaxHeight</code>.</p>
        pub fn set_max_height(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_height = input;
            self
        }
        /// <p>A value that controls scaling of the watermark: </p>
        /// <ul>
        /// <li> <p> <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
        /// <li> <p> <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the values of <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be distorted.</p> </li>
        /// <li> <p> <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the watermark up.</p> </li>
        /// </ul>
        pub fn sizing_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.sizing_policy = Some(input.into());
            self
        }
        /// <p>A value that controls scaling of the watermark: </p>
        /// <ul>
        /// <li> <p> <b>Fit</b>: Elastic Transcoder scales the watermark so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
        /// <li> <p> <b>Stretch</b>: Elastic Transcoder stretches the watermark to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the watermark and the values of <code>MaxWidth</code> and <code>MaxHeight</code> are different, the watermark will be distorted.</p> </li>
        /// <li> <p> <b>ShrinkToFit</b>: Elastic Transcoder scales the watermark down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the watermark up.</p> </li>
        /// </ul>
        pub fn set_sizing_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sizing_policy = input;
            self
        }
        /// <p>The horizontal position of the watermark unless you specify a non-zero value for <code>HorizontalOffset</code>: </p>
        /// <ul>
        /// <li> <p> <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.</p> </li>
        /// <li> <p> <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.</p> </li>
        /// <li> <p> <b>Center</b>: The watermark is centered between the left and right borders.</p> </li>
        /// </ul>
        pub fn horizontal_align(mut self, input: impl Into<std::string::String>) -> Self {
            self.horizontal_align = Some(input.into());
            self
        }
        /// <p>The horizontal position of the watermark unless you specify a non-zero value for <code>HorizontalOffset</code>: </p>
        /// <ul>
        /// <li> <p> <b>Left</b>: The left edge of the watermark is aligned with the left border of the video.</p> </li>
        /// <li> <p> <b>Right</b>: The right edge of the watermark is aligned with the right border of the video.</p> </li>
        /// <li> <p> <b>Center</b>: The watermark is centered between the left and right borders.</p> </li>
        /// </ul>
        pub fn set_horizontal_align(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.horizontal_align = input;
            self
        }
        /// <p>The amount by which you want the horizontal position of the watermark to be offset from the position specified by HorizontalAlign: </p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
        /// </ul>
        /// <p>For example, if you specify Left for <code>HorizontalAlign</code> and 5px for <code>HorizontalOffset</code>, the left side of the watermark appears 5 pixels from the left border of the output video.</p>
        /// <p> <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is <code>Left</code> or <code>Right</code>. If you specify an offset that causes the watermark to extend beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
        /// <p>Use the value of <code>Target</code> to specify whether you want to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
        pub fn horizontal_offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.horizontal_offset = Some(input.into());
            self
        }
        /// <p>The amount by which you want the horizontal position of the watermark to be offset from the position specified by HorizontalAlign: </p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
        /// </ul>
        /// <p>For example, if you specify Left for <code>HorizontalAlign</code> and 5px for <code>HorizontalOffset</code>, the left side of the watermark appears 5 pixels from the left border of the output video.</p>
        /// <p> <code>HorizontalOffset</code> is only valid when the value of <code>HorizontalAlign</code> is <code>Left</code> or <code>Right</code>. If you specify an offset that causes the watermark to extend beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
        /// <p>Use the value of <code>Target</code> to specify whether you want to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
        pub fn set_horizontal_offset(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.horizontal_offset = input;
            self
        }
        /// <p>The vertical position of the watermark unless you specify a non-zero value for <code>VerticalOffset</code>: </p>
        /// <ul>
        /// <li> <p> <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.</p> </li>
        /// <li> <p> <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.</p> </li>
        /// <li> <p> <b>Center</b>: The watermark is centered between the top and bottom borders.</p> </li>
        /// </ul>
        pub fn vertical_align(mut self, input: impl Into<std::string::String>) -> Self {
            self.vertical_align = Some(input.into());
            self
        }
        /// <p>The vertical position of the watermark unless you specify a non-zero value for <code>VerticalOffset</code>: </p>
        /// <ul>
        /// <li> <p> <b>Top</b>: The top edge of the watermark is aligned with the top border of the video.</p> </li>
        /// <li> <p> <b>Bottom</b>: The bottom edge of the watermark is aligned with the bottom border of the video.</p> </li>
        /// <li> <p> <b>Center</b>: The watermark is centered between the top and bottom borders.</p> </li>
        /// </ul>
        pub fn set_vertical_align(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vertical_align = input;
            self
        }
        /// <p> <code>VerticalOffset</code> </p>
        /// <p>The amount by which you want the vertical position of the watermark to be offset from the position specified by VerticalAlign:</p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
        /// </ul>
        /// <p>For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the output video.</p>
        /// <p> <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.</p>
        /// <p>If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
        /// <p>Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
        pub fn vertical_offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.vertical_offset = Some(input.into());
            self
        }
        /// <p> <code>VerticalOffset</code> </p>
        /// <p>The amount by which you want the vertical position of the watermark to be offset from the position specified by VerticalAlign:</p>
        /// <ul>
        /// <li> <p>number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of <code>MaxHeight</code>.</p> </li>
        /// <li> <p>integer percentage (%): The range of valid values is 0 to 100.</p> </li>
        /// </ul>
        /// <p>For example, if you specify <code>Top</code> for <code>VerticalAlign</code> and <code>5px</code> for <code>VerticalOffset</code>, the top of the watermark appears 5 pixels from the top border of the output video.</p>
        /// <p> <code>VerticalOffset</code> is only valid when the value of VerticalAlign is Top or Bottom.</p>
        /// <p>If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.</p>
        /// <p>Use the value of <code>Target</code> to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.</p>
        pub fn set_vertical_offset(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vertical_offset = input;
            self
        }
        /// <p>A percentage that indicates how much you want a watermark to obscure the video in the location where it appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video in the specified location). The datatype of <code>Opacity</code> is float.</p>
        /// <p>Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion of the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg file format doesn't support transparency.</p>
        pub fn opacity(mut self, input: impl Into<std::string::String>) -> Self {
            self.opacity = Some(input.into());
            self
        }
        /// <p>A percentage that indicates how much you want a watermark to obscure the video in the location where it appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video in the specified location). The datatype of <code>Opacity</code> is float.</p>
        /// <p>Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion of the video appears as if you had specified a value of 0 for <code>Opacity</code>. The .jpg file format doesn't support transparency.</p>
        pub fn set_opacity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opacity = input;
            self
        }
        /// <p>A value that determines how Elastic Transcoder interprets values that you specified for <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and <code>MaxHeight</code>:</p>
        /// <ul>
        /// <li> <p> <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any.</p> </li>
        /// <li> <p> <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any.</p> </li>
        /// </ul>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>A value that determines how Elastic Transcoder interprets values that you specified for <code>HorizontalOffset</code>, <code>VerticalOffset</code>, <code>MaxWidth</code>, and <code>MaxHeight</code>:</p>
        /// <ul>
        /// <li> <p> <b>Content</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any.</p> </li>
        /// <li> <p> <b>Frame</b>: <code>HorizontalOffset</code> and <code>VerticalOffset</code> values are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any. In addition, <code>MaxWidth</code> and <code>MaxHeight</code>, if specified as a percentage, are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any.</p> </li>
        /// </ul>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`PresetWatermark`](crate::model::PresetWatermark)
        pub fn build(self) -> crate::model::PresetWatermark {
            crate::model::PresetWatermark {
                id: self.id,
                max_width: self.max_width,
                max_height: self.max_height,
                sizing_policy: self.sizing_policy,
                horizontal_align: self.horizontal_align,
                horizontal_offset: self.horizontal_offset,
                vertical_align: self.vertical_align,
                vertical_offset: self.vertical_offset,
                opacity: self.opacity,
                target: self.target,
            }
        }
    }
}
impl PresetWatermark {
    /// Creates a new builder-style object to manufacture [`PresetWatermark`](crate::model::PresetWatermark)
    pub fn builder() -> crate::model::preset_watermark::Builder {
        crate::model::preset_watermark::Builder::default()
    }
}

/// <p>Parameters required for transcoding audio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioParameters {
    /// <p>The audio codec for the output file. Valid values include <code>aac</code>, <code>flac</code>, <code>mp2</code>, <code>mp3</code>, <code>pcm</code>, and <code>vorbis</code>.</p>
    pub codec: std::option::Option<std::string::String>,
    /// <p>The sample rate of the audio stream in the output file, in Hertz. Valid values include:</p>
    /// <p> <code>auto</code>, <code>22050</code>, <code>32000</code>, <code>44100</code>, <code>48000</code>, <code>96000</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder automatically detects the sample rate.</p>
    pub sample_rate: std::option::Option<std::string::String>,
    /// <p>The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.</p>
    pub bit_rate: std::option::Option<std::string::String>,
    /// <p>The number of audio channels in the output file. The following values are valid:</p>
    /// <p> <code>auto</code>, <code>0</code>, <code>1</code>, <code>2</code> </p>
    /// <p>One channel carries the information played by a single speaker. For example, a stereo track with two channels sends one channel to the left speaker, and the other channel to the right speaker. The output channels are organized into tracks. If you want Elastic Transcoder to automatically detect the number of audio channels in the input file and use that value for the output file, select <code>auto</code>.</p>
    /// <p>The output of a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>auto</code> <b> channel specified, with any input:</b> Pass through up to eight input channels.</p> </li>
    /// <li> <p> <code>0</code> <b> channels specified, with any input:</b> Audio omitted from the output.</p> </li>
    /// <li> <p> <code>1</code> <b> channel specified, with at least one input channel:</b> Mono sound.</p> </li>
    /// <li> <p> <code>2</code> <b> channels specified, with any input:</b> Two identical mono channels or stereo. For more information about tracks, see <code>Audio:AudioPackingMode.</code> </p> </li>
    /// </ul>
    /// <p> For more information about how Elastic Transcoder organizes channels and tracks, see <code>Audio:AudioPackingMode</code>.</p>
    pub channels: std::option::Option<std::string::String>,
    /// <p>The method of organizing audio channels and tracks. Use <code>Audio:Channels</code> to specify the number of channels in your output, and <code>Audio:AudioPackingMode</code> to specify the number of tracks and their relation to the channels. If you do not specify an <code>Audio:AudioPackingMode</code>, Elastic Transcoder uses <code>SingleTrack</code>.</p>
    /// <p>The following values are valid:</p>
    /// <p> <code>SingleTrack</code>, <code>OneChannelPerTrack</code>, and <code>OneChannelPerTrackWithMosTo8Tracks</code> </p>
    /// <p>When you specify <code>SingleTrack</code>, Elastic Transcoder creates a single track for your output. The track can have up to eight channels. Use <code>SingleTrack</code> for all non-<code>mxf</code> containers.</p>
    /// <p>The outputs of <code>SingleTrack</code> for a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>0</code> <b> channels with any input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> One track with two identical channels</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> One track with two channels</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> One track with two channels</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> One track with two channels</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> One track with multiple channels</p> </li>
    /// </ul>
    /// <p>When you specify <code>OneChannelPerTrack</code>, Elastic Transcoder creates a new track for every channel in your output. Your output can have up to eight single-channel tracks.</p>
    /// <p>The outputs of <code>OneChannelPerTrack</code> for a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each</p> </li>
    /// </ul>
    /// <p>When you specify <code>OneChannelPerTrackWithMosTo8Tracks</code>, Elastic Transcoder creates eight single-channel tracks for your output. All tracks that do not contain audio data from an input channel are MOS, or Mit Out Sound, tracks.</p>
    /// <p>The outputs of <code>OneChannelPerTrackWithMosTo8Tracks</code> for a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel, plus seven MOS tracks</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each, plus MOS tracks until there are eight tracks in all</p> </li>
    /// </ul>
    pub audio_packing_mode: std::option::Option<std::string::String>,
    /// <p>If you specified <code>AAC</code> for <code>Audio:Codec</code>, this is the <code>AAC</code> compression profile to use. Valid values include:</p>
    /// <p> <code>auto</code>, <code>AAC-LC</code>, <code>HE-AAC</code>, <code>HE-AACv2</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder chooses a profile based on the bit rate of the output file.</p>
    pub codec_options: std::option::Option<crate::model::AudioCodecOptions>,
}
impl AudioParameters {
    /// <p>The audio codec for the output file. Valid values include <code>aac</code>, <code>flac</code>, <code>mp2</code>, <code>mp3</code>, <code>pcm</code>, and <code>vorbis</code>.</p>
    pub fn codec(&self) -> std::option::Option<&str> {
        self.codec.as_deref()
    }
    /// <p>The sample rate of the audio stream in the output file, in Hertz. Valid values include:</p>
    /// <p> <code>auto</code>, <code>22050</code>, <code>32000</code>, <code>44100</code>, <code>48000</code>, <code>96000</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder automatically detects the sample rate.</p>
    pub fn sample_rate(&self) -> std::option::Option<&str> {
        self.sample_rate.as_deref()
    }
    /// <p>The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.</p>
    pub fn bit_rate(&self) -> std::option::Option<&str> {
        self.bit_rate.as_deref()
    }
    /// <p>The number of audio channels in the output file. The following values are valid:</p>
    /// <p> <code>auto</code>, <code>0</code>, <code>1</code>, <code>2</code> </p>
    /// <p>One channel carries the information played by a single speaker. For example, a stereo track with two channels sends one channel to the left speaker, and the other channel to the right speaker. The output channels are organized into tracks. If you want Elastic Transcoder to automatically detect the number of audio channels in the input file and use that value for the output file, select <code>auto</code>.</p>
    /// <p>The output of a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>auto</code> <b> channel specified, with any input:</b> Pass through up to eight input channels.</p> </li>
    /// <li> <p> <code>0</code> <b> channels specified, with any input:</b> Audio omitted from the output.</p> </li>
    /// <li> <p> <code>1</code> <b> channel specified, with at least one input channel:</b> Mono sound.</p> </li>
    /// <li> <p> <code>2</code> <b> channels specified, with any input:</b> Two identical mono channels or stereo. For more information about tracks, see <code>Audio:AudioPackingMode.</code> </p> </li>
    /// </ul>
    /// <p> For more information about how Elastic Transcoder organizes channels and tracks, see <code>Audio:AudioPackingMode</code>.</p>
    pub fn channels(&self) -> std::option::Option<&str> {
        self.channels.as_deref()
    }
    /// <p>The method of organizing audio channels and tracks. Use <code>Audio:Channels</code> to specify the number of channels in your output, and <code>Audio:AudioPackingMode</code> to specify the number of tracks and their relation to the channels. If you do not specify an <code>Audio:AudioPackingMode</code>, Elastic Transcoder uses <code>SingleTrack</code>.</p>
    /// <p>The following values are valid:</p>
    /// <p> <code>SingleTrack</code>, <code>OneChannelPerTrack</code>, and <code>OneChannelPerTrackWithMosTo8Tracks</code> </p>
    /// <p>When you specify <code>SingleTrack</code>, Elastic Transcoder creates a single track for your output. The track can have up to eight channels. Use <code>SingleTrack</code> for all non-<code>mxf</code> containers.</p>
    /// <p>The outputs of <code>SingleTrack</code> for a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>0</code> <b> channels with any input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> One track with two identical channels</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> One track with two channels</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> One track with two channels</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> One track with two channels</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> One track with multiple channels</p> </li>
    /// </ul>
    /// <p>When you specify <code>OneChannelPerTrack</code>, Elastic Transcoder creates a new track for every channel in your output. Your output can have up to eight single-channel tracks.</p>
    /// <p>The outputs of <code>OneChannelPerTrack</code> for a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each</p> </li>
    /// </ul>
    /// <p>When you specify <code>OneChannelPerTrackWithMosTo8Tracks</code>, Elastic Transcoder creates eight single-channel tracks for your output. All tracks that do not contain audio data from an input channel are MOS, or Mit Out Sound, tracks.</p>
    /// <p>The outputs of <code>OneChannelPerTrackWithMosTo8Tracks</code> for a specific channel value and inputs are as follows:</p>
    /// <ul>
    /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
    /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel, plus seven MOS tracks</p> </li>
    /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each, plus MOS tracks until there are eight tracks in all</p> </li>
    /// </ul>
    pub fn audio_packing_mode(&self) -> std::option::Option<&str> {
        self.audio_packing_mode.as_deref()
    }
    /// <p>If you specified <code>AAC</code> for <code>Audio:Codec</code>, this is the <code>AAC</code> compression profile to use. Valid values include:</p>
    /// <p> <code>auto</code>, <code>AAC-LC</code>, <code>HE-AAC</code>, <code>HE-AACv2</code> </p>
    /// <p>If you specify <code>auto</code>, Elastic Transcoder chooses a profile based on the bit rate of the output file.</p>
    pub fn codec_options(&self) -> std::option::Option<&crate::model::AudioCodecOptions> {
        self.codec_options.as_ref()
    }
}
impl std::fmt::Debug for AudioParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioParameters");
        formatter.field("codec", &self.codec);
        formatter.field("sample_rate", &self.sample_rate);
        formatter.field("bit_rate", &self.bit_rate);
        formatter.field("channels", &self.channels);
        formatter.field("audio_packing_mode", &self.audio_packing_mode);
        formatter.field("codec_options", &self.codec_options);
        formatter.finish()
    }
}
/// See [`AudioParameters`](crate::model::AudioParameters)
pub mod audio_parameters {
    /// A builder for [`AudioParameters`](crate::model::AudioParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) codec: std::option::Option<std::string::String>,
        pub(crate) sample_rate: std::option::Option<std::string::String>,
        pub(crate) bit_rate: std::option::Option<std::string::String>,
        pub(crate) channels: std::option::Option<std::string::String>,
        pub(crate) audio_packing_mode: std::option::Option<std::string::String>,
        pub(crate) codec_options: std::option::Option<crate::model::AudioCodecOptions>,
    }
    impl Builder {
        /// <p>The audio codec for the output file. Valid values include <code>aac</code>, <code>flac</code>, <code>mp2</code>, <code>mp3</code>, <code>pcm</code>, and <code>vorbis</code>.</p>
        pub fn codec(mut self, input: impl Into<std::string::String>) -> Self {
            self.codec = Some(input.into());
            self
        }
        /// <p>The audio codec for the output file. Valid values include <code>aac</code>, <code>flac</code>, <code>mp2</code>, <code>mp3</code>, <code>pcm</code>, and <code>vorbis</code>.</p>
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.codec = input;
            self
        }
        /// <p>The sample rate of the audio stream in the output file, in Hertz. Valid values include:</p>
        /// <p> <code>auto</code>, <code>22050</code>, <code>32000</code>, <code>44100</code>, <code>48000</code>, <code>96000</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder automatically detects the sample rate.</p>
        pub fn sample_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.sample_rate = Some(input.into());
            self
        }
        /// <p>The sample rate of the audio stream in the output file, in Hertz. Valid values include:</p>
        /// <p> <code>auto</code>, <code>22050</code>, <code>32000</code>, <code>44100</code>, <code>48000</code>, <code>96000</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder automatically detects the sample rate.</p>
        pub fn set_sample_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sample_rate = input;
            self
        }
        /// <p>The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.</p>
        pub fn bit_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.bit_rate = Some(input.into());
            self
        }
        /// <p>The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.</p>
        pub fn set_bit_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bit_rate = input;
            self
        }
        /// <p>The number of audio channels in the output file. The following values are valid:</p>
        /// <p> <code>auto</code>, <code>0</code>, <code>1</code>, <code>2</code> </p>
        /// <p>One channel carries the information played by a single speaker. For example, a stereo track with two channels sends one channel to the left speaker, and the other channel to the right speaker. The output channels are organized into tracks. If you want Elastic Transcoder to automatically detect the number of audio channels in the input file and use that value for the output file, select <code>auto</code>.</p>
        /// <p>The output of a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>auto</code> <b> channel specified, with any input:</b> Pass through up to eight input channels.</p> </li>
        /// <li> <p> <code>0</code> <b> channels specified, with any input:</b> Audio omitted from the output.</p> </li>
        /// <li> <p> <code>1</code> <b> channel specified, with at least one input channel:</b> Mono sound.</p> </li>
        /// <li> <p> <code>2</code> <b> channels specified, with any input:</b> Two identical mono channels or stereo. For more information about tracks, see <code>Audio:AudioPackingMode.</code> </p> </li>
        /// </ul>
        /// <p> For more information about how Elastic Transcoder organizes channels and tracks, see <code>Audio:AudioPackingMode</code>.</p>
        pub fn channels(mut self, input: impl Into<std::string::String>) -> Self {
            self.channels = Some(input.into());
            self
        }
        /// <p>The number of audio channels in the output file. The following values are valid:</p>
        /// <p> <code>auto</code>, <code>0</code>, <code>1</code>, <code>2</code> </p>
        /// <p>One channel carries the information played by a single speaker. For example, a stereo track with two channels sends one channel to the left speaker, and the other channel to the right speaker. The output channels are organized into tracks. If you want Elastic Transcoder to automatically detect the number of audio channels in the input file and use that value for the output file, select <code>auto</code>.</p>
        /// <p>The output of a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>auto</code> <b> channel specified, with any input:</b> Pass through up to eight input channels.</p> </li>
        /// <li> <p> <code>0</code> <b> channels specified, with any input:</b> Audio omitted from the output.</p> </li>
        /// <li> <p> <code>1</code> <b> channel specified, with at least one input channel:</b> Mono sound.</p> </li>
        /// <li> <p> <code>2</code> <b> channels specified, with any input:</b> Two identical mono channels or stereo. For more information about tracks, see <code>Audio:AudioPackingMode.</code> </p> </li>
        /// </ul>
        /// <p> For more information about how Elastic Transcoder organizes channels and tracks, see <code>Audio:AudioPackingMode</code>.</p>
        pub fn set_channels(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channels = input;
            self
        }
        /// <p>The method of organizing audio channels and tracks. Use <code>Audio:Channels</code> to specify the number of channels in your output, and <code>Audio:AudioPackingMode</code> to specify the number of tracks and their relation to the channels. If you do not specify an <code>Audio:AudioPackingMode</code>, Elastic Transcoder uses <code>SingleTrack</code>.</p>
        /// <p>The following values are valid:</p>
        /// <p> <code>SingleTrack</code>, <code>OneChannelPerTrack</code>, and <code>OneChannelPerTrackWithMosTo8Tracks</code> </p>
        /// <p>When you specify <code>SingleTrack</code>, Elastic Transcoder creates a single track for your output. The track can have up to eight channels. Use <code>SingleTrack</code> for all non-<code>mxf</code> containers.</p>
        /// <p>The outputs of <code>SingleTrack</code> for a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>0</code> <b> channels with any input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> One track with two identical channels</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> One track with two channels</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> One track with two channels</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> One track with two channels</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> One track with multiple channels</p> </li>
        /// </ul>
        /// <p>When you specify <code>OneChannelPerTrack</code>, Elastic Transcoder creates a new track for every channel in your output. Your output can have up to eight single-channel tracks.</p>
        /// <p>The outputs of <code>OneChannelPerTrack</code> for a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each</p> </li>
        /// </ul>
        /// <p>When you specify <code>OneChannelPerTrackWithMosTo8Tracks</code>, Elastic Transcoder creates eight single-channel tracks for your output. All tracks that do not contain audio data from an input channel are MOS, or Mit Out Sound, tracks.</p>
        /// <p>The outputs of <code>OneChannelPerTrackWithMosTo8Tracks</code> for a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel, plus seven MOS tracks</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each, plus MOS tracks until there are eight tracks in all</p> </li>
        /// </ul>
        pub fn audio_packing_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_packing_mode = Some(input.into());
            self
        }
        /// <p>The method of organizing audio channels and tracks. Use <code>Audio:Channels</code> to specify the number of channels in your output, and <code>Audio:AudioPackingMode</code> to specify the number of tracks and their relation to the channels. If you do not specify an <code>Audio:AudioPackingMode</code>, Elastic Transcoder uses <code>SingleTrack</code>.</p>
        /// <p>The following values are valid:</p>
        /// <p> <code>SingleTrack</code>, <code>OneChannelPerTrack</code>, and <code>OneChannelPerTrackWithMosTo8Tracks</code> </p>
        /// <p>When you specify <code>SingleTrack</code>, Elastic Transcoder creates a single track for your output. The track can have up to eight channels. Use <code>SingleTrack</code> for all non-<code>mxf</code> containers.</p>
        /// <p>The outputs of <code>SingleTrack</code> for a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>0</code> <b> channels with any input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> One track with two identical channels</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> One track with two channels</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> One track with two channels</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> One track with two channels</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> One track with multiple channels</p> </li>
        /// </ul>
        /// <p>When you specify <code>OneChannelPerTrack</code>, Elastic Transcoder creates a new track for every channel in your output. Your output can have up to eight single-channel tracks.</p>
        /// <p>The outputs of <code>OneChannelPerTrack</code> for a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each</p> </li>
        /// </ul>
        /// <p>When you specify <code>OneChannelPerTrackWithMosTo8Tracks</code>, Elastic Transcoder creates eight single-channel tracks for your output. All tracks that do not contain audio data from an input channel are MOS, or Mit Out Sound, tracks.</p>
        /// <p>The outputs of <code>OneChannelPerTrackWithMosTo8Tracks</code> for a specific channel value and inputs are as follows:</p>
        /// <ul>
        /// <li> <p> <code>0 </code> <b>channels with any input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1, 2, or auto </code> <b>channels with no audio input:</b> Audio omitted from the output</p> </li>
        /// <li> <p> <code>1 </code> <b>channel with any input with audio:</b> One track with one channel, downmixed if necessary, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with one channel:</b> Two tracks with one identical channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with two tracks with one channel each:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 or auto </code> <b>channels with one track with two channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>2 </code> <b>channels with one track with multiple channels:</b> Two tracks with one channel each, plus six MOS tracks</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with one channel:</b> One track with one channel, plus seven MOS tracks</p> </li>
        /// <li> <p> <code>auto </code> <b>channels with one track with multiple channels:</b> Up to eight tracks with one channel each, plus MOS tracks until there are eight tracks in all</p> </li>
        /// </ul>
        pub fn set_audio_packing_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_packing_mode = input;
            self
        }
        /// <p>If you specified <code>AAC</code> for <code>Audio:Codec</code>, this is the <code>AAC</code> compression profile to use. Valid values include:</p>
        /// <p> <code>auto</code>, <code>AAC-LC</code>, <code>HE-AAC</code>, <code>HE-AACv2</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder chooses a profile based on the bit rate of the output file.</p>
        pub fn codec_options(mut self, input: crate::model::AudioCodecOptions) -> Self {
            self.codec_options = Some(input);
            self
        }
        /// <p>If you specified <code>AAC</code> for <code>Audio:Codec</code>, this is the <code>AAC</code> compression profile to use. Valid values include:</p>
        /// <p> <code>auto</code>, <code>AAC-LC</code>, <code>HE-AAC</code>, <code>HE-AACv2</code> </p>
        /// <p>If you specify <code>auto</code>, Elastic Transcoder chooses a profile based on the bit rate of the output file.</p>
        pub fn set_codec_options(
            mut self,
            input: std::option::Option<crate::model::AudioCodecOptions>,
        ) -> Self {
            self.codec_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioParameters`](crate::model::AudioParameters)
        pub fn build(self) -> crate::model::AudioParameters {
            crate::model::AudioParameters {
                codec: self.codec,
                sample_rate: self.sample_rate,
                bit_rate: self.bit_rate,
                channels: self.channels,
                audio_packing_mode: self.audio_packing_mode,
                codec_options: self.codec_options,
            }
        }
    }
}
impl AudioParameters {
    /// Creates a new builder-style object to manufacture [`AudioParameters`](crate::model::AudioParameters)
    pub fn builder() -> crate::model::audio_parameters::Builder {
        crate::model::audio_parameters::Builder::default()
    }
}

/// <p>Options associated with your audio codec.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioCodecOptions {
    /// <p>You can only choose an audio profile when you specify AAC for the value of Audio:Codec.</p>
    /// <p>Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:</p>
    /// <ul>
    /// <li> <p> <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on the bit rate selected for the output file.</p> </li>
    /// <li> <p> <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.</p> </li>
    /// <li> <p> <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and 80 kbps.</p> </li>
    /// <li> <p> <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.</p> </li>
    /// </ul>
    /// <p>All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.</p> <note>
    /// <p>If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your presets to use AAC-LC. You can change the value as required.</p>
    /// </note>
    pub profile: std::option::Option<std::string::String>,
    /// <p>You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the value of Audio:Codec.</p>
    /// <p>The bit depth of a sample is how many bits of information are included in the audio samples. The higher the bit depth, the better the audio, but the larger the file.</p>
    /// <p>Valid values are <code>16</code> and <code>24</code>.</p>
    /// <p>The most common bit depth is <code>24</code>.</p>
    pub bit_depth: std::option::Option<std::string::String>,
    /// <p>You can only choose an audio bit order when you specify <code>pcm</code> for the value of Audio:Codec.</p>
    /// <p>The order the bits of a PCM sample are stored in.</p>
    /// <p>The supported value is <code>LittleEndian</code>.</p>
    pub bit_order: std::option::Option<std::string::String>,
    /// <p>You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value of Audio:Codec.</p>
    /// <p>Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned).</p>
    /// <p>The supported value is <code>Signed</code>.</p>
    pub signed: std::option::Option<std::string::String>,
}
impl AudioCodecOptions {
    /// <p>You can only choose an audio profile when you specify AAC for the value of Audio:Codec.</p>
    /// <p>Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:</p>
    /// <ul>
    /// <li> <p> <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on the bit rate selected for the output file.</p> </li>
    /// <li> <p> <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.</p> </li>
    /// <li> <p> <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and 80 kbps.</p> </li>
    /// <li> <p> <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.</p> </li>
    /// </ul>
    /// <p>All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.</p> <note>
    /// <p>If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your presets to use AAC-LC. You can change the value as required.</p>
    /// </note>
    pub fn profile(&self) -> std::option::Option<&str> {
        self.profile.as_deref()
    }
    /// <p>You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the value of Audio:Codec.</p>
    /// <p>The bit depth of a sample is how many bits of information are included in the audio samples. The higher the bit depth, the better the audio, but the larger the file.</p>
    /// <p>Valid values are <code>16</code> and <code>24</code>.</p>
    /// <p>The most common bit depth is <code>24</code>.</p>
    pub fn bit_depth(&self) -> std::option::Option<&str> {
        self.bit_depth.as_deref()
    }
    /// <p>You can only choose an audio bit order when you specify <code>pcm</code> for the value of Audio:Codec.</p>
    /// <p>The order the bits of a PCM sample are stored in.</p>
    /// <p>The supported value is <code>LittleEndian</code>.</p>
    pub fn bit_order(&self) -> std::option::Option<&str> {
        self.bit_order.as_deref()
    }
    /// <p>You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value of Audio:Codec.</p>
    /// <p>Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned).</p>
    /// <p>The supported value is <code>Signed</code>.</p>
    pub fn signed(&self) -> std::option::Option<&str> {
        self.signed.as_deref()
    }
}
impl std::fmt::Debug for AudioCodecOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioCodecOptions");
        formatter.field("profile", &self.profile);
        formatter.field("bit_depth", &self.bit_depth);
        formatter.field("bit_order", &self.bit_order);
        formatter.field("signed", &self.signed);
        formatter.finish()
    }
}
/// See [`AudioCodecOptions`](crate::model::AudioCodecOptions)
pub mod audio_codec_options {
    /// A builder for [`AudioCodecOptions`](crate::model::AudioCodecOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile: std::option::Option<std::string::String>,
        pub(crate) bit_depth: std::option::Option<std::string::String>,
        pub(crate) bit_order: std::option::Option<std::string::String>,
        pub(crate) signed: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>You can only choose an audio profile when you specify AAC for the value of Audio:Codec.</p>
        /// <p>Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:</p>
        /// <ul>
        /// <li> <p> <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on the bit rate selected for the output file.</p> </li>
        /// <li> <p> <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.</p> </li>
        /// <li> <p> <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and 80 kbps.</p> </li>
        /// <li> <p> <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.</p> </li>
        /// </ul>
        /// <p>All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.</p> <note>
        /// <p>If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your presets to use AAC-LC. You can change the value as required.</p>
        /// </note>
        pub fn profile(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile = Some(input.into());
            self
        }
        /// <p>You can only choose an audio profile when you specify AAC for the value of Audio:Codec.</p>
        /// <p>Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:</p>
        /// <ul>
        /// <li> <p> <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on the bit rate selected for the output file.</p> </li>
        /// <li> <p> <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.</p> </li>
        /// <li> <p> <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and 80 kbps.</p> </li>
        /// <li> <p> <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.</p> </li>
        /// </ul>
        /// <p>All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.</p> <note>
        /// <p>If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your presets to use AAC-LC. You can change the value as required.</p>
        /// </note>
        pub fn set_profile(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile = input;
            self
        }
        /// <p>You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the value of Audio:Codec.</p>
        /// <p>The bit depth of a sample is how many bits of information are included in the audio samples. The higher the bit depth, the better the audio, but the larger the file.</p>
        /// <p>Valid values are <code>16</code> and <code>24</code>.</p>
        /// <p>The most common bit depth is <code>24</code>.</p>
        pub fn bit_depth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bit_depth = Some(input.into());
            self
        }
        /// <p>You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the value of Audio:Codec.</p>
        /// <p>The bit depth of a sample is how many bits of information are included in the audio samples. The higher the bit depth, the better the audio, but the larger the file.</p>
        /// <p>Valid values are <code>16</code> and <code>24</code>.</p>
        /// <p>The most common bit depth is <code>24</code>.</p>
        pub fn set_bit_depth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bit_depth = input;
            self
        }
        /// <p>You can only choose an audio bit order when you specify <code>pcm</code> for the value of Audio:Codec.</p>
        /// <p>The order the bits of a PCM sample are stored in.</p>
        /// <p>The supported value is <code>LittleEndian</code>.</p>
        pub fn bit_order(mut self, input: impl Into<std::string::String>) -> Self {
            self.bit_order = Some(input.into());
            self
        }
        /// <p>You can only choose an audio bit order when you specify <code>pcm</code> for the value of Audio:Codec.</p>
        /// <p>The order the bits of a PCM sample are stored in.</p>
        /// <p>The supported value is <code>LittleEndian</code>.</p>
        pub fn set_bit_order(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bit_order = input;
            self
        }
        /// <p>You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value of Audio:Codec.</p>
        /// <p>Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned).</p>
        /// <p>The supported value is <code>Signed</code>.</p>
        pub fn signed(mut self, input: impl Into<std::string::String>) -> Self {
            self.signed = Some(input.into());
            self
        }
        /// <p>You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value of Audio:Codec.</p>
        /// <p>Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned).</p>
        /// <p>The supported value is <code>Signed</code>.</p>
        pub fn set_signed(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signed = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioCodecOptions`](crate::model::AudioCodecOptions)
        pub fn build(self) -> crate::model::AudioCodecOptions {
            crate::model::AudioCodecOptions {
                profile: self.profile,
                bit_depth: self.bit_depth,
                bit_order: self.bit_order,
                signed: self.signed,
            }
        }
    }
}
impl AudioCodecOptions {
    /// Creates a new builder-style object to manufacture [`AudioCodecOptions`](crate::model::AudioCodecOptions)
    pub fn builder() -> crate::model::audio_codec_options::Builder {
        crate::model::audio_codec_options::Builder::default()
    }
}

/// <p>A section of the response body that provides information about the job that is created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or to delete the job.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files. </p>
    pub pipeline_id: std::option::Option<std::string::String>,
    /// <p>A section of the request or response body that provides information about the file that is being transcoded.</p>
    pub input: std::option::Option<crate::model::JobInput>,
    /// <p>Information about the files that you're transcoding. If you specified multiple files for this job, Elastic Transcoder stitches the files together to make one output.</p>
    pub inputs: std::option::Option<std::vec::Vec<crate::model::JobInput>>,
    /// <p>If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the Output object lists information about the first output. This duplicates the information that is listed for the first output in the Outputs object.</p> <important>
    /// <p>Outputs recommended instead.</p>
    /// </important>
    /// <p>A section of the request or response body that provides information about the transcoded (target) file. </p>
    pub output: std::option::Option<crate::model::JobOutput>,
    /// <p>Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30 outputs per job. </p>
    /// <p>If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the order in which you specify them in the job.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::JobOutput>>,
    /// <p>The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other delimiter to the end of the <code>OutputKeyPrefix</code>.</p>
    pub output_key_prefix: std::option::Option<std::string::String>,
    /// <important>
    /// <p>Outputs in Fragmented MP4 or MPEG-TS format only.</p>
    /// </important>
    /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4 (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that you want Elastic Transcoder to create.</p>
    /// <p>The maximum number of master playlists in a job is 30.</p>
    pub playlists: std::option::Option<std::vec::Vec<crate::model::Playlist>>,
    /// <p> The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
    pub status: std::option::Option<std::string::String>,
    /// <p>User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.</p>
    /// <p>Metadata <code>keys</code> and <code>values</code> must use characters from the following list:</p>
    /// <ul>
    /// <li> <p> <code>0-9</code> </p> </li>
    /// <li> <p> <code>A-Z</code> and <code>a-z</code> </p> </li>
    /// <li> <p> <code>Space</code> </p> </li>
    /// <li> <p>The following symbols: <code>_.:/=+-%@</code> </p> </li>
    /// </ul>
    pub user_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Details about the timing of a job.</p>
    pub timing: std::option::Option<crate::model::Timing>,
}
impl Job {
    /// <p>The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or to delete the job.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files. </p>
    pub fn pipeline_id(&self) -> std::option::Option<&str> {
        self.pipeline_id.as_deref()
    }
    /// <p>A section of the request or response body that provides information about the file that is being transcoded.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::JobInput> {
        self.input.as_ref()
    }
    /// <p>Information about the files that you're transcoding. If you specified multiple files for this job, Elastic Transcoder stitches the files together to make one output.</p>
    pub fn inputs(&self) -> std::option::Option<&[crate::model::JobInput]> {
        self.inputs.as_deref()
    }
    /// <p>If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the Output object lists information about the first output. This duplicates the information that is listed for the first output in the Outputs object.</p> <important>
    /// <p>Outputs recommended instead.</p>
    /// </important>
    /// <p>A section of the request or response body that provides information about the transcoded (target) file. </p>
    pub fn output(&self) -> std::option::Option<&crate::model::JobOutput> {
        self.output.as_ref()
    }
    /// <p>Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30 outputs per job. </p>
    /// <p>If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the order in which you specify them in the job.</p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::JobOutput]> {
        self.outputs.as_deref()
    }
    /// <p>The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other delimiter to the end of the <code>OutputKeyPrefix</code>.</p>
    pub fn output_key_prefix(&self) -> std::option::Option<&str> {
        self.output_key_prefix.as_deref()
    }
    /// <important>
    /// <p>Outputs in Fragmented MP4 or MPEG-TS format only.</p>
    /// </important>
    /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4 (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that you want Elastic Transcoder to create.</p>
    /// <p>The maximum number of master playlists in a job is 30.</p>
    pub fn playlists(&self) -> std::option::Option<&[crate::model::Playlist]> {
        self.playlists.as_deref()
    }
    /// <p> The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.</p>
    /// <p>Metadata <code>keys</code> and <code>values</code> must use characters from the following list:</p>
    /// <ul>
    /// <li> <p> <code>0-9</code> </p> </li>
    /// <li> <p> <code>A-Z</code> and <code>a-z</code> </p> </li>
    /// <li> <p> <code>Space</code> </p> </li>
    /// <li> <p>The following symbols: <code>_.:/=+-%@</code> </p> </li>
    /// </ul>
    pub fn user_metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.user_metadata.as_ref()
    }
    /// <p>Details about the timing of a job.</p>
    pub fn timing(&self) -> std::option::Option<&crate::model::Timing> {
        self.timing.as_ref()
    }
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("pipeline_id", &self.pipeline_id);
        formatter.field("input", &self.input);
        formatter.field("inputs", &self.inputs);
        formatter.field("output", &self.output);
        formatter.field("outputs", &self.outputs);
        formatter.field("output_key_prefix", &self.output_key_prefix);
        formatter.field("playlists", &self.playlists);
        formatter.field("status", &self.status);
        formatter.field("user_metadata", &self.user_metadata);
        formatter.field("timing", &self.timing);
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_id: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<crate::model::JobInput>,
        pub(crate) inputs: std::option::Option<std::vec::Vec<crate::model::JobInput>>,
        pub(crate) output: std::option::Option<crate::model::JobOutput>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::JobOutput>>,
        pub(crate) output_key_prefix: std::option::Option<std::string::String>,
        pub(crate) playlists: std::option::Option<std::vec::Vec<crate::model::Playlist>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) user_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) timing: std::option::Option<crate::model::Timing>,
    }
    impl Builder {
        /// <p>The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or to delete the job.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or to delete the job.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files. </p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_id = Some(input.into());
            self
        }
        /// <p> The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files. </p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_id = input;
            self
        }
        /// <p>A section of the request or response body that provides information about the file that is being transcoded.</p>
        pub fn input(mut self, input: crate::model::JobInput) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>A section of the request or response body that provides information about the file that is being transcoded.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::JobInput>) -> Self {
            self.input = input;
            self
        }
        /// Appends an item to `inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// <p>Information about the files that you're transcoding. If you specified multiple files for this job, Elastic Transcoder stitches the files together to make one output.</p>
        pub fn inputs(mut self, input: crate::model::JobInput) -> Self {
            let mut v = self.inputs.unwrap_or_default();
            v.push(input);
            self.inputs = Some(v);
            self
        }
        /// <p>Information about the files that you're transcoding. If you specified multiple files for this job, Elastic Transcoder stitches the files together to make one output.</p>
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobInput>>,
        ) -> Self {
            self.inputs = input;
            self
        }
        /// <p>If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the Output object lists information about the first output. This duplicates the information that is listed for the first output in the Outputs object.</p> <important>
        /// <p>Outputs recommended instead.</p>
        /// </important>
        /// <p>A section of the request or response body that provides information about the transcoded (target) file. </p>
        pub fn output(mut self, input: crate::model::JobOutput) -> Self {
            self.output = Some(input);
            self
        }
        /// <p>If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the Output object lists information about the first output. This duplicates the information that is listed for the first output in the Outputs object.</p> <important>
        /// <p>Outputs recommended instead.</p>
        /// </important>
        /// <p>A section of the request or response body that provides information about the transcoded (target) file. </p>
        pub fn set_output(mut self, input: std::option::Option<crate::model::JobOutput>) -> Self {
            self.output = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30 outputs per job. </p>
        /// <p>If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the order in which you specify them in the job.</p>
        pub fn outputs(mut self, input: crate::model::JobOutput) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input);
            self.outputs = Some(v);
            self
        }
        /// <p>Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30 outputs per job. </p>
        /// <p>If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the order in which you specify them in the job.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobOutput>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// <p>The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other delimiter to the end of the <code>OutputKeyPrefix</code>.</p>
        pub fn output_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_key_prefix = Some(input.into());
            self
        }
        /// <p>The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other delimiter to the end of the <code>OutputKeyPrefix</code>.</p>
        pub fn set_output_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_key_prefix = input;
            self
        }
        /// Appends an item to `playlists`.
        ///
        /// To override the contents of this collection use [`set_playlists`](Self::set_playlists).
        ///
        /// <important>
        /// <p>Outputs in Fragmented MP4 or MPEG-TS format only.</p>
        /// </important>
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4 (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that you want Elastic Transcoder to create.</p>
        /// <p>The maximum number of master playlists in a job is 30.</p>
        pub fn playlists(mut self, input: crate::model::Playlist) -> Self {
            let mut v = self.playlists.unwrap_or_default();
            v.push(input);
            self.playlists = Some(v);
            self
        }
        /// <important>
        /// <p>Outputs in Fragmented MP4 or MPEG-TS format only.</p>
        /// </important>
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4 (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that you want Elastic Transcoder to create.</p>
        /// <p>The maximum number of master playlists in a job is 30.</p>
        pub fn set_playlists(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Playlist>>,
        ) -> Self {
            self.playlists = input;
            self
        }
        /// <p> The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p> The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `user_metadata`.
        ///
        /// To override the contents of this collection use [`set_user_metadata`](Self::set_user_metadata).
        ///
        /// <p>User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.</p>
        /// <p>Metadata <code>keys</code> and <code>values</code> must use characters from the following list:</p>
        /// <ul>
        /// <li> <p> <code>0-9</code> </p> </li>
        /// <li> <p> <code>A-Z</code> and <code>a-z</code> </p> </li>
        /// <li> <p> <code>Space</code> </p> </li>
        /// <li> <p>The following symbols: <code>_.:/=+-%@</code> </p> </li>
        /// </ul>
        pub fn user_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_metadata = Some(hash_map);
            self
        }
        /// <p>User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.</p>
        /// <p>Metadata <code>keys</code> and <code>values</code> must use characters from the following list:</p>
        /// <ul>
        /// <li> <p> <code>0-9</code> </p> </li>
        /// <li> <p> <code>A-Z</code> and <code>a-z</code> </p> </li>
        /// <li> <p> <code>Space</code> </p> </li>
        /// <li> <p>The following symbols: <code>_.:/=+-%@</code> </p> </li>
        /// </ul>
        pub fn set_user_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_metadata = input;
            self
        }
        /// <p>Details about the timing of a job.</p>
        pub fn timing(mut self, input: crate::model::Timing) -> Self {
            self.timing = Some(input);
            self
        }
        /// <p>Details about the timing of a job.</p>
        pub fn set_timing(mut self, input: std::option::Option<crate::model::Timing>) -> Self {
            self.timing = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                id: self.id,
                arn: self.arn,
                pipeline_id: self.pipeline_id,
                input: self.input,
                inputs: self.inputs,
                output: self.output,
                outputs: self.outputs,
                output_key_prefix: self.output_key_prefix,
                playlists: self.playlists,
                status: self.status,
                user_metadata: self.user_metadata,
                timing: self.timing,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p>Details about the timing of a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Timing {
    /// <p>The time the job was submitted to Elastic Transcoder, in epoch milliseconds.</p>
    pub submit_time_millis: std::option::Option<i64>,
    /// <p>The time the job began transcoding, in epoch milliseconds.</p>
    pub start_time_millis: std::option::Option<i64>,
    /// <p>The time the job finished transcoding, in epoch milliseconds.</p>
    pub finish_time_millis: std::option::Option<i64>,
}
impl Timing {
    /// <p>The time the job was submitted to Elastic Transcoder, in epoch milliseconds.</p>
    pub fn submit_time_millis(&self) -> std::option::Option<i64> {
        self.submit_time_millis
    }
    /// <p>The time the job began transcoding, in epoch milliseconds.</p>
    pub fn start_time_millis(&self) -> std::option::Option<i64> {
        self.start_time_millis
    }
    /// <p>The time the job finished transcoding, in epoch milliseconds.</p>
    pub fn finish_time_millis(&self) -> std::option::Option<i64> {
        self.finish_time_millis
    }
}
impl std::fmt::Debug for Timing {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Timing");
        formatter.field("submit_time_millis", &self.submit_time_millis);
        formatter.field("start_time_millis", &self.start_time_millis);
        formatter.field("finish_time_millis", &self.finish_time_millis);
        formatter.finish()
    }
}
/// See [`Timing`](crate::model::Timing)
pub mod timing {
    /// A builder for [`Timing`](crate::model::Timing)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) submit_time_millis: std::option::Option<i64>,
        pub(crate) start_time_millis: std::option::Option<i64>,
        pub(crate) finish_time_millis: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The time the job was submitted to Elastic Transcoder, in epoch milliseconds.</p>
        pub fn submit_time_millis(mut self, input: i64) -> Self {
            self.submit_time_millis = Some(input);
            self
        }
        /// <p>The time the job was submitted to Elastic Transcoder, in epoch milliseconds.</p>
        pub fn set_submit_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.submit_time_millis = input;
            self
        }
        /// <p>The time the job began transcoding, in epoch milliseconds.</p>
        pub fn start_time_millis(mut self, input: i64) -> Self {
            self.start_time_millis = Some(input);
            self
        }
        /// <p>The time the job began transcoding, in epoch milliseconds.</p>
        pub fn set_start_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.start_time_millis = input;
            self
        }
        /// <p>The time the job finished transcoding, in epoch milliseconds.</p>
        pub fn finish_time_millis(mut self, input: i64) -> Self {
            self.finish_time_millis = Some(input);
            self
        }
        /// <p>The time the job finished transcoding, in epoch milliseconds.</p>
        pub fn set_finish_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.finish_time_millis = input;
            self
        }
        /// Consumes the builder and constructs a [`Timing`](crate::model::Timing)
        pub fn build(self) -> crate::model::Timing {
            crate::model::Timing {
                submit_time_millis: self.submit_time_millis,
                start_time_millis: self.start_time_millis,
                finish_time_millis: self.finish_time_millis,
            }
        }
    }
}
impl Timing {
    /// Creates a new builder-style object to manufacture [`Timing`](crate::model::Timing)
    pub fn builder() -> crate::model::timing::Builder {
        crate::model::timing::Builder::default()
    }
}

/// <p> Use Only for Fragmented MP4 or MPEG-TS Outputs. If you specify a preset for which the value of Container is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), Playlists contains information about the master playlists that you want Elastic Transcoder to create. We recommend that you create only one master playlist per output format. The maximum number of master playlists in a job is 30. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Playlist {
    /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
    /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
    /// </note>
    pub name: std::option::Option<std::string::String>,
    /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>For each output in this job that you want to include in a master playlist, the value of the Outputs:Key object.</p>
    /// <ul>
    /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
    /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
    /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
    /// </ul>
    /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
    /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
    pub output_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub hls_content_protection: std::option::Option<crate::model::HlsContentProtection>,
    /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub play_ready_drm: std::option::Option<crate::model::PlayReadyDrm>,
    /// <p>The status of the job with which the playlist is associated.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Information that further explains the status.</p>
    pub status_detail: std::option::Option<std::string::String>,
}
impl Playlist {
    /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
    /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
    /// </note>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>For each output in this job that you want to include in a master playlist, the value of the Outputs:Key object.</p>
    /// <ul>
    /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
    /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
    /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
    /// </ul>
    /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
    /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
    pub fn output_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.output_keys.as_deref()
    }
    /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub fn hls_content_protection(
        &self,
    ) -> std::option::Option<&crate::model::HlsContentProtection> {
        self.hls_content_protection.as_ref()
    }
    /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub fn play_ready_drm(&self) -> std::option::Option<&crate::model::PlayReadyDrm> {
        self.play_ready_drm.as_ref()
    }
    /// <p>The status of the job with which the playlist is associated.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Information that further explains the status.</p>
    pub fn status_detail(&self) -> std::option::Option<&str> {
        self.status_detail.as_deref()
    }
}
impl std::fmt::Debug for Playlist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Playlist");
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("output_keys", &self.output_keys);
        formatter.field("hls_content_protection", &self.hls_content_protection);
        formatter.field("play_ready_drm", &self.play_ready_drm);
        formatter.field("status", &self.status);
        formatter.field("status_detail", &self.status_detail);
        formatter.finish()
    }
}
/// See [`Playlist`](crate::model::Playlist)
pub mod playlist {
    /// A builder for [`Playlist`](crate::model::Playlist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) output_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hls_content_protection: std::option::Option<crate::model::HlsContentProtection>,
        pub(crate) play_ready_drm: std::option::Option<crate::model::PlayReadyDrm>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) status_detail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
        /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
        /// </note>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
        /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// Appends an item to `output_keys`.
        ///
        /// To override the contents of this collection use [`set_output_keys`](Self::set_output_keys).
        ///
        /// <p>For each output in this job that you want to include in a master playlist, the value of the Outputs:Key object.</p>
        /// <ul>
        /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
        /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
        /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
        /// </ul>
        /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
        /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
        pub fn output_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.output_keys.unwrap_or_default();
            v.push(input.into());
            self.output_keys = Some(v);
            self
        }
        /// <p>For each output in this job that you want to include in a master playlist, the value of the Outputs:Key object.</p>
        /// <ul>
        /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
        /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
        /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
        /// </ul>
        /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
        /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
        pub fn set_output_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.output_keys = input;
            self
        }
        /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn hls_content_protection(mut self, input: crate::model::HlsContentProtection) -> Self {
            self.hls_content_protection = Some(input);
            self
        }
        /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn set_hls_content_protection(
            mut self,
            input: std::option::Option<crate::model::HlsContentProtection>,
        ) -> Self {
            self.hls_content_protection = input;
            self
        }
        /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn play_ready_drm(mut self, input: crate::model::PlayReadyDrm) -> Self {
            self.play_ready_drm = Some(input);
            self
        }
        /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn set_play_ready_drm(
            mut self,
            input: std::option::Option<crate::model::PlayReadyDrm>,
        ) -> Self {
            self.play_ready_drm = input;
            self
        }
        /// <p>The status of the job with which the playlist is associated.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the job with which the playlist is associated.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information that further explains the status.</p>
        pub fn status_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_detail = Some(input.into());
            self
        }
        /// <p>Information that further explains the status.</p>
        pub fn set_status_detail(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`Playlist`](crate::model::Playlist)
        pub fn build(self) -> crate::model::Playlist {
            crate::model::Playlist {
                name: self.name,
                format: self.format,
                output_keys: self.output_keys,
                hls_content_protection: self.hls_content_protection,
                play_ready_drm: self.play_ready_drm,
                status: self.status,
                status_detail: self.status_detail,
            }
        }
    }
}
impl Playlist {
    /// Creates a new builder-style object to manufacture [`Playlist`](crate::model::Playlist)
    pub fn builder() -> crate::model::playlist::Builder {
        crate::model::playlist::Builder::default()
    }
}

/// <p>The PlayReady DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
/// <p>PlayReady DRM encrypts your media files using <code>aes-ctr</code> encryption.</p>
/// <p>If you use DRM for an <code>HLSv3</code> playlist, your outputs must have a master playlist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlayReadyDrm {
    /// <p>The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
    /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
    /// <p>The key must also be encrypted by using AWS KMS.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
    pub key_md5: std::option::Option<std::string::String>,
    /// <p>The ID for your DRM key, so that your DRM license provider knows which key to provide.</p>
    /// <p>The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your key ID in big or little endian, check with your DRM provider.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic Transcoder generates one for you.</p>
    pub initialization_vector: std::option::Option<std::string::String>,
    /// <p>The location of the license key required to play DRM content. The URL must be an absolute path, and is referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS playlist outputs. An example URL looks like this: <code>https://www.example.com/exampleKey/</code> </p>
    pub license_acquisition_url: std::option::Option<std::string::String>,
}
impl PlayReadyDrm {
    /// <p>The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
    /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
    /// <p>The key must also be encrypted by using AWS KMS.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
    pub fn key_md5(&self) -> std::option::Option<&str> {
        self.key_md5.as_deref()
    }
    /// <p>The ID for your DRM key, so that your DRM license provider knows which key to provide.</p>
    /// <p>The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your key ID in big or little endian, check with your DRM provider.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic Transcoder generates one for you.</p>
    pub fn initialization_vector(&self) -> std::option::Option<&str> {
        self.initialization_vector.as_deref()
    }
    /// <p>The location of the license key required to play DRM content. The URL must be an absolute path, and is referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS playlist outputs. An example URL looks like this: <code>https://www.example.com/exampleKey/</code> </p>
    pub fn license_acquisition_url(&self) -> std::option::Option<&str> {
        self.license_acquisition_url.as_deref()
    }
}
impl std::fmt::Debug for PlayReadyDrm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlayReadyDrm");
        formatter.field("format", &self.format);
        formatter.field("key", &self.key);
        formatter.field("key_md5", &self.key_md5);
        formatter.field("key_id", &self.key_id);
        formatter.field("initialization_vector", &self.initialization_vector);
        formatter.field("license_acquisition_url", &self.license_acquisition_url);
        formatter.finish()
    }
}
/// See [`PlayReadyDrm`](crate::model::PlayReadyDrm)
pub mod play_ready_drm {
    /// A builder for [`PlayReadyDrm`](crate::model::PlayReadyDrm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) key_md5: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) initialization_vector: std::option::Option<std::string::String>,
        pub(crate) license_acquisition_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
        /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
        /// <p>The key must also be encrypted by using AWS KMS.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
        /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
        /// <p>The key must also be encrypted by using AWS KMS.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
        pub fn key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
        pub fn set_key_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_md5 = input;
            self
        }
        /// <p>The ID for your DRM key, so that your DRM license provider knows which key to provide.</p>
        /// <p>The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your key ID in big or little endian, check with your DRM provider.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The ID for your DRM key, so that your DRM license provider knows which key to provide.</p>
        /// <p>The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your key ID in big or little endian, check with your DRM provider.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic Transcoder generates one for you.</p>
        pub fn initialization_vector(mut self, input: impl Into<std::string::String>) -> Self {
            self.initialization_vector = Some(input.into());
            self
        }
        /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic Transcoder generates one for you.</p>
        pub fn set_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initialization_vector = input;
            self
        }
        /// <p>The location of the license key required to play DRM content. The URL must be an absolute path, and is referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS playlist outputs. An example URL looks like this: <code>https://www.example.com/exampleKey/</code> </p>
        pub fn license_acquisition_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_acquisition_url = Some(input.into());
            self
        }
        /// <p>The location of the license key required to play DRM content. The URL must be an absolute path, and is referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS playlist outputs. An example URL looks like this: <code>https://www.example.com/exampleKey/</code> </p>
        pub fn set_license_acquisition_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_acquisition_url = input;
            self
        }
        /// Consumes the builder and constructs a [`PlayReadyDrm`](crate::model::PlayReadyDrm)
        pub fn build(self) -> crate::model::PlayReadyDrm {
            crate::model::PlayReadyDrm {
                format: self.format,
                key: self.key,
                key_md5: self.key_md5,
                key_id: self.key_id,
                initialization_vector: self.initialization_vector,
                license_acquisition_url: self.license_acquisition_url,
            }
        }
    }
}
impl PlayReadyDrm {
    /// Creates a new builder-style object to manufacture [`PlayReadyDrm`](crate::model::PlayReadyDrm)
    pub fn builder() -> crate::model::play_ready_drm::Builder {
        crate::model::play_ready_drm::Builder::default()
    }
}

/// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to your output files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsContentProtection {
    /// <p>The content protection method for your output. The only valid value is: <code>aes-128</code>.</p>
    /// <p>This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the output playlist.</p>
    pub method: std::option::Option<std::string::String>,
    /// <p>If you want Elastic Transcoder to generate a key for you, leave this field blank.</p>
    /// <p>If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
    /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
    /// <p>The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.</p>
    pub key_md5: std::option::Option<std::string::String>,
    /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
    /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
    pub initialization_vector: std::option::Option<std::string::String>,
    /// <p>The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.</p>
    pub license_acquisition_url: std::option::Option<std::string::String>,
    /// <p>Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you choose <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank and Elastic Transcoder writes your data key into the same bucket as the associated playlist.</p>
    pub key_storage_policy: std::option::Option<std::string::String>,
}
impl HlsContentProtection {
    /// <p>The content protection method for your output. The only valid value is: <code>aes-128</code>.</p>
    /// <p>This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the output playlist.</p>
    pub fn method(&self) -> std::option::Option<&str> {
        self.method.as_deref()
    }
    /// <p>If you want Elastic Transcoder to generate a key for you, leave this field blank.</p>
    /// <p>If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
    /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
    /// <p>The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.</p>
    pub fn key_md5(&self) -> std::option::Option<&str> {
        self.key_md5.as_deref()
    }
    /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
    /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
    pub fn initialization_vector(&self) -> std::option::Option<&str> {
        self.initialization_vector.as_deref()
    }
    /// <p>The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.</p>
    pub fn license_acquisition_url(&self) -> std::option::Option<&str> {
        self.license_acquisition_url.as_deref()
    }
    /// <p>Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you choose <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank and Elastic Transcoder writes your data key into the same bucket as the associated playlist.</p>
    pub fn key_storage_policy(&self) -> std::option::Option<&str> {
        self.key_storage_policy.as_deref()
    }
}
impl std::fmt::Debug for HlsContentProtection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsContentProtection");
        formatter.field("method", &self.method);
        formatter.field("key", &self.key);
        formatter.field("key_md5", &self.key_md5);
        formatter.field("initialization_vector", &self.initialization_vector);
        formatter.field("license_acquisition_url", &self.license_acquisition_url);
        formatter.field("key_storage_policy", &self.key_storage_policy);
        formatter.finish()
    }
}
/// See [`HlsContentProtection`](crate::model::HlsContentProtection)
pub mod hls_content_protection {
    /// A builder for [`HlsContentProtection`](crate::model::HlsContentProtection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) method: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) key_md5: std::option::Option<std::string::String>,
        pub(crate) initialization_vector: std::option::Option<std::string::String>,
        pub(crate) license_acquisition_url: std::option::Option<std::string::String>,
        pub(crate) key_storage_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The content protection method for your output. The only valid value is: <code>aes-128</code>.</p>
        /// <p>This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the output playlist.</p>
        pub fn method(mut self, input: impl Into<std::string::String>) -> Self {
            self.method = Some(input.into());
            self
        }
        /// <p>The content protection method for your output. The only valid value is: <code>aes-128</code>.</p>
        /// <p>This value is written into the method attribute of the <code>EXT-X-KEY</code> metadata tag in the output playlist.</p>
        pub fn set_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.method = input;
            self
        }
        /// <p>If you want Elastic Transcoder to generate a key for you, leave this field blank.</p>
        /// <p>If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
        /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>If you want Elastic Transcoder to generate a key for you, leave this field blank.</p>
        /// <p>If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:</p>
        /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
        /// <p>The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.</p>
        pub fn key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_md5 = Some(input.into());
            self
        }
        /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
        /// <p>The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.</p>
        pub fn set_key_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_md5 = input;
            self
        }
        /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
        /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
        pub fn initialization_vector(mut self, input: impl Into<std::string::String>) -> Self {
            self.initialization_vector = Some(input.into());
            self
        }
        /// <p>If Elastic Transcoder is generating your key for you, you must leave this field blank.</p>
        /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.</p>
        pub fn set_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initialization_vector = input;
            self
        }
        /// <p>The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.</p>
        pub fn license_acquisition_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_acquisition_url = Some(input.into());
            self
        }
        /// <p>The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.</p>
        pub fn set_license_acquisition_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_acquisition_url = input;
            self
        }
        /// <p>Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you choose <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank and Elastic Transcoder writes your data key into the same bucket as the associated playlist.</p>
        pub fn key_storage_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_storage_policy = Some(input.into());
            self
        }
        /// <p>Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you choose <code>WithVariantPlaylists</code>, <code>LicenseAcquisitionUrl</code> must be left blank and Elastic Transcoder writes your data key into the same bucket as the associated playlist.</p>
        pub fn set_key_storage_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_storage_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsContentProtection`](crate::model::HlsContentProtection)
        pub fn build(self) -> crate::model::HlsContentProtection {
            crate::model::HlsContentProtection {
                method: self.method,
                key: self.key,
                key_md5: self.key_md5,
                initialization_vector: self.initialization_vector,
                license_acquisition_url: self.license_acquisition_url,
                key_storage_policy: self.key_storage_policy,
            }
        }
    }
}
impl HlsContentProtection {
    /// Creates a new builder-style object to manufacture [`HlsContentProtection`](crate::model::HlsContentProtection)
    pub fn builder() -> crate::model::hls_content_protection::Builder {
        crate::model::hls_content_protection::Builder::default()
    }
}

/// <important>
/// <p>Outputs recommended instead.</p>
/// </important>
/// <p>If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the <code>Output</code> object lists information about the first output. This duplicates the information that is listed for the first output in the <code>Outputs</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobOutput {
    /// <p>A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In the Output syntax, this value is always 1.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
    /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
    /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
    /// <ul>
    /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
    /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
    /// </important> </li>
    /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
    /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
    /// </ul>
    /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
    pub thumbnail_pattern: std::option::Option<std::string::String>,
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
    pub thumbnail_encryption: std::option::Option<crate::model::Encryption>,
    /// <p>The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values:</p>
    /// <p> <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code> </p>
    /// <p> The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata.</p>
    pub rotate: std::option::Option<std::string::String>,
    /// <p>The value of the <code>Id</code> object for the preset that you want to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a preset that you created, specify the preset ID that Elastic Transcoder returned in the response when you created the preset. You can also use the Elastic Transcoder system presets, which you can get with <code>ListPresets</code>.</p>
    pub preset_id: std::option::Option<std::string::String>,
    /// <important>
    /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
    /// </important>
    /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code>, <code>MPEG-DASH</code>, and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
    /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
    /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
    pub segment_duration: std::option::Option<std::string::String>,
    /// <p> The status of one output in a job. If you specified only one output for the job, <code>Outputs:Status</code> is always the same as <code>Job:Status</code>. If you specified more than one output: </p>
    /// <ul>
    /// <li> <p> <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until Elastic Transcoder starts to process the first output.</p> </li>
    /// <li> <p>When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that output and <code>Job:Status</code> both change to Progressing. For each output, the value of <code>Outputs:Status</code> remains Submitted until Elastic Transcoder starts to process the output.</p> </li>
    /// <li> <p>Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.</p> </li>
    /// <li> <p>When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If <code>Outputs:Status</code> for one or more outputs is <code>Error</code>, the terminal status for <code>Job:Status</code> is also <code>Error</code>.</p> </li>
    /// </ul>
    /// <p>The value of <code>Status</code> is one of the following: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Information that further explains <code>Status</code>.</p>
    pub status_detail: std::option::Option<std::string::String>,
    /// <p>Duration of the output file, in seconds.</p>
    pub duration: std::option::Option<i64>,
    /// <p>Specifies the width of the output file in pixels.</p>
    pub width: std::option::Option<i32>,
    /// <p>Height of the output file, in pixels.</p>
    pub height: std::option::Option<i32>,
    /// <p>Frame rate of the output file, in frames per second.</p>
    pub frame_rate: std::option::Option<std::string::String>,
    /// <p>File size of the output file, in bytes.</p>
    pub file_size: std::option::Option<i64>,
    /// <p>Duration of the output file, in milliseconds.</p>
    pub duration_millis: std::option::Option<i64>,
    /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset that you specify in <code>Preset</code> for the current output.</p>
    /// <p>Watermarks are added to the output video in the sequence in which you list them in the job output—the first watermark in the list is added to the output video first, the second watermark in the list is added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same location, the second watermark that you add covers the first one, the third one covers the second, and the fourth one covers the third.</p>
    pub watermarks: std::option::Option<std::vec::Vec<crate::model::JobWatermark>>,
    /// <p>The album art to be associated with the output file, if any.</p>
    pub album_art: std::option::Option<crate::model::JobAlbumArt>,
    /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
    pub composition: std::option::Option<std::vec::Vec<crate::model::Clip>>,
    /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
    /// <ul>
    /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
    /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
    /// </ul>
    /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
    /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
    /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
    /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
    pub captions: std::option::Option<crate::model::Captions>,
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic Transcoder writes an unencrypted file to your Amazon S3 bucket.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// <p>If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the output file, the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in the job response.</p>
    pub applied_color_space_conversion: std::option::Option<std::string::String>,
}
impl JobOutput {
    /// <p>A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In the Output syntax, this value is always 1.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
    /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
    /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
    /// <ul>
    /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
    /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
    /// </important> </li>
    /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
    /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
    /// </ul>
    /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
    pub fn thumbnail_pattern(&self) -> std::option::Option<&str> {
        self.thumbnail_pattern.as_deref()
    }
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
    pub fn thumbnail_encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.thumbnail_encryption.as_ref()
    }
    /// <p>The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values:</p>
    /// <p> <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code> </p>
    /// <p> The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata.</p>
    pub fn rotate(&self) -> std::option::Option<&str> {
        self.rotate.as_deref()
    }
    /// <p>The value of the <code>Id</code> object for the preset that you want to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a preset that you created, specify the preset ID that Elastic Transcoder returned in the response when you created the preset. You can also use the Elastic Transcoder system presets, which you can get with <code>ListPresets</code>.</p>
    pub fn preset_id(&self) -> std::option::Option<&str> {
        self.preset_id.as_deref()
    }
    /// <important>
    /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
    /// </important>
    /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code>, <code>MPEG-DASH</code>, and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
    /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
    /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
    pub fn segment_duration(&self) -> std::option::Option<&str> {
        self.segment_duration.as_deref()
    }
    /// <p> The status of one output in a job. If you specified only one output for the job, <code>Outputs:Status</code> is always the same as <code>Job:Status</code>. If you specified more than one output: </p>
    /// <ul>
    /// <li> <p> <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until Elastic Transcoder starts to process the first output.</p> </li>
    /// <li> <p>When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that output and <code>Job:Status</code> both change to Progressing. For each output, the value of <code>Outputs:Status</code> remains Submitted until Elastic Transcoder starts to process the output.</p> </li>
    /// <li> <p>Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.</p> </li>
    /// <li> <p>When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If <code>Outputs:Status</code> for one or more outputs is <code>Error</code>, the terminal status for <code>Job:Status</code> is also <code>Error</code>.</p> </li>
    /// </ul>
    /// <p>The value of <code>Status</code> is one of the following: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Information that further explains <code>Status</code>.</p>
    pub fn status_detail(&self) -> std::option::Option<&str> {
        self.status_detail.as_deref()
    }
    /// <p>Duration of the output file, in seconds.</p>
    pub fn duration(&self) -> std::option::Option<i64> {
        self.duration
    }
    /// <p>Specifies the width of the output file in pixels.</p>
    pub fn width(&self) -> std::option::Option<i32> {
        self.width
    }
    /// <p>Height of the output file, in pixels.</p>
    pub fn height(&self) -> std::option::Option<i32> {
        self.height
    }
    /// <p>Frame rate of the output file, in frames per second.</p>
    pub fn frame_rate(&self) -> std::option::Option<&str> {
        self.frame_rate.as_deref()
    }
    /// <p>File size of the output file, in bytes.</p>
    pub fn file_size(&self) -> std::option::Option<i64> {
        self.file_size
    }
    /// <p>Duration of the output file, in milliseconds.</p>
    pub fn duration_millis(&self) -> std::option::Option<i64> {
        self.duration_millis
    }
    /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset that you specify in <code>Preset</code> for the current output.</p>
    /// <p>Watermarks are added to the output video in the sequence in which you list them in the job output—the first watermark in the list is added to the output video first, the second watermark in the list is added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same location, the second watermark that you add covers the first one, the third one covers the second, and the fourth one covers the third.</p>
    pub fn watermarks(&self) -> std::option::Option<&[crate::model::JobWatermark]> {
        self.watermarks.as_deref()
    }
    /// <p>The album art to be associated with the output file, if any.</p>
    pub fn album_art(&self) -> std::option::Option<&crate::model::JobAlbumArt> {
        self.album_art.as_ref()
    }
    /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
    pub fn composition(&self) -> std::option::Option<&[crate::model::Clip]> {
        self.composition.as_deref()
    }
    /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
    /// <ul>
    /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
    /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
    /// </ul>
    /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
    /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
    /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
    /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
    pub fn captions(&self) -> std::option::Option<&crate::model::Captions> {
        self.captions.as_ref()
    }
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic Transcoder writes an unencrypted file to your Amazon S3 bucket.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
    /// <p>If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the output file, the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in the job response.</p>
    pub fn applied_color_space_conversion(&self) -> std::option::Option<&str> {
        self.applied_color_space_conversion.as_deref()
    }
}
impl std::fmt::Debug for JobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobOutput");
        formatter.field("id", &self.id);
        formatter.field("key", &self.key);
        formatter.field("thumbnail_pattern", &self.thumbnail_pattern);
        formatter.field("thumbnail_encryption", &self.thumbnail_encryption);
        formatter.field("rotate", &self.rotate);
        formatter.field("preset_id", &self.preset_id);
        formatter.field("segment_duration", &self.segment_duration);
        formatter.field("status", &self.status);
        formatter.field("status_detail", &self.status_detail);
        formatter.field("duration", &self.duration);
        formatter.field("width", &self.width);
        formatter.field("height", &self.height);
        formatter.field("frame_rate", &self.frame_rate);
        formatter.field("file_size", &self.file_size);
        formatter.field("duration_millis", &self.duration_millis);
        formatter.field("watermarks", &self.watermarks);
        formatter.field("album_art", &self.album_art);
        formatter.field("composition", &self.composition);
        formatter.field("captions", &self.captions);
        formatter.field("encryption", &self.encryption);
        formatter.field(
            "applied_color_space_conversion",
            &self.applied_color_space_conversion,
        );
        formatter.finish()
    }
}
/// See [`JobOutput`](crate::model::JobOutput)
pub mod job_output {
    /// A builder for [`JobOutput`](crate::model::JobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) thumbnail_pattern: std::option::Option<std::string::String>,
        pub(crate) thumbnail_encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) rotate: std::option::Option<std::string::String>,
        pub(crate) preset_id: std::option::Option<std::string::String>,
        pub(crate) segment_duration: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) status_detail: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i64>,
        pub(crate) width: std::option::Option<i32>,
        pub(crate) height: std::option::Option<i32>,
        pub(crate) frame_rate: std::option::Option<std::string::String>,
        pub(crate) file_size: std::option::Option<i64>,
        pub(crate) duration_millis: std::option::Option<i64>,
        pub(crate) watermarks: std::option::Option<std::vec::Vec<crate::model::JobWatermark>>,
        pub(crate) album_art: std::option::Option<crate::model::JobAlbumArt>,
        pub(crate) composition: std::option::Option<std::vec::Vec<crate::model::Clip>>,
        pub(crate) captions: std::option::Option<crate::model::Captions>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) applied_color_space_conversion: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In the Output syntax, this value is always 1.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In the Output syntax, this value is always 1.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
        /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
        /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
        /// <ul>
        /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
        /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
        /// </important> </li>
        /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
        /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
        /// </ul>
        /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
        pub fn thumbnail_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbnail_pattern = Some(input.into());
            self
        }
        /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
        /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
        /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
        /// <ul>
        /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
        /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
        /// </important> </li>
        /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
        /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
        /// </ul>
        /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
        pub fn set_thumbnail_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thumbnail_pattern = input;
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
        pub fn thumbnail_encryption(mut self, input: crate::model::Encryption) -> Self {
            self.thumbnail_encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
        pub fn set_thumbnail_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.thumbnail_encryption = input;
            self
        }
        /// <p>The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values:</p>
        /// <p> <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code> </p>
        /// <p> The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata.</p>
        pub fn rotate(mut self, input: impl Into<std::string::String>) -> Self {
            self.rotate = Some(input.into());
            self
        }
        /// <p>The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values:</p>
        /// <p> <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code> </p>
        /// <p> The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata.</p>
        pub fn set_rotate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rotate = input;
            self
        }
        /// <p>The value of the <code>Id</code> object for the preset that you want to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a preset that you created, specify the preset ID that Elastic Transcoder returned in the response when you created the preset. You can also use the Elastic Transcoder system presets, which you can get with <code>ListPresets</code>.</p>
        pub fn preset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.preset_id = Some(input.into());
            self
        }
        /// <p>The value of the <code>Id</code> object for the preset that you want to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a preset that you created, specify the preset ID that Elastic Transcoder returned in the response when you created the preset. You can also use the Elastic Transcoder system presets, which you can get with <code>ListPresets</code>.</p>
        pub fn set_preset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.preset_id = input;
            self
        }
        /// <important>
        /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
        /// </important>
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code>, <code>MPEG-DASH</code>, and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
        /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
        /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
        pub fn segment_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_duration = Some(input.into());
            self
        }
        /// <important>
        /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
        /// </important>
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code>, <code>MPEG-DASH</code>, and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
        /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
        /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
        pub fn set_segment_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.segment_duration = input;
            self
        }
        /// <p> The status of one output in a job. If you specified only one output for the job, <code>Outputs:Status</code> is always the same as <code>Job:Status</code>. If you specified more than one output: </p>
        /// <ul>
        /// <li> <p> <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until Elastic Transcoder starts to process the first output.</p> </li>
        /// <li> <p>When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that output and <code>Job:Status</code> both change to Progressing. For each output, the value of <code>Outputs:Status</code> remains Submitted until Elastic Transcoder starts to process the output.</p> </li>
        /// <li> <p>Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.</p> </li>
        /// <li> <p>When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If <code>Outputs:Status</code> for one or more outputs is <code>Error</code>, the terminal status for <code>Job:Status</code> is also <code>Error</code>.</p> </li>
        /// </ul>
        /// <p>The value of <code>Status</code> is one of the following: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p> The status of one output in a job. If you specified only one output for the job, <code>Outputs:Status</code> is always the same as <code>Job:Status</code>. If you specified more than one output: </p>
        /// <ul>
        /// <li> <p> <code>Job:Status</code> and <code>Outputs:Status</code> for all of the outputs is Submitted until Elastic Transcoder starts to process the first output.</p> </li>
        /// <li> <p>When Elastic Transcoder starts to process the first output, <code>Outputs:Status</code> for that output and <code>Job:Status</code> both change to Progressing. For each output, the value of <code>Outputs:Status</code> remains Submitted until Elastic Transcoder starts to process the output.</p> </li>
        /// <li> <p>Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.</p> </li>
        /// <li> <p>When all of the outputs reach a terminal status, <code>Job:Status</code> changes to Complete only if <code>Outputs:Status</code> for all of the outputs is <code>Complete</code>. If <code>Outputs:Status</code> for one or more outputs is <code>Error</code>, the terminal status for <code>Job:Status</code> is also <code>Error</code>.</p> </li>
        /// </ul>
        /// <p>The value of <code>Status</code> is one of the following: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>. </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information that further explains <code>Status</code>.</p>
        pub fn status_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_detail = Some(input.into());
            self
        }
        /// <p>Information that further explains <code>Status</code>.</p>
        pub fn set_status_detail(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_detail = input;
            self
        }
        /// <p>Duration of the output file, in seconds.</p>
        pub fn duration(mut self, input: i64) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>Duration of the output file, in seconds.</p>
        pub fn set_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.duration = input;
            self
        }
        /// <p>Specifies the width of the output file in pixels.</p>
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// <p>Specifies the width of the output file in pixels.</p>
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// <p>Height of the output file, in pixels.</p>
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// <p>Height of the output file, in pixels.</p>
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// <p>Frame rate of the output file, in frames per second.</p>
        pub fn frame_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.frame_rate = Some(input.into());
            self
        }
        /// <p>Frame rate of the output file, in frames per second.</p>
        pub fn set_frame_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.frame_rate = input;
            self
        }
        /// <p>File size of the output file, in bytes.</p>
        pub fn file_size(mut self, input: i64) -> Self {
            self.file_size = Some(input);
            self
        }
        /// <p>File size of the output file, in bytes.</p>
        pub fn set_file_size(mut self, input: std::option::Option<i64>) -> Self {
            self.file_size = input;
            self
        }
        /// <p>Duration of the output file, in milliseconds.</p>
        pub fn duration_millis(mut self, input: i64) -> Self {
            self.duration_millis = Some(input);
            self
        }
        /// <p>Duration of the output file, in milliseconds.</p>
        pub fn set_duration_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_millis = input;
            self
        }
        /// Appends an item to `watermarks`.
        ///
        /// To override the contents of this collection use [`set_watermarks`](Self::set_watermarks).
        ///
        /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset that you specify in <code>Preset</code> for the current output.</p>
        /// <p>Watermarks are added to the output video in the sequence in which you list them in the job output—the first watermark in the list is added to the output video first, the second watermark in the list is added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same location, the second watermark that you add covers the first one, the third one covers the second, and the fourth one covers the third.</p>
        pub fn watermarks(mut self, input: crate::model::JobWatermark) -> Self {
            let mut v = self.watermarks.unwrap_or_default();
            v.push(input);
            self.watermarks = Some(v);
            self
        }
        /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset that you specify in <code>Preset</code> for the current output.</p>
        /// <p>Watermarks are added to the output video in the sequence in which you list them in the job output—the first watermark in the list is added to the output video first, the second watermark in the list is added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same location, the second watermark that you add covers the first one, the third one covers the second, and the fourth one covers the third.</p>
        pub fn set_watermarks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobWatermark>>,
        ) -> Self {
            self.watermarks = input;
            self
        }
        /// <p>The album art to be associated with the output file, if any.</p>
        pub fn album_art(mut self, input: crate::model::JobAlbumArt) -> Self {
            self.album_art = Some(input);
            self
        }
        /// <p>The album art to be associated with the output file, if any.</p>
        pub fn set_album_art(
            mut self,
            input: std::option::Option<crate::model::JobAlbumArt>,
        ) -> Self {
            self.album_art = input;
            self
        }
        /// Appends an item to `composition`.
        ///
        /// To override the contents of this collection use [`set_composition`](Self::set_composition).
        ///
        /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
        pub fn composition(mut self, input: crate::model::Clip) -> Self {
            let mut v = self.composition.unwrap_or_default();
            v.push(input);
            self.composition = Some(v);
            self
        }
        /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
        pub fn set_composition(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Clip>>,
        ) -> Self {
            self.composition = input;
            self
        }
        /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
        /// <ul>
        /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
        /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
        /// </ul>
        /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
        /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
        /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
        /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
        pub fn captions(mut self, input: crate::model::Captions) -> Self {
            self.captions = Some(input);
            self
        }
        /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
        /// <ul>
        /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
        /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
        /// </ul>
        /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
        /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
        /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
        /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
        pub fn set_captions(mut self, input: std::option::Option<crate::model::Captions>) -> Self {
            self.captions = input;
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic Transcoder writes an unencrypted file to your Amazon S3 bucket.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic Transcoder writes an unencrypted file to your Amazon S3 bucket.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// <p>If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the output file, the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in the job response.</p>
        pub fn applied_color_space_conversion(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.applied_color_space_conversion = Some(input.into());
            self
        }
        /// <p>If Elastic Transcoder used a preset with a <code>ColorSpaceConversionMode</code> to transcode the output file, the <code>AppliedColorSpaceConversion</code> parameter shows the conversion used. If no <code>ColorSpaceConversionMode</code> was defined in the preset, this parameter is not be included in the job response.</p>
        pub fn set_applied_color_space_conversion(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.applied_color_space_conversion = input;
            self
        }
        /// Consumes the builder and constructs a [`JobOutput`](crate::model::JobOutput)
        pub fn build(self) -> crate::model::JobOutput {
            crate::model::JobOutput {
                id: self.id,
                key: self.key,
                thumbnail_pattern: self.thumbnail_pattern,
                thumbnail_encryption: self.thumbnail_encryption,
                rotate: self.rotate,
                preset_id: self.preset_id,
                segment_duration: self.segment_duration,
                status: self.status,
                status_detail: self.status_detail,
                duration: self.duration,
                width: self.width,
                height: self.height,
                frame_rate: self.frame_rate,
                file_size: self.file_size,
                duration_millis: self.duration_millis,
                watermarks: self.watermarks,
                album_art: self.album_art,
                composition: self.composition,
                captions: self.captions,
                encryption: self.encryption,
                applied_color_space_conversion: self.applied_color_space_conversion,
            }
        }
    }
}
impl JobOutput {
    /// Creates a new builder-style object to manufacture [`JobOutput`](crate::model::JobOutput)
    pub fn builder() -> crate::model::job_output::Builder {
        crate::model::job_output::Builder::default()
    }
}

/// <p>The encryption settings, if any, that are used for decrypting your input files or encrypting your output files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file, otherwise you must specify the mode you want Elastic Transcoder to use to encrypt your output files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Encryption {
    /// <p>The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input files or encrypting your output files. Elastic Transcoder supports the following options:</p>
    /// <ul>
    /// <li> <p> <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.</p> </li>
    /// <li> <p> <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that are used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't want to use the default key, you must add the AWS-KMS key that you want to use to your pipeline.</p> </li>
    /// <li> <p> <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.</p> </li>
    /// <li> <p> <b>aes-ctr:</b> AES Counter Mode.</p> </li>
    /// <li> <p> <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption format, meaning that a file, key, or initialization vector that has been tampered with fails the decryption process.</p> </li>
    /// </ul>
    /// <p>For all three AES options, you must provide the following settings, which must be base64-encoded:</p>
    /// <ul>
    /// <li> <p> <b>Key</b> </p> </li>
    /// <li> <p> <b>Key MD5</b> </p> </li>
    /// <li> <p> <b>Initialization Vector</b> </p> </li>
    /// </ul> <important>
    /// <p>For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt your data.</p>
    /// </important>
    pub mode: std::option::Option<std::string::String>,
    /// <p>The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used to encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths before being base64-encoded:</p>
    /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
    /// <p>The key must also be encrypted by using the Amazon Key Management Service.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
    pub key_md5: std::option::Option<std::string::String>,
    /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
    pub initialization_vector: std::option::Option<std::string::String>,
}
impl Encryption {
    /// <p>The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input files or encrypting your output files. Elastic Transcoder supports the following options:</p>
    /// <ul>
    /// <li> <p> <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.</p> </li>
    /// <li> <p> <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that are used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't want to use the default key, you must add the AWS-KMS key that you want to use to your pipeline.</p> </li>
    /// <li> <p> <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.</p> </li>
    /// <li> <p> <b>aes-ctr:</b> AES Counter Mode.</p> </li>
    /// <li> <p> <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption format, meaning that a file, key, or initialization vector that has been tampered with fails the decryption process.</p> </li>
    /// </ul>
    /// <p>For all three AES options, you must provide the following settings, which must be base64-encoded:</p>
    /// <ul>
    /// <li> <p> <b>Key</b> </p> </li>
    /// <li> <p> <b>Key MD5</b> </p> </li>
    /// <li> <p> <b>Initialization Vector</b> </p> </li>
    /// </ul> <important>
    /// <p>For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt your data.</p>
    /// </important>
    pub fn mode(&self) -> std::option::Option<&str> {
        self.mode.as_deref()
    }
    /// <p>The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used to encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths before being base64-encoded:</p>
    /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
    /// <p>The key must also be encrypted by using the Amazon Key Management Service.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
    pub fn key_md5(&self) -> std::option::Option<&str> {
        self.key_md5.as_deref()
    }
    /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
    pub fn initialization_vector(&self) -> std::option::Option<&str> {
        self.initialization_vector.as_deref()
    }
}
impl std::fmt::Debug for Encryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Encryption");
        formatter.field("mode", &self.mode);
        formatter.field("key", &self.key);
        formatter.field("key_md5", &self.key_md5);
        formatter.field("initialization_vector", &self.initialization_vector);
        formatter.finish()
    }
}
/// See [`Encryption`](crate::model::Encryption)
pub mod encryption {
    /// A builder for [`Encryption`](crate::model::Encryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) key_md5: std::option::Option<std::string::String>,
        pub(crate) initialization_vector: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input files or encrypting your output files. Elastic Transcoder supports the following options:</p>
        /// <ul>
        /// <li> <p> <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.</p> </li>
        /// <li> <p> <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that are used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't want to use the default key, you must add the AWS-KMS key that you want to use to your pipeline.</p> </li>
        /// <li> <p> <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.</p> </li>
        /// <li> <p> <b>aes-ctr:</b> AES Counter Mode.</p> </li>
        /// <li> <p> <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption format, meaning that a file, key, or initialization vector that has been tampered with fails the decryption process.</p> </li>
        /// </ul>
        /// <p>For all three AES options, you must provide the following settings, which must be base64-encoded:</p>
        /// <ul>
        /// <li> <p> <b>Key</b> </p> </li>
        /// <li> <p> <b>Key MD5</b> </p> </li>
        /// <li> <p> <b>Initialization Vector</b> </p> </li>
        /// </ul> <important>
        /// <p>For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt your data.</p>
        /// </important>
        pub fn mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.mode = Some(input.into());
            self
        }
        /// <p>The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input files or encrypting your output files. Elastic Transcoder supports the following options:</p>
        /// <ul>
        /// <li> <p> <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.</p> </li>
        /// <li> <p> <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that are used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't want to use the default key, you must add the AWS-KMS key that you want to use to your pipeline.</p> </li>
        /// <li> <p> <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.</p> </li>
        /// <li> <p> <b>aes-ctr:</b> AES Counter Mode.</p> </li>
        /// <li> <p> <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption format, meaning that a file, key, or initialization vector that has been tampered with fails the decryption process.</p> </li>
        /// </ul>
        /// <p>For all three AES options, you must provide the following settings, which must be base64-encoded:</p>
        /// <ul>
        /// <li> <p> <b>Key</b> </p> </li>
        /// <li> <p> <b>Key MD5</b> </p> </li>
        /// <li> <p> <b>Initialization Vector</b> </p> </li>
        /// </ul> <important>
        /// <p>For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt your data.</p>
        /// </important>
        pub fn set_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used to encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths before being base64-encoded:</p>
        /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
        /// <p>The key must also be encrypted by using the Amazon Key Management Service.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used to encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths before being base64-encoded:</p>
        /// <p> <code>128</code>, <code>192</code>, or <code>256</code>. </p>
        /// <p>The key must also be encrypted by using the Amazon Key Management Service.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
        pub fn key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
        pub fn set_key_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_md5 = input;
            self
        }
        /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
        pub fn initialization_vector(mut self, input: impl Into<std::string::String>) -> Self {
            self.initialization_vector = Some(input.into());
            self
        }
        /// <p>The series of random bits created by a random bit generator, unique for every encryption operation, that you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.</p>
        pub fn set_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initialization_vector = input;
            self
        }
        /// Consumes the builder and constructs a [`Encryption`](crate::model::Encryption)
        pub fn build(self) -> crate::model::Encryption {
            crate::model::Encryption {
                mode: self.mode,
                key: self.key,
                key_md5: self.key_md5,
                initialization_vector: self.initialization_vector,
            }
        }
    }
}
impl Encryption {
    /// Creates a new builder-style object to manufacture [`Encryption`](crate::model::Encryption)
    pub fn builder() -> crate::model::encryption::Builder {
        crate::model::encryption::Builder::default()
    }
}

/// <p>The captions to be created, if any.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Captions {
    /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
    /// <ul>
    /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
    /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
    /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
    /// </ul>
    /// <p> <code>MergePolicy</code> cannot be null.</p>
    pub merge_policy: std::option::Option<std::string::String>,
    /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
    pub caption_sources: std::option::Option<std::vec::Vec<crate::model::CaptionSource>>,
    /// <p>The array of file formats for the output captions. If you leave this value blank, Elastic Transcoder returns an error.</p>
    pub caption_formats: std::option::Option<std::vec::Vec<crate::model::CaptionFormat>>,
}
impl Captions {
    /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
    /// <ul>
    /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
    /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
    /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
    /// </ul>
    /// <p> <code>MergePolicy</code> cannot be null.</p>
    pub fn merge_policy(&self) -> std::option::Option<&str> {
        self.merge_policy.as_deref()
    }
    /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
    pub fn caption_sources(&self) -> std::option::Option<&[crate::model::CaptionSource]> {
        self.caption_sources.as_deref()
    }
    /// <p>The array of file formats for the output captions. If you leave this value blank, Elastic Transcoder returns an error.</p>
    pub fn caption_formats(&self) -> std::option::Option<&[crate::model::CaptionFormat]> {
        self.caption_formats.as_deref()
    }
}
impl std::fmt::Debug for Captions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Captions");
        formatter.field("merge_policy", &self.merge_policy);
        formatter.field("caption_sources", &self.caption_sources);
        formatter.field("caption_formats", &self.caption_formats);
        formatter.finish()
    }
}
/// See [`Captions`](crate::model::Captions)
pub mod captions {
    /// A builder for [`Captions`](crate::model::Captions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) merge_policy: std::option::Option<std::string::String>,
        pub(crate) caption_sources: std::option::Option<std::vec::Vec<crate::model::CaptionSource>>,
        pub(crate) caption_formats: std::option::Option<std::vec::Vec<crate::model::CaptionFormat>>,
    }
    impl Builder {
        /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
        /// <ul>
        /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
        /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
        /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
        /// </ul>
        /// <p> <code>MergePolicy</code> cannot be null.</p>
        pub fn merge_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_policy = Some(input.into());
            self
        }
        /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
        /// <ul>
        /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
        /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
        /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
        /// </ul>
        /// <p> <code>MergePolicy</code> cannot be null.</p>
        pub fn set_merge_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merge_policy = input;
            self
        }
        /// Appends an item to `caption_sources`.
        ///
        /// To override the contents of this collection use [`set_caption_sources`](Self::set_caption_sources).
        ///
        /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
        pub fn caption_sources(mut self, input: crate::model::CaptionSource) -> Self {
            let mut v = self.caption_sources.unwrap_or_default();
            v.push(input);
            self.caption_sources = Some(v);
            self
        }
        /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
        pub fn set_caption_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaptionSource>>,
        ) -> Self {
            self.caption_sources = input;
            self
        }
        /// Appends an item to `caption_formats`.
        ///
        /// To override the contents of this collection use [`set_caption_formats`](Self::set_caption_formats).
        ///
        /// <p>The array of file formats for the output captions. If you leave this value blank, Elastic Transcoder returns an error.</p>
        pub fn caption_formats(mut self, input: crate::model::CaptionFormat) -> Self {
            let mut v = self.caption_formats.unwrap_or_default();
            v.push(input);
            self.caption_formats = Some(v);
            self
        }
        /// <p>The array of file formats for the output captions. If you leave this value blank, Elastic Transcoder returns an error.</p>
        pub fn set_caption_formats(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaptionFormat>>,
        ) -> Self {
            self.caption_formats = input;
            self
        }
        /// Consumes the builder and constructs a [`Captions`](crate::model::Captions)
        pub fn build(self) -> crate::model::Captions {
            crate::model::Captions {
                merge_policy: self.merge_policy,
                caption_sources: self.caption_sources,
                caption_formats: self.caption_formats,
            }
        }
    }
}
impl Captions {
    /// Creates a new builder-style object to manufacture [`Captions`](crate::model::Captions)
    pub fn builder() -> crate::model::captions::Builder {
        crate::model::captions::Builder::default()
    }
}

/// <p>The file format of the output captions. If you leave this value blank, Elastic Transcoder returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaptionFormat {
    /// <p>The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption for this output.</p>
    /// <ul>
    /// <li> <p> <b>Valid Embedded Caption Formats:</b> </p>
    /// <ul>
    /// <li> <p> <b>for FLAC</b>: None</p> </li>
    /// <li> <p> <b>For MP3</b>: None</p> </li>
    /// <li> <p> <b>For MP4</b>: mov-text</p> </li>
    /// <li> <p> <b>For MPEG-TS</b>: None</p> </li>
    /// <li> <p> <b>For ogg</b>: None</p> </li>
    /// <li> <p> <b>For webm</b>: None</p> </li>
    /// </ul> </li>
    /// <li> <p> <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc, srt, and webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <ul>
    /// <li> <p> <b>For FMP4</b>: dfxp</p> </li>
    /// <li> <p> <b>Non-FMP4 outputs</b>: All sidecar types</p> </li>
    /// </ul> <p> <code>fmp4</code> captions have an extension of <code>.ismt</code> </p> </li>
    /// </ul>
    pub format: std::option::Option<std::string::String>,
    /// <p>The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:</p>
    /// <ul>
    /// <li> <p> <i>description</i> is a description of the video.</p> </li>
    /// <li> <p> <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or three-letter code for the language of the caption in the output file names.</p> </li>
    /// </ul>
    /// <p>If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder automatically appends "<code>{language}</code>" to the value that you specify for the description. In addition, Elastic Transcoder automatically appends the count to the end of the segment files.</p>
    /// <p>For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise", and the language of the captions is English (en), the name of the first caption file is be Sydney-en-sunrise00000.srt.</p>
    pub pattern: std::option::Option<std::string::String>,
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
}
impl CaptionFormat {
    /// <p>The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption for this output.</p>
    /// <ul>
    /// <li> <p> <b>Valid Embedded Caption Formats:</b> </p>
    /// <ul>
    /// <li> <p> <b>for FLAC</b>: None</p> </li>
    /// <li> <p> <b>For MP3</b>: None</p> </li>
    /// <li> <p> <b>For MP4</b>: mov-text</p> </li>
    /// <li> <p> <b>For MPEG-TS</b>: None</p> </li>
    /// <li> <p> <b>For ogg</b>: None</p> </li>
    /// <li> <p> <b>For webm</b>: None</p> </li>
    /// </ul> </li>
    /// <li> <p> <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc, srt, and webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <ul>
    /// <li> <p> <b>For FMP4</b>: dfxp</p> </li>
    /// <li> <p> <b>Non-FMP4 outputs</b>: All sidecar types</p> </li>
    /// </ul> <p> <code>fmp4</code> captions have an extension of <code>.ismt</code> </p> </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:</p>
    /// <ul>
    /// <li> <p> <i>description</i> is a description of the video.</p> </li>
    /// <li> <p> <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or three-letter code for the language of the caption in the output file names.</p> </li>
    /// </ul>
    /// <p>If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder automatically appends "<code>{language}</code>" to the value that you specify for the description. In addition, Elastic Transcoder automatically appends the count to the end of the segment files.</p>
    /// <p>For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise", and the language of the captions is English (en), the name of the first caption file is be Sydney-en-sunrise00000.srt.</p>
    pub fn pattern(&self) -> std::option::Option<&str> {
        self.pattern.as_deref()
    }
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
}
impl std::fmt::Debug for CaptionFormat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaptionFormat");
        formatter.field("format", &self.format);
        formatter.field("pattern", &self.pattern);
        formatter.field("encryption", &self.encryption);
        formatter.finish()
    }
}
/// See [`CaptionFormat`](crate::model::CaptionFormat)
pub mod caption_format {
    /// A builder for [`CaptionFormat`](crate::model::CaptionFormat)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) pattern: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
    }
    impl Builder {
        /// <p>The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption for this output.</p>
        /// <ul>
        /// <li> <p> <b>Valid Embedded Caption Formats:</b> </p>
        /// <ul>
        /// <li> <p> <b>for FLAC</b>: None</p> </li>
        /// <li> <p> <b>For MP3</b>: None</p> </li>
        /// <li> <p> <b>For MP4</b>: mov-text</p> </li>
        /// <li> <p> <b>For MPEG-TS</b>: None</p> </li>
        /// <li> <p> <b>For ogg</b>: None</p> </li>
        /// <li> <p> <b>For webm</b>: None</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc, srt, and webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <ul>
        /// <li> <p> <b>For FMP4</b>: dfxp</p> </li>
        /// <li> <p> <b>Non-FMP4 outputs</b>: All sidecar types</p> </li>
        /// </ul> <p> <code>fmp4</code> captions have an extension of <code>.ismt</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption for this output.</p>
        /// <ul>
        /// <li> <p> <b>Valid Embedded Caption Formats:</b> </p>
        /// <ul>
        /// <li> <p> <b>for FLAC</b>: None</p> </li>
        /// <li> <p> <b>For MP3</b>: None</p> </li>
        /// <li> <p> <b>For MP4</b>: mov-text</p> </li>
        /// <li> <p> <b>For MPEG-TS</b>: None</p> </li>
        /// <li> <p> <b>For ogg</b>: None</p> </li>
        /// <li> <p> <b>For webm</b>: None</p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc, srt, and webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <ul>
        /// <li> <p> <b>For FMP4</b>: dfxp</p> </li>
        /// <li> <p> <b>Non-FMP4 outputs</b>: All sidecar types</p> </li>
        /// </ul> <p> <code>fmp4</code> captions have an extension of <code>.ismt</code> </p> </li>
        /// </ul>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:</p>
        /// <ul>
        /// <li> <p> <i>description</i> is a description of the video.</p> </li>
        /// <li> <p> <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or three-letter code for the language of the caption in the output file names.</p> </li>
        /// </ul>
        /// <p>If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder automatically appends "<code>{language}</code>" to the value that you specify for the description. In addition, Elastic Transcoder automatically appends the count to the end of the segment files.</p>
        /// <p>For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise", and the language of the captions is English (en), the name of the first caption file is be Sydney-en-sunrise00000.srt.</p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p>The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:</p>
        /// <ul>
        /// <li> <p> <i>description</i> is a description of the video.</p> </li>
        /// <li> <p> <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or three-letter code for the language of the caption in the output file names.</p> </li>
        /// </ul>
        /// <p>If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder automatically appends "<code>{language}</code>" to the value that you specify for the description. In addition, Elastic Transcoder automatically appends the count to the end of the segment files.</p>
        /// <p>For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise", and the language of the captions is English (en), the name of the first caption file is be Sydney-en-sunrise00000.srt.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`CaptionFormat`](crate::model::CaptionFormat)
        pub fn build(self) -> crate::model::CaptionFormat {
            crate::model::CaptionFormat {
                format: self.format,
                pattern: self.pattern,
                encryption: self.encryption,
            }
        }
    }
}
impl CaptionFormat {
    /// Creates a new builder-style object to manufacture [`CaptionFormat`](crate::model::CaptionFormat)
    pub fn builder() -> crate::model::caption_format::Builder {
        crate::model::caption_format::Builder::default()
    }
}

/// <p>A source file for the input sidecar captions used during the transcoding process.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaptionSource {
    /// <p>The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A string that specifies the language of the caption. If you specified multiple inputs with captions, the caption language must match in order to be included in the output. Specify this as one of:</p>
    /// <ul>
    /// <li> <p>2-character ISO 639-1 code</p> </li>
    /// <li> <p>3-character ISO 639-2 code</p> </li>
    /// </ul>
    /// <p>For more information on ISO language codes and language names, see the List of ISO 639-1 codes.</p>
    pub language: std::option::Option<std::string::String>,
    /// <p>For clip generation or captions that do not start at the same time as the associated video file, the <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including captions.</p>
    /// <p>Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.</p>
    pub time_offset: std::option::Option<std::string::String>,
    /// <p>The label of the caption shown in the player when choosing a language. We recommend that you put the caption language name here, in the language of the captions.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you want Elastic Transcoder to apply to your caption sources.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
}
impl CaptionSource {
    /// <p>The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A string that specifies the language of the caption. If you specified multiple inputs with captions, the caption language must match in order to be included in the output. Specify this as one of:</p>
    /// <ul>
    /// <li> <p>2-character ISO 639-1 code</p> </li>
    /// <li> <p>3-character ISO 639-2 code</p> </li>
    /// </ul>
    /// <p>For more information on ISO language codes and language names, see the List of ISO 639-1 codes.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
    /// <p>For clip generation or captions that do not start at the same time as the associated video file, the <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including captions.</p>
    /// <p>Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.</p>
    pub fn time_offset(&self) -> std::option::Option<&str> {
        self.time_offset.as_deref()
    }
    /// <p>The label of the caption shown in the player when choosing a language. We recommend that you put the caption language name here, in the language of the captions.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you want Elastic Transcoder to apply to your caption sources.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
}
impl std::fmt::Debug for CaptionSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaptionSource");
        formatter.field("key", &self.key);
        formatter.field("language", &self.language);
        formatter.field("time_offset", &self.time_offset);
        formatter.field("label", &self.label);
        formatter.field("encryption", &self.encryption);
        formatter.finish()
    }
}
/// See [`CaptionSource`](crate::model::CaptionSource)
pub mod caption_source {
    /// A builder for [`CaptionSource`](crate::model::CaptionSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<std::string::String>,
        pub(crate) time_offset: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
    }
    impl Builder {
        /// <p>The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A string that specifies the language of the caption. If you specified multiple inputs with captions, the caption language must match in order to be included in the output. Specify this as one of:</p>
        /// <ul>
        /// <li> <p>2-character ISO 639-1 code</p> </li>
        /// <li> <p>3-character ISO 639-2 code</p> </li>
        /// </ul>
        /// <p>For more information on ISO language codes and language names, see the List of ISO 639-1 codes.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>A string that specifies the language of the caption. If you specified multiple inputs with captions, the caption language must match in order to be included in the output. Specify this as one of:</p>
        /// <ul>
        /// <li> <p>2-character ISO 639-1 code</p> </li>
        /// <li> <p>3-character ISO 639-2 code</p> </li>
        /// </ul>
        /// <p>For more information on ISO language codes and language names, see the List of ISO 639-1 codes.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// <p>For clip generation or captions that do not start at the same time as the associated video file, the <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including captions.</p>
        /// <p>Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.</p>
        pub fn time_offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_offset = Some(input.into());
            self
        }
        /// <p>For clip generation or captions that do not start at the same time as the associated video file, the <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including captions.</p>
        /// <p>Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.</p>
        pub fn set_time_offset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_offset = input;
            self
        }
        /// <p>The label of the caption shown in the player when choosing a language. We recommend that you put the caption language name here, in the language of the captions.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label of the caption shown in the player when choosing a language. We recommend that you put the caption language name here, in the language of the captions.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you want Elastic Transcoder to apply to your caption sources.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you want Elastic Transcoder to apply to your caption sources.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`CaptionSource`](crate::model::CaptionSource)
        pub fn build(self) -> crate::model::CaptionSource {
            crate::model::CaptionSource {
                key: self.key,
                language: self.language,
                time_offset: self.time_offset,
                label: self.label,
                encryption: self.encryption,
            }
        }
    }
}
impl CaptionSource {
    /// Creates a new builder-style object to manufacture [`CaptionSource`](crate::model::CaptionSource)
    pub fn builder() -> crate::model::caption_source::Builder {
        crate::model::caption_source::Builder::default()
    }
}

/// <p>Settings for one clip in a composition. All jobs in a playlist must have the same clip settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Clip {
    /// <p>Settings that determine when a clip begins and how long it lasts.</p>
    pub time_span: std::option::Option<crate::model::TimeSpan>,
}
impl Clip {
    /// <p>Settings that determine when a clip begins and how long it lasts.</p>
    pub fn time_span(&self) -> std::option::Option<&crate::model::TimeSpan> {
        self.time_span.as_ref()
    }
}
impl std::fmt::Debug for Clip {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Clip");
        formatter.field("time_span", &self.time_span);
        formatter.finish()
    }
}
/// See [`Clip`](crate::model::Clip)
pub mod clip {
    /// A builder for [`Clip`](crate::model::Clip)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_span: std::option::Option<crate::model::TimeSpan>,
    }
    impl Builder {
        /// <p>Settings that determine when a clip begins and how long it lasts.</p>
        pub fn time_span(mut self, input: crate::model::TimeSpan) -> Self {
            self.time_span = Some(input);
            self
        }
        /// <p>Settings that determine when a clip begins and how long it lasts.</p>
        pub fn set_time_span(mut self, input: std::option::Option<crate::model::TimeSpan>) -> Self {
            self.time_span = input;
            self
        }
        /// Consumes the builder and constructs a [`Clip`](crate::model::Clip)
        pub fn build(self) -> crate::model::Clip {
            crate::model::Clip {
                time_span: self.time_span,
            }
        }
    }
}
impl Clip {
    /// Creates a new builder-style object to manufacture [`Clip`](crate::model::Clip)
    pub fn builder() -> crate::model::clip::Builder {
        crate::model::clip::Builder::default()
    }
}

/// <p>Settings that determine when a clip begins and how long it lasts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeSpan {
    /// <p>The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder starts at the beginning of the input file.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder creates an output file from StartTime to the end of the file.</p>
    /// <p>If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the file and returns a warning message.</p>
    pub duration: std::option::Option<std::string::String>,
}
impl TimeSpan {
    /// <p>The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder starts at the beginning of the input file.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder creates an output file from StartTime to the end of the file.</p>
    /// <p>If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the file and returns a warning message.</p>
    pub fn duration(&self) -> std::option::Option<&str> {
        self.duration.as_deref()
    }
}
impl std::fmt::Debug for TimeSpan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeSpan");
        formatter.field("start_time", &self.start_time);
        formatter.field("duration", &self.duration);
        formatter.finish()
    }
}
/// See [`TimeSpan`](crate::model::TimeSpan)
pub mod time_span {
    /// A builder for [`TimeSpan`](crate::model::TimeSpan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder starts at the beginning of the input file.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder starts at the beginning of the input file.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder creates an output file from StartTime to the end of the file.</p>
        /// <p>If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the file and returns a warning message.</p>
        pub fn duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.duration = Some(input.into());
            self
        }
        /// <p>The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder creates an output file from StartTime to the end of the file.</p>
        /// <p>If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the file and returns a warning message.</p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.duration = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeSpan`](crate::model::TimeSpan)
        pub fn build(self) -> crate::model::TimeSpan {
            crate::model::TimeSpan {
                start_time: self.start_time,
                duration: self.duration,
            }
        }
    }
}
impl TimeSpan {
    /// Creates a new builder-style object to manufacture [`TimeSpan`](crate::model::TimeSpan)
    pub fn builder() -> crate::model::time_span::Builder {
        crate::model::time_span::Builder::default()
    }
}

/// <p>The .jpg or .png file associated with an audio file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobAlbumArt {
    /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple album artwork files.</p>
    /// <ul>
    /// <li> <p> <code>Replace:</code> The specified album art replaces any existing album art.</p> </li>
    /// <li> <p> <code>Prepend:</code> The specified album art is placed in front of any existing album art.</p> </li>
    /// <li> <p> <code>Append:</code> The specified album art is placed after any existing album art.</p> </li>
    /// <li> <p> <code>Fallback:</code> If the original input file contains artwork, Elastic Transcoder uses that artwork for the output. If the original input does not contain artwork, Elastic Transcoder uses the specified album art file.</p> </li>
    /// </ul>
    pub merge_policy: std::option::Option<std::string::String>,
    /// <p>The file to be used as album art. There can be multiple artworks associated with an audio file, to a maximum of 20. Valid formats are <code>.jpg</code> and <code>.png</code> </p>
    pub artwork: std::option::Option<std::vec::Vec<crate::model::Artwork>>,
}
impl JobAlbumArt {
    /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple album artwork files.</p>
    /// <ul>
    /// <li> <p> <code>Replace:</code> The specified album art replaces any existing album art.</p> </li>
    /// <li> <p> <code>Prepend:</code> The specified album art is placed in front of any existing album art.</p> </li>
    /// <li> <p> <code>Append:</code> The specified album art is placed after any existing album art.</p> </li>
    /// <li> <p> <code>Fallback:</code> If the original input file contains artwork, Elastic Transcoder uses that artwork for the output. If the original input does not contain artwork, Elastic Transcoder uses the specified album art file.</p> </li>
    /// </ul>
    pub fn merge_policy(&self) -> std::option::Option<&str> {
        self.merge_policy.as_deref()
    }
    /// <p>The file to be used as album art. There can be multiple artworks associated with an audio file, to a maximum of 20. Valid formats are <code>.jpg</code> and <code>.png</code> </p>
    pub fn artwork(&self) -> std::option::Option<&[crate::model::Artwork]> {
        self.artwork.as_deref()
    }
}
impl std::fmt::Debug for JobAlbumArt {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobAlbumArt");
        formatter.field("merge_policy", &self.merge_policy);
        formatter.field("artwork", &self.artwork);
        formatter.finish()
    }
}
/// See [`JobAlbumArt`](crate::model::JobAlbumArt)
pub mod job_album_art {
    /// A builder for [`JobAlbumArt`](crate::model::JobAlbumArt)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) merge_policy: std::option::Option<std::string::String>,
        pub(crate) artwork: std::option::Option<std::vec::Vec<crate::model::Artwork>>,
    }
    impl Builder {
        /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple album artwork files.</p>
        /// <ul>
        /// <li> <p> <code>Replace:</code> The specified album art replaces any existing album art.</p> </li>
        /// <li> <p> <code>Prepend:</code> The specified album art is placed in front of any existing album art.</p> </li>
        /// <li> <p> <code>Append:</code> The specified album art is placed after any existing album art.</p> </li>
        /// <li> <p> <code>Fallback:</code> If the original input file contains artwork, Elastic Transcoder uses that artwork for the output. If the original input does not contain artwork, Elastic Transcoder uses the specified album art file.</p> </li>
        /// </ul>
        pub fn merge_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_policy = Some(input.into());
            self
        }
        /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple album artwork files.</p>
        /// <ul>
        /// <li> <p> <code>Replace:</code> The specified album art replaces any existing album art.</p> </li>
        /// <li> <p> <code>Prepend:</code> The specified album art is placed in front of any existing album art.</p> </li>
        /// <li> <p> <code>Append:</code> The specified album art is placed after any existing album art.</p> </li>
        /// <li> <p> <code>Fallback:</code> If the original input file contains artwork, Elastic Transcoder uses that artwork for the output. If the original input does not contain artwork, Elastic Transcoder uses the specified album art file.</p> </li>
        /// </ul>
        pub fn set_merge_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merge_policy = input;
            self
        }
        /// Appends an item to `artwork`.
        ///
        /// To override the contents of this collection use [`set_artwork`](Self::set_artwork).
        ///
        /// <p>The file to be used as album art. There can be multiple artworks associated with an audio file, to a maximum of 20. Valid formats are <code>.jpg</code> and <code>.png</code> </p>
        pub fn artwork(mut self, input: crate::model::Artwork) -> Self {
            let mut v = self.artwork.unwrap_or_default();
            v.push(input);
            self.artwork = Some(v);
            self
        }
        /// <p>The file to be used as album art. There can be multiple artworks associated with an audio file, to a maximum of 20. Valid formats are <code>.jpg</code> and <code>.png</code> </p>
        pub fn set_artwork(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Artwork>>,
        ) -> Self {
            self.artwork = input;
            self
        }
        /// Consumes the builder and constructs a [`JobAlbumArt`](crate::model::JobAlbumArt)
        pub fn build(self) -> crate::model::JobAlbumArt {
            crate::model::JobAlbumArt {
                merge_policy: self.merge_policy,
                artwork: self.artwork,
            }
        }
    }
}
impl JobAlbumArt {
    /// Creates a new builder-style object to manufacture [`JobAlbumArt`](crate::model::JobAlbumArt)
    pub fn builder() -> crate::model::job_album_art::Builder {
        crate::model::job_album_art::Builder::default()
    }
}

/// <p>The file to be used as album art. There can be multiple artworks associated with an audio file, to a maximum of 20.</p>
/// <p>To remove artwork or leave the artwork empty, you can either set <code>Artwork</code> to null, or set the <code>Merge Policy</code> to "Replace" and use an empty <code>Artwork</code> array.</p>
/// <p>To pass through existing artwork unchanged, set the <code>Merge Policy</code> to "Prepend", "Append", or "Fallback", and use an empty <code>Artwork</code> array.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Artwork {
    /// <p>The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the <code>InputBucket</code> object in that pipeline identifies the bucket.</p>
    /// <p>If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
    pub input_key: std::option::Option<std::string::String>,
    /// <p>The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.</p>
    pub max_width: std::option::Option<std::string::String>,
    /// <p>The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.</p>
    pub max_height: std::option::Option<std::string::String>,
    /// <p>Specify one of the following values to control scaling of the output album art:</p>
    /// <ul>
    /// <li> <p> <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
    /// <li> <p> <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum value. </p> </li>
    /// <li> <p> <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input art and the output art are different, the output art will be distorted.</p> </li>
    /// <li> <p> <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input art exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output art.</p> </li>
    /// <li> <p> <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
    /// <li> <p> <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
    /// </ul>
    pub sizing_policy: std::option::Option<std::string::String>,
    /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to the top and bottom and/or left and right sides of the output album art to make the total size of the output art match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
    pub padding_policy: std::option::Option<std::string::String>,
    /// <p>The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.</p>
    pub album_art_format: std::option::Option<std::string::String>,
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
}
impl Artwork {
    /// <p>The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the <code>InputBucket</code> object in that pipeline identifies the bucket.</p>
    /// <p>If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
    pub fn input_key(&self) -> std::option::Option<&str> {
        self.input_key.as_deref()
    }
    /// <p>The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.</p>
    pub fn max_width(&self) -> std::option::Option<&str> {
        self.max_width.as_deref()
    }
    /// <p>The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.</p>
    pub fn max_height(&self) -> std::option::Option<&str> {
        self.max_height.as_deref()
    }
    /// <p>Specify one of the following values to control scaling of the output album art:</p>
    /// <ul>
    /// <li> <p> <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
    /// <li> <p> <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum value. </p> </li>
    /// <li> <p> <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input art and the output art are different, the output art will be distorted.</p> </li>
    /// <li> <p> <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input art exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output art.</p> </li>
    /// <li> <p> <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
    /// <li> <p> <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
    /// </ul>
    pub fn sizing_policy(&self) -> std::option::Option<&str> {
        self.sizing_policy.as_deref()
    }
    /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to the top and bottom and/or left and right sides of the output album art to make the total size of the output art match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
    pub fn padding_policy(&self) -> std::option::Option<&str> {
        self.padding_policy.as_deref()
    }
    /// <p>The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.</p>
    pub fn album_art_format(&self) -> std::option::Option<&str> {
        self.album_art_format.as_deref()
    }
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
}
impl std::fmt::Debug for Artwork {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Artwork");
        formatter.field("input_key", &self.input_key);
        formatter.field("max_width", &self.max_width);
        formatter.field("max_height", &self.max_height);
        formatter.field("sizing_policy", &self.sizing_policy);
        formatter.field("padding_policy", &self.padding_policy);
        formatter.field("album_art_format", &self.album_art_format);
        formatter.field("encryption", &self.encryption);
        formatter.finish()
    }
}
/// See [`Artwork`](crate::model::Artwork)
pub mod artwork {
    /// A builder for [`Artwork`](crate::model::Artwork)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_key: std::option::Option<std::string::String>,
        pub(crate) max_width: std::option::Option<std::string::String>,
        pub(crate) max_height: std::option::Option<std::string::String>,
        pub(crate) sizing_policy: std::option::Option<std::string::String>,
        pub(crate) padding_policy: std::option::Option<std::string::String>,
        pub(crate) album_art_format: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
    }
    impl Builder {
        /// <p>The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the <code>InputBucket</code> object in that pipeline identifies the bucket.</p>
        /// <p>If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
        pub fn input_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_key = Some(input.into());
            self
        }
        /// <p>The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the <code>InputBucket</code> object in that pipeline identifies the bucket.</p>
        /// <p>If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
        pub fn set_input_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_key = input;
            self
        }
        /// <p>The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.</p>
        pub fn max_width(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_width = Some(input.into());
            self
        }
        /// <p>The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.</p>
        pub fn set_max_width(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_width = input;
            self
        }
        /// <p>The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.</p>
        pub fn max_height(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_height = Some(input.into());
            self
        }
        /// <p>The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.</p>
        pub fn set_max_height(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_height = input;
            self
        }
        /// <p>Specify one of the following values to control scaling of the output album art:</p>
        /// <ul>
        /// <li> <p> <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
        /// <li> <p> <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum value. </p> </li>
        /// <li> <p> <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input art and the output art are different, the output art will be distorted.</p> </li>
        /// <li> <p> <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input art exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output art.</p> </li>
        /// <li> <p> <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
        /// <li> <p> <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
        /// </ul>
        pub fn sizing_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.sizing_policy = Some(input.into());
            self
        }
        /// <p>Specify one of the following values to control scaling of the output album art:</p>
        /// <ul>
        /// <li> <p> <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.</p> </li>
        /// <li> <p> <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum value. </p> </li>
        /// <li> <p> <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input art and the output art are different, the output art will be distorted.</p> </li>
        /// <li> <p> <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input art exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the output art.</p> </li>
        /// <li> <p> <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
        /// <li> <p> <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.</p> </li>
        /// </ul>
        pub fn set_sizing_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sizing_policy = input;
            self
        }
        /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to the top and bottom and/or left and right sides of the output album art to make the total size of the output art match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
        pub fn padding_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.padding_policy = Some(input.into());
            self
        }
        /// <p>When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to the top and bottom and/or left and right sides of the output album art to make the total size of the output art match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.</p>
        pub fn set_padding_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.padding_policy = input;
            self
        }
        /// <p>The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.</p>
        pub fn album_art_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.album_art_format = Some(input.into());
            self
        }
        /// <p>The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.</p>
        pub fn set_album_art_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.album_art_format = input;
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`Artwork`](crate::model::Artwork)
        pub fn build(self) -> crate::model::Artwork {
            crate::model::Artwork {
                input_key: self.input_key,
                max_width: self.max_width,
                max_height: self.max_height,
                sizing_policy: self.sizing_policy,
                padding_policy: self.padding_policy,
                album_art_format: self.album_art_format,
                encryption: self.encryption,
            }
        }
    }
}
impl Artwork {
    /// Creates a new builder-style object to manufacture [`Artwork`](crate::model::Artwork)
    pub fn builder() -> crate::model::artwork::Builder {
        crate::model::artwork::Builder::default()
    }
}

/// <p>Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png format, which supports transparency.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobWatermark {
    /// <p>The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during transcoding. The settings are in the preset specified by Preset for the current output. In that preset, the value of Watermarks Id tells Elastic Transcoder which settings to use.</p>
    pub preset_watermark_id: std::option::Option<std::string::String>,
    /// <p> The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>Pipeline</code>; the <code>Input Bucket</code> object in that pipeline identifies the bucket.</p>
    /// <p> If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error. </p>
    pub input_key: std::option::Option<std::string::String>,
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
}
impl JobWatermark {
    /// <p>The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during transcoding. The settings are in the preset specified by Preset for the current output. In that preset, the value of Watermarks Id tells Elastic Transcoder which settings to use.</p>
    pub fn preset_watermark_id(&self) -> std::option::Option<&str> {
        self.preset_watermark_id.as_deref()
    }
    /// <p> The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>Pipeline</code>; the <code>Input Bucket</code> object in that pipeline identifies the bucket.</p>
    /// <p> If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error. </p>
    pub fn input_key(&self) -> std::option::Option<&str> {
        self.input_key.as_deref()
    }
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
}
impl std::fmt::Debug for JobWatermark {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobWatermark");
        formatter.field("preset_watermark_id", &self.preset_watermark_id);
        formatter.field("input_key", &self.input_key);
        formatter.field("encryption", &self.encryption);
        formatter.finish()
    }
}
/// See [`JobWatermark`](crate::model::JobWatermark)
pub mod job_watermark {
    /// A builder for [`JobWatermark`](crate::model::JobWatermark)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preset_watermark_id: std::option::Option<std::string::String>,
        pub(crate) input_key: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
    }
    impl Builder {
        /// <p>The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during transcoding. The settings are in the preset specified by Preset for the current output. In that preset, the value of Watermarks Id tells Elastic Transcoder which settings to use.</p>
        pub fn preset_watermark_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.preset_watermark_id = Some(input.into());
            self
        }
        /// <p>The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during transcoding. The settings are in the preset specified by Preset for the current output. In that preset, the value of Watermarks Id tells Elastic Transcoder which settings to use.</p>
        pub fn set_preset_watermark_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preset_watermark_id = input;
            self
        }
        /// <p> The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>Pipeline</code>; the <code>Input Bucket</code> object in that pipeline identifies the bucket.</p>
        /// <p> If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error. </p>
        pub fn input_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_key = Some(input.into());
            self
        }
        /// <p> The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by <code>Pipeline</code>; the <code>Input Bucket</code> object in that pipeline identifies the bucket.</p>
        /// <p> If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error. </p>
        pub fn set_input_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_key = input;
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`JobWatermark`](crate::model::JobWatermark)
        pub fn build(self) -> crate::model::JobWatermark {
            crate::model::JobWatermark {
                preset_watermark_id: self.preset_watermark_id,
                input_key: self.input_key,
                encryption: self.encryption,
            }
        }
    }
}
impl JobWatermark {
    /// Creates a new builder-style object to manufacture [`JobWatermark`](crate::model::JobWatermark)
    pub fn builder() -> crate::model::job_watermark::Builder {
        crate::model::job_watermark::Builder::default()
    }
}

/// <p>Information about the file that you're transcoding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobInput {
    /// <p> The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to use for processing the job. The <code>InputBucket</code> object in that pipeline tells Elastic Transcoder which Amazon S3 bucket to get the file from. </p>
    /// <p>If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of the input file, specify <code>auto</code>. If you want to specify the frame rate for the input file, enter one of the following values: </p>
    /// <p> <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
    /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the frame rate.</p>
    pub frame_rate: std::option::Option<std::string::String>,
    /// <p>This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the resolution of the input file.</p>
    pub resolution: std::option::Option<std::string::String>,
    /// <p> The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio of the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the output file, enter one of the following values: </p>
    /// <p> <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
    /// <p> If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the aspect ratio. </p>
    pub aspect_ratio: std::option::Option<std::string::String>,
    /// <p>Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the input file is interlaced, specify <code>auto</code>. If you want to specify whether the input file is interlaced, enter one of the following values:</p>
    /// <p> <code>true</code>, <code>false</code> </p>
    /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of interlacing.</p>
    pub interlaced: std::option::Option<std::string::String>,
    /// <p>The container type for the input file. If you want Elastic Transcoder to automatically detect the container type of the input file, specify <code>auto</code>. If you want to specify the container type for the input file, enter one of the following values: </p>
    /// <p> <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>, <code>flv</code>, <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>, <code>mp4</code>, <code>mpeg</code>, <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>, <code>ogg</code>, <code>vob</code>, <code>wav</code>, <code>webm</code> </p>
    pub container: std::option::Option<std::string::String>,
    /// <p>The encryption settings, if any, that are used for decrypting your input files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// <p>Settings for clipping an input. Each input can have different clip settings.</p>
    pub time_span: std::option::Option<crate::model::TimeSpan>,
    /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
    /// <ul>
    /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
    /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
    /// </ul>
    /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
    /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
    /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
    /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
    pub input_captions: std::option::Option<crate::model::InputCaptions>,
    /// <p>The detected properties of the input file.</p>
    pub detected_properties: std::option::Option<crate::model::DetectedProperties>,
}
impl JobInput {
    /// <p> The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to use for processing the job. The <code>InputBucket</code> object in that pipeline tells Elastic Transcoder which Amazon S3 bucket to get the file from. </p>
    /// <p>If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of the input file, specify <code>auto</code>. If you want to specify the frame rate for the input file, enter one of the following values: </p>
    /// <p> <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
    /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the frame rate.</p>
    pub fn frame_rate(&self) -> std::option::Option<&str> {
        self.frame_rate.as_deref()
    }
    /// <p>This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the resolution of the input file.</p>
    pub fn resolution(&self) -> std::option::Option<&str> {
        self.resolution.as_deref()
    }
    /// <p> The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio of the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the output file, enter one of the following values: </p>
    /// <p> <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
    /// <p> If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the aspect ratio. </p>
    pub fn aspect_ratio(&self) -> std::option::Option<&str> {
        self.aspect_ratio.as_deref()
    }
    /// <p>Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the input file is interlaced, specify <code>auto</code>. If you want to specify whether the input file is interlaced, enter one of the following values:</p>
    /// <p> <code>true</code>, <code>false</code> </p>
    /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of interlacing.</p>
    pub fn interlaced(&self) -> std::option::Option<&str> {
        self.interlaced.as_deref()
    }
    /// <p>The container type for the input file. If you want Elastic Transcoder to automatically detect the container type of the input file, specify <code>auto</code>. If you want to specify the container type for the input file, enter one of the following values: </p>
    /// <p> <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>, <code>flv</code>, <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>, <code>mp4</code>, <code>mpeg</code>, <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>, <code>ogg</code>, <code>vob</code>, <code>wav</code>, <code>webm</code> </p>
    pub fn container(&self) -> std::option::Option<&str> {
        self.container.as_deref()
    }
    /// <p>The encryption settings, if any, that are used for decrypting your input files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
    /// <p>Settings for clipping an input. Each input can have different clip settings.</p>
    pub fn time_span(&self) -> std::option::Option<&crate::model::TimeSpan> {
        self.time_span.as_ref()
    }
    /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
    /// <ul>
    /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
    /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
    /// </ul>
    /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
    /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
    /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
    /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
    pub fn input_captions(&self) -> std::option::Option<&crate::model::InputCaptions> {
        self.input_captions.as_ref()
    }
    /// <p>The detected properties of the input file.</p>
    pub fn detected_properties(&self) -> std::option::Option<&crate::model::DetectedProperties> {
        self.detected_properties.as_ref()
    }
}
impl std::fmt::Debug for JobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobInput");
        formatter.field("key", &self.key);
        formatter.field("frame_rate", &self.frame_rate);
        formatter.field("resolution", &self.resolution);
        formatter.field("aspect_ratio", &self.aspect_ratio);
        formatter.field("interlaced", &self.interlaced);
        formatter.field("container", &self.container);
        formatter.field("encryption", &self.encryption);
        formatter.field("time_span", &self.time_span);
        formatter.field("input_captions", &self.input_captions);
        formatter.field("detected_properties", &self.detected_properties);
        formatter.finish()
    }
}
/// See [`JobInput`](crate::model::JobInput)
pub mod job_input {
    /// A builder for [`JobInput`](crate::model::JobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) frame_rate: std::option::Option<std::string::String>,
        pub(crate) resolution: std::option::Option<std::string::String>,
        pub(crate) aspect_ratio: std::option::Option<std::string::String>,
        pub(crate) interlaced: std::option::Option<std::string::String>,
        pub(crate) container: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) time_span: std::option::Option<crate::model::TimeSpan>,
        pub(crate) input_captions: std::option::Option<crate::model::InputCaptions>,
        pub(crate) detected_properties: std::option::Option<crate::model::DetectedProperties>,
    }
    impl Builder {
        /// <p> The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to use for processing the job. The <code>InputBucket</code> object in that pipeline tells Elastic Transcoder which Amazon S3 bucket to get the file from. </p>
        /// <p>If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to use for processing the job. The <code>InputBucket</code> object in that pipeline tells Elastic Transcoder which Amazon S3 bucket to get the file from. </p>
        /// <p>If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of the input file, specify <code>auto</code>. If you want to specify the frame rate for the input file, enter one of the following values: </p>
        /// <p> <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
        /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the frame rate.</p>
        pub fn frame_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.frame_rate = Some(input.into());
            self
        }
        /// <p>The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of the input file, specify <code>auto</code>. If you want to specify the frame rate for the input file, enter one of the following values: </p>
        /// <p> <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code> </p>
        /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the frame rate.</p>
        pub fn set_frame_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.frame_rate = input;
            self
        }
        /// <p>This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the resolution of the input file.</p>
        pub fn resolution(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution = Some(input.into());
            self
        }
        /// <p>This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the resolution of the input file.</p>
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolution = input;
            self
        }
        /// <p> The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio of the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the output file, enter one of the following values: </p>
        /// <p> <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
        /// <p> If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the aspect ratio. </p>
        pub fn aspect_ratio(mut self, input: impl Into<std::string::String>) -> Self {
            self.aspect_ratio = Some(input.into());
            self
        }
        /// <p> The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio of the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the output file, enter one of the following values: </p>
        /// <p> <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code> </p>
        /// <p> If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the aspect ratio. </p>
        pub fn set_aspect_ratio(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aspect_ratio = input;
            self
        }
        /// <p>Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the input file is interlaced, specify <code>auto</code>. If you want to specify whether the input file is interlaced, enter one of the following values:</p>
        /// <p> <code>true</code>, <code>false</code> </p>
        /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of interlacing.</p>
        pub fn interlaced(mut self, input: impl Into<std::string::String>) -> Self {
            self.interlaced = Some(input.into());
            self
        }
        /// <p>Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the input file is interlaced, specify <code>auto</code>. If you want to specify whether the input file is interlaced, enter one of the following values:</p>
        /// <p> <code>true</code>, <code>false</code> </p>
        /// <p>If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of interlacing.</p>
        pub fn set_interlaced(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.interlaced = input;
            self
        }
        /// <p>The container type for the input file. If you want Elastic Transcoder to automatically detect the container type of the input file, specify <code>auto</code>. If you want to specify the container type for the input file, enter one of the following values: </p>
        /// <p> <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>, <code>flv</code>, <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>, <code>mp4</code>, <code>mpeg</code>, <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>, <code>ogg</code>, <code>vob</code>, <code>wav</code>, <code>webm</code> </p>
        pub fn container(mut self, input: impl Into<std::string::String>) -> Self {
            self.container = Some(input.into());
            self
        }
        /// <p>The container type for the input file. If you want Elastic Transcoder to automatically detect the container type of the input file, specify <code>auto</code>. If you want to specify the container type for the input file, enter one of the following values: </p>
        /// <p> <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>, <code>flv</code>, <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>, <code>mp4</code>, <code>mpeg</code>, <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>, <code>ogg</code>, <code>vob</code>, <code>wav</code>, <code>webm</code> </p>
        pub fn set_container(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.container = input;
            self
        }
        /// <p>The encryption settings, if any, that are used for decrypting your input files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that are used for decrypting your input files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// <p>Settings for clipping an input. Each input can have different clip settings.</p>
        pub fn time_span(mut self, input: crate::model::TimeSpan) -> Self {
            self.time_span = Some(input);
            self
        }
        /// <p>Settings for clipping an input. Each input can have different clip settings.</p>
        pub fn set_time_span(mut self, input: std::option::Option<crate::model::TimeSpan>) -> Self {
            self.time_span = input;
            self
        }
        /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
        /// <ul>
        /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
        /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
        /// </ul>
        /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
        /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
        /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
        /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
        pub fn input_captions(mut self, input: crate::model::InputCaptions) -> Self {
            self.input_captions = Some(input);
            self
        }
        /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
        /// <ul>
        /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
        /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
        /// </ul>
        /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
        /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
        /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
        /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
        pub fn set_input_captions(
            mut self,
            input: std::option::Option<crate::model::InputCaptions>,
        ) -> Self {
            self.input_captions = input;
            self
        }
        /// <p>The detected properties of the input file.</p>
        pub fn detected_properties(mut self, input: crate::model::DetectedProperties) -> Self {
            self.detected_properties = Some(input);
            self
        }
        /// <p>The detected properties of the input file.</p>
        pub fn set_detected_properties(
            mut self,
            input: std::option::Option<crate::model::DetectedProperties>,
        ) -> Self {
            self.detected_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`JobInput`](crate::model::JobInput)
        pub fn build(self) -> crate::model::JobInput {
            crate::model::JobInput {
                key: self.key,
                frame_rate: self.frame_rate,
                resolution: self.resolution,
                aspect_ratio: self.aspect_ratio,
                interlaced: self.interlaced,
                container: self.container,
                encryption: self.encryption,
                time_span: self.time_span,
                input_captions: self.input_captions,
                detected_properties: self.detected_properties,
            }
        }
    }
}
impl JobInput {
    /// Creates a new builder-style object to manufacture [`JobInput`](crate::model::JobInput)
    pub fn builder() -> crate::model::job_input::Builder {
        crate::model::job_input::Builder::default()
    }
}

/// <p>The detected properties of the input file. Elastic Transcoder identifies these values from the input file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectedProperties {
    /// <p>The detected width of the input file, in pixels.</p>
    pub width: std::option::Option<i32>,
    /// <p>The detected height of the input file, in pixels.</p>
    pub height: std::option::Option<i32>,
    /// <p>The detected frame rate of the input file, in frames per second.</p>
    pub frame_rate: std::option::Option<std::string::String>,
    /// <p>The detected file size of the input file, in bytes.</p>
    pub file_size: std::option::Option<i64>,
    /// <p>The detected duration of the input file, in milliseconds.</p>
    pub duration_millis: std::option::Option<i64>,
}
impl DetectedProperties {
    /// <p>The detected width of the input file, in pixels.</p>
    pub fn width(&self) -> std::option::Option<i32> {
        self.width
    }
    /// <p>The detected height of the input file, in pixels.</p>
    pub fn height(&self) -> std::option::Option<i32> {
        self.height
    }
    /// <p>The detected frame rate of the input file, in frames per second.</p>
    pub fn frame_rate(&self) -> std::option::Option<&str> {
        self.frame_rate.as_deref()
    }
    /// <p>The detected file size of the input file, in bytes.</p>
    pub fn file_size(&self) -> std::option::Option<i64> {
        self.file_size
    }
    /// <p>The detected duration of the input file, in milliseconds.</p>
    pub fn duration_millis(&self) -> std::option::Option<i64> {
        self.duration_millis
    }
}
impl std::fmt::Debug for DetectedProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectedProperties");
        formatter.field("width", &self.width);
        formatter.field("height", &self.height);
        formatter.field("frame_rate", &self.frame_rate);
        formatter.field("file_size", &self.file_size);
        formatter.field("duration_millis", &self.duration_millis);
        formatter.finish()
    }
}
/// See [`DetectedProperties`](crate::model::DetectedProperties)
pub mod detected_properties {
    /// A builder for [`DetectedProperties`](crate::model::DetectedProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) width: std::option::Option<i32>,
        pub(crate) height: std::option::Option<i32>,
        pub(crate) frame_rate: std::option::Option<std::string::String>,
        pub(crate) file_size: std::option::Option<i64>,
        pub(crate) duration_millis: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The detected width of the input file, in pixels.</p>
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// <p>The detected width of the input file, in pixels.</p>
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// <p>The detected height of the input file, in pixels.</p>
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// <p>The detected height of the input file, in pixels.</p>
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// <p>The detected frame rate of the input file, in frames per second.</p>
        pub fn frame_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.frame_rate = Some(input.into());
            self
        }
        /// <p>The detected frame rate of the input file, in frames per second.</p>
        pub fn set_frame_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.frame_rate = input;
            self
        }
        /// <p>The detected file size of the input file, in bytes.</p>
        pub fn file_size(mut self, input: i64) -> Self {
            self.file_size = Some(input);
            self
        }
        /// <p>The detected file size of the input file, in bytes.</p>
        pub fn set_file_size(mut self, input: std::option::Option<i64>) -> Self {
            self.file_size = input;
            self
        }
        /// <p>The detected duration of the input file, in milliseconds.</p>
        pub fn duration_millis(mut self, input: i64) -> Self {
            self.duration_millis = Some(input);
            self
        }
        /// <p>The detected duration of the input file, in milliseconds.</p>
        pub fn set_duration_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_millis = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectedProperties`](crate::model::DetectedProperties)
        pub fn build(self) -> crate::model::DetectedProperties {
            crate::model::DetectedProperties {
                width: self.width,
                height: self.height,
                frame_rate: self.frame_rate,
                file_size: self.file_size,
                duration_millis: self.duration_millis,
            }
        }
    }
}
impl DetectedProperties {
    /// Creates a new builder-style object to manufacture [`DetectedProperties`](crate::model::DetectedProperties)
    pub fn builder() -> crate::model::detected_properties::Builder {
        crate::model::detected_properties::Builder::default()
    }
}

/// <p>The captions to be created, if any.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputCaptions {
    /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
    /// <ul>
    /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
    /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
    /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
    /// </ul>
    /// <p> <code>MergePolicy</code> cannot be null.</p>
    pub merge_policy: std::option::Option<std::string::String>,
    /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
    pub caption_sources: std::option::Option<std::vec::Vec<crate::model::CaptionSource>>,
}
impl InputCaptions {
    /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
    /// <ul>
    /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
    /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
    /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
    /// </ul>
    /// <p> <code>MergePolicy</code> cannot be null.</p>
    pub fn merge_policy(&self) -> std::option::Option<&str> {
        self.merge_policy.as_deref()
    }
    /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
    pub fn caption_sources(&self) -> std::option::Option<&[crate::model::CaptionSource]> {
        self.caption_sources.as_deref()
    }
}
impl std::fmt::Debug for InputCaptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputCaptions");
        formatter.field("merge_policy", &self.merge_policy);
        formatter.field("caption_sources", &self.caption_sources);
        formatter.finish()
    }
}
/// See [`InputCaptions`](crate::model::InputCaptions)
pub mod input_captions {
    /// A builder for [`InputCaptions`](crate::model::InputCaptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) merge_policy: std::option::Option<std::string::String>,
        pub(crate) caption_sources: std::option::Option<std::vec::Vec<crate::model::CaptionSource>>,
    }
    impl Builder {
        /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
        /// <ul>
        /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
        /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
        /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
        /// </ul>
        /// <p> <code>MergePolicy</code> cannot be null.</p>
        pub fn merge_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_policy = Some(input.into());
            self
        }
        /// <p>A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
        /// <ul>
        /// <li> <p> <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.</p> </li>
        /// <li> <p> <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output files.</p> </li>
        /// <li> <p> <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in <code>CaptionSources</code>.</p> </li>
        /// </ul>
        /// <p> <code>MergePolicy</code> cannot be null.</p>
        pub fn set_merge_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merge_policy = input;
            self
        }
        /// Appends an item to `caption_sources`.
        ///
        /// To override the contents of this collection use [`set_caption_sources`](Self::set_caption_sources).
        ///
        /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
        pub fn caption_sources(mut self, input: crate::model::CaptionSource) -> Self {
            let mut v = self.caption_sources.unwrap_or_default();
            v.push(input);
            self.caption_sources = Some(v);
            self
        }
        /// <p>Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave <code>CaptionSources</code> blank.</p>
        pub fn set_caption_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaptionSource>>,
        ) -> Self {
            self.caption_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`InputCaptions`](crate::model::InputCaptions)
        pub fn build(self) -> crate::model::InputCaptions {
            crate::model::InputCaptions {
                merge_policy: self.merge_policy,
                caption_sources: self.caption_sources,
            }
        }
    }
}
impl InputCaptions {
    /// Creates a new builder-style object to manufacture [`InputCaptions`](crate::model::InputCaptions)
    pub fn builder() -> crate::model::input_captions::Builder {
        crate::model::input_captions::Builder::default()
    }
}

/// <p>Information about the master playlist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobPlaylist {
    /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
    /// <p> Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
    /// </note>
    pub name: std::option::Option<std::string::String>,
    /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>For each output in this job that you want to include in a master playlist, the value of the <code>Outputs:Key</code> object. </p>
    /// <ul>
    /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
    /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
    /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
    /// </ul>
    /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
    /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
    pub output_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub hls_content_protection: std::option::Option<crate::model::HlsContentProtection>,
    /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub play_ready_drm: std::option::Option<crate::model::PlayReadyDrm>,
}
impl CreateJobPlaylist {
    /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
    /// <p> Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
    /// </note>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>For each output in this job that you want to include in a master playlist, the value of the <code>Outputs:Key</code> object. </p>
    /// <ul>
    /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
    /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
    /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
    /// </ul>
    /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
    /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
    pub fn output_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.output_keys.as_deref()
    }
    /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub fn hls_content_protection(
        &self,
    ) -> std::option::Option<&crate::model::HlsContentProtection> {
        self.hls_content_protection.as_ref()
    }
    /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
    pub fn play_ready_drm(&self) -> std::option::Option<&crate::model::PlayReadyDrm> {
        self.play_ready_drm.as_ref()
    }
}
impl std::fmt::Debug for CreateJobPlaylist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobPlaylist");
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("output_keys", &self.output_keys);
        formatter.field("hls_content_protection", &self.hls_content_protection);
        formatter.field("play_ready_drm", &self.play_ready_drm);
        formatter.finish()
    }
}
/// See [`CreateJobPlaylist`](crate::model::CreateJobPlaylist)
pub mod create_job_playlist {
    /// A builder for [`CreateJobPlaylist`](crate::model::CreateJobPlaylist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) output_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hls_content_protection: std::option::Option<crate::model::HlsContentProtection>,
        pub(crate) play_ready_drm: std::option::Option<crate::model::PlayReadyDrm>,
    }
    impl Builder {
        /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
        /// <p> Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
        /// </note>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
        /// <p> Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two extensions.</p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and <code>Smooth</code>.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// Appends an item to `output_keys`.
        ///
        /// To override the contents of this collection use [`set_output_keys`](Self::set_output_keys).
        ///
        /// <p>For each output in this job that you want to include in a master playlist, the value of the <code>Outputs:Key</code> object. </p>
        /// <ul>
        /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
        /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
        /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
        /// </ul>
        /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
        /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
        pub fn output_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.output_keys.unwrap_or_default();
            v.push(input.into());
            self.output_keys = Some(v);
            self
        }
        /// <p>For each output in this job that you want to include in a master playlist, the value of the <code>Outputs:Key</code> object. </p>
        /// <ul>
        /// <li> <p>If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code> </p> </li>
        /// <li> <p>If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>00000.ts</p> </li>
        /// <li> <p>If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an extension of <code>_iframe.m3u8</code>:</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8</p> <p>OutputKeyPrefix<code>Outputs:Key</code>.ts</p> </li>
        /// </ul>
        /// <p>Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.</p>
        /// <p>If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.</p>
        pub fn set_output_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.output_keys = input;
            self
        }
        /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn hls_content_protection(mut self, input: crate::model::HlsContentProtection) -> Self {
            self.hls_content_protection = Some(input);
            self
        }
        /// <p>The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn set_hls_content_protection(
            mut self,
            input: std::option::Option<crate::model::HlsContentProtection>,
        ) -> Self {
            self.hls_content_protection = input;
            self
        }
        /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn play_ready_drm(mut self, input: crate::model::PlayReadyDrm) -> Self {
            self.play_ready_drm = Some(input);
            self
        }
        /// <p>The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.</p>
        pub fn set_play_ready_drm(
            mut self,
            input: std::option::Option<crate::model::PlayReadyDrm>,
        ) -> Self {
            self.play_ready_drm = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobPlaylist`](crate::model::CreateJobPlaylist)
        pub fn build(self) -> crate::model::CreateJobPlaylist {
            crate::model::CreateJobPlaylist {
                name: self.name,
                format: self.format,
                output_keys: self.output_keys,
                hls_content_protection: self.hls_content_protection,
                play_ready_drm: self.play_ready_drm,
            }
        }
    }
}
impl CreateJobPlaylist {
    /// Creates a new builder-style object to manufacture [`CreateJobPlaylist`](crate::model::CreateJobPlaylist)
    pub fn builder() -> crate::model::create_job_playlist::Builder {
        crate::model::create_job_playlist::Builder::default()
    }
}

/// <p>The <code>CreateJobOutput</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobOutput {
    /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID. If a file with the specified name already exists in the output bucket, the job fails. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
    /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
    /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
    /// <ul>
    /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
    /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
    /// </important> </li>
    /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
    /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
    /// </ul>
    /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
    pub thumbnail_pattern: std::option::Option<std::string::String>,
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
    pub thumbnail_encryption: std::option::Option<crate::model::Encryption>,
    /// <p> The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>. The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata. </p>
    pub rotate: std::option::Option<std::string::String>,
    /// <p> The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. </p>
    pub preset_id: std::option::Option<std::string::String>,
    /// <important>
    /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
    /// </important>
    /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
    /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
    /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
    pub segment_duration: std::option::Option<std::string::String>,
    /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset for the current output.</p>
    pub watermarks: std::option::Option<std::vec::Vec<crate::model::JobWatermark>>,
    /// <p>Information about the album art that you want Elastic Transcoder to add to the file during transcoding. You can specify up to twenty album artworks for each output. Settings for each artwork must be defined in the job for the current output.</p>
    pub album_art: std::option::Option<crate::model::JobAlbumArt>,
    /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
    pub composition: std::option::Option<std::vec::Vec<crate::model::Clip>>,
    /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
    /// <ul>
    /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
    /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
    /// </ul>
    /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
    /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
    /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
    /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
    pub captions: std::option::Option<crate::model::Captions>,
    /// <p>You can specify encryption settings for any output files that you want to use for a transcoding job. This includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You must specify encryption settings for each file individually.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
}
impl CreateJobOutput {
    /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID. If a file with the specified name already exists in the output bucket, the job fails. </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
    /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
    /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
    /// <ul>
    /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
    /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
    /// </important> </li>
    /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
    /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
    /// </ul>
    /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
    pub fn thumbnail_pattern(&self) -> std::option::Option<&str> {
        self.thumbnail_pattern.as_deref()
    }
    /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
    pub fn thumbnail_encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.thumbnail_encryption.as_ref()
    }
    /// <p> The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>. The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata. </p>
    pub fn rotate(&self) -> std::option::Option<&str> {
        self.rotate.as_deref()
    }
    /// <p> The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. </p>
    pub fn preset_id(&self) -> std::option::Option<&str> {
        self.preset_id.as_deref()
    }
    /// <important>
    /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
    /// </important>
    /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
    /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
    /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
    pub fn segment_duration(&self) -> std::option::Option<&str> {
        self.segment_duration.as_deref()
    }
    /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset for the current output.</p>
    pub fn watermarks(&self) -> std::option::Option<&[crate::model::JobWatermark]> {
        self.watermarks.as_deref()
    }
    /// <p>Information about the album art that you want Elastic Transcoder to add to the file during transcoding. You can specify up to twenty album artworks for each output. Settings for each artwork must be defined in the job for the current output.</p>
    pub fn album_art(&self) -> std::option::Option<&crate::model::JobAlbumArt> {
        self.album_art.as_ref()
    }
    /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
    pub fn composition(&self) -> std::option::Option<&[crate::model::Clip]> {
        self.composition.as_deref()
    }
    /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
    /// <ul>
    /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
    /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
    /// </ul>
    /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
    /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
    /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
    /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
    /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
    pub fn captions(&self) -> std::option::Option<&crate::model::Captions> {
        self.captions.as_ref()
    }
    /// <p>You can specify encryption settings for any output files that you want to use for a transcoding job. This includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You must specify encryption settings for each file individually.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
}
impl std::fmt::Debug for CreateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobOutput");
        formatter.field("key", &self.key);
        formatter.field("thumbnail_pattern", &self.thumbnail_pattern);
        formatter.field("thumbnail_encryption", &self.thumbnail_encryption);
        formatter.field("rotate", &self.rotate);
        formatter.field("preset_id", &self.preset_id);
        formatter.field("segment_duration", &self.segment_duration);
        formatter.field("watermarks", &self.watermarks);
        formatter.field("album_art", &self.album_art);
        formatter.field("composition", &self.composition);
        formatter.field("captions", &self.captions);
        formatter.field("encryption", &self.encryption);
        formatter.finish()
    }
}
/// See [`CreateJobOutput`](crate::model::CreateJobOutput)
pub mod create_job_output {
    /// A builder for [`CreateJobOutput`](crate::model::CreateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) thumbnail_pattern: std::option::Option<std::string::String>,
        pub(crate) thumbnail_encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) rotate: std::option::Option<std::string::String>,
        pub(crate) preset_id: std::option::Option<std::string::String>,
        pub(crate) segment_duration: std::option::Option<std::string::String>,
        pub(crate) watermarks: std::option::Option<std::vec::Vec<crate::model::JobWatermark>>,
        pub(crate) album_art: std::option::Option<crate::model::JobAlbumArt>,
        pub(crate) composition: std::option::Option<std::vec::Vec<crate::model::Clip>>,
        pub(crate) captions: std::option::Option<crate::model::Captions>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
    }
    impl Builder {
        /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID. If a file with the specified name already exists in the output bucket, the job fails. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID. If a file with the specified name already exists in the output bucket, the job fails. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
        /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
        /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
        /// <ul>
        /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
        /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
        /// </important> </li>
        /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
        /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
        /// </ul>
        /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
        pub fn thumbnail_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbnail_pattern = Some(input.into());
            self
        }
        /// <p>Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.</p>
        /// <p>If you don't want Elastic Transcoder to create thumbnails, specify "".</p>
        /// <p>If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:</p>
        /// <ul>
        /// <li> <p> <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. </p> <important>
        /// <p>If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic Transcoder returns a validation error and does not create the job.</p>
        /// </important> </li>
        /// <li> <p> <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a delimiter between <code>{resolution}</code> and <code>{count}</code>. </p> </li>
        /// <li> <p> <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object. </p> </li>
        /// </ul>
        /// <p>When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.</p>
        pub fn set_thumbnail_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thumbnail_pattern = input;
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
        pub fn thumbnail_encryption(mut self, input: crate::model::Encryption) -> Self {
            self.thumbnail_encryption = Some(input);
            self
        }
        /// <p>The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.</p>
        pub fn set_thumbnail_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.thumbnail_encryption = input;
            self
        }
        /// <p> The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>. The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata. </p>
        pub fn rotate(mut self, input: impl Into<std::string::String>) -> Self {
            self.rotate = Some(input.into());
            self
        }
        /// <p> The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>, <code>270</code>. The value <code>auto</code> generally works only if the file that you're transcoding contains rotation metadata. </p>
        pub fn set_rotate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rotate = input;
            self
        }
        /// <p> The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. </p>
        pub fn preset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.preset_id = Some(input.into());
            self
        }
        /// <p> The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. </p>
        pub fn set_preset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.preset_id = input;
            self
        }
        /// <important>
        /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
        /// </important>
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
        /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
        /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
        pub fn segment_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_duration = Some(input.into());
            self
        }
        /// <important>
        /// <p>(Outputs in Fragmented MP4 or MPEG-TS format only.</p>
        /// </important>
        /// <p>If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.</p>
        /// <p>The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.</p>
        /// <p>Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of the associated playlist.</p>
        pub fn set_segment_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.segment_duration = input;
            self
        }
        /// Appends an item to `watermarks`.
        ///
        /// To override the contents of this collection use [`set_watermarks`](Self::set_watermarks).
        ///
        /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset for the current output.</p>
        pub fn watermarks(mut self, input: crate::model::JobWatermark) -> Self {
            let mut v = self.watermarks.unwrap_or_default();
            v.push(input);
            self.watermarks = Some(v);
            self
        }
        /// <p>Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset for the current output.</p>
        pub fn set_watermarks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobWatermark>>,
        ) -> Self {
            self.watermarks = input;
            self
        }
        /// <p>Information about the album art that you want Elastic Transcoder to add to the file during transcoding. You can specify up to twenty album artworks for each output. Settings for each artwork must be defined in the job for the current output.</p>
        pub fn album_art(mut self, input: crate::model::JobAlbumArt) -> Self {
            self.album_art = Some(input);
            self
        }
        /// <p>Information about the album art that you want Elastic Transcoder to add to the file during transcoding. You can specify up to twenty album artworks for each output. Settings for each artwork must be defined in the job for the current output.</p>
        pub fn set_album_art(
            mut self,
            input: std::option::Option<crate::model::JobAlbumArt>,
        ) -> Self {
            self.album_art = input;
            self
        }
        /// Appends an item to `composition`.
        ///
        /// To override the contents of this collection use [`set_composition`](Self::set_composition).
        ///
        /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
        pub fn composition(mut self, input: crate::model::Clip) -> Self {
            let mut v = self.composition.unwrap_or_default();
            v.push(input);
            self.composition = Some(v);
            self
        }
        /// <p>You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.</p>
        pub fn set_composition(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Clip>>,
        ) -> Self {
            self.composition = input;
            self
        }
        /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
        /// <ul>
        /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
        /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
        /// </ul>
        /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
        /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
        /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
        /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
        pub fn captions(mut self, input: crate::model::Captions) -> Self {
            self.captions = Some(input);
            self
        }
        /// <p>You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
        /// <ul>
        /// <li> <p> <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.</p> <p>Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only), <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code> </p> <p>Valid outputs include: <code>mov-text</code> </p> <p>Elastic Transcoder supports a maximum of one embedded format per output.</p> </li>
        /// <li> <p> <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.</p> <p>Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code> </p> <p>Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and <code>webvtt</code>.</p> </li>
        /// </ul>
        /// <p>If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.</p>
        /// <p>Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.</p>
        /// <p>To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null <code>CaptionSources</code> array.</p>
        /// <p>For more information on embedded files, see the Subtitles Wikipedia page.</p>
        /// <p>For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.</p>
        pub fn set_captions(mut self, input: std::option::Option<crate::model::Captions>) -> Self {
            self.captions = input;
            self
        }
        /// <p>You can specify encryption settings for any output files that you want to use for a transcoding job. This includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You must specify encryption settings for each file individually.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>You can specify encryption settings for any output files that you want to use for a transcoding job. This includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You must specify encryption settings for each file individually.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobOutput`](crate::model::CreateJobOutput)
        pub fn build(self) -> crate::model::CreateJobOutput {
            crate::model::CreateJobOutput {
                key: self.key,
                thumbnail_pattern: self.thumbnail_pattern,
                thumbnail_encryption: self.thumbnail_encryption,
                rotate: self.rotate,
                preset_id: self.preset_id,
                segment_duration: self.segment_duration,
                watermarks: self.watermarks,
                album_art: self.album_art,
                composition: self.composition,
                captions: self.captions,
                encryption: self.encryption,
            }
        }
    }
}
impl CreateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobOutput`](crate::model::CreateJobOutput)
    pub fn builder() -> crate::model::create_job_output::Builder {
        crate::model::create_job_output::Builder::default()
    }
}
