// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>When you update status for a pipeline,
/// Elastic Transcoder returns the values that you specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePipelineStatusOutput {
    /// <p>A section of the response body that provides information about the pipeline.</p>
    pub pipeline: std::option::Option<crate::model::Pipeline>,
}
impl UpdatePipelineStatusOutput {
    /// <p>A section of the response body that provides information about the pipeline.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::Pipeline> {
        self.pipeline.as_ref()
    }
}
impl std::fmt::Debug for UpdatePipelineStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePipelineStatusOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.finish()
    }
}
/// See [`UpdatePipelineStatusOutput`](crate::output::UpdatePipelineStatusOutput)
pub mod update_pipeline_status_output {
    /// A builder for [`UpdatePipelineStatusOutput`](crate::output::UpdatePipelineStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::Pipeline>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the pipeline.</p>
        pub fn pipeline(mut self, input: crate::model::Pipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the pipeline.</p>
        pub fn set_pipeline(mut self, input: std::option::Option<crate::model::Pipeline>) -> Self {
            self.pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePipelineStatusOutput`](crate::output::UpdatePipelineStatusOutput)
        pub fn build(self) -> crate::output::UpdatePipelineStatusOutput {
            crate::output::UpdatePipelineStatusOutput {
                pipeline: self.pipeline,
            }
        }
    }
}
impl UpdatePipelineStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineStatusOutput`](crate::output::UpdatePipelineStatusOutput)
    pub fn builder() -> crate::output::update_pipeline_status_output::Builder {
        crate::output::update_pipeline_status_output::Builder::default()
    }
}

/// <p>The <code>UpdatePipelineNotificationsResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePipelineNotificationsOutput {
    /// <p>A section of the response body that provides information about the pipeline associated
    /// with this notification.</p>
    pub pipeline: std::option::Option<crate::model::Pipeline>,
}
impl UpdatePipelineNotificationsOutput {
    /// <p>A section of the response body that provides information about the pipeline associated
    /// with this notification.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::Pipeline> {
        self.pipeline.as_ref()
    }
}
impl std::fmt::Debug for UpdatePipelineNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePipelineNotificationsOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.finish()
    }
}
/// See [`UpdatePipelineNotificationsOutput`](crate::output::UpdatePipelineNotificationsOutput)
pub mod update_pipeline_notifications_output {
    /// A builder for [`UpdatePipelineNotificationsOutput`](crate::output::UpdatePipelineNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::Pipeline>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the pipeline associated
        /// with this notification.</p>
        pub fn pipeline(mut self, input: crate::model::Pipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the pipeline associated
        /// with this notification.</p>
        pub fn set_pipeline(mut self, input: std::option::Option<crate::model::Pipeline>) -> Self {
            self.pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePipelineNotificationsOutput`](crate::output::UpdatePipelineNotificationsOutput)
        pub fn build(self) -> crate::output::UpdatePipelineNotificationsOutput {
            crate::output::UpdatePipelineNotificationsOutput {
                pipeline: self.pipeline,
            }
        }
    }
}
impl UpdatePipelineNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineNotificationsOutput`](crate::output::UpdatePipelineNotificationsOutput)
    pub fn builder() -> crate::output::update_pipeline_notifications_output::Builder {
        crate::output::update_pipeline_notifications_output::Builder::default()
    }
}

/// <p>When you update a pipeline, Elastic Transcoder returns the values that you specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePipelineOutput {
    /// <p>The pipeline updated by this <code>UpdatePipelineResponse</code> call.</p>
    pub pipeline: std::option::Option<crate::model::Pipeline>,
    /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
    /// pipeline.</p>
    /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
    /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    pub warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
}
impl UpdatePipelineOutput {
    /// <p>The pipeline updated by this <code>UpdatePipelineResponse</code> call.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::Pipeline> {
        self.pipeline.as_ref()
    }
    /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
    /// pipeline.</p>
    /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
    /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    pub fn warnings(&self) -> std::option::Option<&[crate::model::Warning]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for UpdatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePipelineOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
pub mod update_pipeline_output {
    /// A builder for [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::Pipeline>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
    }
    impl Builder {
        /// <p>The pipeline updated by this <code>UpdatePipelineResponse</code> call.</p>
        pub fn pipeline(mut self, input: crate::model::Pipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>The pipeline updated by this <code>UpdatePipelineResponse</code> call.</p>
        pub fn set_pipeline(mut self, input: std::option::Option<crate::model::Pipeline>) -> Self {
            self.pipeline = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
        /// pipeline.</p>
        /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
        /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
        pub fn warnings(mut self, input: impl Into<crate::model::Warning>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
        /// pipeline.</p>
        /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
        /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
        pub fn build(self) -> crate::output::UpdatePipelineOutput {
            crate::output::UpdatePipelineOutput {
                pipeline: self.pipeline,
                warnings: self.warnings,
            }
        }
    }
}
impl UpdatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
    pub fn builder() -> crate::output::update_pipeline_output::Builder {
        crate::output::update_pipeline_output::Builder::default()
    }
}

/// <p>The <code>TestRoleResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestRoleOutput {
    /// <p>If the operation is successful, this value is <code>true</code>; otherwise, the value is
    /// <code>false</code>.</p>
    pub success: std::option::Option<std::string::String>,
    /// <p>If the <code>Success</code> element contains <code>false</code>, this value is an array
    /// of one or more error messages that were generated during the test process.</p>
    pub messages: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TestRoleOutput {
    /// <p>If the operation is successful, this value is <code>true</code>; otherwise, the value is
    /// <code>false</code>.</p>
    pub fn success(&self) -> std::option::Option<&str> {
        self.success.as_deref()
    }
    /// <p>If the <code>Success</code> element contains <code>false</code>, this value is an array
    /// of one or more error messages that were generated during the test process.</p>
    pub fn messages(&self) -> std::option::Option<&[std::string::String]> {
        self.messages.as_deref()
    }
}
impl std::fmt::Debug for TestRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestRoleOutput");
        formatter.field("success", &self.success);
        formatter.field("messages", &self.messages);
        formatter.finish()
    }
}
/// See [`TestRoleOutput`](crate::output::TestRoleOutput)
pub mod test_role_output {
    /// A builder for [`TestRoleOutput`](crate::output::TestRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) success: std::option::Option<std::string::String>,
        pub(crate) messages: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>If the operation is successful, this value is <code>true</code>; otherwise, the value is
        /// <code>false</code>.</p>
        pub fn success(mut self, input: impl Into<std::string::String>) -> Self {
            self.success = Some(input.into());
            self
        }
        /// <p>If the operation is successful, this value is <code>true</code>; otherwise, the value is
        /// <code>false</code>.</p>
        pub fn set_success(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.success = input;
            self
        }
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>If the <code>Success</code> element contains <code>false</code>, this value is an array
        /// of one or more error messages that were generated during the test process.</p>
        pub fn messages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p>If the <code>Success</code> element contains <code>false</code>, this value is an array
        /// of one or more error messages that were generated during the test process.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// Consumes the builder and constructs a [`TestRoleOutput`](crate::output::TestRoleOutput)
        pub fn build(self) -> crate::output::TestRoleOutput {
            crate::output::TestRoleOutput {
                success: self.success,
                messages: self.messages,
            }
        }
    }
}
impl TestRoleOutput {
    /// Creates a new builder-style object to manufacture [`TestRoleOutput`](crate::output::TestRoleOutput)
    pub fn builder() -> crate::output::test_role_output::Builder {
        crate::output::test_role_output::Builder::default()
    }
}

/// <p>The <code>ReadPresetResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReadPresetOutput {
    /// <p>A section of the response body that provides information about the preset.</p>
    pub preset: std::option::Option<crate::model::Preset>,
}
impl ReadPresetOutput {
    /// <p>A section of the response body that provides information about the preset.</p>
    pub fn preset(&self) -> std::option::Option<&crate::model::Preset> {
        self.preset.as_ref()
    }
}
impl std::fmt::Debug for ReadPresetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReadPresetOutput");
        formatter.field("preset", &self.preset);
        formatter.finish()
    }
}
/// See [`ReadPresetOutput`](crate::output::ReadPresetOutput)
pub mod read_preset_output {
    /// A builder for [`ReadPresetOutput`](crate::output::ReadPresetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preset: std::option::Option<crate::model::Preset>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the preset.</p>
        pub fn preset(mut self, input: crate::model::Preset) -> Self {
            self.preset = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the preset.</p>
        pub fn set_preset(mut self, input: std::option::Option<crate::model::Preset>) -> Self {
            self.preset = input;
            self
        }
        /// Consumes the builder and constructs a [`ReadPresetOutput`](crate::output::ReadPresetOutput)
        pub fn build(self) -> crate::output::ReadPresetOutput {
            crate::output::ReadPresetOutput {
                preset: self.preset,
            }
        }
    }
}
impl ReadPresetOutput {
    /// Creates a new builder-style object to manufacture [`ReadPresetOutput`](crate::output::ReadPresetOutput)
    pub fn builder() -> crate::output::read_preset_output::Builder {
        crate::output::read_preset_output::Builder::default()
    }
}

/// <p>The <code>ReadPipelineResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReadPipelineOutput {
    /// <p>A section of the response body that provides information about the pipeline.</p>
    pub pipeline: std::option::Option<crate::model::Pipeline>,
    /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
    /// as the pipeline.</p>
    /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
    /// and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    pub warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
}
impl ReadPipelineOutput {
    /// <p>A section of the response body that provides information about the pipeline.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::Pipeline> {
        self.pipeline.as_ref()
    }
    /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
    /// as the pipeline.</p>
    /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
    /// and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    pub fn warnings(&self) -> std::option::Option<&[crate::model::Warning]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for ReadPipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReadPipelineOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`ReadPipelineOutput`](crate::output::ReadPipelineOutput)
pub mod read_pipeline_output {
    /// A builder for [`ReadPipelineOutput`](crate::output::ReadPipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::Pipeline>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the pipeline.</p>
        pub fn pipeline(mut self, input: crate::model::Pipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the pipeline.</p>
        pub fn set_pipeline(mut self, input: std::option::Option<crate::model::Pipeline>) -> Self {
            self.pipeline = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
        /// as the pipeline.</p>
        /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
        /// and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
        pub fn warnings(mut self, input: impl Into<crate::model::Warning>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
        /// as the pipeline.</p>
        /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
        /// and AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ReadPipelineOutput`](crate::output::ReadPipelineOutput)
        pub fn build(self) -> crate::output::ReadPipelineOutput {
            crate::output::ReadPipelineOutput {
                pipeline: self.pipeline,
                warnings: self.warnings,
            }
        }
    }
}
impl ReadPipelineOutput {
    /// Creates a new builder-style object to manufacture [`ReadPipelineOutput`](crate::output::ReadPipelineOutput)
    pub fn builder() -> crate::output::read_pipeline_output::Builder {
        crate::output::read_pipeline_output::Builder::default()
    }
}

/// <p>The <code>ReadJobResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReadJobOutput {
    /// <p>A section of the response body that provides information about the job.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl ReadJobOutput {
    /// <p>A section of the response body that provides information about the job.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for ReadJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReadJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`ReadJobOutput`](crate::output::ReadJobOutput)
pub mod read_job_output {
    /// A builder for [`ReadJobOutput`](crate::output::ReadJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the job.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the job.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`ReadJobOutput`](crate::output::ReadJobOutput)
        pub fn build(self) -> crate::output::ReadJobOutput {
            crate::output::ReadJobOutput { job: self.job }
        }
    }
}
impl ReadJobOutput {
    /// Creates a new builder-style object to manufacture [`ReadJobOutput`](crate::output::ReadJobOutput)
    pub fn builder() -> crate::output::read_job_output::Builder {
        crate::output::read_job_output::Builder::default()
    }
}

/// <p>The <code>ListPresetsResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPresetsOutput {
    /// <p>An array of <code>Preset</code> objects.</p>
    pub presets: std::option::Option<std::vec::Vec<crate::model::Preset>>,
    /// <p>A value that you use to access the second and subsequent pages of results, if any. When
    /// the presets fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl ListPresetsOutput {
    /// <p>An array of <code>Preset</code> objects.</p>
    pub fn presets(&self) -> std::option::Option<&[crate::model::Preset]> {
        self.presets.as_deref()
    }
    /// <p>A value that you use to access the second and subsequent pages of results, if any. When
    /// the presets fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for ListPresetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPresetsOutput");
        formatter.field("presets", &self.presets);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListPresetsOutput`](crate::output::ListPresetsOutput)
pub mod list_presets_output {
    /// A builder for [`ListPresetsOutput`](crate::output::ListPresetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) presets: std::option::Option<std::vec::Vec<crate::model::Preset>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `presets`.
        ///
        /// To override the contents of this collection use [`set_presets`](Self::set_presets).
        ///
        /// <p>An array of <code>Preset</code> objects.</p>
        pub fn presets(mut self, input: impl Into<crate::model::Preset>) -> Self {
            let mut v = self.presets.unwrap_or_default();
            v.push(input.into());
            self.presets = Some(v);
            self
        }
        /// <p>An array of <code>Preset</code> objects.</p>
        pub fn set_presets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Preset>>,
        ) -> Self {
            self.presets = input;
            self
        }
        /// <p>A value that you use to access the second and subsequent pages of results, if any. When
        /// the presets fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>A value that you use to access the second and subsequent pages of results, if any. When
        /// the presets fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPresetsOutput`](crate::output::ListPresetsOutput)
        pub fn build(self) -> crate::output::ListPresetsOutput {
            crate::output::ListPresetsOutput {
                presets: self.presets,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListPresetsOutput {
    /// Creates a new builder-style object to manufacture [`ListPresetsOutput`](crate::output::ListPresetsOutput)
    pub fn builder() -> crate::output::list_presets_output::Builder {
        crate::output::list_presets_output::Builder::default()
    }
}

/// <p>A list of the pipelines associated with the current AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelinesOutput {
    /// <p>An array of <code>Pipeline</code> objects.</p>
    pub pipelines: std::option::Option<std::vec::Vec<crate::model::Pipeline>>,
    /// <p>A value that you use to access the second and subsequent pages of results, if any. When
    /// the pipelines fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl ListPipelinesOutput {
    /// <p>An array of <code>Pipeline</code> objects.</p>
    pub fn pipelines(&self) -> std::option::Option<&[crate::model::Pipeline]> {
        self.pipelines.as_deref()
    }
    /// <p>A value that you use to access the second and subsequent pages of results, if any. When
    /// the pipelines fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelinesOutput");
        formatter.field("pipelines", &self.pipelines);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
pub mod list_pipelines_output {
    /// A builder for [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipelines: std::option::Option<std::vec::Vec<crate::model::Pipeline>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pipelines`.
        ///
        /// To override the contents of this collection use [`set_pipelines`](Self::set_pipelines).
        ///
        /// <p>An array of <code>Pipeline</code> objects.</p>
        pub fn pipelines(mut self, input: impl Into<crate::model::Pipeline>) -> Self {
            let mut v = self.pipelines.unwrap_or_default();
            v.push(input.into());
            self.pipelines = Some(v);
            self
        }
        /// <p>An array of <code>Pipeline</code> objects.</p>
        pub fn set_pipelines(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Pipeline>>,
        ) -> Self {
            self.pipelines = input;
            self
        }
        /// <p>A value that you use to access the second and subsequent pages of results, if any. When
        /// the pipelines fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>A value that you use to access the second and subsequent pages of results, if any. When
        /// the pipelines fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
        pub fn build(self) -> crate::output::ListPipelinesOutput {
            crate::output::ListPipelinesOutput {
                pipelines: self.pipelines,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListPipelinesOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    pub fn builder() -> crate::output::list_pipelines_output::Builder {
        crate::output::list_pipelines_output::Builder::default()
    }
}

/// <p>
/// The <code>ListJobsByStatusResponse</code> structure.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsByStatusOutput {
    /// <p>An array of <code>Job</code> objects that have the specified status.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p> A value that you use to access the second and subsequent pages of results, if any. When
    /// the jobs in the specified pipeline fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl ListJobsByStatusOutput {
    /// <p>An array of <code>Job</code> objects that have the specified status.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::Job]> {
        self.jobs.as_deref()
    }
    /// <p> A value that you use to access the second and subsequent pages of results, if any. When
    /// the jobs in the specified pipeline fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsByStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsByStatusOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListJobsByStatusOutput`](crate::output::ListJobsByStatusOutput)
pub mod list_jobs_by_status_output {
    /// A builder for [`ListJobsByStatusOutput`](crate::output::ListJobsByStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>An array of <code>Job</code> objects that have the specified status.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>An array of <code>Job</code> objects that have the specified status.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p> A value that you use to access the second and subsequent pages of results, if any. When
        /// the jobs in the specified pipeline fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p> A value that you use to access the second and subsequent pages of results, if any. When
        /// the jobs in the specified pipeline fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsByStatusOutput`](crate::output::ListJobsByStatusOutput)
        pub fn build(self) -> crate::output::ListJobsByStatusOutput {
            crate::output::ListJobsByStatusOutput {
                jobs: self.jobs,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListJobsByStatusOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsByStatusOutput`](crate::output::ListJobsByStatusOutput)
    pub fn builder() -> crate::output::list_jobs_by_status_output::Builder {
        crate::output::list_jobs_by_status_output::Builder::default()
    }
}

/// <p>The <code>ListJobsByPipelineResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsByPipelineOutput {
    /// <p>An array of <code>Job</code> objects that are in the specified pipeline.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p> A value that you use to access the second and subsequent pages of results, if any. When
    /// the jobs in the specified pipeline fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl ListJobsByPipelineOutput {
    /// <p>An array of <code>Job</code> objects that are in the specified pipeline.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::Job]> {
        self.jobs.as_deref()
    }
    /// <p> A value that you use to access the second and subsequent pages of results, if any. When
    /// the jobs in the specified pipeline fit on one page or when you've reached the last page
    /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsByPipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsByPipelineOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListJobsByPipelineOutput`](crate::output::ListJobsByPipelineOutput)
pub mod list_jobs_by_pipeline_output {
    /// A builder for [`ListJobsByPipelineOutput`](crate::output::ListJobsByPipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>An array of <code>Job</code> objects that are in the specified pipeline.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>An array of <code>Job</code> objects that are in the specified pipeline.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p> A value that you use to access the second and subsequent pages of results, if any. When
        /// the jobs in the specified pipeline fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p> A value that you use to access the second and subsequent pages of results, if any. When
        /// the jobs in the specified pipeline fit on one page or when you've reached the last page
        /// of results, the value of <code>NextPageToken</code> is <code>null</code>. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsByPipelineOutput`](crate::output::ListJobsByPipelineOutput)
        pub fn build(self) -> crate::output::ListJobsByPipelineOutput {
            crate::output::ListJobsByPipelineOutput {
                jobs: self.jobs,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListJobsByPipelineOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsByPipelineOutput`](crate::output::ListJobsByPipelineOutput)
    pub fn builder() -> crate::output::list_jobs_by_pipeline_output::Builder {
        crate::output::list_jobs_by_pipeline_output::Builder::default()
    }
}

/// <p>The <code>DeletePresetResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePresetOutput {}
impl std::fmt::Debug for DeletePresetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePresetOutput");
        formatter.finish()
    }
}
/// See [`DeletePresetOutput`](crate::output::DeletePresetOutput)
pub mod delete_preset_output {
    /// A builder for [`DeletePresetOutput`](crate::output::DeletePresetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePresetOutput`](crate::output::DeletePresetOutput)
        pub fn build(self) -> crate::output::DeletePresetOutput {
            crate::output::DeletePresetOutput {}
        }
    }
}
impl DeletePresetOutput {
    /// Creates a new builder-style object to manufacture [`DeletePresetOutput`](crate::output::DeletePresetOutput)
    pub fn builder() -> crate::output::delete_preset_output::Builder {
        crate::output::delete_preset_output::Builder::default()
    }
}

/// <p>The <code>DeletePipelineResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePipelineOutput {}
impl std::fmt::Debug for DeletePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePipelineOutput");
        formatter.finish()
    }
}
/// See [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
pub mod delete_pipeline_output {
    /// A builder for [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
        pub fn build(self) -> crate::output::DeletePipelineOutput {
            crate::output::DeletePipelineOutput {}
        }
    }
}
impl DeletePipelineOutput {
    /// Creates a new builder-style object to manufacture [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
    pub fn builder() -> crate::output::delete_pipeline_output::Builder {
        crate::output::delete_pipeline_output::Builder::default()
    }
}

/// <p>The <code>CreatePresetResponse</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePresetOutput {
    /// <p>A section of the response body that provides information about the preset that is created.</p>
    pub preset: std::option::Option<crate::model::Preset>,
    /// <p>If the preset settings don't comply with the standards for the video codec but Elastic Transcoder
    /// created the preset, this message explains the reason the preset settings don't meet the
    /// standard. Elastic Transcoder created the preset because the settings might produce
    /// acceptable output.</p>
    pub warning: std::option::Option<std::string::String>,
}
impl CreatePresetOutput {
    /// <p>A section of the response body that provides information about the preset that is created.</p>
    pub fn preset(&self) -> std::option::Option<&crate::model::Preset> {
        self.preset.as_ref()
    }
    /// <p>If the preset settings don't comply with the standards for the video codec but Elastic Transcoder
    /// created the preset, this message explains the reason the preset settings don't meet the
    /// standard. Elastic Transcoder created the preset because the settings might produce
    /// acceptable output.</p>
    pub fn warning(&self) -> std::option::Option<&str> {
        self.warning.as_deref()
    }
}
impl std::fmt::Debug for CreatePresetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePresetOutput");
        formatter.field("preset", &self.preset);
        formatter.field("warning", &self.warning);
        formatter.finish()
    }
}
/// See [`CreatePresetOutput`](crate::output::CreatePresetOutput)
pub mod create_preset_output {
    /// A builder for [`CreatePresetOutput`](crate::output::CreatePresetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preset: std::option::Option<crate::model::Preset>,
        pub(crate) warning: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the preset that is created.</p>
        pub fn preset(mut self, input: crate::model::Preset) -> Self {
            self.preset = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the preset that is created.</p>
        pub fn set_preset(mut self, input: std::option::Option<crate::model::Preset>) -> Self {
            self.preset = input;
            self
        }
        /// <p>If the preset settings don't comply with the standards for the video codec but Elastic Transcoder
        /// created the preset, this message explains the reason the preset settings don't meet the
        /// standard. Elastic Transcoder created the preset because the settings might produce
        /// acceptable output.</p>
        pub fn warning(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning = Some(input.into());
            self
        }
        /// <p>If the preset settings don't comply with the standards for the video codec but Elastic Transcoder
        /// created the preset, this message explains the reason the preset settings don't meet the
        /// standard. Elastic Transcoder created the preset because the settings might produce
        /// acceptable output.</p>
        pub fn set_warning(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warning = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePresetOutput`](crate::output::CreatePresetOutput)
        pub fn build(self) -> crate::output::CreatePresetOutput {
            crate::output::CreatePresetOutput {
                preset: self.preset,
                warning: self.warning,
            }
        }
    }
}
impl CreatePresetOutput {
    /// Creates a new builder-style object to manufacture [`CreatePresetOutput`](crate::output::CreatePresetOutput)
    pub fn builder() -> crate::output::create_preset_output::Builder {
        crate::output::create_preset_output::Builder::default()
    }
}

/// <p>When you create a pipeline, Elastic Transcoder returns the values that you specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePipelineOutput {
    /// <p>A section of the response body that provides information about the pipeline that is created.</p>
    pub pipeline: std::option::Option<crate::model::Pipeline>,
    /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as
    /// the pipeline.</p>
    /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
    /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    pub warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
}
impl CreatePipelineOutput {
    /// <p>A section of the response body that provides information about the pipeline that is created.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::Pipeline> {
        self.pipeline.as_ref()
    }
    /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as
    /// the pipeline.</p>
    /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
    /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
    pub fn warnings(&self) -> std::option::Option<&[crate::model::Warning]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for CreatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePipelineOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
pub mod create_pipeline_output {
    /// A builder for [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::Pipeline>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<crate::model::Warning>>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the pipeline that is created.</p>
        pub fn pipeline(mut self, input: crate::model::Pipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the pipeline that is created.</p>
        pub fn set_pipeline(mut self, input: std::option::Option<crate::model::Pipeline>) -> Self {
            self.pipeline = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as
        /// the pipeline.</p>
        /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
        /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
        pub fn warnings(mut self, input: impl Into<crate::model::Warning>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as
        /// the pipeline.</p>
        /// <p>Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
        /// AWS KMS key, reduces processing time and prevents cross-regional charges.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Warning>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
        pub fn build(self) -> crate::output::CreatePipelineOutput {
            crate::output::CreatePipelineOutput {
                pipeline: self.pipeline,
                warnings: self.warnings,
            }
        }
    }
}
impl CreatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
    pub fn builder() -> crate::output::create_pipeline_output::Builder {
        crate::output::create_pipeline_output::Builder::default()
    }
}

/// <p>The CreateJobResponse structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobOutput {
    /// <p>A section of the response body that provides information about the job that is created.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl CreateJobOutput {
    /// <p>A section of the response body that provides information about the job that is created.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for CreateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`CreateJobOutput`](crate::output::CreateJobOutput)
pub mod create_job_output {
    /// A builder for [`CreateJobOutput`](crate::output::CreateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>A section of the response body that provides information about the job that is created.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>A section of the response body that provides information about the job that is created.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobOutput`](crate::output::CreateJobOutput)
        pub fn build(self) -> crate::output::CreateJobOutput {
            crate::output::CreateJobOutput { job: self.job }
        }
    }
}
impl CreateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobOutput`](crate::output::CreateJobOutput)
    pub fn builder() -> crate::output::create_job_output::Builder {
        crate::output::create_job_output::Builder::default()
    }
}

/// <p>The response body contains a JSON object. If the job is successfully canceled, the value
/// of <code>Success</code> is <code>true</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobOutput {}
impl std::fmt::Debug for CancelJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobOutput");
        formatter.finish()
    }
}
/// See [`CancelJobOutput`](crate::output::CancelJobOutput)
pub mod cancel_job_output {
    /// A builder for [`CancelJobOutput`](crate::output::CancelJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelJobOutput`](crate::output::CancelJobOutput)
        pub fn build(self) -> crate::output::CancelJobOutput {
            crate::output::CancelJobOutput {}
        }
    }
}
impl CancelJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelJobOutput`](crate::output::CancelJobOutput)
    pub fn builder() -> crate::output::cancel_job_output::Builder {
        crate::output::cancel_job_output::Builder::default()
    }
}
