// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_job`](crate::client::Client::cancel_job).
///
/// See [`crate::client::fluent_builders::CancelJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelJob {
    _private: (),
}
impl CancelJob {
    /// Creates a new builder-style object to manufacture [`CancelJobInput`](crate::input::CancelJobInput)
    pub fn builder() -> crate::input::cancel_job_input::Builder {
        crate::input::cancel_job_input::Builder::default()
    }
    /// Creates a new `CancelJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelJob {
    type Output = std::result::Result<crate::output::CancelJobOutput, crate::error::CancelJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_cancel_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_job_response(response)
        }
    }
}

/// Operation shape for `CreateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job`](crate::client::Client::create_job).
///
/// See [`crate::client::fluent_builders::CreateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJob {
    _private: (),
}
impl CreateJob {
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
    /// Creates a new `CreateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJob {
    type Output = std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_job_error(response)
        } else {
            crate::operation_deser::parse_create_job_response(response)
        }
    }
}

/// Operation shape for `CreatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pipeline`](crate::client::Client::create_pipeline).
///
/// See [`crate::client::fluent_builders::CreatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePipeline {
    _private: (),
}
impl CreatePipeline {
    /// Creates a new builder-style object to manufacture [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    pub fn builder() -> crate::input::create_pipeline_input::Builder {
        crate::input::create_pipeline_input::Builder::default()
    }
    /// Creates a new `CreatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePipeline {
    type Output =
        std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_pipeline_error(response)
        } else {
            crate::operation_deser::parse_create_pipeline_response(response)
        }
    }
}

/// Operation shape for `CreatePreset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_preset`](crate::client::Client::create_preset).
///
/// See [`crate::client::fluent_builders::CreatePreset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePreset {
    _private: (),
}
impl CreatePreset {
    /// Creates a new builder-style object to manufacture [`CreatePresetInput`](crate::input::CreatePresetInput)
    pub fn builder() -> crate::input::create_preset_input::Builder {
        crate::input::create_preset_input::Builder::default()
    }
    /// Creates a new `CreatePreset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePreset {
    type Output =
        std::result::Result<crate::output::CreatePresetOutput, crate::error::CreatePresetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_preset_error(response)
        } else {
            crate::operation_deser::parse_create_preset_response(response)
        }
    }
}

/// Operation shape for `DeletePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pipeline`](crate::client::Client::delete_pipeline).
///
/// See [`crate::client::fluent_builders::DeletePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePipeline {
    _private: (),
}
impl DeletePipeline {
    /// Creates a new builder-style object to manufacture [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    pub fn builder() -> crate::input::delete_pipeline_input::Builder {
        crate::input::delete_pipeline_input::Builder::default()
    }
    /// Creates a new `DeletePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePipeline {
    type Output =
        std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_pipeline_error(response)
        } else {
            crate::operation_deser::parse_delete_pipeline_response(response)
        }
    }
}

/// Operation shape for `DeletePreset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_preset`](crate::client::Client::delete_preset).
///
/// See [`crate::client::fluent_builders::DeletePreset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePreset {
    _private: (),
}
impl DeletePreset {
    /// Creates a new builder-style object to manufacture [`DeletePresetInput`](crate::input::DeletePresetInput)
    pub fn builder() -> crate::input::delete_preset_input::Builder {
        crate::input::delete_preset_input::Builder::default()
    }
    /// Creates a new `DeletePreset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePreset {
    type Output =
        std::result::Result<crate::output::DeletePresetOutput, crate::error::DeletePresetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_preset_error(response)
        } else {
            crate::operation_deser::parse_delete_preset_response(response)
        }
    }
}

/// Operation shape for `ListJobsByPipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs_by_pipeline`](crate::client::Client::list_jobs_by_pipeline).
///
/// See [`crate::client::fluent_builders::ListJobsByPipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobsByPipeline {
    _private: (),
}
impl ListJobsByPipeline {
    /// Creates a new builder-style object to manufacture [`ListJobsByPipelineInput`](crate::input::ListJobsByPipelineInput)
    pub fn builder() -> crate::input::list_jobs_by_pipeline_input::Builder {
        crate::input::list_jobs_by_pipeline_input::Builder::default()
    }
    /// Creates a new `ListJobsByPipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobsByPipeline {
    type Output = std::result::Result<
        crate::output::ListJobsByPipelineOutput,
        crate::error::ListJobsByPipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_by_pipeline_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_by_pipeline_response(response)
        }
    }
}

/// Operation shape for `ListJobsByStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs_by_status`](crate::client::Client::list_jobs_by_status).
///
/// See [`crate::client::fluent_builders::ListJobsByStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobsByStatus {
    _private: (),
}
impl ListJobsByStatus {
    /// Creates a new builder-style object to manufacture [`ListJobsByStatusInput`](crate::input::ListJobsByStatusInput)
    pub fn builder() -> crate::input::list_jobs_by_status_input::Builder {
        crate::input::list_jobs_by_status_input::Builder::default()
    }
    /// Creates a new `ListJobsByStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobsByStatus {
    type Output = std::result::Result<
        crate::output::ListJobsByStatusOutput,
        crate::error::ListJobsByStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_by_status_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_by_status_response(response)
        }
    }
}

/// Operation shape for `ListPipelines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipelines`](crate::client::Client::list_pipelines).
///
/// See [`crate::client::fluent_builders::ListPipelines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelines {
    _private: (),
}
impl ListPipelines {
    /// Creates a new builder-style object to manufacture [`ListPipelinesInput`](crate::input::ListPipelinesInput)
    pub fn builder() -> crate::input::list_pipelines_input::Builder {
        crate::input::list_pipelines_input::Builder::default()
    }
    /// Creates a new `ListPipelines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelines {
    type Output =
        std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipelines_error(response)
        } else {
            crate::operation_deser::parse_list_pipelines_response(response)
        }
    }
}

/// Operation shape for `ListPresets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_presets`](crate::client::Client::list_presets).
///
/// See [`crate::client::fluent_builders::ListPresets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPresets {
    _private: (),
}
impl ListPresets {
    /// Creates a new builder-style object to manufacture [`ListPresetsInput`](crate::input::ListPresetsInput)
    pub fn builder() -> crate::input::list_presets_input::Builder {
        crate::input::list_presets_input::Builder::default()
    }
    /// Creates a new `ListPresets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPresets {
    type Output =
        std::result::Result<crate::output::ListPresetsOutput, crate::error::ListPresetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_presets_error(response)
        } else {
            crate::operation_deser::parse_list_presets_response(response)
        }
    }
}

/// Operation shape for `ReadJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`read_job`](crate::client::Client::read_job).
///
/// See [`crate::client::fluent_builders::ReadJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReadJob {
    _private: (),
}
impl ReadJob {
    /// Creates a new builder-style object to manufacture [`ReadJobInput`](crate::input::ReadJobInput)
    pub fn builder() -> crate::input::read_job_input::Builder {
        crate::input::read_job_input::Builder::default()
    }
    /// Creates a new `ReadJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReadJob {
    type Output = std::result::Result<crate::output::ReadJobOutput, crate::error::ReadJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_read_job_error(response)
        } else {
            crate::operation_deser::parse_read_job_response(response)
        }
    }
}

/// Operation shape for `ReadPipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`read_pipeline`](crate::client::Client::read_pipeline).
///
/// See [`crate::client::fluent_builders::ReadPipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReadPipeline {
    _private: (),
}
impl ReadPipeline {
    /// Creates a new builder-style object to manufacture [`ReadPipelineInput`](crate::input::ReadPipelineInput)
    pub fn builder() -> crate::input::read_pipeline_input::Builder {
        crate::input::read_pipeline_input::Builder::default()
    }
    /// Creates a new `ReadPipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReadPipeline {
    type Output =
        std::result::Result<crate::output::ReadPipelineOutput, crate::error::ReadPipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_read_pipeline_error(response)
        } else {
            crate::operation_deser::parse_read_pipeline_response(response)
        }
    }
}

/// Operation shape for `ReadPreset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`read_preset`](crate::client::Client::read_preset).
///
/// See [`crate::client::fluent_builders::ReadPreset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReadPreset {
    _private: (),
}
impl ReadPreset {
    /// Creates a new builder-style object to manufacture [`ReadPresetInput`](crate::input::ReadPresetInput)
    pub fn builder() -> crate::input::read_preset_input::Builder {
        crate::input::read_preset_input::Builder::default()
    }
    /// Creates a new `ReadPreset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReadPreset {
    type Output =
        std::result::Result<crate::output::ReadPresetOutput, crate::error::ReadPresetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_read_preset_error(response)
        } else {
            crate::operation_deser::parse_read_preset_response(response)
        }
    }
}

/// Operation shape for `TestRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_role`](crate::client::Client::test_role).
///
/// See [`crate::client::fluent_builders::TestRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestRole {
    _private: (),
}
impl TestRole {
    /// Creates a new builder-style object to manufacture [`TestRoleInput`](crate::input::TestRoleInput)
    pub fn builder() -> crate::input::test_role_input::Builder {
        crate::input::test_role_input::Builder::default()
    }
    /// Creates a new `TestRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestRole {
    type Output = std::result::Result<crate::output::TestRoleOutput, crate::error::TestRoleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_role_error(response)
        } else {
            crate::operation_deser::parse_test_role_response(response)
        }
    }
}

/// Operation shape for `UpdatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pipeline`](crate::client::Client::update_pipeline).
///
/// See [`crate::client::fluent_builders::UpdatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePipeline {
    _private: (),
}
impl UpdatePipeline {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
    pub fn builder() -> crate::input::update_pipeline_input::Builder {
        crate::input::update_pipeline_input::Builder::default()
    }
    /// Creates a new `UpdatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePipeline {
    type Output =
        std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pipeline_error(response)
        } else {
            crate::operation_deser::parse_update_pipeline_response(response)
        }
    }
}

/// Operation shape for `UpdatePipelineNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pipeline_notifications`](crate::client::Client::update_pipeline_notifications).
///
/// See [`crate::client::fluent_builders::UpdatePipelineNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePipelineNotifications {
    _private: (),
}
impl UpdatePipelineNotifications {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineNotificationsInput`](crate::input::UpdatePipelineNotificationsInput)
    pub fn builder() -> crate::input::update_pipeline_notifications_input::Builder {
        crate::input::update_pipeline_notifications_input::Builder::default()
    }
    /// Creates a new `UpdatePipelineNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePipelineNotifications {
    type Output = std::result::Result<
        crate::output::UpdatePipelineNotificationsOutput,
        crate::error::UpdatePipelineNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pipeline_notifications_error(response)
        } else {
            crate::operation_deser::parse_update_pipeline_notifications_response(response)
        }
    }
}

/// Operation shape for `UpdatePipelineStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pipeline_status`](crate::client::Client::update_pipeline_status).
///
/// See [`crate::client::fluent_builders::UpdatePipelineStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePipelineStatus {
    _private: (),
}
impl UpdatePipelineStatus {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineStatusInput`](crate::input::UpdatePipelineStatusInput)
    pub fn builder() -> crate::input::update_pipeline_status_input::Builder {
        crate::input::update_pipeline_status_input::Builder::default()
    }
    /// Creates a new `UpdatePipelineStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePipelineStatus {
    type Output = std::result::Result<
        crate::output::UpdatePipelineStatusOutput,
        crate::error::UpdatePipelineStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pipeline_status_error(response)
        } else {
            crate::operation_deser::parse_update_pipeline_status_response(response)
        }
    }
}
